"use strict";
/*
 * credentials.ts
 *
 * Copyright (C) 2025 by Posit Software, PBC
 *
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagedCredentialsInput = void 0;
/**
 * Encapsulates operations on the "managed credentials" section of the UI.
 */
class ManagedCredentialsInput {
    constructor(callback) {
        this.callback = callback;
        this.userModified = false;
        this.managedCredsSection = document.getElementById('managed-credentials');
        this.managedCredsCheckbox = document.getElementById('managed-credentials-enabled');
        this.managedCredsCheckbox.addEventListener('click', () => {
            this.userModified = true;
            this.callback(this.checked);
        });
    }
    enable(value) {
        if (value) {
            this.managedCredsSection.classList.remove('hidden');
        }
        else {
            this.managedCredsSection.classList.add('hidden');
        }
        if (!this.userModified) {
            this.managedCredsCheckbox.checked = value;
        }
        this.callback(this.checked);
    }
    get checked() {
        return this.managedCredsSection.style.display !== 'none' && this.managedCredsCheckbox.checked;
    }
}
exports.ManagedCredentialsInput = ManagedCredentialsInput;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3JlZGVudGlhbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvY3JlZGVudGlhbHMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7OztHQUtHOzs7QUFFSDs7R0FFRztBQUNILE1BQWEsdUJBQXVCO0lBS2xDLFlBQW9CLFFBQW9DO1FBQXBDLGFBQVEsR0FBUixRQUFRLENBQTRCO1FBSmpELGlCQUFZLEdBQUcsS0FBSyxDQUFDO1FBQ3BCLHdCQUFtQixHQUFHLFFBQVEsQ0FBQyxjQUFjLENBQUMscUJBQXFCLENBQUUsQ0FBQztRQUN0RSx5QkFBb0IsR0FBRyxRQUFRLENBQUMsY0FBYyxDQUFDLDZCQUE2QixDQUFzQixDQUFDO1FBR3pHLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLEVBQUUsR0FBRyxFQUFFO1lBQ3ZELElBQUksQ0FBQyxZQUFZLEdBQUcsSUFBSSxDQUFDO1lBQ3pCLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxDQUFDO1FBQzlCLENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVNLE1BQU0sQ0FBQyxLQUFjO1FBQzFCLElBQUksS0FBSyxFQUFFLENBQUM7WUFDVixJQUFJLENBQUMsbUJBQW1CLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUN0RCxDQUFDO2FBQU0sQ0FBQztZQUNOLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxTQUFTLENBQUMsR0FBRyxDQUFDLFFBQVEsQ0FBQyxDQUFDO1FBQ25ELENBQUM7UUFDRCxJQUFJLENBQUMsSUFBSSxDQUFDLFlBQVksRUFBRSxDQUFDO1lBQ3ZCLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO1FBQzVDLENBQUM7UUFDRCxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUM5QixDQUFDO0lBRUQsSUFBWSxPQUFPO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxPQUFPLEtBQUssTUFBTSxJQUFJLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxPQUFPLENBQUM7SUFDaEcsQ0FBQztDQUNGO0FBM0JELDBEQTJCQyJ9