/*!--------------------------------------------------------
 * Copyright (C) Microsoft Corporation. All rights reserved.
 *--------------------------------------------------------*//******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */

var extendStatics = function(d, b) {
    extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
    return extendStatics(d, b);
};

export function __extends(d, b) {
    if (typeof b !== "function" && b !== null)
        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
    extendStatics(d, b);
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
}

export var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    }
    return __assign.apply(this, arguments);
}

export function __rest(s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
}

export function __decorate(decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
}

export function __param(paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
}

export function __esDecorate(ctor, descriptorIn, decorators, contextIn, initializers, extraInitializers) {
    function accept(f) { if (f !== void 0 && typeof f !== "function") throw new TypeError("Function expected"); return f; }
    var kind = contextIn.kind, key = kind === "getter" ? "get" : kind === "setter" ? "set" : "value";
    var target = !descriptorIn && ctor ? contextIn["static"] ? ctor : ctor.prototype : null;
    var descriptor = descriptorIn || (target ? Object.getOwnPropertyDescriptor(target, contextIn.name) : {});
    var _, done = false;
    for (var i = decorators.length - 1; i >= 0; i--) {
        var context = {};
        for (var p in contextIn) context[p] = p === "access" ? {} : contextIn[p];
        for (var p in contextIn.access) context.access[p] = contextIn.access[p];
        context.addInitializer = function (f) { if (done) throw new TypeError("Cannot add initializers after decoration has completed"); extraInitializers.push(accept(f || null)); };
        var result = (0, decorators[i])(kind === "accessor" ? { get: descriptor.get, set: descriptor.set } : descriptor[key], context);
        if (kind === "accessor") {
            if (result === void 0) continue;
            if (result === null || typeof result !== "object") throw new TypeError("Object expected");
            if (_ = accept(result.get)) descriptor.get = _;
            if (_ = accept(result.set)) descriptor.set = _;
            if (_ = accept(result.init)) initializers.unshift(_);
        }
        else if (_ = accept(result)) {
            if (kind === "field") initializers.unshift(_);
            else descriptor[key] = _;
        }
    }
    if (target) Object.defineProperty(target, contextIn.name, descriptor);
    done = true;
};

export function __runInitializers(thisArg, initializers, value) {
    var useValue = arguments.length > 2;
    for (var i = 0; i < initializers.length; i++) {
        value = useValue ? initializers[i].call(thisArg, value) : initializers[i].call(thisArg);
    }
    return useValue ? value : void 0;
};

export function __propKey(x) {
    return typeof x === "symbol" ? x : "".concat(x);
};

export function __setFunctionName(f, name, prefix) {
    if (typeof name === "symbol") name = name.description ? "[".concat(name.description, "]") : "";
    return Object.defineProperty(f, "name", { configurable: true, value: prefix ? "".concat(prefix, " ", name) : name });
};

export function __metadata(metadataKey, metadataValue) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(metadataKey, metadataValue);
}

export function __awaiter(thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

export function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

export var __createBinding = Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
        desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
});

export function __exportStar(m, o) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(o, p)) __createBinding(o, m, p);
}

export function __values(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
}

export function __read(o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
}

/** @deprecated */
export function __spread() {
    for (var ar = [], i = 0; i < arguments.length; i++)
        ar = ar.concat(__read(arguments[i]));
    return ar;
}

/** @deprecated */
export function __spreadArrays() {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
}

export function __spreadArray(to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
}

export function __await(v) {
    return this instanceof __await ? (this.v = v, this) : new __await(v);
}

export function __asyncGenerator(thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
}

export function __asyncDelegator(o) {
    var i, p;
    return i = {}, verb("next"), verb("throw", function (e) { throw e; }), verb("return"), i[Symbol.iterator] = function () { return this; }, i;
    function verb(n, f) { i[n] = o[n] ? function (v) { return (p = !p) ? { value: __await(o[n](v)), done: false } : f ? f(v) : v; } : f; }
}

export function __asyncValues(o) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var m = o[Symbol.asyncIterator], i;
    return m ? m.call(o) : (o = typeof __values === "function" ? __values(o) : o[Symbol.iterator](), i = {}, verb("next"), verb("throw"), verb("return"), i[Symbol.asyncIterator] = function () { return this; }, i);
    function verb(n) { i[n] = o[n] && function (v) { return new Promise(function (resolve, reject) { v = o[n](v), settle(resolve, reject, v.done, v.value); }); }; }
    function settle(resolve, reject, d, v) { Promise.resolve(v).then(function(v) { resolve({ value: v, done: d }); }, reject); }
}

export function __makeTemplateObject(cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};

var __setModuleDefault = Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
};

export function __importStar(mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
}

export function __importDefault(mod) {
    return (mod && mod.__esModule) ? mod : { default: mod };
}

export function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

export function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

export function __classPrivateFieldIn(state, receiver) {
    if (receiver === null || (typeof receiver !== "object" && typeof receiver !== "function")) throw new TypeError("Cannot use 'in' operator on non-object");
    return typeof state === "function" ? receiver === state : state.has(receiver);
}

export function __addDisposableResource(env, value, async) {
    if (value !== null && value !== void 0) {
        if (typeof value !== "object" && typeof value !== "function") throw new TypeError("Object expected.");
        var dispose, inner;
        if (async) {
            if (!Symbol.asyncDispose) throw new TypeError("Symbol.asyncDispose is not defined.");
            dispose = value[Symbol.asyncDispose];
        }
        if (dispose === void 0) {
            if (!Symbol.dispose) throw new TypeError("Symbol.dispose is not defined.");
            dispose = value[Symbol.dispose];
            if (async) inner = dispose;
        }
        if (typeof dispose !== "function") throw new TypeError("Object not disposable.");
        if (inner) dispose = function() { try { inner.call(this); } catch (e) { return Promise.reject(e); } };
        env.stack.push({ value: value, dispose: dispose, async: async });
    }
    else if (async) {
        env.stack.push({ async: true });
    }
    return value;

}

var _SuppressedError = typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

export function __disposeResources(env) {
    function fail(e) {
        env.error = env.hasError ? new _SuppressedError(e, env.error, "An error was suppressed during disposal.") : e;
        env.hasError = true;
    }
    function next() {
        while (env.stack.length) {
            var rec = env.stack.pop();
            try {
                var result = rec.dispose && rec.dispose.call(rec.value);
                if (rec.async) return Promise.resolve(result).then(next, function(e) { fail(e); return next(); });
            }
            catch (e) {
                fail(e);
            }
        }
        if (env.hasError) throw env.error;
    }
    return next();
}

export default {
    __extends: __extends,
    __assign: __assign,
    __rest: __rest,
    __decorate: __decorate,
    __param: __param,
    __metadata: __metadata,
    __awaiter: __awaiter,
    __generator: __generator,
    __createBinding: __createBinding,
    __exportStar: __exportStar,
    __values: __values,
    __read: __read,
    __spread: __spread,
    __spreadArrays: __spreadArrays,
    __spreadArray: __spreadArray,
    __await: __await,
    __asyncGenerator: __asyncGenerator,
    __asyncDelegator: __asyncDelegator,
    __asyncValues: __asyncValues,
    __makeTemplateObject: __makeTemplateObject,
    __importStar: __importStar,
    __importDefault: __importDefault,
    __classPrivateFieldGet: __classPrivateFieldGet,
    __classPrivateFieldSet: __classPrivateFieldSet,
    __classPrivateFieldIn: __classPrivateFieldIn,
    __addDisposableResource: __addDisposableResource,
    __disposeResources: __disposeResources,
};

var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __esm = (fn, res) => function __init() {
  return fn && (res = (0, fn[__getOwnPropNames(fn)[0]])(fn = 0)), res;
};
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));

// node_modules/minimist/index.js
var require_minimist = __commonJS({
  "node_modules/minimist/index.js"(exports2, module2) {
    "use strict";
    function hasKey(obj, keys) {
      var o = obj;
      keys.slice(0, -1).forEach(function(key2) {
        o = o[key2] || {};
      });
      var key = keys[keys.length - 1];
      return key in o;
    }
    function isNumber2(x) {
      if (typeof x === "number") {
        return true;
      }
      if (/^0x[0-9a-f]+$/i.test(x)) {
        return true;
      }
      return /^[-+]?(?:\d+(?:\.\d*)?|\.\d+)(e[-+]?\d+)?$/.test(x);
    }
    function isConstructorOrProto(obj, key) {
      return key === "constructor" && typeof obj[key] === "function" || key === "__proto__";
    }
    module2.exports = function(args, opts) {
      if (!opts) {
        opts = {};
      }
      var flags = {
        bools: {},
        strings: {},
        unknownFn: null
      };
      if (typeof opts.unknown === "function") {
        flags.unknownFn = opts.unknown;
      }
      if (typeof opts.boolean === "boolean" && opts.boolean) {
        flags.allBools = true;
      } else {
        [].concat(opts.boolean).filter(Boolean).forEach(function(key2) {
          flags.bools[key2] = true;
        });
      }
      var aliases = {};
      function aliasIsBoolean(key2) {
        return aliases[key2].some(function(x) {
          return flags.bools[x];
        });
      }
      Object.keys(opts.alias || {}).forEach(function(key2) {
        aliases[key2] = [].concat(opts.alias[key2]);
        aliases[key2].forEach(function(x) {
          aliases[x] = [key2].concat(aliases[key2].filter(function(y) {
            return x !== y;
          }));
        });
      });
      [].concat(opts.string).filter(Boolean).forEach(function(key2) {
        flags.strings[key2] = true;
        if (aliases[key2]) {
          [].concat(aliases[key2]).forEach(function(k) {
            flags.strings[k] = true;
          });
        }
      });
      var defaults = opts.default || {};
      var argv = { _: [] };
      function argDefined(key2, arg2) {
        return flags.allBools && /^--[^=]+$/.test(arg2) || flags.strings[key2] || flags.bools[key2] || aliases[key2];
      }
      function setKey(obj, keys, value2) {
        var o = obj;
        for (var i2 = 0; i2 < keys.length - 1; i2++) {
          var key2 = keys[i2];
          if (isConstructorOrProto(o, key2)) {
            return;
          }
          if (o[key2] === void 0) {
            o[key2] = {};
          }
          if (o[key2] === Object.prototype || o[key2] === Number.prototype || o[key2] === String.prototype) {
            o[key2] = {};
          }
          if (o[key2] === Array.prototype) {
            o[key2] = [];
          }
          o = o[key2];
        }
        var lastKey = keys[keys.length - 1];
        if (isConstructorOrProto(o, lastKey)) {
          return;
        }
        if (o === Object.prototype || o === Number.prototype || o === String.prototype) {
          o = {};
        }
        if (o === Array.prototype) {
          o = [];
        }
        if (o[lastKey] === void 0 || flags.bools[lastKey] || typeof o[lastKey] === "boolean") {
          o[lastKey] = value2;
        } else if (Array.isArray(o[lastKey])) {
          o[lastKey].push(value2);
        } else {
          o[lastKey] = [o[lastKey], value2];
        }
      }
      function setArg(key2, val, arg2) {
        if (arg2 && flags.unknownFn && !argDefined(key2, arg2)) {
          if (flags.unknownFn(arg2) === false) {
            return;
          }
        }
        var value2 = !flags.strings[key2] && isNumber2(val) ? Number(val) : val;
        setKey(argv, key2.split("."), value2);
        (aliases[key2] || []).forEach(function(x) {
          setKey(argv, x.split("."), value2);
        });
      }
      Object.keys(flags.bools).forEach(function(key2) {
        setArg(key2, defaults[key2] === void 0 ? false : defaults[key2]);
      });
      var notFlags = [];
      if (args.indexOf("--") !== -1) {
        notFlags = args.slice(args.indexOf("--") + 1);
        args = args.slice(0, args.indexOf("--"));
      }
      for (var i = 0; i < args.length; i++) {
        var arg = args[i];
        var key;
        var next;
        if (/^--.+=/.test(arg)) {
          var m = arg.match(/^--([^=]+)=([\s\S]*)$/);
          key = m[1];
          var value = m[2];
          if (flags.bools[key]) {
            value = value !== "false";
          }
          setArg(key, value, arg);
        } else if (/^--no-.+/.test(arg)) {
          key = arg.match(/^--no-(.+)/)[1];
          setArg(key, false, arg);
        } else if (/^--.+/.test(arg)) {
          key = arg.match(/^--(.+)/)[1];
          next = args[i + 1];
          if (next !== void 0 && !/^(-|--)[^-]/.test(next) && !flags.bools[key] && !flags.allBools && (aliases[key] ? !aliasIsBoolean(key) : true)) {
            setArg(key, next, arg);
            i += 1;
          } else if (/^(true|false)$/.test(next)) {
            setArg(key, next === "true", arg);
            i += 1;
          } else {
            setArg(key, flags.strings[key] ? "" : true, arg);
          }
        } else if (/^-[^-]+/.test(arg)) {
          var letters = arg.slice(1, -1).split("");
          var broken = false;
          for (var j = 0; j < letters.length; j++) {
            next = arg.slice(j + 2);
            if (next === "-") {
              setArg(letters[j], next, arg);
              continue;
            }
            if (/[A-Za-z]/.test(letters[j]) && next[0] === "=") {
              setArg(letters[j], next.slice(1), arg);
              broken = true;
              break;
            }
            if (/[A-Za-z]/.test(letters[j]) && /-?\d+(\.\d*)?(e-?\d+)?$/.test(next)) {
              setArg(letters[j], next, arg);
              broken = true;
              break;
            }
            if (letters[j + 1] && letters[j + 1].match(/\W/)) {
              setArg(letters[j], arg.slice(j + 2), arg);
              broken = true;
              break;
            } else {
              setArg(letters[j], flags.strings[letters[j]] ? "" : true, arg);
            }
          }
          key = arg.slice(-1)[0];
          if (!broken && key !== "-") {
            if (args[i + 1] && !/^(-|--)[^-]/.test(args[i + 1]) && !flags.bools[key] && (aliases[key] ? !aliasIsBoolean(key) : true)) {
              setArg(key, args[i + 1], arg);
              i += 1;
            } else if (args[i + 1] && /^(true|false)$/.test(args[i + 1])) {
              setArg(key, args[i + 1] === "true", arg);
              i += 1;
            } else {
              setArg(key, flags.strings[key] ? "" : true, arg);
            }
          }
        } else {
          if (!flags.unknownFn || flags.unknownFn(arg) !== false) {
            argv._.push(flags.strings._ || !isNumber2(arg) ? arg : Number(arg));
          }
          if (opts.stopEarly) {
            argv._.push.apply(argv._, args.slice(i + 1));
            break;
          }
        }
      }
      Object.keys(defaults).forEach(function(k) {
        if (!hasKey(argv, k.split("."))) {
          setKey(argv, k.split("."), defaults[k]);
          (aliases[k] || []).forEach(function(x) {
            setKey(argv, x.split("."), defaults[k]);
          });
        }
      });
      if (opts["--"]) {
        argv["--"] = notFlags.slice();
      } else {
        notFlags.forEach(function(k) {
          argv._.push(k);
        });
      }
      return argv;
    };
  }
});

// out-build/vs/base/common/performance.js
function _definePolyfillMarks(timeOrigin) {
  const _data = [];
  if (typeof timeOrigin === "number") {
    _data.push("code/timeOrigin", timeOrigin);
  }
  function mark(name, markOptions) {
    _data.push(name, markOptions?.startTime ?? Date.now());
  }
  function getMarks() {
    const result = [];
    for (let i = 0; i < _data.length; i += 2) {
      result.push({
        name: _data[i],
        startTime: _data[i + 1]
      });
    }
    return result;
  }
  return { mark, getMarks };
}
function _define() {
  if (typeof performance === "object" && typeof performance.mark === "function" && !performance.nodeTiming) {
    if (typeof performance.timeOrigin !== "number" && !performance.timing) {
      return _definePolyfillMarks();
    } else {
      return {
        mark(name, markOptions) {
          performance.mark(name, markOptions);
        },
        getMarks() {
          let timeOrigin = performance.timeOrigin;
          if (typeof timeOrigin !== "number") {
            timeOrigin = performance.timing.navigationStart || performance.timing.redirectStart || performance.timing.fetchStart;
          }
          const result = [{ name: "code/timeOrigin", startTime: Math.round(timeOrigin) }];
          for (const entry of performance.getEntriesByType("mark")) {
            result.push({
              name: entry.name,
              startTime: Math.round(timeOrigin + entry.startTime)
            });
          }
          return result;
        }
      };
    }
  } else if (typeof process === "object") {
    const timeOrigin = performance?.timeOrigin;
    return _definePolyfillMarks(timeOrigin);
  } else {
    console.trace("perf-util loaded in UNKNOWN environment");
    return _definePolyfillMarks();
  }
}
function _factory(sharedObj) {
  if (!sharedObj.MonacoPerformanceMarks) {
    sharedObj.MonacoPerformanceMarks = _define();
  }
  return sharedObj.MonacoPerformanceMarks;
}
var perf, $S, $T;
var init_performance = __esm({
  "out-build/vs/base/common/performance.js"() {
    "use strict";
    perf = _factory(globalThis);
    $S = perf.mark;
    $T = perf.getMarks;
  }
});

// out-build/vs/base/node/nls.js
import * as path3 from "path";
import * as fs3 from "fs";
async function $vt({ userLocale, osLocale, userDataPath, commit, nlsMetadataPath: nlsMetadataPath2 }) {
  $S("code/willGenerateNls");
  if (process.env["VSCODE_DEV"] || userLocale === "pseudo" || userLocale.startsWith("en") || !commit || !userDataPath) {
    return defaultNLSConfiguration(userLocale, osLocale, nlsMetadataPath2);
  }
  try {
    const languagePacks = await getLanguagePackConfigurations(userDataPath);
    if (!languagePacks) {
      return defaultNLSConfiguration(userLocale, osLocale, nlsMetadataPath2);
    }
    const resolvedLanguage = resolveLanguagePackLanguage(languagePacks, userLocale);
    if (!resolvedLanguage) {
      return defaultNLSConfiguration(userLocale, osLocale, nlsMetadataPath2);
    }
    const languagePack = languagePacks[resolvedLanguage];
    const mainLanguagePackPath = languagePack?.translations?.["vscode"];
    if (!languagePack || typeof languagePack.hash !== "string" || !languagePack.translations || typeof mainLanguagePackPath !== "string" || !await exists(mainLanguagePackPath)) {
      return defaultNLSConfiguration(userLocale, osLocale, nlsMetadataPath2);
    }
    const languagePackId = `${languagePack.hash}.${resolvedLanguage}`;
    const globalLanguagePackCachePath = path3.join(userDataPath, "clp", languagePackId);
    const commitLanguagePackCachePath = path3.join(globalLanguagePackCachePath, commit);
    const languagePackMessagesFile = path3.join(commitLanguagePackCachePath, "nls.messages.json");
    const translationsConfigFile = path3.join(globalLanguagePackCachePath, "tcf.json");
    const languagePackCorruptMarkerFile = path3.join(globalLanguagePackCachePath, "corrupted.info");
    if (await exists(languagePackCorruptMarkerFile)) {
      await fs3.promises.rm(globalLanguagePackCachePath, { recursive: true, force: true, maxRetries: 3 });
    }
    const result = {
      userLocale,
      osLocale,
      resolvedLanguage,
      defaultMessagesFile: path3.join(nlsMetadataPath2, "nls.messages.json"),
      languagePack: {
        translationsConfigFile,
        messagesFile: languagePackMessagesFile,
        corruptMarkerFile: languagePackCorruptMarkerFile
      },
      // NLS: below properties are a relic from old times only used by vscode-nls and deprecated
      locale: userLocale,
      availableLanguages: { "*": resolvedLanguage },
      _languagePackId: languagePackId,
      _languagePackSupport: true,
      _translationsConfigFile: translationsConfigFile,
      _cacheRoot: globalLanguagePackCachePath,
      _resolvedLanguagePackCoreLocation: commitLanguagePackCachePath,
      _corruptedFile: languagePackCorruptMarkerFile
    };
    if (await exists(commitLanguagePackCachePath)) {
      touch(commitLanguagePackCachePath).catch(() => {
      });
      $S("code/didGenerateNls");
      return result;
    }
    const [, nlsDefaultKeys, nlsDefaultMessages, nlsPackdata] = await Promise.all([
      fs3.promises.mkdir(commitLanguagePackCachePath, { recursive: true }),
      JSON.parse(await fs3.promises.readFile(path3.join(nlsMetadataPath2, "nls.keys.json"), "utf-8")),
      JSON.parse(await fs3.promises.readFile(path3.join(nlsMetadataPath2, "nls.messages.json"), "utf-8")),
      JSON.parse(await fs3.promises.readFile(mainLanguagePackPath, "utf-8"))
    ]);
    const nlsResult = [];
    let nlsIndex = 0;
    for (const [moduleId, nlsKeys] of nlsDefaultKeys) {
      const moduleTranslations = nlsPackdata.contents[moduleId];
      for (const nlsKey of nlsKeys) {
        nlsResult.push(moduleTranslations?.[nlsKey] || nlsDefaultMessages[nlsIndex]);
        nlsIndex++;
      }
    }
    await Promise.all([
      fs3.promises.writeFile(languagePackMessagesFile, JSON.stringify(nlsResult), "utf-8"),
      fs3.promises.writeFile(translationsConfigFile, JSON.stringify(languagePack.translations), "utf-8")
    ]);
    $S("code/didGenerateNls");
    return result;
  } catch (error) {
    console.error("Generating translation files failed.", error);
  }
  return defaultNLSConfiguration(userLocale, osLocale, nlsMetadataPath2);
}
async function getLanguagePackConfigurations(userDataPath) {
  const configFile = path3.join(userDataPath, "languagepacks.json");
  try {
    return JSON.parse(await fs3.promises.readFile(configFile, "utf-8"));
  } catch (err) {
    return void 0;
  }
}
function resolveLanguagePackLanguage(languagePacks, locale) {
  try {
    while (locale) {
      if (languagePacks[locale]) {
        return locale;
      }
      const index = locale.lastIndexOf("-");
      if (index > 0) {
        locale = locale.substring(0, index);
      } else {
        return void 0;
      }
    }
  } catch (error) {
    console.error("Resolving language pack configuration failed.", error);
  }
  return void 0;
}
function defaultNLSConfiguration(userLocale, osLocale, nlsMetadataPath2) {
  $S("code/didGenerateNls");
  return {
    userLocale,
    osLocale,
    resolvedLanguage: "en",
    defaultMessagesFile: path3.join(nlsMetadataPath2, "nls.messages.json"),
    // NLS: below 2 are a relic from old times only used by vscode-nls and deprecated
    locale: userLocale,
    availableLanguages: {}
  };
}
async function exists(path7) {
  try {
    await fs3.promises.access(path7);
    return true;
  } catch {
    return false;
  }
}
function touch(path7) {
  const date = /* @__PURE__ */ new Date();
  return fs3.promises.utimes(path7, date, date);
}
var init_nls = __esm({
  "out-build/vs/base/node/nls.js"() {
    "use strict";
    init_performance();
  }
});

// out-build/vs/base/common/errors.js
function setUnexpectedErrorHandler(newUnexpectedErrorHandler) {
  $cb.setUnexpectedErrorHandler(newUnexpectedErrorHandler);
}
function $eb(e) {
  if (!e || typeof e !== "object") {
    return false;
  }
  const cast = e;
  return cast.code === "EPIPE" && cast.syscall?.toUpperCase() === "WRITE";
}
function $gb(e) {
  if (!$kb(e)) {
    $cb.onUnexpectedError(e);
  }
  return void 0;
}
function $kb(error) {
  if (error instanceof $lb) {
    return true;
  }
  return error instanceof Error && error.name === canceledName && error.message === canceledName;
}
function $mb() {
  const error = new Error(canceledName);
  error.name = error.message;
  return error;
}
function $nb(name) {
  if (name) {
    return new Error(`Illegal argument: ${name}`);
  } else {
    return new Error("Illegal argument");
  }
}
function $ob(name) {
  if (name) {
    return new Error(`Illegal state: ${name}`);
  } else {
    return new Error("Illegal state");
  }
}
function $qb(err) {
  if (!err) {
    return "Error";
  }
  if (err.message) {
    return err.message;
  }
  if (err.stack) {
    return err.stack.split("\n")[0];
  }
  return String(err);
}
var $bb, $cb, canceledName, $lb, $ub, $vb;
var init_errors = __esm({
  "out-build/vs/base/common/errors.js"() {
    "use strict";
    $bb = class {
      constructor() {
        this.b = [];
        this.a = function(e) {
          setTimeout(() => {
            if (e.stack) {
              if ($ub.isErrorNoTelemetry(e)) {
                throw new $ub(e.message + "\n\n" + e.stack);
              }
              throw new Error(e.message + "\n\n" + e.stack);
            }
            throw e;
          }, 0);
        };
      }
      addListener(listener) {
        this.b.push(listener);
        return () => {
          this.d(listener);
        };
      }
      c(e) {
        this.b.forEach((listener) => {
          listener(e);
        });
      }
      d(listener) {
        this.b.splice(this.b.indexOf(listener), 1);
      }
      setUnexpectedErrorHandler(newUnexpectedErrorHandler) {
        this.a = newUnexpectedErrorHandler;
      }
      getUnexpectedErrorHandler() {
        return this.a;
      }
      onUnexpectedError(e) {
        this.a(e);
        this.c(e);
      }
      // For external errors, we don't want the listeners to be called
      onUnexpectedExternalError(e) {
        this.a(e);
      }
    };
    $cb = new $bb();
    canceledName = "Canceled";
    $lb = class extends Error {
      constructor() {
        super(canceledName);
        this.name = this.message;
      }
    };
    $ub = class _$ub extends Error {
      constructor(msg) {
        super(msg);
        this.name = "CodeExpectedError";
      }
      static fromError(err) {
        if (err instanceof _$ub) {
          return err;
        }
        const result = new _$ub();
        result.message = err.message;
        result.stack = err.stack;
        return result;
      }
      static isErrorNoTelemetry(err) {
        return err.name === "CodeExpectedError";
      }
    };
    $vb = class _$vb extends Error {
      constructor(message) {
        super(message || "An unexpected bug occurred.");
        Object.setPrototypeOf(this, _$vb.prototype);
      }
    };
  }
});

// out-build/vs/nls.messages.js
function $f() {
  return globalThis._VSCODE_NLS_MESSAGES;
}
function $g() {
  return globalThis._VSCODE_NLS_LANGUAGE;
}
var init_nls_messages = __esm({
  "out-build/vs/nls.messages.js"() {
    "use strict";
  }
});

// out-build/vs/nls.js
function _format(message, args) {
  let result;
  if (args.length === 0) {
    result = message;
  } else {
    result = message.replace(/\{(\d+)\}/g, (match, rest) => {
      const index = rest[0];
      const arg = args[index];
      let result2 = match;
      if (typeof arg === "string") {
        result2 = arg;
      } else if (typeof arg === "number" || typeof arg === "boolean" || arg === void 0 || arg === null) {
        result2 = String(arg);
      }
      return result2;
    });
  }
  if (isPseudo) {
    result = "\uFF3B" + result.replace(/[aouei]/g, "$&$&") + "\uFF3D";
  }
  return result;
}
function localize(data, message, ...args) {
  if (typeof data === "number") {
    return _format(lookupMessage(data, message), args);
  }
  return _format(message, args);
}
function lookupMessage(index, fallback) {
  const message = $f()?.[index];
  if (typeof message !== "string") {
    if (typeof fallback === "string") {
      return fallback;
    }
    throw new Error(`!!! NLS MISSING: ${index} !!!`);
  }
  return message;
}
function localize2(data, originalMessage, ...args) {
  let message;
  if (typeof data === "number") {
    message = lookupMessage(data, originalMessage);
  } else {
    message = originalMessage;
  }
  const value = _format(message, args);
  return {
    value,
    original: originalMessage === message ? value : _format(originalMessage, args)
  };
}
var isPseudo;
var init_nls2 = __esm({
  "out-build/vs/nls.js"() {
    "use strict";
    init_nls_messages();
    init_nls_messages();
    isPseudo = $g() === "pseudo" || typeof document !== "undefined" && document.location && typeof document.location.hash === "string" && document.location.hash.indexOf("pseudo=true") >= 0;
  }
});

// out-build/vs/base/common/platform.js
function $k(platform) {
  switch (platform) {
    case 0:
      return "Web";
    case 1:
      return "Mac";
    case 2:
      return "Linux";
    case 3:
      return "Windows";
  }
}
var $j, _isWindows, _isMacintosh, _isLinux, _isLinuxSnap, _isNative, _isWeb, _isElectron, _isIOS, _isCI, _isMobile, _locale, _language, _platformLocale, _translationsConfigFile, _userAgent, $globalThis, nodeProcess, isElectronProcess, isElectronRenderer, Platform, _platform, $l, $m, $n, $o, $p, $r, $s, $t, $x, $y, $z, Language, $D, $E, OperatingSystem, OS, $H, $I, $J, $K, $L;
var init_platform = __esm({
  "out-build/vs/base/common/platform.js"() {
    "use strict";
    init_nls2();
    $j = "en";
    _isWindows = false;
    _isMacintosh = false;
    _isLinux = false;
    _isLinuxSnap = false;
    _isNative = false;
    _isWeb = false;
    _isElectron = false;
    _isIOS = false;
    _isCI = false;
    _isMobile = false;
    _locale = void 0;
    _language = $j;
    _platformLocale = $j;
    _translationsConfigFile = void 0;
    _userAgent = void 0;
    $globalThis = globalThis;
    nodeProcess = void 0;
    if (typeof $globalThis.vscode !== "undefined" && typeof $globalThis.vscode.process !== "undefined") {
      nodeProcess = $globalThis.vscode.process;
    } else if (typeof process !== "undefined" && typeof process?.versions?.node === "string") {
      nodeProcess = process;
    }
    isElectronProcess = typeof nodeProcess?.versions?.electron === "string";
    isElectronRenderer = isElectronProcess && nodeProcess?.type === "renderer";
    if (typeof nodeProcess === "object") {
      _isWindows = nodeProcess.platform === "win32";
      _isMacintosh = nodeProcess.platform === "darwin";
      _isLinux = nodeProcess.platform === "linux";
      _isLinuxSnap = _isLinux && !!nodeProcess.env["SNAP"] && !!nodeProcess.env["SNAP_REVISION"];
      _isElectron = isElectronProcess;
      _isCI = !!nodeProcess.env["CI"] || !!nodeProcess.env["BUILD_ARTIFACTSTAGINGDIRECTORY"];
      _locale = $j;
      _language = $j;
      const rawNlsConfig = nodeProcess.env["VSCODE_NLS_CONFIG"];
      if (rawNlsConfig) {
        try {
          const nlsConfig = JSON.parse(rawNlsConfig);
          _locale = nlsConfig.userLocale;
          _platformLocale = nlsConfig.osLocale;
          _language = nlsConfig.resolvedLanguage || $j;
          _translationsConfigFile = nlsConfig.languagePack?.translationsConfigFile;
        } catch (e) {
        }
      }
      _isNative = true;
    } else if (typeof navigator === "object" && !isElectronRenderer) {
      _userAgent = navigator.userAgent;
      _isWindows = _userAgent.indexOf("Windows") >= 0;
      _isMacintosh = _userAgent.indexOf("Macintosh") >= 0;
      _isIOS = (_userAgent.indexOf("Macintosh") >= 0 || _userAgent.indexOf("iPad") >= 0 || _userAgent.indexOf("iPhone") >= 0) && !!navigator.maxTouchPoints && navigator.maxTouchPoints > 0;
      _isLinux = _userAgent.indexOf("Linux") >= 0;
      _isMobile = _userAgent?.indexOf("Mobi") >= 0;
      _isWeb = true;
      _language = $g() || $j;
      _locale = navigator.language.toLowerCase();
      _platformLocale = _locale;
    } else {
      console.error("Unable to resolve platform.");
    }
    (function(Platform2) {
      Platform2[Platform2["Web"] = 0] = "Web";
      Platform2[Platform2["Mac"] = 1] = "Mac";
      Platform2[Platform2["Linux"] = 2] = "Linux";
      Platform2[Platform2["Windows"] = 3] = "Windows";
    })(Platform || (Platform = {}));
    _platform = 0;
    if (_isMacintosh) {
      _platform = 1;
    } else if (_isWindows) {
      _platform = 3;
    } else if (_isLinux) {
      _platform = 2;
    }
    $l = _isWindows;
    $m = _isMacintosh;
    $n = _isLinux;
    $o = _isLinuxSnap;
    $p = _isNative;
    $r = _isWeb;
    $s = _isWeb && typeof $globalThis.importScripts === "function";
    $t = $s ? $globalThis.origin : void 0;
    $x = _platform;
    $y = _userAgent;
    $z = _language;
    (function(Language2) {
      function value() {
        return $z;
      }
      Language2.value = value;
      function isDefaultVariant() {
        if ($z.length === 2) {
          return $z === "en";
        } else if ($z.length >= 3) {
          return $z[0] === "e" && $z[1] === "n" && $z[2] === "-";
        } else {
          return false;
        }
      }
      Language2.isDefaultVariant = isDefaultVariant;
      function isDefault() {
        return $z === "en";
      }
      Language2.isDefault = isDefault;
    })(Language || (Language = {}));
    $D = typeof $globalThis.postMessage === "function" && !$globalThis.importScripts;
    $E = (() => {
      if ($D) {
        const pending = [];
        $globalThis.addEventListener("message", (e) => {
          if (e.data && e.data.vscodeScheduleAsyncWork) {
            for (let i = 0, len = pending.length; i < len; i++) {
              const candidate = pending[i];
              if (candidate.id === e.data.vscodeScheduleAsyncWork) {
                pending.splice(i, 1);
                candidate.callback();
                return;
              }
            }
          }
        });
        let lastId = 0;
        return (callback) => {
          const myId = ++lastId;
          pending.push({
            id: myId,
            callback
          });
          $globalThis.postMessage({ vscodeScheduleAsyncWork: myId }, "*");
        };
      }
      return (callback) => setTimeout(callback);
    })();
    (function(OperatingSystem2) {
      OperatingSystem2[OperatingSystem2["Windows"] = 1] = "Windows";
      OperatingSystem2[OperatingSystem2["Macintosh"] = 2] = "Macintosh";
      OperatingSystem2[OperatingSystem2["Linux"] = 3] = "Linux";
    })(OperatingSystem || (OperatingSystem = {}));
    OS = _isMacintosh || _isIOS ? 2 : _isWindows ? 1 : 3;
    $H = !!($y && $y.indexOf("Chrome") >= 0);
    $I = !!($y && $y.indexOf("Firefox") >= 0);
    $J = !!(!$H && ($y && $y.indexOf("Safari") >= 0));
    $K = !!($y && $y.indexOf("Edg/") >= 0);
    $L = !!($y && $y.indexOf("Android") >= 0);
  }
});

// out-build/vs/base/common/collections.js
function $a(data, groupFn) {
  const result = /* @__PURE__ */ Object.create(null);
  for (const element of data) {
    const key = groupFn(element);
    let target = result[key];
    if (!target) {
      target = result[key] = [];
    }
    target.push(element);
  }
  return result;
}
var _a, $e;
var init_collections = __esm({
  "out-build/vs/base/common/collections.js"() {
    "use strict";
    $e = class {
      static {
        _a = Symbol.toStringTag;
      }
      constructor(values, b) {
        this.b = b;
        this.a = /* @__PURE__ */ new Map();
        this[_a] = "SetWithKey";
        for (const value of values) {
          this.add(value);
        }
      }
      get size() {
        return this.a.size;
      }
      add(value) {
        const key = this.b(value);
        this.a.set(key, value);
        return this;
      }
      delete(value) {
        return this.a.delete(this.b(value));
      }
      has(value) {
        return this.a.has(this.b(value));
      }
      *entries() {
        for (const entry of this.a.values()) {
          yield [entry, entry];
        }
      }
      keys() {
        return this.values();
      }
      *values() {
        for (const entry of this.a.values()) {
          yield entry;
        }
      }
      clear() {
        this.a.clear();
      }
      forEach(callbackfn, thisArg) {
        this.a.forEach((entry) => callbackfn.call(thisArg, entry, entry, this));
      }
      [Symbol.iterator]() {
        return this.values();
      }
    };
  }
});

// out-build/vs/base/common/functional.js
function $Pc(fn, fnDidRunCallback) {
  const _this = this;
  let didCall = false;
  let result;
  return function() {
    if (didCall) {
      return result;
    }
    didCall = true;
    if (fnDidRunCallback) {
      try {
        result = fn.apply(_this, arguments);
      } finally {
        fnDidRunCallback();
      }
    } else {
      result = fn.apply(_this, arguments);
    }
    return result;
  };
}
var init_functional = __esm({
  "out-build/vs/base/common/functional.js"() {
    "use strict";
  }
});

// out-build/vs/base/common/arraysFind.js
function $4(array, predicate, startIdx = 0, endIdxEx = array.length) {
  let i = startIdx;
  let j = endIdxEx;
  while (i < j) {
    const k = Math.floor((i + j) / 2);
    if (predicate(array[k])) {
      i = k + 1;
    } else {
      j = k;
    }
  }
  return i - 1;
}
var $8;
var init_arraysFind = __esm({
  "out-build/vs/base/common/arraysFind.js"() {
    "use strict";
    $8 = class _$8 {
      static {
        this.assertInvariants = false;
      }
      constructor(e) {
        this.e = e;
        this.c = 0;
      }
      /**
       * The predicate must be monotonous, i.e. `arr.map(predicate)` must be like `[true, ..., true, false, ..., false]`!
       * For subsequent calls, current predicate must be weaker than (or equal to) the previous predicate, i.e. more entries must be `true`.
       */
      findLastMonotonous(predicate) {
        if (_$8.assertInvariants) {
          if (this.d) {
            for (const item of this.e) {
              if (this.d(item) && !predicate(item)) {
                throw new Error("MonotonousArray: current predicate must be weaker than (or equal to) the previous predicate.");
              }
            }
          }
          this.d = predicate;
        }
        const idx = $4(this.e, predicate, this.c);
        this.c = idx + 1;
        return idx === -1 ? void 0 : this.e[idx];
      }
    };
  }
});

// out-build/vs/base/common/arrays.js
function $yb(one, other, itemEquals = (a, b) => a === b) {
  if (one === other) {
    return true;
  }
  if (!one || !other) {
    return false;
  }
  if (one.length !== other.length) {
    return false;
  }
  for (let i = 0, len = one.length; i < len; i++) {
    if (!itemEquals(one[i], other[i])) {
      return false;
    }
  }
  return true;
}
function $Ab(array, key, comparator) {
  return $Bb(array.length, (i) => comparator(array[i], key));
}
function $Bb(length, compareToKey) {
  let low = 0, high = length - 1;
  while (low <= high) {
    const mid = (low + high) / 2 | 0;
    const comp = compareToKey(mid);
    if (comp < 0) {
      low = mid + 1;
    } else if (comp > 0) {
      high = mid - 1;
    } else {
      return mid;
    }
  }
  return -(low + 1);
}
function $Lb(array) {
  return array.filter((e) => !!e);
}
function $Mb(array) {
  let to = 0;
  for (let i = 0; i < array.length; i++) {
    if (!!array[i]) {
      array[to] = array[i];
      to += 1;
    }
  }
  array.length = to;
}
function $Pb(obj) {
  return Array.isArray(obj) && obj.length > 0;
}
function $Qb(array, keyFn = (value) => value) {
  const seen = /* @__PURE__ */ new Set();
  return array.filter((element) => {
    const key = keyFn(element);
    if (seen.has(key)) {
      return false;
    }
    seen.add(key);
    return true;
  });
}
function $Vb(array, element) {
  array.push(element);
  return () => $Wb(array, element);
}
function $Wb(array, element) {
  const index = array.indexOf(element);
  if (index > -1) {
    array.splice(index, 1);
    return element;
  }
  return void 0;
}
function $Yb(array, _seed) {
  let rand;
  if (typeof _seed === "number") {
    let seed = _seed;
    rand = () => {
      const x = Math.sin(seed++) * 179426549;
      return x - Math.floor(x);
    };
  } else {
    rand = Math.random;
  }
  for (let i = array.length - 1; i > 0; i -= 1) {
    const j = Math.floor(rand() * (i + 1));
    const temp = array[i];
    array[i] = array[j];
    array[j] = temp;
  }
}
function $4b(x) {
  return Array.isArray(x) ? x : [x];
}
function $5b(arr) {
  return arr[Math.floor(Math.random() * arr.length)];
}
function $9b(selector, comparator) {
  return (a, b) => comparator(selector(a), selector(b));
}
var CompareResult, $$b, $dc;
var init_arrays = __esm({
  "out-build/vs/base/common/arrays.js"() {
    "use strict";
    init_arraysFind();
    init_errors();
    (function(CompareResult2) {
      function isLessThan(result) {
        return result < 0;
      }
      CompareResult2.isLessThan = isLessThan;
      function isLessThanOrEqual(result) {
        return result <= 0;
      }
      CompareResult2.isLessThanOrEqual = isLessThanOrEqual;
      function isGreaterThan(result) {
        return result > 0;
      }
      CompareResult2.isGreaterThan = isGreaterThan;
      function isNeitherLessOrGreaterThan(result) {
        return result === 0;
      }
      CompareResult2.isNeitherLessOrGreaterThan = isNeitherLessOrGreaterThan;
      CompareResult2.greaterThan = 1;
      CompareResult2.lessThan = -1;
      CompareResult2.neitherLessOrGreaterThan = 0;
    })(CompareResult || (CompareResult = {}));
    $$b = (a, b) => a - b;
    $dc = class _$dc {
      static {
        this.empty = new _$dc((_callback) => {
        });
      }
      constructor(iterate) {
        this.iterate = iterate;
      }
      forEach(handler) {
        this.iterate((item) => {
          handler(item);
          return true;
        });
      }
      toArray() {
        const result = [];
        this.iterate((item) => {
          result.push(item);
          return true;
        });
        return result;
      }
      filter(predicate) {
        return new _$dc((cb) => this.iterate((item) => predicate(item) ? cb(item) : true));
      }
      map(mapFn) {
        return new _$dc((cb) => this.iterate((item) => cb(mapFn(item))));
      }
      some(predicate) {
        let result = false;
        this.iterate((item) => {
          result = predicate(item);
          return !result;
        });
        return result;
      }
      findFirst(predicate) {
        let result;
        this.iterate((item) => {
          if (predicate(item)) {
            result = item;
            return false;
          }
          return true;
        });
        return result;
      }
      findLast(predicate) {
        let result;
        this.iterate((item) => {
          if (predicate(item)) {
            result = item;
          }
          return true;
        });
        return result;
      }
      findLastMaxBy(comparator) {
        let result;
        let first = true;
        this.iterate((item) => {
          if (first || CompareResult.isGreaterThan(comparator(item, result))) {
            first = false;
            result = item;
          }
          return true;
        });
        return result;
      }
    };
  }
});

// out-build/vs/base/common/map.js
function isEntries(arg) {
  return Array.isArray(arg);
}
var _a2, _b, _c, ResourceMapEntry, $Fc, $Gc, Touch, $Hc, Cache, $Ic, $Mc;
var init_map = __esm({
  "out-build/vs/base/common/map.js"() {
    "use strict";
    ResourceMapEntry = class {
      constructor(uri, value) {
        this.uri = uri;
        this.value = value;
      }
    };
    $Fc = class _$Fc {
      static {
        this.c = (resource) => resource.toString();
      }
      constructor(arg, toKey) {
        this[_a2] = "ResourceMap";
        if (arg instanceof _$Fc) {
          this.d = new Map(arg.d);
          this.e = toKey ?? _$Fc.c;
        } else if (isEntries(arg)) {
          this.d = /* @__PURE__ */ new Map();
          this.e = toKey ?? _$Fc.c;
          for (const [resource, value] of arg) {
            this.set(resource, value);
          }
        } else {
          this.d = /* @__PURE__ */ new Map();
          this.e = arg ?? _$Fc.c;
        }
      }
      set(resource, value) {
        this.d.set(this.e(resource), new ResourceMapEntry(resource, value));
        return this;
      }
      get(resource) {
        return this.d.get(this.e(resource))?.value;
      }
      has(resource) {
        return this.d.has(this.e(resource));
      }
      get size() {
        return this.d.size;
      }
      clear() {
        this.d.clear();
      }
      delete(resource) {
        return this.d.delete(this.e(resource));
      }
      forEach(clb, thisArg) {
        if (typeof thisArg !== "undefined") {
          clb = clb.bind(thisArg);
        }
        for (const [_, entry] of this.d) {
          clb(entry.value, entry.uri, this);
        }
      }
      *values() {
        for (const entry of this.d.values()) {
          yield entry.value;
        }
      }
      *keys() {
        for (const entry of this.d.values()) {
          yield entry.uri;
        }
      }
      *entries() {
        for (const entry of this.d.values()) {
          yield [entry.uri, entry.value];
        }
      }
      *[(_a2 = Symbol.toStringTag, Symbol.iterator)]() {
        for (const [, entry] of this.d) {
          yield [entry.uri, entry.value];
        }
      }
    };
    $Gc = class {
      constructor(entriesOrKey, toKey) {
        this[_b] = "ResourceSet";
        if (!entriesOrKey || typeof entriesOrKey === "function") {
          this.c = new $Fc(entriesOrKey);
        } else {
          this.c = new $Fc(toKey);
          entriesOrKey.forEach(this.add, this);
        }
      }
      get size() {
        return this.c.size;
      }
      add(value) {
        this.c.set(value, value);
        return this;
      }
      clear() {
        this.c.clear();
      }
      delete(value) {
        return this.c.delete(value);
      }
      forEach(callbackfn, thisArg) {
        this.c.forEach((_value, key) => callbackfn.call(thisArg, key, key, this));
      }
      has(value) {
        return this.c.has(value);
      }
      entries() {
        return this.c.entries();
      }
      keys() {
        return this.c.keys();
      }
      values() {
        return this.c.keys();
      }
      [(_b = Symbol.toStringTag, Symbol.iterator)]() {
        return this.keys();
      }
    };
    (function(Touch2) {
      Touch2[Touch2["None"] = 0] = "None";
      Touch2[Touch2["AsOld"] = 1] = "AsOld";
      Touch2[Touch2["AsNew"] = 2] = "AsNew";
    })(Touch || (Touch = {}));
    $Hc = class {
      constructor() {
        this[_c] = "LinkedMap";
        this.c = /* @__PURE__ */ new Map();
        this.d = void 0;
        this.e = void 0;
        this.f = 0;
        this.g = 0;
      }
      clear() {
        this.c.clear();
        this.d = void 0;
        this.e = void 0;
        this.f = 0;
        this.g++;
      }
      isEmpty() {
        return !this.d && !this.e;
      }
      get size() {
        return this.f;
      }
      get first() {
        return this.d?.value;
      }
      get last() {
        return this.e?.value;
      }
      has(key) {
        return this.c.has(key);
      }
      get(key, touch2 = 0) {
        const item = this.c.get(key);
        if (!item) {
          return void 0;
        }
        if (touch2 !== 0) {
          this.n(item, touch2);
        }
        return item.value;
      }
      set(key, value, touch2 = 0) {
        let item = this.c.get(key);
        if (item) {
          item.value = value;
          if (touch2 !== 0) {
            this.n(item, touch2);
          }
        } else {
          item = { key, value, next: void 0, previous: void 0 };
          switch (touch2) {
            case 0:
              this.l(item);
              break;
            case 1:
              this.k(item);
              break;
            case 2:
              this.l(item);
              break;
            default:
              this.l(item);
              break;
          }
          this.c.set(key, item);
          this.f++;
        }
        return this;
      }
      delete(key) {
        return !!this.remove(key);
      }
      remove(key) {
        const item = this.c.get(key);
        if (!item) {
          return void 0;
        }
        this.c.delete(key);
        this.m(item);
        this.f--;
        return item.value;
      }
      shift() {
        if (!this.d && !this.e) {
          return void 0;
        }
        if (!this.d || !this.e) {
          throw new Error("Invalid list");
        }
        const item = this.d;
        this.c.delete(item.key);
        this.m(item);
        this.f--;
        return item.value;
      }
      forEach(callbackfn, thisArg) {
        const state = this.g;
        let current = this.d;
        while (current) {
          if (thisArg) {
            callbackfn.bind(thisArg)(current.value, current.key, this);
          } else {
            callbackfn(current.value, current.key, this);
          }
          if (this.g !== state) {
            throw new Error(`LinkedMap got modified during iteration.`);
          }
          current = current.next;
        }
      }
      keys() {
        const map = this;
        const state = this.g;
        let current = this.d;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map.g !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: current.key, done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      values() {
        const map = this;
        const state = this.g;
        let current = this.d;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map.g !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: current.value, done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      entries() {
        const map = this;
        const state = this.g;
        let current = this.d;
        const iterator = {
          [Symbol.iterator]() {
            return iterator;
          },
          next() {
            if (map.g !== state) {
              throw new Error(`LinkedMap got modified during iteration.`);
            }
            if (current) {
              const result = { value: [current.key, current.value], done: false };
              current = current.next;
              return result;
            } else {
              return { value: void 0, done: true };
            }
          }
        };
        return iterator;
      }
      [(_c = Symbol.toStringTag, Symbol.iterator)]() {
        return this.entries();
      }
      h(newSize) {
        if (newSize >= this.size) {
          return;
        }
        if (newSize === 0) {
          this.clear();
          return;
        }
        let current = this.d;
        let currentSize = this.size;
        while (current && currentSize > newSize) {
          this.c.delete(current.key);
          current = current.next;
          currentSize--;
        }
        this.d = current;
        this.f = currentSize;
        if (current) {
          current.previous = void 0;
        }
        this.g++;
      }
      j(newSize) {
        if (newSize >= this.size) {
          return;
        }
        if (newSize === 0) {
          this.clear();
          return;
        }
        let current = this.e;
        let currentSize = this.size;
        while (current && currentSize > newSize) {
          this.c.delete(current.key);
          current = current.previous;
          currentSize--;
        }
        this.e = current;
        this.f = currentSize;
        if (current) {
          current.next = void 0;
        }
        this.g++;
      }
      k(item) {
        if (!this.d && !this.e) {
          this.e = item;
        } else if (!this.d) {
          throw new Error("Invalid list");
        } else {
          item.next = this.d;
          this.d.previous = item;
        }
        this.d = item;
        this.g++;
      }
      l(item) {
        if (!this.d && !this.e) {
          this.d = item;
        } else if (!this.e) {
          throw new Error("Invalid list");
        } else {
          item.previous = this.e;
          this.e.next = item;
        }
        this.e = item;
        this.g++;
      }
      m(item) {
        if (item === this.d && item === this.e) {
          this.d = void 0;
          this.e = void 0;
        } else if (item === this.d) {
          if (!item.next) {
            throw new Error("Invalid list");
          }
          item.next.previous = void 0;
          this.d = item.next;
        } else if (item === this.e) {
          if (!item.previous) {
            throw new Error("Invalid list");
          }
          item.previous.next = void 0;
          this.e = item.previous;
        } else {
          const next = item.next;
          const previous = item.previous;
          if (!next || !previous) {
            throw new Error("Invalid list");
          }
          next.previous = previous;
          previous.next = next;
        }
        item.next = void 0;
        item.previous = void 0;
        this.g++;
      }
      n(item, touch2) {
        if (!this.d || !this.e) {
          throw new Error("Invalid list");
        }
        if (touch2 !== 1 && touch2 !== 2) {
          return;
        }
        if (touch2 === 1) {
          if (item === this.d) {
            return;
          }
          const next = item.next;
          const previous = item.previous;
          if (item === this.e) {
            previous.next = void 0;
            this.e = previous;
          } else {
            next.previous = previous;
            previous.next = next;
          }
          item.previous = void 0;
          item.next = this.d;
          this.d.previous = item;
          this.d = item;
          this.g++;
        } else if (touch2 === 2) {
          if (item === this.e) {
            return;
          }
          const next = item.next;
          const previous = item.previous;
          if (item === this.d) {
            next.previous = void 0;
            this.d = next;
          } else {
            next.previous = previous;
            previous.next = next;
          }
          item.next = void 0;
          item.previous = this.e;
          this.e.next = item;
          this.e = item;
          this.g++;
        }
      }
      toJSON() {
        const data = [];
        this.forEach((value, key) => {
          data.push([key, value]);
        });
        return data;
      }
      fromJSON(data) {
        this.clear();
        for (const [key, value] of data) {
          this.set(key, value);
        }
      }
    };
    Cache = class extends $Hc {
      constructor(limit, ratio = 1) {
        super();
        this.o = limit;
        this.p = Math.min(Math.max(0, ratio), 1);
      }
      get limit() {
        return this.o;
      }
      set limit(limit) {
        this.o = limit;
        this.q();
      }
      get ratio() {
        return this.p;
      }
      set ratio(ratio) {
        this.p = Math.min(Math.max(0, ratio), 1);
        this.q();
      }
      get(key, touch2 = 2) {
        return super.get(key, touch2);
      }
      peek(key) {
        return super.get(
          key,
          0
          /* Touch.None */
        );
      }
      set(key, value) {
        super.set(
          key,
          value,
          2
          /* Touch.AsNew */
        );
        return this;
      }
      q() {
        if (this.size > this.o) {
          this.r(Math.round(this.o * this.p));
        }
      }
    };
    $Ic = class extends Cache {
      constructor(limit, ratio = 1) {
        super(limit, ratio);
      }
      r(newSize) {
        this.h(newSize);
      }
      set(key, value) {
        super.set(key, value);
        this.q();
        return this;
      }
    };
    $Mc = class {
      constructor() {
        this.c = /* @__PURE__ */ new Map();
      }
      add(key, value) {
        let values = this.c.get(key);
        if (!values) {
          values = /* @__PURE__ */ new Set();
          this.c.set(key, values);
        }
        values.add(value);
      }
      delete(key, value) {
        const values = this.c.get(key);
        if (!values) {
          return;
        }
        values.delete(value);
        if (values.size === 0) {
          this.c.delete(key);
        }
      }
      forEach(key, fn) {
        const values = this.c.get(key);
        if (!values) {
          return;
        }
        values.forEach(fn);
      }
      get(key) {
        const values = this.c.get(key);
        if (!values) {
          return /* @__PURE__ */ new Set();
        }
        return values;
      }
    };
  }
});

// out-build/vs/base/common/assert.js
function ok(value, message) {
  if (!value) {
    throw new Error(message ? `Assertion failed (${message})` : "Assertion Failed");
  }
}
function $Sc(condition, messageOrError = "unexpected state") {
  if (!condition) {
    const errorToThrow = typeof messageOrError === "string" ? new $vb(`Assertion Failed: ${messageOrError}`) : messageOrError;
    throw errorToThrow;
  }
}
var init_assert = __esm({
  "out-build/vs/base/common/assert.js"() {
    "use strict";
    init_errors();
  }
});

// out-build/vs/base/common/types.js
function $Wc(str) {
  return typeof str === "string";
}
function $Yc(obj) {
  return typeof obj === "object" && obj !== null && !Array.isArray(obj) && !(obj instanceof RegExp) && !(obj instanceof Date);
}
function $Zc(obj) {
  const TypedArray = Object.getPrototypeOf(Uint8Array);
  return typeof obj === "object" && obj instanceof TypedArray;
}
function $1c(obj) {
  return typeof obj === "number" && !isNaN(obj);
}
function $2c(obj) {
  return !!obj && typeof obj[Symbol.iterator] === "function";
}
function $3c(obj) {
  return obj === true || obj === false;
}
function $4c(obj) {
  return typeof obj === "undefined";
}
function $5c(arg) {
  return !$6c(arg);
}
function $6c(obj) {
  return $4c(obj) || obj === null;
}
function $8c(arg) {
  $Sc(arg !== null && arg !== void 0, "Argument is `undefined` or `null`.");
  return arg;
}
function $ad(obj) {
  if (!$Yc(obj)) {
    return false;
  }
  for (const key in obj) {
    if (hasOwnProperty.call(obj, key)) {
      return false;
    }
  }
  return true;
}
function $bd(obj) {
  return typeof obj === "function";
}
function $ed(arg, constraint) {
  if ($Wc(constraint)) {
    if (typeof arg !== constraint) {
      throw new Error(`argument does not match constraint: typeof ${constraint}`);
    }
  } else if ($bd(constraint)) {
    try {
      if (arg instanceof constraint) {
        return;
      }
    } catch {
    }
    if (!$6c(arg) && arg.constructor === constraint) {
      return;
    }
    if (constraint.length === 1 && constraint.call(void 0, arg) === true) {
      return;
    }
    throw new Error(`argument does not match one of these constraints: arg instanceof constraint, arg.constructor === constraint, nor constraint(arg) === true`);
  }
}
var hasOwnProperty;
var init_types = __esm({
  "out-build/vs/base/common/types.js"() {
    "use strict";
    init_assert();
    hasOwnProperty = Object.prototype.hasOwnProperty;
  }
});

// out-build/vs/base/common/iterator.js
var Iterable;
var init_iterator = __esm({
  "out-build/vs/base/common/iterator.js"() {
    "use strict";
    init_types();
    (function(Iterable2) {
      function is(thing) {
        return thing && typeof thing === "object" && typeof thing[Symbol.iterator] === "function";
      }
      Iterable2.is = is;
      const _empty2 = Object.freeze([]);
      function empty() {
        return _empty2;
      }
      Iterable2.empty = empty;
      function* single(element) {
        yield element;
      }
      Iterable2.single = single;
      function wrap(iterableOrElement) {
        if (is(iterableOrElement)) {
          return iterableOrElement;
        } else {
          return single(iterableOrElement);
        }
      }
      Iterable2.wrap = wrap;
      function from(iterable) {
        return iterable || _empty2;
      }
      Iterable2.from = from;
      function* reverse(array) {
        for (let i = array.length - 1; i >= 0; i--) {
          yield array[i];
        }
      }
      Iterable2.reverse = reverse;
      function isEmpty(iterable) {
        return !iterable || iterable[Symbol.iterator]().next().done === true;
      }
      Iterable2.isEmpty = isEmpty;
      function first(iterable) {
        return iterable[Symbol.iterator]().next().value;
      }
      Iterable2.first = first;
      function some(iterable, predicate) {
        let i = 0;
        for (const element of iterable) {
          if (predicate(element, i++)) {
            return true;
          }
        }
        return false;
      }
      Iterable2.some = some;
      function find(iterable, predicate) {
        for (const element of iterable) {
          if (predicate(element)) {
            return element;
          }
        }
        return void 0;
      }
      Iterable2.find = find;
      function* filter(iterable, predicate) {
        for (const element of iterable) {
          if (predicate(element)) {
            yield element;
          }
        }
      }
      Iterable2.filter = filter;
      function* map(iterable, fn) {
        let index = 0;
        for (const element of iterable) {
          yield fn(element, index++);
        }
      }
      Iterable2.map = map;
      function* flatMap(iterable, fn) {
        let index = 0;
        for (const element of iterable) {
          yield* fn(element, index++);
        }
      }
      Iterable2.flatMap = flatMap;
      function* concat(...iterables) {
        for (const item of iterables) {
          if ($2c(item)) {
            yield* item;
          } else {
            yield item;
          }
        }
      }
      Iterable2.concat = concat;
      function reduce(iterable, reducer, initialValue) {
        let value = initialValue;
        for (const element of iterable) {
          value = reducer(value, element);
        }
        return value;
      }
      Iterable2.reduce = reduce;
      function length(iterable) {
        let count = 0;
        for (const _ of iterable) {
          count++;
        }
        return count;
      }
      Iterable2.length = length;
      function* slice(arr, from2, to = arr.length) {
        if (from2 < -arr.length) {
          from2 = 0;
        }
        if (from2 < 0) {
          from2 += arr.length;
        }
        if (to < 0) {
          to += arr.length;
        } else if (to > arr.length) {
          to = arr.length;
        }
        for (; from2 < to; from2++) {
          yield arr[from2];
        }
      }
      Iterable2.slice = slice;
      function consume(iterable, atMost = Number.POSITIVE_INFINITY) {
        const consumed = [];
        if (atMost === 0) {
          return [consumed, iterable];
        }
        const iterator = iterable[Symbol.iterator]();
        for (let i = 0; i < atMost; i++) {
          const next = iterator.next();
          if (next.done) {
            return [consumed, Iterable2.empty()];
          }
          consumed.push(next.value);
        }
        return [consumed, { [Symbol.iterator]() {
          return iterator;
        } }];
      }
      Iterable2.consume = consume;
      async function asyncToArray(iterable) {
        const result = [];
        for await (const item of iterable) {
          result.push(item);
        }
        return Promise.resolve(result);
      }
      Iterable2.asyncToArray = asyncToArray;
    })(Iterable || (Iterable = {}));
  }
});

// out-build/vs/base/common/lifecycle.js
function $id(tracker) {
  disposableTracker = tracker;
}
function $jd(x) {
  disposableTracker?.trackDisposable(x);
  return x;
}
function $kd(disposable) {
  disposableTracker?.markAsDisposed(disposable);
}
function setParentOfDisposable(child, parent) {
  disposableTracker?.setParent(child, parent);
}
function setParentOfDisposables(children, parent) {
  if (!disposableTracker) {
    return;
  }
  for (const child of children) {
    disposableTracker.setParent(child, parent);
  }
}
function $md(thing) {
  return typeof thing === "object" && thing !== null && typeof thing.dispose === "function" && thing.dispose.length === 0;
}
function $nd(arg) {
  if (Iterable.is(arg)) {
    const errors = [];
    for (const d of arg) {
      if (d) {
        try {
          d.dispose();
        } catch (e) {
          errors.push(e);
        }
      }
    }
    if (errors.length === 1) {
      throw errors[0];
    } else if (errors.length > 1) {
      throw new AggregateError(errors, "Encountered errors while disposing of store");
    }
    return Array.isArray(arg) ? [] : arg;
  } else if (arg) {
    arg.dispose();
    return arg;
  }
}
function $pd(...disposables) {
  const parent = $qd(() => $nd(disposables));
  setParentOfDisposables(disposables, parent);
  return parent;
}
function $qd(fn) {
  const self2 = $jd({
    dispose: $Pc(() => {
      $kd(self2);
      fn();
    })
  });
  return self2;
}
var TRACK_DISPOSABLES, disposableTracker, $hd, $rd, $sd, $td, $Bd;
var init_lifecycle = __esm({
  "out-build/vs/base/common/lifecycle.js"() {
    "use strict";
    init_arrays();
    init_collections();
    init_map();
    init_functional();
    init_iterator();
    TRACK_DISPOSABLES = false;
    disposableTracker = null;
    $hd = class _$hd {
      constructor() {
        this.b = /* @__PURE__ */ new Map();
      }
      static {
        this.a = 0;
      }
      c(d) {
        let val = this.b.get(d);
        if (!val) {
          val = { parent: null, source: null, isSingleton: false, value: d, idx: _$hd.a++ };
          this.b.set(d, val);
        }
        return val;
      }
      trackDisposable(d) {
        const data = this.c(d);
        if (!data.source) {
          data.source = new Error().stack;
        }
      }
      setParent(child, parent) {
        const data = this.c(child);
        data.parent = parent;
      }
      markAsDisposed(x) {
        this.b.delete(x);
      }
      markAsSingleton(disposable) {
        this.c(disposable).isSingleton = true;
      }
      f(data, cache2) {
        const cacheValue = cache2.get(data);
        if (cacheValue) {
          return cacheValue;
        }
        const result = data.parent ? this.f(this.c(data.parent), cache2) : data;
        cache2.set(data, result);
        return result;
      }
      getTrackedDisposables() {
        const rootParentCache = /* @__PURE__ */ new Map();
        const leaking = [...this.b.entries()].filter(([, v]) => v.source !== null && !this.f(v, rootParentCache).isSingleton).flatMap(([k]) => k);
        return leaking;
      }
      computeLeakingDisposables(maxReported = 10, preComputedLeaks) {
        let uncoveredLeakingObjs;
        if (preComputedLeaks) {
          uncoveredLeakingObjs = preComputedLeaks;
        } else {
          const rootParentCache = /* @__PURE__ */ new Map();
          const leakingObjects = [...this.b.values()].filter((info) => info.source !== null && !this.f(info, rootParentCache).isSingleton);
          if (leakingObjects.length === 0) {
            return;
          }
          const leakingObjsSet = new Set(leakingObjects.map((o) => o.value));
          uncoveredLeakingObjs = leakingObjects.filter((l) => {
            return !(l.parent && leakingObjsSet.has(l.parent));
          });
          if (uncoveredLeakingObjs.length === 0) {
            throw new Error("There are cyclic diposable chains!");
          }
        }
        if (!uncoveredLeakingObjs) {
          return void 0;
        }
        function getStackTracePath(leaking) {
          function removePrefix(array, linesToRemove) {
            while (array.length > 0 && linesToRemove.some((regexp) => typeof regexp === "string" ? regexp === array[0] : array[0].match(regexp))) {
              array.shift();
            }
          }
          const lines = leaking.source.split("\n").map((p) => p.trim().replace("at ", "")).filter((l) => l !== "");
          removePrefix(lines, ["Error", /^trackDisposable \(.*\)$/, /^DisposableTracker.trackDisposable \(.*\)$/]);
          return lines.reverse();
        }
        const stackTraceStarts = new $Mc();
        for (const leaking of uncoveredLeakingObjs) {
          const stackTracePath = getStackTracePath(leaking);
          for (let i2 = 0; i2 <= stackTracePath.length; i2++) {
            stackTraceStarts.add(stackTracePath.slice(0, i2).join("\n"), leaking);
          }
        }
        uncoveredLeakingObjs.sort($9b((l) => l.idx, $$b));
        let message = "";
        let i = 0;
        for (const leaking of uncoveredLeakingObjs.slice(0, maxReported)) {
          i++;
          const stackTracePath = getStackTracePath(leaking);
          const stackTraceFormattedLines = [];
          for (let i2 = 0; i2 < stackTracePath.length; i2++) {
            let line = stackTracePath[i2];
            const starts = stackTraceStarts.get(stackTracePath.slice(0, i2 + 1).join("\n"));
            line = `(shared with ${starts.size}/${uncoveredLeakingObjs.length} leaks) at ${line}`;
            const prevStarts = stackTraceStarts.get(stackTracePath.slice(0, i2).join("\n"));
            const continuations = $a([...prevStarts].map((d) => getStackTracePath(d)[i2]), (v) => v);
            delete continuations[stackTracePath[i2]];
            for (const [cont, set] of Object.entries(continuations)) {
              stackTraceFormattedLines.unshift(`    - stacktraces of ${set.length} other leaks continue with ${cont}`);
            }
            stackTraceFormattedLines.unshift(line);
          }
          message += `


==================== Leaking disposable ${i}/${uncoveredLeakingObjs.length}: ${leaking.value.constructor.name} ====================
${stackTraceFormattedLines.join("\n")}
============================================================

`;
        }
        if (uncoveredLeakingObjs.length > maxReported) {
          message += `


... and ${uncoveredLeakingObjs.length - maxReported} more leaking disposables

`;
        }
        return { leaks: uncoveredLeakingObjs, details: message };
      }
    };
    if (TRACK_DISPOSABLES) {
      const __is_disposable_tracked__ = "__is_disposable_tracked__";
      $id(new class {
        trackDisposable(x) {
          const stack = new Error("Potentially leaked disposable").stack;
          setTimeout(() => {
            if (!x[__is_disposable_tracked__]) {
              console.log(stack);
            }
          }, 3e3);
        }
        setParent(child, parent) {
          if (child && child !== $sd.None) {
            try {
              child[__is_disposable_tracked__] = true;
            } catch {
            }
          }
        }
        markAsDisposed(disposable) {
          if (disposable && disposable !== $sd.None) {
            try {
              disposable[__is_disposable_tracked__] = true;
            } catch {
            }
          }
        }
        markAsSingleton(disposable) {
        }
      }());
    }
    $rd = class _$rd {
      static {
        this.DISABLE_DISPOSED_WARNING = false;
      }
      constructor() {
        this.f = /* @__PURE__ */ new Set();
        this.g = false;
        $jd(this);
      }
      /**
       * Dispose of all registered disposables and mark this object as disposed.
       *
       * Any future disposables added to this object will be disposed of on `add`.
       */
      dispose() {
        if (this.g) {
          return;
        }
        $kd(this);
        this.g = true;
        this.clear();
      }
      /**
       * @return `true` if this object has been disposed of.
       */
      get isDisposed() {
        return this.g;
      }
      /**
       * Dispose of all registered disposables but do not mark this object as disposed.
       */
      clear() {
        if (this.f.size === 0) {
          return;
        }
        try {
          $nd(this.f);
        } finally {
          this.f.clear();
        }
      }
      /**
       * Add a new {@link IDisposable disposable} to the collection.
       */
      add(o) {
        if (!o) {
          return o;
        }
        if (o === this) {
          throw new Error("Cannot register a disposable on itself!");
        }
        setParentOfDisposable(o, this);
        if (this.g) {
          if (!_$rd.DISABLE_DISPOSED_WARNING) {
            console.warn(new Error("Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!").stack);
          }
        } else {
          this.f.add(o);
        }
        return o;
      }
      /**
       * Deletes a disposable from store and disposes of it. This will not throw or warn and proceed to dispose the
       * disposable even when the disposable is not part in the store.
       */
      delete(o) {
        if (!o) {
          return;
        }
        if (o === this) {
          throw new Error("Cannot dispose a disposable on itself!");
        }
        this.f.delete(o);
        o.dispose();
      }
      /**
       * Deletes the value from the store, but does not dispose it.
       */
      deleteAndLeak(o) {
        if (!o) {
          return;
        }
        if (this.f.has(o)) {
          this.f.delete(o);
          setParentOfDisposable(o, null);
        }
      }
    };
    $sd = class {
      static {
        this.None = Object.freeze({ dispose() {
        } });
      }
      constructor() {
        this.q = new $rd();
        $jd(this);
        setParentOfDisposable(this.q, this);
      }
      dispose() {
        $kd(this);
        this.q.dispose();
      }
      /**
       * Adds `o` to the collection of disposables managed by this object.
       */
      B(o) {
        if (o === this) {
          throw new Error("Cannot register a disposable on itself!");
        }
        return this.q.add(o);
      }
    };
    $td = class {
      constructor() {
        this.b = false;
        $jd(this);
      }
      get value() {
        return this.b ? void 0 : this.a;
      }
      set value(value) {
        if (this.b || value === this.a) {
          return;
        }
        this.a?.dispose();
        if (value) {
          setParentOfDisposable(value, this);
        }
        this.a = value;
      }
      /**
       * Resets the stored value and disposed of the previously stored value.
       */
      clear() {
        this.value = void 0;
      }
      dispose() {
        this.b = true;
        $kd(this);
        this.a?.dispose();
        this.a = void 0;
      }
      /**
       * Clears the value, but does not dispose it.
       * The old value is returned.
      */
      clearAndLeak() {
        const oldValue = this.a;
        this.a = void 0;
        if (oldValue) {
          setParentOfDisposable(oldValue, null);
        }
        return oldValue;
      }
    };
    $Bd = class {
      constructor() {
        this.a = /* @__PURE__ */ new Map();
        this.b = false;
        $jd(this);
      }
      /**
       * Disposes of all stored values and mark this object as disposed.
       *
       * Trying to use this object after it has been disposed of is an error.
       */
      dispose() {
        $kd(this);
        this.b = true;
        this.clearAndDisposeAll();
      }
      /**
       * Disposes of all stored values and clear the map, but DO NOT mark this object as disposed.
       */
      clearAndDisposeAll() {
        if (!this.a.size) {
          return;
        }
        try {
          $nd(this.a.values());
        } finally {
          this.a.clear();
        }
      }
      has(key) {
        return this.a.has(key);
      }
      get size() {
        return this.a.size;
      }
      get(key) {
        return this.a.get(key);
      }
      set(key, value, skipDisposeOnOverwrite = false) {
        if (this.b) {
          console.warn(new Error("Trying to add a disposable to a DisposableMap that has already been disposed of. The added object will be leaked!").stack);
        }
        if (!skipDisposeOnOverwrite) {
          this.a.get(key)?.dispose();
        }
        this.a.set(key, value);
      }
      /**
       * Delete the value stored for `key` from this map and also dispose of it.
       */
      deleteAndDispose(key) {
        this.a.get(key)?.dispose();
        this.a.delete(key);
      }
      /**
       * Delete the value stored for `key` from this map but return it. The caller is
       * responsible for disposing of the value.
       */
      deleteAndLeak(key) {
        const value = this.a.get(key);
        this.a.delete(key);
        return value;
      }
      keys() {
        return this.a.keys();
      }
      values() {
        return this.a.values();
      }
      [Symbol.iterator]() {
        return this.a[Symbol.iterator]();
      }
    };
  }
});

// out-build/vs/base/common/linkedList.js
var Node, $Fd;
var init_linkedList = __esm({
  "out-build/vs/base/common/linkedList.js"() {
    "use strict";
    Node = class _Node {
      static {
        this.Undefined = new _Node(void 0);
      }
      constructor(element) {
        this.element = element;
        this.next = _Node.Undefined;
        this.prev = _Node.Undefined;
      }
    };
    $Fd = class {
      constructor() {
        this.a = Node.Undefined;
        this.b = Node.Undefined;
        this.c = 0;
      }
      get size() {
        return this.c;
      }
      isEmpty() {
        return this.a === Node.Undefined;
      }
      clear() {
        let node = this.a;
        while (node !== Node.Undefined) {
          const next = node.next;
          node.prev = Node.Undefined;
          node.next = Node.Undefined;
          node = next;
        }
        this.a = Node.Undefined;
        this.b = Node.Undefined;
        this.c = 0;
      }
      unshift(element) {
        return this.d(element, false);
      }
      push(element) {
        return this.d(element, true);
      }
      d(element, atTheEnd) {
        const newNode = new Node(element);
        if (this.a === Node.Undefined) {
          this.a = newNode;
          this.b = newNode;
        } else if (atTheEnd) {
          const oldLast = this.b;
          this.b = newNode;
          newNode.prev = oldLast;
          oldLast.next = newNode;
        } else {
          const oldFirst = this.a;
          this.a = newNode;
          newNode.next = oldFirst;
          oldFirst.prev = newNode;
        }
        this.c += 1;
        let didRemove = false;
        return () => {
          if (!didRemove) {
            didRemove = true;
            this.e(newNode);
          }
        };
      }
      shift() {
        if (this.a === Node.Undefined) {
          return void 0;
        } else {
          const res = this.a.element;
          this.e(this.a);
          return res;
        }
      }
      pop() {
        if (this.b === Node.Undefined) {
          return void 0;
        } else {
          const res = this.b.element;
          this.e(this.b);
          return res;
        }
      }
      e(node) {
        if (node.prev !== Node.Undefined && node.next !== Node.Undefined) {
          const anchor = node.prev;
          anchor.next = node.next;
          node.next.prev = anchor;
        } else if (node.prev === Node.Undefined && node.next === Node.Undefined) {
          this.a = Node.Undefined;
          this.b = Node.Undefined;
        } else if (node.next === Node.Undefined) {
          this.b = this.b.prev;
          this.b.next = Node.Undefined;
        } else if (node.prev === Node.Undefined) {
          this.a = this.a.next;
          this.a.prev = Node.Undefined;
        }
        this.c -= 1;
      }
      *[Symbol.iterator]() {
        let node = this.a;
        while (node !== Node.Undefined) {
          yield node.element;
          node = node.next;
        }
      }
    };
  }
});

// out-build/vs/base/common/stopwatch.js
var hasPerformanceNow, $4e;
var init_stopwatch = __esm({
  "out-build/vs/base/common/stopwatch.js"() {
    "use strict";
    hasPerformanceNow = globalThis.performance && typeof globalThis.performance.now === "function";
    $4e = class _$4e {
      static create(highResolution) {
        return new _$4e(highResolution);
      }
      constructor(highResolution) {
        this.c = hasPerformanceNow && highResolution === false ? Date.now : globalThis.performance.now.bind(globalThis.performance);
        this.a = this.c();
        this.b = -1;
      }
      stop() {
        this.b = this.c();
      }
      reset() {
        this.a = this.c();
        this.b = -1;
      }
      elapsed() {
        if (this.b !== -1) {
          return this.b - this.a;
        }
        return this.c() - this.a;
      }
    };
  }
});

// out-build/vs/base/common/event.js
var _enableDisposeWithListenerWarning, _enableSnapshotPotentialLeakWarning, Event, $6e, _globalLeakWarningThreshold, LeakageMonitor, Stacktrace, $8e, $9e, id, UniqueContainer, compactionThreshold, forEachListener, $0e, EventDeliveryQueuePrivate, $af, $df, $gf;
var init_event = __esm({
  "out-build/vs/base/common/event.js"() {
    "use strict";
    init_collections();
    init_errors();
    init_functional();
    init_lifecycle();
    init_linkedList();
    init_stopwatch();
    _enableDisposeWithListenerWarning = false;
    _enableSnapshotPotentialLeakWarning = false;
    (function(Event2) {
      Event2.None = () => $sd.None;
      function _addLeakageTraceLogic(options2) {
        if (_enableSnapshotPotentialLeakWarning) {
          const { onDidAddListener: origListenerDidAdd } = options2;
          const stack = Stacktrace.create();
          let count = 0;
          options2.onDidAddListener = () => {
            if (++count === 2) {
              console.warn("snapshotted emitter LIKELY used public and SHOULD HAVE BEEN created with DisposableStore. snapshotted here");
              stack.print();
            }
            origListenerDidAdd?.();
          };
        }
      }
      function defer(event, disposable) {
        return debounce(event, () => void 0, 0, void 0, true, void 0, disposable);
      }
      Event2.defer = defer;
      function once(event) {
        return (listener, thisArgs = null, disposables) => {
          let didFire = false;
          let result = void 0;
          result = event((e) => {
            if (didFire) {
              return;
            } else if (result) {
              result.dispose();
            } else {
              didFire = true;
            }
            return listener.call(thisArgs, e);
          }, null, disposables);
          if (didFire) {
            result.dispose();
          }
          return result;
        };
      }
      Event2.once = once;
      function onceIf(event, condition) {
        return Event2.once(Event2.filter(event, condition));
      }
      Event2.onceIf = onceIf;
      function map(event, map2, disposable) {
        return snapshot((listener, thisArgs = null, disposables) => event((i) => listener.call(thisArgs, map2(i)), null, disposables), disposable);
      }
      Event2.map = map;
      function forEach(event, each, disposable) {
        return snapshot((listener, thisArgs = null, disposables) => event((i) => {
          each(i);
          listener.call(thisArgs, i);
        }, null, disposables), disposable);
      }
      Event2.forEach = forEach;
      function filter(event, filter2, disposable) {
        return snapshot((listener, thisArgs = null, disposables) => event((e) => filter2(e) && listener.call(thisArgs, e), null, disposables), disposable);
      }
      Event2.filter = filter;
      function signal(event) {
        return event;
      }
      Event2.signal = signal;
      function any(...events) {
        return (listener, thisArgs = null, disposables) => {
          const disposable = $pd(...events.map((event) => event((e) => listener.call(thisArgs, e))));
          return addAndReturnDisposable(disposable, disposables);
        };
      }
      Event2.any = any;
      function reduce(event, merge, initial, disposable) {
        let output = initial;
        return map(event, (e) => {
          output = merge(output, e);
          return output;
        }, disposable);
      }
      Event2.reduce = reduce;
      function snapshot(event, disposable) {
        let listener;
        const options2 = {
          onWillAddFirstListener() {
            listener = event(emitter.fire, emitter);
          },
          onDidRemoveLastListener() {
            listener?.dispose();
          }
        };
        if (!disposable) {
          _addLeakageTraceLogic(options2);
        }
        const emitter = new $0e(options2);
        disposable?.add(emitter);
        return emitter.event;
      }
      function addAndReturnDisposable(d, store) {
        if (store instanceof Array) {
          store.push(d);
        } else if (store) {
          store.add(d);
        }
        return d;
      }
      function debounce(event, merge, delay = 100, leading = false, flushOnListenerRemove = false, leakWarningThreshold, disposable) {
        let subscription;
        let output = void 0;
        let handle = void 0;
        let numDebouncedCalls = 0;
        let doFire;
        const options2 = {
          leakWarningThreshold,
          onWillAddFirstListener() {
            subscription = event((cur) => {
              numDebouncedCalls++;
              output = merge(output, cur);
              if (leading && !handle) {
                emitter.fire(output);
                output = void 0;
              }
              doFire = () => {
                const _output = output;
                output = void 0;
                handle = void 0;
                if (!leading || numDebouncedCalls > 1) {
                  emitter.fire(_output);
                }
                numDebouncedCalls = 0;
              };
              if (typeof delay === "number") {
                clearTimeout(handle);
                handle = setTimeout(doFire, delay);
              } else {
                if (handle === void 0) {
                  handle = 0;
                  queueMicrotask(doFire);
                }
              }
            });
          },
          onWillRemoveListener() {
            if (flushOnListenerRemove && numDebouncedCalls > 0) {
              doFire?.();
            }
          },
          onDidRemoveLastListener() {
            doFire = void 0;
            subscription.dispose();
          }
        };
        if (!disposable) {
          _addLeakageTraceLogic(options2);
        }
        const emitter = new $0e(options2);
        disposable?.add(emitter);
        return emitter.event;
      }
      Event2.debounce = debounce;
      function accumulate(event, delay = 0, disposable) {
        return Event2.debounce(event, (last, e) => {
          if (!last) {
            return [e];
          }
          last.push(e);
          return last;
        }, delay, void 0, true, void 0, disposable);
      }
      Event2.accumulate = accumulate;
      function latch(event, equals = (a, b) => a === b, disposable) {
        let firstCall = true;
        let cache2;
        return filter(event, (value) => {
          const shouldEmit = firstCall || !equals(value, cache2);
          firstCall = false;
          cache2 = value;
          return shouldEmit;
        }, disposable);
      }
      Event2.latch = latch;
      function split(event, isT, disposable) {
        return [
          Event2.filter(event, isT, disposable),
          Event2.filter(event, (e) => !isT(e), disposable)
        ];
      }
      Event2.split = split;
      function buffer(event, flushAfterTimeout = false, _buffer = [], disposable) {
        let buffer2 = _buffer.slice();
        let listener = event((e) => {
          if (buffer2) {
            buffer2.push(e);
          } else {
            emitter.fire(e);
          }
        });
        if (disposable) {
          disposable.add(listener);
        }
        const flush = () => {
          buffer2?.forEach((e) => emitter.fire(e));
          buffer2 = null;
        };
        const emitter = new $0e({
          onWillAddFirstListener() {
            if (!listener) {
              listener = event((e) => emitter.fire(e));
              if (disposable) {
                disposable.add(listener);
              }
            }
          },
          onDidAddFirstListener() {
            if (buffer2) {
              if (flushAfterTimeout) {
                setTimeout(flush);
              } else {
                flush();
              }
            }
          },
          onDidRemoveLastListener() {
            if (listener) {
              listener.dispose();
            }
            listener = null;
          }
        });
        if (disposable) {
          disposable.add(emitter);
        }
        return emitter.event;
      }
      Event2.buffer = buffer;
      function chain(event, sythensize) {
        const fn = (listener, thisArgs, disposables) => {
          const cs = sythensize(new ChainableSynthesis());
          return event(function(value) {
            const result = cs.evaluate(value);
            if (result !== HaltChainable) {
              listener.call(thisArgs, result);
            }
          }, void 0, disposables);
        };
        return fn;
      }
      Event2.chain = chain;
      const HaltChainable = Symbol("HaltChainable");
      class ChainableSynthesis {
        constructor() {
          this.f = [];
        }
        map(fn) {
          this.f.push(fn);
          return this;
        }
        forEach(fn) {
          this.f.push((v) => {
            fn(v);
            return v;
          });
          return this;
        }
        filter(fn) {
          this.f.push((v) => fn(v) ? v : HaltChainable);
          return this;
        }
        reduce(merge, initial) {
          let last = initial;
          this.f.push((v) => {
            last = merge(last, v);
            return last;
          });
          return this;
        }
        latch(equals = (a, b) => a === b) {
          let firstCall = true;
          let cache2;
          this.f.push((value) => {
            const shouldEmit = firstCall || !equals(value, cache2);
            firstCall = false;
            cache2 = value;
            return shouldEmit ? value : HaltChainable;
          });
          return this;
        }
        evaluate(value) {
          for (const step of this.f) {
            value = step(value);
            if (value === HaltChainable) {
              break;
            }
          }
          return value;
        }
      }
      function fromNodeEventEmitter(emitter, eventName, map2 = (id2) => id2) {
        const fn = (...args) => result.fire(map2(...args));
        const onFirstListenerAdd = () => emitter.on(eventName, fn);
        const onLastListenerRemove = () => emitter.removeListener(eventName, fn);
        const result = new $0e({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
        return result.event;
      }
      Event2.fromNodeEventEmitter = fromNodeEventEmitter;
      function fromDOMEventEmitter(emitter, eventName, map2 = (id2) => id2) {
        const fn = (...args) => result.fire(map2(...args));
        const onFirstListenerAdd = () => emitter.addEventListener(eventName, fn);
        const onLastListenerRemove = () => emitter.removeEventListener(eventName, fn);
        const result = new $0e({ onWillAddFirstListener: onFirstListenerAdd, onDidRemoveLastListener: onLastListenerRemove });
        return result.event;
      }
      Event2.fromDOMEventEmitter = fromDOMEventEmitter;
      function toPromise(event, disposables) {
        return new Promise((resolve4) => once(event)(resolve4, null, disposables));
      }
      Event2.toPromise = toPromise;
      function fromPromise(promise) {
        const result = new $0e();
        promise.then((res) => {
          result.fire(res);
        }, () => {
          result.fire(void 0);
        }).finally(() => {
          result.dispose();
        });
        return result.event;
      }
      Event2.fromPromise = fromPromise;
      function forward(from, to) {
        return from((e) => to.fire(e));
      }
      Event2.forward = forward;
      function runAndSubscribe(event, handler, initial) {
        handler(initial);
        return event((e) => handler(e));
      }
      Event2.runAndSubscribe = runAndSubscribe;
      class EmitterObserver {
        constructor(_observable, store) {
          this._observable = _observable;
          this.f = 0;
          this.g = false;
          const options2 = {
            onWillAddFirstListener: () => {
              _observable.addObserver(this);
              this._observable.reportChanges();
            },
            onDidRemoveLastListener: () => {
              _observable.removeObserver(this);
            }
          };
          if (!store) {
            _addLeakageTraceLogic(options2);
          }
          this.emitter = new $0e(options2);
          if (store) {
            store.add(this.emitter);
          }
        }
        beginUpdate(_observable) {
          this.f++;
        }
        handlePossibleChange(_observable) {
        }
        handleChange(_observable, _change) {
          this.g = true;
        }
        endUpdate(_observable) {
          this.f--;
          if (this.f === 0) {
            this._observable.reportChanges();
            if (this.g) {
              this.g = false;
              this.emitter.fire(this._observable.get());
            }
          }
        }
      }
      function fromObservable(obs, store) {
        const observer = new EmitterObserver(obs, store);
        return observer.emitter.event;
      }
      Event2.fromObservable = fromObservable;
      function fromObservableLight(observable) {
        return (listener, thisArgs, disposables) => {
          let count = 0;
          let didChange = false;
          const observer = {
            beginUpdate() {
              count++;
            },
            endUpdate() {
              count--;
              if (count === 0) {
                observable.reportChanges();
                if (didChange) {
                  didChange = false;
                  listener.call(thisArgs);
                }
              }
            },
            handlePossibleChange() {
            },
            handleChange() {
              didChange = true;
            }
          };
          observable.addObserver(observer);
          observable.reportChanges();
          const disposable = {
            dispose() {
              observable.removeObserver(observer);
            }
          };
          if (disposables instanceof $rd) {
            disposables.add(disposable);
          } else if (Array.isArray(disposables)) {
            disposables.push(disposable);
          }
          return disposable;
        };
      }
      Event2.fromObservableLight = fromObservableLight;
    })(Event || (Event = {}));
    $6e = class _$6e {
      static {
        this.all = /* @__PURE__ */ new Set();
      }
      static {
        this.f = 0;
      }
      constructor(name) {
        this.listenerCount = 0;
        this.invocationCount = 0;
        this.elapsedOverall = 0;
        this.durations = [];
        this.name = `${name}_${_$6e.f++}`;
        _$6e.all.add(this);
      }
      start(listenerCount) {
        this.g = new $4e();
        this.listenerCount = listenerCount;
      }
      stop() {
        if (this.g) {
          const elapsed = this.g.elapsed();
          this.durations.push(elapsed);
          this.elapsedOverall += elapsed;
          this.invocationCount += 1;
          this.g = void 0;
        }
      }
    };
    _globalLeakWarningThreshold = -1;
    LeakageMonitor = class _LeakageMonitor {
      static {
        this.f = 1;
      }
      constructor(j, threshold, name = (_LeakageMonitor.f++).toString(16).padStart(3, "0")) {
        this.j = j;
        this.threshold = threshold;
        this.name = name;
        this.h = 0;
      }
      dispose() {
        this.g?.clear();
      }
      check(stack, listenerCount) {
        const threshold = this.threshold;
        if (threshold <= 0 || listenerCount < threshold) {
          return void 0;
        }
        if (!this.g) {
          this.g = /* @__PURE__ */ new Map();
        }
        const count = this.g.get(stack.value) || 0;
        this.g.set(stack.value, count + 1);
        this.h -= 1;
        if (this.h <= 0) {
          this.h = threshold * 0.5;
          const [topStack, topCount] = this.getMostFrequentStack();
          const message = `[${this.name}] potential listener LEAK detected, having ${listenerCount} listeners already. MOST frequent listener (${topCount}):`;
          console.warn(message);
          console.warn(topStack);
          const error = new $8e(message, topStack);
          this.j(error);
        }
        return () => {
          const count2 = this.g.get(stack.value) || 0;
          this.g.set(stack.value, count2 - 1);
        };
      }
      getMostFrequentStack() {
        if (!this.g) {
          return void 0;
        }
        let topStack;
        let topCount = 0;
        for (const [stack, count] of this.g) {
          if (!topStack || topCount < count) {
            topStack = [stack, count];
            topCount = count;
          }
        }
        return topStack;
      }
    };
    Stacktrace = class _Stacktrace {
      static create() {
        const err = new Error();
        return new _Stacktrace(err.stack ?? "");
      }
      constructor(value) {
        this.value = value;
      }
      print() {
        console.warn(this.value.split("\n").slice(2).join("\n"));
      }
    };
    $8e = class extends Error {
      constructor(message, stack) {
        super(message);
        this.name = "ListenerLeakError";
        this.stack = stack;
      }
    };
    $9e = class extends Error {
      constructor(message, stack) {
        super(message);
        this.name = "ListenerRefusalError";
        this.stack = stack;
      }
    };
    id = 0;
    UniqueContainer = class {
      constructor(value) {
        this.value = value;
        this.id = id++;
      }
    };
    compactionThreshold = 2;
    forEachListener = (listeners, fn) => {
      if (listeners instanceof UniqueContainer) {
        fn(listeners);
      } else {
        for (let i = 0; i < listeners.length; i++) {
          const l = listeners[i];
          if (l) {
            fn(l);
          }
        }
      }
    };
    $0e = class {
      constructor(options2) {
        this.z = 0;
        this.f = options2;
        this.g = _globalLeakWarningThreshold > 0 || this.f?.leakWarningThreshold ? new LeakageMonitor(options2?.onListenerError ?? $gb, this.f?.leakWarningThreshold ?? _globalLeakWarningThreshold) : void 0;
        this.j = this.f?._profName ? new $6e(this.f._profName) : void 0;
        this.w = this.f?.deliveryQueue;
      }
      dispose() {
        if (!this.m) {
          this.m = true;
          if (this.w?.current === this) {
            this.w.reset();
          }
          if (this.u) {
            if (_enableDisposeWithListenerWarning) {
              const listeners = this.u;
              queueMicrotask(() => {
                forEachListener(listeners, (l) => l.stack?.print());
              });
            }
            this.u = void 0;
            this.z = 0;
          }
          this.f?.onDidRemoveLastListener?.();
          this.g?.dispose();
        }
      }
      /**
       * For the public to allow to subscribe
       * to events from this Emitter
       */
      get event() {
        this.q ??= (callback, thisArgs, disposables) => {
          if (this.g && this.z > this.g.threshold ** 2) {
            const message = `[${this.g.name}] REFUSES to accept new listeners because it exceeded its threshold by far (${this.z} vs ${this.g.threshold})`;
            console.warn(message);
            const tuple = this.g.getMostFrequentStack() ?? ["UNKNOWN stack", -1];
            const error = new $9e(`${message}. HINT: Stack shows most frequent listener (${tuple[1]}-times)`, tuple[0]);
            const errorHandler = this.f?.onListenerError || $gb;
            errorHandler(error);
            return $sd.None;
          }
          if (this.m) {
            return $sd.None;
          }
          if (thisArgs) {
            callback = callback.bind(thisArgs);
          }
          const contained = new UniqueContainer(callback);
          let removeMonitor;
          let stack;
          if (this.g && this.z >= Math.ceil(this.g.threshold * 0.2)) {
            contained.stack = Stacktrace.create();
            removeMonitor = this.g.check(contained.stack, this.z + 1);
          }
          if (_enableDisposeWithListenerWarning) {
            contained.stack = stack ?? Stacktrace.create();
          }
          if (!this.u) {
            this.f?.onWillAddFirstListener?.(this);
            this.u = contained;
            this.f?.onDidAddFirstListener?.(this);
          } else if (this.u instanceof UniqueContainer) {
            this.w ??= new EventDeliveryQueuePrivate();
            this.u = [this.u, contained];
          } else {
            this.u.push(contained);
          }
          this.f?.onDidAddListener?.(this);
          this.z++;
          const result = $qd(() => {
            removeMonitor?.();
            this.A(contained);
          });
          if (disposables instanceof $rd) {
            disposables.add(result);
          } else if (Array.isArray(disposables)) {
            disposables.push(result);
          }
          return result;
        };
        return this.q;
      }
      A(listener) {
        this.f?.onWillRemoveListener?.(this);
        if (!this.u) {
          return;
        }
        if (this.z === 1) {
          this.u = void 0;
          this.f?.onDidRemoveLastListener?.(this);
          this.z = 0;
          return;
        }
        const listeners = this.u;
        const index = listeners.indexOf(listener);
        if (index === -1) {
          console.log("disposed?", this.m);
          console.log("size?", this.z);
          console.log("arr?", JSON.stringify(this.u));
          throw new Error("Attempted to dispose unknown listener");
        }
        this.z--;
        listeners[index] = void 0;
        const adjustDeliveryQueue = this.w.current === this;
        if (this.z * compactionThreshold <= listeners.length) {
          let n = 0;
          for (let i = 0; i < listeners.length; i++) {
            if (listeners[i]) {
              listeners[n++] = listeners[i];
            } else if (adjustDeliveryQueue && n < this.w.end) {
              this.w.end--;
              if (n < this.w.i) {
                this.w.i--;
              }
            }
          }
          listeners.length = n;
        }
      }
      B(listener, value) {
        if (!listener) {
          return;
        }
        const errorHandler = this.f?.onListenerError || $gb;
        if (!errorHandler) {
          listener.value(value);
          return;
        }
        try {
          listener.value(value);
        } catch (e) {
          errorHandler(e);
        }
      }
      /** Delivers items in the queue. Assumes the queue is ready to go. */
      C(dq) {
        const listeners = dq.current.u;
        while (dq.i < dq.end) {
          this.B(listeners[dq.i++], dq.value);
        }
        dq.reset();
      }
      /**
       * To be kept private to fire an event to
       * subscribers
       */
      fire(event) {
        if (this.w?.current) {
          this.C(this.w);
          this.j?.stop();
        }
        this.j?.start(this.z);
        if (!this.u) {
        } else if (this.u instanceof UniqueContainer) {
          this.B(this.u, event);
        } else {
          const dq = this.w;
          dq.enqueue(this, event, this.u.length);
          this.C(dq);
        }
        this.j?.stop();
      }
      hasListeners() {
        return this.z > 0;
      }
    };
    EventDeliveryQueuePrivate = class {
      constructor() {
        this.i = -1;
        this.end = 0;
      }
      enqueue(emitter, value, end) {
        this.i = 0;
        this.end = end;
        this.current = emitter;
        this.value = value;
      }
      reset() {
        this.i = this.end;
        this.current = void 0;
        this.value = void 0;
      }
    };
    $af = class extends $0e {
      get isPaused() {
        return this.h !== 0;
      }
      constructor(options2) {
        super(options2);
        this.h = 0;
        this.s = new $Fd();
        this.t = options2?.merge;
      }
      pause() {
        this.h++;
      }
      resume() {
        if (this.h !== 0 && --this.h === 0) {
          if (this.t) {
            if (this.s.size > 0) {
              const events = Array.from(this.s);
              this.s.clear();
              super.fire(this.t(events));
            }
          } else {
            while (!this.h && this.s.size !== 0) {
              super.fire(this.s.shift());
            }
          }
        }
      }
      fire(event) {
        if (this.z) {
          if (this.h !== 0) {
            this.s.push(event);
          } else {
            super.fire(event);
          }
        }
      }
    };
    $df = class {
      constructor() {
        this.g = false;
        this.h = [];
        this.f = new $0e({
          onWillAddFirstListener: () => this.j(),
          onDidRemoveLastListener: () => this.k()
        });
      }
      get event() {
        return this.f.event;
      }
      add(event) {
        const e = { event, listener: null };
        this.h.push(e);
        if (this.g) {
          this.m(e);
        }
        const dispose2 = () => {
          if (this.g) {
            this.o(e);
          }
          const idx = this.h.indexOf(e);
          this.h.splice(idx, 1);
        };
        return $qd($Pc(dispose2));
      }
      j() {
        this.g = true;
        this.h.forEach((e) => this.m(e));
      }
      k() {
        this.g = false;
        this.h.forEach((e) => this.o(e));
      }
      m(e) {
        e.listener = e.event((r) => this.f.fire(r));
      }
      o(e) {
        e.listener?.dispose();
        e.listener = null;
      }
      dispose() {
        this.f.dispose();
        for (const e of this.h) {
          e.listener?.dispose();
        }
        this.h = [];
      }
    };
    $gf = class {
      constructor() {
        this.f = false;
        this.g = Event.None;
        this.h = $sd.None;
        this.j = new $0e({
          onDidAddFirstListener: () => {
            this.f = true;
            this.h = this.g(this.j.fire, this.j);
          },
          onDidRemoveLastListener: () => {
            this.f = false;
            this.h.dispose();
          }
        });
        this.event = this.j.event;
      }
      set input(event) {
        this.g = event;
        if (this.f) {
          this.h.dispose();
          this.h = event(this.j.fire, this.j);
        }
      }
      dispose() {
        this.h.dispose();
        this.j.dispose();
      }
    };
  }
});

// out-build/vs/base/common/cancellation.js
var shortcutEvent, CancellationToken, MutableToken, $Dd;
var init_cancellation = __esm({
  "out-build/vs/base/common/cancellation.js"() {
    "use strict";
    init_event();
    shortcutEvent = Object.freeze(function(callback, context) {
      const handle = setTimeout(callback.bind(context), 0);
      return { dispose() {
        clearTimeout(handle);
      } };
    });
    (function(CancellationToken2) {
      function isCancellationToken(thing) {
        if (thing === CancellationToken2.None || thing === CancellationToken2.Cancelled) {
          return true;
        }
        if (thing instanceof MutableToken) {
          return true;
        }
        if (!thing || typeof thing !== "object") {
          return false;
        }
        return typeof thing.isCancellationRequested === "boolean" && typeof thing.onCancellationRequested === "function";
      }
      CancellationToken2.isCancellationToken = isCancellationToken;
      CancellationToken2.None = Object.freeze({
        isCancellationRequested: false,
        onCancellationRequested: Event.None
      });
      CancellationToken2.Cancelled = Object.freeze({
        isCancellationRequested: true,
        onCancellationRequested: shortcutEvent
      });
    })(CancellationToken || (CancellationToken = {}));
    MutableToken = class {
      constructor() {
        this.a = false;
        this.b = null;
      }
      cancel() {
        if (!this.a) {
          this.a = true;
          if (this.b) {
            this.b.fire(void 0);
            this.dispose();
          }
        }
      }
      get isCancellationRequested() {
        return this.a;
      }
      get onCancellationRequested() {
        if (this.a) {
          return shortcutEvent;
        }
        if (!this.b) {
          this.b = new $0e();
        }
        return this.b.event;
      }
      dispose() {
        if (this.b) {
          this.b.dispose();
          this.b = null;
        }
      }
    };
    $Dd = class {
      constructor(parent) {
        this.f = void 0;
        this.g = void 0;
        this.g = parent && parent.onCancellationRequested(this.cancel, this);
      }
      get token() {
        if (!this.f) {
          this.f = new MutableToken();
        }
        return this.f;
      }
      cancel() {
        if (!this.f) {
          this.f = CancellationToken.Cancelled;
        } else if (this.f instanceof MutableToken) {
          this.f.cancel();
        }
      }
      dispose(cancel = false) {
        if (cancel) {
          this.cancel();
        }
        this.g?.dispose();
        if (!this.f) {
          this.f = CancellationToken.None;
        } else if (this.f instanceof MutableToken) {
          this.f.dispose();
        }
      }
    };
  }
});

// out-build/vs/base/common/cache.js
function $Zf(t) {
  return t;
}
var $1f;
var init_cache = __esm({
  "out-build/vs/base/common/cache.js"() {
    "use strict";
    init_cancellation();
    $1f = class {
      constructor(arg1, arg2) {
        this.a = void 0;
        this.b = void 0;
        if (typeof arg1 === "function") {
          this.c = arg1;
          this.d = $Zf;
        } else {
          this.c = arg2;
          this.d = arg1.getCacheKey;
        }
      }
      get(arg) {
        const key = this.d(arg);
        if (this.b !== key) {
          this.b = key;
          this.a = this.c(arg);
        }
        return this.a;
      }
    };
  }
});

// out-build/vs/base/common/lazy.js
var $3f;
var init_lazy = __esm({
  "out-build/vs/base/common/lazy.js"() {
    "use strict";
    $3f = class {
      constructor(d) {
        this.d = d;
        this.a = false;
      }
      /**
       * True if the lazy value has been resolved.
       */
      get hasValue() {
        return this.a;
      }
      /**
       * Get the wrapped value.
       *
       * This will force evaluation of the lazy value if it has not been resolved yet. Lazy values are only
       * resolved once. `getValue` will re-throw exceptions that are hit while resolving the value
       */
      get value() {
        if (!this.a) {
          try {
            this.b = this.d();
          } catch (err) {
            this.c = err;
          } finally {
            this.a = true;
          }
        }
        if (this.c) {
          throw this.c;
        }
        return this.b;
      }
      /**
       * Get the wrapped value without forcing evaluation.
       */
      get rawValue() {
        return this.b;
      }
    };
  }
});

// out-build/vs/base/common/strings.js
function $6f(str) {
  if (!str || typeof str !== "string") {
    return true;
  }
  return str.trim().length === 0;
}
function $8f(template, values) {
  if (Object.keys(values).length === 0) {
    return template;
  }
  return template.replace(_format2Regexp, (match, group) => values[group] ?? match);
}
function $$f(value) {
  return value.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g, "\\$&");
}
function $dg(haystack, needle) {
  if (!haystack || !needle) {
    return haystack;
  }
  const needleLen = needle.length;
  if (needleLen === 0 || haystack.length === 0) {
    return haystack;
  }
  let offset = 0;
  while (haystack.indexOf(needle, offset) === offset) {
    offset = offset + needleLen;
  }
  return haystack.substring(offset);
}
function $eg(haystack, needle) {
  if (!haystack || !needle) {
    return haystack;
  }
  const needleLen = needle.length, haystackLen = haystack.length;
  if (needleLen === 0 || haystackLen === 0) {
    return haystack;
  }
  let offset = haystackLen, idx = -1;
  while (true) {
    idx = haystack.lastIndexOf(needle, offset - 1);
    if (idx === -1 || idx + needleLen !== offset) {
      break;
    }
    if (idx === 0) {
      return "";
    }
    offset = idx;
  }
  return haystack.substring(0, offset);
}
function $hg(searchString, isRegex, options2 = {}) {
  if (!searchString) {
    throw new Error("Cannot create regex from empty string");
  }
  if (!isRegex) {
    searchString = $$f(searchString);
  }
  if (options2.wholeWord) {
    if (!/\B/.test(searchString.charAt(0))) {
      searchString = "\\b" + searchString;
    }
    if (!/\B/.test(searchString.charAt(searchString.length - 1))) {
      searchString = searchString + "\\b";
    }
  }
  let modifiers = "";
  if (options2.global) {
    modifiers += "g";
  }
  if (!options2.matchCase) {
    modifiers += "i";
  }
  if (options2.multiline) {
    modifiers += "m";
  }
  if (options2.unicode) {
    modifiers += "u";
  }
  return new RegExp(searchString, modifiers);
}
function $rg(a, b) {
  if (a < b) {
    return -1;
  } else if (a > b) {
    return 1;
  } else {
    return 0;
  }
}
function $sg(a, b, aStart = 0, aEnd = a.length, bStart = 0, bEnd = b.length) {
  for (; aStart < aEnd && bStart < bEnd; aStart++, bStart++) {
    const codeA = a.charCodeAt(aStart);
    const codeB = b.charCodeAt(bStart);
    if (codeA < codeB) {
      return -1;
    } else if (codeA > codeB) {
      return 1;
    }
  }
  const aLen = aEnd - aStart;
  const bLen = bEnd - bStart;
  if (aLen < bLen) {
    return -1;
  } else if (aLen > bLen) {
    return 1;
  }
  return 0;
}
function $tg(a, b) {
  return $ug(a, b, 0, a.length, 0, b.length);
}
function $ug(a, b, aStart = 0, aEnd = a.length, bStart = 0, bEnd = b.length) {
  for (; aStart < aEnd && bStart < bEnd; aStart++, bStart++) {
    let codeA = a.charCodeAt(aStart);
    let codeB = b.charCodeAt(bStart);
    if (codeA === codeB) {
      continue;
    }
    if (codeA >= 128 || codeB >= 128) {
      return $sg(a.toLowerCase(), b.toLowerCase(), aStart, aEnd, bStart, bEnd);
    }
    if ($wg(codeA)) {
      codeA -= 32;
    }
    if ($wg(codeB)) {
      codeB -= 32;
    }
    const diff2 = codeA - codeB;
    if (diff2 === 0) {
      continue;
    }
    return diff2;
  }
  const aLen = aEnd - aStart;
  const bLen = bEnd - bStart;
  if (aLen < bLen) {
    return -1;
  } else if (aLen > bLen) {
    return 1;
  }
  return 0;
}
function $wg(code) {
  return code >= 97 && code <= 122;
}
function $xg(code) {
  return code >= 65 && code <= 90;
}
function $yg(a, b) {
  return a.length === b.length && $ug(a, b) === 0;
}
function $zg(str, candidate) {
  const candidateLength = candidate.length;
  if (candidate.length > str.length) {
    return false;
  }
  return $ug(str, candidate, 0, candidateLength) === 0;
}
function $Cg(charCode) {
  return 55296 <= charCode && charCode <= 56319;
}
function $Dg(charCode) {
  return 56320 <= charCode && charCode <= 57343;
}
function $Eg(highSurrogate, lowSurrogate) {
  return (highSurrogate - 55296 << 10) + (lowSurrogate - 56320) + 65536;
}
function getGraphemeBreakRawData() {
  return JSON.parse("[0,0,0,51229,51255,12,44061,44087,12,127462,127487,6,7083,7085,5,47645,47671,12,54813,54839,12,128678,128678,14,3270,3270,5,9919,9923,14,45853,45879,12,49437,49463,12,53021,53047,12,71216,71218,7,128398,128399,14,129360,129374,14,2519,2519,5,4448,4519,9,9742,9742,14,12336,12336,14,44957,44983,12,46749,46775,12,48541,48567,12,50333,50359,12,52125,52151,12,53917,53943,12,69888,69890,5,73018,73018,5,127990,127990,14,128558,128559,14,128759,128760,14,129653,129655,14,2027,2035,5,2891,2892,7,3761,3761,5,6683,6683,5,8293,8293,4,9825,9826,14,9999,9999,14,43452,43453,5,44509,44535,12,45405,45431,12,46301,46327,12,47197,47223,12,48093,48119,12,48989,49015,12,49885,49911,12,50781,50807,12,51677,51703,12,52573,52599,12,53469,53495,12,54365,54391,12,65279,65279,4,70471,70472,7,72145,72147,7,119173,119179,5,127799,127818,14,128240,128244,14,128512,128512,14,128652,128652,14,128721,128722,14,129292,129292,14,129445,129450,14,129734,129743,14,1476,1477,5,2366,2368,7,2750,2752,7,3076,3076,5,3415,3415,5,4141,4144,5,6109,6109,5,6964,6964,5,7394,7400,5,9197,9198,14,9770,9770,14,9877,9877,14,9968,9969,14,10084,10084,14,43052,43052,5,43713,43713,5,44285,44311,12,44733,44759,12,45181,45207,12,45629,45655,12,46077,46103,12,46525,46551,12,46973,46999,12,47421,47447,12,47869,47895,12,48317,48343,12,48765,48791,12,49213,49239,12,49661,49687,12,50109,50135,12,50557,50583,12,51005,51031,12,51453,51479,12,51901,51927,12,52349,52375,12,52797,52823,12,53245,53271,12,53693,53719,12,54141,54167,12,54589,54615,12,55037,55063,12,69506,69509,5,70191,70193,5,70841,70841,7,71463,71467,5,72330,72342,5,94031,94031,5,123628,123631,5,127763,127765,14,127941,127941,14,128043,128062,14,128302,128317,14,128465,128467,14,128539,128539,14,128640,128640,14,128662,128662,14,128703,128703,14,128745,128745,14,129004,129007,14,129329,129330,14,129402,129402,14,129483,129483,14,129686,129704,14,130048,131069,14,173,173,4,1757,1757,1,2200,2207,5,2434,2435,7,2631,2632,5,2817,2817,5,3008,3008,5,3201,3201,5,3387,3388,5,3542,3542,5,3902,3903,7,4190,4192,5,6002,6003,5,6439,6440,5,6765,6770,7,7019,7027,5,7154,7155,7,8205,8205,13,8505,8505,14,9654,9654,14,9757,9757,14,9792,9792,14,9852,9853,14,9890,9894,14,9937,9937,14,9981,9981,14,10035,10036,14,11035,11036,14,42654,42655,5,43346,43347,7,43587,43587,5,44006,44007,7,44173,44199,12,44397,44423,12,44621,44647,12,44845,44871,12,45069,45095,12,45293,45319,12,45517,45543,12,45741,45767,12,45965,45991,12,46189,46215,12,46413,46439,12,46637,46663,12,46861,46887,12,47085,47111,12,47309,47335,12,47533,47559,12,47757,47783,12,47981,48007,12,48205,48231,12,48429,48455,12,48653,48679,12,48877,48903,12,49101,49127,12,49325,49351,12,49549,49575,12,49773,49799,12,49997,50023,12,50221,50247,12,50445,50471,12,50669,50695,12,50893,50919,12,51117,51143,12,51341,51367,12,51565,51591,12,51789,51815,12,52013,52039,12,52237,52263,12,52461,52487,12,52685,52711,12,52909,52935,12,53133,53159,12,53357,53383,12,53581,53607,12,53805,53831,12,54029,54055,12,54253,54279,12,54477,54503,12,54701,54727,12,54925,54951,12,55149,55175,12,68101,68102,5,69762,69762,7,70067,70069,7,70371,70378,5,70720,70721,7,71087,71087,5,71341,71341,5,71995,71996,5,72249,72249,7,72850,72871,5,73109,73109,5,118576,118598,5,121505,121519,5,127245,127247,14,127568,127569,14,127777,127777,14,127872,127891,14,127956,127967,14,128015,128016,14,128110,128172,14,128259,128259,14,128367,128368,14,128424,128424,14,128488,128488,14,128530,128532,14,128550,128551,14,128566,128566,14,128647,128647,14,128656,128656,14,128667,128673,14,128691,128693,14,128715,128715,14,128728,128732,14,128752,128752,14,128765,128767,14,129096,129103,14,129311,129311,14,129344,129349,14,129394,129394,14,129413,129425,14,129466,129471,14,129511,129535,14,129664,129666,14,129719,129722,14,129760,129767,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2307,2307,7,2382,2383,7,2497,2500,5,2563,2563,7,2677,2677,5,2763,2764,7,2879,2879,5,2914,2915,5,3021,3021,5,3142,3144,5,3263,3263,5,3285,3286,5,3398,3400,7,3530,3530,5,3633,3633,5,3864,3865,5,3974,3975,5,4155,4156,7,4229,4230,5,5909,5909,7,6078,6085,7,6277,6278,5,6451,6456,7,6744,6750,5,6846,6846,5,6972,6972,5,7074,7077,5,7146,7148,7,7222,7223,5,7416,7417,5,8234,8238,4,8417,8417,5,9000,9000,14,9203,9203,14,9730,9731,14,9748,9749,14,9762,9763,14,9776,9783,14,9800,9811,14,9831,9831,14,9872,9873,14,9882,9882,14,9900,9903,14,9929,9933,14,9941,9960,14,9974,9974,14,9989,9989,14,10006,10006,14,10062,10062,14,10160,10160,14,11647,11647,5,12953,12953,14,43019,43019,5,43232,43249,5,43443,43443,5,43567,43568,7,43696,43696,5,43765,43765,7,44013,44013,5,44117,44143,12,44229,44255,12,44341,44367,12,44453,44479,12,44565,44591,12,44677,44703,12,44789,44815,12,44901,44927,12,45013,45039,12,45125,45151,12,45237,45263,12,45349,45375,12,45461,45487,12,45573,45599,12,45685,45711,12,45797,45823,12,45909,45935,12,46021,46047,12,46133,46159,12,46245,46271,12,46357,46383,12,46469,46495,12,46581,46607,12,46693,46719,12,46805,46831,12,46917,46943,12,47029,47055,12,47141,47167,12,47253,47279,12,47365,47391,12,47477,47503,12,47589,47615,12,47701,47727,12,47813,47839,12,47925,47951,12,48037,48063,12,48149,48175,12,48261,48287,12,48373,48399,12,48485,48511,12,48597,48623,12,48709,48735,12,48821,48847,12,48933,48959,12,49045,49071,12,49157,49183,12,49269,49295,12,49381,49407,12,49493,49519,12,49605,49631,12,49717,49743,12,49829,49855,12,49941,49967,12,50053,50079,12,50165,50191,12,50277,50303,12,50389,50415,12,50501,50527,12,50613,50639,12,50725,50751,12,50837,50863,12,50949,50975,12,51061,51087,12,51173,51199,12,51285,51311,12,51397,51423,12,51509,51535,12,51621,51647,12,51733,51759,12,51845,51871,12,51957,51983,12,52069,52095,12,52181,52207,12,52293,52319,12,52405,52431,12,52517,52543,12,52629,52655,12,52741,52767,12,52853,52879,12,52965,52991,12,53077,53103,12,53189,53215,12,53301,53327,12,53413,53439,12,53525,53551,12,53637,53663,12,53749,53775,12,53861,53887,12,53973,53999,12,54085,54111,12,54197,54223,12,54309,54335,12,54421,54447,12,54533,54559,12,54645,54671,12,54757,54783,12,54869,54895,12,54981,55007,12,55093,55119,12,55243,55291,10,66045,66045,5,68325,68326,5,69688,69702,5,69817,69818,5,69957,69958,7,70089,70092,5,70198,70199,5,70462,70462,5,70502,70508,5,70750,70750,5,70846,70846,7,71100,71101,5,71230,71230,7,71351,71351,5,71737,71738,5,72000,72000,7,72160,72160,5,72273,72278,5,72752,72758,5,72882,72883,5,73031,73031,5,73461,73462,7,94192,94193,7,119149,119149,7,121403,121452,5,122915,122916,5,126980,126980,14,127358,127359,14,127535,127535,14,127759,127759,14,127771,127771,14,127792,127793,14,127825,127867,14,127897,127899,14,127945,127945,14,127985,127986,14,128000,128007,14,128021,128021,14,128066,128100,14,128184,128235,14,128249,128252,14,128266,128276,14,128335,128335,14,128379,128390,14,128407,128419,14,128444,128444,14,128481,128481,14,128499,128499,14,128526,128526,14,128536,128536,14,128543,128543,14,128556,128556,14,128564,128564,14,128577,128580,14,128643,128645,14,128649,128649,14,128654,128654,14,128660,128660,14,128664,128664,14,128675,128675,14,128686,128689,14,128695,128696,14,128705,128709,14,128717,128719,14,128725,128725,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129009,129023,14,129160,129167,14,129296,129304,14,129320,129327,14,129340,129342,14,129356,129356,14,129388,129392,14,129399,129400,14,129404,129407,14,129432,129442,14,129454,129455,14,129473,129474,14,129485,129487,14,129648,129651,14,129659,129660,14,129671,129679,14,129709,129711,14,129728,129730,14,129751,129753,14,129776,129782,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2274,2274,1,2363,2363,7,2377,2380,7,2402,2403,5,2494,2494,5,2507,2508,7,2558,2558,5,2622,2624,7,2641,2641,5,2691,2691,7,2759,2760,5,2786,2787,5,2876,2876,5,2881,2884,5,2901,2902,5,3006,3006,5,3014,3016,7,3072,3072,5,3134,3136,5,3157,3158,5,3260,3260,5,3266,3266,5,3274,3275,7,3328,3329,5,3391,3392,7,3405,3405,5,3457,3457,5,3536,3537,7,3551,3551,5,3636,3642,5,3764,3772,5,3895,3895,5,3967,3967,7,3993,4028,5,4146,4151,5,4182,4183,7,4226,4226,5,4253,4253,5,4957,4959,5,5940,5940,7,6070,6070,7,6087,6088,7,6158,6158,4,6432,6434,5,6448,6449,7,6679,6680,5,6742,6742,5,6754,6754,5,6783,6783,5,6912,6915,5,6966,6970,5,6978,6978,5,7042,7042,7,7080,7081,5,7143,7143,7,7150,7150,7,7212,7219,5,7380,7392,5,7412,7412,5,8203,8203,4,8232,8232,4,8265,8265,14,8400,8412,5,8421,8432,5,8617,8618,14,9167,9167,14,9200,9200,14,9410,9410,14,9723,9726,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9774,14,9786,9786,14,9794,9794,14,9823,9823,14,9828,9828,14,9833,9850,14,9855,9855,14,9875,9875,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9935,9935,14,9939,9939,14,9962,9962,14,9972,9972,14,9978,9978,14,9986,9986,14,9997,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10133,10135,14,10548,10549,14,11093,11093,14,12330,12333,5,12441,12442,5,42608,42610,5,43010,43010,5,43045,43046,5,43188,43203,7,43302,43309,5,43392,43394,5,43446,43449,5,43493,43493,5,43571,43572,7,43597,43597,7,43703,43704,5,43756,43757,5,44003,44004,7,44009,44010,7,44033,44059,12,44089,44115,12,44145,44171,12,44201,44227,12,44257,44283,12,44313,44339,12,44369,44395,12,44425,44451,12,44481,44507,12,44537,44563,12,44593,44619,12,44649,44675,12,44705,44731,12,44761,44787,12,44817,44843,12,44873,44899,12,44929,44955,12,44985,45011,12,45041,45067,12,45097,45123,12,45153,45179,12,45209,45235,12,45265,45291,12,45321,45347,12,45377,45403,12,45433,45459,12,45489,45515,12,45545,45571,12,45601,45627,12,45657,45683,12,45713,45739,12,45769,45795,12,45825,45851,12,45881,45907,12,45937,45963,12,45993,46019,12,46049,46075,12,46105,46131,12,46161,46187,12,46217,46243,12,46273,46299,12,46329,46355,12,46385,46411,12,46441,46467,12,46497,46523,12,46553,46579,12,46609,46635,12,46665,46691,12,46721,46747,12,46777,46803,12,46833,46859,12,46889,46915,12,46945,46971,12,47001,47027,12,47057,47083,12,47113,47139,12,47169,47195,12,47225,47251,12,47281,47307,12,47337,47363,12,47393,47419,12,47449,47475,12,47505,47531,12,47561,47587,12,47617,47643,12,47673,47699,12,47729,47755,12,47785,47811,12,47841,47867,12,47897,47923,12,47953,47979,12,48009,48035,12,48065,48091,12,48121,48147,12,48177,48203,12,48233,48259,12,48289,48315,12,48345,48371,12,48401,48427,12,48457,48483,12,48513,48539,12,48569,48595,12,48625,48651,12,48681,48707,12,48737,48763,12,48793,48819,12,48849,48875,12,48905,48931,12,48961,48987,12,49017,49043,12,49073,49099,12,49129,49155,12,49185,49211,12,49241,49267,12,49297,49323,12,49353,49379,12,49409,49435,12,49465,49491,12,49521,49547,12,49577,49603,12,49633,49659,12,49689,49715,12,49745,49771,12,49801,49827,12,49857,49883,12,49913,49939,12,49969,49995,12,50025,50051,12,50081,50107,12,50137,50163,12,50193,50219,12,50249,50275,12,50305,50331,12,50361,50387,12,50417,50443,12,50473,50499,12,50529,50555,12,50585,50611,12,50641,50667,12,50697,50723,12,50753,50779,12,50809,50835,12,50865,50891,12,50921,50947,12,50977,51003,12,51033,51059,12,51089,51115,12,51145,51171,12,51201,51227,12,51257,51283,12,51313,51339,12,51369,51395,12,51425,51451,12,51481,51507,12,51537,51563,12,51593,51619,12,51649,51675,12,51705,51731,12,51761,51787,12,51817,51843,12,51873,51899,12,51929,51955,12,51985,52011,12,52041,52067,12,52097,52123,12,52153,52179,12,52209,52235,12,52265,52291,12,52321,52347,12,52377,52403,12,52433,52459,12,52489,52515,12,52545,52571,12,52601,52627,12,52657,52683,12,52713,52739,12,52769,52795,12,52825,52851,12,52881,52907,12,52937,52963,12,52993,53019,12,53049,53075,12,53105,53131,12,53161,53187,12,53217,53243,12,53273,53299,12,53329,53355,12,53385,53411,12,53441,53467,12,53497,53523,12,53553,53579,12,53609,53635,12,53665,53691,12,53721,53747,12,53777,53803,12,53833,53859,12,53889,53915,12,53945,53971,12,54001,54027,12,54057,54083,12,54113,54139,12,54169,54195,12,54225,54251,12,54281,54307,12,54337,54363,12,54393,54419,12,54449,54475,12,54505,54531,12,54561,54587,12,54617,54643,12,54673,54699,12,54729,54755,12,54785,54811,12,54841,54867,12,54897,54923,12,54953,54979,12,55009,55035,12,55065,55091,12,55121,55147,12,55177,55203,12,65024,65039,5,65520,65528,4,66422,66426,5,68152,68154,5,69291,69292,5,69633,69633,5,69747,69748,5,69811,69814,5,69826,69826,5,69932,69932,7,70016,70017,5,70079,70080,7,70095,70095,5,70196,70196,5,70367,70367,5,70402,70403,7,70464,70464,5,70487,70487,5,70709,70711,7,70725,70725,7,70833,70834,7,70843,70844,7,70849,70849,7,71090,71093,5,71103,71104,5,71227,71228,7,71339,71339,5,71344,71349,5,71458,71461,5,71727,71735,5,71985,71989,7,71998,71998,5,72002,72002,7,72154,72155,5,72193,72202,5,72251,72254,5,72281,72283,5,72344,72345,5,72766,72766,7,72874,72880,5,72885,72886,5,73023,73029,5,73104,73105,5,73111,73111,5,92912,92916,5,94095,94098,5,113824,113827,4,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,125252,125258,5,127183,127183,14,127340,127343,14,127377,127386,14,127491,127503,14,127548,127551,14,127744,127756,14,127761,127761,14,127769,127769,14,127773,127774,14,127780,127788,14,127796,127797,14,127820,127823,14,127869,127869,14,127894,127895,14,127902,127903,14,127943,127943,14,127947,127950,14,127972,127972,14,127988,127988,14,127992,127994,14,128009,128011,14,128019,128019,14,128023,128041,14,128064,128064,14,128102,128107,14,128174,128181,14,128238,128238,14,128246,128247,14,128254,128254,14,128264,128264,14,128278,128299,14,128329,128330,14,128348,128359,14,128371,128377,14,128392,128393,14,128401,128404,14,128421,128421,14,128433,128434,14,128450,128452,14,128476,128478,14,128483,128483,14,128495,128495,14,128506,128506,14,128519,128520,14,128528,128528,14,128534,128534,14,128538,128538,14,128540,128542,14,128544,128549,14,128552,128555,14,128557,128557,14,128560,128563,14,128565,128565,14,128567,128576,14,128581,128591,14,128641,128642,14,128646,128646,14,128648,128648,14,128650,128651,14,128653,128653,14,128655,128655,14,128657,128659,14,128661,128661,14,128663,128663,14,128665,128666,14,128674,128674,14,128676,128677,14,128679,128685,14,128690,128690,14,128694,128694,14,128697,128702,14,128704,128704,14,128710,128714,14,128716,128716,14,128720,128720,14,128723,128724,14,128726,128727,14,128733,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129008,129008,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129661,129663,14,129667,129670,14,129680,129685,14,129705,129708,14,129712,129718,14,129723,129727,14,129731,129733,14,129744,129750,14,129754,129759,14,129768,129775,14,129783,129791,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2192,2193,1,2250,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3132,3132,5,3137,3140,7,3146,3149,5,3170,3171,5,3202,3203,7,3262,3262,7,3264,3265,7,3267,3268,7,3271,3272,7,3276,3277,5,3298,3299,5,3330,3331,7,3390,3390,5,3393,3396,5,3402,3404,7,3406,3406,1,3426,3427,5,3458,3459,7,3535,3535,5,3538,3540,5,3544,3550,7,3570,3571,7,3635,3635,7,3655,3662,5,3763,3763,7,3784,3789,5,3893,3893,5,3897,3897,5,3953,3966,5,3968,3972,5,3981,3991,5,4038,4038,5,4145,4145,7,4153,4154,5,4157,4158,5,4184,4185,5,4209,4212,5,4228,4228,7,4237,4237,5,4352,4447,8,4520,4607,10,5906,5908,5,5938,5939,5,5970,5971,5,6068,6069,5,6071,6077,5,6086,6086,5,6089,6099,5,6155,6157,5,6159,6159,5,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6862,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7679,5,8204,8204,5,8206,8207,4,8233,8233,4,8252,8252,14,8288,8292,4,8294,8303,4,8413,8416,5,8418,8420,5,8482,8482,14,8596,8601,14,8986,8987,14,9096,9096,14,9193,9196,14,9199,9199,14,9201,9202,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9729,14,9732,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9775,9775,14,9784,9785,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9874,14,9876,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9934,14,9936,9936,14,9938,9938,14,9940,9940,14,9961,9961,14,9963,9967,14,9970,9971,14,9973,9973,14,9975,9977,14,9979,9980,14,9982,9985,14,9987,9988,14,9992,9996,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10083,14,10085,10087,14,10145,10145,14,10175,10175,14,11013,11015,14,11088,11088,14,11503,11505,5,11744,11775,5,12334,12335,5,12349,12349,14,12951,12951,14,42607,42607,5,42612,42621,5,42736,42737,5,43014,43014,5,43043,43044,7,43047,43047,7,43136,43137,7,43204,43205,5,43263,43263,5,43335,43345,5,43360,43388,8,43395,43395,7,43444,43445,7,43450,43451,7,43454,43456,7,43561,43566,5,43569,43570,5,43573,43574,5,43596,43596,5,43644,43644,5,43698,43700,5,43710,43711,5,43755,43755,7,43758,43759,7,43766,43766,5,44005,44005,5,44008,44008,5,44012,44012,7,44032,44032,11,44060,44060,11,44088,44088,11,44116,44116,11,44144,44144,11,44172,44172,11,44200,44200,11,44228,44228,11,44256,44256,11,44284,44284,11,44312,44312,11,44340,44340,11,44368,44368,11,44396,44396,11,44424,44424,11,44452,44452,11,44480,44480,11,44508,44508,11,44536,44536,11,44564,44564,11,44592,44592,11,44620,44620,11,44648,44648,11,44676,44676,11,44704,44704,11,44732,44732,11,44760,44760,11,44788,44788,11,44816,44816,11,44844,44844,11,44872,44872,11,44900,44900,11,44928,44928,11,44956,44956,11,44984,44984,11,45012,45012,11,45040,45040,11,45068,45068,11,45096,45096,11,45124,45124,11,45152,45152,11,45180,45180,11,45208,45208,11,45236,45236,11,45264,45264,11,45292,45292,11,45320,45320,11,45348,45348,11,45376,45376,11,45404,45404,11,45432,45432,11,45460,45460,11,45488,45488,11,45516,45516,11,45544,45544,11,45572,45572,11,45600,45600,11,45628,45628,11,45656,45656,11,45684,45684,11,45712,45712,11,45740,45740,11,45768,45768,11,45796,45796,11,45824,45824,11,45852,45852,11,45880,45880,11,45908,45908,11,45936,45936,11,45964,45964,11,45992,45992,11,46020,46020,11,46048,46048,11,46076,46076,11,46104,46104,11,46132,46132,11,46160,46160,11,46188,46188,11,46216,46216,11,46244,46244,11,46272,46272,11,46300,46300,11,46328,46328,11,46356,46356,11,46384,46384,11,46412,46412,11,46440,46440,11,46468,46468,11,46496,46496,11,46524,46524,11,46552,46552,11,46580,46580,11,46608,46608,11,46636,46636,11,46664,46664,11,46692,46692,11,46720,46720,11,46748,46748,11,46776,46776,11,46804,46804,11,46832,46832,11,46860,46860,11,46888,46888,11,46916,46916,11,46944,46944,11,46972,46972,11,47000,47000,11,47028,47028,11,47056,47056,11,47084,47084,11,47112,47112,11,47140,47140,11,47168,47168,11,47196,47196,11,47224,47224,11,47252,47252,11,47280,47280,11,47308,47308,11,47336,47336,11,47364,47364,11,47392,47392,11,47420,47420,11,47448,47448,11,47476,47476,11,47504,47504,11,47532,47532,11,47560,47560,11,47588,47588,11,47616,47616,11,47644,47644,11,47672,47672,11,47700,47700,11,47728,47728,11,47756,47756,11,47784,47784,11,47812,47812,11,47840,47840,11,47868,47868,11,47896,47896,11,47924,47924,11,47952,47952,11,47980,47980,11,48008,48008,11,48036,48036,11,48064,48064,11,48092,48092,11,48120,48120,11,48148,48148,11,48176,48176,11,48204,48204,11,48232,48232,11,48260,48260,11,48288,48288,11,48316,48316,11,48344,48344,11,48372,48372,11,48400,48400,11,48428,48428,11,48456,48456,11,48484,48484,11,48512,48512,11,48540,48540,11,48568,48568,11,48596,48596,11,48624,48624,11,48652,48652,11,48680,48680,11,48708,48708,11,48736,48736,11,48764,48764,11,48792,48792,11,48820,48820,11,48848,48848,11,48876,48876,11,48904,48904,11,48932,48932,11,48960,48960,11,48988,48988,11,49016,49016,11,49044,49044,11,49072,49072,11,49100,49100,11,49128,49128,11,49156,49156,11,49184,49184,11,49212,49212,11,49240,49240,11,49268,49268,11,49296,49296,11,49324,49324,11,49352,49352,11,49380,49380,11,49408,49408,11,49436,49436,11,49464,49464,11,49492,49492,11,49520,49520,11,49548,49548,11,49576,49576,11,49604,49604,11,49632,49632,11,49660,49660,11,49688,49688,11,49716,49716,11,49744,49744,11,49772,49772,11,49800,49800,11,49828,49828,11,49856,49856,11,49884,49884,11,49912,49912,11,49940,49940,11,49968,49968,11,49996,49996,11,50024,50024,11,50052,50052,11,50080,50080,11,50108,50108,11,50136,50136,11,50164,50164,11,50192,50192,11,50220,50220,11,50248,50248,11,50276,50276,11,50304,50304,11,50332,50332,11,50360,50360,11,50388,50388,11,50416,50416,11,50444,50444,11,50472,50472,11,50500,50500,11,50528,50528,11,50556,50556,11,50584,50584,11,50612,50612,11,50640,50640,11,50668,50668,11,50696,50696,11,50724,50724,11,50752,50752,11,50780,50780,11,50808,50808,11,50836,50836,11,50864,50864,11,50892,50892,11,50920,50920,11,50948,50948,11,50976,50976,11,51004,51004,11,51032,51032,11,51060,51060,11,51088,51088,11,51116,51116,11,51144,51144,11,51172,51172,11,51200,51200,11,51228,51228,11,51256,51256,11,51284,51284,11,51312,51312,11,51340,51340,11,51368,51368,11,51396,51396,11,51424,51424,11,51452,51452,11,51480,51480,11,51508,51508,11,51536,51536,11,51564,51564,11,51592,51592,11,51620,51620,11,51648,51648,11,51676,51676,11,51704,51704,11,51732,51732,11,51760,51760,11,51788,51788,11,51816,51816,11,51844,51844,11,51872,51872,11,51900,51900,11,51928,51928,11,51956,51956,11,51984,51984,11,52012,52012,11,52040,52040,11,52068,52068,11,52096,52096,11,52124,52124,11,52152,52152,11,52180,52180,11,52208,52208,11,52236,52236,11,52264,52264,11,52292,52292,11,52320,52320,11,52348,52348,11,52376,52376,11,52404,52404,11,52432,52432,11,52460,52460,11,52488,52488,11,52516,52516,11,52544,52544,11,52572,52572,11,52600,52600,11,52628,52628,11,52656,52656,11,52684,52684,11,52712,52712,11,52740,52740,11,52768,52768,11,52796,52796,11,52824,52824,11,52852,52852,11,52880,52880,11,52908,52908,11,52936,52936,11,52964,52964,11,52992,52992,11,53020,53020,11,53048,53048,11,53076,53076,11,53104,53104,11,53132,53132,11,53160,53160,11,53188,53188,11,53216,53216,11,53244,53244,11,53272,53272,11,53300,53300,11,53328,53328,11,53356,53356,11,53384,53384,11,53412,53412,11,53440,53440,11,53468,53468,11,53496,53496,11,53524,53524,11,53552,53552,11,53580,53580,11,53608,53608,11,53636,53636,11,53664,53664,11,53692,53692,11,53720,53720,11,53748,53748,11,53776,53776,11,53804,53804,11,53832,53832,11,53860,53860,11,53888,53888,11,53916,53916,11,53944,53944,11,53972,53972,11,54000,54000,11,54028,54028,11,54056,54056,11,54084,54084,11,54112,54112,11,54140,54140,11,54168,54168,11,54196,54196,11,54224,54224,11,54252,54252,11,54280,54280,11,54308,54308,11,54336,54336,11,54364,54364,11,54392,54392,11,54420,54420,11,54448,54448,11,54476,54476,11,54504,54504,11,54532,54532,11,54560,54560,11,54588,54588,11,54616,54616,11,54644,54644,11,54672,54672,11,54700,54700,11,54728,54728,11,54756,54756,11,54784,54784,11,54812,54812,11,54840,54840,11,54868,54868,11,54896,54896,11,54924,54924,11,54952,54952,11,54980,54980,11,55008,55008,11,55036,55036,11,55064,55064,11,55092,55092,11,55120,55120,11,55148,55148,11,55176,55176,11,55216,55238,9,64286,64286,5,65056,65071,5,65438,65439,5,65529,65531,4,66272,66272,5,68097,68099,5,68108,68111,5,68159,68159,5,68900,68903,5,69446,69456,5,69632,69632,7,69634,69634,7,69744,69744,5,69759,69761,5,69808,69810,7,69815,69816,7,69821,69821,1,69837,69837,1,69927,69931,5,69933,69940,5,70003,70003,5,70018,70018,7,70070,70078,5,70082,70083,1,70094,70094,7,70188,70190,7,70194,70195,7,70197,70197,7,70206,70206,5,70368,70370,7,70400,70401,5,70459,70460,5,70463,70463,7,70465,70468,7,70475,70477,7,70498,70499,7,70512,70516,5,70712,70719,5,70722,70724,5,70726,70726,5,70832,70832,5,70835,70840,5,70842,70842,5,70845,70845,5,70847,70848,5,70850,70851,5,71088,71089,7,71096,71099,7,71102,71102,7,71132,71133,5,71219,71226,5,71229,71229,5,71231,71232,5,71340,71340,7,71342,71343,7,71350,71350,7,71453,71455,5,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,118528,118573,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123566,123566,5,125136,125142,5,126976,126979,14,126981,127182,14,127184,127231,14,127279,127279,14,127344,127345,14,127374,127374,14,127405,127461,14,127489,127490,14,127514,127514,14,127538,127546,14,127561,127567,14,127570,127743,14,127757,127758,14,127760,127760,14,127762,127762,14,127766,127768,14,127770,127770,14,127772,127772,14,127775,127776,14,127778,127779,14,127789,127791,14,127794,127795,14,127798,127798,14,127819,127819,14,127824,127824,14,127868,127868,14,127870,127871,14,127892,127893,14,127896,127896,14,127900,127901,14,127904,127940,14,127942,127942,14,127944,127944,14,127946,127946,14,127951,127955,14,127968,127971,14,127973,127984,14,127987,127987,14,127989,127989,14,127991,127991,14,127995,127999,5,128008,128008,14,128012,128014,14,128017,128018,14,128020,128020,14,128022,128022,14,128042,128042,14,128063,128063,14,128065,128065,14,128101,128101,14,128108,128109,14,128173,128173,14,128182,128183,14,128236,128237,14,128239,128239,14,128245,128245,14,128248,128248,14,128253,128253,14,128255,128258,14,128260,128263,14,128265,128265,14,128277,128277,14,128300,128301,14,128326,128328,14,128331,128334,14,128336,128347,14,128360,128366,14,128369,128370,14,128378,128378,14,128391,128391,14,128394,128397,14,128400,128400,14,128405,128406,14,128420,128420,14,128422,128423,14,128425,128432,14,128435,128443,14,128445,128449,14,128453,128464,14,128468,128475,14,128479,128480,14,128482,128482,14,128484,128487,14,128489,128494,14,128496,128498,14,128500,128505,14,128507,128511,14,128513,128518,14,128521,128525,14,128527,128527,14,128529,128529,14,128533,128533,14,128535,128535,14,128537,128537,14]");
}
var _format2Regexp, CSI_SEQUENCE, OSC_SEQUENCE, ESC_SEQUENCE, CONTROL_SEQUENCES, $Xg, GraphemeBreakType, GraphemeBreakTree, CodePoint, $9g, $0g;
var init_strings = __esm({
  "out-build/vs/base/common/strings.js"() {
    "use strict";
    init_cache();
    init_lazy();
    _format2Regexp = /{([^}]+)}/g;
    CSI_SEQUENCE = /(?:\x1b\[|\x9b)[=?>!]?[\d;:]*["$#'* ]?[a-zA-Z@^`{}|~]/;
    OSC_SEQUENCE = /(?:\x1b\]|\x9d).*?(?:\x1b\\|\x07|\x9c)/;
    ESC_SEQUENCE = /\x1b(?:[ #%\(\)\*\+\-\.\/]?[a-zA-Z0-9\|}~@])/;
    CONTROL_SEQUENCES = new RegExp("(?:" + [
      CSI_SEQUENCE.source,
      OSC_SEQUENCE.source,
      ESC_SEQUENCE.source
    ].join("|") + ")", "g");
    $Xg = String.fromCharCode(
      65279
      /* CharCode.UTF8_BOM */
    );
    (function(GraphemeBreakType2) {
      GraphemeBreakType2[GraphemeBreakType2["Other"] = 0] = "Other";
      GraphemeBreakType2[GraphemeBreakType2["Prepend"] = 1] = "Prepend";
      GraphemeBreakType2[GraphemeBreakType2["CR"] = 2] = "CR";
      GraphemeBreakType2[GraphemeBreakType2["LF"] = 3] = "LF";
      GraphemeBreakType2[GraphemeBreakType2["Control"] = 4] = "Control";
      GraphemeBreakType2[GraphemeBreakType2["Extend"] = 5] = "Extend";
      GraphemeBreakType2[GraphemeBreakType2["Regional_Indicator"] = 6] = "Regional_Indicator";
      GraphemeBreakType2[GraphemeBreakType2["SpacingMark"] = 7] = "SpacingMark";
      GraphemeBreakType2[GraphemeBreakType2["L"] = 8] = "L";
      GraphemeBreakType2[GraphemeBreakType2["V"] = 9] = "V";
      GraphemeBreakType2[GraphemeBreakType2["T"] = 10] = "T";
      GraphemeBreakType2[GraphemeBreakType2["LV"] = 11] = "LV";
      GraphemeBreakType2[GraphemeBreakType2["LVT"] = 12] = "LVT";
      GraphemeBreakType2[GraphemeBreakType2["ZWJ"] = 13] = "ZWJ";
      GraphemeBreakType2[GraphemeBreakType2["Extended_Pictographic"] = 14] = "Extended_Pictographic";
    })(GraphemeBreakType || (GraphemeBreakType = {}));
    GraphemeBreakTree = class _GraphemeBreakTree {
      static {
        this.c = null;
      }
      static getInstance() {
        if (!_GraphemeBreakTree.c) {
          _GraphemeBreakTree.c = new _GraphemeBreakTree();
        }
        return _GraphemeBreakTree.c;
      }
      constructor() {
        this.d = getGraphemeBreakRawData();
      }
      getGraphemeBreakType(codePoint) {
        if (codePoint < 32) {
          if (codePoint === 10) {
            return 3;
          }
          if (codePoint === 13) {
            return 2;
          }
          return 4;
        }
        if (codePoint < 127) {
          return 0;
        }
        const data = this.d;
        const nodeCount = data.length / 3;
        let nodeIndex = 1;
        while (nodeIndex <= nodeCount) {
          if (codePoint < data[3 * nodeIndex]) {
            nodeIndex = 2 * nodeIndex;
          } else if (codePoint > data[3 * nodeIndex + 1]) {
            nodeIndex = 2 * nodeIndex + 1;
          } else {
            return data[3 * nodeIndex + 2];
          }
        }
        return 0;
      }
    };
    (function(CodePoint2) {
      CodePoint2[CodePoint2["zwj"] = 8205] = "zwj";
      CodePoint2[CodePoint2["emojiVariantSelector"] = 65039] = "emojiVariantSelector";
      CodePoint2[CodePoint2["enclosingKeyCap"] = 8419] = "enclosingKeyCap";
      CodePoint2[CodePoint2["space"] = 32] = "space";
    })(CodePoint || (CodePoint = {}));
    $9g = class _$9g {
      static {
        this.c = new $3f(() => {
          return JSON.parse('{"_common":[8232,32,8233,32,5760,32,8192,32,8193,32,8194,32,8195,32,8196,32,8197,32,8198,32,8200,32,8201,32,8202,32,8287,32,8199,32,8239,32,2042,95,65101,95,65102,95,65103,95,8208,45,8209,45,8210,45,65112,45,1748,45,8259,45,727,45,8722,45,10134,45,11450,45,1549,44,1643,44,184,44,42233,44,894,59,2307,58,2691,58,1417,58,1795,58,1796,58,5868,58,65072,58,6147,58,6153,58,8282,58,1475,58,760,58,42889,58,8758,58,720,58,42237,58,451,33,11601,33,660,63,577,63,2429,63,5038,63,42731,63,119149,46,8228,46,1793,46,1794,46,42510,46,68176,46,1632,46,1776,46,42232,46,1373,96,65287,96,8219,96,1523,96,8242,96,1370,96,8175,96,65344,96,900,96,8189,96,8125,96,8127,96,8190,96,697,96,884,96,712,96,714,96,715,96,756,96,699,96,701,96,700,96,702,96,42892,96,1497,96,2036,96,2037,96,5194,96,5836,96,94033,96,94034,96,65339,91,10088,40,10098,40,12308,40,64830,40,65341,93,10089,41,10099,41,12309,41,64831,41,10100,123,119060,123,10101,125,65342,94,8270,42,1645,42,8727,42,66335,42,5941,47,8257,47,8725,47,8260,47,9585,47,10187,47,10744,47,119354,47,12755,47,12339,47,11462,47,20031,47,12035,47,65340,92,65128,92,8726,92,10189,92,10741,92,10745,92,119311,92,119355,92,12756,92,20022,92,12034,92,42872,38,708,94,710,94,5869,43,10133,43,66203,43,8249,60,10094,60,706,60,119350,60,5176,60,5810,60,5120,61,11840,61,12448,61,42239,61,8250,62,10095,62,707,62,119351,62,5171,62,94015,62,8275,126,732,126,8128,126,8764,126,65372,124,65293,45,118002,50,120784,50,120794,50,120804,50,120814,50,120824,50,130034,50,42842,50,423,50,1000,50,42564,50,5311,50,42735,50,119302,51,118003,51,120785,51,120795,51,120805,51,120815,51,120825,51,130035,51,42923,51,540,51,439,51,42858,51,11468,51,1248,51,94011,51,71882,51,118004,52,120786,52,120796,52,120806,52,120816,52,120826,52,130036,52,5070,52,71855,52,118005,53,120787,53,120797,53,120807,53,120817,53,120827,53,130037,53,444,53,71867,53,118006,54,120788,54,120798,54,120808,54,120818,54,120828,54,130038,54,11474,54,5102,54,71893,54,119314,55,118007,55,120789,55,120799,55,120809,55,120819,55,120829,55,130039,55,66770,55,71878,55,2819,56,2538,56,2666,56,125131,56,118008,56,120790,56,120800,56,120810,56,120820,56,120830,56,130040,56,547,56,546,56,66330,56,2663,57,2920,57,2541,57,3437,57,118009,57,120791,57,120801,57,120811,57,120821,57,120831,57,130041,57,42862,57,11466,57,71884,57,71852,57,71894,57,9082,97,65345,97,119834,97,119886,97,119938,97,119990,97,120042,97,120094,97,120146,97,120198,97,120250,97,120302,97,120354,97,120406,97,120458,97,593,97,945,97,120514,97,120572,97,120630,97,120688,97,120746,97,65313,65,117974,65,119808,65,119860,65,119912,65,119964,65,120016,65,120068,65,120120,65,120172,65,120224,65,120276,65,120328,65,120380,65,120432,65,913,65,120488,65,120546,65,120604,65,120662,65,120720,65,5034,65,5573,65,42222,65,94016,65,66208,65,119835,98,119887,98,119939,98,119991,98,120043,98,120095,98,120147,98,120199,98,120251,98,120303,98,120355,98,120407,98,120459,98,388,98,5071,98,5234,98,5551,98,65314,66,8492,66,117975,66,119809,66,119861,66,119913,66,120017,66,120069,66,120121,66,120173,66,120225,66,120277,66,120329,66,120381,66,120433,66,42932,66,914,66,120489,66,120547,66,120605,66,120663,66,120721,66,5108,66,5623,66,42192,66,66178,66,66209,66,66305,66,65347,99,8573,99,119836,99,119888,99,119940,99,119992,99,120044,99,120096,99,120148,99,120200,99,120252,99,120304,99,120356,99,120408,99,120460,99,7428,99,1010,99,11429,99,43951,99,66621,99,128844,67,71913,67,71922,67,65315,67,8557,67,8450,67,8493,67,117976,67,119810,67,119862,67,119914,67,119966,67,120018,67,120174,67,120226,67,120278,67,120330,67,120382,67,120434,67,1017,67,11428,67,5087,67,42202,67,66210,67,66306,67,66581,67,66844,67,8574,100,8518,100,119837,100,119889,100,119941,100,119993,100,120045,100,120097,100,120149,100,120201,100,120253,100,120305,100,120357,100,120409,100,120461,100,1281,100,5095,100,5231,100,42194,100,8558,68,8517,68,117977,68,119811,68,119863,68,119915,68,119967,68,120019,68,120071,68,120123,68,120175,68,120227,68,120279,68,120331,68,120383,68,120435,68,5024,68,5598,68,5610,68,42195,68,8494,101,65349,101,8495,101,8519,101,119838,101,119890,101,119942,101,120046,101,120098,101,120150,101,120202,101,120254,101,120306,101,120358,101,120410,101,120462,101,43826,101,1213,101,8959,69,65317,69,8496,69,117978,69,119812,69,119864,69,119916,69,120020,69,120072,69,120124,69,120176,69,120228,69,120280,69,120332,69,120384,69,120436,69,917,69,120492,69,120550,69,120608,69,120666,69,120724,69,11577,69,5036,69,42224,69,71846,69,71854,69,66182,69,119839,102,119891,102,119943,102,119995,102,120047,102,120099,102,120151,102,120203,102,120255,102,120307,102,120359,102,120411,102,120463,102,43829,102,42905,102,383,102,7837,102,1412,102,119315,70,8497,70,117979,70,119813,70,119865,70,119917,70,120021,70,120073,70,120125,70,120177,70,120229,70,120281,70,120333,70,120385,70,120437,70,42904,70,988,70,120778,70,5556,70,42205,70,71874,70,71842,70,66183,70,66213,70,66853,70,65351,103,8458,103,119840,103,119892,103,119944,103,120048,103,120100,103,120152,103,120204,103,120256,103,120308,103,120360,103,120412,103,120464,103,609,103,7555,103,397,103,1409,103,117980,71,119814,71,119866,71,119918,71,119970,71,120022,71,120074,71,120126,71,120178,71,120230,71,120282,71,120334,71,120386,71,120438,71,1292,71,5056,71,5107,71,42198,71,65352,104,8462,104,119841,104,119945,104,119997,104,120049,104,120101,104,120153,104,120205,104,120257,104,120309,104,120361,104,120413,104,120465,104,1211,104,1392,104,5058,104,65320,72,8459,72,8460,72,8461,72,117981,72,119815,72,119867,72,119919,72,120023,72,120179,72,120231,72,120283,72,120335,72,120387,72,120439,72,919,72,120494,72,120552,72,120610,72,120668,72,120726,72,11406,72,5051,72,5500,72,42215,72,66255,72,731,105,9075,105,65353,105,8560,105,8505,105,8520,105,119842,105,119894,105,119946,105,119998,105,120050,105,120102,105,120154,105,120206,105,120258,105,120310,105,120362,105,120414,105,120466,105,120484,105,618,105,617,105,953,105,8126,105,890,105,120522,105,120580,105,120638,105,120696,105,120754,105,1110,105,42567,105,1231,105,43893,105,5029,105,71875,105,65354,106,8521,106,119843,106,119895,106,119947,106,119999,106,120051,106,120103,106,120155,106,120207,106,120259,106,120311,106,120363,106,120415,106,120467,106,1011,106,1112,106,65322,74,117983,74,119817,74,119869,74,119921,74,119973,74,120025,74,120077,74,120129,74,120181,74,120233,74,120285,74,120337,74,120389,74,120441,74,42930,74,895,74,1032,74,5035,74,5261,74,42201,74,119844,107,119896,107,119948,107,120000,107,120052,107,120104,107,120156,107,120208,107,120260,107,120312,107,120364,107,120416,107,120468,107,8490,75,65323,75,117984,75,119818,75,119870,75,119922,75,119974,75,120026,75,120078,75,120130,75,120182,75,120234,75,120286,75,120338,75,120390,75,120442,75,922,75,120497,75,120555,75,120613,75,120671,75,120729,75,11412,75,5094,75,5845,75,42199,75,66840,75,1472,108,8739,73,9213,73,65512,73,1633,108,1777,73,66336,108,125127,108,118001,108,120783,73,120793,73,120803,73,120813,73,120823,73,130033,73,65321,73,8544,73,8464,73,8465,73,117982,108,119816,73,119868,73,119920,73,120024,73,120128,73,120180,73,120232,73,120284,73,120336,73,120388,73,120440,73,65356,108,8572,73,8467,108,119845,108,119897,108,119949,108,120001,108,120053,108,120105,73,120157,73,120209,73,120261,73,120313,73,120365,73,120417,73,120469,73,448,73,120496,73,120554,73,120612,73,120670,73,120728,73,11410,73,1030,73,1216,73,1493,108,1503,108,1575,108,126464,108,126592,108,65166,108,65165,108,1994,108,11599,73,5825,73,42226,73,93992,73,66186,124,66313,124,119338,76,8556,76,8466,76,117985,76,119819,76,119871,76,119923,76,120027,76,120079,76,120131,76,120183,76,120235,76,120287,76,120339,76,120391,76,120443,76,11472,76,5086,76,5290,76,42209,76,93974,76,71843,76,71858,76,66587,76,66854,76,65325,77,8559,77,8499,77,117986,77,119820,77,119872,77,119924,77,120028,77,120080,77,120132,77,120184,77,120236,77,120288,77,120340,77,120392,77,120444,77,924,77,120499,77,120557,77,120615,77,120673,77,120731,77,1018,77,11416,77,5047,77,5616,77,5846,77,42207,77,66224,77,66321,77,119847,110,119899,110,119951,110,120003,110,120055,110,120107,110,120159,110,120211,110,120263,110,120315,110,120367,110,120419,110,120471,110,1400,110,1404,110,65326,78,8469,78,117987,78,119821,78,119873,78,119925,78,119977,78,120029,78,120081,78,120185,78,120237,78,120289,78,120341,78,120393,78,120445,78,925,78,120500,78,120558,78,120616,78,120674,78,120732,78,11418,78,42208,78,66835,78,3074,111,3202,111,3330,111,3458,111,2406,111,2662,111,2790,111,3046,111,3174,111,3302,111,3430,111,3664,111,3792,111,4160,111,1637,111,1781,111,65359,111,8500,111,119848,111,119900,111,119952,111,120056,111,120108,111,120160,111,120212,111,120264,111,120316,111,120368,111,120420,111,120472,111,7439,111,7441,111,43837,111,959,111,120528,111,120586,111,120644,111,120702,111,120760,111,963,111,120532,111,120590,111,120648,111,120706,111,120764,111,11423,111,4351,111,1413,111,1505,111,1607,111,126500,111,126564,111,126596,111,65259,111,65260,111,65258,111,65257,111,1726,111,64428,111,64429,111,64427,111,64426,111,1729,111,64424,111,64425,111,64423,111,64422,111,1749,111,3360,111,4125,111,66794,111,71880,111,71895,111,66604,111,1984,79,2534,79,2918,79,12295,79,70864,79,71904,79,118000,79,120782,79,120792,79,120802,79,120812,79,120822,79,130032,79,65327,79,117988,79,119822,79,119874,79,119926,79,119978,79,120030,79,120082,79,120134,79,120186,79,120238,79,120290,79,120342,79,120394,79,120446,79,927,79,120502,79,120560,79,120618,79,120676,79,120734,79,11422,79,1365,79,11604,79,4816,79,2848,79,66754,79,42227,79,71861,79,66194,79,66219,79,66564,79,66838,79,9076,112,65360,112,119849,112,119901,112,119953,112,120005,112,120057,112,120109,112,120161,112,120213,112,120265,112,120317,112,120369,112,120421,112,120473,112,961,112,120530,112,120544,112,120588,112,120602,112,120646,112,120660,112,120704,112,120718,112,120762,112,120776,112,11427,112,65328,80,8473,80,117989,80,119823,80,119875,80,119927,80,119979,80,120031,80,120083,80,120187,80,120239,80,120291,80,120343,80,120395,80,120447,80,929,80,120504,80,120562,80,120620,80,120678,80,120736,80,11426,80,5090,80,5229,80,42193,80,66197,80,119850,113,119902,113,119954,113,120006,113,120058,113,120110,113,120162,113,120214,113,120266,113,120318,113,120370,113,120422,113,120474,113,1307,113,1379,113,1382,113,8474,81,117990,81,119824,81,119876,81,119928,81,119980,81,120032,81,120084,81,120188,81,120240,81,120292,81,120344,81,120396,81,120448,81,11605,81,119851,114,119903,114,119955,114,120007,114,120059,114,120111,114,120163,114,120215,114,120267,114,120319,114,120371,114,120423,114,120475,114,43847,114,43848,114,7462,114,11397,114,43905,114,119318,82,8475,82,8476,82,8477,82,117991,82,119825,82,119877,82,119929,82,120033,82,120189,82,120241,82,120293,82,120345,82,120397,82,120449,82,422,82,5025,82,5074,82,66740,82,5511,82,42211,82,94005,82,65363,115,119852,115,119904,115,119956,115,120008,115,120060,115,120112,115,120164,115,120216,115,120268,115,120320,115,120372,115,120424,115,120476,115,42801,115,445,115,1109,115,43946,115,71873,115,66632,115,65331,83,117992,83,119826,83,119878,83,119930,83,119982,83,120034,83,120086,83,120138,83,120190,83,120242,83,120294,83,120346,83,120398,83,120450,83,1029,83,1359,83,5077,83,5082,83,42210,83,94010,83,66198,83,66592,83,119853,116,119905,116,119957,116,120009,116,120061,116,120113,116,120165,116,120217,116,120269,116,120321,116,120373,116,120425,116,120477,116,8868,84,10201,84,128872,84,65332,84,117993,84,119827,84,119879,84,119931,84,119983,84,120035,84,120087,84,120139,84,120191,84,120243,84,120295,84,120347,84,120399,84,120451,84,932,84,120507,84,120565,84,120623,84,120681,84,120739,84,11430,84,5026,84,42196,84,93962,84,71868,84,66199,84,66225,84,66325,84,119854,117,119906,117,119958,117,120010,117,120062,117,120114,117,120166,117,120218,117,120270,117,120322,117,120374,117,120426,117,120478,117,42911,117,7452,117,43854,117,43858,117,651,117,965,117,120534,117,120592,117,120650,117,120708,117,120766,117,1405,117,66806,117,71896,117,8746,85,8899,85,117994,85,119828,85,119880,85,119932,85,119984,85,120036,85,120088,85,120140,85,120192,85,120244,85,120296,85,120348,85,120400,85,120452,85,1357,85,4608,85,66766,85,5196,85,42228,85,94018,85,71864,85,8744,118,8897,118,65366,118,8564,118,119855,118,119907,118,119959,118,120011,118,120063,118,120115,118,120167,118,120219,118,120271,118,120323,118,120375,118,120427,118,120479,118,7456,118,957,118,120526,118,120584,118,120642,118,120700,118,120758,118,1141,118,1496,118,71430,118,43945,118,71872,118,119309,86,1639,86,1783,86,8548,86,117995,86,119829,86,119881,86,119933,86,119985,86,120037,86,120089,86,120141,86,120193,86,120245,86,120297,86,120349,86,120401,86,120453,86,1140,86,11576,86,5081,86,5167,86,42719,86,42214,86,93960,86,71840,86,66845,86,623,119,119856,119,119908,119,119960,119,120012,119,120064,119,120116,119,120168,119,120220,119,120272,119,120324,119,120376,119,120428,119,120480,119,7457,119,1121,119,1309,119,1377,119,71434,119,71438,119,71439,119,43907,119,71910,87,71919,87,117996,87,119830,87,119882,87,119934,87,119986,87,120038,87,120090,87,120142,87,120194,87,120246,87,120298,87,120350,87,120402,87,120454,87,1308,87,5043,87,5076,87,42218,87,5742,120,10539,120,10540,120,10799,120,65368,120,8569,120,119857,120,119909,120,119961,120,120013,120,120065,120,120117,120,120169,120,120221,120,120273,120,120325,120,120377,120,120429,120,120481,120,5441,120,5501,120,5741,88,9587,88,66338,88,71916,88,65336,88,8553,88,117997,88,119831,88,119883,88,119935,88,119987,88,120039,88,120091,88,120143,88,120195,88,120247,88,120299,88,120351,88,120403,88,120455,88,42931,88,935,88,120510,88,120568,88,120626,88,120684,88,120742,88,11436,88,11613,88,5815,88,42219,88,66192,88,66228,88,66327,88,66855,88,611,121,7564,121,65369,121,119858,121,119910,121,119962,121,120014,121,120066,121,120118,121,120170,121,120222,121,120274,121,120326,121,120378,121,120430,121,120482,121,655,121,7935,121,43866,121,947,121,8509,121,120516,121,120574,121,120632,121,120690,121,120748,121,1199,121,4327,121,71900,121,65337,89,117998,89,119832,89,119884,89,119936,89,119988,89,120040,89,120092,89,120144,89,120196,89,120248,89,120300,89,120352,89,120404,89,120456,89,933,89,978,89,120508,89,120566,89,120624,89,120682,89,120740,89,11432,89,1198,89,5033,89,5053,89,42220,89,94019,89,71844,89,66226,89,119859,122,119911,122,119963,122,120015,122,120067,122,120119,122,120171,122,120223,122,120275,122,120327,122,120379,122,120431,122,120483,122,7458,122,43923,122,71876,122,71909,90,66293,90,65338,90,8484,90,8488,90,117999,90,119833,90,119885,90,119937,90,119989,90,120041,90,120197,90,120249,90,120301,90,120353,90,120405,90,120457,90,918,90,120493,90,120551,90,120609,90,120667,90,120725,90,5059,90,42204,90,71849,90,65282,34,65283,35,65284,36,65285,37,65286,38,65290,42,65291,43,65294,46,65295,47,65296,48,65298,50,65299,51,65300,52,65301,53,65302,54,65303,55,65304,56,65305,57,65308,60,65309,61,65310,62,65312,64,65316,68,65318,70,65319,71,65324,76,65329,81,65330,82,65333,85,65334,86,65335,87,65343,95,65346,98,65348,100,65350,102,65355,107,65357,109,65358,110,65361,113,65362,114,65364,116,65365,117,65367,119,65370,122,65371,123,65373,125,119846,109],"_default":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8217,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"cs":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"de":[65374,126,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"es":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"fr":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"it":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ja":[8211,45,8218,44,65281,33,8216,96,8245,96,180,96,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65292,44,65297,49,65307,59],"ko":[8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pl":[65374,126,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"pt-BR":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"qps-ploc":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"ru":[65374,126,8218,44,65306,58,65281,33,8216,96,8245,96,180,96,12494,47,305,105,921,73,1009,112,215,120,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"tr":[160,32,8211,45,65374,126,8218,44,65306,58,65281,33,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65288,40,65289,41,65292,44,65297,49,65307,59,65311,63],"zh-hans":[160,32,65374,126,8218,44,8245,96,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89,65297,49],"zh-hant":[8211,45,65374,126,8218,44,180,96,12494,47,1047,51,1073,54,1072,97,1040,65,1068,98,1042,66,1089,99,1057,67,1077,101,1045,69,1053,72,305,105,1050,75,921,73,1052,77,1086,111,1054,79,1009,112,1088,112,1056,80,1075,114,1058,84,215,120,1093,120,1061,88,1091,121,1059,89]}');
        });
      }
      static {
        this.d = new $1f({ getCacheKey: JSON.stringify }, (locales) => {
          function arrayToMap(arr) {
            const result = /* @__PURE__ */ new Map();
            for (let i = 0; i < arr.length; i += 2) {
              result.set(arr[i], arr[i + 1]);
            }
            return result;
          }
          function mergeMaps(map1, map2) {
            const result = new Map(map1);
            for (const [key, value] of map2) {
              result.set(key, value);
            }
            return result;
          }
          function intersectMaps(map1, map2) {
            if (!map1) {
              return map2;
            }
            const result = /* @__PURE__ */ new Map();
            for (const [key, value] of map1) {
              if (map2.has(key)) {
                result.set(key, value);
              }
            }
            return result;
          }
          const data = this.c.value;
          let filteredLocales = locales.filter((l) => !l.startsWith("_") && l in data);
          if (filteredLocales.length === 0) {
            filteredLocales = ["_default"];
          }
          let languageSpecificMap = void 0;
          for (const locale of filteredLocales) {
            const map2 = arrayToMap(data[locale]);
            languageSpecificMap = intersectMaps(languageSpecificMap, map2);
          }
          const commonMap = arrayToMap(data["_common"]);
          const map = mergeMaps(commonMap, languageSpecificMap);
          return new _$9g(map);
        });
      }
      static getInstance(locales) {
        return _$9g.d.get(Array.from(locales));
      }
      static {
        this.e = new $3f(() => Object.keys(_$9g.c.value).filter((k) => !k.startsWith("_")));
      }
      static getLocales() {
        return _$9g.e.value;
      }
      constructor(f) {
        this.f = f;
      }
      isAmbiguous(codePoint) {
        return this.f.has(codePoint);
      }
      containsAmbiguousCharacter(str) {
        for (let i = 0; i < str.length; i++) {
          const codePoint = str.codePointAt(i);
          if (typeof codePoint === "number" && this.isAmbiguous(codePoint)) {
            return true;
          }
        }
        return false;
      }
      /**
       * Returns the non basic ASCII code point that the given code point can be confused,
       * or undefined if such code point does note exist.
       */
      getPrimaryConfusable(codePoint) {
        return this.f.get(codePoint);
      }
      getConfusableCodePoints() {
        return new Set(this.f.keys());
      }
    };
    $0g = class _$0g {
      static c() {
        return JSON.parse('{"_common":[11,12,13,127,847,1564,4447,4448,6068,6069,6155,6156,6157,6158,7355,7356,8192,8193,8194,8195,8196,8197,8198,8199,8200,8201,8202,8204,8205,8206,8207,8234,8235,8236,8237,8238,8239,8287,8288,8289,8290,8291,8292,8293,8294,8295,8296,8297,8298,8299,8300,8301,8302,8303,10240,12644,65024,65025,65026,65027,65028,65029,65030,65031,65032,65033,65034,65035,65036,65037,65038,65039,65279,65440,65520,65521,65522,65523,65524,65525,65526,65527,65528,65532,78844,119155,119156,119157,119158,119159,119160,119161,119162,917504,917505,917506,917507,917508,917509,917510,917511,917512,917513,917514,917515,917516,917517,917518,917519,917520,917521,917522,917523,917524,917525,917526,917527,917528,917529,917530,917531,917532,917533,917534,917535,917536,917537,917538,917539,917540,917541,917542,917543,917544,917545,917546,917547,917548,917549,917550,917551,917552,917553,917554,917555,917556,917557,917558,917559,917560,917561,917562,917563,917564,917565,917566,917567,917568,917569,917570,917571,917572,917573,917574,917575,917576,917577,917578,917579,917580,917581,917582,917583,917584,917585,917586,917587,917588,917589,917590,917591,917592,917593,917594,917595,917596,917597,917598,917599,917600,917601,917602,917603,917604,917605,917606,917607,917608,917609,917610,917611,917612,917613,917614,917615,917616,917617,917618,917619,917620,917621,917622,917623,917624,917625,917626,917627,917628,917629,917630,917631,917760,917761,917762,917763,917764,917765,917766,917767,917768,917769,917770,917771,917772,917773,917774,917775,917776,917777,917778,917779,917780,917781,917782,917783,917784,917785,917786,917787,917788,917789,917790,917791,917792,917793,917794,917795,917796,917797,917798,917799,917800,917801,917802,917803,917804,917805,917806,917807,917808,917809,917810,917811,917812,917813,917814,917815,917816,917817,917818,917819,917820,917821,917822,917823,917824,917825,917826,917827,917828,917829,917830,917831,917832,917833,917834,917835,917836,917837,917838,917839,917840,917841,917842,917843,917844,917845,917846,917847,917848,917849,917850,917851,917852,917853,917854,917855,917856,917857,917858,917859,917860,917861,917862,917863,917864,917865,917866,917867,917868,917869,917870,917871,917872,917873,917874,917875,917876,917877,917878,917879,917880,917881,917882,917883,917884,917885,917886,917887,917888,917889,917890,917891,917892,917893,917894,917895,917896,917897,917898,917899,917900,917901,917902,917903,917904,917905,917906,917907,917908,917909,917910,917911,917912,917913,917914,917915,917916,917917,917918,917919,917920,917921,917922,917923,917924,917925,917926,917927,917928,917929,917930,917931,917932,917933,917934,917935,917936,917937,917938,917939,917940,917941,917942,917943,917944,917945,917946,917947,917948,917949,917950,917951,917952,917953,917954,917955,917956,917957,917958,917959,917960,917961,917962,917963,917964,917965,917966,917967,917968,917969,917970,917971,917972,917973,917974,917975,917976,917977,917978,917979,917980,917981,917982,917983,917984,917985,917986,917987,917988,917989,917990,917991,917992,917993,917994,917995,917996,917997,917998,917999],"cs":[173,8203,12288],"de":[173,8203,12288],"es":[8203,12288],"fr":[173,8203,12288],"it":[160,173,12288],"ja":[173],"ko":[173,12288],"pl":[173,8203,12288],"pt-BR":[173,8203,12288],"qps-ploc":[160,173,8203,12288],"ru":[173,12288],"tr":[160,173,8203,12288],"zh-hans":[160,173,8203,12288],"zh-hant":[173,12288]}');
      }
      static {
        this.d = void 0;
      }
      static e() {
        if (!this.d) {
          this.d = new Set([...Object.values(_$0g.c())].flat());
        }
        return this.d;
      }
      static isInvisibleCharacter(codePoint) {
        return _$0g.e().has(codePoint);
      }
      static containsInvisibleCharacter(str) {
        for (let i = 0; i < str.length; i++) {
          const codePoint = str.codePointAt(i);
          if (typeof codePoint === "number" && (_$0g.isInvisibleCharacter(codePoint) || codePoint === 32)) {
            return true;
          }
        }
        return false;
      }
      static get codePoints() {
        return _$0g.e();
      }
    };
  }
});

// out-build/vs/base/common/process.js
var safeProcess, vscodeGlobal, cwd, env, $ic, $jc;
var init_process = __esm({
  "out-build/vs/base/common/process.js"() {
    "use strict";
    init_platform();
    vscodeGlobal = globalThis.vscode;
    if (typeof vscodeGlobal !== "undefined" && typeof vscodeGlobal.process !== "undefined") {
      const sandboxProcess = vscodeGlobal.process;
      safeProcess = {
        get platform() {
          return sandboxProcess.platform;
        },
        get arch() {
          return sandboxProcess.arch;
        },
        get env() {
          return sandboxProcess.env;
        },
        cwd() {
          return sandboxProcess.cwd();
        }
      };
    } else if (typeof process !== "undefined" && typeof process?.versions?.node === "string") {
      safeProcess = {
        get platform() {
          return process.platform;
        },
        get arch() {
          return process.arch;
        },
        get env() {
          return process.env;
        },
        cwd() {
          return process.env["VSCODE_CWD"] || process.cwd();
        }
      };
    } else {
      safeProcess = {
        // Supported
        get platform() {
          return $l ? "win32" : $m ? "darwin" : "linux";
        },
        get arch() {
          return void 0;
        },
        // Unsupported
        get env() {
          return {};
        },
        cwd() {
          return "/";
        }
      };
    }
    cwd = safeProcess.cwd;
    env = safeProcess.env;
    $ic = safeProcess.platform;
    $jc = safeProcess.arch;
  }
});

// out-build/vs/base/common/path.js
function validateObject(pathObject, name) {
  if (pathObject === null || typeof pathObject !== "object") {
    throw new ErrorInvalidArgType(name, "Object", pathObject);
  }
}
function validateString(value, name) {
  if (typeof value !== "string") {
    throw new ErrorInvalidArgType(name, "string", value);
  }
}
function isPathSeparator(code) {
  return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
}
function isPosixPathSeparator(code) {
  return code === CHAR_FORWARD_SLASH;
}
function isWindowsDeviceRoot(code) {
  return code >= CHAR_UPPERCASE_A && code <= CHAR_UPPERCASE_Z || code >= CHAR_LOWERCASE_A && code <= CHAR_LOWERCASE_Z;
}
function normalizeString(path7, allowAboveRoot, separator, isPathSeparator2) {
  let res = "";
  let lastSegmentLength = 0;
  let lastSlash = -1;
  let dots = 0;
  let code = 0;
  for (let i = 0; i <= path7.length; ++i) {
    if (i < path7.length) {
      code = path7.charCodeAt(i);
    } else if (isPathSeparator2(code)) {
      break;
    } else {
      code = CHAR_FORWARD_SLASH;
    }
    if (isPathSeparator2(code)) {
      if (lastSlash === i - 1 || dots === 1) {
      } else if (dots === 2) {
        if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== CHAR_DOT || res.charCodeAt(res.length - 2) !== CHAR_DOT) {
          if (res.length > 2) {
            const lastSlashIndex = res.lastIndexOf(separator);
            if (lastSlashIndex === -1) {
              res = "";
              lastSegmentLength = 0;
            } else {
              res = res.slice(0, lastSlashIndex);
              lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
            }
            lastSlash = i;
            dots = 0;
            continue;
          } else if (res.length !== 0) {
            res = "";
            lastSegmentLength = 0;
            lastSlash = i;
            dots = 0;
            continue;
          }
        }
        if (allowAboveRoot) {
          res += res.length > 0 ? `${separator}..` : "..";
          lastSegmentLength = 2;
        }
      } else {
        if (res.length > 0) {
          res += `${separator}${path7.slice(lastSlash + 1, i)}`;
        } else {
          res = path7.slice(lastSlash + 1, i);
        }
        lastSegmentLength = i - lastSlash - 1;
      }
      lastSlash = i;
      dots = 0;
    } else if (code === CHAR_DOT && dots !== -1) {
      ++dots;
    } else {
      dots = -1;
    }
  }
  return res;
}
function formatExt(ext) {
  return ext ? `${ext[0] === "." ? "" : "."}${ext}` : "";
}
function _format2(sep2, pathObject) {
  validateObject(pathObject, "pathObject");
  const dir = pathObject.dir || pathObject.root;
  const base = pathObject.base || `${pathObject.name || ""}${formatExt(pathObject.ext)}`;
  if (!dir) {
    return base;
  }
  return dir === pathObject.root ? `${dir}${base}` : `${dir}${sep2}${base}`;
}
var CHAR_UPPERCASE_A, CHAR_LOWERCASE_A, CHAR_UPPERCASE_Z, CHAR_LOWERCASE_Z, CHAR_DOT, CHAR_FORWARD_SLASH, CHAR_BACKWARD_SLASH, CHAR_COLON, CHAR_QUESTION_MARK, ErrorInvalidArgType, platformIsWin32, $kc, posixCwd, $lc, $mc, $nc, $oc, $pc, $qc, $rc, $sc, $tc, $uc, $vc, $wc, sep, $yc;
var init_path = __esm({
  "out-build/vs/base/common/path.js"() {
    "use strict";
    init_process();
    CHAR_UPPERCASE_A = 65;
    CHAR_LOWERCASE_A = 97;
    CHAR_UPPERCASE_Z = 90;
    CHAR_LOWERCASE_Z = 122;
    CHAR_DOT = 46;
    CHAR_FORWARD_SLASH = 47;
    CHAR_BACKWARD_SLASH = 92;
    CHAR_COLON = 58;
    CHAR_QUESTION_MARK = 63;
    ErrorInvalidArgType = class extends Error {
      constructor(name, expected, actual) {
        let determiner;
        if (typeof expected === "string" && expected.indexOf("not ") === 0) {
          determiner = "must not be";
          expected = expected.replace(/^not /, "");
        } else {
          determiner = "must be";
        }
        const type2 = name.indexOf(".") !== -1 ? "property" : "argument";
        let msg = `The "${name}" ${type2} ${determiner} of type ${expected}`;
        msg += `. Received type ${typeof actual}`;
        super(msg);
        this.code = "ERR_INVALID_ARG_TYPE";
      }
    };
    platformIsWin32 = $ic === "win32";
    $kc = {
      // path.resolve([from ...], to)
      resolve(...pathSegments) {
        let resolvedDevice = "";
        let resolvedTail = "";
        let resolvedAbsolute = false;
        for (let i = pathSegments.length - 1; i >= -1; i--) {
          let path7;
          if (i >= 0) {
            path7 = pathSegments[i];
            validateString(path7, `paths[${i}]`);
            if (path7.length === 0) {
              continue;
            }
          } else if (resolvedDevice.length === 0) {
            path7 = cwd();
          } else {
            path7 = env[`=${resolvedDevice}`] || cwd();
            if (path7 === void 0 || path7.slice(0, 2).toLowerCase() !== resolvedDevice.toLowerCase() && path7.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
              path7 = `${resolvedDevice}\\`;
            }
          }
          const len = path7.length;
          let rootEnd = 0;
          let device = "";
          let isAbsolute2 = false;
          const code = path7.charCodeAt(0);
          if (len === 1) {
            if (isPathSeparator(code)) {
              rootEnd = 1;
              isAbsolute2 = true;
            }
          } else if (isPathSeparator(code)) {
            isAbsolute2 = true;
            if (isPathSeparator(path7.charCodeAt(1))) {
              let j = 2;
              let last = j;
              while (j < len && !isPathSeparator(path7.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                const firstPart = path7.slice(last, j);
                last = j;
                while (j < len && isPathSeparator(path7.charCodeAt(j))) {
                  j++;
                }
                if (j < len && j !== last) {
                  last = j;
                  while (j < len && !isPathSeparator(path7.charCodeAt(j))) {
                    j++;
                  }
                  if (j === len || j !== last) {
                    device = `\\\\${firstPart}\\${path7.slice(last, j)}`;
                    rootEnd = j;
                  }
                }
              }
            } else {
              rootEnd = 1;
            }
          } else if (isWindowsDeviceRoot(code) && path7.charCodeAt(1) === CHAR_COLON) {
            device = path7.slice(0, 2);
            rootEnd = 2;
            if (len > 2 && isPathSeparator(path7.charCodeAt(2))) {
              isAbsolute2 = true;
              rootEnd = 3;
            }
          }
          if (device.length > 0) {
            if (resolvedDevice.length > 0) {
              if (device.toLowerCase() !== resolvedDevice.toLowerCase()) {
                continue;
              }
            } else {
              resolvedDevice = device;
            }
          }
          if (resolvedAbsolute) {
            if (resolvedDevice.length > 0) {
              break;
            }
          } else {
            resolvedTail = `${path7.slice(rootEnd)}\\${resolvedTail}`;
            resolvedAbsolute = isAbsolute2;
            if (isAbsolute2 && resolvedDevice.length > 0) {
              break;
            }
          }
        }
        resolvedTail = normalizeString(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator);
        return resolvedAbsolute ? `${resolvedDevice}\\${resolvedTail}` : `${resolvedDevice}${resolvedTail}` || ".";
      },
      normalize(path7) {
        validateString(path7, "path");
        const len = path7.length;
        if (len === 0) {
          return ".";
        }
        let rootEnd = 0;
        let device;
        let isAbsolute2 = false;
        const code = path7.charCodeAt(0);
        if (len === 1) {
          return isPosixPathSeparator(code) ? "\\" : path7;
        }
        if (isPathSeparator(code)) {
          isAbsolute2 = true;
          if (isPathSeparator(path7.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator(path7.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              const firstPart = path7.slice(last, j);
              last = j;
              while (j < len && isPathSeparator(path7.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator(path7.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  return `\\\\${firstPart}\\${path7.slice(last)}\\`;
                }
                if (j !== last) {
                  device = `\\\\${firstPart}\\${path7.slice(last, j)}`;
                  rootEnd = j;
                }
              }
            }
          } else {
            rootEnd = 1;
          }
        } else if (isWindowsDeviceRoot(code) && path7.charCodeAt(1) === CHAR_COLON) {
          device = path7.slice(0, 2);
          rootEnd = 2;
          if (len > 2 && isPathSeparator(path7.charCodeAt(2))) {
            isAbsolute2 = true;
            rootEnd = 3;
          }
        }
        let tail = rootEnd < len ? normalizeString(path7.slice(rootEnd), !isAbsolute2, "\\", isPathSeparator) : "";
        if (tail.length === 0 && !isAbsolute2) {
          tail = ".";
        }
        if (tail.length > 0 && isPathSeparator(path7.charCodeAt(len - 1))) {
          tail += "\\";
        }
        if (!isAbsolute2 && device === void 0 && path7.includes(":")) {
          if (tail.length >= 2 && isWindowsDeviceRoot(tail.charCodeAt(0)) && tail.charCodeAt(1) === CHAR_COLON) {
            return `.\\${tail}`;
          }
          let index = path7.indexOf(":");
          do {
            if (index === len - 1 || isPathSeparator(path7.charCodeAt(index + 1))) {
              return `.\\${tail}`;
            }
          } while ((index = path7.indexOf(":", index + 1)) !== -1);
        }
        if (device === void 0) {
          return isAbsolute2 ? `\\${tail}` : tail;
        }
        return isAbsolute2 ? `${device}\\${tail}` : `${device}${tail}`;
      },
      isAbsolute(path7) {
        validateString(path7, "path");
        const len = path7.length;
        if (len === 0) {
          return false;
        }
        const code = path7.charCodeAt(0);
        return isPathSeparator(code) || // Possible device root
        len > 2 && isWindowsDeviceRoot(code) && path7.charCodeAt(1) === CHAR_COLON && isPathSeparator(path7.charCodeAt(2));
      },
      join(...paths) {
        if (paths.length === 0) {
          return ".";
        }
        let joined;
        let firstPart;
        for (let i = 0; i < paths.length; ++i) {
          const arg = paths[i];
          validateString(arg, "path");
          if (arg.length > 0) {
            if (joined === void 0) {
              joined = firstPart = arg;
            } else {
              joined += `\\${arg}`;
            }
          }
        }
        if (joined === void 0) {
          return ".";
        }
        let needsReplace = true;
        let slashCount = 0;
        if (typeof firstPart === "string" && isPathSeparator(firstPart.charCodeAt(0))) {
          ++slashCount;
          const firstLen = firstPart.length;
          if (firstLen > 1 && isPathSeparator(firstPart.charCodeAt(1))) {
            ++slashCount;
            if (firstLen > 2) {
              if (isPathSeparator(firstPart.charCodeAt(2))) {
                ++slashCount;
              } else {
                needsReplace = false;
              }
            }
          }
        }
        if (needsReplace) {
          while (slashCount < joined.length && isPathSeparator(joined.charCodeAt(slashCount))) {
            slashCount++;
          }
          if (slashCount >= 2) {
            joined = `\\${joined.slice(slashCount)}`;
          }
        }
        return $kc.normalize(joined);
      },
      // It will solve the relative path from `from` to `to`, for instance:
      //  from = 'C:\\orandea\\test\\aaa'
      //  to = 'C:\\orandea\\impl\\bbb'
      // The output of the function should be: '..\\..\\impl\\bbb'
      relative(from, to) {
        validateString(from, "from");
        validateString(to, "to");
        if (from === to) {
          return "";
        }
        const fromOrig = $kc.resolve(from);
        const toOrig = $kc.resolve(to);
        if (fromOrig === toOrig) {
          return "";
        }
        from = fromOrig.toLowerCase();
        to = toOrig.toLowerCase();
        if (from === to) {
          return "";
        }
        if (fromOrig.length !== from.length || toOrig.length !== to.length) {
          const fromSplit = fromOrig.split("\\");
          const toSplit = toOrig.split("\\");
          if (fromSplit[fromSplit.length - 1] === "") {
            fromSplit.pop();
          }
          if (toSplit[toSplit.length - 1] === "") {
            toSplit.pop();
          }
          const fromLen2 = fromSplit.length;
          const toLen2 = toSplit.length;
          const length2 = fromLen2 < toLen2 ? fromLen2 : toLen2;
          let i2;
          for (i2 = 0; i2 < length2; i2++) {
            if (fromSplit[i2].toLowerCase() !== toSplit[i2].toLowerCase()) {
              break;
            }
          }
          if (i2 === 0) {
            return toOrig;
          } else if (i2 === length2) {
            if (toLen2 > length2) {
              return toSplit.slice(i2).join("\\");
            }
            if (fromLen2 > length2) {
              return "..\\".repeat(fromLen2 - 1 - i2) + "..";
            }
            return "";
          }
          return "..\\".repeat(fromLen2 - i2) + toSplit.slice(i2).join("\\");
        }
        let fromStart = 0;
        while (fromStart < from.length && from.charCodeAt(fromStart) === CHAR_BACKWARD_SLASH) {
          fromStart++;
        }
        let fromEnd = from.length;
        while (fromEnd - 1 > fromStart && from.charCodeAt(fromEnd - 1) === CHAR_BACKWARD_SLASH) {
          fromEnd--;
        }
        const fromLen = fromEnd - fromStart;
        let toStart = 0;
        while (toStart < to.length && to.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
          toStart++;
        }
        let toEnd = to.length;
        while (toEnd - 1 > toStart && to.charCodeAt(toEnd - 1) === CHAR_BACKWARD_SLASH) {
          toEnd--;
        }
        const toLen = toEnd - toStart;
        const length = fromLen < toLen ? fromLen : toLen;
        let lastCommonSep = -1;
        let i = 0;
        for (; i < length; i++) {
          const fromCode = from.charCodeAt(fromStart + i);
          if (fromCode !== to.charCodeAt(toStart + i)) {
            break;
          } else if (fromCode === CHAR_BACKWARD_SLASH) {
            lastCommonSep = i;
          }
        }
        if (i !== length) {
          if (lastCommonSep === -1) {
            return toOrig;
          }
        } else {
          if (toLen > length) {
            if (to.charCodeAt(toStart + i) === CHAR_BACKWARD_SLASH) {
              return toOrig.slice(toStart + i + 1);
            }
            if (i === 2) {
              return toOrig.slice(toStart + i);
            }
          }
          if (fromLen > length) {
            if (from.charCodeAt(fromStart + i) === CHAR_BACKWARD_SLASH) {
              lastCommonSep = i;
            } else if (i === 2) {
              lastCommonSep = 3;
            }
          }
          if (lastCommonSep === -1) {
            lastCommonSep = 0;
          }
        }
        let out = "";
        for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
          if (i === fromEnd || from.charCodeAt(i) === CHAR_BACKWARD_SLASH) {
            out += out.length === 0 ? ".." : "\\..";
          }
        }
        toStart += lastCommonSep;
        if (out.length > 0) {
          return `${out}${toOrig.slice(toStart, toEnd)}`;
        }
        if (toOrig.charCodeAt(toStart) === CHAR_BACKWARD_SLASH) {
          ++toStart;
        }
        return toOrig.slice(toStart, toEnd);
      },
      toNamespacedPath(path7) {
        if (typeof path7 !== "string" || path7.length === 0) {
          return path7;
        }
        const resolvedPath = $kc.resolve(path7);
        if (resolvedPath.length <= 2) {
          return path7;
        }
        if (resolvedPath.charCodeAt(0) === CHAR_BACKWARD_SLASH) {
          if (resolvedPath.charCodeAt(1) === CHAR_BACKWARD_SLASH) {
            const code = resolvedPath.charCodeAt(2);
            if (code !== CHAR_QUESTION_MARK && code !== CHAR_DOT) {
              return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
            }
          }
        } else if (isWindowsDeviceRoot(resolvedPath.charCodeAt(0)) && resolvedPath.charCodeAt(1) === CHAR_COLON && resolvedPath.charCodeAt(2) === CHAR_BACKWARD_SLASH) {
          return `\\\\?\\${resolvedPath}`;
        }
        return resolvedPath;
      },
      dirname(path7) {
        validateString(path7, "path");
        const len = path7.length;
        if (len === 0) {
          return ".";
        }
        let rootEnd = -1;
        let offset = 0;
        const code = path7.charCodeAt(0);
        if (len === 1) {
          return isPathSeparator(code) ? path7 : ".";
        }
        if (isPathSeparator(code)) {
          rootEnd = offset = 1;
          if (isPathSeparator(path7.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator(path7.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && isPathSeparator(path7.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator(path7.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  return path7;
                }
                if (j !== last) {
                  rootEnd = offset = j + 1;
                }
              }
            }
          }
        } else if (isWindowsDeviceRoot(code) && path7.charCodeAt(1) === CHAR_COLON) {
          rootEnd = len > 2 && isPathSeparator(path7.charCodeAt(2)) ? 3 : 2;
          offset = rootEnd;
        }
        let end = -1;
        let matchedSlash = true;
        for (let i = len - 1; i >= offset; --i) {
          if (isPathSeparator(path7.charCodeAt(i))) {
            if (!matchedSlash) {
              end = i;
              break;
            }
          } else {
            matchedSlash = false;
          }
        }
        if (end === -1) {
          if (rootEnd === -1) {
            return ".";
          }
          end = rootEnd;
        }
        return path7.slice(0, end);
      },
      basename(path7, suffix) {
        if (suffix !== void 0) {
          validateString(suffix, "suffix");
        }
        validateString(path7, "path");
        let start = 0;
        let end = -1;
        let matchedSlash = true;
        let i;
        if (path7.length >= 2 && isWindowsDeviceRoot(path7.charCodeAt(0)) && path7.charCodeAt(1) === CHAR_COLON) {
          start = 2;
        }
        if (suffix !== void 0 && suffix.length > 0 && suffix.length <= path7.length) {
          if (suffix === path7) {
            return "";
          }
          let extIdx = suffix.length - 1;
          let firstNonSlashEnd = -1;
          for (i = path7.length - 1; i >= start; --i) {
            const code = path7.charCodeAt(i);
            if (isPathSeparator(code)) {
              if (!matchedSlash) {
                start = i + 1;
                break;
              }
            } else {
              if (firstNonSlashEnd === -1) {
                matchedSlash = false;
                firstNonSlashEnd = i + 1;
              }
              if (extIdx >= 0) {
                if (code === suffix.charCodeAt(extIdx)) {
                  if (--extIdx === -1) {
                    end = i;
                  }
                } else {
                  extIdx = -1;
                  end = firstNonSlashEnd;
                }
              }
            }
          }
          if (start === end) {
            end = firstNonSlashEnd;
          } else if (end === -1) {
            end = path7.length;
          }
          return path7.slice(start, end);
        }
        for (i = path7.length - 1; i >= start; --i) {
          if (isPathSeparator(path7.charCodeAt(i))) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
        }
        if (end === -1) {
          return "";
        }
        return path7.slice(start, end);
      },
      extname(path7) {
        validateString(path7, "path");
        let start = 0;
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let preDotState = 0;
        if (path7.length >= 2 && path7.charCodeAt(1) === CHAR_COLON && isWindowsDeviceRoot(path7.charCodeAt(0))) {
          start = startPart = 2;
        }
        for (let i = path7.length - 1; i >= start; --i) {
          const code = path7.charCodeAt(i);
          if (isPathSeparator(code)) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code === CHAR_DOT) {
            if (startDot === -1) {
              startDot = i;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          return "";
        }
        return path7.slice(startDot, end);
      },
      format: _format2.bind(null, "\\"),
      parse(path7) {
        validateString(path7, "path");
        const ret = { root: "", dir: "", base: "", ext: "", name: "" };
        if (path7.length === 0) {
          return ret;
        }
        const len = path7.length;
        let rootEnd = 0;
        let code = path7.charCodeAt(0);
        if (len === 1) {
          if (isPathSeparator(code)) {
            ret.root = ret.dir = path7;
            return ret;
          }
          ret.base = ret.name = path7;
          return ret;
        }
        if (isPathSeparator(code)) {
          rootEnd = 1;
          if (isPathSeparator(path7.charCodeAt(1))) {
            let j = 2;
            let last = j;
            while (j < len && !isPathSeparator(path7.charCodeAt(j))) {
              j++;
            }
            if (j < len && j !== last) {
              last = j;
              while (j < len && isPathSeparator(path7.charCodeAt(j))) {
                j++;
              }
              if (j < len && j !== last) {
                last = j;
                while (j < len && !isPathSeparator(path7.charCodeAt(j))) {
                  j++;
                }
                if (j === len) {
                  rootEnd = j;
                } else if (j !== last) {
                  rootEnd = j + 1;
                }
              }
            }
          }
        } else if (isWindowsDeviceRoot(code) && path7.charCodeAt(1) === CHAR_COLON) {
          if (len <= 2) {
            ret.root = ret.dir = path7;
            return ret;
          }
          rootEnd = 2;
          if (isPathSeparator(path7.charCodeAt(2))) {
            if (len === 3) {
              ret.root = ret.dir = path7;
              return ret;
            }
            rootEnd = 3;
          }
        }
        if (rootEnd > 0) {
          ret.root = path7.slice(0, rootEnd);
        }
        let startDot = -1;
        let startPart = rootEnd;
        let end = -1;
        let matchedSlash = true;
        let i = path7.length - 1;
        let preDotState = 0;
        for (; i >= rootEnd; --i) {
          code = path7.charCodeAt(i);
          if (isPathSeparator(code)) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code === CHAR_DOT) {
            if (startDot === -1) {
              startDot = i;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (end !== -1) {
          if (startDot === -1 || // We saw a non-dot character immediately before the dot
          preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
          preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
            ret.base = ret.name = path7.slice(startPart, end);
          } else {
            ret.name = path7.slice(startPart, startDot);
            ret.base = path7.slice(startPart, end);
            ret.ext = path7.slice(startDot, end);
          }
        }
        if (startPart > 0 && startPart !== rootEnd) {
          ret.dir = path7.slice(0, startPart - 1);
        } else {
          ret.dir = ret.root;
        }
        return ret;
      },
      sep: "\\",
      delimiter: ";",
      win32: null,
      posix: null
    };
    posixCwd = (() => {
      if (platformIsWin32) {
        const regexp = /\\/g;
        return () => {
          const cwd3 = cwd().replace(regexp, "/");
          return cwd3.slice(cwd3.indexOf("/"));
        };
      }
      return () => cwd();
    })();
    $lc = {
      // path.resolve([from ...], to)
      resolve(...pathSegments) {
        let resolvedPath = "";
        let resolvedAbsolute = false;
        for (let i = pathSegments.length - 1; i >= 0 && !resolvedAbsolute; i--) {
          const path7 = pathSegments[i];
          validateString(path7, `paths[${i}]`);
          if (path7.length === 0) {
            continue;
          }
          resolvedPath = `${path7}/${resolvedPath}`;
          resolvedAbsolute = path7.charCodeAt(0) === CHAR_FORWARD_SLASH;
        }
        if (!resolvedAbsolute) {
          const cwd3 = posixCwd();
          resolvedPath = `${cwd3}/${resolvedPath}`;
          resolvedAbsolute = cwd3.charCodeAt(0) === CHAR_FORWARD_SLASH;
        }
        resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator);
        if (resolvedAbsolute) {
          return `/${resolvedPath}`;
        }
        return resolvedPath.length > 0 ? resolvedPath : ".";
      },
      normalize(path7) {
        validateString(path7, "path");
        if (path7.length === 0) {
          return ".";
        }
        const isAbsolute2 = path7.charCodeAt(0) === CHAR_FORWARD_SLASH;
        const trailingSeparator = path7.charCodeAt(path7.length - 1) === CHAR_FORWARD_SLASH;
        path7 = normalizeString(path7, !isAbsolute2, "/", isPosixPathSeparator);
        if (path7.length === 0) {
          if (isAbsolute2) {
            return "/";
          }
          return trailingSeparator ? "./" : ".";
        }
        if (trailingSeparator) {
          path7 += "/";
        }
        return isAbsolute2 ? `/${path7}` : path7;
      },
      isAbsolute(path7) {
        validateString(path7, "path");
        return path7.length > 0 && path7.charCodeAt(0) === CHAR_FORWARD_SLASH;
      },
      join(...paths) {
        if (paths.length === 0) {
          return ".";
        }
        const path7 = [];
        for (let i = 0; i < paths.length; ++i) {
          const arg = paths[i];
          validateString(arg, "path");
          if (arg.length > 0) {
            path7.push(arg);
          }
        }
        if (path7.length === 0) {
          return ".";
        }
        return $lc.normalize(path7.join("/"));
      },
      relative(from, to) {
        validateString(from, "from");
        validateString(to, "to");
        if (from === to) {
          return "";
        }
        from = $lc.resolve(from);
        to = $lc.resolve(to);
        if (from === to) {
          return "";
        }
        const fromStart = 1;
        const fromEnd = from.length;
        const fromLen = fromEnd - fromStart;
        const toStart = 1;
        const toLen = to.length - toStart;
        const length = fromLen < toLen ? fromLen : toLen;
        let lastCommonSep = -1;
        let i = 0;
        for (; i < length; i++) {
          const fromCode = from.charCodeAt(fromStart + i);
          if (fromCode !== to.charCodeAt(toStart + i)) {
            break;
          } else if (fromCode === CHAR_FORWARD_SLASH) {
            lastCommonSep = i;
          }
        }
        if (i === length) {
          if (toLen > length) {
            if (to.charCodeAt(toStart + i) === CHAR_FORWARD_SLASH) {
              return to.slice(toStart + i + 1);
            }
            if (i === 0) {
              return to.slice(toStart + i);
            }
          } else if (fromLen > length) {
            if (from.charCodeAt(fromStart + i) === CHAR_FORWARD_SLASH) {
              lastCommonSep = i;
            } else if (i === 0) {
              lastCommonSep = 0;
            }
          }
        }
        let out = "";
        for (i = fromStart + lastCommonSep + 1; i <= fromEnd; ++i) {
          if (i === fromEnd || from.charCodeAt(i) === CHAR_FORWARD_SLASH) {
            out += out.length === 0 ? ".." : "/..";
          }
        }
        return `${out}${to.slice(toStart + lastCommonSep)}`;
      },
      toNamespacedPath(path7) {
        return path7;
      },
      dirname(path7) {
        validateString(path7, "path");
        if (path7.length === 0) {
          return ".";
        }
        const hasRoot = path7.charCodeAt(0) === CHAR_FORWARD_SLASH;
        let end = -1;
        let matchedSlash = true;
        for (let i = path7.length - 1; i >= 1; --i) {
          if (path7.charCodeAt(i) === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              end = i;
              break;
            }
          } else {
            matchedSlash = false;
          }
        }
        if (end === -1) {
          return hasRoot ? "/" : ".";
        }
        if (hasRoot && end === 1) {
          return "//";
        }
        return path7.slice(0, end);
      },
      basename(path7, suffix) {
        if (suffix !== void 0) {
          validateString(suffix, "suffix");
        }
        validateString(path7, "path");
        let start = 0;
        let end = -1;
        let matchedSlash = true;
        let i;
        if (suffix !== void 0 && suffix.length > 0 && suffix.length <= path7.length) {
          if (suffix === path7) {
            return "";
          }
          let extIdx = suffix.length - 1;
          let firstNonSlashEnd = -1;
          for (i = path7.length - 1; i >= 0; --i) {
            const code = path7.charCodeAt(i);
            if (code === CHAR_FORWARD_SLASH) {
              if (!matchedSlash) {
                start = i + 1;
                break;
              }
            } else {
              if (firstNonSlashEnd === -1) {
                matchedSlash = false;
                firstNonSlashEnd = i + 1;
              }
              if (extIdx >= 0) {
                if (code === suffix.charCodeAt(extIdx)) {
                  if (--extIdx === -1) {
                    end = i;
                  }
                } else {
                  extIdx = -1;
                  end = firstNonSlashEnd;
                }
              }
            }
          }
          if (start === end) {
            end = firstNonSlashEnd;
          } else if (end === -1) {
            end = path7.length;
          }
          return path7.slice(start, end);
        }
        for (i = path7.length - 1; i >= 0; --i) {
          if (path7.charCodeAt(i) === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              start = i + 1;
              break;
            }
          } else if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
        }
        if (end === -1) {
          return "";
        }
        return path7.slice(start, end);
      },
      extname(path7) {
        validateString(path7, "path");
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let preDotState = 0;
        for (let i = path7.length - 1; i >= 0; --i) {
          const char = path7[i];
          if (char === "/") {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (char === ".") {
            if (startDot === -1) {
              startDot = i;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (startDot === -1 || end === -1 || // We saw a non-dot character immediately before the dot
        preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
        preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
          return "";
        }
        return path7.slice(startDot, end);
      },
      format: _format2.bind(null, "/"),
      parse(path7) {
        validateString(path7, "path");
        const ret = { root: "", dir: "", base: "", ext: "", name: "" };
        if (path7.length === 0) {
          return ret;
        }
        const isAbsolute2 = path7.charCodeAt(0) === CHAR_FORWARD_SLASH;
        let start;
        if (isAbsolute2) {
          ret.root = "/";
          start = 1;
        } else {
          start = 0;
        }
        let startDot = -1;
        let startPart = 0;
        let end = -1;
        let matchedSlash = true;
        let i = path7.length - 1;
        let preDotState = 0;
        for (; i >= start; --i) {
          const code = path7.charCodeAt(i);
          if (code === CHAR_FORWARD_SLASH) {
            if (!matchedSlash) {
              startPart = i + 1;
              break;
            }
            continue;
          }
          if (end === -1) {
            matchedSlash = false;
            end = i + 1;
          }
          if (code === CHAR_DOT) {
            if (startDot === -1) {
              startDot = i;
            } else if (preDotState !== 1) {
              preDotState = 1;
            }
          } else if (startDot !== -1) {
            preDotState = -1;
          }
        }
        if (end !== -1) {
          const start2 = startPart === 0 && isAbsolute2 ? 1 : startPart;
          if (startDot === -1 || // We saw a non-dot character immediately before the dot
          preDotState === 0 || // The (right-most) trimmed path component is exactly '..'
          preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
            ret.base = ret.name = path7.slice(start2, end);
          } else {
            ret.name = path7.slice(start2, startDot);
            ret.base = path7.slice(start2, end);
            ret.ext = path7.slice(startDot, end);
          }
        }
        if (startPart > 0) {
          ret.dir = path7.slice(0, startPart - 1);
        } else if (isAbsolute2) {
          ret.dir = "/";
        }
        return ret;
      },
      sep: "/",
      delimiter: ":",
      win32: null,
      posix: null
    };
    $lc.win32 = $kc.win32 = $kc;
    $lc.posix = $kc.posix = $lc;
    $mc = platformIsWin32 ? $kc.normalize : $lc.normalize;
    $nc = platformIsWin32 ? $kc.isAbsolute : $lc.isAbsolute;
    $oc = platformIsWin32 ? $kc.join : $lc.join;
    $pc = platformIsWin32 ? $kc.resolve : $lc.resolve;
    $qc = platformIsWin32 ? $kc.relative : $lc.relative;
    $rc = platformIsWin32 ? $kc.dirname : $lc.dirname;
    $sc = platformIsWin32 ? $kc.basename : $lc.basename;
    $tc = platformIsWin32 ? $kc.extname : $lc.extname;
    $uc = platformIsWin32 ? $kc.format : $lc.format;
    $vc = platformIsWin32 ? $kc.parse : $lc.parse;
    $wc = platformIsWin32 ? $kc.toNamespacedPath : $lc.toNamespacedPath;
    sep = platformIsWin32 ? $kc.sep : $lc.sep;
    $yc = platformIsWin32 ? $kc.delimiter : $lc.delimiter;
  }
});

// out-build/vs/base/common/uri.js
function _validateUri(ret, _strict) {
  if (!ret.scheme && _strict) {
    throw new Error(`[UriError]: Scheme is missing: {scheme: "", authority: "${ret.authority}", path: "${ret.path}", query: "${ret.query}", fragment: "${ret.fragment}"}`);
  }
  if (ret.scheme && !_schemePattern.test(ret.scheme)) {
    throw new Error("[UriError]: Scheme contains illegal characters.");
  }
  if (ret.path) {
    if (ret.authority) {
      if (!_singleSlashStart.test(ret.path)) {
        throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
      }
    } else {
      if (_doubleSlashStart.test(ret.path)) {
        throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
      }
    }
  }
}
function _schemeFix(scheme, _strict) {
  if (!scheme && !_strict) {
    return "file";
  }
  return scheme;
}
function _referenceResolution(scheme, path7) {
  switch (scheme) {
    case "https":
    case "http":
    case "file":
      if (!path7) {
        path7 = _slash;
      } else if (path7[0] !== _slash) {
        path7 = _slash + path7;
      }
      break;
  }
  return path7;
}
function $Ac(thing) {
  if (!thing || typeof thing !== "object") {
    return false;
  }
  return typeof thing.scheme === "string" && (typeof thing.authority === "string" || typeof thing.authority === "undefined") && (typeof thing.path === "string" || typeof thing.path === "undefined") && (typeof thing.query === "string" || typeof thing.query === "undefined") && (typeof thing.fragment === "string" || typeof thing.fragment === "undefined");
}
function encodeURIComponentFast(uriComponent, isPath, isAuthority) {
  let res = void 0;
  let nativeEncodePos = -1;
  for (let pos = 0; pos < uriComponent.length; pos++) {
    const code = uriComponent.charCodeAt(pos);
    if (code >= 97 && code <= 122 || code >= 65 && code <= 90 || code >= 48 && code <= 57 || code === 45 || code === 46 || code === 95 || code === 126 || isPath && code === 47 || isAuthority && code === 91 || isAuthority && code === 93 || isAuthority && code === 58) {
      if (nativeEncodePos !== -1) {
        res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
        nativeEncodePos = -1;
      }
      if (res !== void 0) {
        res += uriComponent.charAt(pos);
      }
    } else {
      if (res === void 0) {
        res = uriComponent.substr(0, pos);
      }
      const escaped = encodeTable[code];
      if (escaped !== void 0) {
        if (nativeEncodePos !== -1) {
          res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
          nativeEncodePos = -1;
        }
        res += escaped;
      } else if (nativeEncodePos === -1) {
        nativeEncodePos = pos;
      }
    }
  }
  if (nativeEncodePos !== -1) {
    res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
  }
  return res !== void 0 ? res : uriComponent;
}
function encodeURIComponentMinimal(path7) {
  let res = void 0;
  for (let pos = 0; pos < path7.length; pos++) {
    const code = path7.charCodeAt(pos);
    if (code === 35 || code === 63) {
      if (res === void 0) {
        res = path7.substr(0, pos);
      }
      res += encodeTable[code];
    } else {
      if (res !== void 0) {
        res += path7[pos];
      }
    }
  }
  return res !== void 0 ? res : path7;
}
function $Bc(uri, keepDriveLetterCasing) {
  let value;
  if (uri.authority && uri.path.length > 1 && uri.scheme === "file") {
    value = `//${uri.authority}${uri.path}`;
  } else if (uri.path.charCodeAt(0) === 47 && (uri.path.charCodeAt(1) >= 65 && uri.path.charCodeAt(1) <= 90 || uri.path.charCodeAt(1) >= 97 && uri.path.charCodeAt(1) <= 122) && uri.path.charCodeAt(2) === 58) {
    if (!keepDriveLetterCasing) {
      value = uri.path[1].toLowerCase() + uri.path.substr(2);
    } else {
      value = uri.path.substr(1);
    }
  } else {
    value = uri.path;
  }
  if ($l) {
    value = value.replace(/\//g, "\\");
  }
  return value;
}
function _asFormatted(uri, skipEncoding) {
  const encoder = !skipEncoding ? encodeURIComponentFast : encodeURIComponentMinimal;
  let res = "";
  let { scheme, authority, path: path7, query, fragment } = uri;
  if (scheme) {
    res += scheme;
    res += ":";
  }
  if (authority || scheme === "file") {
    res += _slash;
    res += _slash;
  }
  if (authority) {
    let idx = authority.indexOf("@");
    if (idx !== -1) {
      const userinfo = authority.substr(0, idx);
      authority = authority.substr(idx + 1);
      idx = userinfo.lastIndexOf(":");
      if (idx === -1) {
        res += encoder(userinfo, false, false);
      } else {
        res += encoder(userinfo.substr(0, idx), false, false);
        res += ":";
        res += encoder(userinfo.substr(idx + 1), false, true);
      }
      res += "@";
    }
    authority = authority.toLowerCase();
    idx = authority.lastIndexOf(":");
    if (idx === -1) {
      res += encoder(authority, false, true);
    } else {
      res += encoder(authority.substr(0, idx), false, true);
      res += authority.substr(idx);
    }
  }
  if (path7) {
    if (path7.length >= 3 && path7.charCodeAt(0) === 47 && path7.charCodeAt(2) === 58) {
      const code = path7.charCodeAt(1);
      if (code >= 65 && code <= 90) {
        path7 = `/${String.fromCharCode(code + 32)}:${path7.substr(3)}`;
      }
    } else if (path7.length >= 2 && path7.charCodeAt(1) === 58) {
      const code = path7.charCodeAt(0);
      if (code >= 65 && code <= 90) {
        path7 = `${String.fromCharCode(code + 32)}:${path7.substr(2)}`;
      }
    }
    res += encoder(path7, true, false);
  }
  if (query) {
    res += "?";
    res += encoder(query, false, false);
  }
  if (fragment) {
    res += "#";
    res += !skipEncoding ? encodeURIComponentFast(fragment, false, false) : fragment;
  }
  return res;
}
function decodeURIComponentGraceful(str) {
  try {
    return decodeURIComponent(str);
  } catch {
    if (str.length > 3) {
      return str.substr(0, 3) + decodeURIComponentGraceful(str.substr(3));
    } else {
      return str;
    }
  }
}
function percentDecode(str) {
  if (!str.match(_rEncodedAsHex)) {
    return str;
  }
  return str.replace(_rEncodedAsHex, (match) => decodeURIComponentGraceful(match));
}
var _schemePattern, _singleSlashStart, _doubleSlashStart, _empty, _slash, _regexp, URI, _pathSepMarker, Uri, encodeTable, _rEncodedAsHex;
var init_uri = __esm({
  "out-build/vs/base/common/uri.js"() {
    "use strict";
    init_path();
    init_platform();
    _schemePattern = /^\w[\w\d+.-]*$/;
    _singleSlashStart = /^\//;
    _doubleSlashStart = /^\/\//;
    _empty = "";
    _slash = "/";
    _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
    URI = class _URI {
      static isUri(thing) {
        if (thing instanceof _URI) {
          return true;
        }
        if (!thing) {
          return false;
        }
        return typeof thing.authority === "string" && typeof thing.fragment === "string" && typeof thing.path === "string" && typeof thing.query === "string" && typeof thing.scheme === "string" && typeof thing.fsPath === "string" && typeof thing.with === "function" && typeof thing.toString === "function";
      }
      /**
       * @internal
       */
      constructor(schemeOrData, authority, path7, query, fragment, _strict = false) {
        if (typeof schemeOrData === "object") {
          this.scheme = schemeOrData.scheme || _empty;
          this.authority = schemeOrData.authority || _empty;
          this.path = schemeOrData.path || _empty;
          this.query = schemeOrData.query || _empty;
          this.fragment = schemeOrData.fragment || _empty;
        } else {
          this.scheme = _schemeFix(schemeOrData, _strict);
          this.authority = authority || _empty;
          this.path = _referenceResolution(this.scheme, path7 || _empty);
          this.query = query || _empty;
          this.fragment = fragment || _empty;
          _validateUri(this, _strict);
        }
      }
      // ---- filesystem path -----------------------
      /**
       * Returns a string representing the corresponding file system path of this URI.
       * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
       * platform specific path separator.
       *
       * * Will *not* validate the path for invalid characters and semantics.
       * * Will *not* look at the scheme of this URI.
       * * The result shall *not* be used for display purposes but for accessing a file on disk.
       *
       *
       * The *difference* to `URI#path` is the use of the platform specific separator and the handling
       * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
       *
       * ```ts
          const u = URI.parse('file://server/c$/folder/file.txt')
          u.authority === 'server'
          u.path === '/shares/c$/file.txt'
          u.fsPath === '\\server\c$\folder\file.txt'
      ```
       *
       * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
       * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
       * with URIs that represent files on disk (`file` scheme).
       */
      get fsPath() {
        return $Bc(this, false);
      }
      // ---- modify to new -------------------------
      with(change) {
        if (!change) {
          return this;
        }
        let { scheme, authority, path: path7, query, fragment } = change;
        if (scheme === void 0) {
          scheme = this.scheme;
        } else if (scheme === null) {
          scheme = _empty;
        }
        if (authority === void 0) {
          authority = this.authority;
        } else if (authority === null) {
          authority = _empty;
        }
        if (path7 === void 0) {
          path7 = this.path;
        } else if (path7 === null) {
          path7 = _empty;
        }
        if (query === void 0) {
          query = this.query;
        } else if (query === null) {
          query = _empty;
        }
        if (fragment === void 0) {
          fragment = this.fragment;
        } else if (fragment === null) {
          fragment = _empty;
        }
        if (scheme === this.scheme && authority === this.authority && path7 === this.path && query === this.query && fragment === this.fragment) {
          return this;
        }
        return new Uri(scheme, authority, path7, query, fragment);
      }
      // ---- parse & validate ------------------------
      /**
       * Creates a new URI from a string, e.g. `http://www.example.com/some/path`,
       * `file:///usr/home`, or `scheme:with/path`.
       *
       * @param value A string which represents an URI (see `URI#toString`).
       */
      static parse(value, _strict = false) {
        const match = _regexp.exec(value);
        if (!match) {
          return new Uri(_empty, _empty, _empty, _empty, _empty);
        }
        return new Uri(match[2] || _empty, percentDecode(match[4] || _empty), percentDecode(match[5] || _empty), percentDecode(match[7] || _empty), percentDecode(match[9] || _empty), _strict);
      }
      /**
       * Creates a new URI from a file system path, e.g. `c:\my\files`,
       * `/usr/home`, or `\\server\share\some\path`.
       *
       * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
       * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
       * `URI.parse('file://' + path)` because the path might contain characters that are
       * interpreted (# and ?). See the following sample:
       * ```ts
      const good = URI.file('/coding/c#/project1');
      good.scheme === 'file';
      good.path === '/coding/c#/project1';
      good.fragment === '';
      const bad = URI.parse('file://' + '/coding/c#/project1');
      bad.scheme === 'file';
      bad.path === '/coding/c'; // path is now broken
      bad.fragment === '/project1';
      ```
       *
       * @param path A file system path (see `URI#fsPath`)
       */
      static file(path7) {
        let authority = _empty;
        if ($l) {
          path7 = path7.replace(/\\/g, _slash);
        }
        if (path7[0] === _slash && path7[1] === _slash) {
          const idx = path7.indexOf(_slash, 2);
          if (idx === -1) {
            authority = path7.substring(2);
            path7 = _slash;
          } else {
            authority = path7.substring(2, idx);
            path7 = path7.substring(idx) || _slash;
          }
        }
        return new Uri("file", authority, path7, _empty, _empty);
      }
      /**
       * Creates new URI from uri components.
       *
       * Unless `strict` is `true` the scheme is defaults to be `file`. This function performs
       * validation and should be used for untrusted uri components retrieved from storage,
       * user input, command arguments etc
       */
      static from(components, strict) {
        const result = new Uri(components.scheme, components.authority, components.path, components.query, components.fragment, strict);
        return result;
      }
      /**
       * Join a URI path with path fragments and normalizes the resulting path.
       *
       * @param uri The input URI.
       * @param pathFragment The path fragment to add to the URI path.
       * @returns The resulting URI.
       */
      static joinPath(uri, ...pathFragment) {
        if (!uri.path) {
          throw new Error(`[UriError]: cannot call joinPath on URI without path`);
        }
        let newPath;
        if ($l && uri.scheme === "file") {
          newPath = _URI.file($kc.join($Bc(uri, true), ...pathFragment)).path;
        } else {
          newPath = $lc.join(uri.path, ...pathFragment);
        }
        return uri.with({ path: newPath });
      }
      // ---- printing/externalize ---------------------------
      /**
       * Creates a string representation for this URI. It's guaranteed that calling
       * `URI.parse` with the result of this function creates an URI which is equal
       * to this URI.
       *
       * * The result shall *not* be used for display purposes but for externalization or transport.
       * * The result will be encoded using the percentage encoding and encoding happens mostly
       * ignore the scheme-specific encoding rules.
       *
       * @param skipEncoding Do not encode the result, default is `false`
       */
      toString(skipEncoding = false) {
        return _asFormatted(this, skipEncoding);
      }
      toJSON() {
        return this;
      }
      static revive(data) {
        if (!data) {
          return data;
        } else if (data instanceof _URI) {
          return data;
        } else {
          const result = new Uri(data);
          result._formatted = data.external ?? null;
          result._fsPath = data._sep === _pathSepMarker ? data.fsPath ?? null : null;
          return result;
        }
      }
      [Symbol.for("debug.description")]() {
        return `URI(${this.toString()})`;
      }
    };
    _pathSepMarker = $l ? 1 : void 0;
    Uri = class extends URI {
      constructor() {
        super(...arguments);
        this._formatted = null;
        this._fsPath = null;
      }
      get fsPath() {
        if (!this._fsPath) {
          this._fsPath = $Bc(this, false);
        }
        return this._fsPath;
      }
      toString(skipEncoding = false) {
        if (!skipEncoding) {
          if (!this._formatted) {
            this._formatted = _asFormatted(this, false);
          }
          return this._formatted;
        } else {
          return _asFormatted(this, true);
        }
      }
      toJSON() {
        const res = {
          $mid: 1
          /* MarshalledId.Uri */
        };
        if (this._fsPath) {
          res.fsPath = this._fsPath;
          res._sep = _pathSepMarker;
        }
        if (this._formatted) {
          res.external = this._formatted;
        }
        if (this.path) {
          res.path = this.path;
        }
        if (this.scheme) {
          res.scheme = this.scheme;
        }
        if (this.authority) {
          res.authority = this.authority;
        }
        if (this.query) {
          res.query = this.query;
        }
        if (this.fragment) {
          res.fragment = this.fragment;
        }
        return res;
      }
    };
    encodeTable = {
      [
        58
        /* CharCode.Colon */
      ]: "%3A",
      // gen-delims
      [
        47
        /* CharCode.Slash */
      ]: "%2F",
      [
        63
        /* CharCode.QuestionMark */
      ]: "%3F",
      [
        35
        /* CharCode.Hash */
      ]: "%23",
      [
        91
        /* CharCode.OpenSquareBracket */
      ]: "%5B",
      [
        93
        /* CharCode.CloseSquareBracket */
      ]: "%5D",
      [
        64
        /* CharCode.AtSign */
      ]: "%40",
      [
        33
        /* CharCode.ExclamationMark */
      ]: "%21",
      // sub-delims
      [
        36
        /* CharCode.DollarSign */
      ]: "%24",
      [
        38
        /* CharCode.Ampersand */
      ]: "%26",
      [
        39
        /* CharCode.SingleQuote */
      ]: "%27",
      [
        40
        /* CharCode.OpenParen */
      ]: "%28",
      [
        41
        /* CharCode.CloseParen */
      ]: "%29",
      [
        42
        /* CharCode.Asterisk */
      ]: "%2A",
      [
        43
        /* CharCode.Plus */
      ]: "%2B",
      [
        44
        /* CharCode.Comma */
      ]: "%2C",
      [
        59
        /* CharCode.Semicolon */
      ]: "%3B",
      [
        61
        /* CharCode.Equals */
      ]: "%3D",
      [
        32
        /* CharCode.Space */
      ]: "%20"
    };
    _rEncodedAsHex = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
  }
});

// out-build/vs/base/common/network.js
function $uh(product2) {
  return `${product2.quality ?? "oss"}-${product2.commit ?? "dev"}`;
}
var Schemas, $rh, $sh, RemoteAuthoritiesImpl, $th, $vh, $wh, $xh, $zh, FileAccessImpl, $Ah, $Bh, $Ch, COI;
var init_network = __esm({
  "out-build/vs/base/common/network.js"() {
    "use strict";
    init_errors();
    init_platform();
    init_strings();
    init_uri();
    init_path();
    (function(Schemas2) {
      Schemas2.inMemory = "inmemory";
      Schemas2.vscode = "vscode";
      Schemas2.internal = "private";
      Schemas2.walkThrough = "walkThrough";
      Schemas2.walkThroughSnippet = "walkThroughSnippet";
      Schemas2.http = "http";
      Schemas2.https = "https";
      Schemas2.file = "file";
      Schemas2.mailto = "mailto";
      Schemas2.untitled = "untitled";
      Schemas2.data = "data";
      Schemas2.command = "command";
      Schemas2.vscodeRemote = "vscode-remote";
      Schemas2.vscodeRemoteResource = "vscode-remote-resource";
      Schemas2.vscodeManagedRemoteResource = "vscode-managed-remote-resource";
      Schemas2.vscodeUserData = "vscode-userdata";
      Schemas2.vscodeCustomEditor = "vscode-custom-editor";
      Schemas2.vscodeNotebookCell = "vscode-notebook-cell";
      Schemas2.vscodeNotebookCellMetadata = "vscode-notebook-cell-metadata";
      Schemas2.vscodeNotebookCellMetadataDiff = "vscode-notebook-cell-metadata-diff";
      Schemas2.vscodeNotebookCellOutput = "vscode-notebook-cell-output";
      Schemas2.vscodeNotebookCellOutputDiff = "vscode-notebook-cell-output-diff";
      Schemas2.vscodeNotebookMetadata = "vscode-notebook-metadata";
      Schemas2.vscodeInteractiveInput = "vscode-interactive-input";
      Schemas2.vscodeSettings = "vscode-settings";
      Schemas2.vscodeWorkspaceTrust = "vscode-workspace-trust";
      Schemas2.vscodeTerminal = "vscode-terminal";
      Schemas2.vscodeChatCodeBlock = "vscode-chat-code-block";
      Schemas2.vscodeChatCodeCompareBlock = "vscode-chat-code-compare-block";
      Schemas2.vscodeChatSesssion = "vscode-chat-editor";
      Schemas2.webviewPanel = "webview-panel";
      Schemas2.vscodeWebview = "vscode-webview";
      Schemas2.extension = "extension";
      Schemas2.vscodeFileResource = "vscode-file";
      Schemas2.tmp = "tmp";
      Schemas2.vsls = "vsls";
      Schemas2.vscodeSourceControl = "vscode-scm";
      Schemas2.commentsInput = "comment";
      Schemas2.codeSetting = "code-setting";
      Schemas2.outputChannel = "output";
      Schemas2.accessibleView = "accessible-view";
    })(Schemas || (Schemas = {}));
    $rh = "vscode-tkn";
    $sh = "tkn";
    RemoteAuthoritiesImpl = class {
      constructor() {
        this.a = /* @__PURE__ */ Object.create(null);
        this.b = /* @__PURE__ */ Object.create(null);
        this.c = /* @__PURE__ */ Object.create(null);
        this.d = "http";
        this.e = null;
        this.f = "/";
      }
      setPreferredWebSchema(schema) {
        this.d = schema;
      }
      setDelegate(delegate) {
        this.e = delegate;
      }
      setServerRootPath(product2, serverBasePath) {
        this.f = $lc.join(serverBasePath ?? "/", $uh(product2));
      }
      getServerRootPath() {
        return this.f;
      }
      get g() {
        return $lc.join(this.f, Schemas.vscodeRemoteResource);
      }
      set(authority, host, port) {
        this.a[authority] = host;
        this.b[authority] = port;
      }
      setConnectionToken(authority, connectionToken) {
        this.c[authority] = connectionToken;
      }
      getPreferredWebSchema() {
        return this.d;
      }
      rewrite(uri) {
        if (this.e) {
          try {
            return this.e(uri);
          } catch (err) {
            $gb(err);
            return uri;
          }
        }
        const authority = uri.authority;
        let host = this.a[authority];
        if (host && host.indexOf(":") !== -1 && host.indexOf("[") === -1) {
          host = `[${host}]`;
        }
        const port = this.b[authority];
        const connectionToken = this.c[authority];
        let query = `path=${encodeURIComponent(uri.path)}`;
        if (typeof connectionToken === "string") {
          query += `&${$sh}=${encodeURIComponent(connectionToken)}`;
        }
        return URI.from({
          scheme: $r ? this.d : Schemas.vscodeRemoteResource,
          authority: `${host}:${port}`,
          path: $r ? (window.location.pathname + "/" + this.g).replace(/\/\/+/g, "/") : this.g,
          query
        });
      }
    };
    $th = new RemoteAuthoritiesImpl();
    $vh = "vs/../../extensions";
    $wh = "vs/../../node_modules";
    $xh = "vs/../../node_modules.asar";
    $zh = "vscode-app";
    FileAccessImpl = class _FileAccessImpl {
      static {
        this.a = $zh;
      }
      /**
       * Returns a URI to use in contexts where the browser is responsible
       * for loading (e.g. fetch()) or when used within the DOM.
       *
       * **Note:** use `dom.ts#asCSSUrl` whenever the URL is to be used in CSS context.
       */
      asBrowserUri(resourcePath) {
        const uri = this.b(resourcePath);
        return this.uriToBrowserUri(uri);
      }
      /**
       * Returns a URI to use in contexts where the browser is responsible
       * for loading (e.g. fetch()) or when used within the DOM.
       *
       * **Note:** use `dom.ts#asCSSUrl` whenever the URL is to be used in CSS context.
       */
      uriToBrowserUri(uri) {
        if (uri.scheme === Schemas.vscodeRemote) {
          return $th.rewrite(uri);
        }
        if (
          // ...only ever for `file` resources
          uri.scheme === Schemas.file && // ...and we run in native environments
          ($p || // ...or web worker extensions on desktop
          $t === `${Schemas.vscodeFileResource}://${_FileAccessImpl.a}`)
        ) {
          return uri.with({
            scheme: Schemas.vscodeFileResource,
            // We need to provide an authority here so that it can serve
            // as origin for network and loading matters in chromium.
            // If the URI is not coming with an authority already, we
            // add our own
            authority: uri.authority || _FileAccessImpl.a,
            query: null,
            fragment: null
          });
        }
        return uri;
      }
      /**
       * Returns the `file` URI to use in contexts where node.js
       * is responsible for loading.
       */
      asFileUri(resourcePath) {
        const uri = this.b(resourcePath);
        return this.uriToFileUri(uri);
      }
      /**
       * Returns the `file` URI to use in contexts where node.js
       * is responsible for loading.
       */
      uriToFileUri(uri) {
        if (uri.scheme === Schemas.vscodeFileResource) {
          return uri.with({
            scheme: Schemas.file,
            // Only preserve the `authority` if it is different from
            // our fallback authority. This ensures we properly preserve
            // Windows UNC paths that come with their own authority.
            authority: uri.authority !== _FileAccessImpl.a ? uri.authority : null,
            query: null,
            fragment: null
          });
        }
        return uri;
      }
      b(uriOrModule) {
        if (URI.isUri(uriOrModule)) {
          return uriOrModule;
        }
        if (globalThis._VSCODE_FILE_ROOT) {
          const rootUriOrPath = globalThis._VSCODE_FILE_ROOT;
          if (/^\w[\w\d+.-]*:\/\//.test(rootUriOrPath)) {
            return URI.joinPath(URI.parse(rootUriOrPath, true), uriOrModule);
          }
          const modulePath = $oc(rootUriOrPath, uriOrModule);
          return URI.file(modulePath);
        }
        throw new Error("Cannot determine URI for module id!");
      }
    };
    $Ah = new FileAccessImpl();
    $Bh = Object.freeze({
      "Cache-Control": "no-cache, no-store"
    });
    $Ch = Object.freeze({
      "Document-Policy": "include-js-call-stacks-in-crash-reports"
    });
    (function(COI2) {
      const coiHeaders = /* @__PURE__ */ new Map([
        ["1", { "Cross-Origin-Opener-Policy": "same-origin" }],
        ["2", { "Cross-Origin-Embedder-Policy": "require-corp" }],
        ["3", { "Cross-Origin-Opener-Policy": "same-origin", "Cross-Origin-Embedder-Policy": "require-corp" }]
      ]);
      COI2.CoopAndCoep = Object.freeze(coiHeaders.get("3"));
      const coiSearchParamName = "vscode-coi";
      function getHeadersFromQuery(url3) {
        let params;
        if (typeof url3 === "string") {
          params = new URL(url3).searchParams;
        } else if (url3 instanceof URL) {
          params = url3.searchParams;
        } else if (URI.isUri(url3)) {
          params = new URL(url3.toString(true)).searchParams;
        }
        const value = params?.get(coiSearchParamName);
        if (!value) {
          return void 0;
        }
        return coiHeaders.get(value);
      }
      COI2.getHeadersFromQuery = getHeadersFromQuery;
      function addSearchParam(urlOrSearch, coop, coep) {
        if (!globalThis.crossOriginIsolated) {
          return;
        }
        const value = coop && coep ? "3" : coep ? "2" : "1";
        if (urlOrSearch instanceof URLSearchParams) {
          urlOrSearch.set(coiSearchParamName, value);
        } else {
          urlOrSearch[coiSearchParamName] = value;
        }
      }
      COI2.addSearchParam = addSearchParam;
    })(COI || (COI = {}));
  }
});

// out-build/vs/platform/instantiation/common/serviceCollection.js
var $il;
var init_serviceCollection = __esm({
  "out-build/vs/platform/instantiation/common/serviceCollection.js"() {
    "use strict";
    $il = class {
      constructor(...entries) {
        this.a = /* @__PURE__ */ new Map();
        for (const [id2, service] of entries) {
          this.set(id2, service);
        }
      }
      set(id2, instanceOrDescriptor) {
        const result = this.a.get(id2);
        this.a.set(id2, instanceOrDescriptor);
        return result;
      }
      has(id2) {
        return this.a.has(id2);
      }
      get(id2) {
        return this.a.get(id2);
      }
    };
  }
});

// out-build/vs/base/common/errorMessage.js
function exceptionToErrorMessage(exception, verbose) {
  if (verbose && (exception.stack || exception.stacktrace)) {
    return localize(110, null, detectSystemErrorMessage(exception), stackToString(exception.stack) || stackToString(exception.stacktrace));
  }
  return detectSystemErrorMessage(exception);
}
function stackToString(stack) {
  if (Array.isArray(stack)) {
    return stack.join("\n");
  }
  return stack;
}
function detectSystemErrorMessage(exception) {
  if (exception.code === "ERR_UNC_HOST_NOT_ALLOWED") {
    return `${exception.message}. Please update the 'security.allowedUNCHosts' setting if you want to allow this host.`;
  }
  if (typeof exception.code === "string" && typeof exception.errno === "number" && typeof exception.syscall === "string") {
    return localize(111, null, exception.message);
  }
  return exception.message || localize(112, null);
}
function $wn(error = null, verbose = false) {
  if (!error) {
    return localize(113, null);
  }
  if (Array.isArray(error)) {
    const errors = $Lb(error);
    const msg = $wn(errors[0], verbose);
    if (errors.length > 1) {
      return localize(114, null, msg, errors.length);
    }
    return msg;
  }
  if ($Wc(error)) {
    return error;
  }
  if (error.detail) {
    const detail = error.detail;
    if (detail.error) {
      return exceptionToErrorMessage(detail.error, verbose);
    }
    if (detail.exception) {
      return exceptionToErrorMessage(detail.exception, verbose);
    }
  }
  if (error.stack) {
    return exceptionToErrorMessage(error, verbose);
  }
  if (error.message) {
    return error.message;
  }
  return localize(115, null);
}
var init_errorMessage = __esm({
  "out-build/vs/base/common/errorMessage.js"() {
    "use strict";
    init_arrays();
    init_types();
    init_nls2();
  }
});

// out-build/vs/base/common/stream.js
function $Ii(obj) {
  const candidate = obj;
  if (!candidate) {
    return false;
  }
  return [candidate.on, candidate.pause, candidate.resume, candidate.destroy].every((fn) => typeof fn === "function");
}
function $Ji(obj) {
  const candidate = obj;
  if (!candidate) {
    return false;
  }
  return $Ii(candidate.stream) && Array.isArray(candidate.buffer) && typeof candidate.ended === "boolean";
}
function $Ki(reducer, options2) {
  return new WriteableStreamImpl(reducer, options2);
}
function $Li(readable, reducer) {
  const chunks = [];
  let chunk;
  while ((chunk = readable.read()) !== null) {
    chunks.push(chunk);
  }
  return reducer(chunks);
}
function $Mi(readable, reducer, maxChunks) {
  const chunks = [];
  let chunk = void 0;
  while ((chunk = readable.read()) !== null && chunks.length < maxChunks) {
    chunks.push(chunk);
  }
  if (chunk === null && chunks.length > 0) {
    return reducer(chunks);
  }
  return {
    read: () => {
      if (chunks.length > 0) {
        return chunks.shift();
      }
      if (typeof chunk !== "undefined") {
        const lastReadChunk = chunk;
        chunk = void 0;
        return lastReadChunk;
      }
      return readable.read();
    }
  };
}
function $Ni(stream, reducer) {
  return new Promise((resolve4, reject) => {
    const chunks = [];
    $Oi(stream, {
      onData: (chunk) => {
        if (reducer) {
          chunks.push(chunk);
        }
      },
      onError: (error) => {
        if (reducer) {
          reject(error);
        } else {
          resolve4(void 0);
        }
      },
      onEnd: () => {
        if (reducer) {
          resolve4(reducer(chunks));
        } else {
          resolve4(void 0);
        }
      }
    });
  });
}
function $Oi(stream, listener, token) {
  stream.on("error", (error) => {
    if (!token?.isCancellationRequested) {
      listener.onError(error);
    }
  });
  stream.on("end", () => {
    if (!token?.isCancellationRequested) {
      listener.onEnd();
    }
  });
  stream.on("data", (data) => {
    if (!token?.isCancellationRequested) {
      listener.onData(data);
    }
  });
}
function $Pi(stream, maxChunks) {
  return new Promise((resolve4, reject) => {
    const streamListeners = new $rd();
    const buffer = [];
    const dataListener = (chunk) => {
      buffer.push(chunk);
      if (buffer.length > maxChunks) {
        streamListeners.dispose();
        stream.pause();
        return resolve4({ stream, buffer, ended: false });
      }
    };
    const errorListener = (error) => {
      streamListeners.dispose();
      return reject(error);
    };
    const endListener = () => {
      streamListeners.dispose();
      return resolve4({ stream, buffer, ended: true });
    };
    streamListeners.add($qd(() => stream.removeListener("error", errorListener)));
    stream.on("error", errorListener);
    streamListeners.add($qd(() => stream.removeListener("end", endListener)));
    stream.on("end", endListener);
    streamListeners.add($qd(() => stream.removeListener("data", dataListener)));
    stream.on("data", dataListener);
  });
}
function $Si(t) {
  let consumed = false;
  return {
    read: () => {
      if (consumed) {
        return null;
      }
      consumed = true;
      return t;
    }
  };
}
function $Ti(stream, transformer, reducer) {
  const target = $Ki(reducer);
  $Oi(stream, {
    onData: (data) => target.write(transformer.data(data)),
    onError: (error) => target.error(transformer.error ? transformer.error(error) : error),
    onEnd: () => target.end()
  });
  return target;
}
var WriteableStreamImpl;
var init_stream = __esm({
  "out-build/vs/base/common/stream.js"() {
    "use strict";
    init_errors();
    init_lifecycle();
    WriteableStreamImpl = class {
      /**
       * @param e a function that reduces the buffered data into a single object;
       * 				  because some objects can be complex and non-reducible, we also
       * 				  allow passing the explicit `null` value to skip the reduce step
       * @param f stream options
       */
      constructor(e, f) {
        this.e = e;
        this.f = f;
        this.a = {
          flowing: false,
          ended: false,
          destroyed: false
        };
        this.b = {
          data: [],
          error: []
        };
        this.c = {
          data: [],
          error: [],
          end: []
        };
        this.d = [];
      }
      pause() {
        if (this.a.destroyed) {
          return;
        }
        this.a.flowing = false;
      }
      resume() {
        if (this.a.destroyed) {
          return;
        }
        if (!this.a.flowing) {
          this.a.flowing = true;
          this.j();
          this.k();
          this.l();
        }
      }
      write(data) {
        if (this.a.destroyed) {
          return;
        }
        if (this.a.flowing) {
          this.g(data);
        } else {
          this.b.data.push(data);
          if (typeof this.f?.highWaterMark === "number" && this.b.data.length > this.f.highWaterMark) {
            return new Promise((resolve4) => this.d.push(resolve4));
          }
        }
      }
      error(error) {
        if (this.a.destroyed) {
          return;
        }
        if (this.a.flowing) {
          this.h(error);
        } else {
          this.b.error.push(error);
        }
      }
      end(result) {
        if (this.a.destroyed) {
          return;
        }
        if (typeof result !== "undefined") {
          this.write(result);
        }
        if (this.a.flowing) {
          this.i();
          this.destroy();
        } else {
          this.a.ended = true;
        }
      }
      g(data) {
        this.c.data.slice(0).forEach((listener) => listener(data));
      }
      h(error) {
        if (this.c.error.length === 0) {
          $gb(error);
        } else {
          this.c.error.slice(0).forEach((listener) => listener(error));
        }
      }
      i() {
        this.c.end.slice(0).forEach((listener) => listener());
      }
      on(event, callback) {
        if (this.a.destroyed) {
          return;
        }
        switch (event) {
          case "data":
            this.c.data.push(callback);
            this.resume();
            break;
          case "end":
            this.c.end.push(callback);
            if (this.a.flowing && this.l()) {
              this.destroy();
            }
            break;
          case "error":
            this.c.error.push(callback);
            if (this.a.flowing) {
              this.k();
            }
            break;
        }
      }
      removeListener(event, callback) {
        if (this.a.destroyed) {
          return;
        }
        let listeners = void 0;
        switch (event) {
          case "data":
            listeners = this.c.data;
            break;
          case "end":
            listeners = this.c.end;
            break;
          case "error":
            listeners = this.c.error;
            break;
        }
        if (listeners) {
          const index = listeners.indexOf(callback);
          if (index >= 0) {
            listeners.splice(index, 1);
          }
        }
      }
      j() {
        if (this.b.data.length === 0) {
          return;
        }
        if (typeof this.e === "function") {
          const fullDataBuffer = this.e(this.b.data);
          this.g(fullDataBuffer);
        } else {
          for (const data of this.b.data) {
            this.g(data);
          }
        }
        this.b.data.length = 0;
        const pendingWritePromises = [...this.d];
        this.d.length = 0;
        pendingWritePromises.forEach((pendingWritePromise) => pendingWritePromise());
      }
      k() {
        if (this.c.error.length > 0) {
          for (const error of this.b.error) {
            this.h(error);
          }
          this.b.error.length = 0;
        }
      }
      l() {
        if (this.a.ended) {
          this.i();
          return this.c.end.length > 0;
        }
        return false;
      }
      destroy() {
        if (!this.a.destroyed) {
          this.a.destroyed = true;
          this.a.ended = true;
          this.b.data.length = 0;
          this.b.error.length = 0;
          this.c.data.length = 0;
          this.c.error.length = 0;
          this.c.end.length = 0;
          this.d.length = 0;
        }
      }
    };
  }
});

// out-build/vs/base/common/buffer.js
function $Xi(haystack, needle, offset = 0) {
  const needleLen = needle.byteLength;
  const haystackLen = haystack.byteLength;
  if (needleLen === 0) {
    return 0;
  }
  if (needleLen === 1) {
    return haystack.indexOf(needle[0]);
  }
  if (needleLen > haystackLen - offset) {
    return -1;
  }
  const table = indexOfTable.value;
  table.fill(needle.length);
  for (let i2 = 0; i2 < needle.length; i2++) {
    table[needle[i2]] = needle.length - i2 - 1;
  }
  let i = offset + needle.length - 1;
  let j = i;
  let result = -1;
  while (i < haystackLen) {
    if (haystack[i] === needle[j]) {
      if (j === 0) {
        result = i;
        break;
      }
      i--;
      j--;
    } else {
      i += Math.max(needle.length - j, table[haystack[i]]);
      j = needle.length - 1;
    }
  }
  return result;
}
function $1i(source, offset) {
  return source[offset] * 2 ** 24 + source[offset + 1] * 2 ** 16 + source[offset + 2] * 2 ** 8 + source[offset + 3];
}
function $2i(destination, value, offset) {
  destination[offset + 3] = value;
  value = value >>> 8;
  destination[offset + 2] = value;
  value = value >>> 8;
  destination[offset + 1] = value;
  value = value >>> 8;
  destination[offset] = value;
}
function $3i(source, offset) {
  return source[offset + 0] << 0 >>> 0 | source[offset + 1] << 8 >>> 0 | source[offset + 2] << 16 >>> 0 | source[offset + 3] << 24 >>> 0;
}
function $4i(destination, value, offset) {
  destination[offset + 0] = value & 255;
  value = value >>> 8;
  destination[offset + 1] = value & 255;
  value = value >>> 8;
  destination[offset + 2] = value & 255;
  value = value >>> 8;
  destination[offset + 3] = value & 255;
}
function $5i(source, offset) {
  return source[offset];
}
function $6i(destination, value, offset) {
  destination[offset] = value;
}
function $7i(readable) {
  return $Li(readable, (chunks) => $Wi.concat(chunks));
}
function $8i(buffer) {
  return $Si(buffer);
}
function $9i(stream) {
  return $Ni(stream, (chunks) => $Wi.concat(chunks));
}
async function $0i(bufferedStream) {
  if (bufferedStream.ended) {
    return $Wi.concat(bufferedStream.buffer);
  }
  return $Wi.concat([
    // Include already read chunks...
    ...bufferedStream.buffer,
    // ...and all additional chunks
    await $9i(bufferedStream.stream)
  ]);
}
function $_i(stream) {
  return $Ti(stream, { data: (data) => typeof data === "string" ? $Wi.fromString(data) : $Wi.wrap(data) }, (chunks) => $Wi.concat(chunks));
}
function $aj(options2) {
  return $Ki((chunks) => $Wi.concat(chunks), options2);
}
function $dj(encoded) {
  let building = 0;
  let remainder = 0;
  let bufi = 0;
  const buffer = new Uint8Array(Math.floor(encoded.length / 4 * 3));
  const append = (value) => {
    switch (remainder) {
      case 3:
        buffer[bufi++] = building | value;
        remainder = 0;
        break;
      case 2:
        buffer[bufi++] = building | value >>> 2;
        building = value << 6;
        remainder = 3;
        break;
      case 1:
        buffer[bufi++] = building | value >>> 4;
        building = value << 4;
        remainder = 2;
        break;
      default:
        building = value << 2;
        remainder = 1;
    }
  };
  for (let i = 0; i < encoded.length; i++) {
    const code = encoded.charCodeAt(i);
    if (code >= 65 && code <= 90) {
      append(code - 65);
    } else if (code >= 97 && code <= 122) {
      append(code - 97 + 26);
    } else if (code >= 48 && code <= 57) {
      append(code - 48 + 52);
    } else if (code === 43 || code === 45) {
      append(62);
    } else if (code === 47 || code === 95) {
      append(63);
    } else if (code === 61) {
      break;
    } else {
      throw new SyntaxError(`Unexpected base64 character ${encoded[i]}`);
    }
  }
  const unpadded = bufi;
  while (remainder > 0) {
    append(0);
  }
  return $Wi.wrap(buffer).slice(0, unpadded);
}
function $ej({ buffer }, padded = true, urlSafe = false) {
  const dictionary = urlSafe ? base64UrlSafeAlphabet : base64Alphabet;
  let output = "";
  const remainder = buffer.byteLength % 3;
  let i = 0;
  for (; i < buffer.byteLength - remainder; i += 3) {
    const a = buffer[i + 0];
    const b = buffer[i + 1];
    const c = buffer[i + 2];
    output += dictionary[a >>> 2];
    output += dictionary[(a << 4 | b >>> 4) & 63];
    output += dictionary[(b << 2 | c >>> 6) & 63];
    output += dictionary[c & 63];
  }
  if (remainder === 1) {
    const a = buffer[i + 0];
    output += dictionary[a >>> 2];
    output += dictionary[a << 4 & 63];
    if (padded) {
      output += "==";
    }
  } else if (remainder === 2) {
    const a = buffer[i + 0];
    const b = buffer[i + 1];
    output += dictionary[a >>> 2];
    output += dictionary[(a << 4 | b >>> 4) & 63];
    output += dictionary[b << 2 & 63];
    if (padded) {
      output += "=";
    }
  }
  return output;
}
var hasBuffer, indexOfTable, textEncoder, textDecoder, $Wi, base64Alphabet, base64UrlSafeAlphabet;
var init_buffer = __esm({
  "out-build/vs/base/common/buffer.js"() {
    "use strict";
    init_lazy();
    init_stream();
    hasBuffer = typeof Buffer !== "undefined";
    indexOfTable = new $3f(() => new Uint8Array(256));
    $Wi = class _$Wi {
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      static alloc(byteLength) {
        if (hasBuffer) {
          return new _$Wi(Buffer.allocUnsafe(byteLength));
        } else {
          return new _$Wi(new Uint8Array(byteLength));
        }
      }
      /**
       * When running in a nodejs context, if `actual` is not a nodejs Buffer, the backing store for
       * the returned `VSBuffer` instance might use a nodejs Buffer allocated from node's Buffer pool,
       * which is not transferrable.
       */
      static wrap(actual) {
        if (hasBuffer && !Buffer.isBuffer(actual)) {
          actual = Buffer.from(actual.buffer, actual.byteOffset, actual.byteLength);
        }
        return new _$Wi(actual);
      }
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      static fromString(source, options2) {
        const dontUseNodeBuffer = options2?.dontUseNodeBuffer || false;
        if (!dontUseNodeBuffer && hasBuffer) {
          return new _$Wi(Buffer.from(source));
        } else {
          if (!textEncoder) {
            textEncoder = new TextEncoder();
          }
          return new _$Wi(textEncoder.encode(source));
        }
      }
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      static fromByteArray(source) {
        const result = _$Wi.alloc(source.length);
        for (let i = 0, len = source.length; i < len; i++) {
          result.buffer[i] = source[i];
        }
        return result;
      }
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      static concat(buffers, totalLength) {
        if (typeof totalLength === "undefined") {
          totalLength = 0;
          for (let i = 0, len = buffers.length; i < len; i++) {
            totalLength += buffers[i].byteLength;
          }
        }
        const ret = _$Wi.alloc(totalLength);
        let offset = 0;
        for (let i = 0, len = buffers.length; i < len; i++) {
          const element = buffers[i];
          ret.set(element, offset);
          offset += element.byteLength;
        }
        return ret;
      }
      constructor(buffer) {
        this.buffer = buffer;
        this.byteLength = this.buffer.byteLength;
      }
      /**
       * When running in a nodejs context, the backing store for the returned `VSBuffer` instance
       * might use a nodejs Buffer allocated from node's Buffer pool, which is not transferrable.
       */
      clone() {
        const result = _$Wi.alloc(this.byteLength);
        result.set(this);
        return result;
      }
      toString() {
        if (hasBuffer) {
          return this.buffer.toString();
        } else {
          if (!textDecoder) {
            textDecoder = new TextDecoder();
          }
          return textDecoder.decode(this.buffer);
        }
      }
      slice(start, end) {
        return new _$Wi(this.buffer.subarray(start, end));
      }
      set(array, offset) {
        if (array instanceof _$Wi) {
          this.buffer.set(array.buffer, offset);
        } else if (array instanceof Uint8Array) {
          this.buffer.set(array, offset);
        } else if (array instanceof ArrayBuffer) {
          this.buffer.set(new Uint8Array(array), offset);
        } else if (ArrayBuffer.isView(array)) {
          this.buffer.set(new Uint8Array(array.buffer, array.byteOffset, array.byteLength), offset);
        } else {
          throw new Error(`Unknown argument 'array'`);
        }
      }
      readUInt32BE(offset) {
        return $1i(this.buffer, offset);
      }
      writeUInt32BE(value, offset) {
        $2i(this.buffer, value, offset);
      }
      readUInt32LE(offset) {
        return $3i(this.buffer, offset);
      }
      writeUInt32LE(value, offset) {
        $4i(this.buffer, value, offset);
      }
      readUInt8(offset) {
        return $5i(this.buffer, offset);
      }
      writeUInt8(value, offset) {
        $6i(this.buffer, value, offset);
      }
      indexOf(subarray, offset = 0) {
        return $Xi(this.buffer, subarray instanceof _$Wi ? subarray.buffer : subarray, offset);
      }
      equals(other) {
        if (this === other) {
          return true;
        }
        if (this.byteLength !== other.byteLength) {
          return false;
        }
        return this.buffer.every((value, index) => value === other.buffer[index]);
      }
    };
    base64Alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    base64UrlSafeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
  }
});

// out-build/vs/base/common/hash.js
function $fj(obj) {
  return $gj(obj, 0);
}
function $gj(obj, hashVal) {
  switch (typeof obj) {
    case "object":
      if (obj === null) {
        return $hj(349, hashVal);
      } else if (Array.isArray(obj)) {
        return arrayHash(obj, hashVal);
      }
      return objectHash(obj, hashVal);
    case "string":
      return $ij(obj, hashVal);
    case "boolean":
      return booleanHash(obj, hashVal);
    case "number":
      return $hj(obj, hashVal);
    case "undefined":
      return $hj(937, hashVal);
    default:
      return $hj(617, hashVal);
  }
}
function $hj(val, initialHashVal) {
  return (initialHashVal << 5) - initialHashVal + val | 0;
}
function booleanHash(b, initialHashVal) {
  return $hj(b ? 433 : 863, initialHashVal);
}
function $ij(s, hashVal) {
  hashVal = $hj(149417, hashVal);
  for (let i = 0, length = s.length; i < length; i++) {
    hashVal = $hj(s.charCodeAt(i), hashVal);
  }
  return hashVal;
}
function arrayHash(arr, initialHashVal) {
  initialHashVal = $hj(104579, initialHashVal);
  return arr.reduce((hashVal, item) => $gj(item, hashVal), initialHashVal);
}
function objectHash(obj, initialHashVal) {
  initialHashVal = $hj(181387, initialHashVal);
  return Object.keys(obj).sort().reduce((hashVal, key) => {
    hashVal = $ij(key, hashVal);
    return $gj(obj[key], hashVal);
  }, initialHashVal);
}
function leftRotate(value, bits, totalBits = 32) {
  const delta = totalBits - bits;
  const mask = ~((1 << delta) - 1);
  return (value << bits | (mask & value) >>> delta) >>> 0;
}
function toHexString(bufferOrValue, bitsize = 32) {
  if (bufferOrValue instanceof ArrayBuffer) {
    return Array.from(new Uint8Array(bufferOrValue)).map((b) => b.toString(16).padStart(2, "0")).join("");
  }
  return (bufferOrValue >>> 0).toString(16).padStart(bitsize / 4, "0");
}
var SHA1Constant, $kj;
var init_hash = __esm({
  "out-build/vs/base/common/hash.js"() {
    "use strict";
    init_buffer();
    init_strings();
    (function(SHA1Constant2) {
      SHA1Constant2[SHA1Constant2["BLOCK_SIZE"] = 64] = "BLOCK_SIZE";
      SHA1Constant2[SHA1Constant2["UNICODE_REPLACEMENT"] = 65533] = "UNICODE_REPLACEMENT";
    })(SHA1Constant || (SHA1Constant = {}));
    $kj = class _$kj {
      static {
        this.g = new DataView(new ArrayBuffer(320));
      }
      // 80 * 4 = 320
      constructor() {
        this.h = 1732584193;
        this.l = 4023233417;
        this.m = 2562383102;
        this.n = 271733878;
        this.o = 3285377520;
        this.p = new Uint8Array(
          64 + 3
          /* to fit any utf-8 */
        );
        this.q = new DataView(this.p.buffer);
        this.r = 0;
        this.t = 0;
        this.u = 0;
        this.v = false;
      }
      update(str) {
        const strLen = str.length;
        if (strLen === 0) {
          return;
        }
        const buff = this.p;
        let buffLen = this.r;
        let leftoverHighSurrogate = this.u;
        let charCode;
        let offset;
        if (leftoverHighSurrogate !== 0) {
          charCode = leftoverHighSurrogate;
          offset = -1;
          leftoverHighSurrogate = 0;
        } else {
          charCode = str.charCodeAt(0);
          offset = 0;
        }
        while (true) {
          let codePoint = charCode;
          if ($Cg(charCode)) {
            if (offset + 1 < strLen) {
              const nextCharCode = str.charCodeAt(offset + 1);
              if ($Dg(nextCharCode)) {
                offset++;
                codePoint = $Eg(charCode, nextCharCode);
              } else {
                codePoint = 65533;
              }
            } else {
              leftoverHighSurrogate = charCode;
              break;
            }
          } else if ($Dg(charCode)) {
            codePoint = 65533;
          }
          buffLen = this.w(buff, buffLen, codePoint);
          offset++;
          if (offset < strLen) {
            charCode = str.charCodeAt(offset);
          } else {
            break;
          }
        }
        this.r = buffLen;
        this.u = leftoverHighSurrogate;
      }
      w(buff, buffLen, codePoint) {
        if (codePoint < 128) {
          buff[buffLen++] = codePoint;
        } else if (codePoint < 2048) {
          buff[buffLen++] = 192 | (codePoint & 1984) >>> 6;
          buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
        } else if (codePoint < 65536) {
          buff[buffLen++] = 224 | (codePoint & 61440) >>> 12;
          buff[buffLen++] = 128 | (codePoint & 4032) >>> 6;
          buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
        } else {
          buff[buffLen++] = 240 | (codePoint & 1835008) >>> 18;
          buff[buffLen++] = 128 | (codePoint & 258048) >>> 12;
          buff[buffLen++] = 128 | (codePoint & 4032) >>> 6;
          buff[buffLen++] = 128 | (codePoint & 63) >>> 0;
        }
        if (buffLen >= 64) {
          this.y();
          buffLen -= 64;
          this.t += 64;
          buff[0] = buff[64 + 0];
          buff[1] = buff[64 + 1];
          buff[2] = buff[64 + 2];
        }
        return buffLen;
      }
      digest() {
        if (!this.v) {
          this.v = true;
          if (this.u) {
            this.u = 0;
            this.r = this.w(
              this.p,
              this.r,
              65533
              /* SHA1Constant.UNICODE_REPLACEMENT */
            );
          }
          this.t += this.r;
          this.x();
        }
        return toHexString(this.h) + toHexString(this.l) + toHexString(this.m) + toHexString(this.n) + toHexString(this.o);
      }
      x() {
        this.p[this.r++] = 128;
        this.p.subarray(this.r).fill(0);
        if (this.r > 56) {
          this.y();
          this.p.fill(0);
        }
        const ml = 8 * this.t;
        this.q.setUint32(56, Math.floor(ml / 4294967296), false);
        this.q.setUint32(60, ml % 4294967296, false);
        this.y();
      }
      y() {
        const bigBlock32 = _$kj.g;
        const data = this.q;
        for (let j = 0; j < 64; j += 4) {
          bigBlock32.setUint32(j, data.getUint32(j, false), false);
        }
        for (let j = 64; j < 320; j += 4) {
          bigBlock32.setUint32(j, leftRotate(bigBlock32.getUint32(j - 12, false) ^ bigBlock32.getUint32(j - 32, false) ^ bigBlock32.getUint32(j - 56, false) ^ bigBlock32.getUint32(j - 64, false), 1), false);
        }
        let a = this.h;
        let b = this.l;
        let c = this.m;
        let d = this.n;
        let e = this.o;
        let f, k;
        let temp;
        for (let j = 0; j < 80; j++) {
          if (j < 20) {
            f = b & c | ~b & d;
            k = 1518500249;
          } else if (j < 40) {
            f = b ^ c ^ d;
            k = 1859775393;
          } else if (j < 60) {
            f = b & c | b & d | c & d;
            k = 2400959708;
          } else {
            f = b ^ c ^ d;
            k = 3395469782;
          }
          temp = leftRotate(a, 5) + f + e + k + bigBlock32.getUint32(j * 4, false) & 4294967295;
          e = d;
          d = c;
          c = leftRotate(b, 30);
          b = a;
          a = temp;
        }
        this.h = this.h + a & 4294967295;
        this.l = this.l + b & 4294967295;
        this.m = this.m + c & 4294967295;
        this.n = this.n + d & 4294967295;
        this.o = this.o + e & 4294967295;
      }
    };
  }
});

// out-build/vs/base/common/extpath.js
function $$g(code) {
  return code === 47 || code === 92;
}
function $_g(osPath) {
  return osPath.replace(/[\\/]/g, $lc.sep);
}
function $ah(osPath) {
  if (osPath.indexOf("/") === -1) {
    osPath = $_g(osPath);
  }
  if (/^[a-zA-Z]:(\/|$)/.test(osPath)) {
    osPath = "/" + osPath;
  }
  return osPath;
}
function $bh(path7, sep2 = $lc.sep) {
  if (!path7) {
    return "";
  }
  const len = path7.length;
  const firstLetter = path7.charCodeAt(0);
  if ($$g(firstLetter)) {
    if ($$g(path7.charCodeAt(1))) {
      if (!$$g(path7.charCodeAt(2))) {
        let pos2 = 3;
        const start = pos2;
        for (; pos2 < len; pos2++) {
          if ($$g(path7.charCodeAt(pos2))) {
            break;
          }
        }
        if (start !== pos2 && !$$g(path7.charCodeAt(pos2 + 1))) {
          pos2 += 1;
          for (; pos2 < len; pos2++) {
            if ($$g(path7.charCodeAt(pos2))) {
              return path7.slice(0, pos2 + 1).replace(/[\\/]/g, sep2);
            }
          }
        }
      }
    }
    return sep2;
  } else if ($gh(firstLetter)) {
    if (path7.charCodeAt(1) === 58) {
      if ($$g(path7.charCodeAt(2))) {
        return path7.slice(0, 2) + sep2;
      } else {
        return path7.slice(0, 2);
      }
    }
  }
  let pos = path7.indexOf("://");
  if (pos !== -1) {
    pos += 3;
    for (; pos < len; pos++) {
      if ($$g(path7.charCodeAt(pos))) {
        return path7.slice(0, pos + 1);
      }
    }
  }
  return "";
}
function $eh(pathA, pathB, ignoreCase) {
  const identityEquals = pathA === pathB;
  if (!ignoreCase || identityEquals) {
    return identityEquals;
  }
  if (!pathA || !pathB) {
    return false;
  }
  return $yg(pathA, pathB);
}
function $fh(base, parentCandidate, ignoreCase, separator = sep) {
  if (base === parentCandidate) {
    return true;
  }
  if (!base || !parentCandidate) {
    return false;
  }
  if (parentCandidate.length > base.length) {
    return false;
  }
  if (ignoreCase) {
    const beginsWith = $zg(base, parentCandidate);
    if (!beginsWith) {
      return false;
    }
    if (parentCandidate.length === base.length) {
      return true;
    }
    let sepOffset = parentCandidate.length;
    if (parentCandidate.charAt(parentCandidate.length - 1) === separator) {
      sepOffset--;
    }
    return base.charAt(sepOffset) === separator;
  }
  if (parentCandidate.charAt(parentCandidate.length - 1) !== separator) {
    parentCandidate += separator;
  }
  return base.indexOf(parentCandidate) === 0;
}
function $gh(char0) {
  return char0 >= 65 && char0 <= 90 || char0 >= 97 && char0 <= 122;
}
function $ih(candidate) {
  if ($l) {
    candidate = $eg(candidate, sep);
    if (candidate.endsWith(":")) {
      candidate += sep;
    }
  } else {
    candidate = $eg(candidate, sep);
    if (!candidate) {
      candidate = sep;
    }
  }
  return candidate;
}
function $jh(path7) {
  const pathNormalized = $mc(path7);
  if ($l) {
    if (path7.length > 3) {
      return false;
    }
    return $kh(pathNormalized) && (path7.length === 2 || pathNormalized.charCodeAt(2) === 92);
  }
  return pathNormalized === $lc.sep;
}
function $kh(path7, isWindowsOS = $l) {
  if (isWindowsOS) {
    return $gh(path7.charCodeAt(0)) && path7.charCodeAt(1) === 58;
  }
  return false;
}
function $oh(parent, prefix, randomLength = 8) {
  let suffix = "";
  for (let i = 0; i < randomLength; i++) {
    let pathCharsTouse;
    if (i === 0 && $l && !prefix && (randomLength === 3 || randomLength === 4)) {
      pathCharsTouse = windowsSafePathFirstChars;
    } else {
      pathCharsTouse = pathChars;
    }
    suffix += pathCharsTouse.charAt(Math.floor(Math.random() * pathCharsTouse.length));
  }
  let randomFileName;
  if (prefix) {
    randomFileName = `${prefix}-${suffix}`;
  } else {
    randomFileName = suffix;
  }
  if (parent) {
    return $oc(parent, randomFileName);
  }
  return randomFileName;
}
var pathChars, windowsSafePathFirstChars;
var init_extpath = __esm({
  "out-build/vs/base/common/extpath.js"() {
    "use strict";
    init_path();
    init_platform();
    init_strings();
    init_types();
    pathChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    windowsSafePathFirstChars = "BDEFGHIJKMOQRSTUVWXYZbdefghijkmoqrstuvwxyz0123456789";
  }
});

// out-build/vs/base/common/resources.js
function $Dh(uri) {
  return $Bc(uri, true);
}
var $Eh, $Fh, $Gh, $Hh, $Ih, $Jh, $Kh, $Lh, $Mh, $Nh, $Oh, $Ph, $Qh, $Rh, $Sh, $Th, $Uh, $Vh, $Wh, $Xh, DataUri;
var init_resources = __esm({
  "out-build/vs/base/common/resources.js"() {
    "use strict";
    init_extpath();
    init_network();
    init_path();
    init_platform();
    init_strings();
    init_uri();
    $Eh = class {
      constructor(a) {
        this.a = a;
      }
      compare(uri1, uri2, ignoreFragment = false) {
        if (uri1 === uri2) {
          return 0;
        }
        return $rg(this.getComparisonKey(uri1, ignoreFragment), this.getComparisonKey(uri2, ignoreFragment));
      }
      isEqual(uri1, uri2, ignoreFragment = false) {
        if (uri1 === uri2) {
          return true;
        }
        if (!uri1 || !uri2) {
          return false;
        }
        return this.getComparisonKey(uri1, ignoreFragment) === this.getComparisonKey(uri2, ignoreFragment);
      }
      getComparisonKey(uri, ignoreFragment = false) {
        return uri.with({
          path: this.a(uri) ? uri.path.toLowerCase() : void 0,
          fragment: ignoreFragment ? null : void 0
        }).toString();
      }
      ignorePathCasing(uri) {
        return this.a(uri);
      }
      isEqualOrParent(base, parentCandidate, ignoreFragment = false) {
        if (base.scheme === parentCandidate.scheme) {
          if (base.scheme === Schemas.file) {
            return $fh($Dh(base), $Dh(parentCandidate), this.a(base)) && base.query === parentCandidate.query && (ignoreFragment || base.fragment === parentCandidate.fragment);
          }
          if ($Uh(base.authority, parentCandidate.authority)) {
            return $fh(base.path, parentCandidate.path, this.a(base), "/") && base.query === parentCandidate.query && (ignoreFragment || base.fragment === parentCandidate.fragment);
          }
        }
        return false;
      }
      // --- path math
      joinPath(resource, ...pathFragment) {
        return URI.joinPath(resource, ...pathFragment);
      }
      basenameOrAuthority(resource) {
        return $Mh(resource) || resource.authority;
      }
      basename(resource) {
        return $lc.basename(resource.path);
      }
      extname(resource) {
        return $lc.extname(resource.path);
      }
      dirname(resource) {
        if (resource.path.length === 0) {
          return resource;
        }
        let dirname5;
        if (resource.scheme === Schemas.file) {
          dirname5 = URI.file($rc($Dh(resource))).path;
        } else {
          dirname5 = $lc.dirname(resource.path);
          if (resource.authority && dirname5.length && dirname5.charCodeAt(0) !== 47) {
            console.error(`dirname("${resource.toString})) resulted in a relative path`);
            dirname5 = "/";
          }
        }
        return resource.with({
          path: dirname5
        });
      }
      normalizePath(resource) {
        if (!resource.path.length) {
          return resource;
        }
        let normalizedPath;
        if (resource.scheme === Schemas.file) {
          normalizedPath = URI.file($mc($Dh(resource))).path;
        } else {
          normalizedPath = $lc.normalize(resource.path);
        }
        return resource.with({
          path: normalizedPath
        });
      }
      relativePath(from, to) {
        if (from.scheme !== to.scheme || !$Uh(from.authority, to.authority)) {
          return void 0;
        }
        if (from.scheme === Schemas.file) {
          const relativePath = $qc($Dh(from), $Dh(to));
          return $l ? $_g(relativePath) : relativePath;
        }
        let fromPath = from.path || "/";
        const toPath = to.path || "/";
        if (this.a(from)) {
          let i = 0;
          for (const len = Math.min(fromPath.length, toPath.length); i < len; i++) {
            if (fromPath.charCodeAt(i) !== toPath.charCodeAt(i)) {
              if (fromPath.charAt(i).toLowerCase() !== toPath.charAt(i).toLowerCase()) {
                break;
              }
            }
          }
          fromPath = toPath.substr(0, i) + fromPath.substr(i);
        }
        return $lc.relative(fromPath, toPath);
      }
      resolvePath(base, path7) {
        if (base.scheme === Schemas.file) {
          const newURI = URI.file($pc($Dh(base), path7));
          return base.with({
            authority: newURI.authority,
            path: newURI.path
          });
        }
        path7 = $ah(path7);
        return base.with({
          path: $lc.resolve(base.path, path7)
        });
      }
      // --- misc
      isAbsolutePath(resource) {
        return !!resource.path && resource.path[0] === "/";
      }
      isEqualAuthority(a1, a2) {
        return a1 === a2 || a1 !== void 0 && a2 !== void 0 && $yg(a1, a2);
      }
      hasTrailingPathSeparator(resource, sep2 = sep) {
        if (resource.scheme === Schemas.file) {
          const fsp = $Dh(resource);
          return fsp.length > $bh(fsp).length && fsp[fsp.length - 1] === sep2;
        } else {
          const p = resource.path;
          return p.length > 1 && p.charCodeAt(p.length - 1) === 47 && !/^[a-zA-Z]:(\/$|\\$)/.test(resource.fsPath);
        }
      }
      removeTrailingPathSeparator(resource, sep2 = sep) {
        if ($Vh(resource, sep2)) {
          return resource.with({ path: resource.path.substr(0, resource.path.length - 1) });
        }
        return resource;
      }
      addTrailingPathSeparator(resource, sep2 = sep) {
        let isRootSep = false;
        if (resource.scheme === Schemas.file) {
          const fsp = $Dh(resource);
          isRootSep = fsp !== void 0 && fsp.length === $bh(fsp).length && fsp[fsp.length - 1] === sep2;
        } else {
          sep2 = "/";
          const p = resource.path;
          isRootSep = p.length === 1 && p.charCodeAt(p.length - 1) === 47;
        }
        if (!isRootSep && !$Vh(resource, sep2)) {
          return resource.with({ path: resource.path + "/" });
        }
        return resource;
      }
    };
    $Fh = new $Eh(() => false);
    $Gh = new $Eh((uri) => {
      return uri.scheme === Schemas.file ? !$n : true;
    });
    $Hh = new $Eh((_) => true);
    $Ih = $Fh.isEqual.bind($Fh);
    $Jh = $Fh.isEqualOrParent.bind($Fh);
    $Kh = $Fh.getComparisonKey.bind($Fh);
    $Lh = $Fh.basenameOrAuthority.bind($Fh);
    $Mh = $Fh.basename.bind($Fh);
    $Nh = $Fh.extname.bind($Fh);
    $Oh = $Fh.dirname.bind($Fh);
    $Ph = $Fh.joinPath.bind($Fh);
    $Qh = $Fh.normalizePath.bind($Fh);
    $Rh = $Fh.relativePath.bind($Fh);
    $Sh = $Fh.resolvePath.bind($Fh);
    $Th = $Fh.isAbsolutePath.bind($Fh);
    $Uh = $Fh.isEqualAuthority.bind($Fh);
    $Vh = $Fh.hasTrailingPathSeparator.bind($Fh);
    $Wh = $Fh.removeTrailingPathSeparator.bind($Fh);
    $Xh = $Fh.addTrailingPathSeparator.bind($Fh);
    (function(DataUri2) {
      DataUri2.META_DATA_LABEL = "label";
      DataUri2.META_DATA_DESCRIPTION = "description";
      DataUri2.META_DATA_SIZE = "size";
      DataUri2.META_DATA_MIME = "mime";
      function parseMetaData(dataUri) {
        const metadata = /* @__PURE__ */ new Map();
        const meta = dataUri.path.substring(dataUri.path.indexOf(";") + 1, dataUri.path.lastIndexOf(";"));
        meta.split(";").forEach((property) => {
          const [key, value] = property.split(":");
          if (key && value) {
            metadata.set(key, value);
          }
        });
        const mime = dataUri.path.substring(0, dataUri.path.indexOf(";"));
        if (mime) {
          metadata.set(DataUri2.META_DATA_MIME, mime);
        }
        return metadata;
      }
      DataUri2.parseMetaData = parseMetaData;
    })(DataUri || (DataUri = {}));
  }
});

// out-build/vs/platform/contextkey/common/scanner.js
function hintDidYouMean(...meant) {
  switch (meant.length) {
    case 1:
      return localize(1822, null, meant[0]);
    case 2:
      return localize(1823, null, meant[0], meant[1]);
    case 3:
      return localize(1824, null, meant[0], meant[1], meant[2]);
    default:
      return void 0;
  }
}
var TokenType, hintDidYouForgetToOpenOrCloseQuote, hintDidYouForgetToEscapeSlash, $zn;
var init_scanner = __esm({
  "out-build/vs/platform/contextkey/common/scanner.js"() {
    "use strict";
    init_errors();
    init_nls2();
    (function(TokenType3) {
      TokenType3[TokenType3["LParen"] = 0] = "LParen";
      TokenType3[TokenType3["RParen"] = 1] = "RParen";
      TokenType3[TokenType3["Neg"] = 2] = "Neg";
      TokenType3[TokenType3["Eq"] = 3] = "Eq";
      TokenType3[TokenType3["NotEq"] = 4] = "NotEq";
      TokenType3[TokenType3["Lt"] = 5] = "Lt";
      TokenType3[TokenType3["LtEq"] = 6] = "LtEq";
      TokenType3[TokenType3["Gt"] = 7] = "Gt";
      TokenType3[TokenType3["GtEq"] = 8] = "GtEq";
      TokenType3[TokenType3["RegexOp"] = 9] = "RegexOp";
      TokenType3[TokenType3["RegexStr"] = 10] = "RegexStr";
      TokenType3[TokenType3["True"] = 11] = "True";
      TokenType3[TokenType3["False"] = 12] = "False";
      TokenType3[TokenType3["In"] = 13] = "In";
      TokenType3[TokenType3["Not"] = 14] = "Not";
      TokenType3[TokenType3["And"] = 15] = "And";
      TokenType3[TokenType3["Or"] = 16] = "Or";
      TokenType3[TokenType3["Str"] = 17] = "Str";
      TokenType3[TokenType3["QuotedStr"] = 18] = "QuotedStr";
      TokenType3[TokenType3["Error"] = 19] = "Error";
      TokenType3[TokenType3["EOF"] = 20] = "EOF";
    })(TokenType || (TokenType = {}));
    hintDidYouForgetToOpenOrCloseQuote = localize(1825, null);
    hintDidYouForgetToEscapeSlash = localize(1826, null);
    $zn = class _$zn {
      constructor() {
        this.c = "";
        this.d = 0;
        this.e = 0;
        this.f = [];
        this.g = [];
        this.m = /[a-zA-Z0-9_<>\-\./\\:\*\?\+\[\]\^,#@;"%\$\p{L}-]+/uy;
      }
      static getLexeme(token) {
        switch (token.type) {
          case 0:
            return "(";
          case 1:
            return ")";
          case 2:
            return "!";
          case 3:
            return token.isTripleEq ? "===" : "==";
          case 4:
            return token.isTripleEq ? "!==" : "!=";
          case 5:
            return "<";
          case 6:
            return "<=";
          case 7:
            return ">=";
          case 8:
            return ">=";
          case 9:
            return "=~";
          case 10:
            return token.lexeme;
          case 11:
            return "true";
          case 12:
            return "false";
          case 13:
            return "in";
          case 14:
            return "not";
          case 15:
            return "&&";
          case 16:
            return "||";
          case 17:
            return token.lexeme;
          case 18:
            return token.lexeme;
          case 19:
            return token.lexeme;
          case 20:
            return "EOF";
          default:
            throw $ob(`unhandled token type: ${JSON.stringify(token)}; have you forgotten to add a case?`);
        }
      }
      static {
        this.a = new Set(["i", "g", "s", "m", "y", "u"].map((ch) => ch.charCodeAt(0)));
      }
      static {
        this.b = /* @__PURE__ */ new Map([
          [
            "not",
            14
            /* TokenType.Not */
          ],
          [
            "in",
            13
            /* TokenType.In */
          ],
          [
            "false",
            12
            /* TokenType.False */
          ],
          [
            "true",
            11
            /* TokenType.True */
          ]
        ]);
      }
      get errors() {
        return this.g;
      }
      reset(value) {
        this.c = value;
        this.d = 0;
        this.e = 0;
        this.f = [];
        this.g = [];
        return this;
      }
      scan() {
        while (!this.r()) {
          this.d = this.e;
          const ch = this.i();
          switch (ch) {
            case 40:
              this.k(
                0
                /* TokenType.LParen */
              );
              break;
            case 41:
              this.k(
                1
                /* TokenType.RParen */
              );
              break;
            case 33:
              if (this.h(
                61
                /* CharCode.Equals */
              )) {
                const isTripleEq = this.h(
                  61
                  /* CharCode.Equals */
                );
                this.f.push({ type: 4, offset: this.d, isTripleEq });
              } else {
                this.k(
                  2
                  /* TokenType.Neg */
                );
              }
              break;
            case 39:
              this.o();
              break;
            case 47:
              this.q();
              break;
            case 61:
              if (this.h(
                61
                /* CharCode.Equals */
              )) {
                const isTripleEq = this.h(
                  61
                  /* CharCode.Equals */
                );
                this.f.push({ type: 3, offset: this.d, isTripleEq });
              } else if (this.h(
                126
                /* CharCode.Tilde */
              )) {
                this.k(
                  9
                  /* TokenType.RegexOp */
                );
              } else {
                this.l(hintDidYouMean("==", "=~"));
              }
              break;
            case 60:
              this.k(
                this.h(
                  61
                  /* CharCode.Equals */
                ) ? 6 : 5
                /* TokenType.Lt */
              );
              break;
            case 62:
              this.k(
                this.h(
                  61
                  /* CharCode.Equals */
                ) ? 8 : 7
                /* TokenType.Gt */
              );
              break;
            case 38:
              if (this.h(
                38
                /* CharCode.Ampersand */
              )) {
                this.k(
                  15
                  /* TokenType.And */
                );
              } else {
                this.l(hintDidYouMean("&&"));
              }
              break;
            case 124:
              if (this.h(
                124
                /* CharCode.Pipe */
              )) {
                this.k(
                  16
                  /* TokenType.Or */
                );
              } else {
                this.l(hintDidYouMean("||"));
              }
              break;
            // TODO@ulugbekna: 1) rewrite using a regex 2) reconsider what characters are considered whitespace, including unicode, nbsp, etc.
            case 32:
            case 13:
            case 9:
            case 10:
            case 160:
              break;
            default:
              this.n();
          }
        }
        this.d = this.e;
        this.k(
          20
          /* TokenType.EOF */
        );
        return Array.from(this.f);
      }
      h(expected) {
        if (this.r()) {
          return false;
        }
        if (this.c.charCodeAt(this.e) !== expected) {
          return false;
        }
        this.e++;
        return true;
      }
      i() {
        return this.c.charCodeAt(this.e++);
      }
      j() {
        return this.r() ? 0 : this.c.charCodeAt(this.e);
      }
      k(type2) {
        this.f.push({ type: type2, offset: this.d });
      }
      l(additional) {
        const offset = this.d;
        const lexeme = this.c.substring(this.d, this.e);
        const errToken = { type: 19, offset: this.d, lexeme };
        this.g.push({ offset, lexeme, additionalInfo: additional });
        this.f.push(errToken);
      }
      n() {
        this.m.lastIndex = this.d;
        const match = this.m.exec(this.c);
        if (match) {
          this.e = this.d + match[0].length;
          const lexeme = this.c.substring(this.d, this.e);
          const keyword = _$zn.b.get(lexeme);
          if (keyword) {
            this.k(keyword);
          } else {
            this.f.push({ type: 17, lexeme, offset: this.d });
          }
        }
      }
      // captures the lexeme without the leading and trailing '
      o() {
        while (this.j() !== 39 && !this.r()) {
          this.i();
        }
        if (this.r()) {
          this.l(hintDidYouForgetToOpenOrCloseQuote);
          return;
        }
        this.i();
        this.f.push({ type: 18, lexeme: this.c.substring(this.d + 1, this.e - 1), offset: this.d + 1 });
      }
      /*
       * Lexing a regex expression: /.../[igsmyu]*
       * Based on https://github.com/microsoft/TypeScript/blob/9247ef115e617805983740ba795d7a8164babf89/src/compiler/scanner.ts#L2129-L2181
       *
       * Note that we want slashes within a regex to be escaped, e.g., /file:\\/\\/\\// should match `file:///`
       */
      q() {
        let p = this.e;
        let inEscape = false;
        let inCharacterClass = false;
        while (true) {
          if (p >= this.c.length) {
            this.e = p;
            this.l(hintDidYouForgetToEscapeSlash);
            return;
          }
          const ch = this.c.charCodeAt(p);
          if (inEscape) {
            inEscape = false;
          } else if (ch === 47 && !inCharacterClass) {
            p++;
            break;
          } else if (ch === 91) {
            inCharacterClass = true;
          } else if (ch === 92) {
            inEscape = true;
          } else if (ch === 93) {
            inCharacterClass = false;
          }
          p++;
        }
        while (p < this.c.length && _$zn.a.has(this.c.charCodeAt(p))) {
          p++;
        }
        this.e = p;
        const lexeme = this.c.substring(this.d, this.e);
        this.f.push({ type: 10, lexeme, offset: this.d });
      }
      r() {
        return this.e >= this.c.length;
      }
    };
  }
});

// out-build/vs/platform/instantiation/common/instantiation.js
function storeServiceDependency(id2, target, index) {
  if (target[_util.DI_TARGET] === target) {
    target[_util.DI_DEPENDENCIES].push({ id: id2, index });
  } else {
    target[_util.DI_DEPENDENCIES] = [{ id: id2, index }];
    target[_util.DI_TARGET] = target;
  }
}
function $kl(serviceId) {
  if (_util.serviceIds.has(serviceId)) {
    return _util.serviceIds.get(serviceId);
  }
  const id2 = function(target, key, index) {
    if (arguments.length !== 3) {
      throw new Error("@IServiceName-decorator can only be used to decorate a parameter");
    }
    storeServiceDependency(id2, target, index);
  };
  id2.toString = () => serviceId;
  _util.serviceIds.set(serviceId, id2);
  return id2;
}
function $ll(serviceIdentifier) {
  return serviceIdentifier;
}
var _util, $jl;
var init_instantiation = __esm({
  "out-build/vs/platform/instantiation/common/instantiation.js"() {
    "use strict";
    (function(_util2) {
      _util2.serviceIds = /* @__PURE__ */ new Map();
      _util2.DI_TARGET = "$di$target";
      _util2.DI_DEPENDENCIES = "$di$dependencies";
      function getServiceDependencies(ctor) {
        return ctor[_util2.DI_DEPENDENCIES] || [];
      }
      _util2.getServiceDependencies = getServiceDependencies;
    })(_util || (_util = {}));
    $jl = $kl("instantiationService");
  }
});

// out-build/vs/platform/contextkey/common/contextkey.js
function cmp(a, b) {
  return a.cmp(b);
}
function withFloatOrStr(value, callback) {
  if (typeof value === "string") {
    const n = parseFloat(value);
    if (!isNaN(n)) {
      value = n;
    }
  }
  if (typeof value === "string" || typeof value === "number") {
    return callback(value);
  }
  return $Fn.INSTANCE;
}
function eliminateConstantsInArray(arr) {
  let newArr = null;
  for (let i = 0, len = arr.length; i < len; i++) {
    const newExpr = arr[i].substituteConstants();
    if (arr[i] !== newExpr) {
      if (newArr === null) {
        newArr = [];
        for (let j = 0; j < i; j++) {
          newArr[j] = arr[j];
        }
      }
    }
    if (newArr !== null) {
      newArr[i] = newExpr;
    }
  }
  if (newArr === null) {
    return arr;
  }
  return newArr;
}
function cmp1(key1, key2) {
  if (key1 < key2) {
    return -1;
  }
  if (key1 > key2) {
    return 1;
  }
  return 0;
}
function cmp2(key1, value1, key2, value2) {
  if (key1 < key2) {
    return -1;
  }
  if (key1 > key2) {
    return 1;
  }
  if (value1 < value2) {
    return -1;
  }
  if (value1 > value2) {
    return 1;
  }
  return 0;
}
function getTerminals(node) {
  if (node.type === 9) {
    return node.expr;
  }
  return [node];
}
var CONSTANT_VALUES, hasOwnProperty2, ContextKeyExprType, defaultConfig, errorEmptyString, hintEmptyString, errorNoInAfterNot, errorClosingParenthesis, errorUnexpectedToken, hintUnexpectedToken, errorUnexpectedEOF, hintUnexpectedEOF, $Bn, $Cn, $Fn, $Gn, $Hn, $In, $Jn, $Kn, $Ln, $Mn, $Nn, $On, $Pn, $Qn, $Rn, $Sn, $Tn, $Un, $Vn, $Wn;
var init_contextkey = __esm({
  "out-build/vs/platform/contextkey/common/contextkey.js"() {
    "use strict";
    init_platform();
    init_strings();
    init_scanner();
    init_instantiation();
    init_nls2();
    init_errors();
    CONSTANT_VALUES = /* @__PURE__ */ new Map();
    CONSTANT_VALUES.set("false", false);
    CONSTANT_VALUES.set("true", true);
    CONSTANT_VALUES.set("isMac", $m);
    CONSTANT_VALUES.set("isLinux", $n);
    CONSTANT_VALUES.set("isWindows", $l);
    CONSTANT_VALUES.set("isWeb", $r);
    CONSTANT_VALUES.set("isMacNative", $m && !$r);
    CONSTANT_VALUES.set("isEdge", $K);
    CONSTANT_VALUES.set("isFirefox", $I);
    CONSTANT_VALUES.set("isChrome", $H);
    CONSTANT_VALUES.set("isSafari", $J);
    hasOwnProperty2 = Object.prototype.hasOwnProperty;
    (function(ContextKeyExprType2) {
      ContextKeyExprType2[ContextKeyExprType2["False"] = 0] = "False";
      ContextKeyExprType2[ContextKeyExprType2["True"] = 1] = "True";
      ContextKeyExprType2[ContextKeyExprType2["Defined"] = 2] = "Defined";
      ContextKeyExprType2[ContextKeyExprType2["Not"] = 3] = "Not";
      ContextKeyExprType2[ContextKeyExprType2["Equals"] = 4] = "Equals";
      ContextKeyExprType2[ContextKeyExprType2["NotEquals"] = 5] = "NotEquals";
      ContextKeyExprType2[ContextKeyExprType2["And"] = 6] = "And";
      ContextKeyExprType2[ContextKeyExprType2["Regex"] = 7] = "Regex";
      ContextKeyExprType2[ContextKeyExprType2["NotRegex"] = 8] = "NotRegex";
      ContextKeyExprType2[ContextKeyExprType2["Or"] = 9] = "Or";
      ContextKeyExprType2[ContextKeyExprType2["In"] = 10] = "In";
      ContextKeyExprType2[ContextKeyExprType2["NotIn"] = 11] = "NotIn";
      ContextKeyExprType2[ContextKeyExprType2["Greater"] = 12] = "Greater";
      ContextKeyExprType2[ContextKeyExprType2["GreaterEquals"] = 13] = "GreaterEquals";
      ContextKeyExprType2[ContextKeyExprType2["Smaller"] = 14] = "Smaller";
      ContextKeyExprType2[ContextKeyExprType2["SmallerEquals"] = 15] = "SmallerEquals";
    })(ContextKeyExprType || (ContextKeyExprType = {}));
    defaultConfig = {
      regexParsingWithErrorRecovery: true
    };
    errorEmptyString = localize(1802, null);
    hintEmptyString = localize(1803, null);
    errorNoInAfterNot = localize(1804, null);
    errorClosingParenthesis = localize(1805, null);
    errorUnexpectedToken = localize(1806, null);
    hintUnexpectedToken = localize(1807, null);
    errorUnexpectedEOF = localize(1808, null);
    hintUnexpectedEOF = localize(1809, null);
    $Bn = class _$Bn {
      static {
        this.c = new Error();
      }
      get lexingErrors() {
        return this.d.errors;
      }
      get parsingErrors() {
        return this.h;
      }
      constructor(k = defaultConfig) {
        this.k = k;
        this.d = new $zn();
        this.f = [];
        this.g = 0;
        this.h = [];
        this.v = /g|y/g;
      }
      /**
       * Parse a context key expression.
       *
       * @param input the expression to parse
       * @returns the parsed expression or `undefined` if there's an error - call `lexingErrors` and `parsingErrors` to see the errors
       */
      parse(input) {
        if (input === "") {
          this.h.push({ message: errorEmptyString, offset: 0, lexeme: "", additionalInfo: hintEmptyString });
          return void 0;
        }
        this.f = this.d.reset(input).scan();
        this.g = 0;
        this.h = [];
        try {
          const expr = this.l();
          if (!this.E()) {
            const peek = this.D();
            const additionalInfo = peek.type === 17 ? hintUnexpectedToken : void 0;
            this.h.push({ message: errorUnexpectedToken, offset: peek.offset, lexeme: $zn.getLexeme(peek), additionalInfo });
            throw _$Bn.c;
          }
          return expr;
        } catch (e) {
          if (!(e === _$Bn.c)) {
            throw e;
          }
          return void 0;
        }
      }
      l() {
        return this.m();
      }
      m() {
        const expr = [this.o()];
        while (this.y(
          16
          /* TokenType.Or */
        )) {
          const right = this.o();
          expr.push(right);
        }
        return expr.length === 1 ? expr[0] : $Cn.or(...expr);
      }
      o() {
        const expr = [this.s()];
        while (this.y(
          15
          /* TokenType.And */
        )) {
          const right = this.s();
          expr.push(right);
        }
        return expr.length === 1 ? expr[0] : $Cn.and(...expr);
      }
      s() {
        if (this.y(
          2
          /* TokenType.Neg */
        )) {
          const peek = this.D();
          switch (peek.type) {
            case 11:
              this.z();
              return $Fn.INSTANCE;
            case 12:
              this.z();
              return $Gn.INSTANCE;
            case 0: {
              this.z();
              const expr = this.l();
              this.A(1, errorClosingParenthesis);
              return expr?.negate();
            }
            case 17:
              this.z();
              return $Mn.create(peek.lexeme);
            default:
              throw this.B(`KEY | true | false | '(' expression ')'`, peek);
          }
        }
        return this.t();
      }
      t() {
        const peek = this.D();
        switch (peek.type) {
          case 11:
            this.z();
            return $Cn.true();
          case 12:
            this.z();
            return $Cn.false();
          case 0: {
            this.z();
            const expr = this.l();
            this.A(1, errorClosingParenthesis);
            return expr;
          }
          case 17: {
            const key = peek.lexeme;
            this.z();
            if (this.y(
              9
              /* TokenType.RegexOp */
            )) {
              const expr = this.D();
              if (!this.k.regexParsingWithErrorRecovery) {
                this.z();
                if (expr.type !== 10) {
                  throw this.B(`REGEX`, expr);
                }
                const regexLexeme = expr.lexeme;
                const closingSlashIndex = regexLexeme.lastIndexOf("/");
                const flags = closingSlashIndex === regexLexeme.length - 1 ? void 0 : this.w(regexLexeme.substring(closingSlashIndex + 1));
                let regexp;
                try {
                  regexp = new RegExp(regexLexeme.substring(1, closingSlashIndex), flags);
                } catch (e) {
                  throw this.B(`REGEX`, expr);
                }
                return $Rn.create(key, regexp);
              }
              switch (expr.type) {
                case 10:
                case 19: {
                  const lexemeReconstruction = [expr.lexeme];
                  this.z();
                  let followingToken = this.D();
                  let parenBalance = 0;
                  for (let i = 0; i < expr.lexeme.length; i++) {
                    if (expr.lexeme.charCodeAt(i) === 40) {
                      parenBalance++;
                    } else if (expr.lexeme.charCodeAt(i) === 41) {
                      parenBalance--;
                    }
                  }
                  while (!this.E() && followingToken.type !== 15 && followingToken.type !== 16) {
                    switch (followingToken.type) {
                      case 0:
                        parenBalance++;
                        break;
                      case 1:
                        parenBalance--;
                        break;
                      case 10:
                      case 18:
                        for (let i = 0; i < followingToken.lexeme.length; i++) {
                          if (followingToken.lexeme.charCodeAt(i) === 40) {
                            parenBalance++;
                          } else if (expr.lexeme.charCodeAt(i) === 41) {
                            parenBalance--;
                          }
                        }
                    }
                    if (parenBalance < 0) {
                      break;
                    }
                    lexemeReconstruction.push($zn.getLexeme(followingToken));
                    this.z();
                    followingToken = this.D();
                  }
                  const regexLexeme = lexemeReconstruction.join("");
                  const closingSlashIndex = regexLexeme.lastIndexOf("/");
                  const flags = closingSlashIndex === regexLexeme.length - 1 ? void 0 : this.w(regexLexeme.substring(closingSlashIndex + 1));
                  let regexp;
                  try {
                    regexp = new RegExp(regexLexeme.substring(1, closingSlashIndex), flags);
                  } catch (e) {
                    throw this.B(`REGEX`, expr);
                  }
                  return $Cn.regex(key, regexp);
                }
                case 18: {
                  const serializedValue = expr.lexeme;
                  this.z();
                  let regex = null;
                  if (!$6f(serializedValue)) {
                    const start = serializedValue.indexOf("/");
                    const end = serializedValue.lastIndexOf("/");
                    if (start !== end && start >= 0) {
                      const value = serializedValue.slice(start + 1, end);
                      const caseIgnoreFlag = serializedValue[end + 1] === "i" ? "i" : "";
                      try {
                        regex = new RegExp(value, caseIgnoreFlag);
                      } catch (_e) {
                        throw this.B(`REGEX`, expr);
                      }
                    }
                  }
                  if (regex === null) {
                    throw this.B("REGEX", expr);
                  }
                  return $Rn.create(key, regex);
                }
                default:
                  throw this.B("REGEX", this.D());
              }
            }
            if (this.y(
              14
              /* TokenType.Not */
            )) {
              this.A(13, errorNoInAfterNot);
              const right = this.u();
              return $Cn.notIn(key, right);
            }
            const maybeOp = this.D().type;
            switch (maybeOp) {
              case 3: {
                this.z();
                const right = this.u();
                if (this.x().type === 18) {
                  return $Cn.equals(key, right);
                }
                switch (right) {
                  case "true":
                    return $Cn.has(key);
                  case "false":
                    return $Cn.not(key);
                  default:
                    return $Cn.equals(key, right);
                }
              }
              case 4: {
                this.z();
                const right = this.u();
                if (this.x().type === 18) {
                  return $Cn.notEquals(key, right);
                }
                switch (right) {
                  case "true":
                    return $Cn.not(key);
                  case "false":
                    return $Cn.has(key);
                  default:
                    return $Cn.notEquals(key, right);
                }
              }
              // TODO: ContextKeyExpr.smaller(key, right) accepts only `number` as `right` AND during eval of this node, we just eval to `false` if `right` is not a number
              // consequently, package.json linter should _warn_ the user if they're passing undesired things to ops
              case 5:
                this.z();
                return $Pn.create(key, this.u());
              case 6:
                this.z();
                return $Qn.create(key, this.u());
              case 7:
                this.z();
                return $Nn.create(key, this.u());
              case 8:
                this.z();
                return $On.create(key, this.u());
              case 13:
                this.z();
                return $Cn.in(key, this.u());
              default:
                return $Cn.has(key);
            }
          }
          case 20:
            this.h.push({ message: errorUnexpectedEOF, offset: peek.offset, lexeme: "", additionalInfo: hintUnexpectedEOF });
            throw _$Bn.c;
          default:
            throw this.B(`true | false | KEY 
	| KEY '=~' REGEX 
	| KEY ('==' | '!=' | '<' | '<=' | '>' | '>=' | 'in' | 'not' 'in') value`, this.D());
        }
      }
      u() {
        const token = this.D();
        switch (token.type) {
          case 17:
          case 18:
            this.z();
            return token.lexeme;
          case 11:
            this.z();
            return "true";
          case 12:
            this.z();
            return "false";
          case 13:
            this.z();
            return "in";
          default:
            return "";
        }
      }
      w(flags) {
        return flags.replaceAll(this.v, "");
      }
      // careful: this can throw if current token is the initial one (ie index = 0)
      x() {
        return this.f[this.g - 1];
      }
      y(token) {
        if (this.C(token)) {
          this.z();
          return true;
        }
        return false;
      }
      z() {
        if (!this.E()) {
          this.g++;
        }
        return this.x();
      }
      A(type2, message) {
        if (this.C(type2)) {
          return this.z();
        }
        throw this.B(message, this.D());
      }
      B(expected, got, additionalInfo) {
        const message = localize(1810, null, expected, $zn.getLexeme(got));
        const offset = got.offset;
        const lexeme = $zn.getLexeme(got);
        this.h.push({ message, offset, lexeme, additionalInfo });
        return _$Bn.c;
      }
      C(type2) {
        return this.D().type === type2;
      }
      D() {
        return this.f[this.g];
      }
      E() {
        return this.D().type === 20;
      }
    };
    $Cn = class {
      static false() {
        return $Fn.INSTANCE;
      }
      static true() {
        return $Gn.INSTANCE;
      }
      static has(key) {
        return $Hn.create(key);
      }
      static equals(key, value) {
        return $In.create(key, value);
      }
      static notEquals(key, value) {
        return $Ln.create(key, value);
      }
      static regex(key, value) {
        return $Rn.create(key, value);
      }
      static in(key, value) {
        return $Jn.create(key, value);
      }
      static notIn(key, value) {
        return $Kn.create(key, value);
      }
      static not(key) {
        return $Mn.create(key);
      }
      static and(...expr) {
        return $Tn.create(expr, null, true);
      }
      static or(...expr) {
        return $Un.create(expr, null, true);
      }
      static greater(key, value) {
        return $Nn.create(key, value);
      }
      static greaterEquals(key, value) {
        return $On.create(key, value);
      }
      static smaller(key, value) {
        return $Pn.create(key, value);
      }
      static smallerEquals(key, value) {
        return $Qn.create(key, value);
      }
      static {
        this.c = new $Bn({ regexParsingWithErrorRecovery: false });
      }
      static deserialize(serialized) {
        if (serialized === void 0 || serialized === null) {
          return void 0;
        }
        const expr = this.c.parse(serialized);
        return expr;
      }
    };
    $Fn = class _$Fn {
      static {
        this.INSTANCE = new _$Fn();
      }
      constructor() {
        this.type = 0;
      }
      cmp(other) {
        return this.type - other.type;
      }
      equals(other) {
        return other.type === this.type;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        return false;
      }
      serialize() {
        return "false";
      }
      keys() {
        return [];
      }
      map(mapFnc) {
        return this;
      }
      negate() {
        return $Gn.INSTANCE;
      }
    };
    $Gn = class _$Gn {
      static {
        this.INSTANCE = new _$Gn();
      }
      constructor() {
        this.type = 1;
      }
      cmp(other) {
        return this.type - other.type;
      }
      equals(other) {
        return other.type === this.type;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        return true;
      }
      serialize() {
        return "true";
      }
      keys() {
        return [];
      }
      map(mapFnc) {
        return this;
      }
      negate() {
        return $Fn.INSTANCE;
      }
    };
    $Hn = class _$Hn {
      static create(key, negated = null) {
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === "boolean") {
          return constantValue ? $Gn.INSTANCE : $Fn.INSTANCE;
        }
        return new _$Hn(key, negated);
      }
      constructor(key, c) {
        this.key = key;
        this.c = c;
        this.type = 2;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp1(this.key, other.key);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.key === other.key;
        }
        return false;
      }
      substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.key);
        if (typeof constantValue === "boolean") {
          return constantValue ? $Gn.INSTANCE : $Fn.INSTANCE;
        }
        return this;
      }
      evaluate(context) {
        return !!context.getValue(this.key);
      }
      serialize() {
        return this.key;
      }
      keys() {
        return [this.key];
      }
      map(mapFnc) {
        return mapFnc.mapDefined(this.key);
      }
      negate() {
        if (!this.c) {
          this.c = $Mn.create(this.key, this);
        }
        return this.c;
      }
    };
    $In = class _$In {
      static create(key, value, negated = null) {
        if (typeof value === "boolean") {
          return value ? $Hn.create(key, negated) : $Mn.create(key, negated);
        }
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === "boolean") {
          const trueValue = constantValue ? "true" : "false";
          return value === trueValue ? $Gn.INSTANCE : $Fn.INSTANCE;
        }
        return new _$In(key, value, negated);
      }
      constructor(c, d, f) {
        this.c = c;
        this.d = d;
        this.f = f;
        this.type = 4;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.c, this.d, other.c, other.d);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c === other.c && this.d === other.d;
        }
        return false;
      }
      substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.c);
        if (typeof constantValue === "boolean") {
          const trueValue = constantValue ? "true" : "false";
          return this.d === trueValue ? $Gn.INSTANCE : $Fn.INSTANCE;
        }
        return this;
      }
      evaluate(context) {
        return context.getValue(this.c) == this.d;
      }
      serialize() {
        return `${this.c} == '${this.d}'`;
      }
      keys() {
        return [this.c];
      }
      map(mapFnc) {
        return mapFnc.mapEquals(this.c, this.d);
      }
      negate() {
        if (!this.f) {
          this.f = $Ln.create(this.c, this.d, this);
        }
        return this.f;
      }
    };
    $Jn = class _$Jn {
      static create(key, valueKey) {
        return new _$Jn(key, valueKey);
      }
      constructor(d, f) {
        this.d = d;
        this.f = f;
        this.type = 10;
        this.c = null;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.d, this.f, other.d, other.f);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.d === other.d && this.f === other.f;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        const source = context.getValue(this.f);
        const item = context.getValue(this.d);
        if (Array.isArray(source)) {
          return source.includes(item);
        }
        if (typeof item === "string" && typeof source === "object" && source !== null) {
          return hasOwnProperty2.call(source, item);
        }
        return false;
      }
      serialize() {
        return `${this.d} in '${this.f}'`;
      }
      keys() {
        return [this.d, this.f];
      }
      map(mapFnc) {
        return mapFnc.mapIn(this.d, this.f);
      }
      negate() {
        if (!this.c) {
          this.c = $Kn.create(this.d, this.f);
        }
        return this.c;
      }
    };
    $Kn = class _$Kn {
      static create(key, valueKey) {
        return new _$Kn(key, valueKey);
      }
      constructor(d, f) {
        this.d = d;
        this.f = f;
        this.type = 11;
        this.c = $Jn.create(d, f);
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return this.c.cmp(other.c);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c.equals(other.c);
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        return !this.c.evaluate(context);
      }
      serialize() {
        return `${this.d} not in '${this.f}'`;
      }
      keys() {
        return this.c.keys();
      }
      map(mapFnc) {
        return mapFnc.mapNotIn(this.d, this.f);
      }
      negate() {
        return this.c;
      }
    };
    $Ln = class _$Ln {
      static create(key, value, negated = null) {
        if (typeof value === "boolean") {
          if (value) {
            return $Mn.create(key, negated);
          }
          return $Hn.create(key, negated);
        }
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === "boolean") {
          const falseValue = constantValue ? "true" : "false";
          return value === falseValue ? $Fn.INSTANCE : $Gn.INSTANCE;
        }
        return new _$Ln(key, value, negated);
      }
      constructor(c, d, f) {
        this.c = c;
        this.d = d;
        this.f = f;
        this.type = 5;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.c, this.d, other.c, other.d);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c === other.c && this.d === other.d;
        }
        return false;
      }
      substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.c);
        if (typeof constantValue === "boolean") {
          const falseValue = constantValue ? "true" : "false";
          return this.d === falseValue ? $Fn.INSTANCE : $Gn.INSTANCE;
        }
        return this;
      }
      evaluate(context) {
        return context.getValue(this.c) != this.d;
      }
      serialize() {
        return `${this.c} != '${this.d}'`;
      }
      keys() {
        return [this.c];
      }
      map(mapFnc) {
        return mapFnc.mapNotEquals(this.c, this.d);
      }
      negate() {
        if (!this.f) {
          this.f = $In.create(this.c, this.d, this);
        }
        return this.f;
      }
    };
    $Mn = class _$Mn {
      static create(key, negated = null) {
        const constantValue = CONSTANT_VALUES.get(key);
        if (typeof constantValue === "boolean") {
          return constantValue ? $Fn.INSTANCE : $Gn.INSTANCE;
        }
        return new _$Mn(key, negated);
      }
      constructor(c, d) {
        this.c = c;
        this.d = d;
        this.type = 3;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp1(this.c, other.c);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c === other.c;
        }
        return false;
      }
      substituteConstants() {
        const constantValue = CONSTANT_VALUES.get(this.c);
        if (typeof constantValue === "boolean") {
          return constantValue ? $Fn.INSTANCE : $Gn.INSTANCE;
        }
        return this;
      }
      evaluate(context) {
        return !context.getValue(this.c);
      }
      serialize() {
        return `!${this.c}`;
      }
      keys() {
        return [this.c];
      }
      map(mapFnc) {
        return mapFnc.mapNot(this.c);
      }
      negate() {
        if (!this.d) {
          this.d = $Hn.create(this.c, this);
        }
        return this.d;
      }
    };
    $Nn = class _$Nn {
      static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => new _$Nn(key, value, negated));
      }
      constructor(c, d, f) {
        this.c = c;
        this.d = d;
        this.f = f;
        this.type = 12;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.c, this.d, other.c, other.d);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c === other.c && this.d === other.d;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        if (typeof this.d === "string") {
          return false;
        }
        return parseFloat(context.getValue(this.c)) > this.d;
      }
      serialize() {
        return `${this.c} > ${this.d}`;
      }
      keys() {
        return [this.c];
      }
      map(mapFnc) {
        return mapFnc.mapGreater(this.c, this.d);
      }
      negate() {
        if (!this.f) {
          this.f = $Qn.create(this.c, this.d, this);
        }
        return this.f;
      }
    };
    $On = class _$On {
      static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => new _$On(key, value, negated));
      }
      constructor(c, d, f) {
        this.c = c;
        this.d = d;
        this.f = f;
        this.type = 13;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.c, this.d, other.c, other.d);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c === other.c && this.d === other.d;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        if (typeof this.d === "string") {
          return false;
        }
        return parseFloat(context.getValue(this.c)) >= this.d;
      }
      serialize() {
        return `${this.c} >= ${this.d}`;
      }
      keys() {
        return [this.c];
      }
      map(mapFnc) {
        return mapFnc.mapGreaterEquals(this.c, this.d);
      }
      negate() {
        if (!this.f) {
          this.f = $Pn.create(this.c, this.d, this);
        }
        return this.f;
      }
    };
    $Pn = class _$Pn {
      static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => new _$Pn(key, value, negated));
      }
      constructor(c, d, f) {
        this.c = c;
        this.d = d;
        this.f = f;
        this.type = 14;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.c, this.d, other.c, other.d);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c === other.c && this.d === other.d;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        if (typeof this.d === "string") {
          return false;
        }
        return parseFloat(context.getValue(this.c)) < this.d;
      }
      serialize() {
        return `${this.c} < ${this.d}`;
      }
      keys() {
        return [this.c];
      }
      map(mapFnc) {
        return mapFnc.mapSmaller(this.c, this.d);
      }
      negate() {
        if (!this.f) {
          this.f = $On.create(this.c, this.d, this);
        }
        return this.f;
      }
    };
    $Qn = class _$Qn {
      static create(key, _value, negated = null) {
        return withFloatOrStr(_value, (value) => new _$Qn(key, value, negated));
      }
      constructor(c, d, f) {
        this.c = c;
        this.d = d;
        this.f = f;
        this.type = 15;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return cmp2(this.c, this.d, other.c, other.d);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c === other.c && this.d === other.d;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        if (typeof this.d === "string") {
          return false;
        }
        return parseFloat(context.getValue(this.c)) <= this.d;
      }
      serialize() {
        return `${this.c} <= ${this.d}`;
      }
      keys() {
        return [this.c];
      }
      map(mapFnc) {
        return mapFnc.mapSmallerEquals(this.c, this.d);
      }
      negate() {
        if (!this.f) {
          this.f = $Nn.create(this.c, this.d, this);
        }
        return this.f;
      }
    };
    $Rn = class _$Rn {
      static create(key, regexp) {
        return new _$Rn(key, regexp);
      }
      constructor(d, f) {
        this.d = d;
        this.f = f;
        this.type = 7;
        this.c = null;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        if (this.d < other.d) {
          return -1;
        }
        if (this.d > other.d) {
          return 1;
        }
        const thisSource = this.f ? this.f.source : "";
        const otherSource = other.f ? other.f.source : "";
        if (thisSource < otherSource) {
          return -1;
        }
        if (thisSource > otherSource) {
          return 1;
        }
        return 0;
      }
      equals(other) {
        if (other.type === this.type) {
          const thisSource = this.f ? this.f.source : "";
          const otherSource = other.f ? other.f.source : "";
          return this.d === other.d && thisSource === otherSource;
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        const value = context.getValue(this.d);
        return this.f ? this.f.test(value) : false;
      }
      serialize() {
        const value = this.f ? `/${this.f.source}/${this.f.flags}` : "/invalid/";
        return `${this.d} =~ ${value}`;
      }
      keys() {
        return [this.d];
      }
      map(mapFnc) {
        return mapFnc.mapRegex(this.d, this.f);
      }
      negate() {
        if (!this.c) {
          this.c = $Sn.create(this);
        }
        return this.c;
      }
    };
    $Sn = class _$Sn {
      static create(actual) {
        return new _$Sn(actual);
      }
      constructor(c) {
        this.c = c;
        this.type = 8;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        return this.c.cmp(other.c);
      }
      equals(other) {
        if (other.type === this.type) {
          return this.c.equals(other.c);
        }
        return false;
      }
      substituteConstants() {
        return this;
      }
      evaluate(context) {
        return !this.c.evaluate(context);
      }
      serialize() {
        return `!(${this.c.serialize()})`;
      }
      keys() {
        return this.c.keys();
      }
      map(mapFnc) {
        return new _$Sn(this.c.map(mapFnc));
      }
      negate() {
        return this.c;
      }
    };
    $Tn = class _$Tn {
      static create(_expr, negated, extraRedundantCheck) {
        return _$Tn.d(_expr, negated, extraRedundantCheck);
      }
      constructor(expr, c) {
        this.expr = expr;
        this.c = c;
        this.type = 6;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        if (this.expr.length < other.expr.length) {
          return -1;
        }
        if (this.expr.length > other.expr.length) {
          return 1;
        }
        for (let i = 0, len = this.expr.length; i < len; i++) {
          const r = cmp(this.expr[i], other.expr[i]);
          if (r !== 0) {
            return r;
          }
        }
        return 0;
      }
      equals(other) {
        if (other.type === this.type) {
          if (this.expr.length !== other.expr.length) {
            return false;
          }
          for (let i = 0, len = this.expr.length; i < len; i++) {
            if (!this.expr[i].equals(other.expr[i])) {
              return false;
            }
          }
          return true;
        }
        return false;
      }
      substituteConstants() {
        const exprArr = eliminateConstantsInArray(this.expr);
        if (exprArr === this.expr) {
          return this;
        }
        return _$Tn.create(exprArr, this.c, false);
      }
      evaluate(context) {
        for (let i = 0, len = this.expr.length; i < len; i++) {
          if (!this.expr[i].evaluate(context)) {
            return false;
          }
        }
        return true;
      }
      static d(arr, negated, extraRedundantCheck) {
        const expr = [];
        let hasTrue = false;
        for (const e of arr) {
          if (!e) {
            continue;
          }
          if (e.type === 1) {
            hasTrue = true;
            continue;
          }
          if (e.type === 0) {
            return $Fn.INSTANCE;
          }
          if (e.type === 6) {
            expr.push(...e.expr);
            continue;
          }
          expr.push(e);
        }
        if (expr.length === 0 && hasTrue) {
          return $Gn.INSTANCE;
        }
        if (expr.length === 0) {
          return void 0;
        }
        if (expr.length === 1) {
          return expr[0];
        }
        expr.sort(cmp);
        for (let i = 1; i < expr.length; i++) {
          if (expr[i - 1].equals(expr[i])) {
            expr.splice(i, 1);
            i--;
          }
        }
        if (expr.length === 1) {
          return expr[0];
        }
        while (expr.length > 1) {
          const lastElement = expr[expr.length - 1];
          if (lastElement.type !== 9) {
            break;
          }
          expr.pop();
          const secondToLastElement = expr.pop();
          const isFinished = expr.length === 0;
          const resultElement = $Un.create(lastElement.expr.map((el) => _$Tn.create([el, secondToLastElement], null, extraRedundantCheck)), null, isFinished);
          if (resultElement) {
            expr.push(resultElement);
            expr.sort(cmp);
          }
        }
        if (expr.length === 1) {
          return expr[0];
        }
        if (extraRedundantCheck) {
          for (let i = 0; i < expr.length; i++) {
            for (let j = i + 1; j < expr.length; j++) {
              if (expr[i].negate().equals(expr[j])) {
                return $Fn.INSTANCE;
              }
            }
          }
          if (expr.length === 1) {
            return expr[0];
          }
        }
        return new _$Tn(expr, negated);
      }
      serialize() {
        return this.expr.map((e) => e.serialize()).join(" && ");
      }
      keys() {
        const result = [];
        for (const expr of this.expr) {
          result.push(...expr.keys());
        }
        return result;
      }
      map(mapFnc) {
        return new _$Tn(this.expr.map((expr) => expr.map(mapFnc)), null);
      }
      negate() {
        if (!this.c) {
          const result = [];
          for (const expr of this.expr) {
            result.push(expr.negate());
          }
          this.c = $Un.create(result, this, true);
        }
        return this.c;
      }
    };
    $Un = class _$Un {
      static create(_expr, negated, extraRedundantCheck) {
        return _$Un.d(_expr, negated, extraRedundantCheck);
      }
      constructor(expr, c) {
        this.expr = expr;
        this.c = c;
        this.type = 9;
      }
      cmp(other) {
        if (other.type !== this.type) {
          return this.type - other.type;
        }
        if (this.expr.length < other.expr.length) {
          return -1;
        }
        if (this.expr.length > other.expr.length) {
          return 1;
        }
        for (let i = 0, len = this.expr.length; i < len; i++) {
          const r = cmp(this.expr[i], other.expr[i]);
          if (r !== 0) {
            return r;
          }
        }
        return 0;
      }
      equals(other) {
        if (other.type === this.type) {
          if (this.expr.length !== other.expr.length) {
            return false;
          }
          for (let i = 0, len = this.expr.length; i < len; i++) {
            if (!this.expr[i].equals(other.expr[i])) {
              return false;
            }
          }
          return true;
        }
        return false;
      }
      substituteConstants() {
        const exprArr = eliminateConstantsInArray(this.expr);
        if (exprArr === this.expr) {
          return this;
        }
        return _$Un.create(exprArr, this.c, false);
      }
      evaluate(context) {
        for (let i = 0, len = this.expr.length; i < len; i++) {
          if (this.expr[i].evaluate(context)) {
            return true;
          }
        }
        return false;
      }
      static d(arr, negated, extraRedundantCheck) {
        let expr = [];
        let hasFalse = false;
        if (arr) {
          for (let i = 0, len = arr.length; i < len; i++) {
            const e = arr[i];
            if (!e) {
              continue;
            }
            if (e.type === 0) {
              hasFalse = true;
              continue;
            }
            if (e.type === 1) {
              return $Gn.INSTANCE;
            }
            if (e.type === 9) {
              expr = expr.concat(e.expr);
              continue;
            }
            expr.push(e);
          }
          if (expr.length === 0 && hasFalse) {
            return $Fn.INSTANCE;
          }
          expr.sort(cmp);
        }
        if (expr.length === 0) {
          return void 0;
        }
        if (expr.length === 1) {
          return expr[0];
        }
        for (let i = 1; i < expr.length; i++) {
          if (expr[i - 1].equals(expr[i])) {
            expr.splice(i, 1);
            i--;
          }
        }
        if (expr.length === 1) {
          return expr[0];
        }
        if (extraRedundantCheck) {
          for (let i = 0; i < expr.length; i++) {
            for (let j = i + 1; j < expr.length; j++) {
              if (expr[i].negate().equals(expr[j])) {
                return $Gn.INSTANCE;
              }
            }
          }
          if (expr.length === 1) {
            return expr[0];
          }
        }
        return new _$Un(expr, negated);
      }
      serialize() {
        return this.expr.map((e) => e.serialize()).join(" || ");
      }
      keys() {
        const result = [];
        for (const expr of this.expr) {
          result.push(...expr.keys());
        }
        return result;
      }
      map(mapFnc) {
        return new _$Un(this.expr.map((expr) => expr.map(mapFnc)), null);
      }
      negate() {
        if (!this.c) {
          const result = [];
          for (const expr of this.expr) {
            result.push(expr.negate());
          }
          while (result.length > 1) {
            const LEFT = result.shift();
            const RIGHT = result.shift();
            const all = [];
            for (const left of getTerminals(LEFT)) {
              for (const right of getTerminals(RIGHT)) {
                all.push($Tn.create([left, right], null, false));
              }
            }
            result.unshift(_$Un.create(all, null, false));
          }
          this.c = _$Un.create(result, this, true);
        }
        return this.c;
      }
    };
    $Vn = class _$Vn extends $Hn {
      static {
        this.d = [];
      }
      static all() {
        return _$Vn.d.values();
      }
      constructor(key, defaultValue, metaOrHide) {
        super(key, null);
        this.f = defaultValue;
        if (typeof metaOrHide === "object") {
          _$Vn.d.push({ ...metaOrHide, key });
        } else if (metaOrHide !== true) {
          _$Vn.d.push({ key, description: metaOrHide, type: defaultValue !== null && defaultValue !== void 0 ? typeof defaultValue : void 0 });
        }
      }
      bindTo(target) {
        return target.createKey(this.key, this.f);
      }
      getValue(target) {
        return target.getContextKeyValue(this.key);
      }
      toNegated() {
        return this.negate();
      }
      isEqualTo(value) {
        return $In.create(this.key, value);
      }
      notEqualsTo(value) {
        return $Ln.create(this.key, value);
      }
      greater(value) {
        return $Nn.create(this.key, value);
      }
    };
    $Wn = $kl("contextKeyService");
  }
});

// out-build/vs/platform/log/common/log.js
function $7n(thing) {
  return $1c(thing);
}
function $9n(loggerLevel, messageLevel) {
  return loggerLevel !== LogLevel.Off && loggerLevel <= messageLevel;
}
function log(logger, level, message) {
  switch (level) {
    case LogLevel.Trace:
      logger.trace(message);
      break;
    case LogLevel.Debug:
      logger.debug(message);
      break;
    case LogLevel.Info:
      logger.info(message);
      break;
    case LogLevel.Warning:
      logger.warn(message);
      break;
    case LogLevel.Error:
      logger.error(message);
      break;
    case LogLevel.Off:
      break;
    default:
      throw new Error(`Invalid log level ${level}`);
  }
}
function format(args, verbose = false) {
  let result = "";
  for (let i = 0; i < args.length; i++) {
    let a = args[i];
    if (a instanceof Error) {
      a = $wn(a, verbose);
    }
    if (typeof a === "object") {
      try {
        a = JSON.stringify(a);
      } catch (e) {
      }
    }
    result += (i > 0 ? " " : "") + a;
  }
  return result;
}
function $ho(environmentService) {
  if (environmentService.verbose) {
    return LogLevel.Trace;
  }
  if (typeof environmentService.logLevel === "string") {
    const logLevel = $ko(environmentService.logLevel.toLowerCase());
    if (logLevel !== void 0) {
      return logLevel;
    }
  }
  return $8n;
}
function $io(logLevel) {
  switch (logLevel) {
    case LogLevel.Trace:
      return "trace";
    case LogLevel.Debug:
      return "debug";
    case LogLevel.Info:
      return "info";
    case LogLevel.Warning:
      return "warn";
    case LogLevel.Error:
      return "error";
    case LogLevel.Off:
      return "off";
  }
}
function $ko(logLevel) {
  switch (logLevel) {
    case "trace":
      return LogLevel.Trace;
    case "debug":
      return LogLevel.Debug;
    case "info":
      return LogLevel.Info;
    case "warn":
      return LogLevel.Warning;
    case "error":
      return LogLevel.Error;
    case "critical":
      return LogLevel.Error;
    case "off":
      return LogLevel.Off;
  }
  return void 0;
}
var $5n, $6n, LogLevel, $8n, $$n, $_n, $bo, $do, $eo, $fo, $go, $lo;
var init_log = __esm({
  "out-build/vs/platform/log/common/log.js"() {
    "use strict";
    init_nls2();
    init_errorMessage();
    init_event();
    init_hash();
    init_lifecycle();
    init_map();
    init_platform();
    init_resources();
    init_types();
    init_uri();
    init_contextkey();
    init_instantiation();
    $5n = $kl("logService");
    $6n = $kl("loggerService");
    (function(LogLevel2) {
      LogLevel2[LogLevel2["Off"] = 0] = "Off";
      LogLevel2[LogLevel2["Trace"] = 1] = "Trace";
      LogLevel2[LogLevel2["Debug"] = 2] = "Debug";
      LogLevel2[LogLevel2["Info"] = 3] = "Info";
      LogLevel2[LogLevel2["Warning"] = 4] = "Warning";
      LogLevel2[LogLevel2["Error"] = 5] = "Error";
    })(LogLevel || (LogLevel = {}));
    $8n = LogLevel.Info;
    $$n = class extends $sd {
      constructor() {
        super(...arguments);
        this.b = $8n;
        this.c = this.B(new $0e());
        this.onDidChangeLogLevel = this.c.event;
      }
      setLevel(level) {
        if (this.b !== level) {
          this.b = level;
          this.c.fire(this.b);
        }
      }
      getLevel() {
        return this.b;
      }
      f(level) {
        return $9n(this.b, level);
      }
      g(level) {
        if (this.q.isDisposed) {
          return false;
        }
        return this.f(level);
      }
    };
    $_n = class extends $$n {
      constructor(h) {
        super();
        this.h = h;
      }
      f(level) {
        return this.h || super.f(level);
      }
      trace(message, ...args) {
        if (this.g(LogLevel.Trace)) {
          this.m(LogLevel.Trace, format([message, ...args], true));
        }
      }
      debug(message, ...args) {
        if (this.g(LogLevel.Debug)) {
          this.m(LogLevel.Debug, format([message, ...args]));
        }
      }
      info(message, ...args) {
        if (this.g(LogLevel.Info)) {
          this.m(LogLevel.Info, format([message, ...args]));
        }
      }
      warn(message, ...args) {
        if (this.g(LogLevel.Warning)) {
          this.m(LogLevel.Warning, format([message, ...args]));
        }
      }
      error(message, ...args) {
        if (this.g(LogLevel.Error)) {
          if (message instanceof Error) {
            const array = Array.prototype.slice.call(arguments);
            array[0] = message.stack;
            this.m(LogLevel.Error, format(array));
          } else {
            this.m(LogLevel.Error, format([message, ...args]));
          }
        }
      }
      flush() {
      }
    };
    $bo = class extends $$n {
      constructor(logLevel = $8n, h = true) {
        super();
        this.h = h;
        this.setLevel(logLevel);
      }
      trace(message, ...args) {
        if (this.g(LogLevel.Trace)) {
          if (this.h) {
            console.log("%cTRACE", "color: #888", message, ...args);
          } else {
            console.log(message, ...args);
          }
        }
      }
      debug(message, ...args) {
        if (this.g(LogLevel.Debug)) {
          if (this.h) {
            console.log("%cDEBUG", "background: #eee; color: #888", message, ...args);
          } else {
            console.log(message, ...args);
          }
        }
      }
      info(message, ...args) {
        if (this.g(LogLevel.Info)) {
          if (this.h) {
            console.log("%c INFO", "color: #33f", message, ...args);
          } else {
            console.log(message, ...args);
          }
        }
      }
      warn(message, ...args) {
        if (this.g(LogLevel.Warning)) {
          if (this.h) {
            console.warn("%c WARN", "color: #993", message, ...args);
          } else {
            console.log(message, ...args);
          }
        }
      }
      error(message, ...args) {
        if (this.g(LogLevel.Error)) {
          if (this.h) {
            console.error("%c  ERR", "color: #f33", message, ...args);
          } else {
            console.error(message, ...args);
          }
        }
      }
      flush() {
      }
    };
    $do = class extends $$n {
      constructor(h) {
        super();
        this.h = h;
        if (h.length) {
          this.setLevel(h[0].getLevel());
        }
      }
      setLevel(level) {
        for (const logger of this.h) {
          logger.setLevel(level);
        }
        super.setLevel(level);
      }
      trace(message, ...args) {
        for (const logger of this.h) {
          logger.trace(message, ...args);
        }
      }
      debug(message, ...args) {
        for (const logger of this.h) {
          logger.debug(message, ...args);
        }
      }
      info(message, ...args) {
        for (const logger of this.h) {
          logger.info(message, ...args);
        }
      }
      warn(message, ...args) {
        for (const logger of this.h) {
          logger.warn(message, ...args);
        }
      }
      error(message, ...args) {
        for (const logger of this.h) {
          logger.error(message, ...args);
        }
      }
      flush() {
        for (const logger of this.h) {
          logger.flush();
        }
      }
      dispose() {
        for (const logger of this.h) {
          logger.dispose();
        }
        super.dispose();
      }
    };
    $eo = class extends $sd {
      constructor(j, m, loggerResources) {
        super();
        this.j = j;
        this.m = m;
        this.b = new $Fc();
        this.f = this.B(new $0e());
        this.onDidChangeLoggers = this.f.event;
        this.g = this.B(new $0e());
        this.onDidChangeLogLevel = this.g.event;
        this.h = this.B(new $0e());
        this.onDidChangeVisibility = this.h.event;
        if (loggerResources) {
          for (const loggerResource of loggerResources) {
            this.b.set(loggerResource.resource, { logger: void 0, info: loggerResource });
          }
        }
      }
      n(resourceOrId) {
        if ($Wc(resourceOrId)) {
          return [...this.b.values()].find((logger) => logger.info.id === resourceOrId);
        }
        return this.b.get(resourceOrId);
      }
      getLogger(resourceOrId) {
        return this.n(resourceOrId)?.logger;
      }
      createLogger(idOrResource, options2) {
        const resource = this.s(idOrResource);
        const id2 = $Wc(idOrResource) ? idOrResource : options2?.id ?? $fj(resource.toString()).toString(16);
        let logger = this.b.get(resource)?.logger;
        const logLevel = options2?.logLevel === "always" ? LogLevel.Trace : options2?.logLevel;
        if (!logger) {
          logger = this.t(resource, logLevel ?? this.getLogLevel(resource) ?? this.j, { ...options2, id: id2 });
        }
        const loggerEntry = {
          logger,
          info: {
            resource,
            id: id2,
            logLevel,
            name: options2?.name,
            hidden: options2?.hidden,
            group: options2?.group,
            extensionId: options2?.extensionId,
            when: options2?.when
          }
        };
        this.registerLogger(loggerEntry.info);
        this.b.set(resource, loggerEntry);
        return logger;
      }
      s(idOrResource) {
        return $Wc(idOrResource) ? $Ph(this.m, `${idOrResource}.log`) : idOrResource;
      }
      setLogLevel(arg1, arg2) {
        if (URI.isUri(arg1)) {
          const resource = arg1;
          const logLevel = arg2;
          const logger = this.b.get(resource);
          if (logger && logLevel !== logger.info.logLevel) {
            logger.info.logLevel = logLevel === this.j ? void 0 : logLevel;
            logger.logger?.setLevel(logLevel);
            this.b.set(logger.info.resource, logger);
            this.g.fire([resource, logLevel]);
          }
        } else {
          this.j = arg1;
          for (const [resource, logger] of this.b.entries()) {
            if (this.b.get(resource)?.info.logLevel === void 0) {
              logger.logger?.setLevel(this.j);
            }
          }
          this.g.fire(this.j);
        }
      }
      setVisibility(resourceOrId, visibility) {
        const logger = this.n(resourceOrId);
        if (logger && visibility !== !logger.info.hidden) {
          logger.info.hidden = !visibility;
          this.b.set(logger.info.resource, logger);
          this.h.fire([logger.info.resource, visibility]);
        }
      }
      getLogLevel(resource) {
        let logLevel;
        if (resource) {
          logLevel = this.b.get(resource)?.info.logLevel;
        }
        return logLevel ?? this.j;
      }
      registerLogger(resource) {
        const existing = this.b.get(resource.resource);
        if (existing) {
          if (existing.info.hidden !== resource.hidden) {
            this.setVisibility(resource.resource, !resource.hidden);
          }
        } else {
          this.b.set(resource.resource, { info: resource, logger: void 0 });
          this.f.fire({ added: [resource], removed: [] });
        }
      }
      deregisterLogger(idOrResource) {
        const resource = this.s(idOrResource);
        const existing = this.b.get(resource);
        if (existing) {
          if (existing.logger) {
            existing.logger.dispose();
          }
          this.b.delete(resource);
          this.f.fire({ added: [], removed: [existing.info] });
        }
      }
      *getRegisteredLoggers() {
        for (const entry of this.b.values()) {
          yield entry.info;
        }
      }
      getRegisteredLogger(resource) {
        return this.b.get(resource)?.info;
      }
      dispose() {
        this.b.forEach((logger) => logger.logger?.dispose());
        this.b.clear();
        super.dispose();
      }
    };
    $fo = class {
      constructor() {
        this.onDidChangeLogLevel = new $0e().event;
      }
      setLevel(level) {
      }
      getLevel() {
        return LogLevel.Info;
      }
      trace(message, ...args) {
      }
      debug(message, ...args) {
      }
      info(message, ...args) {
      }
      warn(message, ...args) {
      }
      error(message, ...args) {
      }
      critical(message, ...args) {
      }
      dispose() {
      }
      flush() {
      }
    };
    $go = class extends $fo {
    };
    $lo = new $Vn("logLevel", $io(LogLevel.Info));
  }
});

// out-build/vs/platform/instantiation/common/descriptors.js
var $hl;
var init_descriptors = __esm({
  "out-build/vs/platform/instantiation/common/descriptors.js"() {
    "use strict";
    $hl = class {
      constructor(ctor, staticArguments = [], supportsDelayedInstantiation = false) {
        this.ctor = ctor;
        this.staticArguments = staticArguments;
        this.supportsDelayedInstantiation = supportsDelayedInstantiation;
      }
    };
  }
});

// out-build/vs/base/common/symbols.js
var $5e;
var init_symbols = __esm({
  "out-build/vs/base/common/symbols.js"() {
    "use strict";
    $5e = Symbol("MicrotaskDelay");
  }
});

// out-build/vs/base/common/async.js
function $1h(obj) {
  return !!obj && typeof obj.then === "function";
}
function $2h(callback) {
  const source = new $Dd();
  const thenable = callback(source.token);
  const promise = new Promise((resolve4, reject) => {
    const subscription = source.token.onCancellationRequested(() => {
      subscription.dispose();
      reject(new $lb());
    });
    Promise.resolve(thenable).then((value) => {
      subscription.dispose();
      source.dispose();
      resolve4(value);
    }, (err) => {
      subscription.dispose();
      source.dispose();
      reject(err);
    });
  });
  return new class {
    cancel() {
      source.cancel();
      source.dispose();
    }
    then(resolve4, reject) {
      return promise.then(resolve4, reject);
    }
    catch(reject) {
      return this.then(void 0, reject);
    }
    finally(onfinally) {
      return promise.finally(onfinally);
    }
  }();
}
function $9h() {
  let resolve4;
  let reject;
  const promise = new Promise((res, rej) => {
    resolve4 = res;
    reject = rej;
  });
  return { promise, resolve: resolve4, reject };
}
function $ei(millis, token) {
  if (!token) {
    return $2h((token2) => $ei(millis, token2));
  }
  return new Promise((resolve4, reject) => {
    const handle = setTimeout(() => {
      disposable.dispose();
      resolve4();
    }, millis);
    const disposable = token.onCancellationRequested(() => {
      clearTimeout(handle);
      disposable.dispose();
      reject(new $lb());
    });
  });
}
async function $xi(task, delay, retries) {
  let lastError;
  for (let i = 0; i < retries; i++) {
    try {
      return await task();
    } catch (error) {
      lastError = error;
      await $ei(delay);
    }
  }
  throw lastError;
}
var $0h, $$h, timeoutDeferred, microtaskDeferred, $ai, $bi, $ci, $ji, $ki, $mi, $pi, $qi, $ri, $si, $ti, $ui, $vi, $wi, DeferredOutcome, $Ai, Promises, AsyncIterableSourceState, $Di;
var init_async = __esm({
  "out-build/vs/base/common/async.js"() {
    "use strict";
    init_cancellation();
    init_errors();
    init_event();
    init_lifecycle();
    init_resources();
    init_platform();
    init_symbols();
    init_lazy();
    $0h = class {
      constructor() {
        this.f = false;
        this.a = null;
        this.b = null;
        this.d = null;
      }
      queue(promiseFactory) {
        if (this.f) {
          return Promise.reject(new Error("Throttler is disposed"));
        }
        if (this.a) {
          this.d = promiseFactory;
          if (!this.b) {
            const onComplete = () => {
              this.b = null;
              if (this.f) {
                return;
              }
              const result = this.queue(this.d);
              this.d = null;
              return result;
            };
            this.b = new Promise((resolve4) => {
              this.a.then(onComplete, onComplete).then(resolve4);
            });
          }
          return new Promise((resolve4, reject) => {
            this.b.then(resolve4, reject);
          });
        }
        this.a = promiseFactory();
        return new Promise((resolve4, reject) => {
          this.a.then((result) => {
            this.a = null;
            resolve4(result);
          }, (err) => {
            this.a = null;
            reject(err);
          });
        });
      }
      dispose() {
        this.f = true;
      }
    };
    $$h = class {
      constructor() {
        this.d = Promise.resolve(null);
      }
      queue(promiseTask) {
        return this.d = this.d.then(() => promiseTask(), () => promiseTask());
      }
    };
    timeoutDeferred = (timeout, fn) => {
      let scheduled = true;
      const handle = setTimeout(() => {
        scheduled = false;
        fn();
      }, timeout);
      return {
        isTriggered: () => scheduled,
        dispose: () => {
          clearTimeout(handle);
          scheduled = false;
        }
      };
    };
    microtaskDeferred = (fn) => {
      let scheduled = true;
      queueMicrotask(() => {
        if (scheduled) {
          scheduled = false;
          fn();
        }
      });
      return {
        isTriggered: () => scheduled,
        dispose: () => {
          scheduled = false;
        }
      };
    };
    $ai = class {
      constructor(defaultDelay) {
        this.defaultDelay = defaultDelay;
        this.a = null;
        this.b = null;
        this.d = null;
        this.f = null;
        this.g = null;
      }
      trigger(task, delay = this.defaultDelay) {
        this.g = task;
        this.h();
        if (!this.b) {
          this.b = new Promise((resolve4, reject) => {
            this.d = resolve4;
            this.f = reject;
          }).then(() => {
            this.b = null;
            this.d = null;
            if (this.g) {
              const task2 = this.g;
              this.g = null;
              return task2();
            }
            return void 0;
          });
        }
        const fn = () => {
          this.a = null;
          this.d?.(null);
        };
        this.a = delay === $5e ? microtaskDeferred(fn) : timeoutDeferred(delay, fn);
        return this.b;
      }
      isTriggered() {
        return !!this.a?.isTriggered();
      }
      cancel() {
        this.h();
        if (this.b) {
          this.f?.(new $lb());
          this.b = null;
        }
      }
      h() {
        this.a?.dispose();
        this.a = null;
      }
      dispose() {
        this.cancel();
      }
    };
    $bi = class {
      constructor(defaultDelay) {
        this.a = new $ai(defaultDelay);
        this.b = new $0h();
      }
      trigger(promiseFactory, delay) {
        return this.a.trigger(() => this.b.queue(promiseFactory), delay);
      }
      isTriggered() {
        return this.a.isTriggered();
      }
      cancel() {
        this.a.cancel();
      }
      dispose() {
        this.a.dispose();
        this.b.dispose();
      }
    };
    $ci = class {
      constructor() {
        this.a = false;
        this.b = new Promise((c, e) => {
          this.d = c;
        });
      }
      isOpen() {
        return this.a;
      }
      open() {
        this.a = true;
        this.d(true);
      }
      wait() {
        return this.b;
      }
    };
    $ji = class {
      constructor(maxDegreeOfParalellism) {
        this.a = 0;
        this.b = false;
        this.f = maxDegreeOfParalellism;
        this.g = [];
        this.d = 0;
        this.h = new $0e();
      }
      /**
       *
       * @returns A promise that resolved when all work is done (onDrained) or when
       * there is nothing to do
       */
      whenIdle() {
        return this.size > 0 ? Event.toPromise(this.onDrained) : Promise.resolve();
      }
      get onDrained() {
        return this.h.event;
      }
      get size() {
        return this.a;
      }
      queue(factory) {
        if (this.b) {
          throw new Error("Object has been disposed");
        }
        this.a++;
        return new Promise((c, e) => {
          this.g.push({ factory, c, e });
          this.j();
        });
      }
      j() {
        while (this.g.length && this.d < this.f) {
          const iLimitedTask = this.g.shift();
          this.d++;
          const promise = iLimitedTask.factory();
          promise.then(iLimitedTask.c, iLimitedTask.e);
          promise.then(() => this.k(), () => this.k());
        }
      }
      k() {
        if (this.b) {
          return;
        }
        this.d--;
        if (--this.a === 0) {
          this.h.fire();
        }
        if (this.g.length > 0) {
          this.j();
        }
      }
      clear() {
        if (this.b) {
          throw new Error("Object has been disposed");
        }
        this.g.length = 0;
        this.a = this.d;
      }
      dispose() {
        this.b = true;
        this.g.length = 0;
        this.a = 0;
        this.h.dispose();
      }
    };
    $ki = class extends $ji {
      constructor() {
        super(1);
      }
    };
    $mi = class {
      constructor() {
        this.a = /* @__PURE__ */ new Map();
        this.b = /* @__PURE__ */ new Set();
        this.d = void 0;
        this.f = 0;
      }
      async whenDrained() {
        if (this.g()) {
          return;
        }
        const promise = new $Ai();
        this.b.add(promise);
        return promise.p;
      }
      g() {
        for (const [, queue] of this.a) {
          if (queue.size > 0) {
            return false;
          }
        }
        return true;
      }
      queueSize(resource, extUri = $Fh) {
        const key = extUri.getComparisonKey(resource);
        return this.a.get(key)?.size ?? 0;
      }
      queueFor(resource, factory, extUri = $Fh) {
        const key = extUri.getComparisonKey(resource);
        let queue = this.a.get(key);
        if (!queue) {
          queue = new $ki();
          const drainListenerId = this.f++;
          const drainListener = Event.once(queue.onDrained)(() => {
            queue?.dispose();
            this.a.delete(key);
            this.h();
            this.d?.deleteAndDispose(drainListenerId);
            if (this.d?.size === 0) {
              this.d.dispose();
              this.d = void 0;
            }
          });
          if (!this.d) {
            this.d = new $Bd();
          }
          this.d.set(drainListenerId, drainListener);
          this.a.set(key, queue);
        }
        return queue.queue(factory);
      }
      h() {
        if (!this.g()) {
          return;
        }
        this.j();
      }
      j() {
        for (const drainer of this.b) {
          drainer.complete();
        }
        this.b.clear();
      }
      dispose() {
        for (const [, queue] of this.a) {
          queue.dispose();
        }
        this.a.clear();
        this.j();
        this.d?.dispose();
      }
    };
    $pi = class {
      constructor(runner, delay) {
        this.b = -1;
        this.a = runner;
        this.d = delay;
        this.f = this.g.bind(this);
      }
      /**
       * Dispose RunOnceScheduler
       */
      dispose() {
        this.cancel();
        this.a = null;
      }
      /**
       * Cancel current scheduled runner (if any).
       */
      cancel() {
        if (this.isScheduled()) {
          clearTimeout(this.b);
          this.b = -1;
        }
      }
      /**
       * Cancel previous runner (if any) & schedule a new runner.
       */
      schedule(delay = this.d) {
        this.cancel();
        this.b = setTimeout(this.f, delay);
      }
      get delay() {
        return this.d;
      }
      set delay(value) {
        this.d = value;
      }
      /**
       * Returns true if scheduled.
       */
      isScheduled() {
        return this.b !== -1;
      }
      flush() {
        if (this.isScheduled()) {
          this.cancel();
          this.h();
        }
      }
      g() {
        this.b = -1;
        if (this.a) {
          this.h();
        }
      }
      h() {
        this.a?.();
      }
    };
    $qi = class {
      constructor(runner, delay) {
        if (delay % 1e3 !== 0) {
          console.warn(`ProcessTimeRunOnceScheduler resolution is 1s, ${delay}ms is not a multiple of 1000ms.`);
        }
        this.a = runner;
        this.b = delay;
        this.d = 0;
        this.f = -1;
        this.g = this.h.bind(this);
      }
      dispose() {
        this.cancel();
        this.a = null;
      }
      cancel() {
        if (this.isScheduled()) {
          clearInterval(this.f);
          this.f = -1;
        }
      }
      /**
       * Cancel previous runner (if any) & schedule a new runner.
       */
      schedule(delay = this.b) {
        if (delay % 1e3 !== 0) {
          console.warn(`ProcessTimeRunOnceScheduler resolution is 1s, ${delay}ms is not a multiple of 1000ms.`);
        }
        this.cancel();
        this.d = Math.ceil(delay / 1e3);
        this.f = setInterval(this.g, 1e3);
      }
      /**
       * Returns true if scheduled.
       */
      isScheduled() {
        return this.f !== -1;
      }
      h() {
        this.d--;
        if (this.d > 0) {
          return;
        }
        clearInterval(this.f);
        this.f = -1;
        this.a?.();
      }
    };
    $ri = class extends $pi {
      constructor(runner, timeout) {
        super(runner, timeout);
        this.j = [];
      }
      work(unit) {
        this.j.push(unit);
        if (!this.isScheduled()) {
          this.schedule();
        }
      }
      h() {
        const units = this.j;
        this.j = [];
        this.a?.(units);
      }
      dispose() {
        this.j = [];
        super.dispose();
      }
    };
    $si = class extends $sd {
      constructor(h, j) {
        super();
        this.h = h;
        this.j = j;
        this.a = [];
        this.b = this.B(new $td());
        this.f = false;
        this.g = 0;
      }
      /**
       * The number of work units that are pending to be processed.
       */
      get pending() {
        return this.a.length;
      }
      /**
       * Add units to be worked on. Use `pending` to figure out
       * how many units are not yet processed after this method
       * was called.
       *
       * @returns whether the work was accepted or not. If the
       * worker is disposed, it will not accept any more work.
       * If the number of pending units would become larger
       * than `maxPendingWork`, more work will also not be accepted.
       */
      work(units) {
        if (this.f) {
          return false;
        }
        if (typeof this.h.maxBufferedWork === "number") {
          if (this.b.value) {
            if (this.pending + units.length > this.h.maxBufferedWork) {
              return false;
            }
          } else {
            if (this.pending + units.length - this.h.maxWorkChunkSize > this.h.maxBufferedWork) {
              return false;
            }
          }
        }
        for (const unit of units) {
          this.a.push(unit);
        }
        const timeSinceLastExecution = Date.now() - this.g;
        if (!this.b.value && (!this.h.waitThrottleDelayBetweenWorkUnits || timeSinceLastExecution >= this.h.throttleDelay)) {
          this.m();
        } else if (!this.b.value && this.h.waitThrottleDelayBetweenWorkUnits) {
          this.r(Math.max(this.h.throttleDelay - timeSinceLastExecution, 0));
        } else {
        }
        return true;
      }
      m() {
        this.g = Date.now();
        this.j(this.a.splice(0, this.h.maxWorkChunkSize));
        if (this.a.length > 0) {
          this.r();
        }
      }
      r(delay = this.h.throttleDelay) {
        this.b.value = new $pi(() => {
          this.b.clear();
          this.m();
        }, delay);
        this.b.value.schedule();
      }
      dispose() {
        super.dispose();
        this.f = true;
      }
    };
    (function() {
      if (typeof globalThis.requestIdleCallback !== "function" || typeof globalThis.cancelIdleCallback !== "function") {
        $ui = (_targetWindow, runner, timeout) => {
          $E(() => {
            if (disposed) {
              return;
            }
            const end = Date.now() + 15;
            const deadline = {
              didTimeout: true,
              timeRemaining() {
                return Math.max(0, end - Date.now());
              }
            };
            runner(Object.freeze(deadline));
          });
          let disposed = false;
          return {
            dispose() {
              if (disposed) {
                return;
              }
              disposed = true;
            }
          };
        };
      } else {
        $ui = (targetWindow, runner, timeout) => {
          const handle = targetWindow.requestIdleCallback(runner, typeof timeout === "number" ? { timeout } : void 0);
          let disposed = false;
          return {
            dispose() {
              if (disposed) {
                return;
              }
              disposed = true;
              targetWindow.cancelIdleCallback(handle);
            }
          };
        };
      }
      $ti = (runner, timeout) => $ui(globalThis, runner, timeout);
    })();
    $vi = class {
      constructor(targetWindow, executor) {
        this.g = false;
        this.d = () => {
          try {
            this.j = executor();
          } catch (err) {
            this.l = err;
          } finally {
            this.g = true;
          }
        };
        this.f = $ui(targetWindow, () => this.d());
      }
      dispose() {
        this.f.dispose();
      }
      get value() {
        if (!this.g) {
          this.f.dispose();
          this.d();
        }
        if (this.l) {
          throw this.l;
        }
        return this.j;
      }
      get isInitialized() {
        return this.g;
      }
    };
    $wi = class extends $vi {
      constructor(executor) {
        super(globalThis, executor);
      }
    };
    (function(DeferredOutcome2) {
      DeferredOutcome2[DeferredOutcome2["Resolved"] = 0] = "Resolved";
      DeferredOutcome2[DeferredOutcome2["Rejected"] = 1] = "Rejected";
    })(DeferredOutcome || (DeferredOutcome = {}));
    $Ai = class {
      get isRejected() {
        return this.d?.outcome === 1;
      }
      get isResolved() {
        return this.d?.outcome === 0;
      }
      get isSettled() {
        return !!this.d;
      }
      get value() {
        return this.d?.outcome === 0 ? this.d?.value : void 0;
      }
      constructor() {
        this.p = new Promise((c, e) => {
          this.a = c;
          this.b = e;
        });
      }
      complete(value) {
        return new Promise((resolve4) => {
          this.a(value);
          this.d = { outcome: 0, value };
          resolve4();
        });
      }
      error(err) {
        return new Promise((resolve4) => {
          this.b(err);
          this.d = { outcome: 1, value: err };
          resolve4();
        });
      }
      cancel() {
        return this.error(new $lb());
      }
    };
    (function(Promises3) {
      async function settled(promises15) {
        let firstError = void 0;
        const result = await Promise.all(promises15.map((promise) => promise.then((value) => value, (error) => {
          if (!firstError) {
            firstError = error;
          }
          return void 0;
        })));
        if (typeof firstError !== "undefined") {
          throw firstError;
        }
        return result;
      }
      Promises3.settled = settled;
      function withAsyncBody(bodyFn) {
        return new Promise(async (resolve4, reject) => {
          try {
            await bodyFn(resolve4, reject);
          } catch (error) {
            reject(error);
          }
        });
      }
      Promises3.withAsyncBody = withAsyncBody;
    })(Promises || (Promises = {}));
    (function(AsyncIterableSourceState2) {
      AsyncIterableSourceState2[AsyncIterableSourceState2["Initial"] = 0] = "Initial";
      AsyncIterableSourceState2[AsyncIterableSourceState2["DoneOK"] = 1] = "DoneOK";
      AsyncIterableSourceState2[AsyncIterableSourceState2["DoneError"] = 2] = "DoneError";
    })(AsyncIterableSourceState || (AsyncIterableSourceState = {}));
    $Di = class _$Di {
      static fromArray(items) {
        return new _$Di((writer) => {
          writer.emitMany(items);
        });
      }
      static fromPromise(promise) {
        return new _$Di(async (emitter) => {
          emitter.emitMany(await promise);
        });
      }
      static fromPromisesResolveOrder(promises15) {
        return new _$Di(async (emitter) => {
          await Promise.all(promises15.map(async (p) => emitter.emitOne(await p)));
        });
      }
      static merge(iterables) {
        return new _$Di(async (emitter) => {
          await Promise.all(iterables.map(async (iterable) => {
            for await (const item of iterable) {
              emitter.emitOne(item);
            }
          }));
        });
      }
      static {
        this.EMPTY = _$Di.fromArray([]);
      }
      constructor(executor, onReturn) {
        this.a = 0;
        this.b = [];
        this.d = null;
        this.f = onReturn;
        this.g = new $0e();
        queueMicrotask(async () => {
          const writer = {
            emitOne: (item) => this.h(item),
            emitMany: (items) => this.j(items),
            reject: (error) => this.l(error)
          };
          try {
            await Promise.resolve(executor(writer));
            this.k();
          } catch (err) {
            this.l(err);
          } finally {
            writer.emitOne = void 0;
            writer.emitMany = void 0;
            writer.reject = void 0;
          }
        });
      }
      [Symbol.asyncIterator]() {
        let i = 0;
        return {
          next: async () => {
            do {
              if (this.a === 2) {
                throw this.d;
              }
              if (i < this.b.length) {
                return { done: false, value: this.b[i++] };
              }
              if (this.a === 1) {
                return { done: true, value: void 0 };
              }
              await Event.toPromise(this.g.event);
            } while (true);
          },
          return: async () => {
            this.f?.();
            return { done: true, value: void 0 };
          }
        };
      }
      static map(iterable, mapFn) {
        return new _$Di(async (emitter) => {
          for await (const item of iterable) {
            emitter.emitOne(mapFn(item));
          }
        });
      }
      map(mapFn) {
        return _$Di.map(this, mapFn);
      }
      static filter(iterable, filterFn) {
        return new _$Di(async (emitter) => {
          for await (const item of iterable) {
            if (filterFn(item)) {
              emitter.emitOne(item);
            }
          }
        });
      }
      filter(filterFn) {
        return _$Di.filter(this, filterFn);
      }
      static coalesce(iterable) {
        return _$Di.filter(iterable, (item) => !!item);
      }
      coalesce() {
        return _$Di.coalesce(this);
      }
      static async toPromise(iterable) {
        const result = [];
        for await (const item of iterable) {
          result.push(item);
        }
        return result;
      }
      toPromise() {
        return _$Di.toPromise(this);
      }
      /**
       * The value will be appended at the end.
       *
       * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
       */
      h(value) {
        if (this.a !== 0) {
          return;
        }
        this.b.push(value);
        this.g.fire();
      }
      /**
       * The values will be appended at the end.
       *
       * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
       */
      j(values) {
        if (this.a !== 0) {
          return;
        }
        this.b = this.b.concat(values);
        this.g.fire();
      }
      /**
       * Calling `resolve()` will mark the result array as complete.
       *
       * **NOTE** `resolve()` must be called, otherwise all consumers of this iterable will hang indefinitely, similar to a non-resolved promise.
       * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
       */
      k() {
        if (this.a !== 0) {
          return;
        }
        this.a = 1;
        this.g.fire();
      }
      /**
       * Writing an error will permanently invalidate this iterable.
       * The current users will receive an error thrown, as will all future users.
       *
       * **NOTE** If `resolve()` or `reject()` have already been called, this method has no effect.
       */
      l(error) {
        if (this.a !== 0) {
          return;
        }
        this.a = 2;
        this.d = error;
        this.g.fire();
      }
    };
  }
});

// out-build/vs/base/common/json.js
function $dx(text, ignoreTrivia = false) {
  let pos = 0;
  const len = text.length;
  let value = "";
  let tokenOffset = 0;
  let token = 16;
  let scanError = 0;
  function scanHexDigits(count) {
    let digits = 0;
    let hexValue = 0;
    while (digits < count) {
      const ch = text.charCodeAt(pos);
      if (ch >= 48 && ch <= 57) {
        hexValue = hexValue * 16 + ch - 48;
      } else if (ch >= 65 && ch <= 70) {
        hexValue = hexValue * 16 + ch - 65 + 10;
      } else if (ch >= 97 && ch <= 102) {
        hexValue = hexValue * 16 + ch - 97 + 10;
      } else {
        break;
      }
      pos++;
      digits++;
    }
    if (digits < count) {
      hexValue = -1;
    }
    return hexValue;
  }
  function setPosition(newPosition) {
    pos = newPosition;
    value = "";
    tokenOffset = 0;
    token = 16;
    scanError = 0;
  }
  function scanNumber() {
    const start = pos;
    if (text.charCodeAt(pos) === 48) {
      pos++;
    } else {
      pos++;
      while (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
      }
    }
    if (pos < text.length && text.charCodeAt(pos) === 46) {
      pos++;
      if (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit(text.charCodeAt(pos))) {
          pos++;
        }
      } else {
        scanError = 3;
        return text.substring(start, pos);
      }
    }
    let end = pos;
    if (pos < text.length && (text.charCodeAt(pos) === 69 || text.charCodeAt(pos) === 101)) {
      pos++;
      if (pos < text.length && text.charCodeAt(pos) === 43 || text.charCodeAt(pos) === 45) {
        pos++;
      }
      if (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit(text.charCodeAt(pos))) {
          pos++;
        }
        end = pos;
      } else {
        scanError = 3;
      }
    }
    return text.substring(start, end);
  }
  function scanString() {
    let result = "", start = pos;
    while (true) {
      if (pos >= len) {
        result += text.substring(start, pos);
        scanError = 2;
        break;
      }
      const ch = text.charCodeAt(pos);
      if (ch === 34) {
        result += text.substring(start, pos);
        pos++;
        break;
      }
      if (ch === 92) {
        result += text.substring(start, pos);
        pos++;
        if (pos >= len) {
          scanError = 2;
          break;
        }
        const ch2 = text.charCodeAt(pos++);
        switch (ch2) {
          case 34:
            result += '"';
            break;
          case 92:
            result += "\\";
            break;
          case 47:
            result += "/";
            break;
          case 98:
            result += "\b";
            break;
          case 102:
            result += "\f";
            break;
          case 110:
            result += "\n";
            break;
          case 114:
            result += "\r";
            break;
          case 116:
            result += "	";
            break;
          case 117: {
            const ch3 = scanHexDigits(4);
            if (ch3 >= 0) {
              result += String.fromCharCode(ch3);
            } else {
              scanError = 4;
            }
            break;
          }
          default:
            scanError = 5;
        }
        start = pos;
        continue;
      }
      if (ch >= 0 && ch <= 31) {
        if (isLineBreak(ch)) {
          result += text.substring(start, pos);
          scanError = 2;
          break;
        } else {
          scanError = 6;
        }
      }
      pos++;
    }
    return result;
  }
  function scanNext() {
    value = "";
    scanError = 0;
    tokenOffset = pos;
    if (pos >= len) {
      tokenOffset = len;
      return token = 17;
    }
    let code = text.charCodeAt(pos);
    if (isWhitespace(code)) {
      do {
        pos++;
        value += String.fromCharCode(code);
        code = text.charCodeAt(pos);
      } while (isWhitespace(code));
      return token = 15;
    }
    if (isLineBreak(code)) {
      pos++;
      value += String.fromCharCode(code);
      if (code === 13 && text.charCodeAt(pos) === 10) {
        pos++;
        value += "\n";
      }
      return token = 14;
    }
    switch (code) {
      // tokens: []{}:,
      case 123:
        pos++;
        return token = 1;
      case 125:
        pos++;
        return token = 2;
      case 91:
        pos++;
        return token = 3;
      case 93:
        pos++;
        return token = 4;
      case 58:
        pos++;
        return token = 6;
      case 44:
        pos++;
        return token = 5;
      // strings
      case 34:
        pos++;
        value = scanString();
        return token = 10;
      // comments
      case 47: {
        const start = pos - 1;
        if (text.charCodeAt(pos + 1) === 47) {
          pos += 2;
          while (pos < len) {
            if (isLineBreak(text.charCodeAt(pos))) {
              break;
            }
            pos++;
          }
          value = text.substring(start, pos);
          return token = 12;
        }
        if (text.charCodeAt(pos + 1) === 42) {
          pos += 2;
          const safeLength = len - 1;
          let commentClosed = false;
          while (pos < safeLength) {
            const ch = text.charCodeAt(pos);
            if (ch === 42 && text.charCodeAt(pos + 1) === 47) {
              pos += 2;
              commentClosed = true;
              break;
            }
            pos++;
          }
          if (!commentClosed) {
            pos++;
            scanError = 1;
          }
          value = text.substring(start, pos);
          return token = 13;
        }
        value += String.fromCharCode(code);
        pos++;
        return token = 16;
      }
      // numbers
      case 45:
        value += String.fromCharCode(code);
        pos++;
        if (pos === len || !isDigit(text.charCodeAt(pos))) {
          return token = 16;
        }
      // found a minus, followed by a number so
      // we fall through to proceed with scanning
      // numbers
      case 48:
      case 49:
      case 50:
      case 51:
      case 52:
      case 53:
      case 54:
      case 55:
      case 56:
      case 57:
        value += scanNumber();
        return token = 11;
      // literals and unknown symbols
      default:
        while (pos < len && isUnknownContentCharacter(code)) {
          pos++;
          code = text.charCodeAt(pos);
        }
        if (tokenOffset !== pos) {
          value = text.substring(tokenOffset, pos);
          switch (value) {
            case "true":
              return token = 8;
            case "false":
              return token = 9;
            case "null":
              return token = 7;
          }
          return token = 16;
        }
        value += String.fromCharCode(code);
        pos++;
        return token = 16;
    }
  }
  function isUnknownContentCharacter(code) {
    if (isWhitespace(code) || isLineBreak(code)) {
      return false;
    }
    switch (code) {
      case 125:
      case 93:
      case 123:
      case 91:
      case 34:
      case 58:
      case 44:
      case 47:
        return false;
    }
    return true;
  }
  function scanNextNonTrivia() {
    let result;
    do {
      result = scanNext();
    } while (result >= 12 && result <= 15);
    return result;
  }
  return {
    setPosition,
    getPosition: () => pos,
    scan: ignoreTrivia ? scanNextNonTrivia : scanNext,
    getToken: () => token,
    getTokenValue: () => value,
    getTokenOffset: () => tokenOffset,
    getTokenLength: () => pos - tokenOffset,
    getTokenError: () => scanError
  };
}
function isWhitespace(ch) {
  return ch === 32 || ch === 9 || ch === 11 || ch === 12 || ch === 160 || ch === 5760 || ch >= 8192 && ch <= 8203 || ch === 8239 || ch === 8287 || ch === 12288 || ch === 65279;
}
function isLineBreak(ch) {
  return ch === 10 || ch === 13 || ch === 8232 || ch === 8233;
}
function isDigit(ch) {
  return ch >= 48 && ch <= 57;
}
function $fx(text, errors = [], options2 = ParseOptions.DEFAULT) {
  let currentProperty = null;
  let currentParent = [];
  const previousParents = [];
  function onValue(value) {
    if (Array.isArray(currentParent)) {
      currentParent.push(value);
    } else if (currentProperty !== null) {
      currentParent[currentProperty] = value;
    }
  }
  const visitor = {
    onObjectBegin: () => {
      const object = {};
      onValue(object);
      previousParents.push(currentParent);
      currentParent = object;
      currentProperty = null;
    },
    onObjectProperty: (name) => {
      currentProperty = name;
    },
    onObjectEnd: () => {
      currentParent = previousParents.pop();
    },
    onArrayBegin: () => {
      const array = [];
      onValue(array);
      previousParents.push(currentParent);
      currentParent = array;
      currentProperty = null;
    },
    onArrayEnd: () => {
      currentParent = previousParents.pop();
    },
    onLiteralValue: onValue,
    onError: (error, offset, length) => {
      errors.push({ error, offset, length });
    }
  };
  $mx(text, visitor, options2);
  return currentParent[0];
}
function $gx(text, errors = [], options2 = ParseOptions.DEFAULT) {
  let currentParent = { type: "array", offset: -1, length: -1, children: [], parent: void 0 };
  function ensurePropertyComplete(endOffset) {
    if (currentParent.type === "property") {
      currentParent.length = endOffset - currentParent.offset;
      currentParent = currentParent.parent;
    }
  }
  function onValue(valueNode) {
    currentParent.children.push(valueNode);
    return valueNode;
  }
  const visitor = {
    onObjectBegin: (offset) => {
      currentParent = onValue({ type: "object", offset, length: -1, parent: currentParent, children: [] });
    },
    onObjectProperty: (name, offset, length) => {
      currentParent = onValue({ type: "property", offset, length: -1, parent: currentParent, children: [] });
      currentParent.children.push({ type: "string", value: name, offset, length, parent: currentParent });
    },
    onObjectEnd: (offset, length) => {
      currentParent.length = offset + length - currentParent.offset;
      currentParent = currentParent.parent;
      ensurePropertyComplete(offset + length);
    },
    onArrayBegin: (offset, length) => {
      currentParent = onValue({ type: "array", offset, length: -1, parent: currentParent, children: [] });
    },
    onArrayEnd: (offset, length) => {
      currentParent.length = offset + length - currentParent.offset;
      currentParent = currentParent.parent;
      ensurePropertyComplete(offset + length);
    },
    onLiteralValue: (value, offset, length) => {
      onValue({ type: $nx(value), offset, length, parent: currentParent, value });
      ensurePropertyComplete(offset + length);
    },
    onSeparator: (sep2, offset, length) => {
      if (currentParent.type === "property") {
        if (sep2 === ":") {
          currentParent.colonOffset = offset;
        } else if (sep2 === ",") {
          ensurePropertyComplete(offset);
        }
      }
    },
    onError: (error, offset, length) => {
      errors.push({ error, offset, length });
    }
  };
  $mx(text, visitor, options2);
  const result = currentParent.children[0];
  if (result) {
    delete result.parent;
  }
  return result;
}
function $hx(root, path7) {
  if (!root) {
    return void 0;
  }
  let node = root;
  for (const segment of path7) {
    if (typeof segment === "string") {
      if (node.type !== "object" || !Array.isArray(node.children)) {
        return void 0;
      }
      let found = false;
      for (const propertyNode of node.children) {
        if (Array.isArray(propertyNode.children) && propertyNode.children[0].value === segment) {
          node = propertyNode.children[1];
          found = true;
          break;
        }
      }
      if (!found) {
        return void 0;
      }
    } else {
      const index = segment;
      if (node.type !== "array" || index < 0 || !Array.isArray(node.children) || index >= node.children.length) {
        return void 0;
      }
      node = node.children[index];
    }
  }
  return node;
}
function $mx(text, visitor, options2 = ParseOptions.DEFAULT) {
  const _scanner = $dx(text, false);
  function toNoArgVisit(visitFunction) {
    return visitFunction ? () => visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength()) : () => true;
  }
  function toOneArgVisit(visitFunction) {
    return visitFunction ? (arg) => visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength()) : () => true;
  }
  const onObjectBegin = toNoArgVisit(visitor.onObjectBegin), onObjectProperty = toOneArgVisit(visitor.onObjectProperty), onObjectEnd = toNoArgVisit(visitor.onObjectEnd), onArrayBegin = toNoArgVisit(visitor.onArrayBegin), onArrayEnd = toNoArgVisit(visitor.onArrayEnd), onLiteralValue = toOneArgVisit(visitor.onLiteralValue), onSeparator = toOneArgVisit(visitor.onSeparator), onComment = toNoArgVisit(visitor.onComment), onError = toOneArgVisit(visitor.onError);
  const disallowComments = options2 && options2.disallowComments;
  const allowTrailingComma = options2 && options2.allowTrailingComma;
  function scanNext() {
    while (true) {
      const token = _scanner.scan();
      switch (_scanner.getTokenError()) {
        case 4:
          handleError(
            14
            /* ParseErrorCode.InvalidUnicode */
          );
          break;
        case 5:
          handleError(
            15
            /* ParseErrorCode.InvalidEscapeCharacter */
          );
          break;
        case 3:
          handleError(
            13
            /* ParseErrorCode.UnexpectedEndOfNumber */
          );
          break;
        case 1:
          if (!disallowComments) {
            handleError(
              11
              /* ParseErrorCode.UnexpectedEndOfComment */
            );
          }
          break;
        case 2:
          handleError(
            12
            /* ParseErrorCode.UnexpectedEndOfString */
          );
          break;
        case 6:
          handleError(
            16
            /* ParseErrorCode.InvalidCharacter */
          );
          break;
      }
      switch (token) {
        case 12:
        case 13:
          if (disallowComments) {
            handleError(
              10
              /* ParseErrorCode.InvalidCommentToken */
            );
          } else {
            onComment();
          }
          break;
        case 16:
          handleError(
            1
            /* ParseErrorCode.InvalidSymbol */
          );
          break;
        case 15:
        case 14:
          break;
        default:
          return token;
      }
    }
  }
  function handleError(error, skipUntilAfter = [], skipUntil = []) {
    onError(error);
    if (skipUntilAfter.length + skipUntil.length > 0) {
      let token = _scanner.getToken();
      while (token !== 17) {
        if (skipUntilAfter.indexOf(token) !== -1) {
          scanNext();
          break;
        } else if (skipUntil.indexOf(token) !== -1) {
          break;
        }
        token = scanNext();
      }
    }
  }
  function parseString(isValue) {
    const value = _scanner.getTokenValue();
    if (isValue) {
      onLiteralValue(value);
    } else {
      onObjectProperty(value);
    }
    scanNext();
    return true;
  }
  function parseLiteral() {
    switch (_scanner.getToken()) {
      case 11: {
        let value = 0;
        try {
          value = JSON.parse(_scanner.getTokenValue());
          if (typeof value !== "number") {
            handleError(
              2
              /* ParseErrorCode.InvalidNumberFormat */
            );
            value = 0;
          }
        } catch (e) {
          handleError(
            2
            /* ParseErrorCode.InvalidNumberFormat */
          );
        }
        onLiteralValue(value);
        break;
      }
      case 7:
        onLiteralValue(null);
        break;
      case 8:
        onLiteralValue(true);
        break;
      case 9:
        onLiteralValue(false);
        break;
      default:
        return false;
    }
    scanNext();
    return true;
  }
  function parseProperty() {
    if (_scanner.getToken() !== 10) {
      handleError(3, [], [
        2,
        5
        /* SyntaxKind.CommaToken */
      ]);
      return false;
    }
    parseString(false);
    if (_scanner.getToken() === 6) {
      onSeparator(":");
      scanNext();
      if (!parseValue()) {
        handleError(4, [], [
          2,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
    } else {
      handleError(5, [], [
        2,
        5
        /* SyntaxKind.CommaToken */
      ]);
    }
    return true;
  }
  function parseObject() {
    onObjectBegin();
    scanNext();
    let needsComma = false;
    while (_scanner.getToken() !== 2 && _scanner.getToken() !== 17) {
      if (_scanner.getToken() === 5) {
        if (!needsComma) {
          handleError(4, [], []);
        }
        onSeparator(",");
        scanNext();
        if (_scanner.getToken() === 2 && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError(6, [], []);
      }
      if (!parseProperty()) {
        handleError(4, [], [
          2,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
      needsComma = true;
    }
    onObjectEnd();
    if (_scanner.getToken() !== 2) {
      handleError(7, [
        2
        /* SyntaxKind.CloseBraceToken */
      ], []);
    } else {
      scanNext();
    }
    return true;
  }
  function parseArray() {
    onArrayBegin();
    scanNext();
    let needsComma = false;
    while (_scanner.getToken() !== 4 && _scanner.getToken() !== 17) {
      if (_scanner.getToken() === 5) {
        if (!needsComma) {
          handleError(4, [], []);
        }
        onSeparator(",");
        scanNext();
        if (_scanner.getToken() === 4 && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError(6, [], []);
      }
      if (!parseValue()) {
        handleError(4, [], [
          4,
          5
          /* SyntaxKind.CommaToken */
        ]);
      }
      needsComma = true;
    }
    onArrayEnd();
    if (_scanner.getToken() !== 4) {
      handleError(8, [
        4
        /* SyntaxKind.CloseBracketToken */
      ], []);
    } else {
      scanNext();
    }
    return true;
  }
  function parseValue() {
    switch (_scanner.getToken()) {
      case 3:
        return parseArray();
      case 1:
        return parseObject();
      case 10:
        return parseString(true);
      default:
        return parseLiteral();
    }
  }
  scanNext();
  if (_scanner.getToken() === 17) {
    if (options2.allowEmptyContent) {
      return true;
    }
    handleError(4, [], []);
    return false;
  }
  if (!parseValue()) {
    handleError(4, [], []);
    return false;
  }
  if (_scanner.getToken() !== 17) {
    handleError(9, [], []);
  }
  return true;
}
function $nx(value) {
  switch (typeof value) {
    case "boolean":
      return "boolean";
    case "number":
      return "number";
    case "string":
      return "string";
    case "object": {
      if (!value) {
        return "null";
      } else if (Array.isArray(value)) {
        return "array";
      }
      return "object";
    }
    default:
      return "null";
  }
}
var ScanError, SyntaxKind, ParseErrorCode, ParseOptions, CharacterCodes;
var init_json = __esm({
  "out-build/vs/base/common/json.js"() {
    "use strict";
    (function(ScanError2) {
      ScanError2[ScanError2["None"] = 0] = "None";
      ScanError2[ScanError2["UnexpectedEndOfComment"] = 1] = "UnexpectedEndOfComment";
      ScanError2[ScanError2["UnexpectedEndOfString"] = 2] = "UnexpectedEndOfString";
      ScanError2[ScanError2["UnexpectedEndOfNumber"] = 3] = "UnexpectedEndOfNumber";
      ScanError2[ScanError2["InvalidUnicode"] = 4] = "InvalidUnicode";
      ScanError2[ScanError2["InvalidEscapeCharacter"] = 5] = "InvalidEscapeCharacter";
      ScanError2[ScanError2["InvalidCharacter"] = 6] = "InvalidCharacter";
    })(ScanError || (ScanError = {}));
    (function(SyntaxKind2) {
      SyntaxKind2[SyntaxKind2["OpenBraceToken"] = 1] = "OpenBraceToken";
      SyntaxKind2[SyntaxKind2["CloseBraceToken"] = 2] = "CloseBraceToken";
      SyntaxKind2[SyntaxKind2["OpenBracketToken"] = 3] = "OpenBracketToken";
      SyntaxKind2[SyntaxKind2["CloseBracketToken"] = 4] = "CloseBracketToken";
      SyntaxKind2[SyntaxKind2["CommaToken"] = 5] = "CommaToken";
      SyntaxKind2[SyntaxKind2["ColonToken"] = 6] = "ColonToken";
      SyntaxKind2[SyntaxKind2["NullKeyword"] = 7] = "NullKeyword";
      SyntaxKind2[SyntaxKind2["TrueKeyword"] = 8] = "TrueKeyword";
      SyntaxKind2[SyntaxKind2["FalseKeyword"] = 9] = "FalseKeyword";
      SyntaxKind2[SyntaxKind2["StringLiteral"] = 10] = "StringLiteral";
      SyntaxKind2[SyntaxKind2["NumericLiteral"] = 11] = "NumericLiteral";
      SyntaxKind2[SyntaxKind2["LineCommentTrivia"] = 12] = "LineCommentTrivia";
      SyntaxKind2[SyntaxKind2["BlockCommentTrivia"] = 13] = "BlockCommentTrivia";
      SyntaxKind2[SyntaxKind2["LineBreakTrivia"] = 14] = "LineBreakTrivia";
      SyntaxKind2[SyntaxKind2["Trivia"] = 15] = "Trivia";
      SyntaxKind2[SyntaxKind2["Unknown"] = 16] = "Unknown";
      SyntaxKind2[SyntaxKind2["EOF"] = 17] = "EOF";
    })(SyntaxKind || (SyntaxKind = {}));
    (function(ParseErrorCode2) {
      ParseErrorCode2[ParseErrorCode2["InvalidSymbol"] = 1] = "InvalidSymbol";
      ParseErrorCode2[ParseErrorCode2["InvalidNumberFormat"] = 2] = "InvalidNumberFormat";
      ParseErrorCode2[ParseErrorCode2["PropertyNameExpected"] = 3] = "PropertyNameExpected";
      ParseErrorCode2[ParseErrorCode2["ValueExpected"] = 4] = "ValueExpected";
      ParseErrorCode2[ParseErrorCode2["ColonExpected"] = 5] = "ColonExpected";
      ParseErrorCode2[ParseErrorCode2["CommaExpected"] = 6] = "CommaExpected";
      ParseErrorCode2[ParseErrorCode2["CloseBraceExpected"] = 7] = "CloseBraceExpected";
      ParseErrorCode2[ParseErrorCode2["CloseBracketExpected"] = 8] = "CloseBracketExpected";
      ParseErrorCode2[ParseErrorCode2["EndOfFileExpected"] = 9] = "EndOfFileExpected";
      ParseErrorCode2[ParseErrorCode2["InvalidCommentToken"] = 10] = "InvalidCommentToken";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfComment"] = 11] = "UnexpectedEndOfComment";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfString"] = 12] = "UnexpectedEndOfString";
      ParseErrorCode2[ParseErrorCode2["UnexpectedEndOfNumber"] = 13] = "UnexpectedEndOfNumber";
      ParseErrorCode2[ParseErrorCode2["InvalidUnicode"] = 14] = "InvalidUnicode";
      ParseErrorCode2[ParseErrorCode2["InvalidEscapeCharacter"] = 15] = "InvalidEscapeCharacter";
      ParseErrorCode2[ParseErrorCode2["InvalidCharacter"] = 16] = "InvalidCharacter";
    })(ParseErrorCode || (ParseErrorCode = {}));
    (function(ParseOptions2) {
      ParseOptions2.DEFAULT = {
        allowTrailingComma: true
      };
    })(ParseOptions || (ParseOptions = {}));
    (function(CharacterCodes2) {
      CharacterCodes2[CharacterCodes2["nullCharacter"] = 0] = "nullCharacter";
      CharacterCodes2[CharacterCodes2["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
      CharacterCodes2[CharacterCodes2["lineFeed"] = 10] = "lineFeed";
      CharacterCodes2[CharacterCodes2["carriageReturn"] = 13] = "carriageReturn";
      CharacterCodes2[CharacterCodes2["lineSeparator"] = 8232] = "lineSeparator";
      CharacterCodes2[CharacterCodes2["paragraphSeparator"] = 8233] = "paragraphSeparator";
      CharacterCodes2[CharacterCodes2["nextLine"] = 133] = "nextLine";
      CharacterCodes2[CharacterCodes2["space"] = 32] = "space";
      CharacterCodes2[CharacterCodes2["nonBreakingSpace"] = 160] = "nonBreakingSpace";
      CharacterCodes2[CharacterCodes2["enQuad"] = 8192] = "enQuad";
      CharacterCodes2[CharacterCodes2["emQuad"] = 8193] = "emQuad";
      CharacterCodes2[CharacterCodes2["enSpace"] = 8194] = "enSpace";
      CharacterCodes2[CharacterCodes2["emSpace"] = 8195] = "emSpace";
      CharacterCodes2[CharacterCodes2["threePerEmSpace"] = 8196] = "threePerEmSpace";
      CharacterCodes2[CharacterCodes2["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
      CharacterCodes2[CharacterCodes2["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
      CharacterCodes2[CharacterCodes2["figureSpace"] = 8199] = "figureSpace";
      CharacterCodes2[CharacterCodes2["punctuationSpace"] = 8200] = "punctuationSpace";
      CharacterCodes2[CharacterCodes2["thinSpace"] = 8201] = "thinSpace";
      CharacterCodes2[CharacterCodes2["hairSpace"] = 8202] = "hairSpace";
      CharacterCodes2[CharacterCodes2["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
      CharacterCodes2[CharacterCodes2["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
      CharacterCodes2[CharacterCodes2["ideographicSpace"] = 12288] = "ideographicSpace";
      CharacterCodes2[CharacterCodes2["mathematicalSpace"] = 8287] = "mathematicalSpace";
      CharacterCodes2[CharacterCodes2["ogham"] = 5760] = "ogham";
      CharacterCodes2[CharacterCodes2["_"] = 95] = "_";
      CharacterCodes2[CharacterCodes2["$"] = 36] = "$";
      CharacterCodes2[CharacterCodes2["_0"] = 48] = "_0";
      CharacterCodes2[CharacterCodes2["_1"] = 49] = "_1";
      CharacterCodes2[CharacterCodes2["_2"] = 50] = "_2";
      CharacterCodes2[CharacterCodes2["_3"] = 51] = "_3";
      CharacterCodes2[CharacterCodes2["_4"] = 52] = "_4";
      CharacterCodes2[CharacterCodes2["_5"] = 53] = "_5";
      CharacterCodes2[CharacterCodes2["_6"] = 54] = "_6";
      CharacterCodes2[CharacterCodes2["_7"] = 55] = "_7";
      CharacterCodes2[CharacterCodes2["_8"] = 56] = "_8";
      CharacterCodes2[CharacterCodes2["_9"] = 57] = "_9";
      CharacterCodes2[CharacterCodes2["a"] = 97] = "a";
      CharacterCodes2[CharacterCodes2["b"] = 98] = "b";
      CharacterCodes2[CharacterCodes2["c"] = 99] = "c";
      CharacterCodes2[CharacterCodes2["d"] = 100] = "d";
      CharacterCodes2[CharacterCodes2["e"] = 101] = "e";
      CharacterCodes2[CharacterCodes2["f"] = 102] = "f";
      CharacterCodes2[CharacterCodes2["g"] = 103] = "g";
      CharacterCodes2[CharacterCodes2["h"] = 104] = "h";
      CharacterCodes2[CharacterCodes2["i"] = 105] = "i";
      CharacterCodes2[CharacterCodes2["j"] = 106] = "j";
      CharacterCodes2[CharacterCodes2["k"] = 107] = "k";
      CharacterCodes2[CharacterCodes2["l"] = 108] = "l";
      CharacterCodes2[CharacterCodes2["m"] = 109] = "m";
      CharacterCodes2[CharacterCodes2["n"] = 110] = "n";
      CharacterCodes2[CharacterCodes2["o"] = 111] = "o";
      CharacterCodes2[CharacterCodes2["p"] = 112] = "p";
      CharacterCodes2[CharacterCodes2["q"] = 113] = "q";
      CharacterCodes2[CharacterCodes2["r"] = 114] = "r";
      CharacterCodes2[CharacterCodes2["s"] = 115] = "s";
      CharacterCodes2[CharacterCodes2["t"] = 116] = "t";
      CharacterCodes2[CharacterCodes2["u"] = 117] = "u";
      CharacterCodes2[CharacterCodes2["v"] = 118] = "v";
      CharacterCodes2[CharacterCodes2["w"] = 119] = "w";
      CharacterCodes2[CharacterCodes2["x"] = 120] = "x";
      CharacterCodes2[CharacterCodes2["y"] = 121] = "y";
      CharacterCodes2[CharacterCodes2["z"] = 122] = "z";
      CharacterCodes2[CharacterCodes2["A"] = 65] = "A";
      CharacterCodes2[CharacterCodes2["B"] = 66] = "B";
      CharacterCodes2[CharacterCodes2["C"] = 67] = "C";
      CharacterCodes2[CharacterCodes2["D"] = 68] = "D";
      CharacterCodes2[CharacterCodes2["E"] = 69] = "E";
      CharacterCodes2[CharacterCodes2["F"] = 70] = "F";
      CharacterCodes2[CharacterCodes2["G"] = 71] = "G";
      CharacterCodes2[CharacterCodes2["H"] = 72] = "H";
      CharacterCodes2[CharacterCodes2["I"] = 73] = "I";
      CharacterCodes2[CharacterCodes2["J"] = 74] = "J";
      CharacterCodes2[CharacterCodes2["K"] = 75] = "K";
      CharacterCodes2[CharacterCodes2["L"] = 76] = "L";
      CharacterCodes2[CharacterCodes2["M"] = 77] = "M";
      CharacterCodes2[CharacterCodes2["N"] = 78] = "N";
      CharacterCodes2[CharacterCodes2["O"] = 79] = "O";
      CharacterCodes2[CharacterCodes2["P"] = 80] = "P";
      CharacterCodes2[CharacterCodes2["Q"] = 81] = "Q";
      CharacterCodes2[CharacterCodes2["R"] = 82] = "R";
      CharacterCodes2[CharacterCodes2["S"] = 83] = "S";
      CharacterCodes2[CharacterCodes2["T"] = 84] = "T";
      CharacterCodes2[CharacterCodes2["U"] = 85] = "U";
      CharacterCodes2[CharacterCodes2["V"] = 86] = "V";
      CharacterCodes2[CharacterCodes2["W"] = 87] = "W";
      CharacterCodes2[CharacterCodes2["X"] = 88] = "X";
      CharacterCodes2[CharacterCodes2["Y"] = 89] = "Y";
      CharacterCodes2[CharacterCodes2["Z"] = 90] = "Z";
      CharacterCodes2[CharacterCodes2["ampersand"] = 38] = "ampersand";
      CharacterCodes2[CharacterCodes2["asterisk"] = 42] = "asterisk";
      CharacterCodes2[CharacterCodes2["at"] = 64] = "at";
      CharacterCodes2[CharacterCodes2["backslash"] = 92] = "backslash";
      CharacterCodes2[CharacterCodes2["bar"] = 124] = "bar";
      CharacterCodes2[CharacterCodes2["caret"] = 94] = "caret";
      CharacterCodes2[CharacterCodes2["closeBrace"] = 125] = "closeBrace";
      CharacterCodes2[CharacterCodes2["closeBracket"] = 93] = "closeBracket";
      CharacterCodes2[CharacterCodes2["closeParen"] = 41] = "closeParen";
      CharacterCodes2[CharacterCodes2["colon"] = 58] = "colon";
      CharacterCodes2[CharacterCodes2["comma"] = 44] = "comma";
      CharacterCodes2[CharacterCodes2["dot"] = 46] = "dot";
      CharacterCodes2[CharacterCodes2["doubleQuote"] = 34] = "doubleQuote";
      CharacterCodes2[CharacterCodes2["equals"] = 61] = "equals";
      CharacterCodes2[CharacterCodes2["exclamation"] = 33] = "exclamation";
      CharacterCodes2[CharacterCodes2["greaterThan"] = 62] = "greaterThan";
      CharacterCodes2[CharacterCodes2["lessThan"] = 60] = "lessThan";
      CharacterCodes2[CharacterCodes2["minus"] = 45] = "minus";
      CharacterCodes2[CharacterCodes2["openBrace"] = 123] = "openBrace";
      CharacterCodes2[CharacterCodes2["openBracket"] = 91] = "openBracket";
      CharacterCodes2[CharacterCodes2["openParen"] = 40] = "openParen";
      CharacterCodes2[CharacterCodes2["percent"] = 37] = "percent";
      CharacterCodes2[CharacterCodes2["plus"] = 43] = "plus";
      CharacterCodes2[CharacterCodes2["question"] = 63] = "question";
      CharacterCodes2[CharacterCodes2["semicolon"] = 59] = "semicolon";
      CharacterCodes2[CharacterCodes2["singleQuote"] = 39] = "singleQuote";
      CharacterCodes2[CharacterCodes2["slash"] = 47] = "slash";
      CharacterCodes2[CharacterCodes2["tilde"] = 126] = "tilde";
      CharacterCodes2[CharacterCodes2["backspace"] = 8] = "backspace";
      CharacterCodes2[CharacterCodes2["formFeed"] = 12] = "formFeed";
      CharacterCodes2[CharacterCodes2["byteOrderMark"] = 65279] = "byteOrderMark";
      CharacterCodes2[CharacterCodes2["tab"] = 9] = "tab";
      CharacterCodes2[CharacterCodes2["verticalTab"] = 11] = "verticalTab";
    })(CharacterCodes || (CharacterCodes = {}));
  }
});

// out-build/vs/base/common/jsonFormatter.js
function $zx(documentText, range, options2) {
  let initialIndentLevel;
  let formatText;
  let formatTextStart;
  let rangeStart;
  let rangeEnd;
  if (range) {
    rangeStart = range.offset;
    rangeEnd = rangeStart + range.length;
    formatTextStart = rangeStart;
    while (formatTextStart > 0 && !$Cx(documentText, formatTextStart - 1)) {
      formatTextStart--;
    }
    let endOffset = rangeEnd;
    while (endOffset < documentText.length && !$Cx(documentText, endOffset)) {
      endOffset++;
    }
    formatText = documentText.substring(formatTextStart, endOffset);
    initialIndentLevel = computeIndentLevel(formatText, options2);
  } else {
    formatText = documentText;
    initialIndentLevel = 0;
    formatTextStart = 0;
    rangeStart = 0;
    rangeEnd = documentText.length;
  }
  const eol = $Bx(options2, documentText);
  let lineBreak = false;
  let indentLevel = 0;
  let indentValue;
  if (options2.insertSpaces) {
    indentValue = repeat(" ", options2.tabSize || 4);
  } else {
    indentValue = "	";
  }
  const scanner = $dx(formatText, false);
  let hasError = false;
  function newLineAndIndent() {
    return eol + repeat(indentValue, initialIndentLevel + indentLevel);
  }
  function scanNext() {
    let token = scanner.scan();
    lineBreak = false;
    while (token === 15 || token === 14) {
      lineBreak = lineBreak || token === 14;
      token = scanner.scan();
    }
    hasError = token === 16 || scanner.getTokenError() !== 0;
    return token;
  }
  const editOperations = [];
  function addEdit(text, startOffset, endOffset) {
    if (!hasError && startOffset < rangeEnd && endOffset > rangeStart && documentText.substring(startOffset, endOffset) !== text) {
      editOperations.push({ offset: startOffset, length: endOffset - startOffset, content: text });
    }
  }
  let firstToken = scanNext();
  if (firstToken !== 17) {
    const firstTokenStart = scanner.getTokenOffset() + formatTextStart;
    const initialIndent = repeat(indentValue, initialIndentLevel);
    addEdit(initialIndent, formatTextStart, firstTokenStart);
  }
  while (firstToken !== 17) {
    let firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
    let secondToken = scanNext();
    let replaceContent = "";
    while (!lineBreak && (secondToken === 12 || secondToken === 13)) {
      const commentTokenStart = scanner.getTokenOffset() + formatTextStart;
      addEdit(" ", firstTokenEnd, commentTokenStart);
      firstTokenEnd = scanner.getTokenOffset() + scanner.getTokenLength() + formatTextStart;
      replaceContent = secondToken === 12 ? newLineAndIndent() : "";
      secondToken = scanNext();
    }
    if (secondToken === 2) {
      if (firstToken !== 1) {
        indentLevel--;
        replaceContent = newLineAndIndent();
      }
    } else if (secondToken === 4) {
      if (firstToken !== 3) {
        indentLevel--;
        replaceContent = newLineAndIndent();
      }
    } else {
      switch (firstToken) {
        case 3:
        case 1:
          indentLevel++;
          replaceContent = newLineAndIndent();
          break;
        case 5:
        case 12:
          replaceContent = newLineAndIndent();
          break;
        case 13:
          if (lineBreak) {
            replaceContent = newLineAndIndent();
          } else {
            replaceContent = " ";
          }
          break;
        case 6:
          replaceContent = " ";
          break;
        case 10:
          if (secondToken === 6) {
            replaceContent = "";
            break;
          }
        // fall through
        case 7:
        case 8:
        case 9:
        case 11:
        case 2:
        case 4:
          if (secondToken === 12 || secondToken === 13) {
            replaceContent = " ";
          } else if (secondToken !== 5 && secondToken !== 17) {
            hasError = true;
          }
          break;
        case 16:
          hasError = true;
          break;
      }
      if (lineBreak && (secondToken === 12 || secondToken === 13)) {
        replaceContent = newLineAndIndent();
      }
    }
    const secondTokenStart = scanner.getTokenOffset() + formatTextStart;
    addEdit(replaceContent, firstTokenEnd, secondTokenStart);
    firstToken = secondToken;
  }
  return editOperations;
}
function repeat(s, count) {
  let result = "";
  for (let i = 0; i < count; i++) {
    result += s;
  }
  return result;
}
function computeIndentLevel(content, options2) {
  let i = 0;
  let nChars = 0;
  const tabSize = options2.tabSize || 4;
  while (i < content.length) {
    const ch = content.charAt(i);
    if (ch === " ") {
      nChars++;
    } else if (ch === "	") {
      nChars += tabSize;
    } else {
      break;
    }
    i++;
  }
  return Math.floor(nChars / tabSize);
}
function $Bx(options2, text) {
  for (let i = 0; i < text.length; i++) {
    const ch = text.charAt(i);
    if (ch === "\r") {
      if (i + 1 < text.length && text.charAt(i + 1) === "\n") {
        return "\r\n";
      }
      return "\r";
    } else if (ch === "\n") {
      return "\n";
    }
  }
  return options2 && options2.eol || "\n";
}
function $Cx(text, offset) {
  return "\r\n".indexOf(text.charAt(offset)) !== -1;
}
var init_jsonFormatter = __esm({
  "out-build/vs/base/common/jsonFormatter.js"() {
    "use strict";
    init_json();
  }
});

// out-build/vs/base/common/jsonEdit.js
function $Ex(text, originalPath, value, formattingOptions, getInsertionIndex) {
  const path7 = originalPath.slice();
  const errors = [];
  const root = $gx(text, errors);
  let parent = void 0;
  let lastSegment = void 0;
  while (path7.length > 0) {
    lastSegment = path7.pop();
    parent = $hx(root, path7);
    if (parent === void 0 && value !== void 0) {
      if (typeof lastSegment === "string") {
        value = { [lastSegment]: value };
      } else {
        value = [value];
      }
    } else {
      break;
    }
  }
  if (!parent) {
    if (value === void 0) {
      return [];
    }
    return $Fx(text, { offset: root ? root.offset : 0, length: root ? root.length : 0, content: JSON.stringify(value) }, formattingOptions);
  } else if (parent.type === "object" && typeof lastSegment === "string" && Array.isArray(parent.children)) {
    const existing = $hx(parent, [lastSegment]);
    if (existing !== void 0) {
      if (value === void 0) {
        if (!existing.parent) {
          throw new Error("Malformed AST");
        }
        const propertyIndex = parent.children.indexOf(existing.parent);
        let removeBegin;
        let removeEnd = existing.parent.offset + existing.parent.length;
        if (propertyIndex > 0) {
          const previous = parent.children[propertyIndex - 1];
          removeBegin = previous.offset + previous.length;
        } else {
          removeBegin = parent.offset + 1;
          if (parent.children.length > 1) {
            const next = parent.children[1];
            removeEnd = next.offset;
          }
        }
        return $Fx(text, { offset: removeBegin, length: removeEnd - removeBegin, content: "" }, formattingOptions);
      } else {
        return $Fx(text, { offset: existing.offset, length: existing.length, content: JSON.stringify(value) }, formattingOptions);
      }
    } else {
      if (value === void 0) {
        return [];
      }
      const newProperty = `${JSON.stringify(lastSegment)}: ${JSON.stringify(value)}`;
      const index = getInsertionIndex ? getInsertionIndex(parent.children.map((p) => p.children[0].value)) : parent.children.length;
      let edit2;
      if (index > 0) {
        const previous = parent.children[index - 1];
        edit2 = { offset: previous.offset + previous.length, length: 0, content: "," + newProperty };
      } else if (parent.children.length === 0) {
        edit2 = { offset: parent.offset + 1, length: 0, content: newProperty };
      } else {
        edit2 = { offset: parent.offset + 1, length: 0, content: newProperty + "," };
      }
      return $Fx(text, edit2, formattingOptions);
    }
  } else if (parent.type === "array" && typeof lastSegment === "number" && Array.isArray(parent.children)) {
    if (value !== void 0) {
      const newProperty = `${JSON.stringify(value)}`;
      let edit2;
      if (parent.children.length === 0 || lastSegment === 0) {
        edit2 = { offset: parent.offset + 1, length: 0, content: parent.children.length === 0 ? newProperty : newProperty + "," };
      } else {
        const index = lastSegment === -1 || lastSegment > parent.children.length ? parent.children.length : lastSegment;
        const previous = parent.children[index - 1];
        edit2 = { offset: previous.offset + previous.length, length: 0, content: "," + newProperty };
      }
      return $Fx(text, edit2, formattingOptions);
    } else {
      const removalIndex = lastSegment;
      const toRemove = parent.children[removalIndex];
      let edit2;
      if (parent.children.length === 1) {
        edit2 = { offset: parent.offset + 1, length: parent.length - 2, content: "" };
      } else if (parent.children.length - 1 === removalIndex) {
        const previous = parent.children[removalIndex - 1];
        const offset = previous.offset + previous.length;
        const parentEndOffset = parent.offset + parent.length;
        edit2 = { offset, length: parentEndOffset - 2 - offset, content: "" };
      } else {
        edit2 = { offset: toRemove.offset, length: parent.children[removalIndex + 1].offset - toRemove.offset, content: "" };
      }
      return $Fx(text, edit2, formattingOptions);
    }
  } else {
    throw new Error(`Can not add ${typeof lastSegment !== "number" ? "index" : "property"} to parent of type ${parent.type}`);
  }
}
function $Fx(text, edit2, formattingOptions) {
  let newText = $Gx(text, edit2);
  let begin = edit2.offset;
  let end = edit2.offset + edit2.content.length;
  if (edit2.length === 0 || edit2.content.length === 0) {
    while (begin > 0 && !$Cx(newText, begin - 1)) {
      begin--;
    }
    while (end < newText.length && !$Cx(newText, end)) {
      end++;
    }
  }
  const edits = $zx(newText, { offset: begin, length: end - begin }, formattingOptions);
  for (let i = edits.length - 1; i >= 0; i--) {
    const curr = edits[i];
    newText = $Gx(newText, curr);
    begin = Math.min(begin, curr.offset);
    end = Math.max(end, curr.offset + curr.length);
    end += curr.content.length - curr.length;
  }
  const editLength = text.length - (newText.length - end) - begin;
  return [{ offset: begin, length: editLength, content: newText.substring(begin, end) }];
}
function $Gx(text, edit2) {
  return text.substring(0, edit2.offset) + edit2.content + text.substring(edit2.offset + edit2.length);
}
function $Hx(text, edits) {
  const sortedEdits = edits.slice(0).sort((a, b) => {
    const diff2 = a.offset - b.offset;
    if (diff2 === 0) {
      return a.length - b.length;
    }
    return diff2;
  });
  let lastModifiedOffset = text.length;
  for (let i = sortedEdits.length - 1; i >= 0; i--) {
    const e = sortedEdits[i];
    if (e.offset + e.length <= lastModifiedOffset) {
      text = $Gx(text, e);
    } else {
      throw new Error("Overlapping edit");
    }
    lastModifiedOffset = e.offset;
  }
  return text;
}
var init_jsonEdit = __esm({
  "out-build/vs/base/common/jsonEdit.js"() {
    "use strict";
    init_json();
    init_jsonFormatter();
  }
});

// out-build/vs/base/common/objects.js
function $uw(obj) {
  if (!obj || typeof obj !== "object") {
    return obj;
  }
  if (obj instanceof RegExp) {
    return obj;
  }
  const result = Array.isArray(obj) ? [] : {};
  Object.entries(obj).forEach(([key, value]) => {
    result[key] = value && typeof value === "object" ? $uw(value) : value;
  });
  return result;
}
function $vw(obj) {
  if (!obj || typeof obj !== "object") {
    return obj;
  }
  const stack = [obj];
  while (stack.length > 0) {
    const obj2 = stack.shift();
    Object.freeze(obj2);
    for (const key in obj2) {
      if (_hasOwnProperty.call(obj2, key)) {
        const prop = obj2[key];
        if (typeof prop === "object" && !Object.isFrozen(prop) && !$Zc(prop)) {
          stack.push(prop);
        }
      }
    }
  }
  return obj;
}
function $ww(obj, changer) {
  return _cloneAndChange(obj, changer, /* @__PURE__ */ new Set());
}
function _cloneAndChange(obj, changer, seen) {
  if ($6c(obj)) {
    return obj;
  }
  const changed = changer(obj);
  if (typeof changed !== "undefined") {
    return changed;
  }
  if (Array.isArray(obj)) {
    const r1 = [];
    for (const e of obj) {
      r1.push(_cloneAndChange(e, changer, seen));
    }
    return r1;
  }
  if ($Yc(obj)) {
    if (seen.has(obj)) {
      throw new Error("Cannot clone recursive data-structure");
    }
    seen.add(obj);
    const r2 = {};
    for (const i2 in obj) {
      if (_hasOwnProperty.call(obj, i2)) {
        r2[i2] = _cloneAndChange(obj[i2], changer, seen);
      }
    }
    seen.delete(obj);
    return r2;
  }
  return obj;
}
function $xw(destination, source, overwrite = true) {
  if (!$Yc(destination)) {
    return source;
  }
  if ($Yc(source)) {
    Object.keys(source).forEach((key) => {
      if (key in destination) {
        if (overwrite) {
          if ($Yc(destination[key]) && $Yc(source[key])) {
            $xw(destination[key], source[key], overwrite);
          } else {
            destination[key] = source[key];
          }
        }
      } else {
        destination[key] = source[key];
      }
    });
  }
  return destination;
}
function $yw(one, other) {
  if (one === other) {
    return true;
  }
  if (one === null || one === void 0 || other === null || other === void 0) {
    return false;
  }
  if (typeof one !== typeof other) {
    return false;
  }
  if (typeof one !== "object") {
    return false;
  }
  if (Array.isArray(one) !== Array.isArray(other)) {
    return false;
  }
  let i;
  let key;
  if (Array.isArray(one)) {
    if (one.length !== other.length) {
      return false;
    }
    for (i = 0; i < one.length; i++) {
      if (!$yw(one[i], other[i])) {
        return false;
      }
    }
  } else {
    const oneKeys = [];
    for (key in one) {
      oneKeys.push(key);
    }
    oneKeys.sort();
    const otherKeys = [];
    for (key in other) {
      otherKeys.push(key);
    }
    otherKeys.sort();
    if (!$yw(oneKeys, otherKeys)) {
      return false;
    }
    for (i = 0; i < oneKeys.length; i++) {
      if (!$yw(one[oneKeys[i]], other[oneKeys[i]])) {
        return false;
      }
    }
  }
  return true;
}
function $zw(obj) {
  const seen = /* @__PURE__ */ new Set();
  return JSON.stringify(obj, (key, value) => {
    if ($Yc(value) || Array.isArray(value)) {
      if (seen.has(value)) {
        return "[Circular]";
      } else {
        seen.add(value);
      }
    }
    if (typeof value === "bigint") {
      return `[BigInt ${value.toString()}]`;
    }
    return value;
  });
}
function $Bw(target, key) {
  const lowercaseKey = key.toLowerCase();
  const equivalentKey = Object.keys(target).find((k) => k.toLowerCase() === lowercaseKey);
  return equivalentKey ? target[equivalentKey] : target[key];
}
var _hasOwnProperty;
var init_objects = __esm({
  "out-build/vs/base/common/objects.js"() {
    "use strict";
    init_types();
    _hasOwnProperty = Object.prototype.hasOwnProperty;
  }
});

// out-build/vs/platform/configuration/common/configuration.js
function $Rl(thing) {
  return thing && typeof thing === "object" && (!thing.overrideIdentifier || typeof thing.overrideIdentifier === "string") && (!thing.resource || thing.resource instanceof URI);
}
function $Sl(thing) {
  return thing && typeof thing === "object" && (!thing.overrideIdentifiers || Array.isArray(thing.overrideIdentifiers)) && !thing.overrideIdentifier && (!thing.resource || thing.resource instanceof URI);
}
function $Wl(properties, conflictReporter) {
  const root = /* @__PURE__ */ Object.create(null);
  for (const key in properties) {
    $Xl(root, key, properties[key], conflictReporter);
  }
  return root;
}
function $Xl(settingsTreeRoot, key, value, conflictReporter) {
  const segments = key.split(".");
  const last = segments.pop();
  let curr = settingsTreeRoot;
  for (let i = 0; i < segments.length; i++) {
    const s = segments[i];
    let obj = curr[s];
    switch (typeof obj) {
      case "undefined":
        obj = curr[s] = /* @__PURE__ */ Object.create(null);
        break;
      case "object":
        if (obj === null) {
          conflictReporter(`Ignoring ${key} as ${segments.slice(0, i + 1).join(".")} is null`);
          return;
        }
        break;
      default:
        conflictReporter(`Ignoring ${key} as ${segments.slice(0, i + 1).join(".")} is ${JSON.stringify(obj)}`);
        return;
    }
    curr = obj;
  }
  if (typeof curr === "object" && curr !== null) {
    try {
      curr[last] = value;
    } catch (e) {
      conflictReporter(`Ignoring ${key} as ${segments.join(".")} is ${JSON.stringify(curr)}`);
    }
  } else {
    conflictReporter(`Ignoring ${key} as ${segments.join(".")} is ${JSON.stringify(curr)}`);
  }
}
function $Yl(valueTree, key) {
  const segments = key.split(".");
  doRemoveFromValueTree(valueTree, segments);
}
function doRemoveFromValueTree(valueTree, segments) {
  if (!valueTree) {
    return;
  }
  const first = segments.shift();
  if (segments.length === 0) {
    delete valueTree[first];
    return;
  }
  if (Object.keys(valueTree).indexOf(first) !== -1) {
    const value = valueTree[first];
    if (typeof value === "object" && !Array.isArray(value)) {
      doRemoveFromValueTree(value, segments);
      if (Object.keys(value).length === 0) {
        delete valueTree[first];
      }
    }
  }
}
function $Zl(config, settingPath, defaultValue) {
  function accessSetting(config2, path8) {
    let current = config2;
    for (const component of path8) {
      if (typeof current !== "object" || current === null) {
        return void 0;
      }
      current = current[component];
    }
    return current;
  }
  const path7 = settingPath.split(".");
  const result = accessSetting(config, path7);
  return typeof result === "undefined" ? defaultValue : result;
}
function $2l(settingKey) {
  return settingKey.replace(/[\[\]]/g, "");
}
var $Ql, ConfigurationTarget;
var init_configuration = __esm({
  "out-build/vs/platform/configuration/common/configuration.js"() {
    "use strict";
    init_assert();
    init_types();
    init_uri();
    init_instantiation();
    $Ql = $kl("configurationService");
    (function(ConfigurationTarget3) {
      ConfigurationTarget3[ConfigurationTarget3["APPLICATION"] = 1] = "APPLICATION";
      ConfigurationTarget3[ConfigurationTarget3["USER"] = 2] = "USER";
      ConfigurationTarget3[ConfigurationTarget3["USER_LOCAL"] = 3] = "USER_LOCAL";
      ConfigurationTarget3[ConfigurationTarget3["USER_REMOTE"] = 4] = "USER_REMOTE";
      ConfigurationTarget3[ConfigurationTarget3["WORKSPACE"] = 5] = "WORKSPACE";
      ConfigurationTarget3[ConfigurationTarget3["WORKSPACE_FOLDER"] = 6] = "WORKSPACE_FOLDER";
      ConfigurationTarget3[ConfigurationTarget3["DEFAULT"] = 7] = "DEFAULT";
      ConfigurationTarget3[ConfigurationTarget3["MEMORY"] = 8] = "MEMORY";
    })(ConfigurationTarget || (ConfigurationTarget = {}));
  }
});

// out-build/vs/base/common/jsonSchema.js
function $Zn(schema) {
  let hasDups = false;
  const equalsByString = /* @__PURE__ */ new Map();
  const nodeToEquals = /* @__PURE__ */ new Map();
  const visitSchemas = (next) => {
    if (schema === next) {
      return true;
    }
    const val = JSON.stringify(next);
    if (val.length < 30) {
      return true;
    }
    const eq2 = equalsByString.get(val);
    if (!eq2) {
      const newEq = { schemas: [next] };
      equalsByString.set(val, newEq);
      nodeToEquals.set(next, newEq);
      return true;
    }
    eq2.schemas.push(next);
    nodeToEquals.set(next, eq2);
    hasDups = true;
    return false;
  };
  traverseNodes(schema, visitSchemas);
  equalsByString.clear();
  if (!hasDups) {
    return JSON.stringify(schema);
  }
  let defNodeName = "$defs";
  while (schema.hasOwnProperty(defNodeName)) {
    defNodeName += "_";
  }
  const definitions = [];
  function stringify(root) {
    return JSON.stringify(root, (_key, value) => {
      if (value !== root) {
        const eq2 = nodeToEquals.get(value);
        if (eq2 && eq2.schemas.length > 1) {
          if (!eq2.id) {
            eq2.id = `_${definitions.length}`;
            definitions.push(eq2.schemas[0]);
          }
          return { $ref: `#/${defNodeName}/${eq2.id}` };
        }
      }
      return value;
    });
  }
  const str = stringify(schema);
  const defStrings = [];
  for (let i = 0; i < definitions.length; i++) {
    defStrings.push(`"_${i}":${stringify(definitions[i])}`);
  }
  if (defStrings.length) {
    return `${str.substring(0, str.length - 1)},"${defNodeName}":{${defStrings.join(",")}}}`;
  }
  return str;
}
function isObject(thing) {
  return typeof thing === "object" && thing !== null;
}
function traverseNodes(root, visit) {
  if (!root || typeof root !== "object") {
    return;
  }
  const collectEntries = (...entries) => {
    for (const entry of entries) {
      if (isObject(entry)) {
        toWalk.push(entry);
      }
    }
  };
  const collectMapEntries = (...maps) => {
    for (const map of maps) {
      if (isObject(map)) {
        for (const key in map) {
          const entry = map[key];
          if (isObject(entry)) {
            toWalk.push(entry);
          }
        }
      }
    }
  };
  const collectArrayEntries = (...arrays) => {
    for (const array of arrays) {
      if (Array.isArray(array)) {
        for (const entry of array) {
          if (isObject(entry)) {
            toWalk.push(entry);
          }
        }
      }
    }
  };
  const collectEntryOrArrayEntries = (items) => {
    if (Array.isArray(items)) {
      for (const entry of items) {
        if (isObject(entry)) {
          toWalk.push(entry);
        }
      }
    } else if (isObject(items)) {
      toWalk.push(items);
    }
  };
  const toWalk = [root];
  let next = toWalk.pop();
  while (next) {
    const visitChildern = visit(next);
    if (visitChildern) {
      collectEntries(next.additionalItems, next.additionalProperties, next.not, next.contains, next.propertyNames, next.if, next.then, next.else, next.unevaluatedItems, next.unevaluatedProperties);
      collectMapEntries(next.definitions, next.$defs, next.properties, next.patternProperties, next.dependencies, next.dependentSchemas);
      collectArrayEntries(next.anyOf, next.allOf, next.oneOf, next.prefixItems);
      collectEntryOrArrayEntries(next.items);
    }
    next = toWalk.pop();
  }
}
var init_jsonSchema = __esm({
  "out-build/vs/base/common/jsonSchema.js"() {
    "use strict";
  }
});

// out-build/vs/platform/registry/common/platform.js
var RegistryImpl, $to;
var init_platform2 = __esm({
  "out-build/vs/platform/registry/common/platform.js"() {
    "use strict";
    init_assert();
    init_types();
    RegistryImpl = class {
      constructor() {
        this.a = /* @__PURE__ */ new Map();
      }
      add(id2, data) {
        ok($Wc(id2));
        ok($Yc(data));
        ok(!this.a.has(id2), "There is already an extension with this id");
        this.a.set(id2, data);
      }
      knows(id2) {
        return this.a.has(id2);
      }
      as(id2) {
        return this.a.get(id2) || null;
      }
    };
    $to = new RegistryImpl();
  }
});

// out-build/vs/platform/jsonschemas/common/jsonContributionRegistry.js
function normalizeId(id2) {
  if (id2.length > 0 && id2.charAt(id2.length - 1) === "#") {
    return id2.substring(0, id2.length - 1);
  }
  return id2;
}
var $uo, JSONContributionRegistry, jsonContributionRegistry;
var init_jsonContributionRegistry = __esm({
  "out-build/vs/platform/jsonschemas/common/jsonContributionRegistry.js"() {
    "use strict";
    init_event();
    init_jsonSchema();
    init_lifecycle();
    init_platform2();
    $uo = {
      JSONContribution: "base.contributions.json"
    };
    JSONContributionRegistry = class {
      constructor() {
        this.a = {};
        this.b = {};
        this.c = new $0e();
        this.onDidChangeSchema = this.c.event;
        this.d = new $0e();
        this.onDidChangeSchemaAssociations = this.d.event;
      }
      registerSchema(uri, unresolvedSchemaContent, store) {
        const normalizedUri = normalizeId(uri);
        this.a[normalizedUri] = unresolvedSchemaContent;
        this.c.fire(uri);
        if (store) {
          store.add($qd(() => {
            delete this.a[normalizedUri];
            this.c.fire(uri);
          }));
        }
      }
      registerSchemaAssociation(uri, glob) {
        const normalizedUri = normalizeId(uri);
        if (!this.b[normalizedUri]) {
          this.b[normalizedUri] = [];
        }
        if (!this.b[normalizedUri].includes(glob)) {
          this.b[normalizedUri].push(glob);
          this.d.fire();
        }
        return $qd(() => {
          const associations = this.b[normalizedUri];
          if (associations) {
            const index = associations.indexOf(glob);
            if (index !== -1) {
              associations.splice(index, 1);
              if (associations.length === 0) {
                delete this.b[normalizedUri];
              }
              this.d.fire();
            }
          }
        });
      }
      notifySchemaChanged(uri) {
        this.c.fire(uri);
      }
      getSchemaContributions() {
        return {
          schemas: this.a
        };
      }
      getSchemaContent(uri) {
        const schema = this.a[uri];
        return schema ? $Zn(schema) : void 0;
      }
      hasSchemaContent(uri) {
        return !!this.a[uri];
      }
      getSchemaAssociations() {
        return this.b;
      }
    };
    jsonContributionRegistry = new JSONContributionRegistry();
    $to.add($uo.JSONContribution, jsonContributionRegistry);
  }
});

// out-build/vs/platform/configuration/common/configurationRegistry.js
function $zu(key) {
  const identifiers2 = [];
  if ($yu.test(key)) {
    let matches = OVERRIDE_IDENTIFIER_REGEX.exec(key);
    while (matches?.length) {
      const identifier = matches[1].trim();
      if (identifier) {
        identifiers2.push(identifier);
      }
      matches = OVERRIDE_IDENTIFIER_REGEX.exec(key);
    }
  }
  return $Qb(identifiers2);
}
function $Au(overrideIdentifiers) {
  return overrideIdentifiers.reduce((result, overrideIdentifier) => `${result}[${overrideIdentifier}]`, "");
}
function $Bu(type2) {
  const t = Array.isArray(type2) ? type2[0] : type2;
  switch (t) {
    case "boolean":
      return false;
    case "integer":
    case "number":
      return 0;
    case "string":
      return "";
    case "array":
      return [];
    case "object":
      return {};
    default:
      return null;
  }
}
function $Cu(property, schema) {
  if (!property.trim()) {
    return localize(1797, null);
  }
  if ($yu.test(property)) {
    return localize(1798, null, property);
  }
  if (configurationRegistry.getConfigurationProperties()[property] !== void 0) {
    return localize(1799, null, property);
  }
  if (schema.policy?.name && configurationRegistry.getPolicyConfigurations().get(schema.policy?.name) !== void 0) {
    return localize(1800, null, property, schema.policy?.name, configurationRegistry.getPolicyConfigurations().get(schema.policy?.name));
  }
  return null;
}
var EditPresentationTypes, $nu, ConfigurationScope, $ou, $pu, $qu, $ru, $su, $tu, $uu, $vu, contributionRegistry, ConfigurationRegistry, OVERRIDE_IDENTIFIER_PATTERN, OVERRIDE_IDENTIFIER_REGEX, $xu, $yu, configurationRegistry;
var init_configurationRegistry = __esm({
  "out-build/vs/platform/configuration/common/configurationRegistry.js"() {
    "use strict";
    init_arrays();
    init_event();
    init_types();
    init_nls2();
    init_configuration();
    init_jsonContributionRegistry();
    init_platform2();
    (function(EditPresentationTypes2) {
      EditPresentationTypes2["Multiline"] = "multilineText";
      EditPresentationTypes2["Singleline"] = "singlelineText";
    })(EditPresentationTypes || (EditPresentationTypes = {}));
    $nu = {
      Configuration: "base.contributions.configuration"
    };
    (function(ConfigurationScope2) {
      ConfigurationScope2[ConfigurationScope2["APPLICATION"] = 1] = "APPLICATION";
      ConfigurationScope2[ConfigurationScope2["MACHINE"] = 2] = "MACHINE";
      ConfigurationScope2[ConfigurationScope2["APPLICATION_MACHINE"] = 3] = "APPLICATION_MACHINE";
      ConfigurationScope2[ConfigurationScope2["WINDOW"] = 4] = "WINDOW";
      ConfigurationScope2[ConfigurationScope2["RESOURCE"] = 5] = "RESOURCE";
      ConfigurationScope2[ConfigurationScope2["LANGUAGE_OVERRIDABLE"] = 6] = "LANGUAGE_OVERRIDABLE";
      ConfigurationScope2[ConfigurationScope2["MACHINE_OVERRIDABLE"] = 7] = "MACHINE_OVERRIDABLE";
    })(ConfigurationScope || (ConfigurationScope = {}));
    $ou = { properties: {}, patternProperties: {} };
    $pu = { properties: {}, patternProperties: {} };
    $qu = { properties: {}, patternProperties: {} };
    $ru = { properties: {}, patternProperties: {} };
    $su = { properties: {}, patternProperties: {} };
    $tu = { properties: {}, patternProperties: {} };
    $uu = { properties: {}, patternProperties: {} };
    $vu = "vscode://schemas/settings/resourceLanguage";
    contributionRegistry = $to.as($uo.JSONContribution);
    ConfigurationRegistry = class {
      constructor() {
        this.a = [];
        this.i = /* @__PURE__ */ new Set();
        this.j = new $0e();
        this.onDidSchemaChange = this.j.event;
        this.k = new $0e();
        this.onDidUpdateConfiguration = this.k.event;
        this.b = /* @__PURE__ */ new Map();
        this.c = {
          id: "defaultOverrides",
          title: localize(1791, null),
          properties: {}
        };
        this.d = [this.c];
        this.h = {
          properties: {},
          patternProperties: {},
          additionalProperties: true,
          allowTrailingCommas: true,
          allowComments: true
        };
        this.e = {};
        this.f = /* @__PURE__ */ new Map();
        this.g = {};
        contributionRegistry.registerSchema($vu, this.h);
        this.z();
      }
      registerConfiguration(configuration, validate = true) {
        this.registerConfigurations([configuration], validate);
        return configuration;
      }
      registerConfigurations(configurations, validate = true) {
        const properties = /* @__PURE__ */ new Set();
        this.r(configurations, validate, properties);
        contributionRegistry.registerSchema($vu, this.h);
        this.j.fire();
        this.k.fire({ properties });
      }
      deregisterConfigurations(configurations) {
        const properties = /* @__PURE__ */ new Set();
        this.s(configurations, properties);
        contributionRegistry.registerSchema($vu, this.h);
        this.j.fire();
        this.k.fire({ properties });
      }
      updateConfigurations({ add, remove }) {
        const properties = /* @__PURE__ */ new Set();
        this.s(remove, properties);
        this.r(add, false, properties);
        contributionRegistry.registerSchema($vu, this.h);
        this.j.fire();
        this.k.fire({ properties });
      }
      registerDefaultConfigurations(configurationDefaults) {
        const properties = /* @__PURE__ */ new Set();
        this.l(configurationDefaults, properties);
        this.j.fire();
        this.k.fire({ properties, defaultsOverrides: true });
      }
      l(configurationDefaults, bucket) {
        this.a.push(...configurationDefaults);
        const overrideIdentifiers = [];
        for (const { overrides, source } of configurationDefaults) {
          for (const key in overrides) {
            bucket.add(key);
            const configurationDefaultOverridesForKey = this.b.get(key) ?? this.b.set(key, { configurationDefaultOverrides: [] }).get(key);
            const value = overrides[key];
            configurationDefaultOverridesForKey.configurationDefaultOverrides.push({ value, source });
            if ($yu.test(key)) {
              const newDefaultOverride = this.o(key, value, source, configurationDefaultOverridesForKey.configurationDefaultOverrideValue);
              if (!newDefaultOverride) {
                continue;
              }
              configurationDefaultOverridesForKey.configurationDefaultOverrideValue = newDefaultOverride;
              this.n(key, newDefaultOverride, source);
              overrideIdentifiers.push(...$zu(key));
            } else {
              const newDefaultOverride = this.p(key, value, source, configurationDefaultOverridesForKey.configurationDefaultOverrideValue);
              if (!newDefaultOverride) {
                continue;
              }
              configurationDefaultOverridesForKey.configurationDefaultOverrideValue = newDefaultOverride;
              const property = this.e[key];
              if (property) {
                this.A(key, property);
                this.w(key, property);
              }
            }
          }
        }
        this.q(overrideIdentifiers);
      }
      deregisterDefaultConfigurations(defaultConfigurations) {
        const properties = /* @__PURE__ */ new Set();
        this.m(defaultConfigurations, properties);
        this.j.fire();
        this.k.fire({ properties, defaultsOverrides: true });
      }
      m(defaultConfigurations, bucket) {
        for (const defaultConfiguration of defaultConfigurations) {
          const index = this.a.indexOf(defaultConfiguration);
          if (index !== -1) {
            this.a.splice(index, 1);
          }
        }
        for (const { overrides, source } of defaultConfigurations) {
          for (const key in overrides) {
            const configurationDefaultOverridesForKey = this.b.get(key);
            if (!configurationDefaultOverridesForKey) {
              continue;
            }
            const index = configurationDefaultOverridesForKey.configurationDefaultOverrides.findIndex((configurationDefaultOverride) => source ? configurationDefaultOverride.source?.id === source.id : configurationDefaultOverride.value === overrides[key]);
            if (index === -1) {
              continue;
            }
            configurationDefaultOverridesForKey.configurationDefaultOverrides.splice(index, 1);
            if (configurationDefaultOverridesForKey.configurationDefaultOverrides.length === 0) {
              this.b.delete(key);
            }
            if ($yu.test(key)) {
              let configurationDefaultOverrideValue;
              for (const configurationDefaultOverride of configurationDefaultOverridesForKey.configurationDefaultOverrides) {
                configurationDefaultOverrideValue = this.o(key, configurationDefaultOverride.value, configurationDefaultOverride.source, configurationDefaultOverrideValue);
              }
              if (configurationDefaultOverrideValue && !$ad(configurationDefaultOverrideValue.value)) {
                configurationDefaultOverridesForKey.configurationDefaultOverrideValue = configurationDefaultOverrideValue;
                this.n(key, configurationDefaultOverrideValue, source);
              } else {
                this.b.delete(key);
                delete this.e[key];
                delete this.c.properties[key];
              }
            } else {
              let configurationDefaultOverrideValue;
              for (const configurationDefaultOverride of configurationDefaultOverridesForKey.configurationDefaultOverrides) {
                configurationDefaultOverrideValue = this.p(key, configurationDefaultOverride.value, configurationDefaultOverride.source, configurationDefaultOverrideValue);
              }
              configurationDefaultOverridesForKey.configurationDefaultOverrideValue = configurationDefaultOverrideValue;
              const property = this.e[key];
              if (property) {
                this.A(key, property);
                this.w(key, property);
              }
            }
            bucket.add(key);
          }
        }
        this.y();
      }
      n(key, newDefaultOverride, source) {
        const property = {
          type: "object",
          default: newDefaultOverride.value,
          description: localize(1792, null, $2l(key)),
          $ref: $vu,
          defaultDefaultValue: newDefaultOverride.value,
          source,
          defaultValueSource: source
        };
        this.e[key] = property;
        this.c.properties[key] = property;
      }
      o(overrideIdentifier, configurationValueObject, valueSource, existingDefaultOverride) {
        const defaultValue = existingDefaultOverride?.value || {};
        const source = existingDefaultOverride?.source ?? /* @__PURE__ */ new Map();
        if (!(source instanceof Map)) {
          console.error("objectConfigurationSources is not a Map");
          return void 0;
        }
        for (const propertyKey of Object.keys(configurationValueObject)) {
          const propertyDefaultValue = configurationValueObject[propertyKey];
          const isObjectSetting = $Yc(propertyDefaultValue) && ($4c(defaultValue[propertyKey]) || $Yc(defaultValue[propertyKey]));
          if (isObjectSetting) {
            defaultValue[propertyKey] = { ...defaultValue[propertyKey] ?? {}, ...propertyDefaultValue };
            if (valueSource) {
              for (const objectKey in propertyDefaultValue) {
                source.set(`${propertyKey}.${objectKey}`, valueSource);
              }
            }
          } else {
            defaultValue[propertyKey] = propertyDefaultValue;
            if (valueSource) {
              source.set(propertyKey, valueSource);
            } else {
              source.delete(propertyKey);
            }
          }
        }
        return { value: defaultValue, source };
      }
      p(propertyKey, value, valuesSource, existingDefaultOverride) {
        const property = this.e[propertyKey];
        const existingDefaultValue = existingDefaultOverride?.value ?? property?.defaultDefaultValue;
        let source = valuesSource;
        const isObjectSetting = $Yc(value) && (property !== void 0 && property.type === "object" || property === void 0 && ($4c(existingDefaultValue) || $Yc(existingDefaultValue)));
        if (isObjectSetting) {
          source = existingDefaultOverride?.source ?? /* @__PURE__ */ new Map();
          if (!(source instanceof Map)) {
            console.error("defaultValueSource is not a Map");
            return void 0;
          }
          for (const objectKey in value) {
            if (valuesSource) {
              source.set(`${propertyKey}.${objectKey}`, valuesSource);
            }
          }
          value = { ...$Yc(existingDefaultValue) ? existingDefaultValue : {}, ...value };
        }
        return { value, source };
      }
      deltaConfiguration(delta) {
        let defaultsOverrides = false;
        const properties = /* @__PURE__ */ new Set();
        if (delta.removedDefaults) {
          this.m(delta.removedDefaults, properties);
          defaultsOverrides = true;
        }
        if (delta.addedDefaults) {
          this.l(delta.addedDefaults, properties);
          defaultsOverrides = true;
        }
        if (delta.removedConfigurations) {
          this.s(delta.removedConfigurations, properties);
        }
        if (delta.addedConfigurations) {
          this.r(delta.addedConfigurations, false, properties);
        }
        this.j.fire();
        this.k.fire({ properties, defaultsOverrides });
      }
      notifyConfigurationSchemaUpdated(...configurations) {
        this.j.fire();
      }
      registerOverrideIdentifiers(overrideIdentifiers) {
        this.q(overrideIdentifiers);
        this.j.fire();
      }
      q(overrideIdentifiers) {
        for (const overrideIdentifier of overrideIdentifiers) {
          this.i.add(overrideIdentifier);
        }
        this.y();
      }
      r(configurations, validate, bucket) {
        configurations.forEach((configuration) => {
          this.u(configuration, validate, configuration.extensionInfo, configuration.restrictedProperties, void 0, bucket);
          this.d.push(configuration);
          this.v(configuration);
        });
      }
      s(configurations, bucket) {
        const deregisterConfiguration = (configuration) => {
          if (configuration.properties) {
            for (const key in configuration.properties) {
              bucket.add(key);
              const property = this.e[key];
              if (property?.policy?.name) {
                this.f.delete(property.policy.name);
              }
              delete this.e[key];
              this.x(key, configuration.properties[key]);
            }
          }
          configuration.allOf?.forEach((node) => deregisterConfiguration(node));
        };
        for (const configuration of configurations) {
          deregisterConfiguration(configuration);
          const index = this.d.indexOf(configuration);
          if (index !== -1) {
            this.d.splice(index, 1);
          }
        }
      }
      u(configuration, validate = true, extensionInfo, restrictedProperties, scope = 4, bucket) {
        scope = $6c(configuration.scope) ? scope : configuration.scope;
        const properties = configuration.properties;
        if (properties) {
          for (const key in properties) {
            const property = properties[key];
            if (validate && $Cu(key, property)) {
              delete properties[key];
              continue;
            }
            property.source = extensionInfo;
            property.defaultDefaultValue = properties[key].default;
            this.A(key, property);
            if ($yu.test(key)) {
              property.scope = void 0;
            } else {
              property.scope = $6c(property.scope) ? scope : property.scope;
              property.restricted = $6c(property.restricted) ? !!restrictedProperties?.includes(key) : property.restricted;
            }
            const excluded = properties[key].hasOwnProperty("included") && !properties[key].included;
            const policyName = properties[key].policy?.name;
            if (excluded) {
              this.g[key] = properties[key];
              if (policyName) {
                this.f.set(policyName, key);
                bucket.add(key);
              }
              delete properties[key];
            } else {
              bucket.add(key);
              if (policyName) {
                this.f.set(policyName, key);
              }
              this.e[key] = properties[key];
              if (!properties[key].deprecationMessage && properties[key].markdownDeprecationMessage) {
                properties[key].deprecationMessage = properties[key].markdownDeprecationMessage;
              }
            }
          }
        }
        const subNodes = configuration.allOf;
        if (subNodes) {
          for (const node of subNodes) {
            this.u(node, validate, extensionInfo, restrictedProperties, scope, bucket);
          }
        }
      }
      // TODO: @sandy081 - Remove this method and include required info in getConfigurationProperties
      getConfigurations() {
        return this.d;
      }
      getConfigurationProperties() {
        return this.e;
      }
      getPolicyConfigurations() {
        return this.f;
      }
      getExcludedConfigurationProperties() {
        return this.g;
      }
      getRegisteredDefaultConfigurations() {
        return [...this.a];
      }
      getConfigurationDefaultsOverrides() {
        const configurationDefaultsOverrides = /* @__PURE__ */ new Map();
        for (const [key, value] of this.b) {
          if (value.configurationDefaultOverrideValue) {
            configurationDefaultsOverrides.set(key, value.configurationDefaultOverrideValue);
          }
        }
        return configurationDefaultsOverrides;
      }
      v(configuration) {
        const register2 = (configuration2) => {
          const properties = configuration2.properties;
          if (properties) {
            for (const key in properties) {
              this.w(key, properties[key]);
            }
          }
          const subNodes = configuration2.allOf;
          subNodes?.forEach(register2);
        };
        register2(configuration);
      }
      w(key, property) {
        $ou.properties[key] = property;
        switch (property.scope) {
          case 1:
            $pu.properties[key] = property;
            break;
          case 2:
            $ru.properties[key] = property;
            break;
          case 3:
            $qu.properties[key] = property;
            break;
          case 7:
            $su.properties[key] = property;
            break;
          case 4:
            $tu.properties[key] = property;
            break;
          case 5:
            $uu.properties[key] = property;
            break;
          case 6:
            $uu.properties[key] = property;
            this.h.properties[key] = property;
            break;
        }
      }
      x(key, property) {
        delete $ou.properties[key];
        switch (property.scope) {
          case 1:
            delete $pu.properties[key];
            break;
          case 2:
            delete $ru.properties[key];
            break;
          case 3:
            delete $qu.properties[key];
            break;
          case 7:
            delete $su.properties[key];
            break;
          case 4:
            delete $tu.properties[key];
            break;
          case 5:
          case 6:
            delete $uu.properties[key];
            delete this.h.properties[key];
            break;
        }
      }
      y() {
        for (const overrideIdentifier of this.i.values()) {
          const overrideIdentifierProperty = `[${overrideIdentifier}]`;
          const resourceLanguagePropertiesSchema = {
            type: "object",
            description: localize(1793, null),
            errorMessage: localize(1794, null),
            $ref: $vu
          };
          this.A(overrideIdentifierProperty, resourceLanguagePropertiesSchema);
          $ou.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          $pu.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          $qu.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          $ru.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          $su.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          $tu.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          $uu.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
        }
      }
      z() {
        const resourceLanguagePropertiesSchema = {
          type: "object",
          description: localize(1795, null),
          errorMessage: localize(1796, null),
          $ref: $vu
        };
        $ou.patternProperties[$xu] = resourceLanguagePropertiesSchema;
        $pu.patternProperties[$xu] = resourceLanguagePropertiesSchema;
        $qu.patternProperties[$xu] = resourceLanguagePropertiesSchema;
        $ru.patternProperties[$xu] = resourceLanguagePropertiesSchema;
        $su.patternProperties[$xu] = resourceLanguagePropertiesSchema;
        $tu.patternProperties[$xu] = resourceLanguagePropertiesSchema;
        $uu.patternProperties[$xu] = resourceLanguagePropertiesSchema;
        this.j.fire();
      }
      A(key, property) {
        const configurationdefaultOverride = this.b.get(key)?.configurationDefaultOverrideValue;
        let defaultValue = void 0;
        let defaultSource = void 0;
        if (configurationdefaultOverride && (!property.disallowConfigurationDefault || !configurationdefaultOverride.source)) {
          defaultValue = configurationdefaultOverride.value;
          defaultSource = configurationdefaultOverride.source;
        }
        if ($4c(defaultValue)) {
          defaultValue = property.defaultDefaultValue;
          defaultSource = void 0;
        }
        if ($4c(defaultValue)) {
          defaultValue = $Bu(property.type);
        }
        property.default = defaultValue;
        property.defaultValueSource = defaultSource;
      }
    };
    OVERRIDE_IDENTIFIER_PATTERN = `\\[([^\\]]+)\\]`;
    OVERRIDE_IDENTIFIER_REGEX = new RegExp(OVERRIDE_IDENTIFIER_PATTERN, "g");
    $xu = `^(${OVERRIDE_IDENTIFIER_PATTERN})+$`;
    $yu = new RegExp($xu);
    configurationRegistry = new ConfigurationRegistry();
    $to.add($nu.Configuration, configurationRegistry);
  }
});

// out-build/vs/platform/configuration/common/configurationModels.js
function freeze(data) {
  return Object.isFrozen(data) ? data : $vw(data);
}
function compare(from, to) {
  const { added, removed, updated } = compareConfigurationContents(to?.rawConfiguration, from?.rawConfiguration);
  const overrides = [];
  const fromOverrideIdentifiers = from?.getAllOverrideIdentifiers() || [];
  const toOverrideIdentifiers = to?.getAllOverrideIdentifiers() || [];
  if (to) {
    const addedOverrideIdentifiers = toOverrideIdentifiers.filter((key) => !fromOverrideIdentifiers.includes(key));
    for (const identifier of addedOverrideIdentifiers) {
      overrides.push([identifier, to.getKeysForOverrideIdentifier(identifier)]);
    }
  }
  if (from) {
    const removedOverrideIdentifiers = fromOverrideIdentifiers.filter((key) => !toOverrideIdentifiers.includes(key));
    for (const identifier of removedOverrideIdentifiers) {
      overrides.push([identifier, from.getKeysForOverrideIdentifier(identifier)]);
    }
  }
  if (to && from) {
    for (const identifier of fromOverrideIdentifiers) {
      if (toOverrideIdentifiers.includes(identifier)) {
        const result = compareConfigurationContents({ contents: from.getOverrideValue(void 0, identifier) || {}, keys: from.getKeysForOverrideIdentifier(identifier) }, { contents: to.getOverrideValue(void 0, identifier) || {}, keys: to.getKeysForOverrideIdentifier(identifier) });
        overrides.push([identifier, [...result.added, ...result.removed, ...result.updated]]);
      }
    }
  }
  return { added, removed, updated, overrides };
}
function compareConfigurationContents(to, from) {
  const added = to ? from ? to.keys.filter((key) => from.keys.indexOf(key) === -1) : [...to.keys] : [];
  const removed = from ? to ? from.keys.filter((key) => to.keys.indexOf(key) === -1) : [...from.keys] : [];
  const updated = [];
  if (to && from) {
    for (const key of from.keys) {
      if (to.keys.indexOf(key) !== -1) {
        const value1 = $Zl(from.contents, key);
        const value2 = $Zl(to.contents, key);
        if (!$yw(value1, value2)) {
          updated.push(key);
        }
      }
    }
  }
  return { added, removed, updated };
}
var $NC, $OC, $PC, ConfigurationInspectValue, $QC, $SC;
var init_configurationModels = __esm({
  "out-build/vs/platform/configuration/common/configurationModels.js"() {
    "use strict";
    init_arrays();
    init_event();
    init_json();
    init_lifecycle();
    init_map();
    init_objects();
    init_types();
    init_uri();
    init_configuration();
    init_configurationRegistry();
    init_platform2();
    $NC = class _$NC {
      static createEmptyModel(logService) {
        return new _$NC({}, [], [], void 0, logService);
      }
      constructor(b, c, d, raw, f) {
        this.b = b;
        this.c = c;
        this.d = d;
        this.raw = raw;
        this.f = f;
        this.a = /* @__PURE__ */ new Map();
      }
      get rawConfiguration() {
        if (!this.g) {
          if (this.raw) {
            const rawConfigurationModels = (Array.isArray(this.raw) ? this.raw : [this.raw]).map((raw) => {
              if (raw instanceof _$NC) {
                return raw;
              }
              const parser2 = new $OC("", this.f);
              parser2.parseRaw(raw);
              return parser2.configurationModel;
            });
            this.g = rawConfigurationModels.reduce((previous, current) => current === previous ? current : previous.merge(current), rawConfigurationModels[0]);
          } else {
            this.g = this;
          }
        }
        return this.g;
      }
      get contents() {
        return this.b;
      }
      get overrides() {
        return this.d;
      }
      get keys() {
        return this.c;
      }
      isEmpty() {
        return this.c.length === 0 && Object.keys(this.b).length === 0 && this.d.length === 0;
      }
      getValue(section) {
        return section ? $Zl(this.contents, section) : this.contents;
      }
      inspect(section, overrideIdentifier) {
        const that = this;
        return {
          get value() {
            return freeze(that.rawConfiguration.getValue(section));
          },
          get override() {
            return overrideIdentifier ? freeze(that.rawConfiguration.getOverrideValue(section, overrideIdentifier)) : void 0;
          },
          get merged() {
            return freeze(overrideIdentifier ? that.rawConfiguration.override(overrideIdentifier).getValue(section) : that.rawConfiguration.getValue(section));
          },
          get overrides() {
            const overrides = [];
            for (const { contents, identifiers: identifiers2, keys } of that.rawConfiguration.overrides) {
              const value = new _$NC(contents, keys, [], void 0, that.f).getValue(section);
              if (value !== void 0) {
                overrides.push({ identifiers: identifiers2, value });
              }
            }
            return overrides.length ? freeze(overrides) : void 0;
          }
        };
      }
      getOverrideValue(section, overrideIdentifier) {
        const overrideContents = this.j(overrideIdentifier);
        return overrideContents ? section ? $Zl(overrideContents, section) : overrideContents : void 0;
      }
      getKeysForOverrideIdentifier(identifier) {
        const keys = [];
        for (const override of this.overrides) {
          if (override.identifiers.includes(identifier)) {
            keys.push(...override.keys);
          }
        }
        return $Qb(keys);
      }
      getAllOverrideIdentifiers() {
        const result = [];
        for (const override of this.overrides) {
          result.push(...override.identifiers);
        }
        return $Qb(result);
      }
      override(identifier) {
        let overrideConfigurationModel = this.a.get(identifier);
        if (!overrideConfigurationModel) {
          overrideConfigurationModel = this.h(identifier);
          this.a.set(identifier, overrideConfigurationModel);
        }
        return overrideConfigurationModel;
      }
      merge(...others) {
        const contents = $uw(this.contents);
        const overrides = $uw(this.overrides);
        const keys = [...this.keys];
        const raws = this.raw ? Array.isArray(this.raw) ? [...this.raw] : [this.raw] : [this];
        for (const other of others) {
          raws.push(...other.raw ? Array.isArray(other.raw) ? other.raw : [other.raw] : [other]);
          if (other.isEmpty()) {
            continue;
          }
          this.i(contents, other.contents);
          for (const otherOverride of other.overrides) {
            const [override] = overrides.filter((o) => $yb(o.identifiers, otherOverride.identifiers));
            if (override) {
              this.i(override.contents, otherOverride.contents);
              override.keys.push(...otherOverride.keys);
              override.keys = $Qb(override.keys);
            } else {
              overrides.push($uw(otherOverride));
            }
          }
          for (const key of other.keys) {
            if (keys.indexOf(key) === -1) {
              keys.push(key);
            }
          }
        }
        return new _$NC(contents, keys, overrides, !raws.length || raws.every((raw) => raw instanceof _$NC) ? void 0 : raws, this.f);
      }
      h(identifier) {
        const overrideContents = this.j(identifier);
        if (!overrideContents || typeof overrideContents !== "object" || !Object.keys(overrideContents).length) {
          return this;
        }
        const contents = {};
        for (const key of $Qb([...Object.keys(this.contents), ...Object.keys(overrideContents)])) {
          let contentsForKey = this.contents[key];
          const overrideContentsForKey = overrideContents[key];
          if (overrideContentsForKey) {
            if (typeof contentsForKey === "object" && typeof overrideContentsForKey === "object") {
              contentsForKey = $uw(contentsForKey);
              this.i(contentsForKey, overrideContentsForKey);
            } else {
              contentsForKey = overrideContentsForKey;
            }
          }
          contents[key] = contentsForKey;
        }
        return new _$NC(contents, this.keys, this.overrides, void 0, this.f);
      }
      i(source, target) {
        for (const key of Object.keys(target)) {
          if (key in source) {
            if ($Yc(source[key]) && $Yc(target[key])) {
              this.i(source[key], target[key]);
              continue;
            }
          }
          source[key] = $uw(target[key]);
        }
      }
      j(identifier) {
        let contentsForIdentifierOnly = null;
        let contents = null;
        const mergeContents = (contentsToMerge) => {
          if (contentsToMerge) {
            if (contents) {
              this.i(contents, contentsToMerge);
            } else {
              contents = $uw(contentsToMerge);
            }
          }
        };
        for (const override of this.overrides) {
          if (override.identifiers.length === 1 && override.identifiers[0] === identifier) {
            contentsForIdentifierOnly = override.contents;
          } else if (override.identifiers.includes(identifier)) {
            mergeContents(override.contents);
          }
        }
        mergeContents(contentsForIdentifierOnly);
        return contents;
      }
      toJSON() {
        return {
          contents: this.contents,
          overrides: this.overrides,
          keys: this.keys
        };
      }
      // Update methods
      addValue(key, value) {
        this.k(key, value, true);
      }
      setValue(key, value) {
        this.k(key, value, false);
      }
      removeValue(key) {
        const index = this.keys.indexOf(key);
        if (index === -1) {
          return;
        }
        this.keys.splice(index, 1);
        $Yl(this.contents, key);
        if ($yu.test(key)) {
          this.overrides.splice(this.overrides.findIndex((o) => $yb(o.identifiers, $zu(key))), 1);
        }
      }
      k(key, value, add) {
        $Xl(this.contents, key, value, (e) => this.f.error(e));
        add = add || this.keys.indexOf(key) === -1;
        if (add) {
          this.keys.push(key);
        }
        if ($yu.test(key)) {
          const identifiers2 = $zu(key);
          const override = {
            identifiers: identifiers2,
            keys: Object.keys(this.contents[key]),
            contents: $Wl(this.contents[key], (message) => this.f.error(message))
          };
          const index = this.overrides.findIndex((o) => $yb(o.identifiers, identifiers2));
          if (index !== -1) {
            this.overrides[index] = override;
          } else {
            this.overrides.push(override);
          }
        }
      }
    };
    $OC = class {
      constructor(f, g) {
        this.f = f;
        this.g = g;
        this.a = null;
        this.b = null;
        this.c = [];
        this.d = [];
      }
      get configurationModel() {
        return this.b || $NC.createEmptyModel(this.g);
      }
      get restrictedConfigurations() {
        return this.c;
      }
      get errors() {
        return this.d;
      }
      parse(content, options2) {
        if (!$6c(content)) {
          const raw = this.h(content);
          this.parseRaw(raw, options2);
        }
      }
      reparse(options2) {
        if (this.a) {
          this.parseRaw(this.a, options2);
        }
      }
      parseRaw(raw, options2) {
        this.a = raw;
        const { contents, keys, overrides, restricted, hasExcludedProperties } = this.i(raw, options2);
        this.b = new $NC(contents, keys, overrides, hasExcludedProperties ? [raw] : void 0, this.g);
        this.c = restricted || [];
      }
      h(content) {
        let raw = {};
        let currentProperty = null;
        let currentParent = [];
        const previousParents = [];
        const parseErrors = [];
        function onValue(value) {
          if (Array.isArray(currentParent)) {
            currentParent.push(value);
          } else if (currentProperty !== null) {
            currentParent[currentProperty] = value;
          }
        }
        const visitor = {
          onObjectBegin: () => {
            const object = {};
            onValue(object);
            previousParents.push(currentParent);
            currentParent = object;
            currentProperty = null;
          },
          onObjectProperty: (name) => {
            currentProperty = name;
          },
          onObjectEnd: () => {
            currentParent = previousParents.pop();
          },
          onArrayBegin: () => {
            const array = [];
            onValue(array);
            previousParents.push(currentParent);
            currentParent = array;
            currentProperty = null;
          },
          onArrayEnd: () => {
            currentParent = previousParents.pop();
          },
          onLiteralValue: onValue,
          onError: (error, offset, length) => {
            parseErrors.push({ error, offset, length });
          }
        };
        if (content) {
          try {
            $mx(content, visitor);
            raw = currentParent[0] || {};
          } catch (e) {
            this.g.error(`Error while parsing settings file ${this.f}: ${e}`);
            this.d = [e];
          }
        }
        return raw;
      }
      i(raw, options2) {
        const configurationProperties = $to.as($nu.Configuration).getConfigurationProperties();
        const filtered = this.j(raw, configurationProperties, true, options2);
        raw = filtered.raw;
        const contents = $Wl(raw, (message) => this.g.error(`Conflict in settings file ${this.f}: ${message}`));
        const keys = Object.keys(raw);
        const overrides = this.m(raw, (message) => this.g.error(`Conflict in settings file ${this.f}: ${message}`));
        return { contents, keys, overrides, restricted: filtered.restricted, hasExcludedProperties: filtered.hasExcludedProperties };
      }
      j(properties, configurationProperties, filterOverriddenProperties, options2) {
        let hasExcludedProperties = false;
        if (!options2?.scopes && !options2?.skipRestricted && !options2?.exclude?.length) {
          return { raw: properties, restricted: [], hasExcludedProperties };
        }
        const raw = {};
        const restricted = [];
        for (const key in properties) {
          if ($yu.test(key) && filterOverriddenProperties) {
            const result = this.j(properties[key], configurationProperties, false, options2);
            raw[key] = result.raw;
            hasExcludedProperties = hasExcludedProperties || result.hasExcludedProperties;
            restricted.push(...result.restricted);
          } else {
            const propertySchema = configurationProperties[key];
            if (propertySchema?.restricted) {
              restricted.push(key);
            }
            if (this.l(key, propertySchema, options2)) {
              raw[key] = properties[key];
            } else {
              hasExcludedProperties = true;
            }
          }
        }
        return { raw, restricted, hasExcludedProperties };
      }
      l(key, propertySchema, options2) {
        if (options2.exclude?.includes(key)) {
          return false;
        }
        if (options2.include?.includes(key)) {
          return true;
        }
        if (options2.skipRestricted && propertySchema?.restricted) {
          return false;
        }
        if (options2.skipUnregistered && !propertySchema) {
          return false;
        }
        const scope = propertySchema ? typeof propertySchema.scope !== "undefined" ? propertySchema.scope : 4 : void 0;
        if (scope === void 0 || options2.scopes === void 0) {
          return true;
        }
        return options2.scopes.includes(scope);
      }
      m(raw, conflictReporter) {
        const overrides = [];
        for (const key of Object.keys(raw)) {
          if ($yu.test(key)) {
            const overrideRaw = {};
            for (const keyInOverrideRaw in raw[key]) {
              overrideRaw[keyInOverrideRaw] = raw[key][keyInOverrideRaw];
            }
            overrides.push({
              identifiers: $zu(key),
              keys: Object.keys(overrideRaw),
              contents: $Wl(overrideRaw, conflictReporter)
            });
          }
        }
        return overrides;
      }
    };
    $PC = class extends $sd {
      constructor(c, f, extUri, g, h) {
        super();
        this.c = c;
        this.f = f;
        this.g = g;
        this.h = h;
        this.b = this.B(new $0e());
        this.onDidChange = this.b.event;
        this.a = new $OC(this.c.toString(), h);
        this.B(this.g.watch(extUri.dirname(this.c)));
        this.B(this.g.watch(this.c));
        this.B(Event.any(Event.filter(this.g.onDidFilesChange, (e) => e.contains(this.c)), Event.filter(this.g.onDidRunOperation, (e) => (e.isOperation(
          0
          /* FileOperation.CREATE */
        ) || e.isOperation(
          3
          /* FileOperation.COPY */
        ) || e.isOperation(
          1
          /* FileOperation.DELETE */
        ) || e.isOperation(
          4
          /* FileOperation.WRITE */
        )) && extUri.isEqual(e.resource, c)))(() => this.b.fire()));
      }
      async loadConfiguration() {
        try {
          const content = await this.g.readFile(this.c);
          this.a.parse(content.value.toString() || "{}", this.f);
          return this.a.configurationModel;
        } catch (e) {
          return $NC.createEmptyModel(this.h);
        }
      }
      reparse(parseOptions) {
        if (parseOptions) {
          this.f = parseOptions;
        }
        this.a.reparse(this.f);
        return this.a.configurationModel;
      }
      getRestrictedSettings() {
        return this.a.restrictedConfigurations;
      }
    };
    ConfigurationInspectValue = class {
      constructor(a, b, c, overrideIdentifiers, d, f, g, h, i, j, k, l, m) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.overrideIdentifiers = overrideIdentifiers;
        this.d = d;
        this.f = f;
        this.g = g;
        this.h = h;
        this.i = i;
        this.j = j;
        this.k = k;
        this.l = l;
        this.m = m;
      }
      get value() {
        return freeze(this.c);
      }
      n(inspectValue) {
        return inspectValue?.value !== void 0 || inspectValue?.override !== void 0 || inspectValue?.overrides !== void 0 ? inspectValue : void 0;
      }
      get q() {
        if (!this.p) {
          this.p = this.d.inspect(this.a, this.b.overrideIdentifier);
        }
        return this.p;
      }
      get defaultValue() {
        return this.q.merged;
      }
      get default() {
        return this.n(this.q);
      }
      get s() {
        if (this.r === void 0) {
          this.r = this.f ? this.f.inspect(this.a) : null;
        }
        return this.r;
      }
      get policyValue() {
        return this.s?.merged;
      }
      get policy() {
        return this.s?.value !== void 0 ? { value: this.s.value } : void 0;
      }
      get u() {
        if (this.t === void 0) {
          this.t = this.g ? this.g.inspect(this.a) : null;
        }
        return this.t;
      }
      get applicationValue() {
        return this.u?.merged;
      }
      get application() {
        return this.n(this.u);
      }
      get w() {
        if (!this.v) {
          this.v = this.h.inspect(this.a, this.b.overrideIdentifier);
        }
        return this.v;
      }
      get userValue() {
        return this.w.merged;
      }
      get user() {
        return this.n(this.w);
      }
      get y() {
        if (!this.x) {
          this.x = this.i.inspect(this.a, this.b.overrideIdentifier);
        }
        return this.x;
      }
      get userLocalValue() {
        return this.y.merged;
      }
      get userLocal() {
        return this.n(this.y);
      }
      get A() {
        if (!this.z) {
          this.z = this.j.inspect(this.a, this.b.overrideIdentifier);
        }
        return this.z;
      }
      get userRemoteValue() {
        return this.A.merged;
      }
      get userRemote() {
        return this.n(this.A);
      }
      get D() {
        if (this.B === void 0) {
          this.B = this.k ? this.k.inspect(this.a, this.b.overrideIdentifier) : null;
        }
        return this.B;
      }
      get workspaceValue() {
        return this.D?.merged;
      }
      get workspace() {
        return this.n(this.D);
      }
      get F() {
        if (this.E === void 0) {
          this.E = this.l ? this.l.inspect(this.a, this.b.overrideIdentifier) : null;
        }
        return this.E;
      }
      get workspaceFolderValue() {
        return this.F?.merged;
      }
      get workspaceFolder() {
        return this.n(this.F);
      }
      get H() {
        if (this.G === void 0) {
          this.G = this.m.inspect(this.a, this.b.overrideIdentifier);
        }
        return this.G;
      }
      get memoryValue() {
        return this.H.merged;
      }
      get memory() {
        return this.n(this.H);
      }
    };
    $QC = class _$QC {
      constructor(j, l, m, n, p, q, r, s, t, u) {
        this.j = j;
        this.l = l;
        this.m = m;
        this.n = n;
        this.p = p;
        this.q = q;
        this.r = r;
        this.s = s;
        this.t = t;
        this.u = u;
        this.h = null;
        this.i = new $Fc();
        this.v = null;
      }
      getValue(section, overrides, workspace) {
        const consolidateConfigurationModel = this.w(section, overrides, workspace);
        return consolidateConfigurationModel.getValue(section);
      }
      updateValue(key, value, overrides = {}) {
        let memoryConfiguration;
        if (overrides.resource) {
          memoryConfiguration = this.t.get(overrides.resource);
          if (!memoryConfiguration) {
            memoryConfiguration = $NC.createEmptyModel(this.u);
            this.t.set(overrides.resource, memoryConfiguration);
          }
        } else {
          memoryConfiguration = this.s;
        }
        if (value === void 0) {
          memoryConfiguration.removeValue(key);
        } else {
          memoryConfiguration.setValue(key, value);
        }
        if (!overrides.resource) {
          this.h = null;
        }
      }
      inspect(key, overrides, workspace) {
        const consolidateConfigurationModel = this.w(key, overrides, workspace);
        const folderConfigurationModel = this.A(overrides.resource, workspace);
        const memoryConfigurationModel = overrides.resource ? this.t.get(overrides.resource) || this.s : this.s;
        const overrideIdentifiers = /* @__PURE__ */ new Set();
        for (const override of consolidateConfigurationModel.overrides) {
          for (const overrideIdentifier of override.identifiers) {
            if (consolidateConfigurationModel.getOverrideValue(key, overrideIdentifier) !== void 0) {
              overrideIdentifiers.add(overrideIdentifier);
            }
          }
        }
        return new ConfigurationInspectValue(key, overrides, consolidateConfigurationModel.getValue(key), overrideIdentifiers.size ? [...overrideIdentifiers] : void 0, this.j, this.l.isEmpty() ? void 0 : this.l, this.applicationConfiguration.isEmpty() ? void 0 : this.applicationConfiguration, this.userConfiguration, this.localUserConfiguration, this.remoteUserConfiguration, workspace ? this.q : void 0, folderConfigurationModel ? folderConfigurationModel : void 0, memoryConfigurationModel);
      }
      keys(workspace) {
        const folderConfigurationModel = this.A(void 0, workspace);
        return {
          default: this.j.keys.slice(0),
          user: this.userConfiguration.keys.slice(0),
          workspace: this.q.keys.slice(0),
          workspaceFolder: folderConfigurationModel ? folderConfigurationModel.keys.slice(0) : []
        };
      }
      updateDefaultConfiguration(defaultConfiguration) {
        this.j = defaultConfiguration;
        this.h = null;
        this.i.clear();
      }
      updatePolicyConfiguration(policyConfiguration) {
        this.l = policyConfiguration;
      }
      updateApplicationConfiguration(applicationConfiguration) {
        this.m = applicationConfiguration;
        this.h = null;
        this.i.clear();
      }
      updateLocalUserConfiguration(localUserConfiguration) {
        this.n = localUserConfiguration;
        this.v = null;
        this.h = null;
        this.i.clear();
      }
      updateRemoteUserConfiguration(remoteUserConfiguration) {
        this.p = remoteUserConfiguration;
        this.v = null;
        this.h = null;
        this.i.clear();
      }
      updateWorkspaceConfiguration(workspaceConfiguration) {
        this.q = workspaceConfiguration;
        this.h = null;
        this.i.clear();
      }
      updateFolderConfiguration(resource, configuration) {
        this.r.set(resource, configuration);
        this.i.delete(resource);
      }
      deleteFolderConfiguration(resource) {
        this.folderConfigurations.delete(resource);
        this.i.delete(resource);
      }
      compareAndUpdateDefaultConfiguration(defaults, keys) {
        const overrides = [];
        if (!keys) {
          const { added, updated, removed } = compare(this.j, defaults);
          keys = [...added, ...updated, ...removed];
        }
        for (const key of keys) {
          for (const overrideIdentifier of $zu(key)) {
            const fromKeys = this.j.getKeysForOverrideIdentifier(overrideIdentifier);
            const toKeys = defaults.getKeysForOverrideIdentifier(overrideIdentifier);
            const keys2 = [
              ...toKeys.filter((key2) => fromKeys.indexOf(key2) === -1),
              ...fromKeys.filter((key2) => toKeys.indexOf(key2) === -1),
              ...fromKeys.filter((key2) => !$yw(this.j.override(overrideIdentifier).getValue(key2), defaults.override(overrideIdentifier).getValue(key2)))
            ];
            overrides.push([overrideIdentifier, keys2]);
          }
        }
        this.updateDefaultConfiguration(defaults);
        return { keys, overrides };
      }
      compareAndUpdatePolicyConfiguration(policyConfiguration) {
        const { added, updated, removed } = compare(this.l, policyConfiguration);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
          this.updatePolicyConfiguration(policyConfiguration);
        }
        return { keys, overrides: [] };
      }
      compareAndUpdateApplicationConfiguration(application) {
        const { added, updated, removed, overrides } = compare(this.applicationConfiguration, application);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
          this.updateApplicationConfiguration(application);
        }
        return { keys, overrides };
      }
      compareAndUpdateLocalUserConfiguration(user) {
        const { added, updated, removed, overrides } = compare(this.localUserConfiguration, user);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
          this.updateLocalUserConfiguration(user);
        }
        return { keys, overrides };
      }
      compareAndUpdateRemoteUserConfiguration(user) {
        const { added, updated, removed, overrides } = compare(this.remoteUserConfiguration, user);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
          this.updateRemoteUserConfiguration(user);
        }
        return { keys, overrides };
      }
      compareAndUpdateWorkspaceConfiguration(workspaceConfiguration) {
        const { added, updated, removed, overrides } = compare(this.workspaceConfiguration, workspaceConfiguration);
        const keys = [...added, ...updated, ...removed];
        if (keys.length) {
          this.updateWorkspaceConfiguration(workspaceConfiguration);
        }
        return { keys, overrides };
      }
      compareAndUpdateFolderConfiguration(resource, folderConfiguration) {
        const currentFolderConfiguration = this.folderConfigurations.get(resource);
        const { added, updated, removed, overrides } = compare(currentFolderConfiguration, folderConfiguration);
        const keys = [...added, ...updated, ...removed];
        if (keys.length || !currentFolderConfiguration) {
          this.updateFolderConfiguration(resource, folderConfiguration);
        }
        return { keys, overrides };
      }
      compareAndDeleteFolderConfiguration(folder) {
        const folderConfig = this.folderConfigurations.get(folder);
        if (!folderConfig) {
          throw new Error("Unknown folder");
        }
        this.deleteFolderConfiguration(folder);
        const { added, updated, removed, overrides } = compare(folderConfig, void 0);
        return { keys: [...added, ...updated, ...removed], overrides };
      }
      get defaults() {
        return this.j;
      }
      get applicationConfiguration() {
        return this.m;
      }
      get userConfiguration() {
        if (!this.v) {
          if (this.p.isEmpty()) {
            this.v = this.n;
          } else {
            const merged = this.n.merge(this.p);
            this.v = new $NC(merged.contents, merged.keys, merged.overrides, void 0, this.u);
          }
        }
        return this.v;
      }
      get localUserConfiguration() {
        return this.n;
      }
      get remoteUserConfiguration() {
        return this.p;
      }
      get workspaceConfiguration() {
        return this.q;
      }
      get folderConfigurations() {
        return this.r;
      }
      w(section, overrides, workspace) {
        let configurationModel = this.x(overrides, workspace);
        if (overrides.overrideIdentifier) {
          configurationModel = configurationModel.override(overrides.overrideIdentifier);
        }
        if (!this.l.isEmpty() && this.l.getValue(section) !== void 0) {
          configurationModel = configurationModel.merge();
          for (const key of this.l.keys) {
            configurationModel.setValue(key, this.l.getValue(key));
          }
        }
        return configurationModel;
      }
      x({ resource }, workspace) {
        let consolidateConfiguration = this.y();
        if (workspace && resource) {
          const root = workspace.getFolder(resource);
          if (root) {
            consolidateConfiguration = this.z(root.uri) || consolidateConfiguration;
          }
          const memoryConfigurationForResource = this.t.get(resource);
          if (memoryConfigurationForResource) {
            consolidateConfiguration = consolidateConfiguration.merge(memoryConfigurationForResource);
          }
        }
        return consolidateConfiguration;
      }
      y() {
        if (!this.h) {
          this.h = this.j.merge(this.applicationConfiguration, this.userConfiguration, this.q, this.s);
        }
        return this.h;
      }
      z(folder) {
        let folderConsolidatedConfiguration = this.i.get(folder);
        if (!folderConsolidatedConfiguration) {
          const workspaceConsolidateConfiguration = this.y();
          const folderConfiguration = this.r.get(folder);
          if (folderConfiguration) {
            folderConsolidatedConfiguration = workspaceConsolidateConfiguration.merge(folderConfiguration);
            this.i.set(folder, folderConsolidatedConfiguration);
          } else {
            folderConsolidatedConfiguration = workspaceConsolidateConfiguration;
          }
        }
        return folderConsolidatedConfiguration;
      }
      A(resource, workspace) {
        if (workspace && resource) {
          const root = workspace.getFolder(resource);
          if (root) {
            return this.r.get(root.uri);
          }
        }
        return void 0;
      }
      toData() {
        return {
          defaults: {
            contents: this.j.contents,
            overrides: this.j.overrides,
            keys: this.j.keys
          },
          policy: {
            contents: this.l.contents,
            overrides: this.l.overrides,
            keys: this.l.keys
          },
          application: {
            contents: this.applicationConfiguration.contents,
            overrides: this.applicationConfiguration.overrides,
            keys: this.applicationConfiguration.keys,
            raw: Array.isArray(this.applicationConfiguration.raw) ? void 0 : this.applicationConfiguration.raw
          },
          userLocal: {
            contents: this.localUserConfiguration.contents,
            overrides: this.localUserConfiguration.overrides,
            keys: this.localUserConfiguration.keys,
            raw: Array.isArray(this.localUserConfiguration.raw) ? void 0 : this.localUserConfiguration.raw
          },
          userRemote: {
            contents: this.remoteUserConfiguration.contents,
            overrides: this.remoteUserConfiguration.overrides,
            keys: this.remoteUserConfiguration.keys,
            raw: Array.isArray(this.remoteUserConfiguration.raw) ? void 0 : this.remoteUserConfiguration.raw
          },
          workspace: {
            contents: this.q.contents,
            overrides: this.q.overrides,
            keys: this.q.keys
          },
          folders: [...this.r.keys()].reduce((result, folder) => {
            const { contents, overrides, keys } = this.r.get(folder);
            result.push([folder, { contents, overrides, keys }]);
            return result;
          }, [])
        };
      }
      allKeys() {
        const keys = /* @__PURE__ */ new Set();
        this.j.keys.forEach((key) => keys.add(key));
        this.userConfiguration.keys.forEach((key) => keys.add(key));
        this.q.keys.forEach((key) => keys.add(key));
        this.r.forEach((folderConfiguration) => folderConfiguration.keys.forEach((key) => keys.add(key)));
        return [...keys.values()];
      }
      B() {
        const keys = /* @__PURE__ */ new Set();
        this.j.getAllOverrideIdentifiers().forEach((key) => keys.add(key));
        this.userConfiguration.getAllOverrideIdentifiers().forEach((key) => keys.add(key));
        this.q.getAllOverrideIdentifiers().forEach((key) => keys.add(key));
        this.r.forEach((folderConfiguration) => folderConfiguration.getAllOverrideIdentifiers().forEach((key) => keys.add(key)));
        return [...keys.values()];
      }
      D(overrideIdentifier) {
        const keys = /* @__PURE__ */ new Set();
        this.j.getKeysForOverrideIdentifier(overrideIdentifier).forEach((key) => keys.add(key));
        this.userConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach((key) => keys.add(key));
        this.q.getKeysForOverrideIdentifier(overrideIdentifier).forEach((key) => keys.add(key));
        this.r.forEach((folderConfiguration) => folderConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach((key) => keys.add(key)));
        return [...keys.values()];
      }
      static parse(data, logService) {
        const defaultConfiguration = this.E(data.defaults, logService);
        const policyConfiguration = this.E(data.policy, logService);
        const applicationConfiguration = this.E(data.application, logService);
        const userLocalConfiguration = this.E(data.userLocal, logService);
        const userRemoteConfiguration = this.E(data.userRemote, logService);
        const workspaceConfiguration = this.E(data.workspace, logService);
        const folders = data.folders.reduce((result, value) => {
          result.set(URI.revive(value[0]), this.E(value[1], logService));
          return result;
        }, new $Fc());
        return new _$QC(defaultConfiguration, policyConfiguration, applicationConfiguration, userLocalConfiguration, userRemoteConfiguration, workspaceConfiguration, folders, $NC.createEmptyModel(logService), new $Fc(), logService);
      }
      static E(model, logService) {
        return new $NC(model.contents, model.keys, model.overrides, model.raw, logService);
      }
    };
    $SC = class {
      constructor(change, f, g, h, i) {
        this.change = change;
        this.f = f;
        this.g = g;
        this.h = h;
        this.i = i;
        this.a = "\n";
        this.b = this.a.charCodeAt(0);
        this.c = ".".charCodeAt(0);
        this.affectedKeys = /* @__PURE__ */ new Set();
        this.j = void 0;
        for (const key of change.keys) {
          this.affectedKeys.add(key);
        }
        for (const [, keys] of change.overrides) {
          for (const key of keys) {
            this.affectedKeys.add(key);
          }
        }
        this.d = this.a;
        for (const key of this.affectedKeys) {
          this.d += key + this.a;
        }
      }
      get previousConfiguration() {
        if (!this.j && this.f) {
          this.j = $QC.parse(this.f.data, this.i);
        }
        return this.j;
      }
      affectsConfiguration(section, overrides) {
        const needle = this.a + section;
        const idx = this.d.indexOf(needle);
        if (idx < 0) {
          return false;
        }
        const pos = idx + needle.length;
        if (pos >= this.d.length) {
          return false;
        }
        const code = this.d.charCodeAt(pos);
        if (code !== this.b && code !== this.c) {
          return false;
        }
        if (overrides) {
          const value1 = this.previousConfiguration ? this.previousConfiguration.getValue(section, overrides, this.f?.workspace) : void 0;
          const value2 = this.g.getValue(section, overrides, this.h);
          return !$yw(value1, value2);
        }
        return true;
      }
    };
  }
});

// out-build/vs/platform/policy/common/policy.js
var $mo, $oo;
var init_policy = __esm({
  "out-build/vs/platform/policy/common/policy.js"() {
    "use strict";
    init_event();
    init_iterator();
    init_lifecycle();
    init_instantiation();
    $mo = $kl("policy");
    $oo = class {
      constructor() {
        this.onDidChange = Event.None;
        this.policyDefinitions = {};
      }
      async updatePolicyDefinitions() {
        return {};
      }
      getPolicyValue() {
        return void 0;
      }
      serialize() {
        return void 0;
      }
    };
  }
});

// out-build/vs/platform/configuration/common/configurations.js
var $TC, $UC, $VC;
var init_configurations = __esm({
  "out-build/vs/platform/configuration/common/configurations.js"() {
    "use strict";
    init_arrays();
    init_event();
    init_lifecycle();
    init_objects();
    init_types();
    init_configurationModels();
    init_configurationRegistry();
    init_log();
    init_policy();
    init_platform2();
    init_errors();
    init_json();
    $TC = class extends $sd {
      get configurationModel() {
        return this.b;
      }
      constructor(c) {
        super();
        this.c = c;
        this.a = this.B(new $0e());
        this.onDidChangeConfiguration = this.a.event;
        this.b = $NC.createEmptyModel(this.c);
      }
      async initialize() {
        this.h();
        this.B($to.as($nu.Configuration).onDidUpdateConfiguration(({ properties, defaultsOverrides }) => this.f(Array.from(properties), defaultsOverrides)));
        return this.configurationModel;
      }
      reload() {
        this.h();
        return this.configurationModel;
      }
      f(properties, defaultsOverrides) {
        this.j(properties, $to.as($nu.Configuration).getConfigurationProperties());
        this.a.fire({ defaults: this.configurationModel, properties });
      }
      g() {
        return {};
      }
      h() {
        this.b = $NC.createEmptyModel(this.c);
        const properties = $to.as($nu.Configuration).getConfigurationProperties();
        this.j(Object.keys(properties), properties);
      }
      j(properties, configurationProperties) {
        const configurationDefaultsOverrides = this.g();
        for (const key of properties) {
          const defaultOverrideValue = configurationDefaultsOverrides[key];
          const propertySchema = configurationProperties[key];
          if (defaultOverrideValue !== void 0) {
            this.b.setValue(key, defaultOverrideValue);
          } else if (propertySchema) {
            this.b.setValue(key, $uw(propertySchema.default));
          } else {
            this.b.removeValue(key);
          }
        }
      }
    };
    $UC = class {
      constructor() {
        this.onDidChangeConfiguration = Event.None;
        this.configurationModel = $NC.createEmptyModel(new $go());
      }
      async initialize() {
        return this.configurationModel;
      }
    };
    $VC = class $VC2 extends $sd {
      get configurationModel() {
        return this.c;
      }
      constructor(f, g, h) {
        super();
        this.f = f;
        this.g = g;
        this.h = h;
        this.a = this.B(new $0e());
        this.onDidChangeConfiguration = this.a.event;
        this.c = $NC.createEmptyModel(this.h);
        this.b = $to.as($nu.Configuration);
      }
      async initialize() {
        this.h.trace("PolicyConfiguration#initialize");
        this.n(await this.j(this.f.configurationModel.keys), false);
        this.n(await this.j(Object.keys(this.b.getExcludedConfigurationProperties())), false);
        this.B(this.g.onDidChange((policyNames) => this.m(policyNames)));
        this.B(this.f.onDidChangeConfiguration(async ({ properties }) => this.n(await this.j(properties), true)));
        return this.c;
      }
      async j(properties) {
        this.h.trace("PolicyConfiguration#updatePolicyDefinitions", properties);
        const policyDefinitions = {};
        const keys = [];
        const configurationProperties = this.b.getConfigurationProperties();
        const excludedConfigurationProperties = this.b.getExcludedConfigurationProperties();
        for (const key of properties) {
          const config = configurationProperties[key] ?? excludedConfigurationProperties[key];
          if (!config) {
            keys.push(key);
            continue;
          }
          if (config.policy) {
            if (config.type !== "string" && config.type !== "number" && config.type !== "array" && config.type !== "object" && config.type !== "boolean") {
              this.h.warn(`Policy ${config.policy.name} has unsupported type ${config.type}`);
              continue;
            }
            const { defaultValue, previewFeature } = config.policy;
            keys.push(key);
            policyDefinitions[config.policy.name] = {
              type: config.type === "number" ? "number" : config.type === "boolean" ? "boolean" : "string",
              previewFeature,
              defaultValue
            };
          }
        }
        if (!$ad(policyDefinitions)) {
          await this.g.updatePolicyDefinitions(policyDefinitions);
        }
        return keys;
      }
      m(policyNames) {
        this.h.trace("PolicyConfiguration#onDidChangePolicies", policyNames);
        const policyConfigurations = this.b.getPolicyConfigurations();
        const keys = $Lb(policyNames.map((policyName) => policyConfigurations.get(policyName)));
        this.n(keys, true);
      }
      n(keys, trigger) {
        this.h.trace("PolicyConfiguration#update", keys);
        const configurationProperties = this.b.getConfigurationProperties();
        const excludedConfigurationProperties = this.b.getExcludedConfigurationProperties();
        const changed = [];
        const wasEmpty = this.c.isEmpty();
        for (const key of keys) {
          const proprety = configurationProperties[key] ?? excludedConfigurationProperties[key];
          const policyName = proprety?.policy?.name;
          if (policyName) {
            let policyValue = this.g.getPolicyValue(policyName);
            if ($Wc(policyValue) && proprety.type !== "string") {
              try {
                policyValue = this.r(policyValue);
              } catch (e) {
                this.h.error(`Error parsing policy value ${policyName}:`, $qb(e));
                continue;
              }
            }
            if (wasEmpty ? policyValue !== void 0 : !$yw(this.c.getValue(key), policyValue)) {
              changed.push([key, policyValue]);
            }
          } else {
            if (this.c.getValue(key) !== void 0) {
              changed.push([key, void 0]);
            }
          }
        }
        if (changed.length) {
          this.h.trace("PolicyConfiguration#changed", changed);
          const old = this.c;
          this.c = $NC.createEmptyModel(this.h);
          for (const key of old.keys) {
            this.c.setValue(key, old.getValue(key));
          }
          for (const [key, policyValue] of changed) {
            if (policyValue === void 0) {
              this.c.removeValue(key);
            } else {
              this.c.setValue(key, policyValue);
            }
          }
          if (trigger) {
            this.a.fire(this.c);
          }
        }
      }
      r(content) {
        let raw = {};
        let currentProperty = null;
        let currentParent = [];
        const previousParents = [];
        const parseErrors = [];
        function onValue(value) {
          if (Array.isArray(currentParent)) {
            currentParent.push(value);
          } else if (currentProperty !== null) {
            if (currentParent[currentProperty] !== void 0) {
              throw new Error(`Duplicate property found: ${currentProperty}`);
            }
            currentParent[currentProperty] = value;
          }
        }
        const visitor = {
          onObjectBegin: () => {
            const object = {};
            onValue(object);
            previousParents.push(currentParent);
            currentParent = object;
            currentProperty = null;
          },
          onObjectProperty: (name) => {
            currentProperty = name;
          },
          onObjectEnd: () => {
            currentParent = previousParents.pop();
          },
          onArrayBegin: () => {
            const array = [];
            onValue(array);
            previousParents.push(currentParent);
            currentParent = array;
            currentProperty = null;
          },
          onArrayEnd: () => {
            currentParent = previousParents.pop();
          },
          onLiteralValue: onValue,
          onError: (error, offset, length) => {
            parseErrors.push({ error, offset, length });
          }
        };
        if (content) {
          $mx(content, visitor);
          raw = currentParent[0] || {};
        }
        if (parseErrors.length > 0) {
          throw new Error(parseErrors.map((e) => $qb(e.error)).join("\n"));
        }
        return raw;
      }
    };
    $VC = __decorate([
      __param(1, $mo),
      __param(2, $5n)
    ], $VC);
  }
});

// out-build/vs/platform/configuration/common/configurationService.js
var $WC, ConfigurationEditing;
var init_configurationService = __esm({
  "out-build/vs/platform/configuration/common/configurationService.js"() {
    "use strict";
    init_arrays();
    init_async();
    init_buffer();
    init_event();
    init_json();
    init_jsonEdit();
    init_lifecycle();
    init_map();
    init_objects();
    init_platform();
    init_resources();
    init_configuration();
    init_configurationModels();
    init_configurationRegistry();
    init_configurations();
    init_policy();
    $WC = class extends $sd {
      constructor(m, fileService, policyService, n) {
        super();
        this.m = m;
        this.n = n;
        this.h = this.B(new $0e());
        this.onDidChangeConfiguration = this.h.event;
        this.b = this.B(new $TC(n));
        this.c = policyService instanceof $oo ? new $UC() : this.B(new $VC(this.b, policyService, n));
        this.f = this.B(new $PC(this.m, {}, $Gh, fileService, n));
        this.a = new $QC(this.b.configurationModel, this.c.configurationModel, $NC.createEmptyModel(n), $NC.createEmptyModel(n), $NC.createEmptyModel(n), $NC.createEmptyModel(n), new $Fc(), $NC.createEmptyModel(n), new $Fc(), n);
        this.j = new ConfigurationEditing(m, fileService, this);
        this.g = this.B(new $pi(() => this.reloadConfiguration(), 50));
        this.B(this.b.onDidChangeConfiguration(({ defaults, properties }) => this.s(defaults, properties)));
        this.B(this.c.onDidChangeConfiguration((model) => this.t(model)));
        this.B(this.f.onDidChange(() => this.g.schedule()));
      }
      async initialize() {
        const [defaultModel, policyModel, userModel] = await Promise.all([this.b.initialize(), this.c.initialize(), this.f.loadConfiguration()]);
        this.a = new $QC(defaultModel, policyModel, $NC.createEmptyModel(this.n), userModel, $NC.createEmptyModel(this.n), $NC.createEmptyModel(this.n), new $Fc(), $NC.createEmptyModel(this.n), new $Fc(), this.n);
      }
      getConfigurationData() {
        return this.a.toData();
      }
      getValue(arg1, arg2) {
        const section = typeof arg1 === "string" ? arg1 : void 0;
        const overrides = $Rl(arg1) ? arg1 : $Rl(arg2) ? arg2 : {};
        return this.a.getValue(section, overrides, void 0);
      }
      async updateValue(key, value, arg3, arg4, options2) {
        const overrides = $Sl(arg3) ? arg3 : $Rl(arg3) ? { resource: arg3.resource, overrideIdentifiers: arg3.overrideIdentifier ? [arg3.overrideIdentifier] : void 0 } : void 0;
        const target = overrides ? arg4 : arg3;
        if (target !== void 0) {
          if (target !== 3 && target !== 2) {
            throw new Error(`Unable to write ${key} to target ${target}.`);
          }
        }
        if (overrides?.overrideIdentifiers) {
          overrides.overrideIdentifiers = $Qb(overrides.overrideIdentifiers);
          overrides.overrideIdentifiers = overrides.overrideIdentifiers.length ? overrides.overrideIdentifiers : void 0;
        }
        const inspect = this.inspect(key, { resource: overrides?.resource, overrideIdentifier: overrides?.overrideIdentifiers ? overrides.overrideIdentifiers[0] : void 0 });
        if (inspect.policyValue !== void 0) {
          throw new Error(`Unable to write ${key} because it is configured in system policy.`);
        }
        if ($yw(value, inspect.defaultValue)) {
          value = void 0;
        }
        if (overrides?.overrideIdentifiers?.length && overrides.overrideIdentifiers.length > 1) {
          const overrideIdentifiers = overrides.overrideIdentifiers.sort();
          const existingOverrides = this.a.localUserConfiguration.overrides.find((override) => $yb([...override.identifiers].sort(), overrideIdentifiers));
          if (existingOverrides) {
            overrides.overrideIdentifiers = existingOverrides.identifiers;
          }
        }
        const path7 = overrides?.overrideIdentifiers?.length ? [$Au(overrides.overrideIdentifiers), key] : [key];
        await this.j.write(path7, value);
        await this.reloadConfiguration();
      }
      inspect(key, overrides = {}) {
        return this.a.inspect(key, overrides, void 0);
      }
      keys() {
        return this.a.keys(void 0);
      }
      async reloadConfiguration() {
        const configurationModel = await this.f.loadConfiguration();
        this.r(configurationModel);
      }
      r(userConfigurationModel) {
        const previous = this.a.toData();
        const change = this.a.compareAndUpdateLocalUserConfiguration(userConfigurationModel);
        this.u(
          change,
          previous,
          2
          /* ConfigurationTarget.USER */
        );
      }
      s(defaultConfigurationModel, properties) {
        const previous = this.a.toData();
        const change = this.a.compareAndUpdateDefaultConfiguration(defaultConfigurationModel, properties);
        this.u(
          change,
          previous,
          7
          /* ConfigurationTarget.DEFAULT */
        );
      }
      t(policyConfiguration) {
        const previous = this.a.toData();
        const change = this.a.compareAndUpdatePolicyConfiguration(policyConfiguration);
        this.u(
          change,
          previous,
          7
          /* ConfigurationTarget.DEFAULT */
        );
      }
      u(configurationChange, previous, source) {
        const event = new $SC(configurationChange, { data: previous }, this.a, void 0, this.n);
        event.source = source;
        this.h.fire(event);
      }
    };
    ConfigurationEditing = class {
      constructor(b, c, d) {
        this.b = b;
        this.c = c;
        this.d = d;
        this.a = new $ki();
      }
      write(path7, value) {
        return this.a.queue(() => this.e(path7, value));
      }
      async e(path7, value) {
        let content;
        try {
          const fileContent = await this.c.readFile(this.b);
          content = fileContent.value.toString();
        } catch (error) {
          if (error.fileOperationResult === 1) {
            content = "{}";
          } else {
            throw error;
          }
        }
        const parseErrors = [];
        $fx(content, parseErrors, { allowTrailingComma: true, allowEmptyContent: true });
        if (parseErrors.length > 0) {
          throw new Error("Unable to write into the settings file. Please open the file to correct errors/warnings in the file and try again.");
        }
        const edits = this.f(content, path7, value);
        content = $Hx(content, edits);
        await this.c.writeFile(this.b, $Wi.fromString(content));
      }
      f(content, path7, value) {
        const { tabSize, insertSpaces, eol } = this.h;
        if (!path7.length) {
          const content2 = JSON.stringify(value, null, insertSpaces ? " ".repeat(tabSize) : "	");
          return [{
            content: content2,
            length: content2.length,
            offset: 0
          }];
        }
        return $Ex(content, path7, value, { tabSize, insertSpaces, eol });
      }
      get h() {
        if (!this.g) {
          let eol = OS === 3 || OS === 2 ? "\n" : "\r\n";
          const configuredEol = this.d.getValue("files.eol", { overrideIdentifier: "jsonc" });
          if (configuredEol && typeof configuredEol === "string" && configuredEol !== "auto") {
            eol = configuredEol;
          }
          this.g = {
            eol,
            insertSpaces: !!this.d.getValue("editor.insertSpaces", { overrideIdentifier: "jsonc" }),
            tabSize: this.d.getValue("editor.tabSize", { overrideIdentifier: "jsonc" })
          };
        }
        return this.g;
      }
    };
  }
});

// out-build/vs/platform/request/common/request.js
function $Sv(context) {
  return context.res.statusCode && context.res.statusCode >= 200 && context.res.statusCode < 300 || context.res.statusCode === 1223;
}
function $Tv(context) {
  return context.res.statusCode === 204;
}
async function $Uv(context) {
  if ($Tv(context)) {
    return null;
  }
  const buffer = await $9i(context.stream);
  return buffer.toString();
}
async function $Vv(context) {
  if (!$Sv(context)) {
    throw new Error("Server returned " + context.res.statusCode);
  }
  return $Uv(context);
}
async function $Wv(context) {
  if (!$Sv(context)) {
    throw new Error("Server returned " + context.res.statusCode);
  }
  if ($Tv(context)) {
    return null;
  }
  const buffer = await $9i(context.stream);
  const str = buffer.toString();
  try {
    return JSON.parse(str);
  } catch (err) {
    err.message += ":\n" + str;
    throw err;
  }
}
function registerProxyConfigurations(useHostProxy = true, useHostProxyDefault = true) {
  if (previousUseHostProxy === useHostProxy && previousUseHostProxyDefault === useHostProxyDefault) {
    return;
  }
  previousUseHostProxy = useHostProxy;
  previousUseHostProxyDefault = useHostProxyDefault;
  const configurationRegistry3 = $to.as($nu.Configuration);
  const oldProxyConfiguration = proxyConfiguration;
  proxyConfiguration = [
    {
      id: "http",
      order: 15,
      title: localize(2192, null),
      type: "object",
      scope: 2,
      properties: {
        "http.useLocalProxyConfiguration": {
          type: "boolean",
          default: useHostProxyDefault,
          markdownDescription: localize(2193, null),
          restricted: true
        }
      }
    },
    {
      id: "http",
      order: 15,
      title: localize(2194, null),
      type: "object",
      scope: 1,
      properties: {
        "http.electronFetch": {
          type: "boolean",
          default: false,
          description: localize(2195, null),
          restricted: true
        }
      }
    },
    {
      id: "http",
      order: 15,
      title: localize(2196, null),
      type: "object",
      scope: useHostProxy ? 1 : 2,
      properties: {
        "http.proxy": {
          type: "string",
          pattern: "^(https?|socks|socks4a?|socks5h?)://([^:]*(:[^@]*)?@)?([^:]+|\\[[:0-9a-fA-F]+\\])(:\\d+)?/?$|^$",
          markdownDescription: localize(2197, null, "`#http.useLocalProxyConfiguration#`"),
          restricted: true
        },
        "http.proxyStrictSSL": {
          type: "boolean",
          default: true,
          markdownDescription: localize(2198, null, "`#http.useLocalProxyConfiguration#`"),
          restricted: true
        },
        "http.proxyKerberosServicePrincipal": {
          type: "string",
          markdownDescription: localize(2199, null, "`#http.useLocalProxyConfiguration#`"),
          restricted: true
        },
        "http.noProxy": {
          type: "array",
          items: { type: "string" },
          markdownDescription: localize(2200, null, "`#http.useLocalProxyConfiguration#`"),
          restricted: true
        },
        "http.proxyAuthorization": {
          type: ["null", "string"],
          default: null,
          markdownDescription: localize(2201, null, "`#http.useLocalProxyConfiguration#`"),
          restricted: true
        },
        "http.proxySupport": {
          type: "string",
          enum: ["off", "on", "fallback", "override"],
          enumDescriptions: [
            localize(2202, null),
            localize(2203, null),
            localize(2204, null),
            localize(2205, null)
          ],
          default: "override",
          markdownDescription: localize(2206, null, "`#http.useLocalProxyConfiguration#`"),
          restricted: true
        },
        "http.systemCertificates": {
          type: "boolean",
          default: true,
          markdownDescription: localize(2207, null, "`#http.useLocalProxyConfiguration#`"),
          restricted: true
        },
        "http.experimental.systemCertificatesV2": {
          type: "boolean",
          tags: ["experimental"],
          default: false,
          markdownDescription: localize(2208, null, "`#http.useLocalProxyConfiguration#`"),
          restricted: true
        },
        "http.fetchAdditionalSupport": {
          type: "boolean",
          default: true,
          markdownDescription: localize(2209, null, "`#http.useLocalProxyConfiguration#`", "`#http.proxySupport#`", "`#http.systemCertificates#`"),
          restricted: true
        }
      }
    }
  ];
  configurationRegistry3.updateConfigurations({ add: proxyConfiguration, remove: oldProxyConfiguration });
}
var $Qv, LoggableHeaders, $Rv, proxyConfiguration, previousUseHostProxy, previousUseHostProxyDefault;
var init_request = __esm({
  "out-build/vs/platform/request/common/request.js"() {
    "use strict";
    init_buffer();
    init_errors();
    init_lifecycle();
    init_nls2();
    init_configurationRegistry();
    init_instantiation();
    init_platform2();
    $Qv = $kl("requestService");
    LoggableHeaders = class {
      constructor(b) {
        this.b = b;
      }
      toJSON() {
        if (!this.a) {
          const headers = /* @__PURE__ */ Object.create(null);
          for (const key in this.b) {
            if (key.toLowerCase() === "authorization" || key.toLowerCase() === "proxy-authorization") {
              headers[key] = "*****";
            } else {
              headers[key] = this.b[key];
            }
          }
          this.a = headers;
        }
        return this.a;
      }
    };
    $Rv = class extends $sd {
      constructor(b) {
        super();
        this.b = b;
        this.a = 0;
      }
      async c(options2, request2) {
        const prefix = `#${++this.a}: ${options2.url}`;
        this.b.trace(`${prefix} - begin`, options2.type, new LoggableHeaders(options2.headers ?? {}));
        try {
          const result = await request2();
          this.b.trace(`${prefix} - end`, options2.type, result.res.statusCode, result.res.headers);
          return result;
        } catch (error) {
          this.b.error(`${prefix} - error`, options2.type, $qb(error));
          throw error;
        }
      }
    };
    proxyConfiguration = [];
    previousUseHostProxy = void 0;
    previousUseHostProxyDefault = void 0;
    registerProxyConfigurations();
  }
});

// out-build/vs/platform/environment/common/environment.js
var $rl, $sl;
var init_environment = __esm({
  "out-build/vs/platform/environment/common/environment.js"() {
    "use strict";
    init_instantiation();
    $rl = $kl("environmentService");
    $sl = $ll($rl);
  }
});

// out-build/vs/base/common/uuid.js
function $5s(value) {
  return _UUIDPattern.test(value);
}
var _UUIDPattern, $6s;
var init_uuid = __esm({
  "out-build/vs/base/common/uuid.js"() {
    "use strict";
    _UUIDPattern = /^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i;
    $6s = function() {
      if (typeof crypto.randomUUID === "function") {
        return crypto.randomUUID.bind(crypto);
      }
      const _data = new Uint8Array(16);
      const _hex = [];
      for (let i = 0; i < 256; i++) {
        _hex.push(i.toString(16).padStart(2, "0"));
      }
      return function generateUuid() {
        crypto.getRandomValues(_data);
        _data[6] = _data[6] & 15 | 64;
        _data[8] = _data[8] & 63 | 128;
        let i = 0;
        let result = "";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += "-";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += "-";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += "-";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += "-";
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        result += _hex[_data[i++]];
        return result;
      };
    }();
  }
});

// out-build/vs/base/common/normalization.js
function $xt(str) {
  return normalize(str, "NFC", nfcCache);
}
function normalize(str, form, normalizedCache) {
  if (!str) {
    return str;
  }
  const cached = normalizedCache.get(str);
  if (cached) {
    return cached;
  }
  let res;
  if (nonAsciiCharactersPattern.test(str)) {
    res = str.normalize(form);
  } else {
    res = str;
  }
  normalizedCache.set(str, res);
  return res;
}
var nfcCache, nfdCache, nonAsciiCharactersPattern;
var init_normalization = __esm({
  "out-build/vs/base/common/normalization.js"() {
    "use strict";
    init_map();
    nfcCache = new $Ic(1e4);
    nfdCache = new $Ic(1e4);
    nonAsciiCharactersPattern = /[^\u0000-\u0080]/;
  }
});

// out-build/vs/base/node/pfs.js
import * as fs4 from "fs";
import { tmpdir } from "os";
import { promisify } from "util";
async function rimraf(path7, mode = RimRafMode.UNLINK, moveToPath) {
  if ($jh(path7)) {
    throw new Error("rimraf - will refuse to recursively delete root");
  }
  if (mode === RimRafMode.UNLINK) {
    return rimrafUnlink(path7);
  }
  return rimrafMove(path7, moveToPath);
}
async function rimrafMove(path7, moveToPath = $oh(tmpdir())) {
  try {
    try {
      await fs4.promises.rename(path7, moveToPath);
    } catch (error) {
      if (error.code === "ENOENT") {
        return;
      }
      return rimrafUnlink(path7);
    }
    rimrafUnlink(moveToPath).catch((error) => {
    });
  } catch (error) {
    if (error.code !== "ENOENT") {
      throw error;
    }
  }
}
async function rimrafUnlink(path7) {
  return fs4.promises.rm(path7, { recursive: true, force: true, maxRetries: 3 });
}
async function readdir(path7, options2) {
  return handleDirectoryChildren(await (options2 ? safeReaddirWithFileTypes(path7) : fs4.promises.readdir(path7)));
}
async function safeReaddirWithFileTypes(path7) {
  try {
    return await fs4.promises.readdir(path7, { withFileTypes: true });
  } catch (error) {
    console.warn("[node.js fs] readdir with filetypes failed with error: ", error);
  }
  const result = [];
  const children = await readdir(path7);
  for (const child of children) {
    let isFile = false;
    let isDirectory = false;
    let isSymbolicLink = false;
    try {
      const lstat = await fs4.promises.lstat($oc(path7, child));
      isFile = lstat.isFile();
      isDirectory = lstat.isDirectory();
      isSymbolicLink = lstat.isSymbolicLink();
    } catch (error) {
      console.warn("[node.js fs] unexpected error from lstat after readdir: ", error);
    }
    result.push({
      name: child,
      isFile: () => isFile,
      isDirectory: () => isDirectory,
      isSymbolicLink: () => isSymbolicLink
    });
  }
  return result;
}
function handleDirectoryChildren(children) {
  return children.map((child) => {
    if (typeof child === "string") {
      return $m ? $xt(child) : child;
    }
    child.name = $m ? $xt(child.name) : child.name;
    return child;
  });
}
async function readDirsInDir(dirPath) {
  const children = await readdir(dirPath);
  const directories = [];
  for (const child of children) {
    if (await SymlinkSupport.existsDirectory($oc(dirPath, child))) {
      directories.push(child);
    }
  }
  return directories;
}
function writeFile2(path7, data, options2) {
  return writeQueues.queueFor(URI.file(path7), () => {
    const ensuredOptions = ensureWriteOptions(options2);
    return new Promise((resolve4, reject) => doWriteFileAndFlush(path7, data, ensuredOptions, (error) => error ? reject(error) : resolve4()));
  }, $Gh);
}
function configureFlushOnWrite(enabled) {
  canFlush = enabled;
}
function doWriteFileAndFlush(path7, data, options2, callback) {
  if (!canFlush) {
    return fs4.writeFile(path7, data, { mode: options2.mode, flag: options2.flag }, callback);
  }
  fs4.open(path7, options2.flag, options2.mode, (openError, fd) => {
    if (openError) {
      return callback(openError);
    }
    fs4.writeFile(fd, data, (writeError) => {
      if (writeError) {
        return fs4.close(fd, () => callback(writeError));
      }
      fs4.fdatasync(fd, (syncError) => {
        if (syncError) {
          console.warn("[node.js fs] fdatasync is now disabled for this session because it failed: ", syncError);
          configureFlushOnWrite(false);
        }
        return fs4.close(fd, (closeError) => callback(closeError));
      });
    });
  });
}
function ensureWriteOptions(options2) {
  if (!options2) {
    return { mode: 438, flag: "w" };
  }
  return {
    mode: typeof options2.mode === "number" ? options2.mode : 438,
    flag: typeof options2.flag === "string" ? options2.flag : "w"
  };
}
async function rename(source, target, windowsRetryTimeout = 6e4) {
  if (source === target) {
    return;
  }
  try {
    if ($l && typeof windowsRetryTimeout === "number") {
      await renameWithRetry(source, target, Date.now(), windowsRetryTimeout);
    } else {
      await fs4.promises.rename(source, target);
    }
  } catch (error) {
    if (source.toLowerCase() !== target.toLowerCase() && error.code === "EXDEV" || source.endsWith(".")) {
      await copy(source, target, {
        preserveSymlinks: false
        /* copying to another device */
      });
      await rimraf(source, RimRafMode.MOVE);
    } else {
      throw error;
    }
  }
}
async function renameWithRetry(source, target, startTime, retryTimeout, attempt = 0) {
  try {
    return await fs4.promises.rename(source, target);
  } catch (error) {
    if (error.code !== "EACCES" && error.code !== "EPERM" && error.code !== "EBUSY") {
      throw error;
    }
    if (Date.now() - startTime >= retryTimeout) {
      console.error(`[node.js fs] rename failed after ${attempt} retries with error: ${error}`);
      throw error;
    }
    if (attempt === 0) {
      let abortRetry = false;
      try {
        const { stat } = await SymlinkSupport.stat(target);
        if (!stat.isFile()) {
          abortRetry = true;
        }
      } catch (error2) {
      }
      if (abortRetry) {
        throw error;
      }
    }
    await $ei(Math.min(100, attempt * 10));
    return renameWithRetry(source, target, startTime, retryTimeout, attempt + 1);
  }
}
async function copy(source, target, options2) {
  return doCopy(source, target, { root: { source, target }, options: options2, handledSourcePaths: /* @__PURE__ */ new Set() });
}
async function doCopy(source, target, payload) {
  if (payload.handledSourcePaths.has(source)) {
    return;
  } else {
    payload.handledSourcePaths.add(source);
  }
  const { stat, symbolicLink } = await SymlinkSupport.stat(source);
  if (symbolicLink) {
    if (payload.options.preserveSymlinks) {
      try {
        return await doCopySymlink(source, target, payload);
      } catch (error) {
      }
    }
    if (symbolicLink.dangling) {
      return;
    }
  }
  if (stat.isDirectory()) {
    return doCopyDirectory(source, target, stat.mode & COPY_MODE_MASK, payload);
  } else {
    return doCopyFile(source, target, stat.mode & COPY_MODE_MASK);
  }
}
async function doCopyDirectory(source, target, mode, payload) {
  await fs4.promises.mkdir(target, { recursive: true, mode });
  const files = await readdir(source);
  for (const file of files) {
    await doCopy($oc(source, file), $oc(target, file), payload);
  }
}
async function doCopyFile(source, target, mode) {
  await fs4.promises.copyFile(source, target);
  await fs4.promises.chmod(target, mode);
}
async function doCopySymlink(source, target, payload) {
  let linkTarget = await fs4.promises.readlink(source);
  if ($fh(linkTarget, payload.root.source, !$n)) {
    linkTarget = $oc(payload.root.target, linkTarget.substr(payload.root.source.length + 1));
  }
  await fs4.promises.symlink(linkTarget, target);
}
var RimRafMode, SymlinkSupport, writeQueues, canFlush, COPY_MODE_MASK, Promises2;
var init_pfs = __esm({
  "out-build/vs/base/node/pfs.js"() {
    "use strict";
    init_async();
    init_extpath();
    init_normalization();
    init_path();
    init_platform();
    init_resources();
    init_uri();
    (function(RimRafMode2) {
      RimRafMode2[RimRafMode2["UNLINK"] = 0] = "UNLINK";
      RimRafMode2[RimRafMode2["MOVE"] = 1] = "MOVE";
    })(RimRafMode || (RimRafMode = {}));
    (function(SymlinkSupport2) {
      async function stat(path7) {
        let lstats;
        try {
          lstats = await fs4.promises.lstat(path7);
          if (!lstats.isSymbolicLink()) {
            return { stat: lstats };
          }
        } catch (error) {
        }
        try {
          const stats = await fs4.promises.stat(path7);
          return { stat: stats, symbolicLink: lstats?.isSymbolicLink() ? { dangling: false } : void 0 };
        } catch (error) {
          if (error.code === "ENOENT" && lstats) {
            return { stat: lstats, symbolicLink: { dangling: true } };
          }
          if ($l && error.code === "EACCES") {
            try {
              const stats = await fs4.promises.stat(await fs4.promises.readlink(path7));
              return { stat: stats, symbolicLink: { dangling: false } };
            } catch (error2) {
              if (error2.code === "ENOENT" && lstats) {
                return { stat: lstats, symbolicLink: { dangling: true } };
              }
              throw error2;
            }
          }
          throw error;
        }
      }
      SymlinkSupport2.stat = stat;
      async function existsFile(path7) {
        try {
          const { stat: stat2, symbolicLink } = await SymlinkSupport2.stat(path7);
          return stat2.isFile() && symbolicLink?.dangling !== true;
        } catch (error) {
        }
        return false;
      }
      SymlinkSupport2.existsFile = existsFile;
      async function existsDirectory(path7) {
        try {
          const { stat: stat2, symbolicLink } = await SymlinkSupport2.stat(path7);
          return stat2.isDirectory() && symbolicLink?.dangling !== true;
        } catch (error) {
        }
        return false;
      }
      SymlinkSupport2.existsDirectory = existsDirectory;
    })(SymlinkSupport || (SymlinkSupport = {}));
    writeQueues = new $mi();
    canFlush = true;
    COPY_MODE_MASK = 511;
    Promises2 = new class {
      //#region Implemented by node.js
      get read() {
        return (fd, buffer, offset, length, position) => {
          return new Promise((resolve4, reject) => {
            fs4.read(fd, buffer, offset, length, position, (err, bytesRead, buffer2) => {
              if (err) {
                return reject(err);
              }
              return resolve4({ bytesRead, buffer: buffer2 });
            });
          });
        };
      }
      get write() {
        return (fd, buffer, offset, length, position) => {
          return new Promise((resolve4, reject) => {
            fs4.write(fd, buffer, offset, length, position, (err, bytesWritten, buffer2) => {
              if (err) {
                return reject(err);
              }
              return resolve4({ bytesWritten, buffer: buffer2 });
            });
          });
        };
      }
      get fdatasync() {
        return promisify(fs4.fdatasync);
      }
      // not exposed as API in 20.x yet
      get open() {
        return promisify(fs4.open);
      }
      // changed to return `FileHandle` in promise API
      get close() {
        return promisify(fs4.close);
      }
      // not exposed as API due to the `FileHandle` return type of `open`
      get realpath() {
        return promisify(fs4.realpath);
      }
      // `fs.promises.realpath` will use `fs.realpath.native` which we do not want
      get ftruncate() {
        return promisify(fs4.ftruncate);
      }
      // not exposed as API in 20.x yet
      //#endregion
      //#region Implemented by us
      async exists(path7) {
        try {
          await fs4.promises.access(path7);
          return true;
        } catch {
          return false;
        }
      }
      get readdir() {
        return readdir;
      }
      get readDirsInDir() {
        return readDirsInDir;
      }
      get writeFile() {
        return writeFile2;
      }
      get rm() {
        return rimraf;
      }
      get rename() {
        return rename;
      }
      get copy() {
        return copy;
      }
    }();
  }
});

// out-build/vs/base/node/powershell.js
import * as os from "os";
function getProgramFilesPath({ useAlternateBitness = false } = {}) {
  if (!useAlternateBitness) {
    return process.env.ProgramFiles || null;
  }
  if (processArch === 0) {
    return process.env["ProgramFiles(x86)"] || null;
  }
  if (osArch === 0) {
    return process.env.ProgramW6432 || null;
  }
  return null;
}
async function findPSCoreWindowsInstallation({ useAlternateBitness = false, findPreview = false } = {}) {
  const programFilesPath = getProgramFilesPath({ useAlternateBitness });
  if (!programFilesPath) {
    return null;
  }
  const powerShellInstallBaseDir = $oc(programFilesPath, "PowerShell");
  if (!await SymlinkSupport.existsDirectory(powerShellInstallBaseDir)) {
    return null;
  }
  let highestSeenVersion = -1;
  let pwshExePath = null;
  for (const item of await Promises2.readdir(powerShellInstallBaseDir)) {
    let currentVersion = -1;
    if (findPreview) {
      const dashIndex = item.indexOf("-");
      if (dashIndex < 0) {
        continue;
      }
      const intPart = item.substring(0, dashIndex);
      if (!IntRegex.test(intPart) || item.substring(dashIndex + 1) !== "preview") {
        continue;
      }
      currentVersion = parseInt(intPart, 10);
    } else {
      if (!IntRegex.test(item)) {
        continue;
      }
      currentVersion = parseInt(item, 10);
    }
    if (currentVersion <= highestSeenVersion) {
      continue;
    }
    const exePath = $oc(powerShellInstallBaseDir, item, "pwsh.exe");
    if (!await SymlinkSupport.existsFile(exePath)) {
      continue;
    }
    pwshExePath = exePath;
    highestSeenVersion = currentVersion;
  }
  if (!pwshExePath) {
    return null;
  }
  const bitness = programFilesPath.includes("x86") ? " (x86)" : "";
  const preview = findPreview ? " Preview" : "";
  return new PossiblePowerShellExe(pwshExePath, `PowerShell${preview}${bitness}`, true);
}
async function findPSCoreMsix({ findPreview } = {}) {
  if (!process.env.LOCALAPPDATA) {
    return null;
  }
  const msixAppDir = $oc(process.env.LOCALAPPDATA, "Microsoft", "WindowsApps");
  if (!await SymlinkSupport.existsDirectory(msixAppDir)) {
    return null;
  }
  const { pwshMsixDirRegex, pwshMsixName } = findPreview ? { pwshMsixDirRegex: PwshPreviewMsixRegex, pwshMsixName: "PowerShell Preview (Store)" } : { pwshMsixDirRegex: PwshMsixRegex, pwshMsixName: "PowerShell (Store)" };
  for (const subdir of await Promises2.readdir(msixAppDir)) {
    if (pwshMsixDirRegex.test(subdir)) {
      const pwshMsixPath = $oc(msixAppDir, subdir, "pwsh.exe");
      return new PossiblePowerShellExe(pwshMsixPath, pwshMsixName);
    }
  }
  return null;
}
function findPSCoreDotnetGlobalTool() {
  const dotnetGlobalToolExePath = $oc(os.homedir(), ".dotnet", "tools", "pwsh.exe");
  return new PossiblePowerShellExe(dotnetGlobalToolExePath, ".NET Core PowerShell Global Tool");
}
function findPSCoreScoopInstallation() {
  const scoopAppsDir = $oc(os.homedir(), "scoop", "apps");
  const scoopPwsh = $oc(scoopAppsDir, "pwsh", "current", "pwsh.exe");
  return new PossiblePowerShellExe(scoopPwsh, "PowerShell (Scoop)");
}
function findWinPS() {
  const winPSPath = $oc(process.env.windir, processArch === 1 && osArch !== 1 ? "SysNative" : "System32", "WindowsPowerShell", "v1.0", "powershell.exe");
  return new PossiblePowerShellExe(winPSPath, "Windows PowerShell", true);
}
async function* enumerateDefaultPowerShellInstallations() {
  let pwshExe = await findPSCoreWindowsInstallation();
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreWindowsInstallation({ useAlternateBitness: true });
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreMsix();
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = findPSCoreDotnetGlobalTool();
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreWindowsInstallation({ findPreview: true });
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreMsix({ findPreview: true });
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreWindowsInstallation({ useAlternateBitness: true, findPreview: true });
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = await findPSCoreScoopInstallation();
  if (pwshExe) {
    yield pwshExe;
  }
  pwshExe = findWinPS();
  if (pwshExe) {
    yield pwshExe;
  }
}
async function* $xy() {
  for await (const defaultPwsh of enumerateDefaultPowerShellInstallations()) {
    if (await defaultPwsh.exists()) {
      yield defaultPwsh;
    }
  }
}
async function $yy() {
  for await (const pwsh of $xy()) {
    return pwsh;
  }
  return null;
}
var IntRegex, PwshMsixRegex, PwshPreviewMsixRegex, Arch, processArch, osArch, PossiblePowerShellExe;
var init_powershell = __esm({
  "out-build/vs/base/node/powershell.js"() {
    "use strict";
    init_path();
    init_pfs();
    IntRegex = /^\d+$/;
    PwshMsixRegex = /^Microsoft.PowerShell_.*/;
    PwshPreviewMsixRegex = /^Microsoft.PowerShellPreview_.*/;
    (function(Arch2) {
      Arch2[Arch2["x64"] = 0] = "x64";
      Arch2[Arch2["x86"] = 1] = "x86";
      Arch2[Arch2["ARM"] = 2] = "ARM";
    })(Arch || (Arch = {}));
    switch (process.arch) {
      case "ia32":
        processArch = 1;
        break;
      case "arm":
      case "arm64":
        processArch = 2;
        break;
      default:
        processArch = 0;
        break;
    }
    if (process.env["PROCESSOR_ARCHITEW6432"]) {
      osArch = process.env["PROCESSOR_ARCHITEW6432"] === "ARM64" ? 2 : 0;
    } else if (process.env["PROCESSOR_ARCHITECTURE"] === "ARM64") {
      osArch = 2;
    } else if (process.env["PROCESSOR_ARCHITECTURE"] === "X86") {
      osArch = 1;
    } else {
      osArch = 0;
    }
    PossiblePowerShellExe = class {
      constructor(exePath, displayName, a) {
        this.exePath = exePath;
        this.displayName = displayName;
        this.a = a;
      }
      async exists() {
        if (this.a === void 0) {
          this.a = await SymlinkSupport.existsFile(this.exePath);
        }
        return this.a;
      }
    };
  }
});

// out-build/vs/base/common/processes.js
function $ly(env2, ...preserve) {
  const set = preserve.reduce((set2, key) => {
    set2[key] = true;
    return set2;
  }, {});
  const keysToRemove = [
    /^ELECTRON_.+$/,
    /^VSCODE_(?!(PORTABLE|SHELL_LOGIN|ENV_REPLACE|ENV_APPEND|ENV_PREPEND)).+$/,
    /^SNAP(|_.*)$/,
    /^GDK_PIXBUF_.+$/
  ];
  const envKeys = Object.keys(env2);
  envKeys.filter((key) => !set[key]).forEach((envKey) => {
    for (let i = 0; i < keysToRemove.length; i++) {
      if (envKey.search(keysToRemove[i]) !== -1) {
        delete env2[envKey];
        break;
      }
    }
  });
}
function $my(env2) {
  if (!env2) {
    return;
  }
  delete env2["DEBUG"];
  if ($n) {
    delete env2["LD_PRELOAD"];
  }
}
var Source, TerminateResponseCode;
var init_processes = __esm({
  "out-build/vs/base/common/processes.js"() {
    "use strict";
    init_platform();
    (function(Source2) {
      Source2[Source2["stdout"] = 0] = "stdout";
      Source2[Source2["stderr"] = 1] = "stderr";
    })(Source || (Source = {}));
    (function(TerminateResponseCode2) {
      TerminateResponseCode2[TerminateResponseCode2["Success"] = 0] = "Success";
      TerminateResponseCode2[TerminateResponseCode2["Unknown"] = 1] = "Unknown";
      TerminateResponseCode2[TerminateResponseCode2["AccessDenied"] = 2] = "AccessDenied";
      TerminateResponseCode2[TerminateResponseCode2["ProcessNotFound"] = 3] = "ProcessNotFound";
    })(TerminateResponseCode || (TerminateResponseCode = {}));
  }
});

// out-build/vs/base/node/processes.js
import { promises as promises4 } from "fs";
function $zy(env2 = env) {
  return env2["comspec"] || "cmd.exe";
}
function $Ay(childProcess) {
  let msgQueue = [];
  let useQueue = false;
  const send = function(msg) {
    if (useQueue) {
      msgQueue.push(msg);
      return;
    }
    const result = childProcess.send(msg, (error) => {
      if (error) {
        console.error(error);
      }
      useQueue = false;
      if (msgQueue.length > 0) {
        const msgQueueCopy = msgQueue.slice(0);
        msgQueue = [];
        msgQueueCopy.forEach((entry) => send(entry));
      }
    });
    if (!result || $l) {
      useQueue = true;
    }
  };
  return { send };
}
async function fileExistsDefault(path7) {
  if (await Promises2.exists(path7)) {
    let statValue;
    try {
      statValue = await promises4.stat(path7);
    } catch (e) {
      if (e.message.startsWith("EACCES")) {
        statValue = await promises4.lstat(path7);
      }
    }
    return statValue ? !statValue.isDirectory() : false;
  }
  return false;
}
async function $By(command, cwd3, paths, env2 = env, fileExists = fileExistsDefault) {
  if ($nc(command)) {
    return await fileExists(command) ? command : void 0;
  }
  if (cwd3 === void 0) {
    cwd3 = cwd();
  }
  const dir = $rc(command);
  if (dir !== ".") {
    const fullPath2 = $oc(cwd3, command);
    return await fileExists(fullPath2) ? fullPath2 : void 0;
  }
  const envPath = $Bw(env2, "PATH");
  if (paths === void 0 && $Wc(envPath)) {
    paths = envPath.split($yc);
  }
  if (paths === void 0 || paths.length === 0) {
    const fullPath2 = $oc(cwd3, command);
    return await fileExists(fullPath2) ? fullPath2 : void 0;
  }
  for (const pathEntry of paths) {
    let fullPath2;
    if ($nc(pathEntry)) {
      fullPath2 = $oc(pathEntry, command);
    } else {
      fullPath2 = $oc(cwd3, pathEntry, command);
    }
    if ($l) {
      const pathExt = $Bw(env2, "PATHEXT") || ".COM;.EXE;.BAT;.CMD";
      const pathExtsFound = pathExt.split(";").map(async (ext) => {
        const withExtension = fullPath2 + ext;
        return await fileExists(withExtension) ? withExtension : void 0;
      });
      for (const foundPromise of pathExtsFound) {
        const found = await foundPromise;
        if (found) {
          return found;
        }
      }
    }
    if (await fileExists(fullPath2)) {
      return fullPath2;
    }
  }
  const fullPath = $oc(cwd3, command);
  return await fileExists(fullPath) ? fullPath : void 0;
}
var init_processes2 = __esm({
  "out-build/vs/base/node/processes.js"() {
    "use strict";
    init_objects();
    init_path();
    init_platform();
    init_process();
    init_processes();
    init_types();
    init_pfs();
  }
});

// out-build/vs/base/node/shell.js
import { userInfo } from "os";
async function $Cy(os7, env2) {
  if (os7 === 1) {
    if ($l) {
      return getSystemShellWindows();
    }
    return $zy(env2);
  }
  return getSystemShellUnixLike(os7, env2);
}
function getSystemShellUnixLike(os7, env2) {
  if ($n && os7 === 2 || $m && os7 === 3) {
    return "/bin/bash";
  }
  if (!_TERMINAL_DEFAULT_SHELL_UNIX_LIKE) {
    let unixLikeTerminal;
    if ($l) {
      unixLikeTerminal = "/bin/bash";
    } else {
      unixLikeTerminal = env2["SHELL"];
      if (!unixLikeTerminal) {
        try {
          unixLikeTerminal = userInfo().shell;
        } catch (err) {
        }
      }
      if (!unixLikeTerminal) {
        unixLikeTerminal = "sh";
      }
      if (unixLikeTerminal === "/bin/false") {
        unixLikeTerminal = "/bin/bash";
      }
    }
    _TERMINAL_DEFAULT_SHELL_UNIX_LIKE = unixLikeTerminal;
  }
  return _TERMINAL_DEFAULT_SHELL_UNIX_LIKE;
}
async function getSystemShellWindows() {
  if (!_TERMINAL_DEFAULT_SHELL_WINDOWS) {
    _TERMINAL_DEFAULT_SHELL_WINDOWS = (await $yy()).exePath;
  }
  return _TERMINAL_DEFAULT_SHELL_WINDOWS;
}
var _TERMINAL_DEFAULT_SHELL_UNIX_LIKE, _TERMINAL_DEFAULT_SHELL_WINDOWS;
var init_shell = __esm({
  "out-build/vs/base/node/shell.js"() {
    "use strict";
    init_platform();
    init_powershell();
    init_processes2();
    _TERMINAL_DEFAULT_SHELL_UNIX_LIKE = null;
    _TERMINAL_DEFAULT_SHELL_WINDOWS = null;
  }
});

// out-build/vs/platform/environment/node/argv.js
function $2t(args, options2, errorReporter2 = ignoringReporter) {
  const firstArg = args.find((a) => a.length > 0 && a[0] !== "-");
  const alias = {};
  const stringOptions = ["_"];
  const booleanOptions = [];
  const globalOptions = {};
  let command = void 0;
  for (const optionId in options2) {
    const o = options2[optionId];
    if (o.type === "subcommand") {
      if (optionId === firstArg) {
        command = o;
      }
    } else {
      if (o.alias) {
        alias[optionId] = o.alias;
      }
      if (o.type === "string" || o.type === "string[]") {
        stringOptions.push(optionId);
        if (o.deprecates) {
          stringOptions.push(...o.deprecates);
        }
      } else if (o.type === "boolean") {
        booleanOptions.push(optionId);
        if (o.deprecates) {
          booleanOptions.push(...o.deprecates);
        }
      }
      if (o.global) {
        globalOptions[optionId] = o;
      }
    }
  }
  if (command && firstArg) {
    const options3 = globalOptions;
    for (const optionId in command.options) {
      options3[optionId] = command.options[optionId];
    }
    const newArgs = args.filter((a) => a !== firstArg);
    const reporter = errorReporter2.getSubcommandReporter ? errorReporter2.getSubcommandReporter(firstArg) : void 0;
    const subcommandOptions = $2t(newArgs, options3, reporter);
    return {
      [firstArg]: subcommandOptions,
      _: []
    };
  }
  const parsedArgs2 = (0, import_minimist.default)(args, { string: stringOptions, boolean: booleanOptions, alias });
  const cleanedArgs = {};
  const remainingArgs = parsedArgs2;
  cleanedArgs._ = parsedArgs2._.map((arg) => String(arg)).filter((arg) => arg.length > 0);
  delete remainingArgs._;
  for (const optionId in options2) {
    const o = options2[optionId];
    if (o.type === "subcommand") {
      continue;
    }
    if (o.alias) {
      delete remainingArgs[o.alias];
    }
    let val = remainingArgs[optionId];
    if (o.deprecates) {
      for (const deprecatedId of o.deprecates) {
        if (remainingArgs.hasOwnProperty(deprecatedId)) {
          if (!val) {
            val = remainingArgs[deprecatedId];
            if (val) {
              errorReporter2.onDeprecatedOption(deprecatedId, o.deprecationMessage || localize(1884, null, optionId));
            }
          }
          delete remainingArgs[deprecatedId];
        }
      }
    }
    if (typeof val !== "undefined") {
      if (o.type === "string[]") {
        if (!Array.isArray(val)) {
          val = [val];
        }
        if (!o.allowEmptyValue) {
          const sanitized = val.filter((v) => v.length > 0);
          if (sanitized.length !== val.length) {
            errorReporter2.onEmptyValue(optionId);
            val = sanitized.length > 0 ? sanitized : void 0;
          }
        }
      } else if (o.type === "string") {
        if (Array.isArray(val)) {
          val = val.pop();
          errorReporter2.onMultipleValues(optionId, val);
        } else if (!val && !o.allowEmptyValue) {
          errorReporter2.onEmptyValue(optionId);
          val = void 0;
        }
      }
      cleanedArgs[optionId] = val;
      if (o.deprecationMessage) {
        errorReporter2.onDeprecatedOption(optionId, o.deprecationMessage);
      }
    }
    delete remainingArgs[optionId];
  }
  for (const key in remainingArgs) {
    errorReporter2.onUnknownOption(key);
  }
  return cleanedArgs;
}
function formatUsage(optionId, option) {
  let args = "";
  if (option.args) {
    if (Array.isArray(option.args)) {
      args = ` <${option.args.join("> <")}>`;
    } else {
      args = ` <${option.args}>`;
    }
  }
  if (option.alias) {
    return `-${option.alias} --${optionId}${args}`;
  }
  return `--${optionId}${args}`;
}
function $3t(options2, columns) {
  const usageTexts = [];
  for (const optionId in options2) {
    const o = options2[optionId];
    const usageText = formatUsage(optionId, o);
    usageTexts.push([usageText, o.description]);
  }
  return formatUsageTexts(usageTexts, columns);
}
function formatUsageTexts(usageTexts, columns) {
  const maxLength = usageTexts.reduce((previous, e) => Math.max(previous, e[0].length), 12);
  const argLength = maxLength + 2 + 1;
  if (columns - argLength < 25) {
    return usageTexts.reduce((r, ut) => r.concat([`  ${ut[0]}`, `      ${ut[1]}`]), []);
  }
  const descriptionColumns = columns - argLength - 1;
  const result = [];
  for (const ut of usageTexts) {
    const usage = ut[0];
    const wrappedDescription = wrapText(ut[1], descriptionColumns);
    const keyPadding = indent(
      argLength - usage.length - 2
      /*left padding*/
    );
    result.push("  " + usage + keyPadding + wrappedDescription[0]);
    for (let i = 1; i < wrappedDescription.length; i++) {
      result.push(indent(argLength) + wrappedDescription[i]);
    }
  }
  return result;
}
function indent(count) {
  return " ".repeat(count);
}
function wrapText(text, columns) {
  const lines = [];
  while (text.length) {
    let index = text.length < columns ? text.length : text.lastIndexOf(" ", columns);
    if (index === 0) {
      index = columns;
    }
    const line = text.slice(0, index).trim();
    text = text.slice(index).trimStart();
    lines.push(line);
  }
  return lines;
}
function $4t(productName, executableName, version, options2, capabilities) {
  const columns = process.stdout.isTTY && process.stdout.columns || 80;
  const inputFiles = capabilities?.noInputFiles !== true ? `[${localize(1885, null)}...]` : "";
  const help = [`${productName} ${version}`];
  help.push("");
  help.push(`${localize(1886, null)}: ${executableName} [${localize(1887, null)}]${inputFiles}`);
  help.push("");
  if (capabilities?.noPipe !== true) {
    if ($l) {
      help.push(localize(1888, null, executableName));
    } else {
      help.push(localize(1889, null, executableName));
    }
    help.push("");
  }
  const optionsByCategory = {};
  const subcommands = [];
  for (const optionId in options2) {
    const o = options2[optionId];
    if (o.type === "subcommand") {
      if (o.description) {
        subcommands.push({ command: optionId, description: o.description });
      }
    } else if (o.description && o.cat) {
      let optionsByCat = optionsByCategory[o.cat];
      if (!optionsByCat) {
        optionsByCategory[o.cat] = optionsByCat = {};
      }
      optionsByCat[optionId] = o;
    }
  }
  for (const helpCategoryKey in optionsByCategory) {
    const key = helpCategoryKey;
    const categoryOptions = optionsByCategory[key];
    if (categoryOptions) {
      help.push(helpCategories[key]);
      help.push(...$3t(categoryOptions, columns));
      help.push("");
    }
  }
  if (subcommands.length) {
    help.push(localize(1890, null));
    help.push(...formatUsageTexts(subcommands.map((s) => [s.command, s.description]), columns));
    help.push("");
  }
  return help.join("\n");
}
function $5t(version, commit) {
  return `${version || localize(1891, null)}
${commit || localize(1892, null)}
${process.arch}`;
}
var import_minimist, helpCategories, $1t, ignoringReporter;
var init_argv = __esm({
  "out-build/vs/platform/environment/node/argv.js"() {
    "use strict";
    import_minimist = __toESM(require_minimist(), 1);
    init_platform();
    init_nls2();
    helpCategories = {
      o: localize(1842, null),
      e: localize(1843, null),
      t: localize(1844, null)
    };
    $1t = {
      "tunnel": {
        type: "subcommand",
        description: "Make the current machine accessible from vscode.dev or other machines through a secure tunnel",
        options: {
          "cli-data-dir": { type: "string", args: "dir", description: localize(1845, null) },
          "disable-telemetry": { type: "boolean" },
          "telemetry-level": { type: "string" },
          user: {
            type: "subcommand",
            options: {
              login: {
                type: "subcommand",
                options: {
                  provider: { type: "string" },
                  "access-token": { type: "string" }
                }
              }
            }
          }
        }
      },
      "serve-web": {
        type: "subcommand",
        description: "Run a server that displays the editor UI in browsers.",
        options: {
          "cli-data-dir": { type: "string", args: "dir", description: localize(1846, null) },
          "disable-telemetry": { type: "boolean" },
          "telemetry-level": { type: "string" }
        }
      },
      "diff": { type: "boolean", cat: "o", alias: "d", args: ["file", "file"], description: localize(1847, null) },
      "merge": { type: "boolean", cat: "o", alias: "m", args: ["path1", "path2", "base", "result"], description: localize(1848, null) },
      "add": { type: "boolean", cat: "o", alias: "a", args: "folder", description: localize(1849, null) },
      "remove": { type: "boolean", cat: "o", args: "folder", description: localize(1850, null) },
      "goto": { type: "boolean", cat: "o", alias: "g", args: "file:line[:character]", description: localize(1851, null) },
      "new-window": { type: "boolean", cat: "o", alias: "n", description: localize(1852, null) },
      "reuse-window": { type: "boolean", cat: "o", alias: "r", description: localize(1853, null) },
      "wait": { type: "boolean", cat: "o", alias: "w", description: localize(1854, null) },
      "waitMarkerFilePath": { type: "string" },
      "locale": { type: "string", cat: "o", args: "locale", description: localize(1855, null) },
      "user-data-dir": { type: "string", cat: "o", args: "dir", description: localize(1856, null) },
      "profile": { type: "string", "cat": "o", args: "profileName", description: localize(1857, null) },
      "help": { type: "boolean", cat: "o", alias: "h", description: localize(1858, null) },
      "extensions-dir": { type: "string", deprecates: ["extensionHomePath"], cat: "e", args: "dir", description: localize(1859, null) },
      "extensions-download-dir": { type: "string" },
      "builtin-extensions-dir": { type: "string" },
      "list-extensions": { type: "boolean", cat: "e", description: localize(1860, null) },
      "show-versions": { type: "boolean", cat: "e", description: localize(1861, null) },
      "category": { type: "string", allowEmptyValue: true, cat: "e", description: localize(1862, null), args: "category" },
      "install-extension": { type: "string[]", cat: "e", args: "ext-id | path", description: localize(1863, null) },
      "pre-release": { type: "boolean", cat: "e", description: localize(1864, null) },
      "uninstall-extension": { type: "string[]", cat: "e", args: "ext-id", description: localize(1865, null) },
      "update-extensions": { type: "boolean", cat: "e", description: localize(1866, null) },
      "enable-proposed-api": { type: "string[]", allowEmptyValue: true, cat: "e", args: "ext-id", description: localize(1867, null) },
      "add-mcp": { type: "string[]", cat: "o", args: "json", description: localize(1868, null) },
      "version": { type: "boolean", cat: "t", alias: "v", description: localize(1869, null) },
      "verbose": { type: "boolean", cat: "t", global: true, description: localize(1870, null) },
      "log": { type: "string[]", cat: "t", args: "level", global: true, description: localize(1871, null) },
      "status": { type: "boolean", alias: "s", cat: "t", description: localize(1872, null) },
      "prof-startup": { type: "boolean", cat: "t", description: localize(1873, null) },
      "prof-append-timers": { type: "string" },
      "prof-duration-markers": { type: "string[]" },
      "prof-duration-markers-file": { type: "string" },
      "no-cached-data": { type: "boolean" },
      "prof-startup-prefix": { type: "string" },
      "prof-v8-extensions": { type: "boolean" },
      "disable-extensions": { type: "boolean", deprecates: ["disableExtensions"], cat: "t", description: localize(1874, null) },
      "disable-extension": { type: "string[]", cat: "t", args: "ext-id", description: localize(1875, null) },
      "sync": { type: "string", cat: "t", description: localize(1876, null), args: ["on | off"] },
      "inspect-extensions": { type: "string", allowEmptyValue: true, deprecates: ["debugPluginHost"], args: "port", cat: "t", description: localize(1877, null) },
      "inspect-brk-extensions": { type: "string", allowEmptyValue: true, deprecates: ["debugBrkPluginHost"], args: "port", cat: "t", description: localize(1878, null) },
      "disable-lcd-text": { type: "boolean", cat: "t", description: localize(1879, null) },
      "disable-gpu": { type: "boolean", cat: "t", description: localize(1880, null) },
      "disable-chromium-sandbox": { type: "boolean", cat: "t", description: localize(1881, null) },
      "sandbox": { type: "boolean" },
      "locate-shell-integration-path": { type: "string", cat: "t", args: ["shell"], description: localize(1882, null) },
      "telemetry": { type: "boolean", cat: "t", description: localize(1883, null) },
      "remote": { type: "string", allowEmptyValue: true },
      "folder-uri": { type: "string[]", cat: "o", args: "uri" },
      "file-uri": { type: "string[]", cat: "o", args: "uri" },
      "locate-extension": { type: "string[]" },
      "extensionDevelopmentPath": { type: "string[]" },
      "extensionDevelopmentKind": { type: "string[]" },
      "extensionTestsPath": { type: "string" },
      "extensionEnvironment": { type: "string" },
      "debugId": { type: "string" },
      "debugRenderer": { type: "boolean" },
      "inspect-ptyhost": { type: "string", allowEmptyValue: true },
      "inspect-brk-ptyhost": { type: "string", allowEmptyValue: true },
      "inspect-search": { type: "string", deprecates: ["debugSearch"], allowEmptyValue: true },
      "inspect-brk-search": { type: "string", deprecates: ["debugBrkSearch"], allowEmptyValue: true },
      "inspect-sharedprocess": { type: "string", allowEmptyValue: true },
      "inspect-brk-sharedprocess": { type: "string", allowEmptyValue: true },
      "export-default-configuration": { type: "string" },
      "install-source": { type: "string" },
      "enable-smoke-test-driver": { type: "boolean" },
      "logExtensionHostCommunication": { type: "boolean" },
      "skip-release-notes": { type: "boolean" },
      "skip-welcome": { type: "boolean" },
      "disable-telemetry": { type: "boolean" },
      "disable-updates": { type: "boolean" },
      "use-inmemory-secretstorage": { type: "boolean", deprecates: ["disable-keytar"] },
      "password-store": { type: "string" },
      "disable-workspace-trust": { type: "boolean" },
      "disable-crash-reporter": { type: "boolean" },
      "crash-reporter-directory": { type: "string" },
      "crash-reporter-id": { type: "string" },
      "skip-add-to-recently-opened": { type: "boolean" },
      "open-url": { type: "boolean" },
      "file-write": { type: "boolean" },
      "file-chmod": { type: "boolean" },
      "install-builtin-extension": { type: "string[]" },
      "force": { type: "boolean" },
      "do-not-sync": { type: "boolean" },
      "do-not-include-pack-dependencies": { type: "boolean" },
      "trace": { type: "boolean" },
      "trace-memory-infra": { type: "boolean" },
      "trace-category-filter": { type: "string" },
      "trace-options": { type: "string" },
      "preserve-env": { type: "boolean" },
      "force-user-env": { type: "boolean" },
      "force-disable-user-env": { type: "boolean" },
      "open-devtools": { type: "boolean" },
      "disable-gpu-sandbox": { type: "boolean" },
      "logsPath": { type: "string" },
      "__enable-file-policy": { type: "boolean" },
      "editSessionId": { type: "string" },
      "continueOn": { type: "string" },
      "enable-coi": { type: "boolean" },
      "unresponsive-sample-interval": { type: "string" },
      "unresponsive-sample-period": { type: "string" },
      // chromium flags
      "no-proxy-server": { type: "boolean" },
      // Minimist incorrectly parses keys that start with `--no`
      // https://github.com/substack/minimist/blob/aeb3e27dae0412de5c0494e9563a5f10c82cc7a9/index.js#L118-L121
      // If --no-sandbox is passed via cli wrapper it will be treated as --sandbox which is incorrect, we use
      // the alias here to make sure --no-sandbox is always respected.
      // For https://github.com/microsoft/vscode/issues/128279
      "no-sandbox": { type: "boolean", alias: "sandbox" },
      "proxy-server": { type: "string" },
      "proxy-bypass-list": { type: "string" },
      "proxy-pac-url": { type: "string" },
      "js-flags": { type: "string" },
      // chrome js flags
      "inspect": { type: "string", allowEmptyValue: true },
      "inspect-brk": { type: "string", allowEmptyValue: true },
      "nolazy": { type: "boolean" },
      // node inspect
      "force-device-scale-factor": { type: "string" },
      "force-renderer-accessibility": { type: "boolean" },
      "ignore-certificate-errors": { type: "boolean" },
      "allow-insecure-localhost": { type: "boolean" },
      "log-net-log": { type: "string" },
      "vmodule": { type: "string" },
      "_urls": { type: "string[]" },
      "disable-dev-shm-usage": { type: "boolean" },
      "profile-temp": { type: "boolean" },
      "ozone-platform": { type: "string" },
      "enable-tracing": { type: "string" },
      "trace-startup-format": { type: "string" },
      "trace-startup-file": { type: "string" },
      "trace-startup-duration": { type: "string" },
      "xdg-portal-required-version": { type: "string" },
      _: { type: "string[]" }
      // main arguments
    };
    ignoringReporter = {
      onUnknownOption: () => {
      },
      onMultipleValues: () => {
      },
      onEmptyValue: () => {
      },
      onDeprecatedOption: () => {
      }
    };
  }
});

// out-build/vs/platform/environment/node/argvHelper.js
import assert from "assert";
function $9t(env2) {
  return env2["VSCODE_CLI"] === "1";
}
var init_argvHelper = __esm({
  "out-build/vs/platform/environment/node/argvHelper.js"() {
    "use strict";
    init_nls2();
    init_argv();
  }
});

// out-build/vs/base/common/numbers.js
function $lj(value, min, max) {
  return Math.min(Math.max(value, min), max);
}
var init_numbers = __esm({
  "out-build/vs/base/common/numbers.js"() {
    "use strict";
    init_assert();
  }
});

// out-build/vs/platform/shell/node/shellEnv.js
import { spawn } from "child_process";
async function $Dy(configurationService, logService, args, env2) {
  if (args["force-disable-user-env"]) {
    logService.trace("resolveShellEnv(): skipped (--force-disable-user-env)");
    return {};
  } else if ($l) {
    logService.trace("resolveShellEnv(): skipped (Windows)");
    return {};
  } else if ($9t(env2) && !args["force-user-env"]) {
    logService.trace("resolveShellEnv(): skipped (VSCODE_CLI is set)");
    return {};
  } else {
    if ($9t(env2)) {
      logService.trace("resolveShellEnv(): running (--force-user-env)");
    } else {
      logService.trace("resolveShellEnv(): running (macOS/Linux)");
    }
    if (!unixShellEnvPromise) {
      unixShellEnvPromise = Promises.withAsyncBody(async (resolve4, reject) => {
        const cts = new $Dd();
        let timeoutValue = 1e4;
        const configuredTimeoutValue = configurationService.getValue("application.shellEnvironmentResolutionTimeout");
        if (typeof configuredTimeoutValue === "number") {
          timeoutValue = $lj(configuredTimeoutValue, 1, 120) * 1e3;
        }
        const timeout = setTimeout(() => {
          cts.dispose(true);
          reject(new Error(localize(2210, null)));
        }, timeoutValue);
        try {
          resolve4(await doResolveUnixShellEnv(logService, cts.token));
        } catch (error) {
          if (!$kb(error) && !cts.token.isCancellationRequested) {
            reject(new Error(localize(2211, null, $wn(error))));
          } else {
            resolve4({});
          }
        } finally {
          clearTimeout(timeout);
          cts.dispose();
        }
      });
    }
    return unixShellEnvPromise;
  }
}
async function doResolveUnixShellEnv(logService, token) {
  const runAsNode = process.env["ELECTRON_RUN_AS_NODE"];
  logService.trace("getUnixShellEnvironment#runAsNode", runAsNode);
  const noAttach = process.env["ELECTRON_NO_ATTACH_CONSOLE"];
  logService.trace("getUnixShellEnvironment#noAttach", noAttach);
  const mark = $6s().replace(/-/g, "").substr(0, 12);
  const regex = new RegExp(mark + "({.*})" + mark);
  const env2 = {
    ...process.env,
    ELECTRON_RUN_AS_NODE: "1",
    ELECTRON_NO_ATTACH_CONSOLE: "1",
    VSCODE_RESOLVING_ENVIRONMENT: "1"
  };
  logService.trace("getUnixShellEnvironment#env", env2);
  const systemShellUnix = await $Cy(OS, env2);
  logService.trace("getUnixShellEnvironment#shell", systemShellUnix);
  return new Promise((resolve4, reject) => {
    if (token.isCancellationRequested) {
      return reject(new $lb());
    }
    const name = $sc(systemShellUnix);
    let command, shellArgs;
    const extraArgs = "";
    if (/^(?:pwsh|powershell)(?:-preview)?$/.test(name)) {
      command = `& '${process.execPath}' ${extraArgs} -p '''${mark}'' + JSON.stringify(process.env) + ''${mark}'''`;
      shellArgs = ["-Login", "-Command"];
    } else if (name === "nu") {
      command = `^'${process.execPath}' ${extraArgs} -p '"${mark}" + JSON.stringify(process.env) + "${mark}"'`;
      shellArgs = ["-i", "-l", "-c"];
    } else if (name === "xonsh") {
      command = `import os, json; print("${mark}", json.dumps(dict(os.environ)), "${mark}")`;
      shellArgs = ["-i", "-l", "-c"];
    } else {
      command = `'${process.execPath}' ${extraArgs} -p '"${mark}" + JSON.stringify(process.env) + "${mark}"'`;
      if (name === "tcsh" || name === "csh") {
        shellArgs = ["-ic"];
      } else {
        shellArgs = ["-i", "-l", "-c"];
      }
    }
    logService.trace("getUnixShellEnvironment#spawn", JSON.stringify(shellArgs), command);
    const child = spawn(systemShellUnix, [...shellArgs, command], {
      detached: true,
      stdio: ["ignore", "pipe", "pipe"],
      env: env2
    });
    token.onCancellationRequested(() => {
      child.kill();
      return reject(new $lb());
    });
    child.on("error", (err) => {
      logService.error("getUnixShellEnvironment#errorChildProcess", $wn(err));
      reject(err);
    });
    const buffers = [];
    child.stdout.on("data", (b) => buffers.push(b));
    const stderr = [];
    child.stderr.on("data", (b) => stderr.push(b));
    child.on("close", (code, signal) => {
      const raw = Buffer.concat(buffers).toString("utf8");
      logService.trace("getUnixShellEnvironment#raw", raw);
      const stderrStr = Buffer.concat(stderr).toString("utf8");
      if (stderrStr.trim()) {
        logService.trace("getUnixShellEnvironment#stderr", stderrStr);
      }
      if (code || signal) {
        return reject(new Error(localize(2212, null, code, signal)));
      }
      const match = regex.exec(raw);
      const rawStripped = match ? match[1] : "{}";
      try {
        const env3 = JSON.parse(rawStripped);
        if (runAsNode) {
          env3["ELECTRON_RUN_AS_NODE"] = runAsNode;
        } else {
          delete env3["ELECTRON_RUN_AS_NODE"];
        }
        if (noAttach) {
          env3["ELECTRON_NO_ATTACH_CONSOLE"] = noAttach;
        } else {
          delete env3["ELECTRON_NO_ATTACH_CONSOLE"];
        }
        delete env3["VSCODE_RESOLVING_ENVIRONMENT"];
        delete env3["XDG_RUNTIME_DIR"];
        logService.trace("getUnixShellEnvironment#result", env3);
        resolve4(env3);
      } catch (err) {
        logService.error("getUnixShellEnvironment#errorCaught", $wn(err));
        reject(err);
      }
    });
  });
}
var unixShellEnvPromise;
var init_shellEnv = __esm({
  "out-build/vs/platform/shell/node/shellEnv.js"() {
    "use strict";
    init_path();
    init_nls2();
    init_cancellation();
    init_errorMessage();
    init_errors();
    init_platform();
    init_uuid();
    init_shell();
    init_argvHelper();
    init_async();
    init_numbers();
    unixShellEnvPromise = void 0;
  }
});

// out-build/vs/platform/request/node/proxy.js
import { parse as parseUrl } from "url";
function getSystemProxyURI(requestURL, env2) {
  if (requestURL.protocol === "http:") {
    return env2.HTTP_PROXY || env2.http_proxy || null;
  } else if (requestURL.protocol === "https:") {
    return env2.HTTPS_PROXY || env2.https_proxy || env2.HTTP_PROXY || env2.http_proxy || null;
  }
  return null;
}
async function $ED(rawRequestURL, env2, options2 = {}) {
  const requestURL = parseUrl(rawRequestURL);
  const proxyURL = options2.proxyUrl || getSystemProxyURI(requestURL, env2);
  if (!proxyURL) {
    return null;
  }
  const proxyEndpoint = parseUrl(proxyURL);
  if (!/^https?:$/.test(proxyEndpoint.protocol || "")) {
    return null;
  }
  const opts = {
    host: proxyEndpoint.hostname || "",
    port: (proxyEndpoint.port ? +proxyEndpoint.port : 0) || (proxyEndpoint.protocol === "https" ? 443 : 80),
    auth: proxyEndpoint.auth,
    rejectUnauthorized: $3c(options2.strictSSL) ? options2.strictSSL : true
  };
  if (requestURL.protocol === "http:") {
    const { default: mod } = await import("http-proxy-agent");
    return new mod.HttpProxyAgent(proxyURL, opts);
  } else {
    const { default: mod } = await import("https-proxy-agent");
    return new mod.HttpsProxyAgent(proxyURL, opts);
  }
}
var init_proxy = __esm({
  "out-build/vs/platform/request/node/proxy.js"() {
    "use strict";
    init_types();
  }
});

// out-build/vs/platform/request/node/requestService.js
import { parse as parseUrl2 } from "url";
import { createGunzip } from "zlib";
async function $GD(urlStr, spnConfig, logService, logPrefix) {
  const importKerberos = await import("kerberos");
  const kerberos = importKerberos.default || importKerberos;
  const url3 = new URL(urlStr);
  const spn = spnConfig || (process.platform === "win32" ? `HTTP/${url3.hostname}` : `HTTP@${url3.hostname}`);
  logService.debug(`${logPrefix} Kerberos authentication lookup`, `proxyURL:${url3}`, `spn:${spn}`);
  const client = await kerberos.initializeClient(spn);
  return client.step("");
}
async function getNodeRequest(options2) {
  const endpoint = parseUrl2(options2.url);
  const module2 = endpoint.protocol === "https:" ? await import("https") : await import("http");
  return module2.request;
}
async function $HD(options2, token) {
  return Promises.withAsyncBody(async (resolve4, reject) => {
    const endpoint = parseUrl2(options2.url);
    const rawRequest = options2.getRawRequest ? options2.getRawRequest(options2) : await getNodeRequest(options2);
    const opts = {
      hostname: endpoint.hostname,
      port: endpoint.port ? parseInt(endpoint.port) : endpoint.protocol === "https:" ? 443 : 80,
      protocol: endpoint.protocol,
      path: endpoint.path,
      method: options2.type || "GET",
      headers: options2.headers,
      agent: options2.agent,
      rejectUnauthorized: $3c(options2.strictSSL) ? options2.strictSSL : true
    };
    if (options2.user && options2.password) {
      opts.auth = options2.user + ":" + options2.password;
    }
    if (options2.disableCache) {
      opts.cache = "no-store";
    }
    const req = rawRequest(opts, (res) => {
      const followRedirects = $1c(options2.followRedirects) ? options2.followRedirects : 3;
      if (res.statusCode && res.statusCode >= 300 && res.statusCode < 400 && followRedirects > 0 && res.headers["location"]) {
        $HD({
          ...options2,
          url: res.headers["location"],
          followRedirects: followRedirects - 1
        }, token).then(resolve4, reject);
      } else {
        let stream = res;
        if (!options2.isChromiumNetwork && res.headers["content-encoding"] === "gzip") {
          stream = res.pipe(createGunzip());
        }
        resolve4({ res, stream: $_i(stream) });
      }
    });
    req.on("error", reject);
    if (options2.timeout) {
      if (options2.isChromiumNetwork) {
        const timeout = setTimeout(() => {
          req.abort();
          reject(new Error(`Request timeout after ${options2.timeout}ms`));
        }, options2.timeout);
        req.on("response", () => clearTimeout(timeout));
        req.on("error", () => clearTimeout(timeout));
        req.on("abort", () => clearTimeout(timeout));
      } else {
        req.setTimeout(options2.timeout);
      }
    }
    if (options2.isChromiumNetwork) {
      req.removeHeader("Content-Length");
    }
    if (options2.data) {
      if (typeof options2.data === "string") {
        req.write(options2.data);
      }
    }
    req.end();
    token.onCancellationRequested(() => {
      req.abort();
      reject(new $lb());
    });
  });
}
var $FD;
var init_requestService = __esm({
  "out-build/vs/platform/request/node/requestService.js"() {
    "use strict";
    init_async();
    init_buffer();
    init_errors();
    init_types();
    init_configuration();
    init_environment();
    init_shellEnv();
    init_log();
    init_request();
    init_proxy();
    $FD = class $FD2 extends $Rv {
      constructor(m, n, r, logService) {
        super(logService);
        this.m = m;
        this.n = n;
        this.r = r;
        this.s();
        this.B(n.onDidChangeConfiguration((e) => {
          if (e.affectsConfiguration("http")) {
            this.s();
          }
        }));
      }
      s() {
        this.f = this.t("http.proxy");
        this.g = !!this.t("http.proxyStrictSSL");
        this.h = this.t("http.proxyAuthorization");
      }
      async request(options2, token) {
        const { f: proxyUrl, g: strictSSL } = this;
        let shellEnv = void 0;
        try {
          shellEnv = await $Dy(this.n, this.b, this.r.args, process.env);
        } catch (error) {
          if (!this.j) {
            this.j = true;
            this.b.error(`resolving shell environment failed`, $qb(error));
          }
        }
        const env2 = {
          ...process.env,
          ...shellEnv
        };
        const agent = options2.agent ? options2.agent : await $ED(options2.url || "", env2, { proxyUrl, strictSSL });
        options2.agent = agent;
        options2.strictSSL = strictSSL;
        if (this.h) {
          options2.headers = {
            ...options2.headers || {},
            "Proxy-Authorization": this.h
          };
        }
        return this.c(options2, () => $HD(options2, token));
      }
      async resolveProxy(url3) {
        return void 0;
      }
      async lookupAuthorization(authInfo) {
        return void 0;
      }
      async lookupKerberosAuthorization(urlStr) {
        try {
          const spnConfig = this.t("http.proxyKerberosServicePrincipal");
          const response = await $GD(urlStr, spnConfig, this.b, "RequestService#lookupKerberosAuthorization");
          return "Negotiate " + response;
        } catch (err) {
          this.b.debug("RequestService#lookupKerberosAuthorization Kerberos authentication failed", err);
          return void 0;
        }
      }
      async loadCertificates() {
        const proxyAgent = await import("@vscode/proxy-agent");
        return proxyAgent.loadSystemCertificates({ log: this.b });
      }
      t(key) {
        if (this.m === "remote") {
          return this.n.getValue(key);
        }
        const values = this.n.inspect(key);
        return values.userLocalValue || values.defaultValue;
      }
    };
    $FD = __decorate([
      __param(1, $Ql),
      __param(2, $sl),
      __param(3, $5n)
    ], $FD);
  }
});

// out-build/vs/platform/remote/common/remoteHosts.js
function $Ow(authority) {
  if (!authority) {
    return void 0;
  }
  const pos = authority.indexOf("+");
  if (pos < 0) {
    return authority;
  }
  return authority.substr(0, pos);
}
var init_remoteHosts = __esm({
  "out-build/vs/platform/remote/common/remoteHosts.js"() {
    "use strict";
    init_network();
  }
});

// out-build/vs/platform/telemetry/common/commonProperties.js
function getPlatformDetail(hostname2) {
  if ($x === 2 && /^penguin(\.|$)/i.test(hostname2)) {
    return "chromebook";
  }
  return void 0;
}
function $Rw(release4, hostname2, arch2, commit, version, machineId2, sqmId, devDeviceId, isInternalTelemetry, product2) {
  const result = /* @__PURE__ */ Object.create(null);
  result["common.machineId"] = machineId2;
  result["common.sqmId"] = sqmId;
  result["common.devDeviceId"] = devDeviceId;
  result["sessionID"] = $6s() + Date.now();
  result["commitHash"] = commit;
  result["version"] = version;
  result["common.platformVersion"] = (release4 || "").replace(/^(\d+)(\.\d+)?(\.\d+)?(.*)/, "$1$2$3");
  result["common.platform"] = $k($x);
  result["common.nodePlatform"] = $ic;
  result["common.nodeArch"] = arch2;
  result["common.product"] = product2 || "desktop";
  if (isInternalTelemetry) {
    result["common.msftInternal"] = isInternalTelemetry;
  }
  let seq = 0;
  const startTime = Date.now();
  Object.defineProperties(result, {
    // __GDPR__COMMON__ "timestamp" : { "classification": "SystemMetaData", "purpose": "FeatureInsight" }
    "timestamp": {
      get: () => /* @__PURE__ */ new Date(),
      enumerable: true
    },
    // __GDPR__COMMON__ "common.timesincesessionstart" : { "classification": "SystemMetaData", "purpose": "FeatureInsight", "isMeasurement": true }
    "common.timesincesessionstart": {
      get: () => Date.now() - startTime,
      enumerable: true
    },
    // __GDPR__COMMON__ "common.sequence" : { "classification": "SystemMetaData", "purpose": "FeatureInsight", "isMeasurement": true }
    "common.sequence": {
      get: () => seq++,
      enumerable: true
    }
  });
  if ($o) {
    result["common.snap"] = "true";
  }
  const platformDetail = getPlatformDetail(hostname2);
  if (platformDetail) {
    result["common.platformDetail"] = platformDetail;
  }
  return result;
}
function $Sw(domainList) {
  const userDnsDomain = env["USERDNSDOMAIN"];
  if (!userDnsDomain) {
    return false;
  }
  const domain = userDnsDomain.toLowerCase();
  return domainList.some((msftDomain) => domain === msftDomain);
}
var init_commonProperties = __esm({
  "out-build/vs/platform/telemetry/common/commonProperties.js"() {
    "use strict";
    init_platform();
    init_process();
    init_uuid();
  }
});

// out-build/vs/platform/telemetry/common/telemetry.js
var $iw, $jw, $qw, $rw, $sw, $tw, TelemetryLevel, TelemetryConfiguration;
var init_telemetry = __esm({
  "out-build/vs/platform/telemetry/common/telemetry.js"() {
    "use strict";
    init_instantiation();
    $iw = $kl("telemetryService");
    $jw = $kl("customEndpointTelemetryService");
    $qw = "telemetry";
    $rw = "telemetry.telemetryLevel";
    $sw = "telemetry.enableCrashReporter";
    $tw = "telemetry.enableTelemetry";
    (function(TelemetryLevel2) {
      TelemetryLevel2[TelemetryLevel2["NONE"] = 0] = "NONE";
      TelemetryLevel2[TelemetryLevel2["CRASH"] = 1] = "CRASH";
      TelemetryLevel2[TelemetryLevel2["ERROR"] = 2] = "ERROR";
      TelemetryLevel2[TelemetryLevel2["USAGE"] = 3] = "USAGE";
    })(TelemetryLevel || (TelemetryLevel = {}));
    (function(TelemetryConfiguration2) {
      TelemetryConfiguration2["OFF"] = "off";
      TelemetryConfiguration2["CRASH"] = "crash";
      TelemetryConfiguration2["ERROR"] = "error";
      TelemetryConfiguration2["ON"] = "all";
    })(TelemetryConfiguration || (TelemetryConfiguration = {}));
  }
});

// out-build/vs/platform/telemetry/common/telemetryUtils.js
function $1w(productService, environmentService) {
  if (!environmentService.isBuilt && !environmentService.disableTelemetry) {
    return true;
  }
  return !(environmentService.disableTelemetry || !productService.enableTelemetry);
}
function $2w(productService, environmentService) {
  if (environmentService.extensionTestsLocationURI) {
    return true;
  }
  if (environmentService.isBuilt) {
    return false;
  }
  if (environmentService.disableTelemetry) {
    return false;
  }
  if (productService.enableTelemetry && productService.aiConfig?.ariaKey) {
    return false;
  }
  return true;
}
function $3w(configurationService) {
  const newConfig = configurationService.getValue($rw);
  const crashReporterConfig = configurationService.getValue($sw);
  const oldConfig = configurationService.getValue($tw);
  if (oldConfig === false || crashReporterConfig === false) {
    return 0;
  }
  switch (newConfig ?? "all") {
    case "all":
      return 3;
    case "error":
      return 2;
    case "crash":
      return 1;
    case "off":
      return 0;
  }
}
function $4w(data) {
  const properties = {};
  const measurements = {};
  const flat = {};
  flatten(data, flat);
  for (let prop in flat) {
    prop = prop.length > 150 ? prop.substr(prop.length - 149) : prop;
    const value = flat[prop];
    if (typeof value === "number") {
      measurements[prop] = value;
    } else if (typeof value === "boolean") {
      measurements[prop] = value ? 1 : 0;
    } else if (typeof value === "string") {
      if (value.length > 8192) {
        console.warn(`Telemetry property: ${prop} has been trimmed to 8192, the original length is ${value.length}`);
      }
      properties[prop] = value.substring(0, 8191);
    } else if (typeof value !== "undefined" && value !== null) {
      properties[prop] = value;
    }
  }
  return {
    properties,
    measurements
  };
}
function $5w(remoteAuthority) {
  if (!remoteAuthority) {
    return "none";
  }
  const remoteName = $Ow(remoteAuthority);
  return telemetryAllowedAuthorities.has(remoteName) ? remoteName : "other";
}
function flatten(obj, result, order = 0, prefix) {
  if (!obj) {
    return;
  }
  for (const item of Object.getOwnPropertyNames(obj)) {
    const value = obj[item];
    const index = prefix ? prefix + item : item;
    if (Array.isArray(value)) {
      result[index] = $zw(value);
    } else if (value instanceof Date) {
      result[index] = value.toISOString();
    } else if ($Yc(value)) {
      if (order < 2) {
        flatten(value, result, order + 1, index + ".");
      } else {
        result[index] = $zw(value);
      }
    } else {
      result[index] = value;
    }
  }
}
function $6w(productService, configService) {
  const msftInternalDomains = productService.msftInternalDomains || [];
  const internalTesting = configService.getValue("telemetry.internalTesting");
  return $Sw(msftInternalDomains) || internalTesting;
}
function $7w(paths) {
  return [paths.appRoot, paths.extensionsPath, paths.userHome.fsPath, paths.tmpDir.fsPath, paths.userDataPath];
}
function anonymizeFilePaths(stack, cleanupPatterns) {
  if (!stack || !stack.includes("/") && !stack.includes("\\")) {
    return stack;
  }
  let updatedStack = stack;
  const cleanUpIndexes = [];
  for (const regexp of cleanupPatterns) {
    while (true) {
      const result = regexp.exec(stack);
      if (!result) {
        break;
      }
      cleanUpIndexes.push([result.index, regexp.lastIndex]);
    }
  }
  const nodeModulesRegex = /^[\\\/]?(node_modules|node_modules\.asar)[\\\/]/;
  const fileRegex = /(file:\/\/)?([a-zA-Z]:(\\\\|\\|\/)|(\\\\|\\|\/))?([\w-\._]+(\\\\|\\|\/))+[\w-\._]*/g;
  let lastIndex = 0;
  updatedStack = "";
  while (true) {
    const result = fileRegex.exec(stack);
    if (!result) {
      break;
    }
    const overlappingRange = cleanUpIndexes.some(([start, end]) => result.index < end && start < fileRegex.lastIndex);
    if (!nodeModulesRegex.test(result[0]) && !overlappingRange) {
      updatedStack += stack.substring(lastIndex, result.index) + "<REDACTED: user-file-path>";
      lastIndex = fileRegex.lastIndex;
    }
  }
  if (lastIndex < stack.length) {
    updatedStack += stack.substr(lastIndex);
  }
  return updatedStack;
}
function removePropertiesWithPossibleUserInfo(property) {
  if (!property) {
    return property;
  }
  const userDataRegexes = [
    { label: "Google API Key", regex: /AIza[A-Za-z0-9_\\\-]{35}/ },
    { label: "Slack Token", regex: /xox[pbar]\-[A-Za-z0-9]/ },
    { label: "GitHub Token", regex: /(gh[psuro]_[a-zA-Z0-9]{36}|github_pat_[a-zA-Z0-9]{22}_[a-zA-Z0-9]{59})/ },
    { label: "Generic Secret", regex: /(key|token|sig|secret|signature|password|passwd|pwd|android:value)[^a-zA-Z0-9]/i },
    { label: "CLI Credentials", regex: /((login|psexec|(certutil|psexec)\.exe).{1,50}(\s-u(ser(name)?)?\s+.{3,100})?\s-(admin|user|vm|root)?p(ass(word)?)?\s+["']?[^$\-\/\s]|(^|[\s\r\n\\])net(\.exe)?.{1,5}(user\s+|share\s+\/user:| user -? secrets ? set) \s + [^ $\s \/])/ },
    { label: "Microsoft Entra ID", regex: /eyJ(?:0eXAiOiJKV1Qi|hbGci|[a-zA-Z0-9\-_]+\.[a-zA-Z0-9\-_]+\.)/ },
    { label: "Email", regex: /[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}/ }
  ];
  for (const secretRegex of userDataRegexes) {
    if (secretRegex.regex.test(property)) {
      return `<REDACTED: ${secretRegex.label}>`;
    }
  }
  return property;
}
function $8w(data, cleanUpPatterns) {
  return $ww(data, (value) => {
    if (value instanceof $Tw || Object.hasOwnProperty.call(value, "isTrustedTelemetryValue")) {
      return value.value;
    }
    if (typeof value === "string") {
      let updatedProperty = value.replaceAll("%20", " ");
      updatedProperty = anonymizeFilePaths(updatedProperty, cleanUpPatterns);
      for (const regexp of cleanUpPatterns) {
        updatedProperty = updatedProperty.replace(regexp, "");
      }
      updatedProperty = removePropertiesWithPossibleUserInfo(updatedProperty);
      return updatedProperty;
    }
    return void 0;
  });
}
var $Tw, $Uw, $Vw, $Xw, $Yw, $Zw, telemetryAllowedAuthorities;
var init_telemetryUtils = __esm({
  "out-build/vs/platform/telemetry/common/telemetryUtils.js"() {
    "use strict";
    init_objects();
    init_types();
    init_nls2();
    init_remoteHosts();
    init_commonProperties();
    init_telemetry();
    $Tw = class {
      constructor(value) {
        this.value = value;
        this.isTrustedTelemetryValue = true;
      }
    };
    $Uw = class {
      constructor() {
        this.telemetryLevel = 0;
        this.sessionId = "someValue.sessionId";
        this.machineId = "someValue.machineId";
        this.sqmId = "someValue.sqmId";
        this.devDeviceId = "someValue.devDeviceId";
        this.firstSessionDate = "someValue.firstSessionDate";
        this.sendErrorTelemetry = false;
      }
      publicLog() {
      }
      publicLog2() {
      }
      publicLogError() {
      }
      publicLogError2() {
      }
      setExperimentProperty() {
      }
    };
    $Vw = new $Uw();
    $Xw = "telemetry";
    $Yw = { id: $Xw, name: localize(2233, null) };
    $Zw = { log: () => null, flush: () => Promise.resolve(void 0) };
    telemetryAllowedAuthorities = /* @__PURE__ */ new Set(["ssh-remote", "dev-container", "attached-container", "wsl", "tunnel", "codespaces", "amlext"]);
  }
});

// out-build/vs/platform/extensionManagement/common/extensionManagement.js
function $6A(targetPlatform) {
  switch (targetPlatform) {
    case "win32-x64":
      return "Windows 64 bit";
    case "win32-arm64":
      return "Windows ARM";
    case "linux-x64":
      return "Linux 64 bit";
    case "linux-arm64":
      return "Linux ARM 64";
    case "linux-armhf":
      return "Linux ARM";
    case "alpine-x64":
      return "Alpine Linux 64 bit";
    case "alpine-arm64":
      return "Alpine ARM 64";
    case "darwin-x64":
      return "Mac";
    case "darwin-arm64":
      return "Mac Silicon";
    case "web":
      return "Web";
    case "universal":
      return "universal";
    case "unknown":
      return "unknown";
    case "undefined":
      return "undefined";
  }
}
function $7A(targetPlatform) {
  switch (targetPlatform) {
    case "win32-x64":
      return "win32-x64";
    case "win32-arm64":
      return "win32-arm64";
    case "linux-x64":
      return "linux-x64";
    case "linux-arm64":
      return "linux-arm64";
    case "linux-armhf":
      return "linux-armhf";
    case "alpine-x64":
      return "alpine-x64";
    case "alpine-arm64":
      return "alpine-arm64";
    case "darwin-x64":
      return "darwin-x64";
    case "darwin-arm64":
      return "darwin-arm64";
    case "web":
      return "web";
    case "universal":
      return "universal";
    default:
      return "unknown";
  }
}
function $8A(platform, arch2) {
  switch (platform) {
    case 3:
      if (arch2 === "x64") {
        return "win32-x64";
      }
      if (arch2 === "arm64") {
        return "win32-arm64";
      }
      return "unknown";
    case 2:
      if (arch2 === "x64") {
        return "linux-x64";
      }
      if (arch2 === "arm64") {
        return "linux-arm64";
      }
      if (arch2 === "arm") {
        return "linux-armhf";
      }
      return "unknown";
    case "alpine":
      if (arch2 === "x64") {
        return "alpine-x64";
      }
      if (arch2 === "arm64") {
        return "alpine-arm64";
      }
      return "unknown";
    case 1:
      if (arch2 === "x64") {
        return "darwin-x64";
      }
      if (arch2 === "arm64") {
        return "darwin-arm64";
      }
      return "unknown";
    case 0:
      return "web";
  }
}
function $9A(allTargetPlatforms, productTargetPlatform) {
  return productTargetPlatform === "web" && !allTargetPlatforms.includes(
    "web"
    /* TargetPlatform.WEB */
  );
}
function $0A(extensionTargetPlatform, allTargetPlatforms, productTargetPlatform) {
  if ($9A(allTargetPlatforms, productTargetPlatform)) {
    return false;
  }
  if (extensionTargetPlatform === "undefined") {
    return true;
  }
  if (extensionTargetPlatform === "universal") {
    return true;
  }
  if (extensionTargetPlatform === "unknown") {
    return false;
  }
  if (extensionTargetPlatform === productTargetPlatform) {
    return true;
  }
  return false;
}
function $$A(thing) {
  return thing && typeof thing === "object" && typeof thing.id === "string" && (!thing.uuid || typeof thing.uuid === "string");
}
async function $iB(location2, fileService) {
  let stat;
  try {
    stat = await fileService.resolve(location2);
  } catch (e) {
    if (e.fileOperationResult === 1) {
      return 0;
    }
    throw e;
  }
  if (stat.children) {
    const sizes = await Promise.all(stat.children.map((c) => $iB(c.resource, fileService)));
    return sizes.reduce((r, s) => r + s, 0);
  }
  return stat.size ?? 0;
}
var $XA, $YA, $ZA, $3A, $4A, $5A, ExtensionInstallSource, SortBy, SortOrder, FilterType, StatisticType, InstallOperation, $_A, ExtensionGalleryErrorCode, $aB, ExtensionManagementErrorCode, ExtensionSignatureVerificationCode, $bB, $cB, $fB, $gB, $hB, $jB, $kB, $lB, $mB;
var init_extensionManagement = __esm({
  "out-build/vs/platform/extensionManagement/common/extensionManagement.js"() {
    "use strict";
    init_nls2();
    init_instantiation();
    $XA = "^([a-z0-9A-Z][a-z0-9-A-Z]*)\\.([a-z0-9A-Z][a-z0-9-A-Z]*)$";
    $YA = new RegExp($XA);
    $ZA = "__web_extension";
    $3A = "extensionInstallSource";
    $4A = "dependecyOrPackExtensionInstall";
    $5A = "clientTargetPlatform";
    (function(ExtensionInstallSource2) {
      ExtensionInstallSource2["COMMAND"] = "command";
      ExtensionInstallSource2["SETTINGS_SYNC"] = "settingsSync";
    })(ExtensionInstallSource || (ExtensionInstallSource = {}));
    (function(SortBy2) {
      SortBy2["NoneOrRelevance"] = "NoneOrRelevance";
      SortBy2["LastUpdatedDate"] = "LastUpdatedDate";
      SortBy2["Title"] = "Title";
      SortBy2["PublisherName"] = "PublisherName";
      SortBy2["InstallCount"] = "InstallCount";
      SortBy2["PublishedDate"] = "PublishedDate";
      SortBy2["AverageRating"] = "AverageRating";
      SortBy2["WeightedRating"] = "WeightedRating";
    })(SortBy || (SortBy = {}));
    (function(SortOrder2) {
      SortOrder2[SortOrder2["Default"] = 0] = "Default";
      SortOrder2[SortOrder2["Ascending"] = 1] = "Ascending";
      SortOrder2[SortOrder2["Descending"] = 2] = "Descending";
    })(SortOrder || (SortOrder = {}));
    (function(FilterType2) {
      FilterType2["Category"] = "Category";
      FilterType2["ExtensionId"] = "ExtensionId";
      FilterType2["ExtensionName"] = "ExtensionName";
      FilterType2["ExcludeWithFlags"] = "ExcludeWithFlags";
      FilterType2["Featured"] = "Featured";
      FilterType2["SearchText"] = "SearchText";
      FilterType2["Tag"] = "Tag";
      FilterType2["Target"] = "Target";
    })(FilterType || (FilterType = {}));
    (function(StatisticType2) {
      StatisticType2["Install"] = "install";
      StatisticType2["Uninstall"] = "uninstall";
    })(StatisticType || (StatisticType = {}));
    (function(InstallOperation2) {
      InstallOperation2[InstallOperation2["None"] = 1] = "None";
      InstallOperation2[InstallOperation2["Install"] = 2] = "Install";
      InstallOperation2[InstallOperation2["Update"] = 3] = "Update";
      InstallOperation2[InstallOperation2["Migrate"] = 4] = "Migrate";
    })(InstallOperation || (InstallOperation = {}));
    $_A = $kl("extensionGalleryService");
    (function(ExtensionGalleryErrorCode2) {
      ExtensionGalleryErrorCode2["Timeout"] = "Timeout";
      ExtensionGalleryErrorCode2["Cancelled"] = "Cancelled";
      ExtensionGalleryErrorCode2["Failed"] = "Failed";
      ExtensionGalleryErrorCode2["DownloadFailedWriting"] = "DownloadFailedWriting";
      ExtensionGalleryErrorCode2["Offline"] = "Offline";
    })(ExtensionGalleryErrorCode || (ExtensionGalleryErrorCode = {}));
    $aB = class extends Error {
      constructor(message, code) {
        super(message);
        this.code = code;
        this.name = code;
      }
    };
    (function(ExtensionManagementErrorCode2) {
      ExtensionManagementErrorCode2["NotFound"] = "NotFound";
      ExtensionManagementErrorCode2["Unsupported"] = "Unsupported";
      ExtensionManagementErrorCode2["Deprecated"] = "Deprecated";
      ExtensionManagementErrorCode2["Malicious"] = "Malicious";
      ExtensionManagementErrorCode2["Incompatible"] = "Incompatible";
      ExtensionManagementErrorCode2["IncompatibleApi"] = "IncompatibleApi";
      ExtensionManagementErrorCode2["IncompatibleTargetPlatform"] = "IncompatibleTargetPlatform";
      ExtensionManagementErrorCode2["ReleaseVersionNotFound"] = "ReleaseVersionNotFound";
      ExtensionManagementErrorCode2["Invalid"] = "Invalid";
      ExtensionManagementErrorCode2["Download"] = "Download";
      ExtensionManagementErrorCode2["DownloadSignature"] = "DownloadSignature";
      ExtensionManagementErrorCode2["DownloadFailedWriting"] = "DownloadFailedWriting";
      ExtensionManagementErrorCode2["UpdateMetadata"] = "UpdateMetadata";
      ExtensionManagementErrorCode2["Extract"] = "Extract";
      ExtensionManagementErrorCode2["Scanning"] = "Scanning";
      ExtensionManagementErrorCode2["ScanningExtension"] = "ScanningExtension";
      ExtensionManagementErrorCode2["ReadRemoved"] = "ReadRemoved";
      ExtensionManagementErrorCode2["UnsetRemoved"] = "UnsetRemoved";
      ExtensionManagementErrorCode2["Delete"] = "Delete";
      ExtensionManagementErrorCode2["Rename"] = "Rename";
      ExtensionManagementErrorCode2["IntializeDefaultProfile"] = "IntializeDefaultProfile";
      ExtensionManagementErrorCode2["AddToProfile"] = "AddToProfile";
      ExtensionManagementErrorCode2["InstalledExtensionNotFound"] = "InstalledExtensionNotFound";
      ExtensionManagementErrorCode2["PostInstall"] = "PostInstall";
      ExtensionManagementErrorCode2["CorruptZip"] = "CorruptZip";
      ExtensionManagementErrorCode2["IncompleteZip"] = "IncompleteZip";
      ExtensionManagementErrorCode2["PackageNotSigned"] = "PackageNotSigned";
      ExtensionManagementErrorCode2["SignatureVerificationInternal"] = "SignatureVerificationInternal";
      ExtensionManagementErrorCode2["SignatureVerificationFailed"] = "SignatureVerificationFailed";
      ExtensionManagementErrorCode2["NotAllowed"] = "NotAllowed";
      ExtensionManagementErrorCode2["Gallery"] = "Gallery";
      ExtensionManagementErrorCode2["Cancelled"] = "Cancelled";
      ExtensionManagementErrorCode2["Unknown"] = "Unknown";
      ExtensionManagementErrorCode2["Internal"] = "Internal";
    })(ExtensionManagementErrorCode || (ExtensionManagementErrorCode = {}));
    (function(ExtensionSignatureVerificationCode2) {
      ExtensionSignatureVerificationCode2["NotSigned"] = "NotSigned";
      ExtensionSignatureVerificationCode2["Success"] = "Success";
      ExtensionSignatureVerificationCode2["RequiredArgumentMissing"] = "RequiredArgumentMissing";
      ExtensionSignatureVerificationCode2["InvalidArgument"] = "InvalidArgument";
      ExtensionSignatureVerificationCode2["PackageIsUnreadable"] = "PackageIsUnreadable";
      ExtensionSignatureVerificationCode2["UnhandledException"] = "UnhandledException";
      ExtensionSignatureVerificationCode2["SignatureManifestIsMissing"] = "SignatureManifestIsMissing";
      ExtensionSignatureVerificationCode2["SignatureManifestIsUnreadable"] = "SignatureManifestIsUnreadable";
      ExtensionSignatureVerificationCode2["SignatureIsMissing"] = "SignatureIsMissing";
      ExtensionSignatureVerificationCode2["SignatureIsUnreadable"] = "SignatureIsUnreadable";
      ExtensionSignatureVerificationCode2["CertificateIsUnreadable"] = "CertificateIsUnreadable";
      ExtensionSignatureVerificationCode2["SignatureArchiveIsUnreadable"] = "SignatureArchiveIsUnreadable";
      ExtensionSignatureVerificationCode2["FileAlreadyExists"] = "FileAlreadyExists";
      ExtensionSignatureVerificationCode2["SignatureArchiveIsInvalidZip"] = "SignatureArchiveIsInvalidZip";
      ExtensionSignatureVerificationCode2["SignatureArchiveHasSameSignatureFile"] = "SignatureArchiveHasSameSignatureFile";
      ExtensionSignatureVerificationCode2["PackageIntegrityCheckFailed"] = "PackageIntegrityCheckFailed";
      ExtensionSignatureVerificationCode2["SignatureIsInvalid"] = "SignatureIsInvalid";
      ExtensionSignatureVerificationCode2["SignatureManifestIsInvalid"] = "SignatureManifestIsInvalid";
      ExtensionSignatureVerificationCode2["SignatureIntegrityCheckFailed"] = "SignatureIntegrityCheckFailed";
      ExtensionSignatureVerificationCode2["EntryIsMissing"] = "EntryIsMissing";
      ExtensionSignatureVerificationCode2["EntryIsTampered"] = "EntryIsTampered";
      ExtensionSignatureVerificationCode2["Untrusted"] = "Untrusted";
      ExtensionSignatureVerificationCode2["CertificateRevoked"] = "CertificateRevoked";
      ExtensionSignatureVerificationCode2["SignatureIsNotValid"] = "SignatureIsNotValid";
      ExtensionSignatureVerificationCode2["UnknownError"] = "UnknownError";
      ExtensionSignatureVerificationCode2["PackageIsInvalidZip"] = "PackageIsInvalidZip";
      ExtensionSignatureVerificationCode2["SignatureArchiveHasTooManyEntries"] = "SignatureArchiveHasTooManyEntries";
    })(ExtensionSignatureVerificationCode || (ExtensionSignatureVerificationCode = {}));
    $bB = class extends Error {
      constructor(message, code) {
        super(message);
        this.code = code;
        this.name = code;
      }
    };
    $cB = $kl("extensionManagementService");
    $fB = $kl("IGlobalExtensionEnablementService");
    $gB = $kl("IExtensionTipsService");
    $hB = $kl("IAllowedExtensionsService");
    $jB = localize2(1920, "Extensions");
    $kB = localize2(1921, "Preferences");
    $lB = "extensions.gallery.useUnpkgResourceApi";
    $mB = "extensions.allowed";
  }
});

// out-build/vs/base/parts/request/common/request.js
function $Ov(error) {
  if (error instanceof $Pv) {
    return true;
  }
  return error instanceof Error && error.name === offlineName && error.message === offlineName;
}
var offlineName, $Pv;
var init_request2 = __esm({
  "out-build/vs/base/parts/request/common/request.js"() {
    "use strict";
    offlineName = "Offline";
    $Pv = class extends Error {
      constructor() {
        super(offlineName);
        this.name = this.message;
      }
    };
  }
});

// out-build/vs/platform/extensions/common/extensions.js
function $QA(manifest) {
  return $RA(manifest);
}
function $RA(manifest) {
  return manifest.contributes && manifest.contributes.localizations ? manifest.contributes.localizations.length > 0 : false;
}
function $UA(enabledApiProposals) {
  return enabledApiProposals.map((proposal) => {
    const [proposalName, version] = proposal.split("@");
    return { proposalName, version: version ? parseInt(version) : void 0 };
  });
}
function $VA(enabledApiProposals) {
  return enabledApiProposals.map((proposal) => proposal.split("@")[0]);
}
var $GA, $HA, $IA, $LA, ExtensionType, TargetPlatform, $MA, $OA, $WA;
var init_extensions = __esm({
  "out-build/vs/platform/extensions/common/extensions.js"() {
    "use strict";
    init_strings();
    init_instantiation();
    init_remoteHosts();
    $GA = "extensions.user.cache";
    $HA = "extensions.builtin.cache";
    $IA = "undefined_publisher";
    $LA = [
      "AI",
      "Azure",
      "Chat",
      "Data Science",
      "Debuggers",
      "Extension Packs",
      "Education",
      "Formatters",
      "Keymaps",
      "Language Packs",
      "Linters",
      "Machine Learning",
      "Notebooks",
      "Programming Languages",
      "SCM Providers",
      "Snippets",
      "Testing",
      "Themes",
      "Visualization",
      "Other"
    ];
    (function(ExtensionType2) {
      ExtensionType2[ExtensionType2["System"] = 0] = "System";
      ExtensionType2[ExtensionType2["User"] = 1] = "User";
    })(ExtensionType || (ExtensionType = {}));
    (function(TargetPlatform2) {
      TargetPlatform2["WIN32_X64"] = "win32-x64";
      TargetPlatform2["WIN32_ARM64"] = "win32-arm64";
      TargetPlatform2["LINUX_X64"] = "linux-x64";
      TargetPlatform2["LINUX_ARM64"] = "linux-arm64";
      TargetPlatform2["LINUX_ARMHF"] = "linux-armhf";
      TargetPlatform2["ALPINE_X64"] = "alpine-x64";
      TargetPlatform2["ALPINE_ARM64"] = "alpine-arm64";
      TargetPlatform2["DARWIN_X64"] = "darwin-x64";
      TargetPlatform2["DARWIN_ARM64"] = "darwin-arm64";
      TargetPlatform2["WEB"] = "web";
      TargetPlatform2["UNIVERSAL"] = "universal";
      TargetPlatform2["UNKNOWN"] = "unknown";
      TargetPlatform2["UNDEFINED"] = "undefined";
    })(TargetPlatform || (TargetPlatform = {}));
    $MA = class {
      constructor(value) {
        this.value = value;
        this._lower = value.toLowerCase();
      }
      static equals(a, b) {
        if (typeof a === "undefined" || a === null) {
          return typeof b === "undefined" || b === null;
        }
        if (typeof b === "undefined" || b === null) {
          return false;
        }
        if (typeof a === "string" || typeof b === "string") {
          const aValue = typeof a === "string" ? a : a.value;
          const bValue = typeof b === "string" ? b : b.value;
          return $yg(aValue, bValue);
        }
        return a._lower === b._lower;
      }
      /**
       * Gives the value by which to index (for equality).
       */
      static toKey(id2) {
        if (typeof id2 === "string") {
          return id2.toLowerCase();
        }
        return id2._lower;
      }
    };
    $OA = class {
      constructor() {
        this.c = /* @__PURE__ */ new Map();
      }
      clear() {
        this.c.clear();
      }
      delete(id2) {
        this.c.delete($MA.toKey(id2));
      }
      get(id2) {
        return this.c.get($MA.toKey(id2));
      }
      has(id2) {
        return this.c.has($MA.toKey(id2));
      }
      set(id2, value) {
        this.c.set($MA.toKey(id2), value);
      }
      values() {
        return this.c.values();
      }
      forEach(callbackfn) {
        this.c.forEach(callbackfn);
      }
      [Symbol.iterator]() {
        return this.c[Symbol.iterator]();
      }
    };
    $WA = $kl("IBuiltinExtensionsScannerService");
  }
});

// out-build/vs/platform/extensionManagement/common/extensionManagementUtil.js
function $nB(a, b) {
  if (a.uuid && b.uuid) {
    return a.uuid === b.uuid;
  }
  if (a.id === b.id) {
    return true;
  }
  return $tg(a.id, b.id) === 0;
}
function $pB(id2) {
  const matches = EXTENSION_IDENTIFIER_WITH_VERSION_REGEX.exec(id2);
  if (matches && matches[1]) {
    return [$rB(matches[1]), matches[2]];
  }
  return [$rB(id2), void 0];
}
function $qB(publisher, name) {
  return `${publisher}.${name}`;
}
function $rB(id2) {
  return id2.toLowerCase();
}
function $sB(publisher, name) {
  return $rB($qB(publisher ?? $IA, name));
}
function $tB(extensions, getExtensionIdentifier) {
  const byExtension = [];
  const findGroup = (extension) => {
    for (const group of byExtension) {
      if (group.some((e) => $nB(getExtensionIdentifier(e), getExtensionIdentifier(extension)))) {
        return group;
      }
    }
    return null;
  };
  for (const extension of extensions) {
    const group = findGroup(extension);
    if (group) {
      group.push(extension);
    } else {
      byExtension.push([extension]);
    }
  }
  return byExtension;
}
function $uB(extension) {
  return {
    id: extension.identifier.id,
    name: extension.manifest.name,
    galleryId: null,
    publisherId: extension.publisherId,
    publisherName: extension.manifest.publisher,
    publisherDisplayName: extension.publisherDisplayName,
    dependencies: extension.manifest.extensionDependencies && extension.manifest.extensionDependencies.length > 0
  };
}
function $vB(extension) {
  return {
    id: new $Tw(extension.identifier.id),
    name: new $Tw(extension.name),
    extensionVersion: extension.version,
    galleryId: extension.identifier.uuid,
    publisherId: extension.publisherId,
    publisherName: extension.publisher,
    publisherDisplayName: extension.publisherDisplayName,
    isPreReleaseVersion: extension.properties.isPreReleaseVersion,
    dependencies: !!(extension.properties.dependencies && extension.properties.dependencies.length > 0),
    isSigned: extension.isSigned,
    ...extension.telemetryData
  };
}
async function isAlpineLinux(fileService, logService) {
  if (!$n) {
    return false;
  }
  let content;
  try {
    const fileContent = await fileService.readFile(URI.file("/etc/os-release"));
    content = fileContent.value.toString();
  } catch (error) {
    try {
      const fileContent = await fileService.readFile(URI.file("/usr/lib/os-release"));
      content = fileContent.value.toString();
    } catch (error2) {
      logService.debug(`Error while getting the os-release file.`, $qb(error2));
    }
  }
  return !!content && (content.match(/^ID=([^\u001b\r\n]*)/m) || [])[1] === "alpine";
}
async function $yB(fileService, logService) {
  const alpineLinux = await isAlpineLinux(fileService, logService);
  const targetPlatform = $8A(alpineLinux ? "alpine" : $x, $jc);
  logService.debug("ComputeTargetPlatform:", targetPlatform);
  return targetPlatform;
}
function $zB(identifier, malicious) {
  return malicious.some((publisherOrIdentifier) => {
    if ($Wc(publisherOrIdentifier)) {
      return $tg(identifier.id.split(".")[0], publisherOrIdentifier) === 0;
    }
    return $nB(identifier, publisherOrIdentifier);
  });
}
var ExtensionKeyRegex, $oB, EXTENSION_IDENTIFIER_WITH_VERSION_REGEX, $wB;
var init_extensionManagementUtil = __esm({
  "out-build/vs/platform/extensionManagement/common/extensionManagementUtil.js"() {
    "use strict";
    init_strings();
    init_extensionManagement();
    init_extensions();
    init_platform();
    init_uri();
    init_errors();
    init_process();
    init_telemetryUtils();
    init_types();
    ExtensionKeyRegex = /^([^.]+\..+)-(\d+\.\d+\.\d+)(-(.+))?$/;
    $oB = class _$oB {
      static create(extension) {
        const version = extension.manifest ? extension.manifest.version : extension.version;
        const targetPlatform = extension.manifest ? extension.targetPlatform : extension.properties.targetPlatform;
        return new _$oB(extension.identifier, version, targetPlatform);
      }
      static parse(key) {
        const matches = ExtensionKeyRegex.exec(key);
        return matches && matches[1] && matches[2] ? new _$oB({ id: matches[1] }, matches[2], matches[4] || void 0) : null;
      }
      constructor(identifier, version, targetPlatform = "undefined") {
        this.identifier = identifier;
        this.version = version;
        this.targetPlatform = targetPlatform;
        this.id = identifier.id;
      }
      toString() {
        return `${this.id}-${this.version}${this.targetPlatform !== "undefined" ? `-${this.targetPlatform}` : ""}`;
      }
      equals(o) {
        if (!(o instanceof _$oB)) {
          return false;
        }
        return $nB(this, o) && this.version === o.version && this.targetPlatform === o.targetPlatform;
      }
    };
    EXTENSION_IDENTIFIER_WITH_VERSION_REGEX = /^([^.]+\..+)@((prerelease)|(\d+\.\d+\.\d+(-.*)?))$/;
    $wB = new $MA("pprice.better-merge");
  }
});

// out-build/vs/base/common/severity.js
var Severity, severity_default;
var init_severity = __esm({
  "out-build/vs/base/common/severity.js"() {
    "use strict";
    init_strings();
    (function(Severity2) {
      Severity2[Severity2["Ignore"] = 0] = "Ignore";
      Severity2[Severity2["Info"] = 1] = "Info";
      Severity2[Severity2["Warning"] = 2] = "Warning";
      Severity2[Severity2["Error"] = 3] = "Error";
    })(Severity || (Severity = {}));
    (function(Severity2) {
      const _error = "error";
      const _warning = "warning";
      const _warn = "warn";
      const _info = "info";
      const _ignore = "ignore";
      function fromValue(value) {
        if (!value) {
          return Severity2.Ignore;
        }
        if ($yg(_error, value)) {
          return Severity2.Error;
        }
        if ($yg(_warning, value) || $yg(_warn, value)) {
          return Severity2.Warning;
        }
        if ($yg(_info, value)) {
          return Severity2.Info;
        }
        return Severity2.Ignore;
      }
      Severity2.fromValue = fromValue;
      function toString(severity) {
        switch (severity) {
          case Severity2.Error:
            return _error;
          case Severity2.Warning:
            return _warning;
          case Severity2.Info:
            return _info;
          default:
            return _ignore;
        }
      }
      Severity2.toString = toString;
    })(Severity || (Severity = {}));
    severity_default = Severity;
  }
});

// out-build/vs/base/common/semver/semver.js
var exports, module, SEMVER_SPEC_VERSION, parse, valid, coerce, clean, inc, major, minor, patch, prerelease, gt, gte, lt, lte, eq, neq, cmp3, compare2, rcompare, compareIdentifiers, rcompareIdentifiers, compareBuild, sort, rsort, diff, validRange, satisfies, maxSatisfying, minSatisfying, minVersion, gtr, ltr, outside, intersects, SemVer, Comparator, Range;
var init_semver = __esm({
  "out-build/vs/base/common/semver/semver.js"() {
    "use strict";
    exports = {};
    module = { exports };
    !function(e, r) {
      if ("object" == typeof exports && "object" == typeof module) module.exports = r();
      else if ("function" == typeof define && define.amd) define([], r);
      else {
        var t = r();
        for (var n in t) ("object" == typeof exports ? exports : e)[n] = t[n];
      }
    }("undefined" != typeof self ? self : void 0, function() {
      return function(e) {
        var r = {};
        function t(n) {
          if (r[n]) return r[n].exports;
          var o = r[n] = { i: n, l: false, exports: {} };
          return e[n].call(o.exports, o, o.exports, t), o.l = true, o.exports;
        }
        return t.m = e, t.c = r, t.d = function(e2, r2, n) {
          t.o(e2, r2) || Object.defineProperty(e2, r2, { enumerable: true, get: n });
        }, t.r = function(e2) {
          "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(e2, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(e2, "__esModule", { value: true });
        }, t.t = function(e2, r2) {
          if (1 & r2 && (e2 = t(e2)), 8 & r2) return e2;
          if (4 & r2 && "object" == typeof e2 && e2 && e2.__esModule) return e2;
          var n = /* @__PURE__ */ Object.create(null);
          if (t.r(n), Object.defineProperty(n, "default", { enumerable: true, value: e2 }), 2 & r2 && "string" != typeof e2) for (var o in e2) t.d(n, o, function(r3) {
            return e2[r3];
          }.bind(null, o));
          return n;
        }, t.n = function(e2) {
          var r2 = e2 && e2.__esModule ? function() {
            return e2.default;
          } : function() {
            return e2;
          };
          return t.d(r2, "a", r2), r2;
        }, t.o = function(e2, r2) {
          return Object.prototype.hasOwnProperty.call(e2, r2);
        }, t.p = "", t(t.s = 0);
      }([function(e, r, t) {
        (function(t2) {
          var n;
          r = e.exports = H, n = "object" == typeof t2 && t2.env && t2.env.NODE_DEBUG && /\bsemver\b/i.test(t2.env.NODE_DEBUG) ? function() {
            var e2 = Array.prototype.slice.call(arguments, 0);
            e2.unshift("SEMVER"), console.log.apply(console, e2);
          } : function() {
          }, r.SEMVER_SPEC_VERSION = "2.0.0";
          var o = 256, i = Number.MAX_SAFE_INTEGER || 9007199254740991, s = r.re = [], a = r.src = [], u = 0, c = u++;
          a[c] = "0|[1-9]\\d*";
          var p = u++;
          a[p] = "[0-9]+";
          var f = u++;
          a[f] = "\\d*[a-zA-Z-][a-zA-Z0-9-]*";
          var l = u++;
          a[l] = "(" + a[c] + ")\\.(" + a[c] + ")\\.(" + a[c] + ")";
          var h = u++;
          a[h] = "(" + a[p] + ")\\.(" + a[p] + ")\\.(" + a[p] + ")";
          var v = u++;
          a[v] = "(?:" + a[c] + "|" + a[f] + ")";
          var m = u++;
          a[m] = "(?:" + a[p] + "|" + a[f] + ")";
          var w = u++;
          a[w] = "(?:-(" + a[v] + "(?:\\." + a[v] + ")*))";
          var g = u++;
          a[g] = "(?:-?(" + a[m] + "(?:\\." + a[m] + ")*))";
          var y = u++;
          a[y] = "[0-9A-Za-z-]+";
          var d = u++;
          a[d] = "(?:\\+(" + a[y] + "(?:\\." + a[y] + ")*))";
          var b = u++, j = "v?" + a[l] + a[w] + "?" + a[d] + "?";
          a[b] = "^" + j + "$";
          var E = "[v=\\s]*" + a[h] + a[g] + "?" + a[d] + "?", T = u++;
          a[T] = "^" + E + "$";
          var x = u++;
          a[x] = "((?:<|>)?=?)";
          var $ = u++;
          a[$] = a[p] + "|x|X|\\*";
          var k = u++;
          a[k] = a[c] + "|x|X|\\*";
          var S = u++;
          a[S] = "[v=\\s]*(" + a[k] + ")(?:\\.(" + a[k] + ")(?:\\.(" + a[k] + ")(?:" + a[w] + ")?" + a[d] + "?)?)?";
          var R = u++;
          a[R] = "[v=\\s]*(" + a[$] + ")(?:\\.(" + a[$] + ")(?:\\.(" + a[$] + ")(?:" + a[g] + ")?" + a[d] + "?)?)?";
          var I = u++;
          a[I] = "^" + a[x] + "\\s*" + a[S] + "$";
          var _ = u++;
          a[_] = "^" + a[x] + "\\s*" + a[R] + "$";
          var O = u++;
          a[O] = "(?:^|[^\\d])(\\d{1,16})(?:\\.(\\d{1,16}))?(?:\\.(\\d{1,16}))?(?:$|[^\\d])";
          var A = u++;
          a[A] = "(?:~>?)";
          var M = u++;
          a[M] = "(\\s*)" + a[A] + "\\s+", s[M] = new RegExp(a[M], "g");
          var V = u++;
          a[V] = "^" + a[A] + a[S] + "$";
          var P = u++;
          a[P] = "^" + a[A] + a[R] + "$";
          var C = u++;
          a[C] = "(?:\\^)";
          var L = u++;
          a[L] = "(\\s*)" + a[C] + "\\s+", s[L] = new RegExp(a[L], "g");
          var N = u++;
          a[N] = "^" + a[C] + a[S] + "$";
          var q = u++;
          a[q] = "^" + a[C] + a[R] + "$";
          var D = u++;
          a[D] = "^" + a[x] + "\\s*(" + E + ")$|^$";
          var X = u++;
          a[X] = "^" + a[x] + "\\s*(" + j + ")$|^$";
          var z = u++;
          a[z] = "(\\s*)" + a[x] + "\\s*(" + E + "|" + a[S] + ")", s[z] = new RegExp(a[z], "g");
          var G = u++;
          a[G] = "^\\s*(" + a[S] + ")\\s+-\\s+(" + a[S] + ")\\s*$";
          var Z = u++;
          a[Z] = "^\\s*(" + a[R] + ")\\s+-\\s+(" + a[R] + ")\\s*$";
          var B = u++;
          a[B] = "(<|>)?=?\\s*\\*";
          for (var U = 0; U < 35; U++) n(U, a[U]), s[U] || (s[U] = new RegExp(a[U]));
          function F(e2, r2) {
            if (e2 instanceof H) return e2;
            if ("string" != typeof e2) return null;
            if (e2.length > o) return null;
            if (!(r2 ? s[T] : s[b]).test(e2)) return null;
            try {
              return new H(e2, r2);
            } catch (e3) {
              return null;
            }
          }
          function H(e2, r2) {
            if (e2 instanceof H) {
              if (e2.loose === r2) return e2;
              e2 = e2.version;
            } else if ("string" != typeof e2) throw new TypeError("Invalid Version: " + e2);
            if (e2.length > o) throw new TypeError("version is longer than " + o + " characters");
            if (!(this instanceof H)) return new H(e2, r2);
            n("SemVer", e2, r2), this.loose = r2;
            var t3 = e2.trim().match(r2 ? s[T] : s[b]);
            if (!t3) throw new TypeError("Invalid Version: " + e2);
            if (this.raw = e2, this.major = +t3[1], this.minor = +t3[2], this.patch = +t3[3], this.major > i || this.major < 0) throw new TypeError("Invalid major version");
            if (this.minor > i || this.minor < 0) throw new TypeError("Invalid minor version");
            if (this.patch > i || this.patch < 0) throw new TypeError("Invalid patch version");
            t3[4] ? this.prerelease = t3[4].split(".").map(function(e3) {
              if (/^[0-9]+$/.test(e3)) {
                var r3 = +e3;
                if (r3 >= 0 && r3 < i) return r3;
              }
              return e3;
            }) : this.prerelease = [], this.build = t3[5] ? t3[5].split(".") : [], this.format();
          }
          r.parse = F, r.valid = function(e2, r2) {
            var t3 = F(e2, r2);
            return t3 ? t3.version : null;
          }, r.clean = function(e2, r2) {
            var t3 = F(e2.trim().replace(/^[=v]+/, ""), r2);
            return t3 ? t3.version : null;
          }, r.SemVer = H, H.prototype.format = function() {
            return this.version = this.major + "." + this.minor + "." + this.patch, this.prerelease.length && (this.version += "-" + this.prerelease.join(".")), this.version;
          }, H.prototype.toString = function() {
            return this.version;
          }, H.prototype.compare = function(e2) {
            return n("SemVer.compare", this.version, this.loose, e2), e2 instanceof H || (e2 = new H(e2, this.loose)), this.compareMain(e2) || this.comparePre(e2);
          }, H.prototype.compareMain = function(e2) {
            return e2 instanceof H || (e2 = new H(e2, this.loose)), K(this.major, e2.major) || K(this.minor, e2.minor) || K(this.patch, e2.patch);
          }, H.prototype.comparePre = function(e2) {
            if (e2 instanceof H || (e2 = new H(e2, this.loose)), this.prerelease.length && !e2.prerelease.length) return -1;
            if (!this.prerelease.length && e2.prerelease.length) return 1;
            if (!this.prerelease.length && !e2.prerelease.length) return 0;
            var r2 = 0;
            do {
              var t3 = this.prerelease[r2], o2 = e2.prerelease[r2];
              if (n("prerelease compare", r2, t3, o2), void 0 === t3 && void 0 === o2) return 0;
              if (void 0 === o2) return 1;
              if (void 0 === t3) return -1;
              if (t3 !== o2) return K(t3, o2);
            } while (++r2);
          }, H.prototype.inc = function(e2, r2) {
            switch (e2) {
              case "premajor":
                this.prerelease.length = 0, this.patch = 0, this.minor = 0, this.major++, this.inc("pre", r2);
                break;
              case "preminor":
                this.prerelease.length = 0, this.patch = 0, this.minor++, this.inc("pre", r2);
                break;
              case "prepatch":
                this.prerelease.length = 0, this.inc("patch", r2), this.inc("pre", r2);
                break;
              case "prerelease":
                0 === this.prerelease.length && this.inc("patch", r2), this.inc("pre", r2);
                break;
              case "major":
                0 === this.minor && 0 === this.patch && 0 !== this.prerelease.length || this.major++, this.minor = 0, this.patch = 0, this.prerelease = [];
                break;
              case "minor":
                0 === this.patch && 0 !== this.prerelease.length || this.minor++, this.patch = 0, this.prerelease = [];
                break;
              case "patch":
                0 === this.prerelease.length && this.patch++, this.prerelease = [];
                break;
              case "pre":
                if (0 === this.prerelease.length) this.prerelease = [0];
                else {
                  for (var t3 = this.prerelease.length; --t3 >= 0; ) "number" == typeof this.prerelease[t3] && (this.prerelease[t3]++, t3 = -2);
                  -1 === t3 && this.prerelease.push(0);
                }
                r2 && (this.prerelease[0] === r2 ? isNaN(this.prerelease[1]) && (this.prerelease = [r2, 0]) : this.prerelease = [r2, 0]);
                break;
              default:
                throw new Error("invalid increment argument: " + e2);
            }
            return this.format(), this.raw = this.version, this;
          }, r.inc = function(e2, r2, t3, n2) {
            "string" == typeof t3 && (n2 = t3, t3 = void 0);
            try {
              return new H(e2, t3).inc(r2, n2).version;
            } catch (e3) {
              return null;
            }
          }, r.diff = function(e2, r2) {
            if (ee(e2, r2)) return null;
            var t3 = F(e2), n2 = F(r2);
            if (t3.prerelease.length || n2.prerelease.length) {
              for (var o2 in t3) if (("major" === o2 || "minor" === o2 || "patch" === o2) && t3[o2] !== n2[o2]) return "pre" + o2;
              return "prerelease";
            }
            for (var o2 in t3) if (("major" === o2 || "minor" === o2 || "patch" === o2) && t3[o2] !== n2[o2]) return o2;
          }, r.compareIdentifiers = K;
          var J = /^[0-9]+$/;
          function K(e2, r2) {
            var t3 = J.test(e2), n2 = J.test(r2);
            return t3 && n2 && (e2 = +e2, r2 = +r2), t3 && !n2 ? -1 : n2 && !t3 ? 1 : e2 < r2 ? -1 : e2 > r2 ? 1 : 0;
          }
          function Q(e2, r2, t3) {
            return new H(e2, t3).compare(new H(r2, t3));
          }
          function W(e2, r2, t3) {
            return Q(e2, r2, t3) > 0;
          }
          function Y(e2, r2, t3) {
            return Q(e2, r2, t3) < 0;
          }
          function ee(e2, r2, t3) {
            return 0 === Q(e2, r2, t3);
          }
          function re(e2, r2, t3) {
            return 0 !== Q(e2, r2, t3);
          }
          function te(e2, r2, t3) {
            return Q(e2, r2, t3) >= 0;
          }
          function ne(e2, r2, t3) {
            return Q(e2, r2, t3) <= 0;
          }
          function oe(e2, r2, t3, n2) {
            var o2;
            switch (r2) {
              case "===":
                "object" == typeof e2 && (e2 = e2.version), "object" == typeof t3 && (t3 = t3.version), o2 = e2 === t3;
                break;
              case "!==":
                "object" == typeof e2 && (e2 = e2.version), "object" == typeof t3 && (t3 = t3.version), o2 = e2 !== t3;
                break;
              case "":
              case "=":
              case "==":
                o2 = ee(e2, t3, n2);
                break;
              case "!=":
                o2 = re(e2, t3, n2);
                break;
              case ">":
                o2 = W(e2, t3, n2);
                break;
              case ">=":
                o2 = te(e2, t3, n2);
                break;
              case "<":
                o2 = Y(e2, t3, n2);
                break;
              case "<=":
                o2 = ne(e2, t3, n2);
                break;
              default:
                throw new TypeError("Invalid operator: " + r2);
            }
            return o2;
          }
          function ie(e2, r2) {
            if (e2 instanceof ie) {
              if (e2.loose === r2) return e2;
              e2 = e2.value;
            }
            if (!(this instanceof ie)) return new ie(e2, r2);
            n("comparator", e2, r2), this.loose = r2, this.parse(e2), this.semver === se ? this.value = "" : this.value = this.operator + this.semver.version, n("comp", this);
          }
          r.rcompareIdentifiers = function(e2, r2) {
            return K(r2, e2);
          }, r.major = function(e2, r2) {
            return new H(e2, r2).major;
          }, r.minor = function(e2, r2) {
            return new H(e2, r2).minor;
          }, r.patch = function(e2, r2) {
            return new H(e2, r2).patch;
          }, r.compare = Q, r.compareLoose = function(e2, r2) {
            return Q(e2, r2, true);
          }, r.rcompare = function(e2, r2, t3) {
            return Q(r2, e2, t3);
          }, r.sort = function(e2, t3) {
            return e2.sort(function(e3, n2) {
              return r.compare(e3, n2, t3);
            });
          }, r.rsort = function(e2, t3) {
            return e2.sort(function(e3, n2) {
              return r.rcompare(e3, n2, t3);
            });
          }, r.gt = W, r.lt = Y, r.eq = ee, r.neq = re, r.gte = te, r.lte = ne, r.cmp = oe, r.Comparator = ie;
          var se = {};
          function ae(e2, r2) {
            if (e2 instanceof ae) return e2.loose === r2 ? e2 : new ae(e2.raw, r2);
            if (e2 instanceof ie) return new ae(e2.value, r2);
            if (!(this instanceof ae)) return new ae(e2, r2);
            if (this.loose = r2, this.raw = e2, this.set = e2.split(/\s*\|\|\s*/).map(function(e3) {
              return this.parseRange(e3.trim());
            }, this).filter(function(e3) {
              return e3.length;
            }), !this.set.length) throw new TypeError("Invalid SemVer Range: " + e2);
            this.format();
          }
          function ue(e2) {
            return !e2 || "x" === e2.toLowerCase() || "*" === e2;
          }
          function ce(e2, r2, t3, n2, o2, i2, s2, a2, u2, c2, p2, f2, l2) {
            return ((r2 = ue(t3) ? "" : ue(n2) ? ">=" + t3 + ".0.0" : ue(o2) ? ">=" + t3 + "." + n2 + ".0" : ">=" + r2) + " " + (a2 = ue(u2) ? "" : ue(c2) ? "<" + (+u2 + 1) + ".0.0" : ue(p2) ? "<" + u2 + "." + (+c2 + 1) + ".0" : f2 ? "<=" + u2 + "." + c2 + "." + p2 + "-" + f2 : "<=" + a2)).trim();
          }
          function pe(e2, r2) {
            for (var t3 = 0; t3 < e2.length; t3++) if (!e2[t3].test(r2)) return false;
            if (r2.prerelease.length) {
              for (t3 = 0; t3 < e2.length; t3++) if (n(e2[t3].semver), e2[t3].semver !== se && e2[t3].semver.prerelease.length > 0) {
                var o2 = e2[t3].semver;
                if (o2.major === r2.major && o2.minor === r2.minor && o2.patch === r2.patch) return true;
              }
              return false;
            }
            return true;
          }
          function fe(e2, r2, t3) {
            try {
              r2 = new ae(r2, t3);
            } catch (e3) {
              return false;
            }
            return r2.test(e2);
          }
          function le(e2, r2, t3, n2) {
            var o2, i2, s2, a2, u2;
            switch (e2 = new H(e2, n2), r2 = new ae(r2, n2), t3) {
              case ">":
                o2 = W, i2 = ne, s2 = Y, a2 = ">", u2 = ">=";
                break;
              case "<":
                o2 = Y, i2 = te, s2 = W, a2 = "<", u2 = "<=";
                break;
              default:
                throw new TypeError('Must provide a hilo val of "<" or ">"');
            }
            if (fe(e2, r2, n2)) return false;
            for (var c2 = 0; c2 < r2.set.length; ++c2) {
              var p2 = r2.set[c2], f2 = null, l2 = null;
              if (p2.forEach(function(e3) {
                e3.semver === se && (e3 = new ie(">=0.0.0")), f2 = f2 || e3, l2 = l2 || e3, o2(e3.semver, f2.semver, n2) ? f2 = e3 : s2(e3.semver, l2.semver, n2) && (l2 = e3);
              }), f2.operator === a2 || f2.operator === u2) return false;
              if ((!l2.operator || l2.operator === a2) && i2(e2, l2.semver)) return false;
              if (l2.operator === u2 && s2(e2, l2.semver)) return false;
            }
            return true;
          }
          ie.prototype.parse = function(e2) {
            var r2 = this.loose ? s[D] : s[X], t3 = e2.match(r2);
            if (!t3) throw new TypeError("Invalid comparator: " + e2);
            this.operator = t3[1], "=" === this.operator && (this.operator = ""), t3[2] ? this.semver = new H(t3[2], this.loose) : this.semver = se;
          }, ie.prototype.toString = function() {
            return this.value;
          }, ie.prototype.test = function(e2) {
            return n("Comparator.test", e2, this.loose), this.semver === se || ("string" == typeof e2 && (e2 = new H(e2, this.loose)), oe(e2, this.operator, this.semver, this.loose));
          }, ie.prototype.intersects = function(e2, r2) {
            if (!(e2 instanceof ie)) throw new TypeError("a Comparator is required");
            var t3;
            if ("" === this.operator) return t3 = new ae(e2.value, r2), fe(this.value, t3, r2);
            if ("" === e2.operator) return t3 = new ae(this.value, r2), fe(e2.semver, t3, r2);
            var n2 = !(">=" !== this.operator && ">" !== this.operator || ">=" !== e2.operator && ">" !== e2.operator), o2 = !("<=" !== this.operator && "<" !== this.operator || "<=" !== e2.operator && "<" !== e2.operator), i2 = this.semver.version === e2.semver.version, s2 = !(">=" !== this.operator && "<=" !== this.operator || ">=" !== e2.operator && "<=" !== e2.operator), a2 = oe(this.semver, "<", e2.semver, r2) && (">=" === this.operator || ">" === this.operator) && ("<=" === e2.operator || "<" === e2.operator), u2 = oe(this.semver, ">", e2.semver, r2) && ("<=" === this.operator || "<" === this.operator) && (">=" === e2.operator || ">" === e2.operator);
            return n2 || o2 || i2 && s2 || a2 || u2;
          }, r.Range = ae, ae.prototype.format = function() {
            return this.range = this.set.map(function(e2) {
              return e2.join(" ").trim();
            }).join("||").trim(), this.range;
          }, ae.prototype.toString = function() {
            return this.range;
          }, ae.prototype.parseRange = function(e2) {
            var r2 = this.loose;
            e2 = e2.trim(), n("range", e2, r2);
            var t3 = r2 ? s[Z] : s[G];
            e2 = e2.replace(t3, ce), n("hyphen replace", e2), e2 = e2.replace(s[z], "$1$2$3"), n("comparator trim", e2, s[z]), e2 = (e2 = (e2 = e2.replace(s[M], "$1~")).replace(s[L], "$1^")).split(/\s+/).join(" ");
            var o2 = r2 ? s[D] : s[X], i2 = e2.split(" ").map(function(e3) {
              return function(e4, r3) {
                return n("comp", e4), e4 = function(e5, r4) {
                  return e5.trim().split(/\s+/).map(function(e6) {
                    return function(e7, r5) {
                      n("caret", e7, r5);
                      var t4 = r5 ? s[q] : s[N];
                      return e7.replace(t4, function(r6, t5, o3, i3, s2) {
                        var a2;
                        return n("caret", e7, r6, t5, o3, i3, s2), ue(t5) ? a2 = "" : ue(o3) ? a2 = ">=" + t5 + ".0.0 <" + (+t5 + 1) + ".0.0" : ue(i3) ? a2 = "0" === t5 ? ">=" + t5 + "." + o3 + ".0 <" + t5 + "." + (+o3 + 1) + ".0" : ">=" + t5 + "." + o3 + ".0 <" + (+t5 + 1) + ".0.0" : s2 ? (n("replaceCaret pr", s2), "-" !== s2.charAt(0) && (s2 = "-" + s2), a2 = "0" === t5 ? "0" === o3 ? ">=" + t5 + "." + o3 + "." + i3 + s2 + " <" + t5 + "." + o3 + "." + (+i3 + 1) : ">=" + t5 + "." + o3 + "." + i3 + s2 + " <" + t5 + "." + (+o3 + 1) + ".0" : ">=" + t5 + "." + o3 + "." + i3 + s2 + " <" + (+t5 + 1) + ".0.0") : (n("no pr"), a2 = "0" === t5 ? "0" === o3 ? ">=" + t5 + "." + o3 + "." + i3 + " <" + t5 + "." + o3 + "." + (+i3 + 1) : ">=" + t5 + "." + o3 + "." + i3 + " <" + t5 + "." + (+o3 + 1) + ".0" : ">=" + t5 + "." + o3 + "." + i3 + " <" + (+t5 + 1) + ".0.0"), n("caret return", a2), a2;
                      });
                    }(e6, r4);
                  }).join(" ");
                }(e4, r3), n("caret", e4), e4 = function(e5, r4) {
                  return e5.trim().split(/\s+/).map(function(e6) {
                    return function(e7, r5) {
                      var t4 = r5 ? s[P] : s[V];
                      return e7.replace(t4, function(r6, t5, o3, i3, s2) {
                        var a2;
                        return n("tilde", e7, r6, t5, o3, i3, s2), ue(t5) ? a2 = "" : ue(o3) ? a2 = ">=" + t5 + ".0.0 <" + (+t5 + 1) + ".0.0" : ue(i3) ? a2 = ">=" + t5 + "." + o3 + ".0 <" + t5 + "." + (+o3 + 1) + ".0" : s2 ? (n("replaceTilde pr", s2), "-" !== s2.charAt(0) && (s2 = "-" + s2), a2 = ">=" + t5 + "." + o3 + "." + i3 + s2 + " <" + t5 + "." + (+o3 + 1) + ".0") : a2 = ">=" + t5 + "." + o3 + "." + i3 + " <" + t5 + "." + (+o3 + 1) + ".0", n("tilde return", a2), a2;
                      });
                    }(e6, r4);
                  }).join(" ");
                }(e4, r3), n("tildes", e4), e4 = function(e5, r4) {
                  return n("replaceXRanges", e5, r4), e5.split(/\s+/).map(function(e6) {
                    return function(e7, r5) {
                      e7 = e7.trim();
                      var t4 = r5 ? s[_] : s[I];
                      return e7.replace(t4, function(r6, t5, o3, i3, s2, a2) {
                        n("xRange", e7, r6, t5, o3, i3, s2, a2);
                        var u2 = ue(o3), c2 = u2 || ue(i3), p2 = c2 || ue(s2);
                        return "=" === t5 && p2 && (t5 = ""), u2 ? r6 = ">" === t5 || "<" === t5 ? "<0.0.0" : "*" : t5 && p2 ? (c2 && (i3 = 0), p2 && (s2 = 0), ">" === t5 ? (t5 = ">=", c2 ? (o3 = +o3 + 1, i3 = 0, s2 = 0) : p2 && (i3 = +i3 + 1, s2 = 0)) : "<=" === t5 && (t5 = "<", c2 ? o3 = +o3 + 1 : i3 = +i3 + 1), r6 = t5 + o3 + "." + i3 + "." + s2) : c2 ? r6 = ">=" + o3 + ".0.0 <" + (+o3 + 1) + ".0.0" : p2 && (r6 = ">=" + o3 + "." + i3 + ".0 <" + o3 + "." + (+i3 + 1) + ".0"), n("xRange return", r6), r6;
                      });
                    }(e6, r4);
                  }).join(" ");
                }(e4, r3), n("xrange", e4), e4 = function(e5, r4) {
                  return n("replaceStars", e5, r4), e5.trim().replace(s[B], "");
                }(e4, r3), n("stars", e4), e4;
              }(e3, r2);
            }).join(" ").split(/\s+/);
            return this.loose && (i2 = i2.filter(function(e3) {
              return !!e3.match(o2);
            })), i2 = i2.map(function(e3) {
              return new ie(e3, r2);
            });
          }, ae.prototype.intersects = function(e2, r2) {
            if (!(e2 instanceof ae)) throw new TypeError("a Range is required");
            return this.set.some(function(t3) {
              return t3.every(function(t4) {
                return e2.set.some(function(e3) {
                  return e3.every(function(e4) {
                    return t4.intersects(e4, r2);
                  });
                });
              });
            });
          }, r.toComparators = function(e2, r2) {
            return new ae(e2, r2).set.map(function(e3) {
              return e3.map(function(e4) {
                return e4.value;
              }).join(" ").trim().split(" ");
            });
          }, ae.prototype.test = function(e2) {
            if (!e2) return false;
            "string" == typeof e2 && (e2 = new H(e2, this.loose));
            for (var r2 = 0; r2 < this.set.length; r2++) if (pe(this.set[r2], e2)) return true;
            return false;
          }, r.satisfies = fe, r.maxSatisfying = function(e2, r2, t3) {
            var n2 = null, o2 = null;
            try {
              var i2 = new ae(r2, t3);
            } catch (e3) {
              return null;
            }
            return e2.forEach(function(e3) {
              i2.test(e3) && (n2 && -1 !== o2.compare(e3) || (o2 = new H(n2 = e3, t3)));
            }), n2;
          }, r.minSatisfying = function(e2, r2, t3) {
            var n2 = null, o2 = null;
            try {
              var i2 = new ae(r2, t3);
            } catch (e3) {
              return null;
            }
            return e2.forEach(function(e3) {
              i2.test(e3) && (n2 && 1 !== o2.compare(e3) || (o2 = new H(n2 = e3, t3)));
            }), n2;
          }, r.validRange = function(e2, r2) {
            try {
              return new ae(e2, r2).range || "*";
            } catch (e3) {
              return null;
            }
          }, r.ltr = function(e2, r2, t3) {
            return le(e2, r2, "<", t3);
          }, r.gtr = function(e2, r2, t3) {
            return le(e2, r2, ">", t3);
          }, r.outside = le, r.prerelease = function(e2, r2) {
            var t3 = F(e2, r2);
            return t3 && t3.prerelease.length ? t3.prerelease : null;
          }, r.intersects = function(e2, r2, t3) {
            return e2 = new ae(e2, t3), r2 = new ae(r2, t3), e2.intersects(r2);
          }, r.coerce = function(e2) {
            if (e2 instanceof H) return e2;
            if ("string" != typeof e2) return null;
            var r2 = e2.match(s[O]);
            return null == r2 ? null : F((r2[1] || "0") + "." + (r2[2] || "0") + "." + (r2[3] || "0"));
          };
        }).call(this, t(1));
      }, function(e, r) {
        var t, n, o = e.exports = {};
        function i() {
          throw new Error("setTimeout has not been defined");
        }
        function s() {
          throw new Error("clearTimeout has not been defined");
        }
        function a(e2) {
          if (t === setTimeout) return setTimeout(e2, 0);
          if ((t === i || !t) && setTimeout) return t = setTimeout, setTimeout(e2, 0);
          try {
            return t(e2, 0);
          } catch (r2) {
            try {
              return t.call(null, e2, 0);
            } catch (r3) {
              return t.call(this, e2, 0);
            }
          }
        }
        !function() {
          try {
            t = "function" == typeof setTimeout ? setTimeout : i;
          } catch (e2) {
            t = i;
          }
          try {
            n = "function" == typeof clearTimeout ? clearTimeout : s;
          } catch (e2) {
            n = s;
          }
        }();
        var u, c = [], p = false, f = -1;
        function l() {
          p && u && (p = false, u.length ? c = u.concat(c) : f = -1, c.length && h());
        }
        function h() {
          if (!p) {
            var e2 = a(l);
            p = true;
            for (var r2 = c.length; r2; ) {
              for (u = c, c = []; ++f < r2; ) u && u[f].run();
              f = -1, r2 = c.length;
            }
            u = null, p = false, function(e3) {
              if (n === clearTimeout) return clearTimeout(e3);
              if ((n === s || !n) && clearTimeout) return n = clearTimeout, clearTimeout(e3);
              try {
                n(e3);
              } catch (r3) {
                try {
                  return n.call(null, e3);
                } catch (r4) {
                  return n.call(this, e3);
                }
              }
            }(e2);
          }
        }
        function v(e2, r2) {
          this.fun = e2, this.array = r2;
        }
        function m() {
        }
        o.nextTick = function(e2) {
          var r2 = new Array(arguments.length - 1);
          if (arguments.length > 1) for (var t2 = 1; t2 < arguments.length; t2++) r2[t2 - 1] = arguments[t2];
          c.push(new v(e2, r2)), 1 !== c.length || p || a(h);
        }, v.prototype.run = function() {
          this.fun.apply(null, this.array);
        }, o.title = "browser", o.browser = true, o.env = {}, o.argv = [], o.version = "", o.versions = {}, o.on = m, o.addListener = m, o.once = m, o.off = m, o.removeListener = m, o.removeAllListeners = m, o.emit = m, o.prependListener = m, o.prependOnceListener = m, o.listeners = function(e2) {
          return [];
        }, o.binding = function(e2) {
          throw new Error("process.binding is not supported");
        }, o.cwd = function() {
          return "/";
        }, o.chdir = function(e2) {
          throw new Error("process.chdir is not supported");
        }, o.umask = function() {
          return 0;
        };
      }]);
    });
    SEMVER_SPEC_VERSION = module.exports.SEMVER_SPEC_VERSION;
    parse = module.exports.parse;
    valid = module.exports.valid;
    coerce = module.exports.coerce;
    clean = module.exports.clean;
    inc = module.exports.inc;
    major = module.exports.major;
    minor = module.exports.minor;
    patch = module.exports.patch;
    prerelease = module.exports.prerelease;
    gt = module.exports.gt;
    gte = module.exports.gte;
    lt = module.exports.lt;
    lte = module.exports.lte;
    eq = module.exports.eq;
    neq = module.exports.neq;
    cmp3 = module.exports.cmp;
    compare2 = module.exports.compare;
    rcompare = module.exports.rcompare;
    compareIdentifiers = module.exports.compareIdentifiers;
    rcompareIdentifiers = module.exports.rcompareIdentifiers;
    compareBuild = module.exports.compareBuild;
    sort = module.exports.sort;
    rsort = module.exports.rsort;
    diff = module.exports.diff;
    validRange = module.exports.validRange;
    satisfies = module.exports.satisfies;
    maxSatisfying = module.exports.maxSatisfying;
    minSatisfying = module.exports.minSatisfying;
    minVersion = module.exports.minVersion;
    gtr = module.exports.gtr;
    ltr = module.exports.ltr;
    outside = module.exports.outside;
    intersects = module.exports.intersects;
    SemVer = module.exports.SemVer;
    Comparator = module.exports.Comparator;
    Range = module.exports.Range;
  }
});

// out-build/vs/platform/extensions/common/extensionsApiProposals.js
var _allApiProposals, allApiProposals;
var init_extensionsApiProposals = __esm({
  "out-build/vs/platform/extensions/common/extensionsApiProposals.js"() {
    "use strict";
    _allApiProposals = {
      activeComment: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.activeComment.d.ts"
      },
      aiRelatedInformation: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.aiRelatedInformation.d.ts"
      },
      aiTextSearchProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.aiTextSearchProvider.d.ts",
        version: 2
      },
      authLearnMore: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.authLearnMore.d.ts"
      },
      authSession: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.authSession.d.ts"
      },
      canonicalUriProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.canonicalUriProvider.d.ts"
      },
      chatEditing: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatEditing.d.ts"
      },
      chatParticipantAdditions: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatParticipantAdditions.d.ts"
      },
      chatParticipantPrivate: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatParticipantPrivate.d.ts",
        version: 6
      },
      chatProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatProvider.d.ts"
      },
      chatReferenceBinaryData: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatReferenceBinaryData.d.ts"
      },
      chatReferenceDiagnostic: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatReferenceDiagnostic.d.ts"
      },
      chatStatusItem: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatStatusItem.d.ts"
      },
      chatTab: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.chatTab.d.ts"
      },
      codeActionAI: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.codeActionAI.d.ts"
      },
      codeActionRanges: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.codeActionRanges.d.ts"
      },
      codiconDecoration: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.codiconDecoration.d.ts"
      },
      commentReactor: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentReactor.d.ts"
      },
      commentReveal: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentReveal.d.ts"
      },
      commentThreadApplicability: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentThreadApplicability.d.ts"
      },
      commentingRangeHint: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentingRangeHint.d.ts"
      },
      commentsDraftState: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.commentsDraftState.d.ts"
      },
      contribAccessibilityHelpContent: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribAccessibilityHelpContent.d.ts"
      },
      contribCommentEditorActionsMenu: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribCommentEditorActionsMenu.d.ts"
      },
      contribCommentPeekContext: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribCommentPeekContext.d.ts"
      },
      contribCommentThreadAdditionalMenu: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribCommentThreadAdditionalMenu.d.ts"
      },
      contribCommentsViewThreadMenus: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribCommentsViewThreadMenus.d.ts"
      },
      contribDebugCreateConfiguration: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribDebugCreateConfiguration.d.ts"
      },
      contribDiffEditorGutterToolBarMenus: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribDiffEditorGutterToolBarMenus.d.ts"
      },
      contribEditSessions: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribEditSessions.d.ts"
      },
      contribEditorContentMenu: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribEditorContentMenu.d.ts"
      },
      contribLabelFormatterWorkspaceTooltip: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribLabelFormatterWorkspaceTooltip.d.ts"
      },
      contribMenuBarHome: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribMenuBarHome.d.ts"
      },
      contribMergeEditorMenus: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribMergeEditorMenus.d.ts"
      },
      contribMultiDiffEditorMenus: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribMultiDiffEditorMenus.d.ts"
      },
      contribNotebookStaticPreloads: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribNotebookStaticPreloads.d.ts"
      },
      contribRemoteHelp: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribRemoteHelp.d.ts"
      },
      contribShareMenu: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribShareMenu.d.ts"
      },
      contribSourceControlHistoryItemMenu: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlHistoryItemMenu.d.ts"
      },
      contribSourceControlHistoryTitleMenu: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlHistoryTitleMenu.d.ts"
      },
      contribSourceControlInputBoxMenu: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlInputBoxMenu.d.ts"
      },
      contribSourceControlTitleMenu: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribSourceControlTitleMenu.d.ts"
      },
      contribStatusBarItems: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribStatusBarItems.d.ts"
      },
      contribViewContainerTitle: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribViewContainerTitle.d.ts"
      },
      contribViewsRemote: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribViewsRemote.d.ts"
      },
      contribViewsWelcome: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.contribViewsWelcome.d.ts"
      },
      customEditorMove: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.customEditorMove.d.ts"
      },
      debugVisualization: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.debugVisualization.d.ts"
      },
      defaultChatParticipant: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.defaultChatParticipant.d.ts",
        version: 3
      },
      diffCommand: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.diffCommand.d.ts"
      },
      diffContentOptions: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.diffContentOptions.d.ts"
      },
      documentFiltersExclusive: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.documentFiltersExclusive.d.ts"
      },
      editSessionIdentityProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.editSessionIdentityProvider.d.ts"
      },
      editorHoverVerbosityLevel: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.editorHoverVerbosityLevel.d.ts"
      },
      editorInsets: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.editorInsets.d.ts"
      },
      embeddings: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.embeddings.d.ts"
      },
      extensionRuntime: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.extensionRuntime.d.ts"
      },
      extensionsAny: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.extensionsAny.d.ts"
      },
      externalUriOpener: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.externalUriOpener.d.ts"
      },
      fileSearchProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.fileSearchProvider.d.ts"
      },
      fileSearchProvider2: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.fileSearchProvider2.d.ts"
      },
      findFiles2: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.findFiles2.d.ts",
        version: 2
      },
      findTextInFiles: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.findTextInFiles.d.ts"
      },
      findTextInFiles2: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.findTextInFiles2.d.ts"
      },
      fsChunks: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.fsChunks.d.ts"
      },
      idToken: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.idToken.d.ts"
      },
      inlineCompletionsAdditions: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.inlineCompletionsAdditions.d.ts"
      },
      inlineEdit: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.inlineEdit.d.ts"
      },
      interactive: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.interactive.d.ts"
      },
      interactiveWindow: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.interactiveWindow.d.ts"
      },
      ipc: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.ipc.d.ts"
      },
      languageModelCapabilities: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelCapabilities.d.ts"
      },
      languageModelDataPart: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelDataPart.d.ts"
      },
      languageModelSystem: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelSystem.d.ts"
      },
      languageModelToolsForAgent: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageModelToolsForAgent.d.ts"
      },
      languageStatusText: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.languageStatusText.d.ts"
      },
      mappedEditsProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.mappedEditsProvider.d.ts"
      },
      mcpConfigurationProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.mcpConfigurationProvider.d.ts"
      },
      multiDocumentHighlightProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.multiDocumentHighlightProvider.d.ts"
      },
      nativeWindowHandle: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.nativeWindowHandle.d.ts"
      },
      newSymbolNamesProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.newSymbolNamesProvider.d.ts"
      },
      notebookCellExecution: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookCellExecution.d.ts"
      },
      notebookCellExecutionState: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookCellExecutionState.d.ts"
      },
      notebookControllerAffinityHidden: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookControllerAffinityHidden.d.ts"
      },
      notebookDeprecated: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookDeprecated.d.ts"
      },
      notebookExecution: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookExecution.d.ts"
      },
      notebookKernelSource: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookKernelSource.d.ts"
      },
      notebookLiveShare: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookLiveShare.d.ts"
      },
      notebookMessaging: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookMessaging.d.ts"
      },
      notebookMime: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookMime.d.ts"
      },
      notebookReplDocument: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookReplDocument.d.ts"
      },
      notebookVariableProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.notebookVariableProvider.d.ts"
      },
      portsAttributes: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.portsAttributes.d.ts"
      },
      profileContentHandlers: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.profileContentHandlers.d.ts"
      },
      quickDiffProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.quickDiffProvider.d.ts"
      },
      quickInputButtonLocation: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.quickInputButtonLocation.d.ts"
      },
      quickPickItemTooltip: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.quickPickItemTooltip.d.ts"
      },
      quickPickSortByLabel: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.quickPickSortByLabel.d.ts"
      },
      resolvers: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.resolvers.d.ts"
      },
      scmActionButton: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmActionButton.d.ts"
      },
      scmHistoryProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmHistoryProvider.d.ts"
      },
      scmMultiDiffEditor: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmMultiDiffEditor.d.ts"
      },
      scmSelectedProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmSelectedProvider.d.ts"
      },
      scmTextDocument: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmTextDocument.d.ts"
      },
      scmValidation: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.scmValidation.d.ts"
      },
      shareProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.shareProvider.d.ts"
      },
      speech: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.speech.d.ts"
      },
      statusBarItemTooltip: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.statusBarItemTooltip.d.ts"
      },
      tabInputMultiDiff: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tabInputMultiDiff.d.ts"
      },
      tabInputTextMerge: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tabInputTextMerge.d.ts"
      },
      taskPresentationGroup: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.taskPresentationGroup.d.ts"
      },
      taskProblemMatcherStatus: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.taskProblemMatcherStatus.d.ts"
      },
      telemetry: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.telemetry.d.ts"
      },
      terminalCompletionProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalCompletionProvider.d.ts"
      },
      terminalDataWriteEvent: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalDataWriteEvent.d.ts"
      },
      terminalDimensions: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalDimensions.d.ts"
      },
      terminalExecuteCommandEvent: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalExecuteCommandEvent.d.ts"
      },
      terminalQuickFixProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalQuickFixProvider.d.ts"
      },
      terminalSelection: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalSelection.d.ts"
      },
      terminalShellEnv: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.terminalShellEnv.d.ts"
      },
      testObserver: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.testObserver.d.ts"
      },
      testRelatedCode: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.testRelatedCode.d.ts"
      },
      textDocumentEncoding: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textDocumentEncoding.d.ts"
      },
      textEditorDiffInformation: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textEditorDiffInformation.d.ts"
      },
      textSearchComplete2: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textSearchComplete2.d.ts"
      },
      textSearchProvider: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textSearchProvider.d.ts"
      },
      textSearchProvider2: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.textSearchProvider2.d.ts"
      },
      timeline: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.timeline.d.ts"
      },
      tokenInformation: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tokenInformation.d.ts"
      },
      treeViewActiveItem: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.treeViewActiveItem.d.ts"
      },
      treeViewMarkdownMessage: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.treeViewMarkdownMessage.d.ts"
      },
      treeViewReveal: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.treeViewReveal.d.ts"
      },
      tunnelFactory: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tunnelFactory.d.ts"
      },
      tunnels: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.tunnels.d.ts"
      },
      valueSelectionInQuickPick: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.valueSelectionInQuickPick.d.ts"
      },
      workspaceTrust: {
        proposal: "https://raw.githubusercontent.com/microsoft/vscode/main/src/vscode-dts/vscode.proposed.workspaceTrust.d.ts"
      }
    };
    allApiProposals = Object.freeze(_allApiProposals);
  }
});

// out-build/vs/platform/extensions/common/extensionValidator.js
function $FB(version) {
  version = version.trim();
  return version === "*" || VERSION_REGEXP.test(version);
}
function $GB(version) {
  if (!$FB(version)) {
    return null;
  }
  version = version.trim();
  if (version === "*") {
    return {
      hasCaret: false,
      hasGreaterEquals: false,
      majorBase: 0,
      majorMustEqual: false,
      minorBase: 0,
      minorMustEqual: false,
      patchBase: 0,
      patchMustEqual: false,
      preRelease: null
    };
  }
  const m = version.match(VERSION_REGEXP);
  if (!m) {
    return null;
  }
  return {
    hasCaret: m[1] === "^",
    hasGreaterEquals: m[1] === ">=",
    majorBase: m[2] === "x" ? 0 : parseInt(m[2], 10),
    majorMustEqual: m[2] === "x" ? false : true,
    minorBase: m[4] === "x" ? 0 : parseInt(m[4], 10),
    minorMustEqual: m[4] === "x" ? false : true,
    patchBase: m[6] === "x" ? 0 : parseInt(m[6], 10),
    patchMustEqual: m[6] === "x" ? false : true,
    preRelease: m[8] || null
  };
}
function $HB(version) {
  if (!version) {
    return null;
  }
  const majorBase = version.majorBase;
  const majorMustEqual = version.majorMustEqual;
  const minorBase = version.minorBase;
  let minorMustEqual = version.minorMustEqual;
  const patchBase = version.patchBase;
  let patchMustEqual = version.patchMustEqual;
  if (version.hasCaret) {
    if (majorBase === 0) {
      patchMustEqual = false;
    } else {
      minorMustEqual = false;
      patchMustEqual = false;
    }
  }
  let notBefore = 0;
  if (version.preRelease) {
    const match = NOT_BEFORE_REGEXP.exec(version.preRelease);
    if (match) {
      const [, year2, month2, day2] = match;
      notBefore = Date.UTC(Number(year2), Number(month2) - 1, Number(day2));
    }
  }
  return {
    majorBase,
    majorMustEqual,
    minorBase,
    minorMustEqual,
    patchBase,
    patchMustEqual,
    isMinimum: version.hasGreaterEquals,
    notBefore
  };
}
function $IB(_inputVersion, _inputDate, _desiredVersion) {
  let version;
  if (typeof _inputVersion === "string") {
    version = $HB($GB(_inputVersion));
  } else {
    version = _inputVersion;
  }
  let productTs;
  if (_inputDate instanceof Date) {
    productTs = _inputDate.getTime();
  } else if (typeof _inputDate === "string") {
    productTs = new Date(_inputDate).getTime();
  }
  let desiredVersion;
  if (typeof _desiredVersion === "string") {
    desiredVersion = $HB($GB(_desiredVersion));
  } else {
    desiredVersion = _desiredVersion;
  }
  if (!version || !desiredVersion) {
    return false;
  }
  const majorBase = version.majorBase;
  const minorBase = version.minorBase;
  const patchBase = version.patchBase;
  let desiredMajorBase = desiredVersion.majorBase;
  let desiredMinorBase = desiredVersion.minorBase;
  let desiredPatchBase = desiredVersion.patchBase;
  const desiredNotBefore = desiredVersion.notBefore;
  let majorMustEqual = desiredVersion.majorMustEqual;
  let minorMustEqual = desiredVersion.minorMustEqual;
  let patchMustEqual = desiredVersion.patchMustEqual;
  if (desiredVersion.isMinimum) {
    if (majorBase > desiredMajorBase) {
      return true;
    }
    if (majorBase < desiredMajorBase) {
      return false;
    }
    if (minorBase > desiredMinorBase) {
      return true;
    }
    if (minorBase < desiredMinorBase) {
      return false;
    }
    if (productTs && productTs < desiredNotBefore) {
      return false;
    }
    return patchBase >= desiredPatchBase;
  }
  if (majorBase === 1 && desiredMajorBase === 0 && (!majorMustEqual || !minorMustEqual || !patchMustEqual)) {
    desiredMajorBase = 1;
    desiredMinorBase = 0;
    desiredPatchBase = 0;
    majorMustEqual = true;
    minorMustEqual = false;
    patchMustEqual = false;
  }
  if (majorBase < desiredMajorBase) {
    return false;
  }
  if (majorBase > desiredMajorBase) {
    return !majorMustEqual;
  }
  if (minorBase < desiredMinorBase) {
    return false;
  }
  if (minorBase > desiredMinorBase) {
    return !minorMustEqual;
  }
  if (patchBase < desiredPatchBase) {
    return false;
  }
  if (patchBase > desiredPatchBase) {
    return !patchMustEqual;
  }
  if (productTs && productTs < desiredNotBefore) {
    return false;
  }
  return true;
}
function $JB(productVersion, productDate, extensionLocation, extensionManifest, extensionIsBuiltin, validateApiVersion) {
  const validations = [];
  if (typeof extensionManifest.publisher !== "undefined" && typeof extensionManifest.publisher !== "string") {
    validations.push([severity_default.Error, localize(1973, null)]);
    return validations;
  }
  if (typeof extensionManifest.name !== "string") {
    validations.push([severity_default.Error, localize(1974, null, "name")]);
    return validations;
  }
  if (typeof extensionManifest.version !== "string") {
    validations.push([severity_default.Error, localize(1975, null, "version")]);
    return validations;
  }
  if (!extensionManifest.engines) {
    validations.push([severity_default.Error, localize(1976, null, "engines")]);
    return validations;
  }
  if (typeof extensionManifest.engines.vscode !== "string") {
    validations.push([severity_default.Error, localize(1977, null, "engines.vscode")]);
    return validations;
  }
  if (typeof extensionManifest.extensionDependencies !== "undefined") {
    if (!isStringArray(extensionManifest.extensionDependencies)) {
      validations.push([severity_default.Error, localize(1978, null, "extensionDependencies")]);
      return validations;
    }
  }
  if (typeof extensionManifest.activationEvents !== "undefined") {
    if (!isStringArray(extensionManifest.activationEvents)) {
      validations.push([severity_default.Error, localize(1979, null, "activationEvents")]);
      return validations;
    }
    if (typeof extensionManifest.main === "undefined" && typeof extensionManifest.browser === "undefined") {
      validations.push([severity_default.Error, localize(1980, null, "activationEvents", "main", "browser")]);
      return validations;
    }
  }
  if (typeof extensionManifest.extensionKind !== "undefined") {
    if (typeof extensionManifest.main === "undefined") {
      validations.push([severity_default.Warning, localize(1981, null, "extensionKind")]);
    }
  }
  if (typeof extensionManifest.main !== "undefined") {
    if (typeof extensionManifest.main !== "string") {
      validations.push([severity_default.Error, localize(1982, null, "main")]);
      return validations;
    } else {
      const mainLocation = $Ph(extensionLocation, extensionManifest.main);
      if (!$Jh(mainLocation, extensionLocation)) {
        validations.push([severity_default.Warning, localize(1983, null, mainLocation.path, extensionLocation.path)]);
      }
    }
  }
  if (typeof extensionManifest.browser !== "undefined") {
    if (typeof extensionManifest.browser !== "string") {
      validations.push([severity_default.Error, localize(1984, null, "browser")]);
      return validations;
    } else {
      const browserLocation = $Ph(extensionLocation, extensionManifest.browser);
      if (!$Jh(browserLocation, extensionLocation)) {
        validations.push([severity_default.Warning, localize(1985, null, browserLocation.path, extensionLocation.path)]);
      }
    }
  }
  if (!valid(extensionManifest.version)) {
    validations.push([severity_default.Error, localize(1986, null)]);
    return validations;
  }
  const notices = [];
  const validExtensionVersion = $KB(productVersion, productDate, extensionManifest, extensionIsBuiltin, notices);
  if (!validExtensionVersion) {
    for (const notice of notices) {
      validations.push([severity_default.Error, notice]);
    }
  }
  if (validateApiVersion && extensionManifest.enabledApiProposals?.length) {
    const incompatibleNotices = [];
    if (!$MB([...extensionManifest.enabledApiProposals], incompatibleNotices)) {
      for (const notice of incompatibleNotices) {
        validations.push([severity_default.Error, notice]);
      }
    }
  }
  return validations;
}
function $KB(productVersion, productDate, extensionManifest, extensionIsBuiltin, notices) {
  if (extensionIsBuiltin || typeof extensionManifest.main === "undefined" && typeof extensionManifest.browser === "undefined") {
    return true;
  }
  return isVersionValid(productVersion, productDate, extensionManifest.engines.vscode, notices);
}
function $LB(engine, version, date) {
  return engine === "*" || isVersionValid(version, date, engine);
}
function $MB(apiProposals, arg1) {
  if (apiProposals.length === 0) {
    return true;
  }
  const notices = Array.isArray(arg1) ? arg1 : void 0;
  const productApiProposals = (notices ? void 0 : arg1) ?? allApiProposals;
  const incompatibleProposals = [];
  const parsedProposals = $UA(apiProposals);
  for (const { proposalName, version } of parsedProposals) {
    if (!version) {
      continue;
    }
    const existingProposal = productApiProposals[proposalName];
    if (existingProposal?.version !== version) {
      incompatibleProposals.push(proposalName);
    }
  }
  if (incompatibleProposals.length) {
    if (notices) {
      if (incompatibleProposals.length === 1) {
        notices.push(localize(1987, null, incompatibleProposals[0]));
      } else {
        notices.push(localize(1988, null, incompatibleProposals.slice(0, incompatibleProposals.length - 1).map((p) => `'${p}'`).join(", "), incompatibleProposals[incompatibleProposals.length - 1]));
      }
    }
    return false;
  }
  return true;
}
function isVersionValid(currentVersion, date, requestedVersion, notices = []) {
  const desiredVersion = $HB($GB(requestedVersion));
  if (!desiredVersion) {
    notices.push(localize(1989, null, requestedVersion));
    return false;
  }
  if (desiredVersion.majorBase === 0) {
    if (!desiredVersion.majorMustEqual || !desiredVersion.minorMustEqual) {
      notices.push(localize(1990, null, requestedVersion));
      return false;
    }
  } else {
    if (!desiredVersion.majorMustEqual) {
      notices.push(localize(1991, null, requestedVersion));
      return false;
    }
  }
  if (!$IB(currentVersion, date, desiredVersion)) {
    notices.push(localize(1992, null, currentVersion, requestedVersion));
    return false;
  }
  return true;
}
function isStringArray(arr) {
  if (!Array.isArray(arr)) {
    return false;
  }
  for (let i = 0, len = arr.length; i < len; i++) {
    if (typeof arr[i] !== "string") {
      return false;
    }
  }
  return true;
}
var VERSION_REGEXP, NOT_BEFORE_REGEXP;
var init_extensionValidator = __esm({
  "out-build/vs/platform/extensions/common/extensionValidator.js"() {
    "use strict";
    init_resources();
    init_severity();
    init_nls2();
    init_semver();
    init_extensions();
    init_extensionsApiProposals();
    VERSION_REGEXP = /^(\^|>=)?((\d+)|x)\.((\d+)|x)\.((\d+)|x)(\-.*)?$/;
    NOT_BEFORE_REGEXP = /^-(\d{4})(\d{2})(\d{2})$/;
  }
});

// out-build/vs/base/common/ternarySearchTree.js
var $ml, $nl, $ol, UriIteratorState, $pl, Undef, TernarySearchTreeNode, Dir, $ql;
var init_ternarySearchTree = __esm({
  "out-build/vs/base/common/ternarySearchTree.js"() {
    "use strict";
    init_arrays();
    init_strings();
    $ml = class {
      constructor() {
        this.b = "";
        this.c = 0;
      }
      reset(key) {
        this.b = key;
        this.c = 0;
        return this;
      }
      next() {
        this.c += 1;
        return this;
      }
      hasNext() {
        return this.c < this.b.length - 1;
      }
      cmp(a) {
        const aCode = a.charCodeAt(0);
        const thisCode = this.b.charCodeAt(this.c);
        return aCode - thisCode;
      }
      value() {
        return this.b[this.c];
      }
    };
    $nl = class {
      constructor(e = true) {
        this.e = e;
      }
      reset(key) {
        this.b = key;
        this.c = 0;
        this.d = 0;
        return this.next();
      }
      hasNext() {
        return this.d < this.b.length;
      }
      next() {
        this.c = this.d;
        let justSeps = true;
        for (; this.d < this.b.length; this.d++) {
          const ch = this.b.charCodeAt(this.d);
          if (ch === 46) {
            if (justSeps) {
              this.c++;
            } else {
              break;
            }
          } else {
            justSeps = false;
          }
        }
        return this;
      }
      cmp(a) {
        return this.e ? $sg(a, this.b, 0, a.length, this.c, this.d) : $ug(a, this.b, 0, a.length, this.c, this.d);
      }
      value() {
        return this.b.substring(this.c, this.d);
      }
    };
    $ol = class {
      constructor(f = true, g = true) {
        this.f = f;
        this.g = g;
      }
      reset(key) {
        this.d = 0;
        this.e = 0;
        this.b = key;
        this.c = key.length;
        for (let pos = key.length - 1; pos >= 0; pos--, this.c--) {
          const ch = this.b.charCodeAt(pos);
          if (!(ch === 47 || this.f && ch === 92)) {
            break;
          }
        }
        return this.next();
      }
      hasNext() {
        return this.e < this.c;
      }
      next() {
        this.d = this.e;
        let justSeps = true;
        for (; this.e < this.c; this.e++) {
          const ch = this.b.charCodeAt(this.e);
          if (ch === 47 || this.f && ch === 92) {
            if (justSeps) {
              this.d++;
            } else {
              break;
            }
          } else {
            justSeps = false;
          }
        }
        return this;
      }
      cmp(a) {
        return this.g ? $sg(a, this.b, 0, a.length, this.d, this.e) : $ug(a, this.b, 0, a.length, this.d, this.e);
      }
      value() {
        return this.b.substring(this.d, this.e);
      }
    };
    (function(UriIteratorState2) {
      UriIteratorState2[UriIteratorState2["Scheme"] = 1] = "Scheme";
      UriIteratorState2[UriIteratorState2["Authority"] = 2] = "Authority";
      UriIteratorState2[UriIteratorState2["Path"] = 3] = "Path";
      UriIteratorState2[UriIteratorState2["Query"] = 4] = "Query";
      UriIteratorState2[UriIteratorState2["Fragment"] = 5] = "Fragment";
    })(UriIteratorState || (UriIteratorState = {}));
    $pl = class {
      constructor(f, g) {
        this.f = f;
        this.g = g;
        this.d = [];
        this.e = 0;
      }
      reset(key) {
        this.c = key;
        this.d = [];
        if (this.c.scheme) {
          this.d.push(
            1
            /* UriIteratorState.Scheme */
          );
        }
        if (this.c.authority) {
          this.d.push(
            2
            /* UriIteratorState.Authority */
          );
        }
        if (this.c.path) {
          this.b = new $ol(false, !this.f(key));
          this.b.reset(key.path);
          if (this.b.value()) {
            this.d.push(
              3
              /* UriIteratorState.Path */
            );
          }
        }
        if (!this.g(key)) {
          if (this.c.query) {
            this.d.push(
              4
              /* UriIteratorState.Query */
            );
          }
          if (this.c.fragment) {
            this.d.push(
              5
              /* UriIteratorState.Fragment */
            );
          }
        }
        this.e = 0;
        return this;
      }
      next() {
        if (this.d[this.e] === 3 && this.b.hasNext()) {
          this.b.next();
        } else {
          this.e += 1;
        }
        return this;
      }
      hasNext() {
        return this.d[this.e] === 3 && this.b.hasNext() || this.e < this.d.length - 1;
      }
      cmp(a) {
        if (this.d[this.e] === 1) {
          return $tg(a, this.c.scheme);
        } else if (this.d[this.e] === 2) {
          return $tg(a, this.c.authority);
        } else if (this.d[this.e] === 3) {
          return this.b.cmp(a);
        } else if (this.d[this.e] === 4) {
          return $rg(a, this.c.query);
        } else if (this.d[this.e] === 5) {
          return $rg(a, this.c.fragment);
        }
        throw new Error();
      }
      value() {
        if (this.d[this.e] === 1) {
          return this.c.scheme;
        } else if (this.d[this.e] === 2) {
          return this.c.authority;
        } else if (this.d[this.e] === 3) {
          return this.b.value();
        } else if (this.d[this.e] === 4) {
          return this.c.query;
        } else if (this.d[this.e] === 5) {
          return this.c.fragment;
        }
        throw new Error();
      }
    };
    Undef = class _Undef {
      static {
        this.Val = Symbol("undefined_placeholder");
      }
      static wrap(value) {
        return value === void 0 ? _Undef.Val : value;
      }
      static unwrap(value) {
        return value === _Undef.Val ? void 0 : value;
      }
    };
    TernarySearchTreeNode = class {
      constructor() {
        this.height = 1;
      }
      isEmpty() {
        return !this.left && !this.mid && !this.right && this.value === void 0;
      }
      rotateLeft() {
        const tmp = this.right;
        this.right = tmp.left;
        tmp.left = this;
        this.updateHeight();
        tmp.updateHeight();
        return tmp;
      }
      rotateRight() {
        const tmp = this.left;
        this.left = tmp.right;
        tmp.right = this;
        this.updateHeight();
        tmp.updateHeight();
        return tmp;
      }
      updateHeight() {
        this.height = 1 + Math.max(this.heightLeft, this.heightRight);
      }
      balanceFactor() {
        return this.heightRight - this.heightLeft;
      }
      get heightLeft() {
        return this.left?.height ?? 0;
      }
      get heightRight() {
        return this.right?.height ?? 0;
      }
    };
    (function(Dir2) {
      Dir2[Dir2["Left"] = -1] = "Left";
      Dir2[Dir2["Mid"] = 0] = "Mid";
      Dir2[Dir2["Right"] = 1] = "Right";
    })(Dir || (Dir = {}));
    $ql = class _$ql {
      static forUris(ignorePathCasing = () => false, ignoreQueryAndFragment = () => false) {
        return new _$ql(new $pl(ignorePathCasing, ignoreQueryAndFragment));
      }
      static forPaths(ignorePathCasing = false) {
        return new _$ql(new $ol(void 0, !ignorePathCasing));
      }
      static forStrings() {
        return new _$ql(new $ml());
      }
      static forConfigKeys() {
        return new _$ql(new $nl());
      }
      constructor(segments) {
        this.b = segments;
      }
      clear() {
        this.c = void 0;
      }
      fill(values, keys) {
        if (keys) {
          const arr = keys.slice(0);
          $Yb(arr);
          for (const k of arr) {
            this.set(k, values);
          }
        } else {
          const arr = values.slice(0);
          $Yb(arr);
          for (const entry of arr) {
            this.set(entry[0], entry[1]);
          }
        }
      }
      set(key, element) {
        const iter = this.b.reset(key);
        let node;
        if (!this.c) {
          this.c = new TernarySearchTreeNode();
          this.c.segment = iter.value();
        }
        const stack = [];
        node = this.c;
        while (true) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            if (!node.left) {
              node.left = new TernarySearchTreeNode();
              node.left.segment = iter.value();
            }
            stack.push([-1, node]);
            node = node.left;
          } else if (val < 0) {
            if (!node.right) {
              node.right = new TernarySearchTreeNode();
              node.right.segment = iter.value();
            }
            stack.push([1, node]);
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            if (!node.mid) {
              node.mid = new TernarySearchTreeNode();
              node.mid.segment = iter.value();
            }
            stack.push([0, node]);
            node = node.mid;
          } else {
            break;
          }
        }
        const oldElement = Undef.unwrap(node.value);
        node.value = Undef.wrap(element);
        node.key = key;
        for (let i = stack.length - 1; i >= 0; i--) {
          const node2 = stack[i][1];
          node2.updateHeight();
          const bf = node2.balanceFactor();
          if (bf < -1 || bf > 1) {
            const d1 = stack[i][0];
            const d2 = stack[i + 1][0];
            if (d1 === 1 && d2 === 1) {
              stack[i][1] = node2.rotateLeft();
            } else if (d1 === -1 && d2 === -1) {
              stack[i][1] = node2.rotateRight();
            } else if (d1 === 1 && d2 === -1) {
              node2.right = stack[i + 1][1] = stack[i + 1][1].rotateRight();
              stack[i][1] = node2.rotateLeft();
            } else if (d1 === -1 && d2 === 1) {
              node2.left = stack[i + 1][1] = stack[i + 1][1].rotateLeft();
              stack[i][1] = node2.rotateRight();
            } else {
              throw new Error();
            }
            if (i > 0) {
              switch (stack[i - 1][0]) {
                case -1:
                  stack[i - 1][1].left = stack[i][1];
                  break;
                case 1:
                  stack[i - 1][1].right = stack[i][1];
                  break;
                case 0:
                  stack[i - 1][1].mid = stack[i][1];
                  break;
              }
            } else {
              this.c = stack[0][1];
            }
          }
        }
        return oldElement;
      }
      get(key) {
        return Undef.unwrap(this.d(key)?.value);
      }
      d(key) {
        const iter = this.b.reset(key);
        let node = this.c;
        while (node) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            node = node.left;
          } else if (val < 0) {
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            node = node.mid;
          } else {
            break;
          }
        }
        return node;
      }
      has(key) {
        const node = this.d(key);
        return !(node?.value === void 0 && node?.mid === void 0);
      }
      delete(key) {
        return this.e(key, false);
      }
      deleteSuperstr(key) {
        return this.e(key, true);
      }
      e(key, superStr) {
        const iter = this.b.reset(key);
        const stack = [];
        let node = this.c;
        while (node) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            stack.push([-1, node]);
            node = node.left;
          } else if (val < 0) {
            stack.push([1, node]);
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            stack.push([0, node]);
            node = node.mid;
          } else {
            break;
          }
        }
        if (!node) {
          return;
        }
        if (superStr) {
          node.left = void 0;
          node.mid = void 0;
          node.right = void 0;
          node.height = 1;
        } else {
          node.key = void 0;
          node.value = void 0;
        }
        if (!node.mid && !node.value) {
          if (node.left && node.right) {
            const min = this.f(node.right);
            if (min.key) {
              const { key: key2, value, segment } = min;
              this.e(min.key, false);
              node.key = key2;
              node.value = value;
              node.segment = segment;
            }
          } else {
            const newChild = node.left ?? node.right;
            if (stack.length > 0) {
              const [dir, parent] = stack[stack.length - 1];
              switch (dir) {
                case -1:
                  parent.left = newChild;
                  break;
                case 0:
                  parent.mid = newChild;
                  break;
                case 1:
                  parent.right = newChild;
                  break;
              }
            } else {
              this.c = newChild;
            }
          }
        }
        for (let i = stack.length - 1; i >= 0; i--) {
          const node2 = stack[i][1];
          node2.updateHeight();
          const bf = node2.balanceFactor();
          if (bf > 1) {
            if (node2.right.balanceFactor() >= 0) {
              stack[i][1] = node2.rotateLeft();
            } else {
              node2.right = node2.right.rotateRight();
              stack[i][1] = node2.rotateLeft();
            }
          } else if (bf < -1) {
            if (node2.left.balanceFactor() <= 0) {
              stack[i][1] = node2.rotateRight();
            } else {
              node2.left = node2.left.rotateLeft();
              stack[i][1] = node2.rotateRight();
            }
          }
          if (i > 0) {
            switch (stack[i - 1][0]) {
              case -1:
                stack[i - 1][1].left = stack[i][1];
                break;
              case 1:
                stack[i - 1][1].right = stack[i][1];
                break;
              case 0:
                stack[i - 1][1].mid = stack[i][1];
                break;
            }
          } else {
            this.c = stack[0][1];
          }
        }
      }
      f(node) {
        while (node.left) {
          node = node.left;
        }
        return node;
      }
      findSubstr(key) {
        const iter = this.b.reset(key);
        let node = this.c;
        let candidate = void 0;
        while (node) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            node = node.left;
          } else if (val < 0) {
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            candidate = Undef.unwrap(node.value) || candidate;
            node = node.mid;
          } else {
            break;
          }
        }
        return node && Undef.unwrap(node.value) || candidate;
      }
      findSuperstr(key) {
        return this.g(key, false);
      }
      g(key, allowValue) {
        const iter = this.b.reset(key);
        let node = this.c;
        while (node) {
          const val = iter.cmp(node.segment);
          if (val > 0) {
            node = node.left;
          } else if (val < 0) {
            node = node.right;
          } else if (iter.hasNext()) {
            iter.next();
            node = node.mid;
          } else {
            if (!node.mid) {
              if (allowValue) {
                return Undef.unwrap(node.value);
              } else {
                return void 0;
              }
            } else {
              return this.h(node.mid);
            }
          }
        }
        return void 0;
      }
      hasElementOrSubtree(key) {
        return this.g(key, true) !== void 0;
      }
      forEach(callback) {
        for (const [key, value] of this) {
          callback(value, key);
        }
      }
      *[Symbol.iterator]() {
        yield* this.h(this.c);
      }
      h(node) {
        const result = [];
        this.j(node, result);
        return result[Symbol.iterator]();
      }
      j(node, bucket) {
        if (!node) {
          return;
        }
        if (node.left) {
          this.j(node.left, bucket);
        }
        if (node.value !== void 0) {
          bucket.push([node.key, Undef.unwrap(node.value)]);
        }
        if (node.mid) {
          this.j(node.mid, bucket);
        }
        if (node.right) {
          this.j(node.right, bucket);
        }
      }
      // for debug/testing
      _isBalanced() {
        const nodeIsBalanced = (node) => {
          if (!node) {
            return true;
          }
          const bf = node.balanceFactor();
          if (bf < -1 || bf > 1) {
            return false;
          }
          return nodeIsBalanced(node.left) && nodeIsBalanced(node.right);
        };
        return nodeIsBalanced(this.c);
      }
    };
  }
});

// out-build/vs/platform/files/common/files.js
function $Tm(options2) {
  return options2.create === true;
}
function $Vm(provider) {
  return !!(provider.capabilities & 2);
}
function $Wm(provider) {
  return !!(provider.capabilities & 8);
}
function $Xm(provider) {
  return !!(provider.capabilities & 131072);
}
function $Ym(provider) {
  return !!(provider.capabilities & 4);
}
function $Zm(provider) {
  return !!(provider.capabilities & 16);
}
function $1m(provider) {
  if (!$Vm(provider)) {
    return false;
  }
  return !!(provider.capabilities & 16384);
}
function $2m(provider) {
  if (!$Vm(provider)) {
    return false;
  }
  return !!(provider.capabilities & 32768);
}
function $3m(provider) {
  return !!(provider.capabilities & 65536);
}
function $6m(error, code) {
  return $5m.create(error, code);
}
function $7m(error) {
  if (!error) {
    return $6m(localize(2007, null), FileSystemProviderErrorCode.Unknown);
  }
  return error;
}
function $8m(error, code) {
  error.name = code ? `${code} (FileSystemError)` : `FileSystemError`;
  return error;
}
function $9m(error) {
  if (!error) {
    return FileSystemProviderErrorCode.Unknown;
  }
  if (error instanceof $5m) {
    return error.code;
  }
  const match = /^(.+) \(FileSystemError\)$/.exec(error.name);
  if (!match) {
    return FileSystemProviderErrorCode.Unknown;
  }
  switch (match[1]) {
    case FileSystemProviderErrorCode.FileExists:
      return FileSystemProviderErrorCode.FileExists;
    case FileSystemProviderErrorCode.FileIsADirectory:
      return FileSystemProviderErrorCode.FileIsADirectory;
    case FileSystemProviderErrorCode.FileNotADirectory:
      return FileSystemProviderErrorCode.FileNotADirectory;
    case FileSystemProviderErrorCode.FileNotFound:
      return FileSystemProviderErrorCode.FileNotFound;
    case FileSystemProviderErrorCode.FileTooLarge:
      return FileSystemProviderErrorCode.FileTooLarge;
    case FileSystemProviderErrorCode.FileWriteLocked:
      return FileSystemProviderErrorCode.FileWriteLocked;
    case FileSystemProviderErrorCode.NoPermissions:
      return FileSystemProviderErrorCode.NoPermissions;
    case FileSystemProviderErrorCode.Unavailable:
      return FileSystemProviderErrorCode.Unavailable;
  }
  return FileSystemProviderErrorCode.Unknown;
}
function $0m(error) {
  if (error instanceof $bn) {
    return error.fileOperationResult;
  }
  switch ($9m(error)) {
    case FileSystemProviderErrorCode.FileNotFound:
      return 1;
    case FileSystemProviderErrorCode.FileIsADirectory:
      return 0;
    case FileSystemProviderErrorCode.FileNotADirectory:
      return 9;
    case FileSystemProviderErrorCode.FileWriteLocked:
      return 5;
    case FileSystemProviderErrorCode.NoPermissions:
      return 6;
    case FileSystemProviderErrorCode.FileExists:
      return 4;
    case FileSystemProviderErrorCode.FileTooLarge:
      return 7;
    default:
      return 10;
  }
}
function $an(path7, candidate, ignoreCase) {
  if (!path7 || !candidate || path7 === candidate) {
    return false;
  }
  if (candidate.length > path7.length) {
    return false;
  }
  if (candidate.charAt(candidate.length - 1) !== sep) {
    candidate += sep;
  }
  if (ignoreCase) {
    return $zg(path7, candidate);
  }
  return path7.indexOf(candidate) === 0;
}
function $mn(stat) {
  if (typeof stat.size !== "number" || typeof stat.mtime !== "number") {
    return void 0;
  }
  return stat.mtime.toString(29) + stat.size.toString(31);
}
var $Sm, FileType, FilePermission, FileChangeFilter, FileSystemProviderCapabilities, FileSystemProviderErrorCode, $5m, FileOperation, $$m, FileChangeType, $_m, $bn, $cn, $dn, FileOperationResult, FileKind, $ln, $on;
var init_files = __esm({
  "out-build/vs/platform/files/common/files.js"() {
    "use strict";
    init_ternarySearchTree();
    init_path();
    init_strings();
    init_types();
    init_uri();
    init_nls2();
    init_instantiation();
    init_platform();
    init_network();
    init_lazy();
    $Sm = $kl("fileService");
    (function(FileType2) {
      FileType2[FileType2["Unknown"] = 0] = "Unknown";
      FileType2[FileType2["File"] = 1] = "File";
      FileType2[FileType2["Directory"] = 2] = "Directory";
      FileType2[FileType2["SymbolicLink"] = 64] = "SymbolicLink";
    })(FileType || (FileType = {}));
    (function(FilePermission2) {
      FilePermission2[FilePermission2["Readonly"] = 1] = "Readonly";
      FilePermission2[FilePermission2["Locked"] = 2] = "Locked";
    })(FilePermission || (FilePermission = {}));
    (function(FileChangeFilter2) {
      FileChangeFilter2[FileChangeFilter2["UPDATED"] = 2] = "UPDATED";
      FileChangeFilter2[FileChangeFilter2["ADDED"] = 4] = "ADDED";
      FileChangeFilter2[FileChangeFilter2["DELETED"] = 8] = "DELETED";
    })(FileChangeFilter || (FileChangeFilter = {}));
    (function(FileSystemProviderCapabilities2) {
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["None"] = 0] = "None";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileReadWrite"] = 2] = "FileReadWrite";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileOpenReadWriteClose"] = 4] = "FileOpenReadWriteClose";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileReadStream"] = 16] = "FileReadStream";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileFolderCopy"] = 8] = "FileFolderCopy";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["PathCaseSensitive"] = 1024] = "PathCaseSensitive";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["Readonly"] = 2048] = "Readonly";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["Trash"] = 4096] = "Trash";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileWriteUnlock"] = 8192] = "FileWriteUnlock";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileAtomicRead"] = 16384] = "FileAtomicRead";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileAtomicWrite"] = 32768] = "FileAtomicWrite";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileAtomicDelete"] = 65536] = "FileAtomicDelete";
      FileSystemProviderCapabilities2[FileSystemProviderCapabilities2["FileClone"] = 131072] = "FileClone";
    })(FileSystemProviderCapabilities || (FileSystemProviderCapabilities = {}));
    (function(FileSystemProviderErrorCode2) {
      FileSystemProviderErrorCode2["FileExists"] = "EntryExists";
      FileSystemProviderErrorCode2["FileNotFound"] = "EntryNotFound";
      FileSystemProviderErrorCode2["FileNotADirectory"] = "EntryNotADirectory";
      FileSystemProviderErrorCode2["FileIsADirectory"] = "EntryIsADirectory";
      FileSystemProviderErrorCode2["FileExceedsStorageQuota"] = "EntryExceedsStorageQuota";
      FileSystemProviderErrorCode2["FileTooLarge"] = "EntryTooLarge";
      FileSystemProviderErrorCode2["FileWriteLocked"] = "EntryWriteLocked";
      FileSystemProviderErrorCode2["NoPermissions"] = "NoPermissions";
      FileSystemProviderErrorCode2["Unavailable"] = "Unavailable";
      FileSystemProviderErrorCode2["Unknown"] = "Unknown";
    })(FileSystemProviderErrorCode || (FileSystemProviderErrorCode = {}));
    $5m = class _$5m extends Error {
      static create(error, code) {
        const providerError = new _$5m(error.toString(), code);
        $8m(providerError, code);
        return providerError;
      }
      constructor(message, code) {
        super(message);
        this.code = code;
      }
    };
    (function(FileOperation2) {
      FileOperation2[FileOperation2["CREATE"] = 0] = "CREATE";
      FileOperation2[FileOperation2["DELETE"] = 1] = "DELETE";
      FileOperation2[FileOperation2["MOVE"] = 2] = "MOVE";
      FileOperation2[FileOperation2["COPY"] = 3] = "COPY";
      FileOperation2[FileOperation2["WRITE"] = 4] = "WRITE";
    })(FileOperation || (FileOperation = {}));
    $$m = class {
      constructor(resource, operation, target) {
        this.resource = resource;
        this.operation = operation;
        this.target = target;
      }
      isOperation(operation) {
        return this.operation === operation;
      }
    };
    (function(FileChangeType3) {
      FileChangeType3[FileChangeType3["UPDATED"] = 0] = "UPDATED";
      FileChangeType3[FileChangeType3["ADDED"] = 1] = "ADDED";
      FileChangeType3[FileChangeType3["DELETED"] = 2] = "DELETED";
    })(FileChangeType || (FileChangeType = {}));
    $_m = class _$_m {
      static {
        this.a = null;
      }
      constructor(changes, c) {
        this.c = c;
        this.b = void 0;
        this.d = new $3f(() => {
          const added = $ql.forUris(() => this.c);
          added.fill(this.rawAdded.map((resource) => [resource, true]));
          return added;
        });
        this.f = new $3f(() => {
          const updated = $ql.forUris(() => this.c);
          updated.fill(this.rawUpdated.map((resource) => [resource, true]));
          return updated;
        });
        this.g = new $3f(() => {
          const deleted = $ql.forUris(() => this.c);
          deleted.fill(this.rawDeleted.map((resource) => [resource, true]));
          return deleted;
        });
        this.rawAdded = [];
        this.rawUpdated = [];
        this.rawDeleted = [];
        for (const change of changes) {
          switch (change.type) {
            case 1:
              this.rawAdded.push(change.resource);
              break;
            case 0:
              this.rawUpdated.push(change.resource);
              break;
            case 2:
              this.rawDeleted.push(change.resource);
              break;
          }
          if (this.b !== _$_m.a) {
            if (typeof change.cId === "number") {
              if (this.b === void 0) {
                this.b = change.cId;
              } else if (this.b !== change.cId) {
                this.b = _$_m.a;
              }
            } else {
              if (this.b !== void 0) {
                this.b = _$_m.a;
              }
            }
          }
        }
      }
      /**
       * Find out if the file change events match the provided resource.
       *
       * Note: when passing `FileChangeType.DELETED`, we consider a match
       * also when the parent of the resource got deleted.
       */
      contains(resource, ...types) {
        return this.h(resource, { includeChildren: false }, ...types);
      }
      /**
       * Find out if the file change events either match the provided
       * resource, or contain a child of this resource.
       */
      affects(resource, ...types) {
        return this.h(resource, { includeChildren: true }, ...types);
      }
      h(resource, options2, ...types) {
        if (!resource) {
          return false;
        }
        const hasTypesFilter = types.length > 0;
        if (!hasTypesFilter || types.includes(
          1
          /* FileChangeType.ADDED */
        )) {
          if (this.d.value.get(resource)) {
            return true;
          }
          if (options2.includeChildren && this.d.value.findSuperstr(resource)) {
            return true;
          }
        }
        if (!hasTypesFilter || types.includes(
          0
          /* FileChangeType.UPDATED */
        )) {
          if (this.f.value.get(resource)) {
            return true;
          }
          if (options2.includeChildren && this.f.value.findSuperstr(resource)) {
            return true;
          }
        }
        if (!hasTypesFilter || types.includes(
          2
          /* FileChangeType.DELETED */
        )) {
          if (this.g.value.findSubstr(resource)) {
            return true;
          }
          if (options2.includeChildren && this.g.value.findSuperstr(resource)) {
            return true;
          }
        }
        return false;
      }
      /**
       * Returns if this event contains added files.
       */
      gotAdded() {
        return this.rawAdded.length > 0;
      }
      /**
       * Returns if this event contains deleted files.
       */
      gotDeleted() {
        return this.rawDeleted.length > 0;
      }
      /**
       * Returns if this event contains updated files.
       */
      gotUpdated() {
        return this.rawUpdated.length > 0;
      }
      /**
       * Returns if this event contains changes that correlate to the
       * provided `correlationId`.
       *
       * File change event correlation is an advanced watch feature that
       * allows to  identify from which watch request the events originate
       * from. This correlation allows to route events specifically
       * only to the requestor and not emit them to all listeners.
       */
      correlates(correlationId) {
        return this.b === correlationId;
      }
      /**
       * Figure out if the event contains changes that correlate to one
       * correlation identifier.
       *
       * File change event correlation is an advanced watch feature that
       * allows to  identify from which watch request the events originate
       * from. This correlation allows to route events specifically
       * only to the requestor and not emit them to all listeners.
       */
      hasCorrelation() {
        return typeof this.b === "number";
      }
    };
    $bn = class extends Error {
      constructor(message, fileOperationResult, options2) {
        super(message);
        this.fileOperationResult = fileOperationResult;
        this.options = options2;
      }
    };
    $cn = class extends $bn {
      constructor(message, fileOperationResult, size, options2) {
        super(message, fileOperationResult, options2);
        this.fileOperationResult = fileOperationResult;
        this.size = size;
      }
    };
    $dn = class extends $bn {
      constructor(message, stat, options2) {
        super(message, 2, options2);
        this.stat = stat;
      }
    };
    (function(FileOperationResult2) {
      FileOperationResult2[FileOperationResult2["FILE_IS_DIRECTORY"] = 0] = "FILE_IS_DIRECTORY";
      FileOperationResult2[FileOperationResult2["FILE_NOT_FOUND"] = 1] = "FILE_NOT_FOUND";
      FileOperationResult2[FileOperationResult2["FILE_NOT_MODIFIED_SINCE"] = 2] = "FILE_NOT_MODIFIED_SINCE";
      FileOperationResult2[FileOperationResult2["FILE_MODIFIED_SINCE"] = 3] = "FILE_MODIFIED_SINCE";
      FileOperationResult2[FileOperationResult2["FILE_MOVE_CONFLICT"] = 4] = "FILE_MOVE_CONFLICT";
      FileOperationResult2[FileOperationResult2["FILE_WRITE_LOCKED"] = 5] = "FILE_WRITE_LOCKED";
      FileOperationResult2[FileOperationResult2["FILE_PERMISSION_DENIED"] = 6] = "FILE_PERMISSION_DENIED";
      FileOperationResult2[FileOperationResult2["FILE_TOO_LARGE"] = 7] = "FILE_TOO_LARGE";
      FileOperationResult2[FileOperationResult2["FILE_INVALID_PATH"] = 8] = "FILE_INVALID_PATH";
      FileOperationResult2[FileOperationResult2["FILE_NOT_DIRECTORY"] = 9] = "FILE_NOT_DIRECTORY";
      FileOperationResult2[FileOperationResult2["FILE_OTHER_ERROR"] = 10] = "FILE_OTHER_ERROR";
    })(FileOperationResult || (FileOperationResult = {}));
    (function(FileKind2) {
      FileKind2[FileKind2["FILE"] = 0] = "FILE";
      FileKind2[FileKind2["FOLDER"] = 1] = "FOLDER";
      FileKind2[FileKind2["ROOT_FOLDER"] = 2] = "ROOT_FOLDER";
    })(FileKind || (FileKind = {}));
    $ln = "";
    $on = class _$on {
      static {
        this.KB = 1024;
      }
      static {
        this.MB = _$on.KB * _$on.KB;
      }
      static {
        this.GB = _$on.MB * _$on.KB;
      }
      static {
        this.TB = _$on.GB * _$on.KB;
      }
      static formatSize(size) {
        if (!$1c(size)) {
          size = 0;
        }
        if (size < _$on.KB) {
          return localize(2008, null, size.toFixed(0));
        }
        if (size < _$on.MB) {
          return localize(2009, null, (size / _$on.KB).toFixed(2));
        }
        if (size < _$on.GB) {
          return localize(2010, null, (size / _$on.MB).toFixed(2));
        }
        if (size < _$on.TB) {
          return localize(2011, null, (size / _$on.GB).toFixed(2));
        }
        return localize(2012, null, (size / _$on.TB).toFixed(2));
      }
    };
  }
});

// out-build/vs/platform/product/common/productService.js
var $Dv;
var init_productService = __esm({
  "out-build/vs/platform/product/common/productService.js"() {
    "use strict";
    init_instantiation();
    $Dv = $kl("productService");
  }
});

// out-build/vs/platform/externalServices/common/serviceMachineId.js
async function $Mw(environmentService, fileService, storageService) {
  let uuid = storageService ? storageService.get(
    "storage.serviceMachineId",
    -1
    /* StorageScope.APPLICATION */
  ) || null : null;
  if (uuid) {
    return uuid;
  }
  try {
    const contents = await fileService.readFile(environmentService.serviceMachineIdResource);
    const value = contents.value.toString();
    uuid = $5s(value) ? value : null;
  } catch (e) {
    uuid = null;
  }
  if (!uuid) {
    uuid = $6s();
    try {
      await fileService.writeFile(environmentService.serviceMachineIdResource, $Wi.fromString(uuid));
    } catch (error) {
    }
  }
  storageService?.store(
    "storage.serviceMachineId",
    uuid,
    -1,
    1
    /* StorageTarget.MACHINE */
  );
  return uuid;
}
var init_serviceMachineId = __esm({
  "out-build/vs/platform/externalServices/common/serviceMachineId.js"() {
    "use strict";
    init_buffer();
    init_uuid();
  }
});

// out-build/vs/platform/externalServices/common/marketplace.js
async function $9w(version, productService, environmentService, configurationService, fileService, storageService, telemetryService) {
  const headers = {
    "X-Market-Client-Id": `VSCode ${version}`,
    "User-Agent": `VSCode ${version} (${productService.nameShort})`
  };
  if ($1w(productService, environmentService) && $3w(configurationService) === 3) {
    const serviceMachineId = await $Mw(environmentService, fileService, storageService);
    headers["X-Market-User-Id"] = serviceMachineId;
    headers["VSCode-SessionId"] = telemetryService.machineId || serviceMachineId;
  }
  return headers;
}
var init_marketplace = __esm({
  "out-build/vs/platform/externalServices/common/marketplace.js"() {
    "use strict";
    init_serviceMachineId();
    init_telemetryUtils();
  }
});

// out-build/vs/base/common/marshalling.js
function $Uu(obj) {
  return JSON.stringify(obj, replacer);
}
function $Vu(text) {
  let data = JSON.parse(text);
  data = $Wu(data);
  return data;
}
function replacer(key, value) {
  if (value instanceof RegExp) {
    return {
      $mid: 2,
      source: value.source,
      flags: value.flags
    };
  }
  return value;
}
function $Wu(obj, depth = 0) {
  if (!obj || depth > 200) {
    return obj;
  }
  if (typeof obj === "object") {
    switch (obj.$mid) {
      case 1:
        return URI.revive(obj);
      case 2:
        return new RegExp(obj.source, obj.flags);
      case 17:
        return new Date(obj.source);
    }
    if (obj instanceof $Wi || obj instanceof Uint8Array) {
      return obj;
    }
    if (Array.isArray(obj)) {
      for (let i = 0; i < obj.length; ++i) {
        obj[i] = $Wu(obj[i], depth + 1);
      }
    } else {
      for (const key in obj) {
        if (Object.hasOwnProperty.call(obj, key)) {
          obj[key] = $Wu(obj[key], depth + 1);
        }
      }
    }
  }
  return obj;
}
var init_marshalling = __esm({
  "out-build/vs/base/common/marshalling.js"() {
    "use strict";
    init_buffer();
    init_uri();
  }
});

// out-build/vs/base/parts/storage/common/storage.js
var StorageHint, StorageState, $1v;
var init_storage = __esm({
  "out-build/vs/base/parts/storage/common/storage.js"() {
    "use strict";
    init_async();
    init_event();
    init_lifecycle();
    init_marshalling();
    init_types();
    (function(StorageHint2) {
      StorageHint2[StorageHint2["STORAGE_DOES_NOT_EXIST"] = 0] = "STORAGE_DOES_NOT_EXIST";
      StorageHint2[StorageHint2["STORAGE_IN_MEMORY"] = 1] = "STORAGE_IN_MEMORY";
    })(StorageHint || (StorageHint = {}));
    (function(StorageState2) {
      StorageState2[StorageState2["None"] = 0] = "None";
      StorageState2[StorageState2["Initialized"] = 1] = "Initialized";
      StorageState2[StorageState2["Closed"] = 2] = "Closed";
    })(StorageState || (StorageState = {}));
    $1v = class _$1v extends $sd {
      static {
        this.a = 100;
      }
      constructor(r, s = /* @__PURE__ */ Object.create(null)) {
        super();
        this.r = r;
        this.s = s;
        this.b = this.B(new $af());
        this.onDidChangeStorage = this.b.event;
        this.c = StorageState.None;
        this.f = /* @__PURE__ */ new Map();
        this.g = this.B(new $bi(_$1v.a));
        this.h = /* @__PURE__ */ new Set();
        this.j = /* @__PURE__ */ new Map();
        this.m = void 0;
        this.n = [];
        this.t();
      }
      t() {
        this.B(this.r.onDidChangeItemsExternal((e) => this.u(e)));
      }
      u(e) {
        this.b.pause();
        try {
          e.changed?.forEach((value, key) => this.w(key, value));
          e.deleted?.forEach((key) => this.w(key, void 0));
        } finally {
          this.b.resume();
        }
      }
      w(key, value) {
        if (this.c === StorageState.Closed) {
          return;
        }
        let changed = false;
        if ($6c(value)) {
          changed = this.f.delete(key);
        } else {
          const currentValue = this.f.get(key);
          if (currentValue !== value) {
            this.f.set(key, value);
            changed = true;
          }
        }
        if (changed) {
          this.b.fire({ key, external: true });
        }
      }
      get items() {
        return this.f;
      }
      get size() {
        return this.f.size;
      }
      async init() {
        if (this.c !== StorageState.None) {
          return;
        }
        this.c = StorageState.Initialized;
        if (this.s.hint === StorageHint.STORAGE_DOES_NOT_EXIST) {
          return;
        }
        this.f = await this.r.getItems();
      }
      get(key, fallbackValue) {
        const value = this.f.get(key);
        if ($6c(value)) {
          return fallbackValue;
        }
        return value;
      }
      getBoolean(key, fallbackValue) {
        const value = this.get(key);
        if ($6c(value)) {
          return fallbackValue;
        }
        return value === "true";
      }
      getNumber(key, fallbackValue) {
        const value = this.get(key);
        if ($6c(value)) {
          return fallbackValue;
        }
        return parseInt(value, 10);
      }
      getObject(key, fallbackValue) {
        const value = this.get(key);
        if ($6c(value)) {
          return fallbackValue;
        }
        return $Vu(value);
      }
      async set(key, value, external = false) {
        if (this.c === StorageState.Closed) {
          return;
        }
        if ($6c(value)) {
          return this.delete(key, external);
        }
        const valueStr = $Yc(value) || Array.isArray(value) ? $Uu(value) : String(value);
        const currentValue = this.f.get(key);
        if (currentValue === valueStr) {
          return;
        }
        this.f.set(key, valueStr);
        this.j.set(key, valueStr);
        this.h.delete(key);
        this.b.fire({ key, external });
        return this.D();
      }
      async delete(key, external = false) {
        if (this.c === StorageState.Closed) {
          return;
        }
        const wasDeleted = this.f.delete(key);
        if (!wasDeleted) {
          return;
        }
        if (!this.h.has(key)) {
          this.h.add(key);
        }
        this.j.delete(key);
        this.b.fire({ key, external });
        return this.D();
      }
      async optimize() {
        if (this.c === StorageState.Closed) {
          return;
        }
        await this.flush(0);
        return this.r.optimize();
      }
      async close() {
        if (!this.m) {
          this.m = this.y();
        }
        return this.m;
      }
      async y() {
        this.c = StorageState.Closed;
        try {
          await this.D(
            0
            /* as soon as possible */
          );
        } catch (error) {
        }
        await this.r.close(() => this.f);
      }
      get z() {
        return this.j.size > 0 || this.h.size > 0;
      }
      async C() {
        if (!this.z) {
          return;
        }
        const updateRequest = { insert: this.j, delete: this.h };
        this.h = /* @__PURE__ */ new Set();
        this.j = /* @__PURE__ */ new Map();
        return this.r.updateItems(updateRequest).finally(() => {
          if (!this.z) {
            while (this.n.length) {
              this.n.pop()?.();
            }
          }
        });
      }
      async flush(delay) {
        if (this.c === StorageState.Closed || // Return early if we are already closed
        this.m) {
          return;
        }
        return this.D(delay);
      }
      async D(delay) {
        if (this.s.hint === StorageHint.STORAGE_IN_MEMORY) {
          return this.C();
        }
        return this.g.trigger(() => this.C(), delay);
      }
      async whenFlushed() {
        if (!this.z) {
          return;
        }
        return new Promise((resolve4) => this.n.push(resolve4));
      }
      isInMemory() {
        return this.s.hint === StorageHint.STORAGE_IN_MEMORY;
      }
    };
  }
});

// out-build/vs/platform/workspace/common/workspace.js
function $ul(obj) {
  const singleFolderIdentifier = obj;
  return typeof singleFolderIdentifier?.id === "string" && URI.isUri(singleFolderIdentifier.uri);
}
function $zl(obj) {
  const workspaceIdentifier = obj;
  return typeof workspaceIdentifier?.id === "string" && URI.isUri(workspaceIdentifier.configPath);
}
function $Pl(path7) {
  const ext = typeof path7 === "string" ? $tc(path7) : $Nh(path7);
  return ext === $Hl;
}
var $tl, WorkbenchState, $Gl, $Hl, $Il;
var init_workspace = __esm({
  "out-build/vs/platform/workspace/common/workspace.js"() {
    "use strict";
    init_nls2();
    init_path();
    init_ternarySearchTree();
    init_resources();
    init_uri();
    init_instantiation();
    init_network();
    $tl = $kl("contextService");
    (function(WorkbenchState2) {
      WorkbenchState2[WorkbenchState2["EMPTY"] = 1] = "EMPTY";
      WorkbenchState2[WorkbenchState2["FOLDER"] = 2] = "FOLDER";
      WorkbenchState2[WorkbenchState2["WORKSPACE"] = 3] = "WORKSPACE";
    })(WorkbenchState || (WorkbenchState = {}));
    $Gl = "code-workspace";
    $Hl = `.${$Gl}`;
    $Il = [{ name: localize(2646, null), extensions: [$Gl] }];
  }
});

// out-build/vs/platform/uriIdentity/common/uriIdentity.js
var $3l;
var init_uriIdentity = __esm({
  "out-build/vs/platform/uriIdentity/common/uriIdentity.js"() {
    "use strict";
    init_instantiation();
    $3l = $kl("IUriIdentityService");
  }
});

// out-build/vs/platform/userDataProfile/common/userDataProfile.js
function $7s(thing) {
  const candidate = thing;
  return !!(candidate && typeof candidate === "object" && typeof candidate.id === "string" && typeof candidate.isDefault === "boolean" && typeof candidate.name === "string" && URI.isUri(candidate.location) && URI.isUri(candidate.globalStorageHome) && URI.isUri(candidate.settingsResource) && URI.isUri(candidate.keybindingsResource) && URI.isUri(candidate.tasksResource) && URI.isUri(candidate.snippetsHome) && URI.isUri(candidate.promptsHome) && URI.isUri(candidate.extensionsResource));
}
function $9s(profile, scheme) {
  return {
    id: profile.id,
    isDefault: profile.isDefault,
    name: profile.name,
    icon: profile.icon,
    location: URI.revive(profile.location).with({ scheme }),
    globalStorageHome: URI.revive(profile.globalStorageHome).with({ scheme }),
    settingsResource: URI.revive(profile.settingsResource).with({ scheme }),
    keybindingsResource: URI.revive(profile.keybindingsResource).with({ scheme }),
    tasksResource: URI.revive(profile.tasksResource).with({ scheme }),
    snippetsHome: URI.revive(profile.snippetsHome).with({ scheme }),
    promptsHome: URI.revive(profile.promptsHome).with({ scheme }),
    extensionsResource: URI.revive(profile.extensionsResource).with({ scheme }),
    cacheHome: URI.revive(profile.cacheHome).with({ scheme }),
    useDefaultFlags: profile.useDefaultFlags,
    isTransient: profile.isTransient,
    workspaces: profile.workspaces?.map((w) => URI.revive(w))
  };
}
function $0s(id2, name, location2, profilesCacheHome, options2, defaultProfile) {
  return {
    id: id2,
    name,
    location: location2,
    isDefault: false,
    icon: options2?.icon,
    globalStorageHome: defaultProfile && options2?.useDefaultFlags?.globalState ? defaultProfile.globalStorageHome : $Ph(location2, "globalStorage"),
    settingsResource: defaultProfile && options2?.useDefaultFlags?.settings ? defaultProfile.settingsResource : $Ph(location2, "settings.json"),
    keybindingsResource: defaultProfile && options2?.useDefaultFlags?.keybindings ? defaultProfile.keybindingsResource : $Ph(location2, "keybindings.json"),
    tasksResource: defaultProfile && options2?.useDefaultFlags?.tasks ? defaultProfile.tasksResource : $Ph(location2, "tasks.json"),
    snippetsHome: defaultProfile && options2?.useDefaultFlags?.snippets ? defaultProfile.snippetsHome : $Ph(location2, "snippets"),
    promptsHome: defaultProfile && options2?.useDefaultFlags?.prompts ? defaultProfile.promptsHome : $Ph(location2, "prompts"),
    extensionsResource: defaultProfile && options2?.useDefaultFlags?.extensions ? defaultProfile.extensionsResource : $Ph(location2, "extensions.json"),
    cacheHome: $Ph(profilesCacheHome, id2),
    useDefaultFlags: options2?.useDefaultFlags,
    isTransient: options2?.transient,
    workspaces: options2?.workspaces
  };
}
var ProfileResourceType, $8s, $$s;
var init_userDataProfile = __esm({
  "out-build/vs/platform/userDataProfile/common/userDataProfile.js"() {
    "use strict";
    init_hash();
    init_event();
    init_lifecycle();
    init_resources();
    init_uri();
    init_nls2();
    init_environment();
    init_files();
    init_instantiation();
    init_log();
    init_workspace();
    init_uriIdentity();
    init_async();
    init_uuid();
    init_strings();
    init_types();
    (function(ProfileResourceType2) {
      ProfileResourceType2["Settings"] = "settings";
      ProfileResourceType2["Keybindings"] = "keybindings";
      ProfileResourceType2["Snippets"] = "snippets";
      ProfileResourceType2["Prompts"] = "prompts";
      ProfileResourceType2["Tasks"] = "tasks";
      ProfileResourceType2["Extensions"] = "extensions";
      ProfileResourceType2["GlobalState"] = "globalState";
    })(ProfileResourceType || (ProfileResourceType = {}));
    $8s = $kl("IUserDataProfilesService");
    $$s = class $$s2 extends $sd {
      static {
        this.b = "userDataProfiles";
      }
      static {
        this.c = "profileAssociations";
      }
      get defaultProfile() {
        return this.profiles[0];
      }
      get profiles() {
        return [...this.C.profiles, ...this.r.profiles];
      }
      constructor(s, t, u, y) {
        super();
        this.s = s;
        this.t = t;
        this.u = u;
        this.y = y;
        this.g = this.B(new $0e());
        this.onDidChangeProfiles = this.g.event;
        this.h = this.B(new $0e());
        this.onWillCreateProfile = this.h.event;
        this.j = this.B(new $0e());
        this.onWillRemoveProfile = this.j.event;
        this.m = this.B(new $0e());
        this.onDidResetWorkspaces = this.m.event;
        this.n = /* @__PURE__ */ new Map();
        this.r = {
          profiles: [],
          emptyWindows: /* @__PURE__ */ new Map()
        };
        this.profilesHome = $Ph(this.s.userRoamingDataHome, "profiles");
        this.f = $Ph(this.s.cacheHome, "CachedProfilesData");
      }
      init() {
        this.z = void 0;
      }
      get C() {
        if (!this.z) {
          const defaultProfile = this.D();
          const profiles = [defaultProfile];
          try {
            for (const storedProfile of this.N()) {
              if (!storedProfile.name || !$Wc(storedProfile.name) || !storedProfile.location) {
                this.y.warn("Skipping the invalid stored profile", storedProfile.location || storedProfile.name);
                continue;
              }
              profiles.push($0s($Mh(storedProfile.location), storedProfile.name, storedProfile.location, this.f, { icon: storedProfile.icon, useDefaultFlags: storedProfile.useDefaultFlags }, defaultProfile));
            }
          } catch (error) {
            this.y.error(error);
          }
          const emptyWindows = /* @__PURE__ */ new Map();
          if (profiles.length) {
            try {
              const profileAssociaitions = this.P();
              if (profileAssociaitions.workspaces) {
                for (const [workspacePath, profileId] of Object.entries(profileAssociaitions.workspaces)) {
                  const workspace = URI.parse(workspacePath);
                  const profile = profiles.find((p) => p.id === profileId);
                  if (profile) {
                    const workspaces = profile.workspaces ? profile.workspaces.slice(0) : [];
                    workspaces.push(workspace);
                    profile.workspaces = workspaces;
                  }
                }
              }
              if (profileAssociaitions.emptyWindows) {
                for (const [windowId, profileId] of Object.entries(profileAssociaitions.emptyWindows)) {
                  const profile = profiles.find((p) => p.id === profileId);
                  if (profile) {
                    emptyWindows.set(windowId, profile);
                  }
                }
              }
            } catch (error) {
              this.y.error(error);
            }
          }
          this.z = { profiles, emptyWindows };
        }
        return this.z;
      }
      D() {
        const defaultProfile = $0s("__default__profile__", localize(2599, null), this.s.userRoamingDataHome, this.f);
        return { ...defaultProfile, extensionsResource: this.R() ?? defaultProfile.extensionsResource, isDefault: true };
      }
      async createTransientProfile(workspaceIdentifier) {
        const namePrefix = `Temp`;
        const nameRegEx = new RegExp(`${$$f(namePrefix)}\\s(\\d+)`);
        let nameIndex = 0;
        for (const profile of this.profiles) {
          const matches = nameRegEx.exec(profile.name);
          const index = matches ? parseInt(matches[1]) : 0;
          nameIndex = index > nameIndex ? index : nameIndex;
        }
        const name = `${namePrefix} ${nameIndex + 1}`;
        return this.createProfile($fj($6s()).toString(16), name, { transient: true }, workspaceIdentifier);
      }
      async createNamedProfile(name, options2, workspaceIdentifier) {
        return this.createProfile($fj($6s()).toString(16), name, options2, workspaceIdentifier);
      }
      async createProfile(id2, name, options2, workspaceIdentifier) {
        const profile = await this.F(id2, name, options2, workspaceIdentifier);
        return profile;
      }
      async F(id2, name, options2, workspaceIdentifier) {
        if (!$Wc(name) || !name) {
          throw new Error("Name of the profile is mandatory and must be of type `string`");
        }
        let profileCreationPromise = this.n.get(name);
        if (!profileCreationPromise) {
          profileCreationPromise = (async () => {
            try {
              const existing = this.profiles.find((p) => p.id === id2 || !p.isTransient && !options2?.transient && p.name === name);
              if (existing) {
                throw new Error(`Profile with ${name} name already exists`);
              }
              const workspace = workspaceIdentifier ? this.G(workspaceIdentifier) : void 0;
              if (URI.isUri(workspace)) {
                options2 = { ...options2, workspaces: [workspace] };
              }
              const profile = $0s(id2, name, $Ph(this.profilesHome, id2), this.f, options2, this.defaultProfile);
              await this.t.createFolder(profile.location);
              const joiners = [];
              this.h.fire({
                profile,
                join(promise) {
                  joiners.push(promise);
                }
              });
              await Promises.settled(joiners);
              if (workspace && !URI.isUri(workspace)) {
                this.L(workspace, profile, !!profile.isTransient);
              }
              this.I([profile], [], []);
              return profile;
            } finally {
              this.n.delete(name);
            }
          })();
          this.n.set(name, profileCreationPromise);
        }
        return profileCreationPromise;
      }
      async updateProfile(profile, options2) {
        const profilesToUpdate = [];
        for (const existing of this.profiles) {
          let profileToUpdate;
          if (profile.id === existing.id) {
            if (!existing.isDefault) {
              profileToUpdate = $0s(existing.id, options2.name ?? existing.name, existing.location, this.f, {
                icon: options2.icon === null ? void 0 : options2.icon ?? existing.icon,
                transient: options2.transient ?? existing.isTransient,
                useDefaultFlags: options2.useDefaultFlags ?? existing.useDefaultFlags,
                workspaces: options2.workspaces ?? existing.workspaces
              }, this.defaultProfile);
            } else if (options2.workspaces) {
              profileToUpdate = existing;
              profileToUpdate.workspaces = options2.workspaces;
            }
          } else if (options2.workspaces) {
            const workspaces = existing.workspaces?.filter((w1) => !options2.workspaces?.some((w2) => this.u.extUri.isEqual(w1, w2)));
            if (existing.workspaces?.length !== workspaces?.length) {
              profileToUpdate = existing;
              profileToUpdate.workspaces = workspaces;
            }
          }
          if (profileToUpdate) {
            profilesToUpdate.push(profileToUpdate);
          }
        }
        if (!profilesToUpdate.length) {
          if (profile.isDefault) {
            throw new Error("Cannot update default profile");
          }
          throw new Error(`Profile '${profile.name}' does not exist`);
        }
        this.I([], [], profilesToUpdate);
        const updatedProfile = this.profiles.find((p) => p.id === profile.id);
        if (!updatedProfile) {
          throw new Error(`Profile '${profile.name}' was not updated`);
        }
        return updatedProfile;
      }
      async removeProfile(profileToRemove) {
        if (profileToRemove.isDefault) {
          throw new Error("Cannot remove default profile");
        }
        const profile = this.profiles.find((p) => p.id === profileToRemove.id);
        if (!profile) {
          throw new Error(`Profile '${profileToRemove.name}' does not exist`);
        }
        const joiners = [];
        this.j.fire({
          profile,
          join(promise) {
            joiners.push(promise);
          }
        });
        try {
          await Promise.allSettled(joiners);
        } catch (error) {
          this.y.error(error);
        }
        this.I([], [profile], []);
        try {
          await this.t.del(profile.cacheHome, { recursive: true });
        } catch (error) {
          if ($0m(error) !== 1) {
            this.y.error(error);
          }
        }
      }
      async setProfileForWorkspace(workspaceIdentifier, profileToSet) {
        const profile = this.profiles.find((p) => p.id === profileToSet.id);
        if (!profile) {
          throw new Error(`Profile '${profileToSet.name}' does not exist`);
        }
        const workspace = this.G(workspaceIdentifier);
        if (URI.isUri(workspace)) {
          const workspaces = profile.workspaces ? [...profile.workspaces] : [];
          if (!workspaces.some((w) => this.u.extUri.isEqual(w, workspace))) {
            workspaces.push(workspace);
            await this.updateProfile(profile, { workspaces });
          }
        } else {
          this.L(workspace, profile, false);
          this.M(this.profiles);
        }
      }
      unsetWorkspace(workspaceIdentifier, transient = false) {
        const workspace = this.G(workspaceIdentifier);
        if (URI.isUri(workspace)) {
          const currentlyAssociatedProfile = this.getProfileForWorkspace(workspaceIdentifier);
          if (currentlyAssociatedProfile) {
            this.updateProfile(currentlyAssociatedProfile, { workspaces: currentlyAssociatedProfile.workspaces?.filter((w) => !this.u.extUri.isEqual(w, workspace)) });
          }
        } else {
          this.L(workspace, void 0, transient);
          this.M(this.profiles);
        }
      }
      async resetWorkspaces() {
        this.r.emptyWindows.clear();
        this.C.emptyWindows.clear();
        for (const profile of this.profiles) {
          profile.workspaces = void 0;
        }
        this.I([], [], this.profiles);
        this.m.fire();
      }
      async cleanUp() {
        if (await this.t.exists(this.profilesHome)) {
          const stat = await this.t.resolve(this.profilesHome);
          await Promise.all((stat.children || []).filter((child) => child.isDirectory && this.profiles.every((p) => !this.u.extUri.isEqual(p.location, child.resource))).map((child) => this.t.del(child.resource, { recursive: true })));
        }
      }
      async cleanUpTransientProfiles() {
        const unAssociatedTransientProfiles = this.r.profiles.filter((p) => !this.H(p));
        await Promise.allSettled(unAssociatedTransientProfiles.map((p) => this.removeProfile(p)));
      }
      getProfileForWorkspace(workspaceIdentifier) {
        const workspace = this.G(workspaceIdentifier);
        return URI.isUri(workspace) ? this.profiles.find((p) => p.workspaces?.some((w) => this.u.extUri.isEqual(w, workspace))) : this.C.emptyWindows.get(workspace) ?? this.r.emptyWindows.get(workspace);
      }
      G(workspaceIdentifier) {
        if ($ul(workspaceIdentifier)) {
          return workspaceIdentifier.uri;
        }
        if ($zl(workspaceIdentifier)) {
          return workspaceIdentifier.configPath;
        }
        return workspaceIdentifier.id;
      }
      H(profile) {
        if (profile.workspaces?.length) {
          return true;
        }
        if ([...this.C.emptyWindows.values()].some((windowProfile) => this.u.extUri.isEqual(windowProfile.location, profile.location))) {
          return true;
        }
        if ([...this.r.emptyWindows.values()].some((windowProfile) => this.u.extUri.isEqual(windowProfile.location, profile.location))) {
          return true;
        }
        return false;
      }
      I(added, removed, updated) {
        const allProfiles = [...this.profiles, ...added];
        const transientProfiles = this.r.profiles;
        this.r.profiles = [];
        const profiles = [];
        for (let profile of allProfiles) {
          if (removed.some((p) => profile.id === p.id)) {
            for (const windowId of [...this.C.emptyWindows.keys()]) {
              if (profile.id === this.C.emptyWindows.get(windowId)?.id) {
                this.C.emptyWindows.delete(windowId);
              }
            }
            continue;
          }
          if (!profile.isDefault) {
            profile = updated.find((p) => profile.id === p.id) ?? profile;
            const transientProfile = transientProfiles.find((p) => profile.id === p.id);
            if (profile.isTransient) {
              this.r.profiles.push(profile);
            } else {
              if (transientProfile) {
                for (const [windowId, p] of this.r.emptyWindows.entries()) {
                  if (profile.id === p.id) {
                    this.r.emptyWindows.delete(windowId);
                    this.C.emptyWindows.set(windowId, profile);
                    break;
                  }
                }
              }
            }
          }
          if (profile.workspaces?.length === 0) {
            profile.workspaces = void 0;
          }
          profiles.push(profile);
        }
        this.M(profiles);
        this.J(added, removed, updated);
      }
      J(added, removed, updated) {
        this.g.fire({ added, removed, updated, all: this.profiles });
      }
      L(windowId, newProfile, transient) {
        transient = newProfile?.isTransient ? true : transient;
        if (transient) {
          if (newProfile) {
            this.r.emptyWindows.set(windowId, newProfile);
          } else {
            this.r.emptyWindows.delete(windowId);
          }
        } else {
          this.r.emptyWindows.delete(windowId);
          if (newProfile) {
            this.C.emptyWindows.set(windowId, newProfile);
          } else {
            this.C.emptyWindows.delete(windowId);
          }
        }
      }
      M(profiles) {
        const storedProfiles = [];
        const workspaces = {};
        const emptyWindows = {};
        for (const profile of profiles) {
          if (profile.isTransient) {
            continue;
          }
          if (!profile.isDefault) {
            storedProfiles.push({ location: profile.location, name: profile.name, icon: profile.icon, useDefaultFlags: profile.useDefaultFlags });
          }
          if (profile.workspaces) {
            for (const workspace of profile.workspaces) {
              workspaces[workspace.toString()] = profile.id;
            }
          }
        }
        for (const [windowId, profile] of this.C.emptyWindows.entries()) {
          emptyWindows[windowId.toString()] = profile.id;
        }
        this.Q({ workspaces, emptyWindows });
        this.O(storedProfiles);
        this.z = void 0;
      }
      N() {
        return [];
      }
      O(storedProfiles) {
        throw new Error("not implemented");
      }
      P() {
        return {};
      }
      Q(storedProfileAssociations) {
        throw new Error("not implemented");
      }
      R() {
        return void 0;
      }
    };
    $$s = __decorate([
      __param(0, $rl),
      __param(1, $Sm),
      __param(2, $3l),
      __param(3, $5n)
    ], $$s);
  }
});

// out-build/vs/platform/storage/common/storage.js
function $6v(storage) {
  const keysRaw = storage.get($4v);
  if (keysRaw) {
    try {
      return JSON.parse(keysRaw);
    } catch (error) {
    }
  }
  return /* @__PURE__ */ Object.create(null);
}
function $8v(profile) {
  return profile.isDefault || !!profile.useDefaultFlags?.globalState;
}
async function $0v(application, profile, workspace, applicationPath, profilePath, workspacePath) {
  const safeParse = (value) => {
    try {
      return JSON.parse(value);
    } catch (error) {
      return value;
    }
  };
  const applicationItems = /* @__PURE__ */ new Map();
  const applicationItemsParsed = /* @__PURE__ */ new Map();
  application.forEach((value, key) => {
    applicationItems.set(key, value);
    applicationItemsParsed.set(key, safeParse(value));
  });
  const profileItems = /* @__PURE__ */ new Map();
  const profileItemsParsed = /* @__PURE__ */ new Map();
  profile.forEach((value, key) => {
    profileItems.set(key, value);
    profileItemsParsed.set(key, safeParse(value));
  });
  const workspaceItems = /* @__PURE__ */ new Map();
  const workspaceItemsParsed = /* @__PURE__ */ new Map();
  workspace.forEach((value, key) => {
    workspaceItems.set(key, value);
    workspaceItemsParsed.set(key, safeParse(value));
  });
  if (applicationPath !== profilePath) {
    console.group(`Storage: Application (path: ${applicationPath})`);
  } else {
    console.group(`Storage: Application & Profile (path: ${applicationPath}, default profile)`);
  }
  const applicationValues = [];
  applicationItems.forEach((value, key) => {
    applicationValues.push({ key, value });
  });
  console.table(applicationValues);
  console.groupEnd();
  console.log(applicationItemsParsed);
  if (applicationPath !== profilePath) {
    console.group(`Storage: Profile (path: ${profilePath}, profile specific)`);
    const profileValues = [];
    profileItems.forEach((value, key) => {
      profileValues.push({ key, value });
    });
    console.table(profileValues);
    console.groupEnd();
    console.log(profileItemsParsed);
  }
  console.group(`Storage: Workspace (path: ${workspacePath})`);
  const workspaceValues = [];
  workspaceItems.forEach((value, key) => {
    workspaceValues.push({ key, value });
  });
  console.table(workspaceValues);
  console.groupEnd();
  console.log(workspaceItemsParsed);
}
var $3v, $4v, $5v, WillSaveStateReason, StorageScope, StorageTarget, $7v;
var init_storage2 = __esm({
  "out-build/vs/platform/storage/common/storage.js"() {
    "use strict";
    init_async();
    init_event();
    init_lifecycle();
    init_performance();
    init_types();
    init_storage();
    init_instantiation();
    init_userDataProfile();
    $3v = "__$__isNewStorageMarker";
    $4v = "__$__targetStorageMarker";
    $5v = $kl("storageService");
    (function(WillSaveStateReason2) {
      WillSaveStateReason2[WillSaveStateReason2["NONE"] = 0] = "NONE";
      WillSaveStateReason2[WillSaveStateReason2["SHUTDOWN"] = 1] = "SHUTDOWN";
    })(WillSaveStateReason || (WillSaveStateReason = {}));
    (function(StorageScope2) {
      StorageScope2[StorageScope2["APPLICATION"] = -1] = "APPLICATION";
      StorageScope2[StorageScope2["PROFILE"] = 0] = "PROFILE";
      StorageScope2[StorageScope2["WORKSPACE"] = 1] = "WORKSPACE";
    })(StorageScope || (StorageScope = {}));
    (function(StorageTarget2) {
      StorageTarget2[StorageTarget2["USER"] = 0] = "USER";
      StorageTarget2[StorageTarget2["MACHINE"] = 1] = "MACHINE";
    })(StorageTarget || (StorageTarget = {}));
    $7v = class _$7v extends $sd {
      static {
        this.a = 60 * 1e3;
      }
      // every minute
      constructor(options2 = { flushInterval: _$7v.a }) {
        super();
        this.b = this.B(new $af());
        this.f = this.B(new $af());
        this.onDidChangeTarget = this.f.event;
        this.g = this.B(new $0e());
        this.onWillSaveState = this.g.event;
        this.m = this.B(new $td());
        this.C = void 0;
        this.F = void 0;
        this.H = void 0;
        this.j = this.B(new $pi(() => this.n(), options2.flushInterval));
      }
      onDidChangeValue(scope, key, disposable) {
        return Event.filter(this.b.event, (e) => e.scope === scope && (key === void 0 || e.key === key), disposable);
      }
      n() {
        this.m.value = $ti(() => {
          if (this.r()) {
            this.flush();
          }
          this.j.schedule();
        });
      }
      r() {
        return true;
      }
      t() {
        $nd([this.m, this.j]);
      }
      initialize() {
        if (!this.h) {
          this.h = (async () => {
            $S("code/willInitStorage");
            try {
              await this.O();
            } finally {
              $S("code/didInitStorage");
            }
            this.j.schedule();
          })();
        }
        return this.h;
      }
      u(scope, event) {
        const { key, external } = event;
        if (key === $4v) {
          switch (scope) {
            case -1:
              this.H = void 0;
              break;
            case 0:
              this.F = void 0;
              break;
            case 1:
              this.C = void 0;
              break;
          }
          this.f.fire({ scope });
        } else {
          this.b.fire({ scope, key, target: this.J(scope)[key], external });
        }
      }
      w(reason) {
        this.g.fire({ reason });
      }
      get(key, scope, fallbackValue) {
        return this.P(scope)?.get(key, fallbackValue);
      }
      getBoolean(key, scope, fallbackValue) {
        return this.P(scope)?.getBoolean(key, fallbackValue);
      }
      getNumber(key, scope, fallbackValue) {
        return this.P(scope)?.getNumber(key, fallbackValue);
      }
      getObject(key, scope, fallbackValue) {
        return this.P(scope)?.getObject(key, fallbackValue);
      }
      storeAll(entries, external) {
        this.y(() => {
          for (const entry of entries) {
            this.store(entry.key, entry.value, entry.scope, entry.target, external);
          }
        });
      }
      store(key, value, scope, target, external = false) {
        if ($6c(value)) {
          this.remove(key, scope, external);
          return;
        }
        this.y(() => {
          this.z(key, scope, target);
          this.P(scope)?.set(key, value, external);
        });
      }
      remove(key, scope, external = false) {
        this.y(() => {
          this.z(key, scope, void 0);
          this.P(scope)?.delete(key, external);
        });
      }
      y(fn) {
        this.b.pause();
        this.f.pause();
        try {
          fn();
        } finally {
          this.b.resume();
          this.f.resume();
        }
      }
      keys(scope, target) {
        const keys = [];
        const keyTargets = this.J(scope);
        for (const key of Object.keys(keyTargets)) {
          const keyTarget = keyTargets[key];
          if (keyTarget === target) {
            keys.push(key);
          }
        }
        return keys;
      }
      z(key, scope, target, external = false) {
        const keyTargets = this.J(scope);
        if (typeof target === "number") {
          if (keyTargets[key] !== target) {
            keyTargets[key] = target;
            this.P(scope)?.set($4v, JSON.stringify(keyTargets), external);
          }
        } else {
          if (typeof keyTargets[key] === "number") {
            delete keyTargets[key];
            this.P(scope)?.set($4v, JSON.stringify(keyTargets), external);
          }
        }
      }
      get D() {
        if (!this.C) {
          this.C = this.L(
            1
            /* StorageScope.WORKSPACE */
          );
        }
        return this.C;
      }
      get G() {
        if (!this.F) {
          this.F = this.L(
            0
            /* StorageScope.PROFILE */
          );
        }
        return this.F;
      }
      get I() {
        if (!this.H) {
          this.H = this.L(
            -1
            /* StorageScope.APPLICATION */
          );
        }
        return this.H;
      }
      J(scope) {
        switch (scope) {
          case -1:
            return this.I;
          case 0:
            return this.G;
          default:
            return this.D;
        }
      }
      L(scope) {
        const storage = this.P(scope);
        return storage ? $6v(storage) : /* @__PURE__ */ Object.create(null);
      }
      isNew(scope) {
        return this.getBoolean($3v, scope) === true;
      }
      async flush(reason = WillSaveStateReason.NONE) {
        this.g.fire({ reason });
        const applicationStorage = this.P(
          -1
          /* StorageScope.APPLICATION */
        );
        const profileStorage = this.P(
          0
          /* StorageScope.PROFILE */
        );
        const workspaceStorage = this.P(
          1
          /* StorageScope.WORKSPACE */
        );
        switch (reason) {
          // Unspecific reason: just wait when data is flushed
          case WillSaveStateReason.NONE:
            await Promises.settled([
              applicationStorage?.whenFlushed() ?? Promise.resolve(),
              profileStorage?.whenFlushed() ?? Promise.resolve(),
              workspaceStorage?.whenFlushed() ?? Promise.resolve()
            ]);
            break;
          // Shutdown: we want to flush as soon as possible
          // and not hit any delays that might be there
          case WillSaveStateReason.SHUTDOWN:
            await Promises.settled([
              applicationStorage?.flush(0) ?? Promise.resolve(),
              profileStorage?.flush(0) ?? Promise.resolve(),
              workspaceStorage?.flush(0) ?? Promise.resolve()
            ]);
            break;
        }
      }
      async log() {
        const applicationItems = this.P(
          -1
          /* StorageScope.APPLICATION */
        )?.items ?? /* @__PURE__ */ new Map();
        const profileItems = this.P(
          0
          /* StorageScope.PROFILE */
        )?.items ?? /* @__PURE__ */ new Map();
        const workspaceItems = this.P(
          1
          /* StorageScope.WORKSPACE */
        )?.items ?? /* @__PURE__ */ new Map();
        return $0v(applicationItems, profileItems, workspaceItems, this.Q(
          -1
          /* StorageScope.APPLICATION */
        ) ?? "", this.Q(
          0
          /* StorageScope.PROFILE */
        ) ?? "", this.Q(
          1
          /* StorageScope.WORKSPACE */
        ) ?? "");
      }
      async optimize(scope) {
        await this.flush();
        return this.P(scope)?.optimize();
      }
      async switch(to, preserveData) {
        this.w(WillSaveStateReason.NONE);
        if ($7s(to)) {
          return this.R(to, preserveData);
        }
        return this.S(to, preserveData);
      }
      M(from, to) {
        if (from.id === to.id) {
          return false;
        }
        if ($8v(to) && $8v(from)) {
          return false;
        }
        return true;
      }
      N(oldStorage, newStorage, scope) {
        this.y(() => {
          const handledkeys = /* @__PURE__ */ new Set();
          for (const [key, oldValue] of oldStorage) {
            handledkeys.add(key);
            const newValue = newStorage.get(key);
            if (newValue !== oldValue) {
              this.u(scope, { key, external: true });
            }
          }
          for (const [key] of newStorage.items) {
            if (!handledkeys.has(key)) {
              this.u(scope, { key, external: true });
            }
          }
        });
      }
    };
  }
});

// out-build/vs/platform/extensionManagement/common/extensionGalleryManifest.js
function $a1(manifest, type2, version) {
  for (const resource of manifest.resources) {
    const [r, v] = resource.type.split("/");
    if (r !== type2) {
      continue;
    }
    if (!version || v === version) {
      return resource.id;
    }
    break;
  }
  return void 0;
}
var ExtensionGalleryResourceType, Flag, $_Z;
var init_extensionGalleryManifest = __esm({
  "out-build/vs/platform/extensionManagement/common/extensionGalleryManifest.js"() {
    "use strict";
    init_instantiation();
    (function(ExtensionGalleryResourceType2) {
      ExtensionGalleryResourceType2["ExtensionQueryService"] = "ExtensionQueryService";
      ExtensionGalleryResourceType2["ExtensionLatestVersionUri"] = "ExtensionLatestVersionUriTemplate";
      ExtensionGalleryResourceType2["ExtensionStatisticsUri"] = "ExtensionStatisticsUriTemplate";
      ExtensionGalleryResourceType2["WebExtensionStatisticsUri"] = "WebExtensionStatisticsUriTemplate";
      ExtensionGalleryResourceType2["PublisherViewUri"] = "PublisherViewUriTemplate";
      ExtensionGalleryResourceType2["ExtensionDetailsViewUri"] = "ExtensionDetailsViewUriTemplate";
      ExtensionGalleryResourceType2["ExtensionRatingViewUri"] = "ExtensionRatingViewUriTemplate";
      ExtensionGalleryResourceType2["ExtensionResourceUri"] = "ExtensionResourceUriTemplate";
      ExtensionGalleryResourceType2["ReportIssueUri"] = "ReportIssueUri";
    })(ExtensionGalleryResourceType || (ExtensionGalleryResourceType = {}));
    (function(Flag2) {
      Flag2["None"] = "None";
      Flag2["IncludeVersions"] = "IncludeVersions";
      Flag2["IncludeFiles"] = "IncludeFiles";
      Flag2["IncludeCategoryAndTags"] = "IncludeCategoryAndTags";
      Flag2["IncludeSharedAccounts"] = "IncludeSharedAccounts";
      Flag2["IncludeVersionProperties"] = "IncludeVersionProperties";
      Flag2["ExcludeNonValidated"] = "ExcludeNonValidated";
      Flag2["IncludeInstallationTargets"] = "IncludeInstallationTargets";
      Flag2["IncludeAssetUri"] = "IncludeAssetUri";
      Flag2["IncludeStatistics"] = "IncludeStatistics";
      Flag2["IncludeLatestVersionOnly"] = "IncludeLatestVersionOnly";
      Flag2["Unpublished"] = "Unpublished";
      Flag2["IncludeNameConflictInfo"] = "IncludeNameConflictInfo";
      Flag2["IncludeLatestPrereleaseAndStableVersionOnly"] = "IncludeLatestPrereleaseAndStableVersionOnly";
    })(Flag || (Flag = {}));
    $_Z = $kl("IExtensionGalleryManifestService");
  }
});

// out-build/vs/platform/extensionManagement/common/extensionGalleryService.js
function getStatistic(statistics, name) {
  const result = (statistics || []).filter((s) => s.statisticName === name)[0];
  return result ? result.value : 0;
}
function getCoreTranslationAssets(version) {
  const coreTranslationAssetPrefix = "Microsoft.VisualStudio.Code.Translation.";
  const result = version.files.filter((f) => f.assetType.indexOf(coreTranslationAssetPrefix) === 0);
  return result.reduce((result2, file) => {
    const asset = getVersionAsset(version, file.assetType);
    if (asset) {
      result2.push([file.assetType.substring(coreTranslationAssetPrefix.length), asset]);
    }
    return result2;
  }, []);
}
function getRepositoryAsset(version) {
  if (version.properties) {
    const results = version.properties.filter((p) => p.key === AssetType.Repository);
    const gitRegExp = new RegExp("((git|ssh|http(s)?)|(git@[\\w.]+))(:(//)?)([\\w.@:/\\-~]+)(.git)(/)?");
    const uri = results.filter((r) => gitRegExp.test(r.value))[0];
    return uri ? { uri: uri.value, fallbackUri: uri.value } : null;
  }
  return getVersionAsset(version, AssetType.Repository);
}
function getDownloadAsset(version) {
  return {
    // always use fallbackAssetUri for download asset to hit the Marketplace API so that downloads are counted
    uri: `${version.fallbackAssetUri}/${AssetType.VSIX}?redirect=true${version.targetPlatform ? `&targetPlatform=${version.targetPlatform}` : ""}`,
    fallbackUri: `${version.fallbackAssetUri}/${AssetType.VSIX}${version.targetPlatform ? `?targetPlatform=${version.targetPlatform}` : ""}`
  };
}
function getVersionAsset(version, type2) {
  const result = version.files.filter((f) => f.assetType === type2)[0];
  return result ? {
    uri: `${version.assetUri}/${type2}${version.targetPlatform ? `?targetPlatform=${version.targetPlatform}` : ""}`,
    fallbackUri: `${version.fallbackAssetUri}/${type2}${version.targetPlatform ? `?targetPlatform=${version.targetPlatform}` : ""}`
  } : null;
}
function getExtensions(version, property) {
  const values = version.properties ? version.properties.filter((p) => p.key === property) : [];
  const value = values.length > 0 && values[0].value;
  return value ? value.split(",").map((v) => $rB(v)) : [];
}
function getEngine(version) {
  const values = version.properties ? version.properties.filter((p) => p.key === PropertyType.Engine) : [];
  return values.length > 0 && values[0].value || "";
}
function isPreReleaseVersion(version) {
  const values = version.properties ? version.properties.filter((p) => p.key === PropertyType.PreRelease) : [];
  return values.length > 0 && values[0].value === "true";
}
function isPrivateExtension(version) {
  const values = version.properties ? version.properties.filter((p) => p.key === PropertyType.Private) : [];
  return values.length > 0 && values[0].value === "true";
}
function executesCode(version) {
  const values = version.properties ? version.properties.filter((p) => p.key === PropertyType.ExecutesCode) : [];
  return values.length > 0 ? values[0].value === "true" : void 0;
}
function getEnabledApiProposals(version) {
  const values = version.properties ? version.properties.filter((p) => p.key === PropertyType.EnabledApiProposals) : [];
  const value = values.length > 0 && values[0].value || "";
  return value ? value.split(",") : [];
}
function getLocalizedLanguages(version) {
  const values = version.properties ? version.properties.filter((p) => p.key === PropertyType.LocalizedLanguages) : [];
  const value = values.length > 0 && values[0].value || "";
  return value ? value.split(",") : [];
}
function getSponsorLink(version) {
  return version.properties?.find((p) => p.key === PropertyType.SponsorLink)?.value;
}
function getSupportLink(version) {
  return version.properties?.find((p) => p.key === PropertyType.SupportLink)?.value;
}
function getIsPreview(flags) {
  return flags.indexOf("preview") !== -1;
}
function getTargetPlatformForExtensionVersion(version) {
  return version.targetPlatform ? $7A(version.targetPlatform) : "undefined";
}
function getAllTargetPlatforms(rawGalleryExtension) {
  const allTargetPlatforms = $Qb(rawGalleryExtension.versions.map(getTargetPlatformForExtensionVersion));
  const isWebExtension = !!rawGalleryExtension.tags?.includes($ZA);
  const webTargetPlatformIndex = allTargetPlatforms.indexOf(
    "web"
    /* TargetPlatform.WEB */
  );
  if (isWebExtension) {
    if (webTargetPlatformIndex === -1) {
      allTargetPlatforms.push(
        "web"
        /* TargetPlatform.WEB */
      );
    }
  } else {
    if (webTargetPlatformIndex !== -1) {
      allTargetPlatforms.splice(webTargetPlatformIndex, 1);
    }
  }
  return allTargetPlatforms;
}
function $c1(versions, preferredTargetPlatform) {
  for (let index = 0; index < versions.length; index++) {
    const version = versions[index];
    if (version.version === versions[index - 1]?.version) {
      let insertionIndex = index;
      const versionTargetPlatform = getTargetPlatformForExtensionVersion(version);
      if (versionTargetPlatform === preferredTargetPlatform) {
        while (insertionIndex > 0 && versions[insertionIndex - 1].version === version.version) {
          insertionIndex--;
        }
      }
      if (insertionIndex !== index) {
        versions.splice(index, 1);
        versions.splice(insertionIndex, 0, version);
      }
    }
  }
  return versions;
}
function setTelemetry(extension, index, querySource) {
  extension.telemetryData = { index, querySource, queryActivityId: extension.queryContext?.[SEARCH_ACTIVITY_HEADER_NAME] };
}
function toExtension(galleryExtension, version, allTargetPlatforms, extensionGalleryManifest, queryContext) {
  const latestVersion = galleryExtension.versions[0];
  const assets = {
    manifest: getVersionAsset(version, AssetType.Manifest),
    readme: getVersionAsset(version, AssetType.Details),
    changelog: getVersionAsset(version, AssetType.Changelog),
    license: getVersionAsset(version, AssetType.License),
    repository: getRepositoryAsset(version),
    download: getDownloadAsset(version),
    icon: getVersionAsset(version, AssetType.Icon),
    signature: getVersionAsset(version, AssetType.Signature),
    coreTranslations: getCoreTranslationAssets(version)
  };
  const detailsViewUri = $a1(
    extensionGalleryManifest,
    "ExtensionDetailsViewUriTemplate"
    /* ExtensionGalleryResourceType.ExtensionDetailsViewUri */
  );
  const publisherViewUri = $a1(
    extensionGalleryManifest,
    "PublisherViewUriTemplate"
    /* ExtensionGalleryResourceType.PublisherViewUri */
  );
  const ratingViewUri = $a1(
    extensionGalleryManifest,
    "ExtensionRatingViewUriTemplate"
    /* ExtensionGalleryResourceType.ExtensionRatingViewUri */
  );
  return {
    type: "gallery",
    identifier: {
      id: $sB(galleryExtension.publisher.publisherName, galleryExtension.extensionName),
      uuid: galleryExtension.extensionId
    },
    name: galleryExtension.extensionName,
    version: version.version,
    displayName: galleryExtension.displayName,
    publisherId: galleryExtension.publisher.publisherId,
    publisher: galleryExtension.publisher.publisherName,
    publisherDisplayName: galleryExtension.publisher.displayName,
    publisherDomain: galleryExtension.publisher.domain ? { link: galleryExtension.publisher.domain, verified: !!galleryExtension.publisher.isDomainVerified } : void 0,
    publisherSponsorLink: getSponsorLink(latestVersion),
    description: galleryExtension.shortDescription ?? "",
    installCount: getStatistic(galleryExtension.statistics, "install"),
    rating: getStatistic(galleryExtension.statistics, "averagerating"),
    ratingCount: getStatistic(galleryExtension.statistics, "ratingcount"),
    categories: galleryExtension.categories || [],
    tags: galleryExtension.tags || [],
    releaseDate: Date.parse(galleryExtension.releaseDate),
    lastUpdated: Date.parse(galleryExtension.lastUpdated),
    allTargetPlatforms,
    assets,
    properties: {
      dependencies: getExtensions(version, PropertyType.Dependency),
      extensionPack: getExtensions(version, PropertyType.ExtensionPack),
      engine: getEngine(version),
      enabledApiProposals: getEnabledApiProposals(version),
      localizedLanguages: getLocalizedLanguages(version),
      targetPlatform: getTargetPlatformForExtensionVersion(version),
      isPreReleaseVersion: isPreReleaseVersion(version),
      executesCode: executesCode(version)
    },
    hasPreReleaseVersion: isPreReleaseVersion(latestVersion),
    hasReleaseVersion: true,
    private: isPrivateExtension(latestVersion),
    preview: getIsPreview(galleryExtension.flags),
    isSigned: !!assets.signature,
    queryContext,
    supportLink: getSupportLink(latestVersion),
    detailsLink: detailsViewUri ? $8f(detailsViewUri, { publisher: galleryExtension.publisher.publisherName, name: galleryExtension.extensionName }) : void 0,
    publisherLink: publisherViewUri ? $8f(publisherViewUri, { publisher: galleryExtension.publisher.publisherName }) : void 0,
    ratingLink: ratingViewUri ? $8f(ratingViewUri, { publisher: galleryExtension.publisher.publisherName, name: galleryExtension.extensionName }) : void 0
  };
}
var CURRENT_TARGET_PLATFORM, SEARCH_ACTIVITY_HEADER_NAME, ACTIVITY_HEADER_NAME, SERVER_HEADER_NAME, END_END_ID_HEADER_NAME, AssetType, PropertyType, DefaultPageSize, DefaultQueryState, VersionKind, Query, $d1, $e1, $f1;
var init_extensionGalleryService = __esm({
  "out-build/vs/platform/extensionManagement/common/extensionGalleryService.js"() {
    "use strict";
    init_arrays();
    init_cancellation();
    init_errors();
    init_platform();
    init_process();
    init_types();
    init_uri();
    init_request2();
    init_configuration();
    init_environment();
    init_extensionManagement();
    init_extensionManagementUtil();
    init_extensionValidator();
    init_files();
    init_log();
    init_productService();
    init_request();
    init_marketplace();
    init_storage2();
    init_telemetry();
    init_stopwatch();
    init_strings();
    init_extensionGalleryManifest();
    CURRENT_TARGET_PLATFORM = $r ? "web" : $8A($x, $jc);
    SEARCH_ACTIVITY_HEADER_NAME = "X-Market-Search-Activity-Id";
    ACTIVITY_HEADER_NAME = "Activityid";
    SERVER_HEADER_NAME = "Server";
    END_END_ID_HEADER_NAME = "X-Vss-E2eid";
    AssetType = {
      Icon: "Microsoft.VisualStudio.Services.Icons.Default",
      Details: "Microsoft.VisualStudio.Services.Content.Details",
      Changelog: "Microsoft.VisualStudio.Services.Content.Changelog",
      Manifest: "Microsoft.VisualStudio.Code.Manifest",
      VSIX: "Microsoft.VisualStudio.Services.VSIXPackage",
      License: "Microsoft.VisualStudio.Services.Content.License",
      Repository: "Microsoft.VisualStudio.Services.Links.Source",
      Signature: "Microsoft.VisualStudio.Services.VsixSignature"
    };
    PropertyType = {
      Dependency: "Microsoft.VisualStudio.Code.ExtensionDependencies",
      ExtensionPack: "Microsoft.VisualStudio.Code.ExtensionPack",
      Engine: "Microsoft.VisualStudio.Code.Engine",
      PreRelease: "Microsoft.VisualStudio.Code.PreRelease",
      EnabledApiProposals: "Microsoft.VisualStudio.Code.EnabledApiProposals",
      LocalizedLanguages: "Microsoft.VisualStudio.Code.LocalizedLanguages",
      WebExtension: "Microsoft.VisualStudio.Code.WebExtension",
      SponsorLink: "Microsoft.VisualStudio.Code.SponsorLink",
      SupportLink: "Microsoft.VisualStudio.Services.Links.Support",
      ExecutesCode: "Microsoft.VisualStudio.Code.ExecutesCode",
      Private: "PrivateMarketplace"
    };
    DefaultPageSize = 10;
    DefaultQueryState = {
      pageNumber: 1,
      pageSize: DefaultPageSize,
      sortBy: "NoneOrRelevance",
      sortOrder: 0,
      flags: [],
      criteria: [],
      assetTypes: []
    };
    (function(VersionKind2) {
      VersionKind2[VersionKind2["Release"] = 0] = "Release";
      VersionKind2[VersionKind2["Prerelease"] = 1] = "Prerelease";
      VersionKind2[VersionKind2["Latest"] = 2] = "Latest";
    })(VersionKind || (VersionKind = {}));
    Query = class _Query {
      constructor(d = DefaultQueryState) {
        this.d = d;
      }
      get pageNumber() {
        return this.d.pageNumber;
      }
      get pageSize() {
        return this.d.pageSize;
      }
      get sortBy() {
        return this.d.sortBy;
      }
      get sortOrder() {
        return this.d.sortOrder;
      }
      get flags() {
        return this.d.flags;
      }
      get criteria() {
        return this.d.criteria;
      }
      get assetTypes() {
        return this.d.assetTypes;
      }
      get source() {
        return this.d.source;
      }
      get searchText() {
        const criterium = this.d.criteria.filter(
          (criterium2) => criterium2.filterType === "SearchText"
          /* FilterType.SearchText */
        )[0];
        return criterium && criterium.value ? criterium.value : "";
      }
      withPage(pageNumber, pageSize = this.d.pageSize) {
        return new _Query({ ...this.d, pageNumber, pageSize });
      }
      withFilter(filterType, ...values) {
        const criteria = [
          ...this.d.criteria,
          ...values.length ? values.map((value) => ({ filterType, value })) : [{ filterType }]
        ];
        return new _Query({ ...this.d, criteria });
      }
      withSortBy(sortBy) {
        return new _Query({ ...this.d, sortBy });
      }
      withSortOrder(sortOrder) {
        return new _Query({ ...this.d, sortOrder });
      }
      withFlags(...flags) {
        return new _Query({ ...this.d, flags: $Qb(flags) });
      }
      withAssetTypes(...assetTypes) {
        return new _Query({ ...this.d, assetTypes });
      }
      withSource(source) {
        return new _Query({ ...this.d, source });
      }
    };
    $d1 = class $d12 {
      constructor(storageService, k, l, n, o, q, u, w, x, y, z) {
        this.k = k;
        this.l = l;
        this.n = n;
        this.o = o;
        this.q = q;
        this.u = u;
        this.w = w;
        this.x = x;
        this.y = y;
        this.z = z;
        this.d = w.extensionsGallery?.controlUrl;
        this.g = w.extensionsGallery?.extensionUrlTemplate;
        this.j = w.extensionsEnabledWithApiProposalVersion?.map((id2) => id2.toLowerCase()) ?? [];
        this.h = $9w(w.version, w, this.o, this.x, this.u, storageService, this.q);
      }
      isEnabled() {
        return this.z.isEnabled();
      }
      async getExtensions(extensionInfos, arg1, arg2) {
        const extensionGalleryManifest = await this.z.getExtensionGalleryManifest();
        if (!extensionGalleryManifest) {
          throw new Error("No extension gallery service configured.");
        }
        const options2 = CancellationToken.isCancellationToken(arg1) ? {} : arg1;
        const token = CancellationToken.isCancellationToken(arg1) ? arg1 : arg2;
        const resourceApi = options2.preferResourceApi && (this.x.getValue($lB) ?? false) ? await this.A(extensionGalleryManifest) : void 0;
        const result = resourceApi ? await this.C(extensionInfos, options2, resourceApi, extensionGalleryManifest, token) : await this.B(extensionInfos, options2, extensionGalleryManifest, token);
        const uuids = result.map((r) => r.identifier.uuid);
        const extensionInfosByName = [];
        for (const e of extensionInfos) {
          if (e.uuid && !uuids.includes(e.uuid)) {
            extensionInfosByName.push({ ...e, uuid: void 0 });
          }
        }
        if (extensionInfosByName.length) {
          this.q.publicLog2("galleryService:additionalQueryByName", {
            count: extensionInfosByName.length
          });
          const extensions = await this.B(extensionInfosByName, options2, extensionGalleryManifest, token);
          result.push(...extensions);
        }
        return result;
      }
      async A(extensionGalleryManifest) {
        const latestVersionResource = $a1(
          extensionGalleryManifest,
          "ExtensionLatestVersionUriTemplate"
          /* ExtensionGalleryResourceType.ExtensionLatestVersionUri */
        );
        if (!latestVersionResource) {
          return void 0;
        }
        if (this.w.quality !== "stable") {
          return {
            uri: latestVersionResource,
            fallback: this.g
          };
        }
        const value = await this.k?.getTreatment("extensions.gallery.useResourceApi") ?? "unpkg";
        if (value === "marketplace") {
          return {
            uri: latestVersionResource,
            fallback: this.g
          };
        }
        if (value === "unpkg" && this.g) {
          return { uri: this.g };
        }
        return void 0;
      }
      async B(extensionInfos, options2, extensionGalleryManifest, token) {
        const names = [], ids = [], includePreRelease = [], versions = [];
        let isQueryForReleaseVersionFromPreReleaseVersion = true;
        for (const extensionInfo of extensionInfos) {
          if (extensionInfo.uuid) {
            ids.push(extensionInfo.uuid);
          } else {
            names.push(extensionInfo.id);
          }
          if (extensionInfo.version) {
            versions.push({ id: extensionInfo.id, uuid: extensionInfo.uuid, version: extensionInfo.version });
          } else {
            includePreRelease.push({ id: extensionInfo.id, uuid: extensionInfo.uuid, includePreRelease: !!extensionInfo.preRelease });
          }
          isQueryForReleaseVersionFromPreReleaseVersion = isQueryForReleaseVersionFromPreReleaseVersion && (!!extensionInfo.hasPreRelease && !extensionInfo.preRelease);
        }
        if (!ids.length && !names.length) {
          return [];
        }
        let query = new Query().withPage(1, extensionInfos.length);
        if (ids.length) {
          query = query.withFilter("ExtensionId", ...ids);
        }
        if (names.length) {
          query = query.withFilter("ExtensionName", ...names);
        }
        if (options2.queryAllVersions) {
          query = query.withFlags(
            ...query.flags,
            "IncludeVersions"
            /* Flag.IncludeVersions */
          );
        }
        if (options2.source) {
          query = query.withSource(options2.source);
        }
        const { extensions } = await this.G(query, {
          targetPlatform: options2.targetPlatform ?? CURRENT_TARGET_PLATFORM,
          includePreRelease,
          versions,
          compatible: !!options2.compatible,
          productVersion: options2.productVersion ?? { version: this.w.version, date: this.w.date },
          isQueryForReleaseVersionFromPreReleaseVersion
        }, extensionGalleryManifest, token);
        if (options2.source) {
          extensions.forEach((e, index) => setTelemetry(e, index, options2.source));
        }
        return extensions;
      }
      async C(extensionInfos, options2, resourceApi, extensionGalleryManifest, token) {
        const result = [];
        const toQuery = [];
        const toFetchLatest = [];
        for (const extensionInfo of extensionInfos) {
          if (!$YA.test(extensionInfo.id)) {
            continue;
          }
          if (extensionInfo.version) {
            toQuery.push(extensionInfo);
          } else {
            toFetchLatest.push(extensionInfo);
          }
        }
        await Promise.allSettled(toFetchLatest.map(async (extensionInfo) => {
          let galleryExtension;
          try {
            try {
              galleryExtension = await this.D(extensionInfo, options2, resourceApi.uri, extensionGalleryManifest, token);
            } catch (error) {
              if (!resourceApi.fallback) {
                throw error;
              }
              this.n.error(`Error while getting the latest version for the extension ${extensionInfo.id} from ${resourceApi.uri}. Trying the fallback ${resourceApi.fallback}`, $qb(error));
              this.q.publicLog2("galleryService:fallbacktounpkg", {
                extension: extensionInfo.id,
                preRelease: !!extensionInfo.preRelease,
                compatible: !!options2.compatible
              });
              galleryExtension = await this.D(extensionInfo, options2, resourceApi.fallback, extensionGalleryManifest, token);
            }
            if (galleryExtension === "NOT_FOUND") {
              if (extensionInfo.uuid) {
                toQuery.push(extensionInfo);
              }
              return;
            }
            if (galleryExtension) {
              result.push(galleryExtension);
            }
          } catch (error) {
            this.n.error(`Error while getting the latest version for the extension ${extensionInfo.id}.`, $qb(error));
            this.q.publicLog2("galleryService:fallbacktoquery", {
              extension: extensionInfo.id,
              preRelease: !!extensionInfo.preRelease,
              compatible: !!options2.compatible,
              fromFallback: !!resourceApi.fallback
            });
            toQuery.push(extensionInfo);
          }
        }));
        if (toQuery.length) {
          const extensions = await this.B(toQuery, options2, extensionGalleryManifest, token);
          result.push(...extensions);
        }
        return result;
      }
      async D(extensionInfo, options2, resourceUriTemplate, extensionGalleryManifest, token) {
        const [publisher, name] = extensionInfo.id.split(".");
        const uri = URI.parse($8f(resourceUriTemplate, { publisher, name }));
        const rawGalleryExtension = await this.M(extensionInfo.id, uri, token);
        if (!rawGalleryExtension) {
          return "NOT_FOUND";
        }
        const allTargetPlatforms = getAllTargetPlatforms(rawGalleryExtension);
        const rawGalleryExtensionVersion = await this.J(rawGalleryExtension, {
          targetPlatform: options2.targetPlatform ?? CURRENT_TARGET_PLATFORM,
          compatible: !!options2.compatible,
          productVersion: options2.productVersion ?? {
            version: this.w.version,
            date: this.w.date
          },
          version: extensionInfo.preRelease ? 1 : 0
          /* VersionKind.Release */
        }, allTargetPlatforms);
        if (rawGalleryExtensionVersion) {
          return toExtension(rawGalleryExtension, rawGalleryExtensionVersion, allTargetPlatforms, extensionGalleryManifest);
        }
        return null;
      }
      async getCompatibleExtension(extension, includePreRelease, targetPlatform, productVersion = { version: this.w.version, date: this.w.date }) {
        if ($9A(extension.allTargetPlatforms, targetPlatform)) {
          return null;
        }
        if (await this.isExtensionCompatible(extension, includePreRelease, targetPlatform)) {
          return extension;
        }
        if (this.y.isAllowed({ id: extension.identifier.id, publisherDisplayName: extension.publisherDisplayName }) !== true) {
          return null;
        }
        const result = await this.getExtensions([{
          ...extension.identifier,
          preRelease: includePreRelease,
          hasPreRelease: extension.hasPreReleaseVersion
        }], {
          compatible: true,
          productVersion,
          queryAllVersions: true,
          targetPlatform
        }, CancellationToken.None);
        return result[0] ?? null;
      }
      async isExtensionCompatible(extension, includePreRelease, targetPlatform, productVersion = { version: this.w.version, date: this.w.date }) {
        if (this.y.isAllowed(extension) !== true) {
          return false;
        }
        if (!$0A(extension.properties.targetPlatform, extension.allTargetPlatforms, targetPlatform)) {
          return false;
        }
        if (!includePreRelease && extension.properties.isPreReleaseVersion) {
          return false;
        }
        let engine = extension.properties.engine;
        if (!engine) {
          const manifest = await this.getManifest(extension, CancellationToken.None);
          if (!manifest) {
            throw new Error("Manifest was not found");
          }
          engine = manifest.engines.vscode;
        }
        if (!$LB(engine, productVersion.version, productVersion.date)) {
          return false;
        }
        if (!this.E(extension.identifier, extension.properties.enabledApiProposals)) {
          return false;
        }
        return true;
      }
      E(extensionIdentifier, enabledApiProposals) {
        if (!enabledApiProposals) {
          return true;
        }
        if (!this.j.includes(extensionIdentifier.id.toLowerCase())) {
          return true;
        }
        return $MB(enabledApiProposals);
      }
      async F(extension, rawGalleryExtensionVersion, { targetPlatform, compatible, productVersion, version }, publisherDisplayName, allTargetPlatforms) {
        if ($Wc(version)) {
          if (rawGalleryExtensionVersion.version !== version) {
            return false;
          }
        } else if (version === 0 || version === 1) {
          if (isPreReleaseVersion(rawGalleryExtensionVersion) !== (version === 1)) {
            return false;
          }
        }
        const targetPlatformForExtension = getTargetPlatformForExtensionVersion(rawGalleryExtensionVersion);
        if (!$0A(targetPlatformForExtension, allTargetPlatforms, targetPlatform)) {
          return false;
        }
        if (compatible) {
          if (this.y.isAllowed({ id: extension, publisherDisplayName, version: rawGalleryExtensionVersion.version, prerelease: isPreReleaseVersion(rawGalleryExtensionVersion), targetPlatform: targetPlatformForExtension }) !== true) {
            return false;
          }
          try {
            const engine = await this.P(extension, rawGalleryExtensionVersion);
            if (!$LB(engine, productVersion.version, productVersion.date)) {
              return false;
            }
          } catch (error) {
            this.n.error(`Error while getting the engine for the version ${rawGalleryExtensionVersion.version}.`, $qb(error));
            return false;
          }
        }
        return true;
      }
      async query(options2, token) {
        const extensionGalleryManifest = await this.z.getExtensionGalleryManifest();
        if (!extensionGalleryManifest) {
          throw new Error("No extension gallery service configured.");
        }
        let text = options2.text || "";
        const pageSize = options2.pageSize ?? 50;
        let query = new Query().withPage(1, pageSize);
        if (text) {
          text = text.replace(/\bcategory:("([^"]*)"|([^"]\S*))(\s+|\b|$)/g, (_, quotedCategory, category) => {
            query = query.withFilter("Category", category || quotedCategory);
            return "";
          });
          text = text.replace(/\btag:("([^"]*)"|([^"]\S*))(\s+|\b|$)/g, (_, quotedTag, tag2) => {
            query = query.withFilter("Tag", tag2 || quotedTag);
            return "";
          });
          text = text.replace(/\bfeatured(\s+|\b|$)/g, () => {
            query = query.withFilter(
              "Featured"
              /* FilterType.Featured */
            );
            return "";
          });
          text = text.trim();
          if (text) {
            text = text.length < 200 ? text : text.substring(0, 200);
            query = query.withFilter("SearchText", text);
          }
          if (extensionGalleryManifest.capabilities.extensionQuery.sorting?.some(
            (c) => c.name === "NoneOrRelevance"
            /* SortBy.NoneOrRelevance */
          )) {
            query = query.withSortBy(
              "NoneOrRelevance"
              /* SortBy.NoneOrRelevance */
            );
          }
        } else {
          if (extensionGalleryManifest.capabilities.extensionQuery.sorting?.some(
            (c) => c.name === "InstallCount"
            /* SortBy.InstallCount */
          )) {
            query = query.withSortBy(
              "InstallCount"
              /* SortBy.InstallCount */
            );
          }
        }
        if (options2.sortBy && extensionGalleryManifest.capabilities.extensionQuery.sorting?.some((c) => c.name === options2.sortBy)) {
          query = query.withSortBy(options2.sortBy);
        }
        if (typeof options2.sortOrder === "number") {
          query = query.withSortOrder(options2.sortOrder);
        }
        if (options2.source) {
          query = query.withSource(options2.source);
        }
        const runQuery = async (query2, token2) => {
          const { extensions: extensions2, total: total2 } = await this.G(query2, { targetPlatform: CURRENT_TARGET_PLATFORM, compatible: false, includePreRelease: !!options2.includePreRelease, productVersion: options2.productVersion ?? { version: this.w.version, date: this.w.date } }, extensionGalleryManifest, token2);
          extensions2.forEach((e, index) => setTelemetry(e, (query2.pageNumber - 1) * query2.pageSize + index, options2.source));
          return { extensions: extensions2, total: total2 };
        };
        const { extensions, total } = await runQuery(query, token);
        const getPage = async (pageIndex, ct) => {
          if (ct.isCancellationRequested) {
            throw new $lb();
          }
          const { extensions: extensions2 } = await runQuery(query.withPage(pageIndex + 1), ct);
          return extensions2;
        };
        return { firstPage: extensions, total, pageSize: query.pageSize, getPage };
      }
      async G(query, criteria, extensionGalleryManifest, token) {
        if (this.w.quality !== "stable" && await this.k?.getTreatment("useLatestPrereleaseAndStableVersionFlag")) {
          return this.I(query, criteria, extensionGalleryManifest, token);
        }
        return this.H(query, criteria, extensionGalleryManifest, token);
      }
      async H(query, criteria, extensionGalleryManifest, token) {
        const flags = query.flags;
        if (query.flags.includes(
          "IncludeLatestVersionOnly"
          /* Flag.IncludeLatestVersionOnly */
        ) && query.flags.includes(
          "IncludeVersions"
          /* Flag.IncludeVersions */
        )) {
          query = query.withFlags(...query.flags.filter(
            (flag) => flag !== "IncludeVersions"
            /* Flag.IncludeVersions */
          ));
        }
        if (!query.flags.includes(
          "IncludeLatestVersionOnly"
          /* Flag.IncludeLatestVersionOnly */
        ) && !query.flags.includes(
          "IncludeVersions"
          /* Flag.IncludeVersions */
        )) {
          query = query.withFlags(
            ...query.flags,
            "IncludeLatestVersionOnly"
            /* Flag.IncludeLatestVersionOnly */
          );
        }
        if (criteria.versions?.length || criteria.isQueryForReleaseVersionFromPreReleaseVersion) {
          query = query.withFlags(
            ...query.flags.filter(
              (flag) => flag !== "IncludeLatestVersionOnly"
              /* Flag.IncludeLatestVersionOnly */
            ),
            "IncludeVersions"
            /* Flag.IncludeVersions */
          );
        }
        query = query.withFlags(
          ...query.flags,
          "IncludeAssetUri",
          "IncludeCategoryAndTags",
          "IncludeFiles",
          "IncludeStatistics",
          "IncludeVersionProperties"
          /* Flag.IncludeVersionProperties */
        );
        const { galleryExtensions: rawGalleryExtensions, total, context } = await this.K(query, extensionGalleryManifest, token);
        const hasAllVersions = !query.flags.includes(
          "IncludeLatestVersionOnly"
          /* Flag.IncludeLatestVersionOnly */
        );
        if (hasAllVersions) {
          const extensions = [];
          for (const rawGalleryExtension of rawGalleryExtensions) {
            const allTargetPlatforms = getAllTargetPlatforms(rawGalleryExtension);
            const extensionIdentifier = { id: $sB(rawGalleryExtension.publisher.publisherName, rawGalleryExtension.extensionName), uuid: rawGalleryExtension.extensionId };
            const includePreRelease = $3c(criteria.includePreRelease) ? criteria.includePreRelease : !!criteria.includePreRelease.find((extensionIdentifierWithPreRelease) => $nB(extensionIdentifierWithPreRelease, extensionIdentifier))?.includePreRelease;
            const rawGalleryExtensionVersion = await this.J(rawGalleryExtension, {
              compatible: criteria.compatible,
              targetPlatform: criteria.targetPlatform,
              productVersion: criteria.productVersion,
              version: criteria.versions?.find((extensionIdentifierWithVersion) => $nB(extensionIdentifierWithVersion, extensionIdentifier))?.version ?? (includePreRelease ? 2 : 0)
            }, allTargetPlatforms);
            if (rawGalleryExtensionVersion) {
              extensions.push(toExtension(rawGalleryExtension, rawGalleryExtensionVersion, allTargetPlatforms, extensionGalleryManifest, context));
            }
          }
          return { extensions, total };
        }
        const result = [];
        const needAllVersions = /* @__PURE__ */ new Map();
        for (let index = 0; index < rawGalleryExtensions.length; index++) {
          const rawGalleryExtension = rawGalleryExtensions[index];
          const extensionIdentifier = { id: $sB(rawGalleryExtension.publisher.publisherName, rawGalleryExtension.extensionName), uuid: rawGalleryExtension.extensionId };
          const includePreRelease = $3c(criteria.includePreRelease) ? criteria.includePreRelease : !!criteria.includePreRelease.find((extensionIdentifierWithPreRelease) => $nB(extensionIdentifierWithPreRelease, extensionIdentifier))?.includePreRelease;
          const allTargetPlatforms = getAllTargetPlatforms(rawGalleryExtension);
          if (criteria.compatible) {
            if ($9A(allTargetPlatforms, criteria.targetPlatform)) {
              continue;
            }
            if (this.y.isAllowed({ id: extensionIdentifier.id, publisherDisplayName: rawGalleryExtension.publisher.displayName }) !== true) {
              continue;
            }
          }
          const rawGalleryExtensionVersion = await this.J(rawGalleryExtension, {
            compatible: criteria.compatible,
            targetPlatform: criteria.targetPlatform,
            productVersion: criteria.productVersion,
            version: criteria.versions?.find((extensionIdentifierWithVersion) => $nB(extensionIdentifierWithVersion, extensionIdentifier))?.version ?? (includePreRelease ? 2 : 0)
          }, allTargetPlatforms);
          const extension = rawGalleryExtensionVersion ? toExtension(rawGalleryExtension, rawGalleryExtensionVersion, allTargetPlatforms, extensionGalleryManifest, context) : null;
          if (!extension || extension.properties.isPreReleaseVersion && (!includePreRelease || !extension.hasReleaseVersion) || !extension.properties.isPreReleaseVersion && extension.properties.targetPlatform !== criteria.targetPlatform && extension.hasPreReleaseVersion) {
            needAllVersions.set(rawGalleryExtension.extensionId, index);
          } else {
            result.push([index, extension]);
          }
        }
        if (needAllVersions.size) {
          const stopWatch = new $4e();
          const query2 = new Query().withFlags(
            ...flags.filter(
              (flag) => flag !== "IncludeLatestVersionOnly"
              /* Flag.IncludeLatestVersionOnly */
            ),
            "IncludeVersions"
            /* Flag.IncludeVersions */
          ).withPage(1, needAllVersions.size).withFilter("ExtensionId", ...needAllVersions.keys());
          const { extensions } = await this.G(query2, criteria, extensionGalleryManifest, token);
          this.q.publicLog2("galleryService:additionalQuery", {
            duration: stopWatch.elapsed(),
            count: needAllVersions.size
          });
          for (const extension of extensions) {
            const index = needAllVersions.get(extension.identifier.uuid);
            result.push([index, extension]);
          }
        }
        return { extensions: result.sort((a, b) => a[0] - b[0]).map(([, extension]) => extension), total };
      }
      async I(query, criteria, extensionGalleryManifest, token) {
        if (criteria.versions?.length) {
          query = query.withFlags(
            ...query.flags.filter(
              (flag) => flag !== "IncludeLatestVersionOnly" && flag !== "IncludeLatestPrereleaseAndStableVersionOnly"
              /* Flag.IncludeLatestPrereleaseAndStableVersionOnly */
            ),
            "IncludeVersions"
            /* Flag.IncludeVersions */
          );
        } else if (!query.flags.includes(
          "IncludeVersions"
          /* Flag.IncludeVersions */
        )) {
          const includeLatest = $3c(criteria.includePreRelease) ? criteria.includePreRelease : criteria.includePreRelease.every(({ includePreRelease }) => includePreRelease);
          query = includeLatest ? query.withFlags(
            ...query.flags.filter(
              (flag) => flag !== "IncludeLatestPrereleaseAndStableVersionOnly"
              /* Flag.IncludeLatestPrereleaseAndStableVersionOnly */
            ),
            "IncludeLatestVersionOnly"
            /* Flag.IncludeLatestVersionOnly */
          ) : query.withFlags(
            ...query.flags.filter(
              (flag) => flag !== "IncludeLatestVersionOnly"
              /* Flag.IncludeLatestVersionOnly */
            ),
            "IncludeLatestPrereleaseAndStableVersionOnly"
            /* Flag.IncludeLatestPrereleaseAndStableVersionOnly */
          );
        }
        if (query.flags.includes(
          "IncludeVersions"
          /* Flag.IncludeVersions */
        ) && (query.flags.includes(
          "IncludeLatestVersionOnly"
          /* Flag.IncludeLatestVersionOnly */
        ) || query.flags.includes(
          "IncludeLatestPrereleaseAndStableVersionOnly"
          /* Flag.IncludeLatestPrereleaseAndStableVersionOnly */
        ))) {
          query = query.withFlags(
            ...query.flags.filter(
              (flag) => flag !== "IncludeLatestVersionOnly" && flag !== "IncludeLatestPrereleaseAndStableVersionOnly"
              /* Flag.IncludeLatestPrereleaseAndStableVersionOnly */
            ),
            "IncludeVersions"
            /* Flag.IncludeVersions */
          );
        }
        query = query.withFlags(
          ...query.flags,
          "IncludeAssetUri",
          "IncludeCategoryAndTags",
          "IncludeFiles",
          "IncludeStatistics",
          "IncludeVersionProperties"
          /* Flag.IncludeVersionProperties */
        );
        const { galleryExtensions: rawGalleryExtensions, total, context } = await this.K(query, extensionGalleryManifest, token);
        const extensions = [];
        for (let index = 0; index < rawGalleryExtensions.length; index++) {
          const rawGalleryExtension = rawGalleryExtensions[index];
          const extensionIdentifier = { id: $sB(rawGalleryExtension.publisher.publisherName, rawGalleryExtension.extensionName), uuid: rawGalleryExtension.extensionId };
          const allTargetPlatforms = getAllTargetPlatforms(rawGalleryExtension);
          if (criteria.compatible) {
            if ($9A(allTargetPlatforms, criteria.targetPlatform)) {
              continue;
            }
            if (this.y.isAllowed({ id: extensionIdentifier.id, publisherDisplayName: rawGalleryExtension.publisher.displayName }) !== true) {
              continue;
            }
          }
          const version = criteria.versions?.find((extensionIdentifierWithVersion) => $nB(extensionIdentifierWithVersion, extensionIdentifier))?.version ?? (($3c(criteria.includePreRelease) ? criteria.includePreRelease : !!criteria.includePreRelease.find((extensionIdentifierWithPreRelease) => $nB(extensionIdentifierWithPreRelease, extensionIdentifier))?.includePreRelease) ? 2 : 0);
          const rawGalleryExtensionVersion = await this.J(rawGalleryExtension, {
            compatible: criteria.compatible,
            targetPlatform: criteria.targetPlatform,
            productVersion: criteria.productVersion,
            version
          }, allTargetPlatforms);
          if (rawGalleryExtensionVersion) {
            extensions.push(toExtension(rawGalleryExtension, rawGalleryExtensionVersion, allTargetPlatforms, extensionGalleryManifest, context));
          }
        }
        return { extensions, total };
      }
      async J(rawGalleryExtension, criteria, allTargetPlatforms) {
        const extensionIdentifier = { id: $sB(rawGalleryExtension.publisher.publisherName, rawGalleryExtension.extensionName), uuid: rawGalleryExtension.extensionId };
        const rawGalleryExtensionVersions = $c1(rawGalleryExtension.versions, criteria.targetPlatform);
        if (criteria.compatible && $9A(allTargetPlatforms, criteria.targetPlatform)) {
          return null;
        }
        const version = $Wc(criteria.version) ? criteria.version : void 0;
        for (let index = 0; index < rawGalleryExtensionVersions.length; index++) {
          const rawGalleryExtensionVersion = rawGalleryExtensionVersions[index];
          if (await this.F(extensionIdentifier.id, rawGalleryExtensionVersion, criteria, rawGalleryExtension.publisher.displayName, allTargetPlatforms)) {
            if (criteria.compatible && !this.E(extensionIdentifier, getEnabledApiProposals(rawGalleryExtensionVersion))) {
              continue;
            }
            return rawGalleryExtensionVersion;
          }
          if (version && rawGalleryExtensionVersion.version === version) {
            return null;
          }
        }
        if (version || criteria.compatible) {
          return null;
        }
        return rawGalleryExtension.versions[0];
      }
      async K(query, extensionGalleryManifest, token) {
        const extensionsQueryApi = $a1(
          extensionGalleryManifest,
          "ExtensionQueryService"
          /* ExtensionGalleryResourceType.ExtensionQueryService */
        );
        if (!extensionsQueryApi) {
          throw new Error("No extension gallery query service configured.");
        }
        query = query.withFlags(
          ...query.flags,
          "ExcludeNonValidated"
          /* Flag.ExcludeNonValidated */
        ).withFilter("Target", "Microsoft.VisualStudio.Code");
        const unpublishedFlag = extensionGalleryManifest.capabilities.extensionQuery.flags?.find(
          (f) => f.name === "Unpublished"
          /* Flag.Unpublished */
        );
        if (unpublishedFlag) {
          query = query.withFilter("ExcludeWithFlags", String(unpublishedFlag.value));
        }
        const data = JSON.stringify({
          filters: [
            {
              criteria: query.criteria.reduce((criteria, c) => {
                const criterium = extensionGalleryManifest.capabilities.extensionQuery.filtering?.find((f) => f.name === c.filterType);
                if (criterium) {
                  criteria.push({
                    filterType: criterium.value,
                    value: c.value
                  });
                }
                return criteria;
              }, []),
              pageNumber: query.pageNumber,
              pageSize: query.pageSize,
              sortBy: extensionGalleryManifest.capabilities.extensionQuery.sorting?.find((s) => s.name === query.sortBy)?.value,
              sortOrder: query.sortOrder
            }
          ],
          assetTypes: query.assetTypes,
          flags: query.flags.reduce((flags, flag) => {
            const flagValue = extensionGalleryManifest.capabilities.extensionQuery.flags?.find((f) => f.name === flag);
            if (flagValue) {
              flags |= flagValue.value;
            }
            return flags;
          }, 0)
        });
        const commonHeaders = await this.h;
        const headers = {
          ...commonHeaders,
          "Content-Type": "application/json",
          "Accept": "application/json;api-version=3.0-preview.1",
          "Accept-Encoding": "gzip",
          "Content-Length": String(data.length)
        };
        const stopWatch = new $4e();
        let context, errorCode, total = 0;
        try {
          context = await this.l.request({
            type: "POST",
            url: extensionsQueryApi,
            data,
            headers
          }, token);
          if (context.res.statusCode && context.res.statusCode >= 400 && context.res.statusCode < 500) {
            return { galleryExtensions: [], total };
          }
          const result = await $Wv(context);
          if (result) {
            const r = result.results[0];
            const galleryExtensions = r.extensions;
            const resultCount = r.resultMetadata && r.resultMetadata.filter((m) => m.metadataType === "ResultCount")[0];
            total = resultCount && resultCount.metadataItems.filter((i) => i.name === "TotalCount")[0].count || 0;
            return {
              galleryExtensions,
              total,
              context: context.res.headers["activityid"] ? {
                [SEARCH_ACTIVITY_HEADER_NAME]: context.res.headers["activityid"]
              } : {}
            };
          }
          return { galleryExtensions: [], total };
        } catch (e) {
          if ($kb(e)) {
            errorCode = "Cancelled";
            throw e;
          } else {
            const errorMessage = $qb(e);
            errorCode = $Ov(e) ? "Offline" : errorMessage.startsWith("XHR timeout") ? "Timeout" : "Failed";
            throw new $aB(errorMessage, errorCode);
          }
        } finally {
          this.q.publicLog2("galleryService:query", {
            filterTypes: query.criteria.map((criterium) => criterium.filterType),
            flags: query.flags,
            sortBy: query.sortBy,
            sortOrder: String(query.sortOrder),
            pageNumber: String(query.pageNumber),
            source: query.source,
            searchTextLength: query.searchText.length,
            requestBodySize: String(data.length),
            duration: stopWatch.elapsed(),
            success: !!context && $Sv(context),
            responseBodySize: context?.res.headers["Content-Length"],
            statusCode: context ? String(context.res.statusCode) : void 0,
            errorCode,
            count: String(total),
            server: this.L(context?.res.headers, SERVER_HEADER_NAME),
            activityId: this.L(context?.res.headers, ACTIVITY_HEADER_NAME),
            endToEndId: this.L(context?.res.headers, END_END_ID_HEADER_NAME)
          });
        }
      }
      L(headers, name) {
        const value = headers?.[name.toLowerCase()];
        return Array.isArray(value) ? value[0] : value;
      }
      async M(extension, uri, token) {
        let errorCode;
        const stopWatch = new $4e();
        let context;
        try {
          const commonHeaders = await this.h;
          const headers = {
            ...commonHeaders,
            "Content-Type": "application/json",
            "Accept": "application/json;api-version=7.2-preview",
            "Accept-Encoding": "gzip"
          };
          context = await this.l.request({
            type: "GET",
            url: uri.toString(true),
            headers,
            timeout: 1e4
            /*10s*/
          }, token);
          if (context.res.statusCode === 404) {
            errorCode = "NotFound";
            return null;
          }
          if (context.res.statusCode && context.res.statusCode !== 200) {
            errorCode = `GalleryServiceError:` + context.res.statusCode;
            throw new Error("Unexpected HTTP response: " + context.res.statusCode);
          }
          const result = await $Wv(context);
          if (!result) {
            errorCode = "NoData";
          }
          return result;
        } catch (error) {
          if ($kb(error)) {
            errorCode = "Cancelled";
          } else {
            const errorMessage = $qb(error);
            errorCode = $Ov(error) ? "Offline" : errorMessage.startsWith("XHR timeout") ? "Timeout" : "Failed";
          }
          throw error;
        } finally {
          this.q.publicLog2("galleryService:getLatest", {
            extension,
            host: uri.authority,
            duration: stopWatch.elapsed(),
            errorCode,
            server: this.L(context?.res.headers, SERVER_HEADER_NAME),
            activityId: this.L(context?.res.headers, ACTIVITY_HEADER_NAME),
            endToEndId: this.L(context?.res.headers, END_END_ID_HEADER_NAME)
          });
        }
      }
      async reportStatistic(publisher, name, version, type2) {
        const manifest = await this.z.getExtensionGalleryManifest();
        if (!manifest) {
          return void 0;
        }
        let url3;
        if ($r) {
          const resource = $a1(
            manifest,
            "WebExtensionStatisticsUriTemplate"
            /* ExtensionGalleryResourceType.WebExtensionStatisticsUri */
          );
          if (!resource) {
            return;
          }
          url3 = $8f(resource, { publisher, name, version, statTypeValue: type2 === "install" ? "1" : "3" });
        } else {
          const resource = $a1(
            manifest,
            "ExtensionStatisticsUriTemplate"
            /* ExtensionGalleryResourceType.ExtensionStatisticsUri */
          );
          if (!resource) {
            return;
          }
          url3 = $8f(resource, { publisher, name, version, statTypeName: type2 });
        }
        const Accept = $r ? "api-version=6.1-preview.1" : "*/*;api-version=4.0-preview.1";
        const commonHeaders = await this.h;
        const headers = { ...commonHeaders, Accept };
        try {
          await this.l.request({
            type: "POST",
            url: url3,
            headers
          }, CancellationToken.None);
        } catch (error) {
        }
      }
      async download(extension, location2, operation) {
        this.n.trace("ExtensionGalleryService#download", extension.identifier.id);
        const data = $vB(extension);
        const startTime = (/* @__PURE__ */ new Date()).getTime();
        const operationParam = operation === 2 ? "install" : operation === 3 ? "update" : "";
        const downloadAsset = operationParam ? {
          uri: `${extension.assets.download.uri}${URI.parse(extension.assets.download.uri).query ? "&" : "?"}${operationParam}=true`,
          fallbackUri: `${extension.assets.download.fallbackUri}${URI.parse(extension.assets.download.fallbackUri).query ? "&" : "?"}${operationParam}=true`
        } : extension.assets.download;
        const headers = extension.queryContext?.[SEARCH_ACTIVITY_HEADER_NAME] ? { [SEARCH_ACTIVITY_HEADER_NAME]: extension.queryContext[SEARCH_ACTIVITY_HEADER_NAME] } : void 0;
        const context = await this.O(extension.identifier.id, downloadAsset, AssetType.VSIX, extension.version, headers ? { headers } : void 0);
        try {
          await this.u.writeFile(location2, context.stream);
        } catch (error) {
          try {
            await this.u.del(location2);
          } catch (e) {
            this.n.warn(`Error while deleting the file ${location2.toString()}`, $qb(e));
          }
          throw new $aB(
            $qb(error),
            "DownloadFailedWriting"
            /* ExtensionGalleryErrorCode.DownloadFailedWriting */
          );
        }
        this.q.publicLog("galleryService:downloadVSIX", { ...data, duration: (/* @__PURE__ */ new Date()).getTime() - startTime });
      }
      async downloadSignatureArchive(extension, location2) {
        if (!extension.assets.signature) {
          throw new Error("No signature asset found");
        }
        this.n.trace("ExtensionGalleryService#downloadSignatureArchive", extension.identifier.id);
        const context = await this.O(extension.identifier.id, extension.assets.signature, AssetType.Signature, extension.version);
        try {
          await this.u.writeFile(location2, context.stream);
        } catch (error) {
          try {
            await this.u.del(location2);
          } catch (e) {
            this.n.warn(`Error while deleting the file ${location2.toString()}`, $qb(e));
          }
          throw new $aB(
            $qb(error),
            "DownloadFailedWriting"
            /* ExtensionGalleryErrorCode.DownloadFailedWriting */
          );
        }
      }
      async getReadme(extension, token) {
        if (extension.assets.readme) {
          const context = await this.O(extension.identifier.id, extension.assets.readme, AssetType.Details, extension.version, {}, token);
          const content = await $Vv(context);
          return content || "";
        }
        return "";
      }
      async getManifest(extension, token) {
        if (extension.assets.manifest) {
          const context = await this.O(extension.identifier.id, extension.assets.manifest, AssetType.Manifest, extension.version, {}, token);
          const text = await $Vv(context);
          return text ? JSON.parse(text) : null;
        }
        return null;
      }
      async N(extension, rawExtensionVersion, token) {
        const manifestAsset = getVersionAsset(rawExtensionVersion, AssetType.Manifest);
        if (!manifestAsset) {
          throw new Error("Manifest was not found");
        }
        const headers = { "Accept-Encoding": "gzip" };
        const context = await this.O(extension, manifestAsset, AssetType.Manifest, rawExtensionVersion.version, { headers });
        return await $Wv(context);
      }
      async getCoreTranslation(extension, languageId) {
        const asset = extension.assets.coreTranslations.filter((t) => t[0] === languageId.toUpperCase())[0];
        if (asset) {
          const context = await this.O(extension.identifier.id, asset[1], asset[0], extension.version);
          const text = await $Vv(context);
          return text ? JSON.parse(text) : null;
        }
        return null;
      }
      async getChangelog(extension, token) {
        if (extension.assets.changelog) {
          const context = await this.O(extension.identifier.id, extension.assets.changelog, AssetType.Changelog, extension.version, {}, token);
          const content = await $Vv(context);
          return content || "";
        }
        return "";
      }
      async getAllCompatibleVersions(extensionIdentifier, includePreRelease, targetPlatform) {
        const extensionGalleryManifest = await this.z.getExtensionGalleryManifest();
        if (!extensionGalleryManifest) {
          throw new Error("No extension gallery service configured.");
        }
        let query = new Query().withFlags(
          "IncludeVersions",
          "IncludeCategoryAndTags",
          "IncludeFiles",
          "IncludeVersionProperties"
          /* Flag.IncludeVersionProperties */
        ).withPage(1, 1);
        if (extensionIdentifier.uuid) {
          query = query.withFilter("ExtensionId", extensionIdentifier.uuid);
        } else {
          query = query.withFilter("ExtensionName", extensionIdentifier.id);
        }
        const { galleryExtensions } = await this.K(query, extensionGalleryManifest, CancellationToken.None);
        if (!galleryExtensions.length) {
          return [];
        }
        const allTargetPlatforms = getAllTargetPlatforms(galleryExtensions[0]);
        if ($9A(allTargetPlatforms, targetPlatform)) {
          return [];
        }
        const validVersions = [];
        const productVersion = { version: this.w.version, date: this.w.date };
        await Promise.all(galleryExtensions[0].versions.map(async (version) => {
          try {
            if (await this.F(extensionIdentifier.id, version, {
              compatible: true,
              productVersion,
              targetPlatform,
              version: includePreRelease ? 2 : 0
              /* VersionKind.Release */
            }, galleryExtensions[0].publisher.displayName, allTargetPlatforms) && this.E(extensionIdentifier, getEnabledApiProposals(version))) {
              validVersions.push(version);
            }
          } catch (error) {
          }
        }));
        const result = [];
        const seen = /* @__PURE__ */ new Set();
        for (const version of $c1(validVersions, targetPlatform)) {
          if (!seen.has(version.version)) {
            seen.add(version.version);
            result.push({ version: version.version, date: version.lastUpdated, isPreReleaseVersion: isPreReleaseVersion(version) });
          }
        }
        return result;
      }
      async O(extension, asset, assetType, extensionVersion, options2 = {}, token = CancellationToken.None) {
        const commonHeaders = await this.h;
        const baseOptions = { type: "GET" };
        const headers = { ...commonHeaders, ...options2.headers || {} };
        options2 = { ...options2, ...baseOptions, headers };
        const url3 = asset.uri;
        const fallbackUrl = asset.fallbackUri;
        const firstOptions = { ...options2, url: url3 };
        let context;
        try {
          context = await this.l.request(firstOptions, token);
          if (context.res.statusCode === 200) {
            return context;
          }
          const message = await $Vv(context);
          throw new Error(`Expected 200, got back ${context.res.statusCode} instead.

${message}`);
        } catch (err) {
          if ($kb(err)) {
            throw err;
          }
          const message = $qb(err);
          this.q.publicLog2("galleryService:cdnFallback", {
            extension,
            assetType,
            message,
            extensionVersion,
            server: this.L(context?.res.headers, SERVER_HEADER_NAME),
            activityId: this.L(context?.res.headers, ACTIVITY_HEADER_NAME),
            endToEndId: this.L(context?.res.headers, END_END_ID_HEADER_NAME)
          });
          const fallbackOptions = { ...options2, url: fallbackUrl };
          return this.l.request(fallbackOptions, token);
        }
      }
      async P(extension, rawExtensionVersion) {
        let engine = getEngine(rawExtensionVersion);
        if (!engine) {
          this.q.publicLog2("galleryService:engineFallback", { extension, extensionVersion: rawExtensionVersion.version });
          const manifest = await this.N(extension, rawExtensionVersion, CancellationToken.None);
          if (!manifest) {
            throw new Error("Manifest was not found");
          }
          engine = manifest.engines.vscode;
        }
        return engine;
      }
      async getExtensionsControlManifest() {
        if (!this.isEnabled()) {
          throw new Error("No extension gallery service configured.");
        }
        if (!this.d) {
          return { malicious: [], deprecated: {}, search: [] };
        }
        const context = await this.l.request({
          type: "GET",
          url: this.d
        }, CancellationToken.None);
        if (context.res.statusCode !== 200) {
          throw new Error("Could not get extensions report.");
        }
        const result = await $Wv(context);
        const malicious = [];
        const deprecated = {};
        const search = [];
        const extensionsEnabledWithPreRelease = [];
        if (result) {
          for (const id2 of result.malicious) {
            if ($YA.test(id2)) {
              malicious.push({ id: id2 });
            } else {
              malicious.push(id2);
            }
          }
          if (result.migrateToPreRelease) {
            for (const [unsupportedPreReleaseExtensionId, preReleaseExtensionInfo] of Object.entries(result.migrateToPreRelease)) {
              if (!preReleaseExtensionInfo.engine || $LB(preReleaseExtensionInfo.engine, this.w.version, this.w.date)) {
                deprecated[unsupportedPreReleaseExtensionId.toLowerCase()] = {
                  disallowInstall: true,
                  extension: {
                    id: preReleaseExtensionInfo.id,
                    displayName: preReleaseExtensionInfo.displayName,
                    autoMigrate: { storage: !!preReleaseExtensionInfo.migrateStorage },
                    preRelease: true
                  }
                };
              }
            }
          }
          if (result.deprecated) {
            for (const [deprecatedExtensionId, deprecationInfo] of Object.entries(result.deprecated)) {
              if (deprecationInfo) {
                deprecated[deprecatedExtensionId.toLowerCase()] = $3c(deprecationInfo) ? {} : deprecationInfo;
              }
            }
          }
          if (result.search) {
            for (const s of result.search) {
              search.push(s);
            }
          }
          if (Array.isArray(result.extensionsEnabledWithPreRelease)) {
            for (const id2 of result.extensionsEnabledWithPreRelease) {
              extensionsEnabledWithPreRelease.push(id2.toLowerCase());
            }
          }
        }
        return { malicious, deprecated, search, extensionsEnabledWithPreRelease };
      }
    };
    $d1 = __decorate([
      __param(2, $Qv),
      __param(3, $5n),
      __param(4, $rl),
      __param(5, $iw),
      __param(6, $Sm),
      __param(7, $Dv),
      __param(8, $Ql),
      __param(9, $hB),
      __param(10, $_Z)
    ], $d1);
    $e1 = class $e12 extends $d1 {
      constructor(storageService, requestService, logService, environmentService, telemetryService, fileService, productService, configurationService, allowedExtensionsService, extensionGalleryManifestService) {
        super(storageService, void 0, requestService, logService, environmentService, telemetryService, fileService, productService, configurationService, allowedExtensionsService, extensionGalleryManifestService);
      }
    };
    $e1 = __decorate([
      __param(0, $5v),
      __param(1, $Qv),
      __param(2, $5n),
      __param(3, $rl),
      __param(4, $iw),
      __param(5, $Sm),
      __param(6, $Dv),
      __param(7, $Ql),
      __param(8, $hB),
      __param(9, $_Z)
    ], $e1);
    $f1 = class $f12 extends $d1 {
      constructor(requestService, logService, environmentService, telemetryService, fileService, productService, configurationService, allowedExtensionsService, extensionGalleryManifestService) {
        super(void 0, void 0, requestService, logService, environmentService, telemetryService, fileService, productService, configurationService, allowedExtensionsService, extensionGalleryManifestService);
      }
    };
    $f1 = __decorate([
      __param(0, $Qv),
      __param(1, $5n),
      __param(2, $rl),
      __param(3, $iw),
      __param(4, $Sm),
      __param(5, $Dv),
      __param(6, $Ql),
      __param(7, $hB),
      __param(8, $_Z)
    ], $f1);
  }
});

// out-build/vs/base/node/zip.js
import { createWriteStream, promises as promises5 } from "fs";
function modeFromEntry(entry) {
  const attr = entry.externalFileAttributes >> 16 || 33188;
  return [
    448,
    56,
    7
    /* S_IRWXO */
  ].map((mask) => attr & mask).reduce(
    (a, b) => a + b,
    attr & 61440
    /* S_IFMT */
  );
}
function toExtractError(err) {
  if (err instanceof $r1) {
    return err;
  }
  let type2 = void 0;
  if (CORRUPT_ZIP_PATTERN.test(err.message)) {
    type2 = "CorruptZip";
  }
  return new $r1(type2, err);
}
function extractEntry(stream, fileName, mode, targetPath, options2, token) {
  const dirName = $rc(fileName);
  const targetDirName = $oc(targetPath, dirName);
  if (!targetDirName.startsWith(targetPath)) {
    return Promise.reject(new Error(localize(145, null, fileName)));
  }
  const targetFileName = $oc(targetPath, fileName);
  let istream;
  token.onCancellationRequested(() => {
    istream?.destroy();
  });
  return Promise.resolve(promises5.mkdir(targetDirName, { recursive: true })).then(() => new Promise((c, e) => {
    if (token.isCancellationRequested) {
      return;
    }
    try {
      istream = createWriteStream(targetFileName, { mode });
      istream.once("close", () => c());
      istream.once("error", e);
      stream.once("error", e);
      stream.pipe(istream);
    } catch (error) {
      e(error);
    }
  }));
}
function extractZip(zipfile, targetPath, options2, token) {
  let last = $2h(() => Promise.resolve());
  let extractedEntriesCount = 0;
  const listener = token.onCancellationRequested(() => {
    last.cancel();
    zipfile.close();
  });
  return new Promise((c, e) => {
    const throttler = new $$h();
    const readNextEntry = (token2) => {
      if (token2.isCancellationRequested) {
        return;
      }
      extractedEntriesCount++;
      zipfile.readEntry();
    };
    zipfile.once("error", e);
    zipfile.once("close", () => last.then(() => {
      if (token.isCancellationRequested || zipfile.entryCount === extractedEntriesCount) {
        c();
      } else {
        e(new $r1("Incomplete", new Error(localize(146, null, extractedEntriesCount, zipfile.entryCount))));
      }
    }, e));
    zipfile.readEntry();
    zipfile.on("entry", (entry) => {
      if (token.isCancellationRequested) {
        return;
      }
      if (!options2.sourcePathRegex.test(entry.fileName)) {
        readNextEntry(token);
        return;
      }
      const fileName = entry.fileName.replace(options2.sourcePathRegex, "");
      if (/\/$/.test(fileName)) {
        const targetFileName = $oc(targetPath, fileName);
        last = $2h((token2) => promises5.mkdir(targetFileName, { recursive: true }).then(() => readNextEntry(token2)).then(void 0, e));
        return;
      }
      const stream = openZipStream(zipfile, entry);
      const mode = modeFromEntry(entry);
      last = $2h((token2) => throttler.queue(() => stream.then((stream2) => extractEntry(stream2, fileName, mode, targetPath, options2, token2).then(() => readNextEntry(token2)))).then(null, e));
    });
  }).finally(() => listener.dispose());
}
async function openZip(zipFile, lazy = false) {
  const { open: open2 } = await import("yauzl");
  return new Promise((resolve4, reject) => {
    open2(zipFile, lazy ? { lazyEntries: true } : void 0, (error, zipfile) => {
      if (error) {
        reject(toExtractError(error));
      } else {
        resolve4($8c(zipfile));
      }
    });
  });
}
function openZipStream(zipFile, entry) {
  return new Promise((resolve4, reject) => {
    zipFile.openReadStream(entry, (error, stream) => {
      if (error) {
        reject(toExtractError(error));
      } else {
        resolve4($8c(stream));
      }
    });
  });
}
async function zip(zipPath, files) {
  const { ZipFile } = await import("yazl");
  return new Promise((c, e) => {
    const zip2 = new ZipFile();
    files.forEach((f) => {
      if (f.contents) {
        zip2.addBuffer(typeof f.contents === "string" ? Buffer.from(f.contents, "utf8") : f.contents, f.path);
      } else if (f.localPath) {
        zip2.addFile(f.localPath, f.path);
      }
    });
    zip2.end();
    const zipStream = createWriteStream(zipPath);
    zip2.outputStream.pipe(zipStream);
    zip2.outputStream.once("error", e);
    zipStream.once("error", e);
    zipStream.once("finish", () => c(zipPath));
  });
}
function $t1(zipPath, targetPath, options2 = {}, token) {
  const sourcePathRegex = new RegExp(options2.sourcePath ? `^${options2.sourcePath}` : "");
  let promise = openZip(zipPath, true);
  if (options2.overwrite) {
    promise = promise.then((zipfile) => Promises2.rm(targetPath).then(() => zipfile));
  }
  return promise.then((zipfile) => extractZip(zipfile, targetPath, { sourcePathRegex }, token));
}
function read2(zipPath, filePath) {
  return openZip(zipPath).then((zipfile) => {
    return new Promise((c, e) => {
      zipfile.on("entry", (entry) => {
        if (entry.fileName === filePath) {
          openZipStream(zipfile, entry).then((stream) => c(stream), (err) => e(err));
        }
      });
      zipfile.once("close", () => e(new Error(localize(147, null, filePath))));
    });
  });
}
function $u1(zipPath, filePath) {
  return read2(zipPath, filePath).then((stream) => {
    return new Promise((c, e) => {
      const buffers = [];
      stream.once("error", e);
      stream.on("data", (b) => buffers.push(b));
      stream.on("end", () => c(Buffer.concat(buffers)));
    });
  });
}
var $q1, CORRUPT_ZIP_PATTERN, $r1;
var init_zip = __esm({
  "out-build/vs/base/node/zip.js"() {
    "use strict";
    init_async();
    init_path();
    init_types();
    init_pfs();
    init_nls2();
    $q1 = "end of central directory record signature not found";
    CORRUPT_ZIP_PATTERN = new RegExp($q1);
    $r1 = class extends Error {
      constructor(type2, cause) {
        let message = cause.message;
        switch (type2) {
          case "CorruptZip":
            message = `Corrupt ZIP: ${message}`;
            break;
        }
        super(message);
        this.type = type2;
        this.cause = cause;
      }
    };
  }
});

// out-build/vs/platform/download/common/download.js
var $6Z;
var init_download = __esm({
  "out-build/vs/platform/download/common/download.js"() {
    "use strict";
    init_instantiation();
    $6Z = $kl("downloadService");
  }
});

// out-build/vs/base/common/naturalLanguage/korean.js
var codeBuffer, HangulRangeStartCode, AsciiCode, AsciiCodeCombo, modernConsonants, modernVowels, modernFinalConsonants, compatibilityJamo;
var init_korean = __esm({
  "out-build/vs/base/common/naturalLanguage/korean.js"() {
    "use strict";
    codeBuffer = new Uint32Array(10);
    (function(HangulRangeStartCode2) {
      HangulRangeStartCode2[HangulRangeStartCode2["InitialConsonant"] = 4352] = "InitialConsonant";
      HangulRangeStartCode2[HangulRangeStartCode2["Vowel"] = 4449] = "Vowel";
      HangulRangeStartCode2[HangulRangeStartCode2["FinalConsonant"] = 4520] = "FinalConsonant";
      HangulRangeStartCode2[HangulRangeStartCode2["CompatibilityJamo"] = 12593] = "CompatibilityJamo";
    })(HangulRangeStartCode || (HangulRangeStartCode = {}));
    (function(AsciiCode2) {
      AsciiCode2[AsciiCode2["NUL"] = 0] = "NUL";
      AsciiCode2[AsciiCode2["A"] = 65] = "A";
      AsciiCode2[AsciiCode2["B"] = 66] = "B";
      AsciiCode2[AsciiCode2["C"] = 67] = "C";
      AsciiCode2[AsciiCode2["D"] = 68] = "D";
      AsciiCode2[AsciiCode2["E"] = 69] = "E";
      AsciiCode2[AsciiCode2["F"] = 70] = "F";
      AsciiCode2[AsciiCode2["G"] = 71] = "G";
      AsciiCode2[AsciiCode2["H"] = 72] = "H";
      AsciiCode2[AsciiCode2["I"] = 73] = "I";
      AsciiCode2[AsciiCode2["J"] = 74] = "J";
      AsciiCode2[AsciiCode2["K"] = 75] = "K";
      AsciiCode2[AsciiCode2["L"] = 76] = "L";
      AsciiCode2[AsciiCode2["M"] = 77] = "M";
      AsciiCode2[AsciiCode2["N"] = 78] = "N";
      AsciiCode2[AsciiCode2["O"] = 79] = "O";
      AsciiCode2[AsciiCode2["P"] = 80] = "P";
      AsciiCode2[AsciiCode2["Q"] = 81] = "Q";
      AsciiCode2[AsciiCode2["R"] = 82] = "R";
      AsciiCode2[AsciiCode2["S"] = 83] = "S";
      AsciiCode2[AsciiCode2["T"] = 84] = "T";
      AsciiCode2[AsciiCode2["U"] = 85] = "U";
      AsciiCode2[AsciiCode2["V"] = 86] = "V";
      AsciiCode2[AsciiCode2["W"] = 87] = "W";
      AsciiCode2[AsciiCode2["X"] = 88] = "X";
      AsciiCode2[AsciiCode2["Y"] = 89] = "Y";
      AsciiCode2[AsciiCode2["Z"] = 90] = "Z";
      AsciiCode2[AsciiCode2["a"] = 97] = "a";
      AsciiCode2[AsciiCode2["b"] = 98] = "b";
      AsciiCode2[AsciiCode2["c"] = 99] = "c";
      AsciiCode2[AsciiCode2["d"] = 100] = "d";
      AsciiCode2[AsciiCode2["e"] = 101] = "e";
      AsciiCode2[AsciiCode2["f"] = 102] = "f";
      AsciiCode2[AsciiCode2["g"] = 103] = "g";
      AsciiCode2[AsciiCode2["h"] = 104] = "h";
      AsciiCode2[AsciiCode2["i"] = 105] = "i";
      AsciiCode2[AsciiCode2["j"] = 106] = "j";
      AsciiCode2[AsciiCode2["k"] = 107] = "k";
      AsciiCode2[AsciiCode2["l"] = 108] = "l";
      AsciiCode2[AsciiCode2["m"] = 109] = "m";
      AsciiCode2[AsciiCode2["n"] = 110] = "n";
      AsciiCode2[AsciiCode2["o"] = 111] = "o";
      AsciiCode2[AsciiCode2["p"] = 112] = "p";
      AsciiCode2[AsciiCode2["q"] = 113] = "q";
      AsciiCode2[AsciiCode2["r"] = 114] = "r";
      AsciiCode2[AsciiCode2["s"] = 115] = "s";
      AsciiCode2[AsciiCode2["t"] = 116] = "t";
      AsciiCode2[AsciiCode2["u"] = 117] = "u";
      AsciiCode2[AsciiCode2["v"] = 118] = "v";
      AsciiCode2[AsciiCode2["w"] = 119] = "w";
      AsciiCode2[AsciiCode2["x"] = 120] = "x";
      AsciiCode2[AsciiCode2["y"] = 121] = "y";
      AsciiCode2[AsciiCode2["z"] = 122] = "z";
    })(AsciiCode || (AsciiCode = {}));
    (function(AsciiCodeCombo2) {
      AsciiCodeCombo2[AsciiCodeCombo2["fa"] = 24934] = "fa";
      AsciiCodeCombo2[AsciiCodeCombo2["fg"] = 26470] = "fg";
      AsciiCodeCombo2[AsciiCodeCombo2["fq"] = 29030] = "fq";
      AsciiCodeCombo2[AsciiCodeCombo2["fr"] = 29286] = "fr";
      AsciiCodeCombo2[AsciiCodeCombo2["ft"] = 29798] = "ft";
      AsciiCodeCombo2[AsciiCodeCombo2["fv"] = 30310] = "fv";
      AsciiCodeCombo2[AsciiCodeCombo2["fx"] = 30822] = "fx";
      AsciiCodeCombo2[AsciiCodeCombo2["hk"] = 27496] = "hk";
      AsciiCodeCombo2[AsciiCodeCombo2["hl"] = 27752] = "hl";
      AsciiCodeCombo2[AsciiCodeCombo2["ho"] = 28520] = "ho";
      AsciiCodeCombo2[AsciiCodeCombo2["ml"] = 27757] = "ml";
      AsciiCodeCombo2[AsciiCodeCombo2["nj"] = 27246] = "nj";
      AsciiCodeCombo2[AsciiCodeCombo2["nl"] = 27758] = "nl";
      AsciiCodeCombo2[AsciiCodeCombo2["np"] = 28782] = "np";
      AsciiCodeCombo2[AsciiCodeCombo2["qt"] = 29809] = "qt";
      AsciiCodeCombo2[AsciiCodeCombo2["rt"] = 29810] = "rt";
      AsciiCodeCombo2[AsciiCodeCombo2["sg"] = 26483] = "sg";
      AsciiCodeCombo2[AsciiCodeCombo2["sw"] = 30579] = "sw";
    })(AsciiCodeCombo || (AsciiCodeCombo = {}));
    modernConsonants = new Uint8Array([
      114,
      // ㄱ
      82,
      // ㄲ
      115,
      // ㄴ
      101,
      // ㄷ
      69,
      // ㄸ
      102,
      // ㄹ
      97,
      // ㅁ
      113,
      // ㅂ
      81,
      // ㅃ
      116,
      // ㅅ
      84,
      // ㅆ
      100,
      // ㅇ
      119,
      // ㅈ
      87,
      // ㅉ
      99,
      // ㅊ
      122,
      // ㅋ
      120,
      // ㅌ
      118,
      // ㅍ
      103
      // ㅎ
    ]);
    modernVowels = new Uint16Array([
      107,
      //  -> ㅏ
      111,
      //  -> ㅐ
      105,
      //  -> ㅑ
      79,
      //  -> ㅒ
      106,
      //  -> ㅓ
      112,
      //  -> ㅔ
      117,
      //  -> ㅕ
      80,
      //  -> ㅖ
      104,
      //  -> ㅗ
      27496,
      //  -> ㅘ
      28520,
      //  -> ㅙ
      27752,
      //  -> ㅚ
      121,
      //  -> ㅛ
      110,
      //  -> ㅜ
      27246,
      //  -> ㅝ
      28782,
      //  -> ㅞ
      27758,
      //  -> ㅟ
      98,
      //  -> ㅠ
      109,
      //  -> ㅡ
      27757,
      //  -> ㅢ
      108
      //  -> ㅣ
    ]);
    modernFinalConsonants = new Uint16Array([
      114,
      // ㄱ
      82,
      // ㄲ
      29810,
      // ㄳ
      115,
      // ㄴ
      30579,
      // ㄵ
      26483,
      // ㄶ
      101,
      // ㄷ
      102,
      // ㄹ
      29286,
      // ㄺ
      24934,
      // ㄻ
      29030,
      // ㄼ
      29798,
      // ㄽ
      30822,
      // ㄾ
      30310,
      // ㄿ
      26470,
      // ㅀ
      97,
      // ㅁ
      113,
      // ㅂ
      29809,
      // ㅄ
      116,
      // ㅅ
      84,
      // ㅆ
      100,
      // ㅇ
      119,
      // ㅈ
      99,
      // ㅊ
      122,
      // ㅋ
      120,
      // ㅌ
      118,
      // ㅍ
      103
      // ㅎ
    ]);
    compatibilityJamo = new Uint16Array([
      114,
      // ㄱ
      82,
      // ㄲ
      29810,
      // ㄳ
      115,
      // ㄴ
      30579,
      // ㄵ
      26483,
      // ㄶ
      101,
      // ㄷ
      69,
      // ㄸ
      102,
      // ㄹ
      29286,
      // ㄺ
      24934,
      // ㄻ
      29030,
      // ㄼ
      29798,
      // ㄽ
      30822,
      // ㄾ
      30310,
      // ㄿ
      26470,
      // ㅀ
      97,
      // ㅁ
      113,
      // ㅂ
      81,
      // ㅃ
      29809,
      // ㅄ
      116,
      // ㅅ
      84,
      // ㅆ
      100,
      // ㅇ
      119,
      // ㅈ
      87,
      // ㅉ
      99,
      // ㅊ
      122,
      // ㅋ
      120,
      // ㅌ
      118,
      // ㅍ
      103,
      // ㅎ
      107,
      // ㅏ
      111,
      // ㅐ
      105,
      // ㅑ
      79,
      // ㅒ
      106,
      // ㅓ
      112,
      // ㅔ
      117,
      // ㅕ
      80,
      // ㅖ
      104,
      // ㅗ
      27496,
      // ㅘ
      28520,
      // ㅙ
      27752,
      // ㅚ
      121,
      // ㅛ
      110,
      // ㅜ
      27246,
      // ㅝ
      28782,
      // ㅞ
      27758,
      // ㅟ
      98,
      // ㅠ
      109,
      // ㅡ
      27757,
      // ㅢ
      108
      // ㅣ
      // HF: Hangul Filler (everything after this is archaic)
      // ㅥ
      // ㅦ
      // ㅧ
      // ㅨ
      // ㅩ
      // ㅪ
      // ㅫ
      // ㅬ
      // ㅮ
      // ㅯ
      // ㅰ
      // ㅱ
      // ㅲ
      // ㅳ
      // ㅴ
      // ㅵ
      // ㅶ
      // ㅷ
      // ㅸ
      // ㅹ
      // ㅺ
      // ㅻ
      // ㅼ
      // ㅽ
      // ㅾ
      // ㅿ
      // ㆀ
      // ㆁ
      // ㆂ
      // ㆃ
      // ㆄ
      // ㆅ
      // ㆆ
      // ㆇ
      // ㆈ
      // ㆉ
      // ㆊ
      // ㆋ
      // ㆌ
      // ㆍ
      // ㆎ
    ]);
  }
});

// out-build/vs/base/common/filters.js
function or(...filter) {
  return function(word, wordToMatchAgainst) {
    for (let i = 0, len = filter.length; i < len; i++) {
      const match = filter[i](word, wordToMatchAgainst);
      if (match) {
        return match;
      }
    }
    return null;
  };
}
function _matchesPrefix(ignoreCase, word, wordToMatchAgainst) {
  if (!wordToMatchAgainst || wordToMatchAgainst.length < word.length) {
    return null;
  }
  let matches;
  if (ignoreCase) {
    matches = $zg(wordToMatchAgainst, word);
  } else {
    matches = wordToMatchAgainst.indexOf(word) === 0;
  }
  if (!matches) {
    return null;
  }
  return word.length > 0 ? [{ start: 0, end: word.length }] : [];
}
function $hm(word, wordToMatchAgainst) {
  const index = wordToMatchAgainst.toLowerCase().indexOf(word.toLowerCase());
  if (index === -1) {
    return null;
  }
  return [{ start: index, end: index + word.length }];
}
function $im(word, wordToMatchAgainst) {
  return _matchesSubString(word.toLowerCase(), wordToMatchAgainst.toLowerCase(), 0, 0);
}
function _matchesSubString(word, wordToMatchAgainst, i, j) {
  if (i === word.length) {
    return [];
  } else if (j === wordToMatchAgainst.length) {
    return null;
  } else {
    if (word[i] === wordToMatchAgainst[j]) {
      let result = null;
      if (result = _matchesSubString(word, wordToMatchAgainst, i + 1, j + 1)) {
        return join3({ start: j, end: j + 1 }, result);
      }
      return null;
    }
    return _matchesSubString(word, wordToMatchAgainst, i, j + 1);
  }
}
function isLower(code) {
  return 97 <= code && code <= 122;
}
function $jm(code) {
  return 65 <= code && code <= 90;
}
function isNumber(code) {
  return 48 <= code && code <= 57;
}
function isWhitespace2(code) {
  return code === 32 || code === 9 || code === 10 || code === 13;
}
function isAlphanumeric(code) {
  return isLower(code) || $jm(code) || isNumber(code);
}
function join3(head, tail) {
  if (tail.length === 0) {
    tail = [head];
  } else if (head.end === tail[0].start) {
    tail[0].start = head.start;
  } else {
    tail.unshift(head);
  }
  return tail;
}
function nextAnchor(camelCaseWord, start) {
  for (let i = start; i < camelCaseWord.length; i++) {
    const c = camelCaseWord.charCodeAt(i);
    if ($jm(c) || isNumber(c) || i > 0 && !isAlphanumeric(camelCaseWord.charCodeAt(i - 1))) {
      return i;
    }
  }
  return camelCaseWord.length;
}
function _matchesCamelCase(word, camelCaseWord, i, j) {
  if (i === word.length) {
    return [];
  } else if (j === camelCaseWord.length) {
    return null;
  } else if (word[i] !== camelCaseWord[j].toLowerCase()) {
    return null;
  } else {
    let result = null;
    let nextUpperIndex = j + 1;
    result = _matchesCamelCase(word, camelCaseWord, i + 1, j + 1);
    while (!result && (nextUpperIndex = nextAnchor(camelCaseWord, nextUpperIndex)) < camelCaseWord.length) {
      result = _matchesCamelCase(word, camelCaseWord, i + 1, nextUpperIndex);
      nextUpperIndex++;
    }
    return result === null ? null : join3({ start: j, end: j + 1 }, result);
  }
}
function analyzeCamelCaseWord(word) {
  let upper = 0, lower = 0, alpha = 0, numeric = 0, code = 0;
  for (let i = 0; i < word.length; i++) {
    code = word.charCodeAt(i);
    if ($jm(code)) {
      upper++;
    }
    if (isLower(code)) {
      lower++;
    }
    if (isAlphanumeric(code)) {
      alpha++;
    }
    if (isNumber(code)) {
      numeric++;
    }
  }
  const upperPercent = upper / word.length;
  const lowerPercent = lower / word.length;
  const alphaPercent = alpha / word.length;
  const numericPercent = numeric / word.length;
  return { upperPercent, lowerPercent, alphaPercent, numericPercent };
}
function isUpperCaseWord(analysis) {
  const { upperPercent, lowerPercent } = analysis;
  return lowerPercent === 0 && upperPercent > 0.6;
}
function isCamelCaseWord(analysis) {
  const { upperPercent, lowerPercent, alphaPercent, numericPercent } = analysis;
  return lowerPercent > 0.2 && upperPercent < 0.8 && alphaPercent > 0.6 && numericPercent < 0.2;
}
function isCamelCasePattern(word) {
  let upper = 0, lower = 0, code = 0, whitespace = 0;
  for (let i = 0; i < word.length; i++) {
    code = word.charCodeAt(i);
    if ($jm(code)) {
      upper++;
    }
    if (isLower(code)) {
      lower++;
    }
    if (isWhitespace2(code)) {
      whitespace++;
    }
  }
  if ((upper === 0 || lower === 0) && whitespace === 0) {
    return word.length <= 30;
  } else {
    return upper <= 5;
  }
}
function $km(word, camelCaseWord) {
  if (!camelCaseWord) {
    return null;
  }
  camelCaseWord = camelCaseWord.trim();
  if (camelCaseWord.length === 0) {
    return null;
  }
  if (!isCamelCasePattern(word)) {
    return null;
  }
  if (camelCaseWord.length > 60) {
    camelCaseWord = camelCaseWord.substring(0, 60);
  }
  const analysis = analyzeCamelCaseWord(camelCaseWord);
  if (!isCamelCaseWord(analysis)) {
    if (!isUpperCaseWord(analysis)) {
      return null;
    }
    camelCaseWord = camelCaseWord.toLowerCase();
  }
  let result = null;
  let i = 0;
  word = word.toLowerCase();
  while (i < camelCaseWord.length && (result = _matchesCamelCase(word, camelCaseWord, 0, i)) === null) {
    i = nextAnchor(camelCaseWord, i + 1);
  }
  return result;
}
function initTable() {
  const table = [];
  const row = [];
  for (let i = 0; i <= _maxLen; i++) {
    row[i] = 0;
  }
  for (let i = 0; i <= _maxLen; i++) {
    table.push(row.slice(0));
  }
  return table;
}
function initArr(maxLen) {
  const row = [];
  for (let i = 0; i <= maxLen; i++) {
    row[i] = 0;
  }
  return row;
}
var $fm, $gm, wordSeparators, fuzzyContiguousFilter, fuzzySeparateFilter, fuzzyRegExpCache, _maxLen, _minWordMatchPos, _maxWordMatchPos, _diag, _table, _arrows, Arrow, FuzzyScore, $rm;
var init_filters = __esm({
  "out-build/vs/base/common/filters.js"() {
    "use strict";
    init_map();
    init_korean();
    init_strings();
    $fm = _matchesPrefix.bind(void 0, false);
    $gm = _matchesPrefix.bind(void 0, true);
    wordSeparators = /* @__PURE__ */ new Set();
    "()[]{}<>`'\"-/;:,.?!".split("").forEach((s) => wordSeparators.add(s.charCodeAt(0)));
    fuzzyContiguousFilter = or($gm, $km, $hm);
    fuzzySeparateFilter = or($gm, $km, $im);
    fuzzyRegExpCache = new $Ic(1e4);
    _maxLen = 128;
    _minWordMatchPos = initArr(2 * _maxLen);
    _maxWordMatchPos = initArr(2 * _maxLen);
    _diag = initTable();
    _table = initTable();
    _arrows = initTable();
    (function(Arrow2) {
      Arrow2[Arrow2["Diag"] = 1] = "Diag";
      Arrow2[Arrow2["Left"] = 2] = "Left";
      Arrow2[Arrow2["LeftLeft"] = 3] = "LeftLeft";
    })(Arrow || (Arrow = {}));
    (function(FuzzyScore2) {
      FuzzyScore2.Default = [-100, 0];
      function isDefault(score) {
        return !score || score.length === 2 && score[0] === -100 && score[1] === 0;
      }
      FuzzyScore2.isDefault = isDefault;
    })(FuzzyScore || (FuzzyScore = {}));
    $rm = class {
      static {
        this.default = { boostFullMatch: true, firstMatchCanBeWeak: false };
      }
      constructor(firstMatchCanBeWeak, boostFullMatch) {
        this.firstMatchCanBeWeak = firstMatchCanBeWeak;
        this.boostFullMatch = boostFullMatch;
      }
    };
  }
});

// out-build/vs/base/common/codiconsUtil.js
function $vm(id2, fontCharacter) {
  if ($Wc(fontCharacter)) {
    const val = _codiconFontCharacters[fontCharacter];
    if (val === void 0) {
      throw new Error(`${id2} references an unknown codicon: ${fontCharacter}`);
    }
    fontCharacter = val;
  }
  _codiconFontCharacters[id2] = fontCharacter;
  return { id: id2 };
}
var _codiconFontCharacters;
var init_codiconsUtil = __esm({
  "out-build/vs/base/common/codiconsUtil.js"() {
    "use strict";
    init_types();
    _codiconFontCharacters = /* @__PURE__ */ Object.create(null);
  }
});

// out-build/vs/base/common/codiconsLibrary.js
var $xm;
var init_codiconsLibrary = __esm({
  "out-build/vs/base/common/codiconsLibrary.js"() {
    "use strict";
    init_codiconsUtil();
    $xm = {
      add: $vm("add", 6e4),
      plus: $vm("plus", 6e4),
      gistNew: $vm("gist-new", 6e4),
      repoCreate: $vm("repo-create", 6e4),
      lightbulb: $vm("lightbulb", 60001),
      lightBulb: $vm("light-bulb", 60001),
      repo: $vm("repo", 60002),
      repoDelete: $vm("repo-delete", 60002),
      gistFork: $vm("gist-fork", 60003),
      repoForked: $vm("repo-forked", 60003),
      gitPullRequest: $vm("git-pull-request", 60004),
      gitPullRequestAbandoned: $vm("git-pull-request-abandoned", 60004),
      recordKeys: $vm("record-keys", 60005),
      keyboard: $vm("keyboard", 60005),
      tag: $vm("tag", 60006),
      gitPullRequestLabel: $vm("git-pull-request-label", 60006),
      tagAdd: $vm("tag-add", 60006),
      tagRemove: $vm("tag-remove", 60006),
      person: $vm("person", 60007),
      personFollow: $vm("person-follow", 60007),
      personOutline: $vm("person-outline", 60007),
      personFilled: $vm("person-filled", 60007),
      gitBranch: $vm("git-branch", 60008),
      gitBranchCreate: $vm("git-branch-create", 60008),
      gitBranchDelete: $vm("git-branch-delete", 60008),
      sourceControl: $vm("source-control", 60008),
      mirror: $vm("mirror", 60009),
      mirrorPublic: $vm("mirror-public", 60009),
      star: $vm("star", 60010),
      starAdd: $vm("star-add", 60010),
      starDelete: $vm("star-delete", 60010),
      starEmpty: $vm("star-empty", 60010),
      comment: $vm("comment", 60011),
      commentAdd: $vm("comment-add", 60011),
      alert: $vm("alert", 60012),
      warning: $vm("warning", 60012),
      search: $vm("search", 60013),
      searchSave: $vm("search-save", 60013),
      logOut: $vm("log-out", 60014),
      signOut: $vm("sign-out", 60014),
      logIn: $vm("log-in", 60015),
      signIn: $vm("sign-in", 60015),
      eye: $vm("eye", 60016),
      eyeUnwatch: $vm("eye-unwatch", 60016),
      eyeWatch: $vm("eye-watch", 60016),
      circleFilled: $vm("circle-filled", 60017),
      primitiveDot: $vm("primitive-dot", 60017),
      closeDirty: $vm("close-dirty", 60017),
      debugBreakpoint: $vm("debug-breakpoint", 60017),
      debugBreakpointDisabled: $vm("debug-breakpoint-disabled", 60017),
      debugHint: $vm("debug-hint", 60017),
      terminalDecorationSuccess: $vm("terminal-decoration-success", 60017),
      primitiveSquare: $vm("primitive-square", 60018),
      edit: $vm("edit", 60019),
      pencil: $vm("pencil", 60019),
      info: $vm("info", 60020),
      issueOpened: $vm("issue-opened", 60020),
      gistPrivate: $vm("gist-private", 60021),
      gitForkPrivate: $vm("git-fork-private", 60021),
      lock: $vm("lock", 60021),
      mirrorPrivate: $vm("mirror-private", 60021),
      close: $vm("close", 60022),
      removeClose: $vm("remove-close", 60022),
      x: $vm("x", 60022),
      repoSync: $vm("repo-sync", 60023),
      sync: $vm("sync", 60023),
      clone: $vm("clone", 60024),
      desktopDownload: $vm("desktop-download", 60024),
      beaker: $vm("beaker", 60025),
      microscope: $vm("microscope", 60025),
      vm: $vm("vm", 60026),
      deviceDesktop: $vm("device-desktop", 60026),
      file: $vm("file", 60027),
      fileText: $vm("file-text", 60027),
      more: $vm("more", 60028),
      ellipsis: $vm("ellipsis", 60028),
      kebabHorizontal: $vm("kebab-horizontal", 60028),
      mailReply: $vm("mail-reply", 60029),
      reply: $vm("reply", 60029),
      organization: $vm("organization", 60030),
      organizationFilled: $vm("organization-filled", 60030),
      organizationOutline: $vm("organization-outline", 60030),
      newFile: $vm("new-file", 60031),
      fileAdd: $vm("file-add", 60031),
      newFolder: $vm("new-folder", 60032),
      fileDirectoryCreate: $vm("file-directory-create", 60032),
      trash: $vm("trash", 60033),
      trashcan: $vm("trashcan", 60033),
      history: $vm("history", 60034),
      clock: $vm("clock", 60034),
      folder: $vm("folder", 60035),
      fileDirectory: $vm("file-directory", 60035),
      symbolFolder: $vm("symbol-folder", 60035),
      logoGithub: $vm("logo-github", 60036),
      markGithub: $vm("mark-github", 60036),
      github: $vm("github", 60036),
      terminal: $vm("terminal", 60037),
      console: $vm("console", 60037),
      repl: $vm("repl", 60037),
      zap: $vm("zap", 60038),
      symbolEvent: $vm("symbol-event", 60038),
      error: $vm("error", 60039),
      stop: $vm("stop", 60039),
      variable: $vm("variable", 60040),
      symbolVariable: $vm("symbol-variable", 60040),
      array: $vm("array", 60042),
      symbolArray: $vm("symbol-array", 60042),
      symbolModule: $vm("symbol-module", 60043),
      symbolPackage: $vm("symbol-package", 60043),
      symbolNamespace: $vm("symbol-namespace", 60043),
      symbolObject: $vm("symbol-object", 60043),
      symbolMethod: $vm("symbol-method", 60044),
      symbolFunction: $vm("symbol-function", 60044),
      symbolConstructor: $vm("symbol-constructor", 60044),
      symbolBoolean: $vm("symbol-boolean", 60047),
      symbolNull: $vm("symbol-null", 60047),
      symbolNumeric: $vm("symbol-numeric", 60048),
      symbolNumber: $vm("symbol-number", 60048),
      symbolStructure: $vm("symbol-structure", 60049),
      symbolStruct: $vm("symbol-struct", 60049),
      symbolParameter: $vm("symbol-parameter", 60050),
      symbolTypeParameter: $vm("symbol-type-parameter", 60050),
      symbolKey: $vm("symbol-key", 60051),
      symbolText: $vm("symbol-text", 60051),
      symbolReference: $vm("symbol-reference", 60052),
      goToFile: $vm("go-to-file", 60052),
      symbolEnum: $vm("symbol-enum", 60053),
      symbolValue: $vm("symbol-value", 60053),
      symbolRuler: $vm("symbol-ruler", 60054),
      symbolUnit: $vm("symbol-unit", 60054),
      activateBreakpoints: $vm("activate-breakpoints", 60055),
      archive: $vm("archive", 60056),
      arrowBoth: $vm("arrow-both", 60057),
      arrowDown: $vm("arrow-down", 60058),
      arrowLeft: $vm("arrow-left", 60059),
      arrowRight: $vm("arrow-right", 60060),
      arrowSmallDown: $vm("arrow-small-down", 60061),
      arrowSmallLeft: $vm("arrow-small-left", 60062),
      arrowSmallRight: $vm("arrow-small-right", 60063),
      arrowSmallUp: $vm("arrow-small-up", 60064),
      arrowUp: $vm("arrow-up", 60065),
      bell: $vm("bell", 60066),
      bold: $vm("bold", 60067),
      book: $vm("book", 60068),
      bookmark: $vm("bookmark", 60069),
      debugBreakpointConditionalUnverified: $vm("debug-breakpoint-conditional-unverified", 60070),
      debugBreakpointConditional: $vm("debug-breakpoint-conditional", 60071),
      debugBreakpointConditionalDisabled: $vm("debug-breakpoint-conditional-disabled", 60071),
      debugBreakpointDataUnverified: $vm("debug-breakpoint-data-unverified", 60072),
      debugBreakpointData: $vm("debug-breakpoint-data", 60073),
      debugBreakpointDataDisabled: $vm("debug-breakpoint-data-disabled", 60073),
      debugBreakpointLogUnverified: $vm("debug-breakpoint-log-unverified", 60074),
      debugBreakpointLog: $vm("debug-breakpoint-log", 60075),
      debugBreakpointLogDisabled: $vm("debug-breakpoint-log-disabled", 60075),
      briefcase: $vm("briefcase", 60076),
      broadcast: $vm("broadcast", 60077),
      browser: $vm("browser", 60078),
      bug: $vm("bug", 60079),
      calendar: $vm("calendar", 60080),
      caseSensitive: $vm("case-sensitive", 60081),
      check: $vm("check", 60082),
      checklist: $vm("checklist", 60083),
      chevronDown: $vm("chevron-down", 60084),
      chevronLeft: $vm("chevron-left", 60085),
      chevronRight: $vm("chevron-right", 60086),
      chevronUp: $vm("chevron-up", 60087),
      chromeClose: $vm("chrome-close", 60088),
      chromeMaximize: $vm("chrome-maximize", 60089),
      chromeMinimize: $vm("chrome-minimize", 60090),
      chromeRestore: $vm("chrome-restore", 60091),
      circleOutline: $vm("circle-outline", 60092),
      circle: $vm("circle", 60092),
      debugBreakpointUnverified: $vm("debug-breakpoint-unverified", 60092),
      terminalDecorationIncomplete: $vm("terminal-decoration-incomplete", 60092),
      circleSlash: $vm("circle-slash", 60093),
      circuitBoard: $vm("circuit-board", 60094),
      clearAll: $vm("clear-all", 60095),
      clippy: $vm("clippy", 60096),
      closeAll: $vm("close-all", 60097),
      cloudDownload: $vm("cloud-download", 60098),
      cloudUpload: $vm("cloud-upload", 60099),
      code: $vm("code", 60100),
      collapseAll: $vm("collapse-all", 60101),
      colorMode: $vm("color-mode", 60102),
      commentDiscussion: $vm("comment-discussion", 60103),
      creditCard: $vm("credit-card", 60105),
      dash: $vm("dash", 60108),
      dashboard: $vm("dashboard", 60109),
      database: $vm("database", 60110),
      debugContinue: $vm("debug-continue", 60111),
      debugDisconnect: $vm("debug-disconnect", 60112),
      debugPause: $vm("debug-pause", 60113),
      debugRestart: $vm("debug-restart", 60114),
      debugStart: $vm("debug-start", 60115),
      debugStepInto: $vm("debug-step-into", 60116),
      debugStepOut: $vm("debug-step-out", 60117),
      debugStepOver: $vm("debug-step-over", 60118),
      debugStop: $vm("debug-stop", 60119),
      debug: $vm("debug", 60120),
      deviceCameraVideo: $vm("device-camera-video", 60121),
      deviceCamera: $vm("device-camera", 60122),
      deviceMobile: $vm("device-mobile", 60123),
      diffAdded: $vm("diff-added", 60124),
      diffIgnored: $vm("diff-ignored", 60125),
      diffModified: $vm("diff-modified", 60126),
      diffRemoved: $vm("diff-removed", 60127),
      diffRenamed: $vm("diff-renamed", 60128),
      diff: $vm("diff", 60129),
      diffSidebyside: $vm("diff-sidebyside", 60129),
      discard: $vm("discard", 60130),
      editorLayout: $vm("editor-layout", 60131),
      emptyWindow: $vm("empty-window", 60132),
      exclude: $vm("exclude", 60133),
      extensions: $vm("extensions", 60134),
      eyeClosed: $vm("eye-closed", 60135),
      fileBinary: $vm("file-binary", 60136),
      fileCode: $vm("file-code", 60137),
      fileMedia: $vm("file-media", 60138),
      filePdf: $vm("file-pdf", 60139),
      fileSubmodule: $vm("file-submodule", 60140),
      fileSymlinkDirectory: $vm("file-symlink-directory", 60141),
      fileSymlinkFile: $vm("file-symlink-file", 60142),
      fileZip: $vm("file-zip", 60143),
      files: $vm("files", 60144),
      filter: $vm("filter", 60145),
      flame: $vm("flame", 60146),
      foldDown: $vm("fold-down", 60147),
      foldUp: $vm("fold-up", 60148),
      fold: $vm("fold", 60149),
      folderActive: $vm("folder-active", 60150),
      folderOpened: $vm("folder-opened", 60151),
      gear: $vm("gear", 60152),
      gift: $vm("gift", 60153),
      gistSecret: $vm("gist-secret", 60154),
      gist: $vm("gist", 60155),
      gitCommit: $vm("git-commit", 60156),
      gitCompare: $vm("git-compare", 60157),
      compareChanges: $vm("compare-changes", 60157),
      gitMerge: $vm("git-merge", 60158),
      githubAction: $vm("github-action", 60159),
      githubAlt: $vm("github-alt", 60160),
      globe: $vm("globe", 60161),
      grabber: $vm("grabber", 60162),
      graph: $vm("graph", 60163),
      gripper: $vm("gripper", 60164),
      heart: $vm("heart", 60165),
      home: $vm("home", 60166),
      horizontalRule: $vm("horizontal-rule", 60167),
      hubot: $vm("hubot", 60168),
      inbox: $vm("inbox", 60169),
      issueReopened: $vm("issue-reopened", 60171),
      issues: $vm("issues", 60172),
      italic: $vm("italic", 60173),
      jersey: $vm("jersey", 60174),
      json: $vm("json", 60175),
      kebabVertical: $vm("kebab-vertical", 60176),
      key: $vm("key", 60177),
      law: $vm("law", 60178),
      lightbulbAutofix: $vm("lightbulb-autofix", 60179),
      linkExternal: $vm("link-external", 60180),
      link: $vm("link", 60181),
      listOrdered: $vm("list-ordered", 60182),
      listUnordered: $vm("list-unordered", 60183),
      liveShare: $vm("live-share", 60184),
      loading: $vm("loading", 60185),
      location: $vm("location", 60186),
      mailRead: $vm("mail-read", 60187),
      mail: $vm("mail", 60188),
      markdown: $vm("markdown", 60189),
      megaphone: $vm("megaphone", 60190),
      mention: $vm("mention", 60191),
      milestone: $vm("milestone", 60192),
      gitPullRequestMilestone: $vm("git-pull-request-milestone", 60192),
      mortarBoard: $vm("mortar-board", 60193),
      move: $vm("move", 60194),
      multipleWindows: $vm("multiple-windows", 60195),
      mute: $vm("mute", 60196),
      noNewline: $vm("no-newline", 60197),
      note: $vm("note", 60198),
      octoface: $vm("octoface", 60199),
      openPreview: $vm("open-preview", 60200),
      package: $vm("package", 60201),
      paintcan: $vm("paintcan", 60202),
      pin: $vm("pin", 60203),
      play: $vm("play", 60204),
      run: $vm("run", 60204),
      plug: $vm("plug", 60205),
      preserveCase: $vm("preserve-case", 60206),
      preview: $vm("preview", 60207),
      project: $vm("project", 60208),
      pulse: $vm("pulse", 60209),
      question: $vm("question", 60210),
      quote: $vm("quote", 60211),
      radioTower: $vm("radio-tower", 60212),
      reactions: $vm("reactions", 60213),
      references: $vm("references", 60214),
      refresh: $vm("refresh", 60215),
      regex: $vm("regex", 60216),
      remoteExplorer: $vm("remote-explorer", 60217),
      remote: $vm("remote", 60218),
      remove: $vm("remove", 60219),
      replaceAll: $vm("replace-all", 60220),
      replace: $vm("replace", 60221),
      repoClone: $vm("repo-clone", 60222),
      repoForcePush: $vm("repo-force-push", 60223),
      repoPull: $vm("repo-pull", 60224),
      repoPush: $vm("repo-push", 60225),
      report: $vm("report", 60226),
      requestChanges: $vm("request-changes", 60227),
      rocket: $vm("rocket", 60228),
      rootFolderOpened: $vm("root-folder-opened", 60229),
      rootFolder: $vm("root-folder", 60230),
      rss: $vm("rss", 60231),
      ruby: $vm("ruby", 60232),
      saveAll: $vm("save-all", 60233),
      saveAs: $vm("save-as", 60234),
      save: $vm("save", 60235),
      screenFull: $vm("screen-full", 60236),
      screenNormal: $vm("screen-normal", 60237),
      searchStop: $vm("search-stop", 60238),
      server: $vm("server", 60240),
      settingsGear: $vm("settings-gear", 60241),
      settings: $vm("settings", 60242),
      shield: $vm("shield", 60243),
      smiley: $vm("smiley", 60244),
      sortPrecedence: $vm("sort-precedence", 60245),
      splitHorizontal: $vm("split-horizontal", 60246),
      splitVertical: $vm("split-vertical", 60247),
      squirrel: $vm("squirrel", 60248),
      starFull: $vm("star-full", 60249),
      starHalf: $vm("star-half", 60250),
      symbolClass: $vm("symbol-class", 60251),
      symbolColor: $vm("symbol-color", 60252),
      symbolConstant: $vm("symbol-constant", 60253),
      symbolEnumMember: $vm("symbol-enum-member", 60254),
      symbolField: $vm("symbol-field", 60255),
      symbolFile: $vm("symbol-file", 60256),
      symbolInterface: $vm("symbol-interface", 60257),
      symbolKeyword: $vm("symbol-keyword", 60258),
      symbolMisc: $vm("symbol-misc", 60259),
      symbolOperator: $vm("symbol-operator", 60260),
      symbolProperty: $vm("symbol-property", 60261),
      wrench: $vm("wrench", 60261),
      wrenchSubaction: $vm("wrench-subaction", 60261),
      symbolSnippet: $vm("symbol-snippet", 60262),
      tasklist: $vm("tasklist", 60263),
      telescope: $vm("telescope", 60264),
      textSize: $vm("text-size", 60265),
      threeBars: $vm("three-bars", 60266),
      thumbsdown: $vm("thumbsdown", 60267),
      thumbsup: $vm("thumbsup", 60268),
      tools: $vm("tools", 60269),
      triangleDown: $vm("triangle-down", 60270),
      triangleLeft: $vm("triangle-left", 60271),
      triangleRight: $vm("triangle-right", 60272),
      triangleUp: $vm("triangle-up", 60273),
      twitter: $vm("twitter", 60274),
      unfold: $vm("unfold", 60275),
      unlock: $vm("unlock", 60276),
      unmute: $vm("unmute", 60277),
      unverified: $vm("unverified", 60278),
      verified: $vm("verified", 60279),
      versions: $vm("versions", 60280),
      vmActive: $vm("vm-active", 60281),
      vmOutline: $vm("vm-outline", 60282),
      vmRunning: $vm("vm-running", 60283),
      watch: $vm("watch", 60284),
      whitespace: $vm("whitespace", 60285),
      wholeWord: $vm("whole-word", 60286),
      window: $vm("window", 60287),
      wordWrap: $vm("word-wrap", 60288),
      zoomIn: $vm("zoom-in", 60289),
      zoomOut: $vm("zoom-out", 60290),
      listFilter: $vm("list-filter", 60291),
      listFlat: $vm("list-flat", 60292),
      listSelection: $vm("list-selection", 60293),
      selection: $vm("selection", 60293),
      listTree: $vm("list-tree", 60294),
      debugBreakpointFunctionUnverified: $vm("debug-breakpoint-function-unverified", 60295),
      debugBreakpointFunction: $vm("debug-breakpoint-function", 60296),
      debugBreakpointFunctionDisabled: $vm("debug-breakpoint-function-disabled", 60296),
      debugStackframeActive: $vm("debug-stackframe-active", 60297),
      circleSmallFilled: $vm("circle-small-filled", 60298),
      debugStackframeDot: $vm("debug-stackframe-dot", 60298),
      terminalDecorationMark: $vm("terminal-decoration-mark", 60298),
      debugStackframe: $vm("debug-stackframe", 60299),
      debugStackframeFocused: $vm("debug-stackframe-focused", 60299),
      debugBreakpointUnsupported: $vm("debug-breakpoint-unsupported", 60300),
      symbolString: $vm("symbol-string", 60301),
      debugReverseContinue: $vm("debug-reverse-continue", 60302),
      debugStepBack: $vm("debug-step-back", 60303),
      debugRestartFrame: $vm("debug-restart-frame", 60304),
      debugAlt: $vm("debug-alt", 60305),
      callIncoming: $vm("call-incoming", 60306),
      callOutgoing: $vm("call-outgoing", 60307),
      menu: $vm("menu", 60308),
      expandAll: $vm("expand-all", 60309),
      feedback: $vm("feedback", 60310),
      gitPullRequestReviewer: $vm("git-pull-request-reviewer", 60310),
      groupByRefType: $vm("group-by-ref-type", 60311),
      ungroupByRefType: $vm("ungroup-by-ref-type", 60312),
      account: $vm("account", 60313),
      gitPullRequestAssignee: $vm("git-pull-request-assignee", 60313),
      bellDot: $vm("bell-dot", 60314),
      debugConsole: $vm("debug-console", 60315),
      library: $vm("library", 60316),
      output: $vm("output", 60317),
      runAll: $vm("run-all", 60318),
      syncIgnored: $vm("sync-ignored", 60319),
      pinned: $vm("pinned", 60320),
      githubInverted: $vm("github-inverted", 60321),
      serverProcess: $vm("server-process", 60322),
      serverEnvironment: $vm("server-environment", 60323),
      pass: $vm("pass", 60324),
      issueClosed: $vm("issue-closed", 60324),
      stopCircle: $vm("stop-circle", 60325),
      playCircle: $vm("play-circle", 60326),
      record: $vm("record", 60327),
      debugAltSmall: $vm("debug-alt-small", 60328),
      vmConnect: $vm("vm-connect", 60329),
      cloud: $vm("cloud", 60330),
      merge: $vm("merge", 60331),
      export: $vm("export", 60332),
      graphLeft: $vm("graph-left", 60333),
      magnet: $vm("magnet", 60334),
      notebook: $vm("notebook", 60335),
      redo: $vm("redo", 60336),
      checkAll: $vm("check-all", 60337),
      pinnedDirty: $vm("pinned-dirty", 60338),
      passFilled: $vm("pass-filled", 60339),
      circleLargeFilled: $vm("circle-large-filled", 60340),
      circleLarge: $vm("circle-large", 60341),
      circleLargeOutline: $vm("circle-large-outline", 60341),
      combine: $vm("combine", 60342),
      gather: $vm("gather", 60342),
      table: $vm("table", 60343),
      variableGroup: $vm("variable-group", 60344),
      typeHierarchy: $vm("type-hierarchy", 60345),
      typeHierarchySub: $vm("type-hierarchy-sub", 60346),
      typeHierarchySuper: $vm("type-hierarchy-super", 60347),
      gitPullRequestCreate: $vm("git-pull-request-create", 60348),
      runAbove: $vm("run-above", 60349),
      runBelow: $vm("run-below", 60350),
      notebookTemplate: $vm("notebook-template", 60351),
      debugRerun: $vm("debug-rerun", 60352),
      workspaceTrusted: $vm("workspace-trusted", 60353),
      workspaceUntrusted: $vm("workspace-untrusted", 60354),
      workspaceUnknown: $vm("workspace-unknown", 60355),
      terminalCmd: $vm("terminal-cmd", 60356),
      terminalDebian: $vm("terminal-debian", 60357),
      terminalLinux: $vm("terminal-linux", 60358),
      terminalPowershell: $vm("terminal-powershell", 60359),
      terminalTmux: $vm("terminal-tmux", 60360),
      terminalUbuntu: $vm("terminal-ubuntu", 60361),
      terminalBash: $vm("terminal-bash", 60362),
      arrowSwap: $vm("arrow-swap", 60363),
      copy: $vm("copy", 60364),
      personAdd: $vm("person-add", 60365),
      filterFilled: $vm("filter-filled", 60366),
      wand: $vm("wand", 60367),
      debugLineByLine: $vm("debug-line-by-line", 60368),
      inspect: $vm("inspect", 60369),
      layers: $vm("layers", 60370),
      layersDot: $vm("layers-dot", 60371),
      layersActive: $vm("layers-active", 60372),
      compass: $vm("compass", 60373),
      compassDot: $vm("compass-dot", 60374),
      compassActive: $vm("compass-active", 60375),
      azure: $vm("azure", 60376),
      issueDraft: $vm("issue-draft", 60377),
      gitPullRequestClosed: $vm("git-pull-request-closed", 60378),
      gitPullRequestDraft: $vm("git-pull-request-draft", 60379),
      debugAll: $vm("debug-all", 60380),
      debugCoverage: $vm("debug-coverage", 60381),
      runErrors: $vm("run-errors", 60382),
      folderLibrary: $vm("folder-library", 60383),
      debugContinueSmall: $vm("debug-continue-small", 60384),
      beakerStop: $vm("beaker-stop", 60385),
      graphLine: $vm("graph-line", 60386),
      graphScatter: $vm("graph-scatter", 60387),
      pieChart: $vm("pie-chart", 60388),
      bracket: $vm("bracket", 60175),
      bracketDot: $vm("bracket-dot", 60389),
      bracketError: $vm("bracket-error", 60390),
      lockSmall: $vm("lock-small", 60391),
      azureDevops: $vm("azure-devops", 60392),
      verifiedFilled: $vm("verified-filled", 60393),
      newline: $vm("newline", 60394),
      layout: $vm("layout", 60395),
      layoutActivitybarLeft: $vm("layout-activitybar-left", 60396),
      layoutActivitybarRight: $vm("layout-activitybar-right", 60397),
      layoutPanelLeft: $vm("layout-panel-left", 60398),
      layoutPanelCenter: $vm("layout-panel-center", 60399),
      layoutPanelJustify: $vm("layout-panel-justify", 60400),
      layoutPanelRight: $vm("layout-panel-right", 60401),
      layoutPanel: $vm("layout-panel", 60402),
      layoutSidebarLeft: $vm("layout-sidebar-left", 60403),
      layoutSidebarRight: $vm("layout-sidebar-right", 60404),
      layoutStatusbar: $vm("layout-statusbar", 60405),
      layoutMenubar: $vm("layout-menubar", 60406),
      layoutCentered: $vm("layout-centered", 60407),
      target: $vm("target", 60408),
      indent: $vm("indent", 60409),
      recordSmall: $vm("record-small", 60410),
      errorSmall: $vm("error-small", 60411),
      terminalDecorationError: $vm("terminal-decoration-error", 60411),
      arrowCircleDown: $vm("arrow-circle-down", 60412),
      arrowCircleLeft: $vm("arrow-circle-left", 60413),
      arrowCircleRight: $vm("arrow-circle-right", 60414),
      arrowCircleUp: $vm("arrow-circle-up", 60415),
      layoutSidebarRightOff: $vm("layout-sidebar-right-off", 60416),
      layoutPanelOff: $vm("layout-panel-off", 60417),
      layoutSidebarLeftOff: $vm("layout-sidebar-left-off", 60418),
      blank: $vm("blank", 60419),
      heartFilled: $vm("heart-filled", 60420),
      map: $vm("map", 60421),
      mapHorizontal: $vm("map-horizontal", 60421),
      foldHorizontal: $vm("fold-horizontal", 60421),
      mapFilled: $vm("map-filled", 60422),
      mapHorizontalFilled: $vm("map-horizontal-filled", 60422),
      foldHorizontalFilled: $vm("fold-horizontal-filled", 60422),
      circleSmall: $vm("circle-small", 60423),
      bellSlash: $vm("bell-slash", 60424),
      bellSlashDot: $vm("bell-slash-dot", 60425),
      commentUnresolved: $vm("comment-unresolved", 60426),
      gitPullRequestGoToChanges: $vm("git-pull-request-go-to-changes", 60427),
      gitPullRequestNewChanges: $vm("git-pull-request-new-changes", 60428),
      searchFuzzy: $vm("search-fuzzy", 60429),
      commentDraft: $vm("comment-draft", 60430),
      send: $vm("send", 60431),
      sparkle: $vm("sparkle", 60432),
      insert: $vm("insert", 60433),
      mic: $vm("mic", 60434),
      thumbsdownFilled: $vm("thumbsdown-filled", 60435),
      thumbsupFilled: $vm("thumbsup-filled", 60436),
      coffee: $vm("coffee", 60437),
      snake: $vm("snake", 60438),
      game: $vm("game", 60439),
      vr: $vm("vr", 60440),
      chip: $vm("chip", 60441),
      piano: $vm("piano", 60442),
      music: $vm("music", 60443),
      micFilled: $vm("mic-filled", 60444),
      repoFetch: $vm("repo-fetch", 60445),
      copilot: $vm("copilot", 60446),
      lightbulbSparkle: $vm("lightbulb-sparkle", 60447),
      robot: $vm("robot", 60448),
      sparkleFilled: $vm("sparkle-filled", 60449),
      diffSingle: $vm("diff-single", 60450),
      diffMultiple: $vm("diff-multiple", 60451),
      surroundWith: $vm("surround-with", 60452),
      share: $vm("share", 60453),
      gitStash: $vm("git-stash", 60454),
      gitStashApply: $vm("git-stash-apply", 60455),
      gitStashPop: $vm("git-stash-pop", 60456),
      vscode: $vm("vscode", 60457),
      vscodeInsiders: $vm("vscode-insiders", 60458),
      codeOss: $vm("code-oss", 60459),
      runCoverage: $vm("run-coverage", 60460),
      runAllCoverage: $vm("run-all-coverage", 60461),
      coverage: $vm("coverage", 60462),
      githubProject: $vm("github-project", 60463),
      mapVertical: $vm("map-vertical", 60464),
      foldVertical: $vm("fold-vertical", 60464),
      mapVerticalFilled: $vm("map-vertical-filled", 60465),
      foldVerticalFilled: $vm("fold-vertical-filled", 60465),
      goToSearch: $vm("go-to-search", 60466),
      percentage: $vm("percentage", 60467),
      sortPercentage: $vm("sort-percentage", 60467),
      attach: $vm("attach", 60468),
      goToEditingSession: $vm("go-to-editing-session", 60469),
      editSession: $vm("edit-session", 60470),
      codeReview: $vm("code-review", 60471),
      copilotWarning: $vm("copilot-warning", 60472),
      python: $vm("python", 60473),
      copilotLarge: $vm("copilot-large", 60474),
      copilotWarningLarge: $vm("copilot-warning-large", 60475),
      keyboardTab: $vm("keyboard-tab", 60476),
      copilotBlocked: $vm("copilot-blocked", 60477),
      copilotNotConnected: $vm("copilot-not-connected", 60478),
      flag: $vm("flag", 60479),
      lightbulbEmpty: $vm("lightbulb-empty", 60480),
      symbolMethodArrow: $vm("symbol-method-arrow", 60481)
    };
  }
});

// out-build/vs/base/common/codicons.js
function $ym() {
  return Object.values($Am);
}
var $zm, $Am;
var init_codicons = __esm({
  "out-build/vs/base/common/codicons.js"() {
    "use strict";
    init_codiconsUtil();
    init_codiconsLibrary();
    $zm = {
      dialogError: $vm("dialog-error", "error"),
      dialogWarning: $vm("dialog-warning", "warning"),
      dialogInfo: $vm("dialog-info", "info"),
      dialogClose: $vm("dialog-close", "close"),
      treeItemExpanded: $vm("tree-item-expanded", "chevron-down"),
      // collapsed is done with rotation
      treeFilterOnTypeOn: $vm("tree-filter-on-type-on", "list-filter"),
      treeFilterOnTypeOff: $vm("tree-filter-on-type-off", "list-selection"),
      treeFilterClear: $vm("tree-filter-clear", "close"),
      treeItemLoading: $vm("tree-item-loading", "loading"),
      menuSelection: $vm("menu-selection", "check"),
      menuSubmenu: $vm("menu-submenu", "chevron-right"),
      menuBarMore: $vm("menubar-more", "more"),
      scrollbarButtonLeft: $vm("scrollbar-button-left", "triangle-left"),
      scrollbarButtonRight: $vm("scrollbar-button-right", "triangle-right"),
      scrollbarButtonUp: $vm("scrollbar-button-up", "triangle-up"),
      scrollbarButtonDown: $vm("scrollbar-button-down", "triangle-down"),
      toolBarMore: $vm("toolbar-more", "more"),
      quickInputBack: $vm("quick-input-back", "arrow-left"),
      dropDownButton: $vm("drop-down-button", 60084),
      symbolCustomColor: $vm("symbol-customcolor", 60252),
      exportIcon: $vm("export", 60332),
      workspaceUnspecified: $vm("workspace-unspecified", 60355),
      newLine: $vm("newline", 60394),
      thumbsDownFilled: $vm("thumbsdown-filled", 60435),
      thumbsUpFilled: $vm("thumbsup-filled", 60436),
      gitFetch: $vm("git-fetch", 60445),
      lightbulbSparkleAutofix: $vm("lightbulb-sparkle-autofix", 60447),
      debugBreakpointPending: $vm("debug-breakpoint-pending", 60377)
    };
    $Am = {
      ...$xm,
      ...$zm
    };
  }
});

// out-build/vs/base/common/themables.js
var ThemeColor, ThemeIcon;
var init_themables = __esm({
  "out-build/vs/base/common/themables.js"() {
    "use strict";
    init_codicons();
    (function(ThemeColor2) {
      function isThemeColor(obj) {
        return obj && typeof obj === "object" && typeof obj.id === "string";
      }
      ThemeColor2.isThemeColor = isThemeColor;
    })(ThemeColor || (ThemeColor = {}));
    (function(ThemeIcon2) {
      ThemeIcon2.iconNameSegment = "[A-Za-z0-9]+";
      ThemeIcon2.iconNameExpression = "[A-Za-z0-9-]+";
      ThemeIcon2.iconModifierExpression = "~[A-Za-z]+";
      ThemeIcon2.iconNameCharacter = "[A-Za-z0-9~-]";
      const ThemeIconIdRegex = new RegExp(`^(${ThemeIcon2.iconNameExpression})(${ThemeIcon2.iconModifierExpression})?$`);
      function asClassNameArray(icon) {
        const match = ThemeIconIdRegex.exec(icon.id);
        if (!match) {
          return asClassNameArray($Am.error);
        }
        const [, id2, modifier] = match;
        const classNames = ["codicon", "codicon-" + id2];
        if (modifier) {
          classNames.push("codicon-modifier-" + modifier.substring(1));
        }
        return classNames;
      }
      ThemeIcon2.asClassNameArray = asClassNameArray;
      function asClassName(icon) {
        return asClassNameArray(icon).join(" ");
      }
      ThemeIcon2.asClassName = asClassName;
      function asCSSSelector(icon) {
        return "." + asClassNameArray(icon).join(".");
      }
      ThemeIcon2.asCSSSelector = asCSSSelector;
      function isThemeIcon(obj) {
        return obj && typeof obj === "object" && typeof obj.id === "string" && (typeof obj.color === "undefined" || ThemeColor.isThemeColor(obj.color));
      }
      ThemeIcon2.isThemeIcon = isThemeIcon;
      const _regexFromString = new RegExp(`^\\$\\((${ThemeIcon2.iconNameExpression}(?:${ThemeIcon2.iconModifierExpression})?)\\)$`);
      function fromString(str) {
        const match = _regexFromString.exec(str);
        if (!match) {
          return void 0;
        }
        const [, name] = match;
        return { id: name };
      }
      ThemeIcon2.fromString = fromString;
      function fromId(id2) {
        return { id: id2 };
      }
      ThemeIcon2.fromId = fromId;
      function modify(icon, modifier) {
        let id2 = icon.id;
        const tildeIndex = id2.lastIndexOf("~");
        if (tildeIndex !== -1) {
          id2 = id2.substring(0, tildeIndex);
        }
        if (modifier) {
          id2 = `${id2}~${modifier}`;
        }
        return { id: id2 };
      }
      ThemeIcon2.modify = modify;
      function getModifier(icon) {
        const tildeIndex = icon.id.lastIndexOf("~");
        if (tildeIndex !== -1) {
          return icon.id.substring(tildeIndex + 1);
        }
        return void 0;
      }
      ThemeIcon2.getModifier = getModifier;
      function isEqual(ti1, ti2) {
        return ti1.id === ti2.id && ti1.color?.id === ti2.color?.id;
      }
      ThemeIcon2.isEqual = isEqual;
    })(ThemeIcon || (ThemeIcon = {}));
  }
});

// out-build/vs/base/common/iconLabels.js
function $Cm(text) {
  return text.replace(escapeIconsRegex, (match, escaped) => escaped ? match : `\\${match}`);
}
var iconsRegex, escapeIconsRegex, markdownEscapedIconsRegex, stripIconsRegex, _parseIconsRegex;
var init_iconLabels = __esm({
  "out-build/vs/base/common/iconLabels.js"() {
    "use strict";
    init_filters();
    init_strings();
    init_themables();
    iconsRegex = new RegExp(`\\$\\(${ThemeIcon.iconNameExpression}(?:${ThemeIcon.iconModifierExpression})?\\)`, "g");
    escapeIconsRegex = new RegExp(`(\\\\)?${iconsRegex.source}`, "g");
    markdownEscapedIconsRegex = new RegExp(`\\\\${iconsRegex.source}`, "g");
    stripIconsRegex = new RegExp(`(\\s)?(\\\\)?${iconsRegex.source}(\\s)?`, "g");
    _parseIconsRegex = new RegExp(`\\$\\(${ThemeIcon.iconNameCharacter}+\\)`, "g");
  }
});

// out-build/vs/base/common/htmlContent.js
function $Km(thing) {
  if (thing instanceof $Im) {
    return true;
  } else if (thing && typeof thing === "object") {
    return typeof thing.value === "string" && (typeof thing.isTrusted === "boolean" || typeof thing.isTrusted === "object" || thing.isTrusted === void 0) && (typeof thing.supportThemeIcons === "boolean" || thing.supportThemeIcons === void 0);
  }
  return false;
}
function $Mm(text) {
  return text.replace(/[\\`*_{}[\]()#+\-!~]/g, "\\$&");
}
function $Nm(code, langId) {
  const longestFenceLength = code.match(/^`+/gm)?.reduce((a, b) => a.length > b.length ? a : b).length ?? 0;
  const desiredFenceLength = longestFenceLength >= 3 ? longestFenceLength + 1 : 3;
  return [
    `${"`".repeat(desiredFenceLength)}${langId}`,
    code,
    `${"`".repeat(desiredFenceLength)}`
  ].join("\n");
}
function $Qm(href) {
  const dimensions = [];
  const splitted = href.split("|").map((s) => s.trim());
  href = splitted[0];
  const parameters = splitted[1];
  if (parameters) {
    const heightFromParams = /height=(\d+)/.exec(parameters);
    const widthFromParams = /width=(\d+)/.exec(parameters);
    const height = heightFromParams ? heightFromParams[1] : "";
    const width = widthFromParams ? widthFromParams[1] : "";
    const widthIsFinite = isFinite(parseInt(width));
    const heightIsFinite = isFinite(parseInt(height));
    if (widthIsFinite) {
      dimensions.push(`width="${width}"`);
    }
    if (heightIsFinite) {
      dimensions.push(`height="${height}"`);
    }
  }
  return { href, dimensions };
}
var MarkdownStringTextNewlineStyle, $Im;
var init_htmlContent = __esm({
  "out-build/vs/base/common/htmlContent.js"() {
    "use strict";
    init_errors();
    init_iconLabels();
    init_network();
    init_resources();
    init_strings();
    init_uri();
    (function(MarkdownStringTextNewlineStyle2) {
      MarkdownStringTextNewlineStyle2[MarkdownStringTextNewlineStyle2["Paragraph"] = 0] = "Paragraph";
      MarkdownStringTextNewlineStyle2[MarkdownStringTextNewlineStyle2["Break"] = 1] = "Break";
    })(MarkdownStringTextNewlineStyle || (MarkdownStringTextNewlineStyle = {}));
    $Im = class _$Im {
      static lift(dto) {
        const markdownString = new _$Im(dto.value, dto);
        markdownString.uris = dto.uris;
        markdownString.baseUri = dto.baseUri ? URI.revive(dto.baseUri) : void 0;
        return markdownString;
      }
      constructor(value = "", isTrustedOrOptions = false) {
        this.value = value;
        if (typeof this.value !== "string") {
          throw $nb("value");
        }
        if (typeof isTrustedOrOptions === "boolean") {
          this.isTrusted = isTrustedOrOptions;
          this.supportThemeIcons = false;
          this.supportHtml = false;
        } else {
          this.isTrusted = isTrustedOrOptions.isTrusted ?? void 0;
          this.supportThemeIcons = isTrustedOrOptions.supportThemeIcons ?? false;
          this.supportHtml = isTrustedOrOptions.supportHtml ?? false;
        }
      }
      appendText(value, newlineStyle = 0) {
        this.value += $Mm(this.supportThemeIcons ? $Cm(value) : value).replace(/([ \t]+)/g, (_match, g1) => "&nbsp;".repeat(g1.length)).replace(/\>/gm, "\\>").replace(/\n/g, newlineStyle === 1 ? "\\\n" : "\n\n");
        return this;
      }
      appendMarkdown(value) {
        this.value += value;
        return this;
      }
      appendCodeblock(langId, code) {
        this.value += `
${$Nm(code, langId)}
`;
        return this;
      }
      appendLink(target, label, title) {
        this.value += "[";
        this.value += this.c(label, "]");
        this.value += "](";
        this.value += this.c(String(target), ")");
        if (title) {
          this.value += ` "${this.c(this.c(title, '"'), ")")}"`;
        }
        this.value += ")";
        return this;
      }
      c(value, ch) {
        const r = new RegExp($$f(ch), "g");
        return value.replace(r, (match, offset) => {
          if (value.charAt(offset - 1) !== "\\") {
            return `\\${match}`;
          } else {
            return match;
          }
        });
      }
    };
  }
});

// out-build/vs/platform/extensionManagement/common/abstractExtensionManagementService.js
function $l1(error, code) {
  if (error instanceof $bB) {
    return error;
  }
  let extensionManagementError;
  if (error instanceof $aB) {
    extensionManagementError = new $bB(
      error.message,
      error.code === "DownloadFailedWriting" ? "DownloadFailedWriting" : "Gallery"
      /* ExtensionManagementErrorCode.Gallery */
    );
  } else {
    extensionManagementError = new $bB(error.message, $kb(error) ? "Cancelled" : code ?? "Internal");
  }
  extensionManagementError.stack = error.stack;
  return extensionManagementError;
}
function reportTelemetry(telemetryService, eventName, { extensionData, verificationStatus, duration, error, source, durationSinceUpdate }) {
  telemetryService.publicLog(eventName, {
    ...extensionData,
    source,
    duration,
    durationSinceUpdate,
    success: !error,
    errorcode: error?.code,
    verificationStatus: verificationStatus === ExtensionSignatureVerificationCode.Success ? "Verified" : verificationStatus ?? "Unverified"
  });
}
var $j1, $k1, $m1;
var init_abstractExtensionManagementService = __esm({
  "out-build/vs/platform/extensionManagement/common/abstractExtensionManagementService.js"() {
    "use strict";
    init_arrays();
    init_async();
    init_cancellation();
    init_errors();
    init_event();
    init_lifecycle();
    init_map();
    init_platform();
    init_uri();
    init_nls2();
    init_extensionManagement();
    init_extensionManagementUtil();
    init_extensions();
    init_extensionValidator();
    init_log();
    init_productService();
    init_telemetry();
    init_uriIdentity();
    init_userDataProfile();
    init_htmlContent();
    $j1 = class $j12 extends $sd {
      constructor(g, h) {
        super();
        this.g = g;
        this.h = h;
      }
      async canInstall(extension) {
        const allowedToInstall = this.h.isAllowed({ id: extension.identifier.id, publisherDisplayName: extension.publisherDisplayName });
        if (allowedToInstall !== true) {
          return new $Im(localize(1899, null, allowedToInstall.value));
        }
        if (!await this.j(extension)) {
          const learnLink = $r ? "https://aka.ms/vscode-web-extensions-guide" : "https://aka.ms/vscode-platform-specific-extensions";
          return new $Im(`${localize(1900, null, extension.displayName ?? extension.identifier.id, this.g.nameLong, $6A(await this.getTargetPlatform()))} [${localize(1901, null)}](${learnLink})`);
        }
        return true;
      }
      async j(extension) {
        const currentTargetPlatform = await this.getTargetPlatform();
        return extension.allTargetPlatforms.some((targetPlatform) => $0A(targetPlatform, extension.allTargetPlatforms, currentTargetPlatform));
      }
    };
    $j1 = __decorate([
      __param(0, $Dv),
      __param(1, $hB)
    ], $j1);
    $k1 = class $k12 extends $j1 {
      get onInstallExtension() {
        return this.u.event;
      }
      get onDidInstallExtensions() {
        return this.w.event;
      }
      get onUninstallExtension() {
        return this.y.event;
      }
      get onDidUninstallExtension() {
        return this.z.event;
      }
      get onDidUpdateExtensionMetadata() {
        return this.C.event;
      }
      constructor(F, G, H, I, productService, allowedExtensionsService, J) {
        super(productService, allowedExtensionsService);
        this.F = F;
        this.G = G;
        this.H = H;
        this.I = I;
        this.J = J;
        this.n = 0;
        this.s = /* @__PURE__ */ new Map();
        this.t = /* @__PURE__ */ new Map();
        this.u = this.B(new $0e());
        this.w = this.B(new $0e());
        this.y = this.B(new $0e());
        this.z = this.B(new $0e());
        this.C = this.B(new $0e());
        this.D = [];
        this.B($qd(() => {
          this.s.forEach(({ task }) => task.cancel());
          this.t.forEach((promise) => promise.cancel());
          this.s.clear();
          this.t.clear();
        }));
      }
      async installFromGallery(extension, options2 = {}) {
        try {
          const results = await this.installGalleryExtensions([{ extension, options: options2 }]);
          const result = results.find(({ identifier }) => $nB(identifier, extension.identifier));
          if (result?.local) {
            return result?.local;
          }
          if (result?.error) {
            throw result.error;
          }
          throw new $bB(
            `Unknown error while installing extension ${extension.identifier.id}`,
            "Unknown"
            /* ExtensionManagementErrorCode.Unknown */
          );
        } catch (error) {
          throw $l1(error);
        }
      }
      async installGalleryExtensions(extensions) {
        if (!this.F.isEnabled()) {
          throw new $bB(
            localize(1902, null),
            "NotAllowed"
            /* ExtensionManagementErrorCode.NotAllowed */
          );
        }
        const results = [];
        const installableExtensions = [];
        await Promise.allSettled(extensions.map(async ({ extension, options: options2 }) => {
          try {
            const compatible = await this.Q(extension, !!options2?.installGivenVersion, !!options2?.installPreReleaseVersion, options2.productVersion ?? { version: this.g.version, date: this.g.date });
            installableExtensions.push({ ...compatible, options: options2 });
          } catch (error) {
            results.push({ identifier: extension.identifier, operation: 2, source: extension, error, profileLocation: options2.profileLocation ?? this.Z() });
          }
        }));
        if (installableExtensions.length) {
          results.push(...await this.L(installableExtensions));
        }
        return results;
      }
      async uninstall(extension, options2) {
        this.I.trace("ExtensionManagementService#uninstall", extension.identifier.id);
        return this.uninstallExtensions([{ extension, options: options2 }]);
      }
      async toggleAppliationScope(extension, fromProfileLocation) {
        if ($QA(extension.manifest) || extension.isBuiltin) {
          return extension;
        }
        if (extension.isApplicationScoped) {
          let local = await this.updateMetadata(extension, { isApplicationScoped: false }, this.J.defaultProfile.extensionsResource);
          if (!this.H.extUri.isEqual(fromProfileLocation, this.J.defaultProfile.extensionsResource)) {
            local = await this.bb(extension, this.J.defaultProfile.extensionsResource, fromProfileLocation);
          }
          for (const profile of this.J.profiles) {
            const existing = (await this.getInstalled(1, profile.extensionsResource)).find((e) => $nB(e.identifier, extension.identifier));
            if (existing) {
              this.C.fire({ local: existing, profileLocation: profile.extensionsResource });
            } else {
              this.z.fire({ identifier: extension.identifier, profileLocation: profile.extensionsResource });
            }
          }
          return local;
        } else {
          const local = this.H.extUri.isEqual(fromProfileLocation, this.J.defaultProfile.extensionsResource) ? await this.updateMetadata(extension, { isApplicationScoped: true }, this.J.defaultProfile.extensionsResource) : await this.bb(extension, fromProfileLocation, this.J.defaultProfile.extensionsResource, { isApplicationScoped: true });
          this.w.fire([{ identifier: local.identifier, operation: 2, local, profileLocation: this.J.defaultProfile.extensionsResource, applicationScoped: true }]);
          return local;
        }
      }
      getExtensionsControlManifest() {
        const now2 = (/* @__PURE__ */ new Date()).getTime();
        if (!this.m || now2 - this.n > 1e3 * 60 * 5) {
          this.m = this.Y();
          this.n = now2;
        }
        return this.m;
      }
      registerParticipant(participant) {
        this.D.push(participant);
      }
      async resetPinnedStateForAllUserExtensions(pinned) {
        try {
          await this.O(this.J.profiles.map(async (profile) => {
            const extensions = await this.getInstalled(1, profile.extensionsResource);
            await this.O(extensions.map(async (extension) => {
              if (extension.pinned !== pinned) {
                await this.updateMetadata(extension, { pinned }, profile.extensionsResource);
              }
            }));
          }));
        } catch (error) {
          this.I.error("Error while resetting pinned state for all user extensions", $qb(error));
          throw error;
        }
      }
      async L(extensions) {
        const installExtensionResultsMap = /* @__PURE__ */ new Map();
        const installingExtensionsMap = /* @__PURE__ */ new Map();
        const alreadyRequestedInstallations = [];
        const getInstallExtensionTaskKey = (extension, profileLocation) => `${$oB.create(extension).toString()}-${profileLocation.toString()}`;
        const createInstallExtensionTask = (manifest, extension, options2, root) => {
          if (!URI.isUri(extension)) {
            if (installingExtensionsMap.has(`${extension.identifier.id.toLowerCase()}-${options2.profileLocation.toString()}`)) {
              return;
            }
            const existingInstallingExtension = this.s.get(getInstallExtensionTaskKey(extension, options2.profileLocation));
            if (existingInstallingExtension) {
              if (root && this.N(root, existingInstallingExtension.task)) {
                const identifier = existingInstallingExtension.task.identifier;
                this.I.info("Waiting for already requested installing extension", identifier.id, root.identifier.id, options2.profileLocation.toString());
                existingInstallingExtension.waitingTasks.push(root);
                alreadyRequestedInstallations.push(Event.toPromise(Event.filter(this.onDidInstallExtensions, (results2) => results2.some((result) => $nB(result.identifier, identifier)))).then((results2) => {
                  this.I.info("Finished waiting for already requested installing extension", identifier.id, root.identifier.id, options2.profileLocation.toString());
                  const result = results2.find((result2) => $nB(result2.identifier, identifier));
                  if (!result?.local) {
                    throw new Error(`Extension ${identifier.id} is not installed`);
                  }
                }));
              }
              return;
            }
          }
          const installExtensionTask = this.$(manifest, extension, options2);
          const key = `${$sB(manifest.publisher, manifest.name)}-${options2.profileLocation.toString()}`;
          installingExtensionsMap.set(key, { task: installExtensionTask, root });
          this.u.fire({ identifier: installExtensionTask.identifier, source: extension, profileLocation: options2.profileLocation });
          this.I.info("Installing extension:", installExtensionTask.identifier.id, options2);
          if (!URI.isUri(extension)) {
            this.s.set(getInstallExtensionTaskKey(extension, options2.profileLocation), { task: installExtensionTask, waitingTasks: [] });
          }
        };
        try {
          for (const { manifest, extension, options: options2 } of extensions) {
            const isApplicationScoped = options2.isApplicationScoped || options2.isBuiltin || $QA(manifest);
            const installExtensionTaskOptions = {
              ...options2,
              isApplicationScoped,
              profileLocation: isApplicationScoped ? this.J.defaultProfile.extensionsResource : options2.profileLocation ?? this.Z(),
              productVersion: options2.productVersion ?? { version: this.g.version, date: this.g.date }
            };
            const existingInstallExtensionTask = !URI.isUri(extension) ? this.s.get(getInstallExtensionTaskKey(extension, installExtensionTaskOptions.profileLocation)) : void 0;
            if (existingInstallExtensionTask) {
              this.I.info("Extension is already requested to install", existingInstallExtensionTask.task.identifier.id, installExtensionTaskOptions.profileLocation.toString());
              alreadyRequestedInstallations.push(existingInstallExtensionTask.task.waitUntilTaskIsFinished());
            } else {
              createInstallExtensionTask(manifest, extension, installExtensionTaskOptions, void 0);
            }
          }
          await Promise.all([...installingExtensionsMap.values()].map(async ({ task }) => {
            if (task.options.donotIncludePackAndDependencies) {
              this.I.info("Installing the extension without checking dependencies and pack", task.identifier.id);
            } else {
              try {
                const allDepsAndPackExtensionsToInstall = await this.P(task.identifier, task.manifest, !!task.options.installPreReleaseVersion, task.options.productVersion);
                const installed = await this.getInstalled(void 0, task.options.profileLocation, task.options.productVersion);
                const options2 = { ...task.options, context: { ...task.options.context, [$4A]: true } };
                for (const { gallery, manifest } of $Qb(allDepsAndPackExtensionsToInstall, ({ gallery: gallery2 }) => gallery2.identifier.id)) {
                  const existing = installed.find((e) => $nB(e.identifier, gallery.identifier));
                  if (existing && existing.isApplicationScoped === !!options2.isApplicationScoped) {
                    continue;
                  }
                  createInstallExtensionTask(manifest, gallery, options2, task);
                }
              } catch (error) {
                if (URI.isUri(task.source)) {
                  if ($Pb(task.manifest.extensionDependencies)) {
                    this.I.warn(`Cannot install dependencies of extension:`, task.identifier.id, error.message);
                  }
                  if ($Pb(task.manifest.extensionPack)) {
                    this.I.warn(`Cannot install packed extensions of extension:`, task.identifier.id, error.message);
                  }
                } else {
                  this.I.error("Error while preparing to install dependencies and extension packs of the extension:", task.identifier.id);
                  throw error;
                }
              }
            }
          }));
          const otherProfilesToUpdate = await this.M([...installingExtensionsMap.values()].map(({ task }) => task));
          for (const [profileLocation, task] of otherProfilesToUpdate) {
            createInstallExtensionTask(task.manifest, task.source, { ...task.options, profileLocation }, void 0);
          }
          await this.O([...installingExtensionsMap.entries()].map(async ([key, { task }]) => {
            const startTime = (/* @__PURE__ */ new Date()).getTime();
            let local;
            try {
              local = await task.run();
              await this.O(
                this.D.map((participant) => participant.postInstall(local, task.source, task.options, CancellationToken.None)),
                "PostInstall"
                /* ExtensionManagementErrorCode.PostInstall */
              );
            } catch (e) {
              const error = $l1(e);
              if (!URI.isUri(task.source)) {
                reportTelemetry(this.G, task.operation === 3 ? "extensionGallery:update" : "extensionGallery:install", {
                  extensionData: $vB(task.source),
                  error,
                  source: task.options.context?.[$3A]
                });
              }
              installExtensionResultsMap.set(key, { error, identifier: task.identifier, operation: task.operation, source: task.source, context: task.options.context, profileLocation: task.options.profileLocation, applicationScoped: task.options.isApplicationScoped });
              this.I.error("Error while installing the extension", task.identifier.id, $qb(error), task.options.profileLocation.toString());
              throw error;
            }
            if (!URI.isUri(task.source)) {
              const isUpdate = task.operation === 3;
              const durationSinceUpdate = isUpdate ? void 0 : ((/* @__PURE__ */ new Date()).getTime() - task.source.lastUpdated) / 1e3;
              reportTelemetry(this.G, isUpdate ? "extensionGallery:update" : "extensionGallery:install", {
                extensionData: $vB(task.source),
                verificationStatus: task.verificationStatus,
                duration: (/* @__PURE__ */ new Date()).getTime() - startTime,
                durationSinceUpdate,
                source: task.options.context?.[$3A]
              });
              if ($r && task.operation !== 3) {
                try {
                  await this.F.reportStatistic(
                    local.manifest.publisher,
                    local.manifest.name,
                    local.manifest.version,
                    "install"
                    /* StatisticType.Install */
                  );
                } catch (error) {
                }
              }
            }
            installExtensionResultsMap.set(key, { local, identifier: task.identifier, operation: task.operation, source: task.source, context: task.options.context, profileLocation: task.options.profileLocation, applicationScoped: local.isApplicationScoped });
          }));
          if (alreadyRequestedInstallations.length) {
            await this.O(alreadyRequestedInstallations);
          }
        } catch (error) {
          const getAllDepsAndPacks = (extension, profileLocation, allDepsOrPacks) => {
            const depsOrPacks = [];
            if (extension.manifest.extensionDependencies?.length) {
              depsOrPacks.push(...extension.manifest.extensionDependencies);
            }
            if (extension.manifest.extensionPack?.length) {
              depsOrPacks.push(...extension.manifest.extensionPack);
            }
            for (const id2 of depsOrPacks) {
              if (allDepsOrPacks.includes(id2.toLowerCase())) {
                continue;
              }
              allDepsOrPacks.push(id2.toLowerCase());
              const installed = installExtensionResultsMap.get(`${id2.toLowerCase()}-${profileLocation.toString()}`);
              if (installed?.local) {
                allDepsOrPacks = getAllDepsAndPacks(installed.local, profileLocation, allDepsOrPacks);
              }
            }
            return allDepsOrPacks;
          };
          const getErrorResult = (task) => ({ identifier: task.identifier, operation: 2, source: task.source, context: task.options.context, profileLocation: task.options.profileLocation, error });
          const rollbackTasks = [];
          for (const [key, { task, root }] of installingExtensionsMap) {
            const result = installExtensionResultsMap.get(key);
            if (!result) {
              task.cancel();
              installExtensionResultsMap.set(key, getErrorResult(task));
            } else if (result.local && root && !installExtensionResultsMap.get(`${root.identifier.id.toLowerCase()}-${task.options.profileLocation.toString()}`)?.local) {
              rollbackTasks.push(this.ab(result.local, { versionOnly: true, profileLocation: task.options.profileLocation }));
              installExtensionResultsMap.set(key, getErrorResult(task));
            }
          }
          for (const [key, { task }] of installingExtensionsMap) {
            const result = installExtensionResultsMap.get(key);
            if (!result?.local) {
              continue;
            }
            if (task.options.donotIncludePackAndDependencies) {
              continue;
            }
            const depsOrPacks = getAllDepsAndPacks(result.local, task.options.profileLocation, [result.local.identifier.id.toLowerCase()]).slice(1);
            if (depsOrPacks.some((depOrPack) => installingExtensionsMap.has(`${depOrPack.toLowerCase()}-${task.options.profileLocation.toString()}`) && !installExtensionResultsMap.get(`${depOrPack.toLowerCase()}-${task.options.profileLocation.toString()}`)?.local)) {
              rollbackTasks.push(this.ab(result.local, { versionOnly: true, profileLocation: task.options.profileLocation }));
              installExtensionResultsMap.set(key, getErrorResult(task));
            }
          }
          if (rollbackTasks.length) {
            await Promise.allSettled(rollbackTasks.map(async (rollbackTask) => {
              try {
                await rollbackTask.run();
                this.I.info("Rollback: Uninstalled extension", rollbackTask.extension.identifier.id);
              } catch (error2) {
                this.I.warn("Rollback: Error while uninstalling extension", rollbackTask.extension.identifier.id, $qb(error2));
              }
            }));
          }
        } finally {
          for (const { task } of installingExtensionsMap.values()) {
            if (task.source && !URI.isUri(task.source)) {
              this.s.delete(getInstallExtensionTaskKey(task.source, task.options.profileLocation));
            }
          }
        }
        const results = [...installExtensionResultsMap.values()];
        for (const result of results) {
          if (result.local) {
            this.I.info(`Extension installed successfully:`, result.identifier.id, result.profileLocation.toString());
          }
        }
        this.w.fire(results);
        return results;
      }
      async M(tasks) {
        const otherProfilesToUpdate = [];
        const profileExtensionsCache = new $Fc();
        for (const task of tasks) {
          if (task.operation !== 3 || task.options.isApplicationScoped || task.options.pinned || task.options.installGivenVersion || URI.isUri(task.source)) {
            continue;
          }
          for (const profile of this.J.profiles) {
            if (this.H.extUri.isEqual(profile.extensionsResource, task.options.profileLocation)) {
              continue;
            }
            let installedExtensions = profileExtensionsCache.get(profile.extensionsResource);
            if (!installedExtensions) {
              installedExtensions = await this.getInstalled(1, profile.extensionsResource);
              profileExtensionsCache.set(profile.extensionsResource, installedExtensions);
            }
            const installedExtension = installedExtensions.find((e) => $nB(e.identifier, task.identifier));
            if (installedExtension && !installedExtension.pinned) {
              otherProfilesToUpdate.push([profile.extensionsResource, task]);
            }
          }
        }
        return otherProfilesToUpdate;
      }
      N(taskToWait, taskToWaitFor) {
        for (const [, { task, waitingTasks }] of this.s.entries()) {
          if (task === taskToWait) {
            if (waitingTasks.includes(taskToWaitFor)) {
              return false;
            }
            if (waitingTasks.some((waitingTask) => this.N(waitingTask, taskToWaitFor))) {
              return false;
            }
          }
          if (task === taskToWaitFor && waitingTasks[0] && !this.N(taskToWait, waitingTasks[0])) {
            return false;
          }
        }
        return true;
      }
      async O(promises15, errorCode) {
        const results = [];
        const errors = [];
        const promiseResults = await Promise.allSettled(promises15);
        for (const r of promiseResults) {
          if (r.status === "fulfilled") {
            results.push(r.value);
          } else {
            errors.push($l1(r.reason, errorCode));
          }
        }
        if (!errors.length) {
          return results;
        }
        if (errors.length === 1) {
          throw errors[0];
        }
        let error = new $bB(
          "",
          "Unknown"
          /* ExtensionManagementErrorCode.Unknown */
        );
        for (const current of errors) {
          error = new $bB(error.message ? `${error.message}, ${current.message}` : current.message, current.code !== "Unknown" && current.code !== "Internal" ? current.code : error.code);
        }
        throw error;
      }
      async P(extensionIdentifier, manifest, installPreRelease, productVersion) {
        if (!this.F.isEnabled()) {
          return [];
        }
        const knownIdentifiers = [];
        const allDependenciesAndPacks = [];
        const collectDependenciesAndPackExtensionsToInstall = async (extensionIdentifier2, manifest2) => {
          knownIdentifiers.push(extensionIdentifier2);
          const dependecies = manifest2.extensionDependencies || [];
          const dependenciesAndPackExtensions = [...dependecies];
          if (manifest2.extensionPack) {
            for (const extension of manifest2.extensionPack) {
              if (dependenciesAndPackExtensions.every((e) => !$nB({ id: e }, { id: extension }))) {
                dependenciesAndPackExtensions.push(extension);
              }
            }
          }
          if (dependenciesAndPackExtensions.length) {
            const ids = dependenciesAndPackExtensions.filter((id2) => knownIdentifiers.every((galleryIdentifier) => !$nB(galleryIdentifier, { id: id2 })));
            if (ids.length) {
              const galleryExtensions = await this.F.getExtensions(ids.map((id2) => ({ id: id2, preRelease: installPreRelease })), CancellationToken.None);
              for (const galleryExtension of galleryExtensions) {
                if (knownIdentifiers.find((identifier) => $nB(identifier, galleryExtension.identifier))) {
                  continue;
                }
                const isDependency = dependecies.some((id2) => $nB({ id: id2 }, galleryExtension.identifier));
                let compatible;
                try {
                  compatible = await this.Q(galleryExtension, false, installPreRelease, productVersion);
                } catch (error) {
                  if (!isDependency) {
                    this.I.info("Skipping the packed extension as it cannot be installed", galleryExtension.identifier.id, $qb(error));
                    continue;
                  } else {
                    throw error;
                  }
                }
                allDependenciesAndPacks.push({ gallery: compatible.extension, manifest: compatible.manifest });
                await collectDependenciesAndPackExtensionsToInstall(compatible.extension.identifier, compatible.manifest);
              }
            }
          }
        };
        await collectDependenciesAndPackExtensionsToInstall(extensionIdentifier, manifest);
        return allDependenciesAndPacks;
      }
      async Q(extension, sameVersion, installPreRelease, productVersion) {
        let compatibleExtension;
        const extensionsControlManifest = await this.getExtensionsControlManifest();
        if ($zB(extension.identifier, extensionsControlManifest.malicious)) {
          throw new $bB(
            localize(1903, null, extension.identifier.id),
            "Malicious"
            /* ExtensionManagementErrorCode.Malicious */
          );
        }
        const deprecationInfo = extensionsControlManifest.deprecated[extension.identifier.id.toLowerCase()];
        if (deprecationInfo?.extension?.autoMigrate) {
          this.I.info(`The '${extension.identifier.id}' extension is deprecated, fetching the compatible '${deprecationInfo.extension.id}' extension instead.`);
          compatibleExtension = (await this.F.getExtensions([{ id: deprecationInfo.extension.id, preRelease: deprecationInfo.extension.preRelease }], { targetPlatform: await this.getTargetPlatform(), compatible: true, productVersion }, CancellationToken.None))[0];
          if (!compatibleExtension) {
            throw new $bB(
              localize(1904, null, extension.identifier.id, deprecationInfo.extension.id),
              "Deprecated"
              /* ExtensionManagementErrorCode.Deprecated */
            );
          }
        } else {
          if (await this.canInstall(extension) !== true) {
            const targetPlatform = await this.getTargetPlatform();
            throw new $bB(
              localize(1905, null, extension.identifier.id, this.g.nameLong, $6A(targetPlatform)),
              "IncompatibleTargetPlatform"
              /* ExtensionManagementErrorCode.IncompatibleTargetPlatform */
            );
          }
          compatibleExtension = await this.R(extension, sameVersion, installPreRelease, productVersion);
          if (!compatibleExtension) {
            const incompatibleApiProposalsMessages = [];
            if (!$MB(extension.properties.enabledApiProposals ?? [], incompatibleApiProposalsMessages)) {
              throw new $bB(
                localize(1906, null, extension.displayName ?? extension.identifier.id, incompatibleApiProposalsMessages[0]),
                "IncompatibleApi"
                /* ExtensionManagementErrorCode.IncompatibleApi */
              );
            }
            if (!installPreRelease && extension.properties.isPreReleaseVersion && (await this.F.getExtensions([extension.identifier], CancellationToken.None))[0]) {
              throw new $bB(
                localize(1907, null, extension.displayName ?? extension.identifier.id),
                "ReleaseVersionNotFound"
                /* ExtensionManagementErrorCode.ReleaseVersionNotFound */
              );
            }
            throw new $bB(
              localize(1908, null, extension.identifier.id, this.g.nameLong, this.g.version),
              "Incompatible"
              /* ExtensionManagementErrorCode.Incompatible */
            );
          }
        }
        this.I.info("Getting Manifest...", compatibleExtension.identifier.id);
        const manifest = await this.F.getManifest(compatibleExtension, CancellationToken.None);
        if (manifest === null) {
          throw new $bB(
            `Missing manifest for extension ${compatibleExtension.identifier.id}`,
            "Invalid"
            /* ExtensionManagementErrorCode.Invalid */
          );
        }
        if (manifest.version !== compatibleExtension.version) {
          throw new $bB(
            `Cannot install '${compatibleExtension.identifier.id}' extension because of version mismatch in Marketplace`,
            "Invalid"
            /* ExtensionManagementErrorCode.Invalid */
          );
        }
        return { extension: compatibleExtension, manifest };
      }
      async R(extension, sameVersion, includePreRelease, productVersion) {
        const targetPlatform = await this.getTargetPlatform();
        let compatibleExtension = null;
        if (!sameVersion && extension.hasPreReleaseVersion && extension.properties.isPreReleaseVersion !== includePreRelease) {
          compatibleExtension = (await this.F.getExtensions([{ ...extension.identifier, preRelease: includePreRelease }], { targetPlatform, compatible: true, productVersion }, CancellationToken.None))[0] || null;
        }
        if (!compatibleExtension && await this.F.isExtensionCompatible(extension, includePreRelease, targetPlatform, productVersion)) {
          compatibleExtension = extension;
        }
        if (!compatibleExtension) {
          if (sameVersion) {
            compatibleExtension = (await this.F.getExtensions([{ ...extension.identifier, version: extension.version }], { targetPlatform, compatible: true, productVersion }, CancellationToken.None))[0] || null;
          } else {
            compatibleExtension = await this.F.getCompatibleExtension(extension, includePreRelease, targetPlatform, productVersion);
          }
        }
        return compatibleExtension;
      }
      async uninstallExtensions(extensions) {
        const getUninstallExtensionTaskKey = (extension, uninstallOptions) => `${extension.identifier.id.toLowerCase()}${uninstallOptions.versionOnly ? `-${extension.manifest.version}` : ""}@${uninstallOptions.profileLocation.toString()}`;
        const createUninstallExtensionTask = (extension, uninstallOptions) => {
          const uninstallExtensionTask = this.ab(extension, uninstallOptions);
          this.t.set(getUninstallExtensionTaskKey(uninstallExtensionTask.extension, uninstallOptions), uninstallExtensionTask);
          this.I.info("Uninstalling extension from the profile:", `${extension.identifier.id}@${extension.manifest.version}`, uninstallOptions.profileLocation.toString());
          this.y.fire({ identifier: extension.identifier, profileLocation: uninstallOptions.profileLocation, applicationScoped: extension.isApplicationScoped });
          return uninstallExtensionTask;
        };
        const postUninstallExtension = (extension, uninstallOptions, error) => {
          if (error) {
            this.I.error("Failed to uninstall extension from the profile:", `${extension.identifier.id}@${extension.manifest.version}`, uninstallOptions.profileLocation.toString(), error.message);
          } else {
            this.I.info("Successfully uninstalled extension from the profile", `${extension.identifier.id}@${extension.manifest.version}`, uninstallOptions.profileLocation.toString());
          }
          reportTelemetry(this.G, "extensionGallery:uninstall", { extensionData: $uB(extension), error });
          this.z.fire({ identifier: extension.identifier, error: error?.code, profileLocation: uninstallOptions.profileLocation, applicationScoped: extension.isApplicationScoped });
        };
        const allTasks = [];
        const processedTasks = [];
        const alreadyRequestedUninstalls = [];
        const installedExtensionsMap = new $Fc();
        for (const { extension, options: options2 } of extensions) {
          const uninstallOptions = {
            ...options2,
            profileLocation: extension.isApplicationScoped ? this.J.defaultProfile.extensionsResource : options2?.profileLocation ?? this.Z()
          };
          const uninstallExtensionTask = this.t.get(getUninstallExtensionTaskKey(extension, uninstallOptions));
          if (uninstallExtensionTask) {
            this.I.info("Extensions is already requested to uninstall", extension.identifier.id);
            alreadyRequestedUninstalls.push(uninstallExtensionTask.waitUntilTaskIsFinished());
          } else {
            allTasks.push(createUninstallExtensionTask(extension, uninstallOptions));
          }
        }
        try {
          for (const task of allTasks.slice(0)) {
            let installed = installedExtensionsMap.get(task.options.profileLocation);
            if (!installed) {
              installedExtensionsMap.set(task.options.profileLocation, installed = await this.getInstalled(1, task.options.profileLocation));
            }
            if (task.options.donotIncludePack) {
              this.I.info("Uninstalling the extension without including packed extension", `${task.extension.identifier.id}@${task.extension.manifest.version}`);
            } else {
              const packedExtensions = this.W(task.extension, installed);
              for (const packedExtension of packedExtensions) {
                if (this.t.has(getUninstallExtensionTaskKey(packedExtension, task.options))) {
                  this.I.info("Extensions is already requested to uninstall", packedExtension.identifier.id);
                } else {
                  allTasks.push(createUninstallExtensionTask(packedExtension, task.options));
                }
              }
            }
            if (task.options.donotCheckDependents) {
              this.I.info("Uninstalling the extension without checking dependents", `${task.extension.identifier.id}@${task.extension.manifest.version}`);
            } else {
              this.S(allTasks.map((task2) => task2.extension), installed, task.extension);
            }
          }
          await this.O(allTasks.map(async (task) => {
            try {
              await task.run();
              await this.O(this.D.map((participant) => participant.postUninstall(task.extension, task.options, CancellationToken.None)));
              if (task.extension.identifier.uuid) {
                try {
                  await this.F.reportStatistic(
                    task.extension.manifest.publisher,
                    task.extension.manifest.name,
                    task.extension.manifest.version,
                    "uninstall"
                    /* StatisticType.Uninstall */
                  );
                } catch (error) {
                }
              }
            } catch (e) {
              const error = $l1(e);
              postUninstallExtension(task.extension, task.options, error);
              throw error;
            } finally {
              processedTasks.push(task);
            }
          }));
          if (alreadyRequestedUninstalls.length) {
            await this.O(alreadyRequestedUninstalls);
          }
          for (const task of allTasks) {
            postUninstallExtension(task.extension, task.options);
          }
        } catch (e) {
          const error = $l1(e);
          for (const task of allTasks) {
            try {
              task.cancel();
            } catch (error2) {
            }
            if (!processedTasks.includes(task)) {
              postUninstallExtension(task.extension, task.options, error);
            }
          }
          throw error;
        } finally {
          for (const task of allTasks) {
            if (!this.t.delete(getUninstallExtensionTaskKey(task.extension, task.options))) {
              this.I.warn("Uninstallation task is not found in the cache", task.extension.identifier.id);
            }
          }
        }
      }
      S(extensionsToUninstall, installed, extensionToUninstall) {
        for (const extension of extensionsToUninstall) {
          const dependents = this.X(extension, installed);
          if (dependents.length) {
            const remainingDependents = dependents.filter((dependent) => !extensionsToUninstall.some((e) => $nB(e.identifier, dependent.identifier)));
            if (remainingDependents.length) {
              throw new Error(this.U(extension, remainingDependents, extensionToUninstall));
            }
          }
        }
      }
      U(dependingExtension, dependents, extensionToUninstall) {
        if (extensionToUninstall === dependingExtension) {
          if (dependents.length === 1) {
            return localize(1909, null, extensionToUninstall.manifest.displayName || extensionToUninstall.manifest.name, dependents[0].manifest.displayName || dependents[0].manifest.name);
          }
          if (dependents.length === 2) {
            return localize(1910, null, extensionToUninstall.manifest.displayName || extensionToUninstall.manifest.name, dependents[0].manifest.displayName || dependents[0].manifest.name, dependents[1].manifest.displayName || dependents[1].manifest.name);
          }
          return localize(1911, null, extensionToUninstall.manifest.displayName || extensionToUninstall.manifest.name, dependents[0].manifest.displayName || dependents[0].manifest.name, dependents[1].manifest.displayName || dependents[1].manifest.name);
        }
        if (dependents.length === 1) {
          return localize(1912, null, extensionToUninstall.manifest.displayName || extensionToUninstall.manifest.name, dependingExtension.manifest.displayName || dependingExtension.manifest.name, dependents[0].manifest.displayName || dependents[0].manifest.name);
        }
        if (dependents.length === 2) {
          return localize(1913, null, extensionToUninstall.manifest.displayName || extensionToUninstall.manifest.name, dependingExtension.manifest.displayName || dependingExtension.manifest.name, dependents[0].manifest.displayName || dependents[0].manifest.name, dependents[1].manifest.displayName || dependents[1].manifest.name);
        }
        return localize(1914, null, extensionToUninstall.manifest.displayName || extensionToUninstall.manifest.name, dependingExtension.manifest.displayName || dependingExtension.manifest.name, dependents[0].manifest.displayName || dependents[0].manifest.name, dependents[1].manifest.displayName || dependents[1].manifest.name);
      }
      W(extension, installed, checked = []) {
        if (checked.indexOf(extension) !== -1) {
          return [];
        }
        checked.push(extension);
        const extensionsPack = extension.manifest.extensionPack ? extension.manifest.extensionPack : [];
        if (extensionsPack.length) {
          const packedExtensions = installed.filter((i) => !i.isBuiltin && extensionsPack.some((id2) => $nB({ id: id2 }, i.identifier)));
          const packOfPackedExtensions = [];
          for (const packedExtension of packedExtensions) {
            packOfPackedExtensions.push(...this.W(packedExtension, installed, checked));
          }
          return [...packedExtensions, ...packOfPackedExtensions];
        }
        return [];
      }
      X(extension, installed) {
        return installed.filter((e) => e.manifest.extensionDependencies && e.manifest.extensionDependencies.some((id2) => $nB({ id: id2 }, extension.identifier)));
      }
      async Y() {
        try {
          this.I.trace("ExtensionManagementService.updateControlCache");
          return await this.F.getExtensionsControlManifest();
        } catch (err) {
          this.I.trace("ExtensionManagementService.refreshControlCache - failed to get extension control manifest", $qb(err));
          return { malicious: [], deprecated: {}, search: [] };
        }
      }
    };
    $k1 = __decorate([
      __param(0, $_A),
      __param(1, $iw),
      __param(2, $3l),
      __param(3, $5n),
      __param(4, $Dv),
      __param(5, $hB),
      __param(6, $8s)
    ], $k1);
    $m1 = class {
      constructor() {
        this.d = new $ci();
      }
      async waitUntilTaskIsFinished() {
        await this.d.wait();
        return this.g;
      }
      run() {
        if (!this.g) {
          this.g = $2h((token) => this.h(token));
        }
        this.d.open();
        return this.g;
      }
      cancel() {
        if (!this.g) {
          this.g = $2h((token) => {
            return new Promise((c, e) => {
              const disposable = token.onCancellationRequested(() => {
                disposable.dispose();
                e(new $lb());
              });
            });
          });
          this.d.open();
        }
        this.g.cancel();
      }
    };
  }
});

// out-build/vs/platform/extensionManagement/common/extensionsProfileScannerService.js
function isStoredProfileExtension(candidate) {
  return $Yc(candidate) && $$A(candidate.identifier) && (isUriComponents(candidate.location) || $Wc(candidate.location) && candidate.location) && ($4c(candidate.relativeLocation) || $Wc(candidate.relativeLocation)) && candidate.version && $Wc(candidate.version);
}
function isUriComponents(thing) {
  if (!thing) {
    return false;
  }
  return $Wc(thing.path) && $Wc(thing.scheme);
}
var ExtensionsProfileScanningErrorCode, $AB, $BB, $CB;
var init_extensionsProfileScannerService = __esm({
  "out-build/vs/platform/extensionManagement/common/extensionsProfileScannerService.js"() {
    "use strict";
    init_async();
    init_buffer();
    init_lifecycle();
    init_event();
    init_map();
    init_uri();
    init_extensionManagement();
    init_extensionManagementUtil();
    init_files();
    init_instantiation();
    init_log();
    init_userDataProfile();
    init_uriIdentity();
    init_types();
    init_errors();
    (function(ExtensionsProfileScanningErrorCode2) {
      ExtensionsProfileScanningErrorCode2["ERROR_PROFILE_NOT_FOUND"] = "ERROR_PROFILE_NOT_FOUND";
      ExtensionsProfileScanningErrorCode2["ERROR_INVALID_CONTENT"] = "ERROR_INVALID_CONTENT";
    })(ExtensionsProfileScanningErrorCode || (ExtensionsProfileScanningErrorCode = {}));
    $AB = class extends Error {
      constructor(message, code) {
        super(message);
        this.code = code;
      }
    };
    $BB = $kl("IExtensionsProfileScannerService");
    $CB = class $CB2 extends $sd {
      constructor(j, m, n, r, s) {
        super();
        this.j = j;
        this.m = m;
        this.n = n;
        this.r = r;
        this.s = s;
        this.b = this.B(new $0e());
        this.onAddExtensions = this.b.event;
        this.c = this.B(new $0e());
        this.onDidAddExtensions = this.c.event;
        this.f = this.B(new $0e());
        this.onRemoveExtensions = this.f.event;
        this.g = this.B(new $0e());
        this.onDidRemoveExtensions = this.g.event;
        this.h = new $Fc();
      }
      scanProfileExtensions(profileLocation, options2) {
        return this.t(profileLocation, void 0, options2);
      }
      async addExtensionsToProfile(extensions, profileLocation, keepExistingVersions) {
        const extensionsToRemove = [];
        const extensionsToAdd = [];
        try {
          await this.t(profileLocation, (existingExtensions) => {
            const result = [];
            if (keepExistingVersions) {
              result.push(...existingExtensions);
            } else {
              for (const existing of existingExtensions) {
                if (extensions.some(([e]) => $nB(e.identifier, existing.identifier) && e.manifest.version !== existing.version)) {
                  extensionsToRemove.push(existing);
                } else {
                  result.push(existing);
                }
              }
            }
            for (const [extension, metadata] of extensions) {
              const index = result.findIndex((e) => $nB(e.identifier, extension.identifier) && e.version === extension.manifest.version);
              const extensionToAdd = { identifier: extension.identifier, version: extension.manifest.version, location: extension.location, metadata };
              if (index === -1) {
                extensionsToAdd.push(extensionToAdd);
                result.push(extensionToAdd);
              } else {
                result.splice(index, 1, extensionToAdd);
              }
            }
            if (extensionsToAdd.length) {
              this.b.fire({ extensions: extensionsToAdd, profileLocation });
            }
            if (extensionsToRemove.length) {
              this.f.fire({ extensions: extensionsToRemove, profileLocation });
            }
            return result;
          });
          if (extensionsToAdd.length) {
            this.c.fire({ extensions: extensionsToAdd, profileLocation });
          }
          if (extensionsToRemove.length) {
            this.g.fire({ extensions: extensionsToRemove, profileLocation });
          }
          return extensionsToAdd;
        } catch (error) {
          if (extensionsToAdd.length) {
            this.c.fire({ extensions: extensionsToAdd, error, profileLocation });
          }
          if (extensionsToRemove.length) {
            this.g.fire({ extensions: extensionsToRemove, error, profileLocation });
          }
          throw error;
        }
      }
      async updateMetadata(extensions, profileLocation) {
        const updatedExtensions = [];
        await this.t(profileLocation, (profileExtensions) => {
          const result = [];
          for (const profileExtension of profileExtensions) {
            const extension = extensions.find(([e]) => $nB(e.identifier, profileExtension.identifier) && e.manifest.version === profileExtension.version);
            if (extension) {
              profileExtension.metadata = { ...profileExtension.metadata, ...extension[1] };
              updatedExtensions.push(profileExtension);
              result.push(profileExtension);
            } else {
              result.push(profileExtension);
            }
          }
          return result;
        });
        return updatedExtensions;
      }
      async removeExtensionsFromProfile(extensions, profileLocation) {
        const extensionsToRemove = [];
        try {
          await this.t(profileLocation, (profileExtensions) => {
            const result = [];
            for (const e of profileExtensions) {
              if (extensions.some((extension) => $nB(e.identifier, extension))) {
                extensionsToRemove.push(e);
              } else {
                result.push(e);
              }
            }
            if (extensionsToRemove.length) {
              this.f.fire({ extensions: extensionsToRemove, profileLocation });
            }
            return result;
          });
          if (extensionsToRemove.length) {
            this.g.fire({ extensions: extensionsToRemove, profileLocation });
          }
        } catch (error) {
          if (extensionsToRemove.length) {
            this.g.fire({ extensions: extensionsToRemove, error, profileLocation });
          }
          throw error;
        }
      }
      async t(file, updateFn, options2) {
        return this.D(file).queue(async () => {
          let extensions = [];
          let storedProfileExtensions;
          try {
            const content = await this.m.readFile(file);
            storedProfileExtensions = JSON.parse(content.value.toString().trim() || "[]");
          } catch (error) {
            if ($0m(error) !== 1) {
              throw error;
            }
            if (this.r.extUri.isEqual(file, this.n.defaultProfile.extensionsResource)) {
              storedProfileExtensions = await this.C();
            }
            if (!storedProfileExtensions && options2?.bailOutWhenFileNotFound) {
              throw new $AB(
                $qb(error),
                "ERROR_PROFILE_NOT_FOUND"
                /* ExtensionsProfileScanningErrorCode.ERROR_PROFILE_NOT_FOUND */
              );
            }
          }
          if (storedProfileExtensions) {
            if (!Array.isArray(storedProfileExtensions)) {
              this.u(file);
            }
            let migrate = false;
            for (const e of storedProfileExtensions) {
              if (!isStoredProfileExtension(e)) {
                this.u(file);
              }
              let location2;
              if ($Wc(e.relativeLocation) && e.relativeLocation) {
                location2 = this.y(e.relativeLocation);
              } else if ($Wc(e.location)) {
                this.s.warn(`Extensions profile: Ignoring extension with invalid location: ${e.location}`);
                continue;
              } else {
                location2 = URI.revive(e.location);
                const relativePath = this.w(location2);
                if (relativePath) {
                  migrate = true;
                  e.relativeLocation = relativePath;
                }
              }
              if ($4c(e.metadata?.hasPreReleaseVersion) && e.metadata?.preRelease) {
                migrate = true;
                e.metadata.hasPreReleaseVersion = true;
              }
              const uuid = e.metadata?.id ?? e.identifier.uuid;
              extensions.push({
                identifier: uuid ? { id: e.identifier.id, uuid } : { id: e.identifier.id },
                location: location2,
                version: e.version,
                metadata: e.metadata
              });
            }
            if (migrate) {
              await this.m.writeFile(file, $Wi.fromString(JSON.stringify(storedProfileExtensions)));
            }
          }
          if (updateFn) {
            extensions = updateFn(extensions);
            const storedProfileExtensions2 = extensions.map((e) => ({
              identifier: e.identifier,
              version: e.version,
              // retain old format so that old clients can read it
              location: e.location.toJSON(),
              relativeLocation: this.w(e.location),
              metadata: e.metadata
            }));
            await this.m.writeFile(file, $Wi.fromString(JSON.stringify(storedProfileExtensions2)));
          }
          return extensions;
        });
      }
      u(file) {
        throw new $AB(
          `Invalid extensions content in ${file.toString()}`,
          "ERROR_INVALID_CONTENT"
          /* ExtensionsProfileScanningErrorCode.ERROR_INVALID_CONTENT */
        );
      }
      w(extensionLocation) {
        return this.r.extUri.isEqual(this.r.extUri.dirname(extensionLocation), this.j) ? this.r.extUri.basename(extensionLocation) : void 0;
      }
      y(path7) {
        return this.r.extUri.joinPath(this.j, path7);
      }
      async C() {
        if (!this.z) {
          this.z = (async () => {
            const oldDefaultProfileExtensionsLocation = this.r.extUri.joinPath(this.n.defaultProfile.location, "extensions.json");
            const oldDefaultProfileExtensionsInitLocation = this.r.extUri.joinPath(this.j, ".init-default-profile-extensions");
            let content;
            try {
              content = (await this.m.readFile(oldDefaultProfileExtensionsLocation)).value.toString();
            } catch (error) {
              if ($0m(error) === 1) {
                return void 0;
              }
              throw error;
            }
            this.s.info("Migrating extensions from old default profile location", oldDefaultProfileExtensionsLocation.toString());
            let storedProfileExtensions;
            try {
              const parsedData = JSON.parse(content);
              if (Array.isArray(parsedData) && parsedData.every((candidate) => isStoredProfileExtension(candidate))) {
                storedProfileExtensions = parsedData;
              } else {
                this.s.warn("Skipping migrating from old default profile locaiton: Found invalid data", parsedData);
              }
            } catch (error) {
              this.s.error(error);
            }
            if (storedProfileExtensions) {
              try {
                await this.m.createFile(this.n.defaultProfile.extensionsResource, $Wi.fromString(JSON.stringify(storedProfileExtensions)), { overwrite: false });
                this.s.info("Migrated extensions from old default profile location to new location", oldDefaultProfileExtensionsLocation.toString(), this.n.defaultProfile.extensionsResource.toString());
              } catch (error) {
                if ($0m(error) === 3) {
                  this.s.info("Migration from old default profile location to new location is done by another window", oldDefaultProfileExtensionsLocation.toString(), this.n.defaultProfile.extensionsResource.toString());
                } else {
                  throw error;
                }
              }
            }
            try {
              await this.m.del(oldDefaultProfileExtensionsLocation);
            } catch (error) {
              if ($0m(error) !== 1) {
                this.s.error(error);
              }
            }
            try {
              await this.m.del(oldDefaultProfileExtensionsInitLocation);
            } catch (error) {
              if ($0m(error) !== 1) {
                this.s.error(error);
              }
            }
            return storedProfileExtensions;
          })();
        }
        return this.z;
      }
      D(file) {
        let resourceQueue = this.h.get(file);
        if (!resourceQueue) {
          resourceQueue = new $ki();
          this.h.set(file, resourceQueue);
        }
        return resourceQueue;
      }
    };
    $CB = __decorate([
      __param(1, $Sm),
      __param(2, $8s),
      __param(3, $3l),
      __param(4, $5n)
    ], $CB);
  }
});

// out-build/vs/base/common/jsonErrorMessages.js
function $DB(errorCode) {
  switch (errorCode) {
    case 1:
      return localize(116, null);
    case 2:
      return localize(117, null);
    case 3:
      return localize(118, null);
    case 4:
      return localize(119, null);
    case 5:
      return localize(120, null);
    case 6:
      return localize(121, null);
    case 7:
      return localize(122, null);
    case 8:
      return localize(123, null);
    case 9:
      return localize(124, null);
    default:
      return "";
  }
}
var init_jsonErrorMessages = __esm({
  "out-build/vs/base/common/jsonErrorMessages.js"() {
    "use strict";
    init_nls2();
  }
});

// out-build/vs/platform/extensionManagement/common/extensionNls.js
function $NB(logger, extensionManifest, translations, fallbackTranslations) {
  try {
    replaceNLStrings(logger, extensionManifest, translations, fallbackTranslations);
  } catch (error) {
    logger.error(error?.message ?? error);
  }
  return extensionManifest;
}
function replaceNLStrings(logger, extensionManifest, messages, originalMessages) {
  const processEntry = (obj, key, command) => {
    const value = obj[key];
    if ($Wc(value)) {
      const str = value;
      const length = str.length;
      if (length > 1 && str[0] === "%" && str[length - 1] === "%") {
        const messageKey = str.substr(1, length - 2);
        let translated = messages[messageKey];
        if (translated === void 0 && originalMessages) {
          translated = originalMessages[messageKey];
        }
        const message = typeof translated === "string" ? translated : translated?.message;
        const original = originalMessages?.[messageKey];
        const originalMessage = typeof original === "string" ? original : original?.message;
        if (!message) {
          if (!originalMessage) {
            logger.warn(`[${extensionManifest.name}]: ${localize(1954, null, messageKey)}`);
          }
          return;
        }
        if (
          // if we are translating the title or category of a command
          command && (key === "title" || key === "category") && // and the original value is not the same as the translated value
          originalMessage && originalMessage !== message
        ) {
          const localizedString = {
            value: message,
            original: originalMessage
          };
          obj[key] = localizedString;
        } else {
          obj[key] = message;
        }
      }
    } else if ($Yc(value)) {
      for (const k in value) {
        if (value.hasOwnProperty(k)) {
          k === "commands" ? processEntry(value, k, true) : processEntry(value, k, command);
        }
      }
    } else if (Array.isArray(value)) {
      for (let i = 0; i < value.length; i++) {
        processEntry(value, i, command);
      }
    }
  };
  for (const key in extensionManifest) {
    if (extensionManifest.hasOwnProperty(key)) {
      processEntry(extensionManifest, key);
    }
  }
}
var init_extensionNls = __esm({
  "out-build/vs/platform/extensionManagement/common/extensionNls.js"() {
    "use strict";
    init_types();
    init_nls2();
  }
});

// out-build/vs/platform/extensionManagement/common/extensionsScannerService.js
function $RB(extension, isUnderDevelopment) {
  const id2 = $qB(extension.manifest.publisher, extension.manifest.name);
  return {
    id: id2,
    identifier: new $MA(id2),
    isBuiltin: extension.type === 0,
    isUserBuiltin: extension.type === 1 && extension.isBuiltin,
    isUnderDevelopment,
    extensionLocation: extension.location,
    uuid: extension.identifier.uuid,
    targetPlatform: extension.targetPlatform,
    publisherDisplayName: extension.publisherDisplayName,
    preRelease: extension.preRelease,
    ...extension.manifest
  };
}
var Translations, $OB, $PB, $QB, ExtensionsScanner, CachedExtensionsScanner;
var init_extensionsScannerService = __esm({
  "out-build/vs/platform/extensionManagement/common/extensionsScannerService.js"() {
    "use strict";
    init_arrays();
    init_async();
    init_objects();
    init_buffer();
    init_errors();
    init_json();
    init_jsonErrorMessages();
    init_lifecycle();
    init_network();
    init_path();
    init_platform();
    init_resources();
    init_semver();
    init_severity();
    init_uri();
    init_nls2();
    init_environment();
    init_extensionManagementUtil();
    init_extensions();
    init_extensionValidator();
    init_files();
    init_instantiation();
    init_log();
    init_productService();
    init_event();
    init_marshalling();
    init_extensionsProfileScannerService();
    init_userDataProfile();
    init_uriIdentity();
    init_extensionNls();
    (function(Translations2) {
      function equals(a, b) {
        if (a === b) {
          return true;
        }
        const aKeys = Object.keys(a);
        const bKeys = /* @__PURE__ */ new Set();
        for (const key of Object.keys(b)) {
          bKeys.add(key);
        }
        if (aKeys.length !== bKeys.size) {
          return false;
        }
        for (const key of aKeys) {
          if (a[key] !== b[key]) {
            return false;
          }
          bKeys.delete(key);
        }
        return bKeys.size === 0;
      }
      Translations2.equals = equals;
    })(Translations || (Translations = {}));
    $OB = $kl("IExtensionsScannerService");
    $PB = class $PB2 extends $sd {
      constructor(systemExtensionsLocation, userExtensionsLocation, n, r, s, t, u, w, y, z, C, D) {
        super();
        this.systemExtensionsLocation = systemExtensionsLocation;
        this.userExtensionsLocation = userExtensionsLocation;
        this.n = n;
        this.r = r;
        this.s = s;
        this.t = t;
        this.u = u;
        this.w = w;
        this.y = y;
        this.z = z;
        this.C = C;
        this.D = D;
        this.g = this.B(new $0e());
        this.onDidChangeCache = this.g.event;
        this.h = this.B(this.D.createInstance(CachedExtensionsScanner, this.r));
        this.j = this.B(this.D.createInstance(CachedExtensionsScanner, this.r));
        this.m = this.B(this.D.createInstance(ExtensionsScanner));
        this.H = void 0;
        this.B(this.h.onDidChangeCache(() => this.g.fire(
          0
          /* ExtensionType.System */
        )));
        this.B(this.j.onDidChangeCache(() => this.g.fire(
          1
          /* ExtensionType.User */
        )));
      }
      G() {
        if (!this.F) {
          this.F = $yB(this.u, this.w);
        }
        return this.F;
      }
      async scanAllExtensions(systemScanOptions, userScanOptions) {
        const [system, user] = await Promise.all([
          this.scanSystemExtensions(systemScanOptions),
          this.scanUserExtensions(userScanOptions)
        ]);
        return this.L(system, user, [], await this.G(), true);
      }
      async scanSystemExtensions(scanOptions) {
        const promises15 = [];
        promises15.push(this.M(scanOptions.language));
        promises15.push(this.N(scanOptions.language, !!scanOptions.checkControlFile));
        const [defaultSystemExtensions, devSystemExtensions] = await Promise.all(promises15);
        return this.J([...defaultSystemExtensions, ...devSystemExtensions], 0, { pickLatest: false });
      }
      async scanUserExtensions(scanOptions) {
        this.w.trace("Started scanning user extensions", scanOptions.profileLocation);
        const profileScanOptions = this.C.extUri.isEqual(scanOptions.profileLocation, this.s.defaultProfile.extensionsResource) ? { bailOutWhenFileNotFound: true } : void 0;
        const extensionsScannerInput = await this.P(scanOptions.profileLocation, true, 1, scanOptions.language, true, profileScanOptions, scanOptions.productVersion ?? this.R());
        const extensionsScanner = scanOptions.useCache && !extensionsScannerInput.devMode ? this.j : this.m;
        let extensions;
        try {
          extensions = await extensionsScanner.scanExtensions(extensionsScannerInput);
        } catch (error) {
          if (error instanceof $AB && error.code === "ERROR_PROFILE_NOT_FOUND") {
            await this.I();
            extensions = await extensionsScanner.scanExtensions(extensionsScannerInput);
          } else {
            throw error;
          }
        }
        extensions = await this.J(extensions, 1, { includeInvalid: scanOptions.includeInvalid, pickLatest: true });
        this.w.trace("Scanned user extensions:", extensions.length);
        return extensions;
      }
      async scanAllUserExtensions(scanOptions = { includeInvalid: true, includeAllVersions: true }) {
        const extensionsScannerInput = await this.P(this.userExtensionsLocation, false, 1, void 0, true, void 0, this.R());
        const extensions = await this.m.scanExtensions(extensionsScannerInput);
        return this.J(extensions, 1, { includeAllVersions: scanOptions.includeAllVersions, includeInvalid: scanOptions.includeInvalid });
      }
      async scanExtensionsUnderDevelopment(existingExtensions, scanOptions) {
        if (this.y.isExtensionDevelopment && this.y.extensionDevelopmentLocationURI) {
          const extensions = (await Promise.all(this.y.extensionDevelopmentLocationURI.filter((extLoc) => extLoc.scheme === Schemas.file).map(async (extensionDevelopmentLocationURI) => {
            const input = await this.P(extensionDevelopmentLocationURI, false, 1, scanOptions.language, false, void 0, this.R());
            const extensions2 = await this.m.scanOneOrMultipleExtensions(input);
            return extensions2.map((extension) => {
              extension.type = existingExtensions.find((e) => $nB(e.identifier, extension.identifier))?.type ?? extension.type;
              return this.m.validate(extension, input);
            });
          }))).flat();
          return this.J(extensions, "development", { includeInvalid: scanOptions.includeInvalid, pickLatest: true });
        }
        return [];
      }
      async scanExistingExtension(extensionLocation, extensionType, scanOptions) {
        const extensionsScannerInput = await this.P(extensionLocation, false, extensionType, scanOptions.language, true, void 0, this.R());
        const extension = await this.m.scanExtension(extensionsScannerInput);
        if (!extension) {
          return null;
        }
        if (!scanOptions.includeInvalid && !extension.isValid) {
          return null;
        }
        return extension;
      }
      async scanOneOrMultipleExtensions(extensionLocation, extensionType, scanOptions) {
        const extensionsScannerInput = await this.P(extensionLocation, false, extensionType, scanOptions.language, true, void 0, this.R());
        const extensions = await this.m.scanOneOrMultipleExtensions(extensionsScannerInput);
        return this.J(extensions, extensionType, { includeInvalid: scanOptions.includeInvalid, pickLatest: true });
      }
      async scanMultipleExtensions(extensionLocations, extensionType, scanOptions) {
        const extensions = [];
        await Promise.all(extensionLocations.map(async (extensionLocation) => {
          const scannedExtensions = await this.scanOneOrMultipleExtensions(extensionLocation, extensionType, scanOptions);
          extensions.push(...scannedExtensions);
        }));
        return this.J(extensions, extensionType, { includeInvalid: scanOptions.includeInvalid, pickLatest: true });
      }
      async updateManifestMetadata(extensionLocation, metaData) {
        const manifestLocation = $Ph(extensionLocation, "package.json");
        const content = (await this.u.readFile(manifestLocation)).value.toString();
        const manifest = JSON.parse(content);
        manifest.__metadata = { ...manifest.__metadata, ...metaData };
        await this.u.writeFile($Ph(extensionLocation, "package.json"), $Wi.fromString(JSON.stringify(manifest, null, "	")));
      }
      async initializeDefaultProfileExtensions() {
        try {
          await this.t.scanProfileExtensions(this.s.defaultProfile.extensionsResource, { bailOutWhenFileNotFound: true });
        } catch (error) {
          if (error instanceof $AB && error.code === "ERROR_PROFILE_NOT_FOUND") {
            await this.I();
          } else {
            throw error;
          }
        }
      }
      async I() {
        if (!this.H) {
          this.H = (async () => {
            try {
              this.w.info("Started initializing default profile extensions in extensions installation folder.", this.userExtensionsLocation.toString());
              const userExtensions = await this.scanAllUserExtensions({ includeInvalid: true });
              if (userExtensions.length) {
                await this.t.addExtensionsToProfile(userExtensions.map((e) => [e, e.metadata]), this.s.defaultProfile.extensionsResource);
              } else {
                try {
                  await this.u.createFile(this.s.defaultProfile.extensionsResource, $Wi.fromString(JSON.stringify([])));
                } catch (error) {
                  if ($0m(error) !== 1) {
                    this.w.warn("Failed to create default profile extensions manifest in extensions installation folder.", this.userExtensionsLocation.toString(), $qb(error));
                  }
                }
              }
              this.w.info("Completed initializing default profile extensions in extensions installation folder.", this.userExtensionsLocation.toString());
            } catch (error) {
              this.w.error(error);
            } finally {
              this.H = void 0;
            }
          })();
        }
        return this.H;
      }
      async J(extensions, type2, scanOptions = {}) {
        if (!scanOptions.includeAllVersions) {
          extensions = this.L(type2 === 0 ? extensions : void 0, type2 === 1 ? extensions : void 0, type2 === "development" ? extensions : void 0, await this.G(), !!scanOptions.pickLatest);
        }
        if (!scanOptions.includeInvalid) {
          extensions = extensions.filter((extension) => extension.isValid);
        }
        return extensions.sort((a, b) => {
          const aLastSegment = $sc(a.location.fsPath);
          const bLastSegment = $sc(b.location.fsPath);
          if (aLastSegment < bLastSegment) {
            return -1;
          }
          if (aLastSegment > bLastSegment) {
            return 1;
          }
          return 0;
        });
      }
      L(system, user, development, targetPlatform, pickLatest) {
        const pick = (existing, extension, isDevelopment) => {
          if (existing.isValid && !extension.isValid) {
            return false;
          }
          if (existing.isValid === extension.isValid) {
            if (pickLatest && gt(existing.manifest.version, extension.manifest.version)) {
              this.w.debug(`Skipping extension ${extension.location.path} with lower version ${extension.manifest.version} in favour of ${existing.location.path} with version ${existing.manifest.version}`);
              return false;
            }
            if (eq(existing.manifest.version, extension.manifest.version)) {
              if (existing.type === 0) {
                this.w.debug(`Skipping extension ${extension.location.path} in favour of system extension ${existing.location.path} with same version`);
                return false;
              }
              if (existing.targetPlatform === targetPlatform) {
                this.w.debug(`Skipping extension ${extension.location.path} from different target platform ${extension.targetPlatform}`);
                return false;
              }
            }
          }
          if (isDevelopment) {
            this.w.warn(`Overwriting user extension ${existing.location.path} with ${extension.location.path}.`);
          } else {
            this.w.debug(`Overwriting user extension ${existing.location.path} with ${extension.location.path}.`);
          }
          return true;
        };
        const result = new $OA();
        system?.forEach((extension) => {
          const existing = result.get(extension.identifier.id);
          if (!existing || pick(existing, extension, false)) {
            result.set(extension.identifier.id, extension);
          }
        });
        user?.forEach((extension) => {
          const existing = result.get(extension.identifier.id);
          if (!existing && system && extension.type === 0) {
            this.w.debug(`Skipping obsolete system extension ${extension.location.path}.`);
            return;
          }
          if (!existing || pick(existing, extension, false)) {
            result.set(extension.identifier.id, extension);
          }
        });
        development?.forEach((extension) => {
          const existing = result.get(extension.identifier.id);
          if (!existing || pick(existing, extension, true)) {
            result.set(extension.identifier.id, extension);
          }
          result.set(extension.identifier.id, extension);
        });
        return [...result.values()];
      }
      async M(language) {
        this.w.trace("Started scanning system extensions");
        const extensionsScannerInput = await this.P(this.systemExtensionsLocation, false, 0, language, true, void 0, this.R());
        const extensionsScanner = extensionsScannerInput.devMode ? this.m : this.h;
        const result = await extensionsScanner.scanExtensions(extensionsScannerInput);
        this.w.trace("Scanned system extensions:", result.length);
        return result;
      }
      async N(language, checkControlFile) {
        const devSystemExtensionsList = this.y.isBuilt ? [] : this.z.builtInExtensions;
        if (!devSystemExtensionsList?.length) {
          return [];
        }
        this.w.trace("Started scanning dev system extensions");
        const builtinExtensionControl = checkControlFile ? await this.O() : {};
        const devSystemExtensionsLocations = [];
        const devSystemExtensionsLocation = URI.file($mc($oc($Ah.asFileUri("").fsPath, "..", ".build", "builtInExtensions")));
        for (const extension of devSystemExtensionsList) {
          const controlState = builtinExtensionControl[extension.name] || "marketplace";
          switch (controlState) {
            case "disabled":
              break;
            case "marketplace":
              devSystemExtensionsLocations.push($Ph(devSystemExtensionsLocation, extension.name));
              break;
            default:
              devSystemExtensionsLocations.push(URI.file(controlState));
              break;
          }
        }
        const result = await Promise.all(devSystemExtensionsLocations.map(async (location2) => this.m.scanExtension(await this.P(location2, false, 0, language, true, void 0, this.R()))));
        this.w.trace("Scanned dev system extensions:", result.length);
        return $Lb(result);
      }
      async O() {
        try {
          const content = await this.u.readFile(this.n);
          return JSON.parse(content.value.toString());
        } catch (error) {
          return {};
        }
      }
      async P(location2, profile, type2, language, validate, profileScanOptions, productVersion) {
        const translations = await this.f(language ?? $z);
        const mtime = await this.Q(location2);
        const applicationExtensionsLocation = profile && !this.C.extUri.isEqual(location2, this.s.defaultProfile.extensionsResource) ? this.s.defaultProfile.extensionsResource : void 0;
        const applicationExtensionsLocationMtime = applicationExtensionsLocation ? await this.Q(applicationExtensionsLocation) : void 0;
        return new $QB(location2, mtime, applicationExtensionsLocation, applicationExtensionsLocationMtime, profile, profileScanOptions, type2, validate, productVersion.version, productVersion.date, this.z.commit, !this.y.isBuilt, language, translations);
      }
      async Q(location2) {
        try {
          const stat = await this.u.stat(location2);
          if (typeof stat.mtime === "number") {
            return stat.mtime;
          }
        } catch (err) {
        }
        return void 0;
      }
      R() {
        return {
          version: this.z.version,
          date: this.z.date
        };
      }
    };
    $PB = __decorate([
      __param(4, $8s),
      __param(5, $BB),
      __param(6, $Sm),
      __param(7, $5n),
      __param(8, $rl),
      __param(9, $Dv),
      __param(10, $3l),
      __param(11, $jl)
    ], $PB);
    $QB = class {
      constructor(location2, mtime, applicationExtensionslocation, applicationExtensionslocationMtime, profile, profileScanOptions, type2, validate, productVersion, productDate, productCommit, devMode, language, translations) {
        this.location = location2;
        this.mtime = mtime;
        this.applicationExtensionslocation = applicationExtensionslocation;
        this.applicationExtensionslocationMtime = applicationExtensionslocationMtime;
        this.profile = profile;
        this.profileScanOptions = profileScanOptions;
        this.type = type2;
        this.validate = validate;
        this.productVersion = productVersion;
        this.productDate = productDate;
        this.productCommit = productCommit;
        this.devMode = devMode;
        this.language = language;
        this.translations = translations;
      }
      static createNlsConfiguration(input) {
        return {
          language: input.language,
          pseudo: input.language === "pseudo",
          devMode: input.devMode,
          translations: input.translations
        };
      }
      static equals(a, b) {
        return $Ih(a.location, b.location) && a.mtime === b.mtime && $Ih(a.applicationExtensionslocation, b.applicationExtensionslocation) && a.applicationExtensionslocationMtime === b.applicationExtensionslocationMtime && a.profile === b.profile && $yw(a.profileScanOptions, b.profileScanOptions) && a.type === b.type && a.validate === b.validate && a.productVersion === b.productVersion && a.productDate === b.productDate && a.productCommit === b.productCommit && a.devMode === b.devMode && a.language === b.language && Translations.equals(a.translations, b.translations);
      }
    };
    ExtensionsScanner = class ExtensionsScanner2 extends $sd {
      constructor(g, h, j, productService, m, n) {
        super();
        this.g = g;
        this.h = h;
        this.j = j;
        this.m = m;
        this.n = n;
        this.f = productService.extensionsEnabledWithApiProposalVersion?.map((id2) => id2.toLowerCase()) ?? [];
      }
      async scanExtensions(input) {
        return input.profile ? this.s(input) : this.r(input);
      }
      async r(input) {
        const stat = await this.j.resolve(input.location);
        if (!stat.children?.length) {
          return [];
        }
        const extensions = await Promise.all(stat.children.map(async (c) => {
          if (!c.isDirectory) {
            return null;
          }
          if (input.type === 1 && $Mh(c.resource).indexOf(".") === 0) {
            return null;
          }
          const extensionScannerInput = new $QB(c.resource, input.mtime, input.applicationExtensionslocation, input.applicationExtensionslocationMtime, input.profile, input.profileScanOptions, input.type, input.validate, input.productVersion, input.productDate, input.productCommit, input.devMode, input.language, input.translations);
          return this.scanExtension(extensionScannerInput);
        }));
        return $Lb(extensions).sort((a, b) => a.location.path < b.location.path ? -1 : 1);
      }
      async s(input) {
        let profileExtensions = await this.t(input.location, () => true, input);
        if (input.applicationExtensionslocation && !this.h.extUri.isEqual(input.location, input.applicationExtensionslocation)) {
          profileExtensions = profileExtensions.filter((e) => !e.metadata?.isApplicationScoped);
          const applicationExtensions = await this.t(input.applicationExtensionslocation, (e) => !!e.metadata?.isBuiltin || !!e.metadata?.isApplicationScoped, input);
          profileExtensions.push(...applicationExtensions);
        }
        return profileExtensions;
      }
      async t(profileResource, filter, input) {
        const scannedProfileExtensions = await this.g.scanProfileExtensions(profileResource, input.profileScanOptions);
        if (!scannedProfileExtensions.length) {
          return [];
        }
        const extensions = await Promise.all(scannedProfileExtensions.map(async (extensionInfo) => {
          if (filter(extensionInfo)) {
            const extensionScannerInput = new $QB(extensionInfo.location, input.mtime, input.applicationExtensionslocation, input.applicationExtensionslocationMtime, input.profile, input.profileScanOptions, input.type, input.validate, input.productVersion, input.productDate, input.productCommit, input.devMode, input.language, input.translations);
            return this.scanExtension(extensionScannerInput, extensionInfo);
          }
          return null;
        }));
        return $Lb(extensions);
      }
      async scanOneOrMultipleExtensions(input) {
        try {
          if (await this.j.exists($Ph(input.location, "package.json"))) {
            const extension = await this.scanExtension(input);
            return extension ? [extension] : [];
          } else {
            return await this.scanExtensions(input);
          }
        } catch (error) {
          this.n.error(`Error scanning extensions at ${input.location.path}:`, $qb(error));
          return [];
        }
      }
      async scanExtension(input, scannedProfileExtension) {
        const validations = [];
        let isValid = true;
        let manifest;
        try {
          manifest = await this.u(input.location);
        } catch (e) {
          if (scannedProfileExtension) {
            validations.push([severity_default.Error, $qb(e)]);
            isValid = false;
            const [publisher, name] = scannedProfileExtension.identifier.id.split(".");
            manifest = {
              name,
              publisher,
              version: scannedProfileExtension.version,
              engines: { vscode: "" }
            };
          } else {
            if (input.type !== 0) {
              this.n.error(e);
            }
            return null;
          }
        }
        if (!manifest.publisher) {
          manifest.publisher = $IA;
        }
        let metadata;
        if (scannedProfileExtension) {
          metadata = {
            ...scannedProfileExtension.metadata,
            size: manifest.__metadata?.size
          };
        } else if (manifest.__metadata) {
          metadata = {
            installedTimestamp: manifest.__metadata.installedTimestamp,
            size: manifest.__metadata.size,
            targetPlatform: manifest.__metadata.targetPlatform
          };
        }
        delete manifest.__metadata;
        const id2 = $sB(manifest.publisher, manifest.name);
        const identifier = metadata?.id ? { id: id2, uuid: metadata.id } : { id: id2 };
        const type2 = metadata?.isSystem ? 0 : input.type;
        const isBuiltin = type2 === 0 || !!metadata?.isBuiltin;
        try {
          manifest = await this.w(input.location, manifest, $QB.createNlsConfiguration(input));
        } catch (error) {
          this.n.warn("Failed to translate manifest", $qb(error));
        }
        let extension = {
          type: type2,
          identifier,
          manifest,
          location: input.location,
          isBuiltin,
          targetPlatform: metadata?.targetPlatform ?? "undefined",
          publisherDisplayName: metadata?.publisherDisplayName,
          metadata,
          isValid,
          validations,
          preRelease: !!metadata?.preRelease
        };
        if (input.validate) {
          extension = this.validate(extension, input);
        }
        if (manifest.enabledApiProposals && (!this.m.isBuilt || this.f.includes(id2.toLowerCase()))) {
          manifest.originalEnabledApiProposals = manifest.enabledApiProposals;
          manifest.enabledApiProposals = $VA([...manifest.enabledApiProposals]);
        }
        return extension;
      }
      validate(extension, input) {
        let isValid = extension.isValid;
        const validateApiVersion = this.m.isBuilt && this.f.includes(extension.identifier.id.toLowerCase());
        const validations = $JB(input.productVersion, input.productDate, input.location, extension.manifest, extension.isBuiltin, validateApiVersion);
        for (const [severity, message] of validations) {
          if (severity === severity_default.Error) {
            isValid = false;
            this.n.error(this.D(input.location, message));
          }
        }
        extension.isValid = isValid;
        extension.validations = [...extension.validations, ...validations];
        return extension;
      }
      async u(extensionLocation) {
        const manifestLocation = $Ph(extensionLocation, "package.json");
        let content;
        try {
          content = (await this.j.readFile(manifestLocation)).value.toString();
        } catch (error) {
          if ($0m(error) !== 1) {
            this.n.error(this.D(extensionLocation, localize(1955, null, manifestLocation.path, error.message)));
          }
          throw error;
        }
        let manifest;
        try {
          manifest = JSON.parse(content);
        } catch (err) {
          const errors = [];
          $fx(content, errors);
          for (const e of errors) {
            this.n.error(this.D(extensionLocation, localize(1956, null, manifestLocation.path, e.offset, e.length, $DB(e.error))));
          }
          throw err;
        }
        if ($nx(manifest) !== "object") {
          const errorMessage = this.D(extensionLocation, localize(1957, null, manifestLocation.path));
          this.n.error(errorMessage);
          throw new Error(errorMessage);
        }
        return manifest;
      }
      async w(extensionLocation, extensionManifest, nlsConfiguration2) {
        const localizedMessages = await this.y(extensionLocation, extensionManifest, nlsConfiguration2);
        if (localizedMessages) {
          try {
            const errors = [];
            const defaults = await this.z(localizedMessages.default, errors);
            if (errors.length > 0) {
              errors.forEach((error) => {
                this.n.error(this.D(extensionLocation, localize(1958, null, localizedMessages.default?.path, $DB(error.error))));
              });
              return extensionManifest;
            } else if ($nx(localizedMessages) !== "object") {
              this.n.error(this.D(extensionLocation, localize(1959, null, localizedMessages.default?.path)));
              return extensionManifest;
            }
            const localized = localizedMessages.values || /* @__PURE__ */ Object.create(null);
            return $NB(this.n, extensionManifest, localized, defaults);
          } catch (error) {
          }
        }
        return extensionManifest;
      }
      async y(extensionLocation, extensionManifest, nlsConfiguration2) {
        const defaultPackageNLS = $Ph(extensionLocation, "package.nls.json");
        const reportErrors = (localized, errors) => {
          errors.forEach((error) => {
            this.n.error(this.D(extensionLocation, localize(1960, null, localized?.path, $DB(error.error))));
          });
        };
        const reportInvalidFormat = (localized) => {
          this.n.error(this.D(extensionLocation, localize(1961, null, localized?.path)));
        };
        const translationId = `${extensionManifest.publisher}.${extensionManifest.name}`;
        const translationPath = nlsConfiguration2.translations[translationId];
        if (translationPath) {
          try {
            const translationResource = URI.file(translationPath);
            const content = (await this.j.readFile(translationResource)).value.toString();
            const errors = [];
            const translationBundle = $fx(content, errors);
            if (errors.length > 0) {
              reportErrors(translationResource, errors);
              return { values: void 0, default: defaultPackageNLS };
            } else if ($nx(translationBundle) !== "object") {
              reportInvalidFormat(translationResource);
              return { values: void 0, default: defaultPackageNLS };
            } else {
              const values = translationBundle.contents ? translationBundle.contents.package : void 0;
              return { values, default: defaultPackageNLS };
            }
          } catch (error) {
            return { values: void 0, default: defaultPackageNLS };
          }
        } else {
          const exists2 = await this.j.exists(defaultPackageNLS);
          if (!exists2) {
            return void 0;
          }
          let messageBundle;
          try {
            messageBundle = await this.C(extensionLocation, nlsConfiguration2);
          } catch (error) {
            return void 0;
          }
          if (!messageBundle.localized) {
            return { values: void 0, default: messageBundle.original };
          }
          try {
            const messageBundleContent = (await this.j.readFile(messageBundle.localized)).value.toString();
            const errors = [];
            const messages = $fx(messageBundleContent, errors);
            if (errors.length > 0) {
              reportErrors(messageBundle.localized, errors);
              return { values: void 0, default: messageBundle.original };
            } else if ($nx(messages) !== "object") {
              reportInvalidFormat(messageBundle.localized);
              return { values: void 0, default: messageBundle.original };
            }
            return { values: messages, default: messageBundle.original };
          } catch (error) {
            return { values: void 0, default: messageBundle.original };
          }
        }
      }
      /**
       * Parses original message bundle, returns null if the original message bundle is null.
       */
      async z(originalMessageBundle, errors) {
        if (originalMessageBundle) {
          try {
            const originalBundleContent = (await this.j.readFile(originalMessageBundle)).value.toString();
            return $fx(originalBundleContent, errors);
          } catch (error) {
          }
        }
        return;
      }
      /**
       * Finds localized message bundle and the original (unlocalized) one.
       * If the localized file is not present, returns null for the original and marks original as localized.
       */
      C(extensionLocation, nlsConfiguration2) {
        return new Promise((c, e) => {
          const loop = (locale) => {
            const toCheck = $Ph(extensionLocation, `package.nls.${locale}.json`);
            this.j.exists(toCheck).then((exists2) => {
              if (exists2) {
                c({ localized: toCheck, original: $Ph(extensionLocation, "package.nls.json") });
              }
              const index = locale.lastIndexOf("-");
              if (index === -1) {
                c({ localized: $Ph(extensionLocation, "package.nls.json"), original: null });
              } else {
                locale = locale.substring(0, index);
                loop(locale);
              }
            });
          };
          if (nlsConfiguration2.devMode || nlsConfiguration2.pseudo || !nlsConfiguration2.language) {
            return c({ localized: $Ph(extensionLocation, "package.nls.json"), original: null });
          }
          loop(nlsConfiguration2.language);
        });
      }
      D(extensionLocation, message) {
        return `[${extensionLocation.path}]: ${message}`;
      }
    };
    ExtensionsScanner = __decorate([
      __param(0, $BB),
      __param(1, $3l),
      __param(2, $Sm),
      __param(3, $Dv),
      __param(4, $rl),
      __param(5, $5n)
    ], ExtensionsScanner);
    CachedExtensionsScanner = class CachedExtensionsScanner2 extends ExtensionsScanner {
      constructor(I, J, extensionsProfileScannerService, uriIdentityService, fileService, productService, environmentService, logService) {
        super(extensionsProfileScannerService, uriIdentityService, fileService, productService, environmentService, logService);
        this.I = I;
        this.J = J;
        this.G = this.B(new $bi(3e3));
        this.H = this.B(new $0e());
        this.onDidChangeCache = this.H.event;
      }
      async scanExtensions(input) {
        const cacheFile = this.O(input);
        const cacheContents = await this.L(cacheFile);
        this.F = input;
        if (cacheContents && cacheContents.input && $QB.equals(cacheContents.input, this.F)) {
          this.n.debug("Using cached extensions scan result", input.type === 0 ? "system" : "user", input.location.toString());
          this.G.trigger(() => this.N());
          return cacheContents.result.map((extension) => {
            extension.location = URI.revive(extension.location);
            return extension;
          });
        }
        const result = await super.scanExtensions(input);
        await this.M(cacheFile, { input, result });
        return result;
      }
      async L(cacheFile) {
        try {
          const cacheRawContents = await this.j.readFile(cacheFile);
          const extensionCacheData = JSON.parse(cacheRawContents.value.toString());
          return { result: extensionCacheData.result, input: $Wu(extensionCacheData.input) };
        } catch (error) {
          this.n.debug("Error while reading the extension cache file:", cacheFile.path, $qb(error));
        }
        return null;
      }
      async M(cacheFile, cacheContents) {
        try {
          await this.j.writeFile(cacheFile, $Wi.fromString(JSON.stringify(cacheContents)));
        } catch (error) {
          this.n.debug("Error while writing the extension cache file:", cacheFile.path, $qb(error));
        }
      }
      async N() {
        if (!this.F) {
          return;
        }
        const cacheFile = this.O(this.F);
        const cacheContents = await this.L(cacheFile);
        if (!cacheContents) {
          return;
        }
        const actual = cacheContents.result;
        const expected = JSON.parse(JSON.stringify(await super.scanExtensions(this.F)));
        if ($yw(expected, actual)) {
          return;
        }
        try {
          this.n.info("Invalidating Cache", actual, expected);
          await this.j.del(cacheFile);
          this.H.fire();
        } catch (error) {
          this.n.error(error);
        }
      }
      O(input) {
        const profile = this.P(input);
        return this.h.extUri.joinPath(profile.cacheHome, input.type === 0 ? $HA : $GA);
      }
      P(input) {
        if (input.type === 0) {
          return this.J.defaultProfile;
        }
        if (!input.profile) {
          return this.J.defaultProfile;
        }
        if (this.h.extUri.isEqual(input.location, this.I.extensionsResource)) {
          return this.I;
        }
        return this.J.profiles.find((p) => this.h.extUri.isEqual(input.location, p.extensionsResource)) ?? this.I;
      }
    };
    CachedExtensionsScanner = __decorate([
      __param(1, $8s),
      __param(2, $BB),
      __param(3, $3l),
      __param(4, $Sm),
      __param(5, $Dv),
      __param(6, $rl),
      __param(7, $5n)
    ], CachedExtensionsScanner);
  }
});

// out-build/vs/platform/extensionManagement/node/extensionManagementUtil.js
function $v1(e) {
  let errorCode = "Extract";
  if (e instanceof $r1) {
    if (e.type === "CorruptZip") {
      errorCode = "CorruptZip";
    } else if (e.type === "Incomplete") {
      errorCode = "IncompleteZip";
    }
  }
  return $l1(e, errorCode);
}
async function $w1(vsixPath) {
  let data;
  try {
    data = await $u1(vsixPath, "extension/package.json");
  } catch (e) {
    throw $v1(e);
  }
  try {
    return JSON.parse(data.toString("utf8"));
  } catch (err) {
    throw new $bB(
      localize(1972, null),
      "Invalid"
      /* ExtensionManagementErrorCode.Invalid */
    );
  }
}
var init_extensionManagementUtil2 = __esm({
  "out-build/vs/platform/extensionManagement/node/extensionManagementUtil.js"() {
    "use strict";
    init_zip();
    init_nls2();
    init_abstractExtensionManagementService();
    init_extensionManagement();
  }
});

// out-build/vs/platform/extensionManagement/node/extensionSignatureVerificationService.js
var $g1, $h1;
var init_extensionSignatureVerificationService = __esm({
  "out-build/vs/platform/extensionManagement/node/extensionSignatureVerificationService.js"() {
    "use strict";
    init_errors();
    init_types();
    init_instantiation();
    init_log();
    init_telemetry();
    init_extensionManagement();
    $g1 = $kl("IExtensionSignatureVerificationService");
    $h1 = class $h12 {
      constructor(b, c) {
        this.b = b;
        this.c = c;
      }
      d() {
        if (!this.a) {
          this.a = this.f();
        }
        return this.a;
      }
      async f() {
        const mod = "@vscode/vsce-sign";
        return import(mod);
      }
      async verify(extensionId, version, vsixFilePath, signatureArchiveFilePath, clientTargetPlatform) {
        let module2;
        try {
          module2 = await this.d();
        } catch (error) {
          this.b.error("Could not load vsce-sign module", $qb(error));
          this.b.info(`Extension signature verification is not done: ${extensionId}`);
          return void 0;
        }
        const startTime = (/* @__PURE__ */ new Date()).getTime();
        let result;
        try {
          this.b.trace(`Verifying extension signature for ${extensionId}...`);
          result = await module2.verify(vsixFilePath, signatureArchiveFilePath, this.b.getLevel() === LogLevel.Trace);
        } catch (e) {
          result = {
            code: ExtensionSignatureVerificationCode.UnknownError,
            didExecute: false,
            output: $qb(e)
          };
        }
        const duration = (/* @__PURE__ */ new Date()).getTime() - startTime;
        this.b.info(`Extension signature verification result for ${extensionId}: ${result.code}. ${$5c(result.internalCode) ? `Internal Code: ${result.internalCode}. ` : ""}Executed: ${result.didExecute}. Duration: ${duration}ms.`);
        this.b.trace(`Extension signature verification output for ${extensionId}:
${result.output}`);
        this.c.publicLog2("extensionsignature:verification", {
          extensionId,
          extensionVersion: version,
          code: result.code,
          internalCode: result.internalCode,
          duration,
          didExecute: result.didExecute,
          clientTargetPlatform
        });
        return { code: result.code };
      }
    };
    $h1 = __decorate([
      __param(0, $5n),
      __param(1, $iw)
    ], $h1);
  }
});

// out-build/vs/platform/extensionManagement/node/extensionDownloader.js
var $x1_1, $x1;
var init_extensionDownloader = __esm({
  "out-build/vs/platform/extensionManagement/node/extensionDownloader.js"() {
    "use strict";
    init_async();
    init_errors();
    init_lifecycle();
    init_network();
    init_resources();
    init_semver();
    init_uuid();
    init_pfs();
    init_zip();
    init_environment();
    init_abstractExtensionManagementService();
    init_extensionManagement();
    init_extensionManagementUtil();
    init_extensionManagementUtil2();
    init_extensionSignatureVerificationService();
    init_files();
    init_log();
    init_telemetry();
    init_uriIdentity();
    $x1 = class $x12 extends $sd {
      static {
        $x1_1 = this;
      }
      static {
        this.c = ".sigzip";
      }
      constructor(environmentService, j, m, n, r, t, u) {
        super();
        this.j = j;
        this.m = m;
        this.n = n;
        this.r = r;
        this.t = t;
        this.u = u;
        this.extensionsDownloadDir = environmentService.extensionsDownloadLocation;
        this.f = t.extUri.joinPath(environmentService.extensionsDownloadLocation, `.trash`);
        this.g = 20;
        this.h = this.F();
      }
      async download(extension, operation, verifySignature, clientTargetPlatform) {
        await this.h;
        const location2 = await this.w(extension, operation);
        if (!verifySignature) {
          return { location: location2, verificationStatus: void 0 };
        }
        if (!extension.isSigned) {
          return { location: location2, verificationStatus: ExtensionSignatureVerificationCode.NotSigned };
        }
        let signatureArchiveLocation;
        try {
          signatureArchiveLocation = await this.y(extension);
          const verificationStatus = (await this.n.verify(extension.identifier.id, extension.version, location2.fsPath, signatureArchiveLocation.fsPath, clientTargetPlatform))?.code;
          if (verificationStatus === ExtensionSignatureVerificationCode.PackageIsInvalidZip || verificationStatus === ExtensionSignatureVerificationCode.SignatureArchiveIsInvalidZip) {
            try {
              await this.delete(location2);
            } catch (error) {
              this.u.error(error);
            }
            throw new $bB(
              $q1,
              "CorruptZip"
              /* ExtensionManagementErrorCode.CorruptZip */
            );
          }
          return { location: location2, verificationStatus };
        } catch (error) {
          try {
            await this.delete(location2);
          } catch (error2) {
            this.u.error(error2);
          }
          throw error;
        } finally {
          if (signatureArchiveLocation) {
            try {
              await this.delete(signatureArchiveLocation);
            } catch (error) {
              this.u.error(error);
            }
          }
        }
      }
      async w(extension, operation) {
        try {
          const location2 = $Ph(this.extensionsDownloadDir, this.G(extension));
          const attempts = await this.C(extension, "vsix", async () => {
            await this.z(extension, location2, (location3) => this.m.download(extension, location3, operation));
            try {
              await this.D(location2.fsPath, "extension/package.json");
            } catch (error) {
              try {
                await this.j.del(location2);
              } catch (e) {
                this.u.warn(`Error while deleting: ${location2.path}`, $qb(e));
              }
              throw error;
            }
          }, 2);
          if (attempts > 1) {
            this.r.publicLog2("extensiongallery:downloadvsix:retry", {
              extensionId: extension.identifier.id,
              attempts
            });
          }
          return location2;
        } catch (e) {
          throw $l1(
            e,
            "Download"
            /* ExtensionManagementErrorCode.Download */
          );
        }
      }
      async y(extension) {
        try {
          const location2 = $Ph(this.extensionsDownloadDir, `${this.G(extension)}${$x1_1.c}`);
          const attempts = await this.C(extension, "sigzip", async () => {
            await this.m.downloadSignatureArchive(extension, location2);
            try {
              await this.D(location2.fsPath, ".signature.p7s");
            } catch (error) {
              try {
                await this.j.del(location2);
              } catch (e) {
                this.u.warn(`Error while deleting: ${location2.path}`, $qb(e));
              }
              throw error;
            }
          }, 2);
          if (attempts > 1) {
            this.r.publicLog2("extensiongallery:downloadsigzip:retry", {
              extensionId: extension.identifier.id,
              attempts
            });
          }
          return location2;
        } catch (e) {
          throw $l1(
            e,
            "DownloadSignature"
            /* ExtensionManagementErrorCode.DownloadSignature */
          );
        }
      }
      async z(extension, location2, downloadFn) {
        if (await this.j.exists(location2)) {
          return;
        }
        if (location2.scheme !== Schemas.file) {
          await downloadFn(location2);
          return;
        }
        const tempLocation = $Ph(this.extensionsDownloadDir, `.${$6s()}`);
        try {
          await downloadFn(tempLocation);
        } catch (error) {
          try {
            await this.j.del(tempLocation);
          } catch (e) {
          }
          throw error;
        }
        try {
          await Promises2.rename(
            tempLocation.fsPath,
            location2.fsPath,
            2 * 60 * 1e3
            /* Retry for 2 minutes */
          );
        } catch (error) {
          try {
            await this.j.del(tempLocation);
          } catch (e) {
          }
          let exists2 = false;
          try {
            exists2 = await this.j.exists(location2);
          } catch (e) {
          }
          if (exists2) {
            this.u.info(`Rename failed because the file was downloaded by another source. So ignoring renaming.`, extension.identifier.id, location2.path);
          } else {
            this.u.info(`Rename failed because of ${$qb(error)}. Deleted the file from downloaded location`, tempLocation.path);
            throw error;
          }
        }
      }
      async C(extension, name, downloadFn, retries) {
        let attempts = 1;
        while (true) {
          try {
            await downloadFn();
            return attempts;
          } catch (e) {
            if (attempts++ > retries) {
              throw e;
            }
            this.u.warn(`Failed downloading ${name}. ${$qb(e)}. Retry again...`, extension.identifier.id);
          }
        }
      }
      async D(zipPath, filePath) {
        try {
          await $u1(zipPath, filePath);
        } catch (e) {
          throw $v1(e);
        }
      }
      async delete(location2) {
        await this.h;
        const trashRelativePath = this.t.extUri.relativePath(this.extensionsDownloadDir, location2);
        if (trashRelativePath) {
          await this.j.move(location2, this.t.extUri.joinPath(this.f, trashRelativePath), true);
        } else {
          await this.j.del(location2);
        }
      }
      async F() {
        try {
          if (!await this.j.exists(this.extensionsDownloadDir)) {
            this.u.trace("Extension VSIX downloads cache dir does not exist");
            return;
          }
          try {
            await this.j.del(this.f, { recursive: true });
          } catch (error) {
            if ($0m(error) !== 1) {
              this.u.error(error);
            }
          }
          const folderStat = await this.j.resolve(this.extensionsDownloadDir, { resolveMetadata: true });
          if (folderStat.children) {
            const toDelete = [];
            const vsixs = [];
            const signatureArchives = [];
            for (const stat of folderStat.children) {
              if (stat.name.endsWith($x1_1.c)) {
                signatureArchives.push(stat.resource);
              } else {
                const extension = $oB.parse(stat.name);
                if (extension) {
                  vsixs.push([extension, stat]);
                }
              }
            }
            const byExtension = $tB(vsixs, ([extension]) => extension);
            const distinct = [];
            for (const p of byExtension) {
              p.sort((a, b) => rcompare(a[0].version, b[0].version));
              toDelete.push(...p.slice(1).map((e) => e[1].resource));
              distinct.push(p[0][1]);
            }
            distinct.sort((a, b) => a.mtime - b.mtime);
            toDelete.push(...distinct.slice(0, Math.max(0, distinct.length - this.g)).map((s) => s.resource));
            toDelete.push(...signatureArchives);
            await Promises.settled(toDelete.map((resource) => {
              this.u.trace("Deleting from cache", resource.path);
              return this.j.del(resource);
            }));
          }
        } catch (e) {
          this.u.error(e);
        }
      }
      G(extension) {
        return $oB.create(extension).toString().toLowerCase();
      }
    };
    $x1 = $x1_1 = __decorate([
      __param(0, $sl),
      __param(1, $Sm),
      __param(2, $_A),
      __param(3, $g1),
      __param(4, $iw),
      __param(5, $3l),
      __param(6, $5n)
    ], $x1);
  }
});

// out-build/vs/platform/extensionManagement/node/extensionLifecycle.js
import { fork } from "child_process";
var $y1;
var init_extensionLifecycle = __esm({
  "out-build/vs/platform/extensionManagement/node/extensionLifecycle.js"() {
    "use strict";
    init_async();
    init_errorMessage();
    init_event();
    init_lifecycle();
    init_network();
    init_path();
    init_pfs();
    init_log();
    init_userDataProfile();
    $y1 = class $y12 extends $sd {
      constructor(b, f) {
        super();
        this.b = b;
        this.f = f;
        this.a = new $ji(5);
      }
      async postUninstall(extension) {
        const script = this.g(extension, "uninstall");
        if (script) {
          this.f.info(extension.identifier.id, extension.manifest.version, `Running post uninstall script`);
          await this.a.queue(async () => {
            try {
              await this.h(script.script, "uninstall", script.args, true, extension);
              this.f.info(`Finished running post uninstall script`, extension.identifier.id, extension.manifest.version);
            } catch (error) {
              this.f.error("Failed to run post uninstall script", extension.identifier.id, extension.manifest.version);
              this.f.error(error);
            }
          });
        }
        try {
          await Promises2.rm(this.m(extension));
        } catch (error) {
          this.f.error("Error while removing extension storage path", extension.identifier.id);
          this.f.error(error);
        }
      }
      g(extension, type2) {
        const scriptKey = `vscode:${type2}`;
        if (extension.location.scheme === Schemas.file && extension.manifest && extension.manifest["scripts"] && typeof extension.manifest["scripts"][scriptKey] === "string") {
          const script = extension.manifest["scripts"][scriptKey].split(" ");
          if (script.length < 2 || script[0] !== "node" || !script[1]) {
            this.f.warn(extension.identifier.id, extension.manifest.version, `${scriptKey} should be a node script`);
            return null;
          }
          return { script: $oc(extension.location.fsPath, script[1]), args: script.slice(2) || [] };
        }
        return null;
      }
      h(lifecycleHook, lifecycleType, args, timeout, extension) {
        return new Promise((c, e) => {
          const extensionLifecycleProcess = this.j(lifecycleHook, lifecycleType, args, extension);
          let timeoutHandler;
          const onexit = (error) => {
            if (timeoutHandler) {
              clearTimeout(timeoutHandler);
              timeoutHandler = null;
            }
            if (error) {
              e(error);
            } else {
              c(void 0);
            }
          };
          extensionLifecycleProcess.on("error", (err) => {
            onexit($wn(err) || "Unknown");
          });
          extensionLifecycleProcess.on("exit", (code, signal) => {
            onexit(code ? `post-${lifecycleType} process exited with code ${code}` : void 0);
          });
          if (timeout) {
            timeoutHandler = setTimeout(() => {
              timeoutHandler = null;
              extensionLifecycleProcess.kill();
              e("timed out");
            }, 5e3);
          }
        });
      }
      j(uninstallHook, lifecycleType, args, extension) {
        const opts = {
          silent: true,
          execArgv: void 0
        };
        const extensionUninstallProcess = fork(uninstallHook, [`--type=extension-post-${lifecycleType}`, ...args], opts);
        extensionUninstallProcess.stdout.setEncoding("utf8");
        extensionUninstallProcess.stderr.setEncoding("utf8");
        const onStdout = Event.fromNodeEventEmitter(extensionUninstallProcess.stdout, "data");
        const onStderr = Event.fromNodeEventEmitter(extensionUninstallProcess.stderr, "data");
        this.B(onStdout((data) => this.f.info(extension.identifier.id, extension.manifest.version, `post-${lifecycleType}`, data)));
        this.B(onStderr((data) => this.f.error(extension.identifier.id, extension.manifest.version, `post-${lifecycleType}`, data)));
        const onOutput = Event.any(Event.map(onStdout, (o) => ({ data: `%c${o}`, format: [""] }), this.q), Event.map(onStderr, (o) => ({ data: `%c${o}`, format: ["color: red"] }), this.q));
        const onDebouncedOutput = Event.debounce(onOutput, (r, o) => {
          return r ? { data: r.data + o.data, format: [...r.format, ...o.format] } : { data: o.data, format: o.format };
        }, 100, void 0, void 0, void 0, this.q);
        onDebouncedOutput((data) => {
          console.group(extension.identifier.id);
          console.log(data.data, ...data.format);
          console.groupEnd();
        });
        return extensionUninstallProcess;
      }
      m(extension) {
        return $oc(this.b.defaultProfile.globalStorageHome.fsPath, extension.identifier.id.toLowerCase());
      }
    };
    $y1 = __decorate([
      __param(0, $8s),
      __param(1, $5n)
    ], $y1);
  }
});

// out-build/vs/platform/extensionManagement/node/extensionsManifestCache.js
var $z1;
var init_extensionsManifestCache = __esm({
  "out-build/vs/platform/extensionManagement/node/extensionsManifestCache.js"() {
    "use strict";
    init_lifecycle();
    init_extensions();
    init_files();
    $z1 = class extends $sd {
      constructor(a, b, c, extensionsManagementService, f) {
        super();
        this.a = a;
        this.b = b;
        this.c = c;
        this.f = f;
        this.B(extensionsManagementService.onDidInstallExtensions((e) => this.g(e)));
        this.B(extensionsManagementService.onDidUninstallExtension((e) => this.h(e)));
      }
      g(results) {
        for (const r of results) {
          if (r.local) {
            this.invalidate(r.profileLocation);
          }
        }
      }
      h(e) {
        if (!e.error) {
          this.invalidate(e.profileLocation);
        }
      }
      async invalidate(extensionsManifestLocation) {
        if (extensionsManifestLocation) {
          for (const profile of this.a.profiles) {
            if (this.c.extUri.isEqual(profile.extensionsResource, extensionsManifestLocation)) {
              await this.j(profile);
            }
          }
        } else {
          await this.j(this.a.defaultProfile);
        }
      }
      async j(profile) {
        try {
          await this.b.del(this.c.extUri.joinPath(profile.cacheHome, $GA));
        } catch (error) {
          if ($0m(error) !== 1) {
            this.f.error(error);
          }
        }
      }
    };
  }
});

// out-build/vs/platform/extensionManagement/node/extensionsWatcher.js
var $A1;
var init_extensionsWatcher = __esm({
  "out-build/vs/platform/extensionManagement/node/extensionsWatcher.js"() {
    "use strict";
    init_errors();
    init_event();
    init_lifecycle();
    init_map();
    init_extensionManagementUtil();
    init_extensions();
    $A1 = class extends $sd {
      constructor(f, g, h, j, m, n, r) {
        super();
        this.f = f;
        this.g = g;
        this.h = h;
        this.j = j;
        this.m = m;
        this.n = n;
        this.r = r;
        this.a = this.B(new $0e());
        this.onDidChangeExtensionsByAnotherSource = this.a.event;
        this.b = /* @__PURE__ */ new Map();
        this.c = this.B(new $Bd());
        this.s().then(null, (error) => r.error("Error while initializing Extensions Watcher", $qb(error)));
      }
      async s() {
        await this.g.initializeDefaultProfileExtensions();
        await this.u(this.h.profiles);
        this.t();
        await this.H();
      }
      t() {
        this.B(this.h.onDidChangeProfiles((e) => this.u(e.added)));
        this.B(this.j.onAddExtensions((e) => this.w(e)));
        this.B(this.j.onDidAddExtensions((e) => this.y(e)));
        this.B(this.j.onRemoveExtensions((e) => this.z(e)));
        this.B(this.j.onDidRemoveExtensions((e) => this.C(e)));
        this.B(this.n.onDidFilesChange((e) => this.D(e)));
      }
      async u(added) {
        try {
          if (added.length) {
            await Promise.all(added.map((profile) => {
              this.c.set(profile.id, $pd(
                this.n.watch(this.m.extUri.dirname(profile.extensionsResource)),
                // Also listen to the resource incase the resource is a symlink - https://github.com/microsoft/vscode/issues/118134
                this.n.watch(profile.extensionsResource)
              ));
              return this.G(profile.extensionsResource);
            }));
          }
        } catch (error) {
          this.r.error(error);
          throw error;
        }
      }
      async w(e) {
        for (const extension of e.extensions) {
          this.I(this.L(extension.identifier, extension.version), e.profileLocation);
        }
      }
      async y(e) {
        for (const extension of e.extensions) {
          const key = this.L(extension.identifier, extension.version);
          if (e.error) {
            this.J(key, e.profileLocation);
          } else {
            this.I(key, e.profileLocation);
          }
        }
      }
      async z(e) {
        for (const extension of e.extensions) {
          this.J(this.L(extension.identifier, extension.version), e.profileLocation);
        }
      }
      async C(e) {
        const extensionsToDelete = [];
        const promises15 = [];
        for (const extension of e.extensions) {
          const key = this.L(extension.identifier, extension.version);
          if (e.error) {
            this.I(key, e.profileLocation);
          } else {
            this.J(key, e.profileLocation);
            if (!this.b.has(key)) {
              this.r.debug("Extension is removed from all profiles", extension.identifier.id, extension.version);
              promises15.push(this.f.scanInstalledExtensionAtLocation(extension.location).then((result) => {
                if (result) {
                  extensionsToDelete.push(result);
                } else {
                  this.r.info("Extension not found at the location", extension.location.toString());
                }
              }, (error) => this.r.error(error)));
            }
          }
        }
        try {
          await Promise.all(promises15);
          if (extensionsToDelete.length) {
            await this.H(extensionsToDelete);
          }
        } catch (error) {
          this.r.error(error);
        }
      }
      D(e) {
        for (const profile of this.h.p