// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/** Order option for {@linkcode SortByOptions}. */ export function sortBy(array, selector, options) {
  const len = array.length;
  const indexes = new Array(len);
  const selectors = new Array(len);
  const order = options?.order ?? "asc";
  array.forEach((element, index)=>{
    indexes[index] = index;
    const selected = selector(element);
    selectors[index] = Number.isNaN(selected) ? null : selected;
  });
  indexes.sort((ai, bi)=>{
    let a = selectors[ai];
    let b = selectors[bi];
    if (order === "desc") {
      [a, b] = [
        b,
        a
      ];
    }
    if (a === null) return 1;
    if (b === null) return -1;
    return a > b ? 1 : a < b ? -1 : 0;
  });
  for(let i = 0; i < len; i++){
    indexes[i] = array[indexes[i]];
  }
  return indexes;
}
//# sourceMappingURL=data:application/json;base64,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