// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { toWritableStream } from "jsr:/@std/io@^0.224.1/to-writable-stream";
/**
 * Create a {@linkcode WritableStream} from a {@linkcode https://jsr.io/@std/io/doc/types/~/Writer | Writer}.
 *
 * @param writer A `Writer` to convert into a `WritableStream`.
 * @param options Options for the `writableStreamFromWriter` function.
 * @returns A `WritableStream` of `Uint8Array`s.
 *
 * @example Convert `Deno.stdout` into a writable stream
 * ```ts no-eval no-assert
 * // Note that you can directly get the writer from `Deno.stdout` by
 * // `Deno.stdout.writable`. This example is just for demonstration purposes;
 * // definitely not a recommended way.
 *
 * import { writableStreamFromWriter } from "@std/streams/writable-stream-from-writer";
 *
 * const stdoutStream = writableStreamFromWriter(Deno.stdout);
 * ```
 *
 * @deprecated This will be removed in 1.0.0. Use {@linkcode https://jsr.io/@std/io/doc/~/toWritableStream | toWritableStream} instead.
 */ export function writableStreamFromWriter(writer, options = {}) {
  return toWritableStream(writer, options);
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=8408556874944719751,16607438622334093499