"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.globalConfigCustomValues = exports.GLOBAL_CONFIG_DEFAULTS = void 0;
const path_1 = __importDefault(require("path"));
const logger_1 = __importDefault(require("./logger"));
const disk_cache_1 = require("./disk_cache");
exports.GLOBAL_CONFIG_DEFAULTS = {
    crlDownloadTimeout: 10000,
    crlCacheValidityTime: 86400000,
    get crlCacheDir() {
        return process.env.SNOWFLAKE_CRL_ON_DISK_CACHE_DIR || path_1.default.join((0, disk_cache_1.getDefaultCacheDir)(), 'crls');
    },
};
exports.globalConfigCustomValues = {};
exports.default = {
    setValues: (options) => {
        const filteredOptions = Object.fromEntries(Object.entries(options).filter(([key, value]) => key in exports.GLOBAL_CONFIG_DEFAULTS && value !== undefined));
        (0, logger_1.default)().debug('Setting global config typed values: %j', filteredOptions);
        Object.assign(exports.globalConfigCustomValues, filteredOptions);
    },
    getValue: (key) => {
        return exports.globalConfigCustomValues[key] ?? exports.GLOBAL_CONFIG_DEFAULTS[key];
    },
};
//# sourceMappingURL=global_config_typed.js.map