"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setInstance = setInstance;
exports.getInstance = getInstance;
const browser_1 = __importDefault(require("./logger/browser"));
let instance;
/**
 * Sets the logger instance. For internal use only.
 */
function setInstance(newInstance) {
    instance = newInstance;
}
/**
 * Returns the current logger instance.
 * @deprecated
 *
 * In TypeScript, use default import:
 * ```
 *  import Logger from './Logger';
 *  Logger().info(...)
 * ```
 *
 * In JavaScript, use:
 * ```
 *  const Logger = require('./Logger').default;
 *  Logger().info(...)
 * ```
 */
function getInstance() {
    // use the browser implementation of logger as the default implementation;
    // we do this so that unit tests don't fail when the modules they're testing
    // log messages
    if (!instance) {
        instance = new browser_1.default();
    }
    return instance;
}
exports.default = () => getInstance();
//# sourceMappingURL=logger.js.map