// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
export { instantiate as instantiateWasm } from "./lib/deno_std_wasm_crypto.generated.mjs";
/**
 * All cryptographic hash/digest algorithms supported by std/crypto.
 *
 * For algorithms that are supported by WebCrypto, the name here will match the
 * one used by WebCrypto. Otherwise we prefer the formatting used in the
 * algorithm's official specification. All names are uppercase to facilitate
 * case-insensitive comparisons required by the WebCrypto spec.
 */ export const DIGEST_ALGORITHM_NAMES = [
  "BLAKE2B",
  "BLAKE2B-128",
  "BLAKE2B-160",
  "BLAKE2B-224",
  "BLAKE2B-256",
  "BLAKE2B-384",
  "BLAKE2S",
  "BLAKE3",
  "KECCAK-224",
  "KECCAK-256",
  "KECCAK-384",
  "KECCAK-512",
  "SHA-384",
  "SHA3-224",
  "SHA3-256",
  "SHA3-384",
  "SHA3-512",
  "SHAKE128",
  "SHAKE256",
  "TIGER",
  // insecure (length-extendable):
  "RIPEMD-160",
  "SHA-224",
  "SHA-256",
  "SHA-512",
  // insecure (length-extendable and collidable):
  "MD4",
  "MD5",
  "SHA-1",
  // insecure (non-cryptographic)
  "FNV32",
  "FNV32A",
  "FNV64",
  "FNV64A"
];
//# sourceMappingURL=data:application/json;base64,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