// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
import { repeat } from "./_utils.ts";
export class Mark {
  name;
  buffer;
  position;
  line;
  column;
  constructor(name, buffer, position, line, column){
    this.name = name;
    this.buffer = buffer;
    this.position = position;
    this.line = line;
    this.column = column;
  }
  getSnippet(indent = 4, maxLength = 75) {
    if (!this.buffer) return null;
    let head = "";
    let start = this.position;
    while(start > 0 && "\x00\r\n\x85\u2028\u2029".indexOf(this.buffer.charAt(start - 1)) === -1){
      start -= 1;
      if (this.position - start > maxLength / 2 - 1) {
        head = " ... ";
        start += 5;
        break;
      }
    }
    let tail = "";
    let end = this.position;
    while(end < this.buffer.length && "\x00\r\n\x85\u2028\u2029".indexOf(this.buffer.charAt(end)) === -1){
      end += 1;
      if (end - this.position > maxLength / 2 - 1) {
        tail = " ... ";
        end -= 5;
        break;
      }
    }
    const snippet = this.buffer.slice(start, end);
    return `${repeat(" ", indent)}${head}${snippet}${tail}\n${repeat(" ", indent + this.position - start + head.length)}^`;
  }
  toString(compact) {
    let snippet;
    let where = "";
    if (this.name) {
      where += `in "${this.name}" `;
    }
    where += `at line ${this.line + 1}, column ${this.column + 1}`;
    if (!compact) {
      snippet = this.getSnippet();
      if (snippet) {
        where += `:\n${snippet}`;
      }
    }
    return where;
  }
}
//# sourceMappingURL=data:application/json;base64,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