"use strict";
/*
 * index.ts
 *
 * Copyright (C) 2022 by Posit Software, PBC
 *
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getApi = getApi;
exports.handleOnBrowse = handleOnBrowse;
exports.validateState = validateState;
exports.run = run;
const tom_select_1 = __importDefault(require("tom-select"));
const credentials_1 = require("./credentials");
const interface_1 = require("./interface");
const languages_1 = require("./languages");
// TODO: Revert this to add back in animation
// The original implementation used explicit heights to animate the expand/collapse action.
// The specific styles were interferring with the custom select, so for now we have commented
// it out until we can find a better solution.
function sizeToContent(_el, _immediate = false, _trim = 0) {
    // if (!el) { return; }
    // const range = new Range();
    // range.selectNodeContents(el);
    // el.style.transition = immediate ? '' : 'height 500ms var(--ease-out)';
    // el.style.height = `${range.getBoundingClientRect().height + trim}px`;
    // el.style.boxSizing = 'content-box';
    // el.style.overflowY = 'hidden';
    // range.detach();
}
// TODO: Revert this to add back in animation
function resetSize(_el) {
    // if (!el) { return; }
    // el.style.transition = '';
    // el.style.height = '';
    // el.style.boxSizing = '';
}
// message ID for postMessage association
let mid = 0;
// convert to our own version of the WebviewApi for explicit events
let api;
function getApi() {
    if (!api) {
        api = acquireVsCodeApi();
    }
    return api;
}
function handleOnBrowse(directory = false, callback) {
    const vscode = getApi();
    const messageId = ++mid;
    const browseListener = (event) => {
        const { type, id, message } = event.data;
        // message id must match, otherwise this may have come from a
        // different browse_path event (unlikely)
        if (type !== "browse_path" || id !== messageId) {
            return;
        }
        window.removeEventListener("message", browseListener);
        if (!message) {
            return;
        }
        callback(event);
    };
    window.addEventListener("message", browseListener);
    vscode.postMessage({ event: "browse_path", id: messageId, directory });
}
function validateState(state) {
    var _a, _b;
    return !!(((_a = state.launchSpec) === null || _a === void 0 ? void 0 : _a.name) && (0, languages_1.validScriptExtension)(((_b = state.jobOptions) === null || _b === void 0 ? void 0 : _b.script) || ""));
}
function run() {
    const vscode = getApi();
    const viewState = vscode.getState() || {};
    // ---- Create and wire up the launcher ----
    const launcherUiEl = document.getElementById("launcher-ui");
    const mainEl = document.getElementById("main");
    const startButton = document.getElementById("submit");
    const workbenches = ["RStudio"];
    try {
        const launcherInput = Object.assign(Object.assign({ default_names: workbenches.map((workbench) => `${workbench} Job`), show_clusters: ShowClusterType.NonInteractive, show_workbenches: false, workbenches }, viewState.input), { launch_spec: viewState.launchSpec || null });
        viewState.input = launcherInput;
        const launcherUiOptions = Object.assign(Object.assign(Object.assign({}, interface_1.DEFAULT_LAUNCHER_UI_OPTIONS), { job_name_label: "Job Name", job_name_placeholder: "New Job", table_layout: true }), viewState.uiOptions);
        viewState.uiOptions = launcherUiOptions;
        const launcher = new LauncherUI(launcherUiEl, () => {
            return new Promise((resolve) => {
                const infoListener = (event) => {
                    const { type, message } = event.data;
                    if (type !== "get_info") {
                        return;
                    }
                    // only want this to trigger once, so remove it once
                    // we receive the info that we requested
                    window.removeEventListener("message", infoListener);
                    resolve(message);
                };
                window.addEventListener("message", infoListener);
                vscode.postMessage({ event: "get_info" });
            });
        }, launcherInput, launcherUiOptions);
        const saveState = () => {
            viewState.launchSpec = launcher.getLaunchSpec();
            viewState.jobOptions = Object.assign({}, jobOptions);
            viewState.userModified = Object.assign({}, userModified);
            viewState.outputArgs = outputArgs.map((args) => args.map((arg) => {
                return Object.assign({}, arg);
            }));
            showPathWarning();
            vscode.setState(Object.assign({}, viewState));
            const valid = validateState(viewState);
            startButton.classList.toggle("disabled", !valid);
            return valid;
        };
        launcher.setOnLaunchSpecModified(() => {
            sizeToContent(launcherUiEl);
            saveState();
        });
        launcher.setOnUiRender(() => {
            var _a;
            resetSize(launcherUiEl);
            sizeToContent(launcherUiEl, true);
            // hack in the default name if the user has already changed it
            if ((_a = launcherInput.launch_spec) === null || _a === void 0 ? void 0 : _a.name) {
                launcher.setJobName(launcherInput.launch_spec.name);
                // just setting the job name won't trigger a save -- have to trigger it manually
                saveState();
            }
            setCurrentScript(jobOptions.script);
            // Add a keydown handler that prevents the form element from submitting itself (Enter key).
            // We don't want to allow this in this UI, which only allows submission through a direct
            // interaction with the submit button
            const formEl = launcherUiEl.querySelector("form.form-horizontal");
            formEl.addEventListener("keydown", (evt) => {
                if (evt.key === "Enter") {
                    evt.preventDefault();
                }
            });
            // add an event listener to the job name field so that we can store it's state immediately
            // following any user changes to it.
            const jobNameEl = launcherUiEl.querySelector("#rstudio_label_job_name");
            jobNameEl.addEventListener("change", () => {
                saveState();
            });
        });
        launcher.initialize();
        // ---- Wire up the other fields ----
        const activeFileInit = document.head.querySelector('meta[name="active-file"]').getAttribute("content");
        const outputArgs = viewState.outputArgs || [];
        const jobOptions = Object.assign({ script: (0, languages_1.validScriptExtension)(activeFileInit || "") ? activeFileInit : "", workDir: "", args: [] }, viewState.jobOptions);
        const userModified = Object.assign({}, viewState.userModified);
        const scriptOptionsEl = document.getElementById("script-options");
        resetSize(scriptOptionsEl);
        sizeToContent(scriptOptionsEl, true, -4);
        const showPathWarning = () => {
            var _a, _b, _c;
            // id comes from a placeholder added by version selector builder
            const warningEl = document.getElementById("version-path-warning");
            // if there is no version selector available, then bail immediately
            if (!warningEl) {
                return;
            }
            // show a path warning if the cluster is set to non-local and the user
            // selects an R version that is anything other than (System Default)
            // TODO: compare image name of the current k8s session (if applicable) for improved
            // warning accuracy, as the IDE does. Right now we don't have access to this information
            const version = ((_a = outputArgs.flat().find((arg) => { var _a; return (_a = arg.name) === null || _a === void 0 ? void 0 : _a.endsWith("-version"); })) === null || _a === void 0 ? void 0 : _a.value) || "(System Default)";
            if (((_b = viewState.launchSpec) === null || _b === void 0 ? void 0 : _b.cluster) !== "Local" && version !== "(System Default)") {
                warningEl.textContent = `Ensure version selection "${version}" exists in "${(_c = viewState.launchSpec) === null || _c === void 0 ? void 0 : _c.cluster}"`;
                warningEl.style.display = "";
            }
            else {
                warningEl.style.display = "none";
            }
            sizeToContent(scriptOptionsEl, false, -4);
        };
        const setCurrentScript = (path = "New Workbench Job") => {
            var _a, _b;
            if (!(0, languages_1.validScriptExtension)(path)) {
                return;
            }
            // only auto-update the name if the user has not modified it
            if (!((_a = viewState.launchSpec) === null || _a === void 0 ? void 0 : _a.name) || ((_b = viewState.launchSpec) === null || _b === void 0 ? void 0 : _b.name) === launcherInput.default_names[0]) {
                launcher.setJobName((0, languages_1.getScriptName)(path));
            }
            scriptPathInputEl.textContent = path;
            scriptPathInputEl.dispatchEvent(new Event("change"));
            const currentLanguage = (0, languages_1.detectFileType)(jobOptions.script);
            jobOptions.script = path;
            saveState();
            const language = (0, languages_1.detectFileType)(path);
            // clear args if it is a different language type
            if ((currentLanguage === null || currentLanguage === void 0 ? void 0 : currentLanguage.ext) !== (language === null || language === void 0 ? void 0 : language.ext)) {
                outputArgs.splice(0);
                jobOptions.args = [];
            }
            scriptPathInputEl.dataset.lang = (language === null || language === void 0 ? void 0 : language.ext) || "";
            const gridFormEl = document.getElementById("form-grid");
            const separatorEl = document.getElementById("arg-list");
            (0, languages_1.clearAfter)(gridFormEl, separatorEl);
            // unrecognized languages should not display r-version selector
            // or generic arguments list. Still resize in case there was
            // previously content which affected the height of the container
            if (!language) {
                sizeToContent(scriptOptionsEl, false, -4);
                return;
            }
            const messageId = ++mid;
            const scriptInfoListener = (event) => {
                const { type, id, message } = event.data;
                // message id must match, otherwise this may have come from a
                // different get_info_for_script event (unlikely)
                if (type !== "get_info_for_script" || id !== messageId) {
                    return;
                }
                window.removeEventListener("message", scriptInfoListener);
                let versionArgs = [];
                let scriptArgs = [];
                if (message) {
                    try {
                        const args = JSON.parse(message);
                        if (args.versionInfo) {
                            versionArgs = args.versionInfo;
                        }
                        if (args.scriptArgs) {
                            scriptArgs = args.scriptArgs;
                        }
                        if (!userModified.workDir && typeof args.workingDirectory === "string") {
                            jobOptions.workDir = args.workingDirectory;
                            workdirPathInputEl.textContent = jobOptions.workDir;
                        }
                    }
                    catch (_) {
                        /* do nothing */
                    }
                }
                const valuesOnly = (args) => {
                    return args.map((arg) => {
                        return { value: `${(arg.name || "").trim()} ${(arg.value || "").trim()}`.trim() };
                    });
                };
                // defaults can be modified by the render functions
                // to strip out already-consumed arguments
                const defaultArgs = [versionArgs.slice(), valuesOnly(scriptArgs)];
                for (let a = 0; a < language.controls.length; a++) {
                    const control = language.controls[a];
                    HTMLElement.prototype.append.apply(gridFormEl, control.render({
                        currents: (outputArgs[a] || defaultArgs[a]).map((arg) => {
                            return Object.assign({}, arg);
                        }),
                        defaults: defaultArgs[a],
                        set: (args) => {
                            outputArgs[a] = args;
                            jobOptions.args = outputArgs.flat();
                            sizeToContent(scriptOptionsEl, false, -4);
                            saveState();
                        }
                    }));
                    document.querySelectorAll("#py-version-selector,#r-version-selector").forEach((el) => {
                        if (!el.dataset.tomselectInitialized) {
                            new tom_select_1.default("#py-version-selector,#r-version-selector", {
                                itemClass: "form-control",
                                render: {
                                    item: function (data, escape) {
                                        return "<div>" + escape(data.text) + "</div>";
                                    },
                                    option: function (data, escape) {
                                        const path = data.$option.dataset.path;
                                        const venv = data.$option.dataset.venv;
                                        const meta = data.$option.dataset.language === "python" ? ` (${venv !== null && venv !== void 0 ? venv : "Global"})` : "";
                                        return `<div><div>${escape(data.text)}${meta}</div><div>${path !== null && path !== void 0 ? path : ""}</div></div>`;
                                    }
                                }
                            });
                            // Mark the element as initialized
                            el.dataset.tomselectInitialized = "true";
                        }
                    });
                }
                sizeToContent(scriptOptionsEl, false, -4);
            };
            window.addEventListener("message", scriptInfoListener);
            vscode.postMessage({ event: "get_info_for_script", id: messageId, ext: language.ext, script: jobOptions.script });
        };
        const scriptPathInputEl = document.getElementById("launcher-script-path");
        const scriptPathBrowseEl = document.getElementById("launcher-browse-script-path");
        const workdirPathInputEl = document.getElementById("launcher-workdir-path");
        workdirPathInputEl.textContent = jobOptions.workDir;
        const workdirPathBrowseEl = document.getElementById("launcher-browse-workdir-path");
        const browseHandler = (targetEl, keyName, directory = false) => {
            return () => {
                handleOnBrowse(directory, (event) => {
                    const { message } = event.data;
                    targetEl.textContent = message;
                    userModified[keyName] = true;
                    targetEl.dispatchEvent(new Event("change"));
                    if (keyName !== "script") {
                        jobOptions[keyName] = message;
                        saveState();
                        return;
                    }
                    setCurrentScript(message);
                });
            };
        };
        scriptPathInputEl.addEventListener("click", browseHandler(scriptPathInputEl, "script"));
        scriptPathBrowseEl.addEventListener("click", browseHandler(scriptPathInputEl, "script"));
        workdirPathInputEl.addEventListener("click", browseHandler(workdirPathInputEl, "workDir", true));
        workdirPathBrowseEl.addEventListener("click", browseHandler(workdirPathInputEl, "workDir", true));
        window.addEventListener("message", (event) => {
            const { type, message: path } = event.data;
            if (type !== "active_file") {
                return;
            }
            if (!(0, languages_1.validScriptExtension)(path)) {
                return;
            }
            // this means the user has not changed the file manually, so we
            // can update the script path without overwriting their choice
            if (!userModified.script) {
                setCurrentScript(path);
            }
        });
        // Wire up the managed credentials input.
        const managedCreds = new credentials_1.ManagedCredentialsInput((enabled) => {
            jobOptions.managedCredentialsEnabled = enabled;
            saveState();
        });
        // Handle managed credentials messages (both during initialization and at
        // runtime when settings change).
        window.addEventListener("message", (event) => {
            if (event.data.type !== "managed_credentials") {
                return;
            }
            managedCreds.enable(event.data.enabled);
        });
        startButton.addEventListener("click", () => {
            const valid = saveState();
            if (!valid) {
                return;
            }
            // Add script name to end of arguments
            const ext = (0, languages_1.extension)(jobOptions.script);
            if (ext === languages_1.R) {
                jobOptions.args.push({ name: "-f", value: jobOptions.script });
            }
            else if (ext === languages_1.PYTHON) {
                jobOptions.args.push({ value: jobOptions.script });
            }
            vscode.postMessage({
                event: "launch",
                launchSpec: Object.assign({}, viewState.launchSpec),
                jobOptions: Object.assign({}, viewState.jobOptions)
            });
        });
    }
    catch (err) {
        mainEl.classList.toggle("error", true);
        console.error(err);
        const errorEl = document.getElementById("error");
        errorEl.textContent = "There was an error initializing the job launcher";
    }
}
//# sourceMappingURL=data:application/json;base64,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