/**
 * Kallichore API
 * Kallichore is a Jupyter kernel gateway and supervisor
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: info@posit.co
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

import { RequestFile } from './models';
import { ExecutionQueue } from './executionQueue';
import { InterruptMode } from './interruptMode';
import { Status } from './status';

export class ActiveSession {
    /**
    * A unique identifier for the session
    */
    'sessionId': string;
    /**
    * The program and command-line parameters for the session
    */
    'argv': Array<string>;
    /**
    * The underlying process ID of the session, if the session is running.
    */
    'processId'?: number;
    /**
    * The username of the user who owns the session
    */
    'username': string;
    /**
    * A human-readable name for the session
    */
    'displayName': string;
    /**
    * The interpreter language
    */
    'language': string;
    'interruptMode': InterruptMode;
    /**
    * The environment variables set when the session was started
    */
    'initialEnv'?: { [key: string]: string; };
    /**
    * Whether the session is connected to a client
    */
    'connected': boolean;
    /**
    * An ISO 8601 timestamp of when the session was started
    */
    'started': Date;
    /**
    * The session\'s current working directory
    */
    'workingDirectory': string;
    /**
    * The text to use to prompt for input
    */
    'inputPrompt': string;
    /**
    * The text to use to prompt for input continuations
    */
    'continuationPrompt': string;
    'executionQueue': ExecutionQueue;
    'status': Status;
    /**
    * The number of seconds the session has been idle, or 0 if the session is busy
    */
    'idleSeconds': number;
    /**
    * The number of seconds the session has been busy, or 0 if the session is idle
    */
    'busySeconds': number;

    static discriminator: string | undefined = undefined;

    static attributeTypeMap: Array<{name: string, baseName: string, type: string}> = [
        {
            "name": "sessionId",
            "baseName": "session_id",
            "type": "string"
        },
        {
            "name": "argv",
            "baseName": "argv",
            "type": "Array<string>"
        },
        {
            "name": "processId",
            "baseName": "process_id",
            "type": "number"
        },
        {
            "name": "username",
            "baseName": "username",
            "type": "string"
        },
        {
            "name": "displayName",
            "baseName": "display_name",
            "type": "string"
        },
        {
            "name": "language",
            "baseName": "language",
            "type": "string"
        },
        {
            "name": "interruptMode",
            "baseName": "interrupt_mode",
            "type": "InterruptMode"
        },
        {
            "name": "initialEnv",
            "baseName": "initial_env",
            "type": "{ [key: string]: string; }"
        },
        {
            "name": "connected",
            "baseName": "connected",
            "type": "boolean"
        },
        {
            "name": "started",
            "baseName": "started",
            "type": "Date"
        },
        {
            "name": "workingDirectory",
            "baseName": "working_directory",
            "type": "string"
        },
        {
            "name": "inputPrompt",
            "baseName": "input_prompt",
            "type": "string"
        },
        {
            "name": "continuationPrompt",
            "baseName": "continuation_prompt",
            "type": "string"
        },
        {
            "name": "executionQueue",
            "baseName": "execution_queue",
            "type": "ExecutionQueue"
        },
        {
            "name": "status",
            "baseName": "status",
            "type": "Status"
        },
        {
            "name": "idleSeconds",
            "baseName": "idle_seconds",
            "type": "number"
        },
        {
            "name": "busySeconds",
            "baseName": "busy_seconds",
            "type": "number"
        }    ];

    static getAttributeTypeMap() {
        return ActiveSession.attributeTypeMap;
    }
}

export namespace ActiveSession {
}
