#!/usr/bin/env bash
# This script manages RStudio's JupyterLab environment

set -e

export RSW_JLAB_EXT_VERSION=1.0.1
export RSW_JLAB_EXT_NAME="jupyterlab_rsw"

echoInstallWarning() {
   echo "WARNING An RStudio Workbench Extension has been developed for JupyterLab. To install the extension, run the following command from wherever sessions will run. Be careful to use the version of pip used by the Jupyter environment configured in $configFile, and you most likely must run the command with sudo:
   sudo pip install ${RSW_JLAB_EXT_NAME}"
}

newExtensionNotification() {
   # load and parse jupyter config file
   configDirs="$XDG_CONFIG_DIRS:/etc"
   IFS=':' read -ra configDirList <<< "$configDirs"
   for configDir in "${configDirList[@]}"
   do
      if test -e "$configDir/rstudio/jupyter.conf"
      then
         configFile="$configDir/rstudio/jupyter.conf"
         break
      fi
   done
   
   # exit if Jupyter is not configured
   if [ ! -f "$configFile" ]; then
      exit 0
   fi
   
   # exit if JupyterLab not enabled
   jlab_enabled=$(grep labs-enabled $configFile | sed 's/.*\(labs-enabled=\)\(.[^ ]*\).*/\2/')
   if [[ -z ${jlab_enabled} || ${jlab_enabled} != 1 ]]; then
      exit 0
   fi
   
   # locate the jupyter executable
   exe=$(grep exe $configFile | sed 's/.*\(exe=\)\(.[^ ]*\).*/\2/')
   if [[ -z $exe ]]; then
      exe='/usr/local/bin/jupyter' # use default value 
   fi
   
   # the executable may not exist here, but since JupyterLab is enabled we still display the warning
   if [ ! -f "$exe" ]; then
      echoInstallWarning
      exit 0
   fi
   
   if [ "$(echo $(${exe} labextension list 2>&1) | grep -c ${RSW_JLAB_EXT_NAME})" -lt 1 ]; then
      echoInstallWarning
      exit 0
   fi
}

