import { mapEntries } from "./map_entries.ts";
export function aggregateGroups(record, aggregator) {
    return mapEntries(record, ([key, values]) => [
        key,
        values.reduce((accumulator, current, currentIndex) => aggregator(current, key, currentIndex === 0, accumulator), undefined),
    ]);
}
//# sourceMappingURL=data:application/json;base64,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