// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
import { load, loadAll } from "./_loader/loader.ts";
import { replaceSchemaNameWithSchemaClass } from "./mod.ts";
/**
 * Parse `content` as single YAML document, and return it.
 *
 * This function does not support regexps, functions, and undefined by default.
 * This method is safe for parsing untrusted data.
 *
 * @example Usage
 * ```ts
 * import { parse } from "@std/yaml/parse";
 * import { assertEquals } from "@std/assert/assert-equals";
 *
 * const data = parse(`
 * id: 1
 * name: Alice
 * `);
 *
 * assertEquals(data, { id: 1, name: "Alice" });
 * ```
 *
 * @throws {YAMLError} Throws error on invalid YAML.
 * @param content YAML string to parse.
 * @param options Parsing options.
 * @returns Parsed document.
 */ export function parse(content, options) {
  replaceSchemaNameWithSchemaClass(options);
  // deno-lint-ignore no-explicit-any
  return load(content, options);
}
export function parseAll(content, iteratorOrOption, options) {
  if (typeof iteratorOrOption !== "function") {
    replaceSchemaNameWithSchemaClass(iteratorOrOption);
  }
  replaceSchemaNameWithSchemaClass(options);
  // deno-lint-ignore no-explicit-any
  return loadAll(content, iteratorOrOption, options);
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=4156805269937947409,15147022962456431822