// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
/** Get log level numeric values through enum constants */ export var LogLevels;
(function(LogLevels) {
    LogLevels[LogLevels["NOTSET"] = 0] = "NOTSET";
    LogLevels[LogLevels["DEBUG"] = 10] = "DEBUG";
    LogLevels[LogLevels["INFO"] = 20] = "INFO";
    LogLevels[LogLevels["WARNING"] = 30] = "WARNING";
    LogLevels[LogLevels["ERROR"] = 40] = "ERROR";
    LogLevels[LogLevels["CRITICAL"] = 50] = "CRITICAL";
})(LogLevels || (LogLevels = {}));
/** Permitted log level names */ export const LogLevelNames = Object.keys(LogLevels).filter((key)=>isNaN(Number(key)));
const byLevel = {
    [String(LogLevels.NOTSET)]: "NOTSET",
    [String(LogLevels.DEBUG)]: "DEBUG",
    [String(LogLevels.INFO)]: "INFO",
    [String(LogLevels.WARNING)]: "WARNING",
    [String(LogLevels.ERROR)]: "ERROR",
    [String(LogLevels.CRITICAL)]: "CRITICAL"
};
/** Returns the numeric log level associated with the passed,
 * stringy log level name.
 */ export function getLevelByName(name) {
    switch(name){
        case "NOTSET":
            return LogLevels.NOTSET;
        case "DEBUG":
            return LogLevels.DEBUG;
        case "INFO":
            return LogLevels.INFO;
        case "WARNING":
            return LogLevels.WARNING;
        case "ERROR":
            return LogLevels.ERROR;
        case "CRITICAL":
            return LogLevels.CRITICAL;
        default:
            throw new Error(`no log level found for "${name}"`);
    }
}
/** Returns the stringy log level name provided the numeric log level */ export function getLevelName(level) {
    const levelName = byLevel[level];
    if (levelName) {
        return levelName;
    }
    throw new Error(`no level name found for level: ${level}`);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjE1My4wL2xvZy9sZXZlbHMudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTgtMjAyMiB0aGUgRGVubyBhdXRob3JzLiBBbGwgcmlnaHRzIHJlc2VydmVkLiBNSVQgbGljZW5zZS5cbi8vIFRoaXMgbW9kdWxlIGlzIGJyb3dzZXIgY29tcGF0aWJsZS5cblxuLyoqIEdldCBsb2cgbGV2ZWwgbnVtZXJpYyB2YWx1ZXMgdGhyb3VnaCBlbnVtIGNvbnN0YW50cyAqL1xuZXhwb3J0IGVudW0gTG9nTGV2ZWxzIHtcbiAgTk9UU0VUID0gMCxcbiAgREVCVUcgPSAxMCxcbiAgSU5GTyA9IDIwLFxuICBXQVJOSU5HID0gMzAsXG4gIEVSUk9SID0gNDAsXG4gIENSSVRJQ0FMID0gNTAsXG59XG5cbi8qKiBQZXJtaXR0ZWQgbG9nIGxldmVsIG5hbWVzICovXG5leHBvcnQgY29uc3QgTG9nTGV2ZWxOYW1lcyA9IE9iamVjdC5rZXlzKExvZ0xldmVscykuZmlsdGVyKChrZXkpID0+XG4gIGlzTmFOKE51bWJlcihrZXkpKVxuKTtcblxuLyoqIFVuaW9uIG9mIHZhbGlkIGxvZyBsZXZlbCBzdHJpbmdzICovXG5leHBvcnQgdHlwZSBMZXZlbE5hbWUgPSBrZXlvZiB0eXBlb2YgTG9nTGV2ZWxzO1xuXG5jb25zdCBieUxldmVsOiBSZWNvcmQ8c3RyaW5nLCBMZXZlbE5hbWU+ID0ge1xuICBbU3RyaW5nKExvZ0xldmVscy5OT1RTRVQpXTogXCJOT1RTRVRcIixcbiAgW1N0cmluZyhMb2dMZXZlbHMuREVCVUcpXTogXCJERUJVR1wiLFxuICBbU3RyaW5nKExvZ0xldmVscy5JTkZPKV06IFwiSU5GT1wiLFxuICBbU3RyaW5nKExvZ0xldmVscy5XQVJOSU5HKV06IFwiV0FSTklOR1wiLFxuICBbU3RyaW5nKExvZ0xldmVscy5FUlJPUildOiBcIkVSUk9SXCIsXG4gIFtTdHJpbmcoTG9nTGV2ZWxzLkNSSVRJQ0FMKV06IFwiQ1JJVElDQUxcIixcbn07XG5cbi8qKiBSZXR1cm5zIHRoZSBudW1lcmljIGxvZyBsZXZlbCBhc3NvY2lhdGVkIHdpdGggdGhlIHBhc3NlZCxcbiAqIHN0cmluZ3kgbG9nIGxldmVsIG5hbWUuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBnZXRMZXZlbEJ5TmFtZShuYW1lOiBMZXZlbE5hbWUpOiBudW1iZXIge1xuICBzd2l0Y2ggKG5hbWUpIHtcbiAgICBjYXNlIFwiTk9UU0VUXCI6XG4gICAgICByZXR1cm4gTG9nTGV2ZWxzLk5PVFNFVDtcbiAgICBjYXNlIFwiREVCVUdcIjpcbiAgICAgIHJldHVybiBMb2dMZXZlbHMuREVCVUc7XG4gICAgY2FzZSBcIklORk9cIjpcbiAgICAgIHJldHVybiBMb2dMZXZlbHMuSU5GTztcbiAgICBjYXNlIFwiV0FSTklOR1wiOlxuICAgICAgcmV0dXJuIExvZ0xldmVscy5XQVJOSU5HO1xuICAgIGNhc2UgXCJFUlJPUlwiOlxuICAgICAgcmV0dXJuIExvZ0xldmVscy5FUlJPUjtcbiAgICBjYXNlIFwiQ1JJVElDQUxcIjpcbiAgICAgIHJldHVybiBMb2dMZXZlbHMuQ1JJVElDQUw7XG4gICAgZGVmYXVsdDpcbiAgICAgIHRocm93IG5ldyBFcnJvcihgbm8gbG9nIGxldmVsIGZvdW5kIGZvciBcIiR7bmFtZX1cImApO1xuICB9XG59XG5cbi8qKiBSZXR1cm5zIHRoZSBzdHJpbmd5IGxvZyBsZXZlbCBuYW1lIHByb3ZpZGVkIHRoZSBudW1lcmljIGxvZyBsZXZlbCAqL1xuZXhwb3J0IGZ1bmN0aW9uIGdldExldmVsTmFtZShsZXZlbDogbnVtYmVyKTogTGV2ZWxOYW1lIHtcbiAgY29uc3QgbGV2ZWxOYW1lID0gYnlMZXZlbFtsZXZlbF07XG4gIGlmIChsZXZlbE5hbWUpIHtcbiAgICByZXR1cm4gbGV2ZWxOYW1lO1xuICB9XG4gIHRocm93IG5ldyBFcnJvcihgbm8gbGV2ZWwgbmFtZSBmb3VuZCBmb3IgbGV2ZWw6ICR7bGV2ZWx9YCk7XG59XG4iXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsMEVBQTBFO0FBQzFFLHFDQUFxQztBQUVyQyx3REFBd0QsR0FDeEQsV0FBTyxTQU9OO1VBUFcsU0FBUztJQUFULFNBQVMsQ0FBVCxTQUFTLENBQ25CLFFBQU0sSUFBRyxDQUFDLElBQVYsUUFBTTtJQURJLFNBQVMsQ0FBVCxTQUFTLENBRW5CLE9BQUssSUFBRyxFQUFFLElBQVYsT0FBSztJQUZLLFNBQVMsQ0FBVCxTQUFTLENBR25CLE1BQUksSUFBRyxFQUFFLElBQVQsTUFBSTtJQUhNLFNBQVMsQ0FBVCxTQUFTLENBSW5CLFNBQU8sSUFBRyxFQUFFLElBQVosU0FBTztJQUpHLFNBQVMsQ0FBVCxTQUFTLENBS25CLE9BQUssSUFBRyxFQUFFLElBQVYsT0FBSztJQUxLLFNBQVMsQ0FBVCxTQUFTLENBTW5CLFVBQVEsSUFBRyxFQUFFLElBQWIsVUFBUTtHQU5FLFNBQVMsS0FBVCxTQUFTO0FBU3JCLDhCQUE4QixHQUM5QixPQUFPLE1BQU0sYUFBYSxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsR0FBRyxHQUM3RCxLQUFLLENBQUMsTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQ25CLENBQUM7QUFLRixNQUFNLE9BQU8sR0FBOEI7SUFDekMsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDLEVBQUUsUUFBUTtJQUNwQyxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxPQUFPO0lBQ2xDLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxFQUFFLE1BQU07SUFDaEMsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDLEVBQUUsU0FBUztJQUN0QyxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsRUFBRSxPQUFPO0lBQ2xDLENBQUMsTUFBTSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsQ0FBQyxFQUFFLFVBQVU7Q0FDekMsQUFBQztBQUVGOztDQUVDLEdBQ0QsT0FBTyxTQUFTLGNBQWMsQ0FBQyxJQUFlLEVBQVU7SUFDdEQsT0FBUSxJQUFJO1FBQ1YsS0FBSyxRQUFRO1lBQ1gsT0FBTyxTQUFTLENBQUMsTUFBTSxDQUFDO1FBQzFCLEtBQUssT0FBTztZQUNWLE9BQU8sU0FBUyxDQUFDLEtBQUssQ0FBQztRQUN6QixLQUFLLE1BQU07WUFDVCxPQUFPLFNBQVMsQ0FBQyxJQUFJLENBQUM7UUFDeEIsS0FBSyxTQUFTO1lBQ1osT0FBTyxTQUFTLENBQUMsT0FBTyxDQUFDO1FBQzNCLEtBQUssT0FBTztZQUNWLE9BQU8sU0FBUyxDQUFDLEtBQUssQ0FBQztRQUN6QixLQUFLLFVBQVU7WUFDYixPQUFPLFNBQVMsQ0FBQyxRQUFRLENBQUM7UUFDNUI7WUFDRSxNQUFNLElBQUksS0FBSyxDQUFDLENBQUMsd0JBQXdCLEVBQUUsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDdkQ7QUFDSCxDQUFDO0FBRUQsc0VBQXNFLEdBQ3RFLE9BQU8sU0FBUyxZQUFZLENBQUMsS0FBYSxFQUFhO0lBQ3JELE1BQU0sU0FBUyxHQUFHLE9BQU8sQ0FBQyxLQUFLLENBQUMsQUFBQztJQUNqQyxJQUFJLFNBQVMsRUFBRTtRQUNiLE9BQU8sU0FBUyxDQUFDO0lBQ25CLENBQUM7SUFDRCxNQUFNLElBQUksS0FBSyxDQUFDLENBQUMsK0JBQStCLEVBQUUsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzdELENBQUMifQ==