export function bytesToUuid(bytes) {
    const bits = [...bytes].map((bit) => {
        const s = bit.toString(16);
        return bit < 0x10 ? "0" + s : s;
    });
    return [
        ...bits.slice(0, 4),
        "-",
        ...bits.slice(4, 6),
        "-",
        ...bits.slice(6, 8),
        "-",
        ...bits.slice(8, 10),
        "-",
        ...bits.slice(10, 16),
    ].join("");
}
export function uuidToBytes(uuid) {
    const bytes = [];
    uuid.replace(/[a-fA-F0-9]{2}/g, (hex) => {
        bytes.push(parseInt(hex, 16));
        return "";
    });
    return bytes;
}
export function stringToBytes(str) {
    str = unescape(encodeURIComponent(str));
    const bytes = Array.from({ length: str.length });
    for (let i = 0; i < str.length; i++) {
        bytes[i] = str.charCodeAt(i);
    }
    return bytes;
}
export function createBuffer(content) {
    const arrayBuffer = new ArrayBuffer(content.length);
    const uint8Array = new Uint8Array(arrayBuffer);
    for (let i = 0; i < content.length; i++) {
        uint8Array[i] = content[i];
    }
    return arrayBuffer;
}
//# sourceMappingURL=data:application/json;base64,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