define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom","ace/config","ace/lib/useragent"],function(e,t,n){"use strict";var r=e("../virtual_renderer").VirtualRenderer,i=e("../editor").Editor,s=e("../range").Range,o=e("../lib/event"),u=e("../lib/lang"),a=e("../lib/dom"),f=e("../config").nls,l=e("./../lib/useragent"),c=function(e){return"suggest-aria-id:".concat(e)},h=l.isSafari?"menu":"listbox",p=l.isSafari?"menuitem":"option",d=l.isSafari?"aria-current":"aria-selected",v=function(e){var t=new r(e);t.$maxLines=4;var n=new i(t);return n.setHighlightActiveLine(!1),n.setShowPrintMargin(!1),n.renderer.setShowGutter(!1),n.renderer.setHighlightGutterLine(!1),n.$mouseHandler.$focusTimeout=0,n.$highlightTagPending=!0,n},m=function(){function e(e){var t=a.createElement("div"),n=v(t);e&&e.appendChild(t),t.style.display="none",n.renderer.content.style.cursor="default",n.renderer.setStyle("ace_autocomplete"),n.renderer.$textLayer.element.setAttribute("role",h),n.renderer.$textLayer.element.setAttribute("aria-roledescription",f("Autocomplete suggestions")),n.renderer.$textLayer.element.setAttribute("aria-label",f("Autocomplete suggestions")),n.renderer.textarea.setAttribute("aria-hidden","true"),n.setOption("displayIndentGuides",!1),n.setOption("dragDelay",150);var r=function(){};n.focus=r,n.$isFocused=!0,n.renderer.$cursorLayer.restartTimer=r,n.renderer.$cursorLayer.element.style.opacity="0",n.renderer.$maxLines=8,n.renderer.$keepTextAreaAtCursor=!1,n.setHighlightActiveLine(!1),n.session.highlight(""),n.session.$searchHighlight.clazz="ace_highlight-marker",n.on("mousedown",function(e){var t=e.getDocumentPosition();n.selection.moveToPosition(t),m.start.row=m.end.row=t.row,e.stop()});var i,l=new s(-1,0,-1,Infinity),m=new s(-1,0,-1,Infinity);m.id=n.session.addMarker(m,"ace_active-line","fullLine"),n.setSelectOnHover=function(e){e?l.id&&(n.session.removeMarker(l.id),l.id=null):l.id=n.session.addMarker(l,"ace_line-hover","fullLine")},n.setSelectOnHover(!1),n.on("mousemove",function(e){if(!i){i=e;return}if(i.x==e.x&&i.y==e.y)return;i=e,i.scrollTop=n.renderer.scrollTop,n.isMouseOver=!0;var t=i.getDocumentPosition().row;l.start.row!=t&&(l.id||n.setRow(t),y(t))}),n.renderer.on("beforeRender",function(){if(i&&l.start.row!=-1){i.$pos=null;var e=i.getDocumentPosition().row;l.id||n.setRow(e),y(e,!0)}}),n.renderer.on("afterRender",function(){var e=n.getRow(),t=n.renderer.$textLayer,r=t.element.childNodes[e-t.config.firstRow],i=document.activeElement;r!==n.selectedNode&&n.selectedNode&&(a.removeCssClass(n.selectedNode,"ace_selected"),i.removeAttribute("aria-activedescendant"),n.selectedNode.removeAttribute(d),n.selectedNode.removeAttribute("id")),n.selectedNode=r;if(r){a.addCssClass(r,"ace_selected");var s=c(e);r.id=s,t.element.setAttribute("aria-activedescendant",s),i.setAttribute("aria-activedescendant",s),r.setAttribute("role",p),r.setAttribute("aria-roledescription",f("item")),r.setAttribute("aria-label",n.getData(e).caption||n.getData(e).value),r.setAttribute("aria-setsize",n.data.length),r.setAttribute("aria-posinset",e+1),r.setAttribute("aria-describedby","doc-tooltip"),r.setAttribute(d,"true")}});var g=function(){y(-1)},y=function(e,t){e!==l.start.row&&(l.start.row=l.end.row=e,t||n.session._emit("changeBackMarker"),n._emit("changeHoverMarker"))};n.getHoveredRow=function(){return l.start.row},o.addListener(n.container,"mouseout",function(){n.isMouseOver=!1,g()}),n.on("hide",g),n.on("changeSelection",g),n.session.doc.getLength=function(){return n.data.length},n.session.doc.getLine=function(e){var t=n.data[e];return typeof t=="string"?t:t&&t.value||""};var b=n.session.bgTokenizer;return b.$tokenizeRow=function(e){function s(e,n){e&&r.push({type:(t.className||"")+(n||""),value:e})}var t=n.data[e],r=[];if(!t)return r;typeof t=="string"&&(t={value:t});var i=t.caption||t.value||t.name,o=i.toLowerCase(),u=(n.filterText||"").toLowerCase(),a=0,f=0;for(var l=0;l<=u.length;l++)if(l!=f&&(t.matchMask&1<<l||l==u.length)){var c=u.slice(f,l);f=l;var h=o.indexOf(c,a);if(h==-1)continue;s(i.slice(a,h),""),a=h+c.length,s(i.slice(h,a),"completion-highlight")}return s(i.slice(a,i.length),""),r.push({type:"completion-spacer",value:" "}),t.meta&&r.push({type:"completion-meta",value:t.meta}),t.message&&r.push({type:"completion-message",value:t.message}),r},b.$updateOnChange=r,b.start=r,n.session.$computeWidth=function(){return this.screenWidth=0},n.isOpen=!1,n.isTopdown=!1,n.autoSelect=!0,n.filterText="",n.isMouseOver=!1,n.data=[],n.setData=function(e,t){n.filterText=t||"",n.setValue(u.stringRepeat("\n",e.length),-1),n.data=e||[],n.setRow(0)},n.getData=function(e){return n.data[e]},n.getRow=function(){return m.start.row},n.setRow=function(e){e=Math.max(this.autoSelect?0:-1,Math.min(this.data.length-1,e)),m.start.row!=e&&(n.selection.clearSelection(),m.start.row=m.end.row=e||0,n.session._emit("changeBackMarker"),n.moveCursorTo(e||0,0),n.isOpen&&n._signal("select"))},n.on("changeSelection",function(){n.isOpen&&n.setRow(n.selection.lead.row),n.renderer.scrollCursorIntoView()}),n.hide=function(){this.container.style.display="none",n.anchorPos=null,n.anchor=null,n.isOpen&&(n.isOpen=!1,this._signal("hide"))},n.tryShow=function(e,t,r,s){if(!s&&n.isOpen&&n.anchorPos&&n.anchor&&n.anchorPos.top===e.top&&n.anchorPos.left===e.left&&n.anchor===r)return!0;var o=this.container,u=window.innerHeight,a=window.innerWidth,f=this.renderer,l=f.$maxLines*t*1.4,c={top:0,bottom:0,left:0},h=u-e.top-3*this.$borderSize-t,p=e.top-3*this.$borderSize;r||(p<=h||h>=l?r="bottom":r="top"),r==="top"?(c.bottom=e.top-this.$borderSize,c.top=c.bottom-l):r==="bottom"&&(c.top=e.top+t+this.$borderSize,c.bottom=c.top+l);var d=c.top>=0&&c.bottom<=u;if(!s&&!d)return!1;d?f.$maxPixelHeight=null:r==="top"?f.$maxPixelHeight=p:f.$maxPixelHeight=h,r==="top"?(o.style.top="",o.style.bottom=u-c.bottom+"px",n.isTopdown=!1):(o.style.top=c.top+"px",o.style.bottom="",n.isTopdown=!0),o.style.display="";var v=e.left;return v+o.offsetWidth>a&&(v=a-o.offsetWidth),o.style.left=v+"px",o.style.right="",n.isOpen||(n.isOpen=!0,this._signal("show"),i=null),n.anchorPos=e,n.anchor=r,!0},n.show=function(e,t,n){this.tryShow(e,t,n?"bottom":undefined,!0)},n.goTo=function(e){var t=this.getRow(),n=this.session.getLength()-1;switch(e){case"up":t=t<=0?n:t-1;break;case"down":t=t>=n?-1:t+1;break;case"start":t=0;break;case"end":t=n}this.setRow(t)},n.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},n.$imageSize=0,n.$borderSize=1,n}return e}();a.importCssString('\n.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #CAD6FA;\n    z-index: 1;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {\n    background-color: #3a674e;\n}\n.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid #abbffe;\n    margin-top: -1px;\n    background: rgba(233,233,253,0.4);\n    position: absolute;\n    z-index: 2;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {\n    border: 1px solid rgba(109, 150, 13, 0.8);\n    background: rgba(58, 103, 78, 0.62);\n}\n.ace_completion-meta {\n    opacity: 0.5;\n    margin-left: 0.9em;\n}\n.ace_completion-message {\n    margin-left: 0.9em;\n    color: blue;\n}\n.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #2d69c7;\n}\n.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{\n    color: #93ca12;\n}\n.ace_editor.ace_autocomplete {\n    width: 300px;\n    z-index: 200000;\n    border: 1px lightgray solid;\n    position: fixed;\n    box-shadow: 2px 3px 5px rgba(0,0,0,.2);\n    line-height: 1.4;\n    background: #fefefe;\n    color: #111;\n}\n.ace_dark.ace_editor.ace_autocomplete {\n    border: 1px #484747 solid;\n    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);\n    line-height: 1.4;\n    background: #25282c;\n    color: #c1c1c1;\n}\n.ace_autocomplete .ace_text-layer  {\n    width: calc(100% - 8px);\n}\n.ace_autocomplete .ace_line {\n    display: flex;\n    align-items: center;\n}\n.ace_autocomplete .ace_line > * {\n    min-width: 0;\n    flex: 0 0 auto;\n}\n.ace_autocomplete .ace_line .ace_ {\n    flex: 0 1 auto;\n    overflow: hidden;\n    white-space: nowrap;\n    text-overflow: ellipsis;\n}\n.ace_autocomplete .ace_completion-spacer {\n    flex: 1;\n}\n.ace_autocomplete.ace_loading:after  {\n    content: "";\n    position: absolute;\n    top: 0px;\n    height: 2px;\n    width: 8%;\n    background: blue;\n    z-index: 100;\n    animation: ace_progress 3s infinite linear;\n    animation-delay: 300ms;\n    transform: translateX(-100%) scaleX(1);\n}\n@keyframes ace_progress {\n    0% { transform: translateX(-100%) scaleX(1) }\n    50% { transform: translateX(625%) scaleX(2) } \n    100% { transform: translateX(1500%) scaleX(3) } \n}\n@media (prefers-reduced-motion) {\n    .ace_autocomplete.ace_loading:after {\n        transform: translateX(625%) scaleX(2);\n        animation: none;\n     }\n}\n',"autocompletion.css",!1),t.AcePopup=m,t.$singleLineEditor=v,t.getAriaId=c}),define("ace/autocomplete/inline_screenreader",["require","exports","module"],function(e,t,n){"use strict";var r=function(){function e(e){this.editor=e,this.screenReaderDiv=document.createElement("div"),this.screenReaderDiv.classList.add("ace_screenreader-only"),this.editor.container.appendChild(this.screenReaderDiv)}return e.prototype.setScreenReaderContent=function(e){!this.popup&&this.editor.completer&&this.editor.completer.popup&&(this.popup=this.editor.completer.popup,this.popup.renderer.on("afterRender",function(){var e=this.popup.getRow(),t=this.popup.renderer.$textLayer,n=t.element.childNodes[e-t.config.firstRow];if(n){var r="doc-tooltip ";for(var i=0;i<this._lines.length;i++)r+="ace-inline-screenreader-line-".concat(i," ");n.setAttribute("aria-describedby",r)}}.bind(this)));while(this.screenReaderDiv.firstChild)this.screenReaderDiv.removeChild(this.screenReaderDiv.firstChild);this._lines=e.split(/\r\n|\r|\n/);var t=this.createCodeBlock();this.screenReaderDiv.appendChild(t)},e.prototype.destroy=function(){this.screenReaderDiv.remove()},e.prototype.createCodeBlock=function(){var e=document.createElement("pre");e.setAttribute("id","ace-inline-screenreader");for(var t=0;t<this._lines.length;t++){var n=document.createElement("code");n.setAttribute("id","ace-inline-screenreader-line-".concat(t));var r=document.createTextNode(this._lines[t]);n.appendChild(r),e.appendChild(n)}return e},e}();t.AceInlineScreenReader=r}),define("ace/autocomplete/inline",["require","exports","module","ace/snippets","ace/autocomplete/inline_screenreader"],function(e,t,n){"use strict";var r=e("../snippets").snippetManager,i=e("./inline_screenreader").AceInlineScreenReader,s=function(){function e(){this.editor=null}return e.prototype.show=function(e,t,n){n=n||"",e&&this.editor&&this.editor!==e&&(this.hide(),this.editor=null,this.inlineScreenReader=null);if(!e||!t)return!1;this.inlineScreenReader||(this.inlineScreenReader=new i(e));var s=t.snippet?r.getDisplayTextForSnippet(e,t.snippet):t.value;return t.hideInlinePreview||!s||!s.startsWith(n)?!1:(this.editor=e,this.inlineScreenReader.setScreenReaderContent(s),s=s.slice(n.length),s===""?e.removeGhostText():e.setGhostText(s),!0)},e.prototype.isOpen=function(){return this.editor?!!this.editor.renderer.$ghostText:!1},e.prototype.hide=function(){return this.editor?(this.editor.removeGhostText(),!0):!1},e.prototype.destroy=function(){this.hide(),this.editor=null,this.inlineScreenReader&&(this.inlineScreenReader.destroy(),this.inlineScreenReader=null)},e}();t.AceInline=s}),define("ace/autocomplete/util",["require","exports","module"],function(e,t,n){"use strict";t.parForEach=function(e,t,n){var r=0,i=e.length;i===0&&n();for(var s=0;s<i;s++)t(e[s],function(e,t){r++,r===i&&n(e,t)})};var r=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;t.retrievePrecedingIdentifier=function(e,t,n){n=n||r;var i=[];for(var s=t-1;s>=0;s--){if(!n.test(e[s]))break;i.push(e[s])}return i.reverse().join("")},t.retrieveFollowingIdentifier=function(e,t,n){n=n||r;var i=[];for(var s=t;s<e.length;s++){if(!n.test(e[s]))break;i.push(e[s])}return i},t.getCompletionPrefix=function(e){var t=e.getCursorPosition(),n=e.session.getLine(t.row),r;return e.completers.forEach(function(e){e.identifierRegexps&&e.identifierRegexps.forEach(function(e){!r&&e&&(r=this.retrievePrecedingIdentifier(n,t.column,e))}.bind(this))}.bind(this)),r||this.retrievePrecedingIdentifier(n,t.column)},t.triggerAutocomplete=function(e){var t=e.getCursorPosition(),n=e.session.getLine(t.row),r=t.column===0?0:t.column-1,i=n[r];return e.completers.some(function(e){if(e.triggerCharacters&&Array.isArray(e.triggerCharacters))return e.triggerCharacters.includes(i)})}}),define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/inline","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config","ace/lib/event","ace/lib/scroll"],function(e,t,n){"use strict";var r=e("./keyboard/hash_handler").HashHandler,i=e("./autocomplete/popup").AcePopup,s=e("./autocomplete/inline").AceInline,o=e("./autocomplete/popup").getAriaId,u=e("./autocomplete/util"),a=e("./lib/lang"),f=e("./lib/dom"),l=e("./snippets").snippetManager,c=e("./config"),h=e("./lib/event"),p=e("./lib/scroll").preventParentScroll,d=function(e,t){t.completer&&t.completer.destroy()},v=function(){function e(){this.autoInsert=!1,this.autoSelect=!0,this.autoShown=!1,this.exactMatch=!1,this.inlineEnabled=!1,this.keyboardHandler=new r,this.keyboardHandler.bindKeys(this.commands),this.parentNode=null,this.setSelectOnHover=!1,this.hasSeen=new Set,this.showLoadingState=!1,this.stickySelectionDelay=500,this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.onLayoutChange=this.onLayoutChange.bind(this),this.changeTimer=a.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=a.delayedCall(this.updateDocTooltip.bind(this),50),this.popupTimer=a.delayedCall(this.$updatePopupPosition.bind(this),50),this.stickySelectionTimer=a.delayedCall(function(){this.stickySelection=!0}.bind(this),this.stickySelectionDelay),this.$firstOpenTimer=a.delayedCall(function(){var t=this.completionProvider&&this.completionProvider.initialPosition;if(this.autoShown||this.popup&&this.popup.isOpen||!t||this.editor.completers.length===0)return;this.completions=new g(e.completionsForLoading),this.openPopup(this.editor,t.prefix,!1),this.popup.renderer.setStyle("ace_loading",!0)}.bind(this),this.stickySelectionDelay)}return Object.defineProperty(e,"completionsForLoading",{get:function(){return[{caption:c.nls("Loading..."),value:""}]},enumerable:!1,configurable:!0}),e.prototype.$init=function(){return this.popup=new i(this.parentNode||document.body||document.documentElement),this.popup.on("click",function(e){this.insertMatch(),e.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.$onPopupShow.bind(this)),this.popup.on("hide",this.$onHidePopup.bind(this)),this.popup.on("select",this.$onPopupChange.bind(this)),h.addListener(this.popup.container,"mouseout",this.mouseOutListener.bind(this)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup.renderer.on("afterRender",this.$onPopupRender.bind(this)),this.popup},e.prototype.$initInline=function(){if(!this.inlineEnabled||this.inlineRenderer)return;return this.inlineRenderer=new s,this.inlineRenderer},e.prototype.getPopup=function(){return this.popup||this.$init()},e.prototype.$onHidePopup=function(){this.inlineRenderer&&this.inlineRenderer.hide(),this.hideDocTooltip(),this.stickySelectionTimer.cancel(),this.popupTimer.cancel(),this.stickySelection=!1},e.prototype.$seen=function(e){!this.hasSeen.has(e)&&e&&e.completer&&e.completer.onSeen&&typeof e.completer.onSeen=="function"&&(e.completer.onSeen(this.editor,e),this.hasSeen.add(e))},e.prototype.$onPopupChange=function(e){if(this.inlineRenderer&&this.inlineEnabled){var t=e?null:this.popup.getData(this.popup.getRow());this.$updateGhostText(t);if(this.popup.isMouseOver&&this.setSelectOnHover){this.tooltipTimer.call(null,null);return}this.popupTimer.schedule(),this.tooltipTimer.schedule()}else this.popupTimer.call(null,null),this.tooltipTimer.call(null,null)},e.prototype.$updateGhostText=function(e){var t=this.base.row,n=this.base.column,r=this.editor.getCursorPosition().column,i=this.editor.session.getLine(t).slice(n,r);this.inlineRenderer.show(this.editor,e,i)?this.$seen(e):this.inlineRenderer.hide()},e.prototype.$onPopupRender=function(){var e=this.inlineRenderer&&this.inlineEnabled;if(this.completions&&this.completions.filtered&&this.completions.filtered.length>0)for(var t=this.popup.getFirstVisibleRow();t<=this.popup.getLastVisibleRow();t++){var n=this.popup.getData(t);n&&(!e||n.hideInlinePreview)&&this.$seen(n)}},e.prototype.$onPopupShow=function(e){this.$onPopupChange(e),this.stickySelection=!1,this.stickySelectionDelay>=0&&this.stickySelectionTimer.schedule(this.stickySelectionDelay)},e.prototype.observeLayoutChanges=function(){if(this.$elements||!this.editor)return;window.addEventListener("resize",this.onLayoutChange,{passive:!0}),window.addEventListener("wheel",this.mousewheelListener);var e=this.editor.container.parentNode,t=[];while(e)t.push(e),e.addEventListener("scroll",this.onLayoutChange,{passive:!0}),e=e.parentNode;this.$elements=t},e.prototype.unObserveLayoutChanges=function(){var e=this;window.removeEventListener("resize",this.onLayoutChange,{passive:!0}),window.removeEventListener("wheel",this.mousewheelListener),this.$elements&&this.$elements.forEach(function(t){t.removeEventListener("scroll",e.onLayoutChange,{passive:!0})}),this.$elements=null},e.prototype.onLayoutChange=function(){if(!this.popup.isOpen)return this.unObserveLayoutChanges();this.$updatePopupPosition(),this.updateDocTooltip()},e.prototype.$updatePopupPosition=function(){var e=this.editor,t=e.renderer,n=t.layerConfig.lineHeight,r=t.$cursorLayer.getPixelPosition(this.base,!0);r.left-=this.popup.getTextLeftOffset();var i=e.container.getBoundingClientRect();r.top+=i.top-t.layerConfig.offset,r.left+=i.left-e.renderer.scrollLeft,r.left+=t.gutterWidth;var s={top:r.top,left:r.left};t.$ghostText&&t.$ghostTextWidget&&this.base.row===t.$ghostText.position.row&&(s.top+=t.$ghostTextWidget.el.offsetHeight);var o=e.container.getBoundingClientRect().bottom-n,u=o<s.top?{top:o,left:s.left}:s;if(this.popup.tryShow(u,n,"bottom"))return;if(this.popup.tryShow(r,n,"top"))return;this.popup.show(r,n)},e.prototype.openPopup=function(e,t,n){this.$firstOpenTimer.cancel(),this.popup||this.$init(),this.inlineEnabled&&!this.inlineRenderer&&this.$initInline(),this.popup.autoSelect=this.autoSelect,this.popup.setSelectOnHover(this.setSelectOnHover);var r=this.popup.getRow(),i=this.popup.data[r];this.popup.setData(this.completions.filtered,this.completions.filterText),this.editor.textInput.setAriaOptions&&this.editor.textInput.setAriaOptions({activeDescendant:o(this.popup.getRow()),inline:this.inlineEnabled}),e.keyBinding.addKeyboardHandler(this.keyboardHandler);var s;this.stickySelection&&(s=this.popup.data.indexOf(i));if(!s||s===-1)s=0;this.popup.setRow(this.autoSelect?s:-1),s===r&&i!==this.completions.filtered[s]&&this.$onPopupChange();var u=this.inlineRenderer&&this.inlineEnabled;if(s===r&&u){var a=this.popup.getData(this.popup.getRow());this.$updateGhostText(a)}n?n&&!t&&this.detach():(this.popup.setTheme(e.getTheme()),this.popup.setFontSize(e.getFontSize()),this.$updatePopupPosition(),this.tooltipNode&&this.updateDocTooltip()),this.changeTimer.cancel(),this.observeLayoutChanges()},e.prototype.detach=function(){this.editor&&(this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener)),this.$firstOpenTimer.cancel(),this.changeTimer.cancel(),this.hideDocTooltip(),this.completionProvider&&this.completionProvider.detach(),this.popup&&this.popup.isOpen&&this.popup.hide(),this.popup&&this.popup.renderer&&this.popup.renderer.off("afterRender",this.$onPopupRender),this.base&&this.base.detach(),this.activated=!1,this.completionProvider=this.completions=this.base=null,this.unObserveLayoutChanges()},e.prototype.changeListener=function(e){var t=this.editor.selection.lead;(t.row!=this.base.row||t.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},e.prototype.blurListener=function(e){this.detach()},e.prototype.mousedownListener=function(e){this.detach()},e.prototype.mousewheelListener=function(e){this.popup.isMouseOver||this.detach()},e.prototype.mouseOutListener=function(e){this.popup.isOpen&&this.$updatePopupPosition()},e.prototype.goTo=function(e){this.popup.goTo(e)},e.prototype.insertMatch=function(e,t){e||(e=this.popup.getData(this.popup.getRow()));if(!e)return!1;if(e.value==="")return this.detach();var n=this.completions,r=this.getCompletionProvider().insertMatch(this.editor,e,n.filterText,t);return this.completions==n&&this.detach(),r},e.prototype.showPopup=function(e,t){this.editor&&this.detach(),this.activated=!0,this.editor=e,e.completer!=this&&(e.completer&&e.completer.detach(),e.completer=this),e.on("changeSelection",this.changeListener),e.on("blur",this.blurListener),e.on("mousedown",this.mousedownListener),e.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,t)},e.prototype.getCompletionProvider=function(e){return this.completionProvider||(this.completionProvider=new m(e)),this.completionProvider},e.prototype.gatherCompletions=function(e,t){return this.getCompletionProvider().gatherCompletions(e,t)},e.prototype.updateCompletions=function(t,n){if(t&&this.base&&this.completions){var r=this.editor.getCursorPosition(),i=this.editor.session.getTextRange({start:this.base,end:r});if(i==this.completions.filterText)return;this.completions.setFilter(i);if(!this.completions.filtered.length)return this.detach();if(this.completions.filtered.length==1&&this.completions.filtered[0].value==i&&!this.completions.filtered[0].snippet)return this.detach();this.openPopup(this.editor,i,t);return}if(n&&n.matches){var r=this.editor.getSelectionRange().start;return this.base=this.editor.session.doc.createAnchor(r.row,r.column),this.base.$insertRight=!0,this.completions=new g(n.matches),this.getCompletionProvider().completions=this.completions,this.openPopup(this.editor,"",t)}var s=this.editor.getSession(),r=this.editor.getCursorPosition(),i=u.getCompletionPrefix(this.editor);this.base=s.doc.createAnchor(r.row,r.column-i.length),this.base.$insertRight=!0;var o={exactMatch:this.exactMatch,ignoreCaption:this.ignoreCaption};this.getCompletionProvider({prefix:i,pos:r}).provideCompletions(this.editor,o,function(n,r,i){var s=r.filtered,o=u.getCompletionPrefix(this.editor);this.$firstOpenTimer.cancel();if(i){if(!s.length){var a=!this.autoShown&&this.emptyMessage;typeof a=="function"&&(a=this.emptyMessage(o));if(a){var f=[{caption:a,value:""}];this.completions=new g(f),this.openPopup(this.editor,o,t),this.popup.renderer.setStyle("ace_loading",!1);return}return this.detach()}if(s.length==1&&s[0].value==o&&!s[0].snippet)return this.detach();if(this.autoInsert&&!this.autoShown&&s.length==1)return this.insertMatch(s[0])}this.completions=!i&&this.showLoadingState?new g(e.completionsForLoading.concat(s),r.filterText):r,this.openPopup(this.editor,o,t),this.popup.renderer.setStyle("ace_loading",!i)}.bind(this)),this.showLoadingState&&!this.autoShown&&(!this.popup||!this.popup.isOpen)&&this.$firstOpenTimer.delay(this.stickySelectionDelay/2)},e.prototype.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},e.prototype.updateDocTooltip=function(){var e=this.popup,t=this.completions.filtered,n=t&&(t[e.getHoveredRow()]||t[e.getRow()]),r=null;if(!n||!this.editor||!this.popup.isOpen)return this.hideDocTooltip();var i=this.editor.completers.length;for(var s=0;s<i;s++){var o=this.editor.completers[s];if(o.getDocTooltip&&n.completerId===o.id){r=o.getDocTooltip(n);break}}!r&&typeof n!="string"&&(r=n),typeof r=="string"&&(r={docText:r});if(!r||!r.docHTML&&!r.docText)return this.hideDocTooltip();this.showDocTooltip(r)},e.prototype.showDocTooltip=function(e){this.tooltipNode||(this.tooltipNode=f.createElement("div"),this.tooltipNode.style.margin="0",this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.style.overscrollBehavior="contain",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this),this.tooltipNode.id="doc-tooltip",this.tooltipNode.setAttribute("role","tooltip"),this.tooltipNode.addEventListener("wheel",p));var t=this.editor.renderer.theme;this.tooltipNode.className="ace_tooltip ace_doc-tooltip "+(t.isDark?"ace_dark ":"")+(t.cssClass||"");var n=this.tooltipNode;e.docHTML?n.innerHTML=e.docHTML:e.docText&&(n.textContent=e.docText),n.parentNode||this.popup.container.appendChild(this.tooltipNode);var r=this.popup,i=r.container.getBoundingClientRect();n.style.top=r.container.style.top,n.style.bottom=r.container.style.bottom,n.style.display="block",window.innerWidth-i.right<320?i.left<320?r.isTopdown?(n.style.top=i.bottom+"px",n.style.left=i.left+"px",n.style.right="",n.style.bottom=""):(n.style.top=r.container.offsetTop-n.offsetHeight+"px",n.style.left=i.left+"px",n.style.right="",n.style.bottom=""):(n.style.right=window.innerWidth-i.left+"px",n.style.left=""):(n.style.left=i.right+1+"px",n.style.right="")},e.prototype.hideDocTooltip=function(){this.tooltipTimer.cancel();if(!this.tooltipNode)return;var e=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==e&&this.editor.focus(),this.tooltipNode=null,e.parentNode&&e.parentNode.removeChild(e)},e.prototype.onTooltipClick=function(e){var t=e.target;while(t&&t!=this.tooltipNode){if(t.nodeName=="A"&&t.href){t.rel="noreferrer",t.target="_blank";break}t=t.parentNode}},e.prototype.destroy=function(){this.detach();if(this.popup){this.popup.destroy();var e=this.popup.container;e&&e.parentNode&&e.parentNode.removeChild(e)}this.editor&&this.editor.completer==this&&(this.editor.off("destroy",d),this.editor.completer=null),this.inlineRenderer=this.popup=this.editor=null},e}();v.prototype.commands={Up:function(e){e.completer.goTo("up")},Down:function(e){e.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(e){e.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(e){e.completer.goTo("end")},Esc:function(e){e.completer.detach()},Return:function(e){return e.completer.insertMatch()},"Shift-Return":function(e){e.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(e){var t=e.completer.insertMatch();if(!!t||!!e.tabstopManager)return t;e.completer.goTo("down")},PageUp:function(e){e.completer.popup.gotoPageUp()},PageDown:function(e){e.completer.popup.gotoPageDown()}},v.for=function(e){return e.completer instanceof v?e.completer:(e.completer&&(e.completer.destroy(),e.completer=null),c.get("sharedPopups")?(v.$sharedInstance||(v.$sharedInstance=new v),e.completer=v.$sharedInstance):(e.completer=new v,e.once("destroy",d)),e.completer)},v.startCommand={name:"startAutocomplete",exec:function(e,t){var n=v.for(e);n.autoInsert=!1,n.autoSelect=!0,n.autoShown=!1,n.showPopup(e,t),n.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var m=function(){function e(e){this.initialPosition=e,this.active=!0}return e.prototype.insertByIndex=function(e,t,n){return!this.completions||!this.completions.filtered?!1:this.insertMatch(e,this.completions.filtered[t],n)},e.prototype.insertMatch=function(e,t,n){if(!t)return!1;e.startOperation({command:{name:"insertMatch"}});if(t.completer&&t.completer.insertMatch)t.completer.insertMatch(e,t);else{if(!this.completions)return!1;var r=this.completions.filterText.length,i=0;t.range&&t.range.start.row===t.range.end.row&&(r-=this.initialPosition.prefix.length,r+=this.initialPosition.pos.column-t.range.start.column,i+=t.range.end.column-this.initialPosition.pos.column);if(r||i){var s;e.selection.getAllRanges?s=e.selection.getAllRanges():s=[e.getSelectionRange()];for(var o=0,u;u=s[o];o++)u.start.column-=r,u.end.column+=i,e.session.remove(u)}t.snippet?l.insertSnippet(e,t.snippet):this.$insertString(e,t),t.completer&&t.completer.onInsert&&typeof t.completer.onInsert=="function"&&t.completer.onInsert(e,t),t.command&&t.command==="startAutocomplete"&&e.execCommand(t.command)}return e.endOperation(),!0},e.prototype.$insertString=function(e,t){var n=t.value||t;e.execCommand("insertstring",n)},e.prototype.gatherCompletions=function(e,t){var n=e.getSession(),r=e.getCursorPosition(),i=u.getCompletionPrefix(e),s=[];this.completers=e.completers;var o=e.completers.length;return e.completers.forEach(function(a,f){a.getCompletions(e,n,r,i,function(n,r){a.hideInlinePreview&&(r=r.map(function(e){return Object.assign(e,{hideInlinePreview:a.hideInlinePreview})})),!n&&r&&(s=s.concat(r)),t(null,{prefix:u.getCompletionPrefix(e),matches:s,finished:--o===0})})}),!0},e.prototype.provideCompletions=function(e,t,n){var r=function(e){var r=e.prefix,i=e.matches;this.completions=new g(i),t.exactMatch&&(this.completions.exactMatch=!0),t.ignoreCaption&&(this.completions.ignoreCaption=!0),this.completions.setFilter(r),(e.finished||this.completions.filtered.length)&&n(null,this.completions,e.finished)}.bind(this),i=!0,s=null;this.gatherCompletions(e,function(e,t){if(!this.active)return;e&&(n(e,[],!0),this.detach());var o=t.prefix;if(o.indexOf(t.prefix)!==0)return;if(i){s=t;return}r(t)}.bind(this)),i=!1;if(s){var o=s;s=null,r(o)}},e.prototype.detach=function(){this.active=!1,this.completers&&this.completers.forEach(function(e){typeof e.cancel=="function"&&e.cancel()})},e}(),g=function(){function e(e,t){this.all=e,this.filtered=e,this.filterText=t||"",this.exactMatch=!1,this.ignoreCaption=!1}return e.prototype.setFilter=function(e){if(e.length>this.filterText&&e.lastIndexOf(this.filterText,0)===0)var t=this.filtered;else var t=this.all;this.filterText=e,t=this.filterCompletions(t,this.filterText),t=t.sort(function(e,t){return t.exactMatch-e.exactMatch||t.$score-e.$score||(e.caption||e.value).localeCompare(t.caption||t.value)});var n=null;t=t.filter(function(e){var t=e.snippet||e.caption||e.value;return t===n?!1:(n=t,!0)}),this.filtered=t},e.prototype.filterCompletions=function(e,t){var n=[],r=t.toUpperCase(),i=t.toLowerCase();e:for(var s=0,o;o=e[s];s++){var u=!this.ignoreCaption&&o.caption||o.value||o.snippet;if(!u)continue;var a=-1,f=0,l=0,c,h;if(this.exactMatch){if(t!==u.substr(0,t.length))continue e}else{var p=u.toLowerCase().indexOf(i);if(p>-1)l=p;else for(var d=0;d<t.length;d++){var v=u.indexOf(i[d],a+1),m=u.indexOf(r[d],a+1);c=v>=0?m<0||v<m?v:m:m;if(c<0)continue e;h=c-a-1,h>0&&(a===-1&&(l+=10),l+=h,f|=1<<d),a=c}}o.matchMask=f,o.exactMatch=l?0:1,o.$score=(o.score||0)-l,n.push(o)}return n},e}();t.Autocomplete=v,t.CompletionProvider=m,t.FilteredList=g}),define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(e,t,n){function s(e,t){var n=e.getTextRange(r.fromPoints({row:0,column:0},t));return n.split(i).length-1}function o(e,t){var n=s(e,t),r=e.getValue().split(i),o=Object.create(null),u=r[n];return r.forEach(function(e,t){if(!e||e===u)return;var i=Math.abs(n-t),s=r.length-i;o[e]?o[e]=Math.max(s,o[e]):o[e]=s}),o}var r=e("../range").Range,i=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;t.getCompletions=function(e,t,n,r,i){var s=o(t,n),u=Object.keys(s);i(null,u.map(function(e){return{caption:e,value:e,score:s[e],meta:"local"}}))}}),define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(e,t,n){"use strict";var r=e("../snippets").snippetManager,i=e("../autocomplete").Autocomplete,s=e("../config"),o=e("../lib/lang"),u=e("../autocomplete/util"),a=e("../autocomplete/text_completer"),f={getCompletions:function(e,t,n,r,i){if(t.$mode.completer)return t.$mode.completer.getCompletions(e,t,n,r,i);var s=e.session.getState(n.row),o=t.$mode.getCompletions(s,t,n,r);o=o.map(function(e){return e.completerId=f.id,e}),i(null,o)},id:"keywordCompleter"},l=function(e){var t={};return e.replace(/\${(\d+)(:(.*?))?}/g,function(e,n,r,i){return t[n]=i||""}).replace(/\$(\d+?)/g,function(e,n){return t[n]})},c={getCompletions:function(e,t,n,i,s){var o=[],u=t.getTokenAt(n.row,n.column);u&&u.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?o.push("html-tag"):o=r.getActiveScopes(e);var a=r.snippetMap,f=[];o.forEach(function(e){var t=a[e]||[];for(var n=t.length;n--;){var r=t[n],i=r.name||r.tabTrigger;if(!i)continue;f.push({caption:i,snippet:r.content,meta:r.tabTrigger&&!r.name?r.tabTrigger+"\u21e5 ":"snippet",completerId:c.id})}},this),s(null,f)},getDocTooltip:function(e){e.snippet&&!e.docHTML&&(e.docHTML=["<b>",o.escapeHTML(e.caption),"</b>","<hr></hr>",o.escapeHTML(l(e.snippet))].join(""))},id:"snippetCompleter"},h=[c,a,f];t.setCompleters=function(e){h.length=0,e&&h.push.apply(h,e)},t.addCompleter=function(e){h.push(e)},t.textCompleter=a,t.keyWordCompleter=f,t.snippetCompleter=c;var p={name:"expandSnippet",exec:function(e){return r.expandWithTab(e)},bindKey:"Tab"},d=function(e,t){v(t.session.$mode)},v=function(e){typeof e=="string"&&(e=s.$modes[e]);if(!e)return;r.files||(r.files={}),m(e.$id,e.snippetFileId),e.modes&&e.modes.forEach(v)},m=function(e,t){if(!t||!e||r.files[e])return;r.files[e]={},s.loadModule(t,function(t){if(!t)return;r.files[e]=t,!t.snippets&&t.snippetText&&(t.snippets=r.parseSnippetFile(t.snippetText)),r.register(t.snippets||[],t.scope),t.includeScopes&&(r.snippetMap[t.scope].includeScopes=t.includeScopes,t.includeScopes.forEach(function(e){v("ace/mode/"+e)}))})},g=function(e){var t=e.editor,n=t.completer&&t.completer.activated;if(e.command.name==="backspace")n&&!u.getCompletionPrefix(t)&&t.completer.detach();else if(e.command.name==="insertstring"&&!n){y=e;var r=e.editor.$liveAutocompletionDelay;r?b.delay(r):w(e)}},y,b=o.delayedCall(function(){w(y)},0),w=function(e){var t=e.editor,n=u.getCompletionPrefix(t),r=u.triggerAutocomplete(t);if(n&&n.length>=t.$liveAutocompletionThreshold||r){var s=i.for(t);s.autoShown=!0,s.showPopup(t)}},E=e("../editor").Editor;e("../config").defineOptions(E.prototype,"editor",{enableBasicAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:h),this.commands.addCommand(i.startCommand)):this.commands.removeCommand(i.startCommand)},value:!1},enableLiveAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:h),this.commands.on("afterExec",g)):this.commands.off("afterExec",g)},value:!1},liveAutocompletionDelay:{initialValue:0},liveAutocompletionThreshold:{initialValue:0},enableSnippets:{set:function(e){e?(this.commands.addCommand(p),this.on("changeMode",d),d(null,this)):(this.commands.removeCommand(p),this.off("changeMode",d))},value:!1}}),t.loadSnippetsForMode=v,t.loadSnippetFile=m});                (function() {
                    window.require(["ace/ext/language_tools"], function(m) {
                        if (typeof module == "object" && typeof exports == "object" && module) {
                            module.exports = m;
                        }
                    });
                })();
            