// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
/** This module is browser compatible. */ import { BinarySearchNode } from "./binary_search_node.ts";
export class RedBlackNode extends BinarySearchNode {
    red;
    constructor(parent, value){
        super(parent, value);
        this.red = true;
    }
    static from(node) {
        const copy = new RedBlackNode(node.parent, node.value);
        copy.left = node.left;
        copy.right = node.right;
        copy.red = node.red;
        return copy;
    }
}
//# sourceMappingURL=data:application/json;base64,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