// Ported from js-yaml v3.13.1:
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// deno-lint-ignore no-explicit-any
export function isBoolean(value) {
  return typeof value === "boolean" || value instanceof Boolean;
}
export function isNull(value) {
  return value === null;
}
export function isObject(value) {
  return value !== null && typeof value === "object";
}
export function repeat(str, count) {
  let result = "";
  for(let cycle = 0; cycle < count; cycle++){
    result += str;
  }
  return result;
}
export function isNegativeZero(i) {
  return i === 0 && Number.NEGATIVE_INFINITY === 1 / i;
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=2084407702782037850,10884243710130818483