// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
export function consumeToken(v) {
  const notPos = indexOf(v, isNotTokenChar);
  if (notPos === -1) {
    return [
      v,
      ""
    ];
  }
  if (notPos === 0) {
    return [
      "",
      v
    ];
  }
  return [
    v.slice(0, notPos),
    v.slice(notPos)
  ];
}
export function consumeValue(v) {
  if (!v) {
    return [
      "",
      v
    ];
  }
  if (v[0] !== `"`) {
    return consumeToken(v);
  }
  let value = "";
  for(let i = 1; i < v.length; i++){
    const r = v[i];
    if (r === `"`) {
      return [
        value,
        v.slice(i + 1)
      ];
    }
    const next = v[i + 1];
    if (r === "\\" && typeof next === "string" && isTSpecial(next)) {
      value += next;
      i++;
      continue;
    }
    if (r === "\r" || r === "\n") {
      return [
        "",
        v
      ];
    }
    value += v[i];
  }
  return [
    "",
    v
  ];
}
export function consumeMediaParam(v) {
  let rest = v.trimStart();
  if (!rest.startsWith(";")) {
    return [
      "",
      "",
      v
    ];
  }
  rest = rest.slice(1);
  rest = rest.trimStart();
  let param;
  [param, rest] = consumeToken(rest);
  param = param.toLowerCase();
  if (!param) {
    return [
      "",
      "",
      v
    ];
  }
  rest = rest.slice(1);
  rest = rest.trimStart();
  const [value, rest2] = consumeValue(rest);
  if (value === "" && rest2 === rest) {
    return [
      "",
      "",
      v
    ];
  }
  rest = rest2;
  return [
    param,
    value,
    rest
  ];
}
export function decode2331Encoding(v) {
  const sv = v.split(`'`, 3);
  if (sv.length !== 3) {
    return undefined;
  }
  const [sv0, , sv2] = sv;
  const charset = sv0.toLowerCase();
  if (!charset) {
    return undefined;
  }
  if (charset !== "us-ascii" && charset !== "utf-8") {
    return undefined;
  }
  const encv = decodeURI(sv2);
  if (!encv) {
    return undefined;
  }
  return encv;
}
function indexOf(s, fn) {
  let i = -1;
  for (const v of s){
    i++;
    if (fn(v)) {
      return i;
    }
  }
  return -1;
}
export function isIterator(obj) {
  if (obj === null || obj === undefined) {
    return false;
  }
  // deno-lint-ignore no-explicit-any
  return typeof obj[Symbol.iterator] === "function";
}
export function isToken(s) {
  if (!s) {
    return false;
  }
  return indexOf(s, isNotTokenChar) < 0;
}
function isNotTokenChar(r) {
  return !isTokenChar(r);
}
function isTokenChar(r) {
  const code = r.charCodeAt(0);
  return code > 0x20 && code < 0x7f && !isTSpecial(r);
}
export function isTSpecial(r) {
  return r[0] ? `()<>@,;:\\"/[]?=`.includes(r[0]) : false;
}
const CHAR_CODE_SPACE = " ".charCodeAt(0);
const CHAR_CODE_TILDE = "~".charCodeAt(0);
export function needsEncoding(s) {
  for (const b of s){
    const charCode = b.charCodeAt(0);
    if ((charCode < CHAR_CODE_SPACE || charCode > CHAR_CODE_TILDE) && b !== "\t") {
      return true;
    }
  }
  return false;
}
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=16989476407078447811,6777076563347076817