// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
/** {@linkcode parse} and {@linkcode stringify} for handling
 * [YAML](https://yaml.org/) encoded data.
 *
 * Ported from
 * [js-yaml v3.13.1](https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da)
 *
 * @module
 */ export { parse, parseAll } from "./_yaml/parse.ts";
export { stringify } from "./_yaml/stringify.ts";
export { Type } from "./_yaml/type.ts";
export { CORE_SCHEMA, DEFAULT_SCHEMA, EXTENDED_SCHEMA, FAILSAFE_SCHEMA, JSON_SCHEMA } from "./_yaml/schema/mod.ts";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImh0dHBzOi8vZGVuby5sYW5kL3N0ZEAwLjE1My4wL2VuY29kaW5nL3lhbWwudHMiXSwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IDIwMTEtMjAxNSBieSBWaXRhbHkgUHV6cmluLiBBbGwgcmlnaHRzIHJlc2VydmVkLiBNSVQgbGljZW5zZS5cbi8vIENvcHlyaWdodCAyMDE4LTIwMjIgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG5cbi8qKiB7QGxpbmtjb2RlIHBhcnNlfSBhbmQge0BsaW5rY29kZSBzdHJpbmdpZnl9IGZvciBoYW5kbGluZ1xuICogW1lBTUxdKGh0dHBzOi8veWFtbC5vcmcvKSBlbmNvZGVkIGRhdGEuXG4gKlxuICogUG9ydGVkIGZyb21cbiAqIFtqcy15YW1sIHYzLjEzLjFdKGh0dHBzOi8vZ2l0aHViLmNvbS9ub2RlY2EvanMteWFtbC9jb21taXQvNjY1YWFkZGE0MjM0OWRjYWU4NjlmMTIwNDBkOWIxMGVmMThkMTJkYSlcbiAqXG4gKiBAbW9kdWxlXG4gKi9cblxuZXhwb3J0IHR5cGUgeyBQYXJzZU9wdGlvbnMgfSBmcm9tIFwiLi9feWFtbC9wYXJzZS50c1wiO1xuZXhwb3J0IHsgcGFyc2UsIHBhcnNlQWxsIH0gZnJvbSBcIi4vX3lhbWwvcGFyc2UudHNcIjtcbmV4cG9ydCB0eXBlIHsgRHVtcE9wdGlvbnMgYXMgU3RyaW5naWZ5T3B0aW9ucyB9IGZyb20gXCIuL195YW1sL3N0cmluZ2lmeS50c1wiO1xuZXhwb3J0IHsgc3RyaW5naWZ5IH0gZnJvbSBcIi4vX3lhbWwvc3RyaW5naWZ5LnRzXCI7XG5leHBvcnQgdHlwZSB7IFNjaGVtYURlZmluaXRpb24gfSBmcm9tIFwiLi9feWFtbC9zY2hlbWEudHNcIjtcbmV4cG9ydCB7IFR5cGUgfSBmcm9tIFwiLi9feWFtbC90eXBlLnRzXCI7XG5leHBvcnQgdHlwZSB7IEtpbmRUeXBlLCBSZXByZXNlbnRGbiwgU3R5bGVWYXJpYW50IH0gZnJvbSBcIi4vX3lhbWwvdHlwZS50c1wiO1xuZXhwb3J0IHtcbiAgQ09SRV9TQ0hFTUEsXG4gIERFRkFVTFRfU0NIRU1BLFxuICBFWFRFTkRFRF9TQ0hFTUEsXG4gIEZBSUxTQUZFX1NDSEVNQSxcbiAgSlNPTl9TQ0hFTUEsXG59IGZyb20gXCIuL195YW1sL3NjaGVtYS9tb2QudHNcIjtcbiJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSwwRUFBMEU7QUFDMUUsMEVBQTBFO0FBRTFFOzs7Ozs7O0NBT0MsR0FFRCxBQUNBLFNBQVMsS0FBSyxFQUFFLFFBQVEsUUFBUSxrQkFBa0IsQ0FBQztBQUVuRCxTQUFTLFNBQVMsUUFBUSxzQkFBc0IsQ0FBQztBQUVqRCxTQUFTLElBQUksUUFBUSxpQkFBaUIsQ0FBQztBQUV2QyxTQUNFLFdBQVcsRUFDWCxjQUFjLEVBQ2QsZUFBZSxFQUNmLGVBQWUsRUFDZixXQUFXLFFBQ04sdUJBQXVCLENBQUMifQ==