export function prettyBytes(num, options = {}) {
    if (!Number.isFinite(num)) {
        throw new TypeError(`Expected a finite number, got ${typeof num}: ${num}`);
    }
    const UNITS_FIRSTLETTER = (options.bits ? "b" : "B") + "kMGTPEZY";
    if (options.signed && num === 0) {
        return ` 0 ${UNITS_FIRSTLETTER[0]}`;
    }
    const prefix = num < 0 ? "-" : (options.signed ? "+" : "");
    num = Math.abs(num);
    const localeOptions = getLocaleOptions(options);
    if (num < 1) {
        const numberString = toLocaleString(num, options.locale, localeOptions);
        return prefix + numberString + " " + UNITS_FIRSTLETTER[0];
    }
    const exponent = Math.min(Math.floor(options.binary ? Math.log(num) / Math.log(1024) : Math.log10(num) / 3), UNITS_FIRSTLETTER.length - 1);
    num /= Math.pow(options.binary ? 1024 : 1000, exponent);
    if (!localeOptions) {
        num = Number(num.toPrecision(3));
    }
    const numberString = toLocaleString(num, options.locale, localeOptions);
    let unit = UNITS_FIRSTLETTER[exponent];
    if (exponent > 0) {
        unit += options.binary ? "i" : "";
        unit += options.bits ? "bit" : "B";
    }
    return prefix + numberString + " " + unit;
}
function getLocaleOptions({ maximumFractionDigits, minimumFractionDigits }) {
    if (maximumFractionDigits || minimumFractionDigits) {
        return {
            maximumFractionDigits,
            minimumFractionDigits,
        };
    }
}
function toLocaleString(num, locale, options) {
    if (typeof locale === "string" || Array.isArray(locale)) {
        return num.toLocaleString(locale, options);
    }
    else if (locale === true || options !== undefined) {
        return num.toLocaleString(undefined, options);
    }
    return num.toString();
}
//# sourceMappingURL=data:application/json;base64,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