export function chunk(array, size) {
    if (size <= 0 || !Number.isInteger(size)) {
        throw new Error(`Expected size to be an integer greater than 0 but found ${size}`);
    }
    if (array.length === 0) {
        return [];
    }
    const ret = Array.from({ length: Math.ceil(array.length / size) });
    let readIndex = 0;
    let writeIndex = 0;
    while (readIndex < array.length) {
        ret[writeIndex] = array.slice(readIndex, readIndex + size);
        writeIndex += 1;
        readIndex += size;
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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