// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
/** Functions for specific common tasks around collection types like `Array` and
 * `Record`.
 *
 * This module re-exports several modules, and importing this module directly
 * will likely include a lot of code that you might not use.
 *
 * Consider importing the function directly.  For example to import
 * {@linkcode groupBy} import the module using the snake cased version of the
 * module:
 *
 * ```ts
 * import { groupBy } from "https://deno.land/std@$STD_VERSION/collections/group_by.ts";
 * ```
 *
 * @module
 */ // Not sure what's causing this warning? Run `deno info <entry-point-path>` to
// analyze the module graph. It's not recommended to import directly from
// mod.ts here because it adds a lot of bloat.
console.warn("%c[WARN] deno_std: prefer importing collections/<function_name_in_snake_case>.ts " + "instead of collections/mod.ts", "color: yellow;");
export * from "./aggregate_groups.ts";
export * from "./associate_by.ts";
export * from "./associate_with.ts";
export * from "./chunk.ts";
export * from "./deep_merge.ts";
export * from "./distinct.ts";
export * from "./distinct_by.ts";
export * from "./drop_while.ts";
export * from "./filter_entries.ts";
export * from "./filter_keys.ts";
export * from "./filter_values.ts";
export * from "./group_by.ts";
export * from "./intersect.ts";
export * from "./map_entries.ts";
export * from "./map_keys.ts";
export * from "./map_not_nullish.ts";
export * from "./map_values.ts";
export * from "./partition.ts";
export * from "./permutations.ts";
export * from "./find_single.ts";
export * from "./sliding_windows.ts";
export * from "./sum_of.ts";
export * from "./max_by.ts";
export * from "./max_of.ts";
export * from "./min_by.ts";
export * from "./min_of.ts";
export * from "./sort_by.ts";
export * from "./union.ts";
export * from "./without_all.ts";
export * from "./unzip.ts";
export * from "./zip.ts";
export * from "./join_to_string.ts";
export * from "./max_with.ts";
export * from "./min_with.ts";
export * from "./includes_value.ts";
export * from "./take_last_while.ts";
export * from "./take_while.ts";
export * from "./first_not_nullish_of.ts";
export * from "./drop_last_while.ts";
export * from "./reduce_groups.ts";
export * from "./sample.ts";
export * from "./running_reduce.ts";
export * from "./binary_heap.ts";
export * from "./bs_tree.ts";
export * from "./rb_tree.ts";
//# sourceMappingURL=data:application/json;base64,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