// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
// This module is browser compatible.
// deno-fmt-ignore-file
export default {
    "application/1d-interleaved-parityfec": {
        "source": "iana"
    },
    "application/3gpdash-qoe-report+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/3gpp-ims+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/3gpphal+json": {
        "source": "iana",
        "compressible": true
    },
    "application/3gpphalforms+json": {
        "source": "iana",
        "compressible": true
    },
    "application/a2l": {
        "source": "iana"
    },
    "application/ace+cbor": {
        "source": "iana"
    },
    "application/activemessage": {
        "source": "iana"
    },
    "application/activity+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-costmap+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-costmapfilter+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-directory+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-endpointcost+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-endpointcostparams+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-endpointprop+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-endpointpropparams+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-error+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-networkmap+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-networkmapfilter+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-updatestreamcontrol+json": {
        "source": "iana",
        "compressible": true
    },
    "application/alto-updatestreamparams+json": {
        "source": "iana",
        "compressible": true
    },
    "application/aml": {
        "source": "iana"
    },
    "application/andrew-inset": {
        "source": "iana",
        "extensions": [
            "ez"
        ]
    },
    "application/applefile": {
        "source": "iana"
    },
    "application/applixware": {
        "source": "apache",
        "extensions": [
            "aw"
        ]
    },
    "application/at+jwt": {
        "source": "iana"
    },
    "application/atf": {
        "source": "iana"
    },
    "application/atfx": {
        "source": "iana"
    },
    "application/atom+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "atom"
        ]
    },
    "application/atomcat+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "atomcat"
        ]
    },
    "application/atomdeleted+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "atomdeleted"
        ]
    },
    "application/atomicmail": {
        "source": "iana"
    },
    "application/atomsvc+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "atomsvc"
        ]
    },
    "application/atsc-dwd+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "dwd"
        ]
    },
    "application/atsc-dynamic-event-message": {
        "source": "iana"
    },
    "application/atsc-held+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "held"
        ]
    },
    "application/atsc-rdt+json": {
        "source": "iana",
        "compressible": true
    },
    "application/atsc-rsat+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rsat"
        ]
    },
    "application/atxml": {
        "source": "iana"
    },
    "application/auth-policy+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/bacnet-xdd+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/batch-smtp": {
        "source": "iana"
    },
    "application/bdoc": {
        "compressible": false,
        "extensions": [
            "bdoc"
        ]
    },
    "application/beep+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/calendar+json": {
        "source": "iana",
        "compressible": true
    },
    "application/calendar+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xcs"
        ]
    },
    "application/call-completion": {
        "source": "iana"
    },
    "application/cals-1840": {
        "source": "iana"
    },
    "application/captive+json": {
        "source": "iana",
        "compressible": true
    },
    "application/cbor": {
        "source": "iana"
    },
    "application/cbor-seq": {
        "source": "iana"
    },
    "application/cccex": {
        "source": "iana"
    },
    "application/ccmp+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/ccxml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "ccxml"
        ]
    },
    "application/cdfx+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "cdfx"
        ]
    },
    "application/cdmi-capability": {
        "source": "iana",
        "extensions": [
            "cdmia"
        ]
    },
    "application/cdmi-container": {
        "source": "iana",
        "extensions": [
            "cdmic"
        ]
    },
    "application/cdmi-domain": {
        "source": "iana",
        "extensions": [
            "cdmid"
        ]
    },
    "application/cdmi-object": {
        "source": "iana",
        "extensions": [
            "cdmio"
        ]
    },
    "application/cdmi-queue": {
        "source": "iana",
        "extensions": [
            "cdmiq"
        ]
    },
    "application/cdni": {
        "source": "iana"
    },
    "application/cea": {
        "source": "iana"
    },
    "application/cea-2018+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/cellml+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/cfw": {
        "source": "iana"
    },
    "application/city+json": {
        "source": "iana",
        "compressible": true
    },
    "application/clr": {
        "source": "iana"
    },
    "application/clue+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/clue_info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/cms": {
        "source": "iana"
    },
    "application/cnrp+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/coap-group+json": {
        "source": "iana",
        "compressible": true
    },
    "application/coap-payload": {
        "source": "iana"
    },
    "application/commonground": {
        "source": "iana"
    },
    "application/conference-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/cose": {
        "source": "iana"
    },
    "application/cose-key": {
        "source": "iana"
    },
    "application/cose-key-set": {
        "source": "iana"
    },
    "application/cpl+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "cpl"
        ]
    },
    "application/csrattrs": {
        "source": "iana"
    },
    "application/csta+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/cstadata+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/csvm+json": {
        "source": "iana",
        "compressible": true
    },
    "application/cu-seeme": {
        "source": "apache",
        "extensions": [
            "cu"
        ]
    },
    "application/cwt": {
        "source": "iana"
    },
    "application/cybercash": {
        "source": "iana"
    },
    "application/dart": {
        "compressible": true
    },
    "application/dash+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mpd"
        ]
    },
    "application/dash-patch+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mpp"
        ]
    },
    "application/dashdelta": {
        "source": "iana"
    },
    "application/davmount+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "davmount"
        ]
    },
    "application/dca-rft": {
        "source": "iana"
    },
    "application/dcd": {
        "source": "iana"
    },
    "application/dec-dx": {
        "source": "iana"
    },
    "application/dialog-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/dicom": {
        "source": "iana"
    },
    "application/dicom+json": {
        "source": "iana",
        "compressible": true
    },
    "application/dicom+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/dii": {
        "source": "iana"
    },
    "application/dit": {
        "source": "iana"
    },
    "application/dns": {
        "source": "iana"
    },
    "application/dns+json": {
        "source": "iana",
        "compressible": true
    },
    "application/dns-message": {
        "source": "iana"
    },
    "application/docbook+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "dbk"
        ]
    },
    "application/dots+cbor": {
        "source": "iana"
    },
    "application/dskpp+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/dssc+der": {
        "source": "iana",
        "extensions": [
            "dssc"
        ]
    },
    "application/dssc+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xdssc"
        ]
    },
    "application/dvcs": {
        "source": "iana"
    },
    "application/ecmascript": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "es",
            "ecma"
        ]
    },
    "application/edi-consent": {
        "source": "iana"
    },
    "application/edi-x12": {
        "source": "iana",
        "compressible": false
    },
    "application/edifact": {
        "source": "iana",
        "compressible": false
    },
    "application/efi": {
        "source": "iana"
    },
    "application/elm+json": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/elm+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/emergencycalldata.cap+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/emergencycalldata.comment+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/emergencycalldata.control+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/emergencycalldata.deviceinfo+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/emergencycalldata.ecall.msd": {
        "source": "iana"
    },
    "application/emergencycalldata.providerinfo+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/emergencycalldata.serviceinfo+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/emergencycalldata.subscriberinfo+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/emergencycalldata.veds+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/emma+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "emma"
        ]
    },
    "application/emotionml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "emotionml"
        ]
    },
    "application/encaprtp": {
        "source": "iana"
    },
    "application/epp+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/epub+zip": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "epub"
        ]
    },
    "application/eshop": {
        "source": "iana"
    },
    "application/exi": {
        "source": "iana",
        "extensions": [
            "exi"
        ]
    },
    "application/expect-ct-report+json": {
        "source": "iana",
        "compressible": true
    },
    "application/express": {
        "source": "iana",
        "extensions": [
            "exp"
        ]
    },
    "application/fastinfoset": {
        "source": "iana"
    },
    "application/fastsoap": {
        "source": "iana"
    },
    "application/fdt+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "fdt"
        ]
    },
    "application/fhir+json": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/fhir+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/fido.trusted-apps+json": {
        "compressible": true
    },
    "application/fits": {
        "source": "iana"
    },
    "application/flexfec": {
        "source": "iana"
    },
    "application/font-sfnt": {
        "source": "iana"
    },
    "application/font-tdpfr": {
        "source": "iana",
        "extensions": [
            "pfr"
        ]
    },
    "application/font-woff": {
        "source": "iana",
        "compressible": false
    },
    "application/framework-attributes+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/geo+json": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "geojson"
        ]
    },
    "application/geo+json-seq": {
        "source": "iana"
    },
    "application/geopackage+sqlite3": {
        "source": "iana"
    },
    "application/geoxacml+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/gltf-buffer": {
        "source": "iana"
    },
    "application/gml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "gml"
        ]
    },
    "application/gpx+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "gpx"
        ]
    },
    "application/gxf": {
        "source": "apache",
        "extensions": [
            "gxf"
        ]
    },
    "application/gzip": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "gz"
        ]
    },
    "application/h224": {
        "source": "iana"
    },
    "application/held+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/hjson": {
        "extensions": [
            "hjson"
        ]
    },
    "application/http": {
        "source": "iana"
    },
    "application/hyperstudio": {
        "source": "iana",
        "extensions": [
            "stk"
        ]
    },
    "application/ibe-key-request+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/ibe-pkg-reply+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/ibe-pp-data": {
        "source": "iana"
    },
    "application/iges": {
        "source": "iana"
    },
    "application/im-iscomposing+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/index": {
        "source": "iana"
    },
    "application/index.cmd": {
        "source": "iana"
    },
    "application/index.obj": {
        "source": "iana"
    },
    "application/index.response": {
        "source": "iana"
    },
    "application/index.vnd": {
        "source": "iana"
    },
    "application/inkml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "ink",
            "inkml"
        ]
    },
    "application/iotp": {
        "source": "iana"
    },
    "application/ipfix": {
        "source": "iana",
        "extensions": [
            "ipfix"
        ]
    },
    "application/ipp": {
        "source": "iana"
    },
    "application/isup": {
        "source": "iana"
    },
    "application/its+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "its"
        ]
    },
    "application/java-archive": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "jar",
            "war",
            "ear"
        ]
    },
    "application/java-serialized-object": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "ser"
        ]
    },
    "application/java-vm": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "class"
        ]
    },
    "application/javascript": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "js",
            "mjs"
        ]
    },
    "application/jf2feed+json": {
        "source": "iana",
        "compressible": true
    },
    "application/jose": {
        "source": "iana"
    },
    "application/jose+json": {
        "source": "iana",
        "compressible": true
    },
    "application/jrd+json": {
        "source": "iana",
        "compressible": true
    },
    "application/jscalendar+json": {
        "source": "iana",
        "compressible": true
    },
    "application/json": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "json",
            "map"
        ]
    },
    "application/json-patch+json": {
        "source": "iana",
        "compressible": true
    },
    "application/json-seq": {
        "source": "iana"
    },
    "application/json5": {
        "extensions": [
            "json5"
        ]
    },
    "application/jsonml+json": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "jsonml"
        ]
    },
    "application/jwk+json": {
        "source": "iana",
        "compressible": true
    },
    "application/jwk-set+json": {
        "source": "iana",
        "compressible": true
    },
    "application/jwt": {
        "source": "iana"
    },
    "application/kpml-request+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/kpml-response+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/ld+json": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "jsonld"
        ]
    },
    "application/lgr+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "lgr"
        ]
    },
    "application/link-format": {
        "source": "iana"
    },
    "application/load-control+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/lost+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "lostxml"
        ]
    },
    "application/lostsync+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/lpf+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/lxf": {
        "source": "iana"
    },
    "application/mac-binhex40": {
        "source": "iana",
        "extensions": [
            "hqx"
        ]
    },
    "application/mac-compactpro": {
        "source": "apache",
        "extensions": [
            "cpt"
        ]
    },
    "application/macwriteii": {
        "source": "iana"
    },
    "application/mads+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mads"
        ]
    },
    "application/manifest+json": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "webmanifest"
        ]
    },
    "application/marc": {
        "source": "iana",
        "extensions": [
            "mrc"
        ]
    },
    "application/marcxml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mrcx"
        ]
    },
    "application/mathematica": {
        "source": "iana",
        "extensions": [
            "ma",
            "nb",
            "mb"
        ]
    },
    "application/mathml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mathml"
        ]
    },
    "application/mathml-content+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mathml-presentation+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-associated-procedure-description+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-deregister+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-envelope+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-msk+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-msk-response+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-protection-description+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-reception-report+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-register+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-register-response+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-schedule+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbms-user-service-description+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mbox": {
        "source": "iana",
        "extensions": [
            "mbox"
        ]
    },
    "application/media-policy-dataset+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mpf"
        ]
    },
    "application/media_control+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mediaservercontrol+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mscml"
        ]
    },
    "application/merge-patch+json": {
        "source": "iana",
        "compressible": true
    },
    "application/metalink+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "metalink"
        ]
    },
    "application/metalink4+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "meta4"
        ]
    },
    "application/mets+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mets"
        ]
    },
    "application/mf4": {
        "source": "iana"
    },
    "application/mikey": {
        "source": "iana"
    },
    "application/mipc": {
        "source": "iana"
    },
    "application/missing-blocks+cbor-seq": {
        "source": "iana"
    },
    "application/mmt-aei+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "maei"
        ]
    },
    "application/mmt-usd+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "musd"
        ]
    },
    "application/mods+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mods"
        ]
    },
    "application/moss-keys": {
        "source": "iana"
    },
    "application/moss-signature": {
        "source": "iana"
    },
    "application/mosskey-data": {
        "source": "iana"
    },
    "application/mosskey-request": {
        "source": "iana"
    },
    "application/mp21": {
        "source": "iana",
        "extensions": [
            "m21",
            "mp21"
        ]
    },
    "application/mp4": {
        "source": "iana",
        "extensions": [
            "mp4s",
            "m4p"
        ]
    },
    "application/mpeg4-generic": {
        "source": "iana"
    },
    "application/mpeg4-iod": {
        "source": "iana"
    },
    "application/mpeg4-iod-xmt": {
        "source": "iana"
    },
    "application/mrb-consumer+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/mrb-publish+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/msc-ivr+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/msc-mixer+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/msword": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "doc",
            "dot"
        ]
    },
    "application/mud+json": {
        "source": "iana",
        "compressible": true
    },
    "application/multipart-core": {
        "source": "iana"
    },
    "application/mxf": {
        "source": "iana",
        "extensions": [
            "mxf"
        ]
    },
    "application/n-quads": {
        "source": "iana",
        "extensions": [
            "nq"
        ]
    },
    "application/n-triples": {
        "source": "iana",
        "extensions": [
            "nt"
        ]
    },
    "application/nasdata": {
        "source": "iana"
    },
    "application/news-checkgroups": {
        "source": "iana",
        "charset": "US-ASCII"
    },
    "application/news-groupinfo": {
        "source": "iana",
        "charset": "US-ASCII"
    },
    "application/news-transmission": {
        "source": "iana"
    },
    "application/nlsml+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/node": {
        "source": "iana",
        "extensions": [
            "cjs"
        ]
    },
    "application/nss": {
        "source": "iana"
    },
    "application/oauth-authz-req+jwt": {
        "source": "iana"
    },
    "application/oblivious-dns-message": {
        "source": "iana"
    },
    "application/ocsp-request": {
        "source": "iana"
    },
    "application/ocsp-response": {
        "source": "iana"
    },
    "application/octet-stream": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "bin",
            "dms",
            "lrf",
            "mar",
            "so",
            "dist",
            "distz",
            "pkg",
            "bpk",
            "dump",
            "elc",
            "deploy",
            "exe",
            "dll",
            "deb",
            "dmg",
            "iso",
            "img",
            "msi",
            "msp",
            "msm",
            "buffer"
        ]
    },
    "application/oda": {
        "source": "iana",
        "extensions": [
            "oda"
        ]
    },
    "application/odm+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/odx": {
        "source": "iana"
    },
    "application/oebps-package+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "opf"
        ]
    },
    "application/ogg": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "ogx"
        ]
    },
    "application/omdoc+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "omdoc"
        ]
    },
    "application/onenote": {
        "source": "apache",
        "extensions": [
            "onetoc",
            "onetoc2",
            "onetmp",
            "onepkg"
        ]
    },
    "application/opc-nodeset+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/oscore": {
        "source": "iana"
    },
    "application/oxps": {
        "source": "iana",
        "extensions": [
            "oxps"
        ]
    },
    "application/p21": {
        "source": "iana"
    },
    "application/p21+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/p2p-overlay+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "relo"
        ]
    },
    "application/parityfec": {
        "source": "iana"
    },
    "application/passport": {
        "source": "iana"
    },
    "application/patch-ops-error+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xer"
        ]
    },
    "application/pdf": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "pdf"
        ]
    },
    "application/pdx": {
        "source": "iana"
    },
    "application/pem-certificate-chain": {
        "source": "iana"
    },
    "application/pgp-encrypted": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "pgp"
        ]
    },
    "application/pgp-keys": {
        "source": "iana",
        "extensions": [
            "asc"
        ]
    },
    "application/pgp-signature": {
        "source": "iana",
        "extensions": [
            "asc",
            "sig"
        ]
    },
    "application/pics-rules": {
        "source": "apache",
        "extensions": [
            "prf"
        ]
    },
    "application/pidf+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/pidf-diff+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/pkcs10": {
        "source": "iana",
        "extensions": [
            "p10"
        ]
    },
    "application/pkcs12": {
        "source": "iana"
    },
    "application/pkcs7-mime": {
        "source": "iana",
        "extensions": [
            "p7m",
            "p7c"
        ]
    },
    "application/pkcs7-signature": {
        "source": "iana",
        "extensions": [
            "p7s"
        ]
    },
    "application/pkcs8": {
        "source": "iana",
        "extensions": [
            "p8"
        ]
    },
    "application/pkcs8-encrypted": {
        "source": "iana"
    },
    "application/pkix-attr-cert": {
        "source": "iana",
        "extensions": [
            "ac"
        ]
    },
    "application/pkix-cert": {
        "source": "iana",
        "extensions": [
            "cer"
        ]
    },
    "application/pkix-crl": {
        "source": "iana",
        "extensions": [
            "crl"
        ]
    },
    "application/pkix-pkipath": {
        "source": "iana",
        "extensions": [
            "pkipath"
        ]
    },
    "application/pkixcmp": {
        "source": "iana",
        "extensions": [
            "pki"
        ]
    },
    "application/pls+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "pls"
        ]
    },
    "application/poc-settings+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/postscript": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "ai",
            "eps",
            "ps"
        ]
    },
    "application/ppsp-tracker+json": {
        "source": "iana",
        "compressible": true
    },
    "application/problem+json": {
        "source": "iana",
        "compressible": true
    },
    "application/problem+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/provenance+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "provx"
        ]
    },
    "application/prs.alvestrand.titrax-sheet": {
        "source": "iana"
    },
    "application/prs.cww": {
        "source": "iana",
        "extensions": [
            "cww"
        ]
    },
    "application/prs.cyn": {
        "source": "iana",
        "charset": "7-BIT"
    },
    "application/prs.hpub+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/prs.nprend": {
        "source": "iana"
    },
    "application/prs.plucker": {
        "source": "iana"
    },
    "application/prs.rdf-xml-crypt": {
        "source": "iana"
    },
    "application/prs.xsf+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/pskc+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "pskcxml"
        ]
    },
    "application/pvd+json": {
        "source": "iana",
        "compressible": true
    },
    "application/qsig": {
        "source": "iana"
    },
    "application/raml+yaml": {
        "compressible": true,
        "extensions": [
            "raml"
        ]
    },
    "application/raptorfec": {
        "source": "iana"
    },
    "application/rdap+json": {
        "source": "iana",
        "compressible": true
    },
    "application/rdf+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rdf",
            "owl"
        ]
    },
    "application/reginfo+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rif"
        ]
    },
    "application/relax-ng-compact-syntax": {
        "source": "iana",
        "extensions": [
            "rnc"
        ]
    },
    "application/remote-printing": {
        "source": "iana"
    },
    "application/reputon+json": {
        "source": "iana",
        "compressible": true
    },
    "application/resource-lists+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rl"
        ]
    },
    "application/resource-lists-diff+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rld"
        ]
    },
    "application/rfc+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/riscos": {
        "source": "iana"
    },
    "application/rlmi+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/rls-services+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rs"
        ]
    },
    "application/route-apd+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rapd"
        ]
    },
    "application/route-s-tsid+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "sls"
        ]
    },
    "application/route-usd+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rusd"
        ]
    },
    "application/rpki-ghostbusters": {
        "source": "iana",
        "extensions": [
            "gbr"
        ]
    },
    "application/rpki-manifest": {
        "source": "iana",
        "extensions": [
            "mft"
        ]
    },
    "application/rpki-publication": {
        "source": "iana"
    },
    "application/rpki-roa": {
        "source": "iana",
        "extensions": [
            "roa"
        ]
    },
    "application/rpki-updown": {
        "source": "iana"
    },
    "application/rsd+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "rsd"
        ]
    },
    "application/rss+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "rss"
        ]
    },
    "application/rtf": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rtf"
        ]
    },
    "application/rtploopback": {
        "source": "iana"
    },
    "application/rtx": {
        "source": "iana"
    },
    "application/samlassertion+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/samlmetadata+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/sarif+json": {
        "source": "iana",
        "compressible": true
    },
    "application/sarif-external-properties+json": {
        "source": "iana",
        "compressible": true
    },
    "application/sbe": {
        "source": "iana"
    },
    "application/sbml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "sbml"
        ]
    },
    "application/scaip+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/scim+json": {
        "source": "iana",
        "compressible": true
    },
    "application/scvp-cv-request": {
        "source": "iana",
        "extensions": [
            "scq"
        ]
    },
    "application/scvp-cv-response": {
        "source": "iana",
        "extensions": [
            "scs"
        ]
    },
    "application/scvp-vp-request": {
        "source": "iana",
        "extensions": [
            "spq"
        ]
    },
    "application/scvp-vp-response": {
        "source": "iana",
        "extensions": [
            "spp"
        ]
    },
    "application/sdp": {
        "source": "iana",
        "extensions": [
            "sdp"
        ]
    },
    "application/secevent+jwt": {
        "source": "iana"
    },
    "application/senml+cbor": {
        "source": "iana"
    },
    "application/senml+json": {
        "source": "iana",
        "compressible": true
    },
    "application/senml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "senmlx"
        ]
    },
    "application/senml-etch+cbor": {
        "source": "iana"
    },
    "application/senml-etch+json": {
        "source": "iana",
        "compressible": true
    },
    "application/senml-exi": {
        "source": "iana"
    },
    "application/sensml+cbor": {
        "source": "iana"
    },
    "application/sensml+json": {
        "source": "iana",
        "compressible": true
    },
    "application/sensml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "sensmlx"
        ]
    },
    "application/sensml-exi": {
        "source": "iana"
    },
    "application/sep+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/sep-exi": {
        "source": "iana"
    },
    "application/session-info": {
        "source": "iana"
    },
    "application/set-payment": {
        "source": "iana"
    },
    "application/set-payment-initiation": {
        "source": "iana",
        "extensions": [
            "setpay"
        ]
    },
    "application/set-registration": {
        "source": "iana"
    },
    "application/set-registration-initiation": {
        "source": "iana",
        "extensions": [
            "setreg"
        ]
    },
    "application/sgml": {
        "source": "iana"
    },
    "application/sgml-open-catalog": {
        "source": "iana"
    },
    "application/shf+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "shf"
        ]
    },
    "application/sieve": {
        "source": "iana",
        "extensions": [
            "siv",
            "sieve"
        ]
    },
    "application/simple-filter+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/simple-message-summary": {
        "source": "iana"
    },
    "application/simplesymbolcontainer": {
        "source": "iana"
    },
    "application/sipc": {
        "source": "iana"
    },
    "application/slate": {
        "source": "iana"
    },
    "application/smil": {
        "source": "iana"
    },
    "application/smil+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "smi",
            "smil"
        ]
    },
    "application/smpte336m": {
        "source": "iana"
    },
    "application/soap+fastinfoset": {
        "source": "iana"
    },
    "application/soap+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/sparql-query": {
        "source": "iana",
        "extensions": [
            "rq"
        ]
    },
    "application/sparql-results+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "srx"
        ]
    },
    "application/spdx+json": {
        "source": "iana",
        "compressible": true
    },
    "application/spirits-event+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/sql": {
        "source": "iana"
    },
    "application/srgs": {
        "source": "iana",
        "extensions": [
            "gram"
        ]
    },
    "application/srgs+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "grxml"
        ]
    },
    "application/sru+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "sru"
        ]
    },
    "application/ssdl+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "ssdl"
        ]
    },
    "application/ssml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "ssml"
        ]
    },
    "application/stix+json": {
        "source": "iana",
        "compressible": true
    },
    "application/swid+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "swidtag"
        ]
    },
    "application/tamp-apex-update": {
        "source": "iana"
    },
    "application/tamp-apex-update-confirm": {
        "source": "iana"
    },
    "application/tamp-community-update": {
        "source": "iana"
    },
    "application/tamp-community-update-confirm": {
        "source": "iana"
    },
    "application/tamp-error": {
        "source": "iana"
    },
    "application/tamp-sequence-adjust": {
        "source": "iana"
    },
    "application/tamp-sequence-adjust-confirm": {
        "source": "iana"
    },
    "application/tamp-status-query": {
        "source": "iana"
    },
    "application/tamp-status-response": {
        "source": "iana"
    },
    "application/tamp-update": {
        "source": "iana"
    },
    "application/tamp-update-confirm": {
        "source": "iana"
    },
    "application/tar": {
        "compressible": true
    },
    "application/taxii+json": {
        "source": "iana",
        "compressible": true
    },
    "application/td+json": {
        "source": "iana",
        "compressible": true
    },
    "application/tei+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "tei",
            "teicorpus"
        ]
    },
    "application/tetra_isi": {
        "source": "iana"
    },
    "application/thraud+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "tfi"
        ]
    },
    "application/timestamp-query": {
        "source": "iana"
    },
    "application/timestamp-reply": {
        "source": "iana"
    },
    "application/timestamped-data": {
        "source": "iana",
        "extensions": [
            "tsd"
        ]
    },
    "application/tlsrpt+gzip": {
        "source": "iana"
    },
    "application/tlsrpt+json": {
        "source": "iana",
        "compressible": true
    },
    "application/tnauthlist": {
        "source": "iana"
    },
    "application/token-introspection+jwt": {
        "source": "iana"
    },
    "application/toml": {
        "compressible": true,
        "extensions": [
            "toml"
        ]
    },
    "application/trickle-ice-sdpfrag": {
        "source": "iana"
    },
    "application/trig": {
        "source": "iana",
        "extensions": [
            "trig"
        ]
    },
    "application/ttml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "ttml"
        ]
    },
    "application/tve-trigger": {
        "source": "iana"
    },
    "application/tzif": {
        "source": "iana"
    },
    "application/tzif-leap": {
        "source": "iana"
    },
    "application/ubjson": {
        "compressible": false,
        "extensions": [
            "ubj"
        ]
    },
    "application/ulpfec": {
        "source": "iana"
    },
    "application/urc-grpsheet+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/urc-ressheet+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rsheet"
        ]
    },
    "application/urc-targetdesc+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "td"
        ]
    },
    "application/urc-uisocketdesc+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vcard+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vcard+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vemmi": {
        "source": "iana"
    },
    "application/vividence.scriptfile": {
        "source": "apache"
    },
    "application/vnd.1000minds.decision-model+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "1km"
        ]
    },
    "application/vnd.3gpp-prose+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp-prose-pc3ch+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp-v2x-local-service-information": {
        "source": "iana"
    },
    "application/vnd.3gpp.5gnas": {
        "source": "iana"
    },
    "application/vnd.3gpp.access-transfer-events+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.bsf+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.gmop+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.gtpc": {
        "source": "iana"
    },
    "application/vnd.3gpp.interworking-data": {
        "source": "iana"
    },
    "application/vnd.3gpp.lpp": {
        "source": "iana"
    },
    "application/vnd.3gpp.mc-signalling-ear": {
        "source": "iana"
    },
    "application/vnd.3gpp.mcdata-affiliation-command+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcdata-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcdata-payload": {
        "source": "iana"
    },
    "application/vnd.3gpp.mcdata-service-config+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcdata-signalling": {
        "source": "iana"
    },
    "application/vnd.3gpp.mcdata-ue-config+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcdata-user-profile+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-affiliation-command+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-floor-request+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-location-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-mbms-usage-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-service-config+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-signed+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-ue-config+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-ue-init-config+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcptt-user-profile+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-affiliation-command+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-affiliation-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-location-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-mbms-usage-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-service-config+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-transmission-request+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-ue-config+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mcvideo-user-profile+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.mid-call+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.ngap": {
        "source": "iana"
    },
    "application/vnd.3gpp.pfcp": {
        "source": "iana"
    },
    "application/vnd.3gpp.pic-bw-large": {
        "source": "iana",
        "extensions": [
            "plb"
        ]
    },
    "application/vnd.3gpp.pic-bw-small": {
        "source": "iana",
        "extensions": [
            "psb"
        ]
    },
    "application/vnd.3gpp.pic-bw-var": {
        "source": "iana",
        "extensions": [
            "pvb"
        ]
    },
    "application/vnd.3gpp.s1ap": {
        "source": "iana"
    },
    "application/vnd.3gpp.sms": {
        "source": "iana"
    },
    "application/vnd.3gpp.sms+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.srvcc-ext+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.srvcc-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.state-and-event-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp.ussd+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp2.bcmcsinfo+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.3gpp2.sms": {
        "source": "iana"
    },
    "application/vnd.3gpp2.tcap": {
        "source": "iana",
        "extensions": [
            "tcap"
        ]
    },
    "application/vnd.3lightssoftware.imagescal": {
        "source": "iana"
    },
    "application/vnd.3m.post-it-notes": {
        "source": "iana",
        "extensions": [
            "pwn"
        ]
    },
    "application/vnd.accpac.simply.aso": {
        "source": "iana",
        "extensions": [
            "aso"
        ]
    },
    "application/vnd.accpac.simply.imp": {
        "source": "iana",
        "extensions": [
            "imp"
        ]
    },
    "application/vnd.acucobol": {
        "source": "iana",
        "extensions": [
            "acu"
        ]
    },
    "application/vnd.acucorp": {
        "source": "iana",
        "extensions": [
            "atc",
            "acutc"
        ]
    },
    "application/vnd.adobe.air-application-installer-package+zip": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "air"
        ]
    },
    "application/vnd.adobe.flash.movie": {
        "source": "iana"
    },
    "application/vnd.adobe.formscentral.fcdt": {
        "source": "iana",
        "extensions": [
            "fcdt"
        ]
    },
    "application/vnd.adobe.fxp": {
        "source": "iana",
        "extensions": [
            "fxp",
            "fxpl"
        ]
    },
    "application/vnd.adobe.partial-upload": {
        "source": "iana"
    },
    "application/vnd.adobe.xdp+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xdp"
        ]
    },
    "application/vnd.adobe.xfdf": {
        "source": "iana",
        "extensions": [
            "xfdf"
        ]
    },
    "application/vnd.aether.imp": {
        "source": "iana"
    },
    "application/vnd.afpc.afplinedata": {
        "source": "iana"
    },
    "application/vnd.afpc.afplinedata-pagedef": {
        "source": "iana"
    },
    "application/vnd.afpc.cmoca-cmresource": {
        "source": "iana"
    },
    "application/vnd.afpc.foca-charset": {
        "source": "iana"
    },
    "application/vnd.afpc.foca-codedfont": {
        "source": "iana"
    },
    "application/vnd.afpc.foca-codepage": {
        "source": "iana"
    },
    "application/vnd.afpc.modca": {
        "source": "iana"
    },
    "application/vnd.afpc.modca-cmtable": {
        "source": "iana"
    },
    "application/vnd.afpc.modca-formdef": {
        "source": "iana"
    },
    "application/vnd.afpc.modca-mediummap": {
        "source": "iana"
    },
    "application/vnd.afpc.modca-objectcontainer": {
        "source": "iana"
    },
    "application/vnd.afpc.modca-overlay": {
        "source": "iana"
    },
    "application/vnd.afpc.modca-pagesegment": {
        "source": "iana"
    },
    "application/vnd.age": {
        "source": "iana",
        "extensions": [
            "age"
        ]
    },
    "application/vnd.ah-barcode": {
        "source": "iana"
    },
    "application/vnd.ahead.space": {
        "source": "iana",
        "extensions": [
            "ahead"
        ]
    },
    "application/vnd.airzip.filesecure.azf": {
        "source": "iana",
        "extensions": [
            "azf"
        ]
    },
    "application/vnd.airzip.filesecure.azs": {
        "source": "iana",
        "extensions": [
            "azs"
        ]
    },
    "application/vnd.amadeus+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.amazon.ebook": {
        "source": "apache",
        "extensions": [
            "azw"
        ]
    },
    "application/vnd.amazon.mobi8-ebook": {
        "source": "iana"
    },
    "application/vnd.americandynamics.acc": {
        "source": "iana",
        "extensions": [
            "acc"
        ]
    },
    "application/vnd.amiga.ami": {
        "source": "iana",
        "extensions": [
            "ami"
        ]
    },
    "application/vnd.amundsen.maze+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.android.ota": {
        "source": "iana"
    },
    "application/vnd.android.package-archive": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "apk"
        ]
    },
    "application/vnd.anki": {
        "source": "iana"
    },
    "application/vnd.anser-web-certificate-issue-initiation": {
        "source": "iana",
        "extensions": [
            "cii"
        ]
    },
    "application/vnd.anser-web-funds-transfer-initiation": {
        "source": "apache",
        "extensions": [
            "fti"
        ]
    },
    "application/vnd.antix.game-component": {
        "source": "iana",
        "extensions": [
            "atx"
        ]
    },
    "application/vnd.apache.arrow.file": {
        "source": "iana"
    },
    "application/vnd.apache.arrow.stream": {
        "source": "iana"
    },
    "application/vnd.apache.thrift.binary": {
        "source": "iana"
    },
    "application/vnd.apache.thrift.compact": {
        "source": "iana"
    },
    "application/vnd.apache.thrift.json": {
        "source": "iana"
    },
    "application/vnd.api+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.aplextor.warrp+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.apothekende.reservation+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.apple.installer+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mpkg"
        ]
    },
    "application/vnd.apple.keynote": {
        "source": "iana",
        "extensions": [
            "key"
        ]
    },
    "application/vnd.apple.mpegurl": {
        "source": "iana",
        "extensions": [
            "m3u8"
        ]
    },
    "application/vnd.apple.numbers": {
        "source": "iana",
        "extensions": [
            "numbers"
        ]
    },
    "application/vnd.apple.pages": {
        "source": "iana",
        "extensions": [
            "pages"
        ]
    },
    "application/vnd.apple.pkpass": {
        "compressible": false,
        "extensions": [
            "pkpass"
        ]
    },
    "application/vnd.arastra.swi": {
        "source": "iana"
    },
    "application/vnd.aristanetworks.swi": {
        "source": "iana",
        "extensions": [
            "swi"
        ]
    },
    "application/vnd.artisan+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.artsquare": {
        "source": "iana"
    },
    "application/vnd.astraea-software.iota": {
        "source": "iana",
        "extensions": [
            "iota"
        ]
    },
    "application/vnd.audiograph": {
        "source": "iana",
        "extensions": [
            "aep"
        ]
    },
    "application/vnd.autopackage": {
        "source": "iana"
    },
    "application/vnd.avalon+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.avistar+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.balsamiq.bmml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "bmml"
        ]
    },
    "application/vnd.balsamiq.bmpr": {
        "source": "iana"
    },
    "application/vnd.banana-accounting": {
        "source": "iana"
    },
    "application/vnd.bbf.usp.error": {
        "source": "iana"
    },
    "application/vnd.bbf.usp.msg": {
        "source": "iana"
    },
    "application/vnd.bbf.usp.msg+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.bekitzur-stech+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.bint.med-content": {
        "source": "iana"
    },
    "application/vnd.biopax.rdf+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.blink-idb-value-wrapper": {
        "source": "iana"
    },
    "application/vnd.blueice.multipass": {
        "source": "iana",
        "extensions": [
            "mpm"
        ]
    },
    "application/vnd.bluetooth.ep.oob": {
        "source": "iana"
    },
    "application/vnd.bluetooth.le.oob": {
        "source": "iana"
    },
    "application/vnd.bmi": {
        "source": "iana",
        "extensions": [
            "bmi"
        ]
    },
    "application/vnd.bpf": {
        "source": "iana"
    },
    "application/vnd.bpf3": {
        "source": "iana"
    },
    "application/vnd.businessobjects": {
        "source": "iana",
        "extensions": [
            "rep"
        ]
    },
    "application/vnd.byu.uapi+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.cab-jscript": {
        "source": "iana"
    },
    "application/vnd.canon-cpdl": {
        "source": "iana"
    },
    "application/vnd.canon-lips": {
        "source": "iana"
    },
    "application/vnd.capasystems-pg+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.cendio.thinlinc.clientconf": {
        "source": "iana"
    },
    "application/vnd.century-systems.tcp_stream": {
        "source": "iana"
    },
    "application/vnd.chemdraw+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "cdxml"
        ]
    },
    "application/vnd.chess-pgn": {
        "source": "iana"
    },
    "application/vnd.chipnuts.karaoke-mmd": {
        "source": "iana",
        "extensions": [
            "mmd"
        ]
    },
    "application/vnd.ciedi": {
        "source": "iana"
    },
    "application/vnd.cinderella": {
        "source": "iana",
        "extensions": [
            "cdy"
        ]
    },
    "application/vnd.cirpack.isdn-ext": {
        "source": "iana"
    },
    "application/vnd.citationstyles.style+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "csl"
        ]
    },
    "application/vnd.claymore": {
        "source": "iana",
        "extensions": [
            "cla"
        ]
    },
    "application/vnd.cloanto.rp9": {
        "source": "iana",
        "extensions": [
            "rp9"
        ]
    },
    "application/vnd.clonk.c4group": {
        "source": "iana",
        "extensions": [
            "c4g",
            "c4d",
            "c4f",
            "c4p",
            "c4u"
        ]
    },
    "application/vnd.cluetrust.cartomobile-config": {
        "source": "iana",
        "extensions": [
            "c11amc"
        ]
    },
    "application/vnd.cluetrust.cartomobile-config-pkg": {
        "source": "iana",
        "extensions": [
            "c11amz"
        ]
    },
    "application/vnd.coffeescript": {
        "source": "iana"
    },
    "application/vnd.collabio.xodocuments.document": {
        "source": "iana"
    },
    "application/vnd.collabio.xodocuments.document-template": {
        "source": "iana"
    },
    "application/vnd.collabio.xodocuments.presentation": {
        "source": "iana"
    },
    "application/vnd.collabio.xodocuments.presentation-template": {
        "source": "iana"
    },
    "application/vnd.collabio.xodocuments.spreadsheet": {
        "source": "iana"
    },
    "application/vnd.collabio.xodocuments.spreadsheet-template": {
        "source": "iana"
    },
    "application/vnd.collection+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.collection.doc+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.collection.next+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.comicbook+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.comicbook-rar": {
        "source": "iana"
    },
    "application/vnd.commerce-battelle": {
        "source": "iana"
    },
    "application/vnd.commonspace": {
        "source": "iana",
        "extensions": [
            "csp"
        ]
    },
    "application/vnd.contact.cmsg": {
        "source": "iana",
        "extensions": [
            "cdbcmsg"
        ]
    },
    "application/vnd.coreos.ignition+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.cosmocaller": {
        "source": "iana",
        "extensions": [
            "cmc"
        ]
    },
    "application/vnd.crick.clicker": {
        "source": "iana",
        "extensions": [
            "clkx"
        ]
    },
    "application/vnd.crick.clicker.keyboard": {
        "source": "iana",
        "extensions": [
            "clkk"
        ]
    },
    "application/vnd.crick.clicker.palette": {
        "source": "iana",
        "extensions": [
            "clkp"
        ]
    },
    "application/vnd.crick.clicker.template": {
        "source": "iana",
        "extensions": [
            "clkt"
        ]
    },
    "application/vnd.crick.clicker.wordbank": {
        "source": "iana",
        "extensions": [
            "clkw"
        ]
    },
    "application/vnd.criticaltools.wbs+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "wbs"
        ]
    },
    "application/vnd.cryptii.pipe+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.crypto-shade-file": {
        "source": "iana"
    },
    "application/vnd.cryptomator.encrypted": {
        "source": "iana"
    },
    "application/vnd.cryptomator.vault": {
        "source": "iana"
    },
    "application/vnd.ctc-posml": {
        "source": "iana",
        "extensions": [
            "pml"
        ]
    },
    "application/vnd.ctct.ws+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.cups-pdf": {
        "source": "iana"
    },
    "application/vnd.cups-postscript": {
        "source": "iana"
    },
    "application/vnd.cups-ppd": {
        "source": "iana",
        "extensions": [
            "ppd"
        ]
    },
    "application/vnd.cups-raster": {
        "source": "iana"
    },
    "application/vnd.cups-raw": {
        "source": "iana"
    },
    "application/vnd.curl": {
        "source": "iana"
    },
    "application/vnd.curl.car": {
        "source": "apache",
        "extensions": [
            "car"
        ]
    },
    "application/vnd.curl.pcurl": {
        "source": "apache",
        "extensions": [
            "pcurl"
        ]
    },
    "application/vnd.cyan.dean.root+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.cybank": {
        "source": "iana"
    },
    "application/vnd.cyclonedx+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.cyclonedx+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.d2l.coursepackage1p0+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.d3m-dataset": {
        "source": "iana"
    },
    "application/vnd.d3m-problem": {
        "source": "iana"
    },
    "application/vnd.dart": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "dart"
        ]
    },
    "application/vnd.data-vision.rdz": {
        "source": "iana",
        "extensions": [
            "rdz"
        ]
    },
    "application/vnd.datapackage+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dataresource+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dbf": {
        "source": "iana",
        "extensions": [
            "dbf"
        ]
    },
    "application/vnd.debian.binary-package": {
        "source": "iana"
    },
    "application/vnd.dece.data": {
        "source": "iana",
        "extensions": [
            "uvf",
            "uvvf",
            "uvd",
            "uvvd"
        ]
    },
    "application/vnd.dece.ttml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "uvt",
            "uvvt"
        ]
    },
    "application/vnd.dece.unspecified": {
        "source": "iana",
        "extensions": [
            "uvx",
            "uvvx"
        ]
    },
    "application/vnd.dece.zip": {
        "source": "iana",
        "extensions": [
            "uvz",
            "uvvz"
        ]
    },
    "application/vnd.denovo.fcselayout-link": {
        "source": "iana",
        "extensions": [
            "fe_launch"
        ]
    },
    "application/vnd.desmume.movie": {
        "source": "iana"
    },
    "application/vnd.dir-bi.plate-dl-nosuffix": {
        "source": "iana"
    },
    "application/vnd.dm.delegation+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dna": {
        "source": "iana",
        "extensions": [
            "dna"
        ]
    },
    "application/vnd.document+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dolby.mlp": {
        "source": "apache",
        "extensions": [
            "mlp"
        ]
    },
    "application/vnd.dolby.mobile.1": {
        "source": "iana"
    },
    "application/vnd.dolby.mobile.2": {
        "source": "iana"
    },
    "application/vnd.doremir.scorecloud-binary-document": {
        "source": "iana"
    },
    "application/vnd.dpgraph": {
        "source": "iana",
        "extensions": [
            "dpg"
        ]
    },
    "application/vnd.dreamfactory": {
        "source": "iana",
        "extensions": [
            "dfac"
        ]
    },
    "application/vnd.drive+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ds-keypoint": {
        "source": "apache",
        "extensions": [
            "kpxx"
        ]
    },
    "application/vnd.dtg.local": {
        "source": "iana"
    },
    "application/vnd.dtg.local.flash": {
        "source": "iana"
    },
    "application/vnd.dtg.local.html": {
        "source": "iana"
    },
    "application/vnd.dvb.ait": {
        "source": "iana",
        "extensions": [
            "ait"
        ]
    },
    "application/vnd.dvb.dvbisl+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dvb.dvbj": {
        "source": "iana"
    },
    "application/vnd.dvb.esgcontainer": {
        "source": "iana"
    },
    "application/vnd.dvb.ipdcdftnotifaccess": {
        "source": "iana"
    },
    "application/vnd.dvb.ipdcesgaccess": {
        "source": "iana"
    },
    "application/vnd.dvb.ipdcesgaccess2": {
        "source": "iana"
    },
    "application/vnd.dvb.ipdcesgpdd": {
        "source": "iana"
    },
    "application/vnd.dvb.ipdcroaming": {
        "source": "iana"
    },
    "application/vnd.dvb.iptv.alfec-base": {
        "source": "iana"
    },
    "application/vnd.dvb.iptv.alfec-enhancement": {
        "source": "iana"
    },
    "application/vnd.dvb.notif-aggregate-root+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dvb.notif-container+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dvb.notif-generic+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dvb.notif-ia-msglist+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dvb.notif-ia-registration-request+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dvb.notif-ia-registration-response+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dvb.notif-init+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.dvb.pfr": {
        "source": "iana"
    },
    "application/vnd.dvb.service": {
        "source": "iana",
        "extensions": [
            "svc"
        ]
    },
    "application/vnd.dxr": {
        "source": "iana"
    },
    "application/vnd.dynageo": {
        "source": "iana",
        "extensions": [
            "geo"
        ]
    },
    "application/vnd.dzr": {
        "source": "iana"
    },
    "application/vnd.easykaraoke.cdgdownload": {
        "source": "iana"
    },
    "application/vnd.ecdis-update": {
        "source": "iana"
    },
    "application/vnd.ecip.rlp": {
        "source": "iana"
    },
    "application/vnd.eclipse.ditto+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ecowin.chart": {
        "source": "iana",
        "extensions": [
            "mag"
        ]
    },
    "application/vnd.ecowin.filerequest": {
        "source": "iana"
    },
    "application/vnd.ecowin.fileupdate": {
        "source": "iana"
    },
    "application/vnd.ecowin.series": {
        "source": "iana"
    },
    "application/vnd.ecowin.seriesrequest": {
        "source": "iana"
    },
    "application/vnd.ecowin.seriesupdate": {
        "source": "iana"
    },
    "application/vnd.efi.img": {
        "source": "iana"
    },
    "application/vnd.efi.iso": {
        "source": "iana"
    },
    "application/vnd.emclient.accessrequest+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.enliven": {
        "source": "iana",
        "extensions": [
            "nml"
        ]
    },
    "application/vnd.enphase.envoy": {
        "source": "iana"
    },
    "application/vnd.eprints.data+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.epson.esf": {
        "source": "iana",
        "extensions": [
            "esf"
        ]
    },
    "application/vnd.epson.msf": {
        "source": "iana",
        "extensions": [
            "msf"
        ]
    },
    "application/vnd.epson.quickanime": {
        "source": "iana",
        "extensions": [
            "qam"
        ]
    },
    "application/vnd.epson.salt": {
        "source": "iana",
        "extensions": [
            "slt"
        ]
    },
    "application/vnd.epson.ssf": {
        "source": "iana",
        "extensions": [
            "ssf"
        ]
    },
    "application/vnd.ericsson.quickcall": {
        "source": "iana"
    },
    "application/vnd.espass-espass+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.eszigno3+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "es3",
            "et3"
        ]
    },
    "application/vnd.etsi.aoc+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.asic-e+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.etsi.asic-s+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.etsi.cug+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvcommand+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvdiscovery+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvprofile+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvsad-bc+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvsad-cod+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvsad-npvr+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvservice+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvsync+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.iptvueprofile+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.mcid+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.mheg5": {
        "source": "iana"
    },
    "application/vnd.etsi.overload-control-policy-dataset+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.pstn+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.sci+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.simservs+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.timestamp-token": {
        "source": "iana"
    },
    "application/vnd.etsi.tsl+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.etsi.tsl.der": {
        "source": "iana"
    },
    "application/vnd.eu.kasparian.car+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.eudora.data": {
        "source": "iana"
    },
    "application/vnd.evolv.ecig.profile": {
        "source": "iana"
    },
    "application/vnd.evolv.ecig.settings": {
        "source": "iana"
    },
    "application/vnd.evolv.ecig.theme": {
        "source": "iana"
    },
    "application/vnd.exstream-empower+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.exstream-package": {
        "source": "iana"
    },
    "application/vnd.ezpix-album": {
        "source": "iana",
        "extensions": [
            "ez2"
        ]
    },
    "application/vnd.ezpix-package": {
        "source": "iana",
        "extensions": [
            "ez3"
        ]
    },
    "application/vnd.f-secure.mobile": {
        "source": "iana"
    },
    "application/vnd.familysearch.gedcom+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.fastcopy-disk-image": {
        "source": "iana"
    },
    "application/vnd.fdf": {
        "source": "iana",
        "extensions": [
            "fdf"
        ]
    },
    "application/vnd.fdsn.mseed": {
        "source": "iana",
        "extensions": [
            "mseed"
        ]
    },
    "application/vnd.fdsn.seed": {
        "source": "iana",
        "extensions": [
            "seed",
            "dataless"
        ]
    },
    "application/vnd.ffsns": {
        "source": "iana"
    },
    "application/vnd.ficlab.flb+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.filmit.zfc": {
        "source": "iana"
    },
    "application/vnd.fints": {
        "source": "iana"
    },
    "application/vnd.firemonkeys.cloudcell": {
        "source": "iana"
    },
    "application/vnd.flographit": {
        "source": "iana",
        "extensions": [
            "gph"
        ]
    },
    "application/vnd.fluxtime.clip": {
        "source": "iana",
        "extensions": [
            "ftc"
        ]
    },
    "application/vnd.font-fontforge-sfd": {
        "source": "iana"
    },
    "application/vnd.framemaker": {
        "source": "iana",
        "extensions": [
            "fm",
            "frame",
            "maker",
            "book"
        ]
    },
    "application/vnd.frogans.fnc": {
        "source": "iana",
        "extensions": [
            "fnc"
        ]
    },
    "application/vnd.frogans.ltf": {
        "source": "iana",
        "extensions": [
            "ltf"
        ]
    },
    "application/vnd.fsc.weblaunch": {
        "source": "iana",
        "extensions": [
            "fsc"
        ]
    },
    "application/vnd.fujifilm.fb.docuworks": {
        "source": "iana"
    },
    "application/vnd.fujifilm.fb.docuworks.binder": {
        "source": "iana"
    },
    "application/vnd.fujifilm.fb.docuworks.container": {
        "source": "iana"
    },
    "application/vnd.fujifilm.fb.jfi+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.fujitsu.oasys": {
        "source": "iana",
        "extensions": [
            "oas"
        ]
    },
    "application/vnd.fujitsu.oasys2": {
        "source": "iana",
        "extensions": [
            "oa2"
        ]
    },
    "application/vnd.fujitsu.oasys3": {
        "source": "iana",
        "extensions": [
            "oa3"
        ]
    },
    "application/vnd.fujitsu.oasysgp": {
        "source": "iana",
        "extensions": [
            "fg5"
        ]
    },
    "application/vnd.fujitsu.oasysprs": {
        "source": "iana",
        "extensions": [
            "bh2"
        ]
    },
    "application/vnd.fujixerox.art-ex": {
        "source": "iana"
    },
    "application/vnd.fujixerox.art4": {
        "source": "iana"
    },
    "application/vnd.fujixerox.ddd": {
        "source": "iana",
        "extensions": [
            "ddd"
        ]
    },
    "application/vnd.fujixerox.docuworks": {
        "source": "iana",
        "extensions": [
            "xdw"
        ]
    },
    "application/vnd.fujixerox.docuworks.binder": {
        "source": "iana",
        "extensions": [
            "xbd"
        ]
    },
    "application/vnd.fujixerox.docuworks.container": {
        "source": "iana"
    },
    "application/vnd.fujixerox.hbpl": {
        "source": "iana"
    },
    "application/vnd.fut-misnet": {
        "source": "iana"
    },
    "application/vnd.futoin+cbor": {
        "source": "iana"
    },
    "application/vnd.futoin+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.fuzzysheet": {
        "source": "iana",
        "extensions": [
            "fzs"
        ]
    },
    "application/vnd.genomatix.tuxedo": {
        "source": "iana",
        "extensions": [
            "txd"
        ]
    },
    "application/vnd.gentics.grd+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.geo+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.geocube+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.geogebra.file": {
        "source": "iana",
        "extensions": [
            "ggb"
        ]
    },
    "application/vnd.geogebra.slides": {
        "source": "iana"
    },
    "application/vnd.geogebra.tool": {
        "source": "iana",
        "extensions": [
            "ggt"
        ]
    },
    "application/vnd.geometry-explorer": {
        "source": "iana",
        "extensions": [
            "gex",
            "gre"
        ]
    },
    "application/vnd.geonext": {
        "source": "iana",
        "extensions": [
            "gxt"
        ]
    },
    "application/vnd.geoplan": {
        "source": "iana",
        "extensions": [
            "g2w"
        ]
    },
    "application/vnd.geospace": {
        "source": "iana",
        "extensions": [
            "g3w"
        ]
    },
    "application/vnd.gerber": {
        "source": "iana"
    },
    "application/vnd.globalplatform.card-content-mgt": {
        "source": "iana"
    },
    "application/vnd.globalplatform.card-content-mgt-response": {
        "source": "iana"
    },
    "application/vnd.gmx": {
        "source": "iana",
        "extensions": [
            "gmx"
        ]
    },
    "application/vnd.google-apps.document": {
        "compressible": false,
        "extensions": [
            "gdoc"
        ]
    },
    "application/vnd.google-apps.presentation": {
        "compressible": false,
        "extensions": [
            "gslides"
        ]
    },
    "application/vnd.google-apps.spreadsheet": {
        "compressible": false,
        "extensions": [
            "gsheet"
        ]
    },
    "application/vnd.google-earth.kml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "kml"
        ]
    },
    "application/vnd.google-earth.kmz": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "kmz"
        ]
    },
    "application/vnd.gov.sk.e-form+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.gov.sk.e-form+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.gov.sk.xmldatacontainer+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.grafeq": {
        "source": "iana",
        "extensions": [
            "gqf",
            "gqs"
        ]
    },
    "application/vnd.gridmp": {
        "source": "iana"
    },
    "application/vnd.groove-account": {
        "source": "iana",
        "extensions": [
            "gac"
        ]
    },
    "application/vnd.groove-help": {
        "source": "iana",
        "extensions": [
            "ghf"
        ]
    },
    "application/vnd.groove-identity-message": {
        "source": "iana",
        "extensions": [
            "gim"
        ]
    },
    "application/vnd.groove-injector": {
        "source": "iana",
        "extensions": [
            "grv"
        ]
    },
    "application/vnd.groove-tool-message": {
        "source": "iana",
        "extensions": [
            "gtm"
        ]
    },
    "application/vnd.groove-tool-template": {
        "source": "iana",
        "extensions": [
            "tpl"
        ]
    },
    "application/vnd.groove-vcard": {
        "source": "iana",
        "extensions": [
            "vcg"
        ]
    },
    "application/vnd.hal+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.hal+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "hal"
        ]
    },
    "application/vnd.handheld-entertainment+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "zmm"
        ]
    },
    "application/vnd.hbci": {
        "source": "iana",
        "extensions": [
            "hbci"
        ]
    },
    "application/vnd.hc+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.hcl-bireports": {
        "source": "iana"
    },
    "application/vnd.hdt": {
        "source": "iana"
    },
    "application/vnd.heroku+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.hhe.lesson-player": {
        "source": "iana",
        "extensions": [
            "les"
        ]
    },
    "application/vnd.hl7cda+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/vnd.hl7v2+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/vnd.hp-hpgl": {
        "source": "iana",
        "extensions": [
            "hpgl"
        ]
    },
    "application/vnd.hp-hpid": {
        "source": "iana",
        "extensions": [
            "hpid"
        ]
    },
    "application/vnd.hp-hps": {
        "source": "iana",
        "extensions": [
            "hps"
        ]
    },
    "application/vnd.hp-jlyt": {
        "source": "iana",
        "extensions": [
            "jlt"
        ]
    },
    "application/vnd.hp-pcl": {
        "source": "iana",
        "extensions": [
            "pcl"
        ]
    },
    "application/vnd.hp-pclxl": {
        "source": "iana",
        "extensions": [
            "pclxl"
        ]
    },
    "application/vnd.httphone": {
        "source": "iana"
    },
    "application/vnd.hydrostatix.sof-data": {
        "source": "iana",
        "extensions": [
            "sfd-hdstx"
        ]
    },
    "application/vnd.hyper+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.hyper-item+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.hyperdrive+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.hzn-3d-crossword": {
        "source": "iana"
    },
    "application/vnd.ibm.afplinedata": {
        "source": "iana"
    },
    "application/vnd.ibm.electronic-media": {
        "source": "iana"
    },
    "application/vnd.ibm.minipay": {
        "source": "iana",
        "extensions": [
            "mpy"
        ]
    },
    "application/vnd.ibm.modcap": {
        "source": "iana",
        "extensions": [
            "afp",
            "listafp",
            "list3820"
        ]
    },
    "application/vnd.ibm.rights-management": {
        "source": "iana",
        "extensions": [
            "irm"
        ]
    },
    "application/vnd.ibm.secure-container": {
        "source": "iana",
        "extensions": [
            "sc"
        ]
    },
    "application/vnd.iccprofile": {
        "source": "iana",
        "extensions": [
            "icc",
            "icm"
        ]
    },
    "application/vnd.ieee.1905": {
        "source": "iana"
    },
    "application/vnd.igloader": {
        "source": "iana",
        "extensions": [
            "igl"
        ]
    },
    "application/vnd.imagemeter.folder+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.imagemeter.image+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.immervision-ivp": {
        "source": "iana",
        "extensions": [
            "ivp"
        ]
    },
    "application/vnd.immervision-ivu": {
        "source": "iana",
        "extensions": [
            "ivu"
        ]
    },
    "application/vnd.ims.imsccv1p1": {
        "source": "iana"
    },
    "application/vnd.ims.imsccv1p2": {
        "source": "iana"
    },
    "application/vnd.ims.imsccv1p3": {
        "source": "iana"
    },
    "application/vnd.ims.lis.v2.result+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ims.lti.v2.toolconsumerprofile+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ims.lti.v2.toolproxy+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ims.lti.v2.toolproxy.id+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ims.lti.v2.toolsettings+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ims.lti.v2.toolsettings.simple+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.informedcontrol.rms+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.informix-visionary": {
        "source": "iana"
    },
    "application/vnd.infotech.project": {
        "source": "iana"
    },
    "application/vnd.infotech.project+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.innopath.wamp.notification": {
        "source": "iana"
    },
    "application/vnd.insors.igm": {
        "source": "iana",
        "extensions": [
            "igm"
        ]
    },
    "application/vnd.intercon.formnet": {
        "source": "iana",
        "extensions": [
            "xpw",
            "xpx"
        ]
    },
    "application/vnd.intergeo": {
        "source": "iana",
        "extensions": [
            "i2g"
        ]
    },
    "application/vnd.intertrust.digibox": {
        "source": "iana"
    },
    "application/vnd.intertrust.nncp": {
        "source": "iana"
    },
    "application/vnd.intu.qbo": {
        "source": "iana",
        "extensions": [
            "qbo"
        ]
    },
    "application/vnd.intu.qfx": {
        "source": "iana",
        "extensions": [
            "qfx"
        ]
    },
    "application/vnd.iptc.g2.catalogitem+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.iptc.g2.conceptitem+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.iptc.g2.knowledgeitem+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.iptc.g2.newsitem+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.iptc.g2.newsmessage+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.iptc.g2.packageitem+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.iptc.g2.planningitem+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ipunplugged.rcprofile": {
        "source": "iana",
        "extensions": [
            "rcprofile"
        ]
    },
    "application/vnd.irepository.package+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "irp"
        ]
    },
    "application/vnd.is-xpr": {
        "source": "iana",
        "extensions": [
            "xpr"
        ]
    },
    "application/vnd.isac.fcs": {
        "source": "iana",
        "extensions": [
            "fcs"
        ]
    },
    "application/vnd.iso11783-10+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.jam": {
        "source": "iana",
        "extensions": [
            "jam"
        ]
    },
    "application/vnd.japannet-directory-service": {
        "source": "iana"
    },
    "application/vnd.japannet-jpnstore-wakeup": {
        "source": "iana"
    },
    "application/vnd.japannet-payment-wakeup": {
        "source": "iana"
    },
    "application/vnd.japannet-registration": {
        "source": "iana"
    },
    "application/vnd.japannet-registration-wakeup": {
        "source": "iana"
    },
    "application/vnd.japannet-setstore-wakeup": {
        "source": "iana"
    },
    "application/vnd.japannet-verification": {
        "source": "iana"
    },
    "application/vnd.japannet-verification-wakeup": {
        "source": "iana"
    },
    "application/vnd.jcp.javame.midlet-rms": {
        "source": "iana",
        "extensions": [
            "rms"
        ]
    },
    "application/vnd.jisp": {
        "source": "iana",
        "extensions": [
            "jisp"
        ]
    },
    "application/vnd.joost.joda-archive": {
        "source": "iana",
        "extensions": [
            "joda"
        ]
    },
    "application/vnd.jsk.isdn-ngn": {
        "source": "iana"
    },
    "application/vnd.kahootz": {
        "source": "iana",
        "extensions": [
            "ktz",
            "ktr"
        ]
    },
    "application/vnd.kde.karbon": {
        "source": "iana",
        "extensions": [
            "karbon"
        ]
    },
    "application/vnd.kde.kchart": {
        "source": "iana",
        "extensions": [
            "chrt"
        ]
    },
    "application/vnd.kde.kformula": {
        "source": "iana",
        "extensions": [
            "kfo"
        ]
    },
    "application/vnd.kde.kivio": {
        "source": "iana",
        "extensions": [
            "flw"
        ]
    },
    "application/vnd.kde.kontour": {
        "source": "iana",
        "extensions": [
            "kon"
        ]
    },
    "application/vnd.kde.kpresenter": {
        "source": "iana",
        "extensions": [
            "kpr",
            "kpt"
        ]
    },
    "application/vnd.kde.kspread": {
        "source": "iana",
        "extensions": [
            "ksp"
        ]
    },
    "application/vnd.kde.kword": {
        "source": "iana",
        "extensions": [
            "kwd",
            "kwt"
        ]
    },
    "application/vnd.kenameaapp": {
        "source": "iana",
        "extensions": [
            "htke"
        ]
    },
    "application/vnd.kidspiration": {
        "source": "iana",
        "extensions": [
            "kia"
        ]
    },
    "application/vnd.kinar": {
        "source": "iana",
        "extensions": [
            "kne",
            "knp"
        ]
    },
    "application/vnd.koan": {
        "source": "iana",
        "extensions": [
            "skp",
            "skd",
            "skt",
            "skm"
        ]
    },
    "application/vnd.kodak-descriptor": {
        "source": "iana",
        "extensions": [
            "sse"
        ]
    },
    "application/vnd.las": {
        "source": "iana"
    },
    "application/vnd.las.las+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.las.las+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "lasxml"
        ]
    },
    "application/vnd.laszip": {
        "source": "iana"
    },
    "application/vnd.leap+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.liberty-request+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.llamagraphics.life-balance.desktop": {
        "source": "iana",
        "extensions": [
            "lbd"
        ]
    },
    "application/vnd.llamagraphics.life-balance.exchange+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "lbe"
        ]
    },
    "application/vnd.logipipe.circuit+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.loom": {
        "source": "iana"
    },
    "application/vnd.lotus-1-2-3": {
        "source": "iana",
        "extensions": [
            "123"
        ]
    },
    "application/vnd.lotus-approach": {
        "source": "iana",
        "extensions": [
            "apr"
        ]
    },
    "application/vnd.lotus-freelance": {
        "source": "iana",
        "extensions": [
            "pre"
        ]
    },
    "application/vnd.lotus-notes": {
        "source": "iana",
        "extensions": [
            "nsf"
        ]
    },
    "application/vnd.lotus-organizer": {
        "source": "iana",
        "extensions": [
            "org"
        ]
    },
    "application/vnd.lotus-screencam": {
        "source": "iana",
        "extensions": [
            "scm"
        ]
    },
    "application/vnd.lotus-wordpro": {
        "source": "iana",
        "extensions": [
            "lwp"
        ]
    },
    "application/vnd.macports.portpkg": {
        "source": "iana",
        "extensions": [
            "portpkg"
        ]
    },
    "application/vnd.mapbox-vector-tile": {
        "source": "iana",
        "extensions": [
            "mvt"
        ]
    },
    "application/vnd.marlin.drm.actiontoken+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.marlin.drm.conftoken+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.marlin.drm.license+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.marlin.drm.mdcf": {
        "source": "iana"
    },
    "application/vnd.mason+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.maxar.archive.3tz+zip": {
        "source": "iana",
        "compressible": false
    },
    "application/vnd.maxmind.maxmind-db": {
        "source": "iana"
    },
    "application/vnd.mcd": {
        "source": "iana",
        "extensions": [
            "mcd"
        ]
    },
    "application/vnd.medcalcdata": {
        "source": "iana",
        "extensions": [
            "mc1"
        ]
    },
    "application/vnd.mediastation.cdkey": {
        "source": "iana",
        "extensions": [
            "cdkey"
        ]
    },
    "application/vnd.meridian-slingshot": {
        "source": "iana"
    },
    "application/vnd.mfer": {
        "source": "iana",
        "extensions": [
            "mwf"
        ]
    },
    "application/vnd.mfmp": {
        "source": "iana",
        "extensions": [
            "mfm"
        ]
    },
    "application/vnd.micro+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.micrografx.flo": {
        "source": "iana",
        "extensions": [
            "flo"
        ]
    },
    "application/vnd.micrografx.igx": {
        "source": "iana",
        "extensions": [
            "igx"
        ]
    },
    "application/vnd.microsoft.portable-executable": {
        "source": "iana"
    },
    "application/vnd.microsoft.windows.thumbnail-cache": {
        "source": "iana"
    },
    "application/vnd.miele+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.mif": {
        "source": "iana",
        "extensions": [
            "mif"
        ]
    },
    "application/vnd.minisoft-hp3000-save": {
        "source": "iana"
    },
    "application/vnd.mitsubishi.misty-guard.trustweb": {
        "source": "iana"
    },
    "application/vnd.mobius.daf": {
        "source": "iana",
        "extensions": [
            "daf"
        ]
    },
    "application/vnd.mobius.dis": {
        "source": "iana",
        "extensions": [
            "dis"
        ]
    },
    "application/vnd.mobius.mbk": {
        "source": "iana",
        "extensions": [
            "mbk"
        ]
    },
    "application/vnd.mobius.mqy": {
        "source": "iana",
        "extensions": [
            "mqy"
        ]
    },
    "application/vnd.mobius.msl": {
        "source": "iana",
        "extensions": [
            "msl"
        ]
    },
    "application/vnd.mobius.plc": {
        "source": "iana",
        "extensions": [
            "plc"
        ]
    },
    "application/vnd.mobius.txf": {
        "source": "iana",
        "extensions": [
            "txf"
        ]
    },
    "application/vnd.mophun.application": {
        "source": "iana",
        "extensions": [
            "mpn"
        ]
    },
    "application/vnd.mophun.certificate": {
        "source": "iana",
        "extensions": [
            "mpc"
        ]
    },
    "application/vnd.motorola.flexsuite": {
        "source": "iana"
    },
    "application/vnd.motorola.flexsuite.adsi": {
        "source": "iana"
    },
    "application/vnd.motorola.flexsuite.fis": {
        "source": "iana"
    },
    "application/vnd.motorola.flexsuite.gotap": {
        "source": "iana"
    },
    "application/vnd.motorola.flexsuite.kmr": {
        "source": "iana"
    },
    "application/vnd.motorola.flexsuite.ttc": {
        "source": "iana"
    },
    "application/vnd.motorola.flexsuite.wem": {
        "source": "iana"
    },
    "application/vnd.motorola.iprm": {
        "source": "iana"
    },
    "application/vnd.mozilla.xul+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xul"
        ]
    },
    "application/vnd.ms-3mfdocument": {
        "source": "iana"
    },
    "application/vnd.ms-artgalry": {
        "source": "iana",
        "extensions": [
            "cil"
        ]
    },
    "application/vnd.ms-asf": {
        "source": "iana"
    },
    "application/vnd.ms-cab-compressed": {
        "source": "iana",
        "extensions": [
            "cab"
        ]
    },
    "application/vnd.ms-color.iccprofile": {
        "source": "apache"
    },
    "application/vnd.ms-excel": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "xls",
            "xlm",
            "xla",
            "xlc",
            "xlt",
            "xlw"
        ]
    },
    "application/vnd.ms-excel.addin.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "xlam"
        ]
    },
    "application/vnd.ms-excel.sheet.binary.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "xlsb"
        ]
    },
    "application/vnd.ms-excel.sheet.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "xlsm"
        ]
    },
    "application/vnd.ms-excel.template.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "xltm"
        ]
    },
    "application/vnd.ms-fontobject": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "eot"
        ]
    },
    "application/vnd.ms-htmlhelp": {
        "source": "iana",
        "extensions": [
            "chm"
        ]
    },
    "application/vnd.ms-ims": {
        "source": "iana",
        "extensions": [
            "ims"
        ]
    },
    "application/vnd.ms-lrm": {
        "source": "iana",
        "extensions": [
            "lrm"
        ]
    },
    "application/vnd.ms-office.activex+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ms-officetheme": {
        "source": "iana",
        "extensions": [
            "thmx"
        ]
    },
    "application/vnd.ms-opentype": {
        "source": "apache",
        "compressible": true
    },
    "application/vnd.ms-outlook": {
        "compressible": false,
        "extensions": [
            "msg"
        ]
    },
    "application/vnd.ms-package.obfuscated-opentype": {
        "source": "apache"
    },
    "application/vnd.ms-pki.seccat": {
        "source": "apache",
        "extensions": [
            "cat"
        ]
    },
    "application/vnd.ms-pki.stl": {
        "source": "apache",
        "extensions": [
            "stl"
        ]
    },
    "application/vnd.ms-playready.initiator+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ms-powerpoint": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "ppt",
            "pps",
            "pot"
        ]
    },
    "application/vnd.ms-powerpoint.addin.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "ppam"
        ]
    },
    "application/vnd.ms-powerpoint.presentation.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "pptm"
        ]
    },
    "application/vnd.ms-powerpoint.slide.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "sldm"
        ]
    },
    "application/vnd.ms-powerpoint.slideshow.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "ppsm"
        ]
    },
    "application/vnd.ms-powerpoint.template.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "potm"
        ]
    },
    "application/vnd.ms-printdevicecapabilities+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ms-printing.printticket+xml": {
        "source": "apache",
        "compressible": true
    },
    "application/vnd.ms-printschematicket+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ms-project": {
        "source": "iana",
        "extensions": [
            "mpp",
            "mpt"
        ]
    },
    "application/vnd.ms-tnef": {
        "source": "iana"
    },
    "application/vnd.ms-windows.devicepairing": {
        "source": "iana"
    },
    "application/vnd.ms-windows.nwprinting.oob": {
        "source": "iana"
    },
    "application/vnd.ms-windows.printerpairing": {
        "source": "iana"
    },
    "application/vnd.ms-windows.wsd.oob": {
        "source": "iana"
    },
    "application/vnd.ms-wmdrm.lic-chlg-req": {
        "source": "iana"
    },
    "application/vnd.ms-wmdrm.lic-resp": {
        "source": "iana"
    },
    "application/vnd.ms-wmdrm.meter-chlg-req": {
        "source": "iana"
    },
    "application/vnd.ms-wmdrm.meter-resp": {
        "source": "iana"
    },
    "application/vnd.ms-word.document.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "docm"
        ]
    },
    "application/vnd.ms-word.template.macroenabled.12": {
        "source": "iana",
        "extensions": [
            "dotm"
        ]
    },
    "application/vnd.ms-works": {
        "source": "iana",
        "extensions": [
            "wps",
            "wks",
            "wcm",
            "wdb"
        ]
    },
    "application/vnd.ms-wpl": {
        "source": "iana",
        "extensions": [
            "wpl"
        ]
    },
    "application/vnd.ms-xpsdocument": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "xps"
        ]
    },
    "application/vnd.msa-disk-image": {
        "source": "iana"
    },
    "application/vnd.mseq": {
        "source": "iana",
        "extensions": [
            "mseq"
        ]
    },
    "application/vnd.msign": {
        "source": "iana"
    },
    "application/vnd.multiad.creator": {
        "source": "iana"
    },
    "application/vnd.multiad.creator.cif": {
        "source": "iana"
    },
    "application/vnd.music-niff": {
        "source": "iana"
    },
    "application/vnd.musician": {
        "source": "iana",
        "extensions": [
            "mus"
        ]
    },
    "application/vnd.muvee.style": {
        "source": "iana",
        "extensions": [
            "msty"
        ]
    },
    "application/vnd.mynfc": {
        "source": "iana",
        "extensions": [
            "taglet"
        ]
    },
    "application/vnd.nacamar.ybrid+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.ncd.control": {
        "source": "iana"
    },
    "application/vnd.ncd.reference": {
        "source": "iana"
    },
    "application/vnd.nearst.inv+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.nebumind.line": {
        "source": "iana"
    },
    "application/vnd.nervana": {
        "source": "iana"
    },
    "application/vnd.netfpx": {
        "source": "iana"
    },
    "application/vnd.neurolanguage.nlu": {
        "source": "iana",
        "extensions": [
            "nlu"
        ]
    },
    "application/vnd.nimn": {
        "source": "iana"
    },
    "application/vnd.nintendo.nitro.rom": {
        "source": "iana"
    },
    "application/vnd.nintendo.snes.rom": {
        "source": "iana"
    },
    "application/vnd.nitf": {
        "source": "iana",
        "extensions": [
            "ntf",
            "nitf"
        ]
    },
    "application/vnd.noblenet-directory": {
        "source": "iana",
        "extensions": [
            "nnd"
        ]
    },
    "application/vnd.noblenet-sealer": {
        "source": "iana",
        "extensions": [
            "nns"
        ]
    },
    "application/vnd.noblenet-web": {
        "source": "iana",
        "extensions": [
            "nnw"
        ]
    },
    "application/vnd.nokia.catalogs": {
        "source": "iana"
    },
    "application/vnd.nokia.conml+wbxml": {
        "source": "iana"
    },
    "application/vnd.nokia.conml+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.nokia.iptv.config+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.nokia.isds-radio-presets": {
        "source": "iana"
    },
    "application/vnd.nokia.landmark+wbxml": {
        "source": "iana"
    },
    "application/vnd.nokia.landmark+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.nokia.landmarkcollection+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.nokia.n-gage.ac+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "ac"
        ]
    },
    "application/vnd.nokia.n-gage.data": {
        "source": "iana",
        "extensions": [
            "ngdat"
        ]
    },
    "application/vnd.nokia.n-gage.symbian.install": {
        "source": "iana",
        "extensions": [
            "n-gage"
        ]
    },
    "application/vnd.nokia.ncd": {
        "source": "iana"
    },
    "application/vnd.nokia.pcd+wbxml": {
        "source": "iana"
    },
    "application/vnd.nokia.pcd+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.nokia.radio-preset": {
        "source": "iana",
        "extensions": [
            "rpst"
        ]
    },
    "application/vnd.nokia.radio-presets": {
        "source": "iana",
        "extensions": [
            "rpss"
        ]
    },
    "application/vnd.novadigm.edm": {
        "source": "iana",
        "extensions": [
            "edm"
        ]
    },
    "application/vnd.novadigm.edx": {
        "source": "iana",
        "extensions": [
            "edx"
        ]
    },
    "application/vnd.novadigm.ext": {
        "source": "iana",
        "extensions": [
            "ext"
        ]
    },
    "application/vnd.ntt-local.content-share": {
        "source": "iana"
    },
    "application/vnd.ntt-local.file-transfer": {
        "source": "iana"
    },
    "application/vnd.ntt-local.ogw_remote-access": {
        "source": "iana"
    },
    "application/vnd.ntt-local.sip-ta_remote": {
        "source": "iana"
    },
    "application/vnd.ntt-local.sip-ta_tcp_stream": {
        "source": "iana"
    },
    "application/vnd.oasis.opendocument.chart": {
        "source": "iana",
        "extensions": [
            "odc"
        ]
    },
    "application/vnd.oasis.opendocument.chart-template": {
        "source": "iana",
        "extensions": [
            "otc"
        ]
    },
    "application/vnd.oasis.opendocument.database": {
        "source": "iana",
        "extensions": [
            "odb"
        ]
    },
    "application/vnd.oasis.opendocument.formula": {
        "source": "iana",
        "extensions": [
            "odf"
        ]
    },
    "application/vnd.oasis.opendocument.formula-template": {
        "source": "iana",
        "extensions": [
            "odft"
        ]
    },
    "application/vnd.oasis.opendocument.graphics": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "odg"
        ]
    },
    "application/vnd.oasis.opendocument.graphics-template": {
        "source": "iana",
        "extensions": [
            "otg"
        ]
    },
    "application/vnd.oasis.opendocument.image": {
        "source": "iana",
        "extensions": [
            "odi"
        ]
    },
    "application/vnd.oasis.opendocument.image-template": {
        "source": "iana",
        "extensions": [
            "oti"
        ]
    },
    "application/vnd.oasis.opendocument.presentation": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "odp"
        ]
    },
    "application/vnd.oasis.opendocument.presentation-template": {
        "source": "iana",
        "extensions": [
            "otp"
        ]
    },
    "application/vnd.oasis.opendocument.spreadsheet": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "ods"
        ]
    },
    "application/vnd.oasis.opendocument.spreadsheet-template": {
        "source": "iana",
        "extensions": [
            "ots"
        ]
    },
    "application/vnd.oasis.opendocument.text": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "odt"
        ]
    },
    "application/vnd.oasis.opendocument.text-master": {
        "source": "iana",
        "extensions": [
            "odm"
        ]
    },
    "application/vnd.oasis.opendocument.text-template": {
        "source": "iana",
        "extensions": [
            "ott"
        ]
    },
    "application/vnd.oasis.opendocument.text-web": {
        "source": "iana",
        "extensions": [
            "oth"
        ]
    },
    "application/vnd.obn": {
        "source": "iana"
    },
    "application/vnd.ocf+cbor": {
        "source": "iana"
    },
    "application/vnd.oci.image.manifest.v1+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oftn.l10n+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.contentaccessdownload+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.contentaccessstreaming+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.cspg-hexbinary": {
        "source": "iana"
    },
    "application/vnd.oipf.dae.svg+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.dae.xhtml+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.mippvcontrolmessage+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.pae.gem": {
        "source": "iana"
    },
    "application/vnd.oipf.spdiscovery+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.spdlist+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.ueprofile+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oipf.userprofile+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.olpc-sugar": {
        "source": "iana",
        "extensions": [
            "xo"
        ]
    },
    "application/vnd.oma-scws-config": {
        "source": "iana"
    },
    "application/vnd.oma-scws-http-request": {
        "source": "iana"
    },
    "application/vnd.oma-scws-http-response": {
        "source": "iana"
    },
    "application/vnd.oma.bcast.associated-procedure-parameter+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.bcast.drm-trigger+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.bcast.imd+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.bcast.ltkm": {
        "source": "iana"
    },
    "application/vnd.oma.bcast.notification+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.bcast.provisioningtrigger": {
        "source": "iana"
    },
    "application/vnd.oma.bcast.sgboot": {
        "source": "iana"
    },
    "application/vnd.oma.bcast.sgdd+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.bcast.sgdu": {
        "source": "iana"
    },
    "application/vnd.oma.bcast.simple-symbol-container": {
        "source": "iana"
    },
    "application/vnd.oma.bcast.smartcard-trigger+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.bcast.sprov+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.bcast.stkm": {
        "source": "iana"
    },
    "application/vnd.oma.cab-address-book+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.cab-feature-handler+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.cab-pcc+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.cab-subs-invite+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.cab-user-prefs+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.dcd": {
        "source": "iana"
    },
    "application/vnd.oma.dcdc": {
        "source": "iana"
    },
    "application/vnd.oma.dd2+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "dd2"
        ]
    },
    "application/vnd.oma.drm.risd+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.group-usage-list+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.lwm2m+cbor": {
        "source": "iana"
    },
    "application/vnd.oma.lwm2m+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.lwm2m+tlv": {
        "source": "iana"
    },
    "application/vnd.oma.pal+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.poc.detailed-progress-report+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.poc.final-report+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.poc.groups+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.poc.invocation-descriptor+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.poc.optimized-progress-report+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.push": {
        "source": "iana"
    },
    "application/vnd.oma.scidm.messages+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oma.xcap-directory+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.omads-email+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/vnd.omads-file+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/vnd.omads-folder+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/vnd.omaloc-supl-init": {
        "source": "iana"
    },
    "application/vnd.onepager": {
        "source": "iana"
    },
    "application/vnd.onepagertamp": {
        "source": "iana"
    },
    "application/vnd.onepagertamx": {
        "source": "iana"
    },
    "application/vnd.onepagertat": {
        "source": "iana"
    },
    "application/vnd.onepagertatp": {
        "source": "iana"
    },
    "application/vnd.onepagertatx": {
        "source": "iana"
    },
    "application/vnd.openblox.game+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "obgx"
        ]
    },
    "application/vnd.openblox.game-binary": {
        "source": "iana"
    },
    "application/vnd.openeye.oeb": {
        "source": "iana"
    },
    "application/vnd.openofficeorg.extension": {
        "source": "apache",
        "extensions": [
            "oxt"
        ]
    },
    "application/vnd.openstreetmap.data+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "osm"
        ]
    },
    "application/vnd.opentimestamps.ots": {
        "source": "iana"
    },
    "application/vnd.openxmlformats-officedocument.custom-properties+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.customxmlproperties+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.drawing+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.diagramcolors+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.diagramdata+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.diagramlayout+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.drawingml.diagramstyle+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.extended-properties+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.commentauthors+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.comments+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.handoutmaster+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.notesmaster+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.notesslide+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "pptx"
        ]
    },
    "application/vnd.openxmlformats-officedocument.presentationml.presentation.main+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.presprops+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slide": {
        "source": "iana",
        "extensions": [
            "sldx"
        ]
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slide+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slidelayout+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slidemaster+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slideshow": {
        "source": "iana",
        "extensions": [
            "ppsx"
        ]
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slideshow.main+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.slideupdateinfo+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.tablestyles+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.tags+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.template": {
        "source": "iana",
        "extensions": [
            "potx"
        ]
    },
    "application/vnd.openxmlformats-officedocument.presentationml.template.main+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.presentationml.viewprops+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.calcchain+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.externallink+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcachedefinition+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotcacherecords+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.pivottable+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.querytable+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionheaders+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionlog+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedstrings+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "xlsx"
        ]
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetmetadata+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.tablesinglecells+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.template": {
        "source": "iana",
        "extensions": [
            "xltx"
        ]
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.usernames+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.volatiledependencies+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.theme+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.themeoverride+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.vmldrawing": {
        "source": "iana"
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.comments+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "docx"
        ]
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document.glossary+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.endnotes+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.fonttable+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.footer+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.footnotes+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.numbering+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.template": {
        "source": "iana",
        "extensions": [
            "dotx"
        ]
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.template.main+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-officedocument.wordprocessingml.websettings+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-package.core-properties+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.openxmlformats-package.relationships+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oracle.resource+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.orange.indata": {
        "source": "iana"
    },
    "application/vnd.osa.netdeploy": {
        "source": "iana"
    },
    "application/vnd.osgeo.mapguide.package": {
        "source": "iana",
        "extensions": [
            "mgp"
        ]
    },
    "application/vnd.osgi.bundle": {
        "source": "iana"
    },
    "application/vnd.osgi.dp": {
        "source": "iana",
        "extensions": [
            "dp"
        ]
    },
    "application/vnd.osgi.subsystem": {
        "source": "iana",
        "extensions": [
            "esa"
        ]
    },
    "application/vnd.otps.ct-kip+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.oxli.countgraph": {
        "source": "iana"
    },
    "application/vnd.pagerduty+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.palm": {
        "source": "iana",
        "extensions": [
            "pdb",
            "pqa",
            "oprc"
        ]
    },
    "application/vnd.panoply": {
        "source": "iana"
    },
    "application/vnd.paos.xml": {
        "source": "iana"
    },
    "application/vnd.patentdive": {
        "source": "iana"
    },
    "application/vnd.patientecommsdoc": {
        "source": "iana"
    },
    "application/vnd.pawaafile": {
        "source": "iana",
        "extensions": [
            "paw"
        ]
    },
    "application/vnd.pcos": {
        "source": "iana"
    },
    "application/vnd.pg.format": {
        "source": "iana",
        "extensions": [
            "str"
        ]
    },
    "application/vnd.pg.osasli": {
        "source": "iana",
        "extensions": [
            "ei6"
        ]
    },
    "application/vnd.piaccess.application-licence": {
        "source": "iana"
    },
    "application/vnd.picsel": {
        "source": "iana",
        "extensions": [
            "efif"
        ]
    },
    "application/vnd.pmi.widget": {
        "source": "iana",
        "extensions": [
            "wg"
        ]
    },
    "application/vnd.poc.group-advertisement+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.pocketlearn": {
        "source": "iana",
        "extensions": [
            "plf"
        ]
    },
    "application/vnd.powerbuilder6": {
        "source": "iana",
        "extensions": [
            "pbd"
        ]
    },
    "application/vnd.powerbuilder6-s": {
        "source": "iana"
    },
    "application/vnd.powerbuilder7": {
        "source": "iana"
    },
    "application/vnd.powerbuilder7-s": {
        "source": "iana"
    },
    "application/vnd.powerbuilder75": {
        "source": "iana"
    },
    "application/vnd.powerbuilder75-s": {
        "source": "iana"
    },
    "application/vnd.preminet": {
        "source": "iana"
    },
    "application/vnd.previewsystems.box": {
        "source": "iana",
        "extensions": [
            "box"
        ]
    },
    "application/vnd.proteus.magazine": {
        "source": "iana",
        "extensions": [
            "mgz"
        ]
    },
    "application/vnd.psfs": {
        "source": "iana"
    },
    "application/vnd.publishare-delta-tree": {
        "source": "iana",
        "extensions": [
            "qps"
        ]
    },
    "application/vnd.pvi.ptid1": {
        "source": "iana",
        "extensions": [
            "ptid"
        ]
    },
    "application/vnd.pwg-multiplexed": {
        "source": "iana"
    },
    "application/vnd.pwg-xhtml-print+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.qualcomm.brew-app-res": {
        "source": "iana"
    },
    "application/vnd.quarantainenet": {
        "source": "iana"
    },
    "application/vnd.quark.quarkxpress": {
        "source": "iana",
        "extensions": [
            "qxd",
            "qxt",
            "qwd",
            "qwt",
            "qxl",
            "qxb"
        ]
    },
    "application/vnd.quobject-quoxdocument": {
        "source": "iana"
    },
    "application/vnd.radisys.moml+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-audit+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-audit-conf+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-audit-conn+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-audit-dialog+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-audit-stream+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-conf+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-dialog+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-dialog-base+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-dialog-fax-detect+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-dialog-fax-sendrecv+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-dialog-group+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-dialog-speech+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.radisys.msml-dialog-transform+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.rainstor.data": {
        "source": "iana"
    },
    "application/vnd.rapid": {
        "source": "iana"
    },
    "application/vnd.rar": {
        "source": "iana",
        "extensions": [
            "rar"
        ]
    },
    "application/vnd.realvnc.bed": {
        "source": "iana",
        "extensions": [
            "bed"
        ]
    },
    "application/vnd.recordare.musicxml": {
        "source": "iana",
        "extensions": [
            "mxl"
        ]
    },
    "application/vnd.recordare.musicxml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "musicxml"
        ]
    },
    "application/vnd.renlearn.rlprint": {
        "source": "iana"
    },
    "application/vnd.resilient.logic": {
        "source": "iana"
    },
    "application/vnd.restful+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.rig.cryptonote": {
        "source": "iana",
        "extensions": [
            "cryptonote"
        ]
    },
    "application/vnd.rim.cod": {
        "source": "apache",
        "extensions": [
            "cod"
        ]
    },
    "application/vnd.rn-realmedia": {
        "source": "apache",
        "extensions": [
            "rm"
        ]
    },
    "application/vnd.rn-realmedia-vbr": {
        "source": "apache",
        "extensions": [
            "rmvb"
        ]
    },
    "application/vnd.route66.link66+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "link66"
        ]
    },
    "application/vnd.rs-274x": {
        "source": "iana"
    },
    "application/vnd.ruckus.download": {
        "source": "iana"
    },
    "application/vnd.s3sms": {
        "source": "iana"
    },
    "application/vnd.sailingtracker.track": {
        "source": "iana",
        "extensions": [
            "st"
        ]
    },
    "application/vnd.sar": {
        "source": "iana"
    },
    "application/vnd.sbm.cid": {
        "source": "iana"
    },
    "application/vnd.sbm.mid2": {
        "source": "iana"
    },
    "application/vnd.scribus": {
        "source": "iana"
    },
    "application/vnd.sealed.3df": {
        "source": "iana"
    },
    "application/vnd.sealed.csf": {
        "source": "iana"
    },
    "application/vnd.sealed.doc": {
        "source": "iana"
    },
    "application/vnd.sealed.eml": {
        "source": "iana"
    },
    "application/vnd.sealed.mht": {
        "source": "iana"
    },
    "application/vnd.sealed.net": {
        "source": "iana"
    },
    "application/vnd.sealed.ppt": {
        "source": "iana"
    },
    "application/vnd.sealed.tiff": {
        "source": "iana"
    },
    "application/vnd.sealed.xls": {
        "source": "iana"
    },
    "application/vnd.sealedmedia.softseal.html": {
        "source": "iana"
    },
    "application/vnd.sealedmedia.softseal.pdf": {
        "source": "iana"
    },
    "application/vnd.seemail": {
        "source": "iana",
        "extensions": [
            "see"
        ]
    },
    "application/vnd.seis+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.sema": {
        "source": "iana",
        "extensions": [
            "sema"
        ]
    },
    "application/vnd.semd": {
        "source": "iana",
        "extensions": [
            "semd"
        ]
    },
    "application/vnd.semf": {
        "source": "iana",
        "extensions": [
            "semf"
        ]
    },
    "application/vnd.shade-save-file": {
        "source": "iana"
    },
    "application/vnd.shana.informed.formdata": {
        "source": "iana",
        "extensions": [
            "ifm"
        ]
    },
    "application/vnd.shana.informed.formtemplate": {
        "source": "iana",
        "extensions": [
            "itp"
        ]
    },
    "application/vnd.shana.informed.interchange": {
        "source": "iana",
        "extensions": [
            "iif"
        ]
    },
    "application/vnd.shana.informed.package": {
        "source": "iana",
        "extensions": [
            "ipk"
        ]
    },
    "application/vnd.shootproof+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.shopkick+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.shp": {
        "source": "iana"
    },
    "application/vnd.shx": {
        "source": "iana"
    },
    "application/vnd.sigrok.session": {
        "source": "iana"
    },
    "application/vnd.simtech-mindmapper": {
        "source": "iana",
        "extensions": [
            "twd",
            "twds"
        ]
    },
    "application/vnd.siren+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.smaf": {
        "source": "iana",
        "extensions": [
            "mmf"
        ]
    },
    "application/vnd.smart.notebook": {
        "source": "iana"
    },
    "application/vnd.smart.teacher": {
        "source": "iana",
        "extensions": [
            "teacher"
        ]
    },
    "application/vnd.snesdev-page-table": {
        "source": "iana"
    },
    "application/vnd.software602.filler.form+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "fo"
        ]
    },
    "application/vnd.software602.filler.form-xml-zip": {
        "source": "iana"
    },
    "application/vnd.solent.sdkm+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "sdkm",
            "sdkd"
        ]
    },
    "application/vnd.spotfire.dxp": {
        "source": "iana",
        "extensions": [
            "dxp"
        ]
    },
    "application/vnd.spotfire.sfs": {
        "source": "iana",
        "extensions": [
            "sfs"
        ]
    },
    "application/vnd.sqlite3": {
        "source": "iana"
    },
    "application/vnd.sss-cod": {
        "source": "iana"
    },
    "application/vnd.sss-dtf": {
        "source": "iana"
    },
    "application/vnd.sss-ntf": {
        "source": "iana"
    },
    "application/vnd.stardivision.calc": {
        "source": "apache",
        "extensions": [
            "sdc"
        ]
    },
    "application/vnd.stardivision.draw": {
        "source": "apache",
        "extensions": [
            "sda"
        ]
    },
    "application/vnd.stardivision.impress": {
        "source": "apache",
        "extensions": [
            "sdd"
        ]
    },
    "application/vnd.stardivision.math": {
        "source": "apache",
        "extensions": [
            "smf"
        ]
    },
    "application/vnd.stardivision.writer": {
        "source": "apache",
        "extensions": [
            "sdw",
            "vor"
        ]
    },
    "application/vnd.stardivision.writer-global": {
        "source": "apache",
        "extensions": [
            "sgl"
        ]
    },
    "application/vnd.stepmania.package": {
        "source": "iana",
        "extensions": [
            "smzip"
        ]
    },
    "application/vnd.stepmania.stepchart": {
        "source": "iana",
        "extensions": [
            "sm"
        ]
    },
    "application/vnd.street-stream": {
        "source": "iana"
    },
    "application/vnd.sun.wadl+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "wadl"
        ]
    },
    "application/vnd.sun.xml.calc": {
        "source": "apache",
        "extensions": [
            "sxc"
        ]
    },
    "application/vnd.sun.xml.calc.template": {
        "source": "apache",
        "extensions": [
            "stc"
        ]
    },
    "application/vnd.sun.xml.draw": {
        "source": "apache",
        "extensions": [
            "sxd"
        ]
    },
    "application/vnd.sun.xml.draw.template": {
        "source": "apache",
        "extensions": [
            "std"
        ]
    },
    "application/vnd.sun.xml.impress": {
        "source": "apache",
        "extensions": [
            "sxi"
        ]
    },
    "application/vnd.sun.xml.impress.template": {
        "source": "apache",
        "extensions": [
            "sti"
        ]
    },
    "application/vnd.sun.xml.math": {
        "source": "apache",
        "extensions": [
            "sxm"
        ]
    },
    "application/vnd.sun.xml.writer": {
        "source": "apache",
        "extensions": [
            "sxw"
        ]
    },
    "application/vnd.sun.xml.writer.global": {
        "source": "apache",
        "extensions": [
            "sxg"
        ]
    },
    "application/vnd.sun.xml.writer.template": {
        "source": "apache",
        "extensions": [
            "stw"
        ]
    },
    "application/vnd.sus-calendar": {
        "source": "iana",
        "extensions": [
            "sus",
            "susp"
        ]
    },
    "application/vnd.svd": {
        "source": "iana",
        "extensions": [
            "svd"
        ]
    },
    "application/vnd.swiftview-ics": {
        "source": "iana"
    },
    "application/vnd.sycle+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.syft+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.symbian.install": {
        "source": "apache",
        "extensions": [
            "sis",
            "sisx"
        ]
    },
    "application/vnd.syncml+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "xsm"
        ]
    },
    "application/vnd.syncml.dm+wbxml": {
        "source": "iana",
        "charset": "UTF-8",
        "extensions": [
            "bdm"
        ]
    },
    "application/vnd.syncml.dm+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "xdm"
        ]
    },
    "application/vnd.syncml.dm.notification": {
        "source": "iana"
    },
    "application/vnd.syncml.dmddf+wbxml": {
        "source": "iana"
    },
    "application/vnd.syncml.dmddf+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "ddf"
        ]
    },
    "application/vnd.syncml.dmtnds+wbxml": {
        "source": "iana"
    },
    "application/vnd.syncml.dmtnds+xml": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true
    },
    "application/vnd.syncml.ds.notification": {
        "source": "iana"
    },
    "application/vnd.tableschema+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.tao.intent-module-archive": {
        "source": "iana",
        "extensions": [
            "tao"
        ]
    },
    "application/vnd.tcpdump.pcap": {
        "source": "iana",
        "extensions": [
            "pcap",
            "cap",
            "dmp"
        ]
    },
    "application/vnd.think-cell.ppttc+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.tmd.mediaflex.api+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.tml": {
        "source": "iana"
    },
    "application/vnd.tmobile-livetv": {
        "source": "iana",
        "extensions": [
            "tmo"
        ]
    },
    "application/vnd.tri.onesource": {
        "source": "iana"
    },
    "application/vnd.trid.tpt": {
        "source": "iana",
        "extensions": [
            "tpt"
        ]
    },
    "application/vnd.triscape.mxs": {
        "source": "iana",
        "extensions": [
            "mxs"
        ]
    },
    "application/vnd.trueapp": {
        "source": "iana",
        "extensions": [
            "tra"
        ]
    },
    "application/vnd.truedoc": {
        "source": "iana"
    },
    "application/vnd.ubisoft.webplayer": {
        "source": "iana"
    },
    "application/vnd.ufdl": {
        "source": "iana",
        "extensions": [
            "ufd",
            "ufdl"
        ]
    },
    "application/vnd.uiq.theme": {
        "source": "iana",
        "extensions": [
            "utz"
        ]
    },
    "application/vnd.umajin": {
        "source": "iana",
        "extensions": [
            "umj"
        ]
    },
    "application/vnd.unity": {
        "source": "iana",
        "extensions": [
            "unityweb"
        ]
    },
    "application/vnd.uoml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "uoml"
        ]
    },
    "application/vnd.uplanet.alert": {
        "source": "iana"
    },
    "application/vnd.uplanet.alert-wbxml": {
        "source": "iana"
    },
    "application/vnd.uplanet.bearer-choice": {
        "source": "iana"
    },
    "application/vnd.uplanet.bearer-choice-wbxml": {
        "source": "iana"
    },
    "application/vnd.uplanet.cacheop": {
        "source": "iana"
    },
    "application/vnd.uplanet.cacheop-wbxml": {
        "source": "iana"
    },
    "application/vnd.uplanet.channel": {
        "source": "iana"
    },
    "application/vnd.uplanet.channel-wbxml": {
        "source": "iana"
    },
    "application/vnd.uplanet.list": {
        "source": "iana"
    },
    "application/vnd.uplanet.list-wbxml": {
        "source": "iana"
    },
    "application/vnd.uplanet.listcmd": {
        "source": "iana"
    },
    "application/vnd.uplanet.listcmd-wbxml": {
        "source": "iana"
    },
    "application/vnd.uplanet.signal": {
        "source": "iana"
    },
    "application/vnd.uri-map": {
        "source": "iana"
    },
    "application/vnd.valve.source.material": {
        "source": "iana"
    },
    "application/vnd.vcx": {
        "source": "iana",
        "extensions": [
            "vcx"
        ]
    },
    "application/vnd.vd-study": {
        "source": "iana"
    },
    "application/vnd.vectorworks": {
        "source": "iana"
    },
    "application/vnd.vel+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.verimatrix.vcas": {
        "source": "iana"
    },
    "application/vnd.veritone.aion+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.veryant.thin": {
        "source": "iana"
    },
    "application/vnd.ves.encrypted": {
        "source": "iana"
    },
    "application/vnd.vidsoft.vidconference": {
        "source": "iana"
    },
    "application/vnd.visio": {
        "source": "iana",
        "extensions": [
            "vsd",
            "vst",
            "vss",
            "vsw"
        ]
    },
    "application/vnd.visionary": {
        "source": "iana",
        "extensions": [
            "vis"
        ]
    },
    "application/vnd.vividence.scriptfile": {
        "source": "iana"
    },
    "application/vnd.vsf": {
        "source": "iana",
        "extensions": [
            "vsf"
        ]
    },
    "application/vnd.wap.sic": {
        "source": "iana"
    },
    "application/vnd.wap.slc": {
        "source": "iana"
    },
    "application/vnd.wap.wbxml": {
        "source": "iana",
        "charset": "UTF-8",
        "extensions": [
            "wbxml"
        ]
    },
    "application/vnd.wap.wmlc": {
        "source": "iana",
        "extensions": [
            "wmlc"
        ]
    },
    "application/vnd.wap.wmlscriptc": {
        "source": "iana",
        "extensions": [
            "wmlsc"
        ]
    },
    "application/vnd.webturbo": {
        "source": "iana",
        "extensions": [
            "wtb"
        ]
    },
    "application/vnd.wfa.dpp": {
        "source": "iana"
    },
    "application/vnd.wfa.p2p": {
        "source": "iana"
    },
    "application/vnd.wfa.wsc": {
        "source": "iana"
    },
    "application/vnd.windows.devicepairing": {
        "source": "iana"
    },
    "application/vnd.wmc": {
        "source": "iana"
    },
    "application/vnd.wmf.bootstrap": {
        "source": "iana"
    },
    "application/vnd.wolfram.mathematica": {
        "source": "iana"
    },
    "application/vnd.wolfram.mathematica.package": {
        "source": "iana"
    },
    "application/vnd.wolfram.player": {
        "source": "iana",
        "extensions": [
            "nbp"
        ]
    },
    "application/vnd.wordperfect": {
        "source": "iana",
        "extensions": [
            "wpd"
        ]
    },
    "application/vnd.wqd": {
        "source": "iana",
        "extensions": [
            "wqd"
        ]
    },
    "application/vnd.wrq-hp3000-labelled": {
        "source": "iana"
    },
    "application/vnd.wt.stf": {
        "source": "iana",
        "extensions": [
            "stf"
        ]
    },
    "application/vnd.wv.csp+wbxml": {
        "source": "iana"
    },
    "application/vnd.wv.csp+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.wv.ssp+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.xacml+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.xara": {
        "source": "iana",
        "extensions": [
            "xar"
        ]
    },
    "application/vnd.xfdl": {
        "source": "iana",
        "extensions": [
            "xfdl"
        ]
    },
    "application/vnd.xfdl.webform": {
        "source": "iana"
    },
    "application/vnd.xmi+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/vnd.xmpie.cpkg": {
        "source": "iana"
    },
    "application/vnd.xmpie.dpkg": {
        "source": "iana"
    },
    "application/vnd.xmpie.plan": {
        "source": "iana"
    },
    "application/vnd.xmpie.ppkg": {
        "source": "iana"
    },
    "application/vnd.xmpie.xlim": {
        "source": "iana"
    },
    "application/vnd.yamaha.hv-dic": {
        "source": "iana",
        "extensions": [
            "hvd"
        ]
    },
    "application/vnd.yamaha.hv-script": {
        "source": "iana",
        "extensions": [
            "hvs"
        ]
    },
    "application/vnd.yamaha.hv-voice": {
        "source": "iana",
        "extensions": [
            "hvp"
        ]
    },
    "application/vnd.yamaha.openscoreformat": {
        "source": "iana",
        "extensions": [
            "osf"
        ]
    },
    "application/vnd.yamaha.openscoreformat.osfpvg+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "osfpvg"
        ]
    },
    "application/vnd.yamaha.remote-setup": {
        "source": "iana"
    },
    "application/vnd.yamaha.smaf-audio": {
        "source": "iana",
        "extensions": [
            "saf"
        ]
    },
    "application/vnd.yamaha.smaf-phrase": {
        "source": "iana",
        "extensions": [
            "spf"
        ]
    },
    "application/vnd.yamaha.through-ngn": {
        "source": "iana"
    },
    "application/vnd.yamaha.tunnel-udpencap": {
        "source": "iana"
    },
    "application/vnd.yaoweme": {
        "source": "iana"
    },
    "application/vnd.yellowriver-custom-menu": {
        "source": "iana",
        "extensions": [
            "cmp"
        ]
    },
    "application/vnd.youtube.yt": {
        "source": "iana"
    },
    "application/vnd.zul": {
        "source": "iana",
        "extensions": [
            "zir",
            "zirz"
        ]
    },
    "application/vnd.zzazz.deck+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "zaz"
        ]
    },
    "application/voicexml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "vxml"
        ]
    },
    "application/voucher-cms+json": {
        "source": "iana",
        "compressible": true
    },
    "application/vq-rtcpxr": {
        "source": "iana"
    },
    "application/wasm": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "wasm"
        ]
    },
    "application/watcherinfo+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "wif"
        ]
    },
    "application/webpush-options+json": {
        "source": "iana",
        "compressible": true
    },
    "application/whoispp-query": {
        "source": "iana"
    },
    "application/whoispp-response": {
        "source": "iana"
    },
    "application/widget": {
        "source": "iana",
        "extensions": [
            "wgt"
        ]
    },
    "application/winhlp": {
        "source": "apache",
        "extensions": [
            "hlp"
        ]
    },
    "application/wita": {
        "source": "iana"
    },
    "application/wordperfect5.1": {
        "source": "iana"
    },
    "application/wsdl+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "wsdl"
        ]
    },
    "application/wspolicy+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "wspolicy"
        ]
    },
    "application/x-7z-compressed": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "7z"
        ]
    },
    "application/x-abiword": {
        "source": "apache",
        "extensions": [
            "abw"
        ]
    },
    "application/x-ace-compressed": {
        "source": "apache",
        "extensions": [
            "ace"
        ]
    },
    "application/x-amf": {
        "source": "apache"
    },
    "application/x-apple-diskimage": {
        "source": "apache",
        "extensions": [
            "dmg"
        ]
    },
    "application/x-arj": {
        "compressible": false,
        "extensions": [
            "arj"
        ]
    },
    "application/x-authorware-bin": {
        "source": "apache",
        "extensions": [
            "aab",
            "x32",
            "u32",
            "vox"
        ]
    },
    "application/x-authorware-map": {
        "source": "apache",
        "extensions": [
            "aam"
        ]
    },
    "application/x-authorware-seg": {
        "source": "apache",
        "extensions": [
            "aas"
        ]
    },
    "application/x-bcpio": {
        "source": "apache",
        "extensions": [
            "bcpio"
        ]
    },
    "application/x-bdoc": {
        "compressible": false,
        "extensions": [
            "bdoc"
        ]
    },
    "application/x-bittorrent": {
        "source": "apache",
        "extensions": [
            "torrent"
        ]
    },
    "application/x-blorb": {
        "source": "apache",
        "extensions": [
            "blb",
            "blorb"
        ]
    },
    "application/x-bzip": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "bz"
        ]
    },
    "application/x-bzip2": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "bz2",
            "boz"
        ]
    },
    "application/x-cbr": {
        "source": "apache",
        "extensions": [
            "cbr",
            "cba",
            "cbt",
            "cbz",
            "cb7"
        ]
    },
    "application/x-cdlink": {
        "source": "apache",
        "extensions": [
            "vcd"
        ]
    },
    "application/x-cfs-compressed": {
        "source": "apache",
        "extensions": [
            "cfs"
        ]
    },
    "application/x-chat": {
        "source": "apache",
        "extensions": [
            "chat"
        ]
    },
    "application/x-chess-pgn": {
        "source": "apache",
        "extensions": [
            "pgn"
        ]
    },
    "application/x-chrome-extension": {
        "extensions": [
            "crx"
        ]
    },
    "application/x-cocoa": {
        "source": "nginx",
        "extensions": [
            "cco"
        ]
    },
    "application/x-compress": {
        "source": "apache"
    },
    "application/x-conference": {
        "source": "apache",
        "extensions": [
            "nsc"
        ]
    },
    "application/x-cpio": {
        "source": "apache",
        "extensions": [
            "cpio"
        ]
    },
    "application/x-csh": {
        "source": "apache",
        "extensions": [
            "csh"
        ]
    },
    "application/x-deb": {
        "compressible": false
    },
    "application/x-debian-package": {
        "source": "apache",
        "extensions": [
            "deb",
            "udeb"
        ]
    },
    "application/x-dgc-compressed": {
        "source": "apache",
        "extensions": [
            "dgc"
        ]
    },
    "application/x-director": {
        "source": "apache",
        "extensions": [
            "dir",
            "dcr",
            "dxr",
            "cst",
            "cct",
            "cxt",
            "w3d",
            "fgd",
            "swa"
        ]
    },
    "application/x-doom": {
        "source": "apache",
        "extensions": [
            "wad"
        ]
    },
    "application/x-dtbncx+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "ncx"
        ]
    },
    "application/x-dtbook+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "dtb"
        ]
    },
    "application/x-dtbresource+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "res"
        ]
    },
    "application/x-dvi": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "dvi"
        ]
    },
    "application/x-envoy": {
        "source": "apache",
        "extensions": [
            "evy"
        ]
    },
    "application/x-eva": {
        "source": "apache",
        "extensions": [
            "eva"
        ]
    },
    "application/x-font-bdf": {
        "source": "apache",
        "extensions": [
            "bdf"
        ]
    },
    "application/x-font-dos": {
        "source": "apache"
    },
    "application/x-font-framemaker": {
        "source": "apache"
    },
    "application/x-font-ghostscript": {
        "source": "apache",
        "extensions": [
            "gsf"
        ]
    },
    "application/x-font-libgrx": {
        "source": "apache"
    },
    "application/x-font-linux-psf": {
        "source": "apache",
        "extensions": [
            "psf"
        ]
    },
    "application/x-font-pcf": {
        "source": "apache",
        "extensions": [
            "pcf"
        ]
    },
    "application/x-font-snf": {
        "source": "apache",
        "extensions": [
            "snf"
        ]
    },
    "application/x-font-speedo": {
        "source": "apache"
    },
    "application/x-font-sunos-news": {
        "source": "apache"
    },
    "application/x-font-type1": {
        "source": "apache",
        "extensions": [
            "pfa",
            "pfb",
            "pfm",
            "afm"
        ]
    },
    "application/x-font-vfont": {
        "source": "apache"
    },
    "application/x-freearc": {
        "source": "apache",
        "extensions": [
            "arc"
        ]
    },
    "application/x-futuresplash": {
        "source": "apache",
        "extensions": [
            "spl"
        ]
    },
    "application/x-gca-compressed": {
        "source": "apache",
        "extensions": [
            "gca"
        ]
    },
    "application/x-glulx": {
        "source": "apache",
        "extensions": [
            "ulx"
        ]
    },
    "application/x-gnumeric": {
        "source": "apache",
        "extensions": [
            "gnumeric"
        ]
    },
    "application/x-gramps-xml": {
        "source": "apache",
        "extensions": [
            "gramps"
        ]
    },
    "application/x-gtar": {
        "source": "apache",
        "extensions": [
            "gtar"
        ]
    },
    "application/x-gzip": {
        "source": "apache"
    },
    "application/x-hdf": {
        "source": "apache",
        "extensions": [
            "hdf"
        ]
    },
    "application/x-httpd-php": {
        "compressible": true,
        "extensions": [
            "php"
        ]
    },
    "application/x-install-instructions": {
        "source": "apache",
        "extensions": [
            "install"
        ]
    },
    "application/x-iso9660-image": {
        "source": "apache",
        "extensions": [
            "iso"
        ]
    },
    "application/x-iwork-keynote-sffkey": {
        "extensions": [
            "key"
        ]
    },
    "application/x-iwork-numbers-sffnumbers": {
        "extensions": [
            "numbers"
        ]
    },
    "application/x-iwork-pages-sffpages": {
        "extensions": [
            "pages"
        ]
    },
    "application/x-java-archive-diff": {
        "source": "nginx",
        "extensions": [
            "jardiff"
        ]
    },
    "application/x-java-jnlp-file": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "jnlp"
        ]
    },
    "application/x-javascript": {
        "compressible": true
    },
    "application/x-keepass2": {
        "extensions": [
            "kdbx"
        ]
    },
    "application/x-latex": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "latex"
        ]
    },
    "application/x-lua-bytecode": {
        "extensions": [
            "luac"
        ]
    },
    "application/x-lzh-compressed": {
        "source": "apache",
        "extensions": [
            "lzh",
            "lha"
        ]
    },
    "application/x-makeself": {
        "source": "nginx",
        "extensions": [
            "run"
        ]
    },
    "application/x-mie": {
        "source": "apache",
        "extensions": [
            "mie"
        ]
    },
    "application/x-mobipocket-ebook": {
        "source": "apache",
        "extensions": [
            "prc",
            "mobi"
        ]
    },
    "application/x-mpegurl": {
        "compressible": false
    },
    "application/x-ms-application": {
        "source": "apache",
        "extensions": [
            "application"
        ]
    },
    "application/x-ms-shortcut": {
        "source": "apache",
        "extensions": [
            "lnk"
        ]
    },
    "application/x-ms-wmd": {
        "source": "apache",
        "extensions": [
            "wmd"
        ]
    },
    "application/x-ms-wmz": {
        "source": "apache",
        "extensions": [
            "wmz"
        ]
    },
    "application/x-ms-xbap": {
        "source": "apache",
        "extensions": [
            "xbap"
        ]
    },
    "application/x-msaccess": {
        "source": "apache",
        "extensions": [
            "mdb"
        ]
    },
    "application/x-msbinder": {
        "source": "apache",
        "extensions": [
            "obd"
        ]
    },
    "application/x-mscardfile": {
        "source": "apache",
        "extensions": [
            "crd"
        ]
    },
    "application/x-msclip": {
        "source": "apache",
        "extensions": [
            "clp"
        ]
    },
    "application/x-msdos-program": {
        "extensions": [
            "exe"
        ]
    },
    "application/x-msdownload": {
        "source": "apache",
        "extensions": [
            "exe",
            "dll",
            "com",
            "bat",
            "msi"
        ]
    },
    "application/x-msmediaview": {
        "source": "apache",
        "extensions": [
            "mvb",
            "m13",
            "m14"
        ]
    },
    "application/x-msmetafile": {
        "source": "apache",
        "extensions": [
            "wmf",
            "wmz",
            "emf",
            "emz"
        ]
    },
    "application/x-msmoney": {
        "source": "apache",
        "extensions": [
            "mny"
        ]
    },
    "application/x-mspublisher": {
        "source": "apache",
        "extensions": [
            "pub"
        ]
    },
    "application/x-msschedule": {
        "source": "apache",
        "extensions": [
            "scd"
        ]
    },
    "application/x-msterminal": {
        "source": "apache",
        "extensions": [
            "trm"
        ]
    },
    "application/x-mswrite": {
        "source": "apache",
        "extensions": [
            "wri"
        ]
    },
    "application/x-netcdf": {
        "source": "apache",
        "extensions": [
            "nc",
            "cdf"
        ]
    },
    "application/x-ns-proxy-autoconfig": {
        "compressible": true,
        "extensions": [
            "pac"
        ]
    },
    "application/x-nzb": {
        "source": "apache",
        "extensions": [
            "nzb"
        ]
    },
    "application/x-perl": {
        "source": "nginx",
        "extensions": [
            "pl",
            "pm"
        ]
    },
    "application/x-pilot": {
        "source": "nginx",
        "extensions": [
            "prc",
            "pdb"
        ]
    },
    "application/x-pkcs12": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "p12",
            "pfx"
        ]
    },
    "application/x-pkcs7-certificates": {
        "source": "apache",
        "extensions": [
            "p7b",
            "spc"
        ]
    },
    "application/x-pkcs7-certreqresp": {
        "source": "apache",
        "extensions": [
            "p7r"
        ]
    },
    "application/x-pki-message": {
        "source": "iana"
    },
    "application/x-rar-compressed": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "rar"
        ]
    },
    "application/x-redhat-package-manager": {
        "source": "nginx",
        "extensions": [
            "rpm"
        ]
    },
    "application/x-research-info-systems": {
        "source": "apache",
        "extensions": [
            "ris"
        ]
    },
    "application/x-sea": {
        "source": "nginx",
        "extensions": [
            "sea"
        ]
    },
    "application/x-sh": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "sh"
        ]
    },
    "application/x-shar": {
        "source": "apache",
        "extensions": [
            "shar"
        ]
    },
    "application/x-shockwave-flash": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "swf"
        ]
    },
    "application/x-silverlight-app": {
        "source": "apache",
        "extensions": [
            "xap"
        ]
    },
    "application/x-sql": {
        "source": "apache",
        "extensions": [
            "sql"
        ]
    },
    "application/x-stuffit": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "sit"
        ]
    },
    "application/x-stuffitx": {
        "source": "apache",
        "extensions": [
            "sitx"
        ]
    },
    "application/x-subrip": {
        "source": "apache",
        "extensions": [
            "srt"
        ]
    },
    "application/x-sv4cpio": {
        "source": "apache",
        "extensions": [
            "sv4cpio"
        ]
    },
    "application/x-sv4crc": {
        "source": "apache",
        "extensions": [
            "sv4crc"
        ]
    },
    "application/x-t3vm-image": {
        "source": "apache",
        "extensions": [
            "t3"
        ]
    },
    "application/x-tads": {
        "source": "apache",
        "extensions": [
            "gam"
        ]
    },
    "application/x-tar": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "tar"
        ]
    },
    "application/x-tcl": {
        "source": "apache",
        "extensions": [
            "tcl",
            "tk"
        ]
    },
    "application/x-tex": {
        "source": "apache",
        "extensions": [
            "tex"
        ]
    },
    "application/x-tex-tfm": {
        "source": "apache",
        "extensions": [
            "tfm"
        ]
    },
    "application/x-texinfo": {
        "source": "apache",
        "extensions": [
            "texinfo",
            "texi"
        ]
    },
    "application/x-tgif": {
        "source": "apache",
        "extensions": [
            "obj"
        ]
    },
    "application/x-ustar": {
        "source": "apache",
        "extensions": [
            "ustar"
        ]
    },
    "application/x-virtualbox-hdd": {
        "compressible": true,
        "extensions": [
            "hdd"
        ]
    },
    "application/x-virtualbox-ova": {
        "compressible": true,
        "extensions": [
            "ova"
        ]
    },
    "application/x-virtualbox-ovf": {
        "compressible": true,
        "extensions": [
            "ovf"
        ]
    },
    "application/x-virtualbox-vbox": {
        "compressible": true,
        "extensions": [
            "vbox"
        ]
    },
    "application/x-virtualbox-vbox-extpack": {
        "compressible": false,
        "extensions": [
            "vbox-extpack"
        ]
    },
    "application/x-virtualbox-vdi": {
        "compressible": true,
        "extensions": [
            "vdi"
        ]
    },
    "application/x-virtualbox-vhd": {
        "compressible": true,
        "extensions": [
            "vhd"
        ]
    },
    "application/x-virtualbox-vmdk": {
        "compressible": true,
        "extensions": [
            "vmdk"
        ]
    },
    "application/x-wais-source": {
        "source": "apache",
        "extensions": [
            "src"
        ]
    },
    "application/x-web-app-manifest+json": {
        "compressible": true,
        "extensions": [
            "webapp"
        ]
    },
    "application/x-www-form-urlencoded": {
        "source": "iana",
        "compressible": true
    },
    "application/x-x509-ca-cert": {
        "source": "iana",
        "extensions": [
            "der",
            "crt",
            "pem"
        ]
    },
    "application/x-x509-ca-ra-cert": {
        "source": "iana"
    },
    "application/x-x509-next-ca-cert": {
        "source": "iana"
    },
    "application/x-xfig": {
        "source": "apache",
        "extensions": [
            "fig"
        ]
    },
    "application/x-xliff+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "xlf"
        ]
    },
    "application/x-xpinstall": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "xpi"
        ]
    },
    "application/x-xz": {
        "source": "apache",
        "extensions": [
            "xz"
        ]
    },
    "application/x-zmachine": {
        "source": "apache",
        "extensions": [
            "z1",
            "z2",
            "z3",
            "z4",
            "z5",
            "z6",
            "z7",
            "z8"
        ]
    },
    "application/x400-bp": {
        "source": "iana"
    },
    "application/xacml+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/xaml+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "xaml"
        ]
    },
    "application/xcap-att+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xav"
        ]
    },
    "application/xcap-caps+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xca"
        ]
    },
    "application/xcap-diff+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xdf"
        ]
    },
    "application/xcap-el+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xel"
        ]
    },
    "application/xcap-error+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/xcap-ns+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xns"
        ]
    },
    "application/xcon-conference-info+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/xcon-conference-info-diff+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/xenc+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xenc"
        ]
    },
    "application/xhtml+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xhtml",
            "xht"
        ]
    },
    "application/xhtml-voice+xml": {
        "source": "apache",
        "compressible": true
    },
    "application/xliff+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xlf"
        ]
    },
    "application/xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xml",
            "xsl",
            "xsd",
            "rng"
        ]
    },
    "application/xml-dtd": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "dtd"
        ]
    },
    "application/xml-external-parsed-entity": {
        "source": "iana"
    },
    "application/xml-patch+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/xmpp+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/xop+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xop"
        ]
    },
    "application/xproc+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "xpl"
        ]
    },
    "application/xslt+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xsl",
            "xslt"
        ]
    },
    "application/xspf+xml": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "xspf"
        ]
    },
    "application/xv+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "mxml",
            "xhvml",
            "xvml",
            "xvm"
        ]
    },
    "application/yang": {
        "source": "iana",
        "extensions": [
            "yang"
        ]
    },
    "application/yang-data+json": {
        "source": "iana",
        "compressible": true
    },
    "application/yang-data+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/yang-patch+json": {
        "source": "iana",
        "compressible": true
    },
    "application/yang-patch+xml": {
        "source": "iana",
        "compressible": true
    },
    "application/yin+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "yin"
        ]
    },
    "application/zip": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "zip"
        ]
    },
    "application/zlib": {
        "source": "iana"
    },
    "application/zstd": {
        "source": "iana"
    },
    "audio/1d-interleaved-parityfec": {
        "source": "iana"
    },
    "audio/32kadpcm": {
        "source": "iana"
    },
    "audio/3gpp": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "3gpp"
        ]
    },
    "audio/3gpp2": {
        "source": "iana"
    },
    "audio/aac": {
        "source": "iana"
    },
    "audio/ac3": {
        "source": "iana"
    },
    "audio/adpcm": {
        "source": "apache",
        "extensions": [
            "adp"
        ]
    },
    "audio/amr": {
        "source": "iana",
        "extensions": [
            "amr"
        ]
    },
    "audio/amr-wb": {
        "source": "iana"
    },
    "audio/amr-wb+": {
        "source": "iana"
    },
    "audio/aptx": {
        "source": "iana"
    },
    "audio/asc": {
        "source": "iana"
    },
    "audio/atrac-advanced-lossless": {
        "source": "iana"
    },
    "audio/atrac-x": {
        "source": "iana"
    },
    "audio/atrac3": {
        "source": "iana"
    },
    "audio/basic": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "au",
            "snd"
        ]
    },
    "audio/bv16": {
        "source": "iana"
    },
    "audio/bv32": {
        "source": "iana"
    },
    "audio/clearmode": {
        "source": "iana"
    },
    "audio/cn": {
        "source": "iana"
    },
    "audio/dat12": {
        "source": "iana"
    },
    "audio/dls": {
        "source": "iana"
    },
    "audio/dsr-es201108": {
        "source": "iana"
    },
    "audio/dsr-es202050": {
        "source": "iana"
    },
    "audio/dsr-es202211": {
        "source": "iana"
    },
    "audio/dsr-es202212": {
        "source": "iana"
    },
    "audio/dv": {
        "source": "iana"
    },
    "audio/dvi4": {
        "source": "iana"
    },
    "audio/eac3": {
        "source": "iana"
    },
    "audio/encaprtp": {
        "source": "iana"
    },
    "audio/evrc": {
        "source": "iana"
    },
    "audio/evrc-qcp": {
        "source": "iana"
    },
    "audio/evrc0": {
        "source": "iana"
    },
    "audio/evrc1": {
        "source": "iana"
    },
    "audio/evrcb": {
        "source": "iana"
    },
    "audio/evrcb0": {
        "source": "iana"
    },
    "audio/evrcb1": {
        "source": "iana"
    },
    "audio/evrcnw": {
        "source": "iana"
    },
    "audio/evrcnw0": {
        "source": "iana"
    },
    "audio/evrcnw1": {
        "source": "iana"
    },
    "audio/evrcwb": {
        "source": "iana"
    },
    "audio/evrcwb0": {
        "source": "iana"
    },
    "audio/evrcwb1": {
        "source": "iana"
    },
    "audio/evs": {
        "source": "iana"
    },
    "audio/flexfec": {
        "source": "iana"
    },
    "audio/fwdred": {
        "source": "iana"
    },
    "audio/g711-0": {
        "source": "iana"
    },
    "audio/g719": {
        "source": "iana"
    },
    "audio/g722": {
        "source": "iana"
    },
    "audio/g7221": {
        "source": "iana"
    },
    "audio/g723": {
        "source": "iana"
    },
    "audio/g726-16": {
        "source": "iana"
    },
    "audio/g726-24": {
        "source": "iana"
    },
    "audio/g726-32": {
        "source": "iana"
    },
    "audio/g726-40": {
        "source": "iana"
    },
    "audio/g728": {
        "source": "iana"
    },
    "audio/g729": {
        "source": "iana"
    },
    "audio/g7291": {
        "source": "iana"
    },
    "audio/g729d": {
        "source": "iana"
    },
    "audio/g729e": {
        "source": "iana"
    },
    "audio/gsm": {
        "source": "iana"
    },
    "audio/gsm-efr": {
        "source": "iana"
    },
    "audio/gsm-hr-08": {
        "source": "iana"
    },
    "audio/ilbc": {
        "source": "iana"
    },
    "audio/ip-mr_v2.5": {
        "source": "iana"
    },
    "audio/isac": {
        "source": "apache"
    },
    "audio/l16": {
        "source": "iana"
    },
    "audio/l20": {
        "source": "iana"
    },
    "audio/l24": {
        "source": "iana",
        "compressible": false
    },
    "audio/l8": {
        "source": "iana"
    },
    "audio/lpc": {
        "source": "iana"
    },
    "audio/melp": {
        "source": "iana"
    },
    "audio/melp1200": {
        "source": "iana"
    },
    "audio/melp2400": {
        "source": "iana"
    },
    "audio/melp600": {
        "source": "iana"
    },
    "audio/mhas": {
        "source": "iana"
    },
    "audio/midi": {
        "source": "apache",
        "extensions": [
            "mid",
            "midi",
            "kar",
            "rmi"
        ]
    },
    "audio/mobile-xmf": {
        "source": "iana",
        "extensions": [
            "mxmf"
        ]
    },
    "audio/mp3": {
        "compressible": false,
        "extensions": [
            "mp3"
        ]
    },
    "audio/mp4": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "m4a",
            "mp4a"
        ]
    },
    "audio/mp4a-latm": {
        "source": "iana"
    },
    "audio/mpa": {
        "source": "iana"
    },
    "audio/mpa-robust": {
        "source": "iana"
    },
    "audio/mpeg": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "mpga",
            "mp2",
            "mp2a",
            "mp3",
            "m2a",
            "m3a"
        ]
    },
    "audio/mpeg4-generic": {
        "source": "iana"
    },
    "audio/musepack": {
        "source": "apache"
    },
    "audio/ogg": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "oga",
            "ogg",
            "spx",
            "opus"
        ]
    },
    "audio/opus": {
        "source": "iana"
    },
    "audio/parityfec": {
        "source": "iana"
    },
    "audio/pcma": {
        "source": "iana"
    },
    "audio/pcma-wb": {
        "source": "iana"
    },
    "audio/pcmu": {
        "source": "iana"
    },
    "audio/pcmu-wb": {
        "source": "iana"
    },
    "audio/prs.sid": {
        "source": "iana"
    },
    "audio/qcelp": {
        "source": "iana"
    },
    "audio/raptorfec": {
        "source": "iana"
    },
    "audio/red": {
        "source": "iana"
    },
    "audio/rtp-enc-aescm128": {
        "source": "iana"
    },
    "audio/rtp-midi": {
        "source": "iana"
    },
    "audio/rtploopback": {
        "source": "iana"
    },
    "audio/rtx": {
        "source": "iana"
    },
    "audio/s3m": {
        "source": "apache",
        "extensions": [
            "s3m"
        ]
    },
    "audio/scip": {
        "source": "iana"
    },
    "audio/silk": {
        "source": "apache",
        "extensions": [
            "sil"
        ]
    },
    "audio/smv": {
        "source": "iana"
    },
    "audio/smv-qcp": {
        "source": "iana"
    },
    "audio/smv0": {
        "source": "iana"
    },
    "audio/sofa": {
        "source": "iana"
    },
    "audio/sp-midi": {
        "source": "iana"
    },
    "audio/speex": {
        "source": "iana"
    },
    "audio/t140c": {
        "source": "iana"
    },
    "audio/t38": {
        "source": "iana"
    },
    "audio/telephone-event": {
        "source": "iana"
    },
    "audio/tetra_acelp": {
        "source": "iana"
    },
    "audio/tetra_acelp_bb": {
        "source": "iana"
    },
    "audio/tone": {
        "source": "iana"
    },
    "audio/tsvcis": {
        "source": "iana"
    },
    "audio/uemclip": {
        "source": "iana"
    },
    "audio/ulpfec": {
        "source": "iana"
    },
    "audio/usac": {
        "source": "iana"
    },
    "audio/vdvi": {
        "source": "iana"
    },
    "audio/vmr-wb": {
        "source": "iana"
    },
    "audio/vnd.3gpp.iufp": {
        "source": "iana"
    },
    "audio/vnd.4sb": {
        "source": "iana"
    },
    "audio/vnd.audiokoz": {
        "source": "iana"
    },
    "audio/vnd.celp": {
        "source": "iana"
    },
    "audio/vnd.cisco.nse": {
        "source": "iana"
    },
    "audio/vnd.cmles.radio-events": {
        "source": "iana"
    },
    "audio/vnd.cns.anp1": {
        "source": "iana"
    },
    "audio/vnd.cns.inf1": {
        "source": "iana"
    },
    "audio/vnd.dece.audio": {
        "source": "iana",
        "extensions": [
            "uva",
            "uvva"
        ]
    },
    "audio/vnd.digital-winds": {
        "source": "iana",
        "extensions": [
            "eol"
        ]
    },
    "audio/vnd.dlna.adts": {
        "source": "iana"
    },
    "audio/vnd.dolby.heaac.1": {
        "source": "iana"
    },
    "audio/vnd.dolby.heaac.2": {
        "source": "iana"
    },
    "audio/vnd.dolby.mlp": {
        "source": "iana"
    },
    "audio/vnd.dolby.mps": {
        "source": "iana"
    },
    "audio/vnd.dolby.pl2": {
        "source": "iana"
    },
    "audio/vnd.dolby.pl2x": {
        "source": "iana"
    },
    "audio/vnd.dolby.pl2z": {
        "source": "iana"
    },
    "audio/vnd.dolby.pulse.1": {
        "source": "iana"
    },
    "audio/vnd.dra": {
        "source": "iana",
        "extensions": [
            "dra"
        ]
    },
    "audio/vnd.dts": {
        "source": "iana",
        "extensions": [
            "dts"
        ]
    },
    "audio/vnd.dts.hd": {
        "source": "iana",
        "extensions": [
            "dtshd"
        ]
    },
    "audio/vnd.dts.uhd": {
        "source": "iana"
    },
    "audio/vnd.dvb.file": {
        "source": "iana"
    },
    "audio/vnd.everad.plj": {
        "source": "iana"
    },
    "audio/vnd.hns.audio": {
        "source": "iana"
    },
    "audio/vnd.lucent.voice": {
        "source": "iana",
        "extensions": [
            "lvp"
        ]
    },
    "audio/vnd.ms-playready.media.pya": {
        "source": "iana",
        "extensions": [
            "pya"
        ]
    },
    "audio/vnd.nokia.mobile-xmf": {
        "source": "iana"
    },
    "audio/vnd.nortel.vbk": {
        "source": "iana"
    },
    "audio/vnd.nuera.ecelp4800": {
        "source": "iana",
        "extensions": [
            "ecelp4800"
        ]
    },
    "audio/vnd.nuera.ecelp7470": {
        "source": "iana",
        "extensions": [
            "ecelp7470"
        ]
    },
    "audio/vnd.nuera.ecelp9600": {
        "source": "iana",
        "extensions": [
            "ecelp9600"
        ]
    },
    "audio/vnd.octel.sbc": {
        "source": "iana"
    },
    "audio/vnd.presonus.multitrack": {
        "source": "iana"
    },
    "audio/vnd.qcelp": {
        "source": "iana"
    },
    "audio/vnd.rhetorex.32kadpcm": {
        "source": "iana"
    },
    "audio/vnd.rip": {
        "source": "iana",
        "extensions": [
            "rip"
        ]
    },
    "audio/vnd.rn-realaudio": {
        "compressible": false
    },
    "audio/vnd.sealedmedia.softseal.mpeg": {
        "source": "iana"
    },
    "audio/vnd.vmx.cvsd": {
        "source": "iana"
    },
    "audio/vnd.wave": {
        "compressible": false
    },
    "audio/vorbis": {
        "source": "iana",
        "compressible": false
    },
    "audio/vorbis-config": {
        "source": "iana"
    },
    "audio/wav": {
        "compressible": false,
        "extensions": [
            "wav"
        ]
    },
    "audio/wave": {
        "compressible": false,
        "extensions": [
            "wav"
        ]
    },
    "audio/webm": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "weba"
        ]
    },
    "audio/x-aac": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "aac"
        ]
    },
    "audio/x-aiff": {
        "source": "apache",
        "extensions": [
            "aif",
            "aiff",
            "aifc"
        ]
    },
    "audio/x-caf": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "caf"
        ]
    },
    "audio/x-flac": {
        "source": "apache",
        "extensions": [
            "flac"
        ]
    },
    "audio/x-m4a": {
        "source": "nginx",
        "extensions": [
            "m4a"
        ]
    },
    "audio/x-matroska": {
        "source": "apache",
        "extensions": [
            "mka"
        ]
    },
    "audio/x-mpegurl": {
        "source": "apache",
        "extensions": [
            "m3u"
        ]
    },
    "audio/x-ms-wax": {
        "source": "apache",
        "extensions": [
            "wax"
        ]
    },
    "audio/x-ms-wma": {
        "source": "apache",
        "extensions": [
            "wma"
        ]
    },
    "audio/x-pn-realaudio": {
        "source": "apache",
        "extensions": [
            "ram",
            "ra"
        ]
    },
    "audio/x-pn-realaudio-plugin": {
        "source": "apache",
        "extensions": [
            "rmp"
        ]
    },
    "audio/x-realaudio": {
        "source": "nginx",
        "extensions": [
            "ra"
        ]
    },
    "audio/x-tta": {
        "source": "apache"
    },
    "audio/x-wav": {
        "source": "apache",
        "extensions": [
            "wav"
        ]
    },
    "audio/xm": {
        "source": "apache",
        "extensions": [
            "xm"
        ]
    },
    "chemical/x-cdx": {
        "source": "apache",
        "extensions": [
            "cdx"
        ]
    },
    "chemical/x-cif": {
        "source": "apache",
        "extensions": [
            "cif"
        ]
    },
    "chemical/x-cmdf": {
        "source": "apache",
        "extensions": [
            "cmdf"
        ]
    },
    "chemical/x-cml": {
        "source": "apache",
        "extensions": [
            "cml"
        ]
    },
    "chemical/x-csml": {
        "source": "apache",
        "extensions": [
            "csml"
        ]
    },
    "chemical/x-pdb": {
        "source": "apache"
    },
    "chemical/x-xyz": {
        "source": "apache",
        "extensions": [
            "xyz"
        ]
    },
    "font/collection": {
        "source": "iana",
        "extensions": [
            "ttc"
        ]
    },
    "font/otf": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "otf"
        ]
    },
    "font/sfnt": {
        "source": "iana"
    },
    "font/ttf": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "ttf"
        ]
    },
    "font/woff": {
        "source": "iana",
        "extensions": [
            "woff"
        ]
    },
    "font/woff2": {
        "source": "iana",
        "extensions": [
            "woff2"
        ]
    },
    "image/aces": {
        "source": "iana",
        "extensions": [
            "exr"
        ]
    },
    "image/apng": {
        "compressible": false,
        "extensions": [
            "apng"
        ]
    },
    "image/avci": {
        "source": "iana",
        "extensions": [
            "avci"
        ]
    },
    "image/avcs": {
        "source": "iana",
        "extensions": [
            "avcs"
        ]
    },
    "image/avif": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "avif"
        ]
    },
    "image/bmp": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "bmp"
        ]
    },
    "image/cgm": {
        "source": "iana",
        "extensions": [
            "cgm"
        ]
    },
    "image/dicom-rle": {
        "source": "iana",
        "extensions": [
            "drle"
        ]
    },
    "image/emf": {
        "source": "iana",
        "extensions": [
            "emf"
        ]
    },
    "image/fits": {
        "source": "iana",
        "extensions": [
            "fits"
        ]
    },
    "image/g3fax": {
        "source": "iana",
        "extensions": [
            "g3"
        ]
    },
    "image/gif": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "gif"
        ]
    },
    "image/heic": {
        "source": "iana",
        "extensions": [
            "heic"
        ]
    },
    "image/heic-sequence": {
        "source": "iana",
        "extensions": [
            "heics"
        ]
    },
    "image/heif": {
        "source": "iana",
        "extensions": [
            "heif"
        ]
    },
    "image/heif-sequence": {
        "source": "iana",
        "extensions": [
            "heifs"
        ]
    },
    "image/hej2k": {
        "source": "iana",
        "extensions": [
            "hej2"
        ]
    },
    "image/hsj2": {
        "source": "iana",
        "extensions": [
            "hsj2"
        ]
    },
    "image/ief": {
        "source": "iana",
        "extensions": [
            "ief"
        ]
    },
    "image/jls": {
        "source": "iana",
        "extensions": [
            "jls"
        ]
    },
    "image/jp2": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "jp2",
            "jpg2"
        ]
    },
    "image/jpeg": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "jpeg",
            "jpg",
            "jpe"
        ]
    },
    "image/jph": {
        "source": "iana",
        "extensions": [
            "jph"
        ]
    },
    "image/jphc": {
        "source": "iana",
        "extensions": [
            "jhc"
        ]
    },
    "image/jpm": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "jpm"
        ]
    },
    "image/jpx": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "jpx",
            "jpf"
        ]
    },
    "image/jxr": {
        "source": "iana",
        "extensions": [
            "jxr"
        ]
    },
    "image/jxra": {
        "source": "iana",
        "extensions": [
            "jxra"
        ]
    },
    "image/jxrs": {
        "source": "iana",
        "extensions": [
            "jxrs"
        ]
    },
    "image/jxs": {
        "source": "iana",
        "extensions": [
            "jxs"
        ]
    },
    "image/jxsc": {
        "source": "iana",
        "extensions": [
            "jxsc"
        ]
    },
    "image/jxsi": {
        "source": "iana",
        "extensions": [
            "jxsi"
        ]
    },
    "image/jxss": {
        "source": "iana",
        "extensions": [
            "jxss"
        ]
    },
    "image/ktx": {
        "source": "iana",
        "extensions": [
            "ktx"
        ]
    },
    "image/ktx2": {
        "source": "iana",
        "extensions": [
            "ktx2"
        ]
    },
    "image/naplps": {
        "source": "iana"
    },
    "image/pjpeg": {
        "compressible": false
    },
    "image/png": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "png"
        ]
    },
    "image/prs.btif": {
        "source": "iana",
        "extensions": [
            "btif"
        ]
    },
    "image/prs.pti": {
        "source": "iana",
        "extensions": [
            "pti"
        ]
    },
    "image/pwg-raster": {
        "source": "iana"
    },
    "image/sgi": {
        "source": "apache",
        "extensions": [
            "sgi"
        ]
    },
    "image/svg+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "svg",
            "svgz"
        ]
    },
    "image/t38": {
        "source": "iana",
        "extensions": [
            "t38"
        ]
    },
    "image/tiff": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "tif",
            "tiff"
        ]
    },
    "image/tiff-fx": {
        "source": "iana",
        "extensions": [
            "tfx"
        ]
    },
    "image/vnd.adobe.photoshop": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "psd"
        ]
    },
    "image/vnd.airzip.accelerator.azv": {
        "source": "iana",
        "extensions": [
            "azv"
        ]
    },
    "image/vnd.cns.inf2": {
        "source": "iana"
    },
    "image/vnd.dece.graphic": {
        "source": "iana",
        "extensions": [
            "uvi",
            "uvvi",
            "uvg",
            "uvvg"
        ]
    },
    "image/vnd.djvu": {
        "source": "iana",
        "extensions": [
            "djvu",
            "djv"
        ]
    },
    "image/vnd.dvb.subtitle": {
        "source": "iana",
        "extensions": [
            "sub"
        ]
    },
    "image/vnd.dwg": {
        "source": "iana",
        "extensions": [
            "dwg"
        ]
    },
    "image/vnd.dxf": {
        "source": "iana",
        "extensions": [
            "dxf"
        ]
    },
    "image/vnd.fastbidsheet": {
        "source": "iana",
        "extensions": [
            "fbs"
        ]
    },
    "image/vnd.fpx": {
        "source": "iana",
        "extensions": [
            "fpx"
        ]
    },
    "image/vnd.fst": {
        "source": "iana",
        "extensions": [
            "fst"
        ]
    },
    "image/vnd.fujixerox.edmics-mmr": {
        "source": "iana",
        "extensions": [
            "mmr"
        ]
    },
    "image/vnd.fujixerox.edmics-rlc": {
        "source": "iana",
        "extensions": [
            "rlc"
        ]
    },
    "image/vnd.globalgraphics.pgb": {
        "source": "iana"
    },
    "image/vnd.microsoft.icon": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "ico"
        ]
    },
    "image/vnd.mix": {
        "source": "iana"
    },
    "image/vnd.mozilla.apng": {
        "source": "iana"
    },
    "image/vnd.ms-dds": {
        "compressible": true,
        "extensions": [
            "dds"
        ]
    },
    "image/vnd.ms-modi": {
        "source": "iana",
        "extensions": [
            "mdi"
        ]
    },
    "image/vnd.ms-photo": {
        "source": "apache",
        "extensions": [
            "wdp"
        ]
    },
    "image/vnd.net-fpx": {
        "source": "iana",
        "extensions": [
            "npx"
        ]
    },
    "image/vnd.pco.b16": {
        "source": "iana",
        "extensions": [
            "b16"
        ]
    },
    "image/vnd.radiance": {
        "source": "iana"
    },
    "image/vnd.sealed.png": {
        "source": "iana"
    },
    "image/vnd.sealedmedia.softseal.gif": {
        "source": "iana"
    },
    "image/vnd.sealedmedia.softseal.jpg": {
        "source": "iana"
    },
    "image/vnd.svf": {
        "source": "iana"
    },
    "image/vnd.tencent.tap": {
        "source": "iana",
        "extensions": [
            "tap"
        ]
    },
    "image/vnd.valve.source.texture": {
        "source": "iana",
        "extensions": [
            "vtf"
        ]
    },
    "image/vnd.wap.wbmp": {
        "source": "iana",
        "extensions": [
            "wbmp"
        ]
    },
    "image/vnd.xiff": {
        "source": "iana",
        "extensions": [
            "xif"
        ]
    },
    "image/vnd.zbrush.pcx": {
        "source": "iana",
        "extensions": [
            "pcx"
        ]
    },
    "image/webp": {
        "source": "apache",
        "extensions": [
            "webp"
        ]
    },
    "image/wmf": {
        "source": "iana",
        "extensions": [
            "wmf"
        ]
    },
    "image/x-3ds": {
        "source": "apache",
        "extensions": [
            "3ds"
        ]
    },
    "image/x-cmu-raster": {
        "source": "apache",
        "extensions": [
            "ras"
        ]
    },
    "image/x-cmx": {
        "source": "apache",
        "extensions": [
            "cmx"
        ]
    },
    "image/x-freehand": {
        "source": "apache",
        "extensions": [
            "fh",
            "fhc",
            "fh4",
            "fh5",
            "fh7"
        ]
    },
    "image/x-icon": {
        "source": "apache",
        "compressible": true,
        "extensions": [
            "ico"
        ]
    },
    "image/x-jng": {
        "source": "nginx",
        "extensions": [
            "jng"
        ]
    },
    "image/x-mrsid-image": {
        "source": "apache",
        "extensions": [
            "sid"
        ]
    },
    "image/x-ms-bmp": {
        "source": "nginx",
        "compressible": true,
        "extensions": [
            "bmp"
        ]
    },
    "image/x-pcx": {
        "source": "apache",
        "extensions": [
            "pcx"
        ]
    },
    "image/x-pict": {
        "source": "apache",
        "extensions": [
            "pic",
            "pct"
        ]
    },
    "image/x-portable-anymap": {
        "source": "apache",
        "extensions": [
            "pnm"
        ]
    },
    "image/x-portable-bitmap": {
        "source": "apache",
        "extensions": [
            "pbm"
        ]
    },
    "image/x-portable-graymap": {
        "source": "apache",
        "extensions": [
            "pgm"
        ]
    },
    "image/x-portable-pixmap": {
        "source": "apache",
        "extensions": [
            "ppm"
        ]
    },
    "image/x-rgb": {
        "source": "apache",
        "extensions": [
            "rgb"
        ]
    },
    "image/x-tga": {
        "source": "apache",
        "extensions": [
            "tga"
        ]
    },
    "image/x-xbitmap": {
        "source": "apache",
        "extensions": [
            "xbm"
        ]
    },
    "image/x-xcf": {
        "compressible": false
    },
    "image/x-xpixmap": {
        "source": "apache",
        "extensions": [
            "xpm"
        ]
    },
    "image/x-xwindowdump": {
        "source": "apache",
        "extensions": [
            "xwd"
        ]
    },
    "message/cpim": {
        "source": "iana"
    },
    "message/delivery-status": {
        "source": "iana"
    },
    "message/disposition-notification": {
        "source": "iana",
        "extensions": [
            "disposition-notification"
        ]
    },
    "message/external-body": {
        "source": "iana"
    },
    "message/feedback-report": {
        "source": "iana"
    },
    "message/global": {
        "source": "iana",
        "extensions": [
            "u8msg"
        ]
    },
    "message/global-delivery-status": {
        "source": "iana",
        "extensions": [
            "u8dsn"
        ]
    },
    "message/global-disposition-notification": {
        "source": "iana",
        "extensions": [
            "u8mdn"
        ]
    },
    "message/global-headers": {
        "source": "iana",
        "extensions": [
            "u8hdr"
        ]
    },
    "message/http": {
        "source": "iana",
        "compressible": false
    },
    "message/imdn+xml": {
        "source": "iana",
        "compressible": true
    },
    "message/news": {
        "source": "iana"
    },
    "message/partial": {
        "source": "iana",
        "compressible": false
    },
    "message/rfc822": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "eml",
            "mime"
        ]
    },
    "message/s-http": {
        "source": "iana"
    },
    "message/sip": {
        "source": "iana"
    },
    "message/sipfrag": {
        "source": "iana"
    },
    "message/tracking-status": {
        "source": "iana"
    },
    "message/vnd.si.simp": {
        "source": "iana"
    },
    "message/vnd.wfa.wsc": {
        "source": "iana",
        "extensions": [
            "wsc"
        ]
    },
    "model/3mf": {
        "source": "iana",
        "extensions": [
            "3mf"
        ]
    },
    "model/e57": {
        "source": "iana"
    },
    "model/gltf+json": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "gltf"
        ]
    },
    "model/gltf-binary": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "glb"
        ]
    },
    "model/iges": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "igs",
            "iges"
        ]
    },
    "model/mesh": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "msh",
            "mesh",
            "silo"
        ]
    },
    "model/mtl": {
        "source": "iana",
        "extensions": [
            "mtl"
        ]
    },
    "model/obj": {
        "source": "iana",
        "extensions": [
            "obj"
        ]
    },
    "model/step": {
        "source": "iana"
    },
    "model/step+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "stpx"
        ]
    },
    "model/step+zip": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "stpz"
        ]
    },
    "model/step-xml+zip": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "stpxz"
        ]
    },
    "model/stl": {
        "source": "iana",
        "extensions": [
            "stl"
        ]
    },
    "model/vnd.collada+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "dae"
        ]
    },
    "model/vnd.dwf": {
        "source": "iana",
        "extensions": [
            "dwf"
        ]
    },
    "model/vnd.flatland.3dml": {
        "source": "iana"
    },
    "model/vnd.gdl": {
        "source": "iana",
        "extensions": [
            "gdl"
        ]
    },
    "model/vnd.gs-gdl": {
        "source": "apache"
    },
    "model/vnd.gs.gdl": {
        "source": "iana"
    },
    "model/vnd.gtw": {
        "source": "iana",
        "extensions": [
            "gtw"
        ]
    },
    "model/vnd.moml+xml": {
        "source": "iana",
        "compressible": true
    },
    "model/vnd.mts": {
        "source": "iana",
        "extensions": [
            "mts"
        ]
    },
    "model/vnd.opengex": {
        "source": "iana",
        "extensions": [
            "ogex"
        ]
    },
    "model/vnd.parasolid.transmit.binary": {
        "source": "iana",
        "extensions": [
            "x_b"
        ]
    },
    "model/vnd.parasolid.transmit.text": {
        "source": "iana",
        "extensions": [
            "x_t"
        ]
    },
    "model/vnd.pytha.pyox": {
        "source": "iana"
    },
    "model/vnd.rosette.annotated-data-model": {
        "source": "iana"
    },
    "model/vnd.sap.vds": {
        "source": "iana",
        "extensions": [
            "vds"
        ]
    },
    "model/vnd.usdz+zip": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "usdz"
        ]
    },
    "model/vnd.valve.source.compiled-map": {
        "source": "iana",
        "extensions": [
            "bsp"
        ]
    },
    "model/vnd.vtu": {
        "source": "iana",
        "extensions": [
            "vtu"
        ]
    },
    "model/vrml": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "wrl",
            "vrml"
        ]
    },
    "model/x3d+binary": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "x3db",
            "x3dbz"
        ]
    },
    "model/x3d+fastinfoset": {
        "source": "iana",
        "extensions": [
            "x3db"
        ]
    },
    "model/x3d+vrml": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "x3dv",
            "x3dvz"
        ]
    },
    "model/x3d+xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "x3d",
            "x3dz"
        ]
    },
    "model/x3d-vrml": {
        "source": "iana",
        "extensions": [
            "x3dv"
        ]
    },
    "multipart/alternative": {
        "source": "iana",
        "compressible": false
    },
    "multipart/appledouble": {
        "source": "iana"
    },
    "multipart/byteranges": {
        "source": "iana"
    },
    "multipart/digest": {
        "source": "iana"
    },
    "multipart/encrypted": {
        "source": "iana",
        "compressible": false
    },
    "multipart/form-data": {
        "source": "iana",
        "compressible": false
    },
    "multipart/header-set": {
        "source": "iana"
    },
    "multipart/mixed": {
        "source": "iana"
    },
    "multipart/multilingual": {
        "source": "iana"
    },
    "multipart/parallel": {
        "source": "iana"
    },
    "multipart/related": {
        "source": "iana",
        "compressible": false
    },
    "multipart/report": {
        "source": "iana"
    },
    "multipart/signed": {
        "source": "iana",
        "compressible": false
    },
    "multipart/vnd.bint.med-plus": {
        "source": "iana"
    },
    "multipart/voice-message": {
        "source": "iana"
    },
    "multipart/x-mixed-replace": {
        "source": "iana"
    },
    "text/1d-interleaved-parityfec": {
        "source": "iana"
    },
    "text/cache-manifest": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "appcache",
            "manifest"
        ]
    },
    "text/calendar": {
        "source": "iana",
        "extensions": [
            "ics",
            "ifb"
        ]
    },
    "text/calender": {
        "compressible": true
    },
    "text/cmd": {
        "compressible": true
    },
    "text/coffeescript": {
        "extensions": [
            "coffee",
            "litcoffee"
        ]
    },
    "text/cql": {
        "source": "iana"
    },
    "text/cql-expression": {
        "source": "iana"
    },
    "text/cql-identifier": {
        "source": "iana"
    },
    "text/css": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "css"
        ]
    },
    "text/csv": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "csv"
        ]
    },
    "text/csv-schema": {
        "source": "iana"
    },
    "text/directory": {
        "source": "iana"
    },
    "text/dns": {
        "source": "iana"
    },
    "text/ecmascript": {
        "source": "iana"
    },
    "text/encaprtp": {
        "source": "iana"
    },
    "text/enriched": {
        "source": "iana"
    },
    "text/fhirpath": {
        "source": "iana"
    },
    "text/flexfec": {
        "source": "iana"
    },
    "text/fwdred": {
        "source": "iana"
    },
    "text/gff3": {
        "source": "iana"
    },
    "text/grammar-ref-list": {
        "source": "iana"
    },
    "text/html": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "html",
            "htm",
            "shtml"
        ]
    },
    "text/jade": {
        "extensions": [
            "jade"
        ]
    },
    "text/javascript": {
        "source": "iana",
        "compressible": true
    },
    "text/jcr-cnd": {
        "source": "iana"
    },
    "text/jsx": {
        "compressible": true,
        "extensions": [
            "jsx"
        ]
    },
    "text/less": {
        "compressible": true,
        "extensions": [
            "less"
        ]
    },
    "text/markdown": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "markdown",
            "md"
        ]
    },
    "text/mathml": {
        "source": "nginx",
        "extensions": [
            "mml"
        ]
    },
    "text/mdx": {
        "compressible": true,
        "extensions": [
            "mdx"
        ]
    },
    "text/mizar": {
        "source": "iana"
    },
    "text/n3": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "n3"
        ]
    },
    "text/parameters": {
        "source": "iana",
        "charset": "UTF-8"
    },
    "text/parityfec": {
        "source": "iana"
    },
    "text/plain": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "txt",
            "text",
            "conf",
            "def",
            "list",
            "log",
            "in",
            "ini"
        ]
    },
    "text/provenance-notation": {
        "source": "iana",
        "charset": "UTF-8"
    },
    "text/prs.fallenstein.rst": {
        "source": "iana"
    },
    "text/prs.lines.tag": {
        "source": "iana",
        "extensions": [
            "dsc"
        ]
    },
    "text/prs.prop.logic": {
        "source": "iana"
    },
    "text/raptorfec": {
        "source": "iana"
    },
    "text/red": {
        "source": "iana"
    },
    "text/rfc822-headers": {
        "source": "iana"
    },
    "text/richtext": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rtx"
        ]
    },
    "text/rtf": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "rtf"
        ]
    },
    "text/rtp-enc-aescm128": {
        "source": "iana"
    },
    "text/rtploopback": {
        "source": "iana"
    },
    "text/rtx": {
        "source": "iana"
    },
    "text/sgml": {
        "source": "iana",
        "extensions": [
            "sgml",
            "sgm"
        ]
    },
    "text/shaclc": {
        "source": "iana"
    },
    "text/shex": {
        "source": "iana",
        "extensions": [
            "shex"
        ]
    },
    "text/slim": {
        "extensions": [
            "slim",
            "slm"
        ]
    },
    "text/spdx": {
        "source": "iana",
        "extensions": [
            "spdx"
        ]
    },
    "text/strings": {
        "source": "iana"
    },
    "text/stylus": {
        "extensions": [
            "stylus",
            "styl"
        ]
    },
    "text/t140": {
        "source": "iana"
    },
    "text/tab-separated-values": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "tsv"
        ]
    },
    "text/troff": {
        "source": "iana",
        "extensions": [
            "t",
            "tr",
            "roff",
            "man",
            "me",
            "ms"
        ]
    },
    "text/turtle": {
        "source": "iana",
        "charset": "UTF-8",
        "extensions": [
            "ttl"
        ]
    },
    "text/ulpfec": {
        "source": "iana"
    },
    "text/uri-list": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "uri",
            "uris",
            "urls"
        ]
    },
    "text/vcard": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "vcard"
        ]
    },
    "text/vnd.a": {
        "source": "iana"
    },
    "text/vnd.abc": {
        "source": "iana"
    },
    "text/vnd.ascii-art": {
        "source": "iana"
    },
    "text/vnd.curl": {
        "source": "iana",
        "extensions": [
            "curl"
        ]
    },
    "text/vnd.curl.dcurl": {
        "source": "apache",
        "extensions": [
            "dcurl"
        ]
    },
    "text/vnd.curl.mcurl": {
        "source": "apache",
        "extensions": [
            "mcurl"
        ]
    },
    "text/vnd.curl.scurl": {
        "source": "apache",
        "extensions": [
            "scurl"
        ]
    },
    "text/vnd.debian.copyright": {
        "source": "iana",
        "charset": "UTF-8"
    },
    "text/vnd.dmclientscript": {
        "source": "iana"
    },
    "text/vnd.dvb.subtitle": {
        "source": "iana",
        "extensions": [
            "sub"
        ]
    },
    "text/vnd.esmertec.theme-descriptor": {
        "source": "iana",
        "charset": "UTF-8"
    },
    "text/vnd.familysearch.gedcom": {
        "source": "iana",
        "extensions": [
            "ged"
        ]
    },
    "text/vnd.ficlab.flt": {
        "source": "iana"
    },
    "text/vnd.fly": {
        "source": "iana",
        "extensions": [
            "fly"
        ]
    },
    "text/vnd.fmi.flexstor": {
        "source": "iana",
        "extensions": [
            "flx"
        ]
    },
    "text/vnd.gml": {
        "source": "iana"
    },
    "text/vnd.graphviz": {
        "source": "iana",
        "extensions": [
            "gv"
        ]
    },
    "text/vnd.hans": {
        "source": "iana"
    },
    "text/vnd.hgl": {
        "source": "iana"
    },
    "text/vnd.in3d.3dml": {
        "source": "iana",
        "extensions": [
            "3dml"
        ]
    },
    "text/vnd.in3d.spot": {
        "source": "iana",
        "extensions": [
            "spot"
        ]
    },
    "text/vnd.iptc.newsml": {
        "source": "iana"
    },
    "text/vnd.iptc.nitf": {
        "source": "iana"
    },
    "text/vnd.latex-z": {
        "source": "iana"
    },
    "text/vnd.motorola.reflex": {
        "source": "iana"
    },
    "text/vnd.ms-mediapackage": {
        "source": "iana"
    },
    "text/vnd.net2phone.commcenter.command": {
        "source": "iana"
    },
    "text/vnd.radisys.msml-basic-layout": {
        "source": "iana"
    },
    "text/vnd.senx.warpscript": {
        "source": "iana"
    },
    "text/vnd.si.uricatalogue": {
        "source": "iana"
    },
    "text/vnd.sosi": {
        "source": "iana"
    },
    "text/vnd.sun.j2me.app-descriptor": {
        "source": "iana",
        "charset": "UTF-8",
        "extensions": [
            "jad"
        ]
    },
    "text/vnd.trolltech.linguist": {
        "source": "iana",
        "charset": "UTF-8"
    },
    "text/vnd.wap.si": {
        "source": "iana"
    },
    "text/vnd.wap.sl": {
        "source": "iana"
    },
    "text/vnd.wap.wml": {
        "source": "iana",
        "extensions": [
            "wml"
        ]
    },
    "text/vnd.wap.wmlscript": {
        "source": "iana",
        "extensions": [
            "wmls"
        ]
    },
    "text/vtt": {
        "source": "iana",
        "charset": "UTF-8",
        "compressible": true,
        "extensions": [
            "vtt"
        ]
    },
    "text/x-asm": {
        "source": "apache",
        "extensions": [
            "s",
            "asm"
        ]
    },
    "text/x-c": {
        "source": "apache",
        "extensions": [
            "c",
            "cc",
            "cxx",
            "cpp",
            "h",
            "hh",
            "dic"
        ]
    },
    "text/x-component": {
        "source": "nginx",
        "extensions": [
            "htc"
        ]
    },
    "text/x-fortran": {
        "source": "apache",
        "extensions": [
            "f",
            "for",
            "f77",
            "f90"
        ]
    },
    "text/x-gwt-rpc": {
        "compressible": true
    },
    "text/x-handlebars-template": {
        "extensions": [
            "hbs"
        ]
    },
    "text/x-java-source": {
        "source": "apache",
        "extensions": [
            "java"
        ]
    },
    "text/x-jquery-tmpl": {
        "compressible": true
    },
    "text/x-lua": {
        "extensions": [
            "lua"
        ]
    },
    "text/x-markdown": {
        "compressible": true,
        "extensions": [
            "mkd"
        ]
    },
    "text/x-nfo": {
        "source": "apache",
        "extensions": [
            "nfo"
        ]
    },
    "text/x-opml": {
        "source": "apache",
        "extensions": [
            "opml"
        ]
    },
    "text/x-org": {
        "compressible": true,
        "extensions": [
            "org"
        ]
    },
    "text/x-pascal": {
        "source": "apache",
        "extensions": [
            "p",
            "pas"
        ]
    },
    "text/x-processing": {
        "compressible": true,
        "extensions": [
            "pde"
        ]
    },
    "text/x-sass": {
        "extensions": [
            "sass"
        ]
    },
    "text/x-scss": {
        "extensions": [
            "scss"
        ]
    },
    "text/x-setext": {
        "source": "apache",
        "extensions": [
            "etx"
        ]
    },
    "text/x-sfv": {
        "source": "apache",
        "extensions": [
            "sfv"
        ]
    },
    "text/x-suse-ymp": {
        "compressible": true,
        "extensions": [
            "ymp"
        ]
    },
    "text/x-uuencode": {
        "source": "apache",
        "extensions": [
            "uu"
        ]
    },
    "text/x-vcalendar": {
        "source": "apache",
        "extensions": [
            "vcs"
        ]
    },
    "text/x-vcard": {
        "source": "apache",
        "extensions": [
            "vcf"
        ]
    },
    "text/xml": {
        "source": "iana",
        "compressible": true,
        "extensions": [
            "xml"
        ]
    },
    "text/xml-external-parsed-entity": {
        "source": "iana"
    },
    "text/yaml": {
        "compressible": true,
        "extensions": [
            "yaml",
            "yml"
        ]
    },
    "video/1d-interleaved-parityfec": {
        "source": "iana"
    },
    "video/3gpp": {
        "source": "iana",
        "extensions": [
            "3gp",
            "3gpp"
        ]
    },
    "video/3gpp-tt": {
        "source": "iana"
    },
    "video/3gpp2": {
        "source": "iana",
        "extensions": [
            "3g2"
        ]
    },
    "video/av1": {
        "source": "iana"
    },
    "video/bmpeg": {
        "source": "iana"
    },
    "video/bt656": {
        "source": "iana"
    },
    "video/celb": {
        "source": "iana"
    },
    "video/dv": {
        "source": "iana"
    },
    "video/encaprtp": {
        "source": "iana"
    },
    "video/ffv1": {
        "source": "iana"
    },
    "video/flexfec": {
        "source": "iana"
    },
    "video/h261": {
        "source": "iana",
        "extensions": [
            "h261"
        ]
    },
    "video/h263": {
        "source": "iana",
        "extensions": [
            "h263"
        ]
    },
    "video/h263-1998": {
        "source": "iana"
    },
    "video/h263-2000": {
        "source": "iana"
    },
    "video/h264": {
        "source": "iana",
        "extensions": [
            "h264"
        ]
    },
    "video/h264-rcdo": {
        "source": "iana"
    },
    "video/h264-svc": {
        "source": "iana"
    },
    "video/h265": {
        "source": "iana"
    },
    "video/iso.segment": {
        "source": "iana",
        "extensions": [
            "m4s"
        ]
    },
    "video/jpeg": {
        "source": "iana",
        "extensions": [
            "jpgv"
        ]
    },
    "video/jpeg2000": {
        "source": "iana"
    },
    "video/jpm": {
        "source": "apache",
        "extensions": [
            "jpm",
            "jpgm"
        ]
    },
    "video/jxsv": {
        "source": "iana"
    },
    "video/mj2": {
        "source": "iana",
        "extensions": [
            "mj2",
            "mjp2"
        ]
    },
    "video/mp1s": {
        "source": "iana"
    },
    "video/mp2p": {
        "source": "iana"
    },
    "video/mp2t": {
        "source": "iana",
        "extensions": [
            "ts"
        ]
    },
    "video/mp4": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "mp4",
            "mp4v",
            "mpg4"
        ]
    },
    "video/mp4v-es": {
        "source": "iana"
    },
    "video/mpeg": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "mpeg",
            "mpg",
            "mpe",
            "m1v",
            "m2v"
        ]
    },
    "video/mpeg4-generic": {
        "source": "iana"
    },
    "video/mpv": {
        "source": "iana"
    },
    "video/nv": {
        "source": "iana"
    },
    "video/ogg": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "ogv"
        ]
    },
    "video/parityfec": {
        "source": "iana"
    },
    "video/pointer": {
        "source": "iana"
    },
    "video/quicktime": {
        "source": "iana",
        "compressible": false,
        "extensions": [
            "qt",
            "mov"
        ]
    },
    "video/raptorfec": {
        "source": "iana"
    },
    "video/raw": {
        "source": "iana"
    },
    "video/rtp-enc-aescm128": {
        "source": "iana"
    },
    "video/rtploopback": {
        "source": "iana"
    },
    "video/rtx": {
        "source": "iana"
    },
    "video/scip": {
        "source": "iana"
    },
    "video/smpte291": {
        "source": "iana"
    },
    "video/smpte292m": {
        "source": "iana"
    },
    "video/ulpfec": {
        "source": "iana"
    },
    "video/vc1": {
        "source": "iana"
    },
    "video/vc2": {
        "source": "iana"
    },
    "video/vnd.cctv": {
        "source": "iana"
    },
    "video/vnd.dece.hd": {
        "source": "iana",
        "extensions": [
            "uvh",
            "uvvh"
        ]
    },
    "video/vnd.dece.mobile": {
        "source": "iana",
        "extensions": [
            "uvm",
            "uvvm"
        ]
    },
    "video/vnd.dece.mp4": {
        "source": "iana"
    },
    "video/vnd.dece.pd": {
        "source": "iana",
        "extensions": [
            "uvp",
            "uvvp"
        ]
    },
    "video/vnd.dece.sd": {
        "source": "iana",
        "extensions": [
            "uvs",
            "uvvs"
        ]
    },
    "video/vnd.dece.video": {
        "source": "iana",
        "extensions": [
            "uvv",
            "uvvv"
        ]
    },
    "video/vnd.directv.mpeg": {
        "source": "iana"
    },
    "video/vnd.directv.mpeg-tts": {
        "source": "iana"
    },
    "video/vnd.dlna.mpeg-tts": {
        "source": "iana"
    },
    "video/vnd.dvb.file": {
        "source": "iana",
        "extensions": [
            "dvb"
        ]
    },
    "video/vnd.fvt": {
        "source": "iana",
        "extensions": [
            "fvt"
        ]
    },
    "video/vnd.hns.video": {
        "source": "iana"
    },
    "video/vnd.iptvforum.1dparityfec-1010": {
        "source": "iana"
    },
    "video/vnd.iptvforum.1dparityfec-2005": {
        "source": "iana"
    },
    "video/vnd.iptvforum.2dparityfec-1010": {
        "source": "iana"
    },
    "video/vnd.iptvforum.2dparityfec-2005": {
        "source": "iana"
    },
    "video/vnd.iptvforum.ttsavc": {
        "source": "iana"
    },
    "video/vnd.iptvforum.ttsmpeg2": {
        "source": "iana"
    },
    "video/vnd.motorola.video": {
        "source": "iana"
    },
    "video/vnd.motorola.videop": {
        "source": "iana"
    },
    "video/vnd.mpegurl": {
        "source": "iana",
        "extensions": [
            "mxu",
            "m4u"
        ]
    },
    "video/vnd.ms-playready.media.pyv": {
        "source": "iana",
        "extensions": [
            "pyv"
        ]
    },
    "video/vnd.nokia.interleaved-multimedia": {
        "source": "iana"
    },
    "video/vnd.nokia.mp4vr": {
        "source": "iana"
    },
    "video/vnd.nokia.videovoip": {
        "source": "iana"
    },
    "video/vnd.objectvideo": {
        "source": "iana"
    },
    "video/vnd.radgamettools.bink": {
        "source": "iana"
    },
    "video/vnd.radgamettools.smacker": {
        "source": "iana"
    },
    "video/vnd.sealed.mpeg1": {
        "source": "iana"
    },
    "video/vnd.sealed.mpeg4": {
        "source": "iana"
    },
    "video/vnd.sealed.swf": {
        "source": "iana"
    },
    "video/vnd.sealedmedia.softseal.mov": {
        "source": "iana"
    },
    "video/vnd.uvvu.mp4": {
        "source": "iana",
        "extensions": [
            "uvu",
            "uvvu"
        ]
    },
    "video/vnd.vivo": {
        "source": "iana",
        "extensions": [
            "viv"
        ]
    },
    "video/vnd.youtube.yt": {
        "source": "iana"
    },
    "video/vp8": {
        "source": "iana"
    },
    "video/vp9": {
        "source": "iana"
    },
    "video/webm": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "webm"
        ]
    },
    "video/x-f4v": {
        "source": "apache",
        "extensions": [
            "f4v"
        ]
    },
    "video/x-fli": {
        "source": "apache",
        "extensions": [
            "fli"
        ]
    },
    "video/x-flv": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "flv"
        ]
    },
    "video/x-m4v": {
        "source": "apache",
        "extensions": [
            "m4v"
        ]
    },
    "video/x-matroska": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "mkv",
            "mk3d",
            "mks"
        ]
    },
    "video/x-mng": {
        "source": "apache",
        "extensions": [
            "mng"
        ]
    },
    "video/x-ms-asf": {
        "source": "apache",
        "extensions": [
            "asf",
            "asx"
        ]
    },
    "video/x-ms-vob": {
        "source": "apache",
        "extensions": [
            "vob"
        ]
    },
    "video/x-ms-wm": {
        "source": "apache",
        "extensions": [
            "wm"
        ]
    },
    "video/x-ms-wmv": {
        "source": "apache",
        "compressible": false,
        "extensions": [
            "wmv"
        ]
    },
    "video/x-ms-wmx": {
        "source": "apache",
        "extensions": [
            "wmx"
        ]
    },
    "video/x-ms-wvx": {
        "source": "apache",
        "extensions": [
            "wvx"
        ]
    },
    "video/x-msvideo": {
        "source": "apache",
        "extensions": [
            "avi"
        ]
    },
    "video/x-sgi-movie": {
        "source": "apache",
        "extensions": [
            "movie"
        ]
    },
    "video/x-smv": {
        "source": "apache",
        "extensions": [
            "smv"
        ]
    },
    "x-conference/x-cooltalk": {
        "source": "apache",
        "extensions": [
            "ice"
        ]
    },
    "x-shader/x-fragment": {
        "compressible": true
    },
    "x-shader/x-vertex": {
        "compressible": true
    }
};
//# sourceMappingURL=data:application/json;base64,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