import { mul64, swap32 } from "./util.ts";
const prime64Lo = 435;
const prime64Hi = 256;
export const fnv64 = (data) => {
    let hashLo = 2216829733;
    let hashHi = 3421674724;
    data.forEach((c) => {
        [hashHi, hashLo] = mul64([hashHi, hashLo], [prime64Hi, prime64Lo]);
        hashLo ^= c;
    });
    return new Uint32Array([swap32(hashHi >>> 0), swap32(hashLo >>> 0)]).buffer;
};
export const fnv64a = (data) => {
    let hashLo = 2216829733;
    let hashHi = 3421674724;
    data.forEach((c) => {
        hashLo ^= c;
        [hashHi, hashLo] = mul64([hashHi, hashLo], [prime64Hi, prime64Lo]);
    });
    return new Uint32Array([swap32(hashHi >>> 0), swap32(hashLo >>> 0)]).buffer;
};
//# sourceMappingURL=data:application/json;base64,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