import { mul32, swap32 } from "./util.ts";
const prime32 = 16777619;
export const fnv32 = (data) => {
    let hash = 2166136261;
    data.forEach((c) => {
        hash = mul32(hash, prime32);
        hash ^= c;
    });
    return Uint32Array.from([swap32(hash)]).buffer;
};
export const fnv32a = (data) => {
    let hash = 2166136261;
    data.forEach((c) => {
        hash ^= c;
        hash = mul32(hash, prime32);
    });
    return Uint32Array.from([swap32(hash)]).buffer;
};
//# sourceMappingURL=data:application/json;base64,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