import { YAMLError } from "./error.ts";
function compileList(schema, name, result) {
    const exclude = [];
    for (const includedSchema of schema.include) {
        result = compileList(includedSchema, name, result);
    }
    for (const currentType of schema[name]) {
        for (let previousIndex = 0; previousIndex < result.length; previousIndex++) {
            const previousType = result[previousIndex];
            if (previousType.tag === currentType.tag &&
                previousType.kind === currentType.kind) {
                exclude.push(previousIndex);
            }
        }
        result.push(currentType);
    }
    return result.filter((_type, index) => !exclude.includes(index));
}
function compileMap(...typesList) {
    const result = {
        fallback: {},
        mapping: {},
        scalar: {},
        sequence: {},
    };
    for (const types of typesList) {
        for (const type of types) {
            if (type.kind !== null) {
                result[type.kind][type.tag] = result["fallback"][type.tag] = type;
            }
        }
    }
    return result;
}
export class Schema {
    static SCHEMA_DEFAULT;
    implicit;
    explicit;
    include;
    compiledImplicit;
    compiledExplicit;
    compiledTypeMap;
    constructor(definition) {
        this.explicit = definition.explicit || [];
        this.implicit = definition.implicit || [];
        this.include = definition.include || [];
        for (const type of this.implicit) {
            if (type.loadKind && type.loadKind !== "scalar") {
                throw new YAMLError("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
            }
        }
        this.compiledImplicit = compileList(this, "implicit", []);
        this.compiledExplicit = compileList(this, "explicit", []);
        this.compiledTypeMap = compileMap(this.compiledImplicit, this.compiledExplicit);
    }
    extend(definition) {
        return new Schema({
            implicit: [
                ...new Set([...this.implicit, ...(definition?.implicit ?? [])]),
            ],
            explicit: [
                ...new Set([...this.explicit, ...(definition?.explicit ?? [])]),
            ],
            include: [...new Set([...this.include, ...(definition?.include ?? [])])],
        });
    }
    static create() { }
}
//# sourceMappingURL=data:application/json;base64,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