// Ported from js-yaml v3.13.1:
// Copyright 2011-2015 by Vitaly Puzrin. All rights reserved. MIT license.
// https://github.com/nodeca/js-yaml/commit/665aadda42349dcae869f12040d9b10ef18d12da
// Copyright 2018-2024 the Deno authors. All rights reserved. MIT license.
// [ 64, 65, 66 ] -> [ padding, CR, LF ]
const BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
function resolveYamlBinary(data) {
  if (data === null) return false;
  let code;
  let bitlen = 0;
  const max = data.length;
  const map = BASE64_MAP;
  // Convert one by one.
  for(let idx = 0; idx < max; idx++){
    code = map.indexOf(data.charAt(idx));
    // Skip CR/LF
    if (code > 64) continue;
    // Fail on illegal characters
    if (code < 0) return false;
    bitlen += 6;
  }
  // If there are any bits left, source was corrupted
  return bitlen % 8 === 0;
}
function constructYamlBinary(data) {
  // remove CR/LF & padding to simplify scan
  const input = data.replace(/[\r\n=]/g, "");
  const max = input.length;
  const map = BASE64_MAP;
  // Collect by 6*4 bits (3 bytes)
  const result = [];
  let bits = 0;
  for(let idx = 0; idx < max; idx++){
    if (idx % 4 === 0 && idx) {
      result.push(bits >> 16 & 0xff);
      result.push(bits >> 8 & 0xff);
      result.push(bits & 0xff);
    }
    bits = bits << 6 | map.indexOf(input.charAt(idx));
  }
  // Dump tail
  const tailbits = max % 4 * 6;
  if (tailbits === 0) {
    result.push(bits >> 16 & 0xff);
    result.push(bits >> 8 & 0xff);
    result.push(bits & 0xff);
  } else if (tailbits === 18) {
    result.push(bits >> 10 & 0xff);
    result.push(bits >> 2 & 0xff);
  } else if (tailbits === 12) {
    result.push(bits >> 4 & 0xff);
  }
  return new Uint8Array(result);
}
function representYamlBinary(object) {
  const max = object.length;
  const map = BASE64_MAP;
  // Convert every three bytes to 4 ASCII characters.
  let result = "";
  let bits = 0;
  for(let idx = 0; idx < max; idx++){
    if (idx % 3 === 0 && idx) {
      result += map[bits >> 18 & 0x3f];
      result += map[bits >> 12 & 0x3f];
      result += map[bits >> 6 & 0x3f];
      result += map[bits & 0x3f];
    }
    bits = (bits << 8) + object[idx];
  }
  // Dump tail
  const tail = max % 3;
  if (tail === 0) {
    result += map[bits >> 18 & 0x3f];
    result += map[bits >> 12 & 0x3f];
    result += map[bits >> 6 & 0x3f];
    result += map[bits & 0x3f];
  } else if (tail === 2) {
    result += map[bits >> 10 & 0x3f];
    result += map[bits >> 4 & 0x3f];
    result += map[bits << 2 & 0x3f];
    result += map[64];
  } else if (tail === 1) {
    result += map[bits >> 2 & 0x3f];
    result += map[bits << 4 & 0x3f];
    result += map[64];
    result += map[64];
  }
  return result;
}
function isBinary(obj) {
  return obj instanceof Uint8Array;
}
export const binary = {
  tag: "tag:yaml.org,2002:binary",
  construct: constructYamlBinary,
  kind: "scalar",
  predicate: isBinary,
  represent: representYamlBinary,
  resolve: resolveYamlBinary
};
//# sourceMappingURL=data:application/json;base64,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
// denoCacheMetadata=17482961167074963811,15701654225825954337