// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
/** This module is browser compatible. */ export class BinarySearchNode {
    left;
    right;
    constructor(parent, value){
        this.parent = parent;
        this.value = value;
        this.left = null;
        this.right = null;
    }
    static from(node) {
        const copy = new BinarySearchNode(node.parent, node.value);
        copy.left = node.left;
        copy.right = node.right;
        return copy;
    }
    directionFromParent() {
        return this.parent === null ? null : this === this.parent.left ? "left" : this === this.parent.right ? "right" : null;
    }
    findMinNode() {
        let minNode = this.left;
        while(minNode?.left)minNode = minNode.left;
        return minNode ?? this;
    }
    findMaxNode() {
        let maxNode = this.right;
        while(maxNode?.right)maxNode = maxNode.right;
        return maxNode ?? this;
    }
    findSuccessorNode() {
        if (this.right !== null) return this.right.findMinNode();
        let parent = this.parent;
        let direction = this.directionFromParent();
        while(parent && direction === "right"){
            direction = parent.directionFromParent();
            parent = parent.parent;
        }
        return parent;
    }
    parent;
    value;
}
//# sourceMappingURL=data:application/json;base64,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