// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
import { assert } from "../testing/asserts.ts";
/** Compare to array buffers or data views in a way that timing based attacks
 * cannot gain information about the platform. */ export function timingSafeEqual(a, b) {
    if (a.byteLength !== b.byteLength) {
        return false;
    }
    if (!(a instanceof DataView)) {
        a = new DataView(ArrayBuffer.isView(a) ? a.buffer : a);
    }
    if (!(b instanceof DataView)) {
        b = new DataView(ArrayBuffer.isView(b) ? b.buffer : b);
    }
    assert(a instanceof DataView);
    assert(b instanceof DataView);
    const length = a.byteLength;
    let out = 0;
    let i = -1;
    while(++i < length){
        out |= a.getUint8(i) ^ b.getUint8(i);
    }
    return out === 0;
}
//# sourceMappingURL=data:application/json;base64,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