#
# SessionAutomationClient.R
#
# Copyright (C) 2024 by Posit Software, PBC
#
# Unless you have received this program directly from Posit Software pursuant
# to the terms of a commercial license agreement with Posit Software, then
# this program is licensed to you under the terms of version 3 of the
# GNU Affero General Public License. This program is distributed WITHOUT
# ANY EXPRESS OR IMPLIED WARRANTY, INCLUDING THOSE OF NON-INFRINGEMENT,
# MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Please refer to the
# AGPL (http://www.gnu.org/licenses/agpl-3.0.txt) for more details.
#
#

# .----------------------------------------------------------.
# | This file was auto-generated by "generate-cdp-client.R". |
# | Please do not modify this file by hand.                  |
# `----------------------------------------------------------`

.rs.addFunction("automation.createClient", function(socket)
{
  list(Accessibility.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Accessibility.disable", list())
}, Accessibility.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Accessibility.enable", list())
}, Accessibility.getPartialAXTree = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL, fetchRelatives = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Accessibility.getPartialAXTree", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId, fetchRelatives = fetchRelatives))
}, Accessibility.getFullAXTree = function(depth = NULL, frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Accessibility.getFullAXTree", list(depth = depth, frameId = frameId))
}, Accessibility.getRootAXNode = function(frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Accessibility.getRootAXNode", list(frameId = frameId))
}, Accessibility.getAXNodeAndAncestors = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Accessibility.getAXNodeAndAncestors", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId))
}, Accessibility.getChildAXNodes = function(id = NULL, frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Accessibility.getChildAXNodes", list(id = id, frameId = frameId))
}, Accessibility.queryAXTree = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL, accessibleName = NULL, role = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Accessibility.queryAXTree", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId, accessibleName = accessibleName, role = role))
}, Animation.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Animation.disable", list())
}, Animation.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Animation.enable", list())
}, Animation.getCurrentTime = function(id = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Animation.getCurrentTime", list(id = id))
}, Animation.getPlaybackRate = function() {
    .rs.automation.sendSynchronousRequest(socket, "Animation.getPlaybackRate", list())
}, Animation.releaseAnimations = function(animations = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Animation.releaseAnimations", list(animations = animations))
}, Animation.resolveAnimation = function(animationId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Animation.resolveAnimation", list(animationId = animationId))
}, Animation.seekAnimations = function(animations = NULL, currentTime = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Animation.seekAnimations", list(animations = animations, currentTime = currentTime))
}, Animation.setPaused = function(animations = NULL, paused = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Animation.setPaused", list(animations = animations, paused = paused))
}, Animation.setPlaybackRate = function(playbackRate = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Animation.setPlaybackRate", list(playbackRate = playbackRate))
}, Animation.setTiming = function(animationId = NULL, duration = NULL, delay = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Animation.setTiming", list(animationId = animationId, duration = duration, delay = delay))
}, Audits.getEncodedResponse = function(requestId = NULL, encoding = NULL, quality = NULL, sizeOnly = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Audits.getEncodedResponse", list(requestId = requestId, encoding = encoding, quality = quality, sizeOnly = sizeOnly))
}, Audits.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Audits.disable", list())
}, Audits.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Audits.enable", list())
}, Audits.checkContrast = function(reportAAA = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Audits.checkContrast", list(reportAAA = reportAAA))
}, BackgroundService.startObserving = function(service = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "BackgroundService.startObserving", list(service = service))
}, BackgroundService.stopObserving = function(service = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "BackgroundService.stopObserving", list(service = service))
}, BackgroundService.setRecording = function(shouldRecord = NULL, service = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "BackgroundService.setRecording", list(shouldRecord = shouldRecord, service = service))
}, BackgroundService.clearEvents = function(service = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "BackgroundService.clearEvents", list(service = service))
}, Browser.setPermission = function(permission = NULL, setting = NULL, origin = NULL, browserContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.setPermission", list(permission = permission, setting = setting, origin = origin, browserContextId = browserContextId))
}, Browser.grantPermissions = function(permissions = NULL, origin = NULL, browserContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.grantPermissions", list(permissions = permissions, origin = origin, browserContextId = browserContextId))
}, Browser.resetPermissions = function(browserContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.resetPermissions", list(browserContextId = browserContextId))
}, Browser.setDownloadBehavior = function(behavior = NULL, browserContextId = NULL, downloadPath = NULL, eventsEnabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.setDownloadBehavior", list(behavior = behavior, browserContextId = browserContextId, downloadPath = downloadPath, eventsEnabled = eventsEnabled))
}, Browser.cancelDownload = function(guid = NULL, browserContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.cancelDownload", list(guid = guid, browserContextId = browserContextId))
}, Browser.close = function() {
    .rs.automation.sendSynchronousRequest(socket, "Browser.close", list())
}, Browser.crash = function() {
    .rs.automation.sendSynchronousRequest(socket, "Browser.crash", list())
}, Browser.crashGpuProcess = function() {
    .rs.automation.sendSynchronousRequest(socket, "Browser.crashGpuProcess", list())
}, Browser.getVersion = function() {
    .rs.automation.sendSynchronousRequest(socket, "Browser.getVersion", list())
}, Browser.getBrowserCommandLine = function() {
    .rs.automation.sendSynchronousRequest(socket, "Browser.getBrowserCommandLine", list())
}, Browser.getHistograms = function(query = NULL, delta = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.getHistograms", list(query = query, delta = delta))
}, Browser.getHistogram = function(name = NULL, delta = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.getHistogram", list(name = name, delta = delta))
}, Browser.getWindowBounds = function(windowId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.getWindowBounds", list(windowId = windowId))
}, Browser.getWindowForTarget = function(targetId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.getWindowForTarget", list(targetId = targetId))
}, Browser.setWindowBounds = function(windowId = NULL, bounds = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.setWindowBounds", list(windowId = windowId, bounds = bounds))
}, Browser.setDockTile = function(badgeLabel = NULL, image = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.setDockTile", list(badgeLabel = badgeLabel, image = image))
}, Browser.executeBrowserCommand = function(commandId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Browser.executeBrowserCommand", list(commandId = commandId))
}, CSS.addRule = function(styleSheetId = NULL, ruleText = NULL, location = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.addRule", list(styleSheetId = styleSheetId, ruleText = ruleText, location = location))
}, CSS.collectClassNames = function(styleSheetId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.collectClassNames", list(styleSheetId = styleSheetId))
}, CSS.createStyleSheet = function(frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.createStyleSheet", list(frameId = frameId))
}, CSS.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "CSS.disable", list())
}, CSS.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "CSS.enable", list())
}, CSS.forcePseudoState = function(nodeId = NULL, forcedPseudoClasses = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.forcePseudoState", list(nodeId = nodeId, forcedPseudoClasses = forcedPseudoClasses))
}, CSS.getBackgroundColors = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.getBackgroundColors", list(nodeId = nodeId))
}, CSS.getComputedStyleForNode = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.getComputedStyleForNode", list(nodeId = nodeId))
}, CSS.getInlineStylesForNode = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.getInlineStylesForNode", list(nodeId = nodeId))
}, CSS.getMatchedStylesForNode = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.getMatchedStylesForNode", list(nodeId = nodeId))
}, CSS.getMediaQueries = function() {
    .rs.automation.sendSynchronousRequest(socket, "CSS.getMediaQueries", list())
}, CSS.getPlatformFontsForNode = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.getPlatformFontsForNode", list(nodeId = nodeId))
}, CSS.getStyleSheetText = function(styleSheetId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.getStyleSheetText", list(styleSheetId = styleSheetId))
}, CSS.getLayersForNode = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.getLayersForNode", list(nodeId = nodeId))
}, CSS.trackComputedStyleUpdates = function(propertiesToTrack = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.trackComputedStyleUpdates", list(propertiesToTrack = propertiesToTrack))
}, CSS.takeComputedStyleUpdates = function() {
    .rs.automation.sendSynchronousRequest(socket, "CSS.takeComputedStyleUpdates", list())
}, CSS.setEffectivePropertyValueForNode = function(nodeId = NULL, propertyName = NULL, value = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setEffectivePropertyValueForNode", list(nodeId = nodeId, propertyName = propertyName, value = value))
}, CSS.setKeyframeKey = function(styleSheetId = NULL, range = NULL, keyText = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setKeyframeKey", list(styleSheetId = styleSheetId, range = range, keyText = keyText))
}, CSS.setMediaText = function(styleSheetId = NULL, range = NULL, text = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setMediaText", list(styleSheetId = styleSheetId, range = range, text = text))
}, CSS.setContainerQueryText = function(styleSheetId = NULL, range = NULL, text = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setContainerQueryText", list(styleSheetId = styleSheetId, range = range, text = text))
}, CSS.setSupportsText = function(styleSheetId = NULL, range = NULL, text = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setSupportsText", list(styleSheetId = styleSheetId, range = range, text = text))
}, CSS.setScopeText = function(styleSheetId = NULL, range = NULL, text = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setScopeText", list(styleSheetId = styleSheetId, range = range, text = text))
}, CSS.setRuleSelector = function(styleSheetId = NULL, range = NULL, selector = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setRuleSelector", list(styleSheetId = styleSheetId, range = range, selector = selector))
}, CSS.setStyleSheetText = function(styleSheetId = NULL, text = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setStyleSheetText", list(styleSheetId = styleSheetId, text = text))
}, CSS.setStyleTexts = function(edits = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setStyleTexts", list(edits = edits))
}, CSS.startRuleUsageTracking = function() {
    .rs.automation.sendSynchronousRequest(socket, "CSS.startRuleUsageTracking", list())
}, CSS.stopRuleUsageTracking = function() {
    .rs.automation.sendSynchronousRequest(socket, "CSS.stopRuleUsageTracking", list())
}, CSS.takeCoverageDelta = function() {
    .rs.automation.sendSynchronousRequest(socket, "CSS.takeCoverageDelta", list())
}, CSS.setLocalFontsEnabled = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CSS.setLocalFontsEnabled", list(enabled = enabled))
}, CacheStorage.deleteCache = function(cacheId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CacheStorage.deleteCache", list(cacheId = cacheId))
}, CacheStorage.deleteEntry = function(cacheId = NULL, request = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CacheStorage.deleteEntry", list(cacheId = cacheId, request = request))
}, CacheStorage.requestCacheNames = function(securityOrigin = NULL, storageKey = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CacheStorage.requestCacheNames", list(securityOrigin = securityOrigin, storageKey = storageKey))
}, CacheStorage.requestCachedResponse = function(cacheId = NULL, requestURL = NULL, requestHeaders = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CacheStorage.requestCachedResponse", list(cacheId = cacheId, requestURL = requestURL, requestHeaders = requestHeaders))
}, CacheStorage.requestEntries = function(cacheId = NULL, skipCount = NULL, pageSize = NULL, pathFilter = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "CacheStorage.requestEntries", list(cacheId = cacheId, skipCount = skipCount, pageSize = pageSize, pathFilter = pathFilter))
}, Cast.enable = function(presentationUrl = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Cast.enable", list(presentationUrl = presentationUrl))
}, Cast.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Cast.disable", list())
}, Cast.setSinkToUse = function(sinkName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Cast.setSinkToUse", list(sinkName = sinkName))
}, Cast.startDesktopMirroring = function(sinkName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Cast.startDesktopMirroring", list(sinkName = sinkName))
}, Cast.startTabMirroring = function(sinkName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Cast.startTabMirroring", list(sinkName = sinkName))
}, Cast.stopCasting = function(sinkName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Cast.stopCasting", list(sinkName = sinkName))
}, DOM.collectClassNamesFromSubtree = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.collectClassNamesFromSubtree", list(nodeId = nodeId))
}, DOM.copyTo = function(nodeId = NULL, targetNodeId = NULL, insertBeforeNodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.copyTo", list(nodeId = nodeId, targetNodeId = targetNodeId, insertBeforeNodeId = insertBeforeNodeId))
}, DOM.describeNode = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL, depth = NULL, pierce = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.describeNode", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId, depth = depth, pierce = pierce))
}, DOM.scrollIntoViewIfNeeded = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL, rect = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.scrollIntoViewIfNeeded", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId, rect = rect))
}, DOM.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOM.disable", list())
}, DOM.discardSearchResults = function(searchId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.discardSearchResults", list(searchId = searchId))
}, DOM.enable = function(includeWhitespace = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.enable", list(includeWhitespace = includeWhitespace))
}, DOM.focus = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.focus", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId))
}, DOM.getAttributes = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getAttributes", list(nodeId = nodeId))
}, DOM.getBoxModel = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getBoxModel", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId))
}, DOM.getContentQuads = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getContentQuads", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId))
}, DOM.getDocument = function(depth = NULL, pierce = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getDocument", list(depth = depth, pierce = pierce))
}, DOM.getFlattenedDocument = function(depth = NULL, pierce = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getFlattenedDocument", list(depth = depth, pierce = pierce))
}, DOM.getNodesForSubtreeByStyle = function(nodeId = NULL, computedStyles = NULL, pierce = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getNodesForSubtreeByStyle", list(nodeId = nodeId, computedStyles = computedStyles, pierce = pierce))
}, DOM.getNodeForLocation = function(x = NULL, y = NULL, includeUserAgentShadowDOM = NULL, ignorePointerEventsNone = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getNodeForLocation", list(x = x, y = y, includeUserAgentShadowDOM = includeUserAgentShadowDOM, ignorePointerEventsNone = ignorePointerEventsNone))
}, DOM.getOuterHTML = function(nodeId = NULL, backendNodeId = NULL, objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getOuterHTML", list(nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId))
}, DOM.getRelayoutBoundary = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getRelayoutBoundary", list(nodeId = nodeId))
}, DOM.getSearchResults = function(searchId = NULL, fromIndex = NULL, toIndex = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getSearchResults", list(searchId = searchId, fromIndex = fromIndex, toIndex = toIndex))
}, DOM.hideHighlight = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOM.hideHighlight", list())
}, DOM.highlightNode = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOM.highlightNode", list())
}, DOM.highlightRect = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOM.highlightRect", list())
}, DOM.markUndoableState = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOM.markUndoableState", list())
}, DOM.moveTo = function(nodeId = NULL, targetNodeId = NULL, insertBeforeNodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.moveTo", list(nodeId = nodeId, targetNodeId = targetNodeId, insertBeforeNodeId = insertBeforeNodeId))
}, DOM.performSearch = function(query = NULL, includeUserAgentShadowDOM = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.performSearch", list(query = query, includeUserAgentShadowDOM = includeUserAgentShadowDOM))
}, DOM.pushNodeByPathToFrontend = function(path = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.pushNodeByPathToFrontend", list(path = path))
}, DOM.pushNodesByBackendIdsToFrontend = function(backendNodeIds = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.pushNodesByBackendIdsToFrontend", list(backendNodeIds = backendNodeIds))
}, DOM.querySelector = function(nodeId = NULL, selector = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.querySelector", list(nodeId = nodeId, selector = selector))
}, DOM.querySelectorAll = function(nodeId = NULL, selector = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.querySelectorAll", list(nodeId = nodeId, selector = selector))
}, DOM.getTopLayerElements = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getTopLayerElements", list())
}, DOM.redo = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOM.redo", list())
}, DOM.removeAttribute = function(nodeId = NULL, name = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.removeAttribute", list(nodeId = nodeId, name = name))
}, DOM.removeNode = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.removeNode", list(nodeId = nodeId))
}, DOM.requestChildNodes = function(nodeId = NULL, depth = NULL, pierce = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.requestChildNodes", list(nodeId = nodeId, depth = depth, pierce = pierce))
}, DOM.requestNode = function(objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.requestNode", list(objectId = objectId))
}, DOM.resolveNode = function(nodeId = NULL, backendNodeId = NULL, objectGroup = NULL, executionContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.resolveNode", list(nodeId = nodeId, backendNodeId = backendNodeId, objectGroup = objectGroup, executionContextId = executionContextId))
}, DOM.setAttributeValue = function(nodeId = NULL, name = NULL, value = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.setAttributeValue", list(nodeId = nodeId, name = name, value = value))
}, DOM.setAttributesAsText = function(nodeId = NULL, text = NULL, name = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.setAttributesAsText", list(nodeId = nodeId, text = text, name = name))
}, DOM.setFileInputFiles = function(files = NULL, nodeId = NULL, backendNodeId = NULL, objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.setFileInputFiles", list(files = files, nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId))
}, DOM.setNodeStackTracesEnabled = function(enable = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.setNodeStackTracesEnabled", list(enable = enable))
}, DOM.getNodeStackTraces = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getNodeStackTraces", list(nodeId = nodeId))
}, DOM.getFileInfo = function(objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getFileInfo", list(objectId = objectId))
}, DOM.setInspectedNode = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.setInspectedNode", list(nodeId = nodeId))
}, DOM.setNodeName = function(nodeId = NULL, name = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.setNodeName", list(nodeId = nodeId, name = name))
}, DOM.setNodeValue = function(nodeId = NULL, value = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.setNodeValue", list(nodeId = nodeId, value = value))
}, DOM.setOuterHTML = function(nodeId = NULL, outerHTML = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.setOuterHTML", list(nodeId = nodeId, outerHTML = outerHTML))
}, DOM.undo = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOM.undo", list())
}, DOM.getFrameOwner = function(frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getFrameOwner", list(frameId = frameId))
}, DOM.getContainerForNode = function(nodeId = NULL, containerName = NULL, physicalAxes = NULL, logicalAxes = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getContainerForNode", list(nodeId = nodeId, containerName = containerName, physicalAxes = physicalAxes, logicalAxes = logicalAxes))
}, DOM.getQueryingDescendantsForContainer = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOM.getQueryingDescendantsForContainer", list(nodeId = nodeId))
}, DOMDebugger.getEventListeners = function(objectId = NULL, depth = NULL, pierce = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.getEventListeners", list(objectId = objectId, depth = depth, pierce = pierce))
}, DOMDebugger.removeDOMBreakpoint = function(nodeId = NULL, type = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.removeDOMBreakpoint", list(nodeId = nodeId, type = type))
}, DOMDebugger.removeEventListenerBreakpoint = function(eventName = NULL, targetName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.removeEventListenerBreakpoint", list(eventName = eventName, targetName = targetName))
}, DOMDebugger.removeInstrumentationBreakpoint = function(eventName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.removeInstrumentationBreakpoint", list(eventName = eventName))
}, DOMDebugger.removeXHRBreakpoint = function(url = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.removeXHRBreakpoint", list(url = url))
}, DOMDebugger.setBreakOnCSPViolation = function(violationTypes = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.setBreakOnCSPViolation", list(violationTypes = violationTypes))
}, DOMDebugger.setDOMBreakpoint = function(nodeId = NULL, type = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.setDOMBreakpoint", list(nodeId = nodeId, type = type))
}, DOMDebugger.setEventListenerBreakpoint = function(eventName = NULL, targetName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.setEventListenerBreakpoint", list(eventName = eventName, targetName = targetName))
}, DOMDebugger.setInstrumentationBreakpoint = function(eventName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.setInstrumentationBreakpoint", list(eventName = eventName))
}, DOMDebugger.setXHRBreakpoint = function(url = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMDebugger.setXHRBreakpoint", list(url = url))
}, EventBreakpoints.setInstrumentationBreakpoint = function(eventName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "EventBreakpoints.setInstrumentationBreakpoint", list(eventName = eventName))
}, EventBreakpoints.removeInstrumentationBreakpoint = function(eventName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "EventBreakpoints.removeInstrumentationBreakpoint", list(eventName = eventName))
}, DOMSnapshot.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOMSnapshot.disable", list())
}, DOMSnapshot.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOMSnapshot.enable", list())
}, DOMSnapshot.getSnapshot = function(computedStyleWhitelist = NULL, includeEventListeners = NULL, includePaintOrder = NULL, includeUserAgentShadowTree = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMSnapshot.getSnapshot", list(computedStyleWhitelist = computedStyleWhitelist, includeEventListeners = includeEventListeners, includePaintOrder = includePaintOrder, includeUserAgentShadowTree = includeUserAgentShadowTree))
}, DOMSnapshot.captureSnapshot = function(computedStyles = NULL, includePaintOrder = NULL, includeDOMRects = NULL, includeBlendedBackgroundColors = NULL, includeTextColorOpacities = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMSnapshot.captureSnapshot", list(computedStyles = computedStyles, includePaintOrder = includePaintOrder, includeDOMRects = includeDOMRects, includeBlendedBackgroundColors = includeBlendedBackgroundColors, includeTextColorOpacities = includeTextColorOpacities))
}, DOMStorage.clear = function(storageId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMStorage.clear", list(storageId = storageId))
}, DOMStorage.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOMStorage.disable", list())
}, DOMStorage.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "DOMStorage.enable", list())
}, DOMStorage.getDOMStorageItems = function(storageId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMStorage.getDOMStorageItems", list(storageId = storageId))
}, DOMStorage.removeDOMStorageItem = function(storageId = NULL, key = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMStorage.removeDOMStorageItem", list(storageId = storageId, key = key))
}, DOMStorage.setDOMStorageItem = function(storageId = NULL, key = NULL, value = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DOMStorage.setDOMStorageItem", list(storageId = storageId, key = key, value = value))
}, Database.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Database.disable", list())
}, Database.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Database.enable", list())
}, Database.executeSQL = function(databaseId = NULL, query = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Database.executeSQL", list(databaseId = databaseId, query = query))
}, Database.getDatabaseTableNames = function(databaseId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Database.getDatabaseTableNames", list(databaseId = databaseId))
}, DeviceOrientation.clearDeviceOrientationOverride = function() {
    .rs.automation.sendSynchronousRequest(socket, "DeviceOrientation.clearDeviceOrientationOverride", list())
}, DeviceOrientation.setDeviceOrientationOverride = function(alpha = NULL, beta = NULL, gamma = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DeviceOrientation.setDeviceOrientationOverride", list(alpha = alpha, beta = beta, gamma = gamma))
}, Emulation.canEmulate = function() {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.canEmulate", list())
}, Emulation.clearDeviceMetricsOverride = function() {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.clearDeviceMetricsOverride", list())
}, Emulation.clearGeolocationOverride = function() {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.clearGeolocationOverride", list())
}, Emulation.resetPageScaleFactor = function() {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.resetPageScaleFactor", list())
}, Emulation.setFocusEmulationEnabled = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setFocusEmulationEnabled", list(enabled = enabled))
}, Emulation.setAutoDarkModeOverride = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setAutoDarkModeOverride", list(enabled = enabled))
}, Emulation.setCPUThrottlingRate = function(rate = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setCPUThrottlingRate", list(rate = rate))
}, Emulation.setDefaultBackgroundColorOverride = function(color = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setDefaultBackgroundColorOverride", list(color = color))
}, Emulation.setDeviceMetricsOverride = function(width = NULL, height = NULL, deviceScaleFactor = NULL, mobile = NULL, scale = NULL, screenWidth = NULL, screenHeight = NULL, positionX = NULL, positionY = NULL, dontSetVisibleSize = NULL, screenOrientation = NULL, viewport = NULL, displayFeature = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setDeviceMetricsOverride", list(width = width, height = height, deviceScaleFactor = deviceScaleFactor, mobile = mobile, scale = scale, screenWidth = screenWidth, screenHeight = screenHeight, positionX = positionX, positionY = positionY, dontSetVisibleSize = dontSetVisibleSize, screenOrientation = screenOrientation, viewport = viewport, displayFeature = displayFeature))
}, Emulation.setScrollbarsHidden = function(hidden = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setScrollbarsHidden", list(hidden = hidden))
}, Emulation.setDocumentCookieDisabled = function(disabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setDocumentCookieDisabled", list(disabled = disabled))
}, Emulation.setEmitTouchEventsForMouse = function(enabled = NULL, configuration = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setEmitTouchEventsForMouse", list(enabled = enabled, configuration = configuration))
}, Emulation.setEmulatedMedia = function(media = NULL, features = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setEmulatedMedia", list(media = media, features = features))
}, Emulation.setEmulatedVisionDeficiency = function(type = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setEmulatedVisionDeficiency", list(type = type))
}, Emulation.setGeolocationOverride = function(latitude = NULL, longitude = NULL, accuracy = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setGeolocationOverride", list(latitude = latitude, longitude = longitude, accuracy = accuracy))
}, Emulation.setIdleOverride = function(isUserActive = NULL, isScreenUnlocked = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setIdleOverride", list(isUserActive = isUserActive, isScreenUnlocked = isScreenUnlocked))
}, Emulation.clearIdleOverride = function() {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.clearIdleOverride", list())
}, Emulation.setNavigatorOverrides = function(platform = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setNavigatorOverrides", list(platform = platform))
}, Emulation.setPageScaleFactor = function(pageScaleFactor = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setPageScaleFactor", list(pageScaleFactor = pageScaleFactor))
}, Emulation.setScriptExecutionDisabled = function(value = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setScriptExecutionDisabled", list(value = value))
}, Emulation.setTouchEmulationEnabled = function(enabled = NULL, maxTouchPoints = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setTouchEmulationEnabled", list(enabled = enabled, maxTouchPoints = maxTouchPoints))
}, Emulation.setVirtualTimePolicy = function(policy = NULL, budget = NULL, maxVirtualTimeTaskStarvationCount = NULL, initialVirtualTime = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setVirtualTimePolicy", list(policy = policy, budget = budget, maxVirtualTimeTaskStarvationCount = maxVirtualTimeTaskStarvationCount, initialVirtualTime = initialVirtualTime))
}, Emulation.setLocaleOverride = function(locale = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setLocaleOverride", list(locale = locale))
}, Emulation.setTimezoneOverride = function(timezoneId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setTimezoneOverride", list(timezoneId = timezoneId))
}, Emulation.setVisibleSize = function(width = NULL, height = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setVisibleSize", list(width = width, height = height))
}, Emulation.setDisabledImageTypes = function(imageTypes = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setDisabledImageTypes", list(imageTypes = imageTypes))
}, Emulation.setHardwareConcurrencyOverride = function(hardwareConcurrency = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setHardwareConcurrencyOverride", list(hardwareConcurrency = hardwareConcurrency))
}, Emulation.setUserAgentOverride = function(userAgent = NULL, acceptLanguage = NULL, platform = NULL, userAgentMetadata = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setUserAgentOverride", list(userAgent = userAgent, acceptLanguage = acceptLanguage, platform = platform, userAgentMetadata = userAgentMetadata))
}, Emulation.setAutomationOverride = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Emulation.setAutomationOverride", list(enabled = enabled))
}, HeadlessExperimental.beginFrame = function(frameTimeTicks = NULL, interval = NULL, noDisplayUpdates = NULL, screenshot = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "HeadlessExperimental.beginFrame", list(frameTimeTicks = frameTimeTicks, interval = interval, noDisplayUpdates = noDisplayUpdates, screenshot = screenshot))
}, HeadlessExperimental.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "HeadlessExperimental.disable", list())
}, HeadlessExperimental.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "HeadlessExperimental.enable", list())
}, IO.close = function(handle = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IO.close", list(handle = handle))
}, IO.read = function(handle = NULL, offset = NULL, size = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IO.read", list(handle = handle, offset = offset, size = size))
}, IO.resolveBlob = function(objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IO.resolveBlob", list(objectId = objectId))
}, IndexedDB.clearObjectStore = function(securityOrigin = NULL, storageKey = NULL, databaseName = NULL, objectStoreName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.clearObjectStore", list(securityOrigin = securityOrigin, storageKey = storageKey, databaseName = databaseName, objectStoreName = objectStoreName))
}, IndexedDB.deleteDatabase = function(securityOrigin = NULL, storageKey = NULL, databaseName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.deleteDatabase", list(securityOrigin = securityOrigin, storageKey = storageKey, databaseName = databaseName))
}, IndexedDB.deleteObjectStoreEntries = function(securityOrigin = NULL, storageKey = NULL, databaseName = NULL, objectStoreName = NULL, keyRange = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.deleteObjectStoreEntries", list(securityOrigin = securityOrigin, storageKey = storageKey, databaseName = databaseName, objectStoreName = objectStoreName, keyRange = keyRange))
}, IndexedDB.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.disable", list())
}, IndexedDB.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.enable", list())
}, IndexedDB.requestData = function(securityOrigin = NULL, storageKey = NULL, databaseName = NULL, objectStoreName = NULL, indexName = NULL, skipCount = NULL, pageSize = NULL, keyRange = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.requestData", list(securityOrigin = securityOrigin, storageKey = storageKey, databaseName = databaseName, objectStoreName = objectStoreName, indexName = indexName, skipCount = skipCount, pageSize = pageSize, keyRange = keyRange))
}, IndexedDB.getMetadata = function(securityOrigin = NULL, storageKey = NULL, databaseName = NULL, objectStoreName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.getMetadata", list(securityOrigin = securityOrigin, storageKey = storageKey, databaseName = databaseName, objectStoreName = objectStoreName))
}, IndexedDB.requestDatabase = function(securityOrigin = NULL, storageKey = NULL, databaseName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.requestDatabase", list(securityOrigin = securityOrigin, storageKey = storageKey, databaseName = databaseName))
}, IndexedDB.requestDatabaseNames = function(securityOrigin = NULL, storageKey = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "IndexedDB.requestDatabaseNames", list(securityOrigin = securityOrigin, storageKey = storageKey))
}, Input.dispatchDragEvent = function(type = NULL, x = NULL, y = NULL, data = NULL, modifiers = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.dispatchDragEvent", list(type = type, x = x, y = y, data = data, modifiers = modifiers))
}, Input.dispatchKeyEvent = function(type = NULL, modifiers = NULL, timestamp = NULL, text = NULL, unmodifiedText = NULL, keyIdentifier = NULL, code = NULL, key = NULL, windowsVirtualKeyCode = NULL, nativeVirtualKeyCode = NULL, autoRepeat = NULL, isKeypad = NULL, isSystemKey = NULL, location = NULL, commands = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.dispatchKeyEvent", list(type = type, modifiers = modifiers, timestamp = timestamp, text = text, unmodifiedText = unmodifiedText, keyIdentifier = keyIdentifier, code = code, key = key, windowsVirtualKeyCode = windowsVirtualKeyCode, nativeVirtualKeyCode = nativeVirtualKeyCode, autoRepeat = autoRepeat, isKeypad = isKeypad, isSystemKey = isSystemKey, location = location, commands = commands))
}, Input.insertText = function(text = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.insertText", list(text = text))
}, Input.imeSetComposition = function(text = NULL, selectionStart = NULL, selectionEnd = NULL, replacementStart = NULL, replacementEnd = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.imeSetComposition", list(text = text, selectionStart = selectionStart, selectionEnd = selectionEnd, replacementStart = replacementStart, replacementEnd = replacementEnd))
}, Input.dispatchMouseEvent = function(type = NULL, x = NULL, y = NULL, modifiers = NULL, timestamp = NULL, button = NULL, buttons = NULL, clickCount = NULL, force = NULL, tangentialPressure = NULL, tiltX = NULL, tiltY = NULL, twist = NULL, deltaX = NULL, deltaY = NULL, pointerType = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.dispatchMouseEvent", list(type = type, x = x, y = y, modifiers = modifiers, timestamp = timestamp, button = button, buttons = buttons, clickCount = clickCount, force = force, tangentialPressure = tangentialPressure, tiltX = tiltX, tiltY = tiltY, twist = twist, deltaX = deltaX, deltaY = deltaY, pointerType = pointerType))
}, Input.dispatchTouchEvent = function(type = NULL, touchPoints = NULL, modifiers = NULL, timestamp = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.dispatchTouchEvent", list(type = type, touchPoints = touchPoints, modifiers = modifiers, timestamp = timestamp))
}, Input.emulateTouchFromMouseEvent = function(type = NULL, x = NULL, y = NULL, button = NULL, timestamp = NULL, deltaX = NULL, deltaY = NULL, modifiers = NULL, clickCount = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.emulateTouchFromMouseEvent", list(type = type, x = x, y = y, button = button, timestamp = timestamp, deltaX = deltaX, deltaY = deltaY, modifiers = modifiers, clickCount = clickCount))
}, Input.setIgnoreInputEvents = function(ignore = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.setIgnoreInputEvents", list(ignore = ignore))
}, Input.setInterceptDrags = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.setInterceptDrags", list(enabled = enabled))
}, Input.synthesizePinchGesture = function(x = NULL, y = NULL, scaleFactor = NULL, relativeSpeed = NULL, gestureSourceType = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.synthesizePinchGesture", list(x = x, y = y, scaleFactor = scaleFactor, relativeSpeed = relativeSpeed, gestureSourceType = gestureSourceType))
}, Input.synthesizeScrollGesture = function(x = NULL, y = NULL, xDistance = NULL, yDistance = NULL, xOverscroll = NULL, yOverscroll = NULL, preventFling = NULL, speed = NULL, gestureSourceType = NULL, repeatCount = NULL, repeatDelayMs = NULL, interactionMarkerName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.synthesizeScrollGesture", list(x = x, y = y, xDistance = xDistance, yDistance = yDistance, xOverscroll = xOverscroll, yOverscroll = yOverscroll, preventFling = preventFling, speed = speed, gestureSourceType = gestureSourceType, repeatCount = repeatCount, repeatDelayMs = repeatDelayMs, interactionMarkerName = interactionMarkerName))
}, Input.synthesizeTapGesture = function(x = NULL, y = NULL, duration = NULL, tapCount = NULL, gestureSourceType = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Input.synthesizeTapGesture", list(x = x, y = y, duration = duration, tapCount = tapCount, gestureSourceType = gestureSourceType))
}, Inspector.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Inspector.disable", list())
}, Inspector.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Inspector.enable", list())
}, LayerTree.compositingReasons = function(layerId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.compositingReasons", list(layerId = layerId))
}, LayerTree.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.disable", list())
}, LayerTree.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.enable", list())
}, LayerTree.loadSnapshot = function(tiles = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.loadSnapshot", list(tiles = tiles))
}, LayerTree.makeSnapshot = function(layerId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.makeSnapshot", list(layerId = layerId))
}, LayerTree.profileSnapshot = function(snapshotId = NULL, minRepeatCount = NULL, minDuration = NULL, clipRect = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.profileSnapshot", list(snapshotId = snapshotId, minRepeatCount = minRepeatCount, minDuration = minDuration, clipRect = clipRect))
}, LayerTree.releaseSnapshot = function(snapshotId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.releaseSnapshot", list(snapshotId = snapshotId))
}, LayerTree.replaySnapshot = function(snapshotId = NULL, fromStep = NULL, toStep = NULL, scale = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.replaySnapshot", list(snapshotId = snapshotId, fromStep = fromStep, toStep = toStep, scale = scale))
}, LayerTree.snapshotCommandLog = function(snapshotId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "LayerTree.snapshotCommandLog", list(snapshotId = snapshotId))
}, Log.clear = function() {
    .rs.automation.sendSynchronousRequest(socket, "Log.clear", list())
}, Log.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Log.disable", list())
}, Log.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Log.enable", list())
}, Log.startViolationsReport = function(config = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Log.startViolationsReport", list(config = config))
}, Log.stopViolationsReport = function() {
    .rs.automation.sendSynchronousRequest(socket, "Log.stopViolationsReport", list())
}, Memory.getDOMCounters = function() {
    .rs.automation.sendSynchronousRequest(socket, "Memory.getDOMCounters", list())
}, Memory.prepareForLeakDetection = function() {
    .rs.automation.sendSynchronousRequest(socket, "Memory.prepareForLeakDetection", list())
}, Memory.forciblyPurgeJavaScriptMemory = function() {
    .rs.automation.sendSynchronousRequest(socket, "Memory.forciblyPurgeJavaScriptMemory", list())
}, Memory.setPressureNotificationsSuppressed = function(suppressed = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Memory.setPressureNotificationsSuppressed", list(suppressed = suppressed))
}, Memory.simulatePressureNotification = function(level = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Memory.simulatePressureNotification", list(level = level))
}, Memory.startSampling = function(samplingInterval = NULL, suppressRandomness = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Memory.startSampling", list(samplingInterval = samplingInterval, suppressRandomness = suppressRandomness))
}, Memory.stopSampling = function() {
    .rs.automation.sendSynchronousRequest(socket, "Memory.stopSampling", list())
}, Memory.getAllTimeSamplingProfile = function() {
    .rs.automation.sendSynchronousRequest(socket, "Memory.getAllTimeSamplingProfile", list())
}, Memory.getBrowserSamplingProfile = function() {
    .rs.automation.sendSynchronousRequest(socket, "Memory.getBrowserSamplingProfile", list())
}, Memory.getSamplingProfile = function() {
    .rs.automation.sendSynchronousRequest(socket, "Memory.getSamplingProfile", list())
}, Network.setAcceptedEncodings = function(encodings = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setAcceptedEncodings", list(encodings = encodings))
}, Network.clearAcceptedEncodingsOverride = function() {
    .rs.automation.sendSynchronousRequest(socket, "Network.clearAcceptedEncodingsOverride", list())
}, Network.canClearBrowserCache = function() {
    .rs.automation.sendSynchronousRequest(socket, "Network.canClearBrowserCache", list())
}, Network.canClearBrowserCookies = function() {
    .rs.automation.sendSynchronousRequest(socket, "Network.canClearBrowserCookies", list())
}, Network.canEmulateNetworkConditions = function() {
    .rs.automation.sendSynchronousRequest(socket, "Network.canEmulateNetworkConditions", list())
}, Network.clearBrowserCache = function() {
    .rs.automation.sendSynchronousRequest(socket, "Network.clearBrowserCache", list())
}, Network.clearBrowserCookies = function() {
    .rs.automation.sendSynchronousRequest(socket, "Network.clearBrowserCookies", list())
}, Network.continueInterceptedRequest = function(interceptionId = NULL, errorReason = NULL, rawResponse = NULL, url = NULL, method = NULL, postData = NULL, headers = NULL, authChallengeResponse = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.continueInterceptedRequest", list(interceptionId = interceptionId, errorReason = errorReason, rawResponse = rawResponse, url = url, method = method, postData = postData, headers = headers, authChallengeResponse = authChallengeResponse))
}, Network.deleteCookies = function(name = NULL, url = NULL, domain = NULL, path = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.deleteCookies", list(name = name, url = url, domain = domain, path = path))
}, Network.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Network.disable", list())
}, Network.emulateNetworkConditions = function(offline = NULL, latency = NULL, downloadThroughput = NULL, uploadThroughput = NULL, connectionType = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.emulateNetworkConditions", list(offline = offline, latency = latency, downloadThroughput = downloadThroughput, uploadThroughput = uploadThroughput, connectionType = connectionType))
}, Network.enable = function(maxTotalBufferSize = NULL, maxResourceBufferSize = NULL, maxPostDataSize = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.enable", list(maxTotalBufferSize = maxTotalBufferSize, maxResourceBufferSize = maxResourceBufferSize, maxPostDataSize = maxPostDataSize))
}, Network.getAllCookies = function() {
    .rs.automation.sendSynchronousRequest(socket, "Network.getAllCookies", list())
}, Network.getCertificate = function(origin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.getCertificate", list(origin = origin))
}, Network.getCookies = function(urls = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.getCookies", list(urls = urls))
}, Network.getResponseBody = function(requestId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.getResponseBody", list(requestId = requestId))
}, Network.getRequestPostData = function(requestId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.getRequestPostData", list(requestId = requestId))
}, Network.getResponseBodyForInterception = function(interceptionId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.getResponseBodyForInterception", list(interceptionId = interceptionId))
}, Network.takeResponseBodyForInterceptionAsStream = function(interceptionId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.takeResponseBodyForInterceptionAsStream", list(interceptionId = interceptionId))
}, Network.replayXHR = function(requestId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.replayXHR", list(requestId = requestId))
}, Network.searchInResponseBody = function(requestId = NULL, query = NULL, caseSensitive = NULL, isRegex = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.searchInResponseBody", list(requestId = requestId, query = query, caseSensitive = caseSensitive, isRegex = isRegex))
}, Network.setBlockedURLs = function(urls = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setBlockedURLs", list(urls = urls))
}, Network.setBypassServiceWorker = function(bypass = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setBypassServiceWorker", list(bypass = bypass))
}, Network.setCacheDisabled = function(cacheDisabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setCacheDisabled", list(cacheDisabled = cacheDisabled))
}, Network.setCookie = function(name = NULL, value = NULL, url = NULL, domain = NULL, path = NULL, secure = NULL, httpOnly = NULL, sameSite = NULL, expires = NULL, priority = NULL, sameParty = NULL, sourceScheme = NULL, sourcePort = NULL, partitionKey = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setCookie", list(name = name, value = value, url = url, domain = domain, path = path, secure = secure, httpOnly = httpOnly, sameSite = sameSite, expires = expires, priority = priority, sameParty = sameParty, sourceScheme = sourceScheme, sourcePort = sourcePort, partitionKey = partitionKey))
}, Network.setCookies = function(cookies = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setCookies", list(cookies = cookies))
}, Network.setExtraHTTPHeaders = function(headers = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setExtraHTTPHeaders", list(headers = headers))
}, Network.setAttachDebugStack = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setAttachDebugStack", list(enabled = enabled))
}, Network.setRequestInterception = function(patterns = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setRequestInterception", list(patterns = patterns))
}, Network.setUserAgentOverride = function(userAgent = NULL, acceptLanguage = NULL, platform = NULL, userAgentMetadata = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.setUserAgentOverride", list(userAgent = userAgent, acceptLanguage = acceptLanguage, platform = platform, userAgentMetadata = userAgentMetadata))
}, Network.getSecurityIsolationStatus = function(frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.getSecurityIsolationStatus", list(frameId = frameId))
}, Network.enableReportingApi = function(enable = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.enableReportingApi", list(enable = enable))
}, Network.loadNetworkResource = function(frameId = NULL, url = NULL, options = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Network.loadNetworkResource", list(frameId = frameId, url = url, options = options))
}, Overlay.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.disable", list())
}, Overlay.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.enable", list())
}, Overlay.getHighlightObjectForTest = function(nodeId = NULL, includeDistance = NULL, includeStyle = NULL, colorFormat = NULL, showAccessibilityInfo = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.getHighlightObjectForTest", list(nodeId = nodeId, includeDistance = includeDistance, includeStyle = includeStyle, colorFormat = colorFormat, showAccessibilityInfo = showAccessibilityInfo))
}, Overlay.getGridHighlightObjectsForTest = function(nodeIds = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.getGridHighlightObjectsForTest", list(nodeIds = nodeIds))
}, Overlay.getSourceOrderHighlightObjectForTest = function(nodeId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.getSourceOrderHighlightObjectForTest", list(nodeId = nodeId))
}, Overlay.hideHighlight = function() {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.hideHighlight", list())
}, Overlay.highlightFrame = function(frameId = NULL, contentColor = NULL, contentOutlineColor = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.highlightFrame", list(frameId = frameId, contentColor = contentColor, contentOutlineColor = contentOutlineColor))
}, Overlay.highlightNode = function(highlightConfig = NULL, nodeId = NULL, backendNodeId = NULL, objectId = NULL, selector = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.highlightNode", list(highlightConfig = highlightConfig, nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId, selector = selector))
}, Overlay.highlightQuad = function(quad = NULL, color = NULL, outlineColor = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.highlightQuad", list(quad = quad, color = color, outlineColor = outlineColor))
}, Overlay.highlightRect = function(x = NULL, y = NULL, width = NULL, height = NULL, color = NULL, outlineColor = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.highlightRect", list(x = x, y = y, width = width, height = height, color = color, outlineColor = outlineColor))
}, Overlay.highlightSourceOrder = function(sourceOrderConfig = NULL, nodeId = NULL, backendNodeId = NULL, objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.highlightSourceOrder", list(sourceOrderConfig = sourceOrderConfig, nodeId = nodeId, backendNodeId = backendNodeId, objectId = objectId))
}, Overlay.setInspectMode = function(mode = NULL, highlightConfig = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setInspectMode", list(mode = mode, highlightConfig = highlightConfig))
}, Overlay.setShowAdHighlights = function(show = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowAdHighlights", list(show = show))
}, Overlay.setPausedInDebuggerMessage = function(message = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setPausedInDebuggerMessage", list(message = message))
}, Overlay.setShowDebugBorders = function(show = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowDebugBorders", list(show = show))
}, Overlay.setShowFPSCounter = function(show = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowFPSCounter", list(show = show))
}, Overlay.setShowGridOverlays = function(gridNodeHighlightConfigs = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowGridOverlays", list(gridNodeHighlightConfigs = gridNodeHighlightConfigs))
}, Overlay.setShowFlexOverlays = function(flexNodeHighlightConfigs = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowFlexOverlays", list(flexNodeHighlightConfigs = flexNodeHighlightConfigs))
}, Overlay.setShowScrollSnapOverlays = function(scrollSnapHighlightConfigs = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowScrollSnapOverlays", list(scrollSnapHighlightConfigs = scrollSnapHighlightConfigs))
}, Overlay.setShowContainerQueryOverlays = function(containerQueryHighlightConfigs = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowContainerQueryOverlays", list(containerQueryHighlightConfigs = containerQueryHighlightConfigs))
}, Overlay.setShowPaintRects = function(result = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowPaintRects", list(result = result))
}, Overlay.setShowLayoutShiftRegions = function(result = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowLayoutShiftRegions", list(result = result))
}, Overlay.setShowScrollBottleneckRects = function(show = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowScrollBottleneckRects", list(show = show))
}, Overlay.setShowHitTestBorders = function(show = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowHitTestBorders", list(show = show))
}, Overlay.setShowWebVitals = function(show = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowWebVitals", list(show = show))
}, Overlay.setShowViewportSizeOnResize = function(show = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowViewportSizeOnResize", list(show = show))
}, Overlay.setShowHinge = function(hingeConfig = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowHinge", list(hingeConfig = hingeConfig))
}, Overlay.setShowIsolatedElements = function(isolatedElementHighlightConfigs = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Overlay.setShowIsolatedElements", list(isolatedElementHighlightConfigs = isolatedElementHighlightConfigs))
}, Page.addScriptToEvaluateOnLoad = function(scriptSource = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.addScriptToEvaluateOnLoad", list(scriptSource = scriptSource))
}, Page.addScriptToEvaluateOnNewDocument = function(source = NULL, worldName = NULL, includeCommandLineAPI = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.addScriptToEvaluateOnNewDocument", list(source = source, worldName = worldName, includeCommandLineAPI = includeCommandLineAPI))
}, Page.bringToFront = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.bringToFront", list())
}, Page.captureScreenshot = function(format = NULL, quality = NULL, clip = NULL, fromSurface = NULL, captureBeyondViewport = NULL, optimizeForSpeed = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.captureScreenshot", list(format = format, quality = quality, clip = clip, fromSurface = fromSurface, captureBeyondViewport = captureBeyondViewport, optimizeForSpeed = optimizeForSpeed))
}, Page.captureSnapshot = function(format = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.captureSnapshot", list(format = format))
}, Page.clearDeviceMetricsOverride = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.clearDeviceMetricsOverride", list())
}, Page.clearDeviceOrientationOverride = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.clearDeviceOrientationOverride", list())
}, Page.clearGeolocationOverride = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.clearGeolocationOverride", list())
}, Page.createIsolatedWorld = function(frameId = NULL, worldName = NULL, grantUniveralAccess = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.createIsolatedWorld", list(frameId = frameId, worldName = worldName, grantUniveralAccess = grantUniveralAccess))
}, Page.deleteCookie = function(cookieName = NULL, url = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.deleteCookie", list(cookieName = cookieName, url = url))
}, Page.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.disable", list())
}, Page.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.enable", list())
}, Page.getAppManifest = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getAppManifest", list())
}, Page.getInstallabilityErrors = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getInstallabilityErrors", list())
}, Page.getManifestIcons = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getManifestIcons", list())
}, Page.getAppId = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getAppId", list())
}, Page.getAdScriptId = function(frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.getAdScriptId", list(frameId = frameId))
}, Page.getCookies = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getCookies", list())
}, Page.getFrameTree = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getFrameTree", list())
}, Page.getLayoutMetrics = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getLayoutMetrics", list())
}, Page.getNavigationHistory = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getNavigationHistory", list())
}, Page.resetNavigationHistory = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.resetNavigationHistory", list())
}, Page.getResourceContent = function(frameId = NULL, url = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.getResourceContent", list(frameId = frameId, url = url))
}, Page.getResourceTree = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.getResourceTree", list())
}, Page.handleJavaScriptDialog = function(accept = NULL, promptText = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.handleJavaScriptDialog", list(accept = accept, promptText = promptText))
}, Page.navigate = function(url = NULL, referrer = NULL, transitionType = NULL, frameId = NULL, referrerPolicy = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.navigate", list(url = url, referrer = referrer, transitionType = transitionType, frameId = frameId, referrerPolicy = referrerPolicy))
}, Page.navigateToHistoryEntry = function(entryId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.navigateToHistoryEntry", list(entryId = entryId))
}, Page.printToPDF = function(landscape = NULL, displayHeaderFooter = NULL, printBackground = NULL, scale = NULL, paperWidth = NULL, paperHeight = NULL, marginTop = NULL, marginBottom = NULL, marginLeft = NULL, marginRight = NULL, pageRanges = NULL, headerTemplate = NULL, footerTemplate = NULL, preferCSSPageSize = NULL, transferMode = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.printToPDF", list(landscape = landscape, displayHeaderFooter = displayHeaderFooter, printBackground = printBackground, scale = scale, paperWidth = paperWidth, paperHeight = paperHeight, marginTop = marginTop, marginBottom = marginBottom, marginLeft = marginLeft, marginRight = marginRight, pageRanges = pageRanges, headerTemplate = headerTemplate, footerTemplate = footerTemplate, preferCSSPageSize = preferCSSPageSize, transferMode = transferMode))
}, Page.reload = function(ignoreCache = NULL, scriptToEvaluateOnLoad = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.reload", list(ignoreCache = ignoreCache, scriptToEvaluateOnLoad = scriptToEvaluateOnLoad))
}, Page.removeScriptToEvaluateOnLoad = function(identifier = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.removeScriptToEvaluateOnLoad", list(identifier = identifier))
}, Page.removeScriptToEvaluateOnNewDocument = function(identifier = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.removeScriptToEvaluateOnNewDocument", list(identifier = identifier))
}, Page.screencastFrameAck = function(sessionId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.screencastFrameAck", list(sessionId = sessionId))
}, Page.searchInResource = function(frameId = NULL, url = NULL, query = NULL, caseSensitive = NULL, isRegex = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.searchInResource", list(frameId = frameId, url = url, query = query, caseSensitive = caseSensitive, isRegex = isRegex))
}, Page.setAdBlockingEnabled = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setAdBlockingEnabled", list(enabled = enabled))
}, Page.setBypassCSP = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setBypassCSP", list(enabled = enabled))
}, Page.getPermissionsPolicyState = function(frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.getPermissionsPolicyState", list(frameId = frameId))
}, Page.getOriginTrials = function(frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.getOriginTrials", list(frameId = frameId))
}, Page.setDeviceMetricsOverride = function(width = NULL, height = NULL, deviceScaleFactor = NULL, mobile = NULL, scale = NULL, screenWidth = NULL, screenHeight = NULL, positionX = NULL, positionY = NULL, dontSetVisibleSize = NULL, screenOrientation = NULL, viewport = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setDeviceMetricsOverride", list(width = width, height = height, deviceScaleFactor = deviceScaleFactor, mobile = mobile, scale = scale, screenWidth = screenWidth, screenHeight = screenHeight, positionX = positionX, positionY = positionY, dontSetVisibleSize = dontSetVisibleSize, screenOrientation = screenOrientation, viewport = viewport))
}, Page.setDeviceOrientationOverride = function(alpha = NULL, beta = NULL, gamma = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setDeviceOrientationOverride", list(alpha = alpha, beta = beta, gamma = gamma))
}, Page.setFontFamilies = function(fontFamilies = NULL, forScripts = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setFontFamilies", list(fontFamilies = fontFamilies, forScripts = forScripts))
}, Page.setFontSizes = function(fontSizes = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setFontSizes", list(fontSizes = fontSizes))
}, Page.setDocumentContent = function(frameId = NULL, html = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setDocumentContent", list(frameId = frameId, html = html))
}, Page.setDownloadBehavior = function(behavior = NULL, downloadPath = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setDownloadBehavior", list(behavior = behavior, downloadPath = downloadPath))
}, Page.setGeolocationOverride = function(latitude = NULL, longitude = NULL, accuracy = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setGeolocationOverride", list(latitude = latitude, longitude = longitude, accuracy = accuracy))
}, Page.setLifecycleEventsEnabled = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setLifecycleEventsEnabled", list(enabled = enabled))
}, Page.setTouchEmulationEnabled = function(enabled = NULL, configuration = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setTouchEmulationEnabled", list(enabled = enabled, configuration = configuration))
}, Page.startScreencast = function(format = NULL, quality = NULL, maxWidth = NULL, maxHeight = NULL, everyNthFrame = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.startScreencast", list(format = format, quality = quality, maxWidth = maxWidth, maxHeight = maxHeight, everyNthFrame = everyNthFrame))
}, Page.stopLoading = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.stopLoading", list())
}, Page.crash = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.crash", list())
}, Page.close = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.close", list())
}, Page.setWebLifecycleState = function(state = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setWebLifecycleState", list(state = state))
}, Page.stopScreencast = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.stopScreencast", list())
}, Page.produceCompilationCache = function(scripts = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.produceCompilationCache", list(scripts = scripts))
}, Page.addCompilationCache = function(url = NULL, data = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.addCompilationCache", list(url = url, data = data))
}, Page.clearCompilationCache = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.clearCompilationCache", list())
}, Page.setSPCTransactionMode = function(mode = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setSPCTransactionMode", list(mode = mode))
}, Page.setRPHRegistrationMode = function(mode = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setRPHRegistrationMode", list(mode = mode))
}, Page.generateTestReport = function(message = NULL, group = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.generateTestReport", list(message = message, group = group))
}, Page.waitForDebugger = function() {
    .rs.automation.sendSynchronousRequest(socket, "Page.waitForDebugger", list())
}, Page.setInterceptFileChooserDialog = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Page.setInterceptFileChooserDialog", list(enabled = enabled))
}, Performance.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Performance.disable", list())
}, Performance.enable = function(timeDomain = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Performance.enable", list(timeDomain = timeDomain))
}, Performance.setTimeDomain = function(timeDomain = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Performance.setTimeDomain", list(timeDomain = timeDomain))
}, Performance.getMetrics = function() {
    .rs.automation.sendSynchronousRequest(socket, "Performance.getMetrics", list())
}, PerformanceTimeline.enable = function(eventTypes = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "PerformanceTimeline.enable", list(eventTypes = eventTypes))
}, Security.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Security.disable", list())
}, Security.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Security.enable", list())
}, Security.setIgnoreCertificateErrors = function(ignore = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Security.setIgnoreCertificateErrors", list(ignore = ignore))
}, Security.handleCertificateError = function(eventId = NULL, action = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Security.handleCertificateError", list(eventId = eventId, action = action))
}, Security.setOverrideCertificateErrors = function(override = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Security.setOverrideCertificateErrors", list(override = override))
}, ServiceWorker.deliverPushMessage = function(origin = NULL, registrationId = NULL, data = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.deliverPushMessage", list(origin = origin, registrationId = registrationId, data = data))
}, ServiceWorker.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.disable", list())
}, ServiceWorker.dispatchSyncEvent = function(origin = NULL, registrationId = NULL, tag = NULL, lastChance = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.dispatchSyncEvent", list(origin = origin, registrationId = registrationId, tag = tag, lastChance = lastChance))
}, ServiceWorker.dispatchPeriodicSyncEvent = function(origin = NULL, registrationId = NULL, tag = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.dispatchPeriodicSyncEvent", list(origin = origin, registrationId = registrationId, tag = tag))
}, ServiceWorker.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.enable", list())
}, ServiceWorker.inspectWorker = function(versionId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.inspectWorker", list(versionId = versionId))
}, ServiceWorker.setForceUpdateOnPageLoad = function(forceUpdateOnPageLoad = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.setForceUpdateOnPageLoad", list(forceUpdateOnPageLoad = forceUpdateOnPageLoad))
}, ServiceWorker.skipWaiting = function(scopeURL = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.skipWaiting", list(scopeURL = scopeURL))
}, ServiceWorker.startWorker = function(scopeURL = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.startWorker", list(scopeURL = scopeURL))
}, ServiceWorker.stopAllWorkers = function() {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.stopAllWorkers", list())
}, ServiceWorker.stopWorker = function(versionId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.stopWorker", list(versionId = versionId))
}, ServiceWorker.unregister = function(scopeURL = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.unregister", list(scopeURL = scopeURL))
}, ServiceWorker.updateRegistration = function(scopeURL = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "ServiceWorker.updateRegistration", list(scopeURL = scopeURL))
}, Storage.getStorageKeyForFrame = function(frameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.getStorageKeyForFrame", list(frameId = frameId))
}, Storage.clearDataForOrigin = function(origin = NULL, storageTypes = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.clearDataForOrigin", list(origin = origin, storageTypes = storageTypes))
}, Storage.clearDataForStorageKey = function(storageKey = NULL, storageTypes = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.clearDataForStorageKey", list(storageKey = storageKey, storageTypes = storageTypes))
}, Storage.getCookies = function(browserContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.getCookies", list(browserContextId = browserContextId))
}, Storage.setCookies = function(cookies = NULL, browserContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.setCookies", list(cookies = cookies, browserContextId = browserContextId))
}, Storage.clearCookies = function(browserContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.clearCookies", list(browserContextId = browserContextId))
}, Storage.getUsageAndQuota = function(origin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.getUsageAndQuota", list(origin = origin))
}, Storage.overrideQuotaForOrigin = function(origin = NULL, quotaSize = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.overrideQuotaForOrigin", list(origin = origin, quotaSize = quotaSize))
}, Storage.trackCacheStorageForOrigin = function(origin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.trackCacheStorageForOrigin", list(origin = origin))
}, Storage.trackCacheStorageForStorageKey = function(storageKey = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.trackCacheStorageForStorageKey", list(storageKey = storageKey))
}, Storage.trackIndexedDBForOrigin = function(origin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.trackIndexedDBForOrigin", list(origin = origin))
}, Storage.trackIndexedDBForStorageKey = function(storageKey = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.trackIndexedDBForStorageKey", list(storageKey = storageKey))
}, Storage.untrackCacheStorageForOrigin = function(origin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.untrackCacheStorageForOrigin", list(origin = origin))
}, Storage.untrackCacheStorageForStorageKey = function(storageKey = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.untrackCacheStorageForStorageKey", list(storageKey = storageKey))
}, Storage.untrackIndexedDBForOrigin = function(origin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.untrackIndexedDBForOrigin", list(origin = origin))
}, Storage.untrackIndexedDBForStorageKey = function(storageKey = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.untrackIndexedDBForStorageKey", list(storageKey = storageKey))
}, Storage.getTrustTokens = function() {
    .rs.automation.sendSynchronousRequest(socket, "Storage.getTrustTokens", list())
}, Storage.clearTrustTokens = function(issuerOrigin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.clearTrustTokens", list(issuerOrigin = issuerOrigin))
}, Storage.getInterestGroupDetails = function(ownerOrigin = NULL, name = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.getInterestGroupDetails", list(ownerOrigin = ownerOrigin, name = name))
}, Storage.setInterestGroupTracking = function(enable = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.setInterestGroupTracking", list(enable = enable))
}, Storage.getSharedStorageMetadata = function(ownerOrigin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.getSharedStorageMetadata", list(ownerOrigin = ownerOrigin))
}, Storage.getSharedStorageEntries = function(ownerOrigin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.getSharedStorageEntries", list(ownerOrigin = ownerOrigin))
}, Storage.setSharedStorageEntry = function(ownerOrigin = NULL, key = NULL, value = NULL, ignoreIfPresent = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.setSharedStorageEntry", list(ownerOrigin = ownerOrigin, key = key, value = value, ignoreIfPresent = ignoreIfPresent))
}, Storage.deleteSharedStorageEntry = function(ownerOrigin = NULL, key = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.deleteSharedStorageEntry", list(ownerOrigin = ownerOrigin, key = key))
}, Storage.clearSharedStorageEntries = function(ownerOrigin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.clearSharedStorageEntries", list(ownerOrigin = ownerOrigin))
}, Storage.resetSharedStorageBudget = function(ownerOrigin = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.resetSharedStorageBudget", list(ownerOrigin = ownerOrigin))
}, Storage.setSharedStorageTracking = function(enable = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Storage.setSharedStorageTracking", list(enable = enable))
}, SystemInfo.getInfo = function() {
    .rs.automation.sendSynchronousRequest(socket, "SystemInfo.getInfo", list())
}, SystemInfo.getFeatureState = function(featureState = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "SystemInfo.getFeatureState", list(featureState = featureState))
}, SystemInfo.getProcessInfo = function() {
    .rs.automation.sendSynchronousRequest(socket, "SystemInfo.getProcessInfo", list())
}, Target.activateTarget = function(targetId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.activateTarget", list(targetId = targetId))
}, Target.attachToTarget = function(targetId = NULL, flatten = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.attachToTarget", list(targetId = targetId, flatten = flatten))
}, Target.attachToBrowserTarget = function() {
    .rs.automation.sendSynchronousRequest(socket, "Target.attachToBrowserTarget", list())
}, Target.closeTarget = function(targetId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.closeTarget", list(targetId = targetId))
}, Target.exposeDevToolsProtocol = function(targetId = NULL, bindingName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.exposeDevToolsProtocol", list(targetId = targetId, bindingName = bindingName))
}, Target.createBrowserContext = function(disposeOnDetach = NULL, proxyServer = NULL, proxyBypassList = NULL, originsWithUniversalNetworkAccess = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.createBrowserContext", list(disposeOnDetach = disposeOnDetach, proxyServer = proxyServer, proxyBypassList = proxyBypassList, originsWithUniversalNetworkAccess = originsWithUniversalNetworkAccess))
}, Target.getBrowserContexts = function() {
    .rs.automation.sendSynchronousRequest(socket, "Target.getBrowserContexts", list())
}, Target.createTarget = function(url = NULL, width = NULL, height = NULL, browserContextId = NULL, enableBeginFrameControl = NULL, newWindow = NULL, background = NULL, forTab = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.createTarget", list(url = url, width = width, height = height, browserContextId = browserContextId, enableBeginFrameControl = enableBeginFrameControl, newWindow = newWindow, background = background, forTab = forTab))
}, Target.detachFromTarget = function(sessionId = NULL, targetId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.detachFromTarget", list(sessionId = sessionId, targetId = targetId))
}, Target.disposeBrowserContext = function(browserContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.disposeBrowserContext", list(browserContextId = browserContextId))
}, Target.getTargetInfo = function(targetId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.getTargetInfo", list(targetId = targetId))
}, Target.getTargets = function(filter = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.getTargets", list(filter = filter))
}, Target.sendMessageToTarget = function(message = NULL, sessionId = NULL, targetId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.sendMessageToTarget", list(message = message, sessionId = sessionId, targetId = targetId))
}, Target.setAutoAttach = function(autoAttach = NULL, waitForDebuggerOnStart = NULL, flatten = NULL, filter = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.setAutoAttach", list(autoAttach = autoAttach, waitForDebuggerOnStart = waitForDebuggerOnStart, flatten = flatten, filter = filter))
}, Target.autoAttachRelated = function(targetId = NULL, waitForDebuggerOnStart = NULL, filter = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.autoAttachRelated", list(targetId = targetId, waitForDebuggerOnStart = waitForDebuggerOnStart, filter = filter))
}, Target.setDiscoverTargets = function(discover = NULL, filter = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.setDiscoverTargets", list(discover = discover, filter = filter))
}, Target.setRemoteLocations = function(locations = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Target.setRemoteLocations", list(locations = locations))
}, Tethering.bind = function(port = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Tethering.bind", list(port = port))
}, Tethering.unbind = function(port = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Tethering.unbind", list(port = port))
}, Tracing.end = function() {
    .rs.automation.sendSynchronousRequest(socket, "Tracing.end", list())
}, Tracing.getCategories = function() {
    .rs.automation.sendSynchronousRequest(socket, "Tracing.getCategories", list())
}, Tracing.recordClockSyncMarker = function(syncId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Tracing.recordClockSyncMarker", list(syncId = syncId))
}, Tracing.requestMemoryDump = function(deterministic = NULL, levelOfDetail = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Tracing.requestMemoryDump", list(deterministic = deterministic, levelOfDetail = levelOfDetail))
}, Tracing.start = function(categories = NULL, options = NULL, bufferUsageReportingInterval = NULL, transferMode = NULL, streamFormat = NULL, streamCompression = NULL, traceConfig = NULL, perfettoConfig = NULL, tracingBackend = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Tracing.start", list(categories = categories, options = options, bufferUsageReportingInterval = bufferUsageReportingInterval, transferMode = transferMode, streamFormat = streamFormat, streamCompression = streamCompression, traceConfig = traceConfig, perfettoConfig = perfettoConfig, tracingBackend = tracingBackend))
}, Fetch.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.disable", list())
}, Fetch.enable = function(patterns = NULL, handleAuthRequests = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.enable", list(patterns = patterns, handleAuthRequests = handleAuthRequests))
}, Fetch.failRequest = function(requestId = NULL, errorReason = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.failRequest", list(requestId = requestId, errorReason = errorReason))
}, Fetch.fulfillRequest = function(requestId = NULL, responseCode = NULL, responseHeaders = NULL, binaryResponseHeaders = NULL, body = NULL, responsePhrase = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.fulfillRequest", list(requestId = requestId, responseCode = responseCode, responseHeaders = responseHeaders, binaryResponseHeaders = binaryResponseHeaders, body = body, responsePhrase = responsePhrase))
}, Fetch.continueRequest = function(requestId = NULL, url = NULL, method = NULL, postData = NULL, headers = NULL, interceptResponse = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.continueRequest", list(requestId = requestId, url = url, method = method, postData = postData, headers = headers, interceptResponse = interceptResponse))
}, Fetch.continueWithAuth = function(requestId = NULL, authChallengeResponse = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.continueWithAuth", list(requestId = requestId, authChallengeResponse = authChallengeResponse))
}, Fetch.continueResponse = function(requestId = NULL, responseCode = NULL, responsePhrase = NULL, responseHeaders = NULL, binaryResponseHeaders = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.continueResponse", list(requestId = requestId, responseCode = responseCode, responsePhrase = responsePhrase, responseHeaders = responseHeaders, binaryResponseHeaders = binaryResponseHeaders))
}, Fetch.getResponseBody = function(requestId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.getResponseBody", list(requestId = requestId))
}, Fetch.takeResponseBodyAsStream = function(requestId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Fetch.takeResponseBodyAsStream", list(requestId = requestId))
}, WebAudio.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "WebAudio.enable", list())
}, WebAudio.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "WebAudio.disable", list())
}, WebAudio.getRealtimeData = function(contextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAudio.getRealtimeData", list(contextId = contextId))
}, WebAuthn.enable = function(enableUI = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.enable", list(enableUI = enableUI))
}, WebAuthn.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.disable", list())
}, WebAuthn.addVirtualAuthenticator = function(options = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.addVirtualAuthenticator", list(options = options))
}, WebAuthn.setResponseOverrideBits = function(authenticatorId = NULL, isBogusSignature = NULL, isBadUV = NULL, isBadUP = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.setResponseOverrideBits", list(authenticatorId = authenticatorId, isBogusSignature = isBogusSignature, isBadUV = isBadUV, isBadUP = isBadUP))
}, WebAuthn.removeVirtualAuthenticator = function(authenticatorId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.removeVirtualAuthenticator", list(authenticatorId = authenticatorId))
}, WebAuthn.addCredential = function(authenticatorId = NULL, credential = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.addCredential", list(authenticatorId = authenticatorId, credential = credential))
}, WebAuthn.getCredential = function(authenticatorId = NULL, credentialId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.getCredential", list(authenticatorId = authenticatorId, credentialId = credentialId))
}, WebAuthn.getCredentials = function(authenticatorId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.getCredentials", list(authenticatorId = authenticatorId))
}, WebAuthn.removeCredential = function(authenticatorId = NULL, credentialId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.removeCredential", list(authenticatorId = authenticatorId, credentialId = credentialId))
}, WebAuthn.clearCredentials = function(authenticatorId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.clearCredentials", list(authenticatorId = authenticatorId))
}, WebAuthn.setUserVerified = function(authenticatorId = NULL, isUserVerified = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.setUserVerified", list(authenticatorId = authenticatorId, isUserVerified = isUserVerified))
}, WebAuthn.setAutomaticPresenceSimulation = function(authenticatorId = NULL, enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "WebAuthn.setAutomaticPresenceSimulation", list(authenticatorId = authenticatorId, enabled = enabled))
}, Media.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Media.enable", list())
}, Media.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Media.disable", list())
}, DeviceAccess.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "DeviceAccess.enable", list())
}, DeviceAccess.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "DeviceAccess.disable", list())
}, DeviceAccess.selectPrompt = function(id = NULL, deviceId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DeviceAccess.selectPrompt", list(id = id, deviceId = deviceId))
}, DeviceAccess.cancelPrompt = function(id = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "DeviceAccess.cancelPrompt", list(id = id))
}, Preload.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Preload.enable", list())
}, Preload.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Preload.disable", list())
}, Console.clearMessages = function() {
    .rs.automation.sendSynchronousRequest(socket, "Console.clearMessages", list())
}, Console.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Console.disable", list())
}, Console.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Console.enable", list())
}, Debugger.continueToLocation = function(location = NULL, targetCallFrames = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.continueToLocation", list(location = location, targetCallFrames = targetCallFrames))
}, Debugger.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.disable", list())
}, Debugger.enable = function(maxScriptsCacheSize = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.enable", list(maxScriptsCacheSize = maxScriptsCacheSize))
}, Debugger.evaluateOnCallFrame = function(callFrameId = NULL, expression = NULL, objectGroup = NULL, includeCommandLineAPI = NULL, silent = NULL, returnByValue = NULL, generatePreview = NULL, throwOnSideEffect = NULL, timeout = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.evaluateOnCallFrame", list(callFrameId = callFrameId, expression = expression, objectGroup = objectGroup, includeCommandLineAPI = includeCommandLineAPI, silent = silent, returnByValue = returnByValue, generatePreview = generatePreview, throwOnSideEffect = throwOnSideEffect, timeout = timeout))
}, Debugger.getPossibleBreakpoints = function(start = NULL, end = NULL, restrictToFunction = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.getPossibleBreakpoints", list(start = start, end = end, restrictToFunction = restrictToFunction))
}, Debugger.getScriptSource = function(scriptId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.getScriptSource", list(scriptId = scriptId))
}, Debugger.disassembleWasmModule = function(scriptId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.disassembleWasmModule", list(scriptId = scriptId))
}, Debugger.nextWasmDisassemblyChunk = function(streamId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.nextWasmDisassemblyChunk", list(streamId = streamId))
}, Debugger.getWasmBytecode = function(scriptId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.getWasmBytecode", list(scriptId = scriptId))
}, Debugger.getStackTrace = function(stackTraceId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.getStackTrace", list(stackTraceId = stackTraceId))
}, Debugger.pause = function() {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.pause", list())
}, Debugger.pauseOnAsyncCall = function(parentStackTraceId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.pauseOnAsyncCall", list(parentStackTraceId = parentStackTraceId))
}, Debugger.removeBreakpoint = function(breakpointId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.removeBreakpoint", list(breakpointId = breakpointId))
}, Debugger.restartFrame = function(callFrameId = NULL, mode = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.restartFrame", list(callFrameId = callFrameId, mode = mode))
}, Debugger.resume = function(terminateOnResume = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.resume", list(terminateOnResume = terminateOnResume))
}, Debugger.searchInContent = function(scriptId = NULL, query = NULL, caseSensitive = NULL, isRegex = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.searchInContent", list(scriptId = scriptId, query = query, caseSensitive = caseSensitive, isRegex = isRegex))
}, Debugger.setAsyncCallStackDepth = function(maxDepth = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setAsyncCallStackDepth", list(maxDepth = maxDepth))
}, Debugger.setBlackboxPatterns = function(patterns = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setBlackboxPatterns", list(patterns = patterns))
}, Debugger.setBlackboxedRanges = function(scriptId = NULL, positions = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setBlackboxedRanges", list(scriptId = scriptId, positions = positions))
}, Debugger.setBreakpoint = function(location = NULL, condition = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setBreakpoint", list(location = location, condition = condition))
}, Debugger.setInstrumentationBreakpoint = function(instrumentation = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setInstrumentationBreakpoint", list(instrumentation = instrumentation))
}, Debugger.setBreakpointByUrl = function(lineNumber = NULL, url = NULL, urlRegex = NULL, scriptHash = NULL, columnNumber = NULL, condition = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setBreakpointByUrl", list(lineNumber = lineNumber, url = url, urlRegex = urlRegex, scriptHash = scriptHash, columnNumber = columnNumber, condition = condition))
}, Debugger.setBreakpointOnFunctionCall = function(objectId = NULL, condition = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setBreakpointOnFunctionCall", list(objectId = objectId, condition = condition))
}, Debugger.setBreakpointsActive = function(active = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setBreakpointsActive", list(active = active))
}, Debugger.setPauseOnExceptions = function(state = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setPauseOnExceptions", list(state = state))
}, Debugger.setReturnValue = function(newValue = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setReturnValue", list(newValue = newValue))
}, Debugger.setScriptSource = function(scriptId = NULL, scriptSource = NULL, dryRun = NULL, allowTopFrameEditing = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setScriptSource", list(scriptId = scriptId, scriptSource = scriptSource, dryRun = dryRun, allowTopFrameEditing = allowTopFrameEditing))
}, Debugger.setSkipAllPauses = function(skip = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setSkipAllPauses", list(skip = skip))
}, Debugger.setVariableValue = function(scopeNumber = NULL, variableName = NULL, newValue = NULL, callFrameId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.setVariableValue", list(scopeNumber = scopeNumber, variableName = variableName, newValue = newValue, callFrameId = callFrameId))
}, Debugger.stepInto = function(breakOnAsyncCall = NULL, skipList = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.stepInto", list(breakOnAsyncCall = breakOnAsyncCall, skipList = skipList))
}, Debugger.stepOut = function() {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.stepOut", list())
}, Debugger.stepOver = function(skipList = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Debugger.stepOver", list(skipList = skipList))
}, HeapProfiler.addInspectedHeapObject = function(heapObjectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.addInspectedHeapObject", list(heapObjectId = heapObjectId))
}, HeapProfiler.collectGarbage = function() {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.collectGarbage", list())
}, HeapProfiler.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.disable", list())
}, HeapProfiler.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.enable", list())
}, HeapProfiler.getHeapObjectId = function(objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.getHeapObjectId", list(objectId = objectId))
}, HeapProfiler.getObjectByHeapObjectId = function(objectId = NULL, objectGroup = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.getObjectByHeapObjectId", list(objectId = objectId, objectGroup = objectGroup))
}, HeapProfiler.getSamplingProfile = function() {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.getSamplingProfile", list())
}, HeapProfiler.startSampling = function(samplingInterval = NULL, includeObjectsCollectedByMajorGC = NULL, includeObjectsCollectedByMinorGC = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.startSampling", list(samplingInterval = samplingInterval, includeObjectsCollectedByMajorGC = includeObjectsCollectedByMajorGC, includeObjectsCollectedByMinorGC = includeObjectsCollectedByMinorGC))
}, HeapProfiler.startTrackingHeapObjects = function(trackAllocations = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.startTrackingHeapObjects", list(trackAllocations = trackAllocations))
}, HeapProfiler.stopSampling = function() {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.stopSampling", list())
}, HeapProfiler.stopTrackingHeapObjects = function(reportProgress = NULL, treatGlobalObjectsAsRoots = NULL, captureNumericValue = NULL, exposeInternals = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.stopTrackingHeapObjects", list(reportProgress = reportProgress, treatGlobalObjectsAsRoots = treatGlobalObjectsAsRoots, captureNumericValue = captureNumericValue, exposeInternals = exposeInternals))
}, HeapProfiler.takeHeapSnapshot = function(reportProgress = NULL, treatGlobalObjectsAsRoots = NULL, captureNumericValue = NULL, exposeInternals = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "HeapProfiler.takeHeapSnapshot", list(reportProgress = reportProgress, treatGlobalObjectsAsRoots = treatGlobalObjectsAsRoots, captureNumericValue = captureNumericValue, exposeInternals = exposeInternals))
}, Profiler.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.disable", list())
}, Profiler.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.enable", list())
}, Profiler.getBestEffortCoverage = function() {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.getBestEffortCoverage", list())
}, Profiler.setSamplingInterval = function(interval = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.setSamplingInterval", list(interval = interval))
}, Profiler.start = function() {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.start", list())
}, Profiler.startPreciseCoverage = function(callCount = NULL, detailed = NULL, allowTriggeredUpdates = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.startPreciseCoverage", list(callCount = callCount, detailed = detailed, allowTriggeredUpdates = allowTriggeredUpdates))
}, Profiler.stop = function() {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.stop", list())
}, Profiler.stopPreciseCoverage = function() {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.stopPreciseCoverage", list())
}, Profiler.takePreciseCoverage = function() {
    .rs.automation.sendSynchronousRequest(socket, "Profiler.takePreciseCoverage", list())
}, Runtime.awaitPromise = function(promiseObjectId = NULL, returnByValue = NULL, generatePreview = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.awaitPromise", list(promiseObjectId = promiseObjectId, returnByValue = returnByValue, generatePreview = generatePreview))
}, Runtime.callFunctionOn = function(functionDeclaration = NULL, objectId = NULL, arguments = NULL, silent = NULL, returnByValue = NULL, generatePreview = NULL, userGesture = NULL, awaitPromise = NULL, executionContextId = NULL, objectGroup = NULL, throwOnSideEffect = NULL, uniqueContextId = NULL, generateWebDriverValue = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.callFunctionOn", list(functionDeclaration = functionDeclaration, objectId = objectId, arguments = arguments, silent = silent, returnByValue = returnByValue, generatePreview = generatePreview, userGesture = userGesture, awaitPromise = awaitPromise, executionContextId = executionContextId, objectGroup = objectGroup, throwOnSideEffect = throwOnSideEffect, uniqueContextId = uniqueContextId, generateWebDriverValue = generateWebDriverValue))
}, Runtime.compileScript = function(expression = NULL, sourceURL = NULL, persistScript = NULL, executionContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.compileScript", list(expression = expression, sourceURL = sourceURL, persistScript = persistScript, executionContextId = executionContextId))
}, Runtime.disable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.disable", list())
}, Runtime.discardConsoleEntries = function() {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.discardConsoleEntries", list())
}, Runtime.enable = function() {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.enable", list())
}, Runtime.evaluate = function(expression = NULL, objectGroup = NULL, includeCommandLineAPI = NULL, silent = NULL, contextId = NULL, returnByValue = NULL, generatePreview = NULL, userGesture = NULL, awaitPromise = NULL, throwOnSideEffect = NULL, timeout = NULL, disableBreaks = NULL, replMode = NULL, allowUnsafeEvalBlockedByCSP = NULL, uniqueContextId = NULL, generateWebDriverValue = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.evaluate", list(expression = expression, objectGroup = objectGroup, includeCommandLineAPI = includeCommandLineAPI, silent = silent, contextId = contextId, returnByValue = returnByValue, generatePreview = generatePreview, userGesture = userGesture, awaitPromise = awaitPromise, throwOnSideEffect = throwOnSideEffect, timeout = timeout, disableBreaks = disableBreaks, replMode = replMode, allowUnsafeEvalBlockedByCSP = allowUnsafeEvalBlockedByCSP, 
        uniqueContextId = uniqueContextId, generateWebDriverValue = generateWebDriverValue))
}, Runtime.getIsolateId = function() {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.getIsolateId", list())
}, Runtime.getHeapUsage = function() {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.getHeapUsage", list())
}, Runtime.getProperties = function(objectId = NULL, ownProperties = NULL, accessorPropertiesOnly = NULL, generatePreview = NULL, nonIndexedPropertiesOnly = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.getProperties", list(objectId = objectId, ownProperties = ownProperties, accessorPropertiesOnly = accessorPropertiesOnly, generatePreview = generatePreview, nonIndexedPropertiesOnly = nonIndexedPropertiesOnly))
}, Runtime.globalLexicalScopeNames = function(executionContextId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.globalLexicalScopeNames", list(executionContextId = executionContextId))
}, Runtime.queryObjects = function(prototypeObjectId = NULL, objectGroup = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.queryObjects", list(prototypeObjectId = prototypeObjectId, objectGroup = objectGroup))
}, Runtime.releaseObject = function(objectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.releaseObject", list(objectId = objectId))
}, Runtime.releaseObjectGroup = function(objectGroup = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.releaseObjectGroup", list(objectGroup = objectGroup))
}, Runtime.runIfWaitingForDebugger = function() {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.runIfWaitingForDebugger", list())
}, Runtime.runScript = function(scriptId = NULL, executionContextId = NULL, objectGroup = NULL, silent = NULL, includeCommandLineAPI = NULL, returnByValue = NULL, generatePreview = NULL, awaitPromise = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.runScript", list(scriptId = scriptId, executionContextId = executionContextId, objectGroup = objectGroup, silent = silent, includeCommandLineAPI = includeCommandLineAPI, returnByValue = returnByValue, generatePreview = generatePreview, awaitPromise = awaitPromise))
}, Runtime.setAsyncCallStackDepth = function(maxDepth = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.setAsyncCallStackDepth", list(maxDepth = maxDepth))
}, Runtime.setCustomObjectFormatterEnabled = function(enabled = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.setCustomObjectFormatterEnabled", list(enabled = enabled))
}, Runtime.setMaxCallStackSizeToCapture = function(size = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.setMaxCallStackSizeToCapture", list(size = size))
}, Runtime.terminateExecution = function() {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.terminateExecution", list())
}, Runtime.addBinding = function(name = NULL, executionContextId = NULL, executionContextName = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.addBinding", list(name = name, executionContextId = executionContextId, executionContextName = executionContextName))
}, Runtime.removeBinding = function(name = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.removeBinding", list(name = name))
}, Runtime.getExceptionDetails = function(errorObjectId = NULL) {
    .rs.automation.sendSynchronousRequest(socket, "Runtime.getExceptionDetails", list(errorObjectId = errorObjectId))
}, Schema.getDomains = function() {
    .rs.automation.sendSynchronousRequest(socket, "Schema.getDomains", list())
})
})
