// Copyright 2018-2022 the Deno authors. All rights reserved. MIT license.
import * as path from "../path/mod.ts";
import { ensureDir, ensureDirSync } from "./ensure_dir.ts";
/**
 * Ensures that the hard link exists.
 * If the directory structure does not exist, it is created.
 *
 * @param src the source file path. Directory hard links are not allowed.
 * @param dest the destination link path
 */ export async function ensureLink(src, dest) {
    await ensureDir(path.dirname(dest));
    await Deno.link(src, dest);
}
/**
 * Ensures that the hard link exists.
 * If the directory structure does not exist, it is created.
 *
 * @param src the source file path. Directory hard links are not allowed.
 * @param dest the destination link path
 */ export function ensureLinkSync(src, dest) {
    ensureDirSync(path.dirname(dest));
    Deno.linkSync(src, dest);
}
//# sourceMappingURL=data:application/json;base64,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