import * as v1 from "./v1.ts";
import * as v4 from "./v4.ts";
import * as v5 from "./v5.ts";
export const NIL_UUID = "00000000-0000-0000-0000-000000000000";
export function isNil(id) {
    return id === NIL_UUID;
}
export function validate(uuid) {
    return /^(?:[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}|00000000-0000-0000-0000-000000000000)$/i
        .test(uuid);
}
export function version(uuid) {
    if (!validate(uuid)) {
        throw TypeError("Invalid UUID");
    }
    return parseInt(uuid[14], 16);
}
export { v1, v4, v5 };
//# sourceMappingURL=data:application/json;base64,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