const decoder = new TextDecoder();
export class StringWriter {
    base;
    chunks = [];
    byteLength = 0;
    cache;
    constructor(base = "") {
        this.base = base;
        const c = new TextEncoder().encode(base);
        this.chunks.push(c);
        this.byteLength += c.byteLength;
    }
    write(p) {
        return Promise.resolve(this.writeSync(p));
    }
    writeSync(p) {
        this.chunks.push(p);
        this.byteLength += p.byteLength;
        this.cache = undefined;
        return p.byteLength;
    }
    toString() {
        if (this.cache) {
            return this.cache;
        }
        const buf = new Uint8Array(this.byteLength);
        let offs = 0;
        for (const chunk of this.chunks) {
            buf.set(chunk, offs);
            offs += chunk.byteLength;
        }
        this.cache = decoder.decode(buf);
        return this.cache;
    }
}
//# sourceMappingURL=data:application/json;base64,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