export function minOf(array, selector) {
    let minimumValue = undefined;
    for (const i of array) {
        const currentValue = selector(i);
        if (minimumValue === undefined || currentValue < minimumValue) {
            minimumValue = currentValue;
            continue;
        }
        if (Number.isNaN(currentValue)) {
            return currentValue;
        }
    }
    return minimumValue;
}
//# sourceMappingURL=data:application/json;base64,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