export var Status;
(function (Status) {
    Status[Status["Continue"] = 100] = "Continue";
    Status[Status["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    Status[Status["Processing"] = 102] = "Processing";
    Status[Status["EarlyHints"] = 103] = "EarlyHints";
    Status[Status["OK"] = 200] = "OK";
    Status[Status["Created"] = 201] = "Created";
    Status[Status["Accepted"] = 202] = "Accepted";
    Status[Status["NonAuthoritativeInfo"] = 203] = "NonAuthoritativeInfo";
    Status[Status["NoContent"] = 204] = "NoContent";
    Status[Status["ResetContent"] = 205] = "ResetContent";
    Status[Status["PartialContent"] = 206] = "PartialContent";
    Status[Status["MultiStatus"] = 207] = "MultiStatus";
    Status[Status["AlreadyReported"] = 208] = "AlreadyReported";
    Status[Status["IMUsed"] = 226] = "IMUsed";
    Status[Status["MultipleChoices"] = 300] = "MultipleChoices";
    Status[Status["MovedPermanently"] = 301] = "MovedPermanently";
    Status[Status["Found"] = 302] = "Found";
    Status[Status["SeeOther"] = 303] = "SeeOther";
    Status[Status["NotModified"] = 304] = "NotModified";
    Status[Status["UseProxy"] = 305] = "UseProxy";
    Status[Status["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    Status[Status["PermanentRedirect"] = 308] = "PermanentRedirect";
    Status[Status["BadRequest"] = 400] = "BadRequest";
    Status[Status["Unauthorized"] = 401] = "Unauthorized";
    Status[Status["PaymentRequired"] = 402] = "PaymentRequired";
    Status[Status["Forbidden"] = 403] = "Forbidden";
    Status[Status["NotFound"] = 404] = "NotFound";
    Status[Status["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    Status[Status["NotAcceptable"] = 406] = "NotAcceptable";
    Status[Status["ProxyAuthRequired"] = 407] = "ProxyAuthRequired";
    Status[Status["RequestTimeout"] = 408] = "RequestTimeout";
    Status[Status["Conflict"] = 409] = "Conflict";
    Status[Status["Gone"] = 410] = "Gone";
    Status[Status["LengthRequired"] = 411] = "LengthRequired";
    Status[Status["PreconditionFailed"] = 412] = "PreconditionFailed";
    Status[Status["RequestEntityTooLarge"] = 413] = "RequestEntityTooLarge";
    Status[Status["RequestURITooLong"] = 414] = "RequestURITooLong";
    Status[Status["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    Status[Status["RequestedRangeNotSatisfiable"] = 416] = "RequestedRangeNotSatisfiable";
    Status[Status["ExpectationFailed"] = 417] = "ExpectationFailed";
    Status[Status["Teapot"] = 418] = "Teapot";
    Status[Status["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    Status[Status["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    Status[Status["Locked"] = 423] = "Locked";
    Status[Status["FailedDependency"] = 424] = "FailedDependency";
    Status[Status["TooEarly"] = 425] = "TooEarly";
    Status[Status["UpgradeRequired"] = 426] = "UpgradeRequired";
    Status[Status["PreconditionRequired"] = 428] = "PreconditionRequired";
    Status[Status["TooManyRequests"] = 429] = "TooManyRequests";
    Status[Status["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    Status[Status["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    Status[Status["InternalServerError"] = 500] = "InternalServerError";
    Status[Status["NotImplemented"] = 501] = "NotImplemented";
    Status[Status["BadGateway"] = 502] = "BadGateway";
    Status[Status["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    Status[Status["GatewayTimeout"] = 504] = "GatewayTimeout";
    Status[Status["HTTPVersionNotSupported"] = 505] = "HTTPVersionNotSupported";
    Status[Status["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    Status[Status["InsufficientStorage"] = 507] = "InsufficientStorage";
    Status[Status["LoopDetected"] = 508] = "LoopDetected";
    Status[Status["NotExtended"] = 510] = "NotExtended";
    Status[Status["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(Status || (Status = {}));
export const STATUS_TEXT = new Map([
    [Status.Continue, "Continue"],
    [Status.SwitchingProtocols, "Switching Protocols"],
    [Status.Processing, "Processing"],
    [Status.EarlyHints, "Early Hints"],
    [Status.OK, "OK"],
    [Status.Created, "Created"],
    [Status.Accepted, "Accepted"],
    [Status.NonAuthoritativeInfo, "Non-Authoritative Information"],
    [Status.NoContent, "No Content"],
    [Status.ResetContent, "Reset Content"],
    [Status.PartialContent, "Partial Content"],
    [Status.MultiStatus, "Multi-Status"],
    [Status.AlreadyReported, "Already Reported"],
    [Status.IMUsed, "IM Used"],
    [Status.MultipleChoices, "Multiple Choices"],
    [Status.MovedPermanently, "Moved Permanently"],
    [Status.Found, "Found"],
    [Status.SeeOther, "See Other"],
    [Status.NotModified, "Not Modified"],
    [Status.UseProxy, "Use Proxy"],
    [Status.TemporaryRedirect, "Temporary Redirect"],
    [Status.PermanentRedirect, "Permanent Redirect"],
    [Status.BadRequest, "Bad Request"],
    [Status.Unauthorized, "Unauthorized"],
    [Status.PaymentRequired, "Payment Required"],
    [Status.Forbidden, "Forbidden"],
    [Status.NotFound, "Not Found"],
    [Status.MethodNotAllowed, "Method Not Allowed"],
    [Status.NotAcceptable, "Not Acceptable"],
    [Status.ProxyAuthRequired, "Proxy Authentication Required"],
    [Status.RequestTimeout, "Request Timeout"],
    [Status.Conflict, "Conflict"],
    [Status.Gone, "Gone"],
    [Status.LengthRequired, "Length Required"],
    [Status.PreconditionFailed, "Precondition Failed"],
    [Status.RequestEntityTooLarge, "Request Entity Too Large"],
    [Status.RequestURITooLong, "Request URI Too Long"],
    [Status.UnsupportedMediaType, "Unsupported Media Type"],
    [Status.RequestedRangeNotSatisfiable, "Requested Range Not Satisfiable"],
    [Status.ExpectationFailed, "Expectation Failed"],
    [Status.Teapot, "I'm a teapot"],
    [Status.MisdirectedRequest, "Misdirected Request"],
    [Status.UnprocessableEntity, "Unprocessable Entity"],
    [Status.Locked, "Locked"],
    [Status.FailedDependency, "Failed Dependency"],
    [Status.TooEarly, "Too Early"],
    [Status.UpgradeRequired, "Upgrade Required"],
    [Status.PreconditionRequired, "Precondition Required"],
    [Status.TooManyRequests, "Too Many Requests"],
    [Status.RequestHeaderFieldsTooLarge, "Request Header Fields Too Large"],
    [Status.UnavailableForLegalReasons, "Unavailable For Legal Reasons"],
    [Status.InternalServerError, "Internal Server Error"],
    [Status.NotImplemented, "Not Implemented"],
    [Status.BadGateway, "Bad Gateway"],
    [Status.ServiceUnavailable, "Service Unavailable"],
    [Status.GatewayTimeout, "Gateway Timeout"],
    [Status.HTTPVersionNotSupported, "HTTP Version Not Supported"],
    [Status.VariantAlsoNegotiates, "Variant Also Negotiates"],
    [Status.InsufficientStorage, "Insufficient Storage"],
    [Status.LoopDetected, "Loop Detected"],
    [Status.NotExtended, "Not Extended"],
    [Status.NetworkAuthenticationRequired, "Network Authentication Required"],
]);
//# sourceMappingURL=data:application/json;base64,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