export var Status;
(function (Status) {
    Status[Status["Continue"] = 100] = "Continue";
    Status[Status["SwitchingProtocols"] = 101] = "SwitchingProtocols";
    Status[Status["Processing"] = 102] = "Processing";
    Status[Status["EarlyHints"] = 103] = "EarlyHints";
    Status[Status["OK"] = 200] = "OK";
    Status[Status["Created"] = 201] = "Created";
    Status[Status["Accepted"] = 202] = "Accepted";
    Status[Status["NonAuthoritativeInfo"] = 203] = "NonAuthoritativeInfo";
    Status[Status["NoContent"] = 204] = "NoContent";
    Status[Status["ResetContent"] = 205] = "ResetContent";
    Status[Status["PartialContent"] = 206] = "PartialContent";
    Status[Status["MultiStatus"] = 207] = "MultiStatus";
    Status[Status["AlreadyReported"] = 208] = "AlreadyReported";
    Status[Status["IMUsed"] = 226] = "IMUsed";
    Status[Status["MultipleChoices"] = 300] = "MultipleChoices";
    Status[Status["MovedPermanently"] = 301] = "MovedPermanently";
    Status[Status["Found"] = 302] = "Found";
    Status[Status["SeeOther"] = 303] = "SeeOther";
    Status[Status["NotModified"] = 304] = "NotModified";
    Status[Status["UseProxy"] = 305] = "UseProxy";
    Status[Status["TemporaryRedirect"] = 307] = "TemporaryRedirect";
    Status[Status["PermanentRedirect"] = 308] = "PermanentRedirect";
    Status[Status["BadRequest"] = 400] = "BadRequest";
    Status[Status["Unauthorized"] = 401] = "Unauthorized";
    Status[Status["PaymentRequired"] = 402] = "PaymentRequired";
    Status[Status["Forbidden"] = 403] = "Forbidden";
    Status[Status["NotFound"] = 404] = "NotFound";
    Status[Status["MethodNotAllowed"] = 405] = "MethodNotAllowed";
    Status[Status["NotAcceptable"] = 406] = "NotAcceptable";
    Status[Status["ProxyAuthRequired"] = 407] = "ProxyAuthRequired";
    Status[Status["RequestTimeout"] = 408] = "RequestTimeout";
    Status[Status["Conflict"] = 409] = "Conflict";
    Status[Status["Gone"] = 410] = "Gone";
    Status[Status["LengthRequired"] = 411] = "LengthRequired";
    Status[Status["PreconditionFailed"] = 412] = "PreconditionFailed";
    Status[Status["RequestEntityTooLarge"] = 413] = "RequestEntityTooLarge";
    Status[Status["RequestURITooLong"] = 414] = "RequestURITooLong";
    Status[Status["UnsupportedMediaType"] = 415] = "UnsupportedMediaType";
    Status[Status["RequestedRangeNotSatisfiable"] = 416] = "RequestedRangeNotSatisfiable";
    Status[Status["ExpectationFailed"] = 417] = "ExpectationFailed";
    Status[Status["Teapot"] = 418] = "Teapot";
    Status[Status["MisdirectedRequest"] = 421] = "MisdirectedRequest";
    Status[Status["UnprocessableEntity"] = 422] = "UnprocessableEntity";
    Status[Status["Locked"] = 423] = "Locked";
    Status[Status["FailedDependency"] = 424] = "FailedDependency";
    Status[Status["TooEarly"] = 425] = "TooEarly";
    Status[Status["UpgradeRequired"] = 426] = "UpgradeRequired";
    Status[Status["PreconditionRequired"] = 428] = "PreconditionRequired";
    Status[Status["TooManyRequests"] = 429] = "TooManyRequests";
    Status[Status["RequestHeaderFieldsTooLarge"] = 431] = "RequestHeaderFieldsTooLarge";
    Status[Status["UnavailableForLegalReasons"] = 451] = "UnavailableForLegalReasons";
    Status[Status["InternalServerError"] = 500] = "InternalServerError";
    Status[Status["NotImplemented"] = 501] = "NotImplemented";
    Status[Status["BadGateway"] = 502] = "BadGateway";
    Status[Status["ServiceUnavailable"] = 503] = "ServiceUnavailable";
    Status[Status["GatewayTimeout"] = 504] = "GatewayTimeout";
    Status[Status["HTTPVersionNotSupported"] = 505] = "HTTPVersionNotSupported";
    Status[Status["VariantAlsoNegotiates"] = 506] = "VariantAlsoNegotiates";
    Status[Status["InsufficientStorage"] = 507] = "InsufficientStorage";
    Status[Status["LoopDetected"] = 508] = "LoopDetected";
    Status[Status["NotExtended"] = 510] = "NotExtended";
    Status[Status["NetworkAuthenticationRequired"] = 511] = "NetworkAuthenticationRequired";
})(Status || (Status = {}));
export const STATUS_TEXT = {
    [Status.Accepted]: "Accepted",
    [Status.AlreadyReported]: "Already Reported",
    [Status.BadGateway]: "Bad Gateway",
    [Status.BadRequest]: "Bad Request",
    [Status.Conflict]: "Conflict",
    [Status.Continue]: "Continue",
    [Status.Created]: "Created",
    [Status.EarlyHints]: "Early Hints",
    [Status.ExpectationFailed]: "Expectation Failed",
    [Status.FailedDependency]: "Failed Dependency",
    [Status.Forbidden]: "Forbidden",
    [Status.Found]: "Found",
    [Status.GatewayTimeout]: "Gateway Timeout",
    [Status.Gone]: "Gone",
    [Status.HTTPVersionNotSupported]: "HTTP Version Not Supported",
    [Status.IMUsed]: "IM Used",
    [Status.InsufficientStorage]: "Insufficient Storage",
    [Status.InternalServerError]: "Internal Server Error",
    [Status.LengthRequired]: "Length Required",
    [Status.Locked]: "Locked",
    [Status.LoopDetected]: "Loop Detected",
    [Status.MethodNotAllowed]: "Method Not Allowed",
    [Status.MisdirectedRequest]: "Misdirected Request",
    [Status.MovedPermanently]: "Moved Permanently",
    [Status.MultiStatus]: "Multi Status",
    [Status.MultipleChoices]: "Multiple Choices",
    [Status.NetworkAuthenticationRequired]: "Network Authentication Required",
    [Status.NoContent]: "No Content",
    [Status.NonAuthoritativeInfo]: "Non Authoritative Info",
    [Status.NotAcceptable]: "Not Acceptable",
    [Status.NotExtended]: "Not Extended",
    [Status.NotFound]: "Not Found",
    [Status.NotImplemented]: "Not Implemented",
    [Status.NotModified]: "Not Modified",
    [Status.OK]: "OK",
    [Status.PartialContent]: "Partial Content",
    [Status.PaymentRequired]: "Payment Required",
    [Status.PermanentRedirect]: "Permanent Redirect",
    [Status.PreconditionFailed]: "Precondition Failed",
    [Status.PreconditionRequired]: "Precondition Required",
    [Status.Processing]: "Processing",
    [Status.ProxyAuthRequired]: "Proxy Auth Required",
    [Status.RequestEntityTooLarge]: "Request Entity Too Large",
    [Status.RequestHeaderFieldsTooLarge]: "Request Header Fields Too Large",
    [Status.RequestTimeout]: "Request Timeout",
    [Status.RequestURITooLong]: "Request URI Too Long",
    [Status.RequestedRangeNotSatisfiable]: "Requested Range Not Satisfiable",
    [Status.ResetContent]: "Reset Content",
    [Status.SeeOther]: "See Other",
    [Status.ServiceUnavailable]: "Service Unavailable",
    [Status.SwitchingProtocols]: "Switching Protocols",
    [Status.Teapot]: "I'm a teapot",
    [Status.TemporaryRedirect]: "Temporary Redirect",
    [Status.TooEarly]: "Too Early",
    [Status.TooManyRequests]: "Too Many Requests",
    [Status.Unauthorized]: "Unauthorized",
    [Status.UnavailableForLegalReasons]: "Unavailable For Legal Reasons",
    [Status.UnprocessableEntity]: "Unprocessable Entity",
    [Status.UnsupportedMediaType]: "Unsupported Media Type",
    [Status.UpgradeRequired]: "Upgrade Required",
    [Status.UseProxy]: "Use Proxy",
    [Status.VariantAlsoNegotiates]: "Variant Also Negotiates",
};
export function isInformationalStatus(status) {
    return status >= 100 && status < 200;
}
export function isSuccessfulStatus(status) {
    return status >= 200 && status < 300;
}
export function isRedirectStatus(status) {
    return status >= 300 && status < 400;
}
export function isClientErrorStatus(status) {
    return status >= 400 && status < 500;
}
export function isServerErrorStatus(status) {
    return status >= 500 && status < 600;
}
export function isErrorStatus(status) {
    return status >= 400 && status < 600;
}
//# sourceMappingURL=data:application/json;base64,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