import { descend } from "./_comparators.ts";
export * from "./_comparators.ts";
function swap(array, a, b) {
    const temp = array[a];
    array[a] = array[b];
    array[b] = temp;
}
export class BinaryHeap {
    compare;
    #data = [];
    constructor(compare = descend) {
        this.compare = compare;
    }
    static from(collection, options) {
        let result;
        let unmappedValues = [];
        if (collection instanceof BinaryHeap) {
            result = new BinaryHeap(options?.compare ?? collection.compare);
            if (options?.compare || options?.map) {
                unmappedValues = collection.#data;
            }
            else {
                result.#data = Array.from(collection.#data);
            }
        }
        else {
            result = options?.compare
                ? new BinaryHeap(options.compare)
                : new BinaryHeap();
            unmappedValues = collection;
        }
        const values = options?.map
            ? Array.from(unmappedValues, options.map, options.thisArg)
            : unmappedValues;
        result.push(...values);
        return result;
    }
    get length() {
        return this.#data.length;
    }
    peek() {
        return this.#data[0];
    }
    pop() {
        const size = this.#data.length - 1;
        swap(this.#data, 0, size);
        let parent = 0;
        let right = 2 * (parent + 1);
        let left = right - 1;
        while (left < size) {
            if (this.compare(this.#data[left], this.#data[parent]) < 0 &&
                (right === size ||
                    this.compare(this.#data[left], this.#data[right]) < 0)) {
                swap(this.#data, parent, left);
                parent = left;
            }
            else if (right < size && this.compare(this.#data[right], this.#data[parent]) < 0) {
                swap(this.#data, parent, right);
                parent = right;
            }
            else {
                break;
            }
            right = 2 * (parent + 1);
            left = right - 1;
        }
        return this.#data.pop();
    }
    push(...values) {
        for (const value of values) {
            let index = this.#data.length;
            let parent = Math.floor(index / 2);
            this.#data.push(value);
            while (index !== 0 && this.compare(this.#data[index], this.#data[parent]) < 0) {
                swap(this.#data, parent, index);
                index = parent;
                parent = Math.floor(index / 2);
            }
        }
        return this.#data.length;
    }
    clear() {
        this.#data = [];
    }
    isEmpty() {
        return this.#data.length === 0;
    }
    *drain() {
        while (!this.isEmpty()) {
            yield this.pop();
        }
    }
    *[Symbol.iterator]() {
        yield* this.drain();
    }
}
//# sourceMappingURL=data:application/json;base64,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