import { deferred } from "../async/deferred.ts";
export function mergeReadableStreams(...streams) {
    const resolvePromises = streams.map(() => deferred());
    return new ReadableStream({
        start(controller) {
            Promise.all(resolvePromises).then(() => {
                controller.close();
            });
            try {
                for (const [key, stream] of Object.entries(streams)) {
                    (async () => {
                        for await (const data of stream) {
                            controller.enqueue(data);
                        }
                        resolvePromises[+key].resolve();
                    })();
                }
            }
            catch (e) {
                controller.error(e);
            }
        },
    });
}
export function zipReadableStreams(...streams) {
    const readers = streams.map((s) => s.getReader());
    return new ReadableStream({
        async start(controller) {
            try {
                let resolved = 0;
                while (resolved != streams.length) {
                    for (const [key, reader] of Object.entries(readers)) {
                        const { value, done } = await reader.read();
                        if (!done) {
                            controller.enqueue(value);
                        }
                        else {
                            resolved++;
                            readers.splice(+key, 1);
                        }
                    }
                }
                controller.close();
            }
            catch (e) {
                controller.error(e);
            }
        },
    });
}
export function earlyZipReadableStreams(...streams) {
    const readers = streams.map((s) => s.getReader());
    return new ReadableStream({
        async start(controller) {
            try {
                loop: while (true) {
                    for (const reader of readers) {
                        const { value, done } = await reader.read();
                        if (!done) {
                            controller.enqueue(value);
                        }
                        else {
                            await Promise.all(readers.map((reader) => reader.cancel()));
                            break loop;
                        }
                    }
                }
                controller.close();
            }
            catch (e) {
                controller.error(e);
            }
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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