export class BSNode {
    parent;
    value;
    left;
    right;
    constructor(parent, value) {
        this.parent = parent;
        this.value = value;
        this.left = null;
        this.right = null;
    }
    static from(node) {
        const copy = new BSNode(node.parent, node.value);
        copy.left = node.left;
        copy.right = node.right;
        return copy;
    }
    directionFromParent() {
        return this.parent === null
            ? null
            : this === this.parent.left
                ? "left"
                : this === this.parent.right
                    ? "right"
                    : null;
    }
    findMinNode() {
        let minNode = this.left;
        while (minNode?.left)
            minNode = minNode.left;
        return minNode ?? this;
    }
    findMaxNode() {
        let maxNode = this.right;
        while (maxNode?.right)
            maxNode = maxNode.right;
        return maxNode ?? this;
    }
    findSuccessorNode() {
        if (this.right !== null)
            return this.right.findMinNode();
        let parent = this.parent;
        let direction = this.directionFromParent();
        while (parent && direction === "right") {
            direction = parent.directionFromParent();
            parent = parent.parent;
        }
        return parent;
    }
}
//# sourceMappingURL=data:application/json;base64,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