import { fnv32, fnv32a } from "./fnv32.ts";
import { fnv64, fnv64a } from "./fnv64.ts";
export const fnv = (name, buf) => {
    if (!buf) {
        throw new TypeError("no data provided for hashing");
    }
    switch (name) {
        case "FNV32":
            return fnv32(buf);
        case "FNV64":
            return fnv64(buf);
        case "FNV32A":
            return fnv32a(buf);
        case "FNV64A":
            return fnv64a(buf);
        default:
            throw new TypeError(`unsupported fnv digest: ${name}`);
    }
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW5kZXguanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJpbmRleC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFHQSxPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxNQUFNLFlBQVksQ0FBQztBQUMzQyxPQUFPLEVBQUUsS0FBSyxFQUFFLE1BQU0sRUFBRSxNQUFNLFlBQVksQ0FBQztBQUUzQyxNQUFNLENBQUMsTUFBTSxHQUFHLEdBQUcsQ0FBQyxJQUFZLEVBQUUsR0FBMkIsRUFBZSxFQUFFO0lBQzVFLElBQUksQ0FBQyxHQUFHLEVBQUU7UUFDUixNQUFNLElBQUksU0FBUyxDQUFDLDhCQUE4QixDQUFDLENBQUM7S0FDckQ7SUFFRCxRQUFRLElBQUksRUFBRTtRQUNaLEtBQUssT0FBTztZQUNWLE9BQU8sS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3BCLEtBQUssT0FBTztZQUNWLE9BQU8sS0FBSyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3BCLEtBQUssUUFBUTtZQUNYLE9BQU8sTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3JCLEtBQUssUUFBUTtZQUNYLE9BQU8sTUFBTSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3JCO1lBQ0UsTUFBTSxJQUFJLFNBQVMsQ0FBQywyQkFBMkIsSUFBSSxFQUFFLENBQUMsQ0FBQztLQUMxRDtBQUNILENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDE4LTIwMjIgdGhlIERlbm8gYXV0aG9ycy4gQWxsIHJpZ2h0cyByZXNlcnZlZC4gTUlUIGxpY2Vuc2UuXG4vLyBUaGlzIG1vZHVsZSBpcyBicm93c2VyIGNvbXBhdGlibGUuXG5cbmltcG9ydCB7IGZudjMyLCBmbnYzMmEgfSBmcm9tIFwiLi9mbnYzMi50c1wiO1xuaW1wb3J0IHsgZm52NjQsIGZudjY0YSB9IGZyb20gXCIuL2ZudjY0LnRzXCI7XG5cbmV4cG9ydCBjb25zdCBmbnYgPSAobmFtZTogc3RyaW5nLCBidWY6IFVpbnQ4QXJyYXkgfCB1bmRlZmluZWQpOiBBcnJheUJ1ZmZlciA9PiB7XG4gIGlmICghYnVmKSB7XG4gICAgdGhyb3cgbmV3IFR5cGVFcnJvcihcIm5vIGRhdGEgcHJvdmlkZWQgZm9yIGhhc2hpbmdcIik7XG4gIH1cblxuICBzd2l0Y2ggKG5hbWUpIHtcbiAgICBjYXNlIFwiRk5WMzJcIjpcbiAgICAgIHJldHVybiBmbnYzMihidWYpO1xuICAgIGNhc2UgXCJGTlY2NFwiOlxuICAgICAgcmV0dXJuIGZudjY0KGJ1Zik7XG4gICAgY2FzZSBcIkZOVjMyQVwiOlxuICAgICAgcmV0dXJuIGZudjMyYShidWYpO1xuICAgIGNhc2UgXCJGTlY2NEFcIjpcbiAgICAgIHJldHVybiBmbnY2NGEoYnVmKTtcbiAgICBkZWZhdWx0OlxuICAgICAgdGhyb3cgbmV3IFR5cGVFcnJvcihgdW5zdXBwb3J0ZWQgZm52IGRpZ2VzdDogJHtuYW1lfWApO1xuICB9XG59O1xuIl19