import { Buffer } from "./buffer.ts";
export class StringReader extends Buffer {
    constructor(s) {
        super(new TextEncoder().encode(s).buffer);
    }
}
export class MultiReader {
    readers;
    currentIndex = 0;
    constructor(readers) {
        this.readers = [...readers];
    }
    async read(p) {
        const r = this.readers[this.currentIndex];
        if (!r)
            return null;
        const result = await r.read(p);
        if (result === null) {
            this.currentIndex++;
            return 0;
        }
        return result;
    }
}
export class LimitedReader {
    reader;
    limit;
    constructor(reader, limit) {
        this.reader = reader;
        this.limit = limit;
    }
    async read(p) {
        if (this.limit <= 0) {
            return null;
        }
        if (p.length > this.limit) {
            p = p.subarray(0, this.limit);
        }
        const n = await this.reader.read(p);
        if (n == null) {
            return null;
        }
        this.limit -= n;
        return n;
    }
}
//# sourceMappingURL=data:application/json;base64,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