export function bytesToUuid(bytes) {
    const bits = [...bytes].map((bit) => {
        const s = bit.toString(16);
        return bit < 0x10 ? "0" + s : s;
    });
    return [
        ...bits.slice(0, 4),
        "-",
        ...bits.slice(4, 6),
        "-",
        ...bits.slice(6, 8),
        "-",
        ...bits.slice(8, 10),
        "-",
        ...bits.slice(10, 16),
    ].join("");
}
export function uuidToBytes(uuid) {
    const bytes = [];
    uuid.replace(/[a-fA-F0-9]{2}/g, (hex) => {
        bytes.push(parseInt(hex, 16));
        return "";
    });
    return bytes;
}
export function stringToBytes(str) {
    str = unescape(encodeURIComponent(str));
    const bytes = Array.from({ length: str.length });
    for (let i = 0; i < str.length; i++) {
        bytes[i] = str.charCodeAt(i);
    }
    return bytes;
}
export function createBuffer(content) {
    const arrayBuffer = new ArrayBuffer(content.length);
    const uint8Array = new Uint8Array(arrayBuffer);
    for (let i = 0; i < content.length; i++) {
        uint8Array[i] = content[i];
    }
    return arrayBuffer;
}
//# sourceMappingURL=data:application/json;base64,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