import { Type } from "../type.ts";
function resolveYamlNull(data) {
    const max = data.length;
    return ((max === 1 && data === "~") ||
        (max === 4 && (data === "null" || data === "Null" || data === "NULL")));
}
function constructYamlNull() {
    return null;
}
function isNull(object) {
    return object === null;
}
export const nil = new Type("tag:yaml.org,2002:null", {
    construct: constructYamlNull,
    defaultStyle: "lowercase",
    kind: "scalar",
    predicate: isNull,
    represent: {
        canonical() {
            return "~";
        },
        lowercase() {
            return "null";
        },
        uppercase() {
            return "NULL";
        },
        camelcase() {
            return "Null";
        },
    },
    resolve: resolveYamlNull,
});
//# sourceMappingURL=data:application/json;base64,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