// deno-fmt-ignore-file
// deno-lint-ignore-file
// This code was bundled using `deno bundle` and it's not recommended to edit it manually

function distance(a, b) {
    if (a.length == 0) {
        return b.length;
    }
    if (b.length == 0) {
        return a.length;
    }
    const matrix = [];
    for(let i2 = 0; i2 <= b.length; i2++){
        matrix[i2] = [
            i2
        ];
    }
    for(let j = 0; j <= a.length; j++){
        matrix[0][j] = j;
    }
    for(let i1 = 1; i1 <= b.length; i1++){
        for(let j = 1; j <= a.length; j++){
            if (b.charAt(i1 - 1) == a.charAt(j - 1)) {
                matrix[i1][j] = matrix[i1 - 1][j - 1];
            } else {
                matrix[i1][j] = Math.min(matrix[i1 - 1][j - 1] + 1, Math.min(matrix[i1][j - 1] + 1, matrix[i1 - 1][j] + 1));
            }
        }
    }
    return matrix[b.length][a.length];
}
function paramCaseToCamelCase(str1) {
    return str1.replace(/-([a-z])/g, (g)=>g[1].toUpperCase()
    );
}
function getOption(flags, name1) {
    while(name1[0] === "-"){
        name1 = name1.slice(1);
    }
    for (const flag of flags){
        if (isOption(flag, name1)) {
            return flag;
        }
    }
    return;
}
function didYouMeanOption(option1, options) {
    const optionNames = options.map((option)=>[
            option.name,
            ...option.aliases ?? []
        ]
    ).flat().map((option)=>getFlag(option)
    );
    return didYouMean(" Did you mean option", getFlag(option1), optionNames);
}
function didYouMeanType(type1, types3) {
    return didYouMean(" Did you mean type", type1, types3);
}
function didYouMean(message, type2, types4) {
    const match = closest(type2, types4);
    return match ? `${message} "${match}"?` : "";
}
function getFlag(name2) {
    if (name2.startsWith("-")) {
        return name2;
    }
    if (name2.length > 1) {
        return `--${name2}`;
    }
    return `-${name2}`;
}
function isOption(option, name3) {
    return option.name === name3 || option.aliases && option.aliases.indexOf(name3) !== -1;
}
function closest(str2, arr) {
    let minDistance = Infinity;
    let minIndex = 0;
    for(let i3 = 0; i3 < arr.length; i3++){
        const dist = distance(str2, arr[i3]);
        if (dist < minDistance) {
            minDistance = dist;
            minIndex = i3;
        }
    }
    return arr[minIndex];
}
function getDefaultValue(option) {
    return typeof option.default === "function" ? option.default() : option.default;
}
class FlagsError extends Error {
    constructor(message){
        super(message);
        Object.setPrototypeOf(this, FlagsError.prototype);
    }
}
class UnknownRequiredOption extends FlagsError {
    constructor(option, options){
        super(`Unknown required option "${getFlag(option)}".${didYouMeanOption(option, options)}`);
        Object.setPrototypeOf(this, UnknownRequiredOption.prototype);
    }
}
class UnknownConflictingOption extends FlagsError {
    constructor(option, options){
        super(`Unknown conflicting option "${getFlag(option)}".${didYouMeanOption(option, options)}`);
        Object.setPrototypeOf(this, UnknownConflictingOption.prototype);
    }
}
class UnknownType extends FlagsError {
    constructor(type3, types5){
        super(`Unknown type "${type3}".${didYouMeanType(type3, types5)}`);
        Object.setPrototypeOf(this, UnknownType.prototype);
    }
}
class ValidationError extends FlagsError {
    constructor(message){
        super(message);
        Object.setPrototypeOf(this, ValidationError.prototype);
    }
}
class DuplicateOption extends ValidationError {
    constructor(name4){
        super(`Option "${getFlag(name4).replace(/^--no-/, "--")}" can only occur once, but was found several times.`);
        Object.setPrototypeOf(this, DuplicateOption.prototype);
    }
}
class UnknownOption extends ValidationError {
    constructor(option, options){
        super(`Unknown option "${getFlag(option)}".${didYouMeanOption(option, options)}`);
        Object.setPrototypeOf(this, UnknownOption.prototype);
    }
}
class MissingOptionValue extends ValidationError {
    constructor(option){
        super(`Missing value for option "${getFlag(option)}".`);
        Object.setPrototypeOf(this, MissingOptionValue.prototype);
    }
}
class InvalidOptionValue extends ValidationError {
    constructor(option, expected, value){
        super(`Option "${getFlag(option)}" must be of type "${expected}", but got "${value}".`);
        Object.setPrototypeOf(this, InvalidOptionValue.prototype);
    }
}
class OptionNotCombinable extends ValidationError {
    constructor(option){
        super(`Option "${getFlag(option)}" cannot be combined with other options.`);
        Object.setPrototypeOf(this, OptionNotCombinable.prototype);
    }
}
class ConflictingOption extends ValidationError {
    constructor(option, conflictingOption){
        super(`Option "${getFlag(option)}" conflicts with option "${getFlag(conflictingOption)}".`);
        Object.setPrototypeOf(this, ConflictingOption.prototype);
    }
}
class DependingOption extends ValidationError {
    constructor(option, dependingOption){
        super(`Option "${getFlag(option)}" depends on option "${getFlag(dependingOption)}".`);
        Object.setPrototypeOf(this, DependingOption.prototype);
    }
}
class MissingRequiredOption extends ValidationError {
    constructor(option){
        super(`Missing required option "${getFlag(option)}".`);
        Object.setPrototypeOf(this, MissingRequiredOption.prototype);
    }
}
class RequiredArgumentFollowsOptionalArgument extends ValidationError {
    constructor(arg){
        super(`An required argument cannot follow an optional argument, but "${arg}"  is defined as required.`);
        Object.setPrototypeOf(this, RequiredArgumentFollowsOptionalArgument.prototype);
    }
}
class ArgumentFollowsVariadicArgument extends ValidationError {
    constructor(arg){
        super(`An argument cannot follow an variadic argument, but got "${arg}".`);
        Object.setPrototypeOf(this, ArgumentFollowsVariadicArgument.prototype);
    }
}
class NoArguments extends ValidationError {
    constructor(){
        super(`No arguments.`);
        Object.setPrototypeOf(this, NoArguments.prototype);
    }
}
class InvalidTypeError extends ValidationError {
    constructor({ label , name: name5 , value: value1 , type: type4  }, expected){
        super(`${label} "${name5}" must be of type "${type4}", but got "${value1}".` + (expected ? ` Expected values: ${expected.map((value)=>`"${value}"`
        ).join(", ")}` : ""));
        Object.setPrototypeOf(this, MissingOptionValue.prototype);
    }
}
function normalize(args) {
    const normalized = [];
    let inLiteral = false;
    for (const arg of args){
        if (inLiteral) {
            normalized.push(arg);
        } else if (arg === "--") {
            inLiteral = true;
            normalized.push(arg);
        } else if (arg.length > 1 && arg[0] === "-") {
            const isLong = arg[1] === "-";
            const isDotted = !isLong && arg[2] === ".";
            if (arg.includes("=")) {
                const parts = arg.split("=");
                const flag = parts.shift();
                if (isLong) {
                    normalized.push(flag);
                } else {
                    normalizeShortFlags(flag);
                }
                normalized.push(parts.join("="));
            } else if (isLong || isDotted) {
                normalized.push(arg);
            } else {
                normalizeShortFlags(arg);
            }
        } else {
            normalized.push(arg);
        }
    }
    return normalized;
    function normalizeShortFlags(flag) {
        const flags = flag.slice(1).split("");
        if (isNaN(Number(flag[flag.length - 1]))) {
            flags.forEach((val)=>normalized.push(`-${val}`)
            );
        } else {
            normalized.push(`-${flags.shift()}`);
            normalized.push(flags.join(""));
        }
    }
}
var OptionType;
(function(OptionType1) {
    OptionType1["STRING"] = "string";
    OptionType1["NUMBER"] = "number";
    OptionType1["INTEGER"] = "integer";
    OptionType1["BOOLEAN"] = "boolean";
})(OptionType || (OptionType = {}));
const __boolean = (type5)=>{
    if (~[
        "1",
        "true"
    ].indexOf(type5.value)) {
        return true;
    }
    if (~[
        "0",
        "false"
    ].indexOf(type5.value)) {
        return false;
    }
    throw new InvalidTypeError(type5);
};
const number = (type6)=>{
    const value = Number(type6.value);
    if (Number.isFinite(value)) {
        return value;
    }
    throw new InvalidTypeError(type6);
};
const string = ({ value  })=>{
    return value;
};
function validateFlags(flags, values1, _knownFlaks, allowEmpty, optionNames = {}) {
    const defaultValues = {};
    for (const option of flags){
        let name6;
        let defaultValue = undefined;
        if (option.name.startsWith("no-")) {
            const propName = option.name.replace(/^no-/, "");
            if (propName in values1) {
                continue;
            }
            const positiveOption = getOption(flags, propName);
            if (positiveOption) {
                continue;
            }
            name6 = paramCaseToCamelCase(propName);
            defaultValue = true;
        }
        if (!name6) {
            name6 = paramCaseToCamelCase(option.name);
        }
        if (!(name6 in optionNames)) {
            optionNames[name6] = option.name;
        }
        const hasDefaultValue = typeof values1[name6] === "undefined" && (typeof option.default !== "undefined" || typeof defaultValue !== "undefined");
        if (hasDefaultValue) {
            values1[name6] = getDefaultValue(option) ?? defaultValue;
            defaultValues[option.name] = true;
            if (typeof option.value === "function") {
                values1[name6] = option.value(values1[name6]);
            }
        }
    }
    const keys1 = Object.keys(values1);
    if (keys1.length === 0 && allowEmpty) {
        return;
    }
    const options = keys1.map((name7)=>({
            name: name7,
            option: getOption(flags, optionNames[name7])
        })
    );
    for (const { name: name1 , option: option1  } of options){
        if (!option1) {
            throw new UnknownOption(name1, flags);
        }
        if (option1.standalone) {
            if (keys1.length > 1) {
                if (options.every(({ option: opt  })=>opt && (option1 === opt || defaultValues[opt.name])
                )) {
                    return;
                }
                throw new OptionNotCombinable(option1.name);
            }
            return;
        }
        option1.conflicts?.forEach((flag)=>{
            if (isset(flag, values1)) {
                throw new ConflictingOption(option1.name, flag);
            }
        });
        option1.depends?.forEach((flag)=>{
            if (!isset(flag, values1) && !defaultValues[option1.name]) {
                throw new DependingOption(option1.name, flag);
            }
        });
        const isArray2 = (option1.args?.length || 0) > 1;
        option1.args?.forEach((arg, i4)=>{
            if (arg.requiredValue && (typeof values1[name1] === "undefined" || isArray2 && typeof values1[name1][i4] === "undefined")) {
                throw new MissingOptionValue(option1.name);
            }
        });
    }
    for (const option2 of flags){
        if (option2.required && !(paramCaseToCamelCase(option2.name) in values1)) {
            if ((!option2.conflicts || !option2.conflicts.find((flag)=>!!values1[flag]
            )) && !options.find((opt)=>opt.option?.conflicts?.find((flag)=>flag === option2.name
                )
            )) {
                throw new MissingRequiredOption(option2.name);
            }
        }
    }
    if (keys1.length === 0 && !allowEmpty) {
        throw new NoArguments();
    }
}
function isset(flag, values2) {
    const name8 = paramCaseToCamelCase(flag);
    return typeof values2[name8] !== "undefined";
}
const integer = (type7)=>{
    const value = Number(type7.value);
    if (Number.isInteger(value)) {
        return value;
    }
    throw new InvalidTypeError(type7);
};
const Types = {
    [OptionType.STRING]: string,
    [OptionType.NUMBER]: number,
    [OptionType.INTEGER]: integer,
    [OptionType.BOOLEAN]: __boolean
};
function parseFlags(args2, opts = {}) {
    !opts.flags && (opts.flags = []);
    const normalized = normalize(args2);
    let inLiteral = false;
    let negate = false;
    const flags = {};
    const optionNames = {};
    let literal1 = [];
    let unknown = [];
    let stopEarly = null;
    opts.flags.forEach((opt)=>{
        opt.depends?.forEach((flag)=>{
            if (!opts.flags || !getOption(opts.flags, flag)) {
                throw new UnknownRequiredOption(flag, opts.flags ?? []);
            }
        });
        opt.conflicts?.forEach((flag)=>{
            if (!opts.flags || !getOption(opts.flags, flag)) {
                throw new UnknownConflictingOption(flag, opts.flags ?? []);
            }
        });
    });
    for(let i5 = 0; i5 < normalized.length; i5++){
        let option1;
        let args1;
        const current = normalized[i5];
        if (inLiteral) {
            literal1.push(current);
            continue;
        }
        if (current === "--") {
            inLiteral = true;
            continue;
        }
        const isFlag = current.length > 1 && current[0] === "-";
        const next = ()=>normalized[i5 + 1]
        ;
        if (isFlag) {
            if (current[2] === "-" || current[1] === "-" && current.length === 3) {
                throw new UnknownOption(current, opts.flags);
            }
            negate = current.startsWith("--no-");
            option1 = getOption(opts.flags, current);
            if (!option1) {
                if (opts.flags.length) {
                    throw new UnknownOption(current, opts.flags);
                }
                option1 = {
                    name: current.replace(/^-+/, ""),
                    optionalValue: true,
                    type: OptionType.STRING
                };
            }
            const positiveName = option1.name.replace(/^no-?/, "");
            const propName = paramCaseToCamelCase(positiveName);
            if (typeof flags[propName] !== "undefined" && !option1.collect) {
                throw new DuplicateOption(current);
            }
            args1 = option1.args?.length ? option1.args : [
                {
                    type: option1.type,
                    requiredValue: option1.requiredValue,
                    optionalValue: option1.optionalValue,
                    variadic: option1.variadic,
                    list: option1.list,
                    separator: option1.separator
                }
            ];
            let argIndex = 0;
            let inOptionalArg = false;
            const previous = flags[propName];
            parseNext(option1, args1);
            if (typeof flags[propName] === "undefined") {
                if (typeof option1.default !== "undefined") {
                    flags[propName] = getDefaultValue(option1);
                } else if (args1[argIndex].requiredValue) {
                    throw new MissingOptionValue(option1.name);
                } else {
                    flags[propName] = true;
                }
            }
            if (option1.value) {
                flags[propName] = option1.value(flags[propName], previous);
            } else if (option1.collect) {
                const value = Array.isArray(previous) ? previous : [];
                value.push(flags[propName]);
                flags[propName] = value;
            }
            optionNames[propName] = option1.name;
            opts.option?.(option1, flags[propName]);
            function parseNext(option3, args) {
                const arg1 = args[argIndex];
                if (!arg1) {
                    const flag = next();
                    throw new UnknownOption(flag, opts.flags ?? []);
                }
                if (!arg1.type) {
                    arg1.type = OptionType.BOOLEAN;
                }
                if (option3.args?.length) {
                    if ((typeof arg1.optionalValue === "undefined" || arg1.optionalValue === false) && typeof arg1.requiredValue === "undefined") {
                        arg1.requiredValue = true;
                    }
                } else {
                    if (arg1.type !== OptionType.BOOLEAN && (typeof arg1.optionalValue === "undefined" || arg1.optionalValue === false) && typeof arg1.requiredValue === "undefined") {
                        arg1.requiredValue = true;
                    }
                }
                if (arg1.requiredValue) {
                    if (inOptionalArg) {
                        throw new RequiredArgumentFollowsOptionalArgument(option3.name);
                    }
                } else {
                    inOptionalArg = true;
                }
                if (negate) {
                    flags[propName] = false;
                    return;
                }
                let result2;
                let increase = false;
                if (arg1.list && hasNext(arg1)) {
                    const parsed = next().split(arg1.separator || ",").map((nextValue)=>{
                        const value = parseValue(option3, arg1, nextValue);
                        if (typeof value === "undefined") {
                            throw new InvalidOptionValue(option3.name, arg1.type ?? "?", nextValue);
                        }
                        return value;
                    });
                    if (parsed?.length) {
                        result2 = parsed;
                    }
                } else {
                    if (hasNext(arg1)) {
                        result2 = parseValue(option3, arg1, next());
                    } else if (arg1.optionalValue && arg1.type === OptionType.BOOLEAN) {
                        result2 = true;
                    }
                }
                if (increase) {
                    i5++;
                    if (!arg1.variadic) {
                        argIndex++;
                    } else if (args[argIndex + 1]) {
                        throw new ArgumentFollowsVariadicArgument(next());
                    }
                }
                if (typeof result2 !== "undefined" && (args.length > 1 || arg1.variadic)) {
                    if (!flags[propName]) {
                        flags[propName] = [];
                    }
                    flags[propName].push(result2);
                    if (hasNext(arg1)) {
                        parseNext(option3, args);
                    }
                } else {
                    flags[propName] = result2;
                }
                function hasNext(arg) {
                    return !!(normalized[i5 + 1] && (arg.optionalValue || arg.requiredValue || arg.variadic) && (normalized[i5 + 1][0] !== "-" || arg.type === OptionType.NUMBER && !isNaN(Number(normalized[i5 + 1]))) && arg);
                }
                function parseValue(option, arg, value) {
                    const type8 = arg.type || OptionType.STRING;
                    const result = opts.parse ? opts.parse({
                        label: "Option",
                        type: type8,
                        name: `--${option.name}`,
                        value
                    }) : parseFlagValue(option, arg, value);
                    if (typeof result !== "undefined") {
                        increase = true;
                    }
                    return result;
                }
            }
        } else {
            if (opts.stopEarly) {
                stopEarly = current;
                break;
            }
            unknown.push(current);
        }
    }
    if (stopEarly) {
        const stopEarlyArgIndex = args2.indexOf(stopEarly);
        if (stopEarlyArgIndex !== -1) {
            const doubleDashIndex = args2.indexOf("--");
            unknown = args2.slice(stopEarlyArgIndex, doubleDashIndex === -1 ? undefined : doubleDashIndex);
            if (doubleDashIndex !== -1) {
                literal1 = args2.slice(doubleDashIndex + 1);
            }
        }
    }
    if (opts.flags?.length) {
        validateFlags(opts.flags, flags, opts.knownFlaks, opts.allowEmpty, optionNames);
    }
    const result1 = Object.keys(flags).reduce((result3, key)=>{
        if (~key.indexOf(".")) {
            key.split(".").reduce((result, subKey, index, parts)=>{
                if (index === parts.length - 1) {
                    result[subKey] = flags[key];
                } else {
                    result[subKey] = result[subKey] ?? {};
                }
                return result[subKey];
            }, result3);
        } else {
            result3[key] = flags[key];
        }
        return result3;
    }, {});
    return {
        flags: result1,
        unknown,
        literal: literal1
    };
}
function parseFlagValue(option, arg, value) {
    const type9 = arg.type || OptionType.STRING;
    const parseType = Types[type9];
    if (!parseType) {
        throw new UnknownType(type9, Object.keys(Types));
    }
    return parseType({
        label: "Option",
        type: type9,
        name: `--${option.name}`,
        value
    });
}
function getPermissions() {
    return hasPermissions([
        "env",
        "hrtime",
        "net",
        "plugin",
        "read",
        "run",
        "write", 
    ]);
}
function isUnstable() {
    return !!Deno.permissions;
}
function didYouMeanCommand(command1, commands1, excludes = []) {
    const commandNames = commands1.map((command)=>command.getName()
    ).filter((command)=>!excludes.includes(command)
    );
    return didYouMean(" Did you mean command", command1, commandNames);
}
async function hasPermission(permission) {
    try {
        return (await Deno.permissions?.query?.({
            name: permission
        }))?.state === "granted";
    } catch  {
        return false;
    }
}
async function hasPermissions(names) {
    const permissions = {};
    await Promise.all(names.map((name9)=>hasPermission(name9).then((hasPermission1)=>permissions[name9] = hasPermission1
        )
    ));
    return permissions;
}
const ARGUMENT_REGEX = /^[<\[].+[\]>]$/;
const ARGUMENT_DETAILS_REGEX = /[<\[:>\]]/;
function splitArguments(args) {
    const parts = args.trim().split(/[, =] */g);
    const typeParts = [];
    while(parts[parts.length - 1] && ARGUMENT_REGEX.test(parts[parts.length - 1])){
        typeParts.unshift(parts.pop());
    }
    const typeDefinition = typeParts.join(" ");
    return {
        flags: parts,
        typeDefinition
    };
}
function parseArgumentsDefinition(argsDefinition) {
    const argumentDetails = [];
    let hasOptional = false;
    let hasVariadic = false;
    const parts = argsDefinition.split(/ +/);
    for (const arg of parts){
        if (hasVariadic) {
            throw new ArgumentFollowsVariadicArgument(arg);
        }
        const parts = arg.split(ARGUMENT_DETAILS_REGEX);
        const type10 = parts[2] || OptionType.STRING;
        const details = {
            optionalValue: arg[0] !== "<",
            name: parts[1],
            action: parts[3] || type10,
            variadic: false,
            list: type10 ? arg.indexOf(type10 + "[]") !== -1 : false,
            type: type10
        };
        if (!details.optionalValue && hasOptional) {
            throw new RequiredArgumentFollowsOptionalArgument(details.name);
        }
        if (arg[0] === "[") {
            hasOptional = true;
        }
        if (details.name.length > 3) {
            const istVariadicLeft = details.name.slice(0, 3) === "...";
            const istVariadicRight = details.name.slice(-3) === "...";
            hasVariadic = details.variadic = istVariadicLeft || istVariadicRight;
            if (istVariadicLeft) {
                details.name = details.name.slice(3);
            } else if (istVariadicRight) {
                details.name = details.name.slice(0, -3);
            }
        }
        if (details.name) {
            argumentDetails.push(details);
        }
    }
    return argumentDetails;
}
const { Deno: Deno1  } = globalThis;
const noColor = typeof Deno1?.noColor === "boolean" ? Deno1.noColor : true;
let enabled = !noColor;
function setColorEnabled(value) {
    if (noColor) {
        return;
    }
    enabled = value;
}
function getColorEnabled() {
    return enabled;
}
function code(open, close) {
    return {
        open: `\x1b[${open.join(";")}m`,
        close: `\x1b[${close}m`,
        regexp: new RegExp(`\\x1b\\[${close}m`, "g")
    };
}
function run(str3, code1) {
    return enabled ? `${code1.open}${str3.replace(code1.regexp, code1.open)}${code1.close}` : str3;
}
function reset(str4) {
    return run(str4, code([
        0
    ], 0));
}
function bold(str5) {
    return run(str5, code([
        1
    ], 22));
}
function dim(str6) {
    return run(str6, code([
        2
    ], 22));
}
function italic(str7) {
    return run(str7, code([
        3
    ], 23));
}
function underline(str8) {
    return run(str8, code([
        4
    ], 24));
}
function inverse(str9) {
    return run(str9, code([
        7
    ], 27));
}
function hidden(str10) {
    return run(str10, code([
        8
    ], 28));
}
function strikethrough(str11) {
    return run(str11, code([
        9
    ], 29));
}
function black(str12) {
    return run(str12, code([
        30
    ], 39));
}
function red(str13) {
    return run(str13, code([
        31
    ], 39));
}
function green(str14) {
    return run(str14, code([
        32
    ], 39));
}
function yellow(str15) {
    return run(str15, code([
        33
    ], 39));
}
function blue(str16) {
    return run(str16, code([
        34
    ], 39));
}
function magenta(str17) {
    return run(str17, code([
        35
    ], 39));
}
function cyan(str18) {
    return run(str18, code([
        36
    ], 39));
}
function white(str19) {
    return run(str19, code([
        37
    ], 39));
}
function gray(str20) {
    return brightBlack(str20);
}
function brightBlack(str21) {
    return run(str21, code([
        90
    ], 39));
}
function brightRed(str22) {
    return run(str22, code([
        91
    ], 39));
}
function brightGreen(str23) {
    return run(str23, code([
        92
    ], 39));
}
function brightYellow(str24) {
    return run(str24, code([
        93
    ], 39));
}
function brightBlue(str25) {
    return run(str25, code([
        94
    ], 39));
}
function brightMagenta(str26) {
    return run(str26, code([
        95
    ], 39));
}
function brightCyan(str27) {
    return run(str27, code([
        96
    ], 39));
}
function brightWhite(str28) {
    return run(str28, code([
        97
    ], 39));
}
function bgBlack(str29) {
    return run(str29, code([
        40
    ], 49));
}
function bgRed(str30) {
    return run(str30, code([
        41
    ], 49));
}
function bgGreen(str31) {
    return run(str31, code([
        42
    ], 49));
}
function bgYellow(str32) {
    return run(str32, code([
        43
    ], 49));
}
function bgBlue(str33) {
    return run(str33, code([
        44
    ], 49));
}
function bgMagenta(str34) {
    return run(str34, code([
        45
    ], 49));
}
function bgCyan(str35) {
    return run(str35, code([
        46
    ], 49));
}
function bgWhite(str36) {
    return run(str36, code([
        47
    ], 49));
}
function bgBrightBlack(str37) {
    return run(str37, code([
        100
    ], 49));
}
function bgBrightRed(str38) {
    return run(str38, code([
        101
    ], 49));
}
function bgBrightGreen(str39) {
    return run(str39, code([
        102
    ], 49));
}
function bgBrightYellow(str40) {
    return run(str40, code([
        103
    ], 49));
}
function bgBrightBlue(str41) {
    return run(str41, code([
        104
    ], 49));
}
function bgBrightMagenta(str42) {
    return run(str42, code([
        105
    ], 49));
}
function bgBrightCyan(str43) {
    return run(str43, code([
        106
    ], 49));
}
function bgBrightWhite(str44) {
    return run(str44, code([
        107
    ], 49));
}
function clampAndTruncate(n, max = 255, min = 0) {
    return Math.trunc(Math.max(Math.min(n, max), min));
}
function rgb8(str45, color) {
    return run(str45, code([
        38,
        5,
        clampAndTruncate(color)
    ], 39));
}
function bgRgb8(str46, color) {
    return run(str46, code([
        48,
        5,
        clampAndTruncate(color)
    ], 49));
}
function rgb24(str47, color) {
    if (typeof color === "number") {
        return run(str47, code([
            38,
            2,
            color >> 16 & 255,
            color >> 8 & 255,
            color & 255
        ], 39));
    }
    return run(str47, code([
        38,
        2,
        clampAndTruncate(color.r),
        clampAndTruncate(color.g),
        clampAndTruncate(color.b), 
    ], 39));
}
function bgRgb24(str48, color) {
    if (typeof color === "number") {
        return run(str48, code([
            48,
            2,
            color >> 16 & 255,
            color >> 8 & 255,
            color & 255
        ], 49));
    }
    return run(str48, code([
        48,
        2,
        clampAndTruncate(color.r),
        clampAndTruncate(color.g),
        clampAndTruncate(color.b), 
    ], 49));
}
const ANSI_PATTERN = new RegExp([
    "[\\u001B\\u009B][[\\]()#;?]*(?:(?:(?:[a-zA-Z\\d]*(?:;[-a-zA-Z\\d\\/#&.:=?%@~_]*)*)?\\u0007)",
    "(?:(?:\\d{1,4}(?:;\\d{0,4})*)?[\\dA-PR-TZcf-ntqry=><~]))", 
].join("|"), "g");
function stripColor(string1) {
    return string1.replace(ANSI_PATTERN, "");
}
const mod = {
    setColorEnabled: setColorEnabled,
    getColorEnabled: getColorEnabled,
    reset: reset,
    bold: bold,
    dim: dim,
    italic: italic,
    underline: underline,
    inverse: inverse,
    hidden: hidden,
    strikethrough: strikethrough,
    black: black,
    red: red,
    green: green,
    yellow: yellow,
    blue: blue,
    magenta: magenta,
    cyan: cyan,
    white: white,
    gray: gray,
    brightBlack: brightBlack,
    brightRed: brightRed,
    brightGreen: brightGreen,
    brightYellow: brightYellow,
    brightBlue: brightBlue,
    brightMagenta: brightMagenta,
    brightCyan: brightCyan,
    brightWhite: brightWhite,
    bgBlack: bgBlack,
    bgRed: bgRed,
    bgGreen: bgGreen,
    bgYellow: bgYellow,
    bgBlue: bgBlue,
    bgMagenta: bgMagenta,
    bgCyan: bgCyan,
    bgWhite: bgWhite,
    bgBrightBlack: bgBrightBlack,
    bgBrightRed: bgBrightRed,
    bgBrightGreen: bgBrightGreen,
    bgBrightYellow: bgBrightYellow,
    bgBrightBlue: bgBrightBlue,
    bgBrightMagenta: bgBrightMagenta,
    bgBrightCyan: bgBrightCyan,
    bgBrightWhite: bgBrightWhite,
    rgb8: rgb8,
    bgRgb8: bgRgb8,
    rgb24: rgb24,
    bgRgb24: bgRgb24,
    stripColor: stripColor
};
class CommandError extends Error {
    constructor(message){
        super(message);
        Object.setPrototypeOf(this, CommandError.prototype);
    }
}
class ValidationError1 extends CommandError {
    exitCode;
    constructor(message, { exitCode  } = {}){
        super(message);
        Object.setPrototypeOf(this, ValidationError1.prototype);
        this.exitCode = exitCode ?? 1;
    }
}
class DuplicateOptionName extends CommandError {
    constructor(name10){
        super(`Option with name "${getFlag(name10)}" already exists.`);
        Object.setPrototypeOf(this, DuplicateOptionName.prototype);
    }
}
class MissingCommandName extends CommandError {
    constructor(){
        super("Missing command name.");
        Object.setPrototypeOf(this, MissingCommandName.prototype);
    }
}
class DuplicateCommandName extends CommandError {
    constructor(name11){
        super(`Duplicate command name "${name11}".`);
        Object.setPrototypeOf(this, DuplicateCommandName.prototype);
    }
}
class DuplicateCommandAlias extends CommandError {
    constructor(alias){
        super(`Duplicate command alias "${alias}".`);
        Object.setPrototypeOf(this, DuplicateCommandAlias.prototype);
    }
}
class CommandNotFound extends CommandError {
    constructor(name12, commands2, excluded){
        super(`Unknown command "${name12}".${didYouMeanCommand(name12, commands2, excluded)}`);
        Object.setPrototypeOf(this, UnknownCommand.prototype);
    }
}
class DuplicateType extends CommandError {
    constructor(name13){
        super(`Type with name "${name13}" already exists.`);
        Object.setPrototypeOf(this, DuplicateType.prototype);
    }
}
class DuplicateCompletion extends CommandError {
    constructor(name14){
        super(`Completion with name "${name14}" already exists.`);
        Object.setPrototypeOf(this, DuplicateCompletion.prototype);
    }
}
class DuplicateExample extends CommandError {
    constructor(name15){
        super(`Example with name "${name15}" already exists.`);
        Object.setPrototypeOf(this, DuplicateExample.prototype);
    }
}
class DuplicateEnvironmentVariable extends CommandError {
    constructor(name16){
        super(`Environment variable with name "${name16}" already exists.`);
        Object.setPrototypeOf(this, DuplicateEnvironmentVariable.prototype);
    }
}
class EnvironmentVariableSingleValue extends CommandError {
    constructor(name17){
        super(`An environment variable can only have one value, but "${name17}" has more than one.`);
        Object.setPrototypeOf(this, EnvironmentVariableSingleValue.prototype);
    }
}
class EnvironmentVariableOptionalValue extends CommandError {
    constructor(name18){
        super(`An environment variable cannot have an optional value, but "${name18}" is defined as optional.`);
        Object.setPrototypeOf(this, EnvironmentVariableOptionalValue.prototype);
    }
}
class EnvironmentVariableVariadicValue extends CommandError {
    constructor(name19){
        super(`An environment variable cannot have an variadic value, but "${name19}" is defined as variadic.`);
        Object.setPrototypeOf(this, EnvironmentVariableVariadicValue.prototype);
    }
}
class DefaultCommandNotFound extends CommandError {
    constructor(name20, commands3){
        super(`Default command "${name20}" not found.${didYouMeanCommand(name20, commands3)}`);
        Object.setPrototypeOf(this, DefaultCommandNotFound.prototype);
    }
}
class CommandExecutableNotFound extends CommandError {
    constructor(name21, files){
        super(`Command executable not found: ${name21}:\n    - ${files.join("\\n    - ")}`);
        Object.setPrototypeOf(this, CommandExecutableNotFound.prototype);
    }
}
class UnknownCompletionCommand extends CommandError {
    constructor(name22, commands4){
        super(`Auto-completion failed. Unknown command "${name22}".${didYouMeanCommand(name22, commands4)}`);
        Object.setPrototypeOf(this, UnknownCompletionCommand.prototype);
    }
}
class UnknownCommand extends ValidationError1 {
    constructor(name23, commands5, excluded){
        super(`Unknown command "${name23}".${didYouMeanCommand(name23, commands5, excluded)}`);
        Object.setPrototypeOf(this, UnknownCommand.prototype);
    }
}
class NoArgumentsAllowed extends ValidationError1 {
    constructor(name24){
        super(`No arguments allowed for command "${name24}".`);
        Object.setPrototypeOf(this, NoArgumentsAllowed.prototype);
    }
}
class MissingArguments extends ValidationError1 {
    constructor(args){
        super("Missing argument(s): " + args.join(", "));
        Object.setPrototypeOf(this, MissingArguments.prototype);
    }
}
class MissingArgument extends ValidationError1 {
    constructor(arg){
        super(`Missing argument "${arg}".`);
        Object.setPrototypeOf(this, MissingArgument.prototype);
    }
}
class TooManyArguments extends ValidationError1 {
    constructor(args){
        super(`Too many arguments: ${args.join(" ")}`);
        Object.setPrototypeOf(this, TooManyArguments.prototype);
    }
}
class Type {
}
class BooleanType extends Type {
    parse(type11) {
        return __boolean(type11);
    }
    complete() {
        return [
            "true",
            "false"
        ];
    }
}
class NumberType extends Type {
    parse(type12) {
        return number(type12);
    }
}
class StringType extends Type {
    parse(type13) {
        return string(type13);
    }
}
const border = {
    top: "─",
    topMid: "┬",
    topLeft: "┌",
    topRight: "┐",
    bottom: "─",
    bottomMid: "┴",
    bottomLeft: "└",
    bottomRight: "┘",
    left: "│",
    leftMid: "├",
    mid: "─",
    midMid: "┼",
    right: "│",
    rightMid: "┤",
    middle: "│"
};
class Cell {
    value;
    options = {};
    get length() {
        return this.toString().length;
    }
    static from(value) {
        const cell = new this(value);
        if (value instanceof Cell) {
            cell.options = {
                ...value.options
            };
        }
        return cell;
    }
    constructor(value){
        this.value = value;
    }
    toString() {
        return this.value.toString();
    }
    setValue(value) {
        this.value = value;
        return this;
    }
    clone(value) {
        const cell = new Cell(value ?? this);
        cell.options = {
            ...this.options
        };
        return cell;
    }
    border(enable, override = true) {
        if (override || typeof this.options.border === "undefined") {
            this.options.border = enable;
        }
        return this;
    }
    colSpan(span, override = true) {
        if (override || typeof this.options.colSpan === "undefined") {
            this.options.colSpan = span;
        }
        return this;
    }
    rowSpan(span, override = true) {
        if (override || typeof this.options.rowSpan === "undefined") {
            this.options.rowSpan = span;
        }
        return this;
    }
    align(direction, override = true) {
        if (override || typeof this.options.align === "undefined") {
            this.options.align = direction;
        }
        return this;
    }
    getBorder() {
        return this.options.border === true;
    }
    getColSpan() {
        return typeof this.options.colSpan === "number" && this.options.colSpan > 0 ? this.options.colSpan : 1;
    }
    getRowSpan() {
        return typeof this.options.rowSpan === "number" && this.options.rowSpan > 0 ? this.options.rowSpan : 1;
    }
    getAlign() {
        return this.options.align ?? "left";
    }
}
class Row extends Array {
    options = {};
    static from(cells) {
        const row = new this(...cells);
        if (cells instanceof Row) {
            row.options = {
                ...cells.options
            };
        }
        return row;
    }
    clone() {
        const row = new Row(...this.map((cell)=>cell instanceof Cell ? cell.clone() : cell
        ));
        row.options = {
            ...this.options
        };
        return row;
    }
    border(enable, override = true) {
        if (override || typeof this.options.border === "undefined") {
            this.options.border = enable;
        }
        return this;
    }
    align(direction, override = true) {
        if (override || typeof this.options.align === "undefined") {
            this.options.align = direction;
        }
        return this;
    }
    getBorder() {
        return this.options.border === true;
    }
    hasBorder() {
        return this.getBorder() || this.some((cell)=>cell instanceof Cell && cell.getBorder()
        );
    }
    getAlign() {
        return this.options.align ?? "left";
    }
}
function consumeWords(length, content) {
    let consumed = "";
    const words = content.split(/ /g);
    for(let i6 = 0; i6 < words.length; i6++){
        let word = words[i6];
        const hasLineBreak = word.indexOf("\n") !== -1;
        if (hasLineBreak) {
            word = word.split("\n").shift();
        }
        if (consumed) {
            const nextLength = stripColor(word).length;
            const consumedLength = stripColor(consumed).length;
            if (consumedLength + nextLength >= length) {
                break;
            }
        }
        consumed += (i6 > 0 ? " " : "") + word;
        if (hasLineBreak) {
            break;
        }
    }
    return consumed;
}
function longest(index, rows, maxWidth) {
    return Math.max(...rows.map((row)=>(row[index] instanceof Cell && row[index].getColSpan() > 1 ? "" : row[index]?.toString() || "").split("\n").map((r)=>{
            const str49 = typeof maxWidth === "undefined" ? r : consumeWords(maxWidth, r);
            return stripColor(str49).length || 0;
        })
    ).flat());
}
class TableLayout {
    table;
    options;
    constructor(table, options){
        this.table = table;
        this.options = options;
    }
    toString() {
        const opts = this.createLayout();
        return opts.rows.length ? this.renderRows(opts) : "";
    }
    createLayout() {
        Object.keys(this.options.chars).forEach((key)=>{
            if (typeof this.options.chars[key] !== "string") {
                this.options.chars[key] = "";
            }
        });
        const hasBodyBorder = this.table.getBorder() || this.table.hasBodyBorder();
        const hasHeaderBorder = this.table.hasHeaderBorder();
        const hasBorder = hasHeaderBorder || hasBodyBorder;
        const header = this.table.getHeader();
        const rows = this.spanRows(header ? [
            header,
            ...this.table
        ] : this.table.slice());
        const columns = Math.max(...rows.map((row)=>row.length
        ));
        for (const row1 of rows){
            const length = row1.length;
            if (length < columns) {
                const diff = columns - length;
                for(let i7 = 0; i7 < diff; i7++){
                    row1.push(this.createCell(null, row1));
                }
            }
        }
        const padding = [];
        const width = [];
        for(let colIndex = 0; colIndex < columns; colIndex++){
            const minColWidth = Array.isArray(this.options.minColWidth) ? this.options.minColWidth[colIndex] : this.options.minColWidth;
            const maxColWidth = Array.isArray(this.options.maxColWidth) ? this.options.maxColWidth[colIndex] : this.options.maxColWidth;
            const colWidth = longest(colIndex, rows, maxColWidth);
            width[colIndex] = Math.min(maxColWidth, Math.max(minColWidth, colWidth));
            padding[colIndex] = Array.isArray(this.options.padding) ? this.options.padding[colIndex] : this.options.padding;
        }
        return {
            padding,
            width,
            rows,
            columns,
            hasBorder,
            hasBodyBorder,
            hasHeaderBorder
        };
    }
    spanRows(_rows, rowIndex = 0, colIndex = 0, rowSpan = [], colSpan = 1) {
        const rows = _rows;
        if (rowIndex >= rows.length && rowSpan.every((span)=>span === 1
        )) {
            return rows;
        } else if (rows[rowIndex] && colIndex >= rows[rowIndex].length && colIndex >= rowSpan.length && colSpan === 1) {
            return this.spanRows(rows, ++rowIndex, 0, rowSpan, 1);
        }
        if (colSpan > 1) {
            colSpan--;
            rowSpan[colIndex] = rowSpan[colIndex - 1];
            rows[rowIndex].splice(colIndex - 1, 0, rows[rowIndex][colIndex - 1]);
            return this.spanRows(rows, rowIndex, ++colIndex, rowSpan, colSpan);
        }
        if (colIndex === 0) {
            rows[rowIndex] = this.createRow(rows[rowIndex] || []);
        }
        if (rowSpan[colIndex] > 1) {
            rowSpan[colIndex]--;
            rows[rowIndex].splice(colIndex, 0, rows[rowIndex - 1][colIndex]);
            return this.spanRows(rows, rowIndex, ++colIndex, rowSpan, colSpan);
        }
        rows[rowIndex][colIndex] = this.createCell(rows[rowIndex][colIndex] || null, rows[rowIndex]);
        colSpan = rows[rowIndex][colIndex].getColSpan();
        rowSpan[colIndex] = rows[rowIndex][colIndex].getRowSpan();
        return this.spanRows(rows, rowIndex, ++colIndex, rowSpan, colSpan);
    }
    createRow(row) {
        return Row.from(row).border(this.table.getBorder(), false).align(this.table.getAlign(), false);
    }
    createCell(cell, row) {
        return Cell.from(cell ?? "").border(row.getBorder(), false).align(row.getAlign(), false);
    }
    renderRows(opts) {
        let result = "";
        const rowSpan = new Array(opts.columns).fill(1);
        for(let rowIndex = 0; rowIndex < opts.rows.length; rowIndex++){
            result += this.renderRow(rowSpan, rowIndex, opts);
        }
        return result.slice(0, -1);
    }
    renderRow(rowSpan, rowIndex, opts, isMultiline) {
        const row = opts.rows[rowIndex];
        const prevRow = opts.rows[rowIndex - 1];
        const nextRow = opts.rows[rowIndex + 1];
        let result = "";
        let colSpan = 1;
        if (!isMultiline && rowIndex === 0 && row.hasBorder()) {
            result += this.renderBorderRow(undefined, row, rowSpan, opts);
        }
        let isMultilineRow = false;
        result += " ".repeat(this.options.indent || 0);
        for(let colIndex = 0; colIndex < opts.columns; colIndex++){
            if (colSpan > 1) {
                colSpan--;
                rowSpan[colIndex] = rowSpan[colIndex - 1];
                continue;
            }
            result += this.renderCell(colIndex, row, opts);
            if (rowSpan[colIndex] > 1) {
                if (!isMultiline) {
                    rowSpan[colIndex]--;
                }
            } else if (!prevRow || prevRow[colIndex] !== row[colIndex]) {
                rowSpan[colIndex] = row[colIndex].getRowSpan();
            }
            colSpan = row[colIndex].getColSpan();
            if (rowSpan[colIndex] === 1 && row[colIndex].length) {
                isMultilineRow = true;
            }
        }
        if (opts.columns > 0) {
            if (row[opts.columns - 1].getBorder()) {
                result += this.options.chars.right;
            } else if (opts.hasBorder) {
                result += " ";
            }
        }
        result += "\n";
        if (isMultilineRow) {
            return result + this.renderRow(rowSpan, rowIndex, opts, isMultilineRow);
        }
        if (rowIndex === 0 && opts.hasHeaderBorder || rowIndex < opts.rows.length - 1 && opts.hasBodyBorder) {
            result += this.renderBorderRow(row, nextRow, rowSpan, opts);
        }
        if (rowIndex === opts.rows.length - 1 && row.hasBorder()) {
            result += this.renderBorderRow(row, undefined, rowSpan, opts);
        }
        return result;
    }
    renderCell(colIndex, row, opts, noBorder) {
        let result = "";
        const prevCell = row[colIndex - 1];
        const cell = row[colIndex];
        if (!noBorder) {
            if (colIndex === 0) {
                if (cell.getBorder()) {
                    result += this.options.chars.left;
                } else if (opts.hasBorder) {
                    result += " ";
                }
            } else {
                if (cell.getBorder() || prevCell?.getBorder()) {
                    result += this.options.chars.middle;
                } else if (opts.hasBorder) {
                    result += " ";
                }
            }
        }
        let maxLength = opts.width[colIndex];
        const colSpan = cell.getColSpan();
        if (colSpan > 1) {
            for(let o = 1; o < colSpan; o++){
                maxLength += opts.width[colIndex + o] + opts.padding[colIndex + o];
                if (opts.hasBorder) {
                    maxLength += opts.padding[colIndex + o] + 1;
                }
            }
        }
        const { current , next  } = this.renderCellValue(cell, maxLength);
        row[colIndex].setValue(next);
        if (opts.hasBorder) {
            result += " ".repeat(opts.padding[colIndex]);
        }
        result += current;
        if (opts.hasBorder || colIndex < opts.columns - 1) {
            result += " ".repeat(opts.padding[colIndex]);
        }
        return result;
    }
    renderCellValue(cell, maxLength) {
        const length = Math.min(maxLength, stripColor(cell.toString()).length);
        let words = consumeWords(length, cell.toString());
        const breakWord = stripColor(words).length > length;
        if (breakWord) {
            words = words.slice(0, length);
        }
        const next = cell.toString().slice(words.length + (breakWord ? 0 : 1));
        const fillLength = maxLength - stripColor(words).length;
        const align = cell.getAlign();
        let current;
        if (fillLength === 0) {
            current = words;
        } else if (align === "left") {
            current = words + " ".repeat(fillLength);
        } else if (align === "center") {
            current = " ".repeat(Math.floor(fillLength / 2)) + words + " ".repeat(Math.ceil(fillLength / 2));
        } else if (align === "right") {
            current = " ".repeat(fillLength) + words;
        } else {
            throw new Error("Unknown direction: " + align);
        }
        return {
            current,
            next: cell.clone(next)
        };
    }
    renderBorderRow(prevRow, nextRow, rowSpan, opts) {
        let result = "";
        let colSpan = 1;
        for(let colIndex = 0; colIndex < opts.columns; colIndex++){
            if (rowSpan[colIndex] > 1) {
                if (!nextRow) {
                    throw new Error("invalid layout");
                }
                if (colSpan > 1) {
                    colSpan--;
                    continue;
                }
            }
            result += this.renderBorderCell(colIndex, prevRow, nextRow, rowSpan, opts);
            colSpan = nextRow?.[colIndex].getColSpan() ?? 1;
        }
        return result.length ? " ".repeat(this.options.indent) + result + "\n" : "";
    }
    renderBorderCell(colIndex, prevRow, nextRow, rowSpan, opts) {
        const a1 = prevRow?.[colIndex - 1];
        const a2 = nextRow?.[colIndex - 1];
        const b1 = prevRow?.[colIndex];
        const b2 = nextRow?.[colIndex];
        const a1Border = !!a1?.getBorder();
        const a2Border = !!a2?.getBorder();
        const b1Border = !!b1?.getBorder();
        const b2Border = !!b2?.getBorder();
        const hasColSpan = (cell)=>(cell?.getColSpan() ?? 1) > 1
        ;
        const hasRowSpan = (cell)=>(cell?.getRowSpan() ?? 1) > 1
        ;
        let result = "";
        if (colIndex === 0) {
            if (rowSpan[colIndex] > 1) {
                if (b1Border) {
                    result += this.options.chars.left;
                } else {
                    result += " ";
                }
            } else if (b1Border && b2Border) {
                result += this.options.chars.leftMid;
            } else if (b1Border) {
                result += this.options.chars.bottomLeft;
            } else if (b2Border) {
                result += this.options.chars.topLeft;
            } else {
                result += " ";
            }
        } else if (colIndex < opts.columns) {
            if (a1Border && b2Border || b1Border && a2Border) {
                const a1ColSpan = hasColSpan(a1);
                const a2ColSpan = hasColSpan(a2);
                const b1ColSpan = hasColSpan(b1);
                const b2ColSpan = hasColSpan(b2);
                const a1RowSpan = hasRowSpan(a1);
                const a2RowSpan = hasRowSpan(a2);
                const b1RowSpan = hasRowSpan(b1);
                const b2RowSpan = hasRowSpan(b2);
                const hasAllBorder = a1Border && b2Border && b1Border && a2Border;
                const hasAllRowSpan = a1RowSpan && b1RowSpan && a2RowSpan && b2RowSpan;
                const hasAllColSpan = a1ColSpan && b1ColSpan && a2ColSpan && b2ColSpan;
                if (hasAllRowSpan && hasAllBorder) {
                    result += this.options.chars.middle;
                } else if (hasAllColSpan && hasAllBorder && a1 === b1 && a2 === b2) {
                    result += this.options.chars.mid;
                } else if (a1ColSpan && b1ColSpan && a1 === b1) {
                    result += this.options.chars.topMid;
                } else if (a2ColSpan && b2ColSpan && a2 === b2) {
                    result += this.options.chars.bottomMid;
                } else if (a1RowSpan && a2RowSpan && a1 === a2) {
                    result += this.options.chars.leftMid;
                } else if (b1RowSpan && b2RowSpan && b1 === b2) {
                    result += this.options.chars.rightMid;
                } else {
                    result += this.options.chars.midMid;
                }
            } else if (a1Border && b1Border) {
                if (hasColSpan(a1) && hasColSpan(b1) && a1 === b1) {
                    result += this.options.chars.bottom;
                } else {
                    result += this.options.chars.bottomMid;
                }
            } else if (b1Border && b2Border) {
                if (rowSpan[colIndex] > 1) {
                    result += this.options.chars.left;
                } else {
                    result += this.options.chars.leftMid;
                }
            } else if (b2Border && a2Border) {
                if (hasColSpan(a2) && hasColSpan(b2) && a2 === b2) {
                    result += this.options.chars.top;
                } else {
                    result += this.options.chars.topMid;
                }
            } else if (a1Border && a2Border) {
                if (hasRowSpan(a1) && a1 === a2) {
                    result += this.options.chars.right;
                } else {
                    result += this.options.chars.rightMid;
                }
            } else if (a1Border) {
                result += this.options.chars.bottomRight;
            } else if (b1Border) {
                result += this.options.chars.bottomLeft;
            } else if (a2Border) {
                result += this.options.chars.topRight;
            } else if (b2Border) {
                result += this.options.chars.topLeft;
            } else {
                result += " ";
            }
        }
        const length = opts.padding[colIndex] + opts.width[colIndex] + opts.padding[colIndex];
        if (rowSpan[colIndex] > 1 && nextRow) {
            result += this.renderCell(colIndex, nextRow, opts, true);
            if (nextRow[colIndex] === nextRow[nextRow.length - 1]) {
                if (b1Border) {
                    result += this.options.chars.right;
                } else {
                    result += " ";
                }
                return result;
            }
        } else if (b1Border && b2Border) {
            result += this.options.chars.mid.repeat(length);
        } else if (b1Border) {
            result += this.options.chars.bottom.repeat(length);
        } else if (b2Border) {
            result += this.options.chars.top.repeat(length);
        } else {
            result += " ".repeat(length);
        }
        if (colIndex === opts.columns - 1) {
            if (b1Border && b2Border) {
                result += this.options.chars.rightMid;
            } else if (b1Border) {
                result += this.options.chars.bottomRight;
            } else if (b2Border) {
                result += this.options.chars.topRight;
            } else {
                result += " ";
            }
        }
        return result;
    }
}
class Table extends Array {
    static _chars = {
        ...border
    };
    options = {
        indent: 0,
        border: false,
        maxColWidth: Infinity,
        minColWidth: 0,
        padding: 1,
        chars: {
            ...Table._chars
        }
    };
    headerRow;
    static from(rows) {
        const table = new this(...rows);
        if (rows instanceof Table) {
            table.options = {
                ...rows.options
            };
            table.headerRow = rows.headerRow ? Row.from(rows.headerRow) : undefined;
        }
        return table;
    }
    static fromJson(rows) {
        return new this().fromJson(rows);
    }
    static chars(chars) {
        Object.assign(this._chars, chars);
        return this;
    }
    static render(rows) {
        Table.from(rows).render();
    }
    fromJson(rows) {
        this.header(Object.keys(rows[0]));
        this.body(rows.map((row)=>Object.values(row)
        ));
        return this;
    }
    header(header) {
        this.headerRow = header instanceof Row ? header : Row.from(header);
        return this;
    }
    body(rows) {
        this.length = 0;
        this.push(...rows);
        return this;
    }
    clone() {
        const table = new Table(...this.map((row)=>row instanceof Row ? row.clone() : Row.from(row).clone()
        ));
        table.options = {
            ...this.options
        };
        table.headerRow = this.headerRow?.clone();
        return table;
    }
    toString() {
        return new TableLayout(this, this.options).toString();
    }
    render() {
        Deno.stdout.writeSync(new TextEncoder().encode(this.toString() + "\n"));
        return this;
    }
    maxColWidth(width, override = true) {
        if (override || typeof this.options.maxColWidth === "undefined") {
            this.options.maxColWidth = width;
        }
        return this;
    }
    minColWidth(width, override = true) {
        if (override || typeof this.options.minColWidth === "undefined") {
            this.options.minColWidth = width;
        }
        return this;
    }
    indent(width, override = true) {
        if (override || typeof this.options.indent === "undefined") {
            this.options.indent = width;
        }
        return this;
    }
    padding(padding, override = true) {
        if (override || typeof this.options.padding === "undefined") {
            this.options.padding = padding;
        }
        return this;
    }
    border(enable, override = true) {
        if (override || typeof this.options.border === "undefined") {
            this.options.border = enable;
        }
        return this;
    }
    align(direction, override = true) {
        if (override || typeof this.options.align === "undefined") {
            this.options.align = direction;
        }
        return this;
    }
    chars(chars) {
        Object.assign(this.options.chars, chars);
        return this;
    }
    getHeader() {
        return this.headerRow;
    }
    getBody() {
        return [
            ...this
        ];
    }
    getMaxColWidth() {
        return this.options.maxColWidth;
    }
    getMinColWidth() {
        return this.options.minColWidth;
    }
    getIndent() {
        return this.options.indent;
    }
    getPadding() {
        return this.options.padding;
    }
    getBorder() {
        return this.options.border === true;
    }
    hasHeaderBorder() {
        const hasBorder = this.headerRow?.hasBorder();
        return hasBorder === true || this.getBorder() && hasBorder !== false;
    }
    hasBodyBorder() {
        return this.getBorder() || this.some((row)=>row instanceof Row ? row.hasBorder() : row.some((cell)=>cell instanceof Cell ? cell.getBorder : false
            )
        );
    }
    hasBorder() {
        return this.hasHeaderBorder() || this.hasBodyBorder();
    }
    getAlign() {
        return this.options.align ?? "left";
    }
}
class HelpGenerator {
    cmd;
    indent = 2;
    options;
    static generate(cmd, options) {
        return new HelpGenerator(cmd, options).generate();
    }
    constructor(cmd, options = {}){
        this.cmd = cmd;
        this.options = {
            types: false,
            hints: true,
            colors: true,
            ...options
        };
    }
    generate() {
        const areColorsEnabled = getColorEnabled();
        setColorEnabled(this.options.colors);
        const result = this.generateHeader() + this.generateDescription() + this.generateOptions() + this.generateCommands() + this.generateEnvironmentVariables() + this.generateExamples() + "\n";
        setColorEnabled(areColorsEnabled);
        return result;
    }
    generateHeader() {
        const rows = [
            [
                bold("Usage:"),
                magenta(`${this.cmd.getPath()}${this.cmd.getArgsDefinition() ? " " + this.cmd.getArgsDefinition() : ""}`), 
            ], 
        ];
        const version1 = this.cmd.getVersion();
        if (version1) {
            rows.push([
                bold("Version:"),
                yellow(`${this.cmd.getVersion()}`)
            ]);
        }
        return "\n" + Table.from(rows).indent(this.indent).padding(1).toString() + "\n";
    }
    generateDescription() {
        if (!this.cmd.getDescription()) {
            return "";
        }
        return this.label("Description") + Table.from([
            [
                this.cmd.getDescription()
            ], 
        ]).indent(this.indent * 2).maxColWidth(140).padding(1).toString() + "\n";
    }
    generateOptions() {
        const options = this.cmd.getOptions(false);
        if (!options.length) {
            return "";
        }
        const hasTypeDefinitions = !!options.find((option)=>!!option.typeDefinition
        );
        if (hasTypeDefinitions) {
            return this.label("Options") + Table.from([
                ...options.map((option)=>[
                        option.flags.map((flag)=>blue(flag)
                        ).join(", "),
                        highlightArguments(option.typeDefinition || "", this.options.types),
                        red(bold("-")) + " " + option.description.split("\n").shift(),
                        this.generateHints(option), 
                    ]
                ), 
            ]).padding([
                2,
                2,
                2
            ]).indent(this.indent * 2).maxColWidth([
                60,
                60,
                80,
                60
            ]).toString() + "\n";
        }
        return this.label("Options") + Table.from([
            ...options.map((option)=>[
                    option.flags.map((flag)=>blue(flag)
                    ).join(", "),
                    red(bold("-")) + " " + option.description.split("\n").shift(),
                    this.generateHints(option), 
                ]
            ), 
        ]).padding([
            2,
            2
        ]).indent(this.indent * 2).maxColWidth([
            60,
            80,
            60
        ]).toString() + "\n";
    }
    generateCommands() {
        const commands6 = this.cmd.getCommands(false);
        if (!commands6.length) {
            return "";
        }
        const hasTypeDefinitions = !!commands6.find((command)=>!!command.getArgsDefinition()
        );
        if (hasTypeDefinitions) {
            return this.label("Commands") + Table.from([
                ...commands6.map((command)=>[
                        [
                            command.getName(),
                            ...command.getAliases()
                        ].map((name25)=>blue(name25)
                        ).join(", "),
                        highlightArguments(command.getArgsDefinition() || "", this.options.types),
                        red(bold("-")) + " " + command.getDescription().split("\n").shift(), 
                    ]
                ), 
            ]).padding([
                2,
                2,
                2
            ]).indent(this.indent * 2).toString() + "\n";
        }
        return this.label("Commands") + Table.from([
            ...commands6.map((command)=>[
                    [
                        command.getName(),
                        ...command.getAliases()
                    ].map((name26)=>blue(name26)
                    ).join(", "),
                    red(bold("-")) + " " + command.getDescription().split("\n").shift(), 
                ]
            ), 
        ]).padding([
            2,
            2
        ]).indent(this.indent * 2).toString() + "\n";
    }
    generateEnvironmentVariables() {
        const envVars = this.cmd.getEnvVars(false);
        if (!envVars.length) {
            return "";
        }
        return this.label("Environment variables") + Table.from([
            ...envVars.map((envVar)=>[
                    envVar.names.map((name27)=>blue(name27)
                    ).join(", "),
                    highlightArgumentDetails(envVar.details, this.options.types),
                    `${red(bold("-"))} ${envVar.description}`, 
                ]
            ), 
        ]).padding(2).indent(this.indent * 2).toString() + "\n";
    }
    generateExamples() {
        const examples = this.cmd.getExamples();
        if (!examples.length) {
            return "";
        }
        return this.label("Examples") + Table.from(examples.map((example)=>[
                dim(bold(`${capitalize(example.name)}:`)),
                example.description, 
            ]
        )).padding(1).indent(this.indent * 2).maxColWidth(150).toString() + "\n";
    }
    generateHints(option) {
        if (!this.options.hints) {
            return "";
        }
        const hints = [];
        option.required && hints.push(yellow(`required`));
        typeof option.default !== "undefined" && hints.push(bold(`Default: `) + inspect(option.default, this.options.colors));
        option.depends?.length && hints.push(yellow(bold(`Depends: `)) + italic(option.depends.map(getFlag).join(", ")));
        option.conflicts?.length && hints.push(red(bold(`Conflicts: `)) + italic(option.conflicts.map(getFlag).join(", ")));
        const type14 = this.cmd.getType(option.args[0]?.type)?.handler;
        if (type14 instanceof Type) {
            const possibleValues = type14.values?.(this.cmd, this.cmd.getParent());
            if (possibleValues?.length) {
                hints.push(bold(`Values: `) + possibleValues.map((value)=>inspect(value, this.options.colors)
                ).join(", "));
            }
        }
        if (hints.length) {
            return `(${hints.join(", ")})`;
        }
        return "";
    }
    label(label) {
        return "\n" + " ".repeat(this.indent) + bold(`${label}:`) + "\n\n";
    }
}
function capitalize(string2) {
    return (string2?.charAt(0).toUpperCase() + string2.slice(1)) ?? "";
}
function inspect(value, colors) {
    return Deno.inspect(value, {
        depth: 1,
        colors,
        trailingComma: false
    });
}
function highlightArguments(argsDefinition, types6 = true) {
    if (!argsDefinition) {
        return "";
    }
    return parseArgumentsDefinition(argsDefinition).map((arg)=>highlightArgumentDetails(arg, types6)
    ).join(" ");
}
function highlightArgumentDetails(arg, types7 = true) {
    let str50 = "";
    str50 += yellow(arg.optionalValue ? "[" : "<");
    let name28 = "";
    name28 += arg.name;
    if (arg.variadic) {
        name28 += "...";
    }
    name28 = magenta(name28);
    str50 += name28;
    if (types7) {
        str50 += yellow(":");
        str50 += red(arg.type);
    }
    if (arg.list) {
        str50 += green("[]");
    }
    str50 += yellow(arg.optionalValue ? "]" : ">");
    return str50;
}
class IntegerType extends Type {
    parse(type15) {
        return integer(type15);
    }
}
class Command {
    types = new Map();
    rawArgs = [];
    literalArgs = [];
    _name = "COMMAND";
    _parent;
    _globalParent;
    ver;
    desc = "";
    fn;
    options = [];
    commands = new Map();
    examples = [];
    envVars = [];
    aliases = [];
    completions = new Map();
    cmd = this;
    argsDefinition;
    isExecutable = false;
    throwOnError = false;
    _allowEmpty = true;
    _stopEarly = false;
    defaultCommand;
    _useRawArgs = false;
    args = [];
    isHidden = false;
    isGlobal = false;
    hasDefaults = false;
    _versionOption;
    _helpOption;
    _help;
    versionOption(flags, desc, opts) {
        this._versionOption = flags === false ? flags : {
            flags,
            desc,
            opts: typeof opts === "function" ? {
                action: opts
            } : opts
        };
        return this;
    }
    helpOption(flags, desc, opts) {
        this._helpOption = flags === false ? flags : {
            flags,
            desc,
            opts: typeof opts === "function" ? {
                action: opts
            } : opts
        };
        return this;
    }
    command(nameAndArguments, cmdOrDescription, override) {
        const result = splitArguments(nameAndArguments);
        const name29 = result.flags.shift();
        const aliases = result.flags;
        if (!name29) {
            throw new MissingCommandName();
        }
        if (this.getBaseCommand(name29, true)) {
            if (!override) {
                throw new DuplicateCommandName(name29);
            }
            this.removeCommand(name29);
        }
        let description1;
        let cmd;
        if (typeof cmdOrDescription === "string") {
            description1 = cmdOrDescription;
        }
        if (cmdOrDescription instanceof Command) {
            cmd = cmdOrDescription.reset();
        } else {
            cmd = new Command();
        }
        cmd._name = name29;
        cmd._parent = this;
        if (description1) {
            cmd.description(description1);
        }
        if (result.typeDefinition) {
            cmd.arguments(result.typeDefinition);
        }
        aliases.forEach((alias)=>cmd.alias(alias)
        );
        this.commands.set(name29, cmd);
        this.select(name29);
        return this;
    }
    alias(alias) {
        if (this.cmd._name === alias || this.cmd.aliases.includes(alias)) {
            throw new DuplicateCommandAlias(alias);
        }
        this.cmd.aliases.push(alias);
        return this;
    }
    reset() {
        this.cmd = this;
        return this;
    }
    select(name30) {
        const cmd = this.getBaseCommand(name30, true);
        if (!cmd) {
            throw new CommandNotFound(name30, this.getBaseCommands(true));
        }
        this.cmd = cmd;
        return this;
    }
    name(name31) {
        this.cmd._name = name31;
        return this;
    }
    version(version2) {
        if (typeof version2 === "string") {
            this.cmd.ver = ()=>version2
            ;
        } else if (typeof version2 === "function") {
            this.cmd.ver = version2;
        }
        return this;
    }
    help(help) {
        if (typeof help === "string") {
            this.cmd._help = ()=>help
            ;
        } else if (typeof help === "function") {
            this.cmd._help = help;
        } else {
            this.cmd._help = (cmd)=>HelpGenerator.generate(cmd, help)
            ;
        }
        return this;
    }
    description(description2) {
        this.cmd.desc = description2;
        return this;
    }
    hidden() {
        this.cmd.isHidden = true;
        return this;
    }
    global() {
        this.cmd.isGlobal = true;
        return this;
    }
    executable() {
        this.cmd.isExecutable = true;
        return this;
    }
    arguments(args) {
        this.cmd.argsDefinition = args;
        return this;
    }
    action(fn) {
        this.cmd.fn = fn;
        return this;
    }
    allowEmpty(allowEmpty = true) {
        this.cmd._allowEmpty = allowEmpty;
        return this;
    }
    stopEarly(stopEarly = true) {
        this.cmd._stopEarly = stopEarly;
        return this;
    }
    useRawArgs(useRawArgs = true) {
        this.cmd._useRawArgs = useRawArgs;
        return this;
    }
    default(name32) {
        this.cmd.defaultCommand = name32;
        return this;
    }
    globalType(name33, type16, options) {
        return this.type(name33, type16, {
            ...options,
            global: true
        });
    }
    type(name34, handler, options) {
        if (this.cmd.types.get(name34) && !options?.override) {
            throw new DuplicateType(name34);
        }
        this.cmd.types.set(name34, {
            ...options,
            name: name34,
            handler
        });
        if (handler instanceof Type && (typeof handler.complete !== "undefined" || typeof handler.values !== "undefined")) {
            const completeHandler = (cmd, parent)=>handler.complete?.(cmd, parent) || []
            ;
            this.complete(name34, completeHandler, options);
        }
        return this;
    }
    globalComplete(name35, complete, options) {
        return this.complete(name35, complete, {
            ...options,
            global: true
        });
    }
    complete(name36, complete, options) {
        if (this.cmd.completions.has(name36) && !options?.override) {
            throw new DuplicateCompletion(name36);
        }
        this.cmd.completions.set(name36, {
            name: name36,
            complete,
            ...options
        });
        return this;
    }
    throwErrors() {
        this.cmd.throwOnError = true;
        return this;
    }
    shouldThrowErrors() {
        return this.cmd.throwOnError || !!this.cmd._parent?.shouldThrowErrors();
    }
    globalOption(flags, desc, opts) {
        if (typeof opts === "function") {
            return this.option(flags, desc, {
                value: opts,
                global: true
            });
        }
        return this.option(flags, desc, {
            ...opts,
            global: true
        });
    }
    option(flags, desc, opts) {
        if (typeof opts === "function") {
            return this.option(flags, desc, {
                value: opts
            });
        }
        const result = splitArguments(flags);
        const args = result.typeDefinition ? parseArgumentsDefinition(result.typeDefinition) : [];
        const option = {
            ...opts,
            name: "",
            description: desc,
            args,
            flags: result.flags,
            typeDefinition: result.typeDefinition
        };
        if (option.separator) {
            for (const arg of args){
                if (arg.list) {
                    arg.separator = option.separator;
                }
            }
        }
        for (const part of option.flags){
            const arg = part.trim();
            const isLong = /^--/.test(arg);
            const name37 = isLong ? arg.slice(2) : arg.slice(1);
            if (this.cmd.getBaseOption(name37, true)) {
                if (opts?.override) {
                    this.removeOption(name37);
                } else {
                    throw new DuplicateOptionName(name37);
                }
            }
            if (!option.name && isLong) {
                option.name = name37;
            } else if (!option.aliases) {
                option.aliases = [
                    name37
                ];
            } else {
                option.aliases.push(name37);
            }
        }
        if (option.prepend) {
            this.cmd.options.unshift(option);
        } else {
            this.cmd.options.push(option);
        }
        return this;
    }
    example(name38, description3) {
        if (this.cmd.hasExample(name38)) {
            throw new DuplicateExample(name38);
        }
        this.cmd.examples.push({
            name: name38,
            description: description3
        });
        return this;
    }
    globalEnv(name39, description4, options) {
        return this.env(name39, description4, {
            ...options,
            global: true
        });
    }
    env(name40, description5, options) {
        const result = splitArguments(name40);
        if (!result.typeDefinition) {
            result.typeDefinition = "<value:boolean>";
        }
        if (result.flags.some((envName)=>this.cmd.getBaseEnvVar(envName, true)
        )) {
            throw new DuplicateEnvironmentVariable(name40);
        }
        const details = parseArgumentsDefinition(result.typeDefinition);
        if (details.length > 1) {
            throw new EnvironmentVariableSingleValue(name40);
        } else if (details.length && details[0].optionalValue) {
            throw new EnvironmentVariableOptionalValue(name40);
        } else if (details.length && details[0].variadic) {
            throw new EnvironmentVariableVariadicValue(name40);
        }
        this.cmd.envVars.push({
            name: result.flags[0],
            names: result.flags,
            description: description5,
            type: details[0].type,
            details: details.shift(),
            ...options
        });
        return this;
    }
    async parse(args = Deno.args, dry) {
        try {
            this.reset();
            this.registerDefaults();
            this.rawArgs = args;
            const subCommand = args.length > 0 && this.getCommand(args[0], true);
            if (subCommand) {
                subCommand._globalParent = this;
                return await subCommand.parse(this.rawArgs.slice(1), dry);
            }
            const result = {
                options: {},
                args: this.rawArgs,
                cmd: this,
                literal: this.literalArgs
            };
            if (this.isExecutable) {
                if (!dry) {
                    await this.executeExecutable(this.rawArgs);
                }
                return result;
            } else if (this._useRawArgs) {
                if (dry) {
                    return result;
                }
                return await this.execute({}, ...this.rawArgs);
            } else {
                const { action , flags , unknown , literal: literal2  } = this.parseFlags(this.rawArgs);
                this.literalArgs = literal2;
                const params = this.parseArguments(unknown, flags);
                await this.validateEnvVars();
                if (dry || action) {
                    if (action) {
                        await action.call(this, flags, ...params);
                    }
                    return {
                        options: flags,
                        args: params,
                        cmd: this,
                        literal: this.literalArgs
                    };
                }
                return await this.execute(flags, ...params);
            }
        } catch (error1) {
            throw this.error(error1);
        }
    }
    registerDefaults() {
        if (this.hasDefaults || this.getParent()) {
            return this;
        }
        this.hasDefaults = true;
        this.reset();
        !this.types.has("string") && this.type("string", new StringType(), {
            global: true
        });
        !this.types.has("number") && this.type("number", new NumberType(), {
            global: true
        });
        !this.types.has("integer") && this.type("integer", new IntegerType(), {
            global: true
        });
        !this.types.has("boolean") && this.type("boolean", new BooleanType(), {
            global: true
        });
        if (!this._help) {
            this.help({
                hints: true,
                types: false
            });
        }
        if (this._versionOption !== false && (this._versionOption || this.ver)) {
            this.option(this._versionOption?.flags || "-V, --version", this._versionOption?.desc || "Show the version number for this program.", {
                standalone: true,
                prepend: true,
                action: function() {
                    this.showVersion();
                    Deno.exit(0);
                },
                ...this._versionOption?.opts ?? {}
            });
        }
        if (this._helpOption !== false) {
            this.option(this._helpOption?.flags || "-h, --help", this._helpOption?.desc || "Show this help.", {
                standalone: true,
                global: true,
                prepend: true,
                action: function() {
                    this.showHelp();
                    Deno.exit(0);
                },
                ...this._helpOption?.opts ?? {}
            });
        }
        return this;
    }
    async execute(options, ...args) {
        if (this.fn) {
            await this.fn(options, ...args);
        } else if (this.defaultCommand) {
            const cmd = this.getCommand(this.defaultCommand, true);
            if (!cmd) {
                throw new DefaultCommandNotFound(this.defaultCommand, this.getCommands());
            }
            cmd._globalParent = this;
            await cmd.execute(options, ...args);
        }
        return {
            options,
            args,
            cmd: this,
            literal: this.literalArgs
        };
    }
    async executeExecutable(args) {
        const permissions = await getPermissions();
        if (!permissions.read) {
            await Deno.permissions?.request({
                name: "read"
            });
        }
        if (!permissions.run) {
            await Deno.permissions?.request({
                name: "run"
            });
        }
        const [main1, ...names] = this.getPath().split(" ");
        names.unshift(main1.replace(/\.ts$/, ""));
        const executableName = names.join("-");
        const files = [];
        const parts = Deno.mainModule.replace(/^file:\/\//g, "").split("/");
        if (Deno.build.os === "windows" && parts[0] === "") {
            parts.shift();
        }
        parts.pop();
        const path2 = parts.join("/");
        files.push(path2 + "/" + executableName, path2 + "/" + executableName + ".ts");
        files.push(executableName, executableName + ".ts");
        const denoOpts = [];
        if (isUnstable()) {
            denoOpts.push("--unstable");
        }
        denoOpts.push("--allow-read", "--allow-run");
        Object.keys(permissions).forEach((name41)=>{
            if (name41 === "read" || name41 === "run") {
                return;
            }
            if (permissions[name41]) {
                denoOpts.push(`--allow-${name41}`);
            }
        });
        for (const file of files){
            try {
                Deno.lstatSync(file);
            } catch (error2) {
                if (error2 instanceof Deno.errors.NotFound) {
                    continue;
                }
                throw error2;
            }
            const cmd = [
                "deno",
                "run",
                ...denoOpts,
                file,
                ...args
            ];
            const process = Deno.run({
                cmd: cmd
            });
            const status = await process.status();
            if (!status.success) {
                Deno.exit(status.code);
            }
            return;
        }
        throw new CommandExecutableNotFound(executableName, files);
    }
    parseFlags(args) {
        try {
            let action;
            const result = parseFlags(args, {
                stopEarly: this._stopEarly,
                allowEmpty: this._allowEmpty,
                flags: this.getOptions(true),
                parse: (type17)=>this.parseType(type17)
                ,
                option: (option)=>{
                    if (!action && option.action) {
                        action = option.action;
                    }
                }
            });
            return {
                ...result,
                action
            };
        } catch (error3) {
            if (error3 instanceof ValidationError) {
                throw new ValidationError1(error3.message);
            }
            throw error3;
        }
    }
    parseType(type1) {
        const typeSettings = this.getType(type1.type);
        if (!typeSettings) {
            throw new UnknownType(type1.type, this.getTypes().map((type18)=>type18.name
            ));
        }
        return typeSettings.handler instanceof Type ? typeSettings.handler.parse(type1) : typeSettings.handler(type1);
    }
    async validateEnvVars() {
        if (!await hasPermission("env")) {
            return;
        }
        const envVars = this.getEnvVars(true);
        if (!envVars.length) {
            return;
        }
        envVars.forEach((env)=>{
            const name1 = env.names.find((name42)=>!!Deno.env.get(name42)
            );
            if (name1) {
                this.parseType({
                    label: "Environment variable",
                    type: env.type,
                    name: name1,
                    value: Deno.env.get(name1) ?? ""
                });
            }
        });
    }
    parseArguments(args, flags) {
        const params = [];
        args = args.slice(0);
        if (!this.hasArguments()) {
            if (args.length) {
                if (this.hasCommands(true)) {
                    throw new UnknownCommand(args[0], this.getCommands());
                } else {
                    throw new NoArgumentsAllowed(this.getPath());
                }
            }
        } else {
            if (!args.length) {
                const required1 = this.getArguments().filter((expectedArg)=>!expectedArg.optionalValue
                ).map((expectedArg)=>expectedArg.name
                );
                if (required1.length) {
                    const flagNames = Object.keys(flags);
                    const hasStandaloneOption = !!flagNames.find((name43)=>this.getOption(name43, true)?.standalone
                    );
                    if (!hasStandaloneOption) {
                        throw new MissingArguments(required1);
                    }
                }
            } else {
                for (const expectedArg of this.getArguments()){
                    if (!args.length) {
                        if (expectedArg.optionalValue) {
                            break;
                        }
                        throw new MissingArgument(`Missing argument: ${expectedArg.name}`);
                    }
                    let arg;
                    if (expectedArg.variadic) {
                        arg = args.splice(0, args.length).map((value)=>this.parseType({
                                label: "Argument",
                                type: expectedArg.type,
                                name: expectedArg.name,
                                value
                            })
                        );
                    } else {
                        arg = this.parseType({
                            label: "Argument",
                            type: expectedArg.type,
                            name: expectedArg.name,
                            value: args.shift()
                        });
                    }
                    if (arg) {
                        params.push(arg);
                    }
                }
                if (args.length) {
                    throw new TooManyArguments(args);
                }
            }
        }
        return params;
    }
    error(error4) {
        if (this.shouldThrowErrors() || !(error4 instanceof ValidationError1)) {
            return error4;
        }
        this.showHelp();
        Deno.stderr.writeSync(new TextEncoder().encode(red(`  ${bold("error")}: ${error4.message}\n`) + "\n"));
        Deno.exit(error4 instanceof ValidationError1 ? error4.exitCode : 1);
    }
    getName() {
        return this._name;
    }
    getParent() {
        return this._parent;
    }
    getGlobalParent() {
        return this._globalParent;
    }
    getMainCommand() {
        return this._parent?.getMainCommand() ?? this;
    }
    getAliases() {
        return this.aliases;
    }
    getPath() {
        return this._parent ? this._parent.getPath() + " " + this._name : this._name;
    }
    getArgsDefinition() {
        return this.argsDefinition;
    }
    getArgument(name44) {
        return this.getArguments().find((arg)=>arg.name === name44
        );
    }
    getArguments() {
        if (!this.args.length && this.argsDefinition) {
            this.args = parseArgumentsDefinition(this.argsDefinition);
        }
        return this.args;
    }
    hasArguments() {
        return !!this.argsDefinition;
    }
    getVersion() {
        return this.getVersionHandler()?.call(this, this);
    }
    getVersionHandler() {
        return this.ver ?? this._parent?.getVersionHandler();
    }
    getDescription() {
        return typeof this.desc === "function" ? this.desc = this.desc() : this.desc;
    }
    getShortDescription() {
        return this.getDescription().trim().split("\n").shift();
    }
    getRawArgs() {
        return this.rawArgs;
    }
    getLiteralArgs() {
        return this.literalArgs;
    }
    showVersion() {
        Deno.stdout.writeSync(new TextEncoder().encode(this.getVersion()));
    }
    showHelp() {
        Deno.stdout.writeSync(new TextEncoder().encode(this.getHelp()));
    }
    getHelp() {
        this.registerDefaults();
        return this.getHelpHandler().call(this, this);
    }
    getHelpHandler() {
        return this._help ?? this._parent?.getHelpHandler();
    }
    hasOptions(hidden1) {
        return this.getOptions(hidden1).length > 0;
    }
    getOptions(hidden2) {
        return this.getGlobalOptions(hidden2).concat(this.getBaseOptions(hidden2));
    }
    getBaseOptions(hidden3) {
        if (!this.options.length) {
            return [];
        }
        return hidden3 ? this.options.slice(0) : this.options.filter((opt)=>!opt.hidden
        );
    }
    getGlobalOptions(hidden4) {
        const getOptions1 = (cmd, options = [], names = [])=>{
            if (cmd) {
                if (cmd.options.length) {
                    cmd.options.forEach((option)=>{
                        if (option.global && !this.options.find((opt)=>opt.name === option.name
                        ) && names.indexOf(option.name) === -1 && (hidden4 || !option.hidden)) {
                            names.push(option.name);
                            options.push(option);
                        }
                    });
                }
                return getOptions1(cmd._parent, options, names);
            }
            return options;
        };
        return getOptions1(this._parent);
    }
    hasOption(name45, hidden5) {
        return !!this.getOption(name45, hidden5);
    }
    getOption(name46, hidden6) {
        return this.getBaseOption(name46, hidden6) ?? this.getGlobalOption(name46, hidden6);
    }
    getBaseOption(name47, hidden7) {
        const option1 = this.options.find((option)=>option.name === name47
        );
        return option1 && (hidden7 || !option1.hidden) ? option1 : undefined;
    }
    getGlobalOption(name48, hidden8) {
        if (!this._parent) {
            return;
        }
        const option = this._parent.getBaseOption(name48, hidden8);
        if (!option || !option.global) {
            return this._parent.getGlobalOption(name48, hidden8);
        }
        return option;
    }
    removeOption(name49) {
        const index = this.options.findIndex((option)=>option.name === name49
        );
        if (index === -1) {
            return;
        }
        return this.options.splice(index, 1)[0];
    }
    hasCommands(hidden9) {
        return this.getCommands(hidden9).length > 0;
    }
    getCommands(hidden10) {
        return this.getGlobalCommands(hidden10).concat(this.getBaseCommands(hidden10));
    }
    getBaseCommands(hidden11) {
        const commands7 = Array.from(this.commands.values());
        return hidden11 ? commands7 : commands7.filter((cmd)=>!cmd.isHidden
        );
    }
    getGlobalCommands(hidden12) {
        const getCommands = (cmd1, commands8 = [], names = [])=>{
            if (cmd1) {
                if (cmd1.commands.size) {
                    cmd1.commands.forEach((cmd)=>{
                        if (cmd.isGlobal && this !== cmd && !this.commands.has(cmd._name) && names.indexOf(cmd._name) === -1 && (hidden12 || !cmd.isHidden)) {
                            names.push(cmd._name);
                            commands8.push(cmd);
                        }
                    });
                }
                return getCommands(cmd1._parent, commands8, names);
            }
            return commands8;
        };
        return getCommands(this._parent);
    }
    hasCommand(name50, hidden13) {
        return !!this.getCommand(name50, hidden13);
    }
    getCommand(name51, hidden14) {
        return this.getBaseCommand(name51, hidden14) ?? this.getGlobalCommand(name51, hidden14);
    }
    getBaseCommand(name52, hidden15) {
        for (const cmd of this.commands.values()){
            if (cmd._name === name52 || cmd.aliases.includes(name52)) {
                return cmd && (hidden15 || !cmd.isHidden) ? cmd : undefined;
            }
        }
    }
    getGlobalCommand(name53, hidden16) {
        if (!this._parent) {
            return;
        }
        const cmd = this._parent.getBaseCommand(name53, hidden16);
        if (!cmd?.isGlobal) {
            return this._parent.getGlobalCommand(name53, hidden16);
        }
        return cmd;
    }
    removeCommand(name54) {
        const command = this.getBaseCommand(name54, true);
        if (command) {
            this.commands.delete(command._name);
        }
        return command;
    }
    getTypes() {
        return this.getGlobalTypes().concat(this.getBaseTypes());
    }
    getBaseTypes() {
        return Array.from(this.types.values());
    }
    getGlobalTypes() {
        const getTypes = (cmd, types8 = [], names = [])=>{
            if (cmd) {
                if (cmd.types.size) {
                    cmd.types.forEach((type19)=>{
                        if (type19.global && !this.types.has(type19.name) && names.indexOf(type19.name) === -1) {
                            names.push(type19.name);
                            types8.push(type19);
                        }
                    });
                }
                return getTypes(cmd._parent, types8, names);
            }
            return types8;
        };
        return getTypes(this._parent);
    }
    getType(name55) {
        return this.getBaseType(name55) ?? this.getGlobalType(name55);
    }
    getBaseType(name56) {
        return this.types.get(name56);
    }
    getGlobalType(name57) {
        if (!this._parent) {
            return;
        }
        const cmd = this._parent.getBaseType(name57);
        if (!cmd?.global) {
            return this._parent.getGlobalType(name57);
        }
        return cmd;
    }
    getCompletions() {
        return this.getGlobalCompletions().concat(this.getBaseCompletions());
    }
    getBaseCompletions() {
        return Array.from(this.completions.values());
    }
    getGlobalCompletions() {
        const getCompletions = (cmd, completions = [], names = [])=>{
            if (cmd) {
                if (cmd.completions.size) {
                    cmd.completions.forEach((completion)=>{
                        if (completion.global && !this.completions.has(completion.name) && names.indexOf(completion.name) === -1) {
                            names.push(completion.name);
                            completions.push(completion);
                        }
                    });
                }
                return getCompletions(cmd._parent, completions, names);
            }
            return completions;
        };
        return getCompletions(this._parent);
    }
    getCompletion(name58) {
        return this.getBaseCompletion(name58) ?? this.getGlobalCompletion(name58);
    }
    getBaseCompletion(name59) {
        return this.completions.get(name59);
    }
    getGlobalCompletion(name60) {
        if (!this._parent) {
            return;
        }
        const completion = this._parent.getBaseCompletion(name60);
        if (!completion?.global) {
            return this._parent.getGlobalCompletion(name60);
        }
        return completion;
    }
    hasEnvVars(hidden17) {
        return this.getEnvVars(hidden17).length > 0;
    }
    getEnvVars(hidden18) {
        return this.getGlobalEnvVars(hidden18).concat(this.getBaseEnvVars(hidden18));
    }
    getBaseEnvVars(hidden19) {
        if (!this.envVars.length) {
            return [];
        }
        return hidden19 ? this.envVars.slice(0) : this.envVars.filter((env)=>!env.hidden
        );
    }
    getGlobalEnvVars(hidden20) {
        const getEnvVars = (cmd, envVars = [], names = [])=>{
            if (cmd) {
                if (cmd.envVars.length) {
                    cmd.envVars.forEach((envVar)=>{
                        if (envVar.global && !this.envVars.find((env)=>env.names[0] === envVar.names[0]
                        ) && names.indexOf(envVar.names[0]) === -1 && (hidden20 || !envVar.hidden)) {
                            names.push(envVar.names[0]);
                            envVars.push(envVar);
                        }
                    });
                }
                return getEnvVars(cmd._parent, envVars, names);
            }
            return envVars;
        };
        return getEnvVars(this._parent);
    }
    hasEnvVar(name61, hidden21) {
        return !!this.getEnvVar(name61, hidden21);
    }
    getEnvVar(name62, hidden22) {
        return this.getBaseEnvVar(name62, hidden22) ?? this.getGlobalEnvVar(name62, hidden22);
    }
    getBaseEnvVar(name63, hidden23) {
        const envVar = this.envVars.find((env)=>env.names.indexOf(name63) !== -1
        );
        return envVar && (hidden23 || !envVar.hidden) ? envVar : undefined;
    }
    getGlobalEnvVar(name64, hidden24) {
        if (!this._parent) {
            return;
        }
        const envVar = this._parent.getBaseEnvVar(name64, hidden24);
        if (!envVar?.global) {
            return this._parent.getGlobalEnvVar(name64, hidden24);
        }
        return envVar;
    }
    hasExamples() {
        return this.examples.length > 0;
    }
    getExamples() {
        return this.examples;
    }
    hasExample(name65) {
        return !!this.getExample(name65);
    }
    getExample(name66) {
        return this.examples.find((example)=>example.name === name66
        );
    }
}
class BashCompletionsGenerator {
    cmd;
    static generate(cmd) {
        return new BashCompletionsGenerator(cmd).generate();
    }
    constructor(cmd){
        this.cmd = cmd;
    }
    generate() {
        const path3 = this.cmd.getPath();
        const version3 = this.cmd.getVersion() ? ` v${this.cmd.getVersion()}` : "";
        return `#!/usr/bin/env bash
# bash completion support for ${path3}${version3}

_${replaceSpecialChars(path3)}() {
  local word cur prev
  local -a opts
  COMPREPLY=()
  cur="\${COMP_WORDS[COMP_CWORD]}"
  prev="\${COMP_WORDS[COMP_CWORD-1]}"
  cmd="_"
  opts=()

  _${replaceSpecialChars(this.cmd.getName())}_complete() {
    local action="$1"; shift
    mapfile -t values < <( ${this.cmd.getName()} completions complete "\${action}" "\${@}" )
    for i in "\${values[@]}"; do
      opts+=("$i")
    done
  }

  ${this.generateCompletions(this.cmd).trim()}

  for word in "\${COMP_WORDS[@]}"; do
    case "\${word}" in
      -*) ;;
      *)
        cmd_tmp="\${cmd}_\${word//[^[:alnum:]]/_}"
        if type "\${cmd_tmp}" &>/dev/null; then
          cmd="\${cmd_tmp}"
        fi
    esac
  done

  \${cmd}

  if [[ \${#opts[@]} -eq 0 ]]; then
    # shellcheck disable=SC2207
    COMPREPLY=($(compgen -f "\${cur}"))
    return 0
  fi

  local values
  values="$( printf "\\n%s" "\${opts[@]}" )"
  local IFS=$'\\n'
  # shellcheck disable=SC2207
  local result=($(compgen -W "\${values[@]}" -- "\${cur}"))
  if [[ \${#result[@]} -eq 0 ]]; then
    # shellcheck disable=SC2207
    COMPREPLY=($(compgen -f "\${cur}"))
  else
    # shellcheck disable=SC2207
    COMPREPLY=($(printf '%q\\n' "\${result[@]}"))
  fi

  return 0
}

complete -F _${replaceSpecialChars(path3)} -o bashdefault -o default ${path3}
`;
    }
    generateCompletions(command, path4 = "", index = 1) {
        path4 = (path4 ? path4 + " " : "") + command.getName();
        const commandCompletions = this.generateCommandCompletions(command, path4, index);
        const childCommandCompletions = command.getCommands(false).filter((subCommand)=>subCommand !== command
        ).map((subCommand)=>this.generateCompletions(subCommand, path4, index + 1)
        ).join("");
        return `${commandCompletions}

${childCommandCompletions}`;
    }
    generateCommandCompletions(command, path5, index) {
        const flags = this.getFlags(command);
        const childCommandNames = command.getCommands(false).map((childCommand)=>childCommand.getName()
        );
        const completionsPath = ~path5.indexOf(" ") ? " " + path5.split(" ").slice(1).join(" ") : "";
        const optionArguments = this.generateOptionArguments(command, completionsPath);
        const completionsCmd = this.generateCommandCompletionsCommand(command.getArguments(), completionsPath);
        return `  __${replaceSpecialChars(path5)}() {
    opts=(${[
            ...flags,
            ...childCommandNames
        ].join(" ")})
    ${completionsCmd}
    if [[ \${cur} == -* || \${COMP_CWORD} -eq ${index} ]] ; then
      return 0
    fi
    ${optionArguments}
  }`;
    }
    getFlags(command) {
        return command.getOptions(false).map((option)=>option.flags
        ).flat();
    }
    generateOptionArguments(command, completionsPath) {
        let opts = "";
        const options = command.getOptions(false);
        if (options.length) {
            opts += 'case "${prev}" in';
            for (const option of options){
                const flags = option.flags.map((flag)=>flag.trim()
                ).join("|");
                const completionsCmd = this.generateOptionCompletionsCommand(option.args, completionsPath, {
                    standalone: option.standalone
                });
                opts += `\n      ${flags}) ${completionsCmd} ;;`;
            }
            opts += "\n    esac";
        }
        return opts;
    }
    generateCommandCompletionsCommand(args, path6) {
        if (args.length) {
            return `_${replaceSpecialChars(this.cmd.getName())}_complete ${args[0].action}${path6}`;
        }
        return "";
    }
    generateOptionCompletionsCommand(args, path7, opts) {
        if (args.length) {
            return `opts=(); _${replaceSpecialChars(this.cmd.getName())}_complete ${args[0].action}${path7}`;
        }
        if (opts?.standalone) {
            return "opts=()";
        }
        return "";
    }
}
function replaceSpecialChars(str51) {
    return str51.replace(/[^a-zA-Z0-9]/g, "_");
}
class BashCompletionsCommand extends Command {
    #cmd;
    constructor(cmd){
        super();
        this.#cmd = cmd;
        this.description(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            return `Generate shell completions for bash.

To enable bash completions for this program add following line to your ${dim(italic("~/.bashrc"))}:

    ${dim(italic(`source <(${baseCmd.getPath()} completions bash)`))}`;
        }).action(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            Deno.stdout.writeSync(new TextEncoder().encode(BashCompletionsGenerator.generate(baseCmd)));
        });
    }
}
class CompleteCommand extends Command {
    constructor(cmd1){
        super();
        this.description("Get completions for given action from given command.").arguments("<action:string> [command...:string]").action(async (_, action, commandNames)=>{
            let parent;
            const completeCommand = commandNames?.reduce((cmd, name67)=>{
                parent = cmd;
                const childCmd = cmd.getCommand(name67, false);
                if (!childCmd) {
                    throw new UnknownCompletionCommand(name67, cmd.getCommands());
                }
                return childCmd;
            }, cmd1 || this.getMainCommand()) ?? (cmd1 || this.getMainCommand());
            const completion = completeCommand.getCompletion(action);
            const result = await completion?.complete(completeCommand, parent) ?? [];
            if (result?.length) {
                Deno.stdout.writeSync(new TextEncoder().encode(result.join("\n")));
            }
        }).reset();
    }
}
class FishCompletionsGenerator {
    cmd;
    static generate(cmd) {
        return new FishCompletionsGenerator(cmd).generate();
    }
    constructor(cmd){
        this.cmd = cmd;
    }
    generate() {
        const path8 = this.cmd.getPath();
        const version4 = this.cmd.getVersion() ? ` v${this.cmd.getVersion()}` : "";
        return `#!/usr/bin/env fish
# fish completion support for ${path8}${version4}

function __fish_${replaceSpecialChars1(this.cmd.getName())}_using_command
  set cmds ${getCommandFnNames(this.cmd).join(" ")}
  set words (commandline -opc)
  set cmd "_"
  for word in $words
    switch $word
      case '-*'
        continue
      case '*'
        set word (string replace -r -a '\\W' '_' $word)
        set cmd_tmp $cmd"_$word"
        if contains $cmd_tmp $cmds
          set cmd $cmd_tmp
        end
    end
  end
  if [ "$cmd" = "$argv[1]" ]
    return 0
  end
  return 1
end

${this.generateCompletions(this.cmd).trim()}
`;
    }
    generateCompletions(command) {
        const parent = command.getParent();
        let result = ``;
        if (parent) {
            result += "\n" + this.complete(parent, {
                description: command.getShortDescription(),
                arguments: command.getName()
            });
        }
        const commandArgs = command.getArguments();
        if (commandArgs.length) {
            result += "\n" + this.complete(command, {
                arguments: commandArgs.length ? this.getCompletionCommand(commandArgs[0].action + " " + getCompletionsPath(command)) : undefined
            });
        }
        for (const option of command.getOptions(false)){
            result += "\n" + this.completeOption(command, option);
        }
        for (const subCommand of command.getCommands(false)){
            result += this.generateCompletions(subCommand);
        }
        return result;
    }
    completeOption(command, option) {
        const shortOption = option.flags.find((flag)=>flag.length === 2
        )?.replace(/^(-)+/, "");
        const longOption = option.flags.find((flag)=>flag.length > 2
        )?.replace(/^(-)+/, "");
        return this.complete(command, {
            description: option.description,
            shortOption: shortOption,
            longOption: longOption,
            required: true,
            standalone: option.standalone,
            arguments: option.args.length ? this.getCompletionCommand(option.args[0].action + " " + getCompletionsPath(command)) : undefined
        });
    }
    complete(command, options) {
        const cmd = [
            "complete"
        ];
        cmd.push("-c", this.cmd.getName());
        cmd.push("-n", `'__fish_${replaceSpecialChars1(this.cmd.getName())}_using_command __${replaceSpecialChars1(command.getPath())}'`);
        options.shortOption && cmd.push("-s", options.shortOption);
        options.longOption && cmd.push("-l", options.longOption);
        options.standalone && cmd.push("-x");
        cmd.push("-k");
        cmd.push("-f");
        if (options.arguments) {
            options.required && cmd.push("-r");
            cmd.push("-a", options.arguments);
        }
        options.description && cmd.push("-d", `'${options.description}'`);
        return cmd.join(" ");
    }
    getCompletionCommand(cmd) {
        return `'(${this.cmd.getName()} completions complete ${cmd.trim()})'`;
    }
}
function getCommandFnNames(cmd, cmds = []) {
    cmds.push(`__${replaceSpecialChars1(cmd.getPath())}`);
    cmd.getCommands(false).forEach((command)=>{
        getCommandFnNames(command, cmds);
    });
    return cmds;
}
function getCompletionsPath(command) {
    return command.getPath().split(" ").slice(1).join(" ");
}
function replaceSpecialChars1(str52) {
    return str52.replace(/[^a-zA-Z0-9]/g, "_");
}
class FishCompletionsCommand extends Command {
    #cmd;
    constructor(cmd){
        super();
        this.#cmd = cmd;
        this.description(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            return `Generate shell completions for fish.

To enable fish completions for this program add following line to your ${dim(italic("~/.config/fish/config.fish"))}:

    ${dim(italic(`source (${baseCmd.getPath()} completions fish | psub)`))}`;
        }).action(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            Deno.stdout.writeSync(new TextEncoder().encode(FishCompletionsGenerator.generate(baseCmd)));
        });
    }
}
class ZshCompletionsGenerator {
    cmd;
    actions = new Map();
    static generate(cmd) {
        return new ZshCompletionsGenerator(cmd).generate();
    }
    constructor(cmd){
        this.cmd = cmd;
    }
    generate() {
        const path9 = this.cmd.getPath();
        const name68 = this.cmd.getName();
        const version5 = this.cmd.getVersion() ? ` v${this.cmd.getVersion()}` : "";
        return `#!/usr/bin/env zsh
# zsh completion support for ${path9}${version5}

autoload -U is-at-least

# shellcheck disable=SC2154
(( $+functions[__${replaceSpecialChars2(name68)}_complete] )) ||
function __${replaceSpecialChars2(name68)}_complete {
  local name="$1"; shift
  local action="$1"; shift
  integer ret=1
  local -a values
  local expl lines
  _tags "$name"
  while _tags; do
    if _requested "$name"; then
      # shellcheck disable=SC2034
      lines="$(${name68} completions complete "\${action}" "\${@}")"
      values=("\${(ps:\\n:)lines}")
      if (( \${#values[@]} )); then
        while _next_label "$name" expl "$action"; do
          compadd -S '' "\${expl[@]}" "\${values[@]}"
        done
      fi
    fi
  done
}

${this.generateCompletions(this.cmd).trim()}

# _${replaceSpecialChars2(path9)} "\${@}"

compdef _${replaceSpecialChars2(path9)} ${path9}

`;
    }
    generateCompletions(command, path10 = "") {
        if (!command.hasCommands(false) && !command.hasOptions(false) && !command.hasArguments()) {
            return "";
        }
        path10 = (path10 ? path10 + " " : "") + command.getName();
        return `# shellcheck disable=SC2154
(( $+functions[_${replaceSpecialChars2(path10)}] )) ||
function _${replaceSpecialChars2(path10)}() {` + (!command.getParent() ? `
  local state` : "") + this.generateCommandCompletions(command, path10) + this.generateSubCommandCompletions(command, path10) + this.generateArgumentCompletions(command, path10) + this.generateActions(command) + `\n}\n\n` + command.getCommands(false).filter((subCommand)=>subCommand !== command
        ).map((subCommand)=>this.generateCompletions(subCommand, path10)
        ).join("");
    }
    generateCommandCompletions(command, path11) {
        const commands9 = command.getCommands(false);
        let completions = commands9.map((subCommand)=>`'${subCommand.getName()}:${subCommand.getShortDescription()}'`
        ).join("\n      ");
        if (completions) {
            completions = `
    local -a commands
    # shellcheck disable=SC2034
    commands=(
      ${completions}
    )
    _describe 'command' commands`;
        }
        if (command.hasArguments()) {
            const completionsPath = path11.split(" ").slice(1).join(" ");
            const arg = command.getArguments()[0];
            const action = this.addAction(arg, completionsPath);
            if (action && command.getCompletion(arg.action)) {
                completions += `\n    __${replaceSpecialChars2(this.cmd.getName())}_complete ${action.arg.name} ${action.arg.action} ${action.cmd}`;
            }
        }
        if (completions) {
            completions = `\n\n  function _commands() {${completions}\n  }`;
        }
        return completions;
    }
    generateSubCommandCompletions(command1, path12) {
        if (command1.hasCommands(false)) {
            const actions = command1.getCommands(false).map((command)=>`${command.getName()}) _${replaceSpecialChars2(path12 + " " + command.getName())} ;;`
            ).join("\n      ");
            return `\n
  function _command_args() {
    case "\${words[1]}" in\n      ${actions}\n    esac
  }`;
        }
        return "";
    }
    generateArgumentCompletions(command, path13) {
        this.actions.clear();
        const options = this.generateOptions(command, path13);
        let argIndex = 0;
        let argsCommand = "\n\n  _arguments -w -s -S -C";
        if (command.hasOptions()) {
            argsCommand += ` \\\n    ${options.join(" \\\n    ")}`;
        }
        if (command.hasCommands(false) || command.getArguments().filter((arg)=>command.getCompletion(arg.action)
        ).length) {
            argsCommand += ` \\\n    '${++argIndex}: :_commands'`;
        }
        if (command.hasArguments() || command.hasCommands(false)) {
            const args = [];
            for (const arg1 of command.getArguments().slice(1)){
                const completionsPath = path13.split(" ").slice(1).join(" ");
                const action = this.addAction(arg1, completionsPath);
                args.push(`${++argIndex}${arg1.optionalValue ? "::" : ":"}${action.name}`);
            }
            argsCommand += args.map((arg)=>`\\\n    '${arg}'`
            ).join("");
            if (command.hasCommands(false)) {
                argsCommand += ` \\\n    '*:: :->command_args'`;
            }
        }
        return argsCommand;
    }
    generateOptions(command, path14) {
        const options = [];
        const cmdArgs = path14.split(" ");
        cmdArgs.shift();
        const completionsPath = cmdArgs.join(" ");
        const excludedFlags = command.getOptions(false).map((option)=>option.standalone ? option.flags : false
        ).flat().filter((flag)=>typeof flag === "string"
        );
        for (const option1 of command.getOptions(false)){
            options.push(this.generateOption(option1, completionsPath, excludedFlags));
        }
        return options;
    }
    generateOption(option, completionsPath, excludedOptions) {
        const flags = option.flags;
        let excludedFlags = option.conflicts?.length ? [
            ...excludedOptions,
            ...option.conflicts.map((opt)=>"--" + opt.replace(/^--/, "")
            ), 
        ] : excludedOptions;
        excludedFlags = option.collect ? excludedFlags : [
            ...excludedFlags,
            ...flags, 
        ];
        let args = "";
        for (const arg of option.args){
            const action = this.addAction(arg, completionsPath);
            if (arg.variadic) {
                args += `${arg.optionalValue ? "::" : ":"}${arg.name}:->${action.name}`;
            } else {
                args += `${arg.optionalValue ? "::" : ":"}${arg.name}:->${action.name}`;
            }
        }
        let description6 = option.description.trim().split("\n").shift();
        description6 = description6.replace(/\[/g, "\\[").replace(/]/g, "\\]").replace(/"/g, '\\"').replace(/'/g, "'\"'\"'");
        const collect = option.collect ? "*" : "";
        if (option.standalone) {
            return `'(- *)'{${collect}${flags}}'[${description6}]${args}'`;
        } else {
            const excluded = excludedFlags.length ? `'(${excludedFlags.join(" ")})'` : "";
            if (collect || flags.length > 1) {
                return `${excluded}{${collect}${flags}}'[${description6}]${args}'`;
            } else {
                return `${excluded}${flags}'[${description6}]${args}'`;
            }
        }
    }
    addAction(arg, cmd) {
        const action = `${arg.name}-${arg.action}`;
        if (!this.actions.has(action)) {
            this.actions.set(action, {
                arg: arg,
                label: `${arg.name}: ${arg.action}`,
                name: action,
                cmd
            });
        }
        return this.actions.get(action);
    }
    generateActions(command) {
        let actions = [];
        if (this.actions.size) {
            actions = Array.from(this.actions).map(([name69, action])=>`${name69}) __${replaceSpecialChars2(this.cmd.getName())}_complete ${action.arg.name} ${action.arg.action} ${action.cmd} ;;`
            );
        }
        if (command.hasCommands(false)) {
            actions.unshift(`command_args) _command_args ;;`);
        }
        if (actions.length) {
            return `\n\n  case "$state" in\n    ${actions.join("\n    ")}\n  esac`;
        }
        return "";
    }
}
function replaceSpecialChars2(str53) {
    return str53.replace(/[^a-zA-Z0-9]/g, "_");
}
class ZshCompletionsCommand extends Command {
    #cmd;
    constructor(cmd){
        super();
        this.#cmd = cmd;
        this.description(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            return `Generate shell completions for zsh.

To enable zsh completions for this program add following line to your ${dim(italic("~/.zshrc"))}:

    ${dim(italic(`source <(${baseCmd.getPath()} completions zsh)`))}`;
        }).action(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            Deno.stdout.writeSync(new TextEncoder().encode(ZshCompletionsGenerator.generate(baseCmd)));
        });
    }
}
class CompletionsCommand extends Command {
    #cmd;
    constructor(cmd){
        super();
        this.#cmd = cmd;
        this.description(()=>{
            const baseCmd = this.#cmd || this.getMainCommand();
            return `Generate shell completions.

To enable shell completions for this program add the following line to your ${dim(italic("~/.bashrc"))} or similar:

    ${dim(italic(`source <(${baseCmd.getPath()} completions [shell])`))}

    For more information run ${dim(italic(`${baseCmd.getPath()} completions [shell] --help`))}
`;
        }).action(()=>this.showHelp()
        ).command("bash", new BashCompletionsCommand(this.#cmd)).command("fish", new FishCompletionsCommand(this.#cmd)).command("zsh", new ZshCompletionsCommand(this.#cmd)).command("complete", new CompleteCommand(this.#cmd).hidden()).reset();
    }
}
class CommandType extends StringType {
    complete(_cmd, parent) {
        return parent?.getCommands(false).map((cmd)=>cmd.getName()
        ) || [];
    }
}
class HelpCommand extends Command {
    constructor(cmd){
        super();
        this.type("command", new CommandType()).arguments("[command:command]").description("Show this help or the help of a sub-command.").action((_, name70)=>{
            if (!cmd) {
                cmd = name70 ? this.getGlobalParent()?.getBaseCommand(name70) : this.getGlobalParent();
            }
            if (!cmd) {
                const cmds = this.getGlobalParent()?.getCommands();
                throw new UnknownCommand(name70 ?? "", cmds ?? [], [
                    this.getName(),
                    ...this.getAliases(), 
                ]);
            }
            cmd.showHelp();
            Deno.exit(0);
        });
    }
}
class EnumType extends Type {
    allowedValues;
    constructor(values3){
        super();
        this.allowedValues = values3;
    }
    parse(type20) {
        for (const value of this.allowedValues){
            if (value.toString() === type20.value) {
                return value;
            }
        }
        throw new InvalidTypeError(type20, this.allowedValues.slice());
    }
    values() {
        return this.allowedValues.slice();
    }
    complete() {
        return this.values();
    }
}
const osType = (()=>{
    const { Deno  } = globalThis;
    if (typeof Deno?.build?.os === "string") {
        return Deno.build.os;
    }
    const { navigator  } = globalThis;
    if (navigator?.appVersion?.includes?.("Win") ?? false) {
        return "windows";
    }
    return "linux";
})();
const isWindows = osType === "windows";
const CHAR_FORWARD_SLASH = 47;
function assertPath(path15) {
    if (typeof path15 !== "string") {
        throw new TypeError(`Path must be a string. Received ${JSON.stringify(path15)}`);
    }
}
function isPosixPathSeparator(code2) {
    return code2 === 47;
}
function isPathSeparator(code3) {
    return isPosixPathSeparator(code3) || code3 === 92;
}
function isWindowsDeviceRoot(code4) {
    return code4 >= 97 && code4 <= 122 || code4 >= 65 && code4 <= 90;
}
function normalizeString(path16, allowAboveRoot, separator, isPathSeparator1) {
    let res = "";
    let lastSegmentLength = 0;
    let lastSlash = -1;
    let dots = 0;
    let code5;
    for(let i8 = 0, len = path16.length; i8 <= len; ++i8){
        if (i8 < len) code5 = path16.charCodeAt(i8);
        else if (isPathSeparator1(code5)) break;
        else code5 = CHAR_FORWARD_SLASH;
        if (isPathSeparator1(code5)) {
            if (lastSlash === i8 - 1 || dots === 1) {} else if (lastSlash !== i8 - 1 && dots === 2) {
                if (res.length < 2 || lastSegmentLength !== 2 || res.charCodeAt(res.length - 1) !== 46 || res.charCodeAt(res.length - 2) !== 46) {
                    if (res.length > 2) {
                        const lastSlashIndex = res.lastIndexOf(separator);
                        if (lastSlashIndex === -1) {
                            res = "";
                            lastSegmentLength = 0;
                        } else {
                            res = res.slice(0, lastSlashIndex);
                            lastSegmentLength = res.length - 1 - res.lastIndexOf(separator);
                        }
                        lastSlash = i8;
                        dots = 0;
                        continue;
                    } else if (res.length === 2 || res.length === 1) {
                        res = "";
                        lastSegmentLength = 0;
                        lastSlash = i8;
                        dots = 0;
                        continue;
                    }
                }
                if (allowAboveRoot) {
                    if (res.length > 0) res += `${separator}..`;
                    else res = "..";
                    lastSegmentLength = 2;
                }
            } else {
                if (res.length > 0) res += separator + path16.slice(lastSlash + 1, i8);
                else res = path16.slice(lastSlash + 1, i8);
                lastSegmentLength = i8 - lastSlash - 1;
            }
            lastSlash = i8;
            dots = 0;
        } else if (code5 === 46 && dots !== -1) {
            ++dots;
        } else {
            dots = -1;
        }
    }
    return res;
}
function _format(sep3, pathObject) {
    const dir = pathObject.dir || pathObject.root;
    const base1 = pathObject.base || (pathObject.name || "") + (pathObject.ext || "");
    if (!dir) return base1;
    if (dir === pathObject.root) return dir + base1;
    return dir + sep3 + base1;
}
const WHITESPACE_ENCODINGS = {
    "\u0009": "%09",
    "\u000A": "%0A",
    "\u000B": "%0B",
    "\u000C": "%0C",
    "\u000D": "%0D",
    "\u0020": "%20"
};
function encodeWhitespace(string3) {
    return string3.replaceAll(/[\s]/g, (c)=>{
        return WHITESPACE_ENCODINGS[c] ?? c;
    });
}
class DenoStdInternalError extends Error {
    constructor(message){
        super(message);
        this.name = "DenoStdInternalError";
    }
}
function assert(expr, msg = "") {
    if (!expr) {
        throw new DenoStdInternalError(msg);
    }
}
const sep = "\\";
const delimiter = ";";
function resolve(...pathSegments) {
    let resolvedDevice = "";
    let resolvedTail = "";
    let resolvedAbsolute = false;
    for(let i9 = pathSegments.length - 1; i9 >= -1; i9--){
        let path17;
        const { Deno  } = globalThis;
        if (i9 >= 0) {
            path17 = pathSegments[i9];
        } else if (!resolvedDevice) {
            if (typeof Deno?.cwd !== "function") {
                throw new TypeError("Resolved a drive-letter-less path without a CWD.");
            }
            path17 = Deno.cwd();
        } else {
            if (typeof Deno?.env?.get !== "function" || typeof Deno?.cwd !== "function") {
                throw new TypeError("Resolved a relative path without a CWD.");
            }
            path17 = Deno.cwd();
            if (path17 === undefined || path17.slice(0, 3).toLowerCase() !== `${resolvedDevice.toLowerCase()}\\`) {
                path17 = `${resolvedDevice}\\`;
            }
        }
        assertPath(path17);
        const len = path17.length;
        if (len === 0) continue;
        let rootEnd = 0;
        let device = "";
        let isAbsolute1 = false;
        const code6 = path17.charCodeAt(0);
        if (len > 1) {
            if (isPathSeparator(code6)) {
                isAbsolute1 = true;
                if (isPathSeparator(path17.charCodeAt(1))) {
                    let j = 2;
                    let last = j;
                    for(; j < len; ++j){
                        if (isPathSeparator(path17.charCodeAt(j))) break;
                    }
                    if (j < len && j !== last) {
                        const firstPart = path17.slice(last, j);
                        last = j;
                        for(; j < len; ++j){
                            if (!isPathSeparator(path17.charCodeAt(j))) break;
                        }
                        if (j < len && j !== last) {
                            last = j;
                            for(; j < len; ++j){
                                if (isPathSeparator(path17.charCodeAt(j))) break;
                            }
                            if (j === len) {
                                device = `\\\\${firstPart}\\${path17.slice(last)}`;
                                rootEnd = j;
                            } else if (j !== last) {
                                device = `\\\\${firstPart}\\${path17.slice(last, j)}`;
                                rootEnd = j;
                            }
                        }
                    }
                } else {
                    rootEnd = 1;
                }
            } else if (isWindowsDeviceRoot(code6)) {
                if (path17.charCodeAt(1) === 58) {
                    device = path17.slice(0, 2);
                    rootEnd = 2;
                    if (len > 2) {
                        if (isPathSeparator(path17.charCodeAt(2))) {
                            isAbsolute1 = true;
                            rootEnd = 3;
                        }
                    }
                }
            }
        } else if (isPathSeparator(code6)) {
            rootEnd = 1;
            isAbsolute1 = true;
        }
        if (device.length > 0 && resolvedDevice.length > 0 && device.toLowerCase() !== resolvedDevice.toLowerCase()) {
            continue;
        }
        if (resolvedDevice.length === 0 && device.length > 0) {
            resolvedDevice = device;
        }
        if (!resolvedAbsolute) {
            resolvedTail = `${path17.slice(rootEnd)}\\${resolvedTail}`;
            resolvedAbsolute = isAbsolute1;
        }
        if (resolvedAbsolute && resolvedDevice.length > 0) break;
    }
    resolvedTail = normalizeString(resolvedTail, !resolvedAbsolute, "\\", isPathSeparator);
    return resolvedDevice + (resolvedAbsolute ? "\\" : "") + resolvedTail || ".";
}
function normalize1(path18) {
    assertPath(path18);
    const len = path18.length;
    if (len === 0) return ".";
    let rootEnd = 0;
    let device;
    let isAbsolute2 = false;
    const code7 = path18.charCodeAt(0);
    if (len > 1) {
        if (isPathSeparator(code7)) {
            isAbsolute2 = true;
            if (isPathSeparator(path18.charCodeAt(1))) {
                let j = 2;
                let last = j;
                for(; j < len; ++j){
                    if (isPathSeparator(path18.charCodeAt(j))) break;
                }
                if (j < len && j !== last) {
                    const firstPart = path18.slice(last, j);
                    last = j;
                    for(; j < len; ++j){
                        if (!isPathSeparator(path18.charCodeAt(j))) break;
                    }
                    if (j < len && j !== last) {
                        last = j;
                        for(; j < len; ++j){
                            if (isPathSeparator(path18.charCodeAt(j))) break;
                        }
                        if (j === len) {
                            return `\\\\${firstPart}\\${path18.slice(last)}\\`;
                        } else if (j !== last) {
                            device = `\\\\${firstPart}\\${path18.slice(last, j)}`;
                            rootEnd = j;
                        }
                    }
                }
            } else {
                rootEnd = 1;
            }
        } else if (isWindowsDeviceRoot(code7)) {
            if (path18.charCodeAt(1) === 58) {
                device = path18.slice(0, 2);
                rootEnd = 2;
                if (len > 2) {
                    if (isPathSeparator(path18.charCodeAt(2))) {
                        isAbsolute2 = true;
                        rootEnd = 3;
                    }
                }
            }
        }
    } else if (isPathSeparator(code7)) {
        return "\\";
    }
    let tail;
    if (rootEnd < len) {
        tail = normalizeString(path18.slice(rootEnd), !isAbsolute2, "\\", isPathSeparator);
    } else {
        tail = "";
    }
    if (tail.length === 0 && !isAbsolute2) tail = ".";
    if (tail.length > 0 && isPathSeparator(path18.charCodeAt(len - 1))) {
        tail += "\\";
    }
    if (device === undefined) {
        if (isAbsolute2) {
            if (tail.length > 0) return `\\${tail}`;
            else return "\\";
        } else if (tail.length > 0) {
            return tail;
        } else {
            return "";
        }
    } else if (isAbsolute2) {
        if (tail.length > 0) return `${device}\\${tail}`;
        else return `${device}\\`;
    } else if (tail.length > 0) {
        return device + tail;
    } else {
        return device;
    }
}
function isAbsolute(path19) {
    assertPath(path19);
    const len = path19.length;
    if (len === 0) return false;
    const code8 = path19.charCodeAt(0);
    if (isPathSeparator(code8)) {
        return true;
    } else if (isWindowsDeviceRoot(code8)) {
        if (len > 2 && path19.charCodeAt(1) === 58) {
            if (isPathSeparator(path19.charCodeAt(2))) return true;
        }
    }
    return false;
}
function join(...paths) {
    const pathsCount = paths.length;
    if (pathsCount === 0) return ".";
    let joined;
    let firstPart = null;
    for(let i10 = 0; i10 < pathsCount; ++i10){
        const path20 = paths[i10];
        assertPath(path20);
        if (path20.length > 0) {
            if (joined === undefined) joined = firstPart = path20;
            else joined += `\\${path20}`;
        }
    }
    if (joined === undefined) return ".";
    let needsReplace = true;
    let slashCount = 0;
    assert(firstPart != null);
    if (isPathSeparator(firstPart.charCodeAt(0))) {
        ++slashCount;
        const firstLen = firstPart.length;
        if (firstLen > 1) {
            if (isPathSeparator(firstPart.charCodeAt(1))) {
                ++slashCount;
                if (firstLen > 2) {
                    if (isPathSeparator(firstPart.charCodeAt(2))) ++slashCount;
                    else {
                        needsReplace = false;
                    }
                }
            }
        }
    }
    if (needsReplace) {
        for(; slashCount < joined.length; ++slashCount){
            if (!isPathSeparator(joined.charCodeAt(slashCount))) break;
        }
        if (slashCount >= 2) joined = `\\${joined.slice(slashCount)}`;
    }
    return normalize1(joined);
}
function relative(from, to) {
    assertPath(from);
    assertPath(to);
    if (from === to) return "";
    const fromOrig = resolve(from);
    const toOrig = resolve(to);
    if (fromOrig === toOrig) return "";
    from = fromOrig.toLowerCase();
    to = toOrig.toLowerCase();
    if (from === to) return "";
    let fromStart = 0;
    let fromEnd = from.length;
    for(; fromStart < fromEnd; ++fromStart){
        if (from.charCodeAt(fromStart) !== 92) break;
    }
    for(; fromEnd - 1 > fromStart; --fromEnd){
        if (from.charCodeAt(fromEnd - 1) !== 92) break;
    }
    const fromLen = fromEnd - fromStart;
    let toStart = 0;
    let toEnd = to.length;
    for(; toStart < toEnd; ++toStart){
        if (to.charCodeAt(toStart) !== 92) break;
    }
    for(; toEnd - 1 > toStart; --toEnd){
        if (to.charCodeAt(toEnd - 1) !== 92) break;
    }
    const toLen = toEnd - toStart;
    const length = fromLen < toLen ? fromLen : toLen;
    let lastCommonSep = -1;
    let i11 = 0;
    for(; i11 <= length; ++i11){
        if (i11 === length) {
            if (toLen > length) {
                if (to.charCodeAt(toStart + i11) === 92) {
                    return toOrig.slice(toStart + i11 + 1);
                } else if (i11 === 2) {
                    return toOrig.slice(toStart + i11);
                }
            }
            if (fromLen > length) {
                if (from.charCodeAt(fromStart + i11) === 92) {
                    lastCommonSep = i11;
                } else if (i11 === 2) {
                    lastCommonSep = 3;
                }
            }
            break;
        }
        const fromCode = from.charCodeAt(fromStart + i11);
        const toCode = to.charCodeAt(toStart + i11);
        if (fromCode !== toCode) break;
        else if (fromCode === 92) lastCommonSep = i11;
    }
    if (i11 !== length && lastCommonSep === -1) {
        return toOrig;
    }
    let out = "";
    if (lastCommonSep === -1) lastCommonSep = 0;
    for(i11 = fromStart + lastCommonSep + 1; i11 <= fromEnd; ++i11){
        if (i11 === fromEnd || from.charCodeAt(i11) === 92) {
            if (out.length === 0) out += "..";
            else out += "\\..";
        }
    }
    if (out.length > 0) {
        return out + toOrig.slice(toStart + lastCommonSep, toEnd);
    } else {
        toStart += lastCommonSep;
        if (toOrig.charCodeAt(toStart) === 92) ++toStart;
        return toOrig.slice(toStart, toEnd);
    }
}
function toNamespacedPath(path21) {
    if (typeof path21 !== "string") return path21;
    if (path21.length === 0) return "";
    const resolvedPath = resolve(path21);
    if (resolvedPath.length >= 3) {
        if (resolvedPath.charCodeAt(0) === 92) {
            if (resolvedPath.charCodeAt(1) === 92) {
                const code9 = resolvedPath.charCodeAt(2);
                if (code9 !== 63 && code9 !== 46) {
                    return `\\\\?\\UNC\\${resolvedPath.slice(2)}`;
                }
            }
        } else if (isWindowsDeviceRoot(resolvedPath.charCodeAt(0))) {
            if (resolvedPath.charCodeAt(1) === 58 && resolvedPath.charCodeAt(2) === 92) {
                return `\\\\?\\${resolvedPath}`;
            }
        }
    }
    return path21;
}
function dirname(path22) {
    assertPath(path22);
    const len = path22.length;
    if (len === 0) return ".";
    let rootEnd = -1;
    let end = -1;
    let matchedSlash = true;
    let offset = 0;
    const code10 = path22.charCodeAt(0);
    if (len > 1) {
        if (isPathSeparator(code10)) {
            rootEnd = offset = 1;
            if (isPathSeparator(path22.charCodeAt(1))) {
                let j = 2;
                let last = j;
                for(; j < len; ++j){
                    if (isPathSeparator(path22.charCodeAt(j))) break;
                }
                if (j < len && j !== last) {
                    last = j;
                    for(; j < len; ++j){
                        if (!isPathSeparator(path22.charCodeAt(j))) break;
                    }
                    if (j < len && j !== last) {
                        last = j;
                        for(; j < len; ++j){
                            if (isPathSeparator(path22.charCodeAt(j))) break;
                        }
                        if (j === len) {
                            return path22;
                        }
                        if (j !== last) {
                            rootEnd = offset = j + 1;
                        }
                    }
                }
            }
        } else if (isWindowsDeviceRoot(code10)) {
            if (path22.charCodeAt(1) === 58) {
                rootEnd = offset = 2;
                if (len > 2) {
                    if (isPathSeparator(path22.charCodeAt(2))) rootEnd = offset = 3;
                }
            }
        }
    } else if (isPathSeparator(code10)) {
        return path22;
    }
    for(let i12 = len - 1; i12 >= offset; --i12){
        if (isPathSeparator(path22.charCodeAt(i12))) {
            if (!matchedSlash) {
                end = i12;
                break;
            }
        } else {
            matchedSlash = false;
        }
    }
    if (end === -1) {
        if (rootEnd === -1) return ".";
        else end = rootEnd;
    }
    return path22.slice(0, end);
}
function basename(path23, ext = "") {
    if (ext !== undefined && typeof ext !== "string") {
        throw new TypeError('"ext" argument must be a string');
    }
    assertPath(path23);
    let start = 0;
    let end = -1;
    let matchedSlash = true;
    let i13;
    if (path23.length >= 2) {
        const drive = path23.charCodeAt(0);
        if (isWindowsDeviceRoot(drive)) {
            if (path23.charCodeAt(1) === 58) start = 2;
        }
    }
    if (ext !== undefined && ext.length > 0 && ext.length <= path23.length) {
        if (ext.length === path23.length && ext === path23) return "";
        let extIdx = ext.length - 1;
        let firstNonSlashEnd = -1;
        for(i13 = path23.length - 1; i13 >= start; --i13){
            const code11 = path23.charCodeAt(i13);
            if (isPathSeparator(code11)) {
                if (!matchedSlash) {
                    start = i13 + 1;
                    break;
                }
            } else {
                if (firstNonSlashEnd === -1) {
                    matchedSlash = false;
                    firstNonSlashEnd = i13 + 1;
                }
                if (extIdx >= 0) {
                    if (code11 === ext.charCodeAt(extIdx)) {
                        if (--extIdx === -1) {
                            end = i13;
                        }
                    } else {
                        extIdx = -1;
                        end = firstNonSlashEnd;
                    }
                }
            }
        }
        if (start === end) end = firstNonSlashEnd;
        else if (end === -1) end = path23.length;
        return path23.slice(start, end);
    } else {
        for(i13 = path23.length - 1; i13 >= start; --i13){
            if (isPathSeparator(path23.charCodeAt(i13))) {
                if (!matchedSlash) {
                    start = i13 + 1;
                    break;
                }
            } else if (end === -1) {
                matchedSlash = false;
                end = i13 + 1;
            }
        }
        if (end === -1) return "";
        return path23.slice(start, end);
    }
}
function extname(path24) {
    assertPath(path24);
    let start = 0;
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let preDotState = 0;
    if (path24.length >= 2 && path24.charCodeAt(1) === 58 && isWindowsDeviceRoot(path24.charCodeAt(0))) {
        start = startPart = 2;
    }
    for(let i14 = path24.length - 1; i14 >= start; --i14){
        const code12 = path24.charCodeAt(i14);
        if (isPathSeparator(code12)) {
            if (!matchedSlash) {
                startPart = i14 + 1;
                break;
            }
            continue;
        }
        if (end === -1) {
            matchedSlash = false;
            end = i14 + 1;
        }
        if (code12 === 46) {
            if (startDot === -1) startDot = i14;
            else if (preDotState !== 1) preDotState = 1;
        } else if (startDot !== -1) {
            preDotState = -1;
        }
    }
    if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
    }
    return path24.slice(startDot, end);
}
function format(pathObject) {
    if (pathObject === null || typeof pathObject !== "object") {
        throw new TypeError(`The "pathObject" argument must be of type Object. Received type ${typeof pathObject}`);
    }
    return _format("\\", pathObject);
}
function parse(path25) {
    assertPath(path25);
    const ret = {
        root: "",
        dir: "",
        base: "",
        ext: "",
        name: ""
    };
    const len = path25.length;
    if (len === 0) return ret;
    let rootEnd = 0;
    let code13 = path25.charCodeAt(0);
    if (len > 1) {
        if (isPathSeparator(code13)) {
            rootEnd = 1;
            if (isPathSeparator(path25.charCodeAt(1))) {
                let j = 2;
                let last = j;
                for(; j < len; ++j){
                    if (isPathSeparator(path25.charCodeAt(j))) break;
                }
                if (j < len && j !== last) {
                    last = j;
                    for(; j < len; ++j){
                        if (!isPathSeparator(path25.charCodeAt(j))) break;
                    }
                    if (j < len && j !== last) {
                        last = j;
                        for(; j < len; ++j){
                            if (isPathSeparator(path25.charCodeAt(j))) break;
                        }
                        if (j === len) {
                            rootEnd = j;
                        } else if (j !== last) {
                            rootEnd = j + 1;
                        }
                    }
                }
            }
        } else if (isWindowsDeviceRoot(code13)) {
            if (path25.charCodeAt(1) === 58) {
                rootEnd = 2;
                if (len > 2) {
                    if (isPathSeparator(path25.charCodeAt(2))) {
                        if (len === 3) {
                            ret.root = ret.dir = path25;
                            return ret;
                        }
                        rootEnd = 3;
                    }
                } else {
                    ret.root = ret.dir = path25;
                    return ret;
                }
            }
        }
    } else if (isPathSeparator(code13)) {
        ret.root = ret.dir = path25;
        return ret;
    }
    if (rootEnd > 0) ret.root = path25.slice(0, rootEnd);
    let startDot = -1;
    let startPart = rootEnd;
    let end = -1;
    let matchedSlash = true;
    let i15 = path25.length - 1;
    let preDotState = 0;
    for(; i15 >= rootEnd; --i15){
        code13 = path25.charCodeAt(i15);
        if (isPathSeparator(code13)) {
            if (!matchedSlash) {
                startPart = i15 + 1;
                break;
            }
            continue;
        }
        if (end === -1) {
            matchedSlash = false;
            end = i15 + 1;
        }
        if (code13 === 46) {
            if (startDot === -1) startDot = i15;
            else if (preDotState !== 1) preDotState = 1;
        } else if (startDot !== -1) {
            preDotState = -1;
        }
    }
    if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        if (end !== -1) {
            ret.base = ret.name = path25.slice(startPart, end);
        }
    } else {
        ret.name = path25.slice(startPart, startDot);
        ret.base = path25.slice(startPart, end);
        ret.ext = path25.slice(startDot, end);
    }
    if (startPart > 0 && startPart !== rootEnd) {
        ret.dir = path25.slice(0, startPart - 1);
    } else ret.dir = ret.root;
    return ret;
}
function fromFileUrl(url) {
    url = url instanceof URL ? url : new URL(url);
    if (url.protocol != "file:") {
        throw new TypeError("Must be a file URL.");
    }
    let path26 = decodeURIComponent(url.pathname.replace(/\//g, "\\").replace(/%(?![0-9A-Fa-f]{2})/g, "%25")).replace(/^\\*([A-Za-z]:)(\\|$)/, "$1\\");
    if (url.hostname != "") {
        path26 = `\\\\${url.hostname}${path26}`;
    }
    return path26;
}
function toFileUrl(path27) {
    if (!isAbsolute(path27)) {
        throw new TypeError("Must be an absolute path.");
    }
    const [, hostname, pathname] = path27.match(/^(?:[/\\]{2}([^/\\]+)(?=[/\\](?:[^/\\]|$)))?(.*)/);
    const url = new URL("file:///");
    url.pathname = encodeWhitespace(pathname.replace(/%/g, "%25"));
    if (hostname != null && hostname != "localhost") {
        url.hostname = hostname;
        if (!url.hostname) {
            throw new TypeError("Invalid hostname.");
        }
    }
    return url;
}
const mod1 = {
    sep: sep,
    delimiter: delimiter,
    resolve: resolve,
    normalize: normalize1,
    isAbsolute: isAbsolute,
    join: join,
    relative: relative,
    toNamespacedPath: toNamespacedPath,
    dirname: dirname,
    basename: basename,
    extname: extname,
    format: format,
    parse: parse,
    fromFileUrl: fromFileUrl,
    toFileUrl: toFileUrl
};
const sep1 = "/";
const delimiter1 = ":";
function resolve1(...pathSegments) {
    let resolvedPath = "";
    let resolvedAbsolute = false;
    for(let i16 = pathSegments.length - 1; i16 >= -1 && !resolvedAbsolute; i16--){
        let path28;
        if (i16 >= 0) path28 = pathSegments[i16];
        else {
            const { Deno  } = globalThis;
            if (typeof Deno?.cwd !== "function") {
                throw new TypeError("Resolved a relative path without a CWD.");
            }
            path28 = Deno.cwd();
        }
        assertPath(path28);
        if (path28.length === 0) {
            continue;
        }
        resolvedPath = `${path28}/${resolvedPath}`;
        resolvedAbsolute = path28.charCodeAt(0) === CHAR_FORWARD_SLASH;
    }
    resolvedPath = normalizeString(resolvedPath, !resolvedAbsolute, "/", isPosixPathSeparator);
    if (resolvedAbsolute) {
        if (resolvedPath.length > 0) return `/${resolvedPath}`;
        else return "/";
    } else if (resolvedPath.length > 0) return resolvedPath;
    else return ".";
}
function normalize2(path29) {
    assertPath(path29);
    if (path29.length === 0) return ".";
    const isAbsolute1 = path29.charCodeAt(0) === 47;
    const trailingSeparator = path29.charCodeAt(path29.length - 1) === 47;
    path29 = normalizeString(path29, !isAbsolute1, "/", isPosixPathSeparator);
    if (path29.length === 0 && !isAbsolute1) path29 = ".";
    if (path29.length > 0 && trailingSeparator) path29 += "/";
    if (isAbsolute1) return `/${path29}`;
    return path29;
}
function isAbsolute1(path30) {
    assertPath(path30);
    return path30.length > 0 && path30.charCodeAt(0) === 47;
}
function join1(...paths) {
    if (paths.length === 0) return ".";
    let joined;
    for(let i17 = 0, len = paths.length; i17 < len; ++i17){
        const path31 = paths[i17];
        assertPath(path31);
        if (path31.length > 0) {
            if (!joined) joined = path31;
            else joined += `/${path31}`;
        }
    }
    if (!joined) return ".";
    return normalize2(joined);
}
function relative1(from, to) {
    assertPath(from);
    assertPath(to);
    if (from === to) return "";
    from = resolve1(from);
    to = resolve1(to);
    if (from === to) return "";
    let fromStart = 1;
    const fromEnd = from.length;
    for(; fromStart < fromEnd; ++fromStart){
        if (from.charCodeAt(fromStart) !== 47) break;
    }
    const fromLen = fromEnd - fromStart;
    let toStart = 1;
    const toEnd = to.length;
    for(; toStart < toEnd; ++toStart){
        if (to.charCodeAt(toStart) !== 47) break;
    }
    const toLen = toEnd - toStart;
    const length = fromLen < toLen ? fromLen : toLen;
    let lastCommonSep = -1;
    let i18 = 0;
    for(; i18 <= length; ++i18){
        if (i18 === length) {
            if (toLen > length) {
                if (to.charCodeAt(toStart + i18) === 47) {
                    return to.slice(toStart + i18 + 1);
                } else if (i18 === 0) {
                    return to.slice(toStart + i18);
                }
            } else if (fromLen > length) {
                if (from.charCodeAt(fromStart + i18) === 47) {
                    lastCommonSep = i18;
                } else if (i18 === 0) {
                    lastCommonSep = 0;
                }
            }
            break;
        }
        const fromCode = from.charCodeAt(fromStart + i18);
        const toCode = to.charCodeAt(toStart + i18);
        if (fromCode !== toCode) break;
        else if (fromCode === 47) lastCommonSep = i18;
    }
    let out = "";
    for(i18 = fromStart + lastCommonSep + 1; i18 <= fromEnd; ++i18){
        if (i18 === fromEnd || from.charCodeAt(i18) === 47) {
            if (out.length === 0) out += "..";
            else out += "/..";
        }
    }
    if (out.length > 0) return out + to.slice(toStart + lastCommonSep);
    else {
        toStart += lastCommonSep;
        if (to.charCodeAt(toStart) === 47) ++toStart;
        return to.slice(toStart);
    }
}
function toNamespacedPath1(path32) {
    return path32;
}
function dirname1(path33) {
    assertPath(path33);
    if (path33.length === 0) return ".";
    const hasRoot = path33.charCodeAt(0) === 47;
    let end = -1;
    let matchedSlash = true;
    for(let i19 = path33.length - 1; i19 >= 1; --i19){
        if (path33.charCodeAt(i19) === 47) {
            if (!matchedSlash) {
                end = i19;
                break;
            }
        } else {
            matchedSlash = false;
        }
    }
    if (end === -1) return hasRoot ? "/" : ".";
    if (hasRoot && end === 1) return "//";
    return path33.slice(0, end);
}
function basename1(path34, ext = "") {
    if (ext !== undefined && typeof ext !== "string") {
        throw new TypeError('"ext" argument must be a string');
    }
    assertPath(path34);
    let start = 0;
    let end = -1;
    let matchedSlash = true;
    let i20;
    if (ext !== undefined && ext.length > 0 && ext.length <= path34.length) {
        if (ext.length === path34.length && ext === path34) return "";
        let extIdx = ext.length - 1;
        let firstNonSlashEnd = -1;
        for(i20 = path34.length - 1; i20 >= 0; --i20){
            const code14 = path34.charCodeAt(i20);
            if (code14 === 47) {
                if (!matchedSlash) {
                    start = i20 + 1;
                    break;
                }
            } else {
                if (firstNonSlashEnd === -1) {
                    matchedSlash = false;
                    firstNonSlashEnd = i20 + 1;
                }
                if (extIdx >= 0) {
                    if (code14 === ext.charCodeAt(extIdx)) {
                        if (--extIdx === -1) {
                            end = i20;
                        }
                    } else {
                        extIdx = -1;
                        end = firstNonSlashEnd;
                    }
                }
            }
        }
        if (start === end) end = firstNonSlashEnd;
        else if (end === -1) end = path34.length;
        return path34.slice(start, end);
    } else {
        for(i20 = path34.length - 1; i20 >= 0; --i20){
            if (path34.charCodeAt(i20) === 47) {
                if (!matchedSlash) {
                    start = i20 + 1;
                    break;
                }
            } else if (end === -1) {
                matchedSlash = false;
                end = i20 + 1;
            }
        }
        if (end === -1) return "";
        return path34.slice(start, end);
    }
}
function extname1(path35) {
    assertPath(path35);
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let preDotState = 0;
    for(let i21 = path35.length - 1; i21 >= 0; --i21){
        const code15 = path35.charCodeAt(i21);
        if (code15 === 47) {
            if (!matchedSlash) {
                startPart = i21 + 1;
                break;
            }
            continue;
        }
        if (end === -1) {
            matchedSlash = false;
            end = i21 + 1;
        }
        if (code15 === 46) {
            if (startDot === -1) startDot = i21;
            else if (preDotState !== 1) preDotState = 1;
        } else if (startDot !== -1) {
            preDotState = -1;
        }
    }
    if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        return "";
    }
    return path35.slice(startDot, end);
}
function format1(pathObject) {
    if (pathObject === null || typeof pathObject !== "object") {
        throw new TypeError(`The "pathObject" argument must be of type Object. Received type ${typeof pathObject}`);
    }
    return _format("/", pathObject);
}
function parse1(path36) {
    assertPath(path36);
    const ret = {
        root: "",
        dir: "",
        base: "",
        ext: "",
        name: ""
    };
    if (path36.length === 0) return ret;
    const isAbsolute2 = path36.charCodeAt(0) === 47;
    let start;
    if (isAbsolute2) {
        ret.root = "/";
        start = 1;
    } else {
        start = 0;
    }
    let startDot = -1;
    let startPart = 0;
    let end = -1;
    let matchedSlash = true;
    let i22 = path36.length - 1;
    let preDotState = 0;
    for(; i22 >= start; --i22){
        const code16 = path36.charCodeAt(i22);
        if (code16 === 47) {
            if (!matchedSlash) {
                startPart = i22 + 1;
                break;
            }
            continue;
        }
        if (end === -1) {
            matchedSlash = false;
            end = i22 + 1;
        }
        if (code16 === 46) {
            if (startDot === -1) startDot = i22;
            else if (preDotState !== 1) preDotState = 1;
        } else if (startDot !== -1) {
            preDotState = -1;
        }
    }
    if (startDot === -1 || end === -1 || preDotState === 0 || preDotState === 1 && startDot === end - 1 && startDot === startPart + 1) {
        if (end !== -1) {
            if (startPart === 0 && isAbsolute2) {
                ret.base = ret.name = path36.slice(1, end);
            } else {
                ret.base = ret.name = path36.slice(startPart, end);
            }
        }
    } else {
        if (startPart === 0 && isAbsolute2) {
            ret.name = path36.slice(1, startDot);
            ret.base = path36.slice(1, end);
        } else {
            ret.name = path36.slice(startPart, startDot);
            ret.base = path36.slice(startPart, end);
        }
        ret.ext = path36.slice(startDot, end);
    }
    if (startPart > 0) ret.dir = path36.slice(0, startPart - 1);
    else if (isAbsolute2) ret.dir = "/";
    return ret;
}
function fromFileUrl1(url) {
    url = url instanceof URL ? url : new URL(url);
    if (url.protocol != "file:") {
        throw new TypeError("Must be a file URL.");
    }
    return decodeURIComponent(url.pathname.replace(/%(?![0-9A-Fa-f]{2})/g, "%25"));
}
function toFileUrl1(path37) {
    if (!isAbsolute1(path37)) {
        throw new TypeError("Must be an absolute path.");
    }
    const url = new URL("file:///");
    url.pathname = encodeWhitespace(path37.replace(/%/g, "%25").replace(/\\/g, "%5C"));
    return url;
}
const mod2 = {
    sep: sep1,
    delimiter: delimiter1,
    resolve: resolve1,
    normalize: normalize2,
    isAbsolute: isAbsolute1,
    join: join1,
    relative: relative1,
    toNamespacedPath: toNamespacedPath1,
    dirname: dirname1,
    basename: basename1,
    extname: extname1,
    format: format1,
    parse: parse1,
    fromFileUrl: fromFileUrl1,
    toFileUrl: toFileUrl1
};
const SEP = isWindows ? "\\" : "/";
const SEP_PATTERN = isWindows ? /[\\/]+/ : /\/+/;
const path = isWindows ? mod1 : mod2;
const { join: join2 , normalize: normalize3  } = path;
const regExpEscapeChars = [
    "!",
    "$",
    "(",
    ")",
    "*",
    "+",
    ".",
    "=",
    "?",
    "[",
    "\\",
    "^",
    "{",
    "|", 
];
const rangeEscapeChars = [
    "-",
    "\\",
    "]"
];
function globToRegExp(glob, { extended =true , globstar: globstarOption = true , os =osType , caseInsensitive =false  } = {}) {
    if (glob == "") {
        return /(?!)/;
    }
    const sep4 = os == "windows" ? "(?:\\\\|/)+" : "/+";
    const sepMaybe = os == "windows" ? "(?:\\\\|/)*" : "/*";
    const seps = os == "windows" ? [
        "\\",
        "/"
    ] : [
        "/"
    ];
    const globstar = os == "windows" ? "(?:[^\\\\/]*(?:\\\\|/|$)+)*" : "(?:[^/]*(?:/|$)+)*";
    const wildcard = os == "windows" ? "[^\\\\/]*" : "[^/]*";
    const escapePrefix = os == "windows" ? "`" : "\\";
    let newLength = glob.length;
    for(; newLength > 1 && seps.includes(glob[newLength - 1]); newLength--);
    glob = glob.slice(0, newLength);
    let regExpString = "";
    for(let j = 0; j < glob.length;){
        let segment = "";
        const groupStack = [];
        let inRange = false;
        let inEscape = false;
        let endsWithSep = false;
        let i23 = j;
        for(; i23 < glob.length && !seps.includes(glob[i23]); i23++){
            if (inEscape) {
                inEscape = false;
                const escapeChars = inRange ? rangeEscapeChars : regExpEscapeChars;
                segment += escapeChars.includes(glob[i23]) ? `\\${glob[i23]}` : glob[i23];
                continue;
            }
            if (glob[i23] == escapePrefix) {
                inEscape = true;
                continue;
            }
            if (glob[i23] == "[") {
                if (!inRange) {
                    inRange = true;
                    segment += "[";
                    if (glob[i23 + 1] == "!") {
                        i23++;
                        segment += "^";
                    } else if (glob[i23 + 1] == "^") {
                        i23++;
                        segment += "\\^";
                    }
                    continue;
                } else if (glob[i23 + 1] == ":") {
                    let k = i23 + 1;
                    let value = "";
                    while(glob[k + 1] != null && glob[k + 1] != ":"){
                        value += glob[k + 1];
                        k++;
                    }
                    if (glob[k + 1] == ":" && glob[k + 2] == "]") {
                        i23 = k + 2;
                        if (value == "alnum") segment += "\\dA-Za-z";
                        else if (value == "alpha") segment += "A-Za-z";
                        else if (value == "ascii") segment += "\x00-\x7F";
                        else if (value == "blank") segment += "\t ";
                        else if (value == "cntrl") segment += "\x00-\x1F\x7F";
                        else if (value == "digit") segment += "\\d";
                        else if (value == "graph") segment += "\x21-\x7E";
                        else if (value == "lower") segment += "a-z";
                        else if (value == "print") segment += "\x20-\x7E";
                        else if (value == "punct") {
                            segment += "!\"#$%&'()*+,\\-./:;<=>?@[\\\\\\]^_‘{|}~";
                        } else if (value == "space") segment += "\\s\v";
                        else if (value == "upper") segment += "A-Z";
                        else if (value == "word") segment += "\\w";
                        else if (value == "xdigit") segment += "\\dA-Fa-f";
                        continue;
                    }
                }
            }
            if (glob[i23] == "]" && inRange) {
                inRange = false;
                segment += "]";
                continue;
            }
            if (inRange) {
                if (glob[i23] == "\\") {
                    segment += `\\\\`;
                } else {
                    segment += glob[i23];
                }
                continue;
            }
            if (glob[i23] == ")" && groupStack.length > 0 && groupStack[groupStack.length - 1] != "BRACE") {
                segment += ")";
                const type21 = groupStack.pop();
                if (type21 == "!") {
                    segment += wildcard;
                } else if (type21 != "@") {
                    segment += type21;
                }
                continue;
            }
            if (glob[i23] == "|" && groupStack.length > 0 && groupStack[groupStack.length - 1] != "BRACE") {
                segment += "|";
                continue;
            }
            if (glob[i23] == "+" && extended && glob[i23 + 1] == "(") {
                i23++;
                groupStack.push("+");
                segment += "(?:";
                continue;
            }
            if (glob[i23] == "@" && extended && glob[i23 + 1] == "(") {
                i23++;
                groupStack.push("@");
                segment += "(?:";
                continue;
            }
            if (glob[i23] == "?") {
                if (extended && glob[i23 + 1] == "(") {
                    i23++;
                    groupStack.push("?");
                    segment += "(?:";
                } else {
                    segment += ".";
                }
                continue;
            }
            if (glob[i23] == "!" && extended && glob[i23 + 1] == "(") {
                i23++;
                groupStack.push("!");
                segment += "(?!";
                continue;
            }
            if (glob[i23] == "{") {
                groupStack.push("BRACE");
                segment += "(?:";
                continue;
            }
            if (glob[i23] == "}" && groupStack[groupStack.length - 1] == "BRACE") {
                groupStack.pop();
                segment += ")";
                continue;
            }
            if (glob[i23] == "," && groupStack[groupStack.length - 1] == "BRACE") {
                segment += "|";
                continue;
            }
            if (glob[i23] == "*") {
                if (extended && glob[i23 + 1] == "(") {
                    i23++;
                    groupStack.push("*");
                    segment += "(?:";
                } else {
                    const prevChar = glob[i23 - 1];
                    let numStars = 1;
                    while(glob[i23 + 1] == "*"){
                        i23++;
                        numStars++;
                    }
                    const nextChar = glob[i23 + 1];
                    if (globstarOption && numStars == 2 && [
                        ...seps,
                        undefined
                    ].includes(prevChar) && [
                        ...seps,
                        undefined
                    ].includes(nextChar)) {
                        segment += globstar;
                        endsWithSep = true;
                    } else {
                        segment += wildcard;
                    }
                }
                continue;
            }
            segment += regExpEscapeChars.includes(glob[i23]) ? `\\${glob[i23]}` : glob[i23];
        }
        if (groupStack.length > 0 || inRange || inEscape) {
            segment = "";
            for (const c of glob.slice(j, i23)){
                segment += regExpEscapeChars.includes(c) ? `\\${c}` : c;
                endsWithSep = false;
            }
        }
        regExpString += segment;
        if (!endsWithSep) {
            regExpString += i23 < glob.length ? sep4 : sepMaybe;
            endsWithSep = true;
        }
        while(seps.includes(glob[i23]))i23++;
        if (!(i23 > j)) {
            throw new Error("Assertion failure: i > j (potential infinite loop)");
        }
        j = i23;
    }
    regExpString = `^${regExpString}$`;
    return new RegExp(regExpString, caseInsensitive ? "i" : "");
}
function isGlob(str54) {
    const chars = {
        "{": "}",
        "(": ")",
        "[": "]"
    };
    const regex = /\\(.)|(^!|\*|\?|[\].+)]\?|\[[^\\\]]+\]|\{[^\\}]+\}|\(\?[:!=][^\\)]+\)|\([^|]+\|[^\\)]+\))/;
    if (str54 === "") {
        return false;
    }
    let match;
    while(match = regex.exec(str54)){
        if (match[2]) return true;
        let idx = match.index + match[0].length;
        const open = match[1];
        const close = open ? chars[open] : null;
        if (open && close) {
            const n = str54.indexOf(close, idx);
            if (n !== -1) {
                idx = n + 1;
            }
        }
        str54 = str54.slice(idx);
    }
    return false;
}
function normalizeGlob(glob, { globstar =false  } = {}) {
    if (glob.match(/\0/g)) {
        throw new Error(`Glob contains invalid characters: "${glob}"`);
    }
    if (!globstar) {
        return normalize3(glob);
    }
    const s = SEP_PATTERN.source;
    const badParentPattern = new RegExp(`(?<=(${s}|^)\\*\\*${s})\\.\\.(?=${s}|$)`, "g");
    return normalize3(glob.replace(badParentPattern, "\0")).replace(/\0/g, "..");
}
function joinGlobs(globs, { extended =true , globstar =false  } = {}) {
    if (!globstar || globs.length == 0) {
        return join2(...globs);
    }
    if (globs.length === 0) return ".";
    let joined;
    for (const glob of globs){
        const path1 = glob;
        if (path1.length > 0) {
            if (!joined) joined = path1;
            else joined += `${SEP}${path1}`;
        }
    }
    if (!joined) return ".";
    return normalizeGlob(joined, {
        extended,
        globstar
    });
}
const path1 = isWindows ? mod1 : mod2;
const posix = mod2;
const { basename: basename2 , delimiter: delimiter2 , dirname: dirname2 , extname: extname2 , format: format2 , fromFileUrl: fromFileUrl2 , isAbsolute: isAbsolute2 , join: join3 , normalize: normalize4 , parse: parse2 , relative: relative2 , resolve: resolve2 , sep: sep2 , toFileUrl: toFileUrl2 , toNamespacedPath: toNamespacedPath2 ,  } = path1;
function _createWalkEntrySync(path38) {
    path38 = normalize4(path38);
    const name71 = basename2(path38);
    const info1 = Deno.statSync(path38);
    return {
        path: path38,
        name: name71,
        isFile: info1.isFile,
        isDirectory: info1.isDirectory,
        isSymlink: info1.isSymlink
    };
}
function include(path39, exts, match, skip) {
    if (exts && !exts.some((ext)=>path39.endsWith(ext)
    )) {
        return false;
    }
    if (match && !match.some((pattern1)=>!!path39.match(pattern1)
    )) {
        return false;
    }
    if (skip && skip.some((pattern2)=>!!path39.match(pattern2)
    )) {
        return false;
    }
    return true;
}
function wrapErrorWithRootPath(err, root1) {
    if (err instanceof Error && "root" in err) return err;
    const e = new Error();
    e.root = root1;
    e.message = err instanceof Error ? `${err.message} for path "${root1}"` : `[non-error thrown] for path "${root1}"`;
    e.stack = err instanceof Error ? err.stack : undefined;
    e.cause = err instanceof Error ? err.cause : undefined;
    return e;
}
function* walkSync(root2, { maxDepth =Infinity , includeFiles =true , includeDirs =true , followSymlinks =false , exts =undefined , match =undefined , skip =undefined  } = {}) {
    if (maxDepth < 0) {
        return;
    }
    if (includeDirs && include(root2, exts, match, skip)) {
        yield _createWalkEntrySync(root2);
    }
    if (maxDepth < 1 || !include(root2, undefined, undefined, skip)) {
        return;
    }
    let entries;
    try {
        entries = Deno.readDirSync(root2);
    } catch (err) {
        throw wrapErrorWithRootPath(err, normalize4(root2));
    }
    for (const entry of entries){
        assert(entry.name != null);
        let path40 = join3(root2, entry.name);
        let { isSymlink , isDirectory  } = entry;
        if (isSymlink) {
            if (!followSymlinks) continue;
            path40 = Deno.realPathSync(path40);
            ({ isSymlink , isDirectory  } = Deno.lstatSync(path40));
        }
        if (isSymlink || isDirectory) {
            yield* walkSync(path40, {
                maxDepth: maxDepth - 1,
                includeFiles,
                includeDirs,
                followSymlinks,
                exts,
                match,
                skip
            });
        } else if (includeFiles && include(path40, exts, match, skip)) {
            yield {
                path: path40,
                ...entry
            };
        }
    }
}
function split(path41) {
    const s = SEP_PATTERN.source;
    const segments = path41.replace(new RegExp(`^${s}|${s}$`, "g"), "").split(SEP_PATTERN);
    const isAbsolute_ = isAbsolute2(path41);
    return {
        segments,
        isAbsolute: isAbsolute_,
        hasTrailingSep: !!path41.match(new RegExp(`${s}$`)),
        winRoot: isWindows && isAbsolute_ ? segments.shift() : undefined
    };
}
function throwUnlessNotFound(error5) {
    if (!(error5 instanceof Deno.errors.NotFound)) {
        throw error5;
    }
}
function comparePath(a, b) {
    if (a.path < b.path) return -1;
    if (a.path > b.path) return 1;
    return 0;
}
function* expandGlobSync(glob, { root: root3 = Deno.cwd() , exclude =[] , includeDirs =true , extended =true , globstar =false , caseInsensitive  } = {}) {
    const globOptions = {
        extended,
        globstar,
        caseInsensitive
    };
    const absRoot = resolve2(root3);
    const resolveFromRoot = (path42)=>resolve2(absRoot, path42)
    ;
    const excludePatterns = exclude.map(resolveFromRoot).map((s)=>globToRegExp(s, globOptions)
    );
    const shouldInclude1 = (path43)=>!excludePatterns.some((p)=>!!path43.match(p)
        )
    ;
    const { segments , isAbsolute: isGlobAbsolute , hasTrailingSep , winRoot  } = split(glob);
    let fixedRoot = isGlobAbsolute ? winRoot != undefined ? winRoot : "/" : absRoot;
    while(segments.length > 0 && !isGlob(segments[0])){
        const seg = segments.shift();
        assert(seg != null);
        fixedRoot = joinGlobs([
            fixedRoot,
            seg
        ], globOptions);
    }
    let fixedRootInfo;
    try {
        fixedRootInfo = _createWalkEntrySync(fixedRoot);
    } catch (error2) {
        return throwUnlessNotFound(error2);
    }
    function* advanceMatch(walkInfo, globSegment) {
        if (!walkInfo.isDirectory) {
            return;
        } else if (globSegment == "..") {
            const parentPath = joinGlobs([
                walkInfo.path,
                ".."
            ], globOptions);
            try {
                if (shouldInclude1(parentPath)) {
                    return yield _createWalkEntrySync(parentPath);
                }
            } catch (error6) {
                throwUnlessNotFound(error6);
            }
            return;
        } else if (globSegment == "**") {
            return yield* walkSync(walkInfo.path, {
                skip: excludePatterns
            });
        }
        const globPattern = globToRegExp(globSegment, globOptions);
        for (const walkEntry of walkSync(walkInfo.path, {
            maxDepth: 1,
            skip: excludePatterns
        })){
            if (walkEntry.path != walkInfo.path && walkEntry.name.match(globPattern)) {
                yield walkEntry;
            }
        }
    }
    let currentMatches = [
        fixedRootInfo
    ];
    for (const segment of segments){
        const nextMatchMap = new Map();
        for (const currentMatch of currentMatches){
            for (const nextMatch of advanceMatch(currentMatch, segment)){
                nextMatchMap.set(nextMatch.path, nextMatch);
            }
        }
        currentMatches = [
            ...nextMatchMap.values()
        ].sort(comparePath);
    }
    if (hasTrailingSep) {
        currentMatches = currentMatches.filter((entry)=>entry.isDirectory
        );
    }
    if (!includeDirs) {
        currentMatches = currentMatches.filter((entry)=>!entry.isDirectory
        );
    }
    yield* currentMatches;
}
var LogLevels;
(function(LogLevels1) {
    LogLevels1[LogLevels1["NOTSET"] = 0] = "NOTSET";
    LogLevels1[LogLevels1["DEBUG"] = 10] = "DEBUG";
    LogLevels1[LogLevels1["INFO"] = 20] = "INFO";
    LogLevels1[LogLevels1["WARNING"] = 30] = "WARNING";
    LogLevels1[LogLevels1["ERROR"] = 40] = "ERROR";
    LogLevels1[LogLevels1["CRITICAL"] = 50] = "CRITICAL";
})(LogLevels || (LogLevels = {}));
Object.keys(LogLevels).filter((key)=>isNaN(Number(key))
);
const byLevel = {
    [String(LogLevels.NOTSET)]: "NOTSET",
    [String(LogLevels.DEBUG)]: "DEBUG",
    [String(LogLevels.INFO)]: "INFO",
    [String(LogLevels.WARNING)]: "WARNING",
    [String(LogLevels.ERROR)]: "ERROR",
    [String(LogLevels.CRITICAL)]: "CRITICAL"
};
function getLevelByName(name72) {
    switch(name72){
        case "NOTSET":
            return LogLevels.NOTSET;
        case "DEBUG":
            return LogLevels.DEBUG;
        case "INFO":
            return LogLevels.INFO;
        case "WARNING":
            return LogLevels.WARNING;
        case "ERROR":
            return LogLevels.ERROR;
        case "CRITICAL":
            return LogLevels.CRITICAL;
        default:
            throw new Error(`no log level found for "${name72}"`);
    }
}
function getLevelName(level) {
    const levelName = byLevel[level];
    if (levelName) {
        return levelName;
    }
    throw new Error(`no level name found for level: ${level}`);
}
class LogRecord {
    msg;
    #args;
    #datetime;
    level;
    levelName;
    loggerName;
    constructor(options){
        this.msg = options.msg;
        this.#args = [
            ...options.args
        ];
        this.level = options.level;
        this.loggerName = options.loggerName;
        this.#datetime = new Date();
        this.levelName = getLevelName(options.level);
    }
    get args() {
        return [
            ...this.#args
        ];
    }
    get datetime() {
        return new Date(this.#datetime.getTime());
    }
}
class Logger {
    #level;
    #handlers;
    #loggerName;
    constructor(loggerName, levelName, options = {}){
        this.#loggerName = loggerName;
        this.#level = getLevelByName(levelName);
        this.#handlers = options.handlers || [];
    }
    get level() {
        return this.#level;
    }
    set level(level) {
        this.#level = level;
    }
    get levelName() {
        return getLevelName(this.#level);
    }
    set levelName(levelName) {
        this.#level = getLevelByName(levelName);
    }
    get loggerName() {
        return this.#loggerName;
    }
    set handlers(hndls) {
        this.#handlers = hndls;
    }
    get handlers() {
        return this.#handlers;
    }
    _log(level, msg, ...args) {
        if (this.level > level) {
            return msg instanceof Function ? undefined : msg;
        }
        let fnResult;
        let logMessage;
        if (msg instanceof Function) {
            fnResult = msg();
            logMessage = this.asString(fnResult);
        } else {
            logMessage = this.asString(msg);
        }
        const record = new LogRecord({
            msg: logMessage,
            args: args,
            level: level,
            loggerName: this.loggerName
        });
        this.#handlers.forEach((handler)=>{
            handler.handle(record);
        });
        return msg instanceof Function ? fnResult : msg;
    }
    asString(data1) {
        if (typeof data1 === "string") {
            return data1;
        } else if (data1 === null || typeof data1 === "number" || typeof data1 === "bigint" || typeof data1 === "boolean" || typeof data1 === "undefined" || typeof data1 === "symbol") {
            return String(data1);
        } else if (data1 instanceof Error) {
            return data1.stack;
        } else if (typeof data1 === "object") {
            return JSON.stringify(data1);
        }
        return "undefined";
    }
    debug(msg, ...args) {
        return this._log(LogLevels.DEBUG, msg, ...args);
    }
    info(msg, ...args) {
        return this._log(LogLevels.INFO, msg, ...args);
    }
    warning(msg, ...args) {
        return this._log(LogLevels.WARNING, msg, ...args);
    }
    error(msg, ...args) {
        return this._log(LogLevels.ERROR, msg, ...args);
    }
    critical(msg, ...args) {
        return this._log(LogLevels.CRITICAL, msg, ...args);
    }
}
async function exists(filePath) {
    try {
        await Deno.lstat(filePath);
        return true;
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            return false;
        }
        throw err;
    }
}
function existsSync(filePath) {
    try {
        Deno.lstatSync(filePath);
        return true;
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            return false;
        }
        throw err;
    }
}
function concat(...buf) {
    let length = 0;
    for (const b of buf){
        length += b.length;
    }
    const output = new Uint8Array(length);
    let index = 0;
    for (const b1 of buf){
        output.set(b1, index);
        index += b1.length;
    }
    return output;
}
function copy(src, dst, off = 0) {
    off = Math.max(0, Math.min(off, dst.byteLength));
    const dstBytesAvailable = dst.byteLength - off;
    if (src.byteLength > dstBytesAvailable) {
        src = src.subarray(0, dstBytesAvailable);
    }
    dst.set(src, off);
    return src.byteLength;
}
const MIN_READ = 32 * 1024;
const MAX_SIZE = 2 ** 32 - 2;
class Buffer {
    #buf;
    #off = 0;
    constructor(ab){
        this.#buf = ab === undefined ? new Uint8Array(0) : new Uint8Array(ab);
    }
    bytes(options = {
        copy: true
    }) {
        if (options.copy === false) return this.#buf.subarray(this.#off);
        return this.#buf.slice(this.#off);
    }
    empty() {
        return this.#buf.byteLength <= this.#off;
    }
    get length() {
        return this.#buf.byteLength - this.#off;
    }
    get capacity() {
        return this.#buf.buffer.byteLength;
    }
    truncate(n) {
        if (n === 0) {
            this.reset();
            return;
        }
        if (n < 0 || n > this.length) {
            throw Error("bytes.Buffer: truncation out of range");
        }
        this.#reslice(this.#off + n);
    }
    reset() {
        this.#reslice(0);
        this.#off = 0;
    }
     #tryGrowByReslice(n) {
        const l = this.#buf.byteLength;
        if (n <= this.capacity - l) {
            this.#reslice(l + n);
            return l;
        }
        return -1;
    }
     #reslice(len) {
        assert(len <= this.#buf.buffer.byteLength);
        this.#buf = new Uint8Array(this.#buf.buffer, 0, len);
    }
    readSync(p) {
        if (this.empty()) {
            this.reset();
            if (p.byteLength === 0) {
                return 0;
            }
            return null;
        }
        const nread = copy(this.#buf.subarray(this.#off), p);
        this.#off += nread;
        return nread;
    }
    read(p) {
        const rr = this.readSync(p);
        return Promise.resolve(rr);
    }
    writeSync(p) {
        const m = this.#grow(p.byteLength);
        return copy(p, this.#buf, m);
    }
    write(p) {
        const n1 = this.writeSync(p);
        return Promise.resolve(n1);
    }
     #grow(n2) {
        const m = this.length;
        if (m === 0 && this.#off !== 0) {
            this.reset();
        }
        const i = this.#tryGrowByReslice(n2);
        if (i >= 0) {
            return i;
        }
        const c = this.capacity;
        if (n2 <= Math.floor(c / 2) - m) {
            copy(this.#buf.subarray(this.#off), this.#buf);
        } else if (c + n2 > MAX_SIZE) {
            throw new Error("The buffer cannot be grown beyond the maximum size.");
        } else {
            const buf = new Uint8Array(Math.min(2 * c + n2, MAX_SIZE));
            copy(this.#buf.subarray(this.#off), buf);
            this.#buf = buf;
        }
        this.#off = 0;
        this.#reslice(Math.min(m + n2, MAX_SIZE));
        return m;
    }
    grow(n3) {
        if (n3 < 0) {
            throw Error("Buffer.grow: negative count");
        }
        const m = this.#grow(n3);
        this.#reslice(m);
    }
    async readFrom(r) {
        let n4 = 0;
        const tmp = new Uint8Array(MIN_READ);
        while(true){
            const shouldGrow = this.capacity - this.length < MIN_READ;
            const buf = shouldGrow ? tmp : new Uint8Array(this.#buf.buffer, this.length);
            const nread = await r.read(buf);
            if (nread === null) {
                return n4;
            }
            if (shouldGrow) this.writeSync(buf.subarray(0, nread));
            else this.#reslice(this.length + nread);
            n4 += nread;
        }
    }
    readFromSync(r) {
        let n5 = 0;
        const tmp = new Uint8Array(MIN_READ);
        while(true){
            const shouldGrow = this.capacity - this.length < MIN_READ;
            const buf = shouldGrow ? tmp : new Uint8Array(this.#buf.buffer, this.length);
            const nread = r.readSync(buf);
            if (nread === null) {
                return n5;
            }
            if (shouldGrow) this.writeSync(buf.subarray(0, nread));
            else this.#reslice(this.length + nread);
            n5 += nread;
        }
    }
}
const DEFAULT_BUF_SIZE = 4096;
const MIN_BUF_SIZE = 16;
const CR = "\r".charCodeAt(0);
const LF = "\n".charCodeAt(0);
class BufferFullError extends Error {
    partial;
    name = "BufferFullError";
    constructor(partial){
        super("Buffer full");
        this.partial = partial;
    }
}
class PartialReadError extends Error {
    name = "PartialReadError";
    partial;
    constructor(){
        super("Encountered UnexpectedEof, data only partially read");
    }
}
class BufReader {
    #buf;
    #rd;
    #r = 0;
    #w = 0;
    #eof = false;
    static create(r, size = 4096) {
        return r instanceof BufReader ? r : new BufReader(r, size);
    }
    constructor(rd, size = 4096){
        if (size < 16) {
            size = MIN_BUF_SIZE;
        }
        this.#reset(new Uint8Array(size), rd);
    }
    size() {
        return this.#buf.byteLength;
    }
    buffered() {
        return this.#w - this.#r;
    }
    #fill = async ()=>{
        if (this.#r > 0) {
            this.#buf.copyWithin(0, this.#r, this.#w);
            this.#w -= this.#r;
            this.#r = 0;
        }
        if (this.#w >= this.#buf.byteLength) {
            throw Error("bufio: tried to fill full buffer");
        }
        for(let i24 = 100; i24 > 0; i24--){
            const rr = await this.#rd.read(this.#buf.subarray(this.#w));
            if (rr === null) {
                this.#eof = true;
                return;
            }
            assert(rr >= 0, "negative read");
            this.#w += rr;
            if (rr > 0) {
                return;
            }
        }
        throw new Error(`No progress after ${100} read() calls`);
    };
    reset(r) {
        this.#reset(this.#buf, r);
    }
    #reset = (buf, rd)=>{
        this.#buf = buf;
        this.#rd = rd;
        this.#eof = false;
    };
    async read(p) {
        let rr = p.byteLength;
        if (p.byteLength === 0) return rr;
        if (this.#r === this.#w) {
            if (p.byteLength >= this.#buf.byteLength) {
                const rr = await this.#rd.read(p);
                const nread = rr ?? 0;
                assert(nread >= 0, "negative read");
                return rr;
            }
            this.#r = 0;
            this.#w = 0;
            rr = await this.#rd.read(this.#buf);
            if (rr === 0 || rr === null) return rr;
            assert(rr >= 0, "negative read");
            this.#w += rr;
        }
        const copied = copy(this.#buf.subarray(this.#r, this.#w), p, 0);
        this.#r += copied;
        return copied;
    }
    async readFull(p) {
        let bytesRead = 0;
        while(bytesRead < p.length){
            try {
                const rr = await this.read(p.subarray(bytesRead));
                if (rr === null) {
                    if (bytesRead === 0) {
                        return null;
                    } else {
                        throw new PartialReadError();
                    }
                }
                bytesRead += rr;
            } catch (err) {
                if (err instanceof PartialReadError) {
                    err.partial = p.subarray(0, bytesRead);
                } else if (err instanceof Error) {
                    const e = new PartialReadError();
                    e.partial = p.subarray(0, bytesRead);
                    e.stack = err.stack;
                    e.message = err.message;
                    e.cause = err.cause;
                    throw err;
                }
                throw err;
            }
        }
        return p;
    }
    async readByte() {
        while(this.#r === this.#w){
            if (this.#eof) return null;
            await this.#fill();
        }
        const c = this.#buf[this.#r];
        this.#r++;
        return c;
    }
    async readString(delim) {
        if (delim.length !== 1) {
            throw new Error("Delimiter should be a single character");
        }
        const buffer = await this.readSlice(delim.charCodeAt(0));
        if (buffer === null) return null;
        return new TextDecoder().decode(buffer);
    }
    async readLine() {
        let line = null;
        try {
            line = await this.readSlice(LF);
        } catch (err) {
            if (err instanceof Deno.errors.BadResource) {
                throw err;
            }
            let partial;
            if (err instanceof PartialReadError) {
                partial = err.partial;
                assert(partial instanceof Uint8Array, "bufio: caught error from `readSlice()` without `partial` property");
            }
            if (!(err instanceof BufferFullError)) {
                throw err;
            }
            partial = err.partial;
            if (!this.#eof && partial && partial.byteLength > 0 && partial[partial.byteLength - 1] === CR) {
                assert(this.#r > 0, "bufio: tried to rewind past start of buffer");
                this.#r--;
                partial = partial.subarray(0, partial.byteLength - 1);
            }
            if (partial) {
                return {
                    line: partial,
                    more: !this.#eof
                };
            }
        }
        if (line === null) {
            return null;
        }
        if (line.byteLength === 0) {
            return {
                line,
                more: false
            };
        }
        if (line[line.byteLength - 1] == LF) {
            let drop = 1;
            if (line.byteLength > 1 && line[line.byteLength - 2] === CR) {
                drop = 2;
            }
            line = line.subarray(0, line.byteLength - drop);
        }
        return {
            line,
            more: false
        };
    }
    async readSlice(delim) {
        let s = 0;
        let slice1;
        while(true){
            let i25 = this.#buf.subarray(this.#r + s, this.#w).indexOf(delim);
            if (i25 >= 0) {
                i25 += s;
                slice1 = this.#buf.subarray(this.#r, this.#r + i25 + 1);
                this.#r += i25 + 1;
                break;
            }
            if (this.#eof) {
                if (this.#r === this.#w) {
                    return null;
                }
                slice1 = this.#buf.subarray(this.#r, this.#w);
                this.#r = this.#w;
                break;
            }
            if (this.buffered() >= this.#buf.byteLength) {
                this.#r = this.#w;
                const oldbuf = this.#buf;
                const newbuf = this.#buf.slice(0);
                this.#buf = newbuf;
                throw new BufferFullError(oldbuf);
            }
            s = this.#w - this.#r;
            try {
                await this.#fill();
            } catch (err) {
                if (err instanceof PartialReadError) {
                    err.partial = slice1;
                } else if (err instanceof Error) {
                    const e = new PartialReadError();
                    e.partial = slice1;
                    e.stack = err.stack;
                    e.message = err.message;
                    e.cause = err.cause;
                    throw err;
                }
                throw err;
            }
        }
        return slice1;
    }
    async peek(n6) {
        if (n6 < 0) {
            throw Error("negative count");
        }
        let avail = this.#w - this.#r;
        while(avail < n6 && avail < this.#buf.byteLength && !this.#eof){
            try {
                await this.#fill();
            } catch (err) {
                if (err instanceof PartialReadError) {
                    err.partial = this.#buf.subarray(this.#r, this.#w);
                } else if (err instanceof Error) {
                    const e = new PartialReadError();
                    e.partial = this.#buf.subarray(this.#r, this.#w);
                    e.stack = err.stack;
                    e.message = err.message;
                    e.cause = err.cause;
                    throw err;
                }
                throw err;
            }
            avail = this.#w - this.#r;
        }
        if (avail === 0 && this.#eof) {
            return null;
        } else if (avail < n6 && this.#eof) {
            return this.#buf.subarray(this.#r, this.#r + avail);
        } else if (avail < n6) {
            throw new BufferFullError(this.#buf.subarray(this.#r, this.#w));
        }
        return this.#buf.subarray(this.#r, this.#r + n6);
    }
}
class AbstractBufBase {
    buf;
    usedBufferBytes = 0;
    err = null;
    constructor(buf){
        this.buf = buf;
    }
    size() {
        return this.buf.byteLength;
    }
    available() {
        return this.buf.byteLength - this.usedBufferBytes;
    }
    buffered() {
        return this.usedBufferBytes;
    }
}
class BufWriter extends AbstractBufBase {
    #writer;
    static create(writer, size = 4096) {
        return writer instanceof BufWriter ? writer : new BufWriter(writer, size);
    }
    constructor(writer, size = 4096){
        if (size <= 0) {
            size = DEFAULT_BUF_SIZE;
        }
        const buf = new Uint8Array(size);
        super(buf);
        this.#writer = writer;
    }
    reset(w) {
        this.err = null;
        this.usedBufferBytes = 0;
        this.#writer = w;
    }
    async flush() {
        if (this.err !== null) throw this.err;
        if (this.usedBufferBytes === 0) return;
        try {
            const p = this.buf.subarray(0, this.usedBufferBytes);
            let nwritten = 0;
            while(nwritten < p.length){
                nwritten += await this.#writer.write(p.subarray(nwritten));
            }
        } catch (e) {
            if (e instanceof Error) {
                this.err = e;
            }
            throw e;
        }
        this.buf = new Uint8Array(this.buf.length);
        this.usedBufferBytes = 0;
    }
    async write(data2) {
        if (this.err !== null) throw this.err;
        if (data2.length === 0) return 0;
        let totalBytesWritten = 0;
        let numBytesWritten = 0;
        while(data2.byteLength > this.available()){
            if (this.buffered() === 0) {
                try {
                    numBytesWritten = await this.#writer.write(data2);
                } catch (e) {
                    if (e instanceof Error) {
                        this.err = e;
                    }
                    throw e;
                }
            } else {
                numBytesWritten = copy(data2, this.buf, this.usedBufferBytes);
                this.usedBufferBytes += numBytesWritten;
                await this.flush();
            }
            totalBytesWritten += numBytesWritten;
            data2 = data2.subarray(numBytesWritten);
        }
        numBytesWritten = copy(data2, this.buf, this.usedBufferBytes);
        this.usedBufferBytes += numBytesWritten;
        totalBytesWritten += numBytesWritten;
        return totalBytesWritten;
    }
}
class BufWriterSync extends AbstractBufBase {
    #writer;
    static create(writer, size = 4096) {
        return writer instanceof BufWriterSync ? writer : new BufWriterSync(writer, size);
    }
    constructor(writer, size = 4096){
        if (size <= 0) {
            size = DEFAULT_BUF_SIZE;
        }
        const buf = new Uint8Array(size);
        super(buf);
        this.#writer = writer;
    }
    reset(w) {
        this.err = null;
        this.usedBufferBytes = 0;
        this.#writer = w;
    }
    flush() {
        if (this.err !== null) throw this.err;
        if (this.usedBufferBytes === 0) return;
        try {
            const p = this.buf.subarray(0, this.usedBufferBytes);
            let nwritten = 0;
            while(nwritten < p.length){
                nwritten += this.#writer.writeSync(p.subarray(nwritten));
            }
        } catch (e) {
            if (e instanceof Error) {
                this.err = e;
            }
            throw e;
        }
        this.buf = new Uint8Array(this.buf.length);
        this.usedBufferBytes = 0;
    }
    writeSync(data3) {
        if (this.err !== null) throw this.err;
        if (data3.length === 0) return 0;
        let totalBytesWritten = 0;
        let numBytesWritten = 0;
        while(data3.byteLength > this.available()){
            if (this.buffered() === 0) {
                try {
                    numBytesWritten = this.#writer.writeSync(data3);
                } catch (e) {
                    if (e instanceof Error) {
                        this.err = e;
                    }
                    throw e;
                }
            } else {
                numBytesWritten = copy(data3, this.buf, this.usedBufferBytes);
                this.usedBufferBytes += numBytesWritten;
                this.flush();
            }
            totalBytesWritten += numBytesWritten;
            data3 = data3.subarray(numBytesWritten);
        }
        numBytesWritten = copy(data3, this.buf, this.usedBufferBytes);
        this.usedBufferBytes += numBytesWritten;
        totalBytesWritten += numBytesWritten;
        return totalBytesWritten;
    }
}
async function* readLines(reader, decoderOpts) {
    const bufReader = new BufReader(reader);
    let chunks = [];
    const decoder = new TextDecoder(decoderOpts?.encoding, decoderOpts);
    while(true){
        const res = await bufReader.readLine();
        if (!res) {
            if (chunks.length > 0) {
                yield decoder.decode(concat(...chunks));
            }
            break;
        }
        chunks.push(res.line);
        if (!res.more) {
            yield decoder.decode(concat(...chunks));
            chunks = [];
        }
    }
}
const DEFAULT_FORMATTER = "{levelName} {msg}";
class BaseHandler {
    level;
    levelName;
    formatter;
    constructor(levelName, options = {}){
        this.level = getLevelByName(levelName);
        this.levelName = levelName;
        this.formatter = options.formatter || DEFAULT_FORMATTER;
    }
    handle(logRecord) {
        if (this.level > logRecord.level) return;
        const msg = this.format(logRecord);
        return this.log(msg);
    }
    format(logRecord) {
        if (this.formatter instanceof Function) {
            return this.formatter(logRecord);
        }
        return this.formatter.replace(/{(\S+)}/g, (match, p1)=>{
            const value = logRecord[p1];
            if (value == null) {
                return match;
            }
            return String(value);
        });
    }
    log(_msg) {}
    async setup() {}
    async destroy() {}
}
class ConsoleHandler extends BaseHandler {
    format(logRecord) {
        let msg = super.format(logRecord);
        switch(logRecord.level){
            case LogLevels.INFO:
                msg = blue(msg);
                break;
            case LogLevels.WARNING:
                msg = yellow(msg);
                break;
            case LogLevels.ERROR:
                msg = red(msg);
                break;
            case LogLevels.CRITICAL:
                msg = bold(red(msg));
                break;
            default:
                break;
        }
        return msg;
    }
    log(msg) {
        console.log(msg);
    }
}
class WriterHandler extends BaseHandler {
    _writer;
    #encoder = new TextEncoder();
}
class FileHandler extends WriterHandler {
    _file;
    _buf;
    _filename;
    _mode;
    _openOptions;
    _encoder = new TextEncoder();
    #unloadCallback = (()=>{
        this.destroy();
    }).bind(this);
    constructor(levelName, options){
        super(levelName, options);
        this._filename = options.filename;
        this._mode = options.mode ? options.mode : "a";
        this._openOptions = {
            createNew: this._mode === "x",
            create: this._mode !== "x",
            append: this._mode === "a",
            truncate: this._mode !== "a",
            write: true
        };
    }
    async setup() {
        this._file = await Deno.open(this._filename, this._openOptions);
        this._writer = this._file;
        this._buf = new BufWriterSync(this._file);
        addEventListener("unload", this.#unloadCallback);
    }
    handle(logRecord) {
        super.handle(logRecord);
        if (logRecord.level > LogLevels.ERROR) {
            this.flush();
        }
    }
    log(msg) {
        if (this._encoder.encode(msg).byteLength + 1 > this._buf.available()) {
            this.flush();
        }
        this._buf.writeSync(this._encoder.encode(msg + "\n"));
    }
    flush() {
        if (this._buf?.buffered() > 0) {
            this._buf.flush();
        }
    }
    destroy() {
        this.flush();
        this._file?.close();
        this._file = undefined;
        removeEventListener("unload", this.#unloadCallback);
        return Promise.resolve();
    }
}
const DEFAULT_LEVEL = "INFO";
const DEFAULT_CONFIG = {
    handlers: {
        default: new ConsoleHandler(DEFAULT_LEVEL)
    },
    loggers: {
        default: {
            level: DEFAULT_LEVEL,
            handlers: [
                "default"
            ]
        }
    }
};
const state = {
    handlers: new Map(),
    loggers: new Map(),
    config: DEFAULT_CONFIG
};
function getLogger(name73) {
    if (!name73) {
        const d = state.loggers.get("default");
        assert(d != null, `"default" logger must be set for getting logger without name`);
        return d;
    }
    const result = state.loggers.get(name73);
    if (!result) {
        const logger = new Logger(name73, "NOTSET", {
            handlers: []
        });
        state.loggers.set(name73, logger);
        return logger;
    }
    return result;
}
function debug(msg, ...args) {
    if (msg instanceof Function) {
        return getLogger("default").debug(msg, ...args);
    }
    return getLogger("default").debug(msg, ...args);
}
function info(msg, ...args) {
    if (msg instanceof Function) {
        return getLogger("default").info(msg, ...args);
    }
    return getLogger("default").info(msg, ...args);
}
function warning(msg, ...args) {
    if (msg instanceof Function) {
        return getLogger("default").warning(msg, ...args);
    }
    return getLogger("default").warning(msg, ...args);
}
function error(msg, ...args) {
    if (msg instanceof Function) {
        return getLogger("default").error(msg, ...args);
    }
    return getLogger("default").error(msg, ...args);
}
async function setup(config) {
    state.config = {
        handlers: {
            ...DEFAULT_CONFIG.handlers,
            ...config.handlers
        },
        loggers: {
            ...DEFAULT_CONFIG.loggers,
            ...config.loggers
        }
    };
    state.handlers.forEach((handler)=>{
        handler.destroy();
    });
    state.handlers.clear();
    const handlers1 = state.config.handlers || {};
    for(const handlerName1 in handlers1){
        const handler = handlers1[handlerName1];
        await handler.setup();
        state.handlers.set(handlerName1, handler);
    }
    state.loggers.clear();
    const loggers = state.config.loggers || {};
    for(const loggerName in loggers){
        const loggerConfig = loggers[loggerName];
        const handlerNames = loggerConfig.handlers || [];
        const handlers2 = [];
        handlerNames.forEach((handlerName)=>{
            const handler = state.handlers.get(handlerName);
            if (handler) {
                handlers2.push(handler);
            }
        });
        const levelName = loggerConfig.level || DEFAULT_LEVEL;
        const logger = new Logger(loggerName, levelName, {
            handlers: handlers2
        });
        state.loggers.set(loggerName, logger);
    }
}
await setup(DEFAULT_CONFIG);
function isSubdir(src, dest, sep5 = sep2) {
    if (src === dest) {
        return false;
    }
    const srcArray = src.split(sep5);
    const destArray = dest.split(sep5);
    return srcArray.every((current, i26)=>destArray[i26] === current
    );
}
function getFileInfoType(fileInfo) {
    return fileInfo.isFile ? "file" : fileInfo.isDirectory ? "dir" : fileInfo.isSymlink ? "symlink" : undefined;
}
async function ensureDir(dir) {
    try {
        const fileInfo = await Deno.lstat(dir);
        if (!fileInfo.isDirectory) {
            throw new Error(`Ensure path exists, expected 'dir', got '${getFileInfoType(fileInfo)}'`);
        }
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            await Deno.mkdir(dir, {
                recursive: true
            });
            return;
        }
        throw err;
    }
}
function ensureDirSync(dir) {
    try {
        const fileInfo = Deno.lstatSync(dir);
        if (!fileInfo.isDirectory) {
            throw new Error(`Ensure path exists, expected 'dir', got '${getFileInfoType(fileInfo)}'`);
        }
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            Deno.mkdirSync(dir, {
                recursive: true
            });
            return;
        }
        throw err;
    }
}
function moveSync(src, dest, { overwrite =false  } = {}) {
    const srcStat = Deno.statSync(src);
    if (srcStat.isDirectory && isSubdir(src, dest)) {
        throw new Error(`Cannot move '${src}' to a subdirectory of itself, '${dest}'.`);
    }
    if (overwrite) {
        if (existsSync(dest)) {
            Deno.removeSync(dest, {
                recursive: true
            });
        }
    } else {
        if (existsSync(dest)) {
            throw new Error("dest already exists.");
        }
    }
    Deno.renameSync(src, dest);
}
var EOL;
(function(EOL1) {
    EOL1["LF"] = "\n";
    EOL1["CRLF"] = "\r\n";
})(EOL || (EOL = {}));
function glb(array, value, compare) {
    compare = compare || ((a, b)=>a - b
    );
    if (array.length === 0) {
        return -1;
    }
    if (array.length === 1) {
        if (compare(value, array[0]) < 0) {
            return -1;
        } else {
            return 0;
        }
    }
    let left = 0;
    let right = array.length - 1;
    const vLeft = array[left], vRight = array[right];
    if (compare(value, vRight) >= 0) {
        return right;
    }
    if (compare(value, vLeft) < 0) {
        return -1;
    }
    while(right - left > 1){
        const center = left + (right - left >> 1);
        const vCenter = array[center];
        const cmp = compare(value, vCenter);
        if (cmp < 0) {
            right = center;
        } else if (cmp === 0) {
            left = center;
        } else {
            left = center;
        }
    }
    return left;
}
function lines(text) {
    return text.split(/\r?\n/);
}
function normalizeNewlines(text) {
    return lines(text).join("\n");
}
function* matchAll(text, regexp1) {
    let match;
    while((match = regexp1.exec(text)) !== null){
        yield match;
    }
}
function* lineOffsets(text) {
    yield 0;
    for (const match of matchAll(text, /\r?\n/g)){
        yield match.index + match[0].length;
    }
}
function* lineBreakPositions(text) {
    for (const match of matchAll(text, /\r?\n/g)){
        yield match.index;
    }
}
function indexToRowCol(text) {
    const offsets = Array.from(lineOffsets(text));
    return function(offset) {
        if (offset === 0) {
            return {
                line: 0,
                column: 0
            };
        }
        const startIndex = glb(offsets, offset);
        return {
            line: startIndex,
            column: offset - offsets[startIndex]
        };
    };
}
function formatLineRange(text, firstLine, lastLine) {
    const lineWidth = Math.max(String(firstLine + 1).length, String(lastLine + 1).length);
    const pad = " ".repeat(lineWidth);
    const ls = lines(text);
    const result = [];
    for(let i27 = firstLine; i27 <= lastLine; ++i27){
        const numberStr = `${pad}${i27 + 1}: `.slice(-(lineWidth + 2));
        const lineStr = ls[i27];
        result.push({
            lineNumber: i27,
            content: numberStr + lineStr,
            rawLine: ls[i27]
        });
    }
    return {
        prefixWidth: lineWidth + 2,
        lines: result
    };
}
function mappedString(source, pieces) {
    if (typeof source === "string") {
        const offsetInfo = [];
        let offset = 0;
        const resultList = pieces.filter((piece)=>typeof piece === "string" || piece.start !== piece.end
        ).map((piece)=>{
            if (typeof piece === "string") {
                offsetInfo.push({
                    fromSource: false,
                    length: piece.length,
                    offset
                });
                offset += piece.length;
                return piece;
            } else {
                const resultPiece = source.substring(piece.start, piece.end);
                offsetInfo.push({
                    fromSource: true,
                    length: resultPiece.length,
                    offset,
                    range: {
                        start: piece.start,
                        end: piece.end
                    }
                });
                offset += resultPiece.length;
                return resultPiece;
            }
        });
        const value = resultList.join("");
        const map1 = (targetOffset)=>{
            const ix = glb(offsetInfo, {
                offset: targetOffset
            }, (a, b)=>a.offset - b.offset
            );
            if (ix < 0) {
                return undefined;
            }
            const info2 = offsetInfo[ix];
            if (!info2.fromSource) {
                return undefined;
            }
            const localOffset = targetOffset - info2.offset;
            if (localOffset >= info2.length) {
                return undefined;
            }
            return info2.range.start + localOffset;
        };
        const mapClosest = (targetOffset)=>{
            if (offsetInfo.length === 0 || targetOffset < 0) {
                return undefined;
            }
            const firstIx = glb(offsetInfo, {
                offset: targetOffset
            }, (a, b)=>a.offset - b.offset
            );
            let ix = firstIx;
            let smallestSourceInfo = undefined;
            while(ix >= 0){
                const info3 = offsetInfo[ix];
                if (!info3.fromSource) {
                    ix--;
                    continue;
                }
                smallestSourceInfo = info3;
                if (ix === firstIx) {
                    const localOffset = targetOffset - info3.offset;
                    if (localOffset < info3.length) {
                        return info3.range.start + localOffset;
                    }
                }
                return info3.range.end - 1;
            }
            if (smallestSourceInfo === undefined) {
                return undefined;
            } else {
                return smallestSourceInfo.range.start;
            }
        };
        return {
            value,
            originalString: source,
            map: map1,
            mapClosest
        };
    } else {
        const { value , originalString , map: previousMap , mapClosest: previousMapClosest ,  } = source;
        const { value: resultValue , map: nextMap , mapClosest: nextMapClosest ,  } = mappedString(value, pieces);
        const composeMap = (offset)=>{
            const v = nextMap(offset);
            if (v === undefined) {
                return v;
            }
            return previousMap(v);
        };
        const composeMapClosest = (offset)=>{
            const v = nextMapClosest(offset);
            if (v === undefined) {
                return v;
            }
            return previousMapClosest(v);
        };
        return {
            value: resultValue,
            originalString,
            map: composeMap,
            mapClosest: composeMapClosest
        };
    }
}
function asMappedString(str55) {
    if (typeof str55 === "string") {
        return {
            value: str55,
            originalString: str55,
            map: (x)=>x
            ,
            mapClosest: (x)=>x
        };
    } else {
        return str55;
    }
}
function mappedConcat(strings) {
    if (strings.length === 0) {
        throw new Error("strings must be non-empty");
    }
    let currentOffset = 0;
    const offsets = [];
    for (const s1 of strings){
        currentOffset += s1.value.length;
        offsets.push(currentOffset);
    }
    const value = "".concat(...strings.map((s)=>s.value
    ));
    return {
        value,
        originalString: strings[0].originalString,
        map (offset) {
            if (offset < 0 || offset >= value.length) {
                return undefined;
            }
            const ix = glb(offsets, offset);
            return strings[ix].map(offset - offsets[ix]);
        },
        mapClosest (offset) {
            if (offset < 0 || offset >= value.length) {
                return undefined;
            }
            const ix = glb(offsets, offset);
            return strings[ix].mapClosest(offset - offsets[ix]);
        }
    };
}
function mappedIndexToRowCol(eitherText) {
    const text = asMappedString(eitherText);
    const f = indexToRowCol(text.originalString);
    return function(offset) {
        const n1 = text.mapClosest(offset);
        if (n1 === undefined) {
            throw new Error("Internal Error: bad offset in mappedIndexRowCol");
        }
        return f(n1);
    };
}
function mappedNormalizeNewlines(eitherText) {
    const text = asMappedString(eitherText);
    let start = 0;
    const chunks = [];
    for (const offset of lineBreakPositions(text.value)){
        if (text.value[offset] !== "\r") {
            continue;
        }
        chunks.push({
            start,
            end: offset
        });
        chunks.push({
            start: offset + 1,
            end: offset + 2
        });
        start = offset + 2;
    }
    if (start !== text.value.length) {
        chunks.push({
            start,
            end: text.value.length
        });
    }
    return mappedString(text, chunks);
}
function skipRegexpAll(eitherText, re) {
    const text = asMappedString(eitherText);
    let start = 0;
    const chunks = [];
    for (const match of matchAll(text.value, re)){
        chunks.push({
            start,
            end: match.index
        });
        start = match[0].length + match.index;
    }
    if (start !== text.value.length) {
        chunks.push({
            start,
            end: text.value.length
        });
    }
    return mappedString(text, chunks);
}
function skipRegexp(eitherText, re) {
    const text = asMappedString(eitherText);
    const m = text.value.match(re);
    if (m) {
        return mappedString(text, [
            {
                start: 0,
                end: m.index
            },
            {
                start: m.index + m[0].length,
                end: text.value.length
            }, 
        ]);
    } else {
        return text;
    }
}
function schemaType(schema) {
    const t = schema.type;
    if (t) {
        return t;
    }
    if (schema.anyOf) {
        return "anyOf";
    }
    if (schema.oneOf) {
        return "oneOf";
    }
    if (schema.allOf) {
        return "allOf";
    }
    if (schema.enum) {
        return "enum";
    }
    return "any";
}
function schemaExhaustiveCompletions(schema) {
    switch(schemaType(schema)){
        case "anyOf":
            return schema.anyOf.every(schemaExhaustiveCompletions);
        case "oneOf":
            return schema.oneOf.every(schemaExhaustiveCompletions);
        case "allOf":
            return schema.allOf.every(schemaExhaustiveCompletions);
        case "array":
            return true;
        case "object":
            return true;
        default:
            return schema.exhaustiveCompletions || false;
    }
}
function walkSchema(schema, f) {
    f(schema);
    const t = schemaType(schema);
    switch(t){
        case "array":
            if (schema.items) {
                walkSchema(schema.items, f);
            }
            break;
        case "anyOf":
            for (const s of schema.anyOf){
                walkSchema(s, f);
            }
            break;
        case "oneOf":
            for (const s1 of schema.oneOf){
                walkSchema(s1, f);
            }
            break;
        case "allOf":
            for (const s2 of schema.allOf){
                walkSchema(s2, f);
            }
            break;
        case "object":
            if (schema.properties) {
                for (const key of Object.getOwnPropertyNames(schema.properties)){
                    const s = schema.properties[key];
                    walkSchema(s, f);
                }
            }
            if (schema.patternProperties) {
                for (const key of Object.getOwnPropertyNames(schema.patternProperties)){
                    const s = schema.patternProperties[key];
                    walkSchema(s, f);
                }
            }
            if (schema.additionalProperties) {
                walkSchema(schema.additionalProperties, f);
            }
            break;
    }
}
function normalizeSchema(schema1) {
    const result = JSON.parse(JSON.stringify(schema1));
    walkSchema(result, (schema)=>{
        if (schema.completions) {
            delete schema.completions;
        }
        if (schema.exhaustiveCompletions) {
            delete schema.exhaustiveCompletions;
        }
        if (schema.documentation) {
            delete schema.documentation;
        }
    });
    return result;
}
let ajv = undefined;
function setupAjv(_ajv) {
    ajv = _ajv;
}
function navigate(path44, annotation, returnKey = false, pathIndex = 0) {
    if (pathIndex >= path44.length) {
        return annotation;
    }
    if (annotation.kind === "mapping" || annotation.kind === "block_mapping") {
        const { components  } = annotation;
        const searchKey = path44[pathIndex];
        const lastKeyIndex = ~~((components.length - 1) / 2) * 2;
        for(let i28 = lastKeyIndex; i28 >= 0; i28 -= 2){
            const key = components[i28].result;
            if (key === searchKey) {
                if (returnKey && pathIndex === path44.length - 1) {
                    return navigate(path44, components[i28], returnKey, pathIndex + 1);
                } else {
                    return navigate(path44, components[i28 + 1], returnKey, pathIndex + 1);
                }
            }
        }
        throw new Error("Internal error: searchKey not found in mapping object");
    } else if (annotation.kind === "sequence" || annotation.kind === "block_sequence") {
        const searchKey = Number(path44[pathIndex]);
        return navigate(path44, annotation.components[searchKey], returnKey, pathIndex + 1);
    } else {
        throw new Error(`Internal error: unexpected kind ${annotation.kind}`);
    }
}
function navigateSchema(path45, schema, pathIndex = 0) {
    if (pathIndex >= path45.length - 1) {
        return schema;
    }
    const pathVal = path45[pathIndex];
    if (pathVal === "patternProperties") {
        const key = path45[pathIndex + 1];
        const subSchema = schema.patternProperties[key];
        return navigateSchema(path45, subSchema, pathIndex + 2);
    } else if (pathVal === "properties") {
        const key = path45[pathIndex + 1];
        const subSchema = schema.properties[key];
        return navigateSchema(path45, subSchema, pathIndex + 2);
    } else if (pathVal === "anyOf") {
        const key = Number(path45[pathIndex + 1]);
        const subSchema = schema.anyOf[key];
        return navigateSchema(path45, subSchema, pathIndex + 2);
    } else if (pathVal === "oneOf") {
        const key = Number(path45[pathIndex + 1]);
        const subSchema = schema.oneOf[key];
        return navigateSchema(path45, subSchema, pathIndex + 2);
    } else if (pathVal === "items") {
        const subSchema = schema.items;
        return navigateSchema(path45, subSchema, pathIndex + 1);
    } else {
        throw new Error(`Internal error: Failed to navigate schema path ${path45}`);
    }
}
function isProperPrefix(a, b) {
    return b.length > a.length && b.substring(0, a.length) === a;
}
function groupBy(lst, f) {
    const record = {};
    const result = [];
    for (const el of lst){
        const key = f(el);
        if (record[key] === undefined) {
            const lst = [];
            const entry = {
                key,
                values: lst
            };
            record[key] = lst;
            result.push(entry);
        }
        record[key].push(el);
    }
    return result;
}
function groupByEntries(entries) {
    const result = [];
    for (const { values: values4  } of entries){
        result.push(...values4);
    }
    return result;
}
function narrowOneOfError(oneOf1, suberrors) {
    const subschemaErrors = groupBy(suberrors.filter((error7)=>error7.schemaPath !== oneOf1.schemaPath
    ), (error8)=>error8.schemaPath.substring(0, error8.schemaPath.lastIndexOf("/"))
    );
    const onlyAdditionalProperties = subschemaErrors.filter(({ values: values5  })=>values5.every((v)=>v.keyword === "additionalProperties"
        )
    );
    if (onlyAdditionalProperties.length) {
        return onlyAdditionalProperties[0].values;
    }
    return [];
}
function localizeAndPruneErrors(annotation, validationErrors, source, schema) {
    const result = [];
    const locF = mappedIndexToRowCol(source);
    let errorsPerInstanceList = groupBy(validationErrors, (error9)=>error9.instancePath
    );
    do {
        const newErrors = [];
        errorsPerInstanceList = errorsPerInstanceList.filter(({ key: pathA  })=>errorsPerInstanceList.filter(({ key: pathB  })=>isProperPrefix(pathA, pathB)
            ).length === 0
        );
        for (let { key: instancePath , values: errors1  } of errorsPerInstanceList){
            let errorsPerSchemaList = groupBy(errors1, (error10)=>error10.schemaPath
            );
            errorsPerSchemaList = errorsPerSchemaList.filter(({ key: pathA  })=>errorsPerSchemaList.filter(({ key: pathB  })=>isProperPrefix(pathB, pathA)
                ).length === 0
            );
            for (const error1 of groupByEntries(errorsPerSchemaList)){
                if (error1.hasBeenTransformed) {
                    continue;
                }
                if (error1.keyword === "oneOf") {
                    error1.hasBeenTransformed = true;
                    newErrors.push(...narrowOneOfError(error1, errors1));
                } else if (error1.keyword === "additionalProperties") {
                    error1.hasBeenTransformed = true;
                    instancePath = `${instancePath}/${error1.params.additionalProperty}`;
                    newErrors.push({
                        ...error1,
                        instancePath,
                        keyword: "_custom_invalidProperty",
                        message: `property ${error1.params.additionalProperty} not allowed in object`,
                        params: {
                            ...error1.params,
                            originalError: error1
                        },
                        schemaPath: error1.schemaPath.slice(0, -21)
                    });
                }
            }
        }
        if (newErrors.length) {
            errorsPerInstanceList.push(...groupBy(newErrors, (error11)=>error11.instancePath
            ));
        } else {
            break;
        }
    }while (true)
    for (const { key: instancePath , values: allErrors  } of errorsPerInstanceList){
        const path46 = instancePath.split("/").slice(1);
        const errors2 = allErrors.filter(({ schemaPath: pathA  })=>!(allErrors.filter(({ schemaPath: pathB  })=>isProperPrefix(pathB, pathA)
            ).length > 0)
        );
        for (const error12 of errors2){
            const returnKey = error12.keyword === "_custom_invalidProperty";
            const violatingObject = navigate(path46, annotation, returnKey);
            const schemaPath = error12.schemaPath.split("/").slice(1);
            const start = locF(violatingObject.start);
            const end = locF(violatingObject.end);
            const locStr = start.line === end.line ? `(line ${start.line + 1}, columns ${start.column + 1}--${end.column + 1})` : `(line ${start.line + 1}, column ${start.column + 1} through line ${end.line + 1}, column ${end.column + 1})`;
            let messageNoLocation;
            if (error12.keyword.startsWith("_custom_")) {
                messageNoLocation = error12.message;
            } else {
                const innerSchema = navigateSchema(schemaPath.map(decodeURIComponent), schema);
                if (instancePath === "") {
                    messageNoLocation = `(top-level error) ${error12.message}`;
                } else {
                    messageNoLocation = `Field ${instancePath} must ${innerSchema.description}`;
                }
            }
            const message = `${locStr}: ${messageNoLocation}`;
            result.push({
                instancePath,
                violatingObject,
                message,
                messageNoLocation,
                source,
                start,
                end,
                error: error12
            });
        }
    }
    result.sort((a, b)=>a.violatingObject.start - b.violatingObject.start
    );
    return result;
}
class YAMLSchema {
    schema;
    validate;
    constructor(schema){
        this.schema = schema;
        this.validate = ajv.compile(normalizeSchema(schema));
    }
    validateParse(src, annotation) {
        let errors3 = [];
        if (!this.validate(annotation.result)) {
            errors3 = localizeAndPruneErrors(annotation, this.validate.errors, src, this.schema);
            return {
                result: annotation.result,
                errors: errors3
            };
        } else {
            return {
                result: annotation.result,
                errors: []
            };
        }
    }
    reportErrorsInSource(result, src, message, error13, log) {
        if (result.errors.length) {
            const locF = mappedIndexToRowCol(src);
            const nLines = lines(src.originalString).length;
            error13(message);
            for (const err of result.errors){
                log(err.message);
                let startO = err.violatingObject.start;
                let endO = err.violatingObject.end;
                while(src.mapClosest(startO) < src.originalString.length - 1 && src.originalString[src.mapClosest(startO)].match(/\s/)){
                    startO++;
                }
                while(src.mapClosest(endO) > src.mapClosest(startO) && src.originalString[src.mapClosest(endO)].match(/\s/)){
                    endO--;
                }
                const start = locF(startO);
                const end = locF(endO);
                const { prefixWidth , lines: lines1 ,  } = formatLineRange(src.originalString, Math.max(0, start.line - 1), Math.min(end.line + 1, nLines - 1));
                for (const { lineNumber , content , rawLine  } of lines1){
                    log(content);
                    if (lineNumber >= start.line && lineNumber <= end.line) {
                        const startColumn = lineNumber > start.line ? 0 : start.column;
                        const endColumn = lineNumber < end.line ? rawLine.length : end.column;
                        log(" ".repeat(prefixWidth + startColumn) + "^".repeat(endColumn - startColumn + 1));
                    }
                }
            }
        }
        return result;
    }
    validateParseWithErrors(src, annotation, message, error14, log) {
        const result = this.validateParse(src, annotation);
        this.reportErrorsInSource(result, src, message, error14, log);
        return result;
    }
}
class PromiseQueue {
    queue = new Array();
    running = false;
    enqueue(promise, clearPending = false) {
        return new Promise((resolve4, reject)=>{
            if (clearPending) {
                this.queue.splice(0, this.queue.length);
            }
            this.queue.push({
                promise,
                resolve: resolve4,
                reject
            });
            this.dequeue();
        });
    }
    dequeue() {
        if (this.running) {
            return false;
        }
        const item = this.queue.shift();
        if (!item) {
            return false;
        }
        try {
            this.running = true;
            item.promise().then((value)=>{
                this.running = false;
                item.resolve(value);
                this.dequeue();
            }).catch((err)=>{
                this.running = false;
                item.reject(err);
                this.dequeue();
            });
        } catch (err) {
            this.running = false;
            item.reject(err);
            this.dequeue();
        }
        return true;
    }
}
const yamlValidators = {};
const validatorQueues = {};
function getSchemaName(schema) {
    const schemaName = schema["$id"];
    if (schemaName === undefined) {
        throw new Error("Expected schema to be named");
    }
    return schemaName;
}
function getValidator(schema) {
    const schemaName = getSchemaName(schema);
    if (yamlValidators[schemaName]) {
        return yamlValidators[schemaName];
    }
    const validator = new YAMLSchema(schema);
    yamlValidators[schemaName] = validator;
    return validator;
}
async function withValidator(schema, fun) {
    const schemaName = getSchemaName(schema);
    if (validatorQueues[schemaName] === undefined) {
        validatorQueues[schemaName] = new PromiseQueue();
    }
    const queue = validatorQueues[schemaName];
    let result;
    let error15;
    await queue.enqueue(async ()=>{
        const validator = getValidator(schema);
        try {
            result = fun(validator);
        } catch (e) {
            console.error("Error in validator queue", e);
            error15 = e;
        }
    });
    if (error15 !== undefined) {
        throw error15;
    }
    return result;
}
function getenv(name74, defaultValue) {
    const value = Deno.env.get(name74);
    if (value === undefined) {
        if (defaultValue === undefined) {
            throw new Error(`Required environment variable ${name74} not specified.`);
        } else {
            return defaultValue;
        }
    } else {
        return value;
    }
}
var State;
(function(State2) {
    State2[State2["PASSTHROUGH"] = 0] = "PASSTHROUGH";
    State2[State2["PERCENT"] = 1] = "PERCENT";
    State2[State2["POSITIONAL"] = 2] = "POSITIONAL";
    State2[State2["PRECISION"] = 3] = "PRECISION";
    State2[State2["WIDTH"] = 4] = "WIDTH";
})(State || (State = {}));
var WorP;
(function(WorP1) {
    WorP1[WorP1["WIDTH"] = 0] = "WIDTH";
    WorP1[WorP1["PRECISION"] = 1] = "PRECISION";
})(WorP || (WorP = {}));
var F;
(function(F1) {
    F1[F1["sign"] = 1] = "sign";
    F1[F1["mantissa"] = 2] = "mantissa";
    F1[F1["fractional"] = 3] = "fractional";
    F1[F1["esign"] = 4] = "esign";
    F1[F1["exponent"] = 5] = "exponent";
})(F || (F = {}));
function appendLogOptions(cmd) {
    return cmd.option("--log <level>", "Path to log file", {
        global: true
    }).option("--log-level <level>", "Log level (info, warning, error, critical)", {
        global: true
    }).option("--log-format <format>", "Log format (plain, json-stream)", {
        global: true
    }).option("--quiet", "Suppress console output.", {
        global: true
    });
}
function logOptions(args) {
    const logOptions1 = {};
    logOptions1.log = args.l || args.log;
    logOptions1.level = args.ll || args["log-level"];
    logOptions1.quiet = args.q || args.quiet;
    logOptions1.format = parseFormat(args.lf || args["log-format"]);
    return logOptions1;
}
class StdErrOutputHandler extends BaseHandler {
    format(logRecord, prefix = true) {
        const options = {
            newline: true,
            colorize: true,
            ...logRecord.args[0]
        };
        let msg = super.format(logRecord);
        if (prefix && logRecord.level >= LogLevels.WARNING) {
            msg = `${logRecord.levelName}: ${msg}`;
        }
        switch(logRecord.level){
            case LogLevels.INFO:
            case LogLevels.DEBUG:
                msg = applyMsgOptions(msg, options);
                break;
            case LogLevels.WARNING:
                if (options.colorize) {
                    msg = yellow(msg);
                }
                break;
            case LogLevels.ERROR:
                if (options.colorize) {
                    msg = brightRed(msg);
                }
                break;
            case LogLevels.CRITICAL:
                if (options.colorize) {
                    msg = bold(red(msg));
                }
                break;
            default:
                break;
        }
        if (options.newline) {
            msg = msg + "\n";
        }
        return msg;
    }
    log(msg) {
        Deno.stderr.writeSync(new TextEncoder().encode(msg));
    }
}
class LogEventsHandler extends StdErrOutputHandler {
    constructor(levelName){
        super(levelName, {
            formatter: "{msg}"
        });
    }
    handle(logRecord) {
        LogEventsHandler.handlers_.forEach((handler)=>handler(logRecord, super.format(logRecord, false))
        );
    }
    static onLog(handler) {
        LogEventsHandler.handlers_.push(handler);
    }
    static handlers_ = new Array();
}
class LogFileHandler extends FileHandler {
    constructor(levelName, options){
        super(levelName, options);
        this.msgFormat = options.format;
    }
    msgFormat;
    format(logRecord) {
        if (logRecord.msg.startsWith("\r")) {
            return "";
        }
        if (this.msgFormat === undefined || this.msgFormat === "plain") {
            const options = {
                newline: true,
                ...logRecord.args[0],
                bold: false,
                dim: false,
                format: undefined
            };
            let msg = applyMsgOptions(logRecord.msg, options);
            if (options.newline) {
                msg = msg + "\n";
            }
            if (logRecord.level >= LogLevels.WARNING) {
                return `(${logRecord.levelName}) ${msg}`;
            } else {
                return msg;
            }
        } else {
            return JSON.stringify(logRecord, undefined, 0) + "\n";
        }
    }
    log(msg) {
        if (msg !== "") {
            msg = stripColor(msg);
            this._buf.writeSync(this._encoder.encode(msg));
            this._buf.flush();
        }
    }
}
async function initializeLogger(logOptions2) {
    const handlers = {};
    const defaultHandlers = [];
    const file = logOptions2.log;
    const logLevel = logOptions2.level ? parseLevel(logOptions2.level) : "INFO";
    handlers["events"] = new LogEventsHandler(logLevel);
    defaultHandlers.push("events");
    if (!logOptions2.quiet) {
        handlers["console"] = new StdErrOutputHandler(logLevel, {
            formatter: "{msg}"
        });
        defaultHandlers.push("console");
    }
    if (file) {
        handlers["file"] = new LogFileHandler(logLevel, {
            filename: file,
            mode: "w",
            format: logOptions2.format
        });
        defaultHandlers.push("file");
    }
    await setup({
        handlers,
        loggers: {
            default: {
                level: "DEBUG",
                handlers: defaultHandlers
            }
        }
    });
}
async function cleanupLogger() {
    const logger = getLogger();
    for (const handler of logger.handlers){
        await handler.destroy();
    }
    logger.handlers = [];
}
function logError(e) {
    let message = e.message ? `${e.name}: ${e.message}` : "";
    const isDebug = getenv("QUARTO_DEBUG", "false") === "true";
    if (isDebug && e.stack) {
        message = message + "\n\n" + e.stack;
    }
    if (message) {
        error(message);
    }
}
function warnOnce(msg) {
    if (!warnings[msg]) {
        warnings[msg] = true;
        warning(msg);
    }
}
const warnings = {};
function applyMsgOptions(msg1, options) {
    if (options.indent) {
        const pad = " ".repeat(options.indent);
        msg1 = lines(msg1).map((msg)=>pad + msg
        ).join("\n");
    }
    if (options.bold) {
        msg1 = bold(msg1);
    }
    if (options.dim) {
        msg1 = dim(msg1);
    }
    if (options.format) {
        msg1 = options.format(msg1);
    }
    return msg1;
}
function parseFormat(format4) {
    if (format4) {
        format4 = format4.toLowerCase();
        switch(format4){
            case "plain":
            case "json-stream":
                return format4;
            default:
                return "plain";
        }
    } else {
        return "plain";
    }
}
function parseLevel(level) {
    const lvl = levelMap[level.toLowerCase()];
    if (lvl) {
        return lvl;
    } else {
        return "WARNING";
    }
}
const levelMap = {
    debug: "DEBUG",
    info: "INFO",
    warning: "WARNING",
    error: "ERROR",
    critical: "CRITICAL"
};
async function ensureValidCopy(src, dest, options) {
    let destStat;
    try {
        destStat = await Deno.lstat(dest);
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            return;
        }
        throw err;
    }
    if (options.isFolder && !destStat.isDirectory) {
        throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
    }
    if (!options.overwrite) {
        throw new Error(`'${dest}' already exists.`);
    }
    return destStat;
}
function ensureValidCopySync(src, dest, options) {
    let destStat;
    try {
        destStat = Deno.lstatSync(dest);
    } catch (err) {
        if (err instanceof Deno.errors.NotFound) {
            return;
        }
        throw err;
    }
    if (options.isFolder && !destStat.isDirectory) {
        throw new Error(`Cannot overwrite non-directory '${dest}' with directory '${src}'.`);
    }
    if (!options.overwrite) {
        throw new Error(`'${dest}' already exists.`);
    }
    return destStat;
}
async function copyFile(src, dest, options) {
    await ensureValidCopy(src, dest, options);
    await Deno.copyFile(src, dest);
    if (options.preserveTimestamps) {
        const statInfo = await Deno.stat(src);
        assert(statInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(statInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        await Deno.utime(dest, statInfo.atime, statInfo.mtime);
    }
}
function copyFileSync(src, dest, options) {
    ensureValidCopySync(src, dest, options);
    Deno.copyFileSync(src, dest);
    if (options.preserveTimestamps) {
        const statInfo = Deno.statSync(src);
        assert(statInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(statInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        Deno.utimeSync(dest, statInfo.atime, statInfo.mtime);
    }
}
async function copySymLink(src, dest, options) {
    await ensureValidCopy(src, dest, options);
    const originSrcFilePath = await Deno.readLink(src);
    const type22 = getFileInfoType(await Deno.lstat(src));
    if (isWindows) {
        await Deno.symlink(originSrcFilePath, dest, {
            type: type22 === "dir" ? "dir" : "file"
        });
    } else {
        await Deno.symlink(originSrcFilePath, dest);
    }
    if (options.preserveTimestamps) {
        const statInfo = await Deno.lstat(src);
        assert(statInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(statInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        await Deno.utime(dest, statInfo.atime, statInfo.mtime);
    }
}
function copySymlinkSync(src, dest, options) {
    ensureValidCopySync(src, dest, options);
    const originSrcFilePath = Deno.readLinkSync(src);
    const type23 = getFileInfoType(Deno.lstatSync(src));
    if (isWindows) {
        Deno.symlinkSync(originSrcFilePath, dest, {
            type: type23 === "dir" ? "dir" : "file"
        });
    } else {
        Deno.symlinkSync(originSrcFilePath, dest);
    }
    if (options.preserveTimestamps) {
        const statInfo = Deno.lstatSync(src);
        assert(statInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(statInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        Deno.utimeSync(dest, statInfo.atime, statInfo.mtime);
    }
}
async function copyDir(src, dest, options) {
    const destStat = await ensureValidCopy(src, dest, {
        ...options,
        isFolder: true
    });
    if (!destStat) {
        await ensureDir(dest);
    }
    if (options.preserveTimestamps) {
        const srcStatInfo = await Deno.stat(src);
        assert(srcStatInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(srcStatInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        await Deno.utime(dest, srcStatInfo.atime, srcStatInfo.mtime);
    }
    for await (const entry of Deno.readDir(src)){
        const srcPath = join3(src, entry.name);
        const destPath = join3(dest, basename2(srcPath));
        if (entry.isSymlink) {
            await copySymLink(srcPath, destPath, options);
        } else if (entry.isDirectory) {
            await copyDir(srcPath, destPath, options);
        } else if (entry.isFile) {
            await copyFile(srcPath, destPath, options);
        }
    }
}
function copyDirSync(src, dest, options) {
    const destStat = ensureValidCopySync(src, dest, {
        ...options,
        isFolder: true
    });
    if (!destStat) {
        ensureDirSync(dest);
    }
    if (options.preserveTimestamps) {
        const srcStatInfo = Deno.statSync(src);
        assert(srcStatInfo.atime instanceof Date, `statInfo.atime is unavailable`);
        assert(srcStatInfo.mtime instanceof Date, `statInfo.mtime is unavailable`);
        Deno.utimeSync(dest, srcStatInfo.atime, srcStatInfo.mtime);
    }
    for (const entry of Deno.readDirSync(src)){
        assert(entry.name != null, "file.name must be set");
        const srcPath = join3(src, entry.name);
        const destPath = join3(dest, basename2(srcPath));
        if (entry.isSymlink) {
            copySymlinkSync(srcPath, destPath, options);
        } else if (entry.isDirectory) {
            copyDirSync(srcPath, destPath, options);
        } else if (entry.isFile) {
            copyFileSync(srcPath, destPath, options);
        }
    }
}
async function copy1(src, dest, options = {}) {
    src = resolve2(src);
    dest = resolve2(dest);
    if (src === dest) {
        throw new Error("Source and destination cannot be the same.");
    }
    const srcStat = await Deno.lstat(src);
    if (srcStat.isDirectory && isSubdir(src, dest)) {
        throw new Error(`Cannot copy '${src}' to a subdirectory of itself, '${dest}'.`);
    }
    if (srcStat.isSymlink) {
        await copySymLink(src, dest, options);
    } else if (srcStat.isDirectory) {
        await copyDir(src, dest, options);
    } else if (srcStat.isFile) {
        await copyFile(src, dest, options);
    }
}
function copySync(src, dest, options = {}) {
    src = resolve2(src);
    dest = resolve2(dest);
    if (src === dest) {
        throw new Error("Source and destination cannot be the same.");
    }
    const srcStat = Deno.lstatSync(src);
    if (srcStat.isDirectory && isSubdir(src, dest)) {
        throw new Error(`Cannot copy '${src}' to a subdirectory of itself, '${dest}'.`);
    }
    if (srcStat.isSymlink) {
        copySymlinkSync(src, dest, options);
    } else if (srcStat.isDirectory) {
        copyDirSync(src, dest, options);
    } else if (srcStat.isFile) {
        copyFileSync(src, dest, options);
    }
}
function listCacheClear() {
    this.__data__ = [];
    this.size = 0;
}
var __VIRTUAL_FILE = listCacheClear;
function eq(value, other) {
    return value === other || value !== value && other !== other;
}
var __VIRTUAL_FILE1 = eq;
function assocIndexOf(array, key) {
    var length = array.length;
    while(length--){
        if (__VIRTUAL_FILE1(array[length][0], key)) {
            return length;
        }
    }
    return -1;
}
var __VIRTUAL_FILE2 = assocIndexOf;
var arrayProto = Array.prototype;
var splice = arrayProto.splice;
function listCacheDelete(key) {
    var data4 = this.__data__, index = __VIRTUAL_FILE2(data4, key);
    if (index < 0) {
        return false;
    }
    var lastIndex = data4.length - 1;
    if (index == lastIndex) {
        data4.pop();
    } else {
        splice.call(data4, index, 1);
    }
    --this.size;
    return true;
}
var __VIRTUAL_FILE3 = listCacheDelete;
function listCacheGet(key) {
    var data5 = this.__data__, index = __VIRTUAL_FILE2(data5, key);
    return index < 0 ? void 0 : data5[index][1];
}
var __VIRTUAL_FILE4 = listCacheGet;
function listCacheHas(key) {
    return __VIRTUAL_FILE2(this.__data__, key) > -1;
}
var __VIRTUAL_FILE5 = listCacheHas;
function listCacheSet(key, value) {
    var data6 = this.__data__, index = __VIRTUAL_FILE2(data6, key);
    if (index < 0) {
        ++this.size;
        data6.push([
            key,
            value
        ]);
    } else {
        data6[index][1] = value;
    }
    return this;
}
var __VIRTUAL_FILE6 = listCacheSet;
function ListCache(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
ListCache.prototype.clear = __VIRTUAL_FILE;
ListCache.prototype["delete"] = __VIRTUAL_FILE3;
ListCache.prototype.get = __VIRTUAL_FILE4;
ListCache.prototype.has = __VIRTUAL_FILE5;
ListCache.prototype.set = __VIRTUAL_FILE6;
var __VIRTUAL_FILE7 = ListCache;
function stackClear() {
    this.__data__ = new __VIRTUAL_FILE7();
    this.size = 0;
}
var __VIRTUAL_FILE8 = stackClear;
function stackDelete(key) {
    var data7 = this.__data__, result = data7["delete"](key);
    this.size = data7.size;
    return result;
}
var __VIRTUAL_FILE9 = stackDelete;
function stackGet(key) {
    return this.__data__.get(key);
}
var __VIRTUAL_FILE10 = stackGet;
function stackHas(key) {
    return this.__data__.has(key);
}
var __VIRTUAL_FILE11 = stackHas;
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
var freeGlobal = typeof commonjsGlobal == "object" && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;
var __VIRTUAL_FILE12 = freeGlobal;
var freeSelf = typeof self == "object" && self && self.Object === Object && self;
var root = __VIRTUAL_FILE12 || freeSelf || Function("return this")();
var __VIRTUAL_FILE13 = root;
var Symbol1 = __VIRTUAL_FILE13.Symbol;
var __VIRTUAL_FILE14 = Symbol1;
var objectProto = Object.prototype;
var hasOwnProperty = objectProto.hasOwnProperty;
var nativeObjectToString = objectProto.toString;
var symToStringTag = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.toStringTag : void 0;
function getRawTag(value) {
    var isOwn = hasOwnProperty.call(value, symToStringTag), tag = value[symToStringTag];
    try {
        value[symToStringTag] = void 0;
        var unmasked = true;
    } catch (e) {}
    var result = nativeObjectToString.call(value);
    if (unmasked) {
        if (isOwn) {
            value[symToStringTag] = tag;
        } else {
            delete value[symToStringTag];
        }
    }
    return result;
}
var __VIRTUAL_FILE15 = getRawTag;
var objectProto1 = Object.prototype;
var nativeObjectToString1 = objectProto1.toString;
function objectToString(value) {
    return nativeObjectToString1.call(value);
}
var __VIRTUAL_FILE16 = objectToString;
var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
var symToStringTag1 = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.toStringTag : void 0;
function baseGetTag(value) {
    if (value == null) {
        return value === void 0 ? undefinedTag : nullTag;
    }
    return symToStringTag1 && symToStringTag1 in Object(value) ? __VIRTUAL_FILE15(value) : __VIRTUAL_FILE16(value);
}
var __VIRTUAL_FILE17 = baseGetTag;
function isObject(value) {
    var type24 = typeof value;
    return value != null && (type24 == "object" || type24 == "function");
}
var __VIRTUAL_FILE18 = isObject;
var asyncTag = "[object AsyncFunction]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
function isFunction(value) {
    if (!__VIRTUAL_FILE18(value)) {
        return false;
    }
    var tag = __VIRTUAL_FILE17(value);
    return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;
}
var __VIRTUAL_FILE19 = isFunction;
var coreJsData = __VIRTUAL_FILE13["__core-js_shared__"];
var __VIRTUAL_FILE20 = coreJsData;
var maskSrcKey = function() {
    var uid = /[^.]+$/.exec(__VIRTUAL_FILE20 && __VIRTUAL_FILE20.keys && __VIRTUAL_FILE20.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
}();
function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
}
var __VIRTUAL_FILE21 = isMasked;
var funcProto = Function.prototype;
var funcToString = funcProto.toString;
function toSource(func) {
    if (func != null) {
        try {
            return funcToString.call(func);
        } catch (e) {}
        try {
            return func + "";
        } catch (e1) {}
    }
    return "";
}
var __VIRTUAL_FILE22 = toSource;
var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
var reIsHostCtor = /^\[object .+?Constructor\]$/;
var funcProto1 = Function.prototype, objectProto2 = Object.prototype;
var funcToString1 = funcProto1.toString;
var hasOwnProperty1 = objectProto2.hasOwnProperty;
var reIsNative = RegExp("^" + funcToString1.call(hasOwnProperty1).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$");
function baseIsNative(value) {
    if (!__VIRTUAL_FILE18(value) || __VIRTUAL_FILE21(value)) {
        return false;
    }
    var pattern3 = __VIRTUAL_FILE19(value) ? reIsNative : reIsHostCtor;
    return pattern3.test(__VIRTUAL_FILE22(value));
}
var __VIRTUAL_FILE23 = baseIsNative;
function getValue(object, key) {
    return object == null ? void 0 : object[key];
}
var __VIRTUAL_FILE24 = getValue;
function getNative(object, key) {
    var value = __VIRTUAL_FILE24(object, key);
    return __VIRTUAL_FILE23(value) ? value : void 0;
}
var __VIRTUAL_FILE25 = getNative;
var Map1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "Map");
var __VIRTUAL_FILE26 = Map1;
var nativeCreate = __VIRTUAL_FILE25(Object, "create");
var __VIRTUAL_FILE27 = nativeCreate;
function hashClear() {
    this.__data__ = __VIRTUAL_FILE27 ? __VIRTUAL_FILE27(null) : {};
    this.size = 0;
}
var __VIRTUAL_FILE28 = hashClear;
function hashDelete(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
}
var __VIRTUAL_FILE29 = hashDelete;
var HASH_UNDEFINED = "__lodash_hash_undefined__";
var objectProto3 = Object.prototype;
var hasOwnProperty2 = objectProto3.hasOwnProperty;
function hashGet(key) {
    var data8 = this.__data__;
    if (__VIRTUAL_FILE27) {
        var result = data8[key];
        return result === HASH_UNDEFINED ? void 0 : result;
    }
    return hasOwnProperty2.call(data8, key) ? data8[key] : void 0;
}
var __VIRTUAL_FILE30 = hashGet;
var objectProto4 = Object.prototype;
var hasOwnProperty3 = objectProto4.hasOwnProperty;
function hashHas(key) {
    var data9 = this.__data__;
    return __VIRTUAL_FILE27 ? data9[key] !== void 0 : hasOwnProperty3.call(data9, key);
}
var __VIRTUAL_FILE31 = hashHas;
var HASH_UNDEFINED1 = "__lodash_hash_undefined__";
function hashSet(key, value) {
    var data10 = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data10[key] = __VIRTUAL_FILE27 && value === void 0 ? HASH_UNDEFINED1 : value;
    return this;
}
var __VIRTUAL_FILE32 = hashSet;
function Hash(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
Hash.prototype.clear = __VIRTUAL_FILE28;
Hash.prototype["delete"] = __VIRTUAL_FILE29;
Hash.prototype.get = __VIRTUAL_FILE30;
Hash.prototype.has = __VIRTUAL_FILE31;
Hash.prototype.set = __VIRTUAL_FILE32;
var __VIRTUAL_FILE33 = Hash;
function mapCacheClear() {
    this.size = 0;
    this.__data__ = {
        hash: new __VIRTUAL_FILE33(),
        map: new (__VIRTUAL_FILE26 || __VIRTUAL_FILE7)(),
        string: new __VIRTUAL_FILE33()
    };
}
var __VIRTUAL_FILE34 = mapCacheClear;
function isKeyable(value) {
    var type25 = typeof value;
    return type25 == "string" || type25 == "number" || type25 == "symbol" || type25 == "boolean" ? value !== "__proto__" : value === null;
}
var __VIRTUAL_FILE35 = isKeyable;
function getMapData(map2, key) {
    var data11 = map2.__data__;
    return __VIRTUAL_FILE35(key) ? data11[typeof key == "string" ? "string" : "hash"] : data11.map;
}
var __VIRTUAL_FILE36 = getMapData;
function mapCacheDelete(key) {
    var result = __VIRTUAL_FILE36(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
}
var __VIRTUAL_FILE37 = mapCacheDelete;
function mapCacheGet(key) {
    return __VIRTUAL_FILE36(this, key).get(key);
}
var __VIRTUAL_FILE38 = mapCacheGet;
function mapCacheHas(key) {
    return __VIRTUAL_FILE36(this, key).has(key);
}
var __VIRTUAL_FILE39 = mapCacheHas;
function mapCacheSet(key, value) {
    var data12 = __VIRTUAL_FILE36(this, key), size = data12.size;
    data12.set(key, value);
    this.size += data12.size == size ? 0 : 1;
    return this;
}
var __VIRTUAL_FILE40 = mapCacheSet;
function MapCache(entries) {
    var index = -1, length = entries == null ? 0 : entries.length;
    this.clear();
    while(++index < length){
        var entry = entries[index];
        this.set(entry[0], entry[1]);
    }
}
MapCache.prototype.clear = __VIRTUAL_FILE34;
MapCache.prototype["delete"] = __VIRTUAL_FILE37;
MapCache.prototype.get = __VIRTUAL_FILE38;
MapCache.prototype.has = __VIRTUAL_FILE39;
MapCache.prototype.set = __VIRTUAL_FILE40;
var __VIRTUAL_FILE41 = MapCache;
var LARGE_ARRAY_SIZE = 200;
function stackSet(key, value) {
    var data13 = this.__data__;
    if (data13 instanceof __VIRTUAL_FILE7) {
        var pairs1 = data13.__data__;
        if (!__VIRTUAL_FILE26 || pairs1.length < LARGE_ARRAY_SIZE - 1) {
            pairs1.push([
                key,
                value
            ]);
            this.size = ++data13.size;
            return this;
        }
        data13 = this.__data__ = new __VIRTUAL_FILE41(pairs1);
    }
    data13.set(key, value);
    this.size = data13.size;
    return this;
}
var __VIRTUAL_FILE42 = stackSet;
function Stack(entries) {
    var data14 = this.__data__ = new __VIRTUAL_FILE7(entries);
    this.size = data14.size;
}
Stack.prototype.clear = __VIRTUAL_FILE8;
Stack.prototype["delete"] = __VIRTUAL_FILE9;
Stack.prototype.get = __VIRTUAL_FILE10;
Stack.prototype.has = __VIRTUAL_FILE11;
Stack.prototype.set = __VIRTUAL_FILE42;
var __VIRTUAL_FILE43 = Stack;
function arrayEach(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length;
    while(++index < length){
        if (iteratee(array[index], index, array) === false) {
            break;
        }
    }
    return array;
}
var __VIRTUAL_FILE44 = arrayEach;
var defineProperty = function() {
    try {
        var func = __VIRTUAL_FILE25(Object, "defineProperty");
        func({}, "", {});
        return func;
    } catch (e) {}
}();
var __VIRTUAL_FILE45 = defineProperty;
function baseAssignValue(object, key, value) {
    if (key == "__proto__" && __VIRTUAL_FILE45) {
        __VIRTUAL_FILE45(object, key, {
            configurable: true,
            enumerable: true,
            value,
            writable: true
        });
    } else {
        object[key] = value;
    }
}
var __VIRTUAL_FILE46 = baseAssignValue;
var objectProto5 = Object.prototype;
var hasOwnProperty4 = objectProto5.hasOwnProperty;
function assignValue(object, key, value) {
    var objValue = object[key];
    if (!(hasOwnProperty4.call(object, key) && __VIRTUAL_FILE1(objValue, value)) || value === void 0 && !(key in object)) {
        __VIRTUAL_FILE46(object, key, value);
    }
}
var __VIRTUAL_FILE47 = assignValue;
function copyObject(source, props, object, customizer) {
    var isNew = !object;
    object || (object = {});
    var index = -1, length = props.length;
    while(++index < length){
        var key = props[index];
        var newValue = customizer ? customizer(object[key], source[key], key, object, source) : void 0;
        if (newValue === void 0) {
            newValue = source[key];
        }
        if (isNew) {
            __VIRTUAL_FILE46(object, key, newValue);
        } else {
            __VIRTUAL_FILE47(object, key, newValue);
        }
    }
    return object;
}
var __VIRTUAL_FILE48 = copyObject;
function baseTimes(n3, iteratee) {
    var index = -1, result = Array(n3);
    while(++index < n3){
        result[index] = iteratee(index);
    }
    return result;
}
var __VIRTUAL_FILE49 = baseTimes;
function isObjectLike(value) {
    return value != null && typeof value == "object";
}
var __VIRTUAL_FILE50 = isObjectLike;
var argsTag = "[object Arguments]";
function baseIsArguments(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE17(value) == argsTag;
}
var __VIRTUAL_FILE51 = baseIsArguments;
var objectProto6 = Object.prototype;
var hasOwnProperty5 = objectProto6.hasOwnProperty;
var propertyIsEnumerable = objectProto6.propertyIsEnumerable;
var isArguments = __VIRTUAL_FILE51(function() {
    return arguments;
}()) ? __VIRTUAL_FILE51 : function(value) {
    return __VIRTUAL_FILE50(value) && hasOwnProperty5.call(value, "callee") && !propertyIsEnumerable.call(value, "callee");
};
var __VIRTUAL_FILE52 = isArguments;
var isArray = Array.isArray;
var __VIRTUAL_FILE53 = isArray;
function stubFalse() {
    return false;
}
var __VIRTUAL_FILE54 = stubFalse;
function createCommonjsModule(fn) {
    var module = {
        exports: {}
    };
    return fn(module, module.exports), module.exports;
}
var __VIRTUAL_FILE55 = createCommonjsModule(function(module, exports) {
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer1 = moduleExports ? __VIRTUAL_FILE13.Buffer : void 0;
    var nativeIsBuffer = Buffer1 ? Buffer1.isBuffer : void 0;
    var isBuffer = nativeIsBuffer || __VIRTUAL_FILE54;
    module.exports = isBuffer;
});
var MAX_SAFE_INTEGER = 9007199254740991;
var reIsUint = /^(?:0|[1-9]\d*)$/;
function isIndex(value, length) {
    var type26 = typeof value;
    length = length == null ? MAX_SAFE_INTEGER : length;
    return !!length && (type26 == "number" || type26 != "symbol" && reIsUint.test(value)) && value > -1 && value % 1 == 0 && value < length;
}
var __VIRTUAL_FILE56 = isIndex;
var MAX_SAFE_INTEGER1 = 9007199254740991;
function isLength(value) {
    return typeof value == "number" && value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER1;
}
var __VIRTUAL_FILE57 = isLength;
var argsTag1 = "[object Arguments]", arrayTag = "[object Array]", boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", funcTag1 = "[object Function]", mapTag = "[object Map]", numberTag = "[object Number]", objectTag = "[object Object]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", weakMapTag = "[object WeakMap]";
var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
var typedArrayTags = {};
typedArrayTags[float32Tag] = typedArrayTags[float64Tag] = typedArrayTags[int8Tag] = typedArrayTags[int16Tag] = typedArrayTags[int32Tag] = typedArrayTags[uint8Tag] = typedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] = typedArrayTags[uint32Tag] = true;
typedArrayTags[argsTag1] = typedArrayTags[arrayTag] = typedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] = typedArrayTags[dataViewTag] = typedArrayTags[dateTag] = typedArrayTags[errorTag] = typedArrayTags[funcTag1] = typedArrayTags[mapTag] = typedArrayTags[numberTag] = typedArrayTags[objectTag] = typedArrayTags[regexpTag] = typedArrayTags[setTag] = typedArrayTags[stringTag] = typedArrayTags[weakMapTag] = false;
function baseIsTypedArray(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE57(value.length) && !!typedArrayTags[__VIRTUAL_FILE17(value)];
}
var __VIRTUAL_FILE58 = baseIsTypedArray;
function baseUnary(func) {
    return function(value) {
        return func(value);
    };
}
var __VIRTUAL_FILE59 = baseUnary;
function createCommonjsModule1(fn) {
    var module = {
        exports: {}
    };
    return fn(module, module.exports), module.exports;
}
var __VIRTUAL_FILE60 = createCommonjsModule1(function(module, exports) {
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var freeProcess = moduleExports && __VIRTUAL_FILE12.process;
    var nodeUtil = function() {
        try {
            var types9 = freeModule && freeModule.require && freeModule.require("util").types;
            if (types9) {
                return types9;
            }
            return freeProcess && freeProcess.binding && freeProcess.binding("util");
        } catch (e) {}
    }();
    module.exports = nodeUtil;
});
var nodeIsTypedArray = __VIRTUAL_FILE60 && __VIRTUAL_FILE60.isTypedArray;
var isTypedArray = nodeIsTypedArray ? __VIRTUAL_FILE59(nodeIsTypedArray) : __VIRTUAL_FILE58;
var __VIRTUAL_FILE61 = isTypedArray;
var objectProto7 = Object.prototype;
var hasOwnProperty6 = objectProto7.hasOwnProperty;
function arrayLikeKeys(value, inherited) {
    var isArr = __VIRTUAL_FILE53(value), isArg = !isArr && __VIRTUAL_FILE52(value), isBuff = !isArr && !isArg && __VIRTUAL_FILE55(value), isType = !isArr && !isArg && !isBuff && __VIRTUAL_FILE61(value), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? __VIRTUAL_FILE49(value.length, String) : [], length = result.length;
    for(var key in value){
        if ((inherited || hasOwnProperty6.call(value, key)) && !(skipIndexes && (key == "length" || isBuff && (key == "offset" || key == "parent") || isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || __VIRTUAL_FILE56(key, length)))) {
            result.push(key);
        }
    }
    return result;
}
var __VIRTUAL_FILE62 = arrayLikeKeys;
var objectProto8 = Object.prototype;
function isPrototype(value) {
    var Ctor = value && value.constructor, proto1 = typeof Ctor == "function" && Ctor.prototype || objectProto8;
    return value === proto1;
}
var __VIRTUAL_FILE63 = isPrototype;
function overArg(func, transform) {
    return function(arg) {
        return func(transform(arg));
    };
}
var __VIRTUAL_FILE64 = overArg;
var nativeKeys = __VIRTUAL_FILE64(Object.keys, Object);
var __VIRTUAL_FILE65 = nativeKeys;
var objectProto9 = Object.prototype;
var hasOwnProperty7 = objectProto9.hasOwnProperty;
function baseKeys(object) {
    if (!__VIRTUAL_FILE63(object)) {
        return __VIRTUAL_FILE65(object);
    }
    var result = [];
    for(var key in Object(object)){
        if (hasOwnProperty7.call(object, key) && key != "constructor") {
            result.push(key);
        }
    }
    return result;
}
var __VIRTUAL_FILE66 = baseKeys;
function isArrayLike(value) {
    return value != null && __VIRTUAL_FILE57(value.length) && !__VIRTUAL_FILE19(value);
}
var __VIRTUAL_FILE67 = isArrayLike;
function keys(object) {
    return __VIRTUAL_FILE67(object) ? __VIRTUAL_FILE62(object) : __VIRTUAL_FILE66(object);
}
var __VIRTUAL_FILE68 = keys;
function baseAssign(object, source) {
    return object && __VIRTUAL_FILE48(source, __VIRTUAL_FILE68(source), object);
}
var __VIRTUAL_FILE69 = baseAssign;
function nativeKeysIn(object) {
    var result = [];
    if (object != null) {
        for(var key in Object(object)){
            result.push(key);
        }
    }
    return result;
}
var __VIRTUAL_FILE70 = nativeKeysIn;
var objectProto10 = Object.prototype;
var hasOwnProperty8 = objectProto10.hasOwnProperty;
function baseKeysIn(object) {
    if (!__VIRTUAL_FILE18(object)) {
        return __VIRTUAL_FILE70(object);
    }
    var isProto = __VIRTUAL_FILE63(object), result = [];
    for(var key in object){
        if (!(key == "constructor" && (isProto || !hasOwnProperty8.call(object, key)))) {
            result.push(key);
        }
    }
    return result;
}
var __VIRTUAL_FILE71 = baseKeysIn;
function keysIn(object) {
    return __VIRTUAL_FILE67(object) ? __VIRTUAL_FILE62(object, true) : __VIRTUAL_FILE71(object);
}
var __VIRTUAL_FILE72 = keysIn;
function baseAssignIn(object, source) {
    return object && __VIRTUAL_FILE48(source, __VIRTUAL_FILE72(source), object);
}
var __VIRTUAL_FILE73 = baseAssignIn;
function createCommonjsModule2(fn) {
    var module = {
        exports: {}
    };
    return fn(module, module.exports), module.exports;
}
var __VIRTUAL_FILE74 = createCommonjsModule2(function(module, exports) {
    var freeExports = exports && !exports.nodeType && exports;
    var freeModule = freeExports && true && module && !module.nodeType && module;
    var moduleExports = freeModule && freeModule.exports === freeExports;
    var Buffer2 = moduleExports ? __VIRTUAL_FILE13.Buffer : void 0, allocUnsafe = Buffer2 ? Buffer2.allocUnsafe : void 0;
    function cloneBuffer(buffer, isDeep) {
        if (isDeep) {
            return buffer.slice();
        }
        var length = buffer.length, result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);
        buffer.copy(result);
        return result;
    }
    module.exports = cloneBuffer;
});
function copyArray(source, array) {
    var index = -1, length = source.length;
    array || (array = Array(length));
    while(++index < length){
        array[index] = source[index];
    }
    return array;
}
var __VIRTUAL_FILE75 = copyArray;
function arrayFilter(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length, resIndex = 0, result = [];
    while(++index < length){
        var value = array[index];
        if (predicate(value, index, array)) {
            result[resIndex++] = value;
        }
    }
    return result;
}
var __VIRTUAL_FILE76 = arrayFilter;
function stubArray() {
    return [];
}
var __VIRTUAL_FILE77 = stubArray;
var objectProto11 = Object.prototype;
var propertyIsEnumerable1 = objectProto11.propertyIsEnumerable;
var nativeGetSymbols = Object.getOwnPropertySymbols;
var getSymbols = !nativeGetSymbols ? __VIRTUAL_FILE77 : function(object) {
    if (object == null) {
        return [];
    }
    object = Object(object);
    return __VIRTUAL_FILE76(nativeGetSymbols(object), function(symbol) {
        return propertyIsEnumerable1.call(object, symbol);
    });
};
var __VIRTUAL_FILE78 = getSymbols;
function copySymbols(source, object) {
    return __VIRTUAL_FILE48(source, __VIRTUAL_FILE78(source), object);
}
var __VIRTUAL_FILE79 = copySymbols;
function arrayPush(array, values6) {
    var index = -1, length = values6.length, offset = array.length;
    while(++index < length){
        array[offset + index] = values6[index];
    }
    return array;
}
var __VIRTUAL_FILE80 = arrayPush;
var getPrototype = __VIRTUAL_FILE64(Object.getPrototypeOf, Object);
var __VIRTUAL_FILE81 = getPrototype;
var nativeGetSymbols1 = Object.getOwnPropertySymbols;
var getSymbolsIn = !nativeGetSymbols1 ? __VIRTUAL_FILE77 : function(object) {
    var result = [];
    while(object){
        __VIRTUAL_FILE80(result, __VIRTUAL_FILE78(object));
        object = __VIRTUAL_FILE81(object);
    }
    return result;
};
var __VIRTUAL_FILE82 = getSymbolsIn;
function copySymbolsIn(source, object) {
    return __VIRTUAL_FILE48(source, __VIRTUAL_FILE82(source), object);
}
var __VIRTUAL_FILE83 = copySymbolsIn;
function baseGetAllKeys(object, keysFunc, symbolsFunc) {
    var result = keysFunc(object);
    return __VIRTUAL_FILE53(object) ? result : __VIRTUAL_FILE80(result, symbolsFunc(object));
}
var __VIRTUAL_FILE84 = baseGetAllKeys;
function getAllKeys(object) {
    return __VIRTUAL_FILE84(object, __VIRTUAL_FILE68, __VIRTUAL_FILE78);
}
var __VIRTUAL_FILE85 = getAllKeys;
function getAllKeysIn(object) {
    return __VIRTUAL_FILE84(object, __VIRTUAL_FILE72, __VIRTUAL_FILE82);
}
var __VIRTUAL_FILE86 = getAllKeysIn;
var DataView1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "DataView");
var __VIRTUAL_FILE87 = DataView1;
var Promise1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "Promise");
var __VIRTUAL_FILE88 = Promise1;
var Set1 = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "Set");
var __VIRTUAL_FILE89 = Set1;
var WeakMap = __VIRTUAL_FILE25(__VIRTUAL_FILE13, "WeakMap");
var __VIRTUAL_FILE90 = WeakMap;
var mapTag1 = "[object Map]", objectTag1 = "[object Object]", promiseTag = "[object Promise]", setTag1 = "[object Set]", weakMapTag1 = "[object WeakMap]";
var dataViewTag1 = "[object DataView]";
var dataViewCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE87), mapCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE26), promiseCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE88), setCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE89), weakMapCtorString = __VIRTUAL_FILE22(__VIRTUAL_FILE90);
var getTag = __VIRTUAL_FILE17;
if (__VIRTUAL_FILE87 && getTag(new __VIRTUAL_FILE87(new ArrayBuffer(1))) != dataViewTag1 || __VIRTUAL_FILE26 && getTag(new __VIRTUAL_FILE26()) != mapTag1 || __VIRTUAL_FILE88 && getTag(__VIRTUAL_FILE88.resolve()) != promiseTag || __VIRTUAL_FILE89 && getTag(new __VIRTUAL_FILE89()) != setTag1 || __VIRTUAL_FILE90 && getTag(new __VIRTUAL_FILE90()) != weakMapTag1) {
    getTag = function(value) {
        var result = __VIRTUAL_FILE17(value), Ctor = result == objectTag1 ? value.constructor : void 0, ctorString = Ctor ? __VIRTUAL_FILE22(Ctor) : "";
        if (ctorString) {
            switch(ctorString){
                case dataViewCtorString:
                    return dataViewTag1;
                case mapCtorString:
                    return mapTag1;
                case promiseCtorString:
                    return promiseTag;
                case setCtorString:
                    return setTag1;
                case weakMapCtorString:
                    return weakMapTag1;
            }
        }
        return result;
    };
}
var __VIRTUAL_FILE91 = getTag;
var objectProto12 = Object.prototype;
var hasOwnProperty9 = objectProto12.hasOwnProperty;
function initCloneArray(array) {
    var length = array.length, result = new array.constructor(length);
    if (length && typeof array[0] == "string" && hasOwnProperty9.call(array, "index")) {
        result.index = array.index;
        result.input = array.input;
    }
    return result;
}
var __VIRTUAL_FILE92 = initCloneArray;
var Uint8Array1 = __VIRTUAL_FILE13.Uint8Array;
var __VIRTUAL_FILE93 = Uint8Array1;
function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new __VIRTUAL_FILE93(result).set(new __VIRTUAL_FILE93(arrayBuffer));
    return result;
}
var __VIRTUAL_FILE94 = cloneArrayBuffer;
function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? __VIRTUAL_FILE94(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
}
var __VIRTUAL_FILE95 = cloneDataView;
var reFlags = /\w*$/;
function cloneRegExp(regexp2) {
    var result = new regexp2.constructor(regexp2.source, reFlags.exec(regexp2));
    result.lastIndex = regexp2.lastIndex;
    return result;
}
var __VIRTUAL_FILE96 = cloneRegExp;
var symbolProto = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.prototype : void 0, symbolValueOf = symbolProto ? symbolProto.valueOf : void 0;
function cloneSymbol(symbol) {
    return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};
}
var __VIRTUAL_FILE97 = cloneSymbol;
function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? __VIRTUAL_FILE94(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
}
var __VIRTUAL_FILE98 = cloneTypedArray;
var boolTag1 = "[object Boolean]", dateTag1 = "[object Date]", mapTag2 = "[object Map]", numberTag1 = "[object Number]", regexpTag1 = "[object RegExp]", setTag2 = "[object Set]", stringTag1 = "[object String]", symbolTag = "[object Symbol]";
var arrayBufferTag1 = "[object ArrayBuffer]", dataViewTag2 = "[object DataView]", float32Tag1 = "[object Float32Array]", float64Tag1 = "[object Float64Array]", int8Tag1 = "[object Int8Array]", int16Tag1 = "[object Int16Array]", int32Tag1 = "[object Int32Array]", uint8Tag1 = "[object Uint8Array]", uint8ClampedTag1 = "[object Uint8ClampedArray]", uint16Tag1 = "[object Uint16Array]", uint32Tag1 = "[object Uint32Array]";
function initCloneByTag(object, tag, isDeep) {
    var Ctor = object.constructor;
    switch(tag){
        case arrayBufferTag1:
            return __VIRTUAL_FILE94(object);
        case boolTag1:
        case dateTag1:
            return new Ctor(+object);
        case dataViewTag2:
            return __VIRTUAL_FILE95(object, isDeep);
        case float32Tag1:
        case float64Tag1:
        case int8Tag1:
        case int16Tag1:
        case int32Tag1:
        case uint8Tag1:
        case uint8ClampedTag1:
        case uint16Tag1:
        case uint32Tag1:
            return __VIRTUAL_FILE98(object, isDeep);
        case mapTag2:
            return new Ctor();
        case numberTag1:
        case stringTag1:
            return new Ctor(object);
        case regexpTag1:
            return __VIRTUAL_FILE96(object);
        case setTag2:
            return new Ctor();
        case symbolTag:
            return __VIRTUAL_FILE97(object);
    }
}
var __VIRTUAL_FILE99 = initCloneByTag;
var objectCreate = Object.create;
var baseCreate = function() {
    function object() {}
    return function(proto2) {
        if (!__VIRTUAL_FILE18(proto2)) {
            return {};
        }
        if (objectCreate) {
            return objectCreate(proto2);
        }
        object.prototype = proto2;
        var result = new object();
        object.prototype = void 0;
        return result;
    };
}();
var __VIRTUAL_FILE100 = baseCreate;
function initCloneObject(object) {
    return typeof object.constructor == "function" && !__VIRTUAL_FILE63(object) ? __VIRTUAL_FILE100(__VIRTUAL_FILE81(object)) : {};
}
var __VIRTUAL_FILE101 = initCloneObject;
var mapTag3 = "[object Map]";
function baseIsMap(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE91(value) == mapTag3;
}
var __VIRTUAL_FILE102 = baseIsMap;
var nodeIsMap = __VIRTUAL_FILE60 && __VIRTUAL_FILE60.isMap;
var isMap = nodeIsMap ? __VIRTUAL_FILE59(nodeIsMap) : __VIRTUAL_FILE102;
var __VIRTUAL_FILE103 = isMap;
var setTag3 = "[object Set]";
function baseIsSet(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE91(value) == setTag3;
}
var __VIRTUAL_FILE104 = baseIsSet;
var nodeIsSet = __VIRTUAL_FILE60 && __VIRTUAL_FILE60.isSet;
var isSet = nodeIsSet ? __VIRTUAL_FILE59(nodeIsSet) : __VIRTUAL_FILE104;
var __VIRTUAL_FILE105 = isSet;
var CLONE_DEEP_FLAG = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG = 4;
var argsTag2 = "[object Arguments]", arrayTag1 = "[object Array]", boolTag2 = "[object Boolean]", dateTag2 = "[object Date]", errorTag1 = "[object Error]", funcTag2 = "[object Function]", genTag1 = "[object GeneratorFunction]", mapTag4 = "[object Map]", numberTag2 = "[object Number]", objectTag2 = "[object Object]", regexpTag2 = "[object RegExp]", setTag4 = "[object Set]", stringTag2 = "[object String]", symbolTag1 = "[object Symbol]", weakMapTag2 = "[object WeakMap]";
var arrayBufferTag2 = "[object ArrayBuffer]", dataViewTag3 = "[object DataView]", float32Tag2 = "[object Float32Array]", float64Tag2 = "[object Float64Array]", int8Tag2 = "[object Int8Array]", int16Tag2 = "[object Int16Array]", int32Tag2 = "[object Int32Array]", uint8Tag2 = "[object Uint8Array]", uint8ClampedTag2 = "[object Uint8ClampedArray]", uint16Tag2 = "[object Uint16Array]", uint32Tag2 = "[object Uint32Array]";
var cloneableTags = {};
cloneableTags[argsTag2] = cloneableTags[arrayTag1] = cloneableTags[arrayBufferTag2] = cloneableTags[dataViewTag3] = cloneableTags[boolTag2] = cloneableTags[dateTag2] = cloneableTags[float32Tag2] = cloneableTags[float64Tag2] = cloneableTags[int8Tag2] = cloneableTags[int16Tag2] = cloneableTags[int32Tag2] = cloneableTags[mapTag4] = cloneableTags[numberTag2] = cloneableTags[objectTag2] = cloneableTags[regexpTag2] = cloneableTags[setTag4] = cloneableTags[stringTag2] = cloneableTags[symbolTag1] = cloneableTags[uint8Tag2] = cloneableTags[uint8ClampedTag2] = cloneableTags[uint16Tag2] = cloneableTags[uint32Tag2] = true;
cloneableTags[errorTag1] = cloneableTags[funcTag2] = cloneableTags[weakMapTag2] = false;
function baseClone(value, bitmask, customizer, key, object, stack) {
    var result, isDeep = bitmask & CLONE_DEEP_FLAG, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG;
    if (customizer) {
        result = object ? customizer(value, key, object, stack) : customizer(value);
    }
    if (result !== void 0) {
        return result;
    }
    if (!__VIRTUAL_FILE18(value)) {
        return value;
    }
    var isArr = __VIRTUAL_FILE53(value);
    if (isArr) {
        result = __VIRTUAL_FILE92(value);
        if (!isDeep) {
            return __VIRTUAL_FILE75(value, result);
        }
    } else {
        var tag = __VIRTUAL_FILE91(value), isFunc = tag == funcTag2 || tag == genTag1;
        if (__VIRTUAL_FILE55(value)) {
            return __VIRTUAL_FILE74(value, isDeep);
        }
        if (tag == objectTag2 || tag == argsTag2 || isFunc && !object) {
            result = isFlat || isFunc ? {} : __VIRTUAL_FILE101(value);
            if (!isDeep) {
                return isFlat ? __VIRTUAL_FILE83(value, __VIRTUAL_FILE73(result, value)) : __VIRTUAL_FILE79(value, __VIRTUAL_FILE69(result, value));
            }
        } else {
            if (!cloneableTags[tag]) {
                return object ? value : {};
            }
            result = __VIRTUAL_FILE99(value, tag, isDeep);
        }
    }
    stack || (stack = new __VIRTUAL_FILE43());
    var stacked = stack.get(value);
    if (stacked) {
        return stacked;
    }
    stack.set(value, result);
    if (__VIRTUAL_FILE105(value)) {
        value.forEach(function(subValue) {
            result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));
        });
    } else if (__VIRTUAL_FILE103(value)) {
        value.forEach(function(subValue, key2) {
            result.set(key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
        });
    }
    var keysFunc = isFull ? isFlat ? __VIRTUAL_FILE86 : __VIRTUAL_FILE85 : isFlat ? __VIRTUAL_FILE72 : __VIRTUAL_FILE68;
    var props = isArr ? void 0 : keysFunc(value);
    __VIRTUAL_FILE44(props || value, function(subValue, key2) {
        if (props) {
            key2 = subValue;
            subValue = value[key2];
        }
        __VIRTUAL_FILE47(result, key2, baseClone(subValue, bitmask, customizer, key2, value, stack));
    });
    return result;
}
var __VIRTUAL_FILE106 = baseClone;
var CLONE_DEEP_FLAG1 = 1, CLONE_SYMBOLS_FLAG1 = 4;
function cloneDeep(value) {
    return __VIRTUAL_FILE106(value, CLONE_DEEP_FLAG1 | CLONE_SYMBOLS_FLAG1);
}
var __VIRTUAL_FILE107 = cloneDeep;
var now = function() {
    return __VIRTUAL_FILE13.Date.now();
};
var __VIRTUAL_FILE108 = now;
var reWhitespace = /\s/;
function trimmedEndIndex(string4) {
    var index = string4.length;
    while(index-- && reWhitespace.test(string4.charAt(index))){}
    return index;
}
var __VIRTUAL_FILE109 = trimmedEndIndex;
var reTrimStart = /^\s+/;
function baseTrim(string5) {
    return string5 ? string5.slice(0, __VIRTUAL_FILE109(string5) + 1).replace(reTrimStart, "") : string5;
}
var __VIRTUAL_FILE110 = baseTrim;
var symbolTag2 = "[object Symbol]";
function isSymbol(value) {
    return typeof value == "symbol" || __VIRTUAL_FILE50(value) && __VIRTUAL_FILE17(value) == symbolTag2;
}
var __VIRTUAL_FILE111 = isSymbol;
var NAN = 0 / 0;
var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
var reIsBinary = /^0b[01]+$/i;
var reIsOctal = /^0o[0-7]+$/i;
var freeParseInt = parseInt;
function toNumber(value) {
    if (typeof value == "number") {
        return value;
    }
    if (__VIRTUAL_FILE111(value)) {
        return NAN;
    }
    if (__VIRTUAL_FILE18(value)) {
        var other = typeof value.valueOf == "function" ? value.valueOf() : value;
        value = __VIRTUAL_FILE18(other) ? other + "" : other;
    }
    if (typeof value != "string") {
        return value === 0 ? value : +value;
    }
    value = __VIRTUAL_FILE110(value);
    var isBinary1 = reIsBinary.test(value);
    return isBinary1 || reIsOctal.test(value) ? freeParseInt(value.slice(2), isBinary1 ? 2 : 8) : reIsBadHex.test(value) ? NAN : +value;
}
var __VIRTUAL_FILE112 = toNumber;
var FUNC_ERROR_TEXT = "Expected a function";
var nativeMax = Math.max, nativeMin = Math.min;
function debounce(func, wait, options) {
    var lastArgs, lastThis, maxWait, result, timerId, lastCallTime, lastInvokeTime = 0, leading = false, maxing = false, trailing = true;
    if (typeof func != "function") {
        throw new TypeError(FUNC_ERROR_TEXT);
    }
    wait = __VIRTUAL_FILE112(wait) || 0;
    if (__VIRTUAL_FILE18(options)) {
        leading = !!options.leading;
        maxing = "maxWait" in options;
        maxWait = maxing ? nativeMax(__VIRTUAL_FILE112(options.maxWait) || 0, wait) : maxWait;
        trailing = "trailing" in options ? !!options.trailing : trailing;
    }
    function invokeFunc(time) {
        var args = lastArgs, thisArg = lastThis;
        lastArgs = lastThis = void 0;
        lastInvokeTime = time;
        result = func.apply(thisArg, args);
        return result;
    }
    function leadingEdge(time) {
        lastInvokeTime = time;
        timerId = setTimeout(timerExpired, wait);
        return leading ? invokeFunc(time) : result;
    }
    function remainingWait(time) {
        var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime, timeWaiting = wait - timeSinceLastCall;
        return maxing ? nativeMin(timeWaiting, maxWait - timeSinceLastInvoke) : timeWaiting;
    }
    function shouldInvoke(time) {
        var timeSinceLastCall = time - lastCallTime, timeSinceLastInvoke = time - lastInvokeTime;
        return lastCallTime === void 0 || timeSinceLastCall >= wait || timeSinceLastCall < 0 || maxing && timeSinceLastInvoke >= maxWait;
    }
    function timerExpired() {
        var time = __VIRTUAL_FILE108();
        if (shouldInvoke(time)) {
            return trailingEdge(time);
        }
        timerId = setTimeout(timerExpired, remainingWait(time));
    }
    function trailingEdge(time) {
        timerId = void 0;
        if (trailing && lastArgs) {
            return invokeFunc(time);
        }
        lastArgs = lastThis = void 0;
        return result;
    }
    function cancel() {
        if (timerId !== void 0) {
            clearTimeout(timerId);
        }
        lastInvokeTime = 0;
        lastArgs = lastCallTime = lastThis = timerId = void 0;
    }
    function flush() {
        return timerId === void 0 ? result : trailingEdge(__VIRTUAL_FILE108());
    }
    function debounced() {
        var time = __VIRTUAL_FILE108(), isInvoking = shouldInvoke(time);
        lastArgs = arguments;
        lastThis = this;
        lastCallTime = time;
        if (isInvoking) {
            if (timerId === void 0) {
                return leadingEdge(lastCallTime);
            }
            if (maxing) {
                clearTimeout(timerId);
                timerId = setTimeout(timerExpired, wait);
                return invokeFunc(lastCallTime);
            }
        }
        if (timerId === void 0) {
            timerId = setTimeout(timerExpired, wait);
        }
        return result;
    }
    debounced.cancel = cancel;
    debounced.flush = flush;
    return debounced;
}
var __VIRTUAL_FILE113 = debounce;
var HASH_UNDEFINED2 = "__lodash_hash_undefined__";
function setCacheAdd(value) {
    this.__data__.set(value, HASH_UNDEFINED2);
    return this;
}
var __VIRTUAL_FILE114 = setCacheAdd;
function setCacheHas(value) {
    return this.__data__.has(value);
}
var __VIRTUAL_FILE115 = setCacheHas;
function SetCache(values7) {
    var index = -1, length = values7 == null ? 0 : values7.length;
    this.__data__ = new __VIRTUAL_FILE41();
    while(++index < length){
        this.add(values7[index]);
    }
}
SetCache.prototype.add = SetCache.prototype.push = __VIRTUAL_FILE114;
SetCache.prototype.has = __VIRTUAL_FILE115;
var __VIRTUAL_FILE116 = SetCache;
function baseFindIndex(array, predicate, fromIndex, fromRight) {
    var length = array.length, index = fromIndex + (fromRight ? 1 : -1);
    while(fromRight ? index-- : ++index < length){
        if (predicate(array[index], index, array)) {
            return index;
        }
    }
    return -1;
}
var __VIRTUAL_FILE117 = baseFindIndex;
function baseIsNaN(value) {
    return value !== value;
}
var __VIRTUAL_FILE118 = baseIsNaN;
function strictIndexOf(array, value, fromIndex) {
    var index = fromIndex - 1, length = array.length;
    while(++index < length){
        if (array[index] === value) {
            return index;
        }
    }
    return -1;
}
var __VIRTUAL_FILE119 = strictIndexOf;
function baseIndexOf(array, value, fromIndex) {
    return value === value ? __VIRTUAL_FILE119(array, value, fromIndex) : __VIRTUAL_FILE117(array, __VIRTUAL_FILE118, fromIndex);
}
var __VIRTUAL_FILE120 = baseIndexOf;
function arrayIncludes(array, value) {
    var length = array == null ? 0 : array.length;
    return !!length && __VIRTUAL_FILE120(array, value, 0) > -1;
}
var __VIRTUAL_FILE121 = arrayIncludes;
function arrayIncludesWith(array, value, comparator) {
    var index = -1, length = array == null ? 0 : array.length;
    while(++index < length){
        if (comparator(value, array[index])) {
            return true;
        }
    }
    return false;
}
var __VIRTUAL_FILE122 = arrayIncludesWith;
function arrayMap(array, iteratee) {
    var index = -1, length = array == null ? 0 : array.length, result = Array(length);
    while(++index < length){
        result[index] = iteratee(array[index], index, array);
    }
    return result;
}
var __VIRTUAL_FILE123 = arrayMap;
function cacheHas(cache, key) {
    return cache.has(key);
}
var __VIRTUAL_FILE124 = cacheHas;
var LARGE_ARRAY_SIZE1 = 200;
function baseDifference(array, values8, iteratee, comparator) {
    var index = -1, includes = __VIRTUAL_FILE121, isCommon = true, length = array.length, result = [], valuesLength = values8.length;
    if (!length) {
        return result;
    }
    if (iteratee) {
        values8 = __VIRTUAL_FILE123(values8, __VIRTUAL_FILE59(iteratee));
    }
    if (comparator) {
        includes = __VIRTUAL_FILE122;
        isCommon = false;
    } else if (values8.length >= LARGE_ARRAY_SIZE1) {
        includes = __VIRTUAL_FILE124;
        isCommon = false;
        values8 = new __VIRTUAL_FILE116(values8);
    }
    outer: while(++index < length){
        var value = array[index], computed = iteratee == null ? value : iteratee(value);
        value = comparator || value !== 0 ? value : 0;
        if (isCommon && computed === computed) {
            var valuesIndex = valuesLength;
            while(valuesIndex--){
                if (values8[valuesIndex] === computed) {
                    continue outer;
                }
            }
            result.push(value);
        } else if (!includes(values8, computed, comparator)) {
            result.push(value);
        }
    }
    return result;
}
var __VIRTUAL_FILE125 = baseDifference;
var spreadableSymbol = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.isConcatSpreadable : void 0;
function isFlattenable(value) {
    return __VIRTUAL_FILE53(value) || __VIRTUAL_FILE52(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
}
var __VIRTUAL_FILE126 = isFlattenable;
function baseFlatten(array, depth, predicate, isStrict, result) {
    var index = -1, length = array.length;
    predicate || (predicate = __VIRTUAL_FILE126);
    result || (result = []);
    while(++index < length){
        var value = array[index];
        if (depth > 0 && predicate(value)) {
            if (depth > 1) {
                baseFlatten(value, depth - 1, predicate, isStrict, result);
            } else {
                __VIRTUAL_FILE80(result, value);
            }
        } else if (!isStrict) {
            result[result.length] = value;
        }
    }
    return result;
}
var __VIRTUAL_FILE127 = baseFlatten;
function identity(value) {
    return value;
}
var __VIRTUAL_FILE128 = identity;
function apply(func, thisArg, args) {
    switch(args.length){
        case 0:
            return func.call(thisArg);
        case 1:
            return func.call(thisArg, args[0]);
        case 2:
            return func.call(thisArg, args[0], args[1]);
        case 3:
            return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
}
var __VIRTUAL_FILE129 = apply;
var nativeMax1 = Math.max;
function overRest(func, start, transform) {
    start = nativeMax1(start === void 0 ? func.length - 1 : start, 0);
    return function() {
        var args = arguments, index = -1, length = nativeMax1(args.length - start, 0), array = Array(length);
        while(++index < length){
            array[index] = args[start + index];
        }
        index = -1;
        var otherArgs = Array(start + 1);
        while(++index < start){
            otherArgs[index] = args[index];
        }
        otherArgs[start] = transform(array);
        return __VIRTUAL_FILE129(func, this, otherArgs);
    };
}
var __VIRTUAL_FILE130 = overRest;
function constant(value) {
    return function() {
        return value;
    };
}
var __VIRTUAL_FILE131 = constant;
var baseSetToString = !__VIRTUAL_FILE45 ? __VIRTUAL_FILE128 : function(func, string6) {
    return __VIRTUAL_FILE45(func, "toString", {
        configurable: true,
        enumerable: false,
        value: __VIRTUAL_FILE131(string6),
        writable: true
    });
};
var __VIRTUAL_FILE132 = baseSetToString;
var HOT_COUNT = 800, HOT_SPAN = 16;
var nativeNow = Date.now;
function shortOut(func) {
    var count = 0, lastCalled = 0;
    return function() {
        var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
        lastCalled = stamp;
        if (remaining > 0) {
            if (++count >= HOT_COUNT) {
                return arguments[0];
            }
        } else {
            count = 0;
        }
        return func.apply(void 0, arguments);
    };
}
var __VIRTUAL_FILE133 = shortOut;
var setToString = __VIRTUAL_FILE133(__VIRTUAL_FILE132);
var __VIRTUAL_FILE134 = setToString;
function baseRest(func, start) {
    return __VIRTUAL_FILE134(__VIRTUAL_FILE130(func, start, __VIRTUAL_FILE128), func + "");
}
var __VIRTUAL_FILE135 = baseRest;
function isArrayLikeObject(value) {
    return __VIRTUAL_FILE50(value) && __VIRTUAL_FILE67(value);
}
var __VIRTUAL_FILE136 = isArrayLikeObject;
var difference = __VIRTUAL_FILE135(function(array, values9) {
    return __VIRTUAL_FILE136(array) ? __VIRTUAL_FILE125(array, __VIRTUAL_FILE127(values9, 1, __VIRTUAL_FILE136, true)) : [];
});
var __VIRTUAL_FILE137 = difference;
function createBaseFor(fromRight) {
    return function(object, iteratee, keysFunc) {
        var index = -1, iterable = Object(object), props = keysFunc(object), length = props.length;
        while(length--){
            var key = props[fromRight ? length : ++index];
            if (iteratee(iterable[key], key, iterable) === false) {
                break;
            }
        }
        return object;
    };
}
var __VIRTUAL_FILE138 = createBaseFor;
var baseFor = __VIRTUAL_FILE138();
var __VIRTUAL_FILE139 = baseFor;
function baseForOwn(object, iteratee) {
    return object && __VIRTUAL_FILE139(object, iteratee, __VIRTUAL_FILE68);
}
var __VIRTUAL_FILE140 = baseForOwn;
function createBaseEach(eachFunc, fromRight) {
    return function(collection, iteratee) {
        if (collection == null) {
            return collection;
        }
        if (!__VIRTUAL_FILE67(collection)) {
            return eachFunc(collection, iteratee);
        }
        var length = collection.length, index = fromRight ? length : -1, iterable = Object(collection);
        while(fromRight ? index-- : ++index < length){
            if (iteratee(iterable[index], index, iterable) === false) {
                break;
            }
        }
        return collection;
    };
}
var __VIRTUAL_FILE141 = createBaseEach;
var baseEach = __VIRTUAL_FILE141(__VIRTUAL_FILE140);
var __VIRTUAL_FILE142 = baseEach;
function castFunction(value) {
    return typeof value == "function" ? value : __VIRTUAL_FILE128;
}
var __VIRTUAL_FILE143 = castFunction;
function forEach(collection, iteratee) {
    var func = __VIRTUAL_FILE53(collection) ? __VIRTUAL_FILE44 : __VIRTUAL_FILE142;
    return func(collection, __VIRTUAL_FILE143(iteratee));
}
var __VIRTUAL_FILE144 = forEach;
var __VIRTUAL_FILE145 = __VIRTUAL_FILE144;
function assignMergeValue(object, key, value) {
    if (value !== void 0 && !__VIRTUAL_FILE1(object[key], value) || value === void 0 && !(key in object)) {
        __VIRTUAL_FILE46(object, key, value);
    }
}
var __VIRTUAL_FILE146 = assignMergeValue;
var objectTag3 = "[object Object]";
var funcProto2 = Function.prototype, objectProto13 = Object.prototype;
var funcToString2 = funcProto2.toString;
var hasOwnProperty10 = objectProto13.hasOwnProperty;
var objectCtorString = funcToString2.call(Object);
function isPlainObject(value) {
    if (!__VIRTUAL_FILE50(value) || __VIRTUAL_FILE17(value) != objectTag3) {
        return false;
    }
    var proto3 = __VIRTUAL_FILE81(value);
    if (proto3 === null) {
        return true;
    }
    var Ctor = hasOwnProperty10.call(proto3, "constructor") && proto3.constructor;
    return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString2.call(Ctor) == objectCtorString;
}
var __VIRTUAL_FILE147 = isPlainObject;
function safeGet(object, key) {
    if (key === "constructor" && typeof object[key] === "function") {
        return;
    }
    if (key == "__proto__") {
        return;
    }
    return object[key];
}
var __VIRTUAL_FILE148 = safeGet;
function toPlainObject(value) {
    return __VIRTUAL_FILE48(value, __VIRTUAL_FILE72(value));
}
var __VIRTUAL_FILE149 = toPlainObject;
function baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {
    var objValue = __VIRTUAL_FILE148(object, key), srcValue = __VIRTUAL_FILE148(source, key), stacked = stack.get(srcValue);
    if (stacked) {
        __VIRTUAL_FILE146(object, key, stacked);
        return;
    }
    var newValue = customizer ? customizer(objValue, srcValue, key + "", object, source, stack) : void 0;
    var isCommon = newValue === void 0;
    if (isCommon) {
        var isArr = __VIRTUAL_FILE53(srcValue), isBuff = !isArr && __VIRTUAL_FILE55(srcValue), isTyped = !isArr && !isBuff && __VIRTUAL_FILE61(srcValue);
        newValue = srcValue;
        if (isArr || isBuff || isTyped) {
            if (__VIRTUAL_FILE53(objValue)) {
                newValue = objValue;
            } else if (__VIRTUAL_FILE136(objValue)) {
                newValue = __VIRTUAL_FILE75(objValue);
            } else if (isBuff) {
                isCommon = false;
                newValue = __VIRTUAL_FILE74(srcValue, true);
            } else if (isTyped) {
                isCommon = false;
                newValue = __VIRTUAL_FILE98(srcValue, true);
            } else {
                newValue = [];
            }
        } else if (__VIRTUAL_FILE147(srcValue) || __VIRTUAL_FILE52(srcValue)) {
            newValue = objValue;
            if (__VIRTUAL_FILE52(objValue)) {
                newValue = __VIRTUAL_FILE149(objValue);
            } else if (!__VIRTUAL_FILE18(objValue) || __VIRTUAL_FILE19(objValue)) {
                newValue = __VIRTUAL_FILE101(srcValue);
            }
        } else {
            isCommon = false;
        }
    }
    if (isCommon) {
        stack.set(srcValue, newValue);
        mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
        stack["delete"](srcValue);
    }
    __VIRTUAL_FILE146(object, key, newValue);
}
var __VIRTUAL_FILE150 = baseMergeDeep;
function baseMerge(object, source, srcIndex, customizer, stack) {
    if (object === source) {
        return;
    }
    __VIRTUAL_FILE139(source, function(srcValue, key) {
        stack || (stack = new __VIRTUAL_FILE43());
        if (__VIRTUAL_FILE18(srcValue)) {
            __VIRTUAL_FILE150(object, source, key, srcIndex, baseMerge, customizer, stack);
        } else {
            var newValue = customizer ? customizer(__VIRTUAL_FILE148(object, key), srcValue, key + "", object, source, stack) : void 0;
            if (newValue === void 0) {
                newValue = srcValue;
            }
            __VIRTUAL_FILE146(object, key, newValue);
        }
    }, __VIRTUAL_FILE72);
}
var __VIRTUAL_FILE151 = baseMerge;
function isIterateeCall(value, index, object) {
    if (!__VIRTUAL_FILE18(object)) {
        return false;
    }
    var type27 = typeof index;
    if (type27 == "number" ? __VIRTUAL_FILE67(object) && __VIRTUAL_FILE56(index, object.length) : type27 == "string" && index in object) {
        return __VIRTUAL_FILE1(object[index], value);
    }
    return false;
}
var __VIRTUAL_FILE152 = isIterateeCall;
function createAssigner(assigner) {
    return __VIRTUAL_FILE135(function(object, sources) {
        var index = -1, length = sources.length, customizer = length > 1 ? sources[length - 1] : void 0, guard = length > 2 ? sources[2] : void 0;
        customizer = assigner.length > 3 && typeof customizer == "function" ? (length--, customizer) : void 0;
        if (guard && __VIRTUAL_FILE152(sources[0], sources[1], guard)) {
            customizer = length < 3 ? void 0 : customizer;
            length = 1;
        }
        object = Object(object);
        while(++index < length){
            var source = sources[index];
            if (source) {
                assigner(object, source, index, customizer);
            }
        }
        return object;
    });
}
var __VIRTUAL_FILE153 = createAssigner;
var mergeWith = __VIRTUAL_FILE153(function(object, source, srcIndex, customizer) {
    __VIRTUAL_FILE151(object, source, srcIndex, customizer);
});
var __VIRTUAL_FILE154 = mergeWith;
var nativeFloor = Math.floor, nativeRandom = Math.random;
function baseRandom(lower, upper) {
    return lower + nativeFloor(nativeRandom() * (upper - lower + 1));
}
var __VIRTUAL_FILE155 = baseRandom;
function shuffleSelf(array, size) {
    var index = -1, length = array.length, lastIndex = length - 1;
    size = size === void 0 ? length : size;
    while(++index < size){
        var rand = __VIRTUAL_FILE155(index, lastIndex), value = array[rand];
        array[rand] = array[index];
        array[index] = value;
    }
    array.length = size;
    return array;
}
var __VIRTUAL_FILE156 = shuffleSelf;
function arrayShuffle(array) {
    return __VIRTUAL_FILE156(__VIRTUAL_FILE75(array));
}
var __VIRTUAL_FILE157 = arrayShuffle;
function baseValues(object, props) {
    return __VIRTUAL_FILE123(props, function(key) {
        return object[key];
    });
}
var __VIRTUAL_FILE158 = baseValues;
function values(object) {
    return object == null ? [] : __VIRTUAL_FILE158(object, __VIRTUAL_FILE68(object));
}
var __VIRTUAL_FILE159 = values;
function baseShuffle(collection) {
    return __VIRTUAL_FILE156(__VIRTUAL_FILE159(collection));
}
var __VIRTUAL_FILE160 = baseShuffle;
function shuffle(collection) {
    var func = __VIRTUAL_FILE53(collection) ? __VIRTUAL_FILE157 : __VIRTUAL_FILE160;
    return func(collection);
}
var __VIRTUAL_FILE161 = shuffle;
var assignInWith = __VIRTUAL_FILE153(function(object, source, srcIndex, customizer) {
    __VIRTUAL_FILE48(source, __VIRTUAL_FILE72(source), object, customizer);
});
var __VIRTUAL_FILE162 = assignInWith;
var domExcTag = "[object DOMException]", errorTag2 = "[object Error]";
function isError(value) {
    if (!__VIRTUAL_FILE50(value)) {
        return false;
    }
    var tag = __VIRTUAL_FILE17(value);
    return tag == errorTag2 || tag == domExcTag || typeof value.message == "string" && typeof value.name == "string" && !__VIRTUAL_FILE147(value);
}
var __VIRTUAL_FILE163 = isError;
var attempt = __VIRTUAL_FILE135(function(func, args) {
    try {
        return __VIRTUAL_FILE129(func, void 0, args);
    } catch (e) {
        return __VIRTUAL_FILE163(e) ? e : new Error(e);
    }
});
var __VIRTUAL_FILE164 = attempt;
var objectProto14 = Object.prototype;
var hasOwnProperty11 = objectProto14.hasOwnProperty;
function customDefaultsAssignIn(objValue, srcValue, key, object) {
    if (objValue === void 0 || __VIRTUAL_FILE1(objValue, objectProto14[key]) && !hasOwnProperty11.call(object, key)) {
        return srcValue;
    }
    return objValue;
}
var __VIRTUAL_FILE165 = customDefaultsAssignIn;
var stringEscapes = {
    "\\": "\\",
    "'": "'",
    "\n": "n",
    "\r": "r",
    "\u2028": "u2028",
    "\u2029": "u2029"
};
function escapeStringChar(chr) {
    return "\\" + stringEscapes[chr];
}
var __VIRTUAL_FILE166 = escapeStringChar;
var reInterpolate = /<%=([\s\S]+?)%>/g;
var __VIRTUAL_FILE167 = reInterpolate;
function basePropertyOf(object) {
    return function(key) {
        return object == null ? void 0 : object[key];
    };
}
var __VIRTUAL_FILE168 = basePropertyOf;
var htmlEscapes = {
    "&": "&amp;",
    "<": "&lt;",
    ">": "&gt;",
    '"': "&quot;",
    "'": "&#39;"
};
var escapeHtmlChar = __VIRTUAL_FILE168(htmlEscapes);
var __VIRTUAL_FILE169 = escapeHtmlChar;
var INFINITY = 1 / 0;
var symbolProto1 = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.prototype : void 0, symbolToString = symbolProto1 ? symbolProto1.toString : void 0;
function baseToString(value) {
    if (typeof value == "string") {
        return value;
    }
    if (__VIRTUAL_FILE53(value)) {
        return __VIRTUAL_FILE123(value, baseToString) + "";
    }
    if (__VIRTUAL_FILE111(value)) {
        return symbolToString ? symbolToString.call(value) : "";
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY ? "-0" : result;
}
var __VIRTUAL_FILE170 = baseToString;
function toString(value) {
    return value == null ? "" : __VIRTUAL_FILE170(value);
}
var __VIRTUAL_FILE171 = toString;
var reUnescapedHtml = /[&<>"']/g, reHasUnescapedHtml = RegExp(reUnescapedHtml.source);
function escape(string7) {
    string7 = __VIRTUAL_FILE171(string7);
    return string7 && reHasUnescapedHtml.test(string7) ? string7.replace(reUnescapedHtml, __VIRTUAL_FILE169) : string7;
}
var __VIRTUAL_FILE172 = escape;
var reEscape = /<%-([\s\S]+?)%>/g;
var __VIRTUAL_FILE173 = reEscape;
var reEvaluate = /<%([\s\S]+?)%>/g;
var __VIRTUAL_FILE174 = reEvaluate;
var templateSettings = {
    escape: __VIRTUAL_FILE173,
    evaluate: __VIRTUAL_FILE174,
    interpolate: __VIRTUAL_FILE167,
    variable: "",
    imports: {
        _: {
            escape: __VIRTUAL_FILE172
        }
    }
};
var __VIRTUAL_FILE175 = templateSettings;
var INVALID_TEMPL_VAR_ERROR_TEXT = "Invalid `variable` option passed into `_.template`";
var reEmptyStringLeading = /\b__p \+= '';/g, reEmptyStringMiddle = /\b(__p \+=) '' \+/g, reEmptyStringTrailing = /(__e\(.*?\)|\b__t\)) \+\n'';/g;
var reForbiddenIdentifierChars = /[()=,{}\[\]\/\s]/;
var reEsTemplate = /\$\{([^\\}]*(?:\\.[^\\}]*)*)\}/g;
var reNoMatch = /($^)/;
var reUnescapedString = /['\n\r\u2028\u2029\\]/g;
var objectProto15 = Object.prototype;
var hasOwnProperty12 = objectProto15.hasOwnProperty;
function template(string8, options, guard) {
    var settings = __VIRTUAL_FILE175.imports._.templateSettings || __VIRTUAL_FILE175;
    if (guard && __VIRTUAL_FILE152(string8, options, guard)) {
        options = void 0;
    }
    string8 = __VIRTUAL_FILE171(string8);
    options = __VIRTUAL_FILE162({}, options, settings, __VIRTUAL_FILE165);
    var imports = __VIRTUAL_FILE162({}, options.imports, settings.imports, __VIRTUAL_FILE165), importsKeys = __VIRTUAL_FILE68(imports), importsValues = __VIRTUAL_FILE158(imports, importsKeys);
    var isEscaping, isEvaluating, index = 0, interpolate = options.interpolate || reNoMatch, source = "__p += '";
    var reDelimiters = RegExp((options.escape || reNoMatch).source + "|" + interpolate.source + "|" + (interpolate === __VIRTUAL_FILE167 ? reEsTemplate : reNoMatch).source + "|" + (options.evaluate || reNoMatch).source + "|$", "g");
    var sourceURL = hasOwnProperty12.call(options, "sourceURL") ? "//# sourceURL=" + (options.sourceURL + "").replace(/\s/g, " ") + "\n" : "";
    string8.replace(reDelimiters, function(match, escapeValue, interpolateValue, esTemplateValue, evaluateValue, offset) {
        interpolateValue || (interpolateValue = esTemplateValue);
        source += string8.slice(index, offset).replace(reUnescapedString, __VIRTUAL_FILE166);
        if (escapeValue) {
            isEscaping = true;
            source += "' +\n__e(" + escapeValue + ") +\n'";
        }
        if (evaluateValue) {
            isEvaluating = true;
            source += "';\n" + evaluateValue + ";\n__p += '";
        }
        if (interpolateValue) {
            source += "' +\n((__t = (" + interpolateValue + ")) == null ? '' : __t) +\n'";
        }
        index = offset + match.length;
        return match;
    });
    source += "';\n";
    var variable = hasOwnProperty12.call(options, "variable") && options.variable;
    if (!variable) {
        source = "with (obj) {\n" + source + "\n}\n";
    } else if (reForbiddenIdentifierChars.test(variable)) {
        throw new Error(INVALID_TEMPL_VAR_ERROR_TEXT);
    }
    source = (isEvaluating ? source.replace(reEmptyStringLeading, "") : source).replace(reEmptyStringMiddle, "$1").replace(reEmptyStringTrailing, "$1;");
    source = "function(" + (variable || "obj") + ") {\n" + (variable ? "" : "obj || (obj = {});\n") + "var __t, __p = ''" + (isEscaping ? ", __e = _.escape" : "") + (isEvaluating ? ", __j = Array.prototype.join;\nfunction print() { __p += __j.call(arguments, '') }\n" : ";\n") + source + "return __p\n}";
    var result = __VIRTUAL_FILE164(function() {
        return Function(importsKeys, sourceURL + "return " + source).apply(void 0, importsValues);
    });
    result.source = source;
    if (__VIRTUAL_FILE163(result)) {
        throw result;
    }
    return result;
}
var __VIRTUAL_FILE176 = template;
function noop() {}
var __VIRTUAL_FILE177 = noop;
function setToArray(set1) {
    var index = -1, result = Array(set1.size);
    set1.forEach(function(value) {
        result[++index] = value;
    });
    return result;
}
var __VIRTUAL_FILE178 = setToArray;
var INFINITY1 = 1 / 0;
var createSet = !(__VIRTUAL_FILE89 && 1 / __VIRTUAL_FILE178(new __VIRTUAL_FILE89([
    ,
    -0
]))[1] == INFINITY1) ? __VIRTUAL_FILE177 : function(values10) {
    return new __VIRTUAL_FILE89(values10);
};
var __VIRTUAL_FILE179 = createSet;
var LARGE_ARRAY_SIZE2 = 200;
function baseUniq(array, iteratee, comparator) {
    var index = -1, includes = __VIRTUAL_FILE121, length = array.length, isCommon = true, result = [], seen = result;
    if (comparator) {
        isCommon = false;
        includes = __VIRTUAL_FILE122;
    } else if (length >= LARGE_ARRAY_SIZE2) {
        var set2 = iteratee ? null : __VIRTUAL_FILE179(array);
        if (set2) {
            return __VIRTUAL_FILE178(set2);
        }
        isCommon = false;
        includes = __VIRTUAL_FILE124;
        seen = new __VIRTUAL_FILE116();
    } else {
        seen = iteratee ? [] : result;
    }
    outer: while(++index < length){
        var value = array[index], computed = iteratee ? iteratee(value) : value;
        value = comparator || value !== 0 ? value : 0;
        if (isCommon && computed === computed) {
            var seenIndex = seen.length;
            while(seenIndex--){
                if (seen[seenIndex] === computed) {
                    continue outer;
                }
            }
            if (iteratee) {
                seen.push(computed);
            }
            result.push(value);
        } else if (!includes(seen, computed, comparator)) {
            if (seen !== result) {
                seen.push(computed);
            }
            result.push(value);
        }
    }
    return result;
}
var __VIRTUAL_FILE180 = baseUniq;
function uniq(array) {
    return array && array.length ? __VIRTUAL_FILE180(array) : [];
}
var __VIRTUAL_FILE181 = uniq;
function arraySome(array, predicate) {
    var index = -1, length = array == null ? 0 : array.length;
    while(++index < length){
        if (predicate(array[index], index, array)) {
            return true;
        }
    }
    return false;
}
var __VIRTUAL_FILE182 = arraySome;
var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
function equalArrays(array, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG, arrLength = array.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
        return false;
    }
    var arrStacked = stack.get(array);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
        return arrStacked == other && othStacked == array;
    }
    var index = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG ? new __VIRTUAL_FILE116() : void 0;
    stack.set(array, other);
    stack.set(other, array);
    while(++index < arrLength){
        var arrValue = array[index], othValue = other[index];
        if (customizer) {
            var compared = isPartial ? customizer(othValue, arrValue, index, other, array, stack) : customizer(arrValue, othValue, index, array, other, stack);
        }
        if (compared !== void 0) {
            if (compared) {
                continue;
            }
            result = false;
            break;
        }
        if (seen) {
            if (!__VIRTUAL_FILE182(other, function(othValue2, othIndex) {
                if (!__VIRTUAL_FILE124(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
                    return seen.push(othIndex);
                }
            })) {
                result = false;
                break;
            }
        } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
            result = false;
            break;
        }
    }
    stack["delete"](array);
    stack["delete"](other);
    return result;
}
var __VIRTUAL_FILE183 = equalArrays;
function mapToArray(map3) {
    var index = -1, result = Array(map3.size);
    map3.forEach(function(value, key) {
        result[++index] = [
            key,
            value
        ];
    });
    return result;
}
var __VIRTUAL_FILE184 = mapToArray;
var COMPARE_PARTIAL_FLAG1 = 1, COMPARE_UNORDERED_FLAG1 = 2;
var boolTag3 = "[object Boolean]", dateTag3 = "[object Date]", errorTag3 = "[object Error]", mapTag5 = "[object Map]", numberTag3 = "[object Number]", regexpTag3 = "[object RegExp]", setTag5 = "[object Set]", stringTag3 = "[object String]", symbolTag3 = "[object Symbol]";
var arrayBufferTag3 = "[object ArrayBuffer]", dataViewTag4 = "[object DataView]";
var symbolProto2 = __VIRTUAL_FILE14 ? __VIRTUAL_FILE14.prototype : void 0, symbolValueOf1 = symbolProto2 ? symbolProto2.valueOf : void 0;
function equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {
    switch(tag){
        case dataViewTag4:
            if (object.byteLength != other.byteLength || object.byteOffset != other.byteOffset) {
                return false;
            }
            object = object.buffer;
            other = other.buffer;
        case arrayBufferTag3:
            if (object.byteLength != other.byteLength || !equalFunc(new __VIRTUAL_FILE93(object), new __VIRTUAL_FILE93(other))) {
                return false;
            }
            return true;
        case boolTag3:
        case dateTag3:
        case numberTag3:
            return __VIRTUAL_FILE1(+object, +other);
        case errorTag3:
            return object.name == other.name && object.message == other.message;
        case regexpTag3:
        case stringTag3:
            return object == other + "";
        case mapTag5:
            var convert = __VIRTUAL_FILE184;
        case setTag5:
            var isPartial = bitmask & COMPARE_PARTIAL_FLAG1;
            convert || (convert = __VIRTUAL_FILE178);
            if (object.size != other.size && !isPartial) {
                return false;
            }
            var stacked = stack.get(object);
            if (stacked) {
                return stacked == other;
            }
            bitmask |= COMPARE_UNORDERED_FLAG1;
            stack.set(object, other);
            var result = __VIRTUAL_FILE183(convert(object), convert(other), bitmask, customizer, equalFunc, stack);
            stack["delete"](object);
            return result;
        case symbolTag3:
            if (symbolValueOf1) {
                return symbolValueOf1.call(object) == symbolValueOf1.call(other);
            }
    }
    return false;
}
var __VIRTUAL_FILE185 = equalByTag;
var COMPARE_PARTIAL_FLAG2 = 1;
var objectProto16 = Object.prototype;
var hasOwnProperty13 = objectProto16.hasOwnProperty;
function equalObjects(object, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG2, objProps = __VIRTUAL_FILE85(object), objLength = objProps.length, othProps = __VIRTUAL_FILE85(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
        return false;
    }
    var index = objLength;
    while(index--){
        var key = objProps[index];
        if (!(isPartial ? key in other : hasOwnProperty13.call(other, key))) {
            return false;
        }
    }
    var objStacked = stack.get(object);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
        return objStacked == other && othStacked == object;
    }
    var result = true;
    stack.set(object, other);
    stack.set(other, object);
    var skipCtor = isPartial;
    while(++index < objLength){
        key = objProps[index];
        var objValue = object[key], othValue = other[key];
        if (customizer) {
            var compared = isPartial ? customizer(othValue, objValue, key, other, object, stack) : customizer(objValue, othValue, key, object, other, stack);
        }
        if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
            result = false;
            break;
        }
        skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
        var objCtor = object.constructor, othCtor = other.constructor;
        if (objCtor != othCtor && "constructor" in object && "constructor" in other && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
            result = false;
        }
    }
    stack["delete"](object);
    stack["delete"](other);
    return result;
}
var __VIRTUAL_FILE186 = equalObjects;
var COMPARE_PARTIAL_FLAG3 = 1;
var argsTag3 = "[object Arguments]", arrayTag2 = "[object Array]", objectTag4 = "[object Object]";
var objectProto17 = Object.prototype;
var hasOwnProperty14 = objectProto17.hasOwnProperty;
function baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = __VIRTUAL_FILE53(object), othIsArr = __VIRTUAL_FILE53(other), objTag = objIsArr ? arrayTag2 : __VIRTUAL_FILE91(object), othTag = othIsArr ? arrayTag2 : __VIRTUAL_FILE91(other);
    objTag = objTag == argsTag3 ? objectTag4 : objTag;
    othTag = othTag == argsTag3 ? objectTag4 : othTag;
    var objIsObj = objTag == objectTag4, othIsObj = othTag == objectTag4, isSameTag = objTag == othTag;
    if (isSameTag && __VIRTUAL_FILE55(object)) {
        if (!__VIRTUAL_FILE55(other)) {
            return false;
        }
        objIsArr = true;
        objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
        stack || (stack = new __VIRTUAL_FILE43());
        return objIsArr || __VIRTUAL_FILE61(object) ? __VIRTUAL_FILE183(object, other, bitmask, customizer, equalFunc, stack) : __VIRTUAL_FILE185(object, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG3)) {
        var objIsWrapped = objIsObj && hasOwnProperty14.call(object, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty14.call(other, "__wrapped__");
        if (objIsWrapped || othIsWrapped) {
            var objUnwrapped = objIsWrapped ? object.value() : object, othUnwrapped = othIsWrapped ? other.value() : other;
            stack || (stack = new __VIRTUAL_FILE43());
            return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
        }
    }
    if (!isSameTag) {
        return false;
    }
    stack || (stack = new __VIRTUAL_FILE43());
    return __VIRTUAL_FILE186(object, other, bitmask, customizer, equalFunc, stack);
}
var __VIRTUAL_FILE187 = baseIsEqualDeep;
function baseIsEqual(value, other, bitmask, customizer, stack) {
    if (value === other) {
        return true;
    }
    if (value == null || other == null || !__VIRTUAL_FILE50(value) && !__VIRTUAL_FILE50(other)) {
        return value !== value && other !== other;
    }
    return __VIRTUAL_FILE187(value, other, bitmask, customizer, baseIsEqual, stack);
}
var __VIRTUAL_FILE188 = baseIsEqual;
var COMPARE_PARTIAL_FLAG4 = 1, COMPARE_UNORDERED_FLAG2 = 2;
function baseIsMatch(object, source, matchData, customizer) {
    var index = matchData.length, length = index, noCustomizer = !customizer;
    if (object == null) {
        return !length;
    }
    object = Object(object);
    while(index--){
        var data15 = matchData[index];
        if (noCustomizer && data15[2] ? data15[1] !== object[data15[0]] : !(data15[0] in object)) {
            return false;
        }
    }
    while(++index < length){
        data15 = matchData[index];
        var key = data15[0], objValue = object[key], srcValue = data15[1];
        if (noCustomizer && data15[2]) {
            if (objValue === void 0 && !(key in object)) {
                return false;
            }
        } else {
            var stack = new __VIRTUAL_FILE43();
            if (customizer) {
                var result = customizer(objValue, srcValue, key, object, source, stack);
            }
            if (!(result === void 0 ? __VIRTUAL_FILE188(srcValue, objValue, COMPARE_PARTIAL_FLAG4 | COMPARE_UNORDERED_FLAG2, customizer, stack) : result)) {
                return false;
            }
        }
    }
    return true;
}
var __VIRTUAL_FILE189 = baseIsMatch;
function isStrictComparable(value) {
    return value === value && !__VIRTUAL_FILE18(value);
}
var __VIRTUAL_FILE190 = isStrictComparable;
function getMatchData(object) {
    var result = __VIRTUAL_FILE68(object), length = result.length;
    while(length--){
        var key = result[length], value = object[key];
        result[length] = [
            key,
            value,
            __VIRTUAL_FILE190(value)
        ];
    }
    return result;
}
var __VIRTUAL_FILE191 = getMatchData;
function matchesStrictComparable(key, srcValue) {
    return function(object) {
        if (object == null) {
            return false;
        }
        return object[key] === srcValue && (srcValue !== void 0 || key in Object(object));
    };
}
var __VIRTUAL_FILE192 = matchesStrictComparable;
function baseMatches(source) {
    var matchData = __VIRTUAL_FILE191(source);
    if (matchData.length == 1 && matchData[0][2]) {
        return __VIRTUAL_FILE192(matchData[0][0], matchData[0][1]);
    }
    return function(object) {
        return object === source || __VIRTUAL_FILE189(object, source, matchData);
    };
}
var __VIRTUAL_FILE193 = baseMatches;
var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
function isKey(value, object) {
    if (__VIRTUAL_FILE53(value)) {
        return false;
    }
    var type28 = typeof value;
    if (type28 == "number" || type28 == "symbol" || type28 == "boolean" || value == null || __VIRTUAL_FILE111(value)) {
        return true;
    }
    return reIsPlainProp.test(value) || !reIsDeepProp.test(value) || object != null && value in Object(object);
}
var __VIRTUAL_FILE194 = isKey;
var FUNC_ERROR_TEXT1 = "Expected a function";
function memoize(func, resolver) {
    if (typeof func != "function" || resolver != null && typeof resolver != "function") {
        throw new TypeError(FUNC_ERROR_TEXT1);
    }
    var memoized = function() {
        var args = arguments, key = resolver ? resolver.apply(this, args) : args[0], cache = memoized.cache;
        if (cache.has(key)) {
            return cache.get(key);
        }
        var result = func.apply(this, args);
        memoized.cache = cache.set(key, result) || cache;
        return result;
    };
    memoized.cache = new (memoize.Cache || __VIRTUAL_FILE41)();
    return memoized;
}
memoize.Cache = __VIRTUAL_FILE41;
var __VIRTUAL_FILE195 = memoize;
var MAX_MEMOIZE_SIZE = 500;
function memoizeCapped(func) {
    var result = __VIRTUAL_FILE195(func, function(key) {
        if (cache.size === MAX_MEMOIZE_SIZE) {
            cache.clear();
        }
        return key;
    });
    var cache = result.cache;
    return result;
}
var __VIRTUAL_FILE196 = memoizeCapped;
var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
var reEscapeChar = /\\(\\)?/g;
var stringToPath = __VIRTUAL_FILE196(function(string9) {
    var result = [];
    if (string9.charCodeAt(0) === 46) {
        result.push("");
    }
    string9.replace(rePropName, function(match, number1, quote, subString) {
        result.push(quote ? subString.replace(reEscapeChar, "$1") : number1 || match);
    });
    return result;
});
var __VIRTUAL_FILE197 = stringToPath;
function castPath(value, object) {
    if (__VIRTUAL_FILE53(value)) {
        return value;
    }
    return __VIRTUAL_FILE194(value, object) ? [
        value
    ] : __VIRTUAL_FILE197(__VIRTUAL_FILE171(value));
}
var __VIRTUAL_FILE198 = castPath;
var INFINITY2 = 1 / 0;
function toKey(value) {
    if (typeof value == "string" || __VIRTUAL_FILE111(value)) {
        return value;
    }
    var result = value + "";
    return result == "0" && 1 / value == -INFINITY2 ? "-0" : result;
}
var __VIRTUAL_FILE199 = toKey;
function baseGet(object, path47) {
    path47 = __VIRTUAL_FILE198(path47, object);
    var index = 0, length = path47.length;
    while(object != null && index < length){
        object = object[__VIRTUAL_FILE199(path47[index++])];
    }
    return index && index == length ? object : void 0;
}
var __VIRTUAL_FILE200 = baseGet;
function get(object, path48, defaultValue) {
    var result = object == null ? void 0 : __VIRTUAL_FILE200(object, path48);
    return result === void 0 ? defaultValue : result;
}
var __VIRTUAL_FILE201 = get;
function baseHasIn(object, key) {
    return object != null && key in Object(object);
}
var __VIRTUAL_FILE202 = baseHasIn;
function hasPath(object, path49, hasFunc) {
    path49 = __VIRTUAL_FILE198(path49, object);
    var index = -1, length = path49.length, result = false;
    while(++index < length){
        var key = __VIRTUAL_FILE199(path49[index]);
        if (!(result = object != null && hasFunc(object, key))) {
            break;
        }
        object = object[key];
    }
    if (result || ++index != length) {
        return result;
    }
    length = object == null ? 0 : object.length;
    return !!length && __VIRTUAL_FILE57(length) && __VIRTUAL_FILE56(key, length) && (__VIRTUAL_FILE53(object) || __VIRTUAL_FILE52(object));
}
var __VIRTUAL_FILE203 = hasPath;
function hasIn(object, path50) {
    return object != null && __VIRTUAL_FILE203(object, path50, __VIRTUAL_FILE202);
}
var __VIRTUAL_FILE204 = hasIn;
var COMPARE_PARTIAL_FLAG5 = 1, COMPARE_UNORDERED_FLAG3 = 2;
function baseMatchesProperty(path51, srcValue) {
    if (__VIRTUAL_FILE194(path51) && __VIRTUAL_FILE190(srcValue)) {
        return __VIRTUAL_FILE192(__VIRTUAL_FILE199(path51), srcValue);
    }
    return function(object) {
        var objValue = __VIRTUAL_FILE201(object, path51);
        return objValue === void 0 && objValue === srcValue ? __VIRTUAL_FILE204(object, path51) : __VIRTUAL_FILE188(srcValue, objValue, COMPARE_PARTIAL_FLAG5 | COMPARE_UNORDERED_FLAG3);
    };
}
var __VIRTUAL_FILE205 = baseMatchesProperty;
function baseProperty(key) {
    return function(object) {
        return object == null ? void 0 : object[key];
    };
}
var __VIRTUAL_FILE206 = baseProperty;
function basePropertyDeep(path52) {
    return function(object) {
        return __VIRTUAL_FILE200(object, path52);
    };
}
var __VIRTUAL_FILE207 = basePropertyDeep;
function property(path53) {
    return __VIRTUAL_FILE194(path53) ? __VIRTUAL_FILE206(__VIRTUAL_FILE199(path53)) : __VIRTUAL_FILE207(path53);
}
var __VIRTUAL_FILE208 = property;
function baseIteratee(value) {
    if (typeof value == "function") {
        return value;
    }
    if (value == null) {
        return __VIRTUAL_FILE128;
    }
    if (typeof value == "object") {
        return __VIRTUAL_FILE53(value) ? __VIRTUAL_FILE205(value[0], value[1]) : __VIRTUAL_FILE193(value);
    }
    return __VIRTUAL_FILE208(value);
}
var __VIRTUAL_FILE209 = baseIteratee;
function uniqBy(array, iteratee) {
    return array && array.length ? __VIRTUAL_FILE180(array, __VIRTUAL_FILE209(iteratee, 2)) : [];
}
var __VIRTUAL_FILE210 = uniqBy;
function isEqual(value, other) {
    return __VIRTUAL_FILE188(value, other);
}
var __VIRTUAL_FILE211 = isEqual;
const cloneDeep1 = __VIRTUAL_FILE107;
const shuffle1 = __VIRTUAL_FILE161;
const toString1 = __VIRTUAL_FILE171;
const uniq1 = __VIRTUAL_FILE181;
const uniqBy1 = __VIRTUAL_FILE210;
function deferred() {
    let methods;
    let state1 = "pending";
    const promise = new Promise((resolve5, reject)=>{
        methods = {
            async resolve (value) {
                await value;
                state1 = "fulfilled";
                resolve5(value);
            },
            reject (reason) {
                state1 = "rejected";
                reject(reason);
            }
        };
    });
    Object.defineProperty(promise, "state", {
        get: ()=>state1
    });
    return Object.assign(promise, methods);
}
class MuxAsyncIterator {
    iteratorCount = 0;
    yields = [];
    throws = [];
    signal = deferred();
    add(iterable) {
        ++this.iteratorCount;
        this.callIteratorNext(iterable[Symbol.asyncIterator]());
    }
    async callIteratorNext(iterator) {
        try {
            const { value , done  } = await iterator.next();
            if (done) {
                --this.iteratorCount;
            } else {
                this.yields.push({
                    iterator,
                    value
                });
            }
        } catch (e) {
            this.throws.push(e);
        }
        this.signal.resolve();
    }
    async *iterate() {
        while(this.iteratorCount > 0){
            await this.signal;
            for(let i29 = 0; i29 < this.yields.length; i29++){
                const { iterator , value  } = this.yields[i29];
                yield value;
                this.callIteratorNext(iterator);
            }
            if (this.throws.length) {
                for (const e of this.throws){
                    throw e;
                }
                this.throws.length = 0;
            }
            this.yields.length = 0;
            this.signal = deferred();
        }
    }
    [Symbol.asyncIterator]() {
        return this.iterate();
    }
}
function pooledMap(poolLimit, array, iteratorFn) {
    const res = new TransformStream({
        async transform (p, controller) {
            controller.enqueue(await p);
        }
    });
    (async ()=>{
        const writer = res.writable.getWriter();
        const executing = [];
        try {
            for await (const item of array){
                const p = Promise.resolve().then(()=>iteratorFn(item)
                );
                p.then((v)=>writer.write(Promise.resolve(v))
                ).catch(()=>{});
                const e = p.then(()=>executing.splice(executing.indexOf(e), 1)
                );
                executing.push(e);
                if (executing.length >= poolLimit) {
                    await Promise.race(executing);
                }
            }
            await Promise.all(executing);
            writer.close();
        } catch  {
            const errors4 = [];
            for (const result of (await Promise.allSettled(executing))){
                if (result.status == "rejected") {
                    errors4.push(result.reason);
                }
            }
            writer.write(Promise.reject(new AggregateError(errors4, "Threw while mapping."))).catch(()=>{});
        }
    })();
    return res.readable[Symbol.asyncIterator]();
}
const DEFAULT_BUFFER_SIZE = 32 * 1024;
function readAllSync(r) {
    const buf = new Buffer();
    buf.readFromSync(r);
    return buf.bytes();
}
async function writeAll(w, arr) {
    let nwritten = 0;
    while(nwritten < arr.length){
        nwritten += await w.write(arr.subarray(nwritten));
    }
}
function writeAllSync(w, arr) {
    let nwritten = 0;
    while(nwritten < arr.length){
        nwritten += w.writeSync(arr.subarray(nwritten));
    }
}
async function* iterateReader(r, options) {
    const bufSize = options?.bufSize ?? DEFAULT_BUFFER_SIZE;
    const b = new Uint8Array(bufSize);
    while(true){
        const result = await r.read(b);
        if (result === null) {
            break;
        }
        yield b.subarray(0, result);
    }
}
"\r".charCodeAt(0);
"\n".charCodeAt(0);
async function execProcess(options, stdin, mergeOutput, stderrFilter) {
    try {
        const process = Deno.run({
            ...options,
            stdin: stdin !== undefined ? "piped" : options.stdin,
            stdout: typeof options.stdout === "number" ? options.stdout : "piped",
            stderr: typeof options.stderr === "number" ? options.stderr : "piped"
        });
        if (stdin !== undefined) {
            if (!process.stdin) {
                throw new Error("Process stdin not available");
            }
            const buffer = new TextEncoder().encode(stdin);
            let offset = 0;
            while(offset < buffer.length){
                const end = Math.min(offset + 4096, buffer.length);
                const window = buffer.subarray(offset, end);
                const written = await process.stdin.write(window);
                offset += written;
            }
            process.stdin.close();
        }
        let stdoutText = "";
        let stderrText = "";
        if (mergeOutput) {
            const multiplexIterator = new MuxAsyncIterator();
            const addStream = (stream, filter1)=>{
                if (stream !== null) {
                    const streamIter = filter1 ? filteredAsyncIterator(iterateReader(stream), filter1) : iterateReader(stream);
                    multiplexIterator.add(streamIter);
                }
            };
            addStream(process.stdout);
            addStream(process.stderr, stderrFilter);
            const allOutput = await processOutput(multiplexIterator, mergeOutput === "stderr>stdout" ? options.stdout : options.stderr);
            if (mergeOutput === "stderr>stdout") {
                stdoutText = allOutput;
            } else {
                stderrText = allOutput;
            }
            const closeStream = (stream)=>{
                if (stream) {
                    stream.close();
                }
            };
            closeStream(process.stdout);
            closeStream(process.stderr);
        } else {
            if (process.stdout !== null) {
                stdoutText = await processOutput(iterateReader(process.stdout), options.stdout);
                process.stdout.close();
            }
            if (process.stderr != null) {
                const iterator = stderrFilter ? filteredAsyncIterator(iterateReader(process.stderr), stderrFilter) : iterateReader(process.stderr);
                stderrText = await processOutput(iterator, options.stderr);
                process.stderr.close();
            }
        }
        const status = await process.status();
        process.close();
        return {
            success: status.success,
            code: status.code,
            stdout: stdoutText,
            stderr: stderrText
        };
    } catch (e) {
        throw new Error(`Error executing '${options.cmd[0]}': ${e.message}`);
    }
}
function processSuccessResult() {
    return {
        success: true,
        code: 0
    };
}
function filteredAsyncIterator(iterator, filter2) {
    const encoder = new TextEncoder();
    const decoder = new TextDecoder();
    return pooledMap(1, iterator, (data16)=>{
        return Promise.resolve(encoder.encode(filter2(decoder.decode(data16))));
    });
}
async function processOutput(iterator, output) {
    const decoder = new TextDecoder();
    let outputText = "";
    for await (const chunk of iterator){
        if (output === "inherit" || output === undefined) {
            info(decoder.decode(chunk), {
                newline: false
            });
        }
        const text = decoder.decode(chunk);
        outputText += text;
    }
    return outputText;
}
const kSkipHidden = /[/\\][\.]/;
function removeIfExists(file) {
    if (existsSync(file)) {
        Deno.removeSync(file, {
            recursive: true
        });
    }
}
function removeIfEmptyDir(dir) {
    if (existsSync(dir)) {
        let empty1 = true;
        for (const _entry of Deno.readDirSync(dir)){
            empty1 = false;
            break;
        }
        if (empty1) {
            Deno.removeSync(dir, {
                recursive: true
            });
        }
    }
}
function isModifiedAfter(file, otherFile) {
    if (!existsSync(file)) {
        throw new Error(`${file} does not exist`);
    }
    if (!existsSync(otherFile)) {
        return true;
    }
    const fileInfo = Deno.statSync(file);
    const otherfileInfo = Deno.statSync(otherFile);
    if (fileInfo.mtime === null || otherfileInfo.mtime === null) {
        return true;
    } else {
        return fileInfo.mtime > otherfileInfo.mtime;
    }
}
function dirAndStem(file) {
    return [
        dirname2(file),
        basename2(file, extname2(file)), 
    ];
}
function expandPath(path54) {
    if (path54 === "~") {
        return getenv("HOME", "~");
    } else {
        return path54.replace(/^~\//, getenv("HOME", "~") + "/");
    }
}
function safeExistsSync(path55) {
    try {
        return existsSync(path55);
    } catch  {
        return false;
    }
}
async function which(cmd) {
    const args = Deno.build.os === "windows" ? [
        "CMD",
        "/C",
        "where",
        cmd
    ] : [
        "which",
        cmd
    ];
    const result = await execProcess({
        cmd: args,
        stderr: "piped",
        stdout: "piped"
    });
    if (result.code === 0) {
        return result.stdout?.trim();
    } else {
        return undefined;
    }
}
function resolvePathGlobs(root4, globs, exclude) {
    const includeGlobs = [];
    const excludeGlobs = [];
    const asFullGlob = (glob)=>{
        if (glob.startsWith("\\!")) {
            glob = glob.slice(1);
        }
        if (glob.endsWith("/")) {
            glob = glob + "**/*";
        } else {
            const fullPath = join3(root4, glob);
            if (existsSync(fullPath) && Deno.statSync(fullPath).isDirectory) {
                glob = glob + "/**/*";
            }
        }
        if (!glob.startsWith("/")) {
            return "**/" + glob;
        } else {
            return join3(root4, glob.slice(1));
        }
    };
    const expandGlobs = (targetGlobs)=>{
        const expanded = [];
        for (const glob of targetGlobs){
            for (const file of expandGlobSync(glob, {
                root: root4,
                exclude,
                includeDirs: true,
                extended: true,
                globstar: true
            })){
                expanded.push(file.path);
            }
        }
        return __VIRTUAL_FILE181(expanded);
    };
    for (const glob1 of globs){
        if (glob1.startsWith("!")) {
            excludeGlobs.push(asFullGlob(glob1.slice(1)));
        } else {
            includeGlobs.push(asFullGlob(glob1));
        }
    }
    const includeFiles = expandGlobs(includeGlobs);
    const excludeFiles = expandGlobs(excludeGlobs);
    return {
        include: includeFiles,
        exclude: excludeFiles
    };
}
function pathWithForwardSlashes(path56) {
    return path56.replace(/\\/g, "/");
}
function copyMinimal(srcDir, destDir, skip, filter3) {
    skip = skip || [];
    const srcFiles = [];
    for (const walk1 of walkSync(srcDir, {
        includeDirs: false,
        followSymlinks: false,
        skip
    })){
        const srcFile = walk1.path;
        if (filter3 && !filter3(srcFile)) {
            continue;
        }
        srcFiles.push(srcFile);
    }
    for (const srcFile of srcFiles){
        if (!existsSync(srcFile)) {
            continue;
        }
        const destFile = join3(destDir, relative2(srcDir, srcFile));
        copyFileIfNewer(srcFile, destFile);
    }
}
function copyFileIfNewer(srcFile, destFile) {
    ensureDirSync(dirname2(destFile));
    if (existsSync(destFile)) {
        const srcInfo = Deno.statSync(srcFile);
        const destInfo = Deno.statSync(destFile);
        if (!srcInfo.mtime || !destInfo.mtime || destInfo.mtime < srcInfo.mtime) {
            copySync(srcFile, destFile, {
                overwrite: true,
                preserveTimestamps: true
            });
        }
    } else {
        copySync(srcFile, destFile, {
            overwrite: true,
            preserveTimestamps: true
        });
    }
}
const kLocalDevelopment = "99.9.9";
const quartoConfig = {
    binPath: ()=>getenv("QUARTO_BIN_PATH")
    ,
    sharePath: ()=>getenv("QUARTO_SHARE_PATH")
    ,
    isDebug: ()=>getenv("QUARTO_DEBUG", "false") === "true"
    ,
    version: ()=>{
        const versionPath = join3(getenv("QUARTO_SHARE_PATH"), "version");
        if (existsSync(versionPath)) {
            return Deno.readTextFileSync(versionPath);
        } else {
            return kLocalDevelopment;
        }
    }
};
const kHKeyCurrentUser = "HKCU";
const kHKeyLocalMachine = "HKLM";
async function registryReadString(root5, key, value) {
    if (Array.isArray(root5)) {
        for (const r of root5){
            const val = registryReadString(r, key, value);
            if (val !== undefined) {
                return val;
            }
        }
        return undefined;
    }
    const kTypeString = "REG_SZ";
    const cmd = [
        "reg",
        "query",
        `${root5}\\${key}`,
        "/v",
        value, 
    ];
    const result = await execProcess({
        cmd,
        stdout: "piped"
    });
    if (result.success && result.stdout) {
        const typePos = result.stdout?.indexOf(kTypeString);
        if (typePos !== -1) {
            return result.stdout.substring(typePos + kTypeString.length).trim();
        }
    }
    return undefined;
}
function resourcePath(resource) {
    const sharePath = quartoConfig.sharePath();
    if (resource) {
        return join3(sharePath, resource);
    } else {
        return sharePath;
    }
}
function formatResourcePath(format5, resource) {
    return join3(resourcePath("formats"), format5, resource);
}
function binaryPath(binary1) {
    return join3(quartoConfig.binPath(), binary1);
}
function pandocBinaryPath() {
    const quartoPandoc = Deno.env.get("QUARTO_PANDOC");
    if (quartoPandoc) {
        if (!existsSync(quartoPandoc)) {
            warnOnce("Specified QUARTO_PANDOC does not exist, using built in Pandoc");
        }
        if (Deno.statSync(quartoPandoc).isFile) {
            return quartoPandoc;
        } else {
            return join3(quartoPandoc, "pandoc");
        }
    }
    return binaryPath("pandoc");
}
async function rBinaryPath(binary2) {
    const rHome = Deno.env.get("R_HOME");
    if (rHome) {
        return join3(rHome, "bin", binary2);
    }
    const path57 = await which(binary2);
    if (path57) {
        return path57;
    }
    if (Deno.build.os === "windows") {
        const version6 = await registryReadString([
            kHKeyLocalMachine,
            kHKeyCurrentUser
        ], "Software\\R-core\\R", "Current Version");
        if (version6) {
            const installPath = await registryReadString([
                kHKeyLocalMachine,
                kHKeyCurrentUser
            ], `Software\\R-core\\R\\${version6}`, "InstallPath");
            if (installPath) {
                return join3(installPath, "bin", binary2);
            }
        }
        const progFiles = Deno.env.get("programfiles");
        if (progFiles) {
            for (const entry of Deno.readDirSync(progFiles)){
                if (entry.isDirectory && entry.name === "R") {
                    for (const walk2 of walkSync(join3(progFiles, "R"))){
                        if (walk2.isDirectory && walk2.name === "bin") {
                            return join3(walk2.path, binary2);
                        }
                    }
                }
            }
        }
    }
    return binary2;
}
function projectTypeResourcePath(projectType1) {
    return resourcePath(join3("projects", projectType1));
}
const kDarkSuffix = "dark";
const kLightSuffix = "light";
function textHighlightThemePath(theme, style) {
    const names = [
        `${theme}-${style === "dark" ? kDarkSuffix : kLightSuffix}`,
        theme, 
    ];
    const themePath = names.map((name75)=>{
        return resourcePath(join3("pandoc", "highlight-styles", `${name75}.theme`));
    }).find((path58)=>existsSync(path58)
    );
    return themePath;
}
class YAMLError extends Error {
    mark;
    constructor(message = "(unknown reason)", mark = ""){
        super(`${message} ${mark}`);
        this.mark = mark;
        this.name = this.constructor.name;
    }
    toString(_compact) {
        return `${this.name}: ${this.message} ${this.mark}`;
    }
}
function isBoolean(value) {
    return typeof value === "boolean" || value instanceof Boolean;
}
function isObject1(value) {
    return value !== null && typeof value === "object";
}
function repeat(str56, count) {
    let result = "";
    for(let cycle = 0; cycle < count; cycle++){
        result += str56;
    }
    return result;
}
function isNegativeZero(i30) {
    return i30 === 0 && Number.NEGATIVE_INFINITY === 1 / i30;
}
class Mark {
    name;
    buffer;
    position;
    line;
    column;
    constructor(name76, buffer, position, line, column){
        this.name = name76;
        this.buffer = buffer;
        this.position = position;
        this.line = line;
        this.column = column;
    }
    getSnippet(indent = 4, maxLength = 75) {
        if (!this.buffer) return null;
        let head = "";
        let start = this.position;
        while(start > 0 && "\x00\r\n\x85\u2028\u2029".indexOf(this.buffer.charAt(start - 1)) === -1){
            start -= 1;
            if (this.position - start > maxLength / 2 - 1) {
                head = " ... ";
                start += 5;
                break;
            }
        }
        let tail = "";
        let end = this.position;
        while(end < this.buffer.length && "\x00\r\n\x85\u2028\u2029".indexOf(this.buffer.charAt(end)) === -1){
            end += 1;
            if (end - this.position > maxLength / 2 - 1) {
                tail = " ... ";
                end -= 5;
                break;
            }
        }
        const snippet = this.buffer.slice(start, end);
        return `${repeat(" ", indent)}${head}${snippet}${tail}\n${repeat(" ", indent + this.position - start + head.length)}^`;
    }
    toString(compact) {
        let snippet, where = "";
        if (this.name) {
            where += `in "${this.name}" `;
        }
        where += `at line ${this.line + 1}, column ${this.column + 1}`;
        if (!compact) {
            snippet = this.getSnippet();
            if (snippet) {
                where += `:\n${snippet}`;
            }
        }
        return where;
    }
}
function compileList(schema, name77, result) {
    const exclude = [];
    for (const includedSchema of schema.include){
        result = compileList(includedSchema, name77, result);
    }
    for (const currentType of schema[name77]){
        for(let previousIndex = 0; previousIndex < result.length; previousIndex++){
            const previousType = result[previousIndex];
            if (previousType.tag === currentType.tag && previousType.kind === currentType.kind) {
                exclude.push(previousIndex);
            }
        }
        result.push(currentType);
    }
    return result.filter((_type, index)=>!exclude.includes(index)
    );
}
function compileMap(...typesList) {
    const result = {
        fallback: {},
        mapping: {},
        scalar: {},
        sequence: {}
    };
    for (const types10 of typesList){
        for (const type29 of types10){
            if (type29.kind !== null) {
                result[type29.kind][type29.tag] = result["fallback"][type29.tag] = type29;
            }
        }
    }
    return result;
}
class Schema {
    static SCHEMA_DEFAULT;
    implicit;
    explicit;
    include;
    compiledImplicit;
    compiledExplicit;
    compiledTypeMap;
    constructor(definition){
        this.explicit = definition.explicit || [];
        this.implicit = definition.implicit || [];
        this.include = definition.include || [];
        for (const type30 of this.implicit){
            if (type30.loadKind && type30.loadKind !== "scalar") {
                throw new YAMLError("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
            }
        }
        this.compiledImplicit = compileList(this, "implicit", []);
        this.compiledExplicit = compileList(this, "explicit", []);
        this.compiledTypeMap = compileMap(this.compiledImplicit, this.compiledExplicit);
    }
    extend(definition) {
        return new Schema({
            implicit: [
                ...new Set([
                    ...this.implicit,
                    ...definition?.implicit ?? []
                ]), 
            ],
            explicit: [
                ...new Set([
                    ...this.explicit,
                    ...definition?.explicit ?? []
                ]), 
            ],
            include: [
                ...new Set([
                    ...this.include,
                    ...definition?.include ?? []
                ])
            ]
        });
    }
    static create() {}
}
const DEFAULT_RESOLVE = ()=>true
;
const DEFAULT_CONSTRUCT = (data17)=>data17
;
function checkTagFormat(tag) {
    return tag;
}
class Type1 {
    tag;
    kind = null;
    instanceOf;
    predicate;
    represent;
    defaultStyle;
    styleAliases;
    loadKind;
    constructor(tag, options){
        this.tag = checkTagFormat(tag);
        if (options) {
            this.kind = options.kind;
            this.resolve = options.resolve || DEFAULT_RESOLVE;
            this.construct = options.construct || DEFAULT_CONSTRUCT;
            this.instanceOf = options.instanceOf;
            this.predicate = options.predicate;
            this.represent = options.represent;
            this.defaultStyle = options.defaultStyle;
            this.styleAliases = options.styleAliases;
        }
    }
    resolve = ()=>true
    ;
    construct = (data18)=>data18
    ;
}
const BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
function resolveYamlBinary(data19) {
    if (data19 === null) return false;
    let code17;
    let bitlen = 0;
    const max = data19.length;
    const map4 = BASE64_MAP;
    for(let idx = 0; idx < max; idx++){
        code17 = map4.indexOf(data19.charAt(idx));
        if (code17 > 64) continue;
        if (code17 < 0) return false;
        bitlen += 6;
    }
    return bitlen % 8 === 0;
}
function constructYamlBinary(data20) {
    const input = data20.replace(/[\r\n=]/g, "");
    const max = input.length;
    const map5 = BASE64_MAP;
    const result = [];
    let bits = 0;
    for(let idx = 0; idx < max; idx++){
        if (idx % 4 === 0 && idx) {
            result.push(bits >> 16 & 255);
            result.push(bits >> 8 & 255);
            result.push(bits & 255);
        }
        bits = bits << 6 | map5.indexOf(input.charAt(idx));
    }
    const tailbits = max % 4 * 6;
    if (tailbits === 0) {
        result.push(bits >> 16 & 255);
        result.push(bits >> 8 & 255);
        result.push(bits & 255);
    } else if (tailbits === 18) {
        result.push(bits >> 10 & 255);
        result.push(bits >> 2 & 255);
    } else if (tailbits === 12) {
        result.push(bits >> 4 & 255);
    }
    return new Buffer(new Uint8Array(result));
}
function representYamlBinary(object) {
    const max = object.length;
    const map6 = BASE64_MAP;
    let result = "";
    let bits = 0;
    for(let idx = 0; idx < max; idx++){
        if (idx % 3 === 0 && idx) {
            result += map6[bits >> 18 & 63];
            result += map6[bits >> 12 & 63];
            result += map6[bits >> 6 & 63];
            result += map6[bits & 63];
        }
        bits = (bits << 8) + object[idx];
    }
    const tail = max % 3;
    if (tail === 0) {
        result += map6[bits >> 18 & 63];
        result += map6[bits >> 12 & 63];
        result += map6[bits >> 6 & 63];
        result += map6[bits & 63];
    } else if (tail === 2) {
        result += map6[bits >> 10 & 63];
        result += map6[bits >> 4 & 63];
        result += map6[bits << 2 & 63];
        result += map6[64];
    } else if (tail === 1) {
        result += map6[bits >> 2 & 63];
        result += map6[bits << 4 & 63];
        result += map6[64];
        result += map6[64];
    }
    return result;
}
function isBinary(obj) {
    const buf = new Buffer();
    try {
        if (0 > buf.readFromSync(obj)) return true;
        return false;
    } catch  {
        return false;
    } finally{
        buf.reset();
    }
}
const binary = new Type1("tag:yaml.org,2002:binary", {
    construct: constructYamlBinary,
    kind: "scalar",
    predicate: isBinary,
    represent: representYamlBinary,
    resolve: resolveYamlBinary
});
function resolveYamlBoolean(data21) {
    const max = data21.length;
    return max === 4 && (data21 === "true" || data21 === "True" || data21 === "TRUE") || max === 5 && (data21 === "false" || data21 === "False" || data21 === "FALSE");
}
function constructYamlBoolean(data22) {
    return data22 === "true" || data22 === "True" || data22 === "TRUE";
}
const bool = new Type1("tag:yaml.org,2002:bool", {
    construct: constructYamlBoolean,
    defaultStyle: "lowercase",
    kind: "scalar",
    predicate: isBoolean,
    represent: {
        lowercase (object) {
            return object ? "true" : "false";
        },
        uppercase (object) {
            return object ? "TRUE" : "FALSE";
        },
        camelcase (object) {
            return object ? "True" : "False";
        }
    },
    resolve: resolveYamlBoolean
});
const YAML_FLOAT_PATTERN = new RegExp("^(?:[-+]?(?:0|[1-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?" + "|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?" + "|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*" + "|[-+]?\\.(?:inf|Inf|INF)" + "|\\.(?:nan|NaN|NAN))$");
function resolveYamlFloat(data23) {
    if (!YAML_FLOAT_PATTERN.test(data23) || data23[data23.length - 1] === "_") {
        return false;
    }
    return true;
}
function constructYamlFloat(data24) {
    let value = data24.replace(/_/g, "").toLowerCase();
    const sign = value[0] === "-" ? -1 : 1;
    const digits = [];
    if ("+-".indexOf(value[0]) >= 0) {
        value = value.slice(1);
    }
    if (value === ".inf") {
        return sign === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
    }
    if (value === ".nan") {
        return NaN;
    }
    if (value.indexOf(":") >= 0) {
        value.split(":").forEach((v)=>{
            digits.unshift(parseFloat(v));
        });
        let valueNb = 0;
        let base2 = 1;
        digits.forEach((d)=>{
            valueNb += d * base2;
            base2 *= 60;
        });
        return sign * valueNb;
    }
    return sign * parseFloat(value);
}
const SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;
function representYamlFloat(object, style) {
    if (isNaN(object)) {
        switch(style){
            case "lowercase":
                return ".nan";
            case "uppercase":
                return ".NAN";
            case "camelcase":
                return ".NaN";
        }
    } else if (Number.POSITIVE_INFINITY === object) {
        switch(style){
            case "lowercase":
                return ".inf";
            case "uppercase":
                return ".INF";
            case "camelcase":
                return ".Inf";
        }
    } else if (Number.NEGATIVE_INFINITY === object) {
        switch(style){
            case "lowercase":
                return "-.inf";
            case "uppercase":
                return "-.INF";
            case "camelcase":
                return "-.Inf";
        }
    } else if (isNegativeZero(object)) {
        return "-0.0";
    }
    const res = object.toString(10);
    return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace("e", ".e") : res;
}
function isFloat(object) {
    return Object.prototype.toString.call(object) === "[object Number]" && (object % 1 !== 0 || isNegativeZero(object));
}
const __float = new Type1("tag:yaml.org,2002:float", {
    construct: constructYamlFloat,
    defaultStyle: "lowercase",
    kind: "scalar",
    predicate: isFloat,
    represent: representYamlFloat,
    resolve: resolveYamlFloat
});
function reconstructFunction(code18) {
    const func1 = new Function(`return ${code18}`)();
    if (!(func1 instanceof Function)) {
        throw new TypeError(`Expected function but got ${typeof func1}: ${code18}`);
    }
    return func1;
}
new Type1("tag:yaml.org,2002:js/function", {
    kind: "scalar",
    resolve (data25) {
        if (data25 === null) {
            return false;
        }
        try {
            reconstructFunction(`${data25}`);
            return true;
        } catch (_err) {
            return false;
        }
    },
    construct (data26) {
        return reconstructFunction(data26);
    },
    predicate (object) {
        return object instanceof Function;
    },
    represent (object) {
        return object.toString();
    }
});
function isHexCode(c) {
    return 48 <= c && c <= 57 || 65 <= c && c <= 70 || 97 <= c && c <= 102;
}
function isOctCode(c) {
    return 48 <= c && c <= 55;
}
function isDecCode(c) {
    return 48 <= c && c <= 57;
}
function resolveYamlInteger(data27) {
    const max = data27.length;
    let index = 0;
    let hasDigits = false;
    if (!max) return false;
    let ch = data27[index];
    if (ch === "-" || ch === "+") {
        ch = data27[++index];
    }
    if (ch === "0") {
        if (index + 1 === max) return true;
        ch = data27[++index];
        if (ch === "b") {
            index++;
            for(; index < max; index++){
                ch = data27[index];
                if (ch === "_") continue;
                if (ch !== "0" && ch !== "1") return false;
                hasDigits = true;
            }
            return hasDigits && ch !== "_";
        }
        if (ch === "x") {
            index++;
            for(; index < max; index++){
                ch = data27[index];
                if (ch === "_") continue;
                if (!isHexCode(data27.charCodeAt(index))) return false;
                hasDigits = true;
            }
            return hasDigits && ch !== "_";
        }
        for(; index < max; index++){
            ch = data27[index];
            if (ch === "_") continue;
            if (!isOctCode(data27.charCodeAt(index))) return false;
            hasDigits = true;
        }
        return hasDigits && ch !== "_";
    }
    if (ch === "_") return false;
    for(; index < max; index++){
        ch = data27[index];
        if (ch === "_") continue;
        if (ch === ":") break;
        if (!isDecCode(data27.charCodeAt(index))) {
            return false;
        }
        hasDigits = true;
    }
    if (!hasDigits || ch === "_") return false;
    if (ch !== ":") return true;
    return /^(:[0-5]?[0-9])+$/.test(data27.slice(index));
}
function constructYamlInteger(data28) {
    let value = data28;
    const digits = [];
    if (value.indexOf("_") !== -1) {
        value = value.replace(/_/g, "");
    }
    let sign = 1;
    let ch = value[0];
    if (ch === "-" || ch === "+") {
        if (ch === "-") sign = -1;
        value = value.slice(1);
        ch = value[0];
    }
    if (value === "0") return 0;
    if (ch === "0") {
        if (value[1] === "b") return sign * parseInt(value.slice(2), 2);
        if (value[1] === "x") return sign * parseInt(value, 16);
        return sign * parseInt(value, 8);
    }
    if (value.indexOf(":") !== -1) {
        value.split(":").forEach((v)=>{
            digits.unshift(parseInt(v, 10));
        });
        let valueInt = 0;
        let base3 = 1;
        digits.forEach((d)=>{
            valueInt += d * base3;
            base3 *= 60;
        });
        return sign * valueInt;
    }
    return sign * parseInt(value, 10);
}
function isInteger(object) {
    return Object.prototype.toString.call(object) === "[object Number]" && object % 1 === 0 && !isNegativeZero(object);
}
const __int = new Type1("tag:yaml.org,2002:int", {
    construct: constructYamlInteger,
    defaultStyle: "decimal",
    kind: "scalar",
    predicate: isInteger,
    represent: {
        binary (obj) {
            return obj >= 0 ? `0b${obj.toString(2)}` : `-0b${obj.toString(2).slice(1)}`;
        },
        octal (obj) {
            return obj >= 0 ? `0${obj.toString(8)}` : `-0${obj.toString(8).slice(1)}`;
        },
        decimal (obj) {
            return obj.toString(10);
        },
        hexadecimal (obj) {
            return obj >= 0 ? `0x${obj.toString(16).toUpperCase()}` : `-0x${obj.toString(16).toUpperCase().slice(1)}`;
        }
    },
    resolve: resolveYamlInteger,
    styleAliases: {
        binary: [
            2,
            "bin"
        ],
        decimal: [
            10,
            "dec"
        ],
        hexadecimal: [
            16,
            "hex"
        ],
        octal: [
            8,
            "oct"
        ]
    }
});
const map = new Type1("tag:yaml.org,2002:map", {
    construct (data29) {
        return data29 !== null ? data29 : {};
    },
    kind: "mapping"
});
function resolveYamlMerge(data30) {
    return data30 === "<<" || data30 === null;
}
const merge = new Type1("tag:yaml.org,2002:merge", {
    kind: "scalar",
    resolve: resolveYamlMerge
});
function resolveYamlNull(data31) {
    const max = data31.length;
    return max === 1 && data31 === "~" || max === 4 && (data31 === "null" || data31 === "Null" || data31 === "NULL");
}
function constructYamlNull() {
    return null;
}
function isNull(object) {
    return object === null;
}
const nil = new Type1("tag:yaml.org,2002:null", {
    construct: constructYamlNull,
    defaultStyle: "lowercase",
    kind: "scalar",
    predicate: isNull,
    represent: {
        canonical () {
            return "~";
        },
        lowercase () {
            return "null";
        },
        uppercase () {
            return "NULL";
        },
        camelcase () {
            return "Null";
        }
    },
    resolve: resolveYamlNull
});
const { hasOwn  } = Object;
const _toString = Object.prototype.toString;
function resolveYamlOmap(data32) {
    const objectKeys = [];
    let pairKey = "";
    let pairHasKey = false;
    for (const pair of data32){
        pairHasKey = false;
        if (_toString.call(pair) !== "[object Object]") return false;
        for(pairKey in pair){
            if (hasOwn(pair, pairKey)) {
                if (!pairHasKey) pairHasKey = true;
                else return false;
            }
        }
        if (!pairHasKey) return false;
        if (objectKeys.indexOf(pairKey) === -1) objectKeys.push(pairKey);
        else return false;
    }
    return true;
}
function constructYamlOmap(data33) {
    return data33 !== null ? data33 : [];
}
const omap = new Type1("tag:yaml.org,2002:omap", {
    construct: constructYamlOmap,
    kind: "sequence",
    resolve: resolveYamlOmap
});
const _toString1 = Object.prototype.toString;
function resolveYamlPairs(data34) {
    const result = Array.from({
        length: data34.length
    });
    for(let index = 0; index < data34.length; index++){
        const pair = data34[index];
        if (_toString1.call(pair) !== "[object Object]") return false;
        const keys2 = Object.keys(pair);
        if (keys2.length !== 1) return false;
        result[index] = [
            keys2[0],
            pair[keys2[0]]
        ];
    }
    return true;
}
function constructYamlPairs(data35) {
    if (data35 === null) return [];
    const result = Array.from({
        length: data35.length
    });
    for(let index = 0; index < data35.length; index += 1){
        const pair = data35[index];
        const keys3 = Object.keys(pair);
        result[index] = [
            keys3[0],
            pair[keys3[0]]
        ];
    }
    return result;
}
const pairs = new Type1("tag:yaml.org,2002:pairs", {
    construct: constructYamlPairs,
    kind: "sequence",
    resolve: resolveYamlPairs
});
const REGEXP = /^\/(?<regexp>[\s\S]+)\/(?<modifiers>[gismuy]*)$/;
const regexp = new Type1("tag:yaml.org,2002:js/regexp", {
    kind: "scalar",
    resolve (data36) {
        if (data36 === null || !data36.length) {
            return false;
        }
        const regexp1 = `${data36}`;
        if (regexp1.charAt(0) === "/") {
            if (!REGEXP.test(data36)) {
                return false;
            }
            const modifiers = [
                ...regexp1.match(REGEXP)?.groups?.modifiers ?? ""
            ];
            if (new Set(modifiers).size < modifiers.length) {
                return false;
            }
        }
        return true;
    },
    construct (data37) {
        const { regexp: regexp2 = `${data37}` , modifiers =""  } = `${data37}`.match(REGEXP)?.groups ?? {};
        return new RegExp(regexp2, modifiers);
    },
    predicate (object) {
        return object instanceof RegExp;
    },
    represent (object) {
        return object.toString();
    }
});
const seq = new Type1("tag:yaml.org,2002:seq", {
    construct (data38) {
        return data38 !== null ? data38 : [];
    },
    kind: "sequence"
});
const { hasOwn: hasOwn1  } = Object;
function resolveYamlSet(data39) {
    if (data39 === null) return true;
    for(const key in data39){
        if (hasOwn1(data39, key)) {
            if (data39[key] !== null) return false;
        }
    }
    return true;
}
function constructYamlSet(data40) {
    return data40 !== null ? data40 : {};
}
const set = new Type1("tag:yaml.org,2002:set", {
    construct: constructYamlSet,
    kind: "mapping",
    resolve: resolveYamlSet
});
const str = new Type1("tag:yaml.org,2002:str", {
    construct (data41) {
        return data41 !== null ? data41 : "";
    },
    kind: "scalar"
});
const YAML_DATE_REGEXP = new RegExp("^([0-9][0-9][0-9][0-9])" + "-([0-9][0-9])" + "-([0-9][0-9])$");
const YAML_TIMESTAMP_REGEXP = new RegExp("^([0-9][0-9][0-9][0-9])" + "-([0-9][0-9]?)" + "-([0-9][0-9]?)" + "(?:[Tt]|[ \\t]+)" + "([0-9][0-9]?)" + ":([0-9][0-9])" + ":([0-9][0-9])" + "(?:\\.([0-9]*))?" + "(?:[ \\t]*(Z|([-+])([0-9][0-9]?)" + "(?::([0-9][0-9]))?))?$");
function resolveYamlTimestamp(data42) {
    if (data42 === null) return false;
    if (YAML_DATE_REGEXP.exec(data42) !== null) return true;
    if (YAML_TIMESTAMP_REGEXP.exec(data42) !== null) return true;
    return false;
}
function constructYamlTimestamp(data43) {
    let match = YAML_DATE_REGEXP.exec(data43);
    if (match === null) match = YAML_TIMESTAMP_REGEXP.exec(data43);
    if (match === null) throw new Error("Date resolve error");
    const year = +match[1];
    const month = +match[2] - 1;
    const day = +match[3];
    if (!match[4]) {
        return new Date(Date.UTC(year, month, day));
    }
    const hour = +match[4];
    const minute = +match[5];
    const second = +match[6];
    let fraction = 0;
    if (match[7]) {
        let partFraction = match[7].slice(0, 3);
        while(partFraction.length < 3){
            partFraction += "0";
        }
        fraction = +partFraction;
    }
    let delta = null;
    if (match[9]) {
        const tzHour = +match[10];
        const tzMinute = +(match[11] || 0);
        delta = (tzHour * 60 + tzMinute) * 60000;
        if (match[9] === "-") delta = -delta;
    }
    const date = new Date(Date.UTC(year, month, day, hour, minute, second, fraction));
    if (delta) date.setTime(date.getTime() - delta);
    return date;
}
function representYamlTimestamp(date) {
    return date.toISOString();
}
const timestamp = new Type1("tag:yaml.org,2002:timestamp", {
    construct: constructYamlTimestamp,
    instanceOf: Date,
    kind: "scalar",
    represent: representYamlTimestamp,
    resolve: resolveYamlTimestamp
});
const undefinedType = new Type1("tag:yaml.org,2002:js/undefined", {
    kind: "scalar",
    resolve () {
        return true;
    },
    construct () {
        return undefined;
    },
    predicate (object) {
        return typeof object === "undefined";
    },
    represent () {
        return "";
    }
});
const failsafe = new Schema({
    explicit: [
        str,
        seq,
        map
    ]
});
const json = new Schema({
    implicit: [
        nil,
        bool,
        __int,
        __float
    ],
    include: [
        failsafe
    ]
});
const core = new Schema({
    include: [
        json
    ]
});
const def = new Schema({
    explicit: [
        binary,
        omap,
        pairs,
        set
    ],
    implicit: [
        timestamp,
        merge
    ],
    include: [
        core
    ]
});
new Schema({
    explicit: [
        regexp,
        undefinedType
    ],
    include: [
        def
    ]
});
class State1 {
    schema;
    constructor(schema = def){
        this.schema = schema;
    }
}
class LoaderState extends State1 {
    input;
    documents = [];
    length;
    lineIndent = 0;
    lineStart = 0;
    position = 0;
    line = 0;
    filename;
    onWarning;
    legacy;
    json;
    listener;
    implicitTypes;
    typeMap;
    version;
    checkLineBreaks;
    tagMap;
    anchorMap;
    tag;
    anchor;
    kind;
    result = "";
    constructor(input, { filename , schema , onWarning , legacy =false , json: json1 = false , listener =null  }){
        super(schema);
        this.input = input;
        this.filename = filename;
        this.onWarning = onWarning;
        this.legacy = legacy;
        this.json = json1;
        this.listener = listener;
        this.implicitTypes = this.schema.compiledImplicit;
        this.typeMap = this.schema.compiledTypeMap;
        this.length = input.length;
    }
}
const { hasOwn: hasOwn2  } = Object;
const CONTEXT_BLOCK_IN = 3;
const CONTEXT_BLOCK_OUT = 4;
const CHOMPING_STRIP = 2;
const CHOMPING_KEEP = 3;
const PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
const PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
const PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
const PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
const PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
function _class(obj) {
    return Object.prototype.toString.call(obj);
}
function isEOL(c) {
    return c === 10 || c === 13;
}
function isWhiteSpace(c) {
    return c === 9 || c === 32;
}
function isWsOrEol(c) {
    return c === 9 || c === 32 || c === 10 || c === 13;
}
function isFlowIndicator(c) {
    return c === 44 || c === 91 || c === 93 || c === 123 || c === 125;
}
function fromHexCode(c) {
    if (48 <= c && c <= 57) {
        return c - 48;
    }
    const lc = c | 32;
    if (97 <= lc && lc <= 102) {
        return lc - 97 + 10;
    }
    return -1;
}
function escapedHexLen(c) {
    if (c === 120) {
        return 2;
    }
    if (c === 117) {
        return 4;
    }
    if (c === 85) {
        return 8;
    }
    return 0;
}
function fromDecimalCode(c) {
    if (48 <= c && c <= 57) {
        return c - 48;
    }
    return -1;
}
function simpleEscapeSequence(c) {
    return c === 48 ? "\x00" : c === 97 ? "\x07" : c === 98 ? "\x08" : c === 116 ? "\x09" : c === 9 ? "\x09" : c === 110 ? "\x0A" : c === 118 ? "\x0B" : c === 102 ? "\x0C" : c === 114 ? "\x0D" : c === 101 ? "\x1B" : c === 32 ? " " : c === 34 ? "\x22" : c === 47 ? "/" : c === 92 ? "\x5C" : c === 78 ? "\x85" : c === 95 ? "\xA0" : c === 76 ? "\u2028" : c === 80 ? "\u2029" : "";
}
function charFromCodepoint(c) {
    if (c <= 65535) {
        return String.fromCharCode(c);
    }
    return String.fromCharCode((c - 65536 >> 10) + 55296, (c - 65536 & 1023) + 56320);
}
const simpleEscapeCheck = Array.from({
    length: 256
});
const simpleEscapeMap = Array.from({
    length: 256
});
for(let i102 = 0; i102 < 256; i102++){
    simpleEscapeCheck[i102] = simpleEscapeSequence(i102) ? 1 : 0;
    simpleEscapeMap[i102] = simpleEscapeSequence(i102);
}
function generateError(state2, message) {
    return new YAMLError(message, new Mark(state2.filename, state2.input, state2.position, state2.line, state2.position - state2.lineStart));
}
function throwError(state3, message) {
    throw generateError(state3, message);
}
function throwWarning(state4, message) {
    if (state4.onWarning) {
        state4.onWarning.call(null, generateError(state4, message));
    }
}
const directiveHandlers = {
    YAML (state5, _name, ...args) {
        if (state5.version !== null) {
            return throwError(state5, "duplication of %YAML directive");
        }
        if (args.length !== 1) {
            return throwError(state5, "YAML directive accepts exactly one argument");
        }
        const match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
        if (match === null) {
            return throwError(state5, "ill-formed argument of the YAML directive");
        }
        const major = parseInt(match[1], 10);
        const minor = parseInt(match[2], 10);
        if (major !== 1) {
            return throwError(state5, "unacceptable YAML version of the document");
        }
        state5.version = args[0];
        state5.checkLineBreaks = minor < 2;
        if (minor !== 1 && minor !== 2) {
            return throwWarning(state5, "unsupported YAML version of the document");
        }
    },
    TAG (state6, _name, ...args) {
        if (args.length !== 2) {
            return throwError(state6, "TAG directive accepts exactly two arguments");
        }
        const handle = args[0];
        const prefix = args[1];
        if (!PATTERN_TAG_HANDLE.test(handle)) {
            return throwError(state6, "ill-formed tag handle (first argument) of the TAG directive");
        }
        if (state6.tagMap && hasOwn2(state6.tagMap, handle)) {
            return throwError(state6, `there is a previously declared suffix for "${handle}" tag handle`);
        }
        if (!PATTERN_TAG_URI.test(prefix)) {
            return throwError(state6, "ill-formed tag prefix (second argument) of the TAG directive");
        }
        if (typeof state6.tagMap === "undefined") {
            state6.tagMap = {};
        }
        state6.tagMap[handle] = prefix;
    }
};
function captureSegment(state7, start, end, checkJson) {
    let result;
    if (start < end) {
        result = state7.input.slice(start, end);
        if (checkJson) {
            for(let position = 0, length = result.length; position < length; position++){
                const character = result.charCodeAt(position);
                if (!(character === 9 || 32 <= character && character <= 1114111)) {
                    return throwError(state7, "expected valid JSON character");
                }
            }
        } else if (PATTERN_NON_PRINTABLE.test(result)) {
            return throwError(state7, "the stream contains non-printable characters");
        }
        state7.result += result;
    }
}
function mergeMappings(state8, destination, source, overridableKeys) {
    if (!isObject1(source)) {
        return throwError(state8, "cannot merge mappings; the provided source object is unacceptable");
    }
    const keys4 = Object.keys(source);
    for(let i1 = 0, len1 = keys4.length; i1 < len1; i1++){
        const key = keys4[i1];
        if (!hasOwn2(destination, key)) {
            destination[key] = source[key];
            overridableKeys[key] = true;
        }
    }
}
function storeMappingPair(state9, result, overridableKeys, keyTag, keyNode, valueNode, startLine, startPos) {
    if (Array.isArray(keyNode)) {
        keyNode = Array.prototype.slice.call(keyNode);
        for(let index = 0, quantity = keyNode.length; index < quantity; index++){
            if (Array.isArray(keyNode[index])) {
                return throwError(state9, "nested arrays are not supported inside keys");
            }
            if (typeof keyNode === "object" && _class(keyNode[index]) === "[object Object]") {
                keyNode[index] = "[object Object]";
            }
        }
    }
    if (typeof keyNode === "object" && _class(keyNode) === "[object Object]") {
        keyNode = "[object Object]";
    }
    keyNode = String(keyNode);
    if (result === null) {
        result = {};
    }
    if (keyTag === "tag:yaml.org,2002:merge") {
        if (Array.isArray(valueNode)) {
            for(let index = 0, quantity = valueNode.length; index < quantity; index++){
                mergeMappings(state9, result, valueNode[index], overridableKeys);
            }
        } else {
            mergeMappings(state9, result, valueNode, overridableKeys);
        }
    } else {
        if (!state9.json && !hasOwn2(overridableKeys, keyNode) && hasOwn2(result, keyNode)) {
            state9.line = startLine || state9.line;
            state9.position = startPos || state9.position;
            return throwError(state9, "duplicated mapping key");
        }
        result[keyNode] = valueNode;
        delete overridableKeys[keyNode];
    }
    return result;
}
function readLineBreak(state10) {
    const ch = state10.input.charCodeAt(state10.position);
    if (ch === 10) {
        state10.position++;
    } else if (ch === 13) {
        state10.position++;
        if (state10.input.charCodeAt(state10.position) === 10) {
            state10.position++;
        }
    } else {
        return throwError(state10, "a line break is expected");
    }
    state10.line += 1;
    state10.lineStart = state10.position;
}
function skipSeparationSpace(state11, allowComments, checkIndent) {
    let lineBreaks = 0, ch = state11.input.charCodeAt(state11.position);
    while(ch !== 0){
        while(isWhiteSpace(ch)){
            ch = state11.input.charCodeAt(++state11.position);
        }
        if (allowComments && ch === 35) {
            do {
                ch = state11.input.charCodeAt(++state11.position);
            }while (ch !== 10 && ch !== 13 && ch !== 0)
        }
        if (isEOL(ch)) {
            readLineBreak(state11);
            ch = state11.input.charCodeAt(state11.position);
            lineBreaks++;
            state11.lineIndent = 0;
            while(ch === 32){
                state11.lineIndent++;
                ch = state11.input.charCodeAt(++state11.position);
            }
        } else {
            break;
        }
    }
    if (checkIndent !== -1 && lineBreaks !== 0 && state11.lineIndent < checkIndent) {
        throwWarning(state11, "deficient indentation");
    }
    return lineBreaks;
}
function testDocumentSeparator(state12) {
    let _position = state12.position;
    let ch = state12.input.charCodeAt(_position);
    if ((ch === 45 || ch === 46) && ch === state12.input.charCodeAt(_position + 1) && ch === state12.input.charCodeAt(_position + 2)) {
        _position += 3;
        ch = state12.input.charCodeAt(_position);
        if (ch === 0 || isWsOrEol(ch)) {
            return true;
        }
    }
    return false;
}
function writeFoldedLines(state13, count) {
    if (count === 1) {
        state13.result += " ";
    } else if (count > 1) {
        state13.result += repeat("\n", count - 1);
    }
}
function readPlainScalar(state14, nodeIndent, withinFlowCollection) {
    const kind = state14.kind;
    const result = state14.result;
    let ch = state14.input.charCodeAt(state14.position);
    if (isWsOrEol(ch) || isFlowIndicator(ch) || ch === 35 || ch === 38 || ch === 42 || ch === 33 || ch === 124 || ch === 62 || ch === 39 || ch === 34 || ch === 37 || ch === 64 || ch === 96) {
        return false;
    }
    let following;
    if (ch === 63 || ch === 45) {
        following = state14.input.charCodeAt(state14.position + 1);
        if (isWsOrEol(following) || withinFlowCollection && isFlowIndicator(following)) {
            return false;
        }
    }
    state14.kind = "scalar";
    state14.result = "";
    let captureEnd, captureStart = captureEnd = state14.position;
    let hasPendingContent = false;
    let line = 0;
    while(ch !== 0){
        if (ch === 58) {
            following = state14.input.charCodeAt(state14.position + 1);
            if (isWsOrEol(following) || withinFlowCollection && isFlowIndicator(following)) {
                break;
            }
        } else if (ch === 35) {
            const preceding = state14.input.charCodeAt(state14.position - 1);
            if (isWsOrEol(preceding)) {
                break;
            }
        } else if (state14.position === state14.lineStart && testDocumentSeparator(state14) || withinFlowCollection && isFlowIndicator(ch)) {
            break;
        } else if (isEOL(ch)) {
            line = state14.line;
            const lineStart = state14.lineStart;
            const lineIndent = state14.lineIndent;
            skipSeparationSpace(state14, false, -1);
            if (state14.lineIndent >= nodeIndent) {
                hasPendingContent = true;
                ch = state14.input.charCodeAt(state14.position);
                continue;
            } else {
                state14.position = captureEnd;
                state14.line = line;
                state14.lineStart = lineStart;
                state14.lineIndent = lineIndent;
                break;
            }
        }
        if (hasPendingContent) {
            captureSegment(state14, captureStart, captureEnd, false);
            writeFoldedLines(state14, state14.line - line);
            captureStart = captureEnd = state14.position;
            hasPendingContent = false;
        }
        if (!isWhiteSpace(ch)) {
            captureEnd = state14.position + 1;
        }
        ch = state14.input.charCodeAt(++state14.position);
    }
    captureSegment(state14, captureStart, captureEnd, false);
    if (state14.result) {
        return true;
    }
    state14.kind = kind;
    state14.result = result;
    return false;
}
function readSingleQuotedScalar(state15, nodeIndent) {
    let ch, captureStart, captureEnd;
    ch = state15.input.charCodeAt(state15.position);
    if (ch !== 39) {
        return false;
    }
    state15.kind = "scalar";
    state15.result = "";
    state15.position++;
    captureStart = captureEnd = state15.position;
    while((ch = state15.input.charCodeAt(state15.position)) !== 0){
        if (ch === 39) {
            captureSegment(state15, captureStart, state15.position, true);
            ch = state15.input.charCodeAt(++state15.position);
            if (ch === 39) {
                captureStart = state15.position;
                state15.position++;
                captureEnd = state15.position;
            } else {
                return true;
            }
        } else if (isEOL(ch)) {
            captureSegment(state15, captureStart, captureEnd, true);
            writeFoldedLines(state15, skipSeparationSpace(state15, false, nodeIndent));
            captureStart = captureEnd = state15.position;
        } else if (state15.position === state15.lineStart && testDocumentSeparator(state15)) {
            return throwError(state15, "unexpected end of the document within a single quoted scalar");
        } else {
            state15.position++;
            captureEnd = state15.position;
        }
    }
    return throwError(state15, "unexpected end of the stream within a single quoted scalar");
}
function readDoubleQuotedScalar(state16, nodeIndent) {
    let ch = state16.input.charCodeAt(state16.position);
    if (ch !== 34) {
        return false;
    }
    state16.kind = "scalar";
    state16.result = "";
    state16.position++;
    let captureEnd, captureStart = captureEnd = state16.position;
    let tmp;
    while((ch = state16.input.charCodeAt(state16.position)) !== 0){
        if (ch === 34) {
            captureSegment(state16, captureStart, state16.position, true);
            state16.position++;
            return true;
        }
        if (ch === 92) {
            captureSegment(state16, captureStart, state16.position, true);
            ch = state16.input.charCodeAt(++state16.position);
            if (isEOL(ch)) {
                skipSeparationSpace(state16, false, nodeIndent);
            } else if (ch < 256 && simpleEscapeCheck[ch]) {
                state16.result += simpleEscapeMap[ch];
                state16.position++;
            } else if ((tmp = escapedHexLen(ch)) > 0) {
                let hexLength = tmp;
                let hexResult = 0;
                for(; hexLength > 0; hexLength--){
                    ch = state16.input.charCodeAt(++state16.position);
                    if ((tmp = fromHexCode(ch)) >= 0) {
                        hexResult = (hexResult << 4) + tmp;
                    } else {
                        return throwError(state16, "expected hexadecimal character");
                    }
                }
                state16.result += charFromCodepoint(hexResult);
                state16.position++;
            } else {
                return throwError(state16, "unknown escape sequence");
            }
            captureStart = captureEnd = state16.position;
        } else if (isEOL(ch)) {
            captureSegment(state16, captureStart, captureEnd, true);
            writeFoldedLines(state16, skipSeparationSpace(state16, false, nodeIndent));
            captureStart = captureEnd = state16.position;
        } else if (state16.position === state16.lineStart && testDocumentSeparator(state16)) {
            return throwError(state16, "unexpected end of the document within a double quoted scalar");
        } else {
            state16.position++;
            captureEnd = state16.position;
        }
    }
    return throwError(state16, "unexpected end of the stream within a double quoted scalar");
}
function readFlowCollection(state17, nodeIndent) {
    let ch = state17.input.charCodeAt(state17.position);
    let terminator;
    let isMapping = true;
    let result = {};
    if (ch === 91) {
        terminator = 93;
        isMapping = false;
        result = [];
    } else if (ch === 123) {
        terminator = 125;
    } else {
        return false;
    }
    if (state17.anchor !== null && typeof state17.anchor != "undefined" && typeof state17.anchorMap != "undefined") {
        state17.anchorMap[state17.anchor] = result;
    }
    ch = state17.input.charCodeAt(++state17.position);
    const tag = state17.tag, anchor = state17.anchor;
    let readNext = true;
    let valueNode, keyNode, keyTag = keyNode = valueNode = null, isExplicitPair, isPair = isExplicitPair = false;
    let following = 0, line = 0;
    const overridableKeys = {};
    while(ch !== 0){
        skipSeparationSpace(state17, true, nodeIndent);
        ch = state17.input.charCodeAt(state17.position);
        if (ch === terminator) {
            state17.position++;
            state17.tag = tag;
            state17.anchor = anchor;
            state17.kind = isMapping ? "mapping" : "sequence";
            state17.result = result;
            return true;
        }
        if (!readNext) {
            return throwError(state17, "missed comma between flow collection entries");
        }
        keyTag = keyNode = valueNode = null;
        isPair = isExplicitPair = false;
        if (ch === 63) {
            following = state17.input.charCodeAt(state17.position + 1);
            if (isWsOrEol(following)) {
                isPair = isExplicitPair = true;
                state17.position++;
                skipSeparationSpace(state17, true, nodeIndent);
            }
        }
        line = state17.line;
        composeNode(state17, nodeIndent, 1, false, true);
        keyTag = state17.tag || null;
        keyNode = state17.result;
        skipSeparationSpace(state17, true, nodeIndent);
        ch = state17.input.charCodeAt(state17.position);
        if ((isExplicitPair || state17.line === line) && ch === 58) {
            isPair = true;
            ch = state17.input.charCodeAt(++state17.position);
            skipSeparationSpace(state17, true, nodeIndent);
            composeNode(state17, nodeIndent, 1, false, true);
            valueNode = state17.result;
        }
        if (isMapping) {
            storeMappingPair(state17, result, overridableKeys, keyTag, keyNode, valueNode);
        } else if (isPair) {
            result.push(storeMappingPair(state17, null, overridableKeys, keyTag, keyNode, valueNode));
        } else {
            result.push(keyNode);
        }
        skipSeparationSpace(state17, true, nodeIndent);
        ch = state17.input.charCodeAt(state17.position);
        if (ch === 44) {
            readNext = true;
            ch = state17.input.charCodeAt(++state17.position);
        } else {
            readNext = false;
        }
    }
    return throwError(state17, "unexpected end of the stream within a flow collection");
}
function readBlockScalar(state18, nodeIndent) {
    let chomping = 1, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false;
    let ch = state18.input.charCodeAt(state18.position);
    let folding = false;
    if (ch === 124) {
        folding = false;
    } else if (ch === 62) {
        folding = true;
    } else {
        return false;
    }
    state18.kind = "scalar";
    state18.result = "";
    let tmp = 0;
    while(ch !== 0){
        ch = state18.input.charCodeAt(++state18.position);
        if (ch === 43 || ch === 45) {
            if (1 === chomping) {
                chomping = ch === 43 ? CHOMPING_KEEP : CHOMPING_STRIP;
            } else {
                return throwError(state18, "repeat of a chomping mode identifier");
            }
        } else if ((tmp = fromDecimalCode(ch)) >= 0) {
            if (tmp === 0) {
                return throwError(state18, "bad explicit indentation width of a block scalar; it cannot be less than one");
            } else if (!detectedIndent) {
                textIndent = nodeIndent + tmp - 1;
                detectedIndent = true;
            } else {
                return throwError(state18, "repeat of an indentation width identifier");
            }
        } else {
            break;
        }
    }
    if (isWhiteSpace(ch)) {
        do {
            ch = state18.input.charCodeAt(++state18.position);
        }while (isWhiteSpace(ch))
        if (ch === 35) {
            do {
                ch = state18.input.charCodeAt(++state18.position);
            }while (!isEOL(ch) && ch !== 0)
        }
    }
    while(ch !== 0){
        readLineBreak(state18);
        state18.lineIndent = 0;
        ch = state18.input.charCodeAt(state18.position);
        while((!detectedIndent || state18.lineIndent < textIndent) && ch === 32){
            state18.lineIndent++;
            ch = state18.input.charCodeAt(++state18.position);
        }
        if (!detectedIndent && state18.lineIndent > textIndent) {
            textIndent = state18.lineIndent;
        }
        if (isEOL(ch)) {
            emptyLines++;
            continue;
        }
        if (state18.lineIndent < textIndent) {
            if (chomping === 3) {
                state18.result += repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
            } else if (chomping === 1) {
                if (didReadContent) {
                    state18.result += "\n";
                }
            }
            break;
        }
        if (folding) {
            if (isWhiteSpace(ch)) {
                atMoreIndented = true;
                state18.result += repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
            } else if (atMoreIndented) {
                atMoreIndented = false;
                state18.result += repeat("\n", emptyLines + 1);
            } else if (emptyLines === 0) {
                if (didReadContent) {
                    state18.result += " ";
                }
            } else {
                state18.result += repeat("\n", emptyLines);
            }
        } else {
            state18.result += repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        }
        didReadContent = true;
        detectedIndent = true;
        emptyLines = 0;
        const captureStart = state18.position;
        while(!isEOL(ch) && ch !== 0){
            ch = state18.input.charCodeAt(++state18.position);
        }
        captureSegment(state18, captureStart, state18.position, false);
    }
    return true;
}
function readBlockSequence(state19, nodeIndent) {
    let line, following, detected = false, ch;
    const tag = state19.tag, anchor = state19.anchor, result = [];
    if (state19.anchor !== null && typeof state19.anchor !== "undefined" && typeof state19.anchorMap !== "undefined") {
        state19.anchorMap[state19.anchor] = result;
    }
    ch = state19.input.charCodeAt(state19.position);
    while(ch !== 0){
        if (ch !== 45) {
            break;
        }
        following = state19.input.charCodeAt(state19.position + 1);
        if (!isWsOrEol(following)) {
            break;
        }
        detected = true;
        state19.position++;
        if (skipSeparationSpace(state19, true, -1)) {
            if (state19.lineIndent <= nodeIndent) {
                result.push(null);
                ch = state19.input.charCodeAt(state19.position);
                continue;
            }
        }
        line = state19.line;
        composeNode(state19, nodeIndent, 3, false, true);
        result.push(state19.result);
        skipSeparationSpace(state19, true, -1);
        ch = state19.input.charCodeAt(state19.position);
        if ((state19.line === line || state19.lineIndent > nodeIndent) && ch !== 0) {
            return throwError(state19, "bad indentation of a sequence entry");
        } else if (state19.lineIndent < nodeIndent) {
            break;
        }
    }
    if (detected) {
        state19.tag = tag;
        state19.anchor = anchor;
        state19.kind = "sequence";
        state19.result = result;
        return true;
    }
    return false;
}
function readBlockMapping(state20, nodeIndent, flowIndent) {
    const tag = state20.tag, anchor = state20.anchor, result = {}, overridableKeys = {};
    let following, allowCompact = false, line, pos, keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch;
    if (state20.anchor !== null && typeof state20.anchor !== "undefined" && typeof state20.anchorMap !== "undefined") {
        state20.anchorMap[state20.anchor] = result;
    }
    ch = state20.input.charCodeAt(state20.position);
    while(ch !== 0){
        following = state20.input.charCodeAt(state20.position + 1);
        line = state20.line;
        pos = state20.position;
        if ((ch === 63 || ch === 58) && isWsOrEol(following)) {
            if (ch === 63) {
                if (atExplicitKey) {
                    storeMappingPair(state20, result, overridableKeys, keyTag, keyNode, null);
                    keyTag = keyNode = valueNode = null;
                }
                detected = true;
                atExplicitKey = true;
                allowCompact = true;
            } else if (atExplicitKey) {
                atExplicitKey = false;
                allowCompact = true;
            } else {
                return throwError(state20, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
            }
            state20.position += 1;
            ch = following;
        } else if (composeNode(state20, flowIndent, 2, false, true)) {
            if (state20.line === line) {
                ch = state20.input.charCodeAt(state20.position);
                while(isWhiteSpace(ch)){
                    ch = state20.input.charCodeAt(++state20.position);
                }
                if (ch === 58) {
                    ch = state20.input.charCodeAt(++state20.position);
                    if (!isWsOrEol(ch)) {
                        return throwError(state20, "a whitespace character is expected after the key-value separator within a block mapping");
                    }
                    if (atExplicitKey) {
                        storeMappingPair(state20, result, overridableKeys, keyTag, keyNode, null);
                        keyTag = keyNode = valueNode = null;
                    }
                    detected = true;
                    atExplicitKey = false;
                    allowCompact = false;
                    keyTag = state20.tag;
                    keyNode = state20.result;
                } else if (detected) {
                    return throwError(state20, "can not read an implicit mapping pair; a colon is missed");
                } else {
                    state20.tag = tag;
                    state20.anchor = anchor;
                    return true;
                }
            } else if (detected) {
                return throwError(state20, "can not read a block mapping entry; a multiline key may not be an implicit key");
            } else {
                state20.tag = tag;
                state20.anchor = anchor;
                return true;
            }
        } else {
            break;
        }
        if (state20.line === line || state20.lineIndent > nodeIndent) {
            if (composeNode(state20, nodeIndent, 4, true, allowCompact)) {
                if (atExplicitKey) {
                    keyNode = state20.result;
                } else {
                    valueNode = state20.result;
                }
            }
            if (!atExplicitKey) {
                storeMappingPair(state20, result, overridableKeys, keyTag, keyNode, valueNode, line, pos);
                keyTag = keyNode = valueNode = null;
            }
            skipSeparationSpace(state20, true, -1);
            ch = state20.input.charCodeAt(state20.position);
        }
        if (state20.lineIndent > nodeIndent && ch !== 0) {
            return throwError(state20, "bad indentation of a mapping entry");
        } else if (state20.lineIndent < nodeIndent) {
            break;
        }
    }
    if (atExplicitKey) {
        storeMappingPair(state20, result, overridableKeys, keyTag, keyNode, null);
    }
    if (detected) {
        state20.tag = tag;
        state20.anchor = anchor;
        state20.kind = "mapping";
        state20.result = result;
    }
    return detected;
}
function readTagProperty(state21) {
    let position, isVerbatim = false, isNamed = false, tagHandle = "", tagName, ch;
    ch = state21.input.charCodeAt(state21.position);
    if (ch !== 33) return false;
    if (state21.tag !== null) {
        return throwError(state21, "duplication of a tag property");
    }
    ch = state21.input.charCodeAt(++state21.position);
    if (ch === 60) {
        isVerbatim = true;
        ch = state21.input.charCodeAt(++state21.position);
    } else if (ch === 33) {
        isNamed = true;
        tagHandle = "!!";
        ch = state21.input.charCodeAt(++state21.position);
    } else {
        tagHandle = "!";
    }
    position = state21.position;
    if (isVerbatim) {
        do {
            ch = state21.input.charCodeAt(++state21.position);
        }while (ch !== 0 && ch !== 62)
        if (state21.position < state21.length) {
            tagName = state21.input.slice(position, state21.position);
            ch = state21.input.charCodeAt(++state21.position);
        } else {
            return throwError(state21, "unexpected end of the stream within a verbatim tag");
        }
    } else {
        while(ch !== 0 && !isWsOrEol(ch)){
            if (ch === 33) {
                if (!isNamed) {
                    tagHandle = state21.input.slice(position - 1, state21.position + 1);
                    if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
                        return throwError(state21, "named tag handle cannot contain such characters");
                    }
                    isNamed = true;
                    position = state21.position + 1;
                } else {
                    return throwError(state21, "tag suffix cannot contain exclamation marks");
                }
            }
            ch = state21.input.charCodeAt(++state21.position);
        }
        tagName = state21.input.slice(position, state21.position);
        if (PATTERN_FLOW_INDICATORS.test(tagName)) {
            return throwError(state21, "tag suffix cannot contain flow indicator characters");
        }
    }
    if (tagName && !PATTERN_TAG_URI.test(tagName)) {
        return throwError(state21, `tag name cannot contain such characters: ${tagName}`);
    }
    if (isVerbatim) {
        state21.tag = tagName;
    } else if (typeof state21.tagMap !== "undefined" && hasOwn2(state21.tagMap, tagHandle)) {
        state21.tag = state21.tagMap[tagHandle] + tagName;
    } else if (tagHandle === "!") {
        state21.tag = `!${tagName}`;
    } else if (tagHandle === "!!") {
        state21.tag = `tag:yaml.org,2002:${tagName}`;
    } else {
        return throwError(state21, `undeclared tag handle "${tagHandle}"`);
    }
    return true;
}
function readAnchorProperty(state22) {
    let ch = state22.input.charCodeAt(state22.position);
    if (ch !== 38) return false;
    if (state22.anchor !== null) {
        return throwError(state22, "duplication of an anchor property");
    }
    ch = state22.input.charCodeAt(++state22.position);
    const position = state22.position;
    while(ch !== 0 && !isWsOrEol(ch) && !isFlowIndicator(ch)){
        ch = state22.input.charCodeAt(++state22.position);
    }
    if (state22.position === position) {
        return throwError(state22, "name of an anchor node must contain at least one character");
    }
    state22.anchor = state22.input.slice(position, state22.position);
    return true;
}
function readAlias(state23) {
    let ch = state23.input.charCodeAt(state23.position);
    if (ch !== 42) return false;
    ch = state23.input.charCodeAt(++state23.position);
    const _position = state23.position;
    while(ch !== 0 && !isWsOrEol(ch) && !isFlowIndicator(ch)){
        ch = state23.input.charCodeAt(++state23.position);
    }
    if (state23.position === _position) {
        return throwError(state23, "name of an alias node must contain at least one character");
    }
    const alias = state23.input.slice(_position, state23.position);
    if (typeof state23.anchorMap !== "undefined" && !hasOwn2(state23.anchorMap, alias)) {
        return throwError(state23, `unidentified alias "${alias}"`);
    }
    if (typeof state23.anchorMap !== "undefined") {
        state23.result = state23.anchorMap[alias];
    }
    skipSeparationSpace(state23, true, -1);
    return true;
}
function composeNode(state24, parentIndent, nodeContext, allowToSeek, allowCompact) {
    let allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, type31, flowIndent, blockIndent;
    if (state24.listener && state24.listener !== null) {
        state24.listener("open", state24);
    }
    state24.tag = null;
    state24.anchor = null;
    state24.kind = null;
    state24.result = null;
    const allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;
    if (allowToSeek) {
        if (skipSeparationSpace(state24, true, -1)) {
            atNewLine = true;
            if (state24.lineIndent > parentIndent) {
                indentStatus = 1;
            } else if (state24.lineIndent === parentIndent) {
                indentStatus = 0;
            } else if (state24.lineIndent < parentIndent) {
                indentStatus = -1;
            }
        }
    }
    if (indentStatus === 1) {
        while(readTagProperty(state24) || readAnchorProperty(state24)){
            if (skipSeparationSpace(state24, true, -1)) {
                atNewLine = true;
                allowBlockCollections = allowBlockStyles;
                if (state24.lineIndent > parentIndent) {
                    indentStatus = 1;
                } else if (state24.lineIndent === parentIndent) {
                    indentStatus = 0;
                } else if (state24.lineIndent < parentIndent) {
                    indentStatus = -1;
                }
            } else {
                allowBlockCollections = false;
            }
        }
    }
    if (allowBlockCollections) {
        allowBlockCollections = atNewLine || allowCompact;
    }
    if (indentStatus === 1 || 4 === nodeContext) {
        const cond = 1 === nodeContext || 2 === nodeContext;
        flowIndent = cond ? parentIndent : parentIndent + 1;
        blockIndent = state24.position - state24.lineStart;
        if (indentStatus === 1) {
            if (allowBlockCollections && (readBlockSequence(state24, blockIndent) || readBlockMapping(state24, blockIndent, flowIndent)) || readFlowCollection(state24, flowIndent)) {
                hasContent = true;
            } else {
                if (allowBlockScalars && readBlockScalar(state24, flowIndent) || readSingleQuotedScalar(state24, flowIndent) || readDoubleQuotedScalar(state24, flowIndent)) {
                    hasContent = true;
                } else if (readAlias(state24)) {
                    hasContent = true;
                    if (state24.tag !== null || state24.anchor !== null) {
                        return throwError(state24, "alias node should not have Any properties");
                    }
                } else if (readPlainScalar(state24, flowIndent, 1 === nodeContext)) {
                    hasContent = true;
                    if (state24.tag === null) {
                        state24.tag = "?";
                    }
                }
                if (state24.anchor !== null && typeof state24.anchorMap !== "undefined") {
                    state24.anchorMap[state24.anchor] = state24.result;
                }
            }
        } else if (indentStatus === 0) {
            hasContent = allowBlockCollections && readBlockSequence(state24, blockIndent);
        }
    }
    if (state24.tag !== null && state24.tag !== "!") {
        if (state24.tag === "?") {
            for(let typeIndex = 0, typeQuantity = state24.implicitTypes.length; typeIndex < typeQuantity; typeIndex++){
                type31 = state24.implicitTypes[typeIndex];
                if (type31.resolve(state24.result)) {
                    state24.result = type31.construct(state24.result);
                    state24.tag = type31.tag;
                    if (state24.anchor !== null && typeof state24.anchorMap !== "undefined") {
                        state24.anchorMap[state24.anchor] = state24.result;
                    }
                    break;
                }
            }
        } else if (hasOwn2(state24.typeMap[state24.kind || "fallback"], state24.tag)) {
            type31 = state24.typeMap[state24.kind || "fallback"][state24.tag];
            if (state24.result !== null && type31.kind !== state24.kind) {
                return throwError(state24, `unacceptable node kind for !<${state24.tag}> tag; it should be "${type31.kind}", not "${state24.kind}"`);
            }
            if (!type31.resolve(state24.result)) {
                return throwError(state24, `cannot resolve a node with !<${state24.tag}> explicit tag`);
            } else {
                state24.result = type31.construct(state24.result);
                if (state24.anchor !== null && typeof state24.anchorMap !== "undefined") {
                    state24.anchorMap[state24.anchor] = state24.result;
                }
            }
        } else {
            return throwError(state24, `unknown tag !<${state24.tag}>`);
        }
    }
    if (state24.listener && state24.listener !== null) {
        state24.listener("close", state24);
    }
    return state24.tag !== null || state24.anchor !== null || hasContent;
}
function readDocument(state25) {
    const documentStart = state25.position;
    let position, directiveName, directiveArgs, hasDirectives = false, ch;
    state25.version = null;
    state25.checkLineBreaks = state25.legacy;
    state25.tagMap = {};
    state25.anchorMap = {};
    while((ch = state25.input.charCodeAt(state25.position)) !== 0){
        skipSeparationSpace(state25, true, -1);
        ch = state25.input.charCodeAt(state25.position);
        if (state25.lineIndent > 0 || ch !== 37) {
            break;
        }
        hasDirectives = true;
        ch = state25.input.charCodeAt(++state25.position);
        position = state25.position;
        while(ch !== 0 && !isWsOrEol(ch)){
            ch = state25.input.charCodeAt(++state25.position);
        }
        directiveName = state25.input.slice(position, state25.position);
        directiveArgs = [];
        if (directiveName.length < 1) {
            return throwError(state25, "directive name must not be less than one character in length");
        }
        while(ch !== 0){
            while(isWhiteSpace(ch)){
                ch = state25.input.charCodeAt(++state25.position);
            }
            if (ch === 35) {
                do {
                    ch = state25.input.charCodeAt(++state25.position);
                }while (ch !== 0 && !isEOL(ch))
                break;
            }
            if (isEOL(ch)) break;
            position = state25.position;
            while(ch !== 0 && !isWsOrEol(ch)){
                ch = state25.input.charCodeAt(++state25.position);
            }
            directiveArgs.push(state25.input.slice(position, state25.position));
        }
        if (ch !== 0) readLineBreak(state25);
        if (hasOwn2(directiveHandlers, directiveName)) {
            directiveHandlers[directiveName](state25, directiveName, ...directiveArgs);
        } else {
            throwWarning(state25, `unknown document directive "${directiveName}"`);
        }
    }
    skipSeparationSpace(state25, true, -1);
    if (state25.lineIndent === 0 && state25.input.charCodeAt(state25.position) === 45 && state25.input.charCodeAt(state25.position + 1) === 45 && state25.input.charCodeAt(state25.position + 2) === 45) {
        state25.position += 3;
        skipSeparationSpace(state25, true, -1);
    } else if (hasDirectives) {
        return throwError(state25, "directives end mark is expected");
    }
    composeNode(state25, state25.lineIndent - 1, 4, false, true);
    skipSeparationSpace(state25, true, -1);
    if (state25.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state25.input.slice(documentStart, state25.position))) {
        throwWarning(state25, "non-ASCII line breaks are interpreted as content");
    }
    state25.documents.push(state25.result);
    if (state25.position === state25.lineStart && testDocumentSeparator(state25)) {
        if (state25.input.charCodeAt(state25.position) === 46) {
            state25.position += 3;
            skipSeparationSpace(state25, true, -1);
        }
        return;
    }
    if (state25.position < state25.length - 1) {
        return throwError(state25, "end of the stream or a document separator is expected");
    } else {
        return;
    }
}
function loadDocuments(input, options) {
    input = String(input);
    options = options || {};
    if (input.length !== 0) {
        if (input.charCodeAt(input.length - 1) !== 10 && input.charCodeAt(input.length - 1) !== 13) {
            input += "\n";
        }
        if (input.charCodeAt(0) === 65279) {
            input = input.slice(1);
        }
    }
    const state26 = new LoaderState(input, options);
    state26.input += "\0";
    while(state26.input.charCodeAt(state26.position) === 32){
        state26.lineIndent += 1;
        state26.position += 1;
    }
    while(state26.position < state26.length - 1){
        readDocument(state26);
    }
    return state26.documents;
}
function load(input, options) {
    const documents = loadDocuments(input, options);
    if (documents.length === 0) {
        return;
    }
    if (documents.length === 1) {
        return documents[0];
    }
    throw new YAMLError("expected a single document in the stream, but found more");
}
function parse3(content, options) {
    return load(content, options);
}
const { hasOwn: hasOwn3  } = Object;
function compileStyleMap(schema, map7) {
    if (typeof map7 === "undefined" || map7 === null) return {};
    let type32;
    const result = {};
    const keys5 = Object.keys(map7);
    let tag, style;
    for(let index = 0, length = keys5.length; index < length; index += 1){
        tag = keys5[index];
        style = String(map7[tag]);
        if (tag.slice(0, 2) === "!!") {
            tag = `tag:yaml.org,2002:${tag.slice(2)}`;
        }
        type32 = schema.compiledTypeMap.fallback[tag];
        if (type32 && typeof type32.styleAliases !== "undefined" && hasOwn3(type32.styleAliases, style)) {
            style = type32.styleAliases[style];
        }
        result[tag] = style;
    }
    return result;
}
class DumperState extends State1 {
    indent;
    noArrayIndent;
    skipInvalid;
    flowLevel;
    sortKeys;
    lineWidth;
    noRefs;
    noCompatMode;
    condenseFlow;
    implicitTypes;
    explicitTypes;
    tag = null;
    result = "";
    duplicates = [];
    usedDuplicates = [];
    styleMap;
    dump;
    constructor({ schema , indent =2 , noArrayIndent =false , skipInvalid =false , flowLevel =-1 , styles =null , sortKeys =false , lineWidth =80 , noRefs =false , noCompatMode =false , condenseFlow =false  }){
        super(schema);
        this.indent = Math.max(1, indent);
        this.noArrayIndent = noArrayIndent;
        this.skipInvalid = skipInvalid;
        this.flowLevel = flowLevel;
        this.styleMap = compileStyleMap(this.schema, styles);
        this.sortKeys = sortKeys;
        this.lineWidth = lineWidth;
        this.noRefs = noRefs;
        this.noCompatMode = noCompatMode;
        this.condenseFlow = condenseFlow;
        this.implicitTypes = this.schema.compiledImplicit;
        this.explicitTypes = this.schema.compiledExplicit;
    }
}
const _toString2 = Object.prototype.toString;
const { hasOwn: hasOwn4  } = Object;
const ESCAPE_SEQUENCES = {};
ESCAPE_SEQUENCES[0] = "\\0";
ESCAPE_SEQUENCES[7] = "\\a";
ESCAPE_SEQUENCES[8] = "\\b";
ESCAPE_SEQUENCES[9] = "\\t";
ESCAPE_SEQUENCES[10] = "\\n";
ESCAPE_SEQUENCES[11] = "\\v";
ESCAPE_SEQUENCES[12] = "\\f";
ESCAPE_SEQUENCES[13] = "\\r";
ESCAPE_SEQUENCES[27] = "\\e";
ESCAPE_SEQUENCES[34] = '\\"';
ESCAPE_SEQUENCES[92] = "\\\\";
ESCAPE_SEQUENCES[133] = "\\N";
ESCAPE_SEQUENCES[160] = "\\_";
ESCAPE_SEQUENCES[8232] = "\\L";
ESCAPE_SEQUENCES[8233] = "\\P";
const DEPRECATED_BOOLEANS_SYNTAX = [
    "y",
    "Y",
    "yes",
    "Yes",
    "YES",
    "on",
    "On",
    "ON",
    "n",
    "N",
    "no",
    "No",
    "NO",
    "off",
    "Off",
    "OFF", 
];
function encodeHex(character) {
    const string10 = character.toString(16).toUpperCase();
    let handle;
    let length;
    if (character <= 255) {
        handle = "x";
        length = 2;
    } else if (character <= 65535) {
        handle = "u";
        length = 4;
    } else if (character <= 4294967295) {
        handle = "U";
        length = 8;
    } else {
        throw new YAMLError("code point within a string may not be greater than 0xFFFFFFFF");
    }
    return `\\${handle}${repeat("0", length - string10.length)}${string10}`;
}
function indentString(string11, spaces) {
    const ind = repeat(" ", spaces), length = string11.length;
    let position = 0, next = -1, result = "", line;
    while(position < length){
        next = string11.indexOf("\n", position);
        if (next === -1) {
            line = string11.slice(position);
            position = length;
        } else {
            line = string11.slice(position, next + 1);
            position = next + 1;
        }
        if (line.length && line !== "\n") result += ind;
        result += line;
    }
    return result;
}
function generateNextLine(state27, level) {
    return `\n${repeat(" ", state27.indent * level)}`;
}
function testImplicitResolving(state28, str57) {
    let type33;
    for(let index = 0, length = state28.implicitTypes.length; index < length; index += 1){
        type33 = state28.implicitTypes[index];
        if (type33.resolve(str57)) {
            return true;
        }
    }
    return false;
}
function isWhitespace(c) {
    return c === 32 || c === 9;
}
function isPrintable(c) {
    return 32 <= c && c <= 126 || 161 <= c && c <= 55295 && c !== 8232 && c !== 8233 || 57344 <= c && c <= 65533 && c !== 65279 || 65536 <= c && c <= 1114111;
}
function isPlainSafe(c) {
    return isPrintable(c) && c !== 65279 && c !== 44 && c !== 91 && c !== 93 && c !== 123 && c !== 125 && c !== 58 && c !== 35;
}
function isPlainSafeFirst(c) {
    return isPrintable(c) && c !== 65279 && !isWhitespace(c) && c !== 45 && c !== 63 && c !== 58 && c !== 44 && c !== 91 && c !== 93 && c !== 123 && c !== 125 && c !== 35 && c !== 38 && c !== 42 && c !== 33 && c !== 124 && c !== 62 && c !== 39 && c !== 34 && c !== 37 && c !== 64 && c !== 96;
}
function needIndentIndicator(string12) {
    const leadingSpaceRe = /^\n* /;
    return leadingSpaceRe.test(string12);
}
const STYLE_PLAIN = 1, STYLE_SINGLE = 2, STYLE_LITERAL = 3, STYLE_FOLDED = 4, STYLE_DOUBLE = 5;
function chooseScalarStyle(string13, singleLineOnly, indentPerLevel, lineWidth, testAmbiguousType) {
    const shouldTrackWidth = lineWidth !== -1;
    let hasLineBreak = false, hasFoldableLine = false, previousLineBreak = -1, plain = isPlainSafeFirst(string13.charCodeAt(0)) && !isWhitespace(string13.charCodeAt(string13.length - 1));
    let __char, i31;
    if (singleLineOnly) {
        for(i31 = 0; i31 < string13.length; i31++){
            __char = string13.charCodeAt(i31);
            if (!isPrintable(__char)) {
                return 5;
            }
            plain = plain && isPlainSafe(__char);
        }
    } else {
        for(i31 = 0; i31 < string13.length; i31++){
            __char = string13.charCodeAt(i31);
            if (__char === 10) {
                hasLineBreak = true;
                if (shouldTrackWidth) {
                    hasFoldableLine = hasFoldableLine || i31 - previousLineBreak - 1 > lineWidth && string13[previousLineBreak + 1] !== " ";
                    previousLineBreak = i31;
                }
            } else if (!isPrintable(__char)) {
                return 5;
            }
            plain = plain && isPlainSafe(__char);
        }
        hasFoldableLine = hasFoldableLine || shouldTrackWidth && i31 - previousLineBreak - 1 > lineWidth && string13[previousLineBreak + 1] !== " ";
    }
    if (!hasLineBreak && !hasFoldableLine) {
        return plain && !testAmbiguousType(string13) ? 1 : 2;
    }
    if (indentPerLevel > 9 && needIndentIndicator(string13)) {
        return 5;
    }
    return hasFoldableLine ? 4 : 3;
}
function foldLine(line, width) {
    if (line === "" || line[0] === " ") return line;
    const breakRe = / [^ ]/g;
    let match;
    let start = 0, end, curr = 0, next = 0;
    let result = "";
    while(match = breakRe.exec(line)){
        next = match.index;
        if (next - start > width) {
            end = curr > start ? curr : next;
            result += `\n${line.slice(start, end)}`;
            start = end + 1;
        }
        curr = next;
    }
    result += "\n";
    if (line.length - start > width && curr > start) {
        result += `${line.slice(start, curr)}\n${line.slice(curr + 1)}`;
    } else {
        result += line.slice(start);
    }
    return result.slice(1);
}
function dropEndingNewline(string14) {
    return string14[string14.length - 1] === "\n" ? string14.slice(0, -1) : string14;
}
function foldString(string15, width) {
    const lineRe = /(\n+)([^\n]*)/g;
    let result = (()=>{
        let nextLF = string15.indexOf("\n");
        nextLF = nextLF !== -1 ? nextLF : string15.length;
        lineRe.lastIndex = nextLF;
        return foldLine(string15.slice(0, nextLF), width);
    })();
    let prevMoreIndented = string15[0] === "\n" || string15[0] === " ";
    let moreIndented;
    let match;
    while(match = lineRe.exec(string15)){
        const prefix = match[1], line = match[2];
        moreIndented = line[0] === " ";
        result += prefix + (!prevMoreIndented && !moreIndented && line !== "" ? "\n" : "") + foldLine(line, width);
        prevMoreIndented = moreIndented;
    }
    return result;
}
function escapeString(string16) {
    let result = "";
    let __char, nextChar;
    let escapeSeq;
    for(let i32 = 0; i32 < string16.length; i32++){
        __char = string16.charCodeAt(i32);
        if (__char >= 55296 && __char <= 56319) {
            nextChar = string16.charCodeAt(i32 + 1);
            if (nextChar >= 56320 && nextChar <= 57343) {
                result += encodeHex((__char - 55296) * 1024 + nextChar - 56320 + 65536);
                i32++;
                continue;
            }
        }
        escapeSeq = ESCAPE_SEQUENCES[__char];
        result += !escapeSeq && isPrintable(__char) ? string16[i32] : escapeSeq || encodeHex(__char);
    }
    return result;
}
function blockHeader(string17, indentPerLevel) {
    const indentIndicator = needIndentIndicator(string17) ? String(indentPerLevel) : "";
    const clip = string17[string17.length - 1] === "\n";
    const keep = clip && (string17[string17.length - 2] === "\n" || string17 === "\n");
    const chomp = keep ? "+" : clip ? "" : "-";
    return `${indentIndicator}${chomp}\n`;
}
function writeScalar(state29, string18, level, iskey) {
    state29.dump = (()=>{
        if (string18.length === 0) {
            return "''";
        }
        if (!state29.noCompatMode && DEPRECATED_BOOLEANS_SYNTAX.indexOf(string18) !== -1) {
            return `'${string18}'`;
        }
        const indent = state29.indent * Math.max(1, level);
        const lineWidth = state29.lineWidth === -1 ? -1 : Math.max(Math.min(state29.lineWidth, 40), state29.lineWidth - indent);
        const singleLineOnly = iskey || state29.flowLevel > -1 && level >= state29.flowLevel;
        function testAmbiguity(str58) {
            return testImplicitResolving(state29, str58);
        }
        switch(chooseScalarStyle(string18, singleLineOnly, state29.indent, lineWidth, testAmbiguity)){
            case STYLE_PLAIN:
                return string18;
            case STYLE_SINGLE:
                return `'${string18.replace(/'/g, "''")}'`;
            case STYLE_LITERAL:
                return `|${blockHeader(string18, state29.indent)}${dropEndingNewline(indentString(string18, indent))}`;
            case STYLE_FOLDED:
                return `>${blockHeader(string18, state29.indent)}${dropEndingNewline(indentString(foldString(string18, lineWidth), indent))}`;
            case STYLE_DOUBLE:
                return `"${escapeString(string18)}"`;
            default:
                throw new YAMLError("impossible error: invalid scalar style");
        }
    })();
}
function writeFlowSequence(state30, level, object) {
    let _result = "";
    const _tag = state30.tag;
    for(let index = 0, length = object.length; index < length; index += 1){
        if (writeNode(state30, level, object[index], false, false)) {
            if (index !== 0) _result += `,${!state30.condenseFlow ? " " : ""}`;
            _result += state30.dump;
        }
    }
    state30.tag = _tag;
    state30.dump = `[${_result}]`;
}
function writeBlockSequence(state31, level, object, compact = false) {
    let _result = "";
    const _tag = state31.tag;
    for(let index = 0, length = object.length; index < length; index += 1){
        if (writeNode(state31, level + 1, object[index], true, true)) {
            if (!compact || index !== 0) {
                _result += generateNextLine(state31, level);
            }
            if (state31.dump && 10 === state31.dump.charCodeAt(0)) {
                _result += "-";
            } else {
                _result += "- ";
            }
            _result += state31.dump;
        }
    }
    state31.tag = _tag;
    state31.dump = _result || "[]";
}
function writeFlowMapping(state32, level, object) {
    let _result = "";
    const _tag = state32.tag, objectKeyList = Object.keys(object);
    let pairBuffer, objectKey, objectValue;
    for(let index = 0, length = objectKeyList.length; index < length; index += 1){
        pairBuffer = state32.condenseFlow ? '"' : "";
        if (index !== 0) pairBuffer += ", ";
        objectKey = objectKeyList[index];
        objectValue = object[objectKey];
        if (!writeNode(state32, level, objectKey, false, false)) {
            continue;
        }
        if (state32.dump.length > 1024) pairBuffer += "? ";
        pairBuffer += `${state32.dump}${state32.condenseFlow ? '"' : ""}:${state32.condenseFlow ? "" : " "}`;
        if (!writeNode(state32, level, objectValue, false, false)) {
            continue;
        }
        pairBuffer += state32.dump;
        _result += pairBuffer;
    }
    state32.tag = _tag;
    state32.dump = `{${_result}}`;
}
function writeBlockMapping(state33, level, object, compact = false) {
    const _tag = state33.tag, objectKeyList = Object.keys(object);
    let _result = "";
    if (state33.sortKeys === true) {
        objectKeyList.sort();
    } else if (typeof state33.sortKeys === "function") {
        objectKeyList.sort(state33.sortKeys);
    } else if (state33.sortKeys) {
        throw new YAMLError("sortKeys must be a boolean or a function");
    }
    let pairBuffer = "", objectKey, objectValue, explicitPair;
    for(let index = 0, length = objectKeyList.length; index < length; index += 1){
        pairBuffer = "";
        if (!compact || index !== 0) {
            pairBuffer += generateNextLine(state33, level);
        }
        objectKey = objectKeyList[index];
        objectValue = object[objectKey];
        if (!writeNode(state33, level + 1, objectKey, true, true, true)) {
            continue;
        }
        explicitPair = state33.tag !== null && state33.tag !== "?" || state33.dump && state33.dump.length > 1024;
        if (explicitPair) {
            if (state33.dump && 10 === state33.dump.charCodeAt(0)) {
                pairBuffer += "?";
            } else {
                pairBuffer += "? ";
            }
        }
        pairBuffer += state33.dump;
        if (explicitPair) {
            pairBuffer += generateNextLine(state33, level);
        }
        if (!writeNode(state33, level + 1, objectValue, true, explicitPair)) {
            continue;
        }
        if (state33.dump && 10 === state33.dump.charCodeAt(0)) {
            pairBuffer += ":";
        } else {
            pairBuffer += ": ";
        }
        pairBuffer += state33.dump;
        _result += pairBuffer;
    }
    state33.tag = _tag;
    state33.dump = _result || "{}";
}
function detectType(state34, object, explicit = false) {
    const typeList = explicit ? state34.explicitTypes : state34.implicitTypes;
    let type34;
    let style;
    let _result;
    for(let index = 0, length = typeList.length; index < length; index += 1){
        type34 = typeList[index];
        if ((type34.instanceOf || type34.predicate) && (!type34.instanceOf || typeof object === "object" && object instanceof type34.instanceOf) && (!type34.predicate || type34.predicate(object))) {
            state34.tag = explicit ? type34.tag : "?";
            if (type34.represent) {
                style = state34.styleMap[type34.tag] || type34.defaultStyle;
                if (_toString2.call(type34.represent) === "[object Function]") {
                    _result = type34.represent(object, style);
                } else if (hasOwn4(type34.represent, style)) {
                    _result = type34.represent[style](object, style);
                } else {
                    throw new YAMLError(`!<${type34.tag}> tag resolver accepts not "${style}" style`);
                }
                state34.dump = _result;
            }
            return true;
        }
    }
    return false;
}
function writeNode(state35, level, object, block, compact, iskey = false) {
    state35.tag = null;
    state35.dump = object;
    if (!detectType(state35, object, false)) {
        detectType(state35, object, true);
    }
    const type35 = _toString2.call(state35.dump);
    if (block) {
        block = state35.flowLevel < 0 || state35.flowLevel > level;
    }
    const objectOrArray = type35 === "[object Object]" || type35 === "[object Array]";
    let duplicateIndex = -1;
    let duplicate = false;
    if (objectOrArray) {
        duplicateIndex = state35.duplicates.indexOf(object);
        duplicate = duplicateIndex !== -1;
    }
    if (state35.tag !== null && state35.tag !== "?" || duplicate || state35.indent !== 2 && level > 0) {
        compact = false;
    }
    if (duplicate && state35.usedDuplicates[duplicateIndex]) {
        state35.dump = `*ref_${duplicateIndex}`;
    } else {
        if (objectOrArray && duplicate && !state35.usedDuplicates[duplicateIndex]) {
            state35.usedDuplicates[duplicateIndex] = true;
        }
        if (type35 === "[object Object]") {
            if (block && Object.keys(state35.dump).length !== 0) {
                writeBlockMapping(state35, level, state35.dump, compact);
                if (duplicate) {
                    state35.dump = `&ref_${duplicateIndex}${state35.dump}`;
                }
            } else {
                writeFlowMapping(state35, level, state35.dump);
                if (duplicate) {
                    state35.dump = `&ref_${duplicateIndex} ${state35.dump}`;
                }
            }
        } else if (type35 === "[object Array]") {
            const arrayLevel = state35.noArrayIndent && level > 0 ? level - 1 : level;
            if (block && state35.dump.length !== 0) {
                writeBlockSequence(state35, arrayLevel, state35.dump, compact);
                if (duplicate) {
                    state35.dump = `&ref_${duplicateIndex}${state35.dump}`;
                }
            } else {
                writeFlowSequence(state35, arrayLevel, state35.dump);
                if (duplicate) {
                    state35.dump = `&ref_${duplicateIndex} ${state35.dump}`;
                }
            }
        } else if (type35 === "[object String]") {
            if (state35.tag !== "?") {
                writeScalar(state35, state35.dump, level, iskey);
            }
        } else {
            if (state35.skipInvalid) return false;
            throw new YAMLError(`unacceptable kind of an object to dump ${type35}`);
        }
        if (state35.tag !== null && state35.tag !== "?") {
            state35.dump = `!<${state35.tag}> ${state35.dump}`;
        }
    }
    return true;
}
function inspectNode(object, objects, duplicatesIndexes) {
    if (object !== null && typeof object === "object") {
        const index = objects.indexOf(object);
        if (index !== -1) {
            if (duplicatesIndexes.indexOf(index) === -1) {
                duplicatesIndexes.push(index);
            }
        } else {
            objects.push(object);
            if (Array.isArray(object)) {
                for(let idx = 0, length = object.length; idx < length; idx += 1){
                    inspectNode(object[idx], objects, duplicatesIndexes);
                }
            } else {
                const objectKeyList = Object.keys(object);
                for(let idx = 0, length = objectKeyList.length; idx < length; idx += 1){
                    inspectNode(object[objectKeyList[idx]], objects, duplicatesIndexes);
                }
            }
        }
    }
}
function getDuplicateReferences(object, state36) {
    const objects = [], duplicatesIndexes = [];
    inspectNode(object, objects, duplicatesIndexes);
    const length = duplicatesIndexes.length;
    for(let index = 0; index < length; index += 1){
        state36.duplicates.push(objects[duplicatesIndexes[index]]);
    }
    state36.usedDuplicates = Array.from({
        length
    });
}
function dump(input, options) {
    options = options || {};
    const state37 = new DumperState(options);
    if (!state37.noRefs) getDuplicateReferences(input, state37);
    if (writeNode(state37, 0, input, true, true)) return `${state37.dump}\n`;
    return "";
}
function stringify(obj, options) {
    return dump(obj, options);
}
function readAnnotatedYamlFromMappedString(yml) {
    return readAnnotatedYamlFromString(yml.value);
}
function readAnnotatedYamlFromString(yml) {
    const stack = [];
    const results = [];
    function listener(what, state38) {
        const { result , position , kind  } = state38;
        if (what === "close") {
            const { position: openPosition  } = stack.pop();
            if (results.length > 0) {
                const last = results[results.length - 1];
                if (last.start === openPosition && last.end === position) {
                    return;
                }
            }
            const components = [];
            while(results.length > 0){
                const last = results[results.length - 1];
                if (last.end <= openPosition) {
                    break;
                }
                components.push(results.pop());
            }
            components.reverse();
            const rawRange = yml.substring(openPosition, position);
            const leftTrim = rawRange.length - rawRange.trimLeft().length;
            const rightTrim = rawRange.length - rawRange.trimRight().length;
            results.push({
                start: openPosition + leftTrim,
                end: position - rightTrim,
                result: result,
                components,
                kind
            });
        } else {
            stack.push({
                position
            });
        }
    }
    parse3(yml, {
        listener
    });
    if (results.length === 0) {
        return {
            start: 0,
            end: 0,
            result: null,
            kind: "null",
            components: []
        };
    }
    if (results.length !== 1) {
        throw new Error(`Internal Error - expected a single result, got ${results.length} instead`);
    }
    return results[0];
}
const BooleanSchema = {
    "type": "boolean",
    "description": "be a boolean value",
    "completions": [
        "true",
        "false"
    ],
    "exhaustiveCompletions": true
};
const NumberSchema = {
    "type": "number",
    "description": "be a number"
};
const IntegerSchema = {
    "type": "integer",
    "description": "be an integral number"
};
function numericSchema(obj) {
    return Object.assign({
        description: "be a number"
    }, obj);
}
const StringSchema = {
    "type": "string",
    "description": "be a string"
};
const NullSchema = {
    "type": "null",
    "description": "be the null value",
    "completions": [
        "null"
    ],
    "exhaustiveCompletions": true
};
function enumSchema(...args) {
    if (args.length === 0) {
        throw new Error("Internal Error: Empty enum schema not supported.");
    }
    return {
        "enum": args,
        "description": args.length > 1 ? `be one of: ${args.map((x)=>"'" + x + "'"
        ).join(", ")}` : `be '${args[0]}'`,
        "completions": args,
        "exhaustiveCompletions": true
    };
}
function regexSchema(arg, description7) {
    return {
        "type": "string",
        "pattern": arg,
        description: description7
    };
}
function oneOfSchema(...args) {
    return {
        "oneOf": args,
        "description": `be exactly one of: ${args.map((x)=>x.description.slice(3)
        ).join(", ")}`
    };
}
function anyOfSchema(...args) {
    return {
        "anyOf": args,
        "description": `be at least one of: ${args.map((x)=>x.description.slice(3)
        ).join(", ")}`
    };
}
function allOfSchema(...args) {
    return {
        "allOf": args,
        "description": `be all of: ${args.map((x)=>x.description.slice(3)
        ).join(", ")}`
    };
}
function objectSchema(params = {}) {
    let { properties: properties1 , patternProperties: patternProperties1 , required: required2 , additionalProperties , description: description8 , baseSchema , exhaustive , completions: completionsParam ,  } = params;
    required2 = required2 || [];
    properties1 = properties1 || {};
    patternProperties1 = patternProperties1 || {};
    const hasDescription = description8 !== undefined;
    description8 = description8 || "be an object";
    let result = undefined;
    const completions = [];
    const uniqueValues = (lst)=>{
        const obj = {};
        for (const c of lst){
            obj[c.value] = c;
        }
        return Object.getOwnPropertyNames(obj).map((k)=>obj[k]
        );
    };
    for (const k1 of Object.getOwnPropertyNames(completionsParam || properties1)){
        const valueS = properties1[k1];
        completions.push({
            type: "key",
            display: k1,
            value: `${k1}: `,
            description: completionsParam?.[k1] || "",
            suggest_on_accept: valueS && schemaExhaustiveCompletions(valueS)
        });
    }
    if (baseSchema) {
        if (baseSchema.type !== "object") {
            throw new Error("Internal Error: can only extend other object Schema");
        }
        result = Object.assign({}, baseSchema);
        if (result.$id) {
            delete result.$id;
        }
        if (exhaustive && baseSchema.exhaustiveCompletions) {
            result.exhaustiveCompletions = true;
        }
        if (hasDescription) {
            result.description = description8;
        }
        result.properties = Object.assign({}, result.properties, properties1);
        result.patternProperties = Object.assign({}, result.patternProperties, patternProperties1);
        if (required2) {
            result.required = (result.required ?? []).slice();
            result.required.push(...required2);
        }
        if (result.completions && result.completions.length || completions.length) {
            result.completions = (result.completions || []).slice();
            result.completions.push(...completions);
            result.completions = uniqueValues(result.completions);
        }
        if (additionalProperties !== undefined) {
            if (result.additionalProperties === false) {
                throw new Error("Internal Error: don't know how to subclass object schema with additionalProperties === false");
            }
            if (result.additionalProperties) {
                result.additionalProperties = allOfSchema(result.additionalProperties, additionalProperties);
            } else {
                result.additionalProperties = additionalProperties;
            }
        }
    } else {
        result = {
            "type": "object",
            description: description8
        };
        if (exhaustive) {
            result.exhaustiveCompletions = true;
        }
        if (properties1) {
            result.properties = properties1;
        }
        if (patternProperties1) {
            result.patternProperties = patternProperties1;
        }
        if (required2 && required2.length > 0) {
            result.required = required2;
        }
        if (completions.length) {
            result.completions = completions;
        }
        if (additionalProperties !== undefined) {
            result.additionalProperties = additionalProperties;
        }
    }
    return result;
}
function arraySchema(items1) {
    if (items1) {
        return {
            "type": "array",
            "description": `be an array of values, where each element should ` + items1.description,
            items: items1
        };
    } else {
        return {
            "type": "array",
            "description": `be an array of values`
        };
    }
}
function documentSchema(schema, doc) {
    const result = Object.assign({}, schema);
    result.documentation = doc;
    return result;
}
function describeSchema(schema, description9) {
    const result = Object.assign({}, schema);
    result.description = `be ${description9}`;
    return result;
}
function completeSchema(schema, ...completions) {
    const result = Object.assign({}, schema);
    const prevCompletions = (schema.completions ?? []).slice();
    prevCompletions.push(...completions);
    result.completions = prevCompletions;
    return result;
}
function completeSchemaOverwrite(schema, ...completions) {
    const result = Object.assign({}, schema);
    result.completions = completions;
    return result;
}
function idSchema(schema, id1) {
    const result = Object.assign({}, schema);
    result["$id"] = id1;
    return result;
}
function refSchema($ref, description10) {
    return {
        $ref,
        description: description10
    };
}
function valueSchema(val) {
    return {
        "enum": [
            val
        ]
    };
}
function setBaseSchemaProperties(yaml, schema) {
    if (yaml.additionalCompletions) schema = completeSchema(schema, yaml.additionalCompletions);
    if (yaml.completions) schema = completeSchemaOverwrite(schema, yaml.completions);
    if (yaml.id) schema = idSchema(schema, yaml.id);
    if (yaml.hidden === false) {
        schema = completeSchemaOverwrite(schema);
    }
    if (yaml.description) {
        if (typeof yaml.description === "string") {
            schema = documentSchema(schema, yaml.description);
        } else if (typeof yaml.description === "object") {
            schema = documentSchema(schema, yaml.description.short);
        }
    }
    return schema;
}
function convertFromNull(yaml, _dict) {
    return setBaseSchemaProperties(yaml, NullSchema);
}
function convertFromString(yaml, _dict) {
    return setBaseSchemaProperties(yaml, StringSchema);
}
function convertFromPath(yaml, _dict) {
    return setBaseSchemaProperties(yaml, StringSchema);
}
function convertFromNumber(yaml, _dict) {
    return setBaseSchemaProperties(yaml, NumberSchema);
}
function convertFromBoolean(yaml, _dict) {
    return setBaseSchemaProperties(yaml, BooleanSchema);
}
function convertFromRef(yaml, _dict) {
    return refSchema(yaml.ref, yaml.description || "");
}
function convertFromMaybeArrayOf(yaml, dict) {
    const schema = convertFromYaml(yaml.maybeArrayOf, dict);
    return oneOfSchema(schema, arraySchema(schema));
}
function convertFromArrayOf(yaml, dict) {
    const schema = yaml.arrayOf;
    if (schema.schema) {
        let result = arraySchema(convertFromYaml(schema.schema, dict));
        return setBaseSchemaProperties(schema, result);
    } else {
        return arraySchema(convertFromYaml(schema, dict));
    }
}
function convertFromOneOf(yaml, dict) {
    const schema = yaml.oneOf;
    if (schema.schemas) {
        let inner = schema.schemas.map((x)=>convertFromYaml(x, dict)
        );
        let result = oneOfSchema(...inner);
        return setBaseSchemaProperties(schema, result);
    } else {
        return oneOfSchema(...schema.map((x)=>convertFromYaml(x, dict)
        ));
    }
}
function convertFromAnyOf(yaml, dict) {
    const schema = yaml.anyOf;
    if (schema.schemas) {
        let result = anyOfSchema(...schema.schemas.map((x)=>convertFromYaml(x, dict)
        ));
        return setBaseSchemaProperties(schema, result);
    } else {
        return anyOfSchema(...schema.map((x)=>convertFromYaml(x, dict)
        ));
    }
}
function convertFromEnum(yaml, _dict) {
    const schema = yaml["enum"];
    if (schema.hasOwnProperty("values")) {
        let result = enumSchema(...schema.values);
        return setBaseSchemaProperties(schema, result);
    } else {
        return enumSchema(...schema);
    }
}
function convertFromObject(yaml, dict) {
    const schema = yaml["object"];
    const params = {};
    if (schema.properties) {
        params.properties = Object.fromEntries(Object.entries(schema.properties).map(([key, value])=>[
                key,
                convertFromYaml(value, dict)
            ]
        ));
    }
    if (schema.patternProperties) {
        params.patternProperties = Object.fromEntries(Object.entries(schema.properties).map(([key, value])=>[
                key,
                convertFromYaml(value, dict)
            ]
        ));
    }
    if (schema.additionalProperties !== undefined) {
        if (schema.additionalProperties === false) {
            params.additionalProperties = false;
        } else {
            params.additionalProperties = convertFromYaml(schema.additionalProperties, dict);
        }
    }
    if (schema["super"]) {
        params.baseSchema = convertFromYaml(schema["super"], dict);
    }
    if (schema["required"] === "all") {
        params.required = Object.keys(schema.properties || {});
    } else if (schema["required"]) {
        params.required = schema["required"];
    }
    if (schema["completions"]) {
        params.completions = schema["completions"];
    }
    return setBaseSchemaProperties(schema, objectSchema(params));
}
function lookup(yaml, dict) {
    if (dict[yaml.resolveRef] === undefined) {
        throw new Error(`lookup of key ${yaml.resolveRef} failed`);
    }
    return dict[yaml.resolveRef];
}
function convertFromYaml(yaml, dict) {
    dict = dict ?? {};
    const literalValues = [
        [
            "object",
            objectSchema()
        ],
        [
            "path",
            StringSchema
        ],
        [
            "string",
            StringSchema
        ],
        [
            "number",
            NumberSchema
        ],
        [
            "boolean",
            BooleanSchema
        ],
        [
            null,
            NullSchema
        ], 
    ];
    for (const [testVal, result] of literalValues){
        if (yaml === testVal) {
            return result;
        }
    }
    if (typeof yaml !== "object") {
        return valueSchema(yaml);
    }
    const schemaObjectKeyFunctions = [
        {
            key: "anyOf",
            value: convertFromAnyOf
        },
        {
            key: "boolean",
            value: convertFromBoolean
        },
        {
            key: "arrayOf",
            value: convertFromArrayOf
        },
        {
            key: "enum",
            value: convertFromEnum
        },
        {
            key: "maybeArrayOf",
            value: convertFromMaybeArrayOf
        },
        {
            key: "null",
            value: convertFromNull
        },
        {
            key: "number",
            value: convertFromNumber
        },
        {
            key: "object",
            value: convertFromObject
        },
        {
            key: "oneOf",
            value: convertFromOneOf
        },
        {
            key: "path",
            value: convertFromPath
        },
        {
            key: "ref",
            value: convertFromRef
        },
        {
            key: "resolveRef",
            value: lookup
        },
        {
            key: "string",
            value: convertFromString
        }, 
    ];
    for (const { key: objectKey , value: fun  } of schemaObjectKeyFunctions){
        try {
            if (yaml[objectKey] !== undefined) {
                return fun(yaml, dict);
            }
        } catch (e) {
            error({
                yaml
            });
            throw e;
        }
    }
    error(JSON.stringify(yaml, null, 2));
    throw new Error("Internal Error: Cannot convert object; this should have failed validation.");
}
var fastDeepEqual = function equal(a, b) {
    if (a === b) return true;
    if (a && b && typeof a == "object" && typeof b == "object") {
        if (a.constructor !== b.constructor) return false;
        var length, i33, keys6;
        if (Array.isArray(a)) {
            length = a.length;
            if (length != b.length) return false;
            for(i33 = length; (i33--) !== 0;)if (!equal(a[i33], b[i33])) return false;
            return true;
        }
        if (a.constructor === RegExp) return a.source === b.source && a.flags === b.flags;
        if (a.valueOf !== Object.prototype.valueOf) return a.valueOf() === b.valueOf();
        if (a.toString !== Object.prototype.toString) return a.toString() === b.toString();
        keys6 = Object.keys(a);
        length = keys6.length;
        if (length !== Object.keys(b).length) return false;
        for(i33 = length; (i33--) !== 0;)if (!Object.prototype.hasOwnProperty.call(b, keys6[i33])) return false;
        for(i33 = length; (i33--) !== 0;){
            var key = keys6[i33];
            if (!equal(a[key], b[key])) return false;
        }
        return true;
    }
    return a !== a && b !== b;
};
function createCommonjsModule3(fn, basedir, module) {
    return module = {
        path: basedir,
        exports: {},
        require: function(path59, base4) {
            return commonjsRequire(path59, base4 === void 0 || base4 === null ? module.path : base4);
        }
    }, fn(module, module.exports), module.exports;
}
function commonjsRequire() {
    throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs");
}
var jsonSchemaTraverse = createCommonjsModule3(function(module) {
    var traverse = module.exports = function(schema, opts, cb) {
        if (typeof opts == "function") {
            cb = opts;
            opts = {};
        }
        cb = opts.cb || cb;
        var pre = typeof cb == "function" ? cb : cb.pre || function() {};
        var post = cb.post || function() {};
        _traverse(opts, pre, post, schema, "", schema);
    };
    traverse.keywords = {
        additionalItems: true,
        items: true,
        contains: true,
        additionalProperties: true,
        propertyNames: true,
        not: true,
        if: true,
        then: true,
        else: true
    };
    traverse.arrayKeywords = {
        items: true,
        allOf: true,
        anyOf: true,
        oneOf: true
    };
    traverse.propsKeywords = {
        $defs: true,
        definitions: true,
        properties: true,
        patternProperties: true,
        dependencies: true
    };
    traverse.skipKeywords = {
        default: true,
        enum: true,
        const: true,
        required: true,
        maximum: true,
        minimum: true,
        exclusiveMaximum: true,
        exclusiveMinimum: true,
        multipleOf: true,
        maxLength: true,
        minLength: true,
        pattern: true,
        format: true,
        maxItems: true,
        minItems: true,
        uniqueItems: true,
        maxProperties: true,
        minProperties: true
    };
    function _traverse(opts, pre, post, schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
        if (schema && typeof schema == "object" && !Array.isArray(schema)) {
            pre(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
            for(var key in schema){
                var sch = schema[key];
                if (Array.isArray(sch)) {
                    if (key in traverse.arrayKeywords) {
                        for(var i34 = 0; i34 < sch.length; i34++)_traverse(opts, pre, post, sch[i34], jsonPtr + "/" + key + "/" + i34, rootSchema, jsonPtr, key, schema, i34);
                    }
                } else if (key in traverse.propsKeywords) {
                    if (sch && typeof sch == "object") {
                        for(var prop in sch)_traverse(opts, pre, post, sch[prop], jsonPtr + "/" + key + "/" + escapeJsonPtr(prop), rootSchema, jsonPtr, key, schema, prop);
                    }
                } else if (key in traverse.keywords || opts.allKeys && !(key in traverse.skipKeywords)) {
                    _traverse(opts, pre, post, sch, jsonPtr + "/" + key, rootSchema, jsonPtr, key, schema);
                }
            }
            post(schema, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex);
        }
    }
    function escapeJsonPtr(str59) {
        return str59.replace(/~/g, "~0").replace(/\//g, "~1");
    }
});
jsonSchemaTraverse.arrayKeywords;
jsonSchemaTraverse.keywords;
jsonSchemaTraverse.propsKeywords;
jsonSchemaTraverse.skipKeywords;
var commonjsGlobal1 = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
function createCommonjsModule4(fn, basedir, module) {
    return module = {
        path: basedir,
        exports: {},
        require: function(path60, base5) {
            return commonjsRequire1(path60, base5 === void 0 || base5 === null ? module.path : base5);
        }
    }, fn(module, module.exports), module.exports;
}
function commonjsRequire1() {
    throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs");
}
var uri_all = createCommonjsModule4(function(module, exports) {
    (function(global2, factory3) {
        factory3(exports);
    })(commonjsGlobal1, function(exports2) {
        function merge1() {
            for(var _len = arguments.length, sets = Array(_len), _key = 0; _key < _len; _key++){
                sets[_key] = arguments[_key];
            }
            if (sets.length > 1) {
                sets[0] = sets[0].slice(0, -1);
                var xl = sets.length - 1;
                for(var x = 1; x < xl; ++x){
                    sets[x] = sets[x].slice(1, -1);
                }
                sets[xl] = sets[xl].slice(1);
                return sets.join("");
            } else {
                return sets[0];
            }
        }
        function subexp(str60) {
            return "(?:" + str60 + ")";
        }
        function typeOf(o) {
            return o === void 0 ? "undefined" : o === null ? "null" : Object.prototype.toString.call(o).split(" ").pop().split("]").shift().toLowerCase();
        }
        function toUpperCase(str61) {
            return str61.toUpperCase();
        }
        function toArray(obj) {
            return obj !== void 0 && obj !== null ? obj instanceof Array ? obj : typeof obj.length !== "number" || obj.split || obj.setInterval || obj.call ? [
                obj
            ] : Array.prototype.slice.call(obj) : [];
        }
        function assign(target, source) {
            var obj = target;
            if (source) {
                for(var key in source){
                    obj[key] = source[key];
                }
            }
            return obj;
        }
        function buildExps(isIRI) {
            var ALPHA$$ = "[A-Za-z]", DIGIT$$ = "[0-9]", HEXDIG$$2 = merge1(DIGIT$$, "[A-Fa-f]"), PCT_ENCODED$2 = subexp(subexp("%[EFef]" + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$2 + "%" + HEXDIG$$2 + HEXDIG$$2) + "|" + subexp("%" + HEXDIG$$2 + HEXDIG$$2)), GEN_DELIMS$$ = "[\\:\\/\\?\\#\\[\\]\\@]", SUB_DELIMS$$ = "[\\!\\$\\&\\'\\(\\)\\*\\+\\,\\;\\=]", RESERVED$$ = merge1(GEN_DELIMS$$, SUB_DELIMS$$), UCSCHAR$$ = isIRI ? "[\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]" : "[]", IPRIVATE$$ = isIRI ? "[\\uE000-\\uF8FF]" : "[]", UNRESERVED$$2 = merge1(ALPHA$$, DIGIT$$, "[\\-\\.\\_\\~]", UCSCHAR$$), SCHEME$ = subexp(ALPHA$$ + merge1(ALPHA$$, DIGIT$$, "[\\+\\-\\.]") + "*"), USERINFO$ = subexp(subexp(PCT_ENCODED$2 + "|" + merge1(UNRESERVED$$2, SUB_DELIMS$$, "[\\:]")) + "*"), DEC_OCTET_RELAXED$ = subexp(subexp("25[0-5]") + "|" + subexp("2[0-4]" + DIGIT$$) + "|" + subexp("1" + DIGIT$$ + DIGIT$$) + "|" + subexp("0?[1-9]" + DIGIT$$) + "|0?0?" + DIGIT$$), IPV4ADDRESS$ = subexp(DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$ + "\\." + DEC_OCTET_RELAXED$), H16$ = subexp(HEXDIG$$2 + "{1,4}"), LS32$ = subexp(subexp(H16$ + "\\:" + H16$) + "|" + IPV4ADDRESS$), IPV6ADDRESS1$ = subexp(subexp(H16$ + "\\:") + "{6}" + LS32$), IPV6ADDRESS2$ = subexp("\\:\\:" + subexp(H16$ + "\\:") + "{5}" + LS32$), IPV6ADDRESS3$ = subexp(subexp(H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{4}" + LS32$), IPV6ADDRESS4$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,1}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{3}" + LS32$), IPV6ADDRESS5$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,2}" + H16$) + "?\\:\\:" + subexp(H16$ + "\\:") + "{2}" + LS32$), IPV6ADDRESS6$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,3}" + H16$) + "?\\:\\:" + H16$ + "\\:" + LS32$), IPV6ADDRESS7$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,4}" + H16$) + "?\\:\\:" + LS32$), IPV6ADDRESS8$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,5}" + H16$) + "?\\:\\:" + H16$), IPV6ADDRESS9$ = subexp(subexp(subexp(H16$ + "\\:") + "{0,6}" + H16$) + "?\\:\\:"), IPV6ADDRESS$ = subexp([
                IPV6ADDRESS1$,
                IPV6ADDRESS2$,
                IPV6ADDRESS3$,
                IPV6ADDRESS4$,
                IPV6ADDRESS5$,
                IPV6ADDRESS6$,
                IPV6ADDRESS7$,
                IPV6ADDRESS8$,
                IPV6ADDRESS9$
            ].join("|")), ZONEID$ = subexp(subexp(UNRESERVED$$2 + "|" + PCT_ENCODED$2) + "+"), IPVFUTURE$ = subexp("[vV]" + HEXDIG$$2 + "+\\." + merge1(UNRESERVED$$2, SUB_DELIMS$$, "[\\:]") + "+"), REG_NAME$ = subexp(subexp(PCT_ENCODED$2 + "|" + merge1(UNRESERVED$$2, SUB_DELIMS$$)) + "*"), PCHAR$ = subexp(PCT_ENCODED$2 + "|" + merge1(UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@]")), SEGMENT_NZ_NC$ = subexp(subexp(PCT_ENCODED$2 + "|" + merge1(UNRESERVED$$2, SUB_DELIMS$$, "[\\@]")) + "+"), QUERY$ = subexp(subexp(PCHAR$ + "|" + merge1("[\\/\\?]", IPRIVATE$$)) + "*");
            return {
                NOT_SCHEME: new RegExp(merge1("[^]", ALPHA$$, DIGIT$$, "[\\+\\-\\.]"), "g"),
                NOT_USERINFO: new RegExp(merge1("[^\\%\\:]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
                NOT_HOST: new RegExp(merge1("[^\\%\\[\\]\\:]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
                NOT_PATH: new RegExp(merge1("[^\\%\\/\\:\\@]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
                NOT_PATH_NOSCHEME: new RegExp(merge1("[^\\%\\/\\@]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
                NOT_QUERY: new RegExp(merge1("[^\\%]", UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@\\/\\?]", IPRIVATE$$), "g"),
                NOT_FRAGMENT: new RegExp(merge1("[^\\%]", UNRESERVED$$2, SUB_DELIMS$$, "[\\:\\@\\/\\?]"), "g"),
                ESCAPE: new RegExp(merge1("[^]", UNRESERVED$$2, SUB_DELIMS$$), "g"),
                UNRESERVED: new RegExp(UNRESERVED$$2, "g"),
                OTHER_CHARS: new RegExp(merge1("[^\\%]", UNRESERVED$$2, RESERVED$$), "g"),
                PCT_ENCODED: new RegExp(PCT_ENCODED$2, "g"),
                IPV4ADDRESS: new RegExp("^(" + IPV4ADDRESS$ + ")$"),
                IPV6ADDRESS: new RegExp("^\\[?(" + IPV6ADDRESS$ + ")" + subexp(subexp("\\%25|\\%(?!" + HEXDIG$$2 + "{2})") + "(" + ZONEID$ + ")") + "?\\]?$")
            };
        }
        var URI_PROTOCOL = buildExps(false);
        var IRI_PROTOCOL = buildExps(true);
        var slicedToArray = function() {
            function sliceIterator(arr, i35) {
                var _arr = [];
                var _n = true;
                var _d = false;
                var _e = void 0;
                try {
                    for(var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true){
                        _arr.push(_s.value);
                        if (i35 && _arr.length === i35) break;
                    }
                } catch (err) {
                    _d = true;
                    _e = err;
                } finally{
                    try {
                        if (!_n && _i["return"]) _i["return"]();
                    } finally{
                        if (_d) throw _e;
                    }
                }
                return _arr;
            }
            return function(arr, i36) {
                if (Array.isArray(arr)) {
                    return arr;
                } else if (Symbol.iterator in Object(arr)) {
                    return sliceIterator(arr, i36);
                } else {
                    throw new TypeError("Invalid attempt to destructure non-iterable instance");
                }
            };
        }();
        var toConsumableArray = function(arr) {
            if (Array.isArray(arr)) {
                for(var i37 = 0, arr2 = Array(arr.length); i37 < arr.length; i37++)arr2[i37] = arr[i37];
                return arr2;
            } else {
                return Array.from(arr);
            }
        };
        var maxInt = 2147483647;
        var base6 = 36;
        var tMin = 1;
        var tMax = 26;
        var skew = 38;
        var damp = 700;
        var initialBias = 72;
        var initialN = 128;
        var delimiter3 = "-";
        var regexPunycode = /^xn--/;
        var regexNonASCII = /[^\0-\x7E]/;
        var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g;
        var errors5 = {
            overflow: "Overflow: input needs wider integers to process",
            "not-basic": "Illegal input >= 0x80 (not a basic code point)",
            "invalid-input": "Invalid input"
        };
        var baseMinusTMin = base6 - tMin;
        var floor = Math.floor;
        var stringFromCharCode = String.fromCharCode;
        function error$1(type36) {
            throw new RangeError(errors5[type36]);
        }
        function map8(array, fn) {
            var result = [];
            var length = array.length;
            while(length--){
                result[length] = fn(array[length]);
            }
            return result;
        }
        function mapDomain(string19, fn) {
            var parts = string19.split("@");
            var result = "";
            if (parts.length > 1) {
                result = parts[0] + "@";
                string19 = parts[1];
            }
            string19 = string19.replace(regexSeparators, ".");
            var labels = string19.split(".");
            var encoded = map8(labels, fn).join(".");
            return result + encoded;
        }
        function ucs2decode(string20) {
            var output = [];
            var counter = 0;
            var length = string20.length;
            while(counter < length){
                var value = string20.charCodeAt(counter++);
                if (value >= 55296 && value <= 56319 && counter < length) {
                    var extra = string20.charCodeAt(counter++);
                    if ((extra & 64512) == 56320) {
                        output.push(((value & 1023) << 10) + (extra & 1023) + 65536);
                    } else {
                        output.push(value);
                        counter--;
                    }
                } else {
                    output.push(value);
                }
            }
            return output;
        }
        var ucs2encode = function ucs2encode2(array) {
            return String.fromCodePoint.apply(String, toConsumableArray(array));
        };
        var basicToDigit = function basicToDigit2(codePoint) {
            if (codePoint - 48 < 10) {
                return codePoint - 22;
            }
            if (codePoint - 65 < 26) {
                return codePoint - 65;
            }
            if (codePoint - 97 < 26) {
                return codePoint - 97;
            }
            return base6;
        };
        var digitToBasic = function digitToBasic2(digit, flag) {
            return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
        };
        var adapt = function adapt2(delta, numPoints, firstTime) {
            var k = 0;
            delta = firstTime ? floor(delta / damp) : delta >> 1;
            delta += floor(delta / numPoints);
            for(; delta > baseMinusTMin * tMax >> 1; k += base6){
                delta = floor(delta / baseMinusTMin);
            }
            return floor(k + (baseMinusTMin + 1) * delta / (delta + skew));
        };
        var decode1 = function decode2(input) {
            var output = [];
            var inputLength = input.length;
            var i38 = 0;
            var n4 = initialN;
            var bias = initialBias;
            var basic = input.lastIndexOf(delimiter3);
            if (basic < 0) {
                basic = 0;
            }
            for(var j = 0; j < basic; ++j){
                if (input.charCodeAt(j) >= 128) {
                    error$1("not-basic");
                }
                output.push(input.charCodeAt(j));
            }
            for(var index = basic > 0 ? basic + 1 : 0; index < inputLength;){
                var oldi = i38;
                for(var w = 1, k = base6;; k += base6){
                    if (index >= inputLength) {
                        error$1("invalid-input");
                    }
                    var digit = basicToDigit(input.charCodeAt(index++));
                    if (digit >= base6 || digit > floor((maxInt - i38) / w)) {
                        error$1("overflow");
                    }
                    i38 += digit * w;
                    var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                    if (digit < t) {
                        break;
                    }
                    var baseMinusT = base6 - t;
                    if (w > floor(maxInt / baseMinusT)) {
                        error$1("overflow");
                    }
                    w *= baseMinusT;
                }
                var out = output.length + 1;
                bias = adapt(i38 - oldi, out, oldi == 0);
                if (floor(i38 / out) > maxInt - n4) {
                    error$1("overflow");
                }
                n4 += floor(i38 / out);
                i38 %= out;
                output.splice(i38++, 0, n4);
            }
            return String.fromCodePoint.apply(String, output);
        };
        var encode1 = function encode2(input) {
            var output = [];
            input = ucs2decode(input);
            var inputLength = input.length;
            var n5 = initialN;
            var delta = 0;
            var bias = initialBias;
            var _iteratorNormalCompletion = true;
            var _didIteratorError = false;
            var _iteratorError = void 0;
            try {
                for(var _iterator = input[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true){
                    var _currentValue2 = _step.value;
                    if (_currentValue2 < 128) {
                        output.push(stringFromCharCode(_currentValue2));
                    }
                }
            } catch (err) {
                _didIteratorError = true;
                _iteratorError = err;
            } finally{
                try {
                    if (!_iteratorNormalCompletion && _iterator.return) {
                        _iterator.return();
                    }
                } finally{
                    if (_didIteratorError) {
                        throw _iteratorError;
                    }
                }
            }
            var basicLength = output.length;
            var handledCPCount = basicLength;
            if (basicLength) {
                output.push(delimiter3);
            }
            while(handledCPCount < inputLength){
                var m = maxInt;
                var _iteratorNormalCompletion2 = true;
                var _didIteratorError2 = false;
                var _iteratorError2 = void 0;
                try {
                    for(var _iterator2 = input[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true){
                        var currentValue = _step2.value;
                        if (currentValue >= n5 && currentValue < m) {
                            m = currentValue;
                        }
                    }
                } catch (err) {
                    _didIteratorError2 = true;
                    _iteratorError2 = err;
                } finally{
                    try {
                        if (!_iteratorNormalCompletion2 && _iterator2.return) {
                            _iterator2.return();
                        }
                    } finally{
                        if (_didIteratorError2) {
                            throw _iteratorError2;
                        }
                    }
                }
                var handledCPCountPlusOne = handledCPCount + 1;
                if (m - n5 > floor((maxInt - delta) / handledCPCountPlusOne)) {
                    error$1("overflow");
                }
                delta += (m - n5) * handledCPCountPlusOne;
                n5 = m;
                var _iteratorNormalCompletion3 = true;
                var _didIteratorError3 = false;
                var _iteratorError3 = void 0;
                try {
                    for(var _iterator3 = input[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true){
                        var _currentValue = _step3.value;
                        if (_currentValue < n5 && ++delta > maxInt) {
                            error$1("overflow");
                        }
                        if (_currentValue == n5) {
                            var q = delta;
                            for(var k = base6;; k += base6){
                                var t = k <= bias ? tMin : k >= bias + tMax ? tMax : k - bias;
                                if (q < t) {
                                    break;
                                }
                                var qMinusT = q - t;
                                var baseMinusT = base6 - t;
                                output.push(stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0)));
                                q = floor(qMinusT / baseMinusT);
                            }
                            output.push(stringFromCharCode(digitToBasic(q, 0)));
                            bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
                            delta = 0;
                            ++handledCPCount;
                        }
                    }
                } catch (err1) {
                    _didIteratorError3 = true;
                    _iteratorError3 = err1;
                } finally{
                    try {
                        if (!_iteratorNormalCompletion3 && _iterator3.return) {
                            _iterator3.return();
                        }
                    } finally{
                        if (_didIteratorError3) {
                            throw _iteratorError3;
                        }
                    }
                }
                ++delta;
                ++n5;
            }
            return output.join("");
        };
        var toUnicode = function toUnicode2(input) {
            return mapDomain(input, function(string21) {
                return regexPunycode.test(string21) ? decode1(string21.slice(4).toLowerCase()) : string21;
            });
        };
        var toASCII = function toASCII2(input) {
            return mapDomain(input, function(string22) {
                return regexNonASCII.test(string22) ? "xn--" + encode1(string22) : string22;
            });
        };
        var punycode = {
            version: "2.1.0",
            ucs2: {
                decode: ucs2decode,
                encode: ucs2encode
            },
            decode: decode1,
            encode: encode1,
            toASCII,
            toUnicode
        };
        var SCHEMES2 = {};
        function pctEncChar2(chr) {
            var c = chr.charCodeAt(0);
            var e = void 0;
            if (c < 16) e = "%0" + c.toString(16).toUpperCase();
            else if (c < 128) e = "%" + c.toString(16).toUpperCase();
            else if (c < 2048) e = "%" + (c >> 6 | 192).toString(16).toUpperCase() + "%" + (c & 63 | 128).toString(16).toUpperCase();
            else e = "%" + (c >> 12 | 224).toString(16).toUpperCase() + "%" + (c >> 6 & 63 | 128).toString(16).toUpperCase() + "%" + (c & 63 | 128).toString(16).toUpperCase();
            return e;
        }
        function pctDecChars2(str62) {
            var newStr = "";
            var i39 = 0;
            var il = str62.length;
            while(i39 < il){
                var c = parseInt(str62.substr(i39 + 1, 2), 16);
                if (c < 128) {
                    newStr += String.fromCharCode(c);
                    i39 += 3;
                } else if (c >= 194 && c < 224) {
                    if (il - i39 >= 6) {
                        var c2 = parseInt(str62.substr(i39 + 4, 2), 16);
                        newStr += String.fromCharCode((c & 31) << 6 | c2 & 63);
                    } else {
                        newStr += str62.substr(i39, 6);
                    }
                    i39 += 6;
                } else if (c >= 224) {
                    if (il - i39 >= 9) {
                        var _c = parseInt(str62.substr(i39 + 4, 2), 16);
                        var c3 = parseInt(str62.substr(i39 + 7, 2), 16);
                        newStr += String.fromCharCode((c & 15) << 12 | (_c & 63) << 6 | c3 & 63);
                    } else {
                        newStr += str62.substr(i39, 9);
                    }
                    i39 += 9;
                } else {
                    newStr += str62.substr(i39, 3);
                    i39 += 3;
                }
            }
            return newStr;
        }
        function _normalizeComponentEncoding(components, protocol) {
            function decodeUnreserved2(str63) {
                var decStr = pctDecChars2(str63);
                return !decStr.match(protocol.UNRESERVED) ? str63 : decStr;
            }
            if (components.scheme) components.scheme = String(components.scheme).replace(protocol.PCT_ENCODED, decodeUnreserved2).toLowerCase().replace(protocol.NOT_SCHEME, "");
            if (components.userinfo !== void 0) components.userinfo = String(components.userinfo).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_USERINFO, pctEncChar2).replace(protocol.PCT_ENCODED, toUpperCase);
            if (components.host !== void 0) components.host = String(components.host).replace(protocol.PCT_ENCODED, decodeUnreserved2).toLowerCase().replace(protocol.NOT_HOST, pctEncChar2).replace(protocol.PCT_ENCODED, toUpperCase);
            if (components.path !== void 0) components.path = String(components.path).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(components.scheme ? protocol.NOT_PATH : protocol.NOT_PATH_NOSCHEME, pctEncChar2).replace(protocol.PCT_ENCODED, toUpperCase);
            if (components.query !== void 0) components.query = String(components.query).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_QUERY, pctEncChar2).replace(protocol.PCT_ENCODED, toUpperCase);
            if (components.fragment !== void 0) components.fragment = String(components.fragment).replace(protocol.PCT_ENCODED, decodeUnreserved2).replace(protocol.NOT_FRAGMENT, pctEncChar2).replace(protocol.PCT_ENCODED, toUpperCase);
            return components;
        }
        function _stripLeadingZeros(str64) {
            return str64.replace(/^0*(.*)/, "$1") || "0";
        }
        function _normalizeIPv4(host, protocol) {
            var matches = host.match(protocol.IPV4ADDRESS) || [];
            var _matches = slicedToArray(matches, 2), address = _matches[1];
            if (address) {
                return address.split(".").map(_stripLeadingZeros).join(".");
            } else {
                return host;
            }
        }
        function _normalizeIPv6(host, protocol) {
            var matches = host.match(protocol.IPV6ADDRESS) || [];
            var _matches2 = slicedToArray(matches, 3), address = _matches2[1], zone = _matches2[2];
            if (address) {
                var _address$toLowerCase$ = address.toLowerCase().split("::").reverse(), _address$toLowerCase$2 = slicedToArray(_address$toLowerCase$, 2), last = _address$toLowerCase$2[0], first = _address$toLowerCase$2[1];
                var firstFields = first ? first.split(":").map(_stripLeadingZeros) : [];
                var lastFields = last.split(":").map(_stripLeadingZeros);
                var isLastFieldIPv4Address = protocol.IPV4ADDRESS.test(lastFields[lastFields.length - 1]);
                var fieldCount = isLastFieldIPv4Address ? 7 : 8;
                var lastFieldsStart = lastFields.length - fieldCount;
                var fields = Array(fieldCount);
                for(var x = 0; x < fieldCount; ++x){
                    fields[x] = firstFields[x] || lastFields[lastFieldsStart + x] || "";
                }
                if (isLastFieldIPv4Address) {
                    fields[fieldCount - 1] = _normalizeIPv4(fields[fieldCount - 1], protocol);
                }
                var allZeroFields = fields.reduce(function(acc, field, index) {
                    if (!field || field === "0") {
                        var lastLongest = acc[acc.length - 1];
                        if (lastLongest && lastLongest.index + lastLongest.length === index) {
                            lastLongest.length++;
                        } else {
                            acc.push({
                                index,
                                length: 1
                            });
                        }
                    }
                    return acc;
                }, []);
                var longestZeroFields = allZeroFields.sort(function(a, b) {
                    return b.length - a.length;
                })[0];
                var newHost = void 0;
                if (longestZeroFields && longestZeroFields.length > 1) {
                    var newFirst = fields.slice(0, longestZeroFields.index);
                    var newLast = fields.slice(longestZeroFields.index + longestZeroFields.length);
                    newHost = newFirst.join(":") + "::" + newLast.join(":");
                } else {
                    newHost = fields.join(":");
                }
                if (zone) {
                    newHost += "%" + zone;
                }
                return newHost;
            } else {
                return host;
            }
        }
        var URI_PARSE = /^(?:([^:\/?#]+):)?(?:\/\/((?:([^\/?#@]*)@)?(\[[^\/?#\]]+\]|[^\/?#:]*)(?:\:(\d*))?))?([^?#]*)(?:\?([^#]*))?(?:#((?:.|\n|\r)*))?/i;
        var NO_MATCH_IS_UNDEFINED = "".match(/(){0}/)[1] === void 0;
        function parse21(uriString) {
            var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
            var components = {};
            var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
            if (options.reference === "suffix") uriString = (options.scheme ? options.scheme + ":" : "") + "//" + uriString;
            var matches = uriString.match(URI_PARSE);
            if (matches) {
                if (NO_MATCH_IS_UNDEFINED) {
                    components.scheme = matches[1];
                    components.userinfo = matches[3];
                    components.host = matches[4];
                    components.port = parseInt(matches[5], 10);
                    components.path = matches[6] || "";
                    components.query = matches[7];
                    components.fragment = matches[8];
                    if (isNaN(components.port)) {
                        components.port = matches[5];
                    }
                } else {
                    components.scheme = matches[1] || void 0;
                    components.userinfo = uriString.indexOf("@") !== -1 ? matches[3] : void 0;
                    components.host = uriString.indexOf("//") !== -1 ? matches[4] : void 0;
                    components.port = parseInt(matches[5], 10);
                    components.path = matches[6] || "";
                    components.query = uriString.indexOf("?") !== -1 ? matches[7] : void 0;
                    components.fragment = uriString.indexOf("#") !== -1 ? matches[8] : void 0;
                    if (isNaN(components.port)) {
                        components.port = uriString.match(/\/\/(?:.|\n)*\:(?:\/|\?|\#|$)/) ? matches[4] : void 0;
                    }
                }
                if (components.host) {
                    components.host = _normalizeIPv6(_normalizeIPv4(components.host, protocol), protocol);
                }
                if (components.scheme === void 0 && components.userinfo === void 0 && components.host === void 0 && components.port === void 0 && !components.path && components.query === void 0) {
                    components.reference = "same-document";
                } else if (components.scheme === void 0) {
                    components.reference = "relative";
                } else if (components.fragment === void 0) {
                    components.reference = "absolute";
                } else {
                    components.reference = "uri";
                }
                if (options.reference && options.reference !== "suffix" && options.reference !== components.reference) {
                    components.error = components.error || "URI is not a " + options.reference + " reference.";
                }
                var schemeHandler = SCHEMES2[(options.scheme || components.scheme || "").toLowerCase()];
                if (!options.unicodeSupport && (!schemeHandler || !schemeHandler.unicodeSupport)) {
                    if (components.host && (options.domainHost || schemeHandler && schemeHandler.domainHost)) {
                        try {
                            components.host = punycode.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars2).toLowerCase());
                        } catch (e) {
                            components.error = components.error || "Host's domain name can not be converted to ASCII via punycode: " + e;
                        }
                    }
                    _normalizeComponentEncoding(components, URI_PROTOCOL);
                } else {
                    _normalizeComponentEncoding(components, protocol);
                }
                if (schemeHandler && schemeHandler.parse) {
                    schemeHandler.parse(components, options);
                }
            } else {
                components.error = components.error || "URI can not be parsed.";
            }
            return components;
        }
        function _recomposeAuthority(components, options) {
            var protocol = options.iri !== false ? IRI_PROTOCOL : URI_PROTOCOL;
            var uriTokens = [];
            if (components.userinfo !== void 0) {
                uriTokens.push(components.userinfo);
                uriTokens.push("@");
            }
            if (components.host !== void 0) {
                uriTokens.push(_normalizeIPv6(_normalizeIPv4(String(components.host), protocol), protocol).replace(protocol.IPV6ADDRESS, function(_, $1, $2) {
                    return "[" + $1 + ($2 ? "%25" + $2 : "") + "]";
                }));
            }
            if (typeof components.port === "number" || typeof components.port === "string") {
                uriTokens.push(":");
                uriTokens.push(String(components.port));
            }
            return uriTokens.length ? uriTokens.join("") : void 0;
        }
        var RDS1 = /^\.\.?\//;
        var RDS2 = /^\/\.(\/|$)/;
        var RDS3 = /^\/\.\.(\/|$)/;
        var RDS5 = /^\/?(?:.|\n)*?(?=\/|$)/;
        function removeDotSegments2(input) {
            var output = [];
            while(input.length){
                if (input.match(RDS1)) {
                    input = input.replace(RDS1, "");
                } else if (input.match(RDS2)) {
                    input = input.replace(RDS2, "/");
                } else if (input.match(RDS3)) {
                    input = input.replace(RDS3, "/");
                    output.pop();
                } else if (input === "." || input === "..") {
                    input = "";
                } else {
                    var im = input.match(RDS5);
                    if (im) {
                        var s = im[0];
                        input = input.slice(s.length);
                        output.push(s);
                    } else {
                        throw new Error("Unexpected dot segment condition");
                    }
                }
            }
            return output.join("");
        }
        function serialize2(components) {
            var options = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
            var protocol = options.iri ? IRI_PROTOCOL : URI_PROTOCOL;
            var uriTokens = [];
            var schemeHandler = SCHEMES2[(options.scheme || components.scheme || "").toLowerCase()];
            if (schemeHandler && schemeHandler.serialize) schemeHandler.serialize(components, options);
            if (components.host) {
                if (protocol.IPV6ADDRESS.test(components.host)) ;
                else if (options.domainHost || schemeHandler && schemeHandler.domainHost) {
                    try {
                        components.host = !options.iri ? punycode.toASCII(components.host.replace(protocol.PCT_ENCODED, pctDecChars2).toLowerCase()) : punycode.toUnicode(components.host);
                    } catch (e) {
                        components.error = components.error || "Host's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e;
                    }
                }
            }
            _normalizeComponentEncoding(components, protocol);
            if (options.reference !== "suffix" && components.scheme) {
                uriTokens.push(components.scheme);
                uriTokens.push(":");
            }
            var authority = _recomposeAuthority(components, options);
            if (authority !== void 0) {
                if (options.reference !== "suffix") {
                    uriTokens.push("//");
                }
                uriTokens.push(authority);
                if (components.path && components.path.charAt(0) !== "/") {
                    uriTokens.push("/");
                }
            }
            if (components.path !== void 0) {
                var s = components.path;
                if (!options.absolutePath && (!schemeHandler || !schemeHandler.absolutePath)) {
                    s = removeDotSegments2(s);
                }
                if (authority === void 0) {
                    s = s.replace(/^\/\//, "/%2F");
                }
                uriTokens.push(s);
            }
            if (components.query !== void 0) {
                uriTokens.push("?");
                uriTokens.push(components.query);
            }
            if (components.fragment !== void 0) {
                uriTokens.push("#");
                uriTokens.push(components.fragment);
            }
            return uriTokens.join("");
        }
        function resolveComponents2(base2, relative3) {
            var options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
            var skipNormalization = arguments[3];
            var target = {};
            if (!skipNormalization) {
                base2 = parse21(serialize2(base2, options), options);
                relative3 = parse21(serialize2(relative3, options), options);
            }
            options = options || {};
            if (!options.tolerant && relative3.scheme) {
                target.scheme = relative3.scheme;
                target.userinfo = relative3.userinfo;
                target.host = relative3.host;
                target.port = relative3.port;
                target.path = removeDotSegments2(relative3.path || "");
                target.query = relative3.query;
            } else {
                if (relative3.userinfo !== void 0 || relative3.host !== void 0 || relative3.port !== void 0) {
                    target.userinfo = relative3.userinfo;
                    target.host = relative3.host;
                    target.port = relative3.port;
                    target.path = removeDotSegments2(relative3.path || "");
                    target.query = relative3.query;
                } else {
                    if (!relative3.path) {
                        target.path = base2.path;
                        if (relative3.query !== void 0) {
                            target.query = relative3.query;
                        } else {
                            target.query = base2.query;
                        }
                    } else {
                        if (relative3.path.charAt(0) === "/") {
                            target.path = removeDotSegments2(relative3.path);
                        } else {
                            if ((base2.userinfo !== void 0 || base2.host !== void 0 || base2.port !== void 0) && !base2.path) {
                                target.path = "/" + relative3.path;
                            } else if (!base2.path) {
                                target.path = relative3.path;
                            } else {
                                target.path = base2.path.slice(0, base2.path.lastIndexOf("/") + 1) + relative3.path;
                            }
                            target.path = removeDotSegments2(target.path);
                        }
                        target.query = relative3.query;
                    }
                    target.userinfo = base2.userinfo;
                    target.host = base2.host;
                    target.port = base2.port;
                }
                target.scheme = base2.scheme;
            }
            target.fragment = relative3.fragment;
            return target;
        }
        function resolve21(baseURI, relativeURI, options) {
            var schemelessOptions = assign({
                scheme: "null"
            }, options);
            return serialize2(resolveComponents2(parse21(baseURI, schemelessOptions), parse21(relativeURI, schemelessOptions), schemelessOptions, true), schemelessOptions);
        }
        function normalize21(uri, options) {
            if (typeof uri === "string") {
                uri = serialize2(parse21(uri, options), options);
            } else if (typeOf(uri) === "object") {
                uri = parse21(serialize2(uri, options), options);
            }
            return uri;
        }
        function equal2(uriA, uriB, options) {
            if (typeof uriA === "string") {
                uriA = serialize2(parse21(uriA, options), options);
            } else if (typeOf(uriA) === "object") {
                uriA = serialize2(uriA, options);
            }
            if (typeof uriB === "string") {
                uriB = serialize2(parse21(uriB, options), options);
            } else if (typeOf(uriB) === "object") {
                uriB = serialize2(uriB, options);
            }
            return uriA === uriB;
        }
        function escapeComponent2(str65, options) {
            return str65 && str65.toString().replace(!options || !options.iri ? URI_PROTOCOL.ESCAPE : IRI_PROTOCOL.ESCAPE, pctEncChar2);
        }
        function unescapeComponent2(str66, options) {
            return str66 && str66.toString().replace(!options || !options.iri ? URI_PROTOCOL.PCT_ENCODED : IRI_PROTOCOL.PCT_ENCODED, pctDecChars2);
        }
        var handler = {
            scheme: "http",
            domainHost: true,
            parse: function parse3(components, options) {
                if (!components.host) {
                    components.error = components.error || "HTTP URIs must have a host.";
                }
                return components;
            },
            serialize: function serialize3(components, options) {
                var secure = String(components.scheme).toLowerCase() === "https";
                if (components.port === (secure ? 443 : 80) || components.port === "") {
                    components.port = void 0;
                }
                if (!components.path) {
                    components.path = "/";
                }
                return components;
            }
        };
        var handler$1 = {
            scheme: "https",
            domainHost: handler.domainHost,
            parse: handler.parse,
            serialize: handler.serialize
        };
        function isSecure(wsComponents) {
            return typeof wsComponents.secure === "boolean" ? wsComponents.secure : String(wsComponents.scheme).toLowerCase() === "wss";
        }
        var handler$2 = {
            scheme: "ws",
            domainHost: true,
            parse: function parse3(components, options) {
                var wsComponents = components;
                wsComponents.secure = isSecure(wsComponents);
                wsComponents.resourceName = (wsComponents.path || "/") + (wsComponents.query ? "?" + wsComponents.query : "");
                wsComponents.path = void 0;
                wsComponents.query = void 0;
                return wsComponents;
            },
            serialize: function serialize3(wsComponents, options) {
                if (wsComponents.port === (isSecure(wsComponents) ? 443 : 80) || wsComponents.port === "") {
                    wsComponents.port = void 0;
                }
                if (typeof wsComponents.secure === "boolean") {
                    wsComponents.scheme = wsComponents.secure ? "wss" : "ws";
                    wsComponents.secure = void 0;
                }
                if (wsComponents.resourceName) {
                    var _wsComponents$resourc = wsComponents.resourceName.split("?"), _wsComponents$resourc2 = slicedToArray(_wsComponents$resourc, 2), path61 = _wsComponents$resourc2[0], query = _wsComponents$resourc2[1];
                    wsComponents.path = path61 && path61 !== "/" ? path61 : void 0;
                    wsComponents.query = query;
                    wsComponents.resourceName = void 0;
                }
                wsComponents.fragment = void 0;
                return wsComponents;
            }
        };
        var handler$3 = {
            scheme: "wss",
            domainHost: handler$2.domainHost,
            parse: handler$2.parse,
            serialize: handler$2.serialize
        };
        var O = {};
        var UNRESERVED$$ = "[A-Za-z0-9\\-\\.\\_\\~\\xA0-\\u200D\\u2010-\\u2029\\u202F-\\uD7FF\\uF900-\\uFDCF\\uFDF0-\\uFFEF]";
        var HEXDIG$$ = "[0-9A-Fa-f]";
        var PCT_ENCODED$ = subexp(subexp("%[EFef]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%[89A-Fa-f]" + HEXDIG$$ + "%" + HEXDIG$$ + HEXDIG$$) + "|" + subexp("%" + HEXDIG$$ + HEXDIG$$));
        var ATEXT$$ = "[A-Za-z0-9\\!\\$\\%\\'\\*\\+\\-\\^\\_\\`\\{\\|\\}\\~]";
        var QTEXT$$ = "[\\!\\$\\%\\'\\(\\)\\*\\+\\,\\-\\.0-9\\<\\>A-Z\\x5E-\\x7E]";
        var VCHAR$$ = merge1(QTEXT$$, '[\\"\\\\]');
        var SOME_DELIMS$$ = "[\\!\\$\\'\\(\\)\\*\\+\\,\\;\\:\\@]";
        var UNRESERVED = new RegExp(UNRESERVED$$, "g");
        var PCT_ENCODED = new RegExp(PCT_ENCODED$, "g");
        var NOT_LOCAL_PART = new RegExp(merge1("[^]", ATEXT$$, "[\\.]", '[\\"]', VCHAR$$), "g");
        var NOT_HFNAME = new RegExp(merge1("[^]", UNRESERVED$$, SOME_DELIMS$$), "g");
        var NOT_HFVALUE = NOT_HFNAME;
        function decodeUnreserved(str67) {
            var decStr = pctDecChars2(str67);
            return !decStr.match(UNRESERVED) ? str67 : decStr;
        }
        var handler$4 = {
            scheme: "mailto",
            parse: function parse$$1(components, options) {
                var mailtoComponents = components;
                var to = mailtoComponents.to = mailtoComponents.path ? mailtoComponents.path.split(",") : [];
                mailtoComponents.path = void 0;
                if (mailtoComponents.query) {
                    var unknownHeaders = false;
                    var headers = {};
                    var hfields = mailtoComponents.query.split("&");
                    for(var x = 0, xl = hfields.length; x < xl; ++x){
                        var hfield = hfields[x].split("=");
                        switch(hfield[0]){
                            case "to":
                                var toAddrs = hfield[1].split(",");
                                for(var _x = 0, _xl = toAddrs.length; _x < _xl; ++_x){
                                    to.push(toAddrs[_x]);
                                }
                                break;
                            case "subject":
                                mailtoComponents.subject = unescapeComponent2(hfield[1], options);
                                break;
                            case "body":
                                mailtoComponents.body = unescapeComponent2(hfield[1], options);
                                break;
                            default:
                                unknownHeaders = true;
                                headers[unescapeComponent2(hfield[0], options)] = unescapeComponent2(hfield[1], options);
                                break;
                        }
                    }
                    if (unknownHeaders) mailtoComponents.headers = headers;
                }
                mailtoComponents.query = void 0;
                for(var _x2 = 0, _xl2 = to.length; _x2 < _xl2; ++_x2){
                    var addr = to[_x2].split("@");
                    addr[0] = unescapeComponent2(addr[0]);
                    if (!options.unicodeSupport) {
                        try {
                            addr[1] = punycode.toASCII(unescapeComponent2(addr[1], options).toLowerCase());
                        } catch (e) {
                            mailtoComponents.error = mailtoComponents.error || "Email address's domain name can not be converted to ASCII via punycode: " + e;
                        }
                    } else {
                        addr[1] = unescapeComponent2(addr[1], options).toLowerCase();
                    }
                    to[_x2] = addr.join("@");
                }
                return mailtoComponents;
            },
            serialize: function serialize$$1(mailtoComponents, options) {
                var components = mailtoComponents;
                var to = toArray(mailtoComponents.to);
                if (to) {
                    for(var x = 0, xl = to.length; x < xl; ++x){
                        var toAddr = String(to[x]);
                        var atIdx = toAddr.lastIndexOf("@");
                        var localPart = toAddr.slice(0, atIdx).replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_LOCAL_PART, pctEncChar2);
                        var domain = toAddr.slice(atIdx + 1);
                        try {
                            domain = !options.iri ? punycode.toASCII(unescapeComponent2(domain, options).toLowerCase()) : punycode.toUnicode(domain);
                        } catch (e) {
                            components.error = components.error || "Email address's domain name can not be converted to " + (!options.iri ? "ASCII" : "Unicode") + " via punycode: " + e;
                        }
                        to[x] = localPart + "@" + domain;
                    }
                    components.path = to.join(",");
                }
                var headers = mailtoComponents.headers = mailtoComponents.headers || {};
                if (mailtoComponents.subject) headers["subject"] = mailtoComponents.subject;
                if (mailtoComponents.body) headers["body"] = mailtoComponents.body;
                var fields = [];
                for(var name78 in headers){
                    if (headers[name78] !== O[name78]) {
                        fields.push(name78.replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_HFNAME, pctEncChar2) + "=" + headers[name78].replace(PCT_ENCODED, decodeUnreserved).replace(PCT_ENCODED, toUpperCase).replace(NOT_HFVALUE, pctEncChar2));
                    }
                }
                if (fields.length) {
                    components.query = fields.join("&");
                }
                return components;
            }
        };
        var URN_PARSE = /^([^\:]+)\:(.*)/;
        var handler$5 = {
            scheme: "urn",
            parse: function parse$$1(components, options) {
                var matches = components.path && components.path.match(URN_PARSE);
                var urnComponents = components;
                if (matches) {
                    var scheme = options.scheme || urnComponents.scheme || "urn";
                    var nid = matches[1].toLowerCase();
                    var nss = matches[2];
                    var urnScheme = scheme + ":" + (options.nid || nid);
                    var schemeHandler = SCHEMES2[urnScheme];
                    urnComponents.nid = nid;
                    urnComponents.nss = nss;
                    urnComponents.path = void 0;
                    if (schemeHandler) {
                        urnComponents = schemeHandler.parse(urnComponents, options);
                    }
                } else {
                    urnComponents.error = urnComponents.error || "URN can not be parsed.";
                }
                return urnComponents;
            },
            serialize: function serialize$$1(urnComponents, options) {
                var scheme = options.scheme || urnComponents.scheme || "urn";
                var nid = urnComponents.nid;
                var urnScheme = scheme + ":" + (options.nid || nid);
                var schemeHandler = SCHEMES2[urnScheme];
                if (schemeHandler) {
                    urnComponents = schemeHandler.serialize(urnComponents, options);
                }
                var uriComponents = urnComponents;
                var nss = urnComponents.nss;
                uriComponents.path = (nid || options.nid) + ":" + nss;
                return uriComponents;
            }
        };
        var UUID = /^[0-9A-Fa-f]{8}(?:\-[0-9A-Fa-f]{4}){3}\-[0-9A-Fa-f]{12}$/;
        var handler$6 = {
            scheme: "urn:uuid",
            parse: function parse3(urnComponents, options) {
                var uuidComponents = urnComponents;
                uuidComponents.uuid = uuidComponents.nss;
                uuidComponents.nss = void 0;
                if (!options.tolerant && (!uuidComponents.uuid || !uuidComponents.uuid.match(UUID))) {
                    uuidComponents.error = uuidComponents.error || "UUID is not valid.";
                }
                return uuidComponents;
            },
            serialize: function serialize3(uuidComponents, options) {
                var urnComponents = uuidComponents;
                urnComponents.nss = (uuidComponents.uuid || "").toLowerCase();
                return urnComponents;
            }
        };
        SCHEMES2[handler.scheme] = handler;
        SCHEMES2[handler$1.scheme] = handler$1;
        SCHEMES2[handler$2.scheme] = handler$2;
        SCHEMES2[handler$3.scheme] = handler$3;
        SCHEMES2[handler$4.scheme] = handler$4;
        SCHEMES2[handler$5.scheme] = handler$5;
        SCHEMES2[handler$6.scheme] = handler$6;
        exports2.SCHEMES = SCHEMES2;
        exports2.pctEncChar = pctEncChar2;
        exports2.pctDecChars = pctDecChars2;
        exports2.parse = parse21;
        exports2.removeDotSegments = removeDotSegments2;
        exports2.serialize = serialize2;
        exports2.resolveComponents = resolveComponents2;
        exports2.resolve = resolve21;
        exports2.normalize = normalize21;
        exports2.equal = equal2;
        exports2.escapeComponent = escapeComponent2;
        exports2.unescapeComponent = unescapeComponent2;
        Object.defineProperty(exports2, "__esModule", {
            value: true
        });
    });
});
var __pika_web_default_export_for_treeshaking__ = getDefaultExportFromCjs(uri_all);
uri_all.SCHEMES;
uri_all.equal;
uri_all.escapeComponent;
uri_all.normalize;
uri_all.parse;
uri_all.pctDecChars;
uri_all.pctEncChar;
uri_all.removeDotSegments;
uri_all.resolve;
uri_all.resolveComponents;
uri_all.serialize;
uri_all.unescapeComponent;
function getDefaultExportFromCjs1(x) {
    return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
function createCommonjsModule5(fn, basedir, module) {
    return module = {
        path: basedir,
        exports: {},
        require: function(path62, base7) {
            return commonjsRequire2(path62, base7 === void 0 || base7 === null ? module.path : base7);
        }
    }, fn(module, module.exports), module.exports;
}
function commonjsRequire2() {
    throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs");
}
var code1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.regexpCode = exports.getProperty = exports.safeStringify = exports.stringify = exports.strConcat = exports.addCodeArg = exports.str = exports._ = exports.nil = exports._Code = exports.Name = exports.IDENTIFIER = exports._CodeOrName = void 0;
    class _CodeOrName {
    }
    exports._CodeOrName = _CodeOrName;
    exports.IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
    class Name2 extends _CodeOrName {
        constructor(s){
            super();
            if (!exports.IDENTIFIER.test(s)) throw new Error("CodeGen: name must be a valid identifier");
            this.str = s;
        }
        toString() {
            return this.str;
        }
        emptyStr() {
            return false;
        }
        get names() {
            return {
                [this.str]: 1
            };
        }
    }
    exports.Name = Name2;
    class _Code extends _CodeOrName {
        constructor(code2){
            super();
            this._items = typeof code2 === "string" ? [
                code2
            ] : code2;
        }
        toString() {
            return this.str;
        }
        emptyStr() {
            if (this._items.length > 1) return false;
            const item = this._items[0];
            return item === "" || item === '""';
        }
        get str() {
            var _a;
            return (_a = this._str) !== null && _a !== void 0 ? _a : this._str = this._items.reduce((s, c)=>`${s}${c}`
            , "");
        }
        get names() {
            var _a;
            return (_a = this._names) !== null && _a !== void 0 ? _a : this._names = this._items.reduce((names, c)=>{
                if (c instanceof Name2) names[c.str] = (names[c.str] || 0) + 1;
                return names;
            }, {});
        }
    }
    exports._Code = _Code;
    exports.nil = new _Code("");
    function _2(strs, ...args) {
        const code2 = [
            strs[0]
        ];
        let i40 = 0;
        while(i40 < args.length){
            addCodeArg(code2, args[i40]);
            code2.push(strs[++i40]);
        }
        return new _Code(code2);
    }
    exports._ = _2;
    const plus = new _Code("+");
    function str2(strs, ...args) {
        const expr = [
            safeStringify(strs[0])
        ];
        let i41 = 0;
        while(i41 < args.length){
            expr.push(plus);
            addCodeArg(expr, args[i41]);
            expr.push(plus, safeStringify(strs[++i41]));
        }
        optimize(expr);
        return new _Code(expr);
    }
    exports.str = str2;
    function addCodeArg(code2, arg) {
        if (arg instanceof _Code) code2.push(...arg._items);
        else if (arg instanceof Name2) code2.push(arg);
        else code2.push(interpolate(arg));
    }
    exports.addCodeArg = addCodeArg;
    function optimize(expr) {
        let i42 = 1;
        while(i42 < expr.length - 1){
            if (expr[i42] === plus) {
                const res = mergeExprItems(expr[i42 - 1], expr[i42 + 1]);
                if (res !== void 0) {
                    expr.splice(i42 - 1, 3, res);
                    continue;
                }
                expr[i42++] = "+";
            }
            i42++;
        }
    }
    function mergeExprItems(a, b) {
        if (b === '""') return a;
        if (a === '""') return b;
        if (typeof a == "string") {
            if (b instanceof Name2 || a[a.length - 1] !== '"') return;
            if (typeof b != "string") return `${a.slice(0, -1)}${b}"`;
            if (b[0] === '"') return a.slice(0, -1) + b.slice(1);
            return;
        }
        if (typeof b == "string" && b[0] === '"' && !(a instanceof Name2)) return `"${a}${b.slice(1)}`;
        return;
    }
    function strConcat(c1, c2) {
        return c2.emptyStr() ? c1 : c1.emptyStr() ? c2 : str2`${c1}${c2}`;
    }
    exports.strConcat = strConcat;
    function interpolate(x) {
        return typeof x == "number" || typeof x == "boolean" || x === null ? x : safeStringify(Array.isArray(x) ? x.join(",") : x);
    }
    function stringify2(x) {
        return new _Code(safeStringify(x));
    }
    exports.stringify = stringify2;
    function safeStringify(x) {
        return JSON.stringify(x).replace(/\u2028/g, "\\u2028").replace(/\u2029/g, "\\u2029");
    }
    exports.safeStringify = safeStringify;
    function getProperty(key) {
        return typeof key == "string" && exports.IDENTIFIER.test(key) ? new _Code(`.${key}`) : _2`[${key}]`;
    }
    exports.getProperty = getProperty;
    function regexpCode(rx) {
        return new _Code(rx.toString());
    }
    exports.regexpCode = regexpCode;
});
var scope = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.ValueScope = exports.ValueScopeName = exports.Scope = exports.varKinds = exports.UsedValueState = void 0;
    class ValueError extends Error {
        constructor(name79){
            super(`CodeGen: "code" for ${name79} not defined`);
            this.value = name79.value;
        }
    }
    var UsedValueState;
    (function(UsedValueState2) {
        UsedValueState2[UsedValueState2["Started"] = 0] = "Started";
        UsedValueState2[UsedValueState2["Completed"] = 1] = "Completed";
    })(UsedValueState = exports.UsedValueState || (exports.UsedValueState = {}));
    exports.varKinds = {
        const: new code1.Name("const"),
        let: new code1.Name("let"),
        var: new code1.Name("var")
    };
    class Scope1 {
        constructor({ prefixes , parent  } = {}){
            this._names = {};
            this._prefixes = prefixes;
            this._parent = parent;
        }
        toName(nameOrPrefix) {
            return nameOrPrefix instanceof code1.Name ? nameOrPrefix : this.name(nameOrPrefix);
        }
        name(prefix) {
            return new code1.Name(this._newName(prefix));
        }
        _newName(prefix) {
            const ng = this._names[prefix] || this._nameGroup(prefix);
            return `${prefix}${ng.index++}`;
        }
        _nameGroup(prefix) {
            var _a, _b;
            if (((_b = (_a = this._parent) === null || _a === void 0 ? void 0 : _a._prefixes) === null || _b === void 0 ? void 0 : _b.has(prefix)) || this._prefixes && !this._prefixes.has(prefix)) {
                throw new Error(`CodeGen: prefix "${prefix}" is not allowed in this scope`);
            }
            return this._names[prefix] = {
                prefix,
                index: 0
            };
        }
    }
    exports.Scope = Scope1;
    class ValueScopeName extends code1.Name {
        constructor(prefix, nameStr){
            super(nameStr);
            this.prefix = prefix;
        }
        setValue(value, { property: property1 , itemIndex  }) {
            this.value = value;
            this.scopePath = code1._`.${new code1.Name(property1)}[${itemIndex}]`;
        }
    }
    exports.ValueScopeName = ValueScopeName;
    const line = code1._`\n`;
    class ValueScope extends Scope1 {
        constructor(opts){
            super(opts);
            this._values = {};
            this._scope = opts.scope;
            this.opts = {
                ...opts,
                _n: opts.lines ? line : code1.nil
            };
        }
        get() {
            return this._scope;
        }
        name(prefix) {
            return new ValueScopeName(prefix, this._newName(prefix));
        }
        value(nameOrPrefix, value) {
            var _a;
            if (value.ref === void 0) throw new Error("CodeGen: ref must be passed in value");
            const name80 = this.toName(nameOrPrefix);
            const { prefix  } = name80;
            const valueKey = (_a = value.key) !== null && _a !== void 0 ? _a : value.ref;
            let vs = this._values[prefix];
            if (vs) {
                const _name = vs.get(valueKey);
                if (_name) return _name;
            } else {
                vs = this._values[prefix] = new Map();
            }
            vs.set(valueKey, name80);
            const s = this._scope[prefix] || (this._scope[prefix] = []);
            const itemIndex = s.length;
            s[itemIndex] = value.ref;
            name80.setValue(value, {
                property: prefix,
                itemIndex
            });
            return name80;
        }
        getValue(prefix, keyOrRef) {
            const vs = this._values[prefix];
            if (!vs) return;
            return vs.get(keyOrRef);
        }
        scopeRefs(scopeName, values11 = this._values) {
            return this._reduceValues(values11, (name81)=>{
                if (name81.scopePath === void 0) throw new Error(`CodeGen: name "${name81}" has no value`);
                return code1._`${scopeName}${name81.scopePath}`;
            });
        }
        scopeCode(values12 = this._values, usedValues, getCode) {
            return this._reduceValues(values12, (name82)=>{
                if (name82.value === void 0) throw new Error(`CodeGen: name "${name82}" has no value`);
                return name82.value.code;
            }, usedValues, getCode);
        }
        _reduceValues(values13, valueCode, usedValues = {}, getCode) {
            let code$12 = code1.nil;
            for(const prefix in values13){
                const vs = values13[prefix];
                if (!vs) continue;
                const nameSet = usedValues[prefix] = usedValues[prefix] || new Map();
                vs.forEach((name83)=>{
                    if (nameSet.has(name83)) return;
                    nameSet.set(name83, UsedValueState.Started);
                    let c = valueCode(name83);
                    if (c) {
                        const def1 = this.opts.es5 ? exports.varKinds.var : exports.varKinds.const;
                        code$12 = code1._`${code$12}${def1} ${name83} = ${c};${this.opts._n}`;
                    } else if (c = getCode === null || getCode === void 0 ? void 0 : getCode(name83)) {
                        code$12 = code1._`${code$12}${c}${this.opts._n}`;
                    } else {
                        throw new ValueError(name83);
                    }
                    nameSet.set(name83, UsedValueState.Completed);
                });
            }
            return code$12;
        }
    }
    exports.ValueScope = ValueScope;
});
var codegen = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.or = exports.and = exports.not = exports.CodeGen = exports.operators = exports.varKinds = exports.ValueScopeName = exports.ValueScope = exports.Scope = exports.Name = exports.regexpCode = exports.stringify = exports.getProperty = exports.nil = exports.strConcat = exports.str = exports._ = void 0;
    var code_2 = code1;
    Object.defineProperty(exports, "_", {
        enumerable: true,
        get: function() {
            return code_2._;
        }
    });
    Object.defineProperty(exports, "str", {
        enumerable: true,
        get: function() {
            return code_2.str;
        }
    });
    Object.defineProperty(exports, "strConcat", {
        enumerable: true,
        get: function() {
            return code_2.strConcat;
        }
    });
    Object.defineProperty(exports, "nil", {
        enumerable: true,
        get: function() {
            return code_2.nil;
        }
    });
    Object.defineProperty(exports, "getProperty", {
        enumerable: true,
        get: function() {
            return code_2.getProperty;
        }
    });
    Object.defineProperty(exports, "stringify", {
        enumerable: true,
        get: function() {
            return code_2.stringify;
        }
    });
    Object.defineProperty(exports, "regexpCode", {
        enumerable: true,
        get: function() {
            return code_2.regexpCode;
        }
    });
    Object.defineProperty(exports, "Name", {
        enumerable: true,
        get: function() {
            return code_2.Name;
        }
    });
    var scope_2 = scope;
    Object.defineProperty(exports, "Scope", {
        enumerable: true,
        get: function() {
            return scope_2.Scope;
        }
    });
    Object.defineProperty(exports, "ValueScope", {
        enumerable: true,
        get: function() {
            return scope_2.ValueScope;
        }
    });
    Object.defineProperty(exports, "ValueScopeName", {
        enumerable: true,
        get: function() {
            return scope_2.ValueScopeName;
        }
    });
    Object.defineProperty(exports, "varKinds", {
        enumerable: true,
        get: function() {
            return scope_2.varKinds;
        }
    });
    exports.operators = {
        GT: new code1._Code(">"),
        GTE: new code1._Code(">="),
        LT: new code1._Code("<"),
        LTE: new code1._Code("<="),
        EQ: new code1._Code("==="),
        NEQ: new code1._Code("!=="),
        NOT: new code1._Code("!"),
        OR: new code1._Code("||"),
        AND: new code1._Code("&&"),
        ADD: new code1._Code("+")
    };
    class Node2 {
        optimizeNodes() {
            return this;
        }
        optimizeNames(_names, _constants) {
            return this;
        }
    }
    class Def extends Node2 {
        constructor(varKind, name84, rhs){
            super();
            this.varKind = varKind;
            this.name = name84;
            this.rhs = rhs;
        }
        render({ es5 , _n  }) {
            const varKind = es5 ? scope.varKinds.var : this.varKind;
            const rhs = this.rhs === void 0 ? "" : ` = ${this.rhs}`;
            return `${varKind} ${this.name}${rhs};` + _n;
        }
        optimizeNames(names, constants) {
            if (!names[this.name.str]) return;
            if (this.rhs) this.rhs = optimizeExpr(this.rhs, names, constants);
            return this;
        }
        get names() {
            return this.rhs instanceof code1._CodeOrName ? this.rhs.names : {};
        }
    }
    class Assign extends Node2 {
        constructor(lhs, rhs, sideEffects){
            super();
            this.lhs = lhs;
            this.rhs = rhs;
            this.sideEffects = sideEffects;
        }
        render({ _n  }) {
            return `${this.lhs} = ${this.rhs};` + _n;
        }
        optimizeNames(names, constants) {
            if (this.lhs instanceof code1.Name && !names[this.lhs.str] && !this.sideEffects) return;
            this.rhs = optimizeExpr(this.rhs, names, constants);
            return this;
        }
        get names() {
            const names = this.lhs instanceof code1.Name ? {} : {
                ...this.lhs.names
            };
            return addExprNames(names, this.rhs);
        }
    }
    class AssignOp extends Assign {
        constructor(lhs, op, rhs, sideEffects){
            super(lhs, rhs, sideEffects);
            this.op = op;
        }
        render({ _n  }) {
            return `${this.lhs} ${this.op}= ${this.rhs};` + _n;
        }
    }
    class Label extends Node2 {
        constructor(label){
            super();
            this.label = label;
            this.names = {};
        }
        render({ _n  }) {
            return `${this.label}:` + _n;
        }
    }
    class Break extends Node2 {
        constructor(label){
            super();
            this.label = label;
            this.names = {};
        }
        render({ _n  }) {
            const label = this.label ? ` ${this.label}` : "";
            return `break${label};` + _n;
        }
    }
    class Throw extends Node2 {
        constructor(error16){
            super();
            this.error = error16;
        }
        render({ _n  }) {
            return `throw ${this.error};` + _n;
        }
        get names() {
            return this.error.names;
        }
    }
    class AnyCode extends Node2 {
        constructor(code2){
            super();
            this.code = code2;
        }
        render({ _n  }) {
            return `${this.code};` + _n;
        }
        optimizeNodes() {
            return `${this.code}` ? this : void 0;
        }
        optimizeNames(names, constants) {
            this.code = optimizeExpr(this.code, names, constants);
            return this;
        }
        get names() {
            return this.code instanceof code1._CodeOrName ? this.code.names : {};
        }
    }
    class ParentNode extends Node2 {
        constructor(nodes = []){
            super();
            this.nodes = nodes;
        }
        render(opts) {
            return this.nodes.reduce((code2, n6)=>code2 + n6.render(opts)
            , "");
        }
        optimizeNodes() {
            const { nodes  } = this;
            let i43 = nodes.length;
            while(i43--){
                const n7 = nodes[i43].optimizeNodes();
                if (Array.isArray(n7)) nodes.splice(i43, 1, ...n7);
                else if (n7) nodes[i43] = n7;
                else nodes.splice(i43, 1);
            }
            return nodes.length > 0 ? this : void 0;
        }
        optimizeNames(names, constants) {
            const { nodes  } = this;
            let i44 = nodes.length;
            while(i44--){
                const n8 = nodes[i44];
                if (n8.optimizeNames(names, constants)) continue;
                subtractNames(names, n8.names);
                nodes.splice(i44, 1);
            }
            return nodes.length > 0 ? this : void 0;
        }
        get names() {
            return this.nodes.reduce((names, n9)=>addNames(names, n9.names)
            , {});
        }
    }
    class BlockNode extends ParentNode {
        render(opts) {
            return "{" + opts._n + super.render(opts) + "}" + opts._n;
        }
    }
    class Root extends ParentNode {
    }
    class Else extends BlockNode {
    }
    Else.kind = "else";
    class If extends BlockNode {
        constructor(condition, nodes){
            super(nodes);
            this.condition = condition;
        }
        render(opts) {
            let code2 = `if(${this.condition})` + super.render(opts);
            if (this.else) code2 += "else " + this.else.render(opts);
            return code2;
        }
        optimizeNodes() {
            super.optimizeNodes();
            const cond = this.condition;
            if (cond === true) return this.nodes;
            let e = this.else;
            if (e) {
                const ns = e.optimizeNodes();
                e = this.else = Array.isArray(ns) ? new Else(ns) : ns;
            }
            if (e) {
                if (cond === false) return e instanceof If ? e : e.nodes;
                if (this.nodes.length) return this;
                return new If(not2(cond), e instanceof If ? [
                    e
                ] : e.nodes);
            }
            if (cond === false || !this.nodes.length) return void 0;
            return this;
        }
        optimizeNames(names, constants) {
            var _a;
            this.else = (_a = this.else) === null || _a === void 0 ? void 0 : _a.optimizeNames(names, constants);
            if (!(super.optimizeNames(names, constants) || this.else)) return;
            this.condition = optimizeExpr(this.condition, names, constants);
            return this;
        }
        get names() {
            const names = super.names;
            addExprNames(names, this.condition);
            if (this.else) addNames(names, this.else.names);
            return names;
        }
    }
    If.kind = "if";
    class For extends BlockNode {
    }
    For.kind = "for";
    class ForLoop extends For {
        constructor(iteration){
            super();
            this.iteration = iteration;
        }
        render(opts) {
            return `for(${this.iteration})` + super.render(opts);
        }
        optimizeNames(names, constants) {
            if (!super.optimizeNames(names, constants)) return;
            this.iteration = optimizeExpr(this.iteration, names, constants);
            return this;
        }
        get names() {
            return addNames(super.names, this.iteration.names);
        }
    }
    class ForRange extends For {
        constructor(varKind, name85, from, to){
            super();
            this.varKind = varKind;
            this.name = name85;
            this.from = from;
            this.to = to;
        }
        render(opts) {
            const varKind = opts.es5 ? scope.varKinds.var : this.varKind;
            const { name: name86 , from , to  } = this;
            return `for(${varKind} ${name86}=${from}; ${name86}<${to}; ${name86}++)` + super.render(opts);
        }
        get names() {
            const names = addExprNames(super.names, this.from);
            return addExprNames(names, this.to);
        }
    }
    class ForIter extends For {
        constructor(loop, varKind, name87, iterable){
            super();
            this.loop = loop;
            this.varKind = varKind;
            this.name = name87;
            this.iterable = iterable;
        }
        render(opts) {
            return `for(${this.varKind} ${this.name} ${this.loop} ${this.iterable})` + super.render(opts);
        }
        optimizeNames(names, constants) {
            if (!super.optimizeNames(names, constants)) return;
            this.iterable = optimizeExpr(this.iterable, names, constants);
            return this;
        }
        get names() {
            return addNames(super.names, this.iterable.names);
        }
    }
    class Func extends BlockNode {
        constructor(name88, args, async){
            super();
            this.name = name88;
            this.args = args;
            this.async = async;
        }
        render(opts) {
            const _async = this.async ? "async " : "";
            return `${_async}function ${this.name}(${this.args})` + super.render(opts);
        }
    }
    Func.kind = "func";
    class Return extends ParentNode {
        render(opts) {
            return "return " + super.render(opts);
        }
    }
    Return.kind = "return";
    class Try extends BlockNode {
        render(opts) {
            let code2 = "try" + super.render(opts);
            if (this.catch) code2 += this.catch.render(opts);
            if (this.finally) code2 += this.finally.render(opts);
            return code2;
        }
        optimizeNodes() {
            var _a, _b;
            super.optimizeNodes();
            (_a = this.catch) === null || _a === void 0 ? void 0 : _a.optimizeNodes();
            (_b = this.finally) === null || _b === void 0 ? void 0 : _b.optimizeNodes();
            return this;
        }
        optimizeNames(names, constants) {
            var _a, _b;
            super.optimizeNames(names, constants);
            (_a = this.catch) === null || _a === void 0 ? void 0 : _a.optimizeNames(names, constants);
            (_b = this.finally) === null || _b === void 0 ? void 0 : _b.optimizeNames(names, constants);
            return this;
        }
        get names() {
            const names = super.names;
            if (this.catch) addNames(names, this.catch.names);
            if (this.finally) addNames(names, this.finally.names);
            return names;
        }
    }
    class Catch extends BlockNode {
        constructor(error17){
            super();
            this.error = error17;
        }
        render(opts) {
            return `catch(${this.error})` + super.render(opts);
        }
    }
    Catch.kind = "catch";
    class Finally extends BlockNode {
        render(opts) {
            return "finally" + super.render(opts);
        }
    }
    Finally.kind = "finally";
    class CodeGen2 {
        constructor(extScope, opts = {}){
            this._values = {};
            this._blockStarts = [];
            this._constants = {};
            this.opts = {
                ...opts,
                _n: opts.lines ? "\n" : ""
            };
            this._extScope = extScope;
            this._scope = new scope.Scope({
                parent: extScope
            });
            this._nodes = [
                new Root()
            ];
        }
        toString() {
            return this._root.render(this.opts);
        }
        name(prefix) {
            return this._scope.name(prefix);
        }
        scopeName(prefix) {
            return this._extScope.name(prefix);
        }
        scopeValue(prefixOrName, value) {
            const name89 = this._extScope.value(prefixOrName, value);
            const vs = this._values[name89.prefix] || (this._values[name89.prefix] = new Set());
            vs.add(name89);
            return name89;
        }
        getScopeValue(prefix, keyOrRef) {
            return this._extScope.getValue(prefix, keyOrRef);
        }
        scopeRefs(scopeName) {
            return this._extScope.scopeRefs(scopeName, this._values);
        }
        scopeCode() {
            return this._extScope.scopeCode(this._values);
        }
        _def(varKind, nameOrPrefix, rhs, constant1) {
            const name90 = this._scope.toName(nameOrPrefix);
            if (rhs !== void 0 && constant1) this._constants[name90.str] = rhs;
            this._leafNode(new Def(varKind, name90, rhs));
            return name90;
        }
        const(nameOrPrefix, rhs, _constant) {
            return this._def(scope.varKinds.const, nameOrPrefix, rhs, _constant);
        }
        let(nameOrPrefix, rhs, _constant) {
            return this._def(scope.varKinds.let, nameOrPrefix, rhs, _constant);
        }
        var(nameOrPrefix, rhs, _constant) {
            return this._def(scope.varKinds.var, nameOrPrefix, rhs, _constant);
        }
        assign(lhs, rhs, sideEffects) {
            return this._leafNode(new Assign(lhs, rhs, sideEffects));
        }
        add(lhs, rhs) {
            return this._leafNode(new AssignOp(lhs, exports.operators.ADD, rhs));
        }
        code(c) {
            if (typeof c == "function") c();
            else if (c !== code1.nil) this._leafNode(new AnyCode(c));
            return this;
        }
        object(...keyValues) {
            const code$12 = [
                "{"
            ];
            for (const [key, value] of keyValues){
                if (code$12.length > 1) code$12.push(",");
                code$12.push(key);
                if (key !== value || this.opts.es5) {
                    code$12.push(":");
                    (0, code1.addCodeArg)(code$12, value);
                }
            }
            code$12.push("}");
            return new code1._Code(code$12);
        }
        if(condition, thenBody, elseBody) {
            this._blockNode(new If(condition));
            if (thenBody && elseBody) {
                this.code(thenBody).else().code(elseBody).endIf();
            } else if (thenBody) {
                this.code(thenBody).endIf();
            } else if (elseBody) {
                throw new Error('CodeGen: "else" body without "then" body');
            }
            return this;
        }
        elseIf(condition) {
            return this._elseNode(new If(condition));
        }
        else() {
            return this._elseNode(new Else());
        }
        endIf() {
            return this._endBlockNode(If, Else);
        }
        _for(node, forBody) {
            this._blockNode(node);
            if (forBody) this.code(forBody).endFor();
            return this;
        }
        for(iteration, forBody) {
            return this._for(new ForLoop(iteration), forBody);
        }
        forRange(nameOrPrefix, from, to, forBody, varKind = this.opts.es5 ? scope.varKinds.var : scope.varKinds.let) {
            const name91 = this._scope.toName(nameOrPrefix);
            return this._for(new ForRange(varKind, name91, from, to), ()=>forBody(name91)
            );
        }
        forOf(nameOrPrefix, iterable, forBody, varKind = scope.varKinds.const) {
            const name92 = this._scope.toName(nameOrPrefix);
            if (this.opts.es5) {
                const arr = iterable instanceof code1.Name ? iterable : this.var("_arr", iterable);
                return this.forRange("_i", 0, code1._`${arr}.length`, (i45)=>{
                    this.var(name92, code1._`${arr}[${i45}]`);
                    forBody(name92);
                });
            }
            return this._for(new ForIter("of", varKind, name92, iterable), ()=>forBody(name92)
            );
        }
        forIn(nameOrPrefix, obj, forBody, varKind = this.opts.es5 ? scope.varKinds.var : scope.varKinds.const) {
            if (this.opts.ownProperties) {
                return this.forOf(nameOrPrefix, code1._`Object.keys(${obj})`, forBody);
            }
            const name93 = this._scope.toName(nameOrPrefix);
            return this._for(new ForIter("in", varKind, name93, obj), ()=>forBody(name93)
            );
        }
        endFor() {
            return this._endBlockNode(For);
        }
        label(label) {
            return this._leafNode(new Label(label));
        }
        break(label) {
            return this._leafNode(new Break(label));
        }
        return(value) {
            const node = new Return();
            this._blockNode(node);
            this.code(value);
            if (node.nodes.length !== 1) throw new Error('CodeGen: "return" should have one node');
            return this._endBlockNode(Return);
        }
        try(tryBody, catchCode, finallyCode) {
            if (!catchCode && !finallyCode) throw new Error('CodeGen: "try" without "catch" and "finally"');
            const node = new Try();
            this._blockNode(node);
            this.code(tryBody);
            if (catchCode) {
                const error18 = this.name("e");
                this._currNode = node.catch = new Catch(error18);
                catchCode(error18);
            }
            if (finallyCode) {
                this._currNode = node.finally = new Finally();
                this.code(finallyCode);
            }
            return this._endBlockNode(Catch, Finally);
        }
        throw(error19) {
            return this._leafNode(new Throw(error19));
        }
        block(body, nodeCount) {
            this._blockStarts.push(this._nodes.length);
            if (body) this.code(body).endBlock(nodeCount);
            return this;
        }
        endBlock(nodeCount) {
            const len2 = this._blockStarts.pop();
            if (len2 === void 0) throw new Error("CodeGen: not in self-balancing block");
            const toClose = this._nodes.length - len2;
            if (toClose < 0 || nodeCount !== void 0 && toClose !== nodeCount) {
                throw new Error(`CodeGen: wrong number of nodes: ${toClose} vs ${nodeCount} expected`);
            }
            this._nodes.length = len2;
            return this;
        }
        func(name94, args = code1.nil, async, funcBody) {
            this._blockNode(new Func(name94, args, async));
            if (funcBody) this.code(funcBody).endFunc();
            return this;
        }
        endFunc() {
            return this._endBlockNode(Func);
        }
        optimize(n10 = 1) {
            while(n10-- > 0){
                this._root.optimizeNodes();
                this._root.optimizeNames(this._root.names, this._constants);
            }
        }
        _leafNode(node) {
            this._currNode.nodes.push(node);
            return this;
        }
        _blockNode(node) {
            this._currNode.nodes.push(node);
            this._nodes.push(node);
        }
        _endBlockNode(N1, N2) {
            const n11 = this._currNode;
            if (n11 instanceof N1 || N2 && n11 instanceof N2) {
                this._nodes.pop();
                return this;
            }
            throw new Error(`CodeGen: not in block "${N2 ? `${N1.kind}/${N2.kind}` : N1.kind}"`);
        }
        _elseNode(node) {
            const n12 = this._currNode;
            if (!(n12 instanceof If)) {
                throw new Error('CodeGen: "else" without "if"');
            }
            this._currNode = n12.else = node;
            return this;
        }
        get _root() {
            return this._nodes[0];
        }
        get _currNode() {
            const ns = this._nodes;
            return ns[ns.length - 1];
        }
        set _currNode(node) {
            const ns = this._nodes;
            ns[ns.length - 1] = node;
        }
    }
    exports.CodeGen = CodeGen2;
    function addNames(names, from) {
        for(const n13 in from)names[n13] = (names[n13] || 0) + (from[n13] || 0);
        return names;
    }
    function addExprNames(names, from) {
        return from instanceof code1._CodeOrName ? addNames(names, from.names) : names;
    }
    function optimizeExpr(expr, names, constants) {
        if (expr instanceof code1.Name) return replaceName(expr);
        if (!canOptimize(expr)) return expr;
        return new code1._Code(expr._items.reduce((items2, c)=>{
            if (c instanceof code1.Name) c = replaceName(c);
            if (c instanceof code1._Code) items2.push(...c._items);
            else items2.push(c);
            return items2;
        }, []));
        function replaceName(n14) {
            const c = constants[n14.str];
            if (c === void 0 || names[n14.str] !== 1) return n14;
            delete names[n14.str];
            return c;
        }
        function canOptimize(e) {
            return e instanceof code1._Code && e._items.some((c)=>c instanceof code1.Name && names[c.str] === 1 && constants[c.str] !== void 0
            );
        }
    }
    function subtractNames(names, from) {
        for(const n15 in from)names[n15] = (names[n15] || 0) - (from[n15] || 0);
    }
    function not2(x) {
        return typeof x == "boolean" || typeof x == "number" || x === null ? !x : code1._`!${par(x)}`;
    }
    exports.not = not2;
    const andCode = mappend(exports.operators.AND);
    function and(...args) {
        return args.reduce(andCode);
    }
    exports.and = and;
    const orCode = mappend(exports.operators.OR);
    function or(...args) {
        return args.reduce(orCode);
    }
    exports.or = or;
    function mappend(op) {
        return (x, y)=>x === code1.nil ? y : y === code1.nil ? x : code1._`${par(x)} ${op} ${par(y)}`
        ;
    }
    function par(x) {
        return x instanceof code1.Name ? x : code1._`(${x})`;
    }
});
var util = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.checkStrictMode = exports.getErrorPath = exports.Type = exports.useFunc = exports.setEvaluated = exports.evaluatedPropsToName = exports.mergeEvaluated = exports.eachItem = exports.unescapeJsonPointer = exports.escapeJsonPointer = exports.escapeFragment = exports.unescapeFragment = exports.schemaRefOrVal = exports.schemaHasRulesButRef = exports.schemaHasRules = exports.checkUnknownRules = exports.alwaysValidSchema = exports.toHash = void 0;
    function toHash(arr) {
        const hash = {};
        for (const item of arr)hash[item] = true;
        return hash;
    }
    exports.toHash = toHash;
    function alwaysValidSchema(it, schema) {
        if (typeof schema == "boolean") return schema;
        if (Object.keys(schema).length === 0) return true;
        checkUnknownRules(it, schema);
        return !schemaHasRules(schema, it.self.RULES.all);
    }
    exports.alwaysValidSchema = alwaysValidSchema;
    function checkUnknownRules(it, schema = it.schema) {
        const { opts , self  } = it;
        if (!opts.strictSchema) return;
        if (typeof schema === "boolean") return;
        const rules2 = self.RULES.keywords;
        for(const key in schema){
            if (!rules2[key]) checkStrictMode(it, `unknown keyword: "${key}"`);
        }
    }
    exports.checkUnknownRules = checkUnknownRules;
    function schemaHasRules(schema, rules2) {
        if (typeof schema == "boolean") return !schema;
        for(const key in schema)if (rules2[key]) return true;
        return false;
    }
    exports.schemaHasRules = schemaHasRules;
    function schemaHasRulesButRef(schema, RULES) {
        if (typeof schema == "boolean") return !schema;
        for(const key in schema)if (key !== "$ref" && RULES.all[key]) return true;
        return false;
    }
    exports.schemaHasRulesButRef = schemaHasRulesButRef;
    function schemaRefOrVal({ topSchemaRef , schemaPath  }, schema, keyword2, $data) {
        if (!$data) {
            if (typeof schema == "number" || typeof schema == "boolean") return schema;
            if (typeof schema == "string") return codegen._`${schema}`;
        }
        return codegen._`${topSchemaRef}${schemaPath}${(0, codegen.getProperty)(keyword2)}`;
    }
    exports.schemaRefOrVal = schemaRefOrVal;
    function unescapeFragment(str2) {
        return unescapeJsonPointer(decodeURIComponent(str2));
    }
    exports.unescapeFragment = unescapeFragment;
    function escapeFragment(str2) {
        return encodeURIComponent(escapeJsonPointer(str2));
    }
    exports.escapeFragment = escapeFragment;
    function escapeJsonPointer(str2) {
        if (typeof str2 == "number") return `${str2}`;
        return str2.replace(/~/g, "~0").replace(/\//g, "~1");
    }
    exports.escapeJsonPointer = escapeJsonPointer;
    function unescapeJsonPointer(str2) {
        return str2.replace(/~1/g, "/").replace(/~0/g, "~");
    }
    exports.unescapeJsonPointer = unescapeJsonPointer;
    function eachItem(xs, f) {
        if (Array.isArray(xs)) {
            for (const x of xs)f(x);
        } else {
            f(xs);
        }
    }
    exports.eachItem = eachItem;
    function makeMergeEvaluated({ mergeNames , mergeToName , mergeValues , resultToName  }) {
        return (gen, from, to, toName)=>{
            const res = to === void 0 ? from : to instanceof codegen.Name ? (from instanceof codegen.Name ? mergeNames(gen, from, to) : mergeToName(gen, from, to), to) : from instanceof codegen.Name ? (mergeToName(gen, to, from), from) : mergeValues(from, to);
            return toName === codegen.Name && !(res instanceof codegen.Name) ? resultToName(gen, res) : res;
        };
    }
    exports.mergeEvaluated = {
        props: makeMergeEvaluated({
            mergeNames: (gen, from, to)=>gen.if(codegen._`${to} !== true && ${from} !== undefined`, ()=>{
                    gen.if(codegen._`${from} === true`, ()=>gen.assign(to, true)
                    , ()=>gen.assign(to, codegen._`${to} || {}`).code(codegen._`Object.assign(${to}, ${from})`)
                    );
                })
            ,
            mergeToName: (gen, from, to)=>gen.if(codegen._`${to} !== true`, ()=>{
                    if (from === true) {
                        gen.assign(to, true);
                    } else {
                        gen.assign(to, codegen._`${to} || {}`);
                        setEvaluated(gen, to, from);
                    }
                })
            ,
            mergeValues: (from, to)=>from === true ? true : {
                    ...from,
                    ...to
                }
            ,
            resultToName: evaluatedPropsToName
        }),
        items: makeMergeEvaluated({
            mergeNames: (gen, from, to)=>gen.if(codegen._`${to} !== true && ${from} !== undefined`, ()=>gen.assign(to, codegen._`${from} === true ? true : ${to} > ${from} ? ${to} : ${from}`)
                )
            ,
            mergeToName: (gen, from, to)=>gen.if(codegen._`${to} !== true`, ()=>gen.assign(to, from === true ? true : codegen._`${to} > ${from} ? ${to} : ${from}`)
                )
            ,
            mergeValues: (from, to)=>from === true ? true : Math.max(from, to)
            ,
            resultToName: (gen, items2)=>gen.var("items", items2)
        })
    };
    function evaluatedPropsToName(gen, ps) {
        if (ps === true) return gen.var("props", true);
        const props = gen.var("props", codegen._`{}`);
        if (ps !== void 0) setEvaluated(gen, props, ps);
        return props;
    }
    exports.evaluatedPropsToName = evaluatedPropsToName;
    function setEvaluated(gen, props, ps) {
        Object.keys(ps).forEach((p)=>gen.assign(codegen._`${props}${(0, codegen.getProperty)(p)}`, true)
        );
    }
    exports.setEvaluated = setEvaluated;
    const snippets = {};
    function useFunc(gen, f) {
        return gen.scopeValue("func", {
            ref: f,
            code: snippets[f.code] || (snippets[f.code] = new code1._Code(f.code))
        });
    }
    exports.useFunc = useFunc;
    var Type2;
    (function(Type2) {
        Type2[Type2["Num"] = 0] = "Num";
        Type2[Type2["Str"] = 1] = "Str";
    })(Type2 = exports.Type || (exports.Type = {}));
    function getErrorPath(dataProp, dataPropType, jsPropertySyntax) {
        if (dataProp instanceof codegen.Name) {
            const isNumber1 = dataPropType === Type2.Num;
            return jsPropertySyntax ? isNumber1 ? codegen._`"[" + ${dataProp} + "]"` : codegen._`"['" + ${dataProp} + "']"` : isNumber1 ? codegen._`"/" + ${dataProp}` : codegen._`"/" + ${dataProp}.replace(/~/g, "~0").replace(/\\//g, "~1")`;
        }
        return jsPropertySyntax ? (0, codegen.getProperty)(dataProp).toString() : "/" + escapeJsonPointer(dataProp);
    }
    exports.getErrorPath = getErrorPath;
    function checkStrictMode(it, msg, mode = it.opts.strictSchema) {
        if (!mode) return;
        msg = `strict mode: ${msg}`;
        if (mode === true) throw new Error(msg);
        it.self.logger.warn(msg);
    }
    exports.checkStrictMode = checkStrictMode;
});
var names_1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const names = {
        data: new codegen.Name("data"),
        valCxt: new codegen.Name("valCxt"),
        instancePath: new codegen.Name("instancePath"),
        parentData: new codegen.Name("parentData"),
        parentDataProperty: new codegen.Name("parentDataProperty"),
        rootData: new codegen.Name("rootData"),
        dynamicAnchors: new codegen.Name("dynamicAnchors"),
        vErrors: new codegen.Name("vErrors"),
        errors: new codegen.Name("errors"),
        this: new codegen.Name("this"),
        self: new codegen.Name("self"),
        scope: new codegen.Name("scope"),
        json: new codegen.Name("json"),
        jsonPos: new codegen.Name("jsonPos"),
        jsonLen: new codegen.Name("jsonLen"),
        jsonPart: new codegen.Name("jsonPart")
    };
    exports.default = names;
});
var errors = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.extendErrors = exports.resetErrorsCount = exports.reportExtraError = exports.reportError = exports.keyword$DataError = exports.keywordError = void 0;
    exports.keywordError = {
        message: ({ keyword: keyword2  })=>codegen.str`must pass "${keyword2}" keyword validation`
    };
    exports.keyword$DataError = {
        message: ({ keyword: keyword2 , schemaType: schemaType1  })=>schemaType1 ? codegen.str`"${keyword2}" keyword must be ${schemaType1} ($data)` : codegen.str`"${keyword2}" keyword is invalid ($data)`
    };
    function reportError(cxt, error20 = exports.keywordError, errorPaths, overrideAllErrors) {
        const { it  } = cxt;
        const { gen , compositeRule , allErrors  } = it;
        const errObj = errorObjectCode(cxt, error20, errorPaths);
        if (overrideAllErrors !== null && overrideAllErrors !== void 0 ? overrideAllErrors : compositeRule || allErrors) {
            addError(gen, errObj);
        } else {
            returnErrors(it, codegen._`[${errObj}]`);
        }
    }
    exports.reportError = reportError;
    function reportExtraError(cxt, error21 = exports.keywordError, errorPaths) {
        const { it  } = cxt;
        const { gen , compositeRule , allErrors  } = it;
        const errObj = errorObjectCode(cxt, error21, errorPaths);
        addError(gen, errObj);
        if (!(compositeRule || allErrors)) {
            returnErrors(it, names_1.default.vErrors);
        }
    }
    exports.reportExtraError = reportExtraError;
    function resetErrorsCount(gen, errsCount) {
        gen.assign(names_1.default.errors, errsCount);
        gen.if(codegen._`${names_1.default.vErrors} !== null`, ()=>gen.if(errsCount, ()=>gen.assign(codegen._`${names_1.default.vErrors}.length`, errsCount)
            , ()=>gen.assign(names_1.default.vErrors, null)
            )
        );
    }
    exports.resetErrorsCount = resetErrorsCount;
    function extendErrors({ gen , keyword: keyword2 , schemaValue , data: data44 , errsCount , it  }) {
        if (errsCount === void 0) throw new Error("ajv implementation error");
        const err = gen.name("err");
        gen.forRange("i", errsCount, names_1.default.errors, (i46)=>{
            gen.const(err, codegen._`${names_1.default.vErrors}[${i46}]`);
            gen.if(codegen._`${err}.instancePath === undefined`, ()=>gen.assign(codegen._`${err}.instancePath`, (0, codegen.strConcat)(names_1.default.instancePath, it.errorPath))
            );
            gen.assign(codegen._`${err}.schemaPath`, codegen.str`${it.errSchemaPath}/${keyword2}`);
            if (it.opts.verbose) {
                gen.assign(codegen._`${err}.schema`, schemaValue);
                gen.assign(codegen._`${err}.data`, data44);
            }
        });
    }
    exports.extendErrors = extendErrors;
    function addError(gen, errObj) {
        const err = gen.const("err", errObj);
        gen.if(codegen._`${names_1.default.vErrors} === null`, ()=>gen.assign(names_1.default.vErrors, codegen._`[${err}]`)
        , codegen._`${names_1.default.vErrors}.push(${err})`);
        gen.code(codegen._`${names_1.default.errors}++`);
    }
    function returnErrors(it, errs) {
        const { gen , validateName , schemaEnv  } = it;
        if (schemaEnv.$async) {
            gen.throw(codegen._`new ${it.ValidationError}(${errs})`);
        } else {
            gen.assign(codegen._`${validateName}.errors`, errs);
            gen.return(false);
        }
    }
    const E = {
        keyword: new codegen.Name("keyword"),
        schemaPath: new codegen.Name("schemaPath"),
        params: new codegen.Name("params"),
        propertyName: new codegen.Name("propertyName"),
        message: new codegen.Name("message"),
        schema: new codegen.Name("schema"),
        parentSchema: new codegen.Name("parentSchema")
    };
    function errorObjectCode(cxt, error22, errorPaths) {
        const { createErrors  } = cxt.it;
        if (createErrors === false) return codegen._`{}`;
        return errorObject(cxt, error22, errorPaths);
    }
    function errorObject(cxt, error23, errorPaths = {}) {
        const { gen , it  } = cxt;
        const keyValues = [
            errorInstancePath(it, errorPaths),
            errorSchemaPath(cxt, errorPaths)
        ];
        extraErrorProps(cxt, error23, keyValues);
        return gen.object(...keyValues);
    }
    function errorInstancePath({ errorPath  }, { instancePath  }) {
        const instPath = instancePath ? codegen.str`${errorPath}${(0, util.getErrorPath)(instancePath, util.Type.Str)}` : errorPath;
        return [
            names_1.default.instancePath,
            (0, codegen.strConcat)(names_1.default.instancePath, instPath)
        ];
    }
    function errorSchemaPath({ keyword: keyword2 , it: { errSchemaPath  }  }, { schemaPath , parentSchema  }) {
        let schPath = parentSchema ? errSchemaPath : codegen.str`${errSchemaPath}/${keyword2}`;
        if (schemaPath) {
            schPath = codegen.str`${schPath}${(0, util.getErrorPath)(schemaPath, util.Type.Str)}`;
        }
        return [
            E.schemaPath,
            schPath
        ];
    }
    function extraErrorProps(cxt, { params , message  }, keyValues) {
        const { keyword: keyword2 , data: data45 , schemaValue , it  } = cxt;
        const { opts , propertyName , topSchemaRef , schemaPath  } = it;
        keyValues.push([
            E.keyword,
            keyword2
        ], [
            E.params,
            typeof params == "function" ? params(cxt) : params || codegen._`{}`
        ]);
        if (opts.messages) {
            keyValues.push([
                E.message,
                typeof message == "function" ? message(cxt) : message
            ]);
        }
        if (opts.verbose) {
            keyValues.push([
                E.schema,
                schemaValue
            ], [
                E.parentSchema,
                codegen._`${topSchemaRef}${schemaPath}`
            ], [
                names_1.default.data,
                data45
            ]);
        }
        if (propertyName) keyValues.push([
            E.propertyName,
            propertyName
        ]);
    }
});
var boolSchema = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.boolOrEmptySchema = exports.topBoolOrEmptySchema = void 0;
    const boolError = {
        message: "boolean schema is false"
    };
    function topBoolOrEmptySchema(it) {
        const { gen , schema , validateName  } = it;
        if (schema === false) {
            falseSchemaError(it, false);
        } else if (typeof schema == "object" && schema.$async === true) {
            gen.return(names_1.default.data);
        } else {
            gen.assign(codegen._`${validateName}.errors`, null);
            gen.return(true);
        }
    }
    exports.topBoolOrEmptySchema = topBoolOrEmptySchema;
    function boolOrEmptySchema(it, valid) {
        const { gen , schema  } = it;
        if (schema === false) {
            gen.var(valid, false);
            falseSchemaError(it);
        } else {
            gen.var(valid, true);
        }
    }
    exports.boolOrEmptySchema = boolOrEmptySchema;
    function falseSchemaError(it, overrideAllErrors) {
        const { gen , data: data46  } = it;
        const cxt = {
            gen,
            keyword: "false schema",
            data: data46,
            schema: false,
            schemaCode: false,
            schemaValue: false,
            params: {},
            it
        };
        (0, errors.reportError)(cxt, boolError, void 0, overrideAllErrors);
    }
});
var rules = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getRules = exports.isJSONType = void 0;
    const _jsonTypes = [
        "string",
        "number",
        "integer",
        "boolean",
        "null",
        "object",
        "array"
    ];
    const jsonTypes = new Set(_jsonTypes);
    function isJSONType(x) {
        return typeof x == "string" && jsonTypes.has(x);
    }
    exports.isJSONType = isJSONType;
    function getRules() {
        const groups = {
            number: {
                type: "number",
                rules: []
            },
            string: {
                type: "string",
                rules: []
            },
            array: {
                type: "array",
                rules: []
            },
            object: {
                type: "object",
                rules: []
            }
        };
        return {
            types: {
                ...groups,
                integer: true,
                boolean: true,
                null: true
            },
            rules: [
                {
                    rules: []
                },
                groups.number,
                groups.string,
                groups.array,
                groups.object
            ],
            post: {
                rules: []
            },
            all: {},
            keywords: {}
        };
    }
    exports.getRules = getRules;
});
var applicability = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.shouldUseRule = exports.shouldUseGroup = exports.schemaHasRulesForType = void 0;
    function schemaHasRulesForType({ schema , self  }, type2) {
        const group = self.RULES.types[type2];
        return group && group !== true && shouldUseGroup(schema, group);
    }
    exports.schemaHasRulesForType = schemaHasRulesForType;
    function shouldUseGroup(schema, group) {
        return group.rules.some((rule)=>shouldUseRule(schema, rule)
        );
    }
    exports.shouldUseGroup = shouldUseGroup;
    function shouldUseRule(schema, rule) {
        var _a;
        return schema[rule.keyword] !== void 0 || ((_a = rule.definition.implements) === null || _a === void 0 ? void 0 : _a.some((kwd)=>schema[kwd] !== void 0
        ));
    }
    exports.shouldUseRule = shouldUseRule;
});
var dataType = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.reportTypeError = exports.checkDataTypes = exports.checkDataType = exports.coerceAndCheckDataType = exports.getJSONTypes = exports.getSchemaTypes = exports.DataType = void 0;
    var DataType;
    (function(DataType2) {
        DataType2[DataType2["Correct"] = 0] = "Correct";
        DataType2[DataType2["Wrong"] = 1] = "Wrong";
    })(DataType = exports.DataType || (exports.DataType = {}));
    function getSchemaTypes(schema) {
        const types2 = getJSONTypes(schema.type);
        const hasNull = types2.includes("null");
        if (hasNull) {
            if (schema.nullable === false) throw new Error("type: null contradicts nullable: false");
        } else {
            if (!types2.length && schema.nullable !== void 0) {
                throw new Error('"nullable" cannot be used without "type"');
            }
            if (schema.nullable === true) types2.push("null");
        }
        return types2;
    }
    exports.getSchemaTypes = getSchemaTypes;
    function getJSONTypes(ts) {
        const types2 = Array.isArray(ts) ? ts : ts ? [
            ts
        ] : [];
        if (types2.every(rules.isJSONType)) return types2;
        throw new Error("type must be JSONType or JSONType[]: " + types2.join(","));
    }
    exports.getJSONTypes = getJSONTypes;
    function coerceAndCheckDataType(it, types2) {
        const { gen , data: data47 , opts  } = it;
        const coerceTo = coerceToTypes(types2, opts.coerceTypes);
        const checkTypes = types2.length > 0 && !(coerceTo.length === 0 && types2.length === 1 && (0, applicability.schemaHasRulesForType)(it, types2[0]));
        if (checkTypes) {
            const wrongType = checkDataTypes(types2, data47, opts.strictNumbers, DataType.Wrong);
            gen.if(wrongType, ()=>{
                if (coerceTo.length) coerceData(it, types2, coerceTo);
                else reportTypeError(it);
            });
        }
        return checkTypes;
    }
    exports.coerceAndCheckDataType = coerceAndCheckDataType;
    const COERCIBLE = new Set([
        "string",
        "number",
        "integer",
        "boolean",
        "null"
    ]);
    function coerceToTypes(types2, coerceTypes) {
        return coerceTypes ? types2.filter((t)=>COERCIBLE.has(t) || coerceTypes === "array" && t === "array"
        ) : [];
    }
    function coerceData(it, types2, coerceTo) {
        const { gen , data: data48 , opts  } = it;
        const dataType2 = gen.let("dataType", codegen._`typeof ${data48}`);
        const coerced = gen.let("coerced", codegen._`undefined`);
        if (opts.coerceTypes === "array") {
            gen.if(codegen._`${dataType2} == 'object' && Array.isArray(${data48}) && ${data48}.length == 1`, ()=>gen.assign(data48, codegen._`${data48}[0]`).assign(dataType2, codegen._`typeof ${data48}`).if(checkDataTypes(types2, data48, opts.strictNumbers), ()=>gen.assign(coerced, data48)
                )
            );
        }
        gen.if(codegen._`${coerced} !== undefined`);
        for (const t1 of coerceTo){
            if (COERCIBLE.has(t1) || t1 === "array" && opts.coerceTypes === "array") {
                coerceSpecificType(t1);
            }
        }
        gen.else();
        reportTypeError(it);
        gen.endIf();
        gen.if(codegen._`${coerced} !== undefined`, ()=>{
            gen.assign(data48, coerced);
            assignParentData(it, coerced);
        });
        function coerceSpecificType(t) {
            switch(t){
                case "string":
                    gen.elseIf(codegen._`${dataType2} == "number" || ${dataType2} == "boolean"`).assign(coerced, codegen._`"" + ${data48}`).elseIf(codegen._`${data48} === null`).assign(coerced, codegen._`""`);
                    return;
                case "number":
                    gen.elseIf(codegen._`${dataType2} == "boolean" || ${data48} === null
              || (${dataType2} == "string" && ${data48} && ${data48} == +${data48})`).assign(coerced, codegen._`+${data48}`);
                    return;
                case "integer":
                    gen.elseIf(codegen._`${dataType2} === "boolean" || ${data48} === null
              || (${dataType2} === "string" && ${data48} && ${data48} == +${data48} && !(${data48} % 1))`).assign(coerced, codegen._`+${data48}`);
                    return;
                case "boolean":
                    gen.elseIf(codegen._`${data48} === "false" || ${data48} === 0 || ${data48} === null`).assign(coerced, false).elseIf(codegen._`${data48} === "true" || ${data48} === 1`).assign(coerced, true);
                    return;
                case "null":
                    gen.elseIf(codegen._`${data48} === "" || ${data48} === 0 || ${data48} === false`);
                    gen.assign(coerced, null);
                    return;
                case "array":
                    gen.elseIf(codegen._`${dataType2} === "string" || ${dataType2} === "number"
              || ${dataType2} === "boolean" || ${data48} === null`).assign(coerced, codegen._`[${data48}]`);
            }
        }
    }
    function assignParentData({ gen , parentData , parentDataProperty  }, expr) {
        gen.if(codegen._`${parentData} !== undefined`, ()=>gen.assign(codegen._`${parentData}[${parentDataProperty}]`, expr)
        );
    }
    function checkDataType(dataType2, data49, strictNums, correct = DataType.Correct) {
        const EQ = correct === DataType.Correct ? codegen.operators.EQ : codegen.operators.NEQ;
        let cond;
        switch(dataType2){
            case "null":
                return codegen._`${data49} ${EQ} null`;
            case "array":
                cond = codegen._`Array.isArray(${data49})`;
                break;
            case "object":
                cond = codegen._`${data49} && typeof ${data49} == "object" && !Array.isArray(${data49})`;
                break;
            case "integer":
                cond = numCond(codegen._`!(${data49} % 1) && !isNaN(${data49})`);
                break;
            case "number":
                cond = numCond();
                break;
            default:
                return codegen._`typeof ${data49} ${EQ} ${dataType2}`;
        }
        return correct === DataType.Correct ? cond : (0, codegen.not)(cond);
        function numCond(_cond = codegen.nil) {
            return (0, codegen.and)(codegen._`typeof ${data49} == "number"`, _cond, strictNums ? codegen._`isFinite(${data49})` : codegen.nil);
        }
    }
    exports.checkDataType = checkDataType;
    function checkDataTypes(dataTypes, data50, strictNums, correct) {
        if (dataTypes.length === 1) {
            return checkDataType(dataTypes[0], data50, strictNums, correct);
        }
        let cond;
        const types2 = (0, util.toHash)(dataTypes);
        if (types2.array && types2.object) {
            const notObj = codegen._`typeof ${data50} != "object"`;
            cond = types2.null ? notObj : codegen._`!${data50} || ${notObj}`;
            delete types2.null;
            delete types2.array;
            delete types2.object;
        } else {
            cond = codegen.nil;
        }
        if (types2.number) delete types2.integer;
        for(const t in types2)cond = (0, codegen.and)(cond, checkDataType(t, data50, strictNums, correct));
        return cond;
    }
    exports.checkDataTypes = checkDataTypes;
    const typeError = {
        message: ({ schema  })=>`must be ${schema}`
        ,
        params: ({ schema , schemaValue  })=>typeof schema == "string" ? codegen._`{type: ${schema}}` : codegen._`{type: ${schemaValue}}`
    };
    function reportTypeError(it) {
        const cxt = getTypeErrorContext(it);
        (0, errors.reportError)(cxt, typeError);
    }
    exports.reportTypeError = reportTypeError;
    function getTypeErrorContext(it) {
        const { gen , data: data51 , schema  } = it;
        const schemaCode = (0, util.schemaRefOrVal)(it, schema, "type");
        return {
            gen,
            keyword: "type",
            data: data51,
            schema: schema.type,
            schemaCode,
            schemaValue: schemaCode,
            parentSchema: schema,
            params: {},
            it
        };
    }
});
var defaults = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.assignDefaults = void 0;
    function assignDefaults(it, ty) {
        const { properties: properties2 , items: items2  } = it.schema;
        if (ty === "object" && properties2) {
            for(const key in properties2){
                assignDefault(it, key, properties2[key].default);
            }
        } else if (ty === "array" && Array.isArray(items2)) {
            items2.forEach((sch, i47)=>assignDefault(it, i47, sch.default)
            );
        }
    }
    exports.assignDefaults = assignDefaults;
    function assignDefault(it, prop, defaultValue) {
        const { gen , compositeRule , data: data52 , opts  } = it;
        if (defaultValue === void 0) return;
        const childData = codegen._`${data52}${(0, codegen.getProperty)(prop)}`;
        if (compositeRule) {
            (0, util.checkStrictMode)(it, `default is ignored for: ${childData}`);
            return;
        }
        let condition = codegen._`${childData} === undefined`;
        if (opts.useDefaults === "empty") {
            condition = codegen._`${condition} || ${childData} === null || ${childData} === ""`;
        }
        gen.if(condition, codegen._`${childData} = ${(0, codegen.stringify)(defaultValue)}`);
    }
});
var code$1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.validateUnion = exports.validateArray = exports.usePattern = exports.callValidateCode = exports.schemaProperties = exports.allSchemaProperties = exports.noPropertyInData = exports.propertyInData = exports.isOwnProperty = exports.hasPropFunc = exports.reportMissingProp = exports.checkMissingProp = exports.checkReportMissingProp = void 0;
    const util_2 = util;
    function checkReportMissingProp(cxt, prop) {
        const { gen , data: data53 , it  } = cxt;
        gen.if(noPropertyInData(gen, data53, prop, it.opts.ownProperties), ()=>{
            cxt.setParams({
                missingProperty: codegen._`${prop}`
            }, true);
            cxt.error();
        });
    }
    exports.checkReportMissingProp = checkReportMissingProp;
    function checkMissingProp({ gen , data: data54 , it: { opts  }  }, properties2, missing) {
        return (0, codegen.or)(...properties2.map((prop)=>(0, codegen.and)(noPropertyInData(gen, data54, prop, opts.ownProperties), codegen._`${missing} = ${prop}`)
        ));
    }
    exports.checkMissingProp = checkMissingProp;
    function reportMissingProp(cxt, missing) {
        cxt.setParams({
            missingProperty: missing
        }, true);
        cxt.error();
    }
    exports.reportMissingProp = reportMissingProp;
    function hasPropFunc(gen) {
        return gen.scopeValue("func", {
            ref: Object.prototype.hasOwnProperty,
            code: codegen._`Object.prototype.hasOwnProperty`
        });
    }
    exports.hasPropFunc = hasPropFunc;
    function isOwnProperty(gen, data55, property2) {
        return codegen._`${hasPropFunc(gen)}.call(${data55}, ${property2})`;
    }
    exports.isOwnProperty = isOwnProperty;
    function propertyInData(gen, data56, property3, ownProperties) {
        const cond = codegen._`${data56}${(0, codegen.getProperty)(property3)} !== undefined`;
        return ownProperties ? codegen._`${cond} && ${isOwnProperty(gen, data56, property3)}` : cond;
    }
    exports.propertyInData = propertyInData;
    function noPropertyInData(gen, data57, property4, ownProperties) {
        const cond = codegen._`${data57}${(0, codegen.getProperty)(property4)} === undefined`;
        return ownProperties ? (0, codegen.or)(cond, (0, codegen.not)(isOwnProperty(gen, data57, property4))) : cond;
    }
    exports.noPropertyInData = noPropertyInData;
    function allSchemaProperties(schemaMap) {
        return schemaMap ? Object.keys(schemaMap).filter((p)=>p !== "__proto__"
        ) : [];
    }
    exports.allSchemaProperties = allSchemaProperties;
    function schemaProperties(it, schemaMap) {
        return allSchemaProperties(schemaMap).filter((p)=>!(0, util.alwaysValidSchema)(it, schemaMap[p])
        );
    }
    exports.schemaProperties = schemaProperties;
    function callValidateCode({ schemaCode , data: data58 , it: { gen , topSchemaRef , schemaPath , errorPath  } , it  }, func, context, passSchema) {
        const dataAndSchema = passSchema ? codegen._`${schemaCode}, ${data58}, ${topSchemaRef}${schemaPath}` : data58;
        const valCxt = [
            [
                names_1.default.instancePath,
                (0, codegen.strConcat)(names_1.default.instancePath, errorPath)
            ],
            [
                names_1.default.parentData,
                it.parentData
            ],
            [
                names_1.default.parentDataProperty,
                it.parentDataProperty
            ],
            [
                names_1.default.rootData,
                names_1.default.rootData
            ]
        ];
        if (it.opts.dynamicRef) valCxt.push([
            names_1.default.dynamicAnchors,
            names_1.default.dynamicAnchors
        ]);
        const args = codegen._`${dataAndSchema}, ${gen.object(...valCxt)}`;
        return context !== codegen.nil ? codegen._`${func}.call(${context}, ${args})` : codegen._`${func}(${args})`;
    }
    exports.callValidateCode = callValidateCode;
    const newRegExp = codegen._`new RegExp`;
    function usePattern({ gen , it: { opts  }  }, pattern2) {
        const u = opts.unicodeRegExp ? "u" : "";
        const { regExp  } = opts.code;
        const rx = regExp(pattern2, u);
        return gen.scopeValue("pattern", {
            key: rx.toString(),
            ref: rx,
            code: codegen._`${regExp.code === "new RegExp" ? newRegExp : (0, util_2.useFunc)(gen, regExp)}(${pattern2}, ${u})`
        });
    }
    exports.usePattern = usePattern;
    function validateArray(cxt) {
        const { gen , data: data59 , keyword: keyword2 , it  } = cxt;
        const valid = gen.name("valid");
        if (it.allErrors) {
            const validArr = gen.let("valid", true);
            validateItems(()=>gen.assign(validArr, false)
            );
            return validArr;
        }
        gen.var(valid, true);
        validateItems(()=>gen.break()
        );
        return valid;
        function validateItems(notValid) {
            const len3 = gen.const("len", codegen._`${data59}.length`);
            gen.forRange("i", 0, len3, (i48)=>{
                cxt.subschema({
                    keyword: keyword2,
                    dataProp: i48,
                    dataPropType: util.Type.Num
                }, valid);
                gen.if((0, codegen.not)(valid), notValid);
            });
        }
    }
    exports.validateArray = validateArray;
    function validateUnion(cxt) {
        const { gen , schema , keyword: keyword2 , it  } = cxt;
        if (!Array.isArray(schema)) throw new Error("ajv implementation error");
        const alwaysValid = schema.some((sch)=>(0, util.alwaysValidSchema)(it, sch)
        );
        if (alwaysValid && !it.opts.unevaluated) return;
        const valid = gen.let("valid", false);
        const schValid = gen.name("_valid");
        gen.block(()=>schema.forEach((_sch, i49)=>{
                const schCxt = cxt.subschema({
                    keyword: keyword2,
                    schemaProp: i49,
                    compositeRule: true
                }, schValid);
                gen.assign(valid, codegen._`${valid} || ${schValid}`);
                const merged = cxt.mergeValidEvaluated(schCxt, schValid);
                if (!merged) gen.if((0, codegen.not)(valid));
            })
        );
        cxt.result(valid, ()=>cxt.reset()
        , ()=>cxt.error(true)
        );
    }
    exports.validateUnion = validateUnion;
});
var keyword = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.validateKeywordUsage = exports.validSchemaType = exports.funcKeywordCode = exports.macroKeywordCode = void 0;
    function macroKeywordCode(cxt, def2) {
        const { gen , keyword: keyword2 , schema , parentSchema , it  } = cxt;
        const macroSchema = def2.macro.call(it.self, schema, parentSchema, it);
        const schemaRef = useKeyword(gen, keyword2, macroSchema);
        if (it.opts.validateSchema !== false) it.self.validateSchema(macroSchema, true);
        const valid = gen.name("valid");
        cxt.subschema({
            schema: macroSchema,
            schemaPath: codegen.nil,
            errSchemaPath: `${it.errSchemaPath}/${keyword2}`,
            topSchemaRef: schemaRef,
            compositeRule: true
        }, valid);
        cxt.pass(valid, ()=>cxt.error(true)
        );
    }
    exports.macroKeywordCode = macroKeywordCode;
    function funcKeywordCode(cxt, def3) {
        var _a;
        const { gen , keyword: keyword2 , schema , parentSchema , $data , it  } = cxt;
        checkAsyncKeyword(it, def3);
        const validate2 = !$data && def3.compile ? def3.compile.call(it.self, schema, parentSchema, it) : def3.validate;
        const validateRef = useKeyword(gen, keyword2, validate2);
        const valid = gen.let("valid");
        cxt.block$data(valid, validateKeyword);
        cxt.ok((_a = def3.valid) !== null && _a !== void 0 ? _a : valid);
        function validateKeyword() {
            if (def3.errors === false) {
                assignValid();
                if (def3.modifying) modifyData(cxt);
                reportErrs(()=>cxt.error()
                );
            } else {
                const ruleErrs = def3.async ? validateAsync() : validateSync();
                if (def3.modifying) modifyData(cxt);
                reportErrs(()=>addErrs(cxt, ruleErrs)
                );
            }
        }
        function validateAsync() {
            const ruleErrs = gen.let("ruleErrs", null);
            gen.try(()=>assignValid(codegen._`await `)
            , (e)=>gen.assign(valid, false).if(codegen._`${e} instanceof ${it.ValidationError}`, ()=>gen.assign(ruleErrs, codegen._`${e}.errors`)
                , ()=>gen.throw(e)
                )
            );
            return ruleErrs;
        }
        function validateSync() {
            const validateErrs = codegen._`${validateRef}.errors`;
            gen.assign(validateErrs, null);
            assignValid(codegen.nil);
            return validateErrs;
        }
        function assignValid(_await = def3.async ? codegen._`await ` : codegen.nil) {
            const passCxt = it.opts.passContext ? names_1.default.this : names_1.default.self;
            const passSchema = !("compile" in def3 && !$data || def3.schema === false);
            gen.assign(valid, codegen._`${_await}${(0, code$1.callValidateCode)(cxt, validateRef, passCxt, passSchema)}`, def3.modifying);
        }
        function reportErrs(errors2) {
            var _a2;
            gen.if((0, codegen.not)((_a2 = def3.valid) !== null && _a2 !== void 0 ? _a2 : valid), errors2);
        }
    }
    exports.funcKeywordCode = funcKeywordCode;
    function modifyData(cxt) {
        const { gen , data: data60 , it  } = cxt;
        gen.if(it.parentData, ()=>gen.assign(data60, codegen._`${it.parentData}[${it.parentDataProperty}]`)
        );
    }
    function addErrs(cxt, errs) {
        const { gen  } = cxt;
        gen.if(codegen._`Array.isArray(${errs})`, ()=>{
            gen.assign(names_1.default.vErrors, codegen._`${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`).assign(names_1.default.errors, codegen._`${names_1.default.vErrors}.length`);
            (0, errors.extendErrors)(cxt);
        }, ()=>cxt.error()
        );
    }
    function checkAsyncKeyword({ schemaEnv  }, def4) {
        if (def4.async && !schemaEnv.$async) throw new Error("async keyword in sync schema");
    }
    function useKeyword(gen, keyword2, result) {
        if (result === void 0) throw new Error(`keyword "${keyword2}" failed to compile`);
        return gen.scopeValue("keyword", typeof result == "function" ? {
            ref: result
        } : {
            ref: result,
            code: (0, codegen.stringify)(result)
        });
    }
    function validSchemaType(schema, schemaType2, allowUndefined = false) {
        return !schemaType2.length || schemaType2.some((st)=>st === "array" ? Array.isArray(schema) : st === "object" ? schema && typeof schema == "object" && !Array.isArray(schema) : typeof schema == st || allowUndefined && typeof schema == "undefined"
        );
    }
    exports.validSchemaType = validSchemaType;
    function validateKeywordUsage({ schema , opts , self , errSchemaPath  }, def5, keyword2) {
        if (Array.isArray(def5.keyword) ? !def5.keyword.includes(keyword2) : def5.keyword !== keyword2) {
            throw new Error("ajv implementation error");
        }
        const deps = def5.dependencies;
        if (deps === null || deps === void 0 ? void 0 : deps.some((kwd)=>!Object.prototype.hasOwnProperty.call(schema, kwd)
        )) {
            throw new Error(`parent schema must have dependencies of ${keyword2}: ${deps.join(",")}`);
        }
        if (def5.validateSchema) {
            const valid = def5.validateSchema(schema[keyword2]);
            if (!valid) {
                const msg = `keyword "${keyword2}" value is invalid at path "${errSchemaPath}": ` + self.errorsText(def5.validateSchema.errors);
                if (opts.validateSchema === "log") self.logger.error(msg);
                else throw new Error(msg);
            }
        }
    }
    exports.validateKeywordUsage = validateKeywordUsage;
});
var subschema = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.extendSubschemaMode = exports.extendSubschemaData = exports.getSubschema = void 0;
    function getSubschema(it, { keyword: keyword2 , schemaProp , schema , schemaPath , errSchemaPath , topSchemaRef  }) {
        if (keyword2 !== void 0 && schema !== void 0) {
            throw new Error('both "keyword" and "schema" passed, only one allowed');
        }
        if (keyword2 !== void 0) {
            const sch = it.schema[keyword2];
            return schemaProp === void 0 ? {
                schema: sch,
                schemaPath: codegen._`${it.schemaPath}${(0, codegen.getProperty)(keyword2)}`,
                errSchemaPath: `${it.errSchemaPath}/${keyword2}`
            } : {
                schema: sch[schemaProp],
                schemaPath: codegen._`${it.schemaPath}${(0, codegen.getProperty)(keyword2)}${(0, codegen.getProperty)(schemaProp)}`,
                errSchemaPath: `${it.errSchemaPath}/${keyword2}/${(0, util.escapeFragment)(schemaProp)}`
            };
        }
        if (schema !== void 0) {
            if (schemaPath === void 0 || errSchemaPath === void 0 || topSchemaRef === void 0) {
                throw new Error('"schemaPath", "errSchemaPath" and "topSchemaRef" are required with "schema"');
            }
            return {
                schema,
                schemaPath,
                topSchemaRef,
                errSchemaPath
            };
        }
        throw new Error('either "keyword" or "schema" must be passed');
    }
    exports.getSubschema = getSubschema;
    function extendSubschemaData(subschema2, it, { dataProp , dataPropType: dpType , data: data61 , dataTypes , propertyName  }) {
        if (data61 !== void 0 && dataProp !== void 0) {
            throw new Error('both "data" and "dataProp" passed, only one allowed');
        }
        const { gen  } = it;
        if (dataProp !== void 0) {
            const { errorPath , dataPathArr , opts  } = it;
            const nextData = gen.let("data", codegen._`${it.data}${(0, codegen.getProperty)(dataProp)}`, true);
            dataContextProps(nextData);
            subschema2.errorPath = codegen.str`${errorPath}${(0, util.getErrorPath)(dataProp, dpType, opts.jsPropertySyntax)}`;
            subschema2.parentDataProperty = codegen._`${dataProp}`;
            subschema2.dataPathArr = [
                ...dataPathArr,
                subschema2.parentDataProperty
            ];
        }
        if (data61 !== void 0) {
            const nextData = data61 instanceof codegen.Name ? data61 : gen.let("data", data61, true);
            dataContextProps(nextData);
            if (propertyName !== void 0) subschema2.propertyName = propertyName;
        }
        if (dataTypes) subschema2.dataTypes = dataTypes;
        function dataContextProps(_nextData) {
            subschema2.data = _nextData;
            subschema2.dataLevel = it.dataLevel + 1;
            subschema2.dataTypes = [];
            it.definedProperties = new Set();
            subschema2.parentData = it.data;
            subschema2.dataNames = [
                ...it.dataNames,
                _nextData
            ];
        }
    }
    exports.extendSubschemaData = extendSubschemaData;
    function extendSubschemaMode(subschema2, { jtdDiscriminator , jtdMetadata , compositeRule , createErrors , allErrors  }) {
        if (compositeRule !== void 0) subschema2.compositeRule = compositeRule;
        if (createErrors !== void 0) subschema2.createErrors = createErrors;
        if (allErrors !== void 0) subschema2.allErrors = allErrors;
        subschema2.jtdDiscriminator = jtdDiscriminator;
        subschema2.jtdMetadata = jtdMetadata;
    }
    exports.extendSubschemaMode = extendSubschemaMode;
});
var resolve3 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getSchemaRefs = exports.resolveUrl = exports.normalizeId = exports._getFullPath = exports.getFullPath = exports.inlineRef = void 0;
    const SIMPLE_INLINED = new Set([
        "type",
        "format",
        "pattern",
        "maxLength",
        "minLength",
        "maxProperties",
        "minProperties",
        "maxItems",
        "minItems",
        "maximum",
        "minimum",
        "uniqueItems",
        "multipleOf",
        "required",
        "enum",
        "const"
    ]);
    function inlineRef(schema, limit = true) {
        if (typeof schema == "boolean") return true;
        if (limit === true) return !hasRef(schema);
        if (!limit) return false;
        return countKeys(schema) <= limit;
    }
    exports.inlineRef = inlineRef;
    const REF_KEYWORDS = new Set([
        "$ref",
        "$recursiveRef",
        "$recursiveAnchor",
        "$dynamicRef",
        "$dynamicAnchor"
    ]);
    function hasRef(schema) {
        for(const key in schema){
            if (REF_KEYWORDS.has(key)) return true;
            const sch = schema[key];
            if (Array.isArray(sch) && sch.some(hasRef)) return true;
            if (typeof sch == "object" && hasRef(sch)) return true;
        }
        return false;
    }
    function countKeys(schema) {
        let count = 0;
        for(const key in schema){
            if (key === "$ref") return Infinity;
            count++;
            if (SIMPLE_INLINED.has(key)) continue;
            if (typeof schema[key] == "object") {
                (0, util.eachItem)(schema[key], (sch)=>count += countKeys(sch)
                );
            }
            if (count === Infinity) return Infinity;
        }
        return count;
    }
    function getFullPath(id2 = "", normalize5) {
        if (normalize5 !== false) id2 = normalizeId(id2);
        const p = __pika_web_default_export_for_treeshaking__.parse(id2);
        return _getFullPath(p);
    }
    exports.getFullPath = getFullPath;
    function _getFullPath(p) {
        return __pika_web_default_export_for_treeshaking__.serialize(p).split("#")[0] + "#";
    }
    exports._getFullPath = _getFullPath;
    const TRAILING_SLASH_HASH = /#\/?$/;
    function normalizeId(id2) {
        return id2 ? id2.replace(TRAILING_SLASH_HASH, "") : "";
    }
    exports.normalizeId = normalizeId;
    function resolveUrl(baseId, id2) {
        id2 = normalizeId(id2);
        return __pika_web_default_export_for_treeshaking__.resolve(baseId, id2);
    }
    exports.resolveUrl = resolveUrl;
    const ANCHOR = /^[a-z_][-a-z0-9._]*$/i;
    function getSchemaRefs(schema, baseId) {
        if (typeof schema == "boolean") return {};
        const { schemaId  } = this.opts;
        const schId = normalizeId(schema[schemaId] || baseId);
        const baseIds = {
            "": schId
        };
        const pathPrefix = getFullPath(schId, false);
        const localRefs = {};
        const schemaRefs = new Set();
        jsonSchemaTraverse(schema, {
            allKeys: true
        }, (sch, jsonPtr, _2, parentJsonPtr)=>{
            if (parentJsonPtr === void 0) return;
            const fullPath = pathPrefix + jsonPtr;
            let baseId2 = baseIds[parentJsonPtr];
            if (typeof sch[schemaId] == "string") baseId2 = addRef.call(this, sch[schemaId]);
            addAnchor.call(this, sch.$anchor);
            addAnchor.call(this, sch.$dynamicAnchor);
            baseIds[jsonPtr] = baseId2;
            function addRef(ref2) {
                ref2 = normalizeId(baseId2 ? __pika_web_default_export_for_treeshaking__.resolve(baseId2, ref2) : ref2);
                if (schemaRefs.has(ref2)) throw ambiguos(ref2);
                schemaRefs.add(ref2);
                let schOrRef = this.refs[ref2];
                if (typeof schOrRef == "string") schOrRef = this.refs[schOrRef];
                if (typeof schOrRef == "object") {
                    checkAmbiguosRef(sch, schOrRef.schema, ref2);
                } else if (ref2 !== normalizeId(fullPath)) {
                    if (ref2[0] === "#") {
                        checkAmbiguosRef(sch, localRefs[ref2], ref2);
                        localRefs[ref2] = sch;
                    } else {
                        this.refs[ref2] = fullPath;
                    }
                }
                return ref2;
            }
            function addAnchor(anchor) {
                if (typeof anchor == "string") {
                    if (!ANCHOR.test(anchor)) throw new Error(`invalid anchor "${anchor}"`);
                    addRef.call(this, `#${anchor}`);
                }
            }
        });
        return localRefs;
        function checkAmbiguosRef(sch1, sch2, ref2) {
            if (sch2 !== void 0 && !fastDeepEqual(sch1, sch2)) throw ambiguos(ref2);
        }
        function ambiguos(ref2) {
            return new Error(`reference "${ref2}" resolves to more than one schema`);
        }
    }
    exports.getSchemaRefs = getSchemaRefs;
});
var validate = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.getData = exports.KeywordCxt = exports.validateFunctionCode = void 0;
    const dataType_2 = dataType;
    function validateFunctionCode(it) {
        if (isSchemaObj(it)) {
            checkKeywords(it);
            if (schemaCxtHasRules(it)) {
                topSchemaObjCode(it);
                return;
            }
        }
        validateFunction(it, ()=>(0, boolSchema.topBoolOrEmptySchema)(it)
        );
    }
    exports.validateFunctionCode = validateFunctionCode;
    function validateFunction({ gen , validateName , schema , schemaEnv , opts  }, body) {
        if (opts.code.es5) {
            gen.func(validateName, codegen._`${names_1.default.data}, ${names_1.default.valCxt}`, schemaEnv.$async, ()=>{
                gen.code(codegen._`"use strict"; ${funcSourceUrl(schema, opts)}`);
                destructureValCxtES5(gen, opts);
                gen.code(body);
            });
        } else {
            gen.func(validateName, codegen._`${names_1.default.data}, ${destructureValCxt(opts)}`, schemaEnv.$async, ()=>gen.code(funcSourceUrl(schema, opts)).code(body)
            );
        }
    }
    function destructureValCxt(opts) {
        return codegen._`{${names_1.default.instancePath}="", ${names_1.default.parentData}, ${names_1.default.parentDataProperty}, ${names_1.default.rootData}=${names_1.default.data}${opts.dynamicRef ? codegen._`, ${names_1.default.dynamicAnchors}={}` : codegen.nil}}={}`;
    }
    function destructureValCxtES5(gen, opts) {
        gen.if(names_1.default.valCxt, ()=>{
            gen.var(names_1.default.instancePath, codegen._`${names_1.default.valCxt}.${names_1.default.instancePath}`);
            gen.var(names_1.default.parentData, codegen._`${names_1.default.valCxt}.${names_1.default.parentData}`);
            gen.var(names_1.default.parentDataProperty, codegen._`${names_1.default.valCxt}.${names_1.default.parentDataProperty}`);
            gen.var(names_1.default.rootData, codegen._`${names_1.default.valCxt}.${names_1.default.rootData}`);
            if (opts.dynamicRef) gen.var(names_1.default.dynamicAnchors, codegen._`${names_1.default.valCxt}.${names_1.default.dynamicAnchors}`);
        }, ()=>{
            gen.var(names_1.default.instancePath, codegen._`""`);
            gen.var(names_1.default.parentData, codegen._`undefined`);
            gen.var(names_1.default.parentDataProperty, codegen._`undefined`);
            gen.var(names_1.default.rootData, names_1.default.data);
            if (opts.dynamicRef) gen.var(names_1.default.dynamicAnchors, codegen._`{}`);
        });
    }
    function topSchemaObjCode(it) {
        const { schema , opts , gen  } = it;
        validateFunction(it, ()=>{
            if (opts.$comment && schema.$comment) commentKeyword(it);
            checkNoDefault(it);
            gen.let(names_1.default.vErrors, null);
            gen.let(names_1.default.errors, 0);
            if (opts.unevaluated) resetEvaluated(it);
            typeAndKeywords(it);
            returnResults(it);
        });
        return;
    }
    function resetEvaluated(it) {
        const { gen , validateName  } = it;
        it.evaluated = gen.const("evaluated", codegen._`${validateName}.evaluated`);
        gen.if(codegen._`${it.evaluated}.dynamicProps`, ()=>gen.assign(codegen._`${it.evaluated}.props`, codegen._`undefined`)
        );
        gen.if(codegen._`${it.evaluated}.dynamicItems`, ()=>gen.assign(codegen._`${it.evaluated}.items`, codegen._`undefined`)
        );
    }
    function funcSourceUrl(schema, opts) {
        const schId = typeof schema == "object" && schema[opts.schemaId];
        return schId && (opts.code.source || opts.code.process) ? codegen._`/*# sourceURL=${schId} */` : codegen.nil;
    }
    function subschemaCode(it, valid) {
        if (isSchemaObj(it)) {
            checkKeywords(it);
            if (schemaCxtHasRules(it)) {
                subSchemaObjCode(it, valid);
                return;
            }
        }
        (0, boolSchema.boolOrEmptySchema)(it, valid);
    }
    function schemaCxtHasRules({ schema , self  }) {
        if (typeof schema == "boolean") return !schema;
        for(const key in schema)if (self.RULES.all[key]) return true;
        return false;
    }
    function isSchemaObj(it) {
        return typeof it.schema != "boolean";
    }
    function subSchemaObjCode(it, valid) {
        const { schema , gen , opts  } = it;
        if (opts.$comment && schema.$comment) commentKeyword(it);
        updateContext(it);
        checkAsyncSchema(it);
        const errsCount = gen.const("_errs", names_1.default.errors);
        typeAndKeywords(it, errsCount);
        gen.var(valid, codegen._`${errsCount} === ${names_1.default.errors}`);
    }
    function checkKeywords(it) {
        (0, util.checkUnknownRules)(it);
        checkRefsAndKeywords(it);
    }
    function typeAndKeywords(it, errsCount) {
        if (it.opts.jtd) return schemaKeywords(it, [], false, errsCount);
        const types2 = (0, dataType.getSchemaTypes)(it.schema);
        const checkedTypes = (0, dataType.coerceAndCheckDataType)(it, types2);
        schemaKeywords(it, types2, !checkedTypes, errsCount);
    }
    function checkRefsAndKeywords(it) {
        const { schema , errSchemaPath , opts , self  } = it;
        if (schema.$ref && opts.ignoreKeywordsWithRef && (0, util.schemaHasRulesButRef)(schema, self.RULES)) {
            self.logger.warn(`$ref: keywords ignored in schema at path "${errSchemaPath}"`);
        }
    }
    function checkNoDefault(it) {
        const { schema , opts  } = it;
        if (schema.default !== void 0 && opts.useDefaults && opts.strictSchema) {
            (0, util.checkStrictMode)(it, "default is ignored in the schema root");
        }
    }
    function updateContext(it) {
        const schId = it.schema[it.opts.schemaId];
        if (schId) it.baseId = (0, resolve3.resolveUrl)(it.baseId, schId);
    }
    function checkAsyncSchema(it) {
        if (it.schema.$async && !it.schemaEnv.$async) throw new Error("async schema in sync schema");
    }
    function commentKeyword({ gen , schemaEnv , schema , errSchemaPath , opts  }) {
        const msg = schema.$comment;
        if (opts.$comment === true) {
            gen.code(codegen._`${names_1.default.self}.logger.log(${msg})`);
        } else if (typeof opts.$comment == "function") {
            const schemaPath = codegen.str`${errSchemaPath}/$comment`;
            const rootName = gen.scopeValue("root", {
                ref: schemaEnv.root
            });
            gen.code(codegen._`${names_1.default.self}.opts.$comment(${msg}, ${schemaPath}, ${rootName}.schema)`);
        }
    }
    function returnResults(it) {
        const { gen , schemaEnv , validateName , ValidationError: ValidationError3 , opts  } = it;
        if (schemaEnv.$async) {
            gen.if(codegen._`${names_1.default.errors} === 0`, ()=>gen.return(names_1.default.data)
            , ()=>gen.throw(codegen._`new ${ValidationError3}(${names_1.default.vErrors})`)
            );
        } else {
            gen.assign(codegen._`${validateName}.errors`, names_1.default.vErrors);
            if (opts.unevaluated) assignEvaluated(it);
            gen.return(codegen._`${names_1.default.errors} === 0`);
        }
    }
    function assignEvaluated({ gen , evaluated , props , items: items2  }) {
        if (props instanceof codegen.Name) gen.assign(codegen._`${evaluated}.props`, props);
        if (items2 instanceof codegen.Name) gen.assign(codegen._`${evaluated}.items`, items2);
    }
    function schemaKeywords(it, types2, typeErrors, errsCount) {
        const { gen , schema , data: data62 , allErrors , opts , self  } = it;
        const { RULES  } = self;
        if (schema.$ref && (opts.ignoreKeywordsWithRef || !(0, util.schemaHasRulesButRef)(schema, RULES))) {
            gen.block(()=>keywordCode(it, "$ref", RULES.all.$ref.definition)
            );
            return;
        }
        if (!opts.jtd) checkStrictTypes(it, types2);
        gen.block(()=>{
            for (const group of RULES.rules)groupKeywords(group);
            groupKeywords(RULES.post);
        });
        function groupKeywords(group) {
            if (!(0, applicability.shouldUseGroup)(schema, group)) return;
            if (group.type) {
                gen.if((0, dataType_2.checkDataType)(group.type, data62, opts.strictNumbers));
                iterateKeywords(it, group);
                if (types2.length === 1 && types2[0] === group.type && typeErrors) {
                    gen.else();
                    (0, dataType_2.reportTypeError)(it);
                }
                gen.endIf();
            } else {
                iterateKeywords(it, group);
            }
            if (!allErrors) gen.if(codegen._`${names_1.default.errors} === ${errsCount || 0}`);
        }
    }
    function iterateKeywords(it, group) {
        const { gen , schema , opts: { useDefaults  }  } = it;
        if (useDefaults) (0, defaults.assignDefaults)(it, group.type);
        gen.block(()=>{
            for (const rule of group.rules){
                if ((0, applicability.shouldUseRule)(schema, rule)) {
                    keywordCode(it, rule.keyword, rule.definition, group.type);
                }
            }
        });
    }
    function checkStrictTypes(it, types2) {
        if (it.schemaEnv.meta || !it.opts.strictTypes) return;
        checkContextTypes(it, types2);
        if (!it.opts.allowUnionTypes) checkMultipleTypes(it, types2);
        checkKeywordTypes(it, it.dataTypes);
    }
    function checkContextTypes(it, types2) {
        if (!types2.length) return;
        if (!it.dataTypes.length) {
            it.dataTypes = types2;
            return;
        }
        types2.forEach((t)=>{
            if (!includesType(it.dataTypes, t)) {
                strictTypesError(it, `type "${t}" not allowed by context "${it.dataTypes.join(",")}"`);
            }
        });
        it.dataTypes = it.dataTypes.filter((t)=>includesType(types2, t)
        );
    }
    function checkMultipleTypes(it, ts) {
        if (ts.length > 1 && !(ts.length === 2 && ts.includes("null"))) {
            strictTypesError(it, "use allowUnionTypes to allow union type keyword");
        }
    }
    function checkKeywordTypes(it, ts) {
        const rules2 = it.self.RULES.all;
        for(const keyword2 in rules2){
            const rule = rules2[keyword2];
            if (typeof rule == "object" && (0, applicability.shouldUseRule)(it.schema, rule)) {
                const { type: type2  } = rule.definition;
                if (type2.length && !type2.some((t)=>hasApplicableType(ts, t)
                )) {
                    strictTypesError(it, `missing type "${type2.join(",")}" for keyword "${keyword2}"`);
                }
            }
        }
    }
    function hasApplicableType(schTs, kwdT) {
        return schTs.includes(kwdT) || kwdT === "number" && schTs.includes("integer");
    }
    function includesType(ts, t) {
        return ts.includes(t) || t === "integer" && ts.includes("number");
    }
    function strictTypesError(it, msg) {
        const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
        msg += ` at "${schemaPath}" (strictTypes)`;
        (0, util.checkStrictMode)(it, msg, it.opts.strictTypes);
    }
    class KeywordCxt2 {
        constructor(it, def6, keyword$1){
            (0, keyword.validateKeywordUsage)(it, def6, keyword$1);
            this.gen = it.gen;
            this.allErrors = it.allErrors;
            this.keyword = keyword$1;
            this.data = it.data;
            this.schema = it.schema[keyword$1];
            this.$data = def6.$data && it.opts.$data && this.schema && this.schema.$data;
            this.schemaValue = (0, util.schemaRefOrVal)(it, this.schema, keyword$1, this.$data);
            this.schemaType = def6.schemaType;
            this.parentSchema = it.schema;
            this.params = {};
            this.it = it;
            this.def = def6;
            if (this.$data) {
                this.schemaCode = it.gen.const("vSchema", getData(this.$data, it));
            } else {
                this.schemaCode = this.schemaValue;
                if (!(0, keyword.validSchemaType)(this.schema, def6.schemaType, def6.allowUndefined)) {
                    throw new Error(`${keyword$1} value must be ${JSON.stringify(def6.schemaType)}`);
                }
            }
            if ("code" in def6 ? def6.trackErrors : def6.errors !== false) {
                this.errsCount = it.gen.const("_errs", names_1.default.errors);
            }
        }
        result(condition, successAction, failAction) {
            this.failResult((0, codegen.not)(condition), successAction, failAction);
        }
        failResult(condition, successAction, failAction) {
            this.gen.if(condition);
            if (failAction) failAction();
            else this.error();
            if (successAction) {
                this.gen.else();
                successAction();
                if (this.allErrors) this.gen.endIf();
            } else {
                if (this.allErrors) this.gen.endIf();
                else this.gen.else();
            }
        }
        pass(condition, failAction) {
            this.failResult((0, codegen.not)(condition), void 0, failAction);
        }
        fail(condition) {
            if (condition === void 0) {
                this.error();
                if (!this.allErrors) this.gen.if(false);
                return;
            }
            this.gen.if(condition);
            this.error();
            if (this.allErrors) this.gen.endIf();
            else this.gen.else();
        }
        fail$data(condition) {
            if (!this.$data) return this.fail(condition);
            const { schemaCode  } = this;
            this.fail(codegen._`${schemaCode} !== undefined && (${(0, codegen.or)(this.invalid$data(), condition)})`);
        }
        error(append, errorParams, errorPaths) {
            if (errorParams) {
                this.setParams(errorParams);
                this._error(append, errorPaths);
                this.setParams({});
                return;
            }
            this._error(append, errorPaths);
        }
        _error(append, errorPaths) {
            (append ? errors.reportExtraError : errors.reportError)(this, this.def.error, errorPaths);
        }
        $dataError() {
            (0, errors.reportError)(this, this.def.$dataError || errors.keyword$DataError);
        }
        reset() {
            if (this.errsCount === void 0) throw new Error('add "trackErrors" to keyword definition');
            (0, errors.resetErrorsCount)(this.gen, this.errsCount);
        }
        ok(cond) {
            if (!this.allErrors) this.gen.if(cond);
        }
        setParams(obj, assign) {
            if (assign) Object.assign(this.params, obj);
            else this.params = obj;
        }
        block$data(valid, codeBlock, $dataValid = codegen.nil) {
            this.gen.block(()=>{
                this.check$data(valid, $dataValid);
                codeBlock();
            });
        }
        check$data(valid = codegen.nil, $dataValid = codegen.nil) {
            if (!this.$data) return;
            const { gen , schemaCode , schemaType: schemaType3 , def: def7  } = this;
            gen.if((0, codegen.or)(codegen._`${schemaCode} === undefined`, $dataValid));
            if (valid !== codegen.nil) gen.assign(valid, true);
            if (schemaType3.length || def7.validateSchema) {
                gen.elseIf(this.invalid$data());
                this.$dataError();
                if (valid !== codegen.nil) gen.assign(valid, false);
            }
            gen.else();
        }
        invalid$data() {
            const { gen , schemaCode , schemaType: schemaType4 , def: def8 , it  } = this;
            return (0, codegen.or)(wrong$DataType(), invalid$DataSchema());
            function wrong$DataType() {
                if (schemaType4.length) {
                    if (!(schemaCode instanceof codegen.Name)) throw new Error("ajv implementation error");
                    const st = Array.isArray(schemaType4) ? schemaType4 : [
                        schemaType4
                    ];
                    return codegen._`${(0, dataType_2.checkDataTypes)(st, schemaCode, it.opts.strictNumbers, dataType_2.DataType.Wrong)}`;
                }
                return codegen.nil;
            }
            function invalid$DataSchema() {
                if (def8.validateSchema) {
                    const validateSchemaRef = gen.scopeValue("validate$data", {
                        ref: def8.validateSchema
                    });
                    return codegen._`!${validateSchemaRef}(${schemaCode})`;
                }
                return codegen.nil;
            }
        }
        subschema(appl, valid) {
            const subschema$1 = (0, subschema.getSubschema)(this.it, appl);
            (0, subschema.extendSubschemaData)(subschema$1, this.it, appl);
            (0, subschema.extendSubschemaMode)(subschema$1, appl);
            const nextContext = {
                ...this.it,
                ...subschema$1,
                items: void 0,
                props: void 0
            };
            subschemaCode(nextContext, valid);
            return nextContext;
        }
        mergeEvaluated(schemaCxt, toName) {
            const { it , gen  } = this;
            if (!it.opts.unevaluated) return;
            if (it.props !== true && schemaCxt.props !== void 0) {
                it.props = util.mergeEvaluated.props(gen, schemaCxt.props, it.props, toName);
            }
            if (it.items !== true && schemaCxt.items !== void 0) {
                it.items = util.mergeEvaluated.items(gen, schemaCxt.items, it.items, toName);
            }
        }
        mergeValidEvaluated(schemaCxt, valid) {
            const { it , gen  } = this;
            if (it.opts.unevaluated && (it.props !== true || it.items !== true)) {
                gen.if(valid, ()=>this.mergeEvaluated(schemaCxt, codegen.Name)
                );
                return true;
            }
        }
    }
    exports.KeywordCxt = KeywordCxt2;
    function keywordCode(it, keyword$1, def9, ruleType) {
        const cxt = new KeywordCxt2(it, def9, keyword$1);
        if ("code" in def9) {
            def9.code(cxt, ruleType);
        } else if (cxt.$data && def9.validate) {
            (0, keyword.funcKeywordCode)(cxt, def9);
        } else if ("macro" in def9) {
            (0, keyword.macroKeywordCode)(cxt, def9);
        } else if (def9.compile || def9.validate) {
            (0, keyword.funcKeywordCode)(cxt, def9);
        }
    }
    const JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
    const RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
    function getData($data, { dataLevel , dataNames , dataPathArr  }) {
        let jsonPointer;
        let data63;
        if ($data === "") return names_1.default.rootData;
        if ($data[0] === "/") {
            if (!JSON_POINTER.test($data)) throw new Error(`Invalid JSON-pointer: ${$data}`);
            jsonPointer = $data;
            data63 = names_1.default.rootData;
        } else {
            const matches = RELATIVE_JSON_POINTER.exec($data);
            if (!matches) throw new Error(`Invalid JSON-pointer: ${$data}`);
            const up = +matches[1];
            jsonPointer = matches[2];
            if (jsonPointer === "#") {
                if (up >= dataLevel) throw new Error(errorMsg("property/index", up));
                return dataPathArr[dataLevel - up];
            }
            if (up > dataLevel) throw new Error(errorMsg("data", up));
            data63 = dataNames[dataLevel - up];
            if (!jsonPointer) return data63;
        }
        let expr = data63;
        const segments = jsonPointer.split("/");
        for (const segment of segments){
            if (segment) {
                data63 = codegen._`${data63}${(0, codegen.getProperty)((0, util.unescapeJsonPointer)(segment))}`;
                expr = codegen._`${expr} && ${data63}`;
            }
        }
        return expr;
        function errorMsg(pointerType, up) {
            return `Cannot access ${pointerType} ${up} levels up, current level is ${dataLevel}`;
        }
    }
    exports.getData = getData;
});
var validation_error = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    class ValidationError4 extends Error {
        constructor(errors2){
            super("validation failed");
            this.errors = errors2;
            this.ajv = this.validation = true;
        }
    }
    exports.default = ValidationError4;
});
var ref_error = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    class MissingRefError extends Error {
        constructor(baseId, ref2, msg){
            super(msg || `can't resolve reference ${ref2} from id ${baseId}`);
            this.missingRef = (0, resolve3.resolveUrl)(baseId, ref2);
            this.missingSchema = (0, resolve3.normalizeId)((0, resolve3.getFullPath)(this.missingRef));
        }
    }
    exports.default = MissingRefError;
});
var compile = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.resolveSchema = exports.getCompilingSchema = exports.resolveRef = exports.compileSchema = exports.SchemaEnv = void 0;
    class SchemaEnv {
        constructor(env){
            var _a;
            this.refs = {};
            this.dynamicAnchors = {};
            let schema;
            if (typeof env.schema == "object") schema = env.schema;
            this.schema = env.schema;
            this.schemaId = env.schemaId;
            this.root = env.root || this;
            this.baseId = (_a = env.baseId) !== null && _a !== void 0 ? _a : (0, resolve3.normalizeId)(schema === null || schema === void 0 ? void 0 : schema[env.schemaId || "$id"]);
            this.schemaPath = env.schemaPath;
            this.localRefs = env.localRefs;
            this.meta = env.meta;
            this.$async = schema === null || schema === void 0 ? void 0 : schema.$async;
            this.refs = {};
        }
    }
    exports.SchemaEnv = SchemaEnv;
    function compileSchema(sch) {
        const _sch = getCompilingSchema.call(this, sch);
        if (_sch) return _sch;
        const rootId = (0, resolve3.getFullPath)(sch.root.baseId);
        const { es5 , lines: lines1  } = this.opts.code;
        const { ownProperties  } = this.opts;
        const gen = new codegen.CodeGen(this.scope, {
            es5,
            lines: lines1,
            ownProperties
        });
        let _ValidationError;
        if (sch.$async) {
            _ValidationError = gen.scopeValue("Error", {
                ref: validation_error.default,
                code: codegen._`require("ajv/dist/runtime/validation_error").default`
            });
        }
        const validateName = gen.scopeName("validate");
        sch.validateName = validateName;
        const schemaCxt = {
            gen,
            allErrors: this.opts.allErrors,
            data: names_1.default.data,
            parentData: names_1.default.parentData,
            parentDataProperty: names_1.default.parentDataProperty,
            dataNames: [
                names_1.default.data
            ],
            dataPathArr: [
                codegen.nil
            ],
            dataLevel: 0,
            dataTypes: [],
            definedProperties: new Set(),
            topSchemaRef: gen.scopeValue("schema", this.opts.code.source === true ? {
                ref: sch.schema,
                code: (0, codegen.stringify)(sch.schema)
            } : {
                ref: sch.schema
            }),
            validateName,
            ValidationError: _ValidationError,
            schema: sch.schema,
            schemaEnv: sch,
            rootId,
            baseId: sch.baseId || rootId,
            schemaPath: codegen.nil,
            errSchemaPath: sch.schemaPath || (this.opts.jtd ? "" : "#"),
            errorPath: codegen._`""`,
            opts: this.opts,
            self: this
        };
        let sourceCode;
        try {
            this._compilations.add(sch);
            (0, validate.validateFunctionCode)(schemaCxt);
            gen.optimize(this.opts.code.optimize);
            const validateCode = gen.toString();
            sourceCode = `${gen.scopeRefs(names_1.default.scope)}return ${validateCode}`;
            if (this.opts.code.process) sourceCode = this.opts.code.process(sourceCode, sch);
            const makeValidate = new Function(`${names_1.default.self}`, `${names_1.default.scope}`, sourceCode);
            const validate$1 = makeValidate(this, this.scope.get());
            this.scope.value(validateName, {
                ref: validate$1
            });
            validate$1.errors = null;
            validate$1.schema = sch.schema;
            validate$1.schemaEnv = sch;
            if (sch.$async) validate$1.$async = true;
            if (this.opts.code.source === true) {
                validate$1.source = {
                    validateName,
                    validateCode,
                    scopeValues: gen._values
                };
            }
            if (this.opts.unevaluated) {
                const { props , items: items2  } = schemaCxt;
                validate$1.evaluated = {
                    props: props instanceof codegen.Name ? void 0 : props,
                    items: items2 instanceof codegen.Name ? void 0 : items2,
                    dynamicProps: props instanceof codegen.Name,
                    dynamicItems: items2 instanceof codegen.Name
                };
                if (validate$1.source) validate$1.source.evaluated = (0, codegen.stringify)(validate$1.evaluated);
            }
            sch.validate = validate$1;
            return sch;
        } catch (e) {
            delete sch.validate;
            delete sch.validateName;
            if (sourceCode) this.logger.error("Error compiling schema, function code:", sourceCode);
            throw e;
        } finally{
            this._compilations.delete(sch);
        }
    }
    exports.compileSchema = compileSchema;
    function resolveRef(root6, baseId, ref2) {
        var _a;
        ref2 = (0, resolve3.resolveUrl)(baseId, ref2);
        const schOrFunc = root6.refs[ref2];
        if (schOrFunc) return schOrFunc;
        let _sch = resolve$1.call(this, root6, ref2);
        if (_sch === void 0) {
            const schema = (_a = root6.localRefs) === null || _a === void 0 ? void 0 : _a[ref2];
            const { schemaId  } = this.opts;
            if (schema) _sch = new SchemaEnv({
                schema,
                schemaId,
                root: root6,
                baseId
            });
        }
        if (_sch === void 0) return;
        return root6.refs[ref2] = inlineOrCompile.call(this, _sch);
    }
    exports.resolveRef = resolveRef;
    function inlineOrCompile(sch) {
        if ((0, resolve3.inlineRef)(sch.schema, this.opts.inlineRefs)) return sch.schema;
        return sch.validate ? sch : compileSchema.call(this, sch);
    }
    function getCompilingSchema(schEnv) {
        for (const sch of this._compilations){
            if (sameSchemaEnv(sch, schEnv)) return sch;
        }
    }
    exports.getCompilingSchema = getCompilingSchema;
    function sameSchemaEnv(s1, s2) {
        return s1.schema === s2.schema && s1.root === s2.root && s1.baseId === s2.baseId;
    }
    function resolve$1(root7, ref2) {
        let sch;
        while(typeof (sch = this.refs[ref2]) == "string")ref2 = sch;
        return sch || this.schemas[ref2] || resolveSchema.call(this, root7, ref2);
    }
    function resolveSchema(root8, ref2) {
        const p = __pika_web_default_export_for_treeshaking__.parse(ref2);
        const refPath = (0, resolve3._getFullPath)(p);
        let baseId = (0, resolve3.getFullPath)(root8.baseId);
        if (Object.keys(root8.schema).length > 0 && refPath === baseId) {
            return getJsonPointer.call(this, p, root8);
        }
        const id2 = (0, resolve3.normalizeId)(refPath);
        const schOrRef = this.refs[id2] || this.schemas[id2];
        if (typeof schOrRef == "string") {
            const sch = resolveSchema.call(this, root8, schOrRef);
            if (typeof (sch === null || sch === void 0 ? void 0 : sch.schema) !== "object") return;
            return getJsonPointer.call(this, p, sch);
        }
        if (typeof (schOrRef === null || schOrRef === void 0 ? void 0 : schOrRef.schema) !== "object") return;
        if (!schOrRef.validate) compileSchema.call(this, schOrRef);
        if (id2 === (0, resolve3.normalizeId)(ref2)) {
            const { schema  } = schOrRef;
            const { schemaId  } = this.opts;
            const schId = schema[schemaId];
            if (schId) baseId = (0, resolve3.resolveUrl)(baseId, schId);
            return new SchemaEnv({
                schema,
                schemaId,
                root: root8,
                baseId
            });
        }
        return getJsonPointer.call(this, p, schOrRef);
    }
    exports.resolveSchema = resolveSchema;
    const PREVENT_SCOPE_CHANGE = new Set([
        "properties",
        "patternProperties",
        "enum",
        "dependencies",
        "definitions"
    ]);
    function getJsonPointer(parsedRef, { baseId , schema , root: root9  }) {
        var _a;
        if (((_a = parsedRef.fragment) === null || _a === void 0 ? void 0 : _a[0]) !== "/") return;
        for (const part of parsedRef.fragment.slice(1).split("/")){
            if (typeof schema === "boolean") return;
            const partSchema = schema[(0, util.unescapeFragment)(part)];
            if (partSchema === void 0) return;
            schema = partSchema;
            const schId = typeof schema === "object" && schema[this.opts.schemaId];
            if (!PREVENT_SCOPE_CHANGE.has(part) && schId) {
                baseId = (0, resolve3.resolveUrl)(baseId, schId);
            }
        }
        let env;
        if (typeof schema != "boolean" && schema.$ref && !(0, util.schemaHasRulesButRef)(schema, this.RULES)) {
            const $ref = (0, resolve3.resolveUrl)(baseId, schema.$ref);
            env = resolveSchema.call(this, root9, $ref);
        }
        const { schemaId  } = this.opts;
        env = env || new SchemaEnv({
            schema,
            schemaId,
            root: root9,
            baseId
        });
        if (env.schema !== env.root.schema) return env;
        return void 0;
    }
});
const $id = "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#";
const description = "Meta-schema for $data reference (JSON AnySchema extension proposal)";
const type = "object";
const required = [
    "$data"
];
const properties = {
    $data: {
        type: "string",
        anyOf: [
            {
                format: "relative-json-pointer"
            },
            {
                format: "json-pointer"
            }
        ]
    }
};
var $dataRefSchema = {
    $id,
    description,
    type,
    required,
    properties,
    additionalProperties: false
};
var core1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.CodeGen = exports.Name = exports.nil = exports.stringify = exports.str = exports._ = exports.KeywordCxt = void 0;
    Object.defineProperty(exports, "KeywordCxt", {
        enumerable: true,
        get: function() {
            return validate.KeywordCxt;
        }
    });
    Object.defineProperty(exports, "_", {
        enumerable: true,
        get: function() {
            return codegen._;
        }
    });
    Object.defineProperty(exports, "str", {
        enumerable: true,
        get: function() {
            return codegen.str;
        }
    });
    Object.defineProperty(exports, "stringify", {
        enumerable: true,
        get: function() {
            return codegen.stringify;
        }
    });
    Object.defineProperty(exports, "nil", {
        enumerable: true,
        get: function() {
            return codegen.nil;
        }
    });
    Object.defineProperty(exports, "Name", {
        enumerable: true,
        get: function() {
            return codegen.Name;
        }
    });
    Object.defineProperty(exports, "CodeGen", {
        enumerable: true,
        get: function() {
            return codegen.CodeGen;
        }
    });
    const codegen_2 = codegen;
    const defaultRegExp = (str2, flags)=>new RegExp(str2, flags)
    ;
    defaultRegExp.code = "new RegExp";
    const META_IGNORE_OPTIONS = [
        "removeAdditional",
        "useDefaults",
        "coerceTypes"
    ];
    const EXT_SCOPE_NAMES = new Set([
        "validate",
        "serialize",
        "parse",
        "wrapper",
        "root",
        "schema",
        "keyword",
        "pattern",
        "formats",
        "validate$data",
        "func",
        "obj",
        "Error"
    ]);
    const removedOptions = {
        errorDataPath: "",
        format: "`validateFormats: false` can be used instead.",
        nullable: '"nullable" keyword is supported by default.',
        jsonPointers: "Deprecated jsPropertySyntax can be used instead.",
        extendRefs: "Deprecated ignoreKeywordsWithRef can be used instead.",
        missingRefs: "Pass empty schema with $id that should be ignored to ajv.addSchema.",
        processCode: "Use option `code: {process: (code, schemaEnv: object) => string}`",
        sourceCode: "Use option `code: {source: true}`",
        strictDefaults: "It is default now, see option `strict`.",
        strictKeywords: "It is default now, see option `strict`.",
        uniqueItems: '"uniqueItems" keyword is always validated.',
        unknownFormats: "Disable strict mode or pass `true` to `ajv.addFormat` (or `formats` option).",
        cache: "Map is used as cache, schema object as key.",
        serialize: "Map is used as cache, schema object as key.",
        ajvErrors: "It is default now."
    };
    const deprecatedOptions = {
        ignoreKeywordsWithRef: "",
        jsPropertySyntax: "",
        unicode: '"minLength"/"maxLength" account for unicode characters by default.'
    };
    function requiredOptions(o) {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s, _t, _u, _v, _w, _x, _y, _z;
        const s = o.strict;
        const _optz = (_a = o.code) === null || _a === void 0 ? void 0 : _a.optimize;
        const optimize = _optz === true || _optz === void 0 ? 1 : _optz || 0;
        const regExp = (_c = (_b = o.code) === null || _b === void 0 ? void 0 : _b.regExp) !== null && _c !== void 0 ? _c : defaultRegExp;
        return {
            strictSchema: (_e = (_d = o.strictSchema) !== null && _d !== void 0 ? _d : s) !== null && _e !== void 0 ? _e : true,
            strictNumbers: (_g = (_f = o.strictNumbers) !== null && _f !== void 0 ? _f : s) !== null && _g !== void 0 ? _g : true,
            strictTypes: (_j = (_h = o.strictTypes) !== null && _h !== void 0 ? _h : s) !== null && _j !== void 0 ? _j : "log",
            strictTuples: (_l = (_k = o.strictTuples) !== null && _k !== void 0 ? _k : s) !== null && _l !== void 0 ? _l : "log",
            strictRequired: (_o = (_m = o.strictRequired) !== null && _m !== void 0 ? _m : s) !== null && _o !== void 0 ? _o : false,
            code: o.code ? {
                ...o.code,
                optimize,
                regExp
            } : {
                optimize,
                regExp
            },
            loopRequired: (_p = o.loopRequired) !== null && _p !== void 0 ? _p : 200,
            loopEnum: (_q = o.loopEnum) !== null && _q !== void 0 ? _q : 200,
            meta: (_r = o.meta) !== null && _r !== void 0 ? _r : true,
            messages: (_s = o.messages) !== null && _s !== void 0 ? _s : true,
            inlineRefs: (_t = o.inlineRefs) !== null && _t !== void 0 ? _t : true,
            schemaId: (_u = o.schemaId) !== null && _u !== void 0 ? _u : "$id",
            addUsedSchema: (_v = o.addUsedSchema) !== null && _v !== void 0 ? _v : true,
            validateSchema: (_w = o.validateSchema) !== null && _w !== void 0 ? _w : true,
            validateFormats: (_x = o.validateFormats) !== null && _x !== void 0 ? _x : true,
            unicodeRegExp: (_y = o.unicodeRegExp) !== null && _y !== void 0 ? _y : true,
            int32range: (_z = o.int32range) !== null && _z !== void 0 ? _z : true
        };
    }
    class Ajv {
        constructor(opts = {}){
            this.schemas = {};
            this.refs = {};
            this.formats = {};
            this._compilations = new Set();
            this._loading = {};
            this._cache = new Map();
            opts = this.opts = {
                ...opts,
                ...requiredOptions(opts)
            };
            const { es5 , lines: lines2  } = this.opts.code;
            this.scope = new codegen_2.ValueScope({
                scope: {},
                prefixes: EXT_SCOPE_NAMES,
                es5,
                lines: lines2
            });
            this.logger = getLogger1(opts.logger);
            const formatOpt = opts.validateFormats;
            opts.validateFormats = false;
            this.RULES = (0, rules.getRules)();
            checkOptions.call(this, removedOptions, opts, "NOT SUPPORTED");
            checkOptions.call(this, deprecatedOptions, opts, "DEPRECATED", "warn");
            this._metaOpts = getMetaSchemaOptions.call(this);
            if (opts.formats) addInitialFormats.call(this);
            this._addVocabularies();
            this._addDefaultMetaSchema();
            if (opts.keywords) addInitialKeywords.call(this, opts.keywords);
            if (typeof opts.meta == "object") this.addMetaSchema(opts.meta);
            addInitialSchemas.call(this);
            opts.validateFormats = formatOpt;
        }
        _addVocabularies() {
            this.addKeyword("$async");
        }
        _addDefaultMetaSchema() {
            const { $data , meta , schemaId  } = this.opts;
            let _dataRefSchema = $dataRefSchema;
            if (schemaId === "id") {
                _dataRefSchema = {
                    ...$dataRefSchema
                };
                _dataRefSchema.id = _dataRefSchema.$id;
                delete _dataRefSchema.$id;
            }
            if (meta && $data) this.addMetaSchema(_dataRefSchema, _dataRefSchema[schemaId], false);
        }
        defaultMeta() {
            const { meta , schemaId  } = this.opts;
            return this.opts.defaultMeta = typeof meta == "object" ? meta[schemaId] || meta : void 0;
        }
        validate(schemaKeyRef, data64) {
            let v;
            if (typeof schemaKeyRef == "string") {
                v = this.getSchema(schemaKeyRef);
                if (!v) throw new Error(`no schema with key or ref "${schemaKeyRef}"`);
            } else {
                v = this.compile(schemaKeyRef);
            }
            const valid = v(data64);
            if (!("$async" in v)) this.errors = v.errors;
            return valid;
        }
        compile(schema, _meta) {
            const sch = this._addSchema(schema, _meta);
            return sch.validate || this._compileSchemaEnv(sch);
        }
        compileAsync(schema, meta) {
            if (typeof this.opts.loadSchema != "function") {
                throw new Error("options.loadSchema should be a function");
            }
            const { loadSchema  } = this.opts;
            return runCompileAsync.call(this, schema, meta);
            async function runCompileAsync(_schema, _meta) {
                await loadMetaSchema.call(this, _schema.$schema);
                const sch = this._addSchema(_schema, _meta);
                return sch.validate || _compileAsync.call(this, sch);
            }
            async function loadMetaSchema($ref) {
                if ($ref && !this.getSchema($ref)) {
                    await runCompileAsync.call(this, {
                        $ref
                    }, true);
                }
            }
            async function _compileAsync(sch) {
                try {
                    return this._compileSchemaEnv(sch);
                } catch (e) {
                    if (!(e instanceof ref_error.default)) throw e;
                    checkLoaded.call(this, e);
                    await loadMissingSchema.call(this, e.missingSchema);
                    return _compileAsync.call(this, sch);
                }
            }
            function checkLoaded({ missingSchema: ref2 , missingRef  }) {
                if (this.refs[ref2]) {
                    throw new Error(`AnySchema ${ref2} is loaded but ${missingRef} cannot be resolved`);
                }
            }
            async function loadMissingSchema(ref2) {
                const _schema = await _loadSchema.call(this, ref2);
                if (!this.refs[ref2]) await loadMetaSchema.call(this, _schema.$schema);
                if (!this.refs[ref2]) this.addSchema(_schema, ref2, meta);
            }
            async function _loadSchema(ref2) {
                const p = this._loading[ref2];
                if (p) return p;
                try {
                    return await (this._loading[ref2] = loadSchema(ref2));
                } finally{
                    delete this._loading[ref2];
                }
            }
        }
        addSchema(schema, key, _meta, _validateSchema = this.opts.validateSchema) {
            if (Array.isArray(schema)) {
                for (const sch of schema)this.addSchema(sch, void 0, _meta, _validateSchema);
                return this;
            }
            let id2;
            if (typeof schema === "object") {
                const { schemaId  } = this.opts;
                id2 = schema[schemaId];
                if (id2 !== void 0 && typeof id2 != "string") {
                    throw new Error(`schema ${schemaId} must be string`);
                }
            }
            key = (0, resolve3.normalizeId)(key || id2);
            this._checkUnique(key);
            this.schemas[key] = this._addSchema(schema, _meta, key, _validateSchema, true);
            return this;
        }
        addMetaSchema(schema, key, _validateSchema = this.opts.validateSchema) {
            this.addSchema(schema, key, true, _validateSchema);
            return this;
        }
        validateSchema(schema, throwOrLogError) {
            if (typeof schema == "boolean") return true;
            let $schema2;
            $schema2 = schema.$schema;
            if ($schema2 !== void 0 && typeof $schema2 != "string") {
                throw new Error("$schema must be a string");
            }
            $schema2 = $schema2 || this.opts.defaultMeta || this.defaultMeta();
            if (!$schema2) {
                this.logger.warn("meta-schema not available");
                this.errors = null;
                return true;
            }
            const valid = this.validate($schema2, schema);
            if (!valid && throwOrLogError) {
                const message = "schema is invalid: " + this.errorsText();
                if (this.opts.validateSchema === "log") this.logger.error(message);
                else throw new Error(message);
            }
            return valid;
        }
        getSchema(keyRef) {
            let sch;
            while(typeof (sch = getSchEnv.call(this, keyRef)) == "string")keyRef = sch;
            if (sch === void 0) {
                const { schemaId  } = this.opts;
                const root10 = new compile.SchemaEnv({
                    schema: {},
                    schemaId
                });
                sch = compile.resolveSchema.call(this, root10, keyRef);
                if (!sch) return;
                this.refs[keyRef] = sch;
            }
            return sch.validate || this._compileSchemaEnv(sch);
        }
        removeSchema(schemaKeyRef) {
            if (schemaKeyRef instanceof RegExp) {
                this._removeAllSchemas(this.schemas, schemaKeyRef);
                this._removeAllSchemas(this.refs, schemaKeyRef);
                return this;
            }
            switch(typeof schemaKeyRef){
                case "undefined":
                    this._removeAllSchemas(this.schemas);
                    this._removeAllSchemas(this.refs);
                    this._cache.clear();
                    return this;
                case "string":
                    {
                        const sch = getSchEnv.call(this, schemaKeyRef);
                        if (typeof sch == "object") this._cache.delete(sch.schema);
                        delete this.schemas[schemaKeyRef];
                        delete this.refs[schemaKeyRef];
                        return this;
                    }
                case "object":
                    {
                        const cacheKey = schemaKeyRef;
                        this._cache.delete(cacheKey);
                        let id2 = schemaKeyRef[this.opts.schemaId];
                        if (id2) {
                            id2 = (0, resolve3.normalizeId)(id2);
                            delete this.schemas[id2];
                            delete this.refs[id2];
                        }
                        return this;
                    }
                default:
                    throw new Error("ajv.removeSchema: invalid parameter");
            }
        }
        addVocabulary(definitions2) {
            for (const def10 of definitions2)this.addKeyword(def10);
            return this;
        }
        addKeyword(kwdOrDef, def11) {
            let keyword2;
            if (typeof kwdOrDef == "string") {
                keyword2 = kwdOrDef;
                if (typeof def11 == "object") {
                    this.logger.warn("these parameters are deprecated, see docs for addKeyword");
                    def11.keyword = keyword2;
                }
            } else if (typeof kwdOrDef == "object" && def11 === void 0) {
                def11 = kwdOrDef;
                keyword2 = def11.keyword;
                if (Array.isArray(keyword2) && !keyword2.length) {
                    throw new Error("addKeywords: keyword must be string or non-empty array");
                }
            } else {
                throw new Error("invalid addKeywords parameters");
            }
            checkKeyword.call(this, keyword2, def11);
            if (!def11) {
                (0, util.eachItem)(keyword2, (kwd)=>addRule.call(this, kwd)
                );
                return this;
            }
            keywordMetaschema.call(this, def11);
            const definition = {
                ...def11,
                type: (0, dataType.getJSONTypes)(def11.type),
                schemaType: (0, dataType.getJSONTypes)(def11.schemaType)
            };
            (0, util.eachItem)(keyword2, definition.type.length === 0 ? (k)=>addRule.call(this, k, definition)
             : (k)=>definition.type.forEach((t)=>addRule.call(this, k, definition, t)
                )
            );
            return this;
        }
        getKeyword(keyword2) {
            const rule = this.RULES.all[keyword2];
            return typeof rule == "object" ? rule.definition : !!rule;
        }
        removeKeyword(keyword2) {
            const { RULES  } = this;
            delete RULES.keywords[keyword2];
            delete RULES.all[keyword2];
            for (const group of RULES.rules){
                const i50 = group.rules.findIndex((rule)=>rule.keyword === keyword2
                );
                if (i50 >= 0) group.rules.splice(i50, 1);
            }
            return this;
        }
        addFormat(name95, format21) {
            if (typeof format21 == "string") format21 = new RegExp(format21);
            this.formats[name95] = format21;
            return this;
        }
        errorsText(errors2 = this.errors, { separator =", " , dataVar ="data"  } = {}) {
            if (!errors2 || errors2.length === 0) return "No errors";
            return errors2.map((e)=>`${dataVar}${e.instancePath} ${e.message}`
            ).reduce((text, msg)=>text + separator + msg
            );
        }
        $dataMetaSchema(metaSchema, keywordsJsonPointers) {
            const rules2 = this.RULES.all;
            metaSchema = JSON.parse(JSON.stringify(metaSchema));
            for (const jsonPointer of keywordsJsonPointers){
                const segments = jsonPointer.split("/").slice(1);
                let keywords1 = metaSchema;
                for (const seg of segments)keywords1 = keywords1[seg];
                for(const key in rules2){
                    const rule = rules2[key];
                    if (typeof rule != "object") continue;
                    const { $data  } = rule.definition;
                    const schema = keywords1[key];
                    if ($data && schema) keywords1[key] = schemaOrData(schema);
                }
            }
            return metaSchema;
        }
        _removeAllSchemas(schemas, regex) {
            for(const keyRef in schemas){
                const sch = schemas[keyRef];
                if (!regex || regex.test(keyRef)) {
                    if (typeof sch == "string") {
                        delete schemas[keyRef];
                    } else if (sch && !sch.meta) {
                        this._cache.delete(sch.schema);
                        delete schemas[keyRef];
                    }
                }
            }
        }
        _addSchema(schema, meta, baseId, validateSchema = this.opts.validateSchema, addSchema = this.opts.addUsedSchema) {
            let id2;
            const { schemaId  } = this.opts;
            if (typeof schema == "object") {
                id2 = schema[schemaId];
            } else {
                if (this.opts.jtd) throw new Error("schema must be object");
                else if (typeof schema != "boolean") throw new Error("schema must be object or boolean");
            }
            let sch = this._cache.get(schema);
            if (sch !== void 0) return sch;
            baseId = (0, resolve3.normalizeId)(id2 || baseId);
            const localRefs = resolve3.getSchemaRefs.call(this, schema, baseId);
            sch = new compile.SchemaEnv({
                schema,
                schemaId,
                meta,
                baseId,
                localRefs
            });
            this._cache.set(sch.schema, sch);
            if (addSchema && !baseId.startsWith("#")) {
                if (baseId) this._checkUnique(baseId);
                this.refs[baseId] = sch;
            }
            if (validateSchema) this.validateSchema(schema, true);
            return sch;
        }
        _checkUnique(id2) {
            if (this.schemas[id2] || this.refs[id2]) {
                throw new Error(`schema with key or id "${id2}" already exists`);
            }
        }
        _compileSchemaEnv(sch) {
            if (sch.meta) this._compileMetaSchema(sch);
            else compile.compileSchema.call(this, sch);
            if (!sch.validate) throw new Error("ajv implementation error");
            return sch.validate;
        }
        _compileMetaSchema(sch) {
            const currentOpts = this.opts;
            this.opts = this._metaOpts;
            try {
                compile.compileSchema.call(this, sch);
            } finally{
                this.opts = currentOpts;
            }
        }
    }
    exports.default = Ajv;
    Ajv.ValidationError = validation_error.default;
    Ajv.MissingRefError = ref_error.default;
    function checkOptions(checkOpts, options, msg, log = "error") {
        for(const key in checkOpts){
            const opt = key;
            if (opt in options) this.logger[log](`${msg}: option ${key}. ${checkOpts[opt]}`);
        }
    }
    function getSchEnv(keyRef) {
        keyRef = (0, resolve3.normalizeId)(keyRef);
        return this.schemas[keyRef] || this.refs[keyRef];
    }
    function addInitialSchemas() {
        const optsSchemas = this.opts.schemas;
        if (!optsSchemas) return;
        if (Array.isArray(optsSchemas)) this.addSchema(optsSchemas);
        else for(const key in optsSchemas)this.addSchema(optsSchemas[key], key);
    }
    function addInitialFormats() {
        for(const name96 in this.opts.formats){
            const format22 = this.opts.formats[name96];
            if (format22) this.addFormat(name96, format22);
        }
    }
    function addInitialKeywords(defs) {
        if (Array.isArray(defs)) {
            this.addVocabulary(defs);
            return;
        }
        this.logger.warn("keywords option as map is deprecated, pass array");
        for(const keyword2 in defs){
            const def12 = defs[keyword2];
            if (!def12.keyword) def12.keyword = keyword2;
            this.addKeyword(def12);
        }
    }
    function getMetaSchemaOptions() {
        const metaOpts = {
            ...this.opts
        };
        for (const opt of META_IGNORE_OPTIONS)delete metaOpts[opt];
        return metaOpts;
    }
    const noLogs = {
        log () {},
        warn () {},
        error () {}
    };
    function getLogger1(logger) {
        if (logger === false) return noLogs;
        if (logger === void 0) return console;
        if (logger.log && logger.warn && logger.error) return logger;
        throw new Error("logger must implement log, warn and error methods");
    }
    const KEYWORD_NAME = /^[a-z_$][a-z0-9_$:-]*$/i;
    function checkKeyword(keyword2, def13) {
        const { RULES  } = this;
        (0, util.eachItem)(keyword2, (kwd)=>{
            if (RULES.keywords[kwd]) throw new Error(`Keyword ${kwd} is already defined`);
            if (!KEYWORD_NAME.test(kwd)) throw new Error(`Keyword ${kwd} has invalid name`);
        });
        if (!def13) return;
        if (def13.$data && !("code" in def13 || "validate" in def13)) {
            throw new Error('$data keyword must have "code" or "validate" function');
        }
    }
    function addRule(keyword2, definition, dataType$1) {
        var _a;
        const post = definition === null || definition === void 0 ? void 0 : definition.post;
        if (dataType$1 && post) throw new Error('keyword with "post" flag cannot have "type"');
        const { RULES  } = this;
        let ruleGroup = post ? RULES.post : RULES.rules.find(({ type: t  })=>t === dataType$1
        );
        if (!ruleGroup) {
            ruleGroup = {
                type: dataType$1,
                rules: []
            };
            RULES.rules.push(ruleGroup);
        }
        RULES.keywords[keyword2] = true;
        if (!definition) return;
        const rule = {
            keyword: keyword2,
            definition: {
                ...definition,
                type: (0, dataType.getJSONTypes)(definition.type),
                schemaType: (0, dataType.getJSONTypes)(definition.schemaType)
            }
        };
        if (definition.before) addBeforeRule.call(this, ruleGroup, rule, definition.before);
        else ruleGroup.rules.push(rule);
        RULES.all[keyword2] = rule;
        (_a = definition.implements) === null || _a === void 0 ? void 0 : _a.forEach((kwd)=>this.addKeyword(kwd)
        );
    }
    function addBeforeRule(ruleGroup, rule, before) {
        const i51 = ruleGroup.rules.findIndex((_rule)=>_rule.keyword === before
        );
        if (i51 >= 0) {
            ruleGroup.rules.splice(i51, 0, rule);
        } else {
            ruleGroup.rules.push(rule);
            this.logger.warn(`rule ${before} is not defined`);
        }
    }
    function keywordMetaschema(def14) {
        let { metaSchema  } = def14;
        if (metaSchema === void 0) return;
        if (def14.$data && this.opts.$data) metaSchema = schemaOrData(metaSchema);
        def14.validateSchema = this.compile(metaSchema, true);
    }
    const $dataRef = {
        $ref: "https://raw.githubusercontent.com/ajv-validator/ajv/master/lib/refs/data.json#"
    };
    function schemaOrData(schema) {
        return {
            anyOf: [
                schema,
                $dataRef
            ]
        };
    }
});
var id = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const def15 = {
        keyword: "id",
        code () {
            throw new Error('NOT SUPPORTED: keyword "id", use "$id" for schema ID');
        }
    };
    exports.default = def15;
});
var ref = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.callRef = exports.getValidate = void 0;
    const def16 = {
        keyword: "$ref",
        schemaType: "string",
        code (cxt) {
            const { gen , schema: $ref , it  } = cxt;
            const { baseId , schemaEnv: env , validateName , opts , self  } = it;
            const { root: root11  } = env;
            if (($ref === "#" || $ref === "#/") && baseId === root11.baseId) return callRootRef();
            const schOrEnv = compile.resolveRef.call(self, root11, baseId, $ref);
            if (schOrEnv === void 0) throw new ref_error.default(baseId, $ref);
            if (schOrEnv instanceof compile.SchemaEnv) return callValidate(schOrEnv);
            return inlineRefSchema(schOrEnv);
            function callRootRef() {
                if (env === root11) return callRef(cxt, validateName, env, env.$async);
                const rootName = gen.scopeValue("root", {
                    ref: root11
                });
                return callRef(cxt, codegen._`${rootName}.validate`, root11, root11.$async);
            }
            function callValidate(sch) {
                const v = getValidate(cxt, sch);
                callRef(cxt, v, sch, sch.$async);
            }
            function inlineRefSchema(sch) {
                const schName = gen.scopeValue("schema", opts.code.source === true ? {
                    ref: sch,
                    code: (0, codegen.stringify)(sch)
                } : {
                    ref: sch
                });
                const valid = gen.name("valid");
                const schCxt = cxt.subschema({
                    schema: sch,
                    dataTypes: [],
                    schemaPath: codegen.nil,
                    topSchemaRef: schName,
                    errSchemaPath: $ref
                }, valid);
                cxt.mergeEvaluated(schCxt);
                cxt.ok(valid);
            }
        }
    };
    function getValidate(cxt, sch) {
        const { gen  } = cxt;
        return sch.validate ? gen.scopeValue("validate", {
            ref: sch.validate
        }) : codegen._`${gen.scopeValue("wrapper", {
            ref: sch
        })}.validate`;
    }
    exports.getValidate = getValidate;
    function callRef(cxt, v, sch, $async) {
        const { gen , it  } = cxt;
        const { allErrors , schemaEnv: env , opts  } = it;
        const passCxt = opts.passContext ? names_1.default.this : codegen.nil;
        if ($async) callAsyncRef();
        else callSyncRef();
        function callAsyncRef() {
            if (!env.$async) throw new Error("async schema referenced by sync schema");
            const valid = gen.let("valid");
            gen.try(()=>{
                gen.code(codegen._`await ${(0, code$1.callValidateCode)(cxt, v, passCxt)}`);
                addEvaluatedFrom(v);
                if (!allErrors) gen.assign(valid, true);
            }, (e)=>{
                gen.if(codegen._`!(${e} instanceof ${it.ValidationError})`, ()=>gen.throw(e)
                );
                addErrorsFrom(e);
                if (!allErrors) gen.assign(valid, false);
            });
            cxt.ok(valid);
        }
        function callSyncRef() {
            cxt.result((0, code$1.callValidateCode)(cxt, v, passCxt), ()=>addEvaluatedFrom(v)
            , ()=>addErrorsFrom(v)
            );
        }
        function addErrorsFrom(source) {
            const errs = codegen._`${source}.errors`;
            gen.assign(names_1.default.vErrors, codegen._`${names_1.default.vErrors} === null ? ${errs} : ${names_1.default.vErrors}.concat(${errs})`);
            gen.assign(names_1.default.errors, codegen._`${names_1.default.vErrors}.length`);
        }
        function addEvaluatedFrom(source) {
            var _a;
            if (!it.opts.unevaluated) return;
            const schEvaluated = (_a = sch === null || sch === void 0 ? void 0 : sch.validate) === null || _a === void 0 ? void 0 : _a.evaluated;
            if (it.props !== true) {
                if (schEvaluated && !schEvaluated.dynamicProps) {
                    if (schEvaluated.props !== void 0) {
                        it.props = util.mergeEvaluated.props(gen, schEvaluated.props, it.props);
                    }
                } else {
                    const props = gen.var("props", codegen._`${source}.evaluated.props`);
                    it.props = util.mergeEvaluated.props(gen, props, it.props, codegen.Name);
                }
            }
            if (it.items !== true) {
                if (schEvaluated && !schEvaluated.dynamicItems) {
                    if (schEvaluated.items !== void 0) {
                        it.items = util.mergeEvaluated.items(gen, schEvaluated.items, it.items);
                    }
                } else {
                    const items2 = gen.var("items", codegen._`${source}.evaluated.items`);
                    it.items = util.mergeEvaluated.items(gen, items2, it.items, codegen.Name);
                }
            }
        }
    }
    exports.callRef = callRef;
    exports.default = def16;
});
var core_1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const core2 = [
        "$schema",
        "$id",
        "$defs",
        "$vocabulary",
        {
            keyword: "$comment"
        },
        "definitions",
        id.default,
        ref.default
    ];
    exports.default = core2;
});
var limitNumber = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const ops = codegen.operators;
    const KWDs = {
        maximum: {
            okStr: "<=",
            ok: ops.LTE,
            fail: ops.GT
        },
        minimum: {
            okStr: ">=",
            ok: ops.GTE,
            fail: ops.LT
        },
        exclusiveMaximum: {
            okStr: "<",
            ok: ops.LT,
            fail: ops.GTE
        },
        exclusiveMinimum: {
            okStr: ">",
            ok: ops.GT,
            fail: ops.LTE
        }
    };
    const error24 = {
        message: ({ keyword: keyword2 , schemaCode  })=>codegen.str`must be ${KWDs[keyword2].okStr} ${schemaCode}`
        ,
        params: ({ keyword: keyword2 , schemaCode  })=>codegen._`{comparison: ${KWDs[keyword2].okStr}, limit: ${schemaCode}}`
    };
    const def17 = {
        keyword: Object.keys(KWDs),
        type: "number",
        schemaType: "number",
        $data: true,
        error: error24,
        code (cxt) {
            const { keyword: keyword2 , data: data65 , schemaCode  } = cxt;
            cxt.fail$data(codegen._`${data65} ${KWDs[keyword2].fail} ${schemaCode} || isNaN(${data65})`);
        }
    };
    exports.default = def17;
});
var multipleOf = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error25 = {
        message: ({ schemaCode  })=>codegen.str`must be multiple of ${schemaCode}`
        ,
        params: ({ schemaCode  })=>codegen._`{multipleOf: ${schemaCode}}`
    };
    const def18 = {
        keyword: "multipleOf",
        type: "number",
        schemaType: "number",
        $data: true,
        error: error25,
        code (cxt) {
            const { gen , data: data66 , schemaCode , it  } = cxt;
            const prec = it.opts.multipleOfPrecision;
            const res = gen.let("res");
            const invalid = prec ? codegen._`Math.abs(Math.round(${res}) - ${res}) > 1e-${prec}` : codegen._`${res} !== parseInt(${res})`;
            cxt.fail$data(codegen._`(${schemaCode} === 0 || (${res} = ${data66}/${schemaCode}, ${invalid}))`);
        }
    };
    exports.default = def18;
});
var ucs2length_1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    function ucs2length(str2) {
        const len4 = str2.length;
        let length = 0;
        let pos = 0;
        let value;
        while(pos < len4){
            length++;
            value = str2.charCodeAt(pos++);
            if (value >= 55296 && value <= 56319 && pos < len4) {
                value = str2.charCodeAt(pos);
                if ((value & 64512) === 56320) pos++;
            }
        }
        return length;
    }
    exports.default = ucs2length;
    ucs2length.code = 'require("ajv/dist/runtime/ucs2length").default';
});
var limitLength = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error26 = {
        message ({ keyword: keyword2 , schemaCode  }) {
            const comp = keyword2 === "maxLength" ? "more" : "fewer";
            return codegen.str`must NOT have ${comp} than ${schemaCode} characters`;
        },
        params: ({ schemaCode  })=>codegen._`{limit: ${schemaCode}}`
    };
    const def19 = {
        keyword: [
            "maxLength",
            "minLength"
        ],
        type: "string",
        schemaType: "number",
        $data: true,
        error: error26,
        code (cxt) {
            const { keyword: keyword2 , data: data67 , schemaCode , it  } = cxt;
            const op = keyword2 === "maxLength" ? codegen.operators.GT : codegen.operators.LT;
            const len5 = it.opts.unicode === false ? codegen._`${data67}.length` : codegen._`${(0, util.useFunc)(cxt.gen, ucs2length_1.default)}(${data67})`;
            cxt.fail$data(codegen._`${len5} ${op} ${schemaCode}`);
        }
    };
    exports.default = def19;
});
var pattern = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error27 = {
        message: ({ schemaCode  })=>codegen.str`must match pattern "${schemaCode}"`
        ,
        params: ({ schemaCode  })=>codegen._`{pattern: ${schemaCode}}`
    };
    const def20 = {
        keyword: "pattern",
        type: "string",
        schemaType: "string",
        $data: true,
        error: error27,
        code (cxt) {
            const { data: data68 , $data , schema , schemaCode , it  } = cxt;
            const u = it.opts.unicodeRegExp ? "u" : "";
            const regExp = $data ? codegen._`(new RegExp(${schemaCode}, ${u}))` : (0, code$1.usePattern)(cxt, schema);
            cxt.fail$data(codegen._`!${regExp}.test(${data68})`);
        }
    };
    exports.default = def20;
});
var limitProperties = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error28 = {
        message ({ keyword: keyword2 , schemaCode  }) {
            const comp = keyword2 === "maxProperties" ? "more" : "fewer";
            return codegen.str`must NOT have ${comp} than ${schemaCode} items`;
        },
        params: ({ schemaCode  })=>codegen._`{limit: ${schemaCode}}`
    };
    const def21 = {
        keyword: [
            "maxProperties",
            "minProperties"
        ],
        type: "object",
        schemaType: "number",
        $data: true,
        error: error28,
        code (cxt) {
            const { keyword: keyword2 , data: data69 , schemaCode  } = cxt;
            const op = keyword2 === "maxProperties" ? codegen.operators.GT : codegen.operators.LT;
            cxt.fail$data(codegen._`Object.keys(${data69}).length ${op} ${schemaCode}`);
        }
    };
    exports.default = def21;
});
var required$1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error29 = {
        message: ({ params: { missingProperty  }  })=>codegen.str`must have required property '${missingProperty}'`
        ,
        params: ({ params: { missingProperty  }  })=>codegen._`{missingProperty: ${missingProperty}}`
    };
    const def22 = {
        keyword: "required",
        type: "object",
        schemaType: "array",
        $data: true,
        error: error29,
        code (cxt) {
            const { gen , schema , schemaCode , data: data70 , $data , it  } = cxt;
            const { opts  } = it;
            if (!$data && schema.length === 0) return;
            const useLoop = schema.length >= opts.loopRequired;
            if (it.allErrors) allErrorsMode();
            else exitOnErrorMode();
            if (opts.strictRequired) {
                const props = cxt.parentSchema.properties;
                const { definedProperties  } = cxt.it;
                for (const requiredKey of schema){
                    if ((props === null || props === void 0 ? void 0 : props[requiredKey]) === void 0 && !definedProperties.has(requiredKey)) {
                        const schemaPath = it.schemaEnv.baseId + it.errSchemaPath;
                        const msg = `required property "${requiredKey}" is not defined at "${schemaPath}" (strictRequired)`;
                        (0, util.checkStrictMode)(it, msg, it.opts.strictRequired);
                    }
                }
            }
            function allErrorsMode() {
                if (useLoop || $data) {
                    cxt.block$data(codegen.nil, loopAllRequired);
                } else {
                    for (const prop of schema){
                        (0, code$1.checkReportMissingProp)(cxt, prop);
                    }
                }
            }
            function exitOnErrorMode() {
                const missing = gen.let("missing");
                if (useLoop || $data) {
                    const valid = gen.let("valid", true);
                    cxt.block$data(valid, ()=>loopUntilMissing(missing, valid)
                    );
                    cxt.ok(valid);
                } else {
                    gen.if((0, code$1.checkMissingProp)(cxt, schema, missing));
                    (0, code$1.reportMissingProp)(cxt, missing);
                    gen.else();
                }
            }
            function loopAllRequired() {
                gen.forOf("prop", schemaCode, (prop)=>{
                    cxt.setParams({
                        missingProperty: prop
                    });
                    gen.if((0, code$1.noPropertyInData)(gen, data70, prop, opts.ownProperties), ()=>cxt.error()
                    );
                });
            }
            function loopUntilMissing(missing, valid) {
                cxt.setParams({
                    missingProperty: missing
                });
                gen.forOf(missing, schemaCode, ()=>{
                    gen.assign(valid, (0, code$1.propertyInData)(gen, data70, missing, opts.ownProperties));
                    gen.if((0, codegen.not)(valid), ()=>{
                        cxt.error();
                        gen.break();
                    });
                }, codegen.nil);
            }
        }
    };
    exports.default = def22;
});
var limitItems = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error30 = {
        message ({ keyword: keyword2 , schemaCode  }) {
            const comp = keyword2 === "maxItems" ? "more" : "fewer";
            return codegen.str`must NOT have ${comp} than ${schemaCode} items`;
        },
        params: ({ schemaCode  })=>codegen._`{limit: ${schemaCode}}`
    };
    const def23 = {
        keyword: [
            "maxItems",
            "minItems"
        ],
        type: "array",
        schemaType: "number",
        $data: true,
        error: error30,
        code (cxt) {
            const { keyword: keyword2 , data: data71 , schemaCode  } = cxt;
            const op = keyword2 === "maxItems" ? codegen.operators.GT : codegen.operators.LT;
            cxt.fail$data(codegen._`${data71}.length ${op} ${schemaCode}`);
        }
    };
    exports.default = def23;
});
var equal_1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    fastDeepEqual.code = 'require("ajv/dist/runtime/equal").default';
    exports.default = fastDeepEqual;
});
var uniqueItems = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error31 = {
        message: ({ params: { i: i52 , j  }  })=>codegen.str`must NOT have duplicate items (items ## ${j} and ${i52} are identical)`
        ,
        params: ({ params: { i: i53 , j  }  })=>codegen._`{i: ${i53}, j: ${j}}`
    };
    const def24 = {
        keyword: "uniqueItems",
        type: "array",
        schemaType: "boolean",
        $data: true,
        error: error31,
        code (cxt) {
            const { gen , data: data72 , $data , schema , parentSchema , schemaCode , it  } = cxt;
            if (!$data && !schema) return;
            const valid = gen.let("valid");
            const itemTypes = parentSchema.items ? (0, dataType.getSchemaTypes)(parentSchema.items) : [];
            cxt.block$data(valid, validateUniqueItems, codegen._`${schemaCode} === false`);
            cxt.ok(valid);
            function validateUniqueItems() {
                const i54 = gen.let("i", codegen._`${data72}.length`);
                const j = gen.let("j");
                cxt.setParams({
                    i: i54,
                    j
                });
                gen.assign(valid, true);
                gen.if(codegen._`${i54} > 1`, ()=>(canOptimize() ? loopN : loopN2)(i54, j)
                );
            }
            function canOptimize() {
                return itemTypes.length > 0 && !itemTypes.some((t)=>t === "object" || t === "array"
                );
            }
            function loopN(i55, j) {
                const item = gen.name("item");
                const wrongType = (0, dataType.checkDataTypes)(itemTypes, item, it.opts.strictNumbers, dataType.DataType.Wrong);
                const indices = gen.const("indices", codegen._`{}`);
                gen.for(codegen._`;${i55}--;`, ()=>{
                    gen.let(item, codegen._`${data72}[${i55}]`);
                    gen.if(wrongType, codegen._`continue`);
                    if (itemTypes.length > 1) gen.if(codegen._`typeof ${item} == "string"`, codegen._`${item} += "_"`);
                    gen.if(codegen._`typeof ${indices}[${item}] == "number"`, ()=>{
                        gen.assign(j, codegen._`${indices}[${item}]`);
                        cxt.error();
                        gen.assign(valid, false).break();
                    }).code(codegen._`${indices}[${item}] = ${i55}`);
                });
            }
            function loopN2(i56, j) {
                const eql = (0, util.useFunc)(gen, equal_1.default);
                const outer = gen.name("outer");
                gen.label(outer).for(codegen._`;${i56}--;`, ()=>gen.for(codegen._`${j} = ${i56}; ${j}--;`, ()=>gen.if(codegen._`${eql}(${data72}[${i56}], ${data72}[${j}])`, ()=>{
                            cxt.error();
                            gen.assign(valid, false).break(outer);
                        })
                    )
                );
            }
        }
    };
    exports.default = def24;
});
var _const = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error32 = {
        message: "must be equal to constant",
        params: ({ schemaCode  })=>codegen._`{allowedValue: ${schemaCode}}`
    };
    const def25 = {
        keyword: "const",
        $data: true,
        error: error32,
        code (cxt) {
            const { gen , data: data73 , $data , schemaCode , schema  } = cxt;
            if ($data || schema && typeof schema == "object") {
                cxt.fail$data(codegen._`!${(0, util.useFunc)(gen, equal_1.default)}(${data73}, ${schemaCode})`);
            } else {
                cxt.fail(codegen._`${schema} !== ${data73}`);
            }
        }
    };
    exports.default = def25;
});
var _enum = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error33 = {
        message: "must be equal to one of the allowed values",
        params: ({ schemaCode  })=>codegen._`{allowedValues: ${schemaCode}}`
    };
    const def26 = {
        keyword: "enum",
        schemaType: "array",
        $data: true,
        error: error33,
        code (cxt) {
            const { gen , data: data74 , $data , schema , schemaCode , it  } = cxt;
            if (!$data && schema.length === 0) throw new Error("enum must have non-empty array");
            const useLoop = schema.length >= it.opts.loopEnum;
            const eql = (0, util.useFunc)(gen, equal_1.default);
            let valid;
            if (useLoop || $data) {
                valid = gen.let("valid");
                cxt.block$data(valid, loopEnum);
            } else {
                if (!Array.isArray(schema)) throw new Error("ajv implementation error");
                const vSchema = gen.const("vSchema", schemaCode);
                valid = (0, codegen.or)(...schema.map((_x, i57)=>equalCode(vSchema, i57)
                ));
            }
            cxt.pass(valid);
            function loopEnum() {
                gen.assign(valid, false);
                gen.forOf("v", schemaCode, (v)=>gen.if(codegen._`${eql}(${data74}, ${v})`, ()=>gen.assign(valid, true).break()
                    )
                );
            }
            function equalCode(vSchema, i58) {
                const sch = schema[i58];
                return typeof sch === "object" && sch !== null ? codegen._`${eql}(${data74}, ${vSchema}[${i58}])` : codegen._`${data74} === ${sch}`;
            }
        }
    };
    exports.default = def26;
});
var validation_1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const validation = [
        limitNumber.default,
        multipleOf.default,
        limitLength.default,
        pattern.default,
        limitProperties.default,
        required$1.default,
        limitItems.default,
        uniqueItems.default,
        {
            keyword: "type",
            schemaType: [
                "string",
                "array"
            ]
        },
        {
            keyword: "nullable",
            schemaType: "boolean"
        },
        _const.default,
        _enum.default
    ];
    exports.default = validation;
});
var additionalItems = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.validateAdditionalItems = void 0;
    const error34 = {
        message: ({ params: { len: len6  }  })=>codegen.str`must NOT have more than ${len6} items`
        ,
        params: ({ params: { len: len7  }  })=>codegen._`{limit: ${len7}}`
    };
    const def27 = {
        keyword: "additionalItems",
        type: "array",
        schemaType: [
            "boolean",
            "object"
        ],
        before: "uniqueItems",
        error: error34,
        code (cxt) {
            const { parentSchema , it  } = cxt;
            const { items: items2  } = parentSchema;
            if (!Array.isArray(items2)) {
                (0, util.checkStrictMode)(it, '"additionalItems" is ignored when "items" is not an array of schemas');
                return;
            }
            validateAdditionalItems(cxt, items2);
        }
    };
    function validateAdditionalItems(cxt, items2) {
        const { gen , schema , data: data75 , keyword: keyword2 , it  } = cxt;
        it.items = true;
        const len8 = gen.const("len", codegen._`${data75}.length`);
        if (schema === false) {
            cxt.setParams({
                len: items2.length
            });
            cxt.pass(codegen._`${len8} <= ${items2.length}`);
        } else if (typeof schema == "object" && !(0, util.alwaysValidSchema)(it, schema)) {
            const valid = gen.var("valid", codegen._`${len8} <= ${items2.length}`);
            gen.if((0, codegen.not)(valid), ()=>validateItems(valid)
            );
            cxt.ok(valid);
        }
        function validateItems(valid) {
            gen.forRange("i", items2.length, len8, (i59)=>{
                cxt.subschema({
                    keyword: keyword2,
                    dataProp: i59,
                    dataPropType: util.Type.Num
                }, valid);
                if (!it.allErrors) gen.if((0, codegen.not)(valid), ()=>gen.break()
                );
            });
        }
    }
    exports.validateAdditionalItems = validateAdditionalItems;
    exports.default = def27;
});
var items = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.validateTuple = void 0;
    const def28 = {
        keyword: "items",
        type: "array",
        schemaType: [
            "object",
            "array",
            "boolean"
        ],
        before: "uniqueItems",
        code (cxt) {
            const { schema , it  } = cxt;
            if (Array.isArray(schema)) return validateTuple(cxt, "additionalItems", schema);
            it.items = true;
            if ((0, util.alwaysValidSchema)(it, schema)) return;
            cxt.ok((0, code$1.validateArray)(cxt));
        }
    };
    function validateTuple(cxt, extraItems, schArr = cxt.schema) {
        const { gen , parentSchema , data: data76 , keyword: keyword2 , it  } = cxt;
        checkStrictTuple(parentSchema);
        if (it.opts.unevaluated && schArr.length && it.items !== true) {
            it.items = util.mergeEvaluated.items(gen, schArr.length, it.items);
        }
        const valid = gen.name("valid");
        const len9 = gen.const("len", codegen._`${data76}.length`);
        schArr.forEach((sch, i60)=>{
            if ((0, util.alwaysValidSchema)(it, sch)) return;
            gen.if(codegen._`${len9} > ${i60}`, ()=>cxt.subschema({
                    keyword: keyword2,
                    schemaProp: i60,
                    dataProp: i60
                }, valid)
            );
            cxt.ok(valid);
        });
        function checkStrictTuple(sch) {
            const { opts , errSchemaPath  } = it;
            const l = schArr.length;
            const fullTuple = l === sch.minItems && (l === sch.maxItems || sch[extraItems] === false);
            if (opts.strictTuples && !fullTuple) {
                const msg = `"${keyword2}" is ${l}-tuple, but minItems or maxItems/${extraItems} are not specified or different at path "${errSchemaPath}"`;
                (0, util.checkStrictMode)(it, msg, opts.strictTuples);
            }
        }
    }
    exports.validateTuple = validateTuple;
    exports.default = def28;
});
var prefixItems = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const def29 = {
        keyword: "prefixItems",
        type: "array",
        schemaType: [
            "array"
        ],
        before: "uniqueItems",
        code: (cxt)=>(0, items.validateTuple)(cxt, "items")
    };
    exports.default = def29;
});
var items2020 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error35 = {
        message: ({ params: { len: len10  }  })=>codegen.str`must NOT have more than ${len10} items`
        ,
        params: ({ params: { len: len11  }  })=>codegen._`{limit: ${len11}}`
    };
    const def30 = {
        keyword: "items",
        type: "array",
        schemaType: [
            "object",
            "boolean"
        ],
        before: "uniqueItems",
        error: error35,
        code (cxt) {
            const { schema , parentSchema , it  } = cxt;
            const { prefixItems: prefixItems2  } = parentSchema;
            it.items = true;
            if ((0, util.alwaysValidSchema)(it, schema)) return;
            if (prefixItems2) (0, additionalItems.validateAdditionalItems)(cxt, prefixItems2);
            else cxt.ok((0, code$1.validateArray)(cxt));
        }
    };
    exports.default = def30;
});
var contains = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error36 = {
        message: ({ params: { min , max  }  })=>max === void 0 ? codegen.str`must contain at least ${min} valid item(s)` : codegen.str`must contain at least ${min} and no more than ${max} valid item(s)`
        ,
        params: ({ params: { min , max  }  })=>max === void 0 ? codegen._`{minContains: ${min}}` : codegen._`{minContains: ${min}, maxContains: ${max}}`
    };
    const def31 = {
        keyword: "contains",
        type: "array",
        schemaType: [
            "object",
            "boolean"
        ],
        before: "uniqueItems",
        trackErrors: true,
        error: error36,
        code (cxt) {
            const { gen , schema , parentSchema , data: data77 , it  } = cxt;
            let min;
            let max;
            const { minContains , maxContains  } = parentSchema;
            if (it.opts.next) {
                min = minContains === void 0 ? 1 : minContains;
                max = maxContains;
            } else {
                min = 1;
            }
            const len12 = gen.const("len", codegen._`${data77}.length`);
            cxt.setParams({
                min,
                max
            });
            if (max === void 0 && min === 0) {
                (0, util.checkStrictMode)(it, `"minContains" == 0 without "maxContains": "contains" keyword ignored`);
                return;
            }
            if (max !== void 0 && min > max) {
                (0, util.checkStrictMode)(it, `"minContains" > "maxContains" is always invalid`);
                cxt.fail();
                return;
            }
            if ((0, util.alwaysValidSchema)(it, schema)) {
                let cond = codegen._`${len12} >= ${min}`;
                if (max !== void 0) cond = codegen._`${cond} && ${len12} <= ${max}`;
                cxt.pass(cond);
                return;
            }
            it.items = true;
            const valid = gen.name("valid");
            if (max === void 0 && min === 1) {
                validateItems(valid, ()=>gen.if(valid, ()=>gen.break()
                    )
                );
            } else if (min === 0) {
                gen.let(valid, true);
                if (max !== void 0) gen.if(codegen._`${data77}.length > 0`, validateItemsWithCount);
            } else {
                gen.let(valid, false);
                validateItemsWithCount();
            }
            cxt.result(valid, ()=>cxt.reset()
            );
            function validateItemsWithCount() {
                const schValid = gen.name("_valid");
                const count = gen.let("count", 0);
                validateItems(schValid, ()=>gen.if(schValid, ()=>checkLimits(count)
                    )
                );
            }
            function validateItems(_valid, block) {
                gen.forRange("i", 0, len12, (i61)=>{
                    cxt.subschema({
                        keyword: "contains",
                        dataProp: i61,
                        dataPropType: util.Type.Num,
                        compositeRule: true
                    }, _valid);
                    block();
                });
            }
            function checkLimits(count) {
                gen.code(codegen._`${count}++`);
                if (max === void 0) {
                    gen.if(codegen._`${count} >= ${min}`, ()=>gen.assign(valid, true).break()
                    );
                } else {
                    gen.if(codegen._`${count} > ${max}`, ()=>gen.assign(valid, false).break()
                    );
                    if (min === 1) gen.assign(valid, true);
                    else gen.if(codegen._`${count} >= ${min}`, ()=>gen.assign(valid, true)
                    );
                }
            }
        }
    };
    exports.default = def31;
});
var dependencies = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.validateSchemaDeps = exports.validatePropertyDeps = exports.error = void 0;
    exports.error = {
        message: ({ params: { property: property5 , depsCount , deps  }  })=>{
            const property_ies = depsCount === 1 ? "property" : "properties";
            return codegen.str`must have ${property_ies} ${deps} when property ${property5} is present`;
        },
        params: ({ params: { property: property6 , depsCount , deps , missingProperty  }  })=>codegen._`{property: ${property6},
    missingProperty: ${missingProperty},
    depsCount: ${depsCount},
    deps: ${deps}}`
    };
    const def32 = {
        keyword: "dependencies",
        type: "object",
        schemaType: "object",
        error: exports.error,
        code (cxt) {
            const [propDeps, schDeps] = splitDependencies(cxt);
            validatePropertyDeps(cxt, propDeps);
            validateSchemaDeps(cxt, schDeps);
        }
    };
    function splitDependencies({ schema  }) {
        const propertyDeps = {};
        const schemaDeps = {};
        for(const key in schema){
            if (key === "__proto__") continue;
            const deps = Array.isArray(schema[key]) ? propertyDeps : schemaDeps;
            deps[key] = schema[key];
        }
        return [
            propertyDeps,
            schemaDeps
        ];
    }
    function validatePropertyDeps(cxt, propertyDeps = cxt.schema) {
        const { gen , data: data78 , it  } = cxt;
        if (Object.keys(propertyDeps).length === 0) return;
        const missing = gen.let("missing");
        for(const prop in propertyDeps){
            const deps = propertyDeps[prop];
            if (deps.length === 0) continue;
            const hasProperty = (0, code$1.propertyInData)(gen, data78, prop, it.opts.ownProperties);
            cxt.setParams({
                property: prop,
                depsCount: deps.length,
                deps: deps.join(", ")
            });
            if (it.allErrors) {
                gen.if(hasProperty, ()=>{
                    for (const depProp of deps){
                        (0, code$1.checkReportMissingProp)(cxt, depProp);
                    }
                });
            } else {
                gen.if(codegen._`${hasProperty} && (${(0, code$1.checkMissingProp)(cxt, deps, missing)})`);
                (0, code$1.reportMissingProp)(cxt, missing);
                gen.else();
            }
        }
    }
    exports.validatePropertyDeps = validatePropertyDeps;
    function validateSchemaDeps(cxt, schemaDeps = cxt.schema) {
        const { gen , data: data79 , keyword: keyword2 , it  } = cxt;
        const valid = gen.name("valid");
        for(const prop in schemaDeps){
            if ((0, util.alwaysValidSchema)(it, schemaDeps[prop])) continue;
            gen.if((0, code$1.propertyInData)(gen, data79, prop, it.opts.ownProperties), ()=>{
                const schCxt = cxt.subschema({
                    keyword: keyword2,
                    schemaProp: prop
                }, valid);
                cxt.mergeValidEvaluated(schCxt, valid);
            }, ()=>gen.var(valid, true)
            );
            cxt.ok(valid);
        }
    }
    exports.validateSchemaDeps = validateSchemaDeps;
    exports.default = def32;
});
var propertyNames = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error37 = {
        message: "property name must be valid",
        params: ({ params  })=>codegen._`{propertyName: ${params.propertyName}}`
    };
    const def33 = {
        keyword: "propertyNames",
        type: "object",
        schemaType: [
            "object",
            "boolean"
        ],
        error: error37,
        code (cxt) {
            const { gen , schema , data: data80 , it  } = cxt;
            if ((0, util.alwaysValidSchema)(it, schema)) return;
            const valid = gen.name("valid");
            gen.forIn("key", data80, (key)=>{
                cxt.setParams({
                    propertyName: key
                });
                cxt.subschema({
                    keyword: "propertyNames",
                    data: key,
                    dataTypes: [
                        "string"
                    ],
                    propertyName: key,
                    compositeRule: true
                }, valid);
                gen.if((0, codegen.not)(valid), ()=>{
                    cxt.error(true);
                    if (!it.allErrors) gen.break();
                });
            });
            cxt.ok(valid);
        }
    };
    exports.default = def33;
});
var additionalProperties$1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error38 = {
        message: "must NOT have additional properties",
        params: ({ params  })=>codegen._`{additionalProperty: ${params.additionalProperty}}`
    };
    const def34 = {
        keyword: "additionalProperties",
        type: [
            "object"
        ],
        schemaType: [
            "boolean",
            "object"
        ],
        allowUndefined: true,
        trackErrors: true,
        error: error38,
        code (cxt) {
            const { gen , schema , parentSchema , data: data81 , errsCount , it  } = cxt;
            if (!errsCount) throw new Error("ajv implementation error");
            const { allErrors , opts  } = it;
            it.props = true;
            if (opts.removeAdditional !== "all" && (0, util.alwaysValidSchema)(it, schema)) return;
            const props = (0, code$1.allSchemaProperties)(parentSchema.properties);
            const patProps = (0, code$1.allSchemaProperties)(parentSchema.patternProperties);
            checkAdditionalProperties();
            cxt.ok(codegen._`${errsCount} === ${names_1.default.errors}`);
            function checkAdditionalProperties() {
                gen.forIn("key", data81, (key)=>{
                    if (!props.length && !patProps.length) additionalPropertyCode(key);
                    else gen.if(isAdditional(key), ()=>additionalPropertyCode(key)
                    );
                });
            }
            function isAdditional(key) {
                let definedProp;
                if (props.length > 8) {
                    const propsSchema = (0, util.schemaRefOrVal)(it, parentSchema.properties, "properties");
                    definedProp = (0, code$1.isOwnProperty)(gen, propsSchema, key);
                } else if (props.length) {
                    definedProp = (0, codegen.or)(...props.map((p)=>codegen._`${key} === ${p}`
                    ));
                } else {
                    definedProp = codegen.nil;
                }
                if (patProps.length) {
                    definedProp = (0, codegen.or)(definedProp, ...patProps.map((p)=>codegen._`${(0, code$1.usePattern)(cxt, p)}.test(${key})`
                    ));
                }
                return (0, codegen.not)(definedProp);
            }
            function deleteAdditional(key) {
                gen.code(codegen._`delete ${data81}[${key}]`);
            }
            function additionalPropertyCode(key) {
                if (opts.removeAdditional === "all" || opts.removeAdditional && schema === false) {
                    deleteAdditional(key);
                    return;
                }
                if (schema === false) {
                    cxt.setParams({
                        additionalProperty: key
                    });
                    cxt.error();
                    if (!allErrors) gen.break();
                    return;
                }
                if (typeof schema == "object" && !(0, util.alwaysValidSchema)(it, schema)) {
                    const valid = gen.name("valid");
                    if (opts.removeAdditional === "failing") {
                        applyAdditionalSchema(key, valid, false);
                        gen.if((0, codegen.not)(valid), ()=>{
                            cxt.reset();
                            deleteAdditional(key);
                        });
                    } else {
                        applyAdditionalSchema(key, valid);
                        if (!allErrors) gen.if((0, codegen.not)(valid), ()=>gen.break()
                        );
                    }
                }
            }
            function applyAdditionalSchema(key, valid, errors2) {
                const subschema2 = {
                    keyword: "additionalProperties",
                    dataProp: key,
                    dataPropType: util.Type.Str
                };
                if (errors2 === false) {
                    Object.assign(subschema2, {
                        compositeRule: true,
                        createErrors: false,
                        allErrors: false
                    });
                }
                cxt.subschema(subschema2, valid);
            }
        }
    };
    exports.default = def34;
});
var properties$1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const def35 = {
        keyword: "properties",
        type: "object",
        schemaType: "object",
        code (cxt) {
            const { gen , schema , parentSchema , data: data82 , it  } = cxt;
            if (it.opts.removeAdditional === "all" && parentSchema.additionalProperties === void 0) {
                additionalProperties$1.default.code(new validate.KeywordCxt(it, additionalProperties$1.default, "additionalProperties"));
            }
            const allProps = (0, code$1.allSchemaProperties)(schema);
            for (const prop2 of allProps){
                it.definedProperties.add(prop2);
            }
            if (it.opts.unevaluated && allProps.length && it.props !== true) {
                it.props = util.mergeEvaluated.props(gen, (0, util.toHash)(allProps), it.props);
            }
            const properties2 = allProps.filter((p)=>!(0, util.alwaysValidSchema)(it, schema[p])
            );
            if (properties2.length === 0) return;
            const valid = gen.name("valid");
            for (const prop1 of properties2){
                if (hasDefault(prop1)) {
                    applyPropertySchema(prop1);
                } else {
                    gen.if((0, code$1.propertyInData)(gen, data82, prop1, it.opts.ownProperties));
                    applyPropertySchema(prop1);
                    if (!it.allErrors) gen.else().var(valid, true);
                    gen.endIf();
                }
                cxt.it.definedProperties.add(prop1);
                cxt.ok(valid);
            }
            function hasDefault(prop) {
                return it.opts.useDefaults && !it.compositeRule && schema[prop].default !== void 0;
            }
            function applyPropertySchema(prop) {
                cxt.subschema({
                    keyword: "properties",
                    schemaProp: prop,
                    dataProp: prop
                }, valid);
            }
        }
    };
    exports.default = def35;
});
var patternProperties = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const util_2 = util;
    const def36 = {
        keyword: "patternProperties",
        type: "object",
        schemaType: "object",
        code (cxt) {
            const { gen , schema , data: data83 , parentSchema , it  } = cxt;
            const { opts  } = it;
            const patterns = (0, code$1.allSchemaProperties)(schema);
            const alwaysValidPatterns = patterns.filter((p)=>(0, util.alwaysValidSchema)(it, schema[p])
            );
            if (patterns.length === 0 || alwaysValidPatterns.length === patterns.length && (!it.opts.unevaluated || it.props === true)) {
                return;
            }
            const checkProperties = opts.strictSchema && !opts.allowMatchingProperties && parentSchema.properties;
            const valid = gen.name("valid");
            if (it.props !== true && !(it.props instanceof codegen.Name)) {
                it.props = (0, util_2.evaluatedPropsToName)(gen, it.props);
            }
            const { props  } = it;
            validatePatternProperties();
            function validatePatternProperties() {
                for (const pat of patterns){
                    if (checkProperties) checkMatchingProperties(pat);
                    if (it.allErrors) {
                        validateProperties(pat);
                    } else {
                        gen.var(valid, true);
                        validateProperties(pat);
                        gen.if(valid);
                    }
                }
            }
            function checkMatchingProperties(pat) {
                for(const prop in checkProperties){
                    if (new RegExp(pat).test(prop)) {
                        (0, util.checkStrictMode)(it, `property ${prop} matches pattern ${pat} (use allowMatchingProperties)`);
                    }
                }
            }
            function validateProperties(pat) {
                gen.forIn("key", data83, (key)=>{
                    gen.if(codegen._`${(0, code$1.usePattern)(cxt, pat)}.test(${key})`, ()=>{
                        const alwaysValid = alwaysValidPatterns.includes(pat);
                        if (!alwaysValid) {
                            cxt.subschema({
                                keyword: "patternProperties",
                                schemaProp: pat,
                                dataProp: key,
                                dataPropType: util_2.Type.Str
                            }, valid);
                        }
                        if (it.opts.unevaluated && props !== true) {
                            gen.assign(codegen._`${props}[${key}]`, true);
                        } else if (!alwaysValid && !it.allErrors) {
                            gen.if((0, codegen.not)(valid), ()=>gen.break()
                            );
                        }
                    });
                });
            }
        }
    };
    exports.default = def36;
});
var not = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const def37 = {
        keyword: "not",
        schemaType: [
            "object",
            "boolean"
        ],
        trackErrors: true,
        code (cxt) {
            const { gen , schema , it  } = cxt;
            if ((0, util.alwaysValidSchema)(it, schema)) {
                cxt.fail();
                return;
            }
            const valid = gen.name("valid");
            cxt.subschema({
                keyword: "not",
                compositeRule: true,
                createErrors: false,
                allErrors: false
            }, valid);
            cxt.failResult(valid, ()=>cxt.reset()
            , ()=>cxt.error()
            );
        },
        error: {
            message: "must NOT be valid"
        }
    };
    exports.default = def37;
});
var anyOf = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const def38 = {
        keyword: "anyOf",
        schemaType: "array",
        trackErrors: true,
        code: code$1.validateUnion,
        error: {
            message: "must match a schema in anyOf"
        }
    };
    exports.default = def38;
});
var oneOf = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error39 = {
        message: "must match exactly one schema in oneOf",
        params: ({ params  })=>codegen._`{passingSchemas: ${params.passing}}`
    };
    const def39 = {
        keyword: "oneOf",
        schemaType: "array",
        trackErrors: true,
        error: error39,
        code (cxt) {
            const { gen , schema , parentSchema , it  } = cxt;
            if (!Array.isArray(schema)) throw new Error("ajv implementation error");
            if (it.opts.discriminator && parentSchema.discriminator) return;
            const schArr = schema;
            const valid = gen.let("valid", false);
            const passing = gen.let("passing", null);
            const schValid = gen.name("_valid");
            cxt.setParams({
                passing
            });
            gen.block(validateOneOf);
            cxt.result(valid, ()=>cxt.reset()
            , ()=>cxt.error(true)
            );
            function validateOneOf() {
                schArr.forEach((sch, i62)=>{
                    let schCxt;
                    if ((0, util.alwaysValidSchema)(it, sch)) {
                        gen.var(schValid, true);
                    } else {
                        schCxt = cxt.subschema({
                            keyword: "oneOf",
                            schemaProp: i62,
                            compositeRule: true
                        }, schValid);
                    }
                    if (i62 > 0) {
                        gen.if(codegen._`${schValid} && ${valid}`).assign(valid, false).assign(passing, codegen._`[${passing}, ${i62}]`).else();
                    }
                    gen.if(schValid, ()=>{
                        gen.assign(valid, true);
                        gen.assign(passing, i62);
                        if (schCxt) cxt.mergeEvaluated(schCxt, codegen.Name);
                    });
                });
            }
        }
    };
    exports.default = def39;
});
var allOf = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const def40 = {
        keyword: "allOf",
        schemaType: "array",
        code (cxt) {
            const { gen , schema , it  } = cxt;
            if (!Array.isArray(schema)) throw new Error("ajv implementation error");
            const valid = gen.name("valid");
            schema.forEach((sch, i63)=>{
                if ((0, util.alwaysValidSchema)(it, sch)) return;
                const schCxt = cxt.subschema({
                    keyword: "allOf",
                    schemaProp: i63
                }, valid);
                cxt.ok(valid);
                cxt.mergeEvaluated(schCxt);
            });
        }
    };
    exports.default = def40;
});
var _if = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error40 = {
        message: ({ params  })=>codegen.str`must match "${params.ifClause}" schema`
        ,
        params: ({ params  })=>codegen._`{failingKeyword: ${params.ifClause}}`
    };
    const def41 = {
        keyword: "if",
        schemaType: [
            "object",
            "boolean"
        ],
        trackErrors: true,
        error: error40,
        code (cxt) {
            const { gen , parentSchema , it  } = cxt;
            if (parentSchema.then === void 0 && parentSchema.else === void 0) {
                (0, util.checkStrictMode)(it, '"if" without "then" and "else" is ignored');
            }
            const hasThen = hasSchema(it, "then");
            const hasElse = hasSchema(it, "else");
            if (!hasThen && !hasElse) return;
            const valid = gen.let("valid", true);
            const schValid = gen.name("_valid");
            validateIf();
            cxt.reset();
            if (hasThen && hasElse) {
                const ifClause = gen.let("ifClause");
                cxt.setParams({
                    ifClause
                });
                gen.if(schValid, validateClause("then", ifClause), validateClause("else", ifClause));
            } else if (hasThen) {
                gen.if(schValid, validateClause("then"));
            } else {
                gen.if((0, codegen.not)(schValid), validateClause("else"));
            }
            cxt.pass(valid, ()=>cxt.error(true)
            );
            function validateIf() {
                const schCxt = cxt.subschema({
                    keyword: "if",
                    compositeRule: true,
                    createErrors: false,
                    allErrors: false
                }, schValid);
                cxt.mergeEvaluated(schCxt);
            }
            function validateClause(keyword2, ifClause) {
                return ()=>{
                    const schCxt = cxt.subschema({
                        keyword: keyword2
                    }, schValid);
                    gen.assign(valid, schValid);
                    cxt.mergeValidEvaluated(schCxt, valid);
                    if (ifClause) gen.assign(ifClause, codegen._`${keyword2}`);
                    else cxt.setParams({
                        ifClause: keyword2
                    });
                };
            }
        }
    };
    function hasSchema(it, keyword2) {
        const schema = it.schema[keyword2];
        return schema !== void 0 && !(0, util.alwaysValidSchema)(it, schema);
    }
    exports.default = def41;
});
var thenElse = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const def42 = {
        keyword: [
            "then",
            "else"
        ],
        schemaType: [
            "object",
            "boolean"
        ],
        code ({ keyword: keyword2 , parentSchema , it  }) {
            if (parentSchema.if === void 0) (0, util.checkStrictMode)(it, `"${keyword2}" without "if" is ignored`);
        }
    };
    exports.default = def42;
});
var applicator = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    function getApplicator(draft2020 = false) {
        const applicator2 = [
            not.default,
            anyOf.default,
            oneOf.default,
            allOf.default,
            _if.default,
            thenElse.default,
            propertyNames.default,
            additionalProperties$1.default,
            dependencies.default,
            properties$1.default,
            patternProperties.default
        ];
        if (draft2020) applicator2.push(prefixItems.default, items2020.default);
        else applicator2.push(additionalItems.default, items.default);
        applicator2.push(contains.default);
        return applicator2;
    }
    exports.default = getApplicator;
});
var format3 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error41 = {
        message: ({ schemaCode  })=>codegen.str`must match format "${schemaCode}"`
        ,
        params: ({ schemaCode  })=>codegen._`{format: ${schemaCode}}`
    };
    const def43 = {
        keyword: "format",
        type: [
            "number",
            "string"
        ],
        schemaType: "string",
        $data: true,
        error: error41,
        code (cxt, ruleType) {
            const { gen , data: data84 , $data , schema , schemaCode , it  } = cxt;
            const { opts , errSchemaPath , schemaEnv , self  } = it;
            if (!opts.validateFormats) return;
            if ($data) validate$DataFormat();
            else validateFormat();
            function validate$DataFormat() {
                const fmts = gen.scopeValue("formats", {
                    ref: self.formats,
                    code: opts.code.formats
                });
                const fDef = gen.const("fDef", codegen._`${fmts}[${schemaCode}]`);
                const fType = gen.let("fType");
                const format23 = gen.let("format");
                gen.if(codegen._`typeof ${fDef} == "object" && !(${fDef} instanceof RegExp)`, ()=>gen.assign(fType, codegen._`${fDef}.type || "string"`).assign(format23, codegen._`${fDef}.validate`)
                , ()=>gen.assign(fType, codegen._`"string"`).assign(format23, fDef)
                );
                cxt.fail$data((0, codegen.or)(unknownFmt(), invalidFmt()));
                function unknownFmt() {
                    if (opts.strictSchema === false) return codegen.nil;
                    return codegen._`${schemaCode} && !${format23}`;
                }
                function invalidFmt() {
                    const callFormat = schemaEnv.$async ? codegen._`(${fDef}.async ? await ${format23}(${data84}) : ${format23}(${data84}))` : codegen._`${format23}(${data84})`;
                    const validData = codegen._`(typeof ${format23} == "function" ? ${callFormat} : ${format23}.test(${data84}))`;
                    return codegen._`${format23} && ${format23} !== true && ${fType} === ${ruleType} && !${validData}`;
                }
            }
            function validateFormat() {
                const formatDef = self.formats[schema];
                if (!formatDef) {
                    unknownFormat();
                    return;
                }
                if (formatDef === true) return;
                const [fmtType, format24, fmtRef] = getFormat(formatDef);
                if (fmtType === ruleType) cxt.pass(validCondition());
                function unknownFormat() {
                    if (opts.strictSchema === false) {
                        self.logger.warn(unknownMsg());
                        return;
                    }
                    throw new Error(unknownMsg());
                    function unknownMsg() {
                        return `unknown format "${schema}" ignored in schema at path "${errSchemaPath}"`;
                    }
                }
                function getFormat(fmtDef) {
                    const code2 = fmtDef instanceof RegExp ? (0, codegen.regexpCode)(fmtDef) : opts.code.formats ? codegen._`${opts.code.formats}${(0, codegen.getProperty)(schema)}` : void 0;
                    const fmt = gen.scopeValue("formats", {
                        key: schema,
                        ref: fmtDef,
                        code: code2
                    });
                    if (typeof fmtDef == "object" && !(fmtDef instanceof RegExp)) {
                        return [
                            fmtDef.type || "string",
                            fmtDef.validate,
                            codegen._`${fmt}.validate`
                        ];
                    }
                    return [
                        "string",
                        fmtDef,
                        fmt
                    ];
                }
                function validCondition() {
                    if (typeof formatDef == "object" && !(formatDef instanceof RegExp) && formatDef.async) {
                        if (!schemaEnv.$async) throw new Error("async format in sync schema");
                        return codegen._`await ${fmtRef}(${data84})`;
                    }
                    return typeof format24 == "function" ? codegen._`${fmtRef}(${data84})` : codegen._`${fmtRef}.test(${data84})`;
                }
            }
        }
    };
    exports.default = def43;
});
var format_2 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const format$1 = [
        format3.default
    ];
    exports.default = format$1;
});
var metadata = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.contentVocabulary = exports.metadataVocabulary = void 0;
    exports.metadataVocabulary = [
        "title",
        "description",
        "default",
        "deprecated",
        "readOnly",
        "writeOnly",
        "examples"
    ];
    exports.contentVocabulary = [
        "contentMediaType",
        "contentEncoding",
        "contentSchema"
    ];
});
var draft7 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const draft7Vocabularies = [
        core_1.default,
        validation_1.default,
        (0, applicator.default)(),
        format_2.default,
        metadata.metadataVocabulary,
        metadata.contentVocabulary
    ];
    exports.default = draft7Vocabularies;
});
var types = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.DiscrError = void 0;
    (function(DiscrError) {
        DiscrError["Tag"] = "tag";
        DiscrError["Mapping"] = "mapping";
    })(exports.DiscrError || (exports.DiscrError = {}));
});
var discriminator = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    const error42 = {
        message: ({ params: { discrError , tagName  }  })=>discrError === types.DiscrError.Tag ? `tag "${tagName}" must be string` : `value of tag "${tagName}" must be in oneOf`
        ,
        params: ({ params: { discrError , tag , tagName  }  })=>codegen._`{error: ${discrError}, tag: ${tagName}, tagValue: ${tag}}`
    };
    const def44 = {
        keyword: "discriminator",
        type: "object",
        schemaType: "object",
        error: error42,
        code (cxt) {
            const { gen , data: data85 , schema , parentSchema , it  } = cxt;
            const { oneOf: oneOf2  } = parentSchema;
            if (!it.opts.discriminator) {
                throw new Error("discriminator: requires discriminator option");
            }
            const tagName = schema.propertyName;
            if (typeof tagName != "string") throw new Error("discriminator: requires propertyName");
            if (schema.mapping) throw new Error("discriminator: mapping is not supported");
            if (!oneOf2) throw new Error("discriminator: requires oneOf keyword");
            const valid = gen.let("valid", false);
            const tag = gen.const("tag", codegen._`${data85}${(0, codegen.getProperty)(tagName)}`);
            gen.if(codegen._`typeof ${tag} == "string"`, ()=>validateMapping()
            , ()=>cxt.error(false, {
                    discrError: types.DiscrError.Tag,
                    tag,
                    tagName
                })
            );
            cxt.ok(valid);
            function validateMapping() {
                const mapping = getMapping();
                gen.if(false);
                for(const tagValue in mapping){
                    gen.elseIf(codegen._`${tag} === ${tagValue}`);
                    gen.assign(valid, applyTagSchema(mapping[tagValue]));
                }
                gen.else();
                cxt.error(false, {
                    discrError: types.DiscrError.Mapping,
                    tag,
                    tagName
                });
                gen.endIf();
            }
            function applyTagSchema(schemaProp) {
                const _valid = gen.name("valid");
                const schCxt = cxt.subschema({
                    keyword: "oneOf",
                    schemaProp
                }, _valid);
                cxt.mergeEvaluated(schCxt, codegen.Name);
                return _valid;
            }
            function getMapping() {
                var _a;
                const oneOfMapping = {};
                const topRequired = hasRequired(parentSchema);
                let tagRequired = true;
                for(let i1 = 0; i1 < oneOf2.length; i1++){
                    const sch = oneOf2[i1];
                    const propSch = (_a = sch.properties) === null || _a === void 0 ? void 0 : _a[tagName];
                    if (typeof propSch != "object") {
                        throw new Error(`discriminator: oneOf schemas must have "properties/${tagName}"`);
                    }
                    tagRequired = tagRequired && (topRequired || hasRequired(sch));
                    addMappings(propSch, i1);
                }
                if (!tagRequired) throw new Error(`discriminator: "${tagName}" must be required`);
                return oneOfMapping;
                function hasRequired({ required: required2  }) {
                    return Array.isArray(required2) && required2.includes(tagName);
                }
                function addMappings(sch, i64) {
                    if (sch.const) {
                        addMapping(sch.const, i64);
                    } else if (sch.enum) {
                        for (const tagValue of sch.enum){
                            addMapping(tagValue, i64);
                        }
                    } else {
                        throw new Error(`discriminator: "properties/${tagName}" must have "const" or "enum"`);
                    }
                }
                function addMapping(tagValue, i65) {
                    if (typeof tagValue != "string" || tagValue in oneOfMapping) {
                        throw new Error(`discriminator: "${tagName}" values must be unique strings`);
                    }
                    oneOfMapping[tagValue] = i65;
                }
            }
        }
    };
    exports.default = def44;
});
const $schema = "http://json-schema.org/draft-07/schema#";
const $id$1 = "http://json-schema.org/draft-07/schema#";
const title = "Core schema meta-schema";
const definitions = {
    schemaArray: {
        type: "array",
        minItems: 1,
        items: {
            $ref: "#"
        }
    },
    nonNegativeInteger: {
        type: "integer",
        minimum: 0
    },
    nonNegativeIntegerDefault0: {
        allOf: [
            {
                $ref: "#/definitions/nonNegativeInteger"
            },
            {
                default: 0
            }
        ]
    },
    simpleTypes: {
        enum: [
            "array",
            "boolean",
            "integer",
            "null",
            "number",
            "object",
            "string"
        ]
    },
    stringArray: {
        type: "array",
        items: {
            type: "string"
        },
        uniqueItems: true,
        default: []
    }
};
const type$1 = [
    "object",
    "boolean"
];
const properties$2 = {
    $id: {
        type: "string",
        format: "uri-reference"
    },
    $schema: {
        type: "string",
        format: "uri"
    },
    $ref: {
        type: "string",
        format: "uri-reference"
    },
    $comment: {
        type: "string"
    },
    title: {
        type: "string"
    },
    description: {
        type: "string"
    },
    default: true,
    readOnly: {
        type: "boolean",
        default: false
    },
    examples: {
        type: "array",
        items: true
    },
    multipleOf: {
        type: "number",
        exclusiveMinimum: 0
    },
    maximum: {
        type: "number"
    },
    exclusiveMaximum: {
        type: "number"
    },
    minimum: {
        type: "number"
    },
    exclusiveMinimum: {
        type: "number"
    },
    maxLength: {
        $ref: "#/definitions/nonNegativeInteger"
    },
    minLength: {
        $ref: "#/definitions/nonNegativeIntegerDefault0"
    },
    pattern: {
        type: "string",
        format: "regex"
    },
    additionalItems: {
        $ref: "#"
    },
    items: {
        anyOf: [
            {
                $ref: "#"
            },
            {
                $ref: "#/definitions/schemaArray"
            }
        ],
        default: true
    },
    maxItems: {
        $ref: "#/definitions/nonNegativeInteger"
    },
    minItems: {
        $ref: "#/definitions/nonNegativeIntegerDefault0"
    },
    uniqueItems: {
        type: "boolean",
        default: false
    },
    contains: {
        $ref: "#"
    },
    maxProperties: {
        $ref: "#/definitions/nonNegativeInteger"
    },
    minProperties: {
        $ref: "#/definitions/nonNegativeIntegerDefault0"
    },
    required: {
        $ref: "#/definitions/stringArray"
    },
    additionalProperties: {
        $ref: "#"
    },
    definitions: {
        type: "object",
        additionalProperties: {
            $ref: "#"
        },
        default: {}
    },
    properties: {
        type: "object",
        additionalProperties: {
            $ref: "#"
        },
        default: {}
    },
    patternProperties: {
        type: "object",
        additionalProperties: {
            $ref: "#"
        },
        propertyNames: {
            format: "regex"
        },
        default: {}
    },
    dependencies: {
        type: "object",
        additionalProperties: {
            anyOf: [
                {
                    $ref: "#"
                },
                {
                    $ref: "#/definitions/stringArray"
                }
            ]
        }
    },
    propertyNames: {
        $ref: "#"
    },
    const: true,
    enum: {
        type: "array",
        items: true,
        minItems: 1,
        uniqueItems: true
    },
    type: {
        anyOf: [
            {
                $ref: "#/definitions/simpleTypes"
            },
            {
                type: "array",
                items: {
                    $ref: "#/definitions/simpleTypes"
                },
                minItems: 1,
                uniqueItems: true
            }
        ]
    },
    format: {
        type: "string"
    },
    contentMediaType: {
        type: "string"
    },
    contentEncoding: {
        type: "string"
    },
    if: {
        $ref: "#"
    },
    then: {
        $ref: "#"
    },
    else: {
        $ref: "#"
    },
    allOf: {
        $ref: "#/definitions/schemaArray"
    },
    anyOf: {
        $ref: "#/definitions/schemaArray"
    },
    oneOf: {
        $ref: "#/definitions/schemaArray"
    },
    not: {
        $ref: "#"
    }
};
var draft7MetaSchema = {
    $schema,
    $id: $id$1,
    title,
    definitions,
    type: type$1,
    properties: properties$2,
    default: true
};
var ajv1 = createCommonjsModule5(function(module, exports) {
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.CodeGen = exports.Name = exports.nil = exports.stringify = exports.str = exports._ = exports.KeywordCxt = void 0;
    const META_SUPPORT_DATA = [
        "/properties"
    ];
    const META_SCHEMA_ID = "http://json-schema.org/draft-07/schema";
    class Ajv extends core1.default {
        _addVocabularies() {
            super._addVocabularies();
            draft7.default.forEach((v)=>this.addVocabulary(v)
            );
            if (this.opts.discriminator) this.addKeyword(discriminator.default);
        }
        _addDefaultMetaSchema() {
            super._addDefaultMetaSchema();
            if (!this.opts.meta) return;
            const metaSchema = this.opts.$data ? this.$dataMetaSchema(draft7MetaSchema, META_SUPPORT_DATA) : draft7MetaSchema;
            this.addMetaSchema(metaSchema, META_SCHEMA_ID, false);
            this.refs["http://json-schema.org/schema"] = META_SCHEMA_ID;
        }
        defaultMeta() {
            return this.opts.defaultMeta = super.defaultMeta() || (this.getSchema(META_SCHEMA_ID) ? META_SCHEMA_ID : void 0);
        }
    }
    module.exports = exports = Ajv;
    Object.defineProperty(exports, "__esModule", {
        value: true
    });
    exports.default = Ajv;
    Object.defineProperty(exports, "KeywordCxt", {
        enumerable: true,
        get: function() {
            return validate.KeywordCxt;
        }
    });
    Object.defineProperty(exports, "_", {
        enumerable: true,
        get: function() {
            return codegen._;
        }
    });
    Object.defineProperty(exports, "str", {
        enumerable: true,
        get: function() {
            return codegen.str;
        }
    });
    Object.defineProperty(exports, "stringify", {
        enumerable: true,
        get: function() {
            return codegen.stringify;
        }
    });
    Object.defineProperty(exports, "nil", {
        enumerable: true,
        get: function() {
            return codegen.nil;
        }
    });
    Object.defineProperty(exports, "Name", {
        enumerable: true,
        get: function() {
            return codegen.Name;
        }
    });
    Object.defineProperty(exports, "CodeGen", {
        enumerable: true,
        get: function() {
            return codegen.CodeGen;
        }
    });
});
var __pika_web_default_export_for_treeshaking__1 = getDefaultExportFromCjs1(ajv1);
ajv1.CodeGen;
ajv1.KeywordCxt;
ajv1.Name;
ajv1._;
ajv1.nil;
ajv1.str;
ajv1.stringify;
function Diff() {}
Diff.prototype = {
    diff: function diff(oldString, newString) {
        var options = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : {};
        var callback = options.callback;
        if (typeof options === "function") {
            callback = options;
            options = {};
        }
        this.options = options;
        var self = this;
        function done(value) {
            if (callback) {
                setTimeout(function() {
                    callback(void 0, value);
                }, 0);
                return true;
            } else {
                return value;
            }
        }
        oldString = this.castInput(oldString);
        newString = this.castInput(newString);
        oldString = this.removeEmpty(this.tokenize(oldString));
        newString = this.removeEmpty(this.tokenize(newString));
        var newLen = newString.length, oldLen = oldString.length;
        var editLength = 1;
        var maxEditLength = newLen + oldLen;
        var bestPath = [
            {
                newPos: -1,
                components: []
            }
        ];
        var oldPos = this.extractCommon(bestPath[0], newString, oldString, 0);
        if (bestPath[0].newPos + 1 >= newLen && oldPos + 1 >= oldLen) {
            return done([
                {
                    value: this.join(newString),
                    count: newString.length
                }
            ]);
        }
        function execEditLength() {
            for(var diagonalPath = -1 * editLength; diagonalPath <= editLength; diagonalPath += 2){
                var basePath = void 0;
                var addPath1 = bestPath[diagonalPath - 1], removePath1 = bestPath[diagonalPath + 1], _oldPos = (removePath1 ? removePath1.newPos : 0) - diagonalPath;
                if (addPath1) {
                    bestPath[diagonalPath - 1] = void 0;
                }
                var canAdd = addPath1 && addPath1.newPos + 1 < newLen, canRemove = removePath1 && 0 <= _oldPos && _oldPos < oldLen;
                if (!canAdd && !canRemove) {
                    bestPath[diagonalPath] = void 0;
                    continue;
                }
                if (!canAdd || canRemove && addPath1.newPos < removePath1.newPos) {
                    basePath = clonePath(removePath1);
                    self.pushComponent(basePath.components, void 0, true);
                } else {
                    basePath = addPath1;
                    basePath.newPos++;
                    self.pushComponent(basePath.components, true, void 0);
                }
                _oldPos = self.extractCommon(basePath, newString, oldString, diagonalPath);
                if (basePath.newPos + 1 >= newLen && _oldPos + 1 >= oldLen) {
                    return done(buildValues(self, basePath.components, newString, oldString, self.useLongestToken));
                } else {
                    bestPath[diagonalPath] = basePath;
                }
            }
            editLength++;
        }
        if (callback) {
            (function exec1() {
                setTimeout(function() {
                    if (editLength > maxEditLength) {
                        return callback();
                    }
                    if (!execEditLength()) {
                        exec1();
                    }
                }, 0);
            })();
        } else {
            while(editLength <= maxEditLength){
                var ret = execEditLength();
                if (ret) {
                    return ret;
                }
            }
        }
    },
    pushComponent: function pushComponent(components, added, removed) {
        var last = components[components.length - 1];
        if (last && last.added === added && last.removed === removed) {
            components[components.length - 1] = {
                count: last.count + 1,
                added,
                removed
            };
        } else {
            components.push({
                count: 1,
                added,
                removed
            });
        }
    },
    extractCommon: function extractCommon(basePath, newString, oldString, diagonalPath) {
        var newLen = newString.length, oldLen = oldString.length, newPos = basePath.newPos, oldPos = newPos - diagonalPath, commonCount = 0;
        while(newPos + 1 < newLen && oldPos + 1 < oldLen && this.equals(newString[newPos + 1], oldString[oldPos + 1])){
            newPos++;
            oldPos++;
            commonCount++;
        }
        if (commonCount) {
            basePath.components.push({
                count: commonCount
            });
        }
        basePath.newPos = newPos;
        return oldPos;
    },
    equals: function equals(left, right) {
        if (this.options.comparator) {
            return this.options.comparator(left, right);
        } else {
            return left === right || this.options.ignoreCase && left.toLowerCase() === right.toLowerCase();
        }
    },
    removeEmpty: function removeEmpty(array) {
        var ret = [];
        for(var i66 = 0; i66 < array.length; i66++){
            if (array[i66]) {
                ret.push(array[i66]);
            }
        }
        return ret;
    },
    castInput: function castInput(value) {
        return value;
    },
    tokenize: function tokenize(value) {
        return value.split("");
    },
    join: function join(chars) {
        return chars.join("");
    }
};
function buildValues(diff2, components, newString, oldString, useLongestToken) {
    var componentPos = 0, componentLen = components.length, newPos = 0, oldPos = 0;
    for(; componentPos < componentLen; componentPos++){
        var component = components[componentPos];
        if (!component.removed) {
            if (!component.added && useLongestToken) {
                var value = newString.slice(newPos, newPos + component.count);
                value = value.map(function(value2, i67) {
                    var oldValue = oldString[oldPos + i67];
                    return oldValue.length > value2.length ? oldValue : value2;
                });
                component.value = diff2.join(value);
            } else {
                component.value = diff2.join(newString.slice(newPos, newPos + component.count));
            }
            newPos += component.count;
            if (!component.added) {
                oldPos += component.count;
            }
        } else {
            component.value = diff2.join(oldString.slice(oldPos, oldPos + component.count));
            oldPos += component.count;
            if (componentPos && components[componentPos - 1].added) {
                var tmp = components[componentPos - 1];
                components[componentPos - 1] = components[componentPos];
                components[componentPos] = tmp;
            }
        }
    }
    var lastComponent = components[componentLen - 1];
    if (componentLen > 1 && typeof lastComponent.value === "string" && (lastComponent.added || lastComponent.removed) && diff2.equals("", lastComponent.value)) {
        components[componentLen - 2].value += lastComponent.value;
        components.pop();
    }
    return components;
}
function clonePath(path63) {
    return {
        newPos: path63.newPos,
        components: path63.components.slice(0)
    };
}
new Diff();
var extendedWordChars = /^[A-Za-z\xC0-\u02C6\u02C8-\u02D7\u02DE-\u02FF\u1E00-\u1EFF]+$/;
var reWhitespace1 = /\S/;
var wordDiff = new Diff();
wordDiff.equals = function(left, right) {
    if (this.options.ignoreCase) {
        left = left.toLowerCase();
        right = right.toLowerCase();
    }
    return left === right || this.options.ignoreWhitespace && !reWhitespace1.test(left) && !reWhitespace1.test(right);
};
wordDiff.tokenize = function(value) {
    var tokens = value.split(/([^\S\r\n]+|[()[\]{}'"\r\n]|\b)/);
    for(var i68 = 0; i68 < tokens.length - 1; i68++){
        if (!tokens[i68 + 1] && tokens[i68 + 2] && extendedWordChars.test(tokens[i68]) && extendedWordChars.test(tokens[i68 + 2])) {
            tokens[i68] += tokens[i68 + 2];
            tokens.splice(i68 + 1, 2);
            i68--;
        }
    }
    return tokens;
};
var lineDiff = new Diff();
lineDiff.tokenize = function(value) {
    var retLines = [], linesAndNewlines = value.split(/(\n|\r\n)/);
    if (!linesAndNewlines[linesAndNewlines.length - 1]) {
        linesAndNewlines.pop();
    }
    for(var i69 = 0; i69 < linesAndNewlines.length; i69++){
        var line = linesAndNewlines[i69];
        if (i69 % 2 && !this.options.newlineIsToken) {
            retLines[retLines.length - 1] += line;
        } else {
            if (this.options.ignoreWhitespace) {
                line = line.trim();
            }
            retLines.push(line);
        }
    }
    return retLines;
};
function diffLines(oldStr, newStr, callback) {
    return lineDiff.diff(oldStr, newStr, callback);
}
var sentenceDiff = new Diff();
sentenceDiff.tokenize = function(value) {
    return value.split(/(\S.+?[.!?])(?=\s+|$)/);
};
var cssDiff = new Diff();
cssDiff.tokenize = function(value) {
    return value.split(/([{}:;,]|\s+)/);
};
function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function(obj2) {
            return typeof obj2;
        };
    } else {
        _typeof = function(obj2) {
            return obj2 && typeof Symbol === "function" && obj2.constructor === Symbol && obj2 !== Symbol.prototype ? "symbol" : typeof obj2;
        };
    }
    return _typeof(obj);
}
var objectPrototypeToString = Object.prototype.toString;
var jsonDiff = new Diff();
jsonDiff.useLongestToken = true;
jsonDiff.tokenize = lineDiff.tokenize;
jsonDiff.castInput = function(value) {
    var _this$options = this.options, undefinedReplacement = _this$options.undefinedReplacement, _this$options$stringi = _this$options.stringifyReplacer, stringifyReplacer = _this$options$stringi === void 0 ? function(k, v) {
        return typeof v === "undefined" ? undefinedReplacement : v;
    } : _this$options$stringi;
    return typeof value === "string" ? value : JSON.stringify(canonicalize(value, null, null, stringifyReplacer), stringifyReplacer, "  ");
};
jsonDiff.equals = function(left, right) {
    return Diff.prototype.equals.call(jsonDiff, left.replace(/,([\r\n])/g, "$1"), right.replace(/,([\r\n])/g, "$1"));
};
function canonicalize(obj, stack, replacementStack, replacer, key) {
    stack = stack || [];
    replacementStack = replacementStack || [];
    if (replacer) {
        obj = replacer(key, obj);
    }
    var i70;
    for(i70 = 0; i70 < stack.length; i70 += 1){
        if (stack[i70] === obj) {
            return replacementStack[i70];
        }
    }
    var canonicalizedObj;
    if (objectPrototypeToString.call(obj) === "[object Array]") {
        stack.push(obj);
        canonicalizedObj = new Array(obj.length);
        replacementStack.push(canonicalizedObj);
        for(i70 = 0; i70 < obj.length; i70 += 1){
            canonicalizedObj[i70] = canonicalize(obj[i70], stack, replacementStack, replacer, key);
        }
        stack.pop();
        replacementStack.pop();
        return canonicalizedObj;
    }
    if (obj && obj.toJSON) {
        obj = obj.toJSON();
    }
    if (_typeof(obj) === "object" && obj !== null) {
        stack.push(obj);
        canonicalizedObj = {};
        replacementStack.push(canonicalizedObj);
        var sortedKeys = [], _key;
        for(_key in obj){
            if (obj.hasOwnProperty(_key)) {
                sortedKeys.push(_key);
            }
        }
        sortedKeys.sort();
        for(i70 = 0; i70 < sortedKeys.length; i70 += 1){
            _key = sortedKeys[i70];
            canonicalizedObj[_key] = canonicalize(obj[_key], stack, replacementStack, replacer, _key);
        }
        stack.pop();
        replacementStack.pop();
    } else {
        canonicalizedObj = obj;
    }
    return canonicalizedObj;
}
var arrayDiff = new Diff();
arrayDiff.tokenize = function(value) {
    return value.slice();
};
arrayDiff.join = arrayDiff.removeEmpty = function(value) {
    return value;
};
function matchAll1(str68, regex) {
    let match;
    regex = new RegExp(regex);
    const result = [];
    while((match = regex.exec(str68)) != null){
        result.push(match);
    }
    return result;
}
function rangedLines(text, includeNewLines = false) {
    const regex = /\r?\n/g;
    const result = [];
    let startOffset = 0;
    if (!includeNewLines) {
        for (const r of matchAll1(text, regex)){
            result.push({
                substring: text.substring(startOffset, r.index),
                range: {
                    start: startOffset,
                    end: r.index
                }
            });
            startOffset = r.index + r[0].length;
        }
        result.push({
            substring: text.substring(startOffset, text.length),
            range: {
                start: startOffset,
                end: text.length
            }
        });
        return result;
    } else {
        const matches = matchAll1(text, regex);
        let prevOffset = 0;
        for (const r of matches){
            const stringEnd = r.index + 1;
            result.push({
                substring: text.substring(prevOffset, stringEnd),
                range: {
                    start: prevOffset,
                    end: stringEnd
                }
            });
            prevOffset = stringEnd;
        }
        result.push({
            substring: text.substring(prevOffset, text.length),
            range: {
                start: prevOffset,
                end: text.length
            }
        });
        return result;
    }
}
function mappedDiff(source, target) {
    const sourceLineRanges = rangedLines(source.value).map((x)=>x.range
    );
    let sourceCursor = 0;
    const resultChunks = [];
    for (const action of diffLines(source.value, target)){
        if (action.removed) {
            sourceCursor += action.count;
        } else if (action.added) {
            resultChunks.push(action.value);
        } else {
            const start = sourceLineRanges[sourceCursor].start;
            const nextCursor = sourceCursor + action.count;
            const end = nextCursor < sourceLineRanges.length ? sourceLineRanges[nextCursor].start : sourceLineRanges[sourceLineRanges.length - 1].end;
            sourceCursor = nextCursor;
            resultChunks.push({
                start,
                end
            });
        }
    }
    return mappedString(source, resultChunks);
}
const kMetadataFormat = "format";
const kRenderDefaults = "render";
const kExecuteDefaults = "execute";
const kPandocDefaults = "pandoc";
const kLanguageDefaults = "language";
const kPandocMetadata = "metadata";
const kFigWidth = "fig-width";
const kFigHeight = "fig-height";
const kFigFormat = "fig-format";
const kFigDpi = "fig-dpi";
const kCache = "cache";
const kFreeze = "freeze";
const kEngine = "engine";
const kEval = "eval";
const kEcho = "echo";
const kOutput = "output";
const kWarning = "warning";
const kError = "error";
const kInclude = "include";
const kResources = "resources";
const kKeepHidden = "keep-hidden";
const kExecuteEnabled = "enabled";
const kExecuteIpynb = "ipynb";
const kExecuteDaemon = "daemon";
const kExecuteDaemonRestart = "daemon-restart";
const kExecuteDebug = "debug";
const kKeepMd = "keep-md";
const kKeepTex = "keep-tex";
const kKeepYaml = "keep-yaml";
const kKeepIpynb = "keep-ipynb";
const kKeepSource = "keep-source";
const kVariant = "variant";
const kOutputExt = "output-ext";
const kOutputDivs = "output-divs";
const kPageWidth = "page-width";
const kFigAlign = "fig-align";
const kCodeFold = "code-fold";
const kCodeLineNumbers = "code-line-numbers";
const kCodeOverflow = "code-overflow";
const kCodeLink = "code-link";
const kCodeTools = "code-tools";
const kTblColwidths = "tbl-colwidths";
const kMergeIncludes = "merge-includes";
const kPreferHtml = "prefer-html";
const kSelfContainedMath = "self-contained-math";
const kLatexAutoMk = "latex-auto-mk";
const kLatexAutoInstall = "latex-auto-install";
const kLatexMinRuns = "latex-min-runs";
const kLatexMaxRuns = "latex-max-runs";
const kLatexClean = "latex-clean";
const kLatexMakeIndex = "latex-makeindex";
const kLatexMakeIndexOpts = "latex-makeindex-opts";
const kLatexTlmgrOpts = "latex-tlmgr-opts";
const kLatexOutputDir = "latex-output-dir";
const kLinkExternalIcon = "link-external-icon";
const kLinkExternalNewwindow = "link-external-newwindow";
const kLinkExternalFilter = "link-external-filter";
const kExecuteDefaultsKeys = [
    kFigWidth,
    kFigHeight,
    kFigFormat,
    kFigDpi,
    kError,
    kEval,
    kEngine,
    kCache,
    kFreeze,
    kEcho,
    kOutput,
    kWarning,
    kInclude,
    kKeepMd,
    kKeepIpynb,
    kExecuteEnabled,
    kExecuteIpynb,
    kExecuteDaemon,
    kExecuteDaemonRestart,
    kExecuteDebug, 
];
const kRenderDefaultsKeys = [
    kKeepTex,
    kKeepYaml,
    kKeepSource,
    kKeepHidden,
    kVariant,
    kOutputExt,
    kOutputDivs,
    kPreferHtml,
    kPageWidth,
    kFigAlign,
    kCodeFold,
    kCodeLink,
    kCodeLineNumbers,
    kCodeOverflow,
    kCodeTools,
    kTblColwidths,
    kSelfContainedMath,
    kLatexAutoMk,
    kLatexAutoInstall,
    kLatexMinRuns,
    kLatexMaxRuns,
    kLatexClean,
    kLatexMakeIndex,
    kLatexMakeIndexOpts,
    kLatexTlmgrOpts,
    kLatexOutputDir,
    kLinkExternalIcon,
    kLinkExternalNewwindow,
    kLinkExternalFilter, 
];
const kTocTitleDocument = "toc-title-document";
const kTocTitleWebsite = "toc-title-website";
const kCalloutTipCaption = "callout-tip-caption";
const kCalloutNoteCaption = "callout-note-caption";
const kCalloutWarningCaption = "callout-warning-caption";
const kCalloutImportantCaption = "callout-important-caption";
const kCalloutDangerCaption = "callout-danger-caption";
const kSectionTitleAbstract = "section-title-abstract";
const kSectionTitleFootnotes = "section-title-footnotes";
const kSectionTitleAppendices = "section-title-appendices";
const kCodeSummary = "code-summary";
const kCodeToolsMenuCaption = "code-tools-menu-caption";
const kCodeToolsShowAllCode = "code-tools-show-all-code";
const kCodeToolsHideAllCode = "code-tools-hide-all-code";
const kCodeToolsViewSource = "code-tools-view-source";
const kCodeToolsSourceCode = "code-tools-source-code";
const kSearchNoResultsText = "search-no-results-text";
const kCopyButtonTooltip = "copy-button-tooltip";
const kRepoActionLinksEdit = "repo-action-links-edit";
const kRepoActionLinksSource = "repo-action-links-source";
const kRepoActionLinksIssue = "repo-action-links-issue";
const kSearchMatchingDocumentsText = "search-matching-documents-text";
const kSearchCopyLinkTitle = "search-copy-link-title";
const kSearchHideMatchesText = "search-hide-matches-text";
const kSearchMoreMatchText = "search-more-match-text";
const kSearchMoreMatchesText = "search-more-matches-text";
const kSearchClearButtonTitle = "search-clear-button-title";
const kSearchDetatchedCancelButtonTitle = "search-detached-cancel-button-title";
const kSearchSubmitButtonTitle = "search-submit-button-title";
const kCrossrefFigTitle = "crossref-fig-title";
const kCrossrefTblTitle = "crossref-tbl-title";
const kCrossrefLstTitle = "crossref-lst-title";
const kCrossrefThmTitle = "crossref-thm-title";
const kCrossrefLemTitle = "crossref-lem-title";
const kCrossrefCorTitle = "crossref-cor-title";
const kCrossrefPrfTitle = "crossref-prp-title";
const kCrossrefCnjTitle = "crossref-cnj-title";
const kCrossrefDefTitle = "crossref-def-title";
const kCrossrefExmTitle = "crossref-exm-title";
const kCrossrefExrTitle = "crossref-exr-title";
const kCrossrefFigPrefix = "crossref-fig-prefix";
const kCrossrefTblPrefix = "crossref-tbl-prefix";
const kCrossrefLstPrefix = "crossref-lst-prefix";
const kCrossrefSecPrefix = "crossref-sec-prefix";
const kCrossrefEqPrefix = "crossref-eq-prefix";
const kCrossrefThmPrefix = "crossref-thm-prefix";
const kCrossrefLemPrefix = "crossref-lem-prefix";
const kCrossrefCorPrefix = "crossref-cor-prefix";
const kCrossrefPrpPrefix = "crossref-prp-prefix";
const kCrossrefCnjPrefix = "crossref-cnj-prefix";
const kCrossrefDefPrefix = "crossref-def-prefix";
const kCrossrefExmPrefix = "crossref-exm-prefix";
const kCrossrefExrPrefix = "crossref-exr-prefix";
const kCrossrefLofTitle = "crossref-lof-title";
const kCrossrefLotTitle = "crossref-lot-title";
const kCrossrefLolTitle = "crossref-lol-title";
const kLanguageDefaultsKeys = [
    kTocTitleDocument,
    kTocTitleWebsite,
    kCalloutTipCaption,
    kCalloutNoteCaption,
    kCalloutWarningCaption,
    kCalloutImportantCaption,
    kCalloutDangerCaption,
    kSectionTitleAbstract,
    kSectionTitleFootnotes,
    kSectionTitleAppendices,
    kCodeSummary,
    kCodeToolsMenuCaption,
    kCodeToolsShowAllCode,
    kCodeToolsHideAllCode,
    kCodeToolsViewSource,
    kCodeToolsSourceCode,
    kSearchNoResultsText,
    kCopyButtonTooltip,
    kRepoActionLinksEdit,
    kRepoActionLinksSource,
    kRepoActionLinksIssue,
    kSearchMatchingDocumentsText,
    kSearchCopyLinkTitle,
    kSearchHideMatchesText,
    kSearchMoreMatchText,
    kSearchMoreMatchesText,
    kSearchClearButtonTitle,
    kSearchDetatchedCancelButtonTitle,
    kSearchSubmitButtonTitle,
    kCrossrefFigTitle,
    kCrossrefTblTitle,
    kCrossrefLstTitle,
    kCrossrefThmTitle,
    kCrossrefLemTitle,
    kCrossrefCorTitle,
    kCrossrefPrfTitle,
    kCrossrefCnjTitle,
    kCrossrefDefTitle,
    kCrossrefExmTitle,
    kCrossrefExrTitle,
    kCrossrefFigPrefix,
    kCrossrefTblPrefix,
    kCrossrefLstPrefix,
    kCrossrefSecPrefix,
    kCrossrefEqPrefix,
    kCrossrefThmPrefix,
    kCrossrefLemPrefix,
    kCrossrefCorPrefix,
    kCrossrefPrpPrefix,
    kCrossrefCnjPrefix,
    kCrossrefDefPrefix,
    kCrossrefExmPrefix,
    kCrossrefExrPrefix,
    kCrossrefLofTitle,
    kCrossrefLotTitle,
    kCrossrefLolTitle, 
];
const kTo = "to";
const kFrom = "from";
const kReader = "reader";
const kWriter = "writer";
const kOutputFile = "output-file";
const kInputFiles = "input-files";
const kAtxHeaders = "atx-headers";
const kMarkdownHeadings = "markdown-headings";
const kTemplate = "template";
const kStandalone = "standalone";
const kWrap = "wrap";
const kSelfContained = "self-contained";
const kIncludeBeforeBody = "include-before-body";
const kIncludeAfterBody = "include-after-body";
const kIncludeInHeader = "include-in-header";
const kCiteproc = "citeproc";
const kCiteMethod = "cite-method";
const kFilters = "filters";
const kFilterParams = "filter-params";
const kPdfEngine = "pdf-engine";
const kPdfEngineOpts = "pdf-engine-opts";
const kPdfEngineOpt = "pdf-engine-opt";
const kListings = "listings";
const kNumberSections = "number-sections";
const kNumberOffset = "number-offset";
const kShiftHeadingLevelBy = "shift-heading-level-by";
const kNumberDepth = "number-depth";
const kTopLevelDivision = "top-level-division";
const kPaperSize = "papersize";
const kLogFile = "log-file";
const kHighlightStyle = "highlight-style";
const kDefaultImageExtension = "default-image-extension";
const kLinkColor = "linkcolor";
const kColorLinks = "colorlinks";
const kVariables = "variables";
const kMetadataFile = "metadata-file";
const kMetadataFiles = "metadata-files";
const kSyntaxDefinitions = "syntax-definitions";
const kSyntaxDefinition = "syntax-definition";
const kReferenceDoc = "reference-doc";
const kHtmlMathMethod = "html-math-method";
const kToc = "toc";
const kTableOfContents = "table-of-contents";
const kSectionDivs = "section-divs";
const kEPubCoverImage = "epub-cover-image";
const kReferenceLocation = "reference-location";
const kCitationLocation = "citation-location";
const kQuartoVarsKey = "_quarto-vars";
const kMathjax = "mathjax";
const kKatex = "katex";
const kMathml = "mathml";
const kGladtex = "gladtex";
const kWebtex = "webtex";
const kTitle = "title";
const kSubtitle = "subtitle";
const kAuthor = "author";
const kDate = "date";
const kDoi = "doi";
const kAbstract = "abstract";
const kAbstractTitle = "abstract-title";
const kDescription = "description";
const kTocTitle = "toc-title";
const kLang = "lang";
const kServer = "server";
const kPageTitle = "pagetitle";
const kTitlePrefix = "title-prefix";
const kCsl = "csl";
const kCss = "css";
const kBibliography = "bibliography";
const kHeaderIncludes = "header-includes";
const kIncludeBefore = "include-before";
const kIncludeAfter = "include-after";
const kLinkCitations = "link-citations";
const kDocumentClass = "documentclass";
const kClassOption = "classoption";
const kSlideLevel = "slide-level";
const kTheme = "theme";
const kCrossref = "crossref";
const kCrossrefChapters = "chapters";
const kCrossrefLabels = "labels";
const kCrossrefAppendixTitle = "appendix-title";
const kCrossrefAppendixDelim = "appendix-delim";
const kCrossrefChaptersAlpha = "chapters-alpha";
const kCrossrefChapterId = "chapter-id";
const kFigResponsive = "fig-responsive";
const kCapLoc = "cap-location";
const kFigCapLoc = "fig-cap-location";
const kTblCapLoc = "tbl-cap-location";
const kCapTop = "top";
const kCapBottom = "bottom";
const kPandocDefaultsKeys = [
    kTo,
    kFrom,
    kReader,
    kWriter,
    kOutputFile,
    kInputFiles,
    "defaults",
    kTemplate,
    kStandalone,
    kSelfContained,
    kVariables,
    "metadata",
    kMetadataFiles,
    kMetadataFile,
    kIncludeBeforeBody,
    kIncludeAfterBody,
    kIncludeInHeader,
    "resource-path",
    kCiteproc,
    kCiteMethod,
    "citation-abbreviations",
    "filters",
    "file-scope",
    "data-dir",
    "verbosity",
    kLogFile,
    kTopLevelDivision,
    "abbreviations",
    kPdfEngine,
    kPdfEngineOpts,
    kPdfEngineOpt,
    kWrap,
    "columns",
    "dpi",
    "extract-media",
    kToc,
    kTableOfContents,
    "toc-depth",
    kNumberSections,
    kNumberOffset,
    kShiftHeadingLevelBy,
    kSectionDivs,
    "identifier-prefix",
    kTitlePrefix,
    "strip-empty-paragraphs",
    "eol",
    "strip-comments",
    "indented-code-classes",
    "ascii",
    kDefaultImageExtension,
    kHighlightStyle,
    kSyntaxDefinitions,
    kSyntaxDefinition,
    kListings,
    kReferenceDoc,
    kHtmlMathMethod,
    "email-obfuscation",
    "tab-stop",
    "preserve-tabs",
    "incremental",
    kSlideLevel,
    "epub-subdirectory",
    "epub-metadata",
    "epub-fonts",
    "epub-chapter-level",
    kEPubCoverImage,
    "reference-links",
    kReferenceLocation,
    kAtxHeaders,
    kMarkdownHeadings,
    "track-changes",
    "html-q-tags",
    "css",
    "ipynb-output",
    "request-headers",
    "fail-if-warnings",
    "dump-args",
    "ignore-args",
    "trace", 
];
const kCellCollapsed = "collapsed";
const kCellAutoscroll = "autoscroll";
const kCellDeletable = "deletable";
const kCellFormat = "format";
const kCellName = "name";
const kCellLinesToNext = "lines_to_next_cell";
const kCellSlideshow = "slideshow";
const kCellSlideshowSlideType = "slide_type";
const kCellRawMimeType = "raw_mimetype";
const kCellId = "id";
const kCellLabel = "label";
const kCellFigCap = "fig-cap";
const kCellFigSubCap = "fig-subcap";
const kCellFigScap = "fig-scap";
const kCellFigColumn = "fig-column";
const kCellTblColumn = "tbl-column";
const kCellFigLink = "fig-link";
const kCellFigAlign = "fig-align";
const kCellFigEnv = "fig-env";
const kCellFigPos = "fig-pos";
const kCellFigAlt = "fig-alt";
const kCellLstLabel = "lst-label";
const kCellLstCap = "lst-cap";
const kCellClasses = "classes";
const kCellPanel = "panel";
const kCellColumn = "column";
const kCellOutWidth = "out-width";
const kCellOutHeight = "out-height";
const kCellMdIndent = "md-indent";
const kCellColab = "colab";
const kCellColabType = "colab_type";
const kCellColbOutputId = "outputId";
const kLayoutAlign = "layout-align";
const kLayoutVAlign = "layout-valign";
const kLayoutNcol = "layout-ncol";
const kLayoutNrow = "layout-nrow";
const kLayout = "layout";
objectSchema();
const dependencyFileSchema = objectSchema({
    properties: {
        name: StringSchema,
        path: StringSchema,
        attribs: objectSchema()
    },
    required: [
        "name",
        "path"
    ]
});
objectSchema({
    properties: {
        name: StringSchema,
        version: StringSchema,
        meta: objectSchema(),
        links: arraySchema(objectSchema({
            properties: {
                rel: StringSchema,
                href: StringSchema
            },
            description: "be an object with 'rel' and 'href' keys with string values"
        })),
        scripts: arraySchema(dependencyFileSchema),
        stylesheets: arraySchema(dependencyFileSchema),
        resources: arraySchema(dependencyFileSchema)
    },
    required: [
        "name"
    ]
});
objectSchema({
    properties: {
        header: StringSchema,
        before: StringSchema,
        after: StringSchema
    }
});
const sassLayerSchema = objectSchema({
    properties: {
        use: arraySchema(StringSchema),
        defaults: StringSchema,
        functions: StringSchema,
        mixins: StringSchema,
        rules: StringSchema
    },
    required: [
        "defaults",
        "functions",
        "mixins",
        "rules"
    ]
});
objectSchema({
    properties: {
        key: StringSchema,
        dependency: StringSchema,
        user: sassLayerSchema,
        quarto: sassLayerSchema,
        framework: sassLayerSchema,
        loadPath: StringSchema,
        dark: objectSchema({
            properties: {
                user: sassLayerSchema,
                quarto: sassLayerSchema,
                framework: sassLayerSchema,
                "default": BooleanSchema
            }
        }),
        attribs: objectSchema({
            additionalProperties: StringSchema
        })
    },
    required: [
        "key",
        "dependency"
    ]
});
objectSchema({
    properties: {
        [kKeepTex]: BooleanSchema,
        [kKeepYaml]: BooleanSchema,
        [kKeepSource]: BooleanSchema,
        [kKeepHidden]: BooleanSchema,
        [kPreferHtml]: BooleanSchema,
        [kOutputDivs]: BooleanSchema,
        [kVariant]: StringSchema,
        [kOutputExt]: StringSchema,
        [kPageWidth]: NumberSchema,
        [kFigAlign]: enumSchema("left", "right", "center", "default"),
        [kCodeFold]: oneOfSchema(enumSchema("none", "show", "hide"), BooleanSchema),
        [kCodeSummary]: StringSchema,
        [kCodeOverflow]: enumSchema("wrap", "scroll"),
        [kCodeLink]: BooleanSchema,
        [kCodeTools]: oneOfSchema(BooleanSchema, objectSchema({
            properties: {
                source: BooleanSchema,
                toggle: BooleanSchema,
                caption: StringSchema
            }
        })),
        [kTblColwidths]: anyOfSchema(BooleanSchema, enumSchema("auto"), arraySchema(NumberSchema)),
        [kMergeIncludes]: BooleanSchema,
        [kSelfContainedMath]: BooleanSchema,
        [kLatexAutoMk]: BooleanSchema,
        [kLatexAutoInstall]: BooleanSchema,
        [kLatexMinRuns]: NumberSchema,
        [kLatexMaxRuns]: NumberSchema,
        [kLatexClean]: BooleanSchema,
        [kLatexMakeIndex]: StringSchema,
        [kLatexMakeIndexOpts]: arraySchema(StringSchema),
        [kLatexTlmgrOpts]: arraySchema(StringSchema),
        [kLatexOutputDir]: oneOfSchema(StringSchema, NullSchema),
        [kLinkExternalIcon]: oneOfSchema(StringSchema, BooleanSchema),
        [kLinkExternalNewwindow]: BooleanSchema
    }
});
const formatExecuteOptionsSchema = objectSchema({
    properties: {
        "fig-width": NumberSchema,
        "fig-height": NumberSchema,
        "fig-format": enumSchema("retina", "png", "jpeg", "svg", "pdf"),
        "fig-dpi": NumberSchema,
        [kCache]: oneOfSchema(BooleanSchema, NullSchema, enumSchema("refresh")),
        [kFreeze]: oneOfSchema(BooleanSchema, enumSchema("auto")),
        [kExecuteEnabled]: oneOfSchema(BooleanSchema, NullSchema),
        [kExecuteIpynb]: oneOfSchema(BooleanSchema, NullSchema),
        [kExecuteDaemon]: oneOfSchema(NumberSchema, BooleanSchema, NullSchema),
        [kExecuteDaemonRestart]: BooleanSchema,
        [kExecuteDebug]: BooleanSchema,
        [kEngine]: StringSchema,
        [kEval]: oneOfSchema(BooleanSchema, NullSchema),
        [kError]: BooleanSchema,
        [kEcho]: oneOfSchema(BooleanSchema, enumSchema("fenced")),
        [kOutput]: oneOfSchema(BooleanSchema, enumSchema("all", "asis")),
        [kWarning]: BooleanSchema,
        [kInclude]: BooleanSchema,
        [kKeepMd]: BooleanSchema,
        [kKeepIpynb]: BooleanSchema
    }
});
objectSchema({
    properties: {
        "from": StringSchema,
        "to": StringSchema,
        "writer": StringSchema,
        [kTemplate]: StringSchema,
        [kOutputFile]: StringSchema,
        "standalone": BooleanSchema,
        [kSelfContained]: BooleanSchema,
        [kVariables]: objectSchema(),
        [kAtxHeaders]: BooleanSchema,
        [kMarkdownHeadings]: BooleanSchema,
        [kIncludeBeforeBody]: arraySchema(StringSchema),
        [kIncludeAfterBody]: arraySchema(StringSchema),
        [kIncludeInHeader]: arraySchema(StringSchema),
        [kCiteproc]: BooleanSchema,
        [kCiteMethod]: StringSchema,
        [kFilters]: arraySchema(StringSchema),
        [kPdfEngine]: StringSchema,
        [kPdfEngineOpts]: arraySchema(StringSchema),
        [kPdfEngineOpt]: StringSchema,
        [kEPubCoverImage]: StringSchema,
        [kCss]: oneOfSchema(StringSchema, arraySchema(StringSchema)),
        [kToc]: BooleanSchema,
        [kTableOfContents]: BooleanSchema,
        [kListings]: BooleanSchema,
        [kNumberSections]: BooleanSchema,
        [kNumberOffset]: arraySchema(NumberSchema),
        [kHighlightStyle]: StringSchema,
        [kSectionDivs]: BooleanSchema,
        [kHtmlMathMethod]: oneOfSchema(StringSchema, objectSchema({
            properties: {
                method: StringSchema,
                url: StringSchema
            },
            required: [
                "method",
                "url"
            ]
        })),
        [kTopLevelDivision]: StringSchema,
        [kShiftHeadingLevelBy]: NumberSchema,
        [kTitlePrefix]: StringSchema
    }
});
objectSchema({
    properties: {
        to: StringSchema,
        output: StringSchema,
        [kSelfContained]: BooleanSchema,
        pdfEngine: StringSchema,
        pdfEngineOpts: arraySchema(StringSchema),
        makeIndexOpts: arraySchema(StringSchema),
        tlmgrOpts: arraySchema(StringSchema),
        natbib: BooleanSchema,
        biblatex: BooleanSchema,
        [kToc]: BooleanSchema,
        [kTocTitle]: StringSchema,
        [kListings]: BooleanSchema,
        [kNumberSections]: BooleanSchema,
        [kNumberOffset]: arraySchema(NumberSchema),
        [kTopLevelDivision]: StringSchema,
        [kShiftHeadingLevelBy]: StringSchema,
        [kIncludeInHeader]: StringSchema,
        [kIncludeBeforeBody]: StringSchema,
        [kIncludeAfterBody]: StringSchema,
        [kMathjax]: BooleanSchema,
        [kKatex]: BooleanSchema,
        [kMathml]: BooleanSchema,
        [kGladtex]: BooleanSchema,
        [kWebtex]: BooleanSchema
    }
});
objectSchema({
    properties: {
        pdfEngine: StringSchema,
        pdfEngineOpts: arraySchema(StringSchema),
        bibEngine: enumSchema("natbib", "biblatex"),
        indexEngine: StringSchema,
        indexEngineOpts: arraySchema(StringSchema),
        tlmgrOpts: arraySchema(StringSchema)
    },
    required: [
        "pdfEngine"
    ]
});
const kRegExBeginYAML = /^---[ \t]*$/;
oneOfSchema(formatExecuteOptionsSchema, enumSchema("default"));
let formatAliases = undefined;
const kRegExEndYAML = /^(?:---|\.\.\.)([ \t]*)$/;
const kRegExYAML = /(^)(---[ \t]*[\r\n]+(?![ \t]*[\r\n]+)[\W\w]*?[\r\n]+(?:---|\.\.\.))([ \t]*)$/gm;
const kRegxHTMLComment = /<!--[\W\w]*?-->/gm;
const kRegexFencedCode = /^([\t >]*`{3,})[^`\n]*\n[\W\w]*?\n\1\s*$/gm;
function readYaml(file) {
    if (existsSync(file)) {
        const decoder = new TextDecoder("utf-8");
        const yml = Deno.readFileSync(file);
        return parse3(decoder.decode(yml), {
            schema: json
        });
    } else {
        throw new Error(`YAML file ${file} not found.`);
    }
}
function getFormatAliases() {
    if (formatAliases !== undefined) {
        return formatAliases;
    }
    formatAliases = readYaml(join3(resourcePath(), "schema/format-aliases.yml")).aliases;
    return formatAliases;
}
function getExpandedFormatAliases() {
    const aliases = getFormatAliases();
    const result = {};
    for (const [key, value] of Object.entries(aliases)){
        result[key] = expandFormatAliases(value);
    }
    return result;
}
class ValidationError2 extends Error {
    validationErrors;
    constructor(msg, validationErrors){
        super(msg);
        Object.setPrototypeOf(this, ValidationError2.prototype);
        this.validationErrors = validationErrors;
    }
}
function readAndValidateYamlFromFile(file, schema, errorMessage) {
    if (!existsSync(file)) {
        throw new Error(`YAML file ${file} not found.`);
    }
    const contents = asMappedString(Deno.readTextFileSync(file));
    return readAndValidateYamlFromMappedString(contents, schema, errorMessage);
}
function expandFormatAliases(lst) {
    const aliases = getFormatAliases();
    const result = [];
    lst = lst.slice();
    for(let i71 = 0; i71 < lst.length; ++i71){
        const el = lst[i71];
        if (el.startsWith("$")) {
            const v = aliases[el.slice(1)];
            if (v === undefined) {
                throw new Error(`Internal Error: ${el} doesn't have an entry in the aliases map`);
            }
            lst.push(...v);
        } else {
            result.push(el);
        }
    }
    return result;
}
async function getFormatSchema(format6) {
    const aliases = getExpandedFormatAliases();
    aliases["pandoc-all"];
    const entries = [];
    try {
        entries.push(...await readAndValidateYamlFromFile(resourcePath("schema/format-pandoc.yml"), {
            $id: "good"
        }, "schema entry file validation failed."));
    } catch (e) {
        error("\n");
        error(e);
        if (e instanceof ValidationError2) {
            for (const err of e.validationErrors){
                error(err.message);
                error(err.error.message);
                error("\n");
            }
        }
        throw e;
    }
    const useEntry = (entry)=>{
        if (entry.disabled) {
            return expandFormatAliases(entry.disabled).indexOf(format6) === -1;
        } else if (entry.enabled) {
            return expandFormatAliases(entry.enabled).indexOf(format6) !== -1;
        }
        return true;
    };
    const properties2 = {};
    for (const entry1 of entries){
        if (!useEntry(entry1)) {
            continue;
        }
        let schema = convertFromYaml(entry1.schema);
        if (entry1.description) {
            if (typeof entry1.description === "string") {
                schema = documentSchema(schema, entry1.description);
            } else if (typeof entry1.description === "object") {
                schema = documentSchema(schema, entry1.description.short);
            }
        }
        properties2[entry1.name] = schema;
    }
    return oneOfSchema(objectSchema({
        properties: properties2
    }), enumSchema("default"));
}
function loadDefaultSchemaDefinitions() {
    return loadSchemaDefinitions(resourcePath("schema/definitions.yml"));
}
function readYamlFromString(yml) {
    return parse3(yml, {
        schema: json
    });
}
function readYamlFromMarkdown(markdown) {
    if (markdown) {
        markdown = normalizeNewlines(markdown);
        markdown = markdown.replaceAll(kRegxHTMLComment, "");
        markdown = markdown.replaceAll(kRegexFencedCode, "");
        let yaml = "";
        kRegExYAML.lastIndex = 0;
        let match = kRegExYAML.exec(markdown);
        while(match != null){
            const yamlBlock = removeYamlDelimiters(match[2]);
            if (!yamlBlock.startsWith("\n\n") && !yamlBlock.startsWith("\n---") && yamlBlock.trim().length > 0) {
                parse3(yamlBlock, {
                    json: true,
                    schema: json
                });
                yaml += yamlBlock;
            }
            match = kRegExYAML.exec(markdown);
        }
        kRegExYAML.lastIndex = 0;
        const metadata1 = parse3(yaml, {
            json: true,
            schema: json
        });
        return metadata1 || {};
    } else {
        return {};
    }
}
let ajvInit = false;
async function ensureAjv() {
    if (!ajvInit) {
        setupAjv(new __pika_web_default_export_for_treeshaking__1({
            allErrors: true
        }));
        ajvInit = true;
        await loadDefaultSchemaDefinitions();
    }
}
async function readAndValidateYamlFromMappedString(mappedYaml, schema, errorMessage) {
    await ensureAjv();
    const result = await withValidator(schema, (validator)=>{
        const annotation = readAnnotatedYamlFromMappedString(mappedYaml);
        const validateYaml = !(annotation.result?.["validate-yaml"] === false);
        const yaml = annotation.result;
        if (validateYaml) {
            const valResult = validator.validateParse(mappedYaml, annotation);
            if (valResult.errors.length) {
                validator.reportErrorsInSource({
                    result: yaml,
                    errors: valResult.errors
                }, mappedYaml, errorMessage, error, info);
            }
            return {
                yaml: yaml,
                yamlValidationErrors: valResult.errors
            };
        } else {
            return {
                yaml: yaml,
                yamlValidationErrors: []
            };
        }
    });
    if (result.yamlValidationErrors.length > 0) {
        throw new ValidationError2(errorMessage, result.yamlValidationErrors);
    }
    return result.yaml;
}
const schemaCache = {};
const schemaCacheNormalized = {};
function cacheSchemaFunction(name97, maker) {
    const getter = async (normalized)=>{
        if (normalized) {
            if (schemaCacheNormalized[name97]) {
                return schemaCacheNormalized[name97];
            }
            const schema = await getter();
            schemaCacheNormalized[name97] = normalizeSchema(schema);
            return schemaCacheNormalized[name97];
        } else {
            if (schemaCache[name97]) {
                return schemaCache[name97];
            }
            const schema = await maker();
            schemaCache[name97] = schema;
            return schema;
        }
    };
    return getter;
}
const pandocOutputFormats = [
    "asciidoc",
    "asciidoctor",
    "beamer",
    "biblatex",
    "bibtex",
    "commonmark",
    "commonmark_x",
    "context",
    "csljson",
    "docbook",
    "docbook4",
    "docbook5",
    "docx",
    "dokuwiki",
    "dzslides",
    "epub",
    "epub2",
    "epub3",
    "fb2",
    "gfm",
    "haddock",
    "html",
    "html4",
    "html5",
    "icml",
    "ipynb",
    "jats",
    "jats_archiving",
    "jats_articleauthoring",
    "jats_publishing",
    "jira",
    "json",
    "latex",
    "man",
    "markdown",
    "markdown_github",
    "markdown_mmd",
    "markdown_phpextra",
    "markdown_strict",
    "mediawiki",
    "ms",
    "muse",
    "native",
    "odt",
    "opendocument",
    "opml",
    "org",
    "pdf",
    "plain",
    "pptx",
    "revealjs",
    "rst",
    "rtf",
    "s5",
    "slideous",
    "slidy",
    "tei",
    "texinfo",
    "textile",
    "xwiki",
    "zimwiki", 
];
async function makeFrontMatterFormatSchema() {
    const formatSchemaDescriptorList = await Promise.all(pandocOutputFormats.map(async (x)=>{
        return {
            regex: `^${x}(\\+.+)?$`,
            schema: await getFormatSchema(x),
            name: x
        };
    }));
    const formatSchemas = formatSchemaDescriptorList.map(({ regex , schema  })=>[
            regex,
            schema
        ]
    );
    const plusFormatStringSchemas = formatSchemaDescriptorList.map(({ regex , name: name98  })=>completeSchema(regexSchema(regex, `be '${name98}'`), {
            type: "value",
            display: name98,
            suggest_on_accept: true,
            value: name98,
            description: name98
        })
    );
    const completionsObject = Object.fromEntries(formatSchemaDescriptorList.map(({ name: name99  })=>[
            name99,
            name99
        ]
    ));
    return oneOfSchema(describeSchema(oneOfSchema(...plusFormatStringSchemas), "the name of a pandoc-supported output format"), regexSchema("^hugo(\\+.+)?$", "be 'hugo'"), objectSchema({
        patternProperties: Object.fromEntries(formatSchemas),
        completions: completionsObject,
        additionalProperties: false
    }));
}
cacheSchemaFunction("front-matter-format", makeFrontMatterFormatSchema);
async function makeFrontMatterSchema() {
    return idSchema(oneOfSchema(NullSchema, objectSchema({
        properties: {
            title: StringSchema
        },
        description: "be a Quarto YAML front matter object"
    })), "front-matter");
}
const getFrontMatterSchema = cacheSchemaFunction("front-matter", makeFrontMatterSchema);
async function readAndValidateYamlFromMarkdown(eitherMarkdown) {
    let markdown = asMappedString(eitherMarkdown);
    if (!markdown.value) {
        return {};
    }
    markdown = mappedNormalizeNewlines(markdown);
    markdown = skipRegexpAll(markdown, kRegxHTMLComment);
    markdown = skipRegexpAll(markdown, kRegexFencedCode);
    const yaml = [];
    kRegExYAML.lastIndex = 0;
    for (const match of matchAll(markdown.value, kRegExYAML)){
        const yamlBlock = removeYamlDelimitersMapped(match[2]);
        const yamlBlockValue = yamlBlock.value;
        if (!yamlBlockValue.startsWith("\n\n") && !yamlBlockValue.startsWith("\n---") && yamlBlockValue.trim().length > 0) {
            parse3(yamlBlockValue, {
                json: true,
                schema: json
            });
            yaml.push(yamlBlock);
        }
    }
    kRegExYAML.lastIndex = 0;
    if (yaml.length === 0) {
        return {};
    }
    const mappedYaml = mappedConcat(yaml);
    const metadata2 = parse3(mappedYaml.value, {
        json: true,
        schema: json
    });
    if (metadata2?.["validate-yaml"] === false) {
        return readAndValidateYamlFromMappedString(mappedYaml, await getFrontMatterSchema(), "YAML front matter validation failed");
    }
    return metadata2;
}
async function readYamlFromMarkdownFile(file) {
    const markdown = Deno.readTextFileSync(file);
    const result = await readAndValidateYamlFromMarkdown(markdown);
    return result;
}
function partitionYamlFrontMatter(markdown) {
    const mdLines = lines(markdown.trimLeft());
    if (mdLines.length < 3 || !mdLines[0].match(kRegExBeginYAML)) {
        return null;
    } else if (mdLines[1].trim().length === 0 || mdLines[1].match(kRegExEndYAML)) {
        return null;
    } else {
        const endYamlPos = mdLines.findIndex((line, index)=>index > 0 && line.match(kRegExEndYAML)
        );
        if (endYamlPos === -1) {
            return null;
        } else {
            return {
                yaml: mdLines.slice(0, endYamlPos + 1).join("\n"),
                markdown: "\n" + mdLines.slice(endYamlPos + 1).join("\n")
            };
        }
    }
}
function removeYamlDelimiters(yaml) {
    return yaml.replace(/^---/, "").replace(/---\s*$/, "");
}
function removeYamlDelimitersMapped(eitherYaml) {
    let yaml = asMappedString(eitherYaml);
    yaml = skipRegexp(yaml, /^---/);
    yaml = skipRegexp(yaml, /---\s*$/);
    return yaml;
}
async function loadSchemaDefinitions(file) {
    let yaml = readYaml(file);
    await ensureAjv();
    await Promise.all(Object.entries(yaml).map(async ([name100, yamlSchema])=>{
        const schema = normalizeSchema(idSchema(convertFromYaml(yamlSchema), name100));
        await withValidator(schema, (_validator)=>{
            return;
        });
    }));
}
function generate() {
    return crypto.randomUUID();
}
function mergeConfigs(config, ...configs) {
    config = cloneDeep1(config);
    configs = cloneDeep1(configs);
    return __VIRTUAL_FILE154(config, ...configs, mergeArrayCustomizer);
}
function mergeArrayCustomizer(objValue, srcValue) {
    if (__VIRTUAL_FILE53(objValue) || __VIRTUAL_FILE53(srcValue)) {
        if (!objValue) {
            return srcValue;
        } else if (!srcValue) {
            return objValue;
        } else {
            if (!__VIRTUAL_FILE53(objValue)) {
                objValue = [
                    objValue
                ];
            }
            if (!__VIRTUAL_FILE53(srcValue)) {
                srcValue = [
                    srcValue
                ];
            }
        }
        const combined = objValue.concat(srcValue);
        return __VIRTUAL_FILE210(combined, (value)=>{
            if (typeof value === "function") {
                return generate();
            } else {
                return JSON.stringify(value);
            }
        });
    }
}
function camelToKebab(camel) {
    const kebab = [];
    for(let i72 = 0; i72 < camel.length; i72++){
        const ch = camel.charAt(i72);
        if (ch === ch.toUpperCase() && !/^\d+/.test(ch)) {
            if (i72 > 0) {
                kebab.push("-");
            }
            kebab.push(ch.toLowerCase());
        } else {
            kebab.push(ch);
        }
    }
    return kebab.join("");
}
function kebabToCamel(kebab, leadingUppercase = false) {
    const camel = [];
    for(let i73 = 0; i73 < kebab.length; i73++){
        const ch = kebab.charAt(i73);
        if (ch === "-") {
            camel.push(kebab.charAt(++i73).toUpperCase());
        } else if (i73 === 0 && leadingUppercase) {
            camel.push(ch.toUpperCase());
        } else {
            camel.push(ch);
        }
    }
    return camel.join("");
}
async function includedMetadata(dir, baseMetadata, schema) {
    const yamlFiles = [];
    const metadataFile = baseMetadata[kMetadataFile];
    if (metadataFile) {
        yamlFiles.push(join3(dir, metadataFile));
    }
    const metadataFiles = baseMetadata[kMetadataFiles];
    if (metadataFiles && Array.isArray(metadataFiles)) {
        metadataFiles.forEach((file)=>yamlFiles.push(join3(dir, file))
        );
    }
    const filesMetadata = await Promise.all(yamlFiles.map(async (yamlFile)=>{
        if (await exists(yamlFile)) {
            try {
                const yaml = await readAndValidateYamlFromFile(yamlFile, schema, `Validation of metadata file ${yamlFile} failed.`);
                return yaml;
            } catch (e) {
                error("\nError reading metadata file from " + yamlFile + "\n");
                throw e;
            }
        } else {
            return undefined;
        }
    }));
    return {
        metadata: mergeFormatMetadata({}, ...filesMetadata),
        files: yamlFiles
    };
}
function formatFromMetadata(baseFormat, to, debug1) {
    const typedFormat = {
        render: {},
        execute: {},
        pandoc: {},
        language: {},
        metadata: {}
    };
    let format7 = typedFormat;
    const configFormats = baseFormat.metadata[kMetadataFormat];
    if (configFormats instanceof Object) {
        const configFormat = configFormats[to];
        if (configFormat === "default" || configFormat === true) {
            format7 = metadataAsFormat({});
        } else if (configFormat instanceof Object) {
            format7 = metadataAsFormat(configFormat);
        }
    }
    const mergedFormat = mergeFormatMetadata(baseFormat, format7);
    if (debug1) {
        mergedFormat.execute[kKeepMd] = true;
        mergedFormat.render[kKeepTex] = true;
    }
    return mergedFormat;
}
function formatKeys(metadata3) {
    if (typeof metadata3[kMetadataFormat] === "string") {
        return [
            metadata3[kMetadataFormat]
        ];
    } else if (metadata3[kMetadataFormat] instanceof Object) {
        return Object.keys(metadata3[kMetadataFormat]).filter((key)=>{
            const format8 = metadata3[kMetadataFormat][key];
            return format8 !== null && format8 !== false;
        });
    } else {
        return [];
    }
}
function isQuartoMetadata(key) {
    return kRenderDefaultsKeys.includes(key) || kExecuteDefaultsKeys.includes(key) || kPandocDefaultsKeys.includes(key) || kLanguageDefaultsKeys.includes(key);
}
function isIncludeMetadata(key) {
    return [
        kHeaderIncludes,
        kIncludeBefore,
        kIncludeAfter
    ].includes(key);
}
function metadataAsFormat(metadata4) {
    const typedFormat = {
        render: {},
        execute: {},
        pandoc: {},
        language: {},
        metadata: {}
    };
    const format9 = typedFormat;
    Object.keys(metadata4).forEach((key)=>{
        if ([
            kRenderDefaults,
            kExecuteDefaults,
            kPandocDefaults,
            kLanguageDefaults,
            kPandocMetadata, 
        ].includes(key)) {
            if (typeof metadata4[key] == "boolean") {
                if (key === kExecuteDefaults) {
                    format9[key] = format9[key] || {};
                    format9[kExecuteDefaults][kExecuteEnabled] = metadata4[key];
                }
            } else {
                format9[key] = {
                    ...format9[key],
                    ...metadata4[key]
                };
            }
        } else {
            if (kRenderDefaultsKeys.includes(key)) {
                format9.render[key] = metadata4[key];
            } else if (kExecuteDefaultsKeys.includes(key)) {
                format9.execute[key] = metadata4[key];
            } else if (kPandocDefaultsKeys.includes(key)) {
                format9.pandoc[key] = metadata4[key];
            } else if (kLanguageDefaultsKeys.includes(key)) {
                format9.language[key] = metadata4[key];
            } else {
                format9.metadata[key] = metadata4[key];
            }
        }
    });
    return typedFormat;
}
function metadataGetDeep(metadata5, property7) {
    let values14 = [];
    __VIRTUAL_FILE145(metadata5, (value, key)=>{
        if (key === property7) {
            values14.push(value);
        } else if (__VIRTUAL_FILE18(value)) {
            values14 = values14.concat(metadataGetDeep(value, property7));
        }
    });
    return values14;
}
const kUnmergeableKeys = [
    kTblColwidths
];
function mergeFormatMetadata(config, ...configs) {
    config = cloneDeep1(config);
    configs = cloneDeep1(configs);
    return __VIRTUAL_FILE154(config, ...configs, (objValue, srcValue, key)=>{
        if (kUnmergeableKeys.includes(key)) {
            return srcValue;
        } else {
            return mergeArrayCustomizer(objValue, srcValue);
        }
    });
}
const kStdOut = "-";
function parseRenderFlags(args) {
    const flags = {};
    const argsStack = [
        ...args
    ];
    let arg = argsStack.shift();
    while(arg !== undefined){
        switch(arg){
            case "-t":
            case "--to":
                arg = argsStack.shift();
                if (arg && !arg.startsWith("-")) {
                    flags.to = arg;
                }
                break;
            case "-o":
            case "--output":
                arg = argsStack.shift();
                if (!arg || arg.startsWith("-")) {
                    flags.output = kStdOut;
                } else {
                    flags.output = arg;
                }
                break;
            case "--output-dir":
                arg = argsStack.shift();
                flags.outputDir = arg;
                break;
            case "--self-contained":
                flags[kSelfContained] = true;
                arg = argsStack.shift();
                break;
            case "--pdf-engine":
                arg = argsStack.shift();
                flags.pdfEngine = arg;
                break;
            case "--pdf-engine-opt":
                arg = argsStack.shift();
                if (arg) {
                    flags.pdfEngineOpts = flags.pdfEngineOpts || [];
                    flags.pdfEngineOpts.push(arg);
                }
                break;
            case "--latex-makeindex-opt":
                arg = argsStack.shift();
                if (arg) {
                    flags.makeIndexOpts = flags.makeIndexOpts || [];
                    flags.makeIndexOpts.push(arg);
                }
                break;
            case "--latex-tlmgr-opt":
                arg = argsStack.shift();
                if (arg) {
                    flags.tlmgrOpts = flags.tlmgrOpts || [];
                    flags.tlmgrOpts.push(arg);
                }
                break;
            case "--natbib":
                arg = argsStack.shift();
                flags.natbib = true;
                break;
            case "--biblatex":
                arg = argsStack.shift();
                flags.biblatex = true;
                break;
            case `--${kToc}`:
            case `--${kTableOfContents}`:
                arg = argsStack.shift();
                flags.toc = true;
                break;
            case "--listings":
                arg = argsStack.shift();
                flags[kListings] = true;
                break;
            case "--number-sections":
                arg = argsStack.shift();
                flags[kNumberSections] = true;
                break;
            case "--number-offset":
                arg = argsStack.shift();
                flags[kNumberSections] = true;
                flags[kNumberOffset] = parseNumbers("--number-offset", arg);
                break;
            case "--top-level-division":
                arg = argsStack.shift();
                flags[kTopLevelDivision] = arg;
                break;
            case "--shift-heading-level-by":
                arg = argsStack.shift();
                flags[kShiftHeadingLevelBy] = arg;
                break;
            case "--include-in-header":
            case "--include-before-body":
            case "--include-after-body":
                {
                    const include1 = arg.replace("^--", "");
                    const includeFlags = flags;
                    includeFlags[include1] = includeFlags[include1] || [];
                    arg = argsStack.shift();
                    includeFlags[include1].push(arg);
                    break;
                }
            case "--mathjax":
                flags.mathjax = true;
                arg = argsStack.shift();
                break;
            case "--katex":
                flags.katex = true;
                arg = argsStack.shift();
                break;
            case "--mathml":
                flags.mathml = true;
                arg = argsStack.shift();
                break;
            case "--gladtex":
                flags.gladtex = true;
                arg = argsStack.shift();
                break;
            case "--webtex":
                flags.webtex = true;
                arg = argsStack.shift();
                break;
            case "--execute":
                flags.execute = true;
                arg = argsStack.shift();
                break;
            case "--no-execute":
                flags.execute = false;
                arg = argsStack.shift();
                break;
            case "--execute-params":
                arg = argsStack.shift();
                flags.paramsFile = arg;
                break;
            case "--execute-dir":
                arg = argsStack.shift();
                flags.executeDir = arg;
                break;
            case "--execute-daemon":
                arg = argsStack.shift();
                flags.executeDaemon = parseInt(arg, 10);
                if (isNaN(flags.executeDaemon)) {
                    delete flags.executeDaemon;
                }
                break;
            case "--no-execute-daemon":
                arg = argsStack.shift();
                flags.executeDaemon = 0;
                break;
            case "--execute-daemon-restart":
                arg = argsStack.shift();
                flags.executeDaemonRestart = true;
                break;
            case "--execute-debug":
                arg = argsStack.shift();
                flags.executeDebug = true;
                break;
            case "--cache":
                arg = argsStack.shift();
                flags.executeCache = true;
                break;
            case "--no-cache":
                arg = argsStack.shift();
                flags.executeCache = false;
                break;
            case "--cache-refresh":
                arg = argsStack.shift();
                flags.executeCache = "refresh";
                break;
            case "--debug":
                flags.debug = true;
                arg = argsStack.shift();
                break;
            case "-P":
            case "--execute-param":
                arg = argsStack.shift();
                if (arg) {
                    const param = parseMetadataFlagValue(arg);
                    if (param) {
                        if (param.value !== undefined) {
                            flags.params = flags.params || {};
                            flags.params[param.name] = param.value;
                        }
                    }
                }
                break;
            case "-M":
            case "--metadata":
                arg = argsStack.shift();
                if (arg) {
                    const metadata6 = parseMetadataFlagValue(arg);
                    if (metadata6) {
                        if (metadata6.value !== undefined) {
                            if (isQuartoMetadata(metadata6.name)) {
                                flags.metadata = flags.metadata || {};
                                flags.metadata[metadata6.name] = metadata6.value;
                            } else {
                                flags.pandocMetadata = flags.pandocMetadata || {};
                                flags.pandocMetadata[metadata6.name] = metadata6.value;
                            }
                        }
                    }
                }
                break;
            case "--metadata-file":
                arg = argsStack.shift();
                if (arg) {
                    if (existsSync(arg)) {
                        const metadata7 = readYamlFromMarkdownFile(arg);
                        flags.metadata = {
                            ...flags.metadata,
                            ...metadata7
                        };
                    }
                }
                break;
            case "--reference-location":
                arg = argsStack.shift();
                if (arg) {
                    flags[kReferenceLocation] = arg;
                }
                break;
            default:
                arg = argsStack.shift();
                break;
        }
    }
    return flags;
}
function havePandocArg(pandocArgs, arg) {
    return pandocArgs.indexOf(arg) !== -1;
}
function replacePandocArg(pandocArgs, arg, value) {
    const newArgs = [
        ...pandocArgs
    ];
    const argIndex = pandocArgs.indexOf(arg);
    if (argIndex !== -1) {
        newArgs[argIndex + 1] = value;
    } else {
        newArgs.push(arg);
        newArgs.push(value);
    }
    return newArgs;
}
function replacePandocOutputArg(pandocArgs, output) {
    if (havePandocArg(pandocArgs, "--output")) {
        return replacePandocArg(pandocArgs, "--output", output);
    } else if (havePandocArg(pandocArgs, "-o")) {
        return replacePandocArg(pandocArgs, "-o", output);
    } else {
        return pandocArgs;
    }
}
function fixupPandocArgs(pandocArgs, flags) {
    pandocArgs = pandocArgs.reduce((args, arg, index)=>{
        args.push(arg);
        if (flags.output === kStdOut && pandocArgs[index + 1] !== kStdOut && (arg === "-o" || arg === "--output")) {
            args.push(kStdOut);
        }
        return args;
    }, new Array());
    const removeArgs = new Map();
    removeArgs.set("--output-dir", true);
    removeArgs.set("--execute", false);
    removeArgs.set("--no-execute", false);
    removeArgs.set("-P", true);
    removeArgs.set("--execute-param", true);
    removeArgs.set("--execute-params", true);
    removeArgs.set("--execute-dir", true);
    removeArgs.set("--execute-daemon", true);
    removeArgs.set("--no-execute-daemon", false);
    removeArgs.set("--execute-daemon-restart", false);
    removeArgs.set("--execute-debug", false);
    removeArgs.set("--cache", false);
    removeArgs.set("--no-cache", false);
    removeArgs.set("--cache-refresh", false);
    removeArgs.set("--debug", false);
    removeArgs.set("--metadata-file", true);
    removeArgs.set("--latex-makeindex-opt", true);
    removeArgs.set("--latex-tlmgr-opt", true);
    removeArgs.set("--log", true);
    removeArgs.set("--l", true);
    removeArgs.set("--log-level", true);
    removeArgs.set("--ll", true);
    removeArgs.set("--log-format", true);
    removeArgs.set("--lf", true);
    removeArgs.set("--quiet", false);
    removeArgs.set("--q", false);
    pandocArgs = removePandocArgs(pandocArgs, removeArgs);
    return removeQuartoMetadataFlags(pandocArgs);
}
function removePandocArgs(pandocArgs, removeArgs) {
    let removeNext = false;
    return pandocArgs.reduce((args, arg)=>{
        if (!removeArgs.has(arg)) {
            if (!removeNext) {
                args.push(arg);
            }
            removeNext = false;
        } else {
            removeNext = removeArgs.get(arg);
        }
        return args;
    }, new Array());
}
function removePandocToArg(args) {
    const removeArgs = new Map();
    removeArgs.set("--to", true);
    removeArgs.set("-t", true);
    return removePandocArgs(args, removeArgs);
}
function removeQuartoMetadataFlags(pandocArgs) {
    const args = [];
    for(let i74 = 0; i74 < pandocArgs.length; i74++){
        const arg = pandocArgs[i74];
        if (arg === "--metadata" || arg === "-M") {
            const flagValue = parseMetadataFlagValue(pandocArgs[i74 + 1] || "");
            if (flagValue !== undefined && isQuartoMetadata(flagValue.name)) {
                i74++;
            } else {
                args.push(arg);
            }
        } else {
            args.push(arg);
        }
    }
    return args;
}
function parseMetadataFlagValue(arg) {
    const match = arg.match(/^([^=:]+)[=:](.*)$/);
    if (match) {
        return {
            name: match[1],
            value: readYamlFromString(match[2])
        };
    }
    return undefined;
}
function resolveParams(params, paramsFile) {
    if (params || paramsFile) {
        params = params || {};
        if (paramsFile) {
            params = mergeConfigs(readYaml(paramsFile), params);
        }
        return params;
    } else {
        return undefined;
    }
}
function parseNumbers(flag, value) {
    if (value) {
        const numbers = value.split(/,/).map((number2)=>parseInt(number2.trim(), 10)
        ).filter((number3)=>!isNaN(number3)
        );
        if (numbers.length > 0) {
            return numbers;
        }
    }
    throw new Error(`Invalid value for ${flag} (should be a comma separated list of numbers)`);
}
function isPdfOutput(format10) {
    if (typeof format10 !== "string") {
        format10 = format10?.to || "html";
    }
    return format10 === "pdf" || format10 === "beamer";
}
function isLatexOutput(format11) {
    return [
        "pdf",
        "latex",
        "beamer"
    ].includes(format11.to || "");
}
function isEpubOutput(format12) {
    if (typeof format12 !== "string") {
        format12 = format12?.to || "html";
    }
    return [
        "epub",
        "epub2",
        "epub3"
    ].includes(format12 || "");
}
function isHtmlFileOutput(format13) {
    if (typeof format13 !== "string") {
        format13 = format13?.to || "html";
    }
    return isHtmlDocOutput(format13) || isHtmlSlideOutput(format13);
}
function isHtmlOutput(format14, strict) {
    if (typeof format14 !== "string") {
        format14 = format14?.to;
    }
    format14 = format14 || "html";
    if (isHtmlDocOutput(format14)) {
        return true;
    } else if (!strict) {
        return isHtmlSlideOutput(format14) || isEpubOutput(format14);
    } else {
        return false;
    }
}
function isHtmlDocOutput(format15) {
    if (typeof format15 !== "string") {
        format15 = format15?.to || "html";
    }
    return [
        "html",
        "html4",
        "html5", 
    ].includes(format15);
}
function isHtmlSlideOutput(format16) {
    return [
        "s5",
        "dzslides",
        "slidy",
        "slideous",
        "revealjs", 
    ].includes(format16);
}
function isPresentationOutput(format17) {
    if (format17.to) {
        return [
            "s5",
            "dzslides",
            "slidy",
            "slideous",
            "revealjs",
            "beamer",
            "pptx"
        ].some((to)=>format17.to?.startsWith(to)
        );
    } else {
        return false;
    }
}
function isRevealjsOutput(format18) {
    if (typeof format18 !== "string") {
        format18 = format18?.to;
    }
    format18 = format18 || "html";
    return format18.startsWith("revealjs");
}
function isIpynbOutput(format19) {
    return !!format19.to && format19.to.startsWith("ipynb");
}
function isMarkdownOutput(format20, flavors = [
    "markdown",
    "gfm",
    "commonmark"
]) {
    const to = (format20.to || "").replace(/[\+\-_].*$/, "");
    return flavors.includes(to) || isIpynbOutput(format20);
}
function isHtmlCompatible(format25) {
    return isHtmlOutput(format25.pandoc) || isMarkdownOutput(format25.pandoc) && format25.render[kPreferHtml] || isIpynbOutput(format25.pandoc);
}
function isJavascriptCompatible(format26) {
    return isHtmlCompatible(format26) && !isEpubOutput(format26.pandoc);
}
function quartoDataDir(subdir, roaming = false) {
    return quartoDir(userDataDir, subdir, roaming);
}
function quartoCacheDir(subdir) {
    return quartoDir(userCacheDir, subdir);
}
function quartoRuntimeDir(subdir) {
    return quartoDir(userRuntimeDir, subdir);
}
function quartoDir(sourceFn, subdir, roaming) {
    const dir = sourceFn("quarto", roaming);
    const fullDir = subdir ? join3(dir, subdir) : dir;
    ensureDirSync(fullDir);
    return fullDir;
}
function userDataDir(appName, roaming = false) {
    switch(Deno.build.os){
        case "darwin":
            return darwinUserDataDir(appName);
        case "linux":
            return xdgUserDataDir(appName);
        case "windows":
            return windowsUserDataDir(appName, roaming);
    }
}
function userCacheDir(appName) {
    switch(Deno.build.os){
        case "darwin":
            return darwinUserCacheDir(appName);
        case "linux":
            return xdgUserCacheDir(appName);
        case "windows":
            return windowsUserDataDir(appName);
    }
}
function userRuntimeDir(appName) {
    switch(Deno.build.os){
        case "darwin":
            return darwinUserCacheDir(appName);
        case "linux":
            return xdgUserRuntimeDir(appName);
        case "windows":
            return windowsUserDataDir(appName);
    }
}
function darwinUserDataDir(appName) {
    return join3(Deno.env.get("HOME") || "", "Library", "Application Support", appName);
}
function darwinUserCacheDir(appName) {
    return join3(Deno.env.get("HOME") || "", "Library", "Caches", appName);
}
function xdgUserDataDir(appName) {
    const dataHome = Deno.env.get("XDG_DATA_HOME") || join3(Deno.env.get("HOME") || "", ".local", "share");
    return join3(dataHome, appName);
}
function xdgUserCacheDir(appName) {
    const cacheHome = Deno.env.get("XDG_CACHE_HOME") || join3(Deno.env.get("HOME") || "", ".cache");
    return join3(cacheHome, appName);
}
function xdgUserRuntimeDir(appName) {
    const runtimeDir = Deno.env.get("XDG_RUNTIME_DIR");
    if (runtimeDir) {
        return runtimeDir;
    } else {
        return xdgUserDataDir(appName);
    }
}
function windowsUserDataDir(appName, roaming = false) {
    const dir = (roaming ? Deno.env.get("APPDATA") : Deno.env.get("LOCALAPPDATA")) || "";
    return join3(dir, appName);
}
async function dartCompile(input, temp, loadPaths, compressed) {
    const inputFilePath = temp.createFile({
        suffix: "scss"
    });
    Deno.writeTextFileSync(inputFilePath, input);
    const args = [
        inputFilePath,
        "--style",
        compressed ? "compressed" : "expanded", 
    ];
    if (loadPaths) {
        loadPaths.forEach((loadPath)=>{
            args.push(`--load-path=${loadPath}`);
        });
    }
    return await dartCommand(args);
}
async function dartCommand(args) {
    const command = Deno.build.os === "windows" ? "sass.bat" : "sass";
    const sass = binaryPath(join3("dart-sass", command));
    const cmd = [
        sass,
        ...args, 
    ];
    const result = await execProcess({
        cmd,
        stdout: "piped",
        stderr: "piped"
    });
    if (result.success) {
        return result.stdout;
    } else {
        const errLines = lines(result.stderr || "");
        const errMsg = errLines.slice(0, errLines.length - 2).join("\n");
        throw new Error("Theme file compilation failed:\n\n" + errMsg);
    }
}
var commonjsGlobal2 = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function createCommonjsModule6(fn, basedir, module) {
    return module = {
        path: basedir,
        exports: {},
        require: function(path64, base8) {
            return commonjsRequire3(path64, base8 === void 0 || base8 === null ? module.path : base8);
        }
    }, fn(module, module.exports), module.exports;
}
function commonjsRequire3() {
    throw new Error("Dynamic requires are not currently supported by @rollup/plugin-commonjs");
}
var md5 = createCommonjsModule6(function(module) {
    (function($) {
        function safeAdd(x, y) {
            var lsw = (x & 65535) + (y & 65535);
            var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
            return msw << 16 | lsw & 65535;
        }
        function bitRotateLeft(num, cnt) {
            return num << cnt | num >>> 32 - cnt;
        }
        function md5cmn(q, a, b, x, s, t) {
            return safeAdd(bitRotateLeft(safeAdd(safeAdd(a, q), safeAdd(x, t)), s), b);
        }
        function md5ff(a, b, c, d, x, s, t) {
            return md5cmn(b & c | ~b & d, a, b, x, s, t);
        }
        function md5gg(a, b, c, d, x, s, t) {
            return md5cmn(b & d | c & ~d, a, b, x, s, t);
        }
        function md5hh(a, b, c, d, x, s, t) {
            return md5cmn(b ^ c ^ d, a, b, x, s, t);
        }
        function md5ii(a, b, c, d, x, s, t) {
            return md5cmn(c ^ (b | ~d), a, b, x, s, t);
        }
        function binlMD5(x, len13) {
            x[len13 >> 5] |= 128 << len13 % 32;
            x[(len13 + 64 >>> 9 << 4) + 14] = len13;
            var i75;
            var olda;
            var oldb;
            var oldc;
            var oldd;
            var a = 1732584193;
            var b = -271733879;
            var c = -1732584194;
            var d = 271733878;
            for(i75 = 0; i75 < x.length; i75 += 16){
                olda = a;
                oldb = b;
                oldc = c;
                oldd = d;
                a = md5ff(a, b, c, d, x[i75], 7, -680876936);
                d = md5ff(d, a, b, c, x[i75 + 1], 12, -389564586);
                c = md5ff(c, d, a, b, x[i75 + 2], 17, 606105819);
                b = md5ff(b, c, d, a, x[i75 + 3], 22, -1044525330);
                a = md5ff(a, b, c, d, x[i75 + 4], 7, -176418897);
                d = md5ff(d, a, b, c, x[i75 + 5], 12, 1200080426);
                c = md5ff(c, d, a, b, x[i75 + 6], 17, -1473231341);
                b = md5ff(b, c, d, a, x[i75 + 7], 22, -45705983);
                a = md5ff(a, b, c, d, x[i75 + 8], 7, 1770035416);
                d = md5ff(d, a, b, c, x[i75 + 9], 12, -1958414417);
                c = md5ff(c, d, a, b, x[i75 + 10], 17, -42063);
                b = md5ff(b, c, d, a, x[i75 + 11], 22, -1990404162);
                a = md5ff(a, b, c, d, x[i75 + 12], 7, 1804603682);
                d = md5ff(d, a, b, c, x[i75 + 13], 12, -40341101);
                c = md5ff(c, d, a, b, x[i75 + 14], 17, -1502002290);
                b = md5ff(b, c, d, a, x[i75 + 15], 22, 1236535329);
                a = md5gg(a, b, c, d, x[i75 + 1], 5, -165796510);
                d = md5gg(d, a, b, c, x[i75 + 6], 9, -1069501632);
                c = md5gg(c, d, a, b, x[i75 + 11], 14, 643717713);
                b = md5gg(b, c, d, a, x[i75], 20, -373897302);
                a = md5gg(a, b, c, d, x[i75 + 5], 5, -701558691);
                d = md5gg(d, a, b, c, x[i75 + 10], 9, 38016083);
                c = md5gg(c, d, a, b, x[i75 + 15], 14, -660478335);
                b = md5gg(b, c, d, a, x[i75 + 4], 20, -405537848);
                a = md5gg(a, b, c, d, x[i75 + 9], 5, 568446438);
                d = md5gg(d, a, b, c, x[i75 + 14], 9, -1019803690);
                c = md5gg(c, d, a, b, x[i75 + 3], 14, -187363961);
                b = md5gg(b, c, d, a, x[i75 + 8], 20, 1163531501);
                a = md5gg(a, b, c, d, x[i75 + 13], 5, -1444681467);
                d = md5gg(d, a, b, c, x[i75 + 2], 9, -51403784);
                c = md5gg(c, d, a, b, x[i75 + 7], 14, 1735328473);
                b = md5gg(b, c, d, a, x[i75 + 12], 20, -1926607734);
                a = md5hh(a, b, c, d, x[i75 + 5], 4, -378558);
                d = md5hh(d, a, b, c, x[i75 + 8], 11, -2022574463);
                c = md5hh(c, d, a, b, x[i75 + 11], 16, 1839030562);
                b = md5hh(b, c, d, a, x[i75 + 14], 23, -35309556);
                a = md5hh(a, b, c, d, x[i75 + 1], 4, -1530992060);
                d = md5hh(d, a, b, c, x[i75 + 4], 11, 1272893353);
                c = md5hh(c, d, a, b, x[i75 + 7], 16, -155497632);
                b = md5hh(b, c, d, a, x[i75 + 10], 23, -1094730640);
                a = md5hh(a, b, c, d, x[i75 + 13], 4, 681279174);
                d = md5hh(d, a, b, c, x[i75], 11, -358537222);
                c = md5hh(c, d, a, b, x[i75 + 3], 16, -722521979);
                b = md5hh(b, c, d, a, x[i75 + 6], 23, 76029189);
                a = md5hh(a, b, c, d, x[i75 + 9], 4, -640364487);
                d = md5hh(d, a, b, c, x[i75 + 12], 11, -421815835);
                c = md5hh(c, d, a, b, x[i75 + 15], 16, 530742520);
                b = md5hh(b, c, d, a, x[i75 + 2], 23, -995338651);
                a = md5ii(a, b, c, d, x[i75], 6, -198630844);
                d = md5ii(d, a, b, c, x[i75 + 7], 10, 1126891415);
                c = md5ii(c, d, a, b, x[i75 + 14], 15, -1416354905);
                b = md5ii(b, c, d, a, x[i75 + 5], 21, -57434055);
                a = md5ii(a, b, c, d, x[i75 + 12], 6, 1700485571);
                d = md5ii(d, a, b, c, x[i75 + 3], 10, -1894986606);
                c = md5ii(c, d, a, b, x[i75 + 10], 15, -1051523);
                b = md5ii(b, c, d, a, x[i75 + 1], 21, -2054922799);
                a = md5ii(a, b, c, d, x[i75 + 8], 6, 1873313359);
                d = md5ii(d, a, b, c, x[i75 + 15], 10, -30611744);
                c = md5ii(c, d, a, b, x[i75 + 6], 15, -1560198380);
                b = md5ii(b, c, d, a, x[i75 + 13], 21, 1309151649);
                a = md5ii(a, b, c, d, x[i75 + 4], 6, -145523070);
                d = md5ii(d, a, b, c, x[i75 + 11], 10, -1120210379);
                c = md5ii(c, d, a, b, x[i75 + 2], 15, 718787259);
                b = md5ii(b, c, d, a, x[i75 + 9], 21, -343485551);
                a = safeAdd(a, olda);
                b = safeAdd(b, oldb);
                c = safeAdd(c, oldc);
                d = safeAdd(d, oldd);
            }
            return [
                a,
                b,
                c,
                d
            ];
        }
        function binl2rstr(input) {
            var i76;
            var output = "";
            var length32 = input.length * 32;
            for(i76 = 0; i76 < length32; i76 += 8){
                output += String.fromCharCode(input[i76 >> 5] >>> i76 % 32 & 255);
            }
            return output;
        }
        function rstr2binl(input) {
            var i77;
            var output = [];
            output[(input.length >> 2) - 1] = void 0;
            for(i77 = 0; i77 < output.length; i77 += 1){
                output[i77] = 0;
            }
            var length8 = input.length * 8;
            for(i77 = 0; i77 < length8; i77 += 8){
                output[i77 >> 5] |= (input.charCodeAt(i77 / 8) & 255) << i77 % 32;
            }
            return output;
        }
        function rstrMD5(s) {
            return binl2rstr(binlMD5(rstr2binl(s), s.length * 8));
        }
        function rstrHMACMD5(key, data86) {
            var i78;
            var bkey = rstr2binl(key);
            var ipad = [];
            var opad = [];
            var hash;
            ipad[15] = opad[15] = void 0;
            if (bkey.length > 16) {
                bkey = binlMD5(bkey, key.length * 8);
            }
            for(i78 = 0; i78 < 16; i78 += 1){
                ipad[i78] = bkey[i78] ^ 909522486;
                opad[i78] = bkey[i78] ^ 1549556828;
            }
            hash = binlMD5(ipad.concat(rstr2binl(data86)), 512 + data86.length * 8);
            return binl2rstr(binlMD5(opad.concat(hash), 512 + 128));
        }
        function rstr2hex(input) {
            var hexTab = "0123456789abcdef";
            var output = "";
            var x;
            var i79;
            for(i79 = 0; i79 < input.length; i79 += 1){
                x = input.charCodeAt(i79);
                output += hexTab.charAt(x >>> 4 & 15) + hexTab.charAt(x & 15);
            }
            return output;
        }
        function str2rstrUTF8(input) {
            return unescape(encodeURIComponent(input));
        }
        function rawMD5(s) {
            return rstrMD5(str2rstrUTF8(s));
        }
        function hexMD5(s) {
            return rstr2hex(rawMD5(s));
        }
        function rawHMACMD5(k, d) {
            return rstrHMACMD5(str2rstrUTF8(k), str2rstrUTF8(d));
        }
        function hexHMACMD5(k, d) {
            return rstr2hex(rawHMACMD5(k, d));
        }
        function md52(string23, key, raw) {
            if (!key) {
                if (!raw) {
                    return hexMD5(string23);
                }
                return rawMD5(string23);
            }
            if (!raw) {
                return hexHMACMD5(key, string23);
            }
            return rawHMACMD5(key, string23);
        }
        if (module.exports) {
            module.exports = md52;
        } else {
            $.md5 = md52;
        }
    })(commonjsGlobal2);
});
function md5Hash(content) {
    return md5(content);
}
function sassVariable(name101, value, formatter) {
    return {
        name: name101,
        value: formatter ? formatter(value) : value
    };
}
function outputVariable(variable, isDefault = true) {
    return `$${variable.name}: ${variable.value}${isDefault ? " !default" : ""};`;
}
async function compileSass(bundles, temp, minified = true) {
    const imports = __VIRTUAL_FILE181(bundles.flatMap((bundle)=>{
        return [
            ...bundle.user?.use || [],
            ...bundle.quarto?.use || [],
            ...bundle.framework?.use || [], 
        ];
    }));
    const useStatements = imports.map((use)=>{
        return `@use '${use}';`;
    }).join("\n");
    const frameworkFunctions = bundles.map((bundle)=>bundle.framework?.functions || ""
    );
    const frameworkDefaults = bundles.map((bundle)=>bundle.framework?.defaults || ""
    );
    const frameworkRules = bundles.map((bundle)=>bundle.framework?.rules || ""
    );
    const frameworkMixins = bundles.map((bundle)=>bundle.framework?.mixins || ""
    );
    const quartoFunctions1 = bundles.map((bundle)=>bundle.quarto?.functions || ""
    );
    const quartoDefaults1 = bundles.map((bundle)=>bundle.quarto?.defaults || ""
    );
    const quartoRules1 = bundles.map((bundle)=>bundle.quarto?.rules || ""
    );
    const quartoMixins = bundles.map((bundle)=>bundle.quarto?.mixins || ""
    );
    const userFunctions = bundles.map((bundle)=>bundle.user?.functions || ""
    );
    const userDefaults = bundles.map((bundle)=>bundle.user?.defaults || ""
    );
    const userRules = bundles.map((bundle)=>bundle.user?.rules || ""
    );
    const userMixins = bundles.map((bundle)=>bundle.user?.mixins || ""
    );
    const loadPaths = [];
    bundles.forEach((bundle)=>{
        if (bundle.loadPaths) {
            loadPaths.push(...bundle.loadPaths);
        }
    });
    const scssInput = [
        useStatements,
        ...frameworkFunctions,
        ...quartoFunctions1,
        ...userFunctions,
        ...userDefaults.reverse(),
        ...quartoDefaults1.reverse(),
        ...frameworkDefaults.reverse(),
        ...frameworkMixins,
        ...quartoMixins,
        ...userMixins,
        ...frameworkRules,
        ...quartoRules1,
        ...userRules, 
    ].join("\n\n");
    return await compileWithCache(scssInput, loadPaths, temp, minified, bundles.map((bundle)=>bundle.key
    ).join("|") + "-" + (minified ? "min" : "nomin"));
}
const layoutBoundary = "^\/\\*\\-\\-[ \\t]*scss:(functions|rules|defaults|mixins)[ \\t]*\\-\\-\\*\\/$";
const kLayerBoundaryLine = RegExp(layoutBoundary);
const kLayerBoundaryTest = RegExp(layoutBoundary, "m");
function mergeLayers(...layers) {
    const themeUse = [];
    const themeDefaults = [];
    const themeRules = [];
    const themeFunctions = [];
    const themeMixins = [];
    layers.forEach((theme)=>{
        if (theme.use) {
            themeUse.push(...theme.use);
        }
        if (theme.defaults) {
            themeDefaults.unshift(theme.defaults);
        }
        if (theme.rules) {
            themeRules.push(theme.rules);
        }
        if (theme.functions) {
            themeFunctions.push(theme.functions);
        }
        if (theme.mixins) {
            themeMixins.push(theme.mixins);
        }
    });
    return {
        use: __VIRTUAL_FILE181(themeUse),
        defaults: themeDefaults.join("\n"),
        functions: themeFunctions.join("\n"),
        mixins: themeMixins.join("\n"),
        rules: themeRules.join("\n")
    };
}
function sassLayer(path65) {
    if (Deno.statSync(path65).isFile) {
        return sassLayerFile(path65);
    } else {
        return sassLayerDir(path65, {
            functions: "_functions.scss",
            defaults: "_defaults.scss",
            mixins: "_mixins.scss",
            rules: "_rules.scss"
        });
    }
}
function sassLayerFile(theme) {
    const rawContents = Deno.readTextFileSync(theme);
    if (!kLayerBoundaryTest.test(rawContents)) {
        throw new Error(`The file ${theme} doesn't contain at least one layer boundary (/*-- scss:defaults --*/, /*-- scss:rules --*/, /*-- scss:mixins --*/ or /*-- scss:functions --*/)`);
    }
    const defaults1 = [];
    const rules1 = [];
    const functions = [];
    const mixins = [];
    let accum = defaults1;
    lines(rawContents).forEach((line)=>{
        const scopeMatch = line.match(kLayerBoundaryLine);
        if (scopeMatch) {
            const scope1 = scopeMatch[1];
            switch(scope1){
                case "defaults":
                    accum = defaults1;
                    break;
                case "rules":
                    accum = rules1;
                    break;
                case "functions":
                    accum = functions;
                    break;
                case "mixins":
                    accum = mixins;
                    break;
            }
        } else {
            accum.push(line);
        }
    });
    return {
        defaults: defaults1.join("\n"),
        rules: rules1.join("\n"),
        mixins: mixins.join("\n"),
        functions: functions.join("\n")
    };
}
function sassLayerDir(dir, names) {
    const read = (path66)=>{
        if (path66) {
            path66 = join3(dir, path66);
            if (existsSync(path66)) {
                return Deno.readTextFileSync(path66);
            } else {
                return "";
            }
        } else {
            return "";
        }
    };
    return {
        defaults: read(names.defaults),
        rules: read(names.rules),
        mixins: read(names.mixins),
        functions: read(names.functions)
    };
}
async function compileWithCache(input, loadPaths, temp, compressed, cacheIdentifier) {
    if (cacheIdentifier) {
        const identifierHash = md5Hash(cacheIdentifier);
        const inputHash = md5Hash(input);
        const cacheDir = quartoCacheDir("sass");
        const cacheIdxPath = join3(cacheDir, "index.json");
        const outputFile = `${identifierHash}.css`;
        const outputFilePath = join3(cacheDir, outputFile);
        let cacheIndex = {};
        let writeCache = true;
        if (existsSync(outputFilePath)) {
            cacheIndex = JSON.parse(Deno.readTextFileSync(cacheIdxPath));
            const existingEntry = cacheIndex[identifierHash];
            writeCache = !existingEntry || existingEntry.hash !== inputHash;
        }
        if (writeCache) {
            const cssOutput = await dartCompile(input, temp, loadPaths, compressed);
            if (cssOutput) {
                Deno.writeTextFileSync(outputFilePath, cssOutput || "");
            }
            cacheIndex[identifierHash] = {
                key: cacheIdentifier,
                hash: inputHash
            };
            Deno.writeTextFileSync(cacheIdxPath, JSON.stringify(cacheIndex));
        }
        return outputFilePath;
    } else {
        const outputFilePath = temp.createFile({
            suffix: "css"
        });
        const cssOutput = await dartCompile(input, temp, __VIRTUAL_FILE181(loadPaths), compressed);
        Deno.writeTextFileSync(outputFilePath, cssOutput || "");
        return outputFilePath;
    }
}
const kTabsets = "tabsets";
const kCodeCopy = "code-copy";
const kAnchorSections = "anchor-sections";
const kCitationsHover = "citations-hover";
const kFootnotesHover = "footnotes-hover";
const kMinimal = "minimal";
const kPageLayout = "page-layout";
const kPageLayoutArticle = "article";
const kPageLayoutCustom = "custom";
const kComments = "comments";
const kHypothesis = "hypothesis";
const kUtterances = "utterances";
const kDocumentCss = "document-css";
const kBootstrapDependencyName = "bootstrap";
const clipboardDependency = ()=>{
    const dependency = {
        name: "clipboard"
    };
    dependency.scripts = [];
    dependency.scripts.push({
        name: "clipboard.min.js",
        path: formatResourcePath("html", join3("clipboard", "clipboard.min.js"))
    });
    return dependency;
};
const bootstrapFunctions = ()=>{
    return Deno.readTextFileSync(join3(bootstrapResourceDir(), "_functions.scss"));
};
const bootstrapMixins = ()=>{
    return Deno.readTextFileSync(join3(bootstrapResourceDir(), "_mixins.scss"));
};
const bootstrapVariables = ()=>{
    return Deno.readTextFileSync(join3(bootstrapResourceDir(), "_variables.scss"));
};
const bootstrapRules = ()=>{
    return Deno.readTextFileSync(join3(bootstrapResourceDir(), "bootstrap.scss"));
};
const bootstrapResourceDir = ()=>{
    return formatResourcePath("html", join3("bootstrap", "dist", "scss"));
};
const sassUtilFunctions = (name102)=>{
    const bootstrapDistDir = formatResourcePath("html", join3("bootstrap", "dist"));
    const path67 = join3(bootstrapDistDir, "sass-utils", name102);
    return Deno.readTextFileSync(path67);
};
const quartoRules = ()=>Deno.readTextFileSync(formatResourcePath("html", "_quarto-rules.scss"))
;
const quartoCopyCodeRules = ()=>Deno.readTextFileSync(formatResourcePath("html", "_quarto-rules-copy-code.scss"))
;
const quartoLinkExternalRules = ()=>Deno.readTextFileSync(formatResourcePath("html", "_quarto-rules-link-external.scss"))
;
const quartoTabbyRules = ()=>Deno.readTextFileSync(formatResourcePath("html", "_quarto-rules-tabby.scss"))
;
const quartoFigResponsiveRules = ()=>{
    return [
        ".img-fluid {",
        "  max-width: 100%;",
        "  height: auto;",
        "}", 
    ].join("\n");
};
const quartoGlobalCssVariableRules = ()=>{
    return `
  $font-family-monospace: SFMono-Regular, Menlo, Monaco, Consolas, "Liberation Mono", "Courier New", monospace !default;
  /*! quarto-variables-start */
  :root {
    --quarto-font-monospace: #{inspect($font-family-monospace)};
  }
  /*! quarto-variables-end */
  `;
};
const quartoBootstrapCustomizationLayer = ()=>{
    const path68 = formatResourcePath("html", join3("bootstrap", "_bootstrap-customize.scss"));
    return sassLayer(path68);
};
const quartoBootstrapRules = ()=>Deno.readTextFileSync(formatResourcePath("html", join3("bootstrap", "_bootstrap-rules.scss")))
;
const quartoBootstrapMixins = ()=>Deno.readTextFileSync(formatResourcePath("html", join3("bootstrap", "_bootstrap-mixins.scss")))
;
const quartoBootstrapFunctions = ()=>Deno.readTextFileSync(formatResourcePath("html", join3("bootstrap", "_bootstrap-functions.scss")))
;
const quartoBaseLayer = (format27, codeCopy = false, tabby = false, figResponsive = false)=>{
    const rules2 = [
        quartoRules()
    ];
    if (codeCopy) {
        rules2.push(quartoCopyCodeRules());
    }
    if (tabby) {
        rules2.push(quartoTabbyRules());
    }
    if (figResponsive) {
        rules2.push(quartoFigResponsiveRules());
    }
    if (format27.render[kLinkExternalIcon]) {
        rules2.push(quartoLinkExternalRules());
    }
    return {
        use: [
            "sass:color",
            "sass:map",
            "sass:math"
        ],
        defaults: [
            quartoDefaults(format27), 
        ].join("\n"),
        functions: quartoFunctions(),
        mixins: "",
        rules: rules2.join("\n")
    };
};
const quartoFunctions = ()=>Deno.readTextFileSync(formatResourcePath("html", "_quarto-functions.scss"))
;
const quartoDefaults = (format28)=>{
    const defaults2 = [];
    defaults2.push(outputVariable(sassVariable("code-copy-selector", format28.metadata[kCodeCopy] === undefined || format28.metadata[kCodeCopy] === "hover" ? '"pre.sourceCode:hover > "' : '""')));
    defaults2.push(outputVariable(sassVariable("code-white-space", format28.render[kCodeOverflow] === "wrap" ? "pre-wrap" : "pre")));
    defaults2.push(outputVariable(sassVariable(kTblCapLoc, format28.metadata[kTblCapLoc] || format28.metadata[kCapLoc] || kCapTop)));
    return defaults2.join("\n");
};
function insertFootnotesTitle(doc, footnotesEl, language, level = 2) {
    const heading = doc.createElement("h" + level);
    const title2 = language[kSectionTitleFootnotes];
    if (typeof title2 == "string" && title2 !== "none") {
        heading.innerHTML = title2;
    }
    footnotesEl.insertBefore(heading, footnotesEl.firstChild);
    const hr = footnotesEl.querySelector("hr");
    if (hr) {
        hr.remove();
    }
}
function removeFootnoteBacklinks(footnotesEl) {
    const backlinks = footnotesEl.querySelectorAll(".footnote-back");
    for (const backlink of backlinks){
        backlink.remove();
    }
}
const kWebsite = "website";
const kSiteUrl = "site-url";
const kSitePath = "site-path";
const kSiteTitle = "title";
const kSiteFavicon = "favicon";
const kSiteRepoUrl = "repo-url";
const kSiteRepoBranch = "repo-branch";
const kSiteRepoActions = "repo-actions";
const kSiteReaderMode = "reader-mode";
const kSiteNavbar = "navbar";
const kSiteSidebar = "sidebar";
const kSiteSidebarStyle = "style";
const kSiteSidebarHeader = "header";
const kSiteSidebarFooter = "footer";
const kSitePageNavigation = "page-navigation";
const kPageFooter = "page-footer";
const kMarginHeader = "margin-header";
const kMarginFooter = "margin-footer";
const kBodyHeader = "body-header";
const kBodyFooter = "body-footer";
const kContents = "contents";
const kTwitterCard = "twitter-card";
const kOpenGraph = "open-graph";
const kCardStyle = "card-style";
const kImage = "image";
const kImageWidth = "image-width";
const kImageHeight = "image-height";
const kCreator = "creator";
const kLocale = "locale";
const kSiteName = "site-name";
function websiteConfigBoolean(name103, defaultValue, project) {
    const config = websiteConfig(name103, project);
    if (typeof config === "string") {
        return !!config;
    } else if (typeof config == "boolean") {
        return config;
    } else {
        return defaultValue;
    }
}
function websiteConfigString(name104, project) {
    const config = websiteConfig(name104, project);
    if (typeof config === "string") {
        return config;
    } else {
        return undefined;
    }
}
function websiteConfigMetadata(name105, project) {
    const config = websiteConfig(name105, project);
    if (typeof config === "object" && !Array.isArray(config)) {
        return config;
    } else {
        return undefined;
    }
}
function websiteConfigArray(name106, project) {
    const config = websiteConfig(name106, project);
    if (Array.isArray(config)) {
        return config;
    } else {
        return undefined;
    }
}
function websiteConfig(name107, project) {
    const site = project?.[kWebsite];
    if (site) {
        return site[name107];
    } else {
        return undefined;
    }
}
function websiteTitle(project) {
    return websiteConfigString(kSiteTitle, project);
}
function websiteBaseurl(project) {
    return websiteConfigString(kSiteUrl, project);
}
function websitePath(project) {
    let path69 = websiteConfigString(kSitePath, project);
    if (path69) {
        if (!path69.endsWith("/")) {
            path69 = path69 + "/";
        }
        return path69;
    } else {
        const baseUrl = websiteBaseurl(project);
        if (baseUrl) {
            try {
                const url = new URL(baseUrl);
                let path70 = url.pathname;
                if (!path70.endsWith("/")) {
                    path70 = path70 + "/";
                }
                return path70;
            } catch  {
                return "/";
            }
        } else {
            return "/";
        }
    }
}
function websiteRepoUrl(project) {
    const repoUrl = websiteConfigString(kSiteRepoUrl, project);
    if (repoUrl) {
        if (!repoUrl.endsWith("/")) {
            return repoUrl + "/";
        } else {
            return repoUrl;
        }
    } else {
        return undefined;
    }
}
function websiteRepoBranch(project) {
    return websiteConfigString(kSiteRepoBranch, project) || "main";
}
function websiteMetadataFields() {
    return [
        kWebsite,
        "site"
    ];
}
function isGithubRepoUrl(url) {
    return !!url.match(/^http[s]?:\/\/github\.com/);
}
function websiteConfigActions(key, subkey, project) {
    const book = project?.[subkey];
    if (book) {
        const value = book[key];
        if (typeof value === "string") {
            if (value === "none") {
                return [];
            } else {
                return [
                    value
                ];
            }
        } else if (Array.isArray(value)) {
            return value.map((x)=>String(x)
            );
        } else {
            return [];
        }
    } else {
        return [];
    }
}
function websiteProjectConfig(_projectDir, config, forceHtml) {
    config = cloneDeep1(config);
    const format110 = config[kMetadataFormat];
    if (format110 !== undefined) {
        if (typeof format110 === "string") {
            if (!isHtmlOutput(format110, true) && forceHtml) {
                config[kMetadataFormat] = {
                    html: "default",
                    [format110]: "default"
                };
            }
        } else {
            const formats1 = Object.keys(format110);
            const orderedFormats = {};
            if (forceHtml) {
                const htmlFormatPos = formats1.findIndex((format29)=>isHtmlOutput(format29, true)
                );
                if (htmlFormatPos !== -1) {
                    const htmlFormatName = formats1.splice(htmlFormatPos, 1)[0];
                    orderedFormats[htmlFormatName] = format110[htmlFormatName];
                } else {
                    orderedFormats["html"] = "default";
                }
            }
            for (const formatName of formats1){
                orderedFormats[formatName] = format110[formatName];
            }
            config[kMetadataFormat] = orderedFormats;
        }
    } else {
        config[kMetadataFormat] = "html";
    }
    const ensureArray = (val)=>{
        if (Array.isArray(val)) {
            return val;
        } else if (typeof val === "string") {
            return [
                val
            ];
        }
    };
    const siteMeta = config[kWebsite] || {};
    if (siteMeta[kBodyHeader]) {
        siteMeta[kBodyHeader] = ensureArray(siteMeta[kBodyHeader]);
    }
    if (siteMeta[kBodyFooter]) {
        siteMeta[kBodyFooter] = ensureArray(siteMeta[kBodyFooter]);
    }
    if (siteMeta[kMarginHeader]) {
        siteMeta[kMarginHeader] = ensureArray(siteMeta[kMarginHeader]);
    }
    if (siteMeta[kMarginFooter]) {
        siteMeta[kMarginFooter] = ensureArray(siteMeta[kMarginFooter]);
    }
    config[kWebsite] = siteMeta;
    const sidebarRaw = siteMeta[kSiteSidebar];
    const sidebars = Array.isArray(sidebarRaw) ? sidebarRaw : typeof sidebarRaw == "object" ? [
        sidebarRaw
    ] : undefined;
    sidebars?.forEach((sidebar)=>{
        const headerRaw = sidebar[kSiteSidebarHeader];
        if (headerRaw) {
            sidebar[kSiteSidebarHeader] = ensureArray(sidebar[kSiteSidebarHeader]);
        }
    });
    sidebars?.forEach((sidebar)=>{
        const footerRaw = sidebar[kSiteSidebarFooter];
        if (footerRaw) {
            sidebar[kSiteSidebarFooter] = ensureArray(sidebar[kSiteSidebarFooter]);
        }
    });
    if (websiteConfigMetadata(kComments, config) && config[kComments] === undefined) {
        config[kComments] = websiteConfigMetadata(kComments, config);
    }
    return Promise.resolve(config);
}
function websiteHtmlFormat(project) {
    const projConfig = project.config || {};
    const baseFormat = metadataAsFormat(projConfig);
    const format30 = formatFromMetadata(baseFormat, formatKeys(projConfig)[0]);
    return mergeConfigs(baseFormat, format30);
}
const kGoogleAnalytics = "google-analytics";
const kTrackingId = "tracking-id";
const kStorage = "storage";
const kAnonymizeIp = "anonymize-ip";
const kVersion = "version";
const kCookieConsent = "cookie-consent";
const kCookieConsentType = "type";
const kCookieConsentStyle = "style";
const kCookieConsentPalette = "palette";
const kCookieConsentPolicyUrl = "policy-url";
const kCookiePrefsText = "prefs-text";
function scriptTagWithConsent(consentRequired, consentlevel, contents, src) {
    const srcAttr = src ? ` src="${src}"` : "";
    if (consentRequired) {
        return `
<script type="text/plain" cookie-consent="${consentlevel}"${srcAttr}>
${contents}
</script>`;
    } else {
        return `
<script type="text/javascript"${srcAttr}>
${contents}
</script>`;
    }
}
function websiteAnalyticsScriptFile(project, temp) {
    const siteMeta = project.config?.[kWebsite];
    let gaConfig = undefined;
    if (siteMeta) {
        const siteGa = siteMeta[kGoogleAnalytics];
        if (typeof siteGa === "object") {
            const siteGaMeta = siteGa;
            const trackingId = siteGaMeta[kTrackingId];
            const storage = siteGaMeta[kStorage];
            const anonymizedIp = siteGaMeta[kAnonymizeIp];
            const version7 = siteGaMeta[kVersion];
            gaConfig = googleAnalyticsConfig(project, trackingId, storage, anonymizedIp, version7);
        } else if (siteGa && typeof siteGa === "string") {
            gaConfig = googleAnalyticsConfig(project, siteGa);
        }
    }
    if (gaConfig) {
        const script = analyticsScript(gaConfig);
        if (script) {
            return scriptFile(script, temp);
        } else {
            return undefined;
        }
    } else {
        return undefined;
    }
}
function cookieConsentDependencies(project, temp) {
    const siteMeta = project.config?.[kWebsite];
    if (siteMeta) {
        const title3 = siteMeta[kTitle] || "";
        let configuration = undefined;
        let changePrefsText = undefined;
        const consent = siteMeta[kCookieConsent];
        if (typeof consent === "object") {
            const cookieMeta = consent;
            configuration = cookieConsentConfiguration(title3, cookieMeta[kCookieConsentType], cookieMeta[kCookieConsentStyle], cookieMeta[kCookieConsentPalette], cookieMeta[kCookieConsentPolicyUrl]);
            changePrefsText = cookieMeta[kCookiePrefsText];
        } else if (consent) {
            configuration = cookieConsentConfiguration(title3);
        }
        if (configuration) {
            const consentResourcesDir = join3(projectTypeResourcePath("website"), "cookie-consent");
            const name108 = "cookie-consent.js";
            const path71 = join3(consentResourcesDir, name108);
            const cssName = "cookie-consent.css";
            const cssPath = join3(consentResourcesDir, cssName);
            return {
                scriptFile: scriptFile(cookieConsentScript(configuration), temp),
                dependency: {
                    name: "cookie-consent",
                    scripts: [
                        {
                            name: name108,
                            path: path71
                        }
                    ],
                    stylesheets: [
                        {
                            name: cssName,
                            path: cssPath
                        }
                    ]
                },
                htmlPostProcessor: (doc)=>{
                    const anchorId = "open_preferences_center";
                    const prefsAnchor = doc.getElementById(anchorId);
                    if (!prefsAnchor) {
                        const footer = doc.querySelector("div.nav-footer .nav-footer-center");
                        if (footer) {
                            const anchor = doc.createElement("a");
                            anchor.setAttribute("href", "#");
                            anchor.setAttribute("id", anchorId);
                            anchor.innerHTML = changePrefsText || "Cookie Preferences";
                            const anchorContainer = doc.createElement("div");
                            anchorContainer.setAttribute("class", "cookie-consent-footer");
                            anchorContainer.appendChild(anchor);
                            footer.appendChild(anchorContainer);
                        }
                    }
                    return Promise.resolve([]);
                }
            };
        } else {
            return undefined;
        }
    } else {
        return undefined;
    }
}
function cookieConsentEnabled(project) {
    const siteMeta = project.config?.[kWebsite];
    if (siteMeta) {
        return !!siteMeta[kCookieConsent];
    } else {
        return false;
    }
}
function cookieConsentConfiguration(_siteName, type37, style, palette, policyUrl) {
    return {
        siteName: "",
        type: type37 || "implied",
        style: style || "simple",
        palette: palette || "light",
        policyUrl
    };
}
function googleAnalyticsConfig(project, trackingId, storage, anoymizeIp, version8) {
    return {
        trackingId,
        consent: cookieConsentEnabled(project),
        storage: storage || "cookies",
        anonymizeIp: anoymizeIp === undefined ? true : !!anoymizeIp,
        version: version8 || (trackingId.startsWith("UA-") ? 3 : 4)
    };
}
function analyticsScript(config) {
    if (config.version === 3) {
        return ga3Script(config);
    } else if (config.version === 4) {
        return ga4Script(config);
    } else {
        return undefined;
    }
}
function ga3Script(config) {
    const scripts = [];
    scripts.push(`
(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
  (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
  m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
  })(window,document,'script','https://www.google-analytics.com/analytics.js','ga');`);
    if (config.storage === "none") {
        scripts.push(`ga('create', '${config.trackingId}', { 'storage': 'none' });`);
    } else {
        scripts.push(`ga('create', '${config.trackingId}', 'auto');`);
    }
    scripts.push(`
ga('send', {
  hitType: 'pageview',
  'anonymizeIp': ${config.anonymizeIp},
});`);
    return scriptTagWithConsent(!!config.consent, "tracking", scripts.join("\n"));
}
function ga4Script(config) {
    const scripts = [];
    scripts.push(`
window.dataLayer = window.dataLayer || [];
function gtag(){dataLayer.push(arguments);}
gtag('js', new Date());`);
    if (config.storage === "none") {
        scripts.push(` 
  gtag('consent', 'default', {
    'ad_storage': 'denied',
    'analytics_storage': 'denied'
  });`);
    }
    scripts.push(`gtag('config', '${config.trackingId}', { 'anonymize_ip': ${config.anonymizeIp}});`);
    return [
        `<script async src="https://www.googletagmanager.com/gtag/js?id=${config.trackingId}"></script>`,
        scriptTagWithConsent(!!config.consent, "tracking", scripts.join("\n")), 
    ].join("\n");
}
function cookieConsentScript(config) {
    const consentLevels = config.type === "implied" ? `["strictly-necessary","functionality","tracking","targeting"]` : `["strictly-necessary"]`;
    const privacyJs = config.policyUrl !== undefined ? `,\n"website_privacy_policy_url":"${config.policyUrl}"` : "";
    return `
<script type="text/javascript" charset="UTF-8">
document.addEventListener('DOMContentLoaded', function () {
cookieconsent.run({
  "notice_banner_type":"${config.style}",
  "consent_type":"${config.type}",
  "palette":"${config.palette === "dark" ? "dark" : "light"}",
  "language":"en",
  "page_load_consent_levels":${consentLevels},
  "notice_banner_reject_button_hide":false,
  "preferences_center_close_button_hide":false,
  "website_name":"${config.siteName}"${privacyJs}
  });
});
</script> 
  `;
}
function scriptFile(script, temp) {
    const gaScriptFile = temp.createFile({
        suffix: ".js"
    });
    Deno.writeTextFileSync(gaScriptFile, script);
    return gaScriptFile;
}
function computePageTitle(format31, extras) {
    const meta = extras?.metadata || {};
    const pageTitle = meta[kPageTitle] || format31.metadata[kPageTitle];
    const titlePrefix = extras?.pandoc?.[kTitlePrefix] || format31.metadata[kWebsite]?.[kTitle];
    const title4 = format31.metadata[kTitle];
    if (pageTitle !== undefined) {
        return pageTitle;
    } else if (titlePrefix !== undefined) {
        if (titlePrefix === title4) {
            return title4;
        } else if (title4 !== undefined) {
            return titlePrefix + " - " + title4;
        } else {
            return undefined;
        }
    } else {
        return title4;
    }
}
function inputFileHref(href) {
    const [hrefDir, hrefStem] = dirAndStem(href);
    const htmlHref = "/" + join3(hrefDir, `${hrefStem}.html`);
    return pathWithForwardSlashes(htmlHref);
}
function websiteNavigationConfig(project) {
    let navbar = websiteConfigMetadata(kSiteNavbar, project.config);
    if (typeof navbar !== "object") {
        navbar = undefined;
    }
    const sidebar = websiteConfig(kSiteSidebar, project.config);
    const sidebars = Array.isArray(sidebar) ? sidebar : typeof sidebar == "object" ? [
        sidebar
    ] : undefined;
    if (sidebars && sidebars.length > 1) {
        const sidebarOptions = __VIRTUAL_FILE107(sidebars[0]);
        delete sidebarOptions.id;
        delete sidebarOptions.title;
        sidebarOptions.contents.splice(0, sidebarOptions.contents.length);
        for(let i80 = 1; i80 < sidebars.length; i80++){
            sidebars[i80] = {
                ...sidebarOptions,
                ...sidebars[i80]
            };
        }
    }
    const pageNavigation = websiteConfigBoolean(kSitePageNavigation, false, project.config);
    const footerValue = (value)=>{
        if (typeof value === "string") {
            return value;
        } else if (Array.isArray(value)) {
            return value;
        } else {
            return undefined;
        }
    };
    const footer = {};
    const footerConfig = websiteConfig(kPageFooter, project.config);
    if (typeof footerConfig === "string") {
        footer.center = footerConfig;
    } else if (!Array.isArray(footerConfig)) {
        footer.left = footerValue(footerConfig?.left);
        footer.center = footerValue(footerConfig?.center);
        footer.right = footerValue(footerConfig?.right);
    }
    if (footer.center === undefined && cookieConsentEnabled(project)) {
        footer.center = " ";
    }
    const pageMargin = {};
    const headerVal = websiteConfigArray(kMarginHeader, project.config);
    if (headerVal) {
        pageMargin.header = headerVal;
    }
    const footerVal = websiteConfigArray(kMarginFooter, project.config);
    if (footerVal) {
        pageMargin.footer = footerVal;
    }
    const bodyDecorators = {};
    const bodyHeaderVal = websiteConfigArray(kBodyHeader, project.config);
    if (bodyHeaderVal) {
        bodyDecorators.header = bodyHeaderVal;
    }
    const bodyFooterVal = websiteConfigArray(kBodyFooter, project.config);
    if (bodyFooterVal) {
        bodyDecorators.footer = bodyFooterVal;
    }
    return {
        navbar,
        sidebars,
        pageNavigation,
        footer,
        pageMargin,
        bodyDecorators
    };
}
function flattenItems(sidebarItems, includeItem) {
    const items2 = [];
    const flatten = (sidebarItem)=>{
        if (includeItem(sidebarItem)) {
            items2.push(sidebarItem);
        }
        if (sidebarItem.contents) {
            items2.push(...flattenItems(sidebarItem.contents, includeItem));
        }
    };
    sidebarItems.forEach(flatten);
    return items2;
}
const kDependencies = "dependencies";
const kSassBundles = "sass-bundles";
const kHtmlPostprocessors = "html-postprocessors";
const kTemplatePatches = "template-patches";
const kBodyEnvelope = "body-envelope";
const kTextHighlightingMode = "text-highlighting-mode";
const kQuartoCssVariables = "css-variables";
const kMarkdownAfterBody = "render-after-body";
const kTextHtml = "text/html";
const kTextMarkdown = "text/markdown";
const kTextLatex = "text/latex";
const kTextPlain = "text/plain";
const kImagePng = "image/png";
const kImageJpeg = "image/jpeg";
const kImageSvg = "image/svg+xml";
const kApplicationPdf = "application/pdf";
const kApplicationJavascript = "application/javascript";
const kApplicationJupyterWidgetState = "application/vnd.jupyter.widget-state+json";
const kApplicationJupyterWidgetView = "application/vnd.jupyter.widget-view+json";
const kRestructuredText = "text/restructuredtext";
const kApplicationRtf = "application/rtf";
function extensionForMimeImageType(mimeType) {
    switch(mimeType){
        case kImagePng:
            return "png";
        case kImageJpeg:
            return "jpeg";
        case kImageSvg:
            return "svg";
        case kApplicationPdf:
            return "pdf";
        default:
            return "bin";
    }
}
function contentType(path72) {
    return MEDIA_TYPES[extname2(path72.toLowerCase())];
}
function isPdfContent(path73) {
    return path73 && contentType(path73) === kApplicationPdf;
}
function isHtmlContent(path74) {
    return path74 && contentType(path74) === kTextHtml;
}
const MEDIA_TYPES = {
    ".md": kTextMarkdown,
    ".html": kTextHtml,
    ".htm": kTextHtml,
    ".json": "application/json",
    ".map": "application/json",
    ".txt": kTextPlain,
    ".ts": "text/typescript",
    ".tsx": "text/tsx",
    ".js": "application/javascript",
    ".jsx": "text/jsx",
    ".gz": "application/gzip",
    ".css": "text/css",
    ".wasm": "application/wasm",
    ".mjs": "application/javascript",
    ".svg": kImageSvg,
    ".png": kImagePng,
    ".jpg": kImageJpeg,
    ".jpeg": kImageJpeg,
    ".pdf": kApplicationPdf,
    ".gif": "image/gif",
    ".wav": "audio/wav",
    ".mp4": "video/mp4",
    ".woff": "application/font-woff",
    ".ttf": "application/font-ttf",
    ".eot": "application/vnd.ms-fontobject",
    ".otf": "application/font-otf"
};
function isFileRef(href) {
    return !/^\w+:/.test(href) && !href.startsWith("#");
}
function httpFileRequestHandler(options) {
    async function serveFile(filePath, req) {
        let fileContents;
        if (options.onFile) {
            fileContents = await options.onFile(filePath, req);
        }
        if (!fileContents) {
            fileContents = Deno.readFileSync(filePath);
        }
        return httpContentResponse(fileContents, contentType(filePath));
    }
    function serveFallback(req, e, fsPath) {
        const encoder = new TextEncoder();
        if (e instanceof URIError) {
            return Promise.resolve(new Response(encoder.encode("BadRequest"), {
                status: 400
            }));
        } else if (e instanceof Deno.errors.NotFound) {
            const url = normalizeURL(req.url);
            const handle404 = options.on404 ? options.on404(url, req) : {
                print: true,
                body: encoder.encode("Not Found")
            };
            handle404.print = handle404.print && !!options.printUrls && (!fsPath || basename2(fsPath) !== "favicon.ico" && extname2(fsPath) !== ".map");
            if (handle404.print) {
                printUrl(url, false);
            }
            return Promise.resolve(new Response(handle404.body, {
                status: 404,
                headers: {
                    "Content-Type": kTextHtml
                }
            }));
        } else {
            error(`500 (Internal Error): ${e.message}`, {
                bold: true
            });
            return Promise.resolve(new Response(encoder.encode("Internal server error"), {
                status: 500
            }));
        }
    }
    return async (req)=>{
        if (options.onRequest) {
            const response = await options.onRequest(req);
            if (response) {
                return response;
            }
        }
        let response;
        let fsPath;
        try {
            const baseDir = pathWithForwardSlashes(options.baseDir);
            const normalizedUrl = normalizeURL(req.url);
            fsPath = pathWithForwardSlashes(baseDir + normalizedUrl);
            if (fsPath.indexOf(baseDir) !== 0) {
                fsPath = baseDir;
            }
            const fileInfo = existsSync(fsPath) ? Deno.statSync(fsPath) : undefined;
            if (fileInfo && fileInfo.isDirectory) {
                fsPath = join3(fsPath, options.defaultFile || "index.html");
            }
            if (fileInfo?.isDirectory && !normalizedUrl.endsWith("/")) {
                response = serveRedirect(normalizedUrl + "/");
            } else {
                response = await serveFile(fsPath, req);
                if (options.printUrls === "all") {
                    printUrl(normalizedUrl);
                }
            }
        } catch (e) {
            response = await serveFallback(req, e, fsPath);
        }
        return response;
    };
}
function httpContentResponse(content, contentType1) {
    if (typeof content === "string") {
        content = new TextEncoder().encode(content);
    }
    const headers = new Headers();
    headers.set("Content-Length", content.byteLength.toString());
    if (contentType1) {
        headers.set("Content-Type", contentType1);
    }
    headers.set("Cache-Control", "no-store, max-age=0");
    return new Response(content, {
        status: 200,
        headers
    });
}
function normalizeURL(url) {
    let normalizedUrl = url;
    try {
        normalizedUrl = decodeURI(normalizedUrl);
    } catch (e) {
        if (!(e instanceof URIError)) {
            throw e;
        }
    }
    try {
        const absoluteURI = new URL(normalizedUrl);
        normalizedUrl = decodeURI(absoluteURI.pathname);
    } catch (e1) {
        if (!(e1 instanceof TypeError)) {
            throw e1;
        }
    }
    if (normalizedUrl[0] !== "/") {
        throw new URIError("The request URI is malformed.");
    }
    normalizedUrl = posix.normalize(normalizedUrl);
    const startOfParams = normalizedUrl.indexOf("?");
    return startOfParams > -1 ? normalizedUrl.slice(0, startOfParams) : normalizedUrl;
}
function maybeDisplaySocketError(e) {
    if (!(e instanceof Deno.errors.BrokenPipe) && !(e instanceof Deno.errors.ConnectionAborted) && !(e instanceof Deno.errors.ConnectionReset) && !(e instanceof DOMException)) {
        logError(e);
    }
}
function serveRedirect(url) {
    const headers = new Headers();
    headers.set("Location", url);
    return new Response(null, {
        status: 301,
        headers
    });
}
function printUrl(url, found = true) {
    const format32 = !found ? red : undefined;
    const urlDisplay = url + (found ? "" : " (404: Not Found)");
    if (isHtmlContent(url) || url.endsWith("/") || extname2(url) === "") {
        info(`GET: ${urlDisplay}`, {
            bold: false,
            format: format32 || green
        });
    } else if (!found) {
        info(urlDisplay, {
            dim: found,
            format: format32,
            indent: 2
        });
    }
}
const kMarkdownBlockSeparator = "\n\n<!-- -->\n\n";
const kDefaultHighlightStyle = "arrow";
const kCssUrlRegex = /url\((?!['"]?(?:data|https?):)(['"])?([^'"]*?)\1\)/g;
const kCssImportRegex = /@import\s(?!['"](?:data|https?):)(['"])([^'"]*?)\1/g;
function cssFileResourceReferences(files) {
    return files.reduce((allRefs, file)=>{
        if (extname2(file).toLowerCase() === ".css") {
            if (existsSync(file)) {
                file = Deno.realPathSync(file);
                const css = Deno.readTextFileSync(file);
                const cssRefs = cssFileRefs(css).map((ref2)=>join3(dirname2(file), ref2)
                );
                allRefs.push(...cssRefs);
                allRefs.push(...cssFileResourceReferences(cssRefs));
            }
        }
        return allRefs;
    }, []);
}
function cssFileRefs(css) {
    return cssImports(css).concat(cssResources(css)).filter(isFileRef);
}
function cssResources(css) {
    return matchCss(css, kCssUrlRegex);
}
function cssImports(css) {
    return matchCss(css, kCssImportRegex);
}
function matchCss(css, regex) {
    const matches = [];
    regex.lastIndex = 0;
    let match = regex.exec(css);
    while(match != null){
        matches.push(match[2]);
        match = regex.exec(css);
    }
    regex.lastIndex = 0;
    return matches;
}
function asCssFont(value) {
    if (!value) {
        return undefined;
    } else {
        const fontFamily = String(value).split(",").map((font)=>{
            font = font.trim();
            if (font.includes(" ")) {
                font = `"${font}"`;
            }
            return font;
        }).filter((font)=>font.length > 0
        ).join(", ");
        return `${fontFamily}`;
    }
}
function asCssNumber(value) {
    if (typeof value === "number") {
        return String(value);
    } else if (!value) {
        return undefined;
    } else {
        const str69 = String(value);
        const match = str69.match(/(^[0-9]*)/);
        if (match) {
            return match[1];
        } else {
            return undefined;
        }
    }
}
function asCssSize(value) {
    if (typeof value === "number") {
        if (value === 0) {
            return "0";
        } else {
            return value + "px";
        }
    } else if (!value) {
        return undefined;
    } else {
        const str70 = String(value);
        if (str70 !== "0" && !str70.match(/\w$/)) {
            return str70 + "px";
        } else {
            return str70;
        }
    }
}
function asCssColor(value) {
    if (typeof value === "string") {
        return value;
    }
}
const kBootstrapColors = [
    "primary",
    "secondary",
    "success",
    "info",
    "warning",
    "danger",
    "light",
    "dark", 
];
const kBootstrapPaletteRegex = RegExp(`gray\-[1-9]00`);
function asBootstrapColor(value) {
    if (typeof value === "string") {
        if (kBootstrapColors.includes(value) || value.match(kBootstrapPaletteRegex)) {
            return `$${value}`;
        } else {
            return asCssColor(value);
        }
    }
}
function renderEjs(file, data87, removeEmptyLines = true) {
    const template1 = compileTemplate(file, removeEmptyLines);
    return lines(template1(data87).trimLeft()).filter((line)=>!removeEmptyLines || line.trim().length > 0
    ).join("\n") + "\n";
}
const compiledTemplates = new Map();
function compileTemplate(file, removeEmptyLines) {
    if (!compiledTemplates.has(file)) {
        const template2 = `<% const partial = (file, data) => print(include(file, data)); %>
      ${Deno.readTextFileSync(file)}`;
        compiledTemplates.set(file, __VIRTUAL_FILE176(template2, {
            imports: {
                include: (includeFile, includeData)=>{
                    return renderEjs(join3(dirname2(file), includeFile), includeData, removeEmptyLines);
                }
            }
        }));
    }
    return compiledTemplates.get(file);
}
const base64abc = [
    "A",
    "B",
    "C",
    "D",
    "E",
    "F",
    "G",
    "H",
    "I",
    "J",
    "K",
    "L",
    "M",
    "N",
    "O",
    "P",
    "Q",
    "R",
    "S",
    "T",
    "U",
    "V",
    "W",
    "X",
    "Y",
    "Z",
    "a",
    "b",
    "c",
    "d",
    "e",
    "f",
    "g",
    "h",
    "i",
    "j",
    "k",
    "l",
    "m",
    "n",
    "o",
    "p",
    "q",
    "r",
    "s",
    "t",
    "u",
    "v",
    "w",
    "x",
    "y",
    "z",
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
    "+",
    "/", 
];
function encode(data88) {
    const uint8 = typeof data88 === "string" ? new TextEncoder().encode(data88) : data88 instanceof Uint8Array ? data88 : new Uint8Array(data88);
    let result = "", i81;
    const l = uint8.length;
    for(i81 = 2; i81 < l; i81 += 3){
        result += base64abc[uint8[i81 - 2] >> 2];
        result += base64abc[(uint8[i81 - 2] & 3) << 4 | uint8[i81 - 1] >> 4];
        result += base64abc[(uint8[i81 - 1] & 15) << 2 | uint8[i81] >> 6];
        result += base64abc[uint8[i81] & 63];
    }
    if (i81 === l + 1) {
        result += base64abc[uint8[i81 - 2] >> 2];
        result += base64abc[(uint8[i81 - 2] & 3) << 4];
        result += "==";
    }
    if (i81 === l) {
        result += base64abc[uint8[i81 - 2] >> 2];
        result += base64abc[(uint8[i81 - 2] & 3) << 4 | uint8[i81 - 1] >> 4];
        result += base64abc[(uint8[i81 - 1] & 15) << 2];
        result += "=";
    }
    return result;
}
function decode(b64) {
    const binString = atob(b64);
    const size = binString.length;
    const bytes = new Uint8Array(size);
    for(let i82 = 0; i82 < size; i82++){
        bytes[i82] = binString.charCodeAt(i82);
    }
    return bytes;
}
function mappedSource(source, substrs) {
    const params = [];
    for (const { range  } of substrs){
        params.push(range);
    }
    return mappedString(source, params);
}
async function partitionCellOptionsMapped(language, source, _validate = false) {
    const commentChars = langCommentChars(language);
    const optionPrefix = optionCommentPrefix(commentChars[0]);
    const optionSuffix = commentChars[1] || "";
    const optionsSource = [];
    const yamlLines = [];
    let endOfYaml = 0;
    for (const line of rangedLines(source.value, true)){
        if (line.substring.startsWith(optionPrefix)) {
            if (!optionSuffix || line.substring.trimRight().endsWith(optionSuffix)) {
                let yamlOption = line.substring.substring(optionPrefix.length);
                if (optionSuffix) {
                    yamlOption = yamlOption.trimRight();
                    yamlOption = yamlOption.substring(0, yamlOption.length - optionSuffix.length);
                }
                endOfYaml = line.range.start + optionPrefix.length + yamlOption.length - optionSuffix.length;
                const rangedYamlOption = {
                    substring: yamlOption,
                    range: {
                        start: line.range.start + optionPrefix.length,
                        end: endOfYaml
                    }
                };
                yamlLines.push(rangedYamlOption);
                optionsSource.push(line);
                continue;
            }
        }
        break;
    }
    const mappedYaml = yamlLines.length ? mappedSource(source, yamlLines) : undefined;
    return {
        yaml: mappedYaml,
        optionsSource,
        source: mappedString(source, [
            {
                start: endOfYaml,
                end: source.value.length
            }
        ]),
        sourceStartLine: yamlLines.length
    };
}
function langCommentChars(lang) {
    const chars = kLangCommentChars[lang] || "#";
    if (!Array.isArray(chars)) {
        return [
            chars
        ];
    } else {
        return chars;
    }
}
function optionCommentPrefix(comment) {
    return comment + "| ";
}
const kLangCommentChars = {
    r: "#",
    python: "#",
    julia: "#",
    scala: "//",
    matlab: "%",
    csharp: "//",
    fsharp: "//",
    c: [
        "/*",
        "*/"
    ],
    css: [
        "/*",
        "*/"
    ],
    sas: [
        "*",
        ";"
    ],
    powershell: "#",
    bash: "#",
    sql: "--",
    mysql: "--",
    psql: "--",
    lua: "--",
    cpp: "//",
    cc: "//",
    stan: "#",
    octave: "#",
    fortran: "!",
    fortran95: "!",
    awk: "#",
    gawk: "#",
    stata: "*",
    java: "//",
    groovy: "//",
    sed: "#",
    perl: "#",
    ruby: "#",
    tikz: "%",
    js: "//",
    d3: "//",
    node: "//",
    sass: "//",
    coffee: "#",
    go: "//",
    asy: "//",
    haskell: "--",
    dot: "//",
    ojs: "//"
};
const commonCellOptionsSchema = objectSchema({
    properties: {
        [kCellLabel]: StringSchema,
        [kCellFigCap]: anyOfSchema(StringSchema, arraySchema(StringSchema)),
        [kCellFigSubCap]: anyOfSchema(StringSchema, arraySchema(StringSchema), BooleanSchema),
        [kCellLstLabel]: StringSchema,
        [kCellLstCap]: StringSchema,
        [kCellClasses]: StringSchema,
        [kCellPanel]: StringSchema,
        [kCodeFold]: oneOfSchema(StringSchema, BooleanSchema),
        [kCodeSummary]: StringSchema,
        [kCodeOverflow]: StringSchema,
        [kTblColwidths]: anyOfSchema(BooleanSchema, enumSchema("auto"), arraySchema(numericSchema)),
        [kCellFigScap]: StringSchema,
        [kCellFigLink]: StringSchema,
        [kCellFigAlign]: StringSchema,
        [kCellFigEnv]: StringSchema,
        [kCellFigPos]: StringSchema,
        [kCellFigAlt]: StringSchema,
        [kEval]: anyOfSchema(BooleanSchema, NullSchema),
        [kError]: BooleanSchema,
        [kEcho]: anyOfSchema(BooleanSchema, enumSchema("fenced")),
        [kOutput]: anyOfSchema(BooleanSchema, enumSchema("all", "asis")),
        [kInclude]: BooleanSchema,
        [kLayoutNcol]: numericSchema({
            "type": "integer",
            "minimum": 1
        }),
        [kLayoutNrow]: numericSchema({
            "type": "integer",
            "minimum": 1
        })
    }
});
const ojsCellOptionsSchema = idSchema(objectSchema({
    baseSchema: commonCellOptionsSchema,
    properties: {
        classes: arraySchema(StringSchema)
    },
    description: "be an OJS cell options object"
}), "ojs");
const jupyterCellOptionsSchema = idSchema(objectSchema({
    baseSchema: commonCellOptionsSchema,
    properties: {
        [kCellMdIndent]: StringSchema,
        [kWarning]: BooleanSchema
    },
    description: "be a Jupyter cell options object"
}), "python");
const rCellOptionsSchema = idSchema(commonCellOptionsSchema, "r");
function getLanguageOptionsSchema(normalized) {
    if (normalized) {
        return Promise.resolve({
            "ojs": normalizeSchema(ojsCellOptionsSchema),
            "python": normalizeSchema(jupyterCellOptionsSchema),
            "r": normalizeSchema(rCellOptionsSchema)
        });
    } else {
        return Promise.resolve({
            "ojs": ojsCellOptionsSchema,
            "python": jupyterCellOptionsSchema,
            "r": rCellOptionsSchema
        });
    }
}
function partitionCellOptions(language, source) {
    const commentChars = langCommentChars(language);
    const optionPrefix = optionCommentPrefix(commentChars[0]);
    const optionSuffix = commentChars[1] || "";
    const optionsSource = [];
    const yamlLines = [];
    for (const line of source){
        if (line.startsWith(optionPrefix)) {
            if (!optionSuffix || line.trimRight().endsWith(optionSuffix)) {
                let yamlOption = line.substring(optionPrefix.length);
                if (optionSuffix) {
                    yamlOption = yamlOption.trimRight();
                    yamlOption = yamlOption.substring(0, yamlOption.length - optionSuffix.length);
                }
                yamlLines.push(yamlOption);
                optionsSource.push(line);
                continue;
            }
        }
        break;
    }
    let yaml = yamlLines.length > 0 ? readYamlFromString(yamlLines.join("\n")) : undefined;
    if (yaml !== undefined && (typeof yaml !== "object" || Array.isArray(yaml))) {
        warnOnce("Invalid YAML option format in cell:\n" + yamlLines.join("\n"));
        yaml = undefined;
    }
    return {
        yaml: yaml,
        optionsSource,
        source: source.slice(yamlLines.length),
        sourceStartLine: yamlLines.length
    };
}
async function parseAndValidateCellOptions(mappedYaml, language, validate1 = false) {
    if (mappedYaml.value.trim().length === 0) {
        return undefined;
    }
    const languageOptionsSchema = await getLanguageOptionsSchema();
    const schema = languageOptionsSchema[language];
    if (schema === undefined || !validate1) {
        return readYamlFromString(mappedYaml.value);
    }
    return readAndValidateYamlFromMappedString(mappedYaml, schema, `Validation of YAML ${language} chunk options failed`);
}
async function partitionCellOptionsMapped1(language, outerSource, validate2 = false) {
    const { yaml: mappedYaml , optionsSource , source , sourceStartLine ,  } = await partitionCellOptionsMapped(language, outerSource);
    const yaml = await parseAndValidateCellOptions(mappedYaml ?? asMappedString(""), language, validate2);
    return {
        yaml: yaml,
        optionsSource,
        source,
        sourceStartLine
    };
}
function shortUuid() {
    return generate().replaceAll("-", "").slice(0, 8);
}
class PngImage {
    content = [];
    width = -1;
    height = -1;
    dpiX = -1;
    dpiY = -1;
    bitDepth = -1;
    colourType = -1;
    compressionMethod = -1;
    filterMethod = -1;
    interlaceMethod = -1;
    constructor(bytes, sizeOnly = true){
        const magicNumberBytes = bytes.slice(0, 8);
        const magicNumber = bytesToString(magicNumberBytes);
        if (magicNumber !== "13780787113102610") {
            throw new Error("Not a png file");
        }
        let pos = 8;
        while(pos < bytes.length){
            const chunk = new PngChunk(bytes.slice(pos));
            switch(chunk.type){
                case "IHDR":
                    this.parseIHDRChunk(chunk, sizeOnly);
                    break;
                case "pHYs":
                    this.parsePHYSChunk(chunk);
                    break;
                case "IDAT":
                    return;
            }
            pos += chunk.totalLength;
        }
    }
    parseIHDRChunk(chunk, sizeOnly) {
        this.width = bytesToUint32(chunk.data, 0, 4);
        this.height = bytesToUint32(chunk.data, 4, 4);
        if (sizeOnly) {
            return;
        }
        this.bitDepth = chunk.data.slice(8, 9)[0];
        if (this.bitDepth !== 8) throw new Error("bitDepth not supported");
        this.colourType = chunk.data.slice(9, 10)[0];
        if (this.colourType !== 6) throw new Error("colourType not supported");
        this.compressionMethod = chunk.data.slice(10, 11)[0];
        if (this.compressionMethod !== 0) {
            throw new Error("compressionMethod not supported");
        }
        this.filterMethod = chunk.data.slice(11, 12)[0];
        if (this.filterMethod !== 0) throw new Error("filterMethod not supported");
        this.interlaceMethod = chunk.data.slice(12, 13)[0];
        if (this.interlaceMethod !== 0) {
            throw new Error("Interlacing not supported");
        }
    }
    parsePHYSChunk(chunk) {
        const meter = chunk.data[8];
        if (meter === 1) {
            const x = bytesToUint32(chunk.data, 0, 4);
            const y = bytesToUint32(chunk.data, 4, 4);
            const kMetersPerInch = 0.0254;
            this.dpiX = Math.round(x * kMetersPerInch);
            this.dpiY = Math.round(y * kMetersPerInch);
        }
    }
}
class PngChunk {
    totalLength;
    dataLength;
    type;
    data;
    crc;
    constructor(bytes){
        this.dataLength = this.getLength(bytes);
        this.type = this.getType(bytes);
        this.data = this.getData(bytes);
        this.crc = this.getCRC(bytes);
        this.totalLength = this.dataLength + 12;
    }
    getLength(bytes) {
        const lengthBytes = bytes.slice(0, 4);
        return bytesToUint32(lengthBytes);
    }
    getType(bytes) {
        const typeByte = bytes.slice(4, 8);
        return new TextDecoder("ascii").decode(typeByte);
    }
    getData(bytes) {
        return bytes.slice(8, 8 + this.dataLength);
    }
    getCRC(bytes) {
        return bytes.slice(8 + this.dataLength, 8 + this.dataLength + 4);
    }
}
const MAX_SIGNIFICANT_SIZE = 127;
function bytesToUint32(byteArray, start = 0, count) {
    if (count === undefined) {
        count = byteArray.length;
    }
    if (count > 4) {
        throw new Error("Length cannot be greater than 4");
    }
    let position = start;
    let value = 0;
    if (count === 4) {
        let sigValue = byteArray[position];
        if (sigValue > 127) {
            value += MAX_SIGNIFICANT_SIZE << 24;
            sigValue -= MAX_SIGNIFICANT_SIZE;
        }
        value += sigValue << 24;
        position++;
    }
    for(let i83 = position; i83 < start + count; i83++){
        value += byteArray[i83] << 8 * (count - (i83 - start) - 1);
    }
    return value;
}
function bytesToString(byteArray, start = 0, count) {
    if (count === undefined) {
        count = byteArray.length;
    }
    let result = "";
    for(let i84 = start; i84 < start + count; i84++){
        const __byte = byteArray[i84];
        if (__byte === 0) {
            result += "00";
        } else if (__byte < 10) {
            result += `0${__byte.toString()}`;
        } else {
            result += __byte.toString();
        }
    }
    return result;
}
function hideCell(cell, options) {
    return shouldHide(cell, options, kInclude);
}
function hideCode(cell, options) {
    return shouldHide(cell, options, kEcho);
}
function hideOutput(cell, options) {
    return shouldHide(cell, options, kOutput);
}
function hideWarnings(cell, options) {
    if (options.execute[kOutput] === false && cell.options[kOutput] !== false) {
        return cell.options[kWarning] || false;
    } else {
        return shouldHide(cell, options, kWarning);
    }
}
function includeCell(cell, options) {
    return shouldInclude(cell, options, kInclude);
}
function includeCode(cell, options) {
    return shouldInclude(cell, options, kEcho);
}
function echoFenced(cell, options) {
    const fenced = cell.options.echo === "fenced" || cell.options.echo === undefined && options.execute.echo === "fenced";
    return fenced;
}
function includeOutput(cell, options) {
    return shouldInclude(cell, options, kOutput);
}
function includeWarnings(cell, options) {
    if (options.execute[kOutput] === false && cell.options[kOutput] !== false) {
        return cell.options[kWarning] || false;
    } else {
        return shouldInclude(cell, options, kWarning);
    }
}
function shouldHide(cell, options, context) {
    if (cell.options[context] !== undefined) {
        return !cell.options[context] && options.keepHidden;
    } else {
        return !options.execute[context] && options.keepHidden;
    }
}
function shouldInclude(cell, options, context) {
    if (cell.options[context] !== undefined) {
        return !!(cell.options[context] || options.keepHidden);
    } else {
        return !!(options.execute[context] || options.keepHidden);
    }
}
function pandocAutoIdentifier(text, asciify) {
    if (asciify) {
        text = pandocAsciify(text);
    }
    return text.replace(/[!"#$%&')*+,\/:;<=>?@\[\\\]^`{|}~]/g, "").replace(/\s/g, "-").toLowerCase().replace(/^[^A-Za-z]+/, "");
}
function pandocAsciify(text) {
    const chars = [];
    const len14 = text.length;
    let newch;
    for(let i85 = 0; i85 < len14; i85++){
        newch = "";
        const ch = text.charCodeAt(i85);
        switch(ch){
            case 192:
            case 193:
            case 194:
            case 195:
            case 196:
            case 197:
            case 256:
            case 258:
            case 260:
            case 461:
            case 512:
            case 514:
            case 550:
            case 7680:
            case 7840:
            case 7842:
                newch = "A";
                break;
            case 7682:
            case 7684:
            case 7686:
                newch = "B";
                break;
            case 199:
            case 262:
            case 264:
            case 266:
            case 268:
                newch = "C";
                break;
            case 270:
            case 7690:
            case 7692:
            case 7694:
            case 7696:
            case 7698:
                newch = "D";
                break;
            case 200:
            case 201:
            case 203:
            case 274:
            case 276:
            case 278:
            case 280:
            case 282:
            case 516:
            case 518:
            case 552:
            case 7704:
            case 7706:
            case 7864:
            case 7866:
            case 7868:
                newch = "E";
                break;
            case 7710:
                newch = "F";
                break;
            case 284:
            case 286:
            case 288:
            case 290:
            case 486:
            case 500:
            case 7712:
                newch = "G";
                break;
            case 292:
            case 542:
            case 7714:
            case 7716:
            case 7718:
            case 7720:
            case 7722:
                newch = "H";
                break;
            case 204:
            case 205:
            case 206:
            case 207:
            case 296:
            case 298:
            case 300:
            case 302:
            case 304:
            case 463:
            case 520:
            case 522:
            case 7724:
            case 7880:
            case 7882:
                newch = "I";
                break;
            case 308:
                newch = "J";
                break;
            case 310:
            case 488:
            case 7728:
            case 7730:
            case 7732:
            case 8490:
                newch = "K";
                break;
            case 313:
            case 315:
            case 317:
            case 7734:
            case 7738:
            case 7740:
                newch = "L";
                break;
            case 7742:
            case 7744:
            case 7746:
                newch = "M";
                break;
            case 209:
            case 323:
            case 325:
            case 327:
            case 504:
            case 7748:
            case 7750:
            case 7752:
            case 7754:
                newch = "N";
                break;
            case 210:
            case 211:
            case 212:
            case 213:
            case 214:
            case 332:
            case 334:
            case 336:
            case 416:
            case 465:
            case 490:
            case 524:
            case 526:
            case 558:
            case 7884:
            case 7886:
                newch = "O";
                break;
            case 7764:
            case 7766:
                newch = "P";
                break;
            case 340:
            case 342:
            case 344:
            case 528:
            case 530:
            case 7768:
            case 7770:
            case 7774:
                newch = "R";
                break;
            case 346:
            case 348:
            case 350:
            case 352:
            case 536:
            case 7776:
            case 7778:
                newch = "S";
                break;
            case 354:
            case 356:
            case 538:
            case 7786:
            case 7788:
            case 7790:
            case 7792:
                newch = "T";
                break;
            case 217:
            case 218:
            case 219:
            case 220:
            case 360:
            case 362:
            case 364:
            case 366:
            case 368:
            case 370:
            case 431:
            case 467:
            case 532:
            case 534:
            case 7794:
            case 7796:
            case 7798:
            case 7908:
            case 7910:
                newch = "U";
                break;
            case 7804:
            case 7806:
                newch = "V";
                break;
            case 372:
            case 7808:
            case 7810:
            case 7812:
            case 7814:
            case 7816:
                newch = "W";
                break;
            case 7818:
            case 7820:
                newch = "X";
                break;
            case 221:
            case 374:
            case 376:
            case 562:
            case 7822:
            case 7922:
            case 7924:
            case 7926:
            case 7928:
                newch = "Y";
                break;
            case 377:
            case 379:
            case 381:
            case 7824:
            case 7826:
            case 7828:
                newch = "Z";
                break;
            case 224:
            case 225:
            case 226:
            case 227:
            case 228:
            case 229:
            case 257:
            case 259:
            case 261:
            case 462:
            case 513:
            case 515:
            case 551:
            case 553:
            case 7681:
            case 7841:
            case 7843:
                newch = "a";
                break;
            case 7683:
            case 7685:
            case 7687:
                newch = "b";
                break;
            case 231:
            case 263:
            case 265:
            case 267:
            case 269:
                newch = "c";
                break;
            case 271:
            case 7691:
            case 7693:
            case 7695:
            case 7697:
            case 7699:
                newch = "d";
                break;
            case 232:
            case 233:
            case 234:
            case 235:
            case 275:
            case 277:
            case 279:
            case 281:
            case 283:
            case 517:
            case 519:
            case 7705:
            case 7707:
            case 7865:
            case 7867:
            case 7869:
                newch = "e";
                break;
            case 7711:
                newch = "f";
                break;
            case 285:
            case 287:
            case 289:
            case 291:
            case 487:
            case 501:
            case 7713:
                newch = "g";
                break;
            case 293:
            case 543:
            case 7715:
            case 7717:
            case 7719:
            case 7721:
            case 7723:
            case 7830:
                newch = "h";
                break;
            case 236:
            case 237:
            case 238:
            case 239:
            case 297:
            case 299:
            case 301:
            case 303:
            case 305:
            case 464:
            case 521:
            case 523:
            case 7725:
            case 7881:
            case 7883:
                newch = "i";
                break;
            case 309:
            case 496:
                newch = "j";
                break;
            case 311:
            case 489:
            case 7729:
            case 7731:
            case 7733:
                newch = "k";
                break;
            case 314:
            case 316:
            case 318:
            case 7735:
            case 7739:
            case 7741:
                newch = "l";
                break;
            case 7743:
            case 7745:
            case 7747:
                newch = "m";
                break;
            case 241:
            case 324:
            case 326:
            case 328:
            case 505:
            case 7749:
            case 7751:
            case 7753:
            case 7755:
                newch = "n";
                break;
            case 242:
            case 243:
            case 244:
            case 245:
            case 246:
            case 333:
            case 335:
            case 337:
            case 417:
            case 432:
            case 466:
            case 491:
            case 525:
            case 527:
            case 559:
            case 7885:
            case 7887:
                newch = "o";
                break;
            case 7765:
            case 7767:
                newch = "p";
                break;
            case 341:
            case 343:
            case 345:
            case 529:
            case 531:
            case 7769:
            case 7771:
            case 7775:
                newch = "r";
                break;
            case 347:
            case 349:
            case 351:
            case 353:
            case 537:
            case 7777:
            case 7779:
                newch = "s";
                break;
            case 355:
            case 357:
            case 539:
            case 7787:
            case 7789:
            case 7791:
            case 7793:
            case 7831:
                newch = "t";
                break;
            case 249:
            case 250:
            case 251:
            case 252:
            case 361:
            case 363:
            case 365:
            case 367:
            case 369:
            case 371:
            case 468:
            case 533:
            case 535:
            case 7795:
            case 7797:
            case 7799:
            case 7909:
            case 7911:
                newch = "u";
                break;
            case 7805:
            case 7807:
                newch = "v";
                break;
            case 373:
            case 7809:
            case 7811:
            case 7813:
            case 7815:
            case 7817:
            case 7832:
                newch = "w";
                break;
            case 7819:
            case 7821:
                newch = "x";
                break;
            case 253:
            case 255:
            case 375:
            case 563:
            case 7833:
            case 7923:
            case 7925:
            case 7927:
            case 7929:
                newch = "y";
                break;
            case 378:
            case 380:
            case 382:
            case 7825:
            case 7827:
            case 7829:
                newch = "z";
                break;
            case 894:
                newch = ";";
                break;
            case 8175:
                newch = "`";
                break;
            case 8800:
                newch = "=";
                break;
            case 8814:
                newch = "<";
                break;
            case 8815:
                newch = ">";
                break;
        }
        if (newch) {
            chars.push(newch.charCodeAt(0));
        } else if (ch < 128) {
            chars.push(ch);
        }
    }
    return String.fromCharCode(...chars);
}
function asHtmlId(text) {
    return pandocAutoIdentifier(text, false);
}
function getDecodedAttribute(element, attrib) {
    const value = element.getAttribute(attrib);
    if (value) {
        return decodeURI(value);
    } else {
        return value;
    }
}
function findParent(el, match) {
    let targetEl = el;
    do {
        if (targetEl.parentElement) {
            if (match(targetEl.parentElement)) {
                return targetEl.parentElement;
            } else {
                targetEl = targetEl.parentElement;
            }
        } else {
            return undefined;
        }
    }while (targetEl !== null && targetEl.nodeType === 1)
    return undefined;
}
const kHtmlResourceTags = {
    "a": [
        "href"
    ],
    "img": [
        "src",
        "data-src"
    ],
    "link": [
        "href"
    ],
    "script": [
        "src"
    ],
    "embed": [
        "src"
    ],
    "iframe": [
        "src"
    ],
    "section": [
        "data-background-image",
        "data-background-video"
    ]
};
function discoverResourceRefs(doc) {
    const refs = [];
    Object.keys(kHtmlResourceTags).forEach((tag)=>{
        for (const attrib of kHtmlResourceTags[tag]){
            refs.push(...resolveResourceTag(doc, tag, attrib));
        }
    });
    const styles = doc.querySelectorAll("style");
    for(let i86 = 0; i86 < styles.length; i86++){
        const style = styles[i86];
        if (style.innerHTML) {
            refs.push(...cssFileRefs(style.innerHTML));
        }
    }
    return Promise.resolve(refs);
}
function processFileResourceRefs(doc, tag, attrib, onRef) {
    const tags = doc.querySelectorAll(tag);
    for(let i87 = 0; i87 < tags.length; i87++){
        const tag = tags[i87];
        const href = getDecodedAttribute(tag, attrib);
        if (href !== null && href.length > 0 && isFileRef(href)) {
            onRef(tag, href);
        }
    }
}
function resolveResourceTag(doc, tag, attrib) {
    const refs = [];
    processFileResourceRefs(doc, tag, attrib, (_tag, ref3)=>refs.push(ref3)
    );
    return refs;
}
function isDisplayData(output) {
    return [
        "display_data",
        "execute_result"
    ].includes(output.output_type);
}
function isCaptionableData(output) {
    if (isDisplayData(output)) {
        const displayData = output;
        return !displayData.noCaption;
    } else {
        return false;
    }
}
function displayDataMimeType(output, options) {
    const displayPriority = [
        kTextMarkdown,
        kImageSvg,
        kImagePng,
        kImageJpeg, 
    ];
    if (options.toHtml) {
        const htmlFormats = [
            kApplicationJupyterWidgetState,
            kApplicationJupyterWidgetView,
            kApplicationJavascript,
            kTextHtml, 
        ];
        if (options.toMarkdown) {
            displayPriority.unshift(...htmlFormats);
        } else {
            displayPriority.push(...htmlFormats);
        }
        displayPriority.unshift(kApplicationJupyterWidgetState, kApplicationJupyterWidgetView, kApplicationJavascript, kTextHtml);
    } else if (options.toLatex) {
        displayPriority.push(kTextLatex, kApplicationPdf);
    } else if (options.toMarkdown) {
        displayPriority.push(kTextHtml);
    }
    displayPriority.push(kTextPlain);
    const availDisplay = Object.keys(output.data);
    for (const display of displayPriority){
        if (availDisplay.includes(display)) {
            return display;
        }
    }
    return null;
}
function displayDataIsImage(mimeType) {
    return [
        kImagePng,
        kImageJpeg,
        kImageSvg,
        kApplicationPdf
    ].includes(mimeType);
}
function displayDataIsTextPlain(mimeType) {
    return [
        kTextPlain
    ].includes(mimeType);
}
function displayDataIsMarkdown(mimeType) {
    return [
        kTextMarkdown
    ].includes(mimeType);
}
function displayDataIsLatex(mimeType) {
    return [
        kTextLatex
    ].includes(mimeType);
}
function displayDataIsHtml(mimeType) {
    return [
        kTextHtml
    ].includes(mimeType);
}
function displayDataIsJson(mimeType) {
    return [
        kApplicationJupyterWidgetState,
        kApplicationJupyterWidgetView
    ].includes(mimeType);
}
function displayDataIsJavascript(mimeType) {
    return [
        kApplicationJavascript
    ].includes(mimeType);
}
function cellLabel(cell) {
    const label = asHtmlId(cell.options[kCellLabel] || cell.metadata[kCellName] || "");
    if (label && !label.startsWith("#")) {
        return "#" + label;
    } else {
        return label;
    }
}
function cellLabelValidator() {
    const cellLabels = new Set();
    return function(cell) {
        const label = cellLabel(cell);
        if (label) {
            if (cellLabels.has(label)) {
                throw new Error("Cell label names must be unique (found duplicate '" + label + "')");
            } else {
                cellLabels.add(label);
            }
        }
    };
}
function shouldLabelCellContainer(cell, outputs, options) {
    if (!outputs) {
        return true;
    }
    if (!includeOutput(cell, options)) {
        return true;
    }
    const displayDataOutputs = outputs.filter(isDisplayData);
    if (displayDataOutputs.length === 0) {
        return true;
    }
    if (displayDataOutputs.length > 1 && !Array.isArray(cell.options[kCellFigCap])) {
        return true;
    }
    if (hasTableLabel(cell.options)) {
        return true;
    }
    return false;
}
function hasTableLabel(options) {
    return typeof options[kCellLabel] === "string" && options[kCellLabel]?.startsWith("tbl-");
}
function shouldLabelOutputContainer(output, cellOptions, options) {
    if (isDisplayData(output)) {
        if (hasTableLabel(cellOptions)) {
            return false;
        }
        if (!isCaptionableData(output)) {
            return false;
        }
        const mimeType = displayDataMimeType(output, options);
        if (mimeType) {
            if (displayDataIsImage(mimeType)) {
                return false;
            }
        }
        return true;
    } else {
        return false;
    }
}
function resolveCaptions(cell) {
    if (Array.isArray(cell.options[kCellFigCap])) {
        const figCap = cell.options[kCellFigCap];
        if (cell.outputs && cell.outputs.filter(isCaptionableData).length > 0) {
            return {
                cellCaption: undefined,
                outputCaptions: figCap
            };
        } else {
            return {
                cellCaption: undefined,
                outputCaptions: []
            };
        }
    } else if (cell.options[kCellFigCap]) {
        if (cell.options[kCellFigSubCap] !== undefined) {
            let subCap = cell.options[kCellFigSubCap];
            if (subCap === true) {
                subCap = [
                    ""
                ];
            }
            if (!Array.isArray(subCap)) {
                subCap = [
                    String(subCap)
                ];
            }
            return {
                cellCaption: cell.options[kCellFigCap],
                outputCaptions: subCap
            };
        } else {
            return {
                cellCaption: undefined,
                outputCaptions: [
                    cell.options[kCellFigCap]
                ]
            };
        }
    } else {
        return {
            cellCaption: undefined,
            outputCaptions: []
        };
    }
}
function extractJupyterWidgetDependencies(nb) {
    const jsWidgets = haveOutputType(nb, [
        kApplicationJavascript,
        kTextHtml
    ]);
    const jupyterWidgets = haveOutputType(nb, [
        kApplicationJupyterWidgetView
    ]);
    const htmlLibraries = [];
    nb.cells.forEach((cell)=>{
        if (cell.cell_type === "code") {
            cell.outputs = cell.outputs?.filter((output)=>{
                if (isDisplayData(output)) {
                    const displayOutput = output;
                    const html = displayOutput.data[kTextHtml];
                    const htmlText = Array.isArray(html) ? html.join("") : html;
                    if (html && isWidgetIncludeHtml(htmlText)) {
                        htmlLibraries.push(htmlText);
                        return false;
                    }
                }
                return true;
            });
        }
    });
    return {
        jsWidgets,
        jupyterWidgets,
        htmlLibraries,
        widgetsState: nb.metadata.widgets?.[kApplicationJupyterWidgetState]
    };
}
function includesForJupyterWidgetDependencies(dependencies1, tempDir1) {
    let haveJavascriptWidgets = false;
    let haveJupyterWidgets = false;
    const htmlLibraries = [];
    let widgetsState;
    for (const dependency of dependencies1){
        haveJavascriptWidgets = haveJavascriptWidgets || dependency.jsWidgets;
        haveJupyterWidgets = haveJupyterWidgets || dependency.jupyterWidgets;
        for (const htmlLib of dependency.htmlLibraries){
            if (!htmlLibraries.includes(htmlLib)) {
                htmlLibraries.push(htmlLib);
            }
        }
        if (dependency.widgetsState) {
            if (!widgetsState) {
                widgetsState = dependency.widgetsState;
            } else {
                widgetsState = mergeConfigs(widgetsState, dependency.widgetsState);
            }
        }
    }
    const head = [];
    if (haveJavascriptWidgets || haveJupyterWidgets) {
        head.push('<script src="https://cdnjs.cloudflare.com/ajax/libs/require.js/2.3.6/require.min.js" integrity="sha512-c3Nl8+7g4LMSTdrm621y7kf9v3SDPnhxLNhcjFJbKECVnmZHTdo+IRO05sNLTH/D3vA6u1X32ehoLC7WFVdheg==" crossorigin="anonymous"></script>');
        head.push('<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.5.1/jquery.min.js" integrity="sha512-bLT0Qm9VnAYZDflyKcBaQ2gg0hSYNQrJ8RilYldYQ1FxQYoCLtUjuuRuZo+fjqhx/qtq/1itJ0C2ejDxltZVFg==" crossorigin="anonymous"></script>');
        head.push("<script type=\"application/javascript\">define('jquery', [],function() {return window.jQuery;})</script>");
    }
    head.push(...htmlLibraries);
    if (haveJupyterWidgets) {
        head.push('<script src="https://unpkg.com/@jupyter-widgets/html-manager@*/dist/embed-amd.js" crossorigin="anonymous"></script>');
    }
    const afterBody = [];
    if (haveJupyterWidgets && widgetsState) {
        afterBody.push(`<script type=${kApplicationJupyterWidgetState}>`);
        afterBody.push(JSON.stringify(widgetsState));
        afterBody.push("</script>");
    }
    const widgetTempFile = (lines3)=>{
        const tempFile = Deno.makeTempFileSync({
            dir: tempDir1,
            prefix: "jupyter-widgets-",
            suffix: ".html"
        });
        Deno.writeTextFileSync(tempFile, lines3.join("\n") + "\n");
        return tempFile;
    };
    const result = {
        inHeader: "",
        afterBody: ""
    };
    if (head.length > 0) {
        result.inHeader = widgetTempFile(head);
    }
    if (afterBody.length > 0) {
        result.afterBody = widgetTempFile(afterBody);
    }
    return result;
}
function haveOutputType(nb, mimeTypes) {
    return nb.cells.some((cell)=>{
        if (cell.cell_type === "code" && cell.outputs) {
            return cell.outputs.some((output)=>{
                if (isDisplayData(output)) {
                    const outputTypes = Object.keys(output.data);
                    return outputTypes.some((type38)=>mimeTypes.includes(type38)
                    );
                } else {
                    return false;
                }
            });
        } else {
            return false;
        }
    });
}
function isWidgetIncludeHtml(html) {
    return isPlotlyLibrary(html);
}
function isPlotlyLibrary(html) {
    return /^\s*<script type="text\/javascript">/.test(html) && (/require\.undef\(["']plotly["']\)/.test(html) || /define\('plotly'/.test(html));
}
function removeAndPreserveHtml(nb) {
    const htmlPreserve = {};
    nb.cells.forEach((cell)=>{
        if (cell.cell_type === "code") {
            cell.outputs?.forEach((output)=>{
                if (isDisplayData(output)) {
                    const displayOutput = output;
                    const html = displayOutput.data[kTextHtml];
                    const htmlText = Array.isArray(html) ? html.join("") : html;
                    if (html && isPreservedHtml(htmlText)) {
                        const key = "preserve" + generate().replaceAll("-", "");
                        htmlPreserve[key] = htmlText;
                        displayOutput.data[kTextMarkdown] = [
                            key
                        ];
                        displayOutput.noCaption = true;
                        delete displayOutput.data[kTextHtml];
                    }
                }
            });
        }
    });
    if (Object.keys(htmlPreserve).length > 0) {
        return htmlPreserve;
    } else {
        return undefined;
    }
}
function restorePreservedHtml(html, preserve) {
    if (preserve) {
        Object.keys(preserve).forEach((key)=>{
            const keyLoc = html.indexOf(key);
            html = html.slice(0, keyLoc) + preserve[key] + html.slice(keyLoc + key.length);
        });
    }
    return html;
}
function isPreservedHtml(_html) {
    return false;
}
function isWindows1() {
    return Deno.build.os === "windows";
}
function isMac() {
    return Deno.build.os === "darwin";
}
function isRStudio() {
    return !!Deno.env.get("RSTUDIO");
}
function isRStudioServer() {
    return isRStudio() && Deno.env.get("RSTUDIO_PROGRAM_MODE") === "server";
}
function isJupyterHubServer() {
    return jupyterHubUser() !== undefined;
}
function jupyterHubHttpReferrer() {
    return Deno.env.get("JUPYTERHUB_HTTP_REFERER");
}
function jupyterHubUser() {
    return Deno.env.get("JUPYTERHUB_USER");
}
function isInteractiveTerminal() {
    return Deno.isatty(Deno.stderr.rid);
}
function isInteractiveSession() {
    return isRStudio() || isInteractiveTerminal();
}
let cachedJupyterCaps;
async function jupyterCapabilities() {
    if (!cachedJupyterCaps) {
        if (isWindows1() && pyPython()) {
            cachedJupyterCaps = await getPyLauncherJupyterCapabilities();
        }
        if (!cachedJupyterCaps) {
            cachedJupyterCaps = await getJupyterCapabilities([
                "python"
            ]);
            if (!cachedJupyterCaps?.conda) {
                const caps = isWindows1() ? await getPyLauncherJupyterCapabilities() : await getJupyterCapabilities([
                    "python3"
                ]);
                if (caps) {
                    cachedJupyterCaps = caps;
                }
            }
        }
    }
    return cachedJupyterCaps;
}
async function jupyterCapabilitiesNoConda() {
    if (isWindows1()) {
        return await getPyLauncherJupyterCapabilities();
    } else {
        const caps = await getJupyterCapabilities([
            "python3"
        ]);
        if (caps) {
            if (caps?.conda) {
                return await getJupyterCapabilities([
                    "/usr/local/bin/python3"
                ]) || await getJupyterCapabilities([
                    "/usr/bin/python3"
                ]);
            } else {
                return caps;
            }
        } else {
            return undefined;
        }
    }
}
function isEnvDir(dir) {
    return existsSync(join3(dir, "pyvenv.cfg")) || existsSync(join3(dir, "conda-meta"));
}
function pyPython() {
    return Deno.env.get("PY_PYTHON");
}
function getPyLauncherJupyterCapabilities() {
    return getJupyterCapabilities([
        "py"
    ], true);
}
async function getJupyterCapabilities(cmd, pyLauncher = false) {
    try {
        const result = await execProcess({
            cmd: [
                ...cmd,
                resourcePath("capabilities/jupyter.py"), 
            ],
            stdout: "piped",
            stderr: "piped"
        });
        if (result.success && result.stdout) {
            const caps = readYamlFromString(result.stdout);
            if (caps.versionMajor >= 3) {
                caps.pyLauncher = pyLauncher;
                return caps;
            } else {
                return undefined;
            }
        } else {
            return undefined;
        }
    } catch  {
        return undefined;
    }
}
async function pythonExec(binaryOnly = false) {
    const caps = await jupyterCapabilities();
    if (caps?.pyLauncher) {
        return [
            "py"
        ];
    } else if (isWindows1()) {
        return [
            binaryOnly ? "python" : caps?.executable || "python"
        ];
    } else {
        return [
            binaryOnly ? "python3" : caps?.executable || "python3"
        ];
    }
}
async function jupyterExec() {
    return [
        ...await pythonExec(),
        "-m",
        "jupyter", 
    ];
}
function isJupyterKernelspec(x) {
    if (x && typeof x === "object") {
        return typeof x.name === "string" && typeof x.language === "string" && typeof x.display_name === "string";
    } else {
        return false;
    }
}
async function jupyterKernelspec(name109) {
    const kernelspecs = await jupyterKernelspecs();
    return kernelspecs.get(name109);
}
async function jupyterKernelspecs() {
    try {
        const result = await execProcess({
            cmd: [
                ...await jupyterExec(),
                "--paths",
                "--json"
            ],
            stdout: "piped",
            stderr: "piped"
        });
        if (result.success) {
            const kernelmap = new Map();
            const dataPaths = JSON.parse(result.stdout).data;
            for (const path75 of dataPaths){
                if (!existsSync(path75)) {
                    continue;
                }
                const kernels = join3(path75, "kernels");
                if (!existsSync(kernels)) {
                    continue;
                }
                for (const walk3 of walkSync(kernels, {
                    maxDepth: 1
                })){
                    if (walk3.path === kernels || !walk3.isDirectory) {
                        continue;
                    }
                    const kernelConfig = join3(walk3.path, "kernel.json");
                    if (existsSync(kernelConfig)) {
                        const config = JSON.parse(Deno.readTextFileSync(kernelConfig));
                        const name110 = basename2(walk3.path);
                        kernelmap.set(name110, {
                            name: name110,
                            language: config.language,
                            display_name: config.display_name
                        });
                    }
                }
            }
            if (kernelmap.size > 0) {
                return kernelmap;
            } else {
                return kDefaultKernelspecs;
            }
        } else {
            return kDefaultKernelspecs;
        }
    } catch (e) {
        debug("Error reading kernelspecs: " + e.message);
        return kDefaultKernelspecs;
    }
}
const kDefaultKernelspecs = new Map();
kDefaultKernelspecs.set("python3", {
    "display_name": "Python 3",
    "language": "python",
    "name": "python3"
});
function inputFilesDir(input) {
    const [_, stem] = dirAndStem(input);
    return stem + "_files";
}
function figuresDir(pandocTo) {
    if (pandocTo === "html4") {
        pandocTo = "html";
    }
    pandocTo = (pandocTo || "html").replace(/[\+\-].*$/, "");
    return "figure-" + pandocTo;
}
const kJupyterNotebookExtensions = [
    ".ipynb", 
];
function isJupyterNotebook(file) {
    return kJupyterNotebookExtensions.includes(extname2(file).toLowerCase());
}
const kJupyterCellInternalOptionKeys = [
    kEval,
    kEcho,
    kWarning,
    kOutput,
    kInclude,
    kCellLabel,
    kCellClasses,
    kCellPanel,
    kCellColumn,
    kCellFigCap,
    kCellFigSubCap,
    kCellFigScap,
    kFigCapLoc,
    kTblCapLoc,
    kCapLoc,
    kCellFigColumn,
    kCellTblColumn,
    kCellFigLink,
    kCellFigAlign,
    kCellFigAlt,
    kCellFigEnv,
    kCellFigPos,
    kCellLstLabel,
    kCellLstCap,
    kCellOutWidth,
    kCellOutHeight,
    kCellMdIndent,
    kCodeFold,
    kCodeLineNumbers,
    kCodeSummary,
    kCodeOverflow, 
];
const kJupyterCellOptionKeys = kJupyterCellInternalOptionKeys.concat([
    kLayoutAlign,
    kLayoutVAlign,
    kLayoutNcol,
    kLayoutNrow,
    kLayout,
    kTblColwidths, 
]);
const kJupyterCellStandardMetadataKeys = [
    kCellCollapsed,
    kCellAutoscroll,
    kCellDeletable,
    kCellFormat,
    kCellName, 
];
const kJupyterCellThirdPartyMetadataKeys = [
    kCellId,
    kCellColab,
    kCellColabType,
    kCellColbOutputId,
    kCellLinesToNext, 
];
async function quartoMdToJupyter(input, includeIds) {
    const [kernelspec, metadata8] = await jupyterKernelspecFromFile(input);
    const nb = {
        cells: [],
        metadata: {
            kernelspec,
            ...metadata8
        },
        nbformat: 4,
        nbformat_minor: includeIds ? 5 : 4
    };
    const yamlRegEx = /^---\s*$/;
    const startCodeCellRegEx = new RegExp("^(\\s*)```+\\s*\\{" + kernelspec.language.toLowerCase() + "( *[ ,].*)?\\}\\s*$");
    const startCodeRegEx = /^(\s*)```/;
    const endCodeRegEx = (indent = "")=>{
        return new RegExp("^" + indent + "```\\s*$");
    };
    const inputContent = Deno.readTextFileSync(input);
    let codeIndent = "";
    const lineBuffer = [];
    const flushLineBuffer = (cell_type, frontMatter)=>{
        if (lineBuffer.length) {
            if (lineBuffer[0] === "") {
                lineBuffer.splice(0, 1);
            }
            if (lineBuffer[lineBuffer.length - 1] === "") {
                lineBuffer.splice(lineBuffer.length - 1, 1);
            }
            if (cell_type !== "code") {
                codeIndent = "";
            }
            const cell = {
                cell_type,
                metadata: codeIndent.length > 0 ? {
                    [kCellMdIndent]: codeIndent
                } : {},
                source: lineBuffer.map((line, index)=>{
                    if (codeIndent.length > 0) {
                        line = line.replace(codeIndent, "");
                    }
                    return line + (index < lineBuffer.length - 1 ? "\n" : "");
                })
            };
            if (includeIds) {
                cell.id = shortUuid();
            }
            if (cell_type === "raw" && frontMatter) {
                const yaml = readYamlFromMarkdown(cell.source.join(""));
                if (yaml.jupyter) {
                    delete yaml.jupyter;
                    if (Object.keys(yaml).length > 0) {
                        const yamlFrontMatter = mdTrimEmptyLines(lines(stringify(yaml, {
                            indent: 2,
                            sortKeys: false,
                            skipInvalid: true
                        })));
                        cell.source = [
                            "---\n",
                            ...yamlFrontMatter.map((line)=>line + "\n"
                            ),
                            "---", 
                        ];
                    } else {
                        cell.source = [];
                    }
                }
            } else if (cell_type === "code") {
                const { yaml , source  } = partitionCellOptions(kernelspec.language.toLowerCase(), cell.source);
                if (yaml) {
                    if (includeIds && yaml[kCellLabel] && !yaml[kCellId]) {
                        yaml[kCellId] = jupyterAutoIdentifier(String(yaml[kCellLabel]));
                    }
                    const yamlKeys = Object.keys(yaml);
                    yamlKeys.forEach((key)=>{
                        if (key === kCellId) {
                            if (includeIds) {
                                cell.id = String(yaml[key]);
                            }
                            delete yaml[key];
                        } else {
                            if (!kJupyterCellOptionKeys.includes(key)) {
                                cell.metadata[key] = yaml[key];
                                delete yaml[key];
                            }
                        }
                    });
                    if (Object.keys(yaml).length < yamlKeys.length) {
                        const yamlOutput = jupyterCellOptionsAsComment(kernelspec.language.toLowerCase(), yaml);
                        cell.source = yamlOutput.concat(source);
                    }
                }
                cell.execution_count = null;
                cell.outputs = [];
            }
            cell.source = mdTrimEmptyLines(cell.source);
            if (cell.source.length > 0) {
                nb.cells.push(cell);
            }
            lineBuffer.splice(0, lineBuffer.length);
        }
    };
    let parsedFrontMatter = false, inYaml = false, inCodeCell = false, inCode = false;
    for (const line1 of lines(inputContent)){
        if (yamlRegEx.test(line1) && !inCodeCell && !inCode) {
            if (inYaml) {
                lineBuffer.push(line1);
                flushLineBuffer("raw", !parsedFrontMatter);
                parsedFrontMatter = true;
                inYaml = false;
            } else {
                flushLineBuffer("markdown");
                lineBuffer.push(line1);
                inYaml = true;
            }
        } else if (startCodeCellRegEx.test(line1)) {
            flushLineBuffer("markdown");
            inCodeCell = true;
            codeIndent = line1.match(startCodeCellRegEx)[1];
        } else if (endCodeRegEx(codeIndent).test(line1)) {
            if (inCodeCell) {
                inCodeCell = false;
                flushLineBuffer("code");
                codeIndent = "";
            } else {
                inCode = !inCode;
                codeIndent = "";
                lineBuffer.push(line1);
            }
        } else if (startCodeRegEx.test(line1)) {
            codeIndent = line1.match(startCodeRegEx)[1];
            inCode = true;
            lineBuffer.push(line1);
        } else {
            lineBuffer.push(line1);
        }
    }
    flushLineBuffer("markdown");
    return nb;
}
async function jupyterKernelspecFromFile(file) {
    const yaml = await readYamlFromMarkdownFile(file);
    const yamlJupyter = yaml.jupyter;
    if (!yamlJupyter) {
        const languages = languagesInMarkdownFile(file);
        languages.add("python");
        const kernelspecs = await jupyterKernelspecs();
        for (const language of languages){
            for (const kernelspec of kernelspecs.values()){
                if (kernelspec.language.toLowerCase() === language) {
                    return [
                        kernelspec,
                        {}
                    ];
                }
            }
        }
    }
    if (typeof yamlJupyter === "string") {
        const kernel = yamlJupyter;
        const kernelspec = await jupyterKernelspec(kernel);
        if (kernelspec) {
            return [
                kernelspec,
                {}
            ];
        } else {
            return Promise.reject(new Error("Jupyter kernel '" + kernel + "' not found."));
        }
    } else if (typeof yamlJupyter === "object") {
        const jupyter = {
            ...yamlJupyter
        };
        if (isJupyterKernelspec(jupyter.kernelspec)) {
            const kernelspec = jupyter.kernelspec;
            delete jupyter.kernelspec;
            return [
                kernelspec,
                jupyter
            ];
        } else if (typeof jupyter.kernel === "string") {
            const kernelspec = await jupyterKernelspec(jupyter.kernel);
            if (kernelspec) {
                delete jupyter.kernel;
                return [
                    kernelspec,
                    jupyter
                ];
            } else {
                return Promise.reject(new Error("Jupyter kernel '" + jupyter.kernel + "' not found."));
            }
        } else {
            return Promise.reject(new Error("Invalid Jupyter kernelspec (must include name, language, & display_name)"));
        }
    } else {
        return Promise.reject(new Error("Invalid jupyter YAML metadata found in file (must be string or object)"));
    }
}
function jupyterFromFile(input) {
    const nbContents = Deno.readTextFileSync(input);
    const nbJSON = JSON.parse(nbContents);
    const nb = nbJSON;
    if (!nb.metadata.kernelspec.language) {
        nb.metadata.kernelspec.language = nbJSON.metadata.language_info?.name;
    }
    if (!nb.metadata.kernelspec.language) {
        throw new Error("No langage set for Jupyter notebook " + input);
    }
    if (!nb.cells) {
        throw new Error("No cells available in Jupyter notebook " + input);
    }
    return nb;
}
function languagesInMarkdownFile(file) {
    return languagesInMarkdown(Deno.readTextFileSync(file));
}
function languagesInMarkdown(markdown) {
    const languages = new Set();
    const kChunkRegex = /^[\t >]*```+\s*\{([a-zA-Z0-9_]+)( *[ ,].*)?\}\s*$/gm;
    kChunkRegex.lastIndex = 0;
    let match = kChunkRegex.exec(markdown);
    while(match){
        const language = match[1].toLowerCase();
        if (!languages.has(language)) {
            languages.add(language);
        }
        match = kChunkRegex.exec(markdown);
    }
    kChunkRegex.lastIndex = 0;
    return languages;
}
function jupyterAutoIdentifier(label) {
    label = pandocAsciify(label);
    label = label.replace(/\s/g, "-").replace(/[^a-zA-Z0-9-_]/g, "").replace(/^[^A-Za-z]+/, "");
    if (label.length > 0) {
        return label.slice(0, 64);
    } else {
        return shortUuid();
    }
}
function jupyterAssets(input, to) {
    input = Deno.realPathSync(input);
    const files_dir = join3(dirname2(input), inputFilesDir(input));
    const figures_dir = join3(files_dir, figuresDir(to));
    ensureDirSync(figures_dir);
    let supporting_dir = files_dir;
    for (const walk4 of walkSync(join3(files_dir), {
        maxDepth: 1
    })){
        if (walk4.path !== files_dir && walk4.path !== figures_dir) {
            supporting_dir = figures_dir;
            break;
        }
    }
    const base_dir = dirname2(input);
    return {
        base_dir,
        files_dir: relative2(base_dir, files_dir),
        figures_dir: relative2(base_dir, figures_dir),
        supporting_dir: relative2(base_dir, supporting_dir)
    };
}
function jupyterToMarkdown(nb, options) {
    const isHtml = options.toHtml && !options.toIpynb;
    const dependencies2 = isHtml ? extractJupyterWidgetDependencies(nb) : undefined;
    const htmlPreserve = isHtml ? removeAndPreserveHtml(nb) : undefined;
    const md = [];
    const validateCellLabel = cellLabelValidator();
    let codeCellIndex = 0;
    for(let i88 = 0; i88 < nb.cells.length; i88++){
        const cell = jupyterCellWithOptions(nb.metadata.kernelspec.language.toLowerCase(), nb.cells[i88]);
        validateCellLabel(cell);
        const slideType = options.toPresentation ? cell.metadata[kCellSlideshow]?.[kCellSlideshowSlideType] : undefined;
        if (slideType) {
            if (slideType === "skip") {
                continue;
            } else if (slideType == "slide" || slideType === "subslide") {
                md.push("\n---\n\n");
            } else if (slideType == "fragment") {
                md.push("\n. . .\n\n");
            } else if (slideType == "notes") {
                md.push("\n:::::::::: notes\n\n");
            }
        }
        switch(cell.cell_type){
            case "markdown":
                md.push(...mdFromContentCell(cell));
                break;
            case "raw":
                md.push(...mdFromRawCell(cell));
                break;
            case "code":
                md.push(...mdFromCodeCell(cell, ++codeCellIndex, options));
                break;
            default:
                throw new Error("Unexpected cell type " + cell.cell_type);
        }
        if (slideType === "notes") {
            md.push("\n::::::::::\n");
        }
        md.push("\n");
    }
    if (options.toIpynb) {
        md.push("---\n");
        const jupyterMetadata = {
            jupyter: {
                ...nb.metadata
            }
        };
        const yamlText = stringify(jupyterMetadata, {
            indent: 2,
            sortKeys: false,
            skipInvalid: true
        });
        md.push(yamlText);
        md.push("---\n");
    }
    return {
        markdown: md.join(""),
        dependencies: dependencies2,
        htmlPreserve
    };
}
function jupyterCellWithOptions(language, cell) {
    const { yaml , optionsSource , source  } = partitionCellOptions(language, cell.source);
    const metadataOptions = kJupyterCellOptionKeys.reduce((options, key)=>{
        if (cell.metadata[key]) {
            options[key] = cell.metadata[key];
        }
        return options;
    }, {});
    const options1 = {
        ...metadataOptions,
        ...yaml
    };
    [
        kLayout,
        kTblColwidths
    ].forEach((option)=>{
        if (options1[option] && typeof options1[option] !== "string") {
            options1[option] = JSON.stringify(options1[option]);
        }
    });
    return {
        ...cell,
        source,
        optionsSource,
        options: options1
    };
}
function jupyterCellOptionsAsComment(language, options, stringifyOptions) {
    if (Object.keys(options).length > 0) {
        const cellYaml = stringify(options, {
            indent: 2,
            sortKeys: false,
            skipInvalid: true,
            ...stringifyOptions
        });
        const commentChars = langCommentChars1(language);
        const yamlOutput = mdTrimEmptyLines(lines(cellYaml)).map((line)=>{
            line = optionCommentPrefix1(commentChars[0]) + line + optionCommentSuffix(commentChars[1]);
            return line + "\n";
        });
        return yamlOutput;
    } else {
        return [];
    }
}
function mdFromContentCell(cell) {
    return mdEnsureTrailingNewline(cell.source);
}
function mdFromRawCell(cell) {
    const mimeType = cell.metadata?.[kCellRawMimeType];
    if (mimeType) {
        switch(mimeType){
            case kTextHtml:
                return mdHtmlOutput(cell.source);
            case kTextLatex:
                return mdLatexOutput(cell.source);
            case kRestructuredText:
                return mdFormatOutput("rst", cell.source);
            case kApplicationRtf:
                return mdFormatOutput("rtf", cell.source);
            case kApplicationJavascript:
                return mdScriptOutput(mimeType, cell.source);
        }
    }
    return mdFromContentCell(cell);
}
function mdEnsureTrailingNewline(source) {
    if (source.length > 0 && !source[source.length - 1].endsWith("\n")) {
        return source.slice(0, source.length - 1).concat([
            source[source.length - 1] + "\n"
        ]);
    } else {
        return source;
    }
}
function optionCommentPrefix1(comment) {
    return comment + "| ";
}
function optionCommentSuffix(comment) {
    if (comment) {
        return " " + comment;
    } else {
        return "";
    }
}
function langCommentChars1(lang) {
    const chars = kLangCommentChars1[lang] || "#";
    if (!Array.isArray(chars)) {
        return [
            chars
        ];
    } else {
        return chars;
    }
}
const kLangCommentChars1 = {
    r: "#",
    python: "#",
    julia: "#",
    scala: "//",
    matlab: "%",
    csharp: "//",
    fsharp: "//",
    c: [
        "/*",
        "*/"
    ],
    css: [
        "/*",
        "*/"
    ],
    sas: [
        "*",
        ";"
    ],
    powershell: "#",
    bash: "#",
    sql: "--",
    mysql: "--",
    psql: "--",
    lua: "--",
    cpp: "//",
    cc: "//",
    stan: "#",
    octave: "#",
    fortran: "!",
    fortran95: "!",
    awk: "#",
    gawk: "#",
    stata: "*",
    java: "//",
    groovy: "//",
    sed: "#",
    perl: "#",
    ruby: "#",
    tikz: "%",
    js: "//",
    d3: "//",
    node: "//",
    sass: "//",
    coffee: "#",
    go: "//",
    asy: "//",
    haskell: "--",
    dot: "//"
};
function mdFromCodeCell(cell, cellIndex, options) {
    if (!includeCell(cell, options)) {
        return [];
    }
    const outputs = (cell.outputs || []).filter((output)=>{
        if (output.output_type === "stream" && output.name === "stderr" && !includeWarnings(cell, options)) {
            return false;
        }
        if (output.output_type === "execute_result") {
            const textPlain = output.data?.[kTextPlain];
            if (textPlain && textPlain[0].startsWith("[<matplotlib")) {
                return false;
            }
        }
        return true;
    });
    if (!cell.source.length && !outputs.length) {
        return [];
    }
    const asis = cell.options[kOutput] === "asis" || options.execute[kOutput] === "asis" && cell.options[kOutput] === undefined;
    const md = [];
    const divMd = [
        `::: {`
    ];
    const kCellOptionsFilter = kJupyterCellInternalOptionKeys.concat(kJupyterCellStandardMetadataKeys, kJupyterCellThirdPartyMetadataKeys);
    const label = cellLabel(cell);
    const labelCellContainer = shouldLabelCellContainer(cell, outputs, options);
    if (label && labelCellContainer) {
        divMd.push(`${label} `);
    }
    const { cellCaption , outputCaptions  } = resolveCaptions(cell);
    divMd.push(`.cell `);
    if (hideCell(cell, options)) {
        divMd.push(`.hidden `);
    }
    if (cell.options[kCellClasses] || cell.options[kCellPanel]) {
        const cellClasses = cell.options[kCellClasses] || new Array();
        const classes = Array.isArray(cellClasses) ? cellClasses : [
            cellClasses
        ];
        if (typeof cell.options[kCellPanel] === "string") {
            classes.push(`panel-${cell.options[kCellPanel]}`);
        }
        if (typeof cell.options[kCellColumn] === "string") {
            classes.push(`column-${cell.options[kCellColumn]}`);
        }
        if (typeof cell.options[kCellFigColumn] === "string") {
            classes.push(`fig-column-${cell.options[kCellFigColumn]}`);
        }
        if (typeof cell.options[kCellTblColumn] === "string") {
            classes.push(`tbl-column-${cell.options[kCellTblColumn]}`);
        }
        if (typeof cell.options[kCapLoc] === "string") {
            classes.push(`caption-${cell.options[kFigCapLoc]}`);
        }
        if (typeof cell.options[kFigCapLoc] === "string") {
            classes.push(`fig-cap-location-${cell.options[kFigCapLoc]}`);
        }
        if (typeof cell.options[kTblCapLoc] === "string") {
            classes.push(`tbl-cap-location-${cell.options[kTblCapLoc]}`);
        }
        const classText = classes.map((clz)=>{
            clz = toString1(clz);
            return clz.startsWith(".") ? clz : "." + clz;
        }).join(" ");
        divMd.push(classText + " ");
    }
    const cellOptions = {
        ...cell.metadata,
        ...cell.options
    };
    for (const key of Object.keys(cellOptions)){
        if (!kCellOptionsFilter.includes(key.toLowerCase())) {
            let value = cellOptions[key];
            if (value) {
                if (typeof value !== "string") {
                    value = JSON.stringify(value);
                }
                value = value.replaceAll("'", `\\'`);
                divMd.push(`${key}='${value}' `);
            }
        }
    }
    if (typeof cell.execution_count === "number") {
        divMd.push(`execution_count=${cell.execution_count} `);
    }
    const divBeginMd = divMd.join("").replace(/ $/, "").concat("}\n");
    if (includeCode(cell, options)) {
        const fenced = echoFenced(cell, options);
        const ticks = fenced ? "````" : "```";
        md.push(ticks + " {");
        if (typeof cell.options[kCellLstLabel] === "string") {
            let label = cell.options[kCellLstLabel];
            if (!label.startsWith("#")) {
                label = "#" + label;
            }
            md.push(label + " ");
        }
        if (!fenced) {
            md.push("." + options.language);
        }
        md.push(" .cell-code");
        if (hideCode(cell, options)) {
            md.push(" .hidden");
        }
        if (cell.options[kCodeOverflow] === "wrap") {
            md.push(" .code-overflow-wrap");
        } else if (cell.options[kCodeOverflow] === "scroll") {
            md.push(" .code-overflow-scroll");
        }
        if (typeof cell.options[kCellLstCap] === "string") {
            md.push(` caption=\"${cell.options[kCellLstCap]}\"`);
        }
        if (typeof cell.options[kCodeFold] !== "undefined") {
            md.push(` code-fold=\"${cell.options[kCodeFold]}\"`);
        }
        if (typeof cell.options[kCodeSummary] !== "undefined") {
            md.push(` code-summary=\"${cell.options[kCodeSummary]}\"`);
        }
        if (typeof cell.options[kCodeLineNumbers] !== "undefined") {
            md.push(` code-line-numbers=\"${cell.options[kCodeLineNumbers]}\"`);
        }
        md.push("}\n");
        let source = __VIRTUAL_FILE107(cell.source);
        if (fenced) {
            const optionsSource = cell.optionsSource.filter((line)=>line.search(/echo:\s+fenced/) === -1
            );
            if (optionsSource.length > 0) {
                source = mdTrimEmptyLines(source, "trailing");
            } else {
                source = mdTrimEmptyLines(source, "all");
            }
            source.unshift(...optionsSource);
            source.unshift("```{{" + options.language + "}}\n");
            source.push("\n```\n");
        } else if (cell.optionsSource.length > 0) {
            source = mdTrimEmptyLines(source, "leading");
        }
        md.push(...source, "\n");
        md.push(ticks + "\n");
    }
    if (includeOutput(cell, options)) {
        const labelName = label ? label.replace(/^#/, "").replaceAll(":", "-") : "cell-" + (cellIndex + 1);
        const outputName = pandocAutoIdentifier(labelName, true) + "-output";
        let nextOutputSuffix = 1;
        for (const { index: index1 , output  } of outputs.map((value, index)=>({
                index,
                output: value
            })
        )){
            const outputLabel = label && labelCellContainer && isDisplayData(output) ? label + "-" + nextOutputSuffix++ : label;
            if (!asis) {
                md.push("\n::: {");
                if (outputLabel && shouldLabelOutputContainer(output, cell.options, options)) {
                    md.push(outputLabel + " ");
                }
                if (output.output_type === "stream") {
                    const stream = output;
                    md.push(`.cell-output-${stream.name}`);
                } else {
                    md.push(`.${outputTypeCssClass(output.output_type)}`);
                }
                if (hideOutput(cell, options) || isWarningOutput(output) && hideWarnings(cell, options)) {
                    md.push(` .hidden`);
                }
                if (typeof output.execution_count === "number") {
                    md.push(` execution_count=${output.execution_count}`);
                }
                md.push("}\n");
            }
            const figureOptions = {};
            const broadcastFigureOption = (name111)=>{
                const value = cell.options[name111];
                if (value) {
                    if (Array.isArray(value)) {
                        return value[index1];
                    } else {
                        return value;
                    }
                } else {
                    return null;
                }
            };
            figureOptions[kCellFigAlign] = broadcastFigureOption(kCellFigAlign);
            figureOptions[kCellFigScap] = broadcastFigureOption(kCellFigScap);
            figureOptions[kCellFigLink] = broadcastFigureOption(kCellFigLink);
            figureOptions[kCellFigEnv] = broadcastFigureOption(kCellFigEnv);
            figureOptions[kCellFigPos] = broadcastFigureOption(kCellFigPos);
            figureOptions[kCellFigAlt] = broadcastFigureOption(kCellFigAlt);
            if (output.output_type === "stream") {
                const stream = output;
                if (asis && stream.name === "stdout") {
                    md.push(stream.text.join(""));
                } else {
                    md.push(mdOutputStream(stream));
                }
            } else if (output.output_type === "error") {
                md.push(mdOutputError(output));
            } else if (isDisplayData(output)) {
                const caption = isCaptionableData(output) ? outputCaptions.shift() || null : null;
                md.push(mdOutputDisplayData(outputLabel, caption, outputName + "-" + (index1 + 1), output, options, figureOptions));
                if (caption && !isImage(output, options)) {
                    md.push(`\n${caption}\n`);
                }
            } else {
                throw new Error("Unexpected output type " + output.output_type);
            }
            if (!asis) {
                md.push(`:::\n`);
            }
        }
    } else if (cell.outputs) {
        cell.outputs.filter(isDisplayData).filter((output)=>output.metadata.ojs_define
        ).forEach((ojs_define)=>{
            const ojs_html = ojs_define.data[kTextHtml];
            md.push("\n" + mdHtmlOutput(ojs_html));
        });
    }
    if (md.length > 0 && !asis) {
        md.unshift(divBeginMd);
        if (cellCaption) {
            md.push("\n" + cellCaption + "\n");
        }
        md.push(":::\n");
    }
    md.push("\n".repeat(cell.metadata.lines_to_next_cell || 1));
    if (cell.options[kCellMdIndent]) {
        const indent = String(cell.options[kCellMdIndent]);
        const mdWithIndent = md.join("").split("\n").map((line)=>indent + line
        ).join("\n");
        md.splice(0, md.length - 1);
        md.push(...mdWithIndent);
    }
    return md;
}
function isDisplayDataType(output, options, checkFn) {
    if (isDisplayData(output)) {
        const mimeType = displayDataMimeType(output, options);
        if (mimeType) {
            if (checkFn(mimeType)) {
                return true;
            }
        }
    }
    return false;
}
function isImage(output, options) {
    return isDisplayDataType(output, options, displayDataIsImage);
}
function mdOutputStream(output) {
    if (output.name === "stderr") {
        if (output.text[0]) {
            const firstLine = output.text[0].replace(/<ipython-input.*?>:\d+:\s+/, "");
            return mdCodeOutput([
                firstLine,
                ...output.text.slice(1)
            ]);
        }
    }
    return mdCodeOutput(output.text);
}
function mdOutputError(output) {
    return mdCodeOutput([
        output.ename + ": " + output.evalue
    ]);
}
function mdOutputDisplayData(label, caption, filename, output, options, figureOptions) {
    const mimeType = displayDataMimeType(output, options);
    if (mimeType) {
        if (displayDataIsImage(mimeType)) {
            return mdImageOutput(label, caption, filename, mimeType, output, options, figureOptions);
        } else if (displayDataIsMarkdown(mimeType)) {
            return mdMarkdownOutput(output.data[mimeType]);
        } else if (displayDataIsLatex(mimeType)) {
            return mdLatexOutput(output.data[mimeType]);
        } else if (displayDataIsHtml(mimeType)) {
            return mdHtmlOutput(output.data[mimeType]);
        } else if (displayDataIsJson(mimeType)) {
            return mdJsonOutput(mimeType, output.data[mimeType], options);
        } else if (displayDataIsJavascript(mimeType)) {
            return mdScriptOutput(mimeType, output.data[mimeType]);
        } else if (displayDataIsTextPlain(mimeType)) {
            const lines1 = output.data[mimeType];
            if (lines1.length === 1 && lines1[0].startsWith("'<table") && lines1[0].endsWith("</table>'")) {
                lines1[0] = lines1[0].slice(1, -1);
                return mdMarkdownOutput(lines1);
            } else {
                return mdCodeOutput(lines1);
            }
        }
    }
    return mdWarningOutput("Unable to display output for mime type(s): " + Object.keys(output.data).join(", "));
}
function mdImageOutput(label, caption, filename, mimeType, output, options, figureOptions) {
    const data89 = output.data[mimeType];
    const metadata9 = output.metadata[mimeType];
    function metadataValue(key, defaultValue) {
        return metadata9 && metadata9[key] ? metadata9["key"] : defaultValue;
    }
    let width = metadataValue(kCellOutWidth, 0);
    let height = metadataValue(kCellOutHeight, 0);
    const alt = caption || "";
    const ext = extensionForMimeImageType(mimeType);
    const imageFile = options.assets.figures_dir + "/" + filename + "." + ext;
    const imageText = Array.isArray(data89) ? data89.join("") : data89;
    const outputFile = join3(options.assets.base_dir, imageFile);
    if (mimeType !== kImageSvg) {
        const imageData = decode(imageText);
        if (mimeType === kImagePng && options.figFormat === "retina" && options.figDpi) {
            const png = new PngImage(imageData);
            if (png.dpiX === options.figDpi * 2 && png.dpiY === options.figDpi * 2) {
                width = Math.round(png.width / 2);
                height = Math.round(png.height / 2);
            }
        }
        Deno.writeFileSync(outputFile, imageData);
    } else {
        Deno.writeTextFileSync(outputFile, imageText);
    }
    let image1 = `![${alt}](${imageFile})`;
    if (label || width || height) {
        image1 += "{";
        if (label) {
            image1 += `${label} `;
        }
        if (width) {
            image1 += `width=${width} `;
        }
        if (height) {
            image1 += `height=${height} `;
        }
        [
            kCellFigAlign,
            kCellFigEnv,
            kCellFigAlt,
            kCellFigPos,
            kCellFigScap
        ].forEach((attrib)=>{
            const value = figureOptions[attrib];
            if (value) {
                image1 += `${attrib}='${value}' `;
            }
        });
        image1 = image1.trimRight() + "}";
    }
    if (figureOptions[kCellFigLink]) {
        image1 = `[${image1}](${figureOptions[kCellFigLink]})`;
    }
    return mdMarkdownOutput([
        image1
    ]);
}
function mdMarkdownOutput(md) {
    return md.join("") + "\n";
}
function mdFormatOutput(format33, source) {
    return mdEnclosedOutput("```{=" + format33 + "}", source, "```");
}
function mdLatexOutput(latex) {
    return mdFormatOutput("tex", latex);
}
function mdHtmlOutput(html) {
    return mdFormatOutput("html", html);
}
function mdJsonOutput(mimeType, json2, options) {
    if (options.toIpynb) {
        return mdCodeOutput([
            JSON.stringify(json2)
        ], "json");
    } else {
        return mdScriptOutput(mimeType, [
            JSON.stringify(json2)
        ]);
    }
}
function mdScriptOutput(mimeType, script) {
    const scriptTag = [
        `<script type="${mimeType}">\n`,
        ...script,
        "\n</script>", 
    ];
    return mdHtmlOutput(scriptTag);
}
function mdTrimEmptyLines(lines2, trim = "all") {
    if (trim === "all" || trim === "leading") {
        const firstNonEmpty = lines2.findIndex((line)=>line.trim().length > 0
        );
        if (firstNonEmpty === -1) {
            return [];
        }
        lines2 = lines2.slice(firstNonEmpty);
    }
    if (trim === "all" || trim === "trailing") {
        let lastNonEmpty = -1;
        for(let i89 = lines2.length - 1; i89 >= 0; i89--){
            if (lines2[i89].trim().length > 0) {
                lastNonEmpty = i89;
                break;
            }
        }
        if (lastNonEmpty > -1) {
            lines2 = lines2.slice(0, lastNonEmpty + 1);
        }
    }
    return lines2;
}
function mdCodeOutput(code19, clz) {
    const open = "```" + (clz ? `{.${clz}}` : "");
    return mdEnclosedOutput(open, code19, "```");
}
function mdEnclosedOutput(begin, text, end) {
    const output = text.join("");
    const md = [
        begin + "\n",
        output + (output.endsWith("\n") ? "" : "\n"),
        end + "\n", 
    ];
    return md.join("");
}
function mdWarningOutput(msg) {
    return mdOutputStream({
        output_type: "stream",
        name: "stderr",
        text: [
            msg
        ]
    });
}
function isWarningOutput(output) {
    if (output.output_type === "stream") {
        const stream = output;
        return stream.name === "stderr";
    } else {
        return false;
    }
}
function outputTypeCssClass(output_type) {
    if ([
        "display_data",
        "execute_result"
    ].includes(output_type)) {
        output_type = "display";
    }
    return `cell-output-${output_type}`;
}
function pandocAttrParseText(attr) {
    attr = attr.trim();
    let id2 = "";
    const classes = [];
    let remainder = "";
    let current = "";
    const resolveCurrent = ()=>{
        const resolve6 = current;
        current = "";
        if (resolve6.length === 0) {
            return true;
        } else if (resolve6.startsWith("#")) {
            if (id2.length === 0 && resolve6.length > 1) {
                id2 = resolve6.substr(1);
                return true;
            } else {
                return false;
            }
        } else if (resolve6.startsWith(".")) {
            if (resolve6.length > 1) {
                classes.push(resolve6.substr(1));
                return true;
            } else {
                return false;
            }
        } else if (resolve6 === "-") {
            classes.push("unnumbered");
            return true;
        } else {
            remainder = resolve6;
            return true;
        }
    };
    for(let i90 = 0; i90 < attr.length; i90++){
        let inQuotes = false;
        const ch = attr[i90];
        inQuotes = ch === '"' ? !inQuotes : inQuotes;
        if (ch !== " " && !inQuotes) {
            current += ch;
        } else if (resolveCurrent()) {
            if (remainder.length > 0) {
                remainder = remainder + attr.substr(i90);
                break;
            }
        } else {
            return null;
        }
    }
    if (resolveCurrent()) {
        if (id2.length === 0 && classes.length === 0) {
            remainder = attr;
        }
        return {
            id: id2,
            classes,
            keyvalue: remainder.length > 0 ? pandocAttrKeyvalueFromText(remainder, " ") : []
        };
    } else {
        return null;
    }
}
function pandocAttrKeyvalueFromText(text, separator) {
    if (separator === " ") {
        let convertedText = "";
        let inQuotes = false;
        for(let i91 = 0; i91 < text.length; i91++){
            let ch = text.charAt(i91);
            if (ch === '"') {
                inQuotes = !inQuotes;
            } else if (ch === " " && !inQuotes) {
                ch = "\n";
            }
            convertedText += ch;
        }
        text = convertedText;
    }
    const lines4 = text.trim().split("\n");
    return lines4.map((line)=>{
        const parts = line.trim().split("=");
        return [
            parts[0],
            (parts[1] || "").replace(/^"/, "").replace(/"$/, "")
        ];
    });
}
function parsePandocTitle(title5) {
    title5 = title5 ? title5.trim() : title5;
    let beginAttrPos = -1;
    let previousCh = undefined;
    let state39 = "none";
    for(let i92 = title5.length - 1; i92 > -1; i92--){
        const ch = title5.charAt(i92);
        if (previousCh === undefined && ch !== "}") {
            break;
        }
        if (previousCh === undefined && ch === "}") {
            state39 = "scanning";
            previousCh = ch;
            continue;
        }
        if (state39 === "scanning") {
            if ([
                "/",
                "}",
                "]"
            ].includes(ch)) {
                break;
            }
            state39 = "reading";
            previousCh = ch;
            continue;
        }
        if (state39 === "reading") {
            if (![
                "/"
            ].includes(ch) && previousCh === "{") {
                beginAttrPos = i92 + 1;
                break;
            }
            previousCh = ch;
        }
    }
    let markdownHeading = beginAttrPos !== -1 ? title5.slice(0, beginAttrPos) : title5;
    markdownHeading = markdownHeading.trim().replace(/^#{1,}\s*/, "");
    let markdownHeadingAttr;
    if (beginAttrPos !== -1) {
        const endAttrPos = title5.lastIndexOf("}");
        if (endAttrPos !== -1) {
            const attr = title5.slice(beginAttrPos + 1, endAttrPos);
            const parsed = pandocAttrParseText(attr);
            if (parsed) {
                markdownHeadingAttr = parsed;
            }
        }
    }
    return {
        heading: markdownHeading,
        attr: markdownHeadingAttr
    };
}
function partitionMarkdown(markdown) {
    const markdownLines = [];
    let markdownHeading;
    let markdownHeadingAttr;
    let markdownContainsRefs = false;
    const partitioned = partitionYamlFrontMatter(markdown);
    markdown = partitioned ? partitioned.markdown : markdown;
    for (const line of lines(markdown)){
        if (!markdownContainsRefs) {
            markdownContainsRefs = /^:::\s*{#refs([\s}]|.*?})\s*$/.test(line);
        }
        if (!markdownHeading) {
            if (line.startsWith("#")) {
                const parsedHeading = parsePandocTitle(line);
                markdownHeading = parsedHeading.heading;
                markdownHeadingAttr = parsedHeading.attr;
            } else if (line.match(/^=+\s*$/) || line.match(/^-+\s*$/)) {
                const prevLine = markdownLines[markdownLines.length - 1];
                if (prevLine) {
                    markdownHeading = prevLine;
                    markdownLines.splice(markdownLines.length - 1);
                } else {
                    markdownLines.push(line);
                }
            } else {
                markdownLines.push(line);
            }
        } else {
            markdownLines.push(line);
        }
    }
    return {
        yaml: partitioned ? partitioned.yaml : undefined,
        headingText: markdownHeading,
        headingAttr: markdownHeadingAttr,
        containsRefs: markdownContainsRefs,
        markdown: markdownLines.join("\n")
    };
}
async function knitrCapabilities() {
    try {
        const result = await execProcess({
            cmd: [
                await rBinaryPath("Rscript"),
                resourcePath("capabilities/knitr.R"), 
            ],
            stdout: "piped"
        });
        if (result.success && result.stdout) {
            const caps = readYamlFromString(result.stdout);
            return caps;
        } else {
            return undefined;
        }
    } catch  {
        return undefined;
    }
}
function knitrCapabilitiesMessage(caps, indent = "") {
    const lines5 = [
        `Version: ${caps.versionMajor}.${caps.versionMinor}.${caps.versionPatch}`,
        `Path: ${caps.home}`,
        `LibPaths:`, 
    ];
    for (const path76 of caps.libPaths){
        lines5.push(`  - ${path76}`);
    }
    lines5.push(`rmarkdown: ${caps.rmarkdown || "(None)"}`);
    return lines5.map((line)=>`${indent}${line}`
    ).join("\n");
}
function knitrInstallationMessage(indent = "") {
    const lines6 = [
        "The rmarkdown package is not available in this R installation.",
        "Install with " + bold('install.packages("rmarkdown")'), 
    ];
    return lines6.map((line)=>`${indent}${line}`
    ).join("\n");
}
function rInstallationMessage(indent = "") {
    const lines7 = [
        "Unable to locate an installed version of R.",
        "Install R from " + bold("https://cloud.r-project.org/"), 
    ];
    return lines7.map((line)=>`${indent}${line}`
    ).join("\n");
}
const kQmdExtensions = [
    ".qmd"
];
const kMarkdownEngine = "markdown";
const kKnitrEngine = "knitr";
const kJupyterEngine = "jupyter";
function postProcessRestorePreservedHtml(options) {
    const outputPath = join3(dirname2(options.target.input), options.output);
    let output = Deno.readTextFileSync(outputPath);
    output = restorePreservedHtml(output, options.preserve);
    Deno.writeTextFileSync(outputPath, output);
}
const kRmdExtensions = [
    ".rmd",
    ".rmarkdown"
];
const knitrEngine = {
    name: kKnitrEngine,
    defaultExt: ".qmd",
    defaultYaml: ()=>[]
    ,
    defaultContent: ()=>[
            "```{r}",
            "1 + 1",
            "```", 
        ]
    ,
    validExtensions: ()=>kRmdExtensions.concat(kRmdExtensions)
    ,
    claimsExtension: (ext)=>{
        return kRmdExtensions.includes(ext.toLowerCase());
    },
    claimsLanguage: (language)=>{
        return language.toLowerCase() === "r";
    },
    target: (file, _quiet)=>{
        const markdown = Deno.readTextFileSync(file);
        return Promise.resolve({
            source: file,
            input: file,
            markdown,
            metadata: readYamlFromMarkdown(markdown)
        });
    },
    partitionedMarkdown: (file)=>{
        return Promise.resolve(partitionMarkdown(Deno.readTextFileSync(file)));
    },
    execute: (options)=>{
        return callR("execute", {
            ...options,
            target: undefined,
            input: options.target.input
        }, options.tempDir, options.quiet);
    },
    dependencies: (options)=>{
        return callR("dependencies", {
            ...options,
            target: undefined,
            input: options.target.input
        }, options.tempDir, options.quiet);
    },
    postprocess: async (options)=>{
        postProcessRestorePreservedHtml(options);
        if (options.format.render?.[kCodeLink]) {
            await callR("postprocess", {
                ...options,
                target: undefined,
                preserve: undefined,
                input: options.target.input
            }, options.tempDir, options.quiet, false).then(()=>{
                return Promise.resolve();
            }, ()=>{
                warning(`Unable to perform code-link (code-link requires R and the downlit package)`);
                return Promise.resolve();
            });
        }
    },
    canFreeze: true,
    generatesFigures: true,
    ignoreDirs: ()=>{
        return [
            "renv",
            "packrat",
            "rsconnect"
        ];
    },
    run: (options)=>{
        return callR("run", options, options.tempDir);
    }
};
async function callR(action, params, tempDir2, quiet, reportError = true) {
    const resultsFile = Deno.makeTempFileSync({
        dir: tempDir2,
        prefix: "r-results",
        suffix: ".json"
    });
    const input = JSON.stringify({
        action,
        params,
        results: resultsFile
    });
    try {
        const result = await execProcess({
            cmd: [
                await rBinaryPath("Rscript"),
                resourcePath("rmd/rmd.R"), 
            ],
            stderr: quiet ? "piped" : "inherit"
        }, input, "stdout>stderr", red);
        if (result.success) {
            const results = await Deno.readTextFile(resultsFile);
            await Deno.remove(resultsFile);
            const resultsJson = JSON.parse(results);
            return resultsJson;
        } else {
            if (quiet) {
                error(result.stderr || "");
            }
            if (reportError) {
                await printCallRDiagnostics();
            }
            return Promise.reject();
        }
    } catch (e) {
        if (reportError) {
            if (e?.message) {
                info("");
                error(e.message);
            }
            await printCallRDiagnostics();
        }
        return Promise.reject();
    }
}
async function printCallRDiagnostics() {
    const caps = await knitrCapabilities();
    if (caps && !caps.rmarkdown) {
        info("");
        info("R installation:");
        info(knitrCapabilitiesMessage(caps, "  "));
        info("");
        info(knitrInstallationMessage());
        info("");
    } else if (!caps) {
        info("");
        info(rInstallationMessage());
        info("");
    }
}
function runningInCI() {
    if ([
        "CI",
        "CONTINUOUS_INTEGRATION",
        "BUILD_NUMBER",
        "RUN_ID"
    ].some(checkEnv)) {
        return true;
    }
    return vendors.some((vendor)=>{
        const envs = Array.isArray(vendor.env) ? vendor.env : [
            vendor.env
        ];
        return envs.some(checkEnv);
    });
}
function checkEnv(obj) {
    if (typeof obj === "string") {
        return !!Deno.env.get(obj);
    } else {
        return Object.keys(obj).every(function(k) {
            return Deno.env.get(k) === obj[k];
        });
    }
}
const vendors = [
    {
        "name": "AppVeyor",
        "constant": "APPVEYOR",
        "env": "APPVEYOR",
        "pr": "APPVEYOR_PULL_REQUEST_NUMBER"
    },
    {
        "name": "Azure Pipelines",
        "constant": "AZURE_PIPELINES",
        "env": "SYSTEM_TEAMFOUNDATIONCOLLECTIONURI",
        "pr": "SYSTEM_PULLREQUEST_PULLREQUESTID"
    },
    {
        "name": "Appcircle",
        "constant": "APPCIRCLE",
        "env": "AC_APPCIRCLE"
    },
    {
        "name": "Bamboo",
        "constant": "BAMBOO",
        "env": "bamboo_planKey"
    },
    {
        "name": "Bitbucket Pipelines",
        "constant": "BITBUCKET",
        "env": "BITBUCKET_COMMIT",
        "pr": "BITBUCKET_PR_ID"
    },
    {
        "name": "Bitrise",
        "constant": "BITRISE",
        "env": "BITRISE_IO",
        "pr": "BITRISE_PULL_REQUEST"
    },
    {
        "name": "Buddy",
        "constant": "BUDDY",
        "env": "BUDDY_WORKSPACE_ID",
        "pr": "BUDDY_EXECUTION_PULL_REQUEST_ID"
    },
    {
        "name": "Buildkite",
        "constant": "BUILDKITE",
        "env": "BUILDKITE",
        "pr": {
            "env": "BUILDKITE_PULL_REQUEST",
            "ne": "false"
        }
    },
    {
        "name": "CircleCI",
        "constant": "CIRCLE",
        "env": "CIRCLECI",
        "pr": "CIRCLE_PULL_REQUEST"
    },
    {
        "name": "Cirrus CI",
        "constant": "CIRRUS",
        "env": "CIRRUS_CI",
        "pr": "CIRRUS_PR"
    },
    {
        "name": "AWS CodeBuild",
        "constant": "CODEBUILD",
        "env": "CODEBUILD_BUILD_ARN"
    },
    {
        "name": "Codefresh",
        "constant": "CODEFRESH",
        "env": "CF_BUILD_ID",
        "pr": {
            "any": [
                "CF_PULL_REQUEST_NUMBER",
                "CF_PULL_REQUEST_ID"
            ]
        }
    },
    {
        "name": "Codeship",
        "constant": "CODESHIP",
        "env": {
            "CI_NAME": "codeship"
        }
    },
    {
        "name": "Drone",
        "constant": "DRONE",
        "env": "DRONE",
        "pr": {
            "DRONE_BUILD_EVENT": "pull_request"
        }
    },
    {
        "name": "dsari",
        "constant": "DSARI",
        "env": "DSARI"
    },
    {
        "name": "GitHub Actions",
        "constant": "GITHUB_ACTIONS",
        "env": "GITHUB_ACTIONS",
        "pr": {
            "GITHUB_EVENT_NAME": "pull_request"
        }
    },
    {
        "name": "GitLab CI",
        "constant": "GITLAB",
        "env": "GITLAB_CI",
        "pr": "CI_MERGE_REQUEST_ID"
    },
    {
        "name": "GoCD",
        "constant": "GOCD",
        "env": "GO_PIPELINE_LABEL"
    },
    {
        "name": "LayerCI",
        "constant": "LAYERCI",
        "env": "LAYERCI",
        "pr": "LAYERCI_PULL_REQUEST"
    },
    {
        "name": "Hudson",
        "constant": "HUDSON",
        "env": "HUDSON_URL"
    },
    {
        "name": "Jenkins",
        "constant": "JENKINS",
        "env": [
            "JENKINS_URL",
            "BUILD_ID"
        ],
        "pr": {
            "any": [
                "ghprbPullId",
                "CHANGE_ID"
            ]
        }
    },
    {
        "name": "Magnum CI",
        "constant": "MAGNUM",
        "env": "MAGNUM"
    },
    {
        "name": "Netlify CI",
        "constant": "NETLIFY",
        "env": "NETLIFY",
        "pr": {
            "env": "PULL_REQUEST",
            "ne": "false"
        }
    },
    {
        "name": "Nevercode",
        "constant": "NEVERCODE",
        "env": "NEVERCODE",
        "pr": {
            "env": "NEVERCODE_PULL_REQUEST",
            "ne": "false"
        }
    },
    {
        "name": "Render",
        "constant": "RENDER",
        "env": "RENDER",
        "pr": {
            "IS_PULL_REQUEST": "true"
        }
    },
    {
        "name": "Sail CI",
        "constant": "SAIL",
        "env": "SAILCI",
        "pr": "SAIL_PULL_REQUEST_NUMBER"
    },
    {
        "name": "Semaphore",
        "constant": "SEMAPHORE",
        "env": "SEMAPHORE",
        "pr": "PULL_REQUEST_NUMBER"
    },
    {
        "name": "Screwdriver",
        "constant": "SCREWDRIVER",
        "env": "SCREWDRIVER",
        "pr": {
            "env": "SD_PULL_REQUEST",
            "ne": "false"
        }
    },
    {
        "name": "Shippable",
        "constant": "SHIPPABLE",
        "env": "SHIPPABLE",
        "pr": {
            "IS_PULL_REQUEST": "true"
        }
    },
    {
        "name": "Solano CI",
        "constant": "SOLANO",
        "env": "TDDIUM",
        "pr": "TDDIUM_PR_ID"
    },
    {
        "name": "Strider CD",
        "constant": "STRIDER",
        "env": "STRIDER"
    },
    {
        "name": "TaskCluster",
        "constant": "TASKCLUSTER",
        "env": [
            "TASK_ID",
            "RUN_ID"
        ]
    },
    {
        "name": "TeamCity",
        "constant": "TEAMCITY",
        "env": "TEAMCITY_VERSION"
    },
    {
        "name": "Travis CI",
        "constant": "TRAVIS",
        "env": "TRAVIS",
        "pr": {
            "env": "TRAVIS_PULL_REQUEST",
            "ne": "false"
        }
    },
    {
        "name": "Vercel",
        "constant": "VERCEL",
        "env": "NOW_BUILDER"
    },
    {
        "name": "Visual Studio App Center",
        "constant": "APPCENTER",
        "env": "APPCENTER_BUILD_ID"
    }, 
];
const sleep = (delay)=>{
    return new Promise((resolve7)=>{
        setTimeout(resolve7, delay);
    });
};
async function jupyterCapabilitiesMessage(caps, indent = "") {
    const lines8 = [
        `Version: ${caps.versionMajor}.${caps.versionMinor}.${caps.versionPatch}${caps.conda ? " (Conda)" : ""}`,
        `Path: ${caps.executable}`,
        `Jupyter: ${caps.jupyter_core || "(None)"}`, 
    ];
    if (caps.jupyter_core) {
        const kernels = Array.from((await jupyterKernelspecs()).values()).map((kernel)=>kernel.name
        ).join(", ");
        lines8.push(`Kernels: ${kernels}`);
    }
    return lines8.map((line)=>`${indent}${line}`
    ).join("\n");
}
async function jupyterInstallationMessage(caps, indent = "") {
    const lines9 = [
        "Jupyter is not available in this Python installation.",
        "Install with " + bold(`${caps.conda ? "conda" : (await pythonExec(true)).join(" ") + " -m pip"} install jupyter`), 
    ];
    return lines9.map((line)=>`${indent}${line}`
    ).join("\n");
}
function jupyterUnactivatedEnvMessage(caps, indent = "") {
    for (const path77 of Deno.readDirSync(Deno.cwd())){
        if (path77.isDirectory) {
            const targetPath = join3(Deno.cwd(), path77.name);
            if (isEnvDir(targetPath)) {
                try {
                    if (!pathWithForwardSlashes(caps.executable).startsWith(pathWithForwardSlashes(targetPath))) {
                        return indent + "There is an unactivated Python environment in " + bold(path77.name) + ". Did you forget to activate it?";
                    }
                } catch  {
                    return undefined;
                }
            }
        }
    }
    const kRequirementsTxt = "requirements.txt";
    const kEnvironmentYaml = "environment.yml";
    for (const envFile of [
        kRequirementsTxt,
        kEnvironmentYaml
    ]){
        if (existsSync(join3(Deno.cwd(), envFile))) {
            return indent + "There is a " + bold(envFile) + " file in this directory. " + "Is this for a " + (envFile === kRequirementsTxt ? "venv" : "conda env") + " that you need to restore?";
        }
    }
    return undefined;
}
function pythonInstallationMessage(indent = "") {
    const lines10 = [
        "Unable to locate an installed version of Python 3.",
        "Install Python 3 from " + bold("https://www.python.org/downloads/"), 
    ];
    return lines10.map((line)=>`${indent}${line}`
    ).join("\n");
}
async function executeKernelOneshot(options) {
    await abortKernel(options);
    if (!options.quiet) {
        messageStartingKernel();
    }
    trace(options, "Executing notebook with oneshot kernel");
    const debug2 = !!options.format.execute[kExecuteDebug];
    const result = await execJupyter("execute", {
        ...options,
        debug: debug2
    });
    if (!result.success) {
        return Promise.reject();
    }
}
async function executeKernelKeepalive(options) {
    let serverLogProcess;
    if (options.format.execute[kExecuteDebug]) {
        if (Deno.build.os !== "windows") {
            serverLogProcess = Deno.run({
                cmd: [
                    "tail",
                    "-F",
                    "-n",
                    "0",
                    kernelLogFile()
                ]
            });
        }
    }
    if (options.format.execute[kExecuteDaemonRestart]) {
        await abortKernel(options);
    }
    trace(options, "Connecting to kernel");
    const [conn, transport] = await connectToKernel(options);
    trace(options, "Kernel connection successful");
    try {
        trace(options, "Sending execute command to kernel");
        await writeKernelCommand(conn, "execute", transport.secret, {
            ...options
        });
        trace(options, "Execute command sent, reading response");
        let leftover = "";
        while(true){
            const buffer = new Uint8Array(512);
            const bytesRead = await conn.read(buffer);
            if (bytesRead === null) {
                break;
            }
            if (bytesRead > 0) {
                const payload = new TextDecoder().decode(buffer.slice(0, bytesRead));
                const jsonMessages = payload.split("\n");
                for (let jsonMessage of jsonMessages){
                    if (!jsonMessage) {
                        continue;
                    }
                    if (leftover) {
                        jsonMessage = leftover + jsonMessage;
                        leftover = "";
                    }
                    try {
                        const msg = JSON.parse(jsonMessage);
                        if (msg.type === "error") {
                            trace(options, "Error response received");
                            error(msg.data, {
                                colorize: false
                            });
                            printExecDiagnostics(msg.data);
                            return Promise.reject();
                        } else if (msg.type == "restart") {
                            trace(options, "Restart request received");
                            return executeKernelKeepalive(options);
                        } else {
                            info(msg.data, {
                                newline: false
                            });
                        }
                    } catch  {
                        leftover = jsonMessage;
                    }
                }
            }
        }
        trace(options, "Server request complete\n\n");
    } catch (e) {
        trace(options, "Error occurred receiving response from server");
        const transportFile = kernelTransportFile(options.target.input);
        if (existsSync(transportFile)) {
            Deno.removeSync(transportFile);
        }
        throw e;
    } finally{
        conn.close();
        if (serverLogProcess) {
            serverLogProcess.kill("SIGKILL");
        }
    }
}
async function abortKernel(options) {
    try {
        trace(options, "Checking for existing kernel");
        const [conn, transport] = await connectToKernel(options, false);
        trace(options, "Existing kernel found");
        try {
            trace(options, "Sending kernel abort request");
            await writeKernelCommand(conn, "abort", transport.secret, {});
            trace(options, "Abort request successful");
        } finally{
            const transportFile = kernelTransportFile(options.target.input);
            if (existsSync(transportFile)) {
                Deno.removeSync(transportFile);
            }
            conn.close();
        }
    } catch  {
        trace(options, "No existing kernel found");
    }
}
async function execJupyter(command, options) {
    try {
        const result = await execProcess({
            cmd: [
                ...await pythonExec(),
                resourcePath("jupyter/jupyter.py"), 
            ],
            stdout: "piped"
        }, kernelCommand(command, "", options));
        if (!result.success) {
            await printExecDiagnostics(result.stderr);
        }
        return result;
    } catch (e) {
        if (e?.message) {
            info("");
            error(e.message);
        }
        await printExecDiagnostics();
        return Promise.reject();
    }
}
async function printExecDiagnostics(stderr) {
    const caps = await jupyterCapabilities();
    if (caps && !caps.jupyter_core) {
        info("Python 3 installation:");
        info(await jupyterCapabilitiesMessage(caps, "  "));
        info("");
        info(await jupyterInstallationMessage(caps));
        info("");
        maybePrintUnactivatedEnvMessage(caps);
    } else if (!caps) {
        info(pythonInstallationMessage());
        info("");
    } else if (stderr && stderr.indexOf("ModuleNotFoundError") !== -1) {
        maybePrintUnactivatedEnvMessage(caps);
    }
}
function maybePrintUnactivatedEnvMessage(caps) {
    const envMessage = jupyterUnactivatedEnvMessage(caps);
    if (envMessage) {
        info(envMessage);
        info("");
    }
}
async function writeKernelCommand(conn, command, secret, options) {
    await conn.write(new TextEncoder().encode(kernelCommand(command, secret, options) + "\n"));
}
function kernelCommand(command, secret, options) {
    return JSON.stringify({
        command,
        secret,
        options: {
            ...options,
            log: kernelLogFile()
        }
    });
}
function kernelTransportFile(target) {
    const transportsDir = quartoRuntimeDir("jt");
    const targetFile = Deno.realPathSync(target);
    const hash = md5Hash(targetFile).slice(0, 20);
    return join3(transportsDir, hash);
}
function kernelLogFile() {
    const logsDir = quartoDataDir("logs");
    const kernelLog = join3(logsDir, "jupyter-kernel.log");
    if (!existsSync(kernelLog)) {
        Deno.writeTextFileSync(kernelLog, "");
    }
    return kernelLog;
}
function readKernelTransportFile(transportFile, type39) {
    if (existsSync(transportFile)) {
        if (type39 === "tcp") {
            try {
                const transport = JSON.parse(Deno.readTextFileSync(transportFile));
                if (transport.port && transport.secret) {
                    return {
                        ...transport,
                        type: type39
                    };
                } else {
                    throw new Error("Invalid file format");
                }
            } catch (e) {
                error("Error reading kernel transport file: " + e.toString() + "(removing file)");
                Deno.removeSync(transportFile);
                return null;
            }
        } else {
            return {
                port: transportFile,
                secret: "",
                type: type39
            };
        }
    } else {
        return null;
    }
}
async function connectToKernel(options, startIfRequired = true) {
    const debug3 = !!options.format.execute[kExecuteDebug];
    const transportFile = kernelTransportFile(options.target.input);
    const type40 = "tcp";
    const transport = readKernelTransportFile(transportFile, type40);
    if (transport) {
        try {
            return await denoConnectToKernel(transport);
        } catch  {
            Deno.removeSync(transportFile);
        }
    }
    if (!startIfRequired) {
        return Promise.reject();
    }
    if (!options.quiet) {
        messageStartingKernel();
    }
    const keepAlive = options.format.execute[kExecuteDaemon];
    const timeout = keepAlive === true || keepAlive === null || keepAlive === undefined ? 300 : keepAlive === false ? 0 : keepAlive;
    const result = await execJupyter("start", {
        transport: transportFile,
        timeout,
        type: type40,
        debug: debug3
    });
    if (!result.success) {
        return Promise.reject();
    }
    for(let i93 = 1; i93 < 20; i93++){
        await sleep(i93 * 100);
        const kernelTransport = readKernelTransportFile(transportFile, type40);
        if (kernelTransport) {
            try {
                return await denoConnectToKernel(kernelTransport);
            } catch (e) {
                Deno.removeSync(transportFile);
                error("Error connecting to Jupyter kernel: " + e.toString());
                return Promise.reject();
            }
        }
    }
    warning("Unable to start Jupyter kernel for " + options.target.input);
    return Promise.reject();
}
async function denoConnectToKernel(transport) {
    if (transport.type === "tcp") {
        const tcpConnectOptions = {
            transport: transport.type,
            hostname: "127.0.0.1",
            port: transport.port
        };
        return [
            await Deno.connect(tcpConnectOptions),
            transport, 
        ];
    } else {
        const unixConnectOptions = {
            transport: transport.type,
            path: transport.port
        };
        return [
            await Deno.connect(unixConnectOptions),
            transport, 
        ];
    }
}
function messageStartingKernel() {
    info("\nStarting Jupyter kernel...", {
        newline: false
    });
}
function trace(options, msg) {
    if (options.format.execute[kExecuteDebug]) {
        info("- " + msg, {
            bold: true
        });
    }
}
const jupyterEngine = {
    name: kJupyterEngine,
    defaultExt: ".qmd",
    defaultYaml: (kernel)=>[
            `jupyter: ${kernel || "python3"}`, 
        ]
    ,
    defaultContent: (kernel)=>{
        kernel = kernel || "python3";
        const lang = kernel.startsWith("python") ? "python" : kernel.startsWith("julia") ? "julia" : undefined;
        if (lang) {
            return [
                "```{" + lang + "}",
                "1 + 1",
                "```", 
            ];
        } else {
            return [];
        }
    },
    validExtensions: ()=>kJupyterNotebookExtensions.concat(kQmdExtensions)
    ,
    claimsExtension: (ext)=>{
        return kJupyterNotebookExtensions.includes(ext.toLowerCase());
    },
    claimsLanguage: (_language)=>{
        return false;
    },
    target: async (file)=>{
        const markdown = isJupyterNotebook(file) ? await markdownFromNotebook(file) : Deno.readTextFileSync(file);
        const metadata10 = readYamlFromMarkdown(markdown);
        if (isQmdFile(file)) {
            const [fileDir, fileStem] = dirAndStem(file);
            const notebook = join3(fileDir, fileStem + ".ipynb");
            const target = {
                source: file,
                input: notebook,
                markdown,
                metadata: metadata10,
                data: {
                    transient: true
                }
            };
            await createNotebookforTarget(target);
            return target;
        } else if (isJupyterNotebook(file)) {
            return {
                source: file,
                input: file,
                markdown,
                metadata: metadata10,
                data: {
                    transient: false
                }
            };
        } else {
            return undefined;
        }
    },
    partitionedMarkdown: async (file)=>{
        if (isJupyterNotebook(file)) {
            return partitionMarkdown(await markdownFromNotebook(file));
        } else {
            return partitionMarkdown(Deno.readTextFileSync(file));
        }
    },
    filterFormat: (source, options, format34)=>{
        if (isJupyterNotebook(source)) {
            let executeEnabled;
            if (options.devServerReload) {
                executeEnabled = false;
            } else if (typeof format34.execute[kExecuteIpynb] === "boolean") {
                executeEnabled = format34.execute[kExecuteIpynb];
            } else if (typeof format34.execute[kExecuteEnabled] == "boolean") {
                executeEnabled = format34.execute[kExecuteEnabled];
            } else {
                executeEnabled = false;
            }
            if (executeEnabled !== undefined) {
                return {
                    ...format34,
                    execute: {
                        ...format34.execute,
                        [kExecuteEnabled]: executeEnabled
                    }
                };
            } else {
                return format34;
            }
        } else {
            return format34;
        }
    },
    execute: async (options)=>{
        if (isQmdFile(options.target.source) && !existsSync(options.target.input)) {
            await createNotebookforTarget(options.target);
        }
        const execute = options.format.execute[kExecuteEnabled] !== false;
        if (execute) {
            const execOptions = {
                ...options,
                target: {
                    ...options.target,
                    input: Deno.realPathSync(options.target.input)
                }
            };
            let executeDaemon = options.format.execute[kExecuteDaemon];
            if (executeDaemon === null || executeDaemon === undefined) {
                executeDaemon = isInteractiveSession() && !runningInCI();
            }
            if (executeDaemon === false || executeDaemon === 0) {
                await executeKernelOneshot(execOptions);
            } else {
                await executeKernelKeepalive(execOptions);
            }
        }
        const nb = jupyterFromFile(options.target.input);
        const assets = jupyterAssets(options.target.input, options.format.pandoc.to);
        const result = jupyterToMarkdown(nb, {
            language: nb.metadata.kernelspec.language.toLowerCase(),
            assets,
            execute: options.format.execute,
            keepHidden: options.format.render[kKeepHidden],
            toHtml: isHtmlCompatible(options.format),
            toLatex: isLatexOutput(options.format.pandoc),
            toMarkdown: isMarkdownOutput(options.format.pandoc),
            toIpynb: isIpynbOutput(options.format.pandoc),
            toPresentation: isPresentationOutput(options.format.pandoc),
            figFormat: options.format.execute[kFigFormat],
            figDpi: options.format.execute[kFigDpi]
        });
        let includes;
        let engineDependencies;
        if (options.dependencies) {
            includes = executeResultIncludes(options.tempDir, result.dependencies);
        } else {
            const dependencies3 = executeResultEngineDependencies(result.dependencies);
            if (dependencies3) {
                engineDependencies = {
                    [kJupyterEngine]: dependencies3
                };
            }
        }
        cleanupNotebook(options.target, options.format);
        return {
            markdown: result.markdown,
            supporting: [
                join3(assets.base_dir, assets.supporting_dir)
            ],
            filters: [],
            pandoc: result.pandoc,
            includes,
            engineDependencies,
            preserve: result.htmlPreserve,
            postProcess: result.htmlPreserve && Object.keys(result.htmlPreserve).length > 0
        };
    },
    executeTargetSkipped: cleanupNotebook,
    dependencies: (options)=>{
        const includes = {};
        if (options.dependencies) {
            const includeFiles = includesForJupyterWidgetDependencies(options.dependencies, options.tempDir);
            if (includeFiles.inHeader) {
                includes[kIncludeInHeader] = [
                    includeFiles.inHeader
                ];
            }
            if (includeFiles.afterBody) {
                includes[kIncludeAfterBody] = [
                    includeFiles.afterBody
                ];
            }
        }
        return Promise.resolve({
            includes
        });
    },
    postprocess: (options)=>{
        postProcessRestorePreservedHtml(options);
        return Promise.resolve();
    },
    canFreeze: true,
    generatesFigures: true,
    ignoreDirs: ()=>{
        return [
            "venv",
            "env"
        ];
    },
    canKeepSource: (target)=>{
        return !isJupyterNotebook(target.source);
    },
    keepFiles: (input)=>{
        if (!isJupyterNotebook(input) && !input.endsWith(`.${kJupyterEngine}.md`)) {
            const [fileDir, fileStem] = dirAndStem(input);
            return [
                join3(fileDir, fileStem + ".ipynb")
            ];
        }
    }
};
function isQmdFile(file) {
    const ext = extname2(file);
    return kQmdExtensions.includes(ext);
}
async function createNotebookforTarget(target) {
    const nb = await quartoMdToJupyter(target.source, true);
    Deno.writeTextFileSync(target.input, JSON.stringify(nb, null, 2));
}
function cleanupNotebook(target, format35) {
    const data90 = target.data;
    if (data90.transient) {
        if (!format35.execute[kKeepIpynb]) {
            removeIfExists(target.input);
        }
    }
}
function executeResultIncludes(tempDir3, widgetDependencies) {
    if (widgetDependencies) {
        const includes = {};
        const includeFiles = includesForJupyterWidgetDependencies([
            widgetDependencies
        ], tempDir3);
        if (includeFiles.inHeader) {
            includes[kIncludeInHeader] = [
                includeFiles.inHeader
            ];
        }
        if (includeFiles.afterBody) {
            includes[kIncludeAfterBody] = [
                includeFiles.afterBody
            ];
        }
        return includes;
    } else {
        return undefined;
    }
}
function executeResultEngineDependencies(widgetDependencies) {
    if (widgetDependencies) {
        return [
            widgetDependencies
        ];
    } else {
        return undefined;
    }
}
async function markdownFromNotebook(file) {
    const decoder = new TextDecoder("utf-8");
    const nbContents = await Deno.readFile(file);
    const nb = JSON.parse(decoder.decode(nbContents));
    const cells = nb.cells;
    const markdown = cells.reduce((md, cell)=>{
        if ([
            "markdown",
            "raw"
        ].includes(cell.cell_type)) {
            return md + "\n" + cell.source.join("") + "\n";
        } else {
            return md;
        }
    }, "");
    return markdown;
}
const kMdExtensions = [
    ".md",
    ".markdown"
];
const markdownEngine = {
    name: kMarkdownEngine,
    defaultExt: ".qmd",
    defaultYaml: ()=>[]
    ,
    defaultContent: ()=>[]
    ,
    validExtensions: ()=>kQmdExtensions.concat(kMdExtensions)
    ,
    claimsExtension: (ext)=>{
        return kMdExtensions.includes(ext.toLowerCase());
    },
    claimsLanguage: (_language)=>{
        return false;
    },
    target: (file)=>{
        const markdown = Deno.readTextFileSync(file);
        return Promise.resolve({
            source: file,
            input: file,
            markdown,
            metadata: readYamlFromMarkdown(markdown)
        });
    },
    partitionedMarkdown: (file)=>{
        return Promise.resolve(partitionMarkdown(Deno.readTextFileSync(file)));
    },
    execute: (options)=>{
        const markdown = Deno.readTextFileSync(options.target.input);
        return Promise.resolve({
            markdown,
            supporting: [],
            filters: []
        });
    },
    dependencies: (_options)=>{
        return Promise.resolve({
            includes: {}
        });
    },
    postprocess: (_options)=>Promise.resolve()
    ,
    canFreeze: false,
    generatesFigures: false
};
const kEngines = [
    knitrEngine,
    jupyterEngine,
    markdownEngine, 
];
function executionEngines() {
    return kEngines.map((engine)=>engine.name
    );
}
function executionEngine(name112) {
    for (const engine of kEngines){
        if (engine.name === name112) {
            return engine;
        }
    }
}
function executionEngineKeepMd(input) {
    const keepSuffix = `.md`;
    if (!input.endsWith(keepSuffix)) {
        const [dir, stem] = dirAndStem(input);
        return join3(dir, stem + keepSuffix);
    }
}
function executionEngineCanKeepSource(engine, target) {
    return !engine.canKeepSource || engine.canKeepSource(target);
}
function executionEngineKeepFiles(engine, input) {
    const files = [];
    const keep = executionEngineKeepMd(input);
    if (keep) {
        files.push(keep);
    }
    const engineKeepFiles = engine.keepFiles ? engine.keepFiles(input) : undefined;
    if (engineKeepFiles) {
        return files.concat(engineKeepFiles);
    } else {
        return files;
    }
}
function engineValidExtensions() {
    return __VIRTUAL_FILE181(kEngines.flatMap((engine)=>engine.validExtensions()
    ));
}
function fileExecutionEngine(file) {
    const ext = extname2(file).toLowerCase();
    if (!kEngines.some((engine)=>engine.validExtensions().includes(ext)
    )) {
        return undefined;
    }
    for (const engine1 of kEngines){
        if (engine1.claimsExtension(ext)) {
            return engine1;
        }
    }
    const markdown = Deno.readTextFileSync(file);
    const result = partitionYamlFrontMatter(markdown);
    if (result) {
        const yaml = readYamlFromMarkdown(result.yaml);
        if (yaml) {
            for (const engine of kEngines){
                if (yaml[engine.name]) {
                    return engine;
                }
                const format36 = metadataAsFormat(yaml);
                if (format36.execute?.[kEngine] === engine.name) {
                    return engine;
                }
            }
        }
    }
    const languages = languagesInMarkdown(markdown);
    if (languages.size > 0) {
        for (const language of languages){
            for (const engine of kEngines){
                if (engine.claimsLanguage(language)) {
                    return engine;
                }
            }
        }
        if (languages.size === 0 || languages.size == 1 && languages.has("ojs")) {
            return engineForMarkdownWithNoLanguages(markdown);
        } else {
            return jupyterEngine;
        }
    } else {
        return engineForMarkdownWithNoLanguages(markdown);
    }
}
function engineForMarkdownWithNoLanguages(markdown) {
    if (markdown.match(/`r[ #]([^`]+)\s*`/)) {
        return knitrEngine;
    } else {
        return markdownEngine;
    }
}
function engineIgnoreDirs() {
    const ignoreDirs = [];
    executionEngines().forEach((name113)=>{
        const engine = executionEngine(name113);
        if (engine && engine.ignoreDirs) {
            const ignores = engine.ignoreDirs();
            if (ignores) {
                ignoreDirs.push(...ignores);
            }
        }
    });
    return ignoreDirs;
}
function engineIgnoreGlobs() {
    return engineIgnoreDirs().map((ignore1)=>`**/${ignore1}/**`
    );
}
const kTocFloat = "toc-float";
function hasTableOfContents(flags, format37) {
    return !!((flags[kToc] || format37.pandoc[kToc] || format37.pandoc[kTableOfContents]) && format37.metadata[kTocFloat] !== false);
}
function disabledTableOfContents(format38) {
    return format38.pandoc[kToc] === false || format38.pandoc[kTableOfContents] === false;
}
function layerQuartoScss(key, dependency, sassLayer1, format39, darkLayer, darkDefault) {
    const frameworkFunctions = [
        bootstrapFunctions(),
        sassUtilFunctions("color-contrast.scss"), 
    ].join("\n");
    const frameworkVariables = [
        bootstrapVariables(),
        pandocVariablesToThemeScss(format39.metadata), 
    ].join("\n");
    return {
        dependency,
        key,
        user: sassLayer1,
        quarto: {
            use: [
                "sass:color",
                "sass:map",
                "sass:math"
            ],
            defaults: [
                quartoDefaults(format39),
                quartoBootstrapDefaults(format39.metadata), 
            ].join("\n"),
            functions: [
                quartoFunctions(),
                quartoBootstrapFunctions()
            ].join("\n"),
            mixins: quartoBootstrapMixins(),
            rules: [
                quartoRules(),
                quartoCopyCodeRules(),
                quartoBootstrapRules(),
                quartoGlobalCssVariableRules(),
                quartoLinkExternalRules(), 
            ].join("\n")
        },
        framework: {
            defaults: frameworkVariables,
            functions: frameworkFunctions,
            mixins: bootstrapMixins(),
            rules: bootstrapRules()
        },
        loadPaths: [
            bootstrapResourceDir()
        ],
        dark: darkLayer ? {
            user: darkLayer,
            default: darkDefault
        } : undefined
    };
}
function resolveBootstrapScss(input, format40) {
    const quartoThemesDir = formatResourcePath("html", join3("bootstrap", "themes"));
    const theme = format40.metadata[kTheme] || [];
    const [themeSassLayers, defaultDark] = resolveThemeLayer(input, theme, quartoThemesDir);
    const sassBundles = [];
    sassBundles.push(layerQuartoScss("quarto-theme", kBootstrapDependencyName, themeSassLayers.light, format40, themeSassLayers.dark, defaultDark));
    return sassBundles;
}
function layerTheme(input, themes1, quartoThemesDir) {
    let injectedCustomization = false;
    const layers = themes1.flatMap((theme)=>{
        const resolvedThemePath = join3(quartoThemesDir, `${theme}.scss`);
        if (existsSync(resolvedThemePath)) {
            const themeLayer1 = sassLayer(resolvedThemePath);
            injectedCustomization = true;
            return [
                themeLayer1,
                quartoBootstrapCustomizationLayer()
            ];
        } else {
            const themePath = join3(dirname2(input), theme);
            if (existsSync(themePath)) {
                return sassLayer(themePath);
            } else {
                return {
                    defaults: "",
                    functions: "",
                    mixins: "",
                    rules: ""
                };
            }
        }
    });
    if (!injectedCustomization) {
        layers.unshift(quartoBootstrapCustomizationLayer());
    }
    return layers;
}
function resolveThemeLayer(input, themes1, quartoThemesDir) {
    let theme1 = undefined;
    let defaultDark = false;
    if (typeof themes1 === "string") {
        theme1 = {
            light: [
                themes1
            ]
        };
    } else if (Array.isArray(themes1)) {
        theme1 = {
            light: themes1
        };
    } else if (typeof themes1 === "object") {
        const themeArr = (theme)=>{
            const themes2 = [];
            if (theme) {
                if (typeof theme === "string") {
                    themes2.push(theme);
                } else if (Array.isArray(theme)) {
                    themes2.push(...theme);
                }
            }
            return themes2;
        };
        const themeObj = themes1;
        const keyList = Object.keys(themeObj);
        defaultDark = keyList.length > 1 && keyList[0] === "dark";
        theme1 = {
            light: themeArr(themeObj.light),
            dark: themeObj.dark ? themeArr(themeObj.dark) : undefined
        };
    } else {
        theme1 = {
            light: []
        };
    }
    const themeSassLayer = {
        light: mergeLayers(...layerTheme(input, theme1.light, quartoThemesDir)),
        dark: theme1.dark ? mergeLayers(...layerTheme(input, theme1.dark, quartoThemesDir)) : undefined
    };
    return [
        themeSassLayer,
        defaultDark
    ];
}
function pandocVariablesToThemeDefaults(metadata11) {
    const explicitVars = [];
    const add = (defaults3, name114, value, formatter)=>{
        if (value) {
            const sassVar = sassVariable(name114, value, formatter);
            defaults3.push(sassVar);
        }
    };
    add(explicitVars, "line-height-base", metadata11["linestretch"], asCssNumber);
    add(explicitVars, "font-size-root", metadata11["fontsize"]);
    add(explicitVars, "body-bg", metadata11["backgroundcolor"]);
    add(explicitVars, "body-color", metadata11["fontcolor"]);
    add(explicitVars, "link-color", metadata11["linkcolor"]);
    add(explicitVars, "font-family-base", metadata11["mainfont"], asCssFont);
    add(explicitVars, "font-family-code", metadata11["monofont"], asCssFont);
    add(explicitVars, "mono-background-color", metadata11["monobackgroundcolor"]);
    const explicitSizes = [
        "max-width",
        "margin-top",
        "margin-bottom",
        "margin-left",
        "margin-right", 
    ];
    explicitSizes.forEach((attrib)=>{
        add(explicitVars, attrib, metadata11[attrib], asCssSize);
    });
    return explicitVars;
}
function pandocVariablesToThemeScss(metadata12, asDefaults = false) {
    return pandocVariablesToThemeDefaults(metadata12).map((variable)=>{
        return outputVariable(variable, asDefaults);
    }).join("\n");
}
const kCodeBorderLeft = "code-block-border-left";
const kCodeBlockBackground = "code-block-bg";
const kBackground = "background";
const kForeground = "foreground";
const kColor = "color";
const kBorder = "border";
const quartoBootstrapDefaults = (metadata13)=>{
    const varFilePath = formatResourcePath("html", join3("bootstrap", "_bootstrap-variables.scss"));
    const variables = [
        Deno.readTextFileSync(varFilePath)
    ];
    const navbar = metadata13[kWebsite]?.[kSiteNavbar];
    if (navbar && typeof navbar === "object") {
        const navbarBackground = navbar[kBackground];
        if (navbarBackground !== undefined) {
            variables.push(outputVariable(sassVariable("navbar-bg", navbarBackground, typeof navbarBackground === "string" ? asBootstrapColor : undefined)));
        }
        const navbarForeground = navbar[kForeground];
        if (navbarForeground !== undefined) {
            variables.push(outputVariable(sassVariable("navbar-fg", navbarForeground, typeof navbarForeground === "string" ? asBootstrapColor : undefined)));
        }
    }
    const sidebars = metadata13[kWebsite]?.[kSiteSidebar];
    const sidebar = Array.isArray(sidebars) ? sidebars[0] : typeof sidebars === "object" ? sidebars : undefined;
    if (sidebar) {
        const sidebarBackground = sidebar[kBackground];
        if (sidebarBackground !== undefined) {
            variables.push(outputVariable(sassVariable("sidebar-bg", sidebarBackground, typeof sidebarBackground === "string" ? asBootstrapColor : undefined)));
        } else if (sidebar.style === "floating" || navbar) {
            variables.push(`$sidebar-bg: if(variable-exists(body-bg), $body-bg, #fff) !default;`);
        }
        const sidebarForeground = sidebar[kForeground];
        if (sidebarForeground !== undefined) {
            variables.push(outputVariable(sassVariable("sidebar-fg", sidebarForeground, typeof sidebarForeground === "string" ? asBootstrapColor : undefined)));
        }
    }
    const footer = metadata13[kWebsite]?.[kPageFooter];
    if (footer !== undefined && typeof footer === "object") {
        const footerBg = footer[kBackground];
        if (footerBg !== undefined) {
            variables.push(outputVariable(sassVariable("footer-bg", footerBg, typeof footerBg === "string" ? asBootstrapColor : undefined)));
        }
        const footerFg = footer[kForeground];
        if (footerFg !== undefined) {
            variables.push(outputVariable(sassVariable("footer-fg", footerFg, typeof footerFg === "string" ? asBootstrapColor : undefined)));
        }
        const footerBorder = footer[kBorder];
        if (footerBorder !== false) {
            variables.push(outputVariable(sassVariable("footer-border", true)));
        }
        if (footerBorder !== undefined && typeof footerBorder === "string") {
            variables.push(outputVariable(sassVariable("footer-border-color", footerBorder, asBootstrapColor)));
        }
        const footerColor = footer[kColor];
        if (footerColor && typeof footerColor === "string") {
            variables.push(outputVariable(sassVariable("footer-color", footerColor, asBootstrapColor)));
        }
    }
    const codeblockLeftBorder = metadata13[kCodeBorderLeft];
    const codeblockBackground = metadata13[kCodeBlockBackground];
    if (codeblockLeftBorder !== undefined) {
        variables.push(outputVariable(sassVariable(kCodeBorderLeft, codeblockLeftBorder, typeof codeblockLeftBorder === "string" ? asBootstrapColor : undefined)));
        if (codeblockBackground === undefined && codeblockLeftBorder !== false) {
            variables.push(outputVariable(sassVariable(kCodeBlockBackground, false)));
        }
    }
    if (codeblockBackground !== undefined) {
        variables.push(outputVariable(sassVariable(kCodeBlockBackground, codeblockBackground, typeof codeblockBackground === "string" ? asBootstrapColor : undefined)));
    }
    return variables.reverse().join("\n");
};
function formatHasBootstrap(format41) {
    if (format41 && isHtmlOutput(format41.pandoc, true)) {
        return hasBootstrapTheme(format41.metadata);
    } else {
        return false;
    }
}
function hasBootstrapTheme(metadata14) {
    const theme = metadata14[kTheme];
    return theme !== "none" && theme !== "pandoc";
}
function formatDarkMode(format42) {
    const isBootstrap = formatHasBootstrap(format42);
    if (isBootstrap) {
        return darkModeDefault(format42.metadata);
    }
    return undefined;
}
function darkModeDefault(metadata15) {
    if (metadata15 !== undefined) {
        const theme = metadata15[kTheme];
        if (theme && typeof theme === "object") {
            const keys7 = Object.keys(theme);
            if (keys7.includes("dark")) {
                if (keys7[0] === "dark") {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }
    return undefined;
}
function formatPageLayout(format43) {
    return format43.metadata[kPageLayout] || kPageLayoutArticle;
}
function formatHasArticlePageLayout(format44) {
    return format44.metadata[kPageLayout] === undefined || format44.metadata[kPageLayout] === kPageLayoutArticle;
}
function formatHasCustomPageLayout(format45) {
    return format45.metadata[kPageLayout] == kPageLayoutCustom;
}
function bootstrapFormatDependency() {
    const boostrapResource = (resource)=>formatResourcePath("html", join3("bootstrap", "dist", resource))
    ;
    const bootstrapDependency = (resource)=>({
            name: resource,
            path: boostrapResource(resource)
        })
    ;
    return {
        name: kBootstrapDependencyName,
        stylesheets: [
            bootstrapDependency("bootstrap-icons.css"), 
        ],
        scripts: [
            bootstrapDependency("bootstrap.min.js"), 
        ],
        resources: [
            bootstrapDependency("bootstrap-icons.woff"), 
        ]
    };
}
function boostrapExtras(input, flags, format46) {
    const toc = hasTableOfContents(flags, format46);
    const renderTemplate = (template3, pageLayout)=>{
        return renderEjs(formatResourcePath("html", `templates/${template3}`), {
            toc,
            pageLayout
        });
    };
    const bodyEnvelope = formatHasArticlePageLayout(format46) ? {
        before: renderTemplate("before-body-article.ejs", kPageLayoutArticle),
        afterPreamble: renderTemplate("after-body-article-preamble.ejs", kPageLayoutArticle),
        afterPostamble: renderTemplate("after-body-article-postamble.ejs", kPageLayoutArticle)
    } : formatHasCustomPageLayout(format46) ? {
        before: renderTemplate("before-body-custom.ejs", kPageLayoutCustom),
        afterPreamble: renderTemplate("after-body-custom-preamble.ejs", kPageLayoutCustom),
        afterPostamble: renderTemplate("after-body-custom-postamble.ejs", kPageLayoutCustom)
    } : undefined;
    return {
        pandoc: {
            [kSectionDivs]: true,
            [kHtmlMathMethod]: "mathjax"
        },
        metadata: {
            [kDocumentCss]: false,
            [kLinkCitations]: true
        },
        html: {
            [kSassBundles]: resolveBootstrapScss(input, format46),
            [kDependencies]: [
                bootstrapFormatDependency()
            ],
            [kBodyEnvelope]: bodyEnvelope,
            [kHtmlPostprocessors]: [
                bootstrapHtmlPostprocessor(flags, format46), 
            ]
        }
    };
}
function bootstrapHtmlPostprocessor(flags, format47) {
    return (doc)=>{
        const title6 = doc.querySelector("header > .title");
        if (title6) {
            title6.classList.add("display-7");
        }
        processMarginCaptions(doc);
        const marginProcessors = [
            simpleMarginProcessor, 
        ];
        const refsInMargin = format47.pandoc[kReferenceLocation] === "margin" || flags[kReferenceLocation] === "margin";
        if (refsInMargin) {
            marginProcessors.push(footnoteMarginProcessor);
        }
        const citesInMargin = format47.metadata[kCitationLocation] === "margin";
        if (citesInMargin) {
            marginProcessors.push(referenceMarginProcessor);
        }
        processMarginNodes(doc, marginProcessors);
        const columnLayouts = doc.querySelectorAll('[class^="column-"], [class*=" column-"], aside, [class*="margin-caption"], [class*=" margin-caption"], [class*="margin-ref"], [class*=" margin-ref"]');
        if (columnLayouts && columnLayouts.length > 0) {
            const ensureInGrid = (el, setLayout)=>{
                if (!el.classList.contains("page-columns")) {
                    el.classList.add("page-columns");
                }
                if (setLayout && !el.classList.contains("page-full")) {
                    el.classList.add("page-full");
                }
                if (el.tagName !== "MAIN") {
                    const parent = el.parentElement;
                    if (parent) {
                        ensureInGrid(parent, true);
                    }
                }
            };
            columnLayouts.forEach((node)=>{
                const el = node;
                if (el.parentElement) {
                    ensureInGrid(el.parentElement, true);
                }
            });
        }
        const subtitle = doc.querySelector("header > .subtitle");
        if (subtitle) {
            subtitle.classList.add("lead");
        }
        const blockquotes = doc.querySelectorAll("blockquote");
        for(let i94 = 0; i94 < blockquotes.length; i94++){
            const classList = blockquotes[i94].classList;
            classList.add("blockquote");
        }
        const figures = doc.querySelectorAll("figure");
        for(let i1 = 0; i1 < figures.length; i1++){
            const figure = figures[i1];
            figure.classList.add("figure");
            const images = figure.querySelectorAll("img");
            for(let j = 0; j < images.length; j++){
                images[j].classList.add("figure-img");
            }
            const captions = figure.querySelectorAll("figcaption");
            for(let j1 = 0; j1 < captions.length; j1++){
                captions[j1].classList.add("figure-caption");
            }
        }
        const toc = doc.querySelector('nav[role="doc-toc"]');
        const tocTarget = doc.getElementById("quarto-toc-target");
        if (toc && tocTarget) {
            const tocLinks = doc.querySelectorAll('nav[role="doc-toc"] > ul a');
            for(let i95 = 0; i95 < tocLinks.length; i95++){
                const tocLink = tocLinks[i95];
                tocLink.classList.add("nav-link");
                if (i95 === 0) {
                    tocLink.classList.add("active");
                }
                if (!tocLink.hasAttribute("data-scroll-target")) {
                    tocLink.setAttribute("data-scroll-target", tocLink.getAttribute("href")?.replaceAll(":", "\\:"));
                }
            }
            const nestedUls = toc.querySelectorAll("ul ul");
            for(let i5 = 0; i5 < nestedUls.length; i5++){
                const ul = nestedUls[i5];
                ul.classList.add("collapse");
            }
            toc.remove();
            tocTarget.replaceWith(toc);
        }
        const tableHeaders = doc.querySelectorAll("tbody > tr:first-child.odd");
        for(let i2 = 0; i2 < tableHeaders.length; i2++){
            const th = tableHeaders[i2];
            if (th.parentNode?.parentNode) {
                const table = th.parentNode.parentNode;
                table.removeAttribute("style");
                table.classList.add("table");
            }
        }
        const pandasTables = doc.querySelectorAll("table.dataframe");
        for(let i3 = 0; i3 < pandasTables.length; i3++){
            const table = pandasTables[i3];
            table.removeAttribute("border");
            table.classList.add("table");
            const headerRows = table.querySelectorAll("tr");
            for(let r = 0; r < headerRows.length; r++){
                headerRows[r].removeAttribute("style");
            }
            if (table.previousElementSibling && table.previousElementSibling.tagName === "STYLE") {
                table.previousElementSibling.remove();
            }
        }
        const sections = doc.querySelectorAll('section[class^="level"]');
        for(let i4 = 0; i4 < sections.length; i4++){
            const section = sections[i4];
            const heading = section.querySelector("h2") || section.querySelector("h3") || section.querySelector("h4") || section.querySelector("h5") || section.querySelector("h6");
            if (heading) {
                heading.setAttribute("data-anchor-id", section.id);
            }
        }
        const footnotes = doc.querySelectorAll('section[role="doc-endnotes"]');
        if (refsInMargin) {
            const footNoteSectionEl = doc.querySelector("section.footnotes");
            if (footNoteSectionEl) {
                footNoteSectionEl.remove();
            }
        } else if (footnotes.length === 1) {
            const footnotesEl = footnotes.item(0);
            insertFootnotesTitle(doc, footnotesEl, format47.language);
        }
        if (citesInMargin) {
            const bibliographyDiv = doc.querySelector("div#refs");
            if (bibliographyDiv) {
                bibliographyDiv.remove();
            }
        }
        if (columnLayouts.length > 0) {
            doc.body.classList.add("slimcontent");
        } else if (doc.getElementById("quarto-margin-sidebar")) {} else {
            doc.body.classList.add("fullcontent");
        }
        return Promise.resolve([]);
    };
}
const processMarginNodes = (doc, processors)=>{
    const marginSelector = processors.map((proc)=>proc.selector
    ).join(", ");
    const marginNodes = doc.querySelectorAll(marginSelector);
    marginNodes.forEach((marginNode)=>{
        const marginEl = marginNode;
        for (const processor of processors){
            if (processor.canProcess(marginEl)) {
                processor.process(marginEl, doc);
                break;
            }
        }
        marginEl.classList.remove("column-margin");
    });
};
const findQuartoFigure = (el)=>{
    if (el.classList.contains("quarto-figure")) {
        return el;
    } else if (el.parentElement) {
        return findQuartoFigure(el.parentElement);
    } else {
        return undefined;
    }
};
const moveClassToCaption = (container, sel)=>{
    const target = container.querySelector(sel);
    if (target) {
        target.classList.add("margin-caption");
        return true;
    } else {
        return false;
    }
};
const removeCaptionClass = (el)=>{
    el.classList.remove("margin-caption");
};
const processLayoutPanelMarginCaption = (captionContainer)=>{
    const figure = captionContainer.querySelector("figure");
    if (figure) {
        for (const child of figure.children){
            if (child.tagName === "FIGCAPTION") {
                child.classList.add("margin-caption");
                removeCaptionClass(captionContainer);
                break;
            }
        }
    } else {
        const caption = captionContainer.querySelector(".panel-caption");
        if (caption) {
            caption.classList.add("margin-caption");
            removeCaptionClass(captionContainer);
        }
    }
};
const processFigureMarginCaption = (captionContainer, doc)=>{
    const foundCaption = moveClassToCaption(captionContainer, "figcaption");
    if (!foundCaption) {
        const captionEl = captionContainer.querySelector("caption");
        if (captionEl) {
            const parentDivEl = captionEl?.parentElement?.parentElement;
            if (parentDivEl) {
                captionEl.classList.add("hidden");
                const divCopy = doc.createElement("div");
                divCopy.classList.add("figure-caption");
                divCopy.classList.add("margin-caption");
                divCopy.innerHTML = captionEl.innerHTML;
                parentDivEl.appendChild(divCopy);
                removeCaptionClass(captionContainer);
            }
        }
    } else {
        removeCaptionClass(captionContainer);
    }
};
const processMarginCaptions = (doc)=>{
    const marginCaptions = doc.querySelectorAll(".margin-caption");
    marginCaptions.forEach((node)=>{
        const figureEl = node;
        const captionContainer = findQuartoFigure(figureEl);
        if (captionContainer) {
            const isLayoutPanel = captionContainer.classList.contains("quarto-layout-panel");
            if (isLayoutPanel) {
                processLayoutPanelMarginCaption(captionContainer);
            } else {
                processFigureMarginCaption(captionContainer, doc);
            }
        }
        removeCaptionClass(figureEl);
    });
};
const simpleMarginProcessor = {
    selector: ".column-margin:not(.column-container)",
    canProcess (el) {
        return el.classList.contains("column-margin") && !el.classList.contains("column-container");
    },
    process (el, doc) {
        el.classList.remove("column-margin");
        addContentToMarginContainerForEl(el, el, doc);
    }
};
const footnoteMarginProcessor = {
    selector: ".footnote-ref",
    canProcess (el) {
        return el.classList.contains("footnote-ref");
    },
    process (el, doc) {
        if (el.hasAttribute("href")) {
            const target = el.getAttribute("href");
            if (target) {
                const refId = target.slice(1);
                const refContentsEl = doc.getElementById(refId);
                if (refContentsEl) {
                    const backLinkEl = refContentsEl.querySelector(".footnote-back");
                    if (backLinkEl) {
                        backLinkEl.remove();
                    }
                    if (refContentsEl.childNodes.length > 0) {
                        const firstChild = refContentsEl.childNodes[0];
                        firstChild.insertBefore(doc.createTextNode("\u00A0"), firstChild.firstChild);
                        firstChild.insertBefore(el.firstChild.cloneNode(true), firstChild.firstChild);
                    }
                    addContentToMarginContainerForEl(el, refContentsEl, doc);
                }
            }
        }
    }
};
const referenceMarginProcessor = {
    selector: "a[role='doc-biblioref']",
    canProcess (el) {
        return el.hasAttribute("role") && el.getAttribute("role") === "doc-biblioref";
    },
    process (el1, doc) {
        if (el1.hasAttribute("href")) {
            const target = el1.getAttribute("href");
            if (target) {
                const refId = target.slice(1);
                const refContentsEl = doc.getElementById(refId);
                const findCaptionEl = (el)=>{
                    if (el.parentElement?.tagName === "FIGCAPTION") {
                        return el.parentElement;
                    } else if (el.parentElement) {
                        return findCaptionEl(el.parentElement);
                    } else {
                        return undefined;
                    }
                };
                const parentCaptionEl = findCaptionEl(el1);
                console.log(parentCaptionEl?.tagName);
                if (refContentsEl && parentCaptionEl) {
                    addContentToMarginContainerForEl(parentCaptionEl, refContentsEl.cloneNode(true), doc);
                }
            }
        }
    }
};
const isContainer = (el)=>{
    return el && el.tagName === "DIV" && el.classList.contains("column-container") && el.classList.contains("column-margin");
};
const isAlreadyInMargin = (el)=>{
    const elInMargin = el.classList.contains("column-margin") || el.classList.contains("aside") || el.classList.contains("margin-caption");
    if (elInMargin) {
        return true;
    } else if (el.parentElement !== null) {
        return isAlreadyInMargin(el.parentElement);
    } else {
        return false;
    }
};
const createMarginContainer = (doc)=>{
    const container = doc.createElement("div");
    container.classList.add("no-row-height");
    container.classList.add("column-margin");
    container.classList.add("column-container");
    return container;
};
const marginContainerForEl = (el, doc)=>{
    if (el.parentElement && isAlreadyInMargin(el.parentElement)) {
        return el.parentElement;
    }
    if (el.nextElementSibling && isContainer(el.nextElementSibling)) {
        return el.nextElementSibling;
    }
    if (el.previousElementSibling && isContainer(el.previousElementSibling)) {
        return el.previousElementSibling;
    }
    const list = findOutermostParentElOfType(el, [
        "OL",
        "UL",
        "TABLE"
    ]);
    if (list) {
        if (list.nextElementSibling && isContainer(list.nextElementSibling)) {
            return list.nextElementSibling;
        } else {
            const container = createMarginContainer(doc);
            if (list.parentNode) {
                list.parentNode.insertBefore(container, list.nextElementSibling);
            }
            return container;
        }
    }
    const parentEl = el.parentElement;
    const cantContainBlockTags = [
        "P"
    ];
    if (parentEl && cantContainBlockTags.includes(parentEl.tagName)) {
        if (parentEl.parentElement && parentEl.parentElement.tagName === "DIV" && parentEl.nextElementSibling && isContainer(parentEl.nextElementSibling)) {
            return parentEl.nextElementSibling;
        } else {
            const container = createMarginContainer(doc);
            const wrapper = doc.createElement("div");
            parentEl.replaceWith(wrapper);
            wrapper.appendChild(parentEl);
            wrapper.appendChild(container);
            return container;
        }
    }
    const container = createMarginContainer(doc);
    el.parentNode?.insertBefore(container, el.nextElementSibling);
    return container;
};
const addContentToMarginContainerForEl = (el, content, doc)=>{
    const container = marginContainerForEl(el, doc);
    if (container) {
        container.appendChild(content);
    }
};
const findOutermostParentElOfType = (el, tagNames)=>{
    let outEl = undefined;
    if (el.parentElement) {
        if (el.parentElement.tagName === "MAIN") {
            return outEl;
        } else {
            if (tagNames.includes(el.parentElement.tagName)) {
                outEl = el.parentElement;
            }
            outEl = findOutermostParentElOfType(el.parentElement, tagNames) || outEl;
            return outEl;
        }
    } else {
        return undefined;
    }
};
const kHideAllCodeLinkId = "quarto-hide-all-code";
const kShowAllCodeLinkId = "quarto-show-all-code";
const kViewSourceLinkId = "quarto-view-source";
const kEmbeddedSourceClass = "quarto-embedded-source-code";
const kEmbeddedSourceModalId = kEmbeddedSourceClass + "-modal";
const kEmbeddedSourceModalLabelId = kEmbeddedSourceClass + "-modal-label";
const kKeepSourceSentinel = "quarto-executable-code-5450563D";
const kCodeToolsSourceButtonId = "quarto-code-tools-source";
const kCodeToolsMenuButtonId = "quarto-code-tools-menu";
const kDataQuartoSourceUrl = "data-quarto-source-url";
function formatHasCodeTools(format48) {
    const codeTools = format48.render?.[kCodeTools];
    return !!codeTools && isHtmlOutput(format48.pandoc, true) && formatHasBootstrap(format48);
}
function resolveKeepSource(format49, engine, target) {
    const codeTools = format49.render?.[kCodeTools];
    if (codeTools === true || typeof codeTools === "object" && (codeTools?.source === undefined || codeTools?.source === true)) {
        format49.render[kKeepSource] = true;
    }
    format49.render[kKeepSource] = format49.render[kKeepSource] && isHtmlOutput(format49.pandoc, true) && formatHasBootstrap(format49) && executionEngineCanKeepSource(engine, target);
}
function keepSourceBlock(format50, source) {
    if (format50.render[kKeepSource]) {
        let code20 = Deno.readTextFileSync(source).trimLeft();
        if (!code20.endsWith("\n")) {
            code20 = code20 + "\n";
        }
        code20 = code20.replaceAll(/\n```{(\w+)}\s*\n/g, "\n" + kKeepSourceSentinel + "\n\n```$1\n");
        const kKeepSourceBackticks = "```````````````````";
        return `${kMarkdownBlockSeparator}::: {.${kEmbeddedSourceClass}}\n${kKeepSourceBackticks}` + `{.markdown shortcodes="false"}\n${code20}` + `${kKeepSourceBackticks}\n:::\n`;
    } else {
        return "";
    }
}
function codeToolsPostprocessor(format51) {
    return (doc)=>{
        if (format51.render[kKeepSource]) {
            const lines11 = doc.querySelectorAll(`.${kEmbeddedSourceClass} > div.sourceCode > pre > code > span`);
            if (lines11.length > 0) {
                const newLines = [];
                for(let i96 = 0; i96 < lines11.length; i96++){
                    const line = lines11[i96];
                    if (line.innerText === kKeepSourceSentinel) {
                        i96 += 2;
                        const codeBlockLine = lines11[i96];
                        const codeSpan = codeBlockLine.lastChild;
                        if (codeSpan.innerHTML) {
                            codeSpan.innerHTML = codeSpan.innerHTML.replace(/```(\w+)/, "```{$1}");
                        }
                        newLines.push(codeBlockLine);
                    } else {
                        newLines.push(line);
                    }
                }
                if (newLines.length !== lines11.length) {
                    const parent = lines11[0].parentElement;
                    parent.innerHTML = "";
                    newLines.forEach((line)=>{
                        parent.appendChild(line);
                        parent.appendChild(doc.createTextNode("\n"));
                    });
                }
            }
        }
        if (formatHasCodeTools(format51)) {
            const codeTools = resolveCodeTools(format51, doc);
            if (codeTools.source || codeTools.toggle) {
                const title7 = doc.querySelector("#title-block-header > h1");
                if (title7) {
                    const header = title7.parentElement;
                    const titleDiv = doc.createElement("div");
                    titleDiv.classList.add("quarto-title-block");
                    const layoutDiv = doc.createElement("div");
                    titleDiv.appendChild(layoutDiv);
                    header?.replaceChild(titleDiv, title7);
                    layoutDiv.appendChild(title7);
                    const button = doc.createElement("button");
                    button.setAttribute("type", "button");
                    button.classList.add("btn").add("code-tools-button");
                    const icon = doc.createElement("i");
                    icon.classList.add("bi");
                    button.appendChild(icon);
                    if (codeTools.caption !== "none") {
                        button.appendChild(doc.createTextNode(" " + codeTools.caption));
                    }
                    layoutDiv.appendChild(button);
                    header.appendChild(titleDiv);
                    if (codeTools.toggle) {
                        button.setAttribute("id", kCodeToolsMenuButtonId);
                        button.classList.add("dropdown-toggle");
                        button.setAttribute("data-bs-toggle", "dropdown");
                        button.setAttribute("aria-expanded", "false");
                        const ul = doc.createElement("ul");
                        ul.classList.add("dropdown-menu").add("dropdown-menu-end");
                        ul.setAttribute("aria-labelelledby", kCodeToolsMenuButtonId);
                        const addListItem = (id3, text)=>{
                            const a = doc.createElement("a");
                            a.setAttribute("id", id3);
                            a.classList.add("dropdown-item");
                            a.setAttribute("href", "javascript:void(0)");
                            a.setAttribute("role", "button");
                            a.appendChild(doc.createTextNode(text));
                            const li = doc.createElement("li");
                            li.appendChild(a);
                            ul.appendChild(li);
                            return li;
                        };
                        const addDivider = ()=>{
                            const hr = doc.createElement("hr");
                            hr.classList.add("dropdown-divider");
                            const li = doc.createElement("li");
                            li.appendChild(hr);
                            ul.appendChild(li);
                        };
                        addListItem(kShowAllCodeLinkId, format51.language[kCodeToolsShowAllCode]);
                        addListItem(kHideAllCodeLinkId, format51.language[kCodeToolsHideAllCode]);
                        if (codeTools.source) {
                            addDivider();
                            const vsLi = addListItem(kViewSourceLinkId, format51.language[kCodeToolsViewSource]);
                            if (typeof codeTools.source === "string") {
                                vsLi.firstChild.setAttribute(kDataQuartoSourceUrl, codeTools.source);
                            }
                        }
                        layoutDiv.appendChild(ul);
                    } else {
                        button.setAttribute("id", kCodeToolsSourceButtonId);
                        if (typeof codeTools.source === "string") {
        