export class Tokenizer {
    rules;
    constructor(rules = []) {
        this.rules = rules;
    }
    addRule(test, fn) {
        this.rules.push({ test, fn });
        return this;
    }
    tokenize(string, receiver = (token) => token) {
        function* generator(rules) {
            let index = 0;
            for (const rule of rules) {
                const result = rule.test(string);
                if (result) {
                    const { value, length } = result;
                    index += length;
                    string = string.slice(length);
                    const token = { ...rule.fn(value), index };
                    yield receiver(token);
                    yield* generator(rules);
                }
            }
        }
        const tokenGenerator = generator(this.rules);
        const tokens = [];
        for (const token of tokenGenerator) {
            tokens.push(token);
        }
        if (string.length) {
            throw new Error(`parser error: string not fully parsed! ${string.slice(0, 25)}`);
        }
        return tokens;
    }
}
//# sourceMappingURL=data:application/json;base64,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