import { bytesToUuid, uuidToBytes } from "./_common.ts";
import { concat } from "../bytes/mod.ts";
import { assert } from "../_util/assert.ts";
const UUID_RE = /^[0-9a-f]{8}-[0-9a-f]{4}-[5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i;
export function validate(id) {
    return UUID_RE.test(id);
}
export async function generate(namespace, data) {
    const space = uuidToBytes(namespace);
    assert(space.length === 16, "namespace must be a valid UUID");
    const toHash = concat(new Uint8Array(space), data);
    const buffer = await crypto.subtle.digest("sha-1", toHash);
    const bytes = new Uint8Array(buffer);
    bytes[6] = (bytes[6] & 0x0f) | 0x50;
    bytes[8] = (bytes[8] & 0x3f) | 0x80;
    return bytesToUuid(bytes);
}
//# sourceMappingURL=data:application/json;base64,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