export function distinctBy(array, selector) {
    const selectedValues = new Set();
    const ret = [];
    for (const element of array) {
        const currentSelectedValue = selector(element);
        if (!selectedValues.has(currentSelectedValue)) {
            selectedValues.add(currentSelectedValue);
            ret.push(element);
        }
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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