import { MuxAsyncIterator } from "../async/mux_async_iterator.ts";
import { deferred } from "../async/deferred.ts";
export function signal(...signals) {
    const mux = new MuxAsyncIterator();
    if (signals.length < 1) {
        throw new Error("No signals are given. You need to specify at least one signal to create a signal stream.");
    }
    const streams = signals.map(createSignalStream);
    streams.forEach((stream) => {
        mux.add(stream);
    });
    const dispose = () => {
        streams.forEach((stream) => {
            stream.dispose();
        });
    };
    return Object.assign(mux, { dispose });
}
function createSignalStream(signal) {
    let streamContinues = deferred();
    const handler = () => {
        streamContinues.resolve(true);
    };
    Deno.addSignalListener(signal, handler);
    const gen = async function* () {
        while (await streamContinues) {
            streamContinues = deferred();
            yield undefined;
        }
    };
    return Object.assign(gen(), {
        dispose() {
            streamContinues.resolve(false);
            Deno.removeSignalListener(signal, handler);
        },
    });
}
//# sourceMappingURL=data:application/json;base64,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