const { PermissionDenied } = Deno.errors;
function getPermissionString(descriptors) {
    return descriptors.length
        ? `  ${descriptors
            .map((pd) => {
            switch (pd.name) {
                case "read":
                case "write":
                    return pd.path
                        ? `--allow-${pd.name}=${pd.path}`
                        : `--allow-${pd.name}`;
                case "net":
                    return pd.host
                        ? `--allow-${pd.name}=${pd.host}`
                        : `--allow-${pd.name}`;
                default:
                    return `--allow-${pd.name}`;
            }
        })
            .join("\n  ")}`
        : "";
}
export async function grant(descriptor, ...descriptors) {
    const result = [];
    descriptors = Array.isArray(descriptor)
        ? descriptor
        : [descriptor, ...descriptors];
    for (const descriptor of descriptors) {
        let state = (await Deno.permissions.query(descriptor)).state;
        if (state === "prompt") {
            state = (await Deno.permissions.request(descriptor)).state;
        }
        if (state === "granted") {
            result.push(descriptor);
        }
    }
    return result.length ? result : undefined;
}
export async function grantOrThrow(descriptor, ...descriptors) {
    const denied = [];
    descriptors = Array.isArray(descriptor)
        ? descriptor
        : [descriptor, ...descriptors];
    for (const descriptor of descriptors) {
        const { state } = await Deno.permissions.request(descriptor);
        if (state !== "granted") {
            denied.push(descriptor);
        }
    }
    if (denied.length) {
        throw new PermissionDenied(`The following permissions have not been granted:\n${getPermissionString(denied)}`);
    }
}
//# sourceMappingURL=data:application/json;base64,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